module("MB-339", package.seeall)

local Module = require("Scripts.DCS-BIOS.lib.modules.Module")

--- @class MB_339: Module
local MB_339 = Module:new("MB-339", 0x8200, { "MB-339A", "MB-339APAN" })

--by WarLord v1.1

-- remove Arg# Pilot 1000 / Copilot 1002

--- Adds a new indicator light control which will enable the LED when the argument value is greater than or equal to 0.3
--- @param identifier string the unique identifier for the control
--- @param arg_number integer the dcs argument number
--- @param category string the category in which the control should appear
--- @param description string additional information about the control
--- @return Control control the control which was added to the module
function MB_339:defineIndicatorLight08(identifier, arg_number, category, description)
	return self:defineGatedIndicatorLight(identifier, arg_number, 0.5, 0.9, category, description)
end

--Breakers
MB_339:defineToggleSwitch("CB_IFF", 1, 3911, 1114, "Circuit Breakers", "C/B IFF")
MB_339:defineToggleSwitch("CB_HYD_PRESS", 1, 3912, 1115, "Circuit Breakers", "C/B Hyd Press")
MB_339:defineToggleSwitch("CB_OIL_PRESS", 1, 3913, 1116, "Circuit Breakers", "C/B Oil Press")
-- MB_339:defineToggleSwitch("CB_HSI", 1, 3914, 1121, "Circuit Breakers", "C/B HSI")
MB_339:reserveIntValue(1)
MB_339:defineToggleSwitch("CB_ADI", 1, 3915, 1122, "Circuit Breakers", "C/B ADI")
-- MB_339:defineToggleSwitch("CB_FD_CMPTR", 1, 3916, 1123, "Circuit Breakers", "C/B F/D Cmptr")
MB_339:reserveIntValue(1)
MB_339:defineToggleSwitch("CB_SIGHT", 1, 3917, 1124, "Circuit Breakers", "C/B Sight")
MB_339:defineToggleSwitch("CB_AHR_GPS", 1, 3918, 1125, "Circuit Breakers", "C/B AHR/GPS")
-- MB_339:defineToggleSwitch("CB_HSI_COMD", 1, 3919, 1126, "Circuit Breakers", "C/B HSI/COMD")
MB_339:reserveIntValue(1)
-- MB_339:defineToggleSwitch("CB_VOR_ILS", 1, 3920, 1127, "Circuit Breakers", "C/B VOR ILS")
MB_339:reserveIntValue(1)
-- MB_339:defineToggleSwitch("CB_UTIL_PW", 1, 3921, 1131, "Circuit Breakers", "C/B Util Pwr")
MB_339:reserveIntValue(1)
-- MB_339:defineToggleSwitch("CB_TACAN", 1, 3922, 1132, "Circuit Breakers", "C/B TACAN")
MB_339:reserveIntValue(1)
MB_339:defineToggleSwitch("CB_FORM_LT", 1, 3923, 1134, "Circuit Breakers", "C/B Form Lt")
MB_339:defineToggleSwitch("CB_AHR_GPS2", 1, 3924, 1135, "Circuit Breakers", "C/B AHR/GPS")
-- MB_339:defineToggleSwitch("CB_ADF", 1, 3925, 1136, "Circuit Breakers", "C/B ADF")
MB_339:reserveIntValue(1)
-- MB_339:defineToggleSwitch("CB_TACAN2", 1, 3926, 1132, "Circuit Breakers", "C/B TACAN")
MB_339:reserveIntValue(1)
MB_339:defineToggleSwitch("CB_STBY_ATT_FWD", 1, 3929, 1213, "Circuit Breakers", "C/B Fwd Stby Att Ind")
MB_339:defineToggleSwitch("CB_STBY_ATT_AFT", 1, 3930, 1214, "Circuit Breakers", "C/B Aft Stby Att Ind")
MB_339:defineToggleSwitch("CB_COMM2", 1, 3931, 1215, "Circuit Breakers", "C/B COMM2")
MB_339:defineToggleSwitch("CB_IFF_2", 1, 3933, 1217, "Circuit Breakers", "C/B IFF 2")
MB_339:defineToggleSwitch("CB_WING_FLAP", 1, 3934, 1221, "Circuit Breakers", "C/B Wing Flap")
MB_339:defineToggleSwitch("CB_SPD_BRAKE", 1, 3935, 1222, "Circuit Breakers", "C/B Spd Brake")
MB_339:defineToggleSwitch("CB_POS_IND", 1, 3936, 1223, "Circuit Breakers", "C/B Pos Ind")
MB_339:defineToggleSwitch("CB_LG", 1, 3937, 1224, "Circuit Breakers", "C/B LG")
MB_339:defineToggleSwitch("CB_LG_DN_MON", 1, 3938, 1225, "Circuit Breakers", "C/B LG Down Mon")
MB_339:defineToggleSwitch("CB_FUEL_QTY", 1, 3939, 1226, "Circuit Breakers", "C/B Fuel Qty")
MB_339:defineToggleSwitch("CB_JPT_IND", 1, 3940, 1227, "Circuit Breakers", "C/B Jpt Ind")
MB_339:defineToggleSwitch("CB_AIR_COND", 1, 3941, 1231, "Circuit Breakers", "C/B Air Cond")
MB_339:defineToggleSwitch("CB_ENG_START", 1, 3942, 1232, "Circuit Breakers", "C/B Eng Start")
MB_339:defineToggleSwitch("CB_DUMP_OFF", 1, 3946, 1236, "Circuit Breakers", "C/B Dump Shut-Off")
MB_339:defineToggleSwitch("CB_OXY_PRESS", 1, 3949, 1242, "Circuit Breakers", "C/B Oxy Press")
MB_339:defineToggleSwitch("CB_ARMT_SEL", 1, 3950, 1243, "Circuit Breakers", "C/B Armt Sel")
MB_339:defineToggleSwitch("CB_FUEL_PUMP", 1, 3951, 1244, "Circuit Breakers", "C/B Fuel Pump")
MB_339:defineToggleSwitch("CB_STORE_JETT", 1, 3952, 1245, "Circuit Breakers", "C/B Store Jett")
MB_339:defineToggleSwitch("CB_INV_MAIN", 1, 3953, 1246, "Circuit Breakers", "C/B Main Inv")
MB_339:defineToggleSwitch("CB_INV_STBY", 1, 3954, 1247, "Circuit Breakers", "C/B Stby Inv")
MB_339:defineToggleSwitch("CB_TRIM_A_E", 1, 3955, 1251, "Circuit Breakers", "C/B Ail & Elev Trim")
MB_339:defineToggleSwitch("CB_AIL_SERVO", 1, 3956, 1252, "Circuit Breakers", "C/B Ail Servo")
MB_339:defineToggleSwitch("CB_CAUTION_L", 1, 3957, 1253, "Circuit Breakers", "C/B Caution Lt")
MB_339:defineToggleSwitch("CB_INV_CONTR_MAIN", 1, 3959, 1255, "Circuit Breakers", "C/B Main Inv Contr")
MB_339:defineToggleSwitch("CB_INV_CONTR_STBY", 1, 3961, 1257, "Circuit Breakers", "C/B Stby Inv Contr")
MB_339:defineToggleSwitch("CB_ANTI_SKID", 1, 3962, 1411, "Circuit Breakers", "C/B Anti-Skid")
MB_339:defineToggleSwitch("CB_AC_PRI_BUS", 1, 3963, 1412, "Circuit Breakers", "C/B AC Pri Bus")
MB_339:defineToggleSwitch("CB_LDG_L_MTR", 1, 3965, 1414, "Circuit Breakers", "C/B Ldg Lt Mtr")
MB_339:defineToggleSwitch("CB_BCN", 1, 3966, 1415, "Circuit Breakers", "C/B Bcn")
MB_339:defineToggleSwitch("CB_NAV_L", 1, 3967, 1416, "Circuit Breakers", "C/B Nav Lt")
MB_339:defineToggleSwitch("CB_AOA", 1, 3973, 1431, "Circuit Breakers", "C/B AOA")
MB_339:defineToggleSwitch("CB_NW_STEER", 1, 3974, 1432, "Circuit Breakers", "C/B NW Steer")
MB_339:defineToggleSwitch("CB_JPT_LIMIT", 1, 3975, 1433, "Circuit Breakers", "C/B JPT Limiter")
MB_339:defineToggleSwitch("CB_FUEL_FLOW_IND", 1, 3977, 1435, "Circuit Breakers", "C/B Fuel Flow ind")
MB_339:defineToggleSwitch("CB_FUEL_TRANS", 1, 3978, 1436, "Circuit Breakers", "C/B Fuel Trans")
MB_339:defineToggleSwitch("CB_TRIM_R", 1, 3979, 1437, "Circuit Breakers", "C/B Rud Trim")
MB_339:defineToggleSwitch("CB_TAXI_L", 1, 3982, 1445, "Circuit Breakers", "C/B Taxi Lt")
MB_339:defineToggleSwitch("CB_LDG_L", 1, 3983, 1446, "Circuit Breakers", "C/B Ldg Lt")
MB_339:defineToggleSwitch("CB_PITOT_FWD", 1, 3984, 1452, "Circuit Breakers", "C/B Fwd Pitot")
MB_339:defineToggleSwitch("CB_PITOT_AFT", 1, 3985, 1453, "Circuit Breakers", "C/B Aft Pitot")
MB_339:defineToggleSwitch("CB_ENG_ANTI_ICE", 1, 3986, 1454, "Circuit Breakers", "C/B Engine Anti-Ice")
MB_339:defineToggleSwitch("CB_WHSLD_DEM", 1, 3987, 1455, "Circuit Breakers", "C/B Whsld Dem")
MB_339:defineToggleSwitch("CB_ICE_DETR", 1, 3988, 1456, "Circuit Breakers", "C/B Ice Detr")
MB_339:defineToggleSwitch("CB_SIGHT2", 1, 3989, 1457, "Circuit Breakers", "C/B Sight")
MB_339:defineToggleSwitch("CB_CDU_FWD", 1, 3990, 1511, "Circuit Breakers", "C/B Fwd Cdu")
MB_339:defineToggleSwitch("CB_CDU_AFT", 1, 3991, 1512, "Circuit Breakers", "C/B Aft Cdu")
MB_339:defineToggleSwitch("CB_AHR_GPS3", 1, 3992, 1513, "Circuit Breakers", "C/B AHR/GPS")
MB_339:defineToggleSwitch("CB_COMM_RDU", 1, 3995, 1522, "Circuit Breakers", "C/B COMM RDU")

--Electrical
MB_339:defineToggleSwitch("BATTERY_SW", 1, 3095, 300, "Electrical", "Battery Switch")
MB_339:defineToggleSwitch("GEN1_SW", 1, 3096, 301, "Electrical", "Generator 1 Switch")
MB_339:defineToggleSwitch("GEN2_SW", 1, 3097, 302, "Electrical", "Generator 2 Switch")
MB_339:defineToggleSwitch("AC_PW_SW", 1, 3098, 303, "Electrical", "AC Power Switch")
MB_339:defineToggleSwitch("BUS_RESET_SW", 1, 3099, 231, "Electrical", "Bus Reset Switch")
MB_339:defineToggleSwitch("BUS_RESET_CV", 1, 3100, 233, "Electrical", "Bus Reset Cover")

--Simple avionics
MB_339:defineRotary("FW_SET_INDEX", 1, 3101, 541, "Avionics FW", "Forward Set Index")
MB_339:defineRotary("FW_ALT_KNOB", 1, 3102, 241, "Avionics FW", "Forward Altimeter Pressure Setting")
MB_339:definePushButton("FW_G_RESET", 1, 3104, 259, "Avionics FW", "Forward Reset Min/Max G")

MB_339:defineRotary("AFT_ALTIMETER_KNOB", 1, 3103, 570, "Avionics AFT", "Aft Altimeter Pressure Setting")
MB_339:definePushButton("AFT_G_RESET", 1, 3105, 691, "Avionics AFT", "Aft Reset Min/Max G")

MB_339:defineFloat("FW_AIRSPEED_IND_G", 8, { 0, 1 }, "Avionics Gauges", "Forward Mach Airspeed Indicator")
MB_339:defineFloat("FW_AIRSPEED_ARROW_O_G", 542, { 0, 1 }, "Avionics Gauges", "Forward Mach Airspeed Outer Arrow")
MB_339:defineFloat("FW_AIRSPEED_DISC_G", 543, { 0, 1 }, "Avionics Gauges", "Forward Mach Airspeed Disc")
MB_339:defineFloat("FW_AIRSPEED_ARROW_I_G", 544, { 0, 1 }, "Avionics Gauges", "Forward Mach Airspeed Inner Arrow")
MB_339:defineFloat("FW_ADI_PITCH_G", 9, { -1, 1 }, "Avionics Gauges", "Forward ADI Pitch")
MB_339:defineFloat("FW_ADI_BANK_G", 10, { -1, 1 }, "Avionics Gauges", "Forward ADI Bank")
MB_339:defineFloat("FW_ADI_GS_G", 11, { -1, 1 }, "Avionics Gauges", "Forward ADI Glide Slope Indicator")
MB_339:defineFloat("FW_ADI_GS_WARN_G", 22, { 0, 1 }, "Avionics Gauges", "Forward ADI Glide Slope Warning Flag")
MB_339:defineFloat("FW_ADI_FD_FLAG_G", 23, { 0, 1 }, "Avionics Gauges", "Forward ADI Flight Director Flag")
MB_339:defineFloat("FW_ALT_100_G", 50, { 0, 1 }, "Avionics Gauges", "Forward Altimeter 100 ft count & Needle")
MB_339:defineFloat("FW_ALT_1000_G", 52, { 0, 1 }, "Avionics Gauges", "Forward Altimeter 1000 ft count")
MB_339:defineFloat("FW_ALT_10000_G", 53, { 0, 1 }, "Avionics Gauges", "Forward Altimeter 10000 ft count")
MB_339:defineFloat("FW_VVI_G", 208, { -1, 1 }, "Avionics Gauges", "Forward Vertical Velocity Indicator")
MB_339:defineFloat("FW_ALT_PRESS_1000_G", 242, { 0, 1 }, "Avionics Gauges", "Forward Altimeter Pressure 1000")
MB_339:defineFloat("FW_ALT_PRESS_100_G", 243, { 0, 1 }, "Avionics Gauges", "Forward Altimeter Pressure 100")
MB_339:defineFloat("FW_ALT_PRESS_10_G", 244, { 0, 1 }, "Avionics Gauges", "Forward Altimeter Pressure 10")
MB_339:defineFloat("FW_ALT_PRESS_1_G", 245, { 0, 1 }, "Avionics Gauges", "Forward Altimeter Pressure 1")
MB_339:defineFloat("FW_COMP_UD_G", 299, { -1, 1 }, "Avionics Gauges", "Forward Compassrose Up/Down")
MB_339:defineFloat("FW_COMP_NS_G", 305, { 0, 1 }, "Avionics Gauges", "Forward Compassrose N/S")
MB_339:defineFloat("FW_ALT_OFF_G", 311, { 0, 1 }, "Avionics Gauges", "Forward Altimeter CODE OFF Flag")
MB_339:defineFloat("FW_ACCEL_G", 6, { -1, 1 }, "Avionics Gauges", "Forward Accelerometer")
MB_339:defineFloat("FW_ACCEL_MIN", 320, { 0, 1 }, "Avionics Gauges", "Forward Accelerometer Min Pointer")
MB_339:defineFloat("FW_ACCEL_MAX", 349, { 0, 1 }, "Avionics Gauges", "Forward Accelerometer Max Pointer")
MB_339:defineFloat("AFT_ACCEL_G", 688, { -1, 1 }, "Avionics Gauges", "Aft Accelerometer")
MB_339:defineFloat("AFT_ACCEL_MIN", 690, { 0, 1 }, "Avionics Gauges", "Aft Accelerometer Min Pointer")
MB_339:defineFloat("AFT_ACCEL_MAX", 689, { 0, 1 }, "Avionics Gauges", "Aft Accelerometer Max Pointer")
MB_339:defineFloat("AFT_ADI_GS_G", 12, { -1, 1 }, "Avionics Gauges", "Aft ADI Glide Slope Indicator")
MB_339:defineFloat("AFT_ADI_TURN_G", 13, { -1, 1 }, "Avionics Gauges", "Aft ADI Rate-of-Turn Indicator")
MB_339:defineFloat("AFT_ALT_CFLAG_G", 19, { 0, 1 }, "Avionics Gauges", "Aft Altimeter CODE OFF Flag")
MB_339:defineFloat("AFT_ALT_100_G", 530, { 0, 1 }, "Avionics Gauges", "Aft Altimeter 100 ft count & Needle")
MB_339:defineFloat("AFT_ALT_1000_G", 531, { 0, 1 }, "Avionics Gauges", "Aft Altimeter 1000 ft count")
MB_339:defineFloat("AFT_ALT_10000_G", 532, { 0, 1 }, "Avionics Gauges", "Aft Altimeter 10000 ft count")
MB_339:defineFloat("AFT_ALT_PRESS_1000_G", 533, { 0, 1 }, "Avionics Gauges", "Aft Altimeter Pressure 1000")
MB_339:defineFloat("AFT_ALT_PRESS_100_G", 534, { 0, 1 }, "Avionics Gauges", "Aft Altimeter Pressure 100")
MB_339:defineFloat("AFT_ALT_PRESS_10_G", 535, { 0, 1 }, "Avionics Gauges", "Aft Altimeter Pressure 10")
MB_339:defineFloat("AFT_ALT_PRESS_1_G", 536, { 0, 1 }, "Avionics Gauges", "Aft Altimeter Pressure 1")
MB_339:defineFloat("AFT_AIRSPEED_IND_G", 545, { 0, 1 }, "Avionics Gauges", "Aft Mach Airspeed Indicator")
MB_339:defineFloat("AFT_AIRSPEED_ARROW_O_G", 549, { 0, 1 }, "Avionics Gauges", "Aft Mach Airspeed Outer Arrow")
MB_339:defineFloat("AFT_AIRSPEED_DISC_G", 547, { 0, 1 }, "Avionics Gauges", "Aft Mach Airspeed Disc")
MB_339:defineFloat("AFT_AIRSPEED_ARROW_I_G", 548, { 0, 1 }, "Avionics Gauges", "Aft Mach Airspeed Inner Arrow")
MB_339:defineFloat("AFT_VVI_G", 692, { -1, 1 }, "Avionics Gauges", "Aft Vertical Velocity Indicator")
MB_339:defineFloat("FLAP_G", 1, { 0, 1 }, "Avionics Gauges", "Flaps Position Indicator")
MB_339:defineFloat("SPEED_BRK_G", 2, { 0, 1 }, "Avionics Gauges", "Speed Brake Position Indicator")
MB_339:defineFloat("LONG_TRIM_G", 3, { -1, 1 }, "Avionics Gauges", "Longitudinal Trim Indicator")
MB_339:defineFloat("FLAP_LVR_G", 7, { 0, 1 }, "Avionics Gauges", "Flaps Lever")
MB_339:defineFloat("TACHO_RPM_G", 16, { 0, 1 }, "Avionics Gauges", "Tachometer Percent RPM")
MB_339:defineFloat("ADI_OFF_G", 21, { 0, 1 }, "Avionics Gauges", "ADI OFF Flag")
MB_339:defineFloat("TACHO_G", 33, { 0, 1 }, "Avionics Gauges", "Tachometer")
MB_339:defineFloat("HYD_PRESS_MAIN_G", 150, { 0, 1 }, "Avionics Gauges", "Main Hydraulic Pressure Gauge")
MB_339:defineFloat("HYD_PRESS_EMERG_G", 151, { 0, 1 }, "Avionics Gauges", "Emergency Hydraulic Pressure Gauge")
MB_339:defineFloat("OIL_PRESS_G", 152, { 0, 1 }, "Avionics Gauges", "Oil Pressure Gauge")
MB_339:defineFloat("OXY_PRESS_G", 153, { 0, 1 }, "Avionics Gauges", "Oxygen Pressure Gauge")
MB_339:defineFloat("AOA_OFF_G", 310, { 0, 1 }, "Avionics Gauges", "AOA OFF Flag")
MB_339:defineFloat("AOA_G", 315, { 0, 1 }, "Avionics Gauges", "AOA Gauge")
MB_339:defineFloat("CABIN_PRESS_G", 319, { 0, 1 }, "Avionics Gauges", "Cabin Pressure Gauge")
MB_339:defineFloat("LOADM_GEN1_G", 380, { 0, 1 }, "Avionics Gauges", "GEN 1 Loadmeter Gauge")
MB_339:defineFloat("LOADM_GEN2_G", 381, { 0, 1 }, "Avionics Gauges", "GEN 2 Loadmeter Gauge")

--Chrono
MB_339:definePushButton("FW_CLOCK_BTN", 1, 3106, 44, "Clock FW", "Forward Clock Start/Stop/Reset")
MB_339:defineToggleSwitch("FW_CLOCK_SET_PULL", 1, 3107, 45, "Clock FW", "Forward Clock Set Pull")
MB_339:defineRotary("FW_CLOCK_SET_KNOB", 1, 3108, 51, "Clock FW", "Forward Clock Set Rotate")

MB_339:definePushButton("AFT_CLOCK_BTN", 1, 3109, 28, "Clock AFT", "Aft Clock Start/Stop/Reset")
MB_339:defineToggleSwitch("AFT_CLOCK_SET_PULL", 1, 3110, 29, "Clock AFT", "Aft Clock Set Pull")
MB_339:defineRotary("AFT_CLOCK_SET_KNOB", 1, 3111, 30, "Clock AFT", "Aft Clock Set Rotate")

MB_339:defineFloat("FW_CLOCK_M_G", 46, { 0, 1 }, "Clock Gauges", "Forward Clock Minutes Indicator")
MB_339:defineFloat("FW_CLOCK_H_G", 47, { 0, 1 }, "Clock Gauges", "Forward Clock Hours Indicator")
MB_339:defineFloat("FW_CLOCK_S_G", 48, { 0, 1 }, "Clock Gauges", "Forward Clock Seconds Indicator")
MB_339:defineFloat("FW_CLOCK_SET_G", 49, { 0, 1 }, "Clock Gauges", "Forward Clock Set Indicator")
MB_339:defineFloat("AFT_CLOCK_M_G", 24, { 0, 1 }, "Clock Gauges", "Aft Clock Minutes Indicator")
MB_339:defineFloat("AFT_CLOCK_H_G", 25, { 0, 1 }, "Clock Gauges", "Aft Clock Hours Indicator")
MB_339:defineFloat("AFT_CLOCK_S_G", 26, { 0, 1 }, "Clock Gauges", "Aft Clock Seconds Indicator")
MB_339:defineFloat("AFT_CLOCK_SET_G", 27, { 0, 1 }, "Clock Gauges", "Aft Clock Set Indicator")

-- ADI
MB_339:definePotentiometer("FW_ADI_PITCH", 1, 3112, 15, { 0, 1 }, "ADI FW", "Forward ADI Pitch Adjustment")
MB_339:defineToggleSwitch("FW_ATT_CAGE", 1, 3114, 403, "ADI FW", "Forward Attitude Indicator Cage")
MB_339:definePotentiometer("FW_ATT_ADJUST", 1, 3115, 401, { -1, 1 }, "ADI FW", "Forward Attitude Indicator Adjust")

MB_339:definePotentiometer("AFT_ADI_PITCH", 1, 3113, 388, { 0, 1 }, "ADI AFT", "Aft ADI Pitch Adjustment")
MB_339:defineToggleSwitch("AFT_ATT_CAGE", 1, 3116, 404, "ADI AFT", "Aft Attitude Indicator Cage")
MB_339:definePotentiometer("AFT_ATT_ADJUST", 1, 3117, 402, { -1, 1 }, "ADI AFT", "Aft Attitude Indicator Adjust")

MB_339:defineFloat("FW_ADI_SLIP_G", 371, { -1, 1 }, "ADI Gauges", "Forward ADI Slipball")
MB_339:defineFloat("FW_ADI_STEER_B_BANK_G", 372, { -1, 1 }, "ADI Gauges", "Forward ADI Bank Steering Bar")
MB_339:defineFloat("FW_ADI_STEER_B_PITCH_G", 373, { -1, 1 }, "ADI Gauges", "Forward ADI Pitch Steering Bar")
MB_339:defineFloat("FW_ATT_PITCH_G", 389, { -1, 1 }, "ADI Gauges", "Forward Attitude Indicator Pitch")
MB_339:defineFloat("FW_ATT_BANK_G", 390, { -1, 1 }, "ADI Gauges", "Forward Attitude Indicator Bank")
MB_339:defineFloat("FW_ATT_OFF_G", 405, { 0, 1 }, "ADI Gauges", "Forward Attitude Indicator OFF Flag")
MB_339:defineFloat("AFT_ADI_PITCH_G", 386, { -1, 1 }, "ADI Gauges", "Aft ADI Pitch")
MB_339:defineFloat("AFT_ADI_BANK_G", 387, { -1, 1 }, "ADI Gauges", "Aft ADI Bank")
MB_339:defineFloat("AFT_ADI_OFF_G", 393, { 0, 1 }, "ADI Gauges", "Aft ADI OFF Flag")
MB_339:defineFloat("AFT_ADI_GLIDE_WARN_G", 394, { 0, 1 }, "ADI Gauges", "Aft ADI Glide Slope Warning Flag")
MB_339:defineFloat("AFT_ADI_CRS_WARN_G", 395, { 0, 1 }, "ADI Gauges", "Aft ADI Course Warning Flag")
MB_339:defineFloat("AFT_ADI_STEER_B_BANK_G", 396, { -1, 1 }, "ADI Gauges", "Aft ADI Bank Steering Bar")
MB_339:defineFloat("AFT_ADI_STEER_B_PITCH_G", 397, { -1, 1 }, "ADI Gauges", "Aft ADI Pitch Steering Bar")
MB_339:defineFloat("AFT_ADI_SLIP_G", 397, { -1, 1 }, "ADI Gauges", "Aft ADI Slipball")
MB_339:defineFloat("AFT_ATT_PITCH_G", 391, { -1, 1 }, "ADI Gauges", "Aft Attitude Indicator Pitch")
MB_339:defineFloat("AFT_ATT_BANK_G", 392, { -1, 1 }, "ADI Gauges", "Aft Attitude Indicator Bank")
MB_339:defineFloat("AFT_ATT_OFF_G", 406, { -1, 1 }, "ADI Gauges", "Aft Attitude Indicator OFF Flag")
MB_339:defineFloat("ADI_TURN_G", 687, { -1, 1 }, "ADI Gauges", "ADI Rate of Turn Indicator")

--HSI
MB_339:defineRotary("FW_HSI_HDG", 1, 3118, 362, "HSI FW", "Forward HSI Heading Set")
MB_339:defineRotary("FW_HSI_CRS", 1, 3119, 353, "HSI FW", "Forward HSI Course Set")
MB_339:definePushButton("FW_HSI_TCN", 1, 3213, 346, "HSI FW", "Forward HSI TACAN")
MB_339:definePushButton("FW_HSI_VOR", 1, 3214, 347, "HSI FW", "Forward HSI VOR")
MB_339:definePushButton("FW_HSI_RNAV", 1, 3215, 348, "HSI FW", "Forward HSI RNAV")

MB_339:defineRotary("AFT_HSI_HDG", 1, 3120, 196, "HSI AFT", "Aft HSI Heading Set")
MB_339:defineRotary("AFT_HSI_CRS", 1, 3121, 187, "HSI AFT", "Aft HSI Course Set")
MB_339:definePushButton("AFT_HSI_TCN", 1, 3216, 57, "HSI AFT", "Aft HSI TACAN")
MB_339:definePushButton("AFT_HSI_VOR", 1, 3217, 58, "HSI AFT", "Aft HSI VOR")
MB_339:definePushButton("AFT_HSI_RNAV", 1, 3218, 59, "HSI AFT", "Aft HSI RNAV")

MB_339:defineFloat("FW_HSI_CRS_1_G", 350, { 0, 1 }, "HSI Gauges", "Forward HSI Course Drum 1")
MB_339:defineFloat("FW_HSI_CRS_10_G", 351, { 0, 1 }, "HSI Gauges", "Forward HSI Course Drum 10")
MB_339:defineFloat("FW_HSI_CRS_100_G", 352, { 0, 1 }, "HSI Gauges", "Forward HSI Course Drum 100")
MB_339:defineFloat("FW_HSI_CRS_A_G", 354, { 0, 1 }, "HSI Gauges", "Forward HSI Course Arrow")
MB_339:defineFloat("FW_HSI_OFF_G", 355, { 0, 1 }, "HSI Gauges", "Forward HSI OFF Flag")
MB_339:defineFloat("FW_HSI_DIST_G", 356, { 0, 1 }, "HSI Gauges", "Forward HSI Distance Bar")
MB_339:defineFloat("FW_HSI_DIST_1_G", 357, { 0, 1 }, "HSI Gauges", "Forward HSI Distance Drum 1")
MB_339:defineFloat("FW_HSI_DIST_10_G", 358, { 0, 1 }, "HSI Gauges", "Forward HSI Distance Drum 10")
MB_339:defineFloat("FW_HSI_DIST_100_G", 359, { 0, 1 }, "HSI Gauges", "Forward HSI Distance Drum 100")
MB_339:defineFloat("FW_HSI_CRS_DEV_G", 360, { -1, 1 }, "HSI Gauges", "Forward HSI Course Deviation Bar")
MB_339:defineFloat("FW_HSI_COMP_G", 361, { 0, 1 }, "HSI Gauges", "Forward HSI Compass Rose")
MB_339:defineFloat("FW_HSI_SEL_HD_G", 363, { 0, 1 }, "HSI Gauges", "Forward HSI Selected Heading Indicator")
MB_339:defineFloat("FW_HSI_POINT_1_G", 364, { 0, 1 }, "HSI Gauges", "Forward HSI Bearing Pointer 1")
MB_339:defineFloat("FW_HSI_POINT_2_G", 365, { 0, 1 }, "HSI Gauges", "Forward HSI Bearing Pointer 2")
MB_339:defineFloat("FW_HSI_DEV_G", 366, { 0, 1 }, "HSI Gauges", "Forward HSI Deviation Flag")
MB_339:defineFloat("FW_HSI_ARROW_UP_G", 367, { 0, 1 }, "HSI Gauges", "Forward HSI Arrow UP")
MB_339:defineFloat("FW_HSI_ARROW_DN_G", 368, { 0, 1 }, "HSI Gauges", "Forward HSI Arrow DN")

MB_339:defineFloat("AFT_HSI_CRS_1_G", 184, { 0, 1 }, "HSI Gauges", "Aft HSI Course Drum 1")
MB_339:defineFloat("AFT_HSI_CRS_10_G", 185, { 0, 1 }, "HSI Gauges", "Aft HSI Course Drum 10")
MB_339:defineFloat("AFT_HSI_CRS_100_G", 186, { 0, 1 }, "HSI Gauges", "Aft HSI Course Drum 100")
MB_339:defineFloat("AFT_HSI_CRS_A_G", 188, { 0, 1 }, "HSI Gauges", "Aft HSI Course Arrow")
MB_339:defineFloat("AFT_HSI_OFF_G", 189, { 0, 1 }, "HSI Gauges", "Aft HSI OFF Flag")
MB_339:defineFloat("AFT_HSI_DIST_G", 190, { 0, 1 }, "HSI Gauges", "Aft HSI Distance Bar")
MB_339:defineFloat("AFT_HSI_DIST_1_G", 191, { 0, 1 }, "HSI Gauges", "Aft HSI Distance Drum 1")
MB_339:defineFloat("AFT_HSI_DIST_10_G", 192, { 0, 1 }, "HSI Gauges", "Aft HSI Distance Drum 10")
MB_339:defineFloat("AFT_HSI_DIST_100_G", 193, { 0, 1 }, "HSI Gauges", "Aft HSI Distance Drum 100")
MB_339:defineFloat("AFT_HSI_CRS_DEV_G", 194, { -1, 1 }, "HSI Gauges", "Aft HSI Course Deviation Bar")
MB_339:defineFloat("AFT_HSI_COMP_G", 195, { 0, 1 }, "HSI Gauges", "Aft HSI Compass Rose")
MB_339:defineFloat("AFT_HSI_SEL_HD_G", 197, { 0, 1 }, "HSI Gauges", "Aft HSI Selected Heading Indicator")
MB_339:defineFloat("AFT_HSI_POINT_1_G", 198, { 0, 1 }, "HSI Gauges", "Aft HSI Bearing Pointer 1")
MB_339:defineFloat("AFT_HSI_POINT_2_G", 199, { 0, 1 }, "HSI Gauges", "Aft HSI Bearing Pointer 2")
MB_339:defineFloat("AFT_HSI_DEV_G", 200, { 0, 1 }, "HSI Gauges", "Aft HSI Deviation Flag")
MB_339:defineFloat("AFT_HSI_ARROW_UP_G", 201, { 0, 1 }, "HSI Gauges", "Aft HSI Arrow UP")
MB_339:defineFloat("AFT_HSI_ARROW_DN_G", 202, { 0, 1 }, "HSI Gauges", "Aft HSI Arrow DN")

MB_339:defineIndicatorLight08("FW_HSI_TCN_L", 369, "HSI Lights", "Forward HSI TACAN Light (green)")
MB_339:defineIndicatorLight08("FW_HSI_VOR_L", 370, "HSI Lights", "Forward HSI VOR Light (green)")
MB_339:defineIndicatorLight08("FW_HSI_RNAV_L", 383, "HSI Lights", "Forward HSI RNAV Light (green)")

MB_339:defineIndicatorLight08("AFT_HSI_TCN_L", 54, "HSI Lights", "Aft HSI TACAN Light (green)")
MB_339:defineIndicatorLight08("AFT_HSI_VOR_L", 55, "HSI Lights", "Aft HSI VOR Light (green)")
MB_339:defineIndicatorLight08("AFT_HSI_RNAV_L", 56, "HSI Lights", "Aft HSI RNAV Light (green)")

--Flight dir
MB_339:definePushButton("FW_FD_HDG", 1, 3122, 333, "Flight Dir FW", "Forward F/D HDG")
MB_339:definePushButton("FW_FD_GS_ARM", 1, 3123, 334, "Flight Dir FW", "Forward F/D GS ARM")
MB_339:definePushButton("FW_FD_STBY", 1, 3124, 335, "Flight Dir FW", "Forward F/D STBY")
MB_339:definePushButton("FW_FD_RADIO_NAV", 1, 3125, 336, "Flight Dir FW", "Forward F/D RADIO NAV")
MB_339:definePushButton("FW_FD_GS", 1, 3126, 337, "Flight Dir FW", "Forward F/D GS")
MB_339:definePushButton("FW_FD_ALT_HOLD", 1, 3127, 338, "Flight Dir FW", "Forward F/D ALT HOLD")

MB_339:definePushButton("AFT_FD_HDG", 1, 3128, 693, "Flight Dir AFT", "Aft F/D HDG")
MB_339:definePushButton("AFT_FD_GS_ARM", 1, 3129, 695, "Flight Dir AFT", "Aft F/D GS ARM")
MB_339:definePushButton("AFT_FD_STBY", 1, 3130, 697, "Flight Dir AFT", "Aft F/D STBY")
MB_339:definePushButton("AFT_FD_RADIO_NAV", 1, 3131, 699, "Flight Dir AFT", "Aft F/D RADIO NAV")
MB_339:definePushButton("AFT_FD_GS", 1, 3132, 701, "Flight Dir AFT", "Aft F/D GS")
MB_339:definePushButton("AFT_FD_ALT_HOLD", 1, 3133, 703, "Flight Dir AFT", "Aft F/D ALT HOLD")

MB_339:defineIndicatorLight08("FW_FD_HDG_L", 339, "Flight Dir Lights", "Forward F/D HDG Light (green)")
MB_339:defineIndicatorLight08("FW_FD_GS_ARM_L", 340, "Flight Dir Lights", "Forward F/D GS ARM Light (green)")
MB_339:defineIndicatorLight08("FW_FD_STBY_L", 341, "Flight Dir Lights", "Forward F/D STBY Light (green)")
MB_339:defineIndicatorLight08("FW_FD_RADIO_NAV_L", 342, "Flight Dir Lights", "Forward F/D RADIO NAV Light (green)")
MB_339:defineIndicatorLight08("FW_FD_GS_L", 343, "Flight Dir Lights", "Forward F/D GS Light (green)")
MB_339:defineIndicatorLight08("FW_FD_ALT_HOLD_L", 344, "Flight Dir Lights", "Forward F/D ALT HOLD Light (green)")
MB_339:defineIndicatorLight08("AFT_FD_HDG_L", 694, "Flight Dir Lights", "Aft F/D HDG Light (green)")
MB_339:defineIndicatorLight08("AFT_FD_GS_ARM_L", 696, "Flight Dir Lights", "Aft F/D GS ARM Light (green)")
MB_339:defineIndicatorLight08("AFT_FD_STBY_L", 698, "Flight Dir Lights", "Aft F/D STBY Light (green)")
MB_339:defineIndicatorLight08("AFT_FD_RADIO_NAV_L", 700, "Flight Dir Lights", "Aft F/D RADIO NAV Light (green)")
MB_339:defineIndicatorLight08("AFT_FD_GS_L", 702, "Flight Dir Lights", "Aft F/D GS Light (green)")
MB_339:defineIndicatorLight08("AFT_FD_ALT_HOLD_L", 704, "Flight Dir Lights", "Aft F/D ALT HOLD Light (green)")

--Fuel
MB_339:defineMultipositionSwitch("FW_FUEL_TANK_SEL", 1, 3134, 257, 5, 0.25, "Fuel FW", "Forward Fuel Tank Selector")
MB_339:definePushButton("FW_FUEL_TEST", 1, 3135, 258, "Fuel FW", "Forward Fuel Quantity Test")
MB_339:defineToggleSwitch("FW_FUEL_OFF_SW", 1, 3138, 248, "Fuel FW", "Foreward Fuel Shut-Off Switch")
MB_339:defineToggleSwitch("FW_FUEL_OFF_CVR", 1, 3139, 237, "Fuel FW", "Foreward Fuel Shut-Off Guard")
MB_339:defineToggleSwitch("FW_FUEL_TRANS", 1, 3142, 249, "Fuel FW", "Foreward Fuel Transfer")
MB_339:defineToggleSwitch("FW_FUEL_DUMP", 1, 3143, 593, "Fuel FW", "Foreward Fuel Dump")

MB_339:defineMultipositionSwitch("AFT_FUEL_TANK_SEL", 1, 3136, 328, 5, 0.25, "Fuel AFT", "Aft Fuel Tank Selector")
MB_339:definePushButton("AFT_FUEL_TEST", 1, 3137, 374, "Fuel AFT", "Aft Fuel Quantity Test")
MB_339:defineToggleSwitch("AFT_FUEL_OFF_SW", 1, 3140, 516, "Fuel AFT", "Aft Fuel Shut-Off Switch")
MB_339:defineToggleSwitch("AFT_FUEL_OFF_CVR", 1, 3141, 517, "Fuel AFT", "Aft Fuel Shut-Off Guard")
MB_339:defineToggleSwitch("AFT_FUEL_DUMP", 1, 3144, 160, "Fuel AFT", "Aft Fuel Dump")

MB_339:defineFloat("FW_FUEL_G", 312, { 0, 1 }, "Fuel Gauge", "Foreward Fuel Gauge")
MB_339:defineFloat("AFT_FUEL_G", 329, { 0, 1 }, "Fuel Gauge", "Aft Fuel Gauge")
MB_339:defineFloat("FUEL_FLOW_G", 313, { 0, 1 }, "Fuel Gauge", "Fuel Flow Gauge")
MB_339:defineFloat("AFT_FUEL_TRANS_G", 520, { 0, 1 }, "Fuel Gauge", "Aft Fuel Transfer Drum")

--L/G & Ground
MB_339:defineToggleSwitch("FW_LG_GEAR_LVR", 1, 5002, 4, "Gear FW", "Foreward Gear Lever")
MB_339:defineToggleSwitch("FW_LG_ASKID", 1, 3145, 250, "Gear FW", "Foreward Anti-Skid")
MB_339:definePotentiometer("FW_LG_PBRAKE", 1, 3147, 266, { 0, 1 }, "Gear FW", "Forward Parking Brake Pull")
MB_339:defineToggleSwitch("FW_LG_PBRAKE_LOCK", 1, 3148, 263, "Gear FW", "Foreward Parking Brake Lock")
MB_339:defineToggleSwitch("FW_LG_EMERG_GEAR", 1, 3149, 681, "Gear FW", "Foreward Emergency Landing Gear")
MB_339:definePushButton("FW_LG_DL_OVERRIDE", 1, 5000, 379, "Gear FW", "Foreward Down-Lock Override")
MB_339:defineSpringloaded_3PosTumb("FW_RUDDER_TRIM", 1, 3150, 3151, 540, "Gear FW", "Foreward Rudder Trim")

MB_339:defineToggleSwitch("AFT_LG_GEAR_LVR", 1, 5002, 106, "Gear AFT", "Aft Gear Lever")
MB_339:defineToggleSwitch("AFT_LG_ASKID", 1, 3146, 518, "Gear AFT", "Aft Anti-Skid")
MB_339:definePushButton("AFT_LG_DL_OVERRIDE", 1, 5001, 14, "Gear AFT", "Aft Down-Lock Override")
MB_339:defineSpringloaded_3PosTumb("AFT_RUDDER_TRIM", 1, 3152, 3153, 519, "Gear AFT", "Aft Rudder Trim")

MB_339:defineIndicatorLight08("NOSE_GEAR_L", 20, "Gear Lights", "Nose Gear Light (green)")
MB_339:defineIndicatorLight08("RIGHT_GEAR_L", 31, "Gear Lights", "Right Gear Light (green)")
MB_339:defineIndicatorLight08("LEFT_GEAR_L", 32, "Gear Lights", "Left Gear Light (green)")
MB_339:defineIndicatorLight08("GEAR_HND_L", 42, "Gear Lights", "Gear Handle Light (red)")
MB_339:defineIndicatorLight08("TRIM_RUD_L", 251, "Gear Lights", "Takeoff Trim Rudder Light (green)")
MB_339:defineIndicatorLight08("TRIM_AIL_L", 252, "Gear Lights", "Takeoff Trim Aileron Light (green)")

--Lights
MB_339:define3PosTumb("FW_LIGHT_TAXI_LAND", 1, 3154, 321, "Lights FW", "Forward Taxi/Landing Lights")
MB_339:definePotentiometer("FW_LIGHT_FORMATION", 1, 3155, 502, { 0, 1 }, "Lights FW", "Forward Formation Lights")
MB_339:definePotentiometer("FW_LIGHT_INSTRUMENT", 1, 3156, 503, { 0, 1 }, "Lights FW", "Forward Instruments Lights")
MB_339:definePotentiometer("FW_LIGHT_FLOOD", 1, 3157, 504, { 0, 1 }, "Lights FW", "Forward Flood Lights")
MB_339:definePotentiometer("FW_LIGHT_CONSOLE", 1, 3158, 505, { 0, 1 }, "Lights FW", "Forward Console Lights")
MB_339:defineToggleSwitch("FW_LIGHT_NAV_FLASH", 1, 3167, 41, "Lights FW", "Forward Nav Lights Flash/Steady")
MB_339:define3PosTumb("FW_LIGHT_NAV_BRIGHT", 1, 3166, 40, "Lights FW", "Forward Nav Lights Bright/Dim")
MB_339:defineToggleSwitch("FW_LIGHT_BEACON", 1, 3167, 685, "Lights FW", "Forward Beacon Lights")
MB_339:defineToggleSwitch("FW_LIGHT_WARN_BRIGHT", 1, 3168, 322, "Lights FW", "Forward Warn Lights Bright/Dim")

MB_339:definePotentiometer("AFT_LIGHT_INSTRUMENT", 1, 3159, 510, { 0, 1 }, "Lights AFT", "Aft Instruments Lights")
MB_339:definePotentiometer("AFT_LIGHT_FLOOD", 1, 3160, 512, { 0, 1 }, "Lights AFT", "Aft Flood Lights")
MB_339:definePotentiometer("AFT_LIGHT_CONSOLE", 1, 3161, 511, { 0, 1 }, "Lights AFT", "Aft Console Lights")
MB_339:defineToggleSwitch("AFT_LIGHT_WARN_BRIGHT", 1, 3169, 107, "Lights AFT", "Aft Warn Lights Bright/Dim")

MB_339:defineFloat("FW_LIGHT_INST_BACK_L", 507, { 0, 1 }, "Lights", "Foreward Instrument Backlights (white)")
MB_339:defineFloat("FW_LIGHT_PANEL_BACK_L", 508, { 0, 1 }, "Lights", "Foreward Panel Backlights (white)")
MB_339:defineFloat("FW_LIGHT_FLOOD_L", 508, { 0, 1 }, "Lights", "Foreward Flood Lights (red)")
MB_339:defineFloat("AFT_LIGHT_INST_BACK_L", 513, { 0, 1 }, "Lights", "Aft Instrument Backlights (white)")
MB_339:defineFloat("AFT_LIGHT_PANEL_BACK_L", 514, { 0, 1 }, "Lights", "Aft Panel Backlights (white)")
MB_339:defineFloat("AFT_LIGHT_FLOOD_L", 515, { 0, 1 }, "Lights", "Aft Flood Lights (red)")

--Warning panel
MB_339:definePushButton("WARN_L_TEST", 1, 3170, 304, "Warning Panel", "Warn Lights Test")
MB_339:definePushButton("FW_MASTER_CAUTION", 1, 3171, 591, "Warning Panel", "Forward Master Caution Reset")
MB_339:definePushButton("AFT_MASTER_CAUTION", 1, 3171, 592, "Warning Panel", "Aft Master Caution Reset")
MB_339:definePushButton("WARN_SILENT", 1, 3173, 382, "Warning Panel", "Warning Silence")

MB_339:defineIndicatorLight08("MASTER_CAUTION_L", 209, "Warning Panel Light", "Master Caution Light (yellow)")
MB_339:defineIndicatorLight08("MCP_DC_GEN1_L", 210, "Warning Panel Light", "NO 1 DC GEN Light (yellow)")
MB_339:defineIndicatorLight08("MCP_DC_GEN2_L", 211, "Warning Panel Light", "NO 2 DC GEN Light (yellow)")
MB_339:defineIndicatorLight08("MCP_BATT1_L", 212, "Warning Panel Light", "NO 1 BATT Light (yellow)")
MB_339:defineIndicatorLight08("MCP_BATT2_L", 213, "Warning Panel Light", "NO 2 BATT Light (yellow)")
MB_339:defineIndicatorLight08("MCP_BATT_HOT_L", 214, "Warning Panel Light", "BATT HOT Light (yellow)")
MB_339:defineIndicatorLight08("MCP_AC_ESS_BUS_L", 215, "Warning Panel Light", "AC ESS BUS Light (yellow)")
MB_339:defineIndicatorLight08("MCP_AC_SEC_BUS_L", 216, "Warning Panel Light", "AC SEC BUS Light (yellow)")
MB_339:defineIndicatorLight08("MCP_CKT_BKR_L", 217, "Warning Panel Light", "CKT BKR Light (yellow)")
MB_339:defineIndicatorLight08("MCP_AIL_SERVO_L", 218, "Warning Panel Light", "AIL SERVO Light (yellow)")
MB_339:defineIndicatorLight08("MCP_OXY_LOW_L", 219, "Warning Panel Light", "OXY LOW Light (yellow)")
MB_339:defineIndicatorLight08("MCP_DUCT_AICE_L", 220, "Warning Panel Light", "DUCT ANTI-ICE Light (yellow)")
MB_339:defineIndicatorLight08("MCP_TK_EMPTY_L", 221, "Warning Panel Light", "PYL TK EMPTY Light (yellow)")
MB_339:defineIndicatorLight08("MCP_FUEL_TRANS_L", 222, "Warning Panel Light", "FUEL TRANSF Light (yellow)")
MB_339:defineIndicatorLight08("MCP_TK_UNBAL_L", 223, "Warning Panel Light", "TIP TK UNBAL Light (yellow)")
MB_339:defineIndicatorLight08("MCP_FUEL_LOW_L", 224, "Warning Panel Light", "FUEL LOW Light (yellow)")
MB_339:defineIndicatorLight08("MCP_FUEL_PRESS_L", 225, "Warning Panel Light", "FUEL PRESS Light (yellow)")
MB_339:defineIndicatorLight08("MCP_OIL_PRESS_L", 226, "Warning Panel Light", "OLI PRESS Light (yellow)")
MB_339:defineIndicatorLight08("MCP_ICE_L", 227, "Warning Panel Light", "ICE Light (yellow)")
MB_339:defineIndicatorLight08("MCP_JPT_LMTR_L", 228, "Warning Panel Light", "JPT LMTR Light (yellow)")
MB_339:defineIndicatorLight08("MCP_IFF_L", 229, "Warning Panel Light", "IFF Light (yellow)")
MB_339:defineIndicatorLight08("MCP_IFF_M4_L", 230, "Warning Panel Light", "IFF MODE 4 Light (yellow)")
MB_339:defineIndicatorLight08("FIRE_L", 253, "Warning Panel Light", "Fire Light (red)")
MB_339:defineIndicatorLight08("STEER_L", 254, "Warning Panel Light", "STEER Light (green)")
MB_339:defineIndicatorLight08("ASKIT_L", 255, "Warning Panel Light", "A/SKIT Light (yellow)")
MB_339:defineIndicatorLight08("OVERHEAT_L", 256, "Warning Panel Light", "OVERHEAT Light (yellow)")
MB_339:defineIndicatorLight08("CANOPY_L", 399, "Warning Panel Light", "CANOPY Light (red)")
MB_339:defineFloat("MCP_BRIGHT_L", 746, { 0, 1 }, "Warning Panel Light", "Warning Panel Brightness")

--Engine
MB_339:defineToggleSwitch("ENG_MASTER", 1, 3174, 238, "Engine", "Engine Master")
MB_339:defineToggleSwitch("ENG_JPT_LIMIT", 1, 3177, 240, "Engine", "JPT Limiter")
MB_339:definePushButton("ENG_START", 1, 3178, 239, "Engine", "Engine Start")

MB_339:defineFloat("ENG_TEMP_G", 314, { 0, 1 }, "Engine Gauges", "Engine Temperature Gauge")

--Flight Controls
MB_339:definePushButton("FW_FC_CANOPY_LOCK", 1, 5004, 182, "Flight Controls FW", "Forward Canopy LOCK/UNLOCK")
MB_339:definePushButton("FW_FC_CANOPY_HOOK", 1, 5005, 183, "Flight Controls FW", "Forward Partial Opening Hook")
MB_339:definePushButton("FW_FC_CANOPY_UNLOCK", 1, 5006, 582, "Flight Controls FW", "Forward Canopy UNLOCK")
MB_339:defineToggleSwitch("FW_FC_CANOPY_HND", 1, 3179, 750, "Flight Controls FW", "Forward Canopy Handle")
MB_339:defineToggleSwitch("FW_FC_LOCK", 1, 5009, 232, "Flight Controls FW", "Forward Flight Controls LOCK/UNLOCK")
MB_339:defineToggleSwitch("FW_FC_MIRRORS", 1, 3181, 400, "Flight Controls FW", "Forward Mirrors OPEN/CLOSE")
MB_339:defineToggleSwitch("FW_FC_AILERON_SERVO_CV", 1, 3187, 235, "Flight Controls FW", "Forward Aileron Servo Guard")
MB_339:defineToggleSwitch("FW_FC_AILERON_SERVO", 1, 3188, 260, "Flight Controls FW", "Forward Aileron Servo Switch")

MB_339:definePushButton("AFT_FC_CANOPY_LOCK", 1, 5008, 43, "Flight Controls AFT", "Aft Canopy LOCK/UNLOCK")
MB_339:defineToggleSwitch("AFT_FC_MIRRORS", 1, 3181, 594, "Flight Controls AFT", "Aft Mirrors OPEN/CLOSE")
MB_339:defineToggleSwitch("AFT_FC_AILERON_SERVO_CV", 1, 3189, 288, "Flight Controls AFT", "Aft Aileron Servo Guard")
MB_339:defineToggleSwitch("AFT_FC_AILERON_SERVO", 1, 3190, 289, "Flight Controls AFT", "Aft Aileron Servo Switch")

MB_339:defineIndicatorLight("FW_FC_MARK_BEACON_L", 165, "Flight Controls Light", "Forward Marker Beacon Light (red)")
MB_339:defineIndicatorLight("AFT_FC_MARK_BEACON_L", 167, "Flight Controls Light", "Aft Marker Beacon Light (red)")

--Pressurisation
MB_339:defineToggleSwitch("PRESS_RAMAIR_SCOOP", 1, 3191, 590, "Pressurisation", "Ram Air Scoop")
MB_339:defineToggleSwitch("PRESS_CABIN_PRESS", 1, 3192, 264, "Pressurisation", "Cabin Pressure Switch")
MB_339:defineToggleSwitch("PRESS_CABIN_PRESS_CVR", 1, 3193, 234, "Pressurisation", "Cabin Pressure Switch Guard")
MB_339:definePotentiometer("PRESS_CABIN_TEMP", 1, 3194, 179, { 0, 1 }, "Pressurisation", "Cabin Temp")

--Smoke
MB_339:defineToggleSwitch("SMOKE_MASTER", 1, 3195, 330, "Smoke", "Smoke Master Switch")
MB_339:defineToggleSwitch("SMOKE_WHITE", 1, 3196, 331, "Smoke", "Smoke White Switch")
MB_339:defineToggleSwitch("SMOKE_COLOR", 1, 3197, 332, "Smoke", "Smoke Color Switch")

--Anti Ice
MB_339:define3PosTumb("AI_ENG_AICE", 1, 3198, 262, "Anti Ice", "Engine Anti-Ice")
MB_339:define3PosTumb("AI_FW_PITOT_AICE", 1, 3199, 261, "Anti Ice", "Front Pitot Anti-Ice")
MB_339:define3PosTumb("AI_AFT_PITOT_AICE", 1, 3200, 149, "Anti Ice", "Rear Pitot Anti-Ice")
MB_339:define3PosTumb("AI_WS_DEMIST", 1, 3201, 178, "Anti Ice", "Windshield Demist")
MB_339:define3PosTumb("AI_WS_RAIN", 1, 3202, 177, "Anti Ice", "Windshield Rain RMVL")

MB_339:defineFloat("AI_AOA_G", 528, { 0, 1 }, "Anti Ice Gauges", "Anti-Ice AOA Drum")
MB_339:defineFloat("AI_PITOT_G", 709, { 0, 1 }, "Anti Ice Gauges", "Anti-Ice PITOT Drum")
MB_339:defineFloat("AI_ENG_G", 529, { 0, 1 }, "Anti Ice Gauges", "Anti-Ice ENG Drum")

--Ejection seat
MB_339:defineToggleSwitch("SEAT_FIRE", 1, 3203, 205, "Seat", "Seat Firing Handle")
MB_339:defineSpringloaded_3PosTumb("SEAT_ADJ", 1, 3205, 3206, 323, "Seat", "Adj Seat UP/DOWN")
MB_339:defineToggleSwitch("SEAT_PIN_CANOPY", 1, 3207, 377, "Seat", "Ejection Safety Pin to Canopy")
MB_339:defineToggleSwitch("SEAT_PIN_SEAT", 1, 3208, 376, "Seat", "Ejection Safety Pin to Seat")

--Control shift
MB_339:definePushButton("FW_CONTROL_TCN", 1, 3219, 324, "Control Shift FW", "Forward TACAN Control Shift")
MB_339:definePushButton("FW_CONTROL_ILS", 1, 3220, 326, "Control Shift FW", "Forward VOR-ILS Control Shift")
MB_339:definePushButton("FW_CONTROL_NAV", 1, 3221, 384, "Control Shift FW", "Forward NAV Control Shift")
MB_339:definePushButton("FW_CONTROL_COM1", 1, 3225, 307, "Control Shift FW", "Forward COMM1 Control Shift")
MB_339:definePushButton("FW_CONTROL_COM2", 1, 3226, 309, "Control Shift FW", "Forward COMM2 Control Shift")
MB_339:definePushButton("FW_CONTROL_ADF", 1, 3227, 317, "Control Shift FW", "Forward ADF Control Shift")

MB_339:definePushButton("AFT_CONTROL_TCN", 1, 3222, 273, "Control Shift AFT", "Aft TACAN Control Shift")
MB_339:definePushButton("AFT_CONTROL_ILS", 1, 3223, 275, "Control Shift AFT", "Aft VOR-ILS Control Shift")
MB_339:definePushButton("AFT_CONTROL_NAV", 1, 3224, 277, "Control Shift AFT", "Aft NAV Control Shift")
MB_339:definePushButton("AFT_CONTROL_COM1", 1, 3228, 267, "Control Shift AFT", "Aft COMM1 Control Shift")
MB_339:definePushButton("AFT_CONTROL_COM2", 1, 3229, 269, "Control Shift AFT", "Aft COMM2 Control Shift")
MB_339:definePushButton("AFT_CONTROL_ADF", 1, 3230, 271, "Control Shift AFT", "Aft ADF Control Shift")

MB_339:defineIndicatorLight08("FW_CONTROL_TCN_L", 325, "Control Shift Lights", "Forward TACAN Control Shift Light (green)")
MB_339:defineIndicatorLight08("FW_CONTROL_ILS_L", 327, "Control Shift Lights", "Forward VOR-ILS Control Shift Light (green)")
MB_339:defineIndicatorLight08("FW_CONTROL_NAV_L", 385, "Control Shift Lights", "Forward NAV Control Shift Light (green)")
MB_339:defineIndicatorLight08("FW_CONTROL_COM1_L", 308, "Control Shift Lights", "Forward COMM1 Control Shift Light (green)")
MB_339:defineIndicatorLight08("FW_CONTROL_COM2_L", 316, "Control Shift Lights", "Forward COMM2 Control Shift Light (green)")
MB_339:defineIndicatorLight08("FW_CONTROL_ADF_L", 318, "Control Shift Lights", "Forward ADF Control Shift Light (green)")
MB_339:defineIndicatorLight08("AFT_CONTROL_TCN_L", 274, "Control Shift Lights", "Aft TACAN Control Shift Light (green)")
MB_339:defineIndicatorLight08("AFT_CONTROL_ILS_L", 276, "Control Shift Lights", "Aft VOR-ILS Control Shift Light (green)")
MB_339:defineIndicatorLight08("AFT_CONTROL_NAV_L", 278, "Control Shift Lights", "Aft NAV Control Shift Light (green)")
MB_339:defineIndicatorLight08("AFT_CONTROL_COM1_L", 268, "Control Shift Lights", "Aft COMM1 Control Shift Light (green)")
MB_339:defineIndicatorLight08("AFT_CONTROL_COM2_L", 270, "Control Shift Lights", "Aft COMM2 Control Shift Light (green)")
MB_339:defineIndicatorLight08("AFT_CONTROL_ADF_L", 272, "Control Shift Lights", "Aft ADF Control Shift Light (green)")

--CDU
MB_339:defineToggleSwitch("FW_CDU_GPS_PW", 1, 3231, 345, "CDU FW", "Forward CDU AHRS/GPS System")
MB_339:definePushButton("FW_CDU_ROW1", 1, 3232, 600, "CDU FW", "Forward CDU Row 1")
MB_339:definePushButton("FW_CDU_ROW2", 1, 3233, 601, "CDU FW", "Forward CDU Row 2")
MB_339:definePushButton("FW_CDU_ROW3", 1, 3234, 602, "CDU FW", "Forward CDU Row 3")
MB_339:definePushButton("FW_CDU_ROW4", 1, 3235, 603, "CDU FW", "Forward CDU Row 4")
MB_339:definePushButton("FW_CDU_MARK", 1, 3236, 605, "CDU FW", "Forward CDU MARK")
MB_339:definePushButton("FW_CDU_SET", 1, 3237, 609, "CDU FW", "Forward CDU SET")
MB_339:definePushButton("FW_CDU_BRT", 1, 3238, 610, "CDU FW", "Forward CDU BRT")
MB_339:definePushButton("FW_CDU_INC", 1, 3239, 611, "CDU FW", "Forward CDU +")
MB_339:definePushButton("FW_CDU_DEC", 1, 3240, 612, "CDU FW", "Forward CDU -")
MB_339:definePushButton("FW_CDU_N1", 1, 3241, 613, "CDU FW", "Forward CDU N. 1")
MB_339:definePushButton("FW_CDU_N2", 1, 3242, 614, "CDU FW", "Forward CDU N. 2")
MB_339:definePushButton("FW_CDU_N3", 1, 3243, 615, "CDU FW", "Forward CDU N. 3")
MB_339:definePushButton("FW_CDU_N4", 1, 3244, 616, "CDU FW", "Forward CDU N. 4")
MB_339:definePushButton("FW_CDU_N5", 1, 3245, 617, "CDU FW", "Forward CDU N. 5")
MB_339:definePushButton("FW_CDU_N6", 1, 3246, 618, "CDU FW", "Forward CDU N. 6")
MB_339:definePushButton("FW_CDU_N7", 1, 3247, 619, "CDU FW", "Forward CDU N. 7")
MB_339:definePushButton("FW_CDU_N8", 1, 3248, 620, "CDU FW", "Forward CDU N. 8")
MB_339:definePushButton("FW_CDU_N9", 1, 3249, 621, "CDU FW", "Forward CDU N. 9")
MB_339:definePushButton("FW_CDU_N0", 1, 3250, 622, "CDU FW", "Forward CDU N. 0")
MB_339:definePushButton("FW_CDU_CLR", 1, 3251, 623, "CDU FW", "Forward CDU CLR")
MB_339:definePushButton("FW_CDU_ENT", 1, 3252, 624, "CDU FW", "Forward CDU ENT")
MB_339:definePushButton("FW_CDU_MODE", 1, 3253, 606, "CDU FW", "Forward CDU MODE")
MB_339:definePushButton("FW_CDU_STEER", 1, 3254, 607, "CDU FW", "Forward CDU STEER")
MB_339:definePushButton("FW_CDU_FIX", 1, 3255, 604, "CDU FW", "Forward CDU FIX")
MB_339:definePushButton("FW_CDU_FLT_PLN", 1, 3257, 608, "CDU FW", "Forward CDU FLT PLN")

MB_339:definePushButton("AFT_CDU_ROW1", 1, 3258, 625, "CDU AFT", "Aft CDU Row 1")
MB_339:definePushButton("AFT_CDU_ROW2", 1, 3259, 626, "CDU AFT", "Aft CDU Row 2")
MB_339:definePushButton("AFT_CDU_ROW3", 1, 3260, 627, "CDU AFT", "Aft CDU Row 3")
MB_339:definePushButton("AFT_CDU_ROW4", 1, 3261, 628, "CDU AFT", "Aft CDU Row 4")
MB_339:definePushButton("AFT_CDU_MARK", 1, 3262, 630, "CDU AFT", "Aft CDU MARK")
MB_339:definePushButton("AFT_CDU_SET", 1, 3263, 634, "CDU AFT", "Aft CDU SET")
MB_339:definePushButton("AFT_CDU_BRT", 1, 3264, 635, "CDU AFT", "Aft CDU BRT")
MB_339:definePushButton("AFT_CDU_INC", 1, 3265, 636, "CDU AFT", "Aft CDU +")
MB_339:definePushButton("AFT_CDU_DEC", 1, 3266, 637, "CDU AFT", "Aft CDU -")
MB_339:definePushButton("AFT_CDU_N1", 1, 3267, 638, "CDU AFT", "Aft CDU N. 1")
MB_339:definePushButton("AFT_CDU_N2", 1, 3268, 639, "CDU AFT", "Aft CDU N. 2")
MB_339:definePushButton("AFT_CDU_N3", 1, 3269, 640, "CDU AFT", "Aft CDU N. 3")
MB_339:definePushButton("AFT_CDU_N4", 1, 3270, 641, "CDU AFT", "Aft CDU N. 4")
MB_339:definePushButton("AFT_CDU_N5", 1, 3271, 642, "CDU AFT", "Aft CDU N. 5")
MB_339:definePushButton("AFT_CDU_N6", 1, 3272, 643, "CDU AFT", "Aft CDU N. 6")
MB_339:definePushButton("AFT_CDU_N7", 1, 3273, 644, "CDU AFT", "Aft CDU N. 7")
MB_339:definePushButton("AFT_CDU_N8", 1, 3274, 645, "CDU AFT", "Aft CDU N. 8")
MB_339:definePushButton("AFT_CDU_N9", 1, 3275, 646, "CDU AFT", "Aft CDU N. 9")
MB_339:definePushButton("AFT_CDU_N0", 1, 3276, 647, "CDU AFT", "Aft CDU N. 0")
MB_339:definePushButton("AFT_CDU_CLR", 1, 3277, 648, "CDU AFT", "Aft CDU CLR")
MB_339:definePushButton("AFT_CDU_ENT", 1, 3278, 649, "CDU AFT", "Aft CDU ENT")
MB_339:definePushButton("AFT_CDU_MODE", 1, 3279, 631, "CDU AFT", "Aft CDU MODE")
MB_339:definePushButton("AFT_CDU_STEER", 1, 3280, 632, "CDU AFT", "Aft CDU STEER")
MB_339:definePushButton("AFT_CDU_FIX", 1, 3281, 629, "CDU AFT", "Aft CDU FIX")
MB_339:definePushButton("AFT_CDU_FLT_PLN", 1, 3282, 633, "CDU AFT", "Aft CDU FLT PLN")

--Weapons
MB_339:defineToggleSwitch("WP_GND_FIRE_CVR", 1, 3283, 236, "Weapons", "Ground Fire Guard")
MB_339:defineToggleSwitch("WP_MASTER_ARM", 1, 3284, 475, "Weapons", "Master Armament")
MB_339:definePushButton("WP_JETT_SALVO", 1, 3285, 473, "Weapons", "Salvo Jettison")
MB_339:definePushButton("WP_JETT_SEL", 1, 3286, 70, "Weapons", "Selective Jettison")
MB_339:define3PosTumb("WP_BOMB_FUZE", 1, 3287, 494, "Weapons", "Bomb Fuze")
MB_339:defineToggleSwitch("WP_SEQUENCE", 1, 3288, 495, "Weapons", "Sequence Ripple/Single")
MB_339:defineToggleSwitch("WP_STAT1", 1, 3289, 488, "Weapons", "Station 1")
MB_339:defineToggleSwitch("WP_STAT2", 1, 3290, 489, "Weapons", "Station 2")
MB_339:defineToggleSwitch("WP_STAT3", 1, 3291, 490, "Weapons", "Station 3")
MB_339:defineToggleSwitch("WP_STAT4", 1, 3292, 491, "Weapons", "Station 4")
MB_339:defineToggleSwitch("WP_STAT5", 1, 3293, 492, "Weapons", "Station 5")
MB_339:defineToggleSwitch("WP_STAT6", 1, 3294, 493, "Weapons", "Station 6")
MB_339:defineToggleSwitch("WP_GND_FIRE", 1, 3295, 506, "Weapons", "Ground Fire")
MB_339:defineToggleSwitch("WP_MASTER_ARM_INIB_CVR", 1, 3296, 169, "Weapons", "Master Arm Inib Guard")
MB_339:defineToggleSwitch("WP_MASTER_ARM_INIB", 1, 3297, 170, "Weapons", "Master Arm Inib")

MB_339:defineFloat("WP_STAT1_G", 69, { 0, 1 }, "Weapons Gauges", "Station 1 Drum")
MB_339:defineFloat("WP_STAT2_G", 68, { 0, 1 }, "Weapons Gauges", "Station 2 Drum")
MB_339:defineFloat("WP_STAT3_G", 67, { 0, 1 }, "Weapons Gauges", "Station 3 Drum")
MB_339:defineFloat("WP_STAT4_G", 66, { 0, 1 }, "Weapons Gauges", "Station 4 Drum")
MB_339:defineFloat("WP_STAT5_G", 65, { 0, 1 }, "Weapons Gauges", "Station 5 Drum")
MB_339:defineFloat("WP_STAT6_G", 64, { 0, 1 }, "Weapons Gauges", "Station 6 Drum")
MB_339:defineFloat("WP_SEQU_G", 161, { 0, 1 }, "Weapons Gauges", "Sequence Drum")
MB_339:defineFloat("WP_BOMB_FUZE_G", 162, { -1, 1 }, "Weapons Gauges", "Bomb Fuze Drum")

MB_339:defineIndicatorLight("WP_MASTER_ARM_L", 163, "Weapons Lights", "Master Arm Light (red)")
MB_339:defineIndicatorLight("WP_STAT1_L", 496, "Weapons Lights", "Station 1 Light (green)")
MB_339:defineIndicatorLight("WP_STAT2_L", 497, "Weapons Lights", "Station 2 Light (green)")
MB_339:defineIndicatorLight("WP_STAT3_L", 498, "Weapons Lights", "Station 3 Light (green)")
MB_339:defineIndicatorLight("WP_STAT4_L", 499, "Weapons Lights", "Station 4 Light (green)")
MB_339:defineIndicatorLight("WP_STAT5_L", 500, "Weapons Lights", "Station 5 Light (green)")
MB_339:defineIndicatorLight("WP_STAT6_L", 501, "Weapons Lights", "Station 6 Light (green)")

--Gunsight
MB_339:define3PosTumb("GUN_PWR", 1, 3298, 478, "Gunsight", "Gunsight Power")
MB_339:definePotentiometer("GUN_BRIGHT", 1, 3300, 479, { 0, 1 }, "Gunsight", "Gunsight Brightness")
MB_339:definePushButton("GUN_TEST", 1, 3301, 480, "Gunsight", "Gunsight Test")
MB_339:defineMultipositionSwitch("GUN_DEP_100", 1, 3302, 481, 10, 0.1, "Gunsight", "Gunsight Depression reticle x 100")
MB_339:defineMultipositionSwitch("GUN_DEP_10", 1, 3303, 482, 10, 0.1, "Gunsight", "Gunsight Depression reticle x 10")
MB_339:defineMultipositionSwitch("GUN_DEP_1", 1, 3304, 483, 10, 0.1, "Gunsight", "Gunsight Depression reticle x 1")

MB_339:defineIndicatorLightInverted("FW_GUN_PRE_G", 477, "Gunsight Gauges", "Forward Gunsight Present")
MB_339:defineFloat("FW_CAM_IND_G", 708, { 0, 1 }, "Gunsight Gauges", "Forward Camera Indicator")
MB_339:defineIndicatorLight08("FW_CAM_PRE_G", 954, "Gunsight Gauges", "Forward Camera Present")

--VOR
MB_339:definePotentiometer("FW_VOR_FREQU_1MHZ", 1, 3307, 563, { 0, 1 }, "VOR FW", "Forward VOR Frequency 1MHz")
MB_339:definePotentiometer("FW_VOR_FREQU_50KHZ", 1, 3308, 564, { 0, 1 }, "VOR FW", "Forward VOR Frequency 50 kHz")
MB_339:definePushButton("FW_VOR_TEST", 1, 3309, 561, "VOR FW", "Forward VOR Frequency Test")
MB_339:defineToggleSwitch("FW_VOR_PW", 1, 3310, 562, "VOR FW", "Forward VOR Frequency Power Switch")

MB_339:definePotentiometer("AFT_VOR_FREQU_1MHZ", 1, 3311, 539, { 0, 1 }, "VOR AFT", "Aft VOR Frequency 1MHz")
MB_339:definePotentiometer("AFT_VOR_FREQU_50KHZ", 1, 3312, 34, { 0, 1 }, "VOR AFT", "Aft VOR Frequency 50 kHz")
MB_339:definePushButton("AFT_VOR_TEST", 1, 3313, 537, "VOR AFT", "Aft VOR Frequency Test")
MB_339:defineToggleSwitch("AFT_VOR_PW", 1, 3314, 538, "VOR AFT", "Aft VOR Frequency Power Switch")

MB_339:defineFloat("FW_VOR_1000", 565, { 0, 1 }, "VOR Gauges", "Forward VOR Frequency 1000")
MB_339:defineFloat("FW_VOR_100", 566, { 0, 1 }, "VOR Gauges", "Forward VOR Frequency 100")
MB_339:defineFloat("FW_VOR_10", 567, { 0, 1 }, "VOR Gauges", "Forward VOR Frequency 10")
MB_339:defineFloat("FW_VOR_1", 568, { 0, 1 }, "VOR Gauges", "Forward VOR Frequency 1")

MB_339:defineFloat("AFT_VOR_1000", 35, { 0, 1 }, "VOR Gauges", "Aft VOR Frequency 1000")
MB_339:defineFloat("AFT_VOR_100", 36, { 0, 1 }, "VOR Gauges", "Aft VOR Frequency 100")
MB_339:defineFloat("AFT_VOR_10", 37, { 0, 1 }, "VOR Gauges", "Aft VOR Frequency 10")
MB_339:defineFloat("AFT_VOR_1", 38, { 0, 1 }, "VOR Gauges", "Aft VOR Frequency 1")

--TACAN
MB_339:defineMultipositionSwitch("FW_TCN_MODE", 1, 3315, 569, 5, 0.25, "TACAN FW", "Forward TACAN Mode")
MB_339:defineToggleSwitch("FW_TCN_XY", 1, 3316, 552, "TACAN FW", "Forward TACAN X/Y Switch")
MB_339:defineMultipositionSwitch("FW_TCN_1", 1, 3317, 553, 10, 0.1, "TACAN FW", "Forward TACAN Units")
MB_339:defineMultipositionSwitch("FW_TCN_10", 1, 3318, 554, 13, 0.08333, "TACAN FW", "Forward TACAN Tens")
MB_339:definePushButton("FW_TCN_TEST", 1, 3319, 555, "TACAN FW", "Forward TACAN Test")

MB_339:defineMultipositionSwitch("AFT_TCN_MODE", 1, 3320, 571, 5, 0.25, "TACAN AFT", "Aft TACAN Mode")
MB_339:defineToggleSwitch("AFT_TCN_XY", 1, 3321, 572, "TACAN AFT", "Aft TACAN X/Y Switch")
MB_339:defineMultipositionSwitch("AFT_TCN_1", 1, 3322, 573, 10, 0.1, "TACAN AFT", "Aft TACAN Units")
MB_339:defineMultipositionSwitch("AFT_TCN_10", 1, 3323, 574, 13, 0.08333, "TACAN AFT", "Aft TACAN Tens")
MB_339:definePushButton("AFT_TCN_TEST", 1, 3324, 575, "TACAN AFT", "Aft TACAN Test")

MB_339:defineIndicatorLight("FW_TCN_TEST_L", 556, "TACAN Lights", "Forward TACAN Test Light (red)")
MB_339:defineIndicatorLight("AFT_TCN_TEST_L", 576, "TACAN Lights", "Aft TACAN Test Light (red)")

MB_339:defineFloat("FW_TCN_XY_G", 557, { 0, 1 }, "TACAN Gauges", "Forward TACAN X/Y Drum")
MB_339:defineFloat("FW_TCN_1_G", 558, { 0, 1 }, "TACAN Gauges", "Forward TACAN 1 Drum")
MB_339:defineFloat("FW_TCN_10_G", 559, { 0, 1 }, "TACAN Gauges", "Forward TACAN 10 Drum")
MB_339:defineFloat("FW_TCN_100_G", 560, { 0, 1 }, "TACAN Gauges", "Forward TACAN 100 Drum")
MB_339:defineFloat("AFT_TCN_XY_G", 577, { 0, 1 }, "TACAN Gauges", "Aft TACAN X/Y Drum")
MB_339:defineFloat("AFT_TCN_1_G", 578, { 0, 1 }, "TACAN Gauges", "Aft TACAN 1 Drum")
MB_339:defineFloat("AFT_TCN_10_G", 579, { 0, 1 }, "TACAN Gauges", "Aft TACAN 10 Drum")
MB_339:defineFloat("AFT_TCN_100_G", 580, { 0, 1 }, "TACAN Gauges", "Aft TACAN 100 Drum")

--Comm1
MB_339:defineMultipositionSwitch("FW_COM1_FUNC", 1, 3325, 664, 4, 0.33, "Comm1 FW", "Forward Comm 1 Function")
MB_339:defineMultipositionSwitch("FW_COM1_MODE", 1, 3326, 665, 3, 0.50, "Comm1 FW", "Forward Comm 1 Mode")
MB_339:defineMultipositionSwitch("FW_COM1_FREQU_1", 1, 3327, 678, 4, 0.33, "Comm1 FW", "Forward Comm 1 Frequency xxxx1")
MB_339:defineMultipositionSwitch("FW_COM1_FREQU_10", 1, 3328, 677, 10, 0.111, "Comm1 FW", "Forward Comm 1 Frequency xxx1x")
MB_339:defineMultipositionSwitch("FW_COM1_FREQU_100", 1, 3329, 676, 10, 0.111, "Comm1 FW", "Forward Comm 1 Frequency xx1xx")
MB_339:defineMultipositionSwitch("FW_COM1_FREQU_1000", 1, 3330, 675, 10, 0.111, "Comm1 FW", "Forward Comm 1 Frequency x1xxx")
MB_339:defineMultipositionSwitch("FW_COM1_FREQU_10000", 1, 3331, 674, 2, 1, "Comm1 FW", "Forward Comm 1 Frequency 1xxxx")
MB_339:defineToggleSwitch("FW_COM1_SQUELCH", 1, 3332, 173, "Comm1 FW", "Forward Comm 1 Squelch")
MB_339:definePushButton("FW_COM1_TONE", 1, 3333, 175, "Comm1 FW", "Forward Comm 1 Tone")
MB_339:definePushButton("FW_COM1_MEM", 1, 3334, 679, "Comm1 FW", "Forward Comm 1 Mem")
MB_339:defineMultipositionSwitch("FW_COM1_CHAN", 1, 3335, 673, 20, 0.0526, "Comm1 FW", "Forward Comm 1 Channel")

MB_339:defineMultipositionSwitch("AFT_COM1_FUNC", 1, 3336, 279, 4, 0.33, "Comm1 AFT", "Aft Comm 1 Function")
MB_339:defineMultipositionSwitch("AFT_COM1_MODE", 1, 3337, 280, 3, 0.50, "Comm1 AFT", "Aft Comm 1 Mode")
MB_339:defineMultipositionSwitch("AFT_COM1_FREQU_1", 1, 3338, 526, 4, 0.33, "Comm1 AFT", "Aft Comm 1 Frequency xxxx1")
MB_339:defineMultipositionSwitch("AFT_COM1_FREQU_10", 1, 3339, 525, 10, 0.111, "Comm1 AFT", "Aft Comm 1 Frequency xxx1x")
MB_339:defineMultipositionSwitch("AFT_COM1_FREQU_100", 1, 3340, 524, 10, 0.111, "Comm1 AFT", "Aft Comm 1 Frequency xx1xx")
MB_339:defineMultipositionSwitch("AFT_COM1_FREQU_1000", 1, 3341, 523, 10, 0.111, "Comm1 AFT", "Aft Comm 1 Frequency x1xxx")
MB_339:defineMultipositionSwitch("AFT_COM1_FREQU_10000", 1, 3342, 522, 2, 1, "Comm1 AFT", "Aft Comm 1 Frequency 1xxxx")
MB_339:defineToggleSwitch("AFT_COM1_SQUELCH", 1, 3343, 174, "Comm1 AFT", "Aft Comm 1 Squelch")
MB_339:definePushButton("AFT_COM1_TONE", 1, 3344, 176, "Comm1 AFT", "Aft Comm 1 Tone")
MB_339:definePushButton("AFT_COM1_MEM", 1, 3345, 527, "Comm1 AFT", "Aft Comm 1 Mem")
MB_339:defineMultipositionSwitch("AFT_COM1_CHAN", 1, 3346, 521, 20, 0.0526, "Comm1 AFT", "Aft Comm 1 Channel")

--Comm2
MB_339:defineMultipositionSwitch("FW_COM2_MODE", 1, 3347, 650, 5, 0.25, "Comm2 FW", "Forward Comm 2 Mode")
MB_339:defineMultipositionSwitch("FW_COM2_FUNC", 1, 3348, 651, 5, 0.25, "Comm2 FW", "Forward Comm 2 Function")
MB_339:definePotentiometer("FW_COM2_BRIGHT", 1, 3349, 652, { 0, 1 }, "Comm2 FW", "Forward Comm 2 Brightness")
MB_339:defineSpringloaded_3PosTumb("FW_COM2_CHN_1", 1, 3350, 3351, 654, "Comm2 FW", "Forward Comm 2 Channel x1")
MB_339:defineSpringloaded_3PosTumb("FW_COM2_CHN_10", 1, 3352, 3353, 655, "Comm2 FW", "Forward Comm 2 Channel 1x")
MB_339:defineSpringloaded_3PosTumb("FW_COM2_FREQU_1", 1, 3354, 3355, 656, "Comm2 FW", "Forward Comm 2 Frequency xxxx1")
MB_339:defineSpringloaded_3PosTumb("FW_COM2_FREQU_10", 1, 3356, 3357, 657, "Comm2 FW", "Forward Comm 2 Frequency xxx1x")
MB_339:defineSpringloaded_3PosTumb("FW_COM2_FREQU_100", 1, 3358, 3359, 658, "Comm2 FW", "Forward Comm 2 Frequency xx1xx")
MB_339:defineSpringloaded_3PosTumb("FW_COM2_FREQU_1000", 1, 3360, 3361, 659, "Comm2 FW", "Forward Comm 2 Frequency x1xxx")
MB_339:defineSpringloaded_3PosTumb("FW_COM2_FREQU_10000", 1, 3362, 3363, 660, "Comm2 FW", "Forward Comm 2 Frequency 1xxxx")
MB_339:defineSpringloaded_3PosTumb("FW_COM2_SQUELCH", 1, 3364, 3364, 662, "Comm2 FW", "Forward Comm 2 Squelch")
MB_339:defineToggleSwitch("FW_COM2_MOD", 1, 3366, 661, "Comm2 FW", "Forward Comm 2 Modulation")
MB_339:defineToggleSwitch("FW_COM2_TOD", 1, 3367, 663, "Comm2 FW", "Forward Comm 2 TOD")

MB_339:defineMultipositionSwitch("AFT_COM2_MODE", 1, 3368, 290, 5, 0.25, "Comm2 AFT", "Aft Comm 2 Mode")
MB_339:defineMultipositionSwitch("AFT_COM2_FUNC", 1, 3369, 291, 5, 0.25, "Comm2 AFT", "Aft Comm 2 Function")
MB_339:definePotentiometer("AFT_COM2_BRIGHT", 1, 3370, 292, { 0, 1 }, "Comm2 AFT", "Aft Comm 2 Brightness")
MB_339:defineSpringloaded_3PosTumb("AFT_COM2_CHN_1", 1, 3371, 3372, 294, "Comm2 AFT", "Aft Comm 2 Channel x1")
MB_339:defineSpringloaded_3PosTumb("AFT_COM2_CHN_10", 1, 3373, 3374, 295, "Comm2 AFT", "Aft Comm 2 Channel 1x")
MB_339:defineSpringloaded_3PosTumb("AFT_COM2_FREQU_1", 1, 3375, 3376, 296, "Comm2 AFT", "Aft Comm 2 Frequency xxxx1")
MB_339:defineSpringloaded_3PosTumb("AFT_COM2_FREQU_10", 1, 3377, 3378, 297, "Comm2 AFT", "Aft Comm 2 Frequency xxx1x")
MB_339:defineSpringloaded_3PosTumb("AFT_COM2_FREQU_100", 1, 3379, 3380, 154, "Comm2 AFT", "Aft Comm 2 Frequency xx1xx")
MB_339:defineSpringloaded_3PosTumb("AFT_COM2_FREQU_1000", 1, 3381, 3382, 155, "Comm2 AFT", "Aft Comm 2 Frequency x1xxx")
MB_339:defineSpringloaded_3PosTumb("AFT_COM2_FREQU_10000", 1, 3383, 3384, 156, "Comm2 AFT", "Aft Comm 2 Frequency 1xxxx")
MB_339:defineSpringloaded_3PosTumb("AFT_COM2_SQUELCH", 1, 3385, 3385, 158, "Comm2 AFT", "Aft Comm 2 Squelch")
MB_339:defineToggleSwitch("AFT_COM2_MOD", 1, 3387, 157, "Comm2 AFT", "Aft Comm 2 Modulation")
MB_339:defineToggleSwitch("AFT_COM2_TOD", 1, 3388, 159, "Comm2 AFT", "Aft Comm 2 TOD")

MB_339:defineIndicatorLight("FW_COM2_FAIL_L", 653, "Comm2 Lights", "Forward Comm 2 FAIL Light (red)")
MB_339:defineIndicatorLight("AFT_COM2_FAIL_L", 293, "Comm2 Lights", "Aft Comm 2 FAIL Light (red)")

--ICS
MB_339:defineToggleSwitch("FW_ICS_COM1_SW", 1, 3389, 115, "ICS FW", "Forward ICS COM1 Switch")
MB_339:definePotentiometer("FW_ICS_COM1_VOL", 1, 3390, 116, { 0, 1 }, "ICS FW", "Forward ICS COM1 Volume")
MB_339:defineToggleSwitch("FW_ICS_COM2_SW", 1, 3391, 117, "ICS FW", "Forward ICS COM2 Switch")
MB_339:definePotentiometer("FW_ICS_COM2_VOL", 1, 3392, 118, { 0, 1 }, "ICS FW", "Forward ICS COM2 Volume")
MB_339:defineToggleSwitch("FW_ICS_TCN_SW", 1, 3393, 119, "ICS FW", "Forward ICS TACAN Switch")
MB_339:definePotentiometer("FW_ICS_TCN_VOL", 1, 3394, 120, { 0, 1 }, "ICS FW", "Forward ICS TACAN Volume")
MB_339:defineToggleSwitch("FW_ICS_VORLOC_SW", 1, 3395, 121, "ICS FW", "Forward ICS VOR/LOC Switch")
MB_339:definePotentiometer("FW_ICS_VORLOC_VOL", 1, 3396, 122, { 0, 1 }, "ICS FW", "Forward ICS VOR/LOC Volume")
MB_339:defineToggleSwitch("FW_ICS_ADF_SW", 1, 3397, 123, "ICS FW", "Forward ICS ADF Switch")
MB_339:definePotentiometer("FW_ICS_ADF_VOL", 1, 3398, 124, { 0, 1 }, "ICS FW", "Forward ICS ADF Volume")
MB_339:defineToggleSwitch("FW_ICS_MARK_SW", 1, 3399, 125, "ICS FW", "Forward ICS Markers Switch")
MB_339:definePotentiometer("FW_ICS_MARK_VOL", 1, 3400, 126, { 0, 1 }, "ICS FW", "Forward ICS Markers Volume")
MB_339:defineToggleSwitch("FW_ICS_INTPH_SW", 1, 3401, 127, "ICS FW", "Forward ICS Interphone Switch")
MB_339:definePotentiometer("FW_ICS_INTPH_VOL", 1, 3402, 128, { 0, 1 }, "ICS FW", "Forward ICS Interphone Volume")
MB_339:definePotentiometer("FW_ICS_MASTER_VOL", 1, 3403, 129, { 0, 1 }, "ICS FW", "Forward ICS Master Volume")
MB_339:definePushButton("FW_ICS_CALL", 1, 3404, 130, "ICS FW", "Forward ICS Call Switch")
MB_339:defineToggleSwitch("FW_ICS_RADIO_SEL", 1, 3405, 131, "ICS FW", "Forward ICS COM1/COM2 TX Selector")

MB_339:defineToggleSwitch("AFT_ICS_COM1_SW", 1, 3406, 132, "ICS AFT", "Aft ICS COM1 Switch")
MB_339:definePotentiometer("AFT_ICS_COM1_VOL", 1, 3407, 133, { 0, 1 }, "ICS AFT", "Aft ICS COM1 Volume")
MB_339:defineToggleSwitch("AFT_ICS_COM2_SW", 1, 3408, 134, "ICS AFT", "Aft ICS COM2 Switch")
MB_339:definePotentiometer("AFT_ICS_COM2_VOL", 1, 3409, 135, { 0, 1 }, "ICS AFT", "Aft ICS COM2 Volume")
MB_339:defineToggleSwitch("AFT_ICS_TCN_SW", 1, 3410, 136, "ICS AFT", "Aft ICS TACAN Switch")
MB_339:definePotentiometer("AFT_ICS_TCN_VOL", 1, 3411, 137, { 0, 1 }, "ICS AFT", "Aft ICS TACAN Volume")
MB_339:defineToggleSwitch("AFT_ICS_VORLOC_SW", 1, 3412, 138, "ICS AFT", "Aft ICS VOR/LOC Switch")
MB_339:definePotentiometer("AFT_ICS_VORLOC_VOL", 1, 3413, 139, { 0, 1 }, "ICS AFT", "Aft ICS VOR/LOC Volume")
MB_339:defineToggleSwitch("AFT_ICS_ADF_SW", 1, 3414, 140, "ICS AFT", "Aft ICS ADF Switch")
MB_339:definePotentiometer("AFT_ICS_ADF_VOL", 1, 3415, 141, { 0, 1 }, "ICS AFT", "Aft ICS ADF Volume")
MB_339:defineToggleSwitch("AFT_ICS_MARK_SW", 1, 3416, 142, "ICS AFT", "Aft ICS Markers Switch")
MB_339:definePotentiometer("AFT_ICS_MARK_VOL", 1, 3417, 143, { 0, 1 }, "ICS AFT", "Aft ICS Markers Volume")
MB_339:defineToggleSwitch("AFT_ICS_INTPH_SW", 1, 3418, 144, "ICS AFT", "Aft ICS Interphone Switch")
MB_339:definePotentiometer("AFT_ICS_INTPH_VOL", 1, 3419, 145, { 0, 1 }, "ICS AFT", "Aft ICS Interphone Volume")
MB_339:definePotentiometer("AFT_ICS_MASTER_VOL", 1, 3420, 146, { 0, 1 }, "ICS AFT", "Aft ICS Master Volume")
MB_339:definePushButton("AFT_ICS_CALL", 1, 3421, 147, "ICS AFT", "Aft ICS Call Switch")
MB_339:defineToggleSwitch("AFT_ICS_RADIO_SEL", 1, 3422, 148, "ICS AFT", "Aft ICS COM1/COM2 TX Selector")

--Oxygen
MB_339:defineToggleSwitch("FW_OXY_PW", 1, 3423, 587, "Oxygen FW", "Forward Oxygen Power Supply")
MB_339:defineToggleSwitch("FW_OXY_DILUIT", 1, 3424, 589, "Oxygen FW", "Forward Oxygen Diluiter Lever (Normal / 100%)")
MB_339:defineToggleSwitch("FW_OXY_EMERG", 1, 3425, 588, "Oxygen FW", "Forward Oxygen Emergency Lever")

MB_339:defineToggleSwitch("AFT_OXY_PW", 1, 3426, 113, "Oxygen AFT", "Aft Oxygen Power Supply")
MB_339:defineToggleSwitch("AFT_OXY_DILUIT", 1, 3426, 113, "Oxygen AFT", "Aft Oxygen Diluiter Lever (Normal / 100%)")
MB_339:defineToggleSwitch("AFT_OXY_EMERG", 1, 3428, 111, "Oxygen AFT", "Aft Oxygen Emergency Lever")

MB_339:defineFloat("FW_OXY_FLOW_G", 306, { 0, 1 }, "Oxygen Gauges", "Forward Oxygen Indicator")
MB_339:defineFloat("AFT_OXY_FLOW_G", 180, { 0, 1 }, "Oxygen Gauges", "Aft Oxygen Indicator")

--Cockpit
MB_339:definePushButton("FW_GLOVE_COMP", 1, 3429, 206, "Cockpit", "Forward Glove Compartment")
MB_339:defineToggleSwitch("FW_CANOPY_SEVERANCE_LVR", 1, 3209, 583, "Cockpit", "Forward Canopy Severance Handle")
MB_339:defineToggleSwitch("FW_CANOPY_SEVERANCE_PIN", 1, 3210, 584, "Cockpit", "Forward Canopy Severance Safety Pin")

MB_339:definePushButton("AFT_GLOVE_COMP", 1, 3430, 207, "Cockpit", "Aft Glove Compartment")
MB_339:defineToggleSwitch("AFT_CANOPY_SEVERANCE_LVR", 1, 3211, 741, "Cockpit", "Aft Canopy Severance Handle")
MB_339:defineToggleSwitch("AFT_CANOPY_SEVERANCE_PIN", 1, 3212, 742, "Cockpit", "Aft Canopy Severance Safety Pin")

MB_339:defineToggleSwitch("CURTAIN_HANDLE", 1, 3431, 1999, "Cockpit", "Curtain Handle")

MB_339:defineFloat("CANOPY_POS_G", 181, { 0, 1 }, "Cockpit Gauges", "Canopy Position")
MB_339:defineFloat("FW_MIRROR_POS_G", 400, { 0, 1 }, "Cockpit Gauges", "Forward Mirror Position")
MB_339:defineFloat("AFT_MIRROR_POS_G", 594, { 0, 1 }, "Cockpit Gauges", "Aft Mirror Position")
MB_339:defineIndicatorLight("CURTAIN_G", 1998, "Cockpit Gauges", "Curtain Present")
MB_339:defineFloat("CURTAIN_POS_G", 1999, { 0, 1 }, "Cockpit Gauges", "Curtain Position")

--ELT
MB_339:defineSpringloaded_3PosTumb("ELT_SW", 1, 3432, 3432, 727, "ELT", "ELT Switch")

MB_339:defineIndicatorLight("ELT_L", 740, "ELT Lights", "ELT Light (red)")

--IFF
MB_339:defineMultipositionSwitch("IFF_MASTER", 1, 3434, 714, 5, 0.25, "IFF", "IFF Master")
MB_339:defineMultipositionSwitch("IFF_CODE", 1, 3435, 713, 5, 0.25, "IFF", "IFF Code")
MB_339:define3PosTumb("IFF_ANT", 1, 3436, 715, "IFF", "IFF ANT Switch")
MB_339:define3PosTumb("IFF_M4_CONT", 1, 3437, 710, "IFF", "IFF Mode 4 Control")
MB_339:define3PosTumb("IFF_M4_AUDIO", 1, 3438, 711, "IFF", "IFF Mode 4 Audio")
MB_339:definePushButton("IFF_RAD", 1, 3439, 716, "IFF", "IFF RAD Switch")
MB_339:define3PosTumb("IFF_M1_CONT", 1, 3440, 720, "IFF", "IFF Mode 1 Control")
MB_339:define3PosTumb("IFF_M2_CONT", 1, 3441, 719, "IFF", "IFF Mode 2 Control")
MB_339:define3PosTumb("IFF_M3A_CONT", 1, 3442, 718, "IFF", "IFF Mode 3/A Control")
MB_339:define3PosTumb("IFF_M3C_CONT", 1, 3443, 717, "IFF", "IFF Mode 3/C Control")
MB_339:defineSpringloaded_3PosTumb("IFF_IDENT_MIC", 1, 3444, 3444, 712, "IFF", "IFF IDENT-MIC Switch")
MB_339:definePushButton("IFF_CODE_SW_1", 1, 3446, 734, "IFF", "IFF Code Switch 1")
MB_339:definePushButton("IFF_CODE_SW_2", 1, 3447, 735, "IFF", "IFF Code Switch 2")
MB_339:definePushButton("IFF_CODE_SW_3", 1, 3448, 736, "IFF", "IFF Code Switch 3")
MB_339:definePushButton("IFF_CODE_SW_4", 1, 3449, 737, "IFF", "IFF Code Switch 4")
MB_339:definePushButton("IFF_CODE_SW_5", 1, 3450, 738, "IFF", "IFF Code Switch 5")
MB_339:definePushButton("IFF_CODE_SW_6", 1, 3451, 739, "IFF", "IFF Code Switch 6")
MB_339:definePushButton("IFF_TEST_GO", 1, 3452, 743, "IFF", "IFF Test Switch GO")
MB_339:definePushButton("IFF_TEST_NOGO", 1, 3453, 744, "IFF", "IFF Test Switch NOGO")
MB_339:definePushButton("IFF_TEST_REPLY", 1, 3454, 745, "IFF", "IFF Test Switch REPLY")

MB_339:defineFloat("IFF_MODE_10_G", 728, { 0, 1 }, "IFF Gauges", "IFF Mode 10 Drum")
MB_339:defineFloat("IFF_MODE_1_G", 729, { 0, 1 }, "IFF Gauges", "IFF Mode 1 Drum")
MB_339:defineFloat("IFF_MODE3A_1000_G", 730, { 0, 1 }, "IFF Gauges", "IFF Mode 3/A 1000 Drum")
MB_339:defineFloat("IFF_MODE3A_100_G", 731, { 0, 1 }, "IFF Gauges", "IFF Mode 3/A 100 Drum")
MB_339:defineFloat("IFF_MODE3A_10_G", 732, { 0, 1 }, "IFF Gauges", "IFF Mode 3/A 10 Drum")
MB_339:defineFloat("IFF_MODE3A_1_G", 733, { 0, 1 }, "IFF Gauges", "IFF Mode 3/A 1 Drum")

MB_339:defineIndicatorLight("IFF_TEST_GO_L", 724, "IFF Lights", "IFF Test Switch GO Light (green)")
MB_339:defineIndicatorLight("IFF_TEST_NOGO_L", 725, "IFF Lights", "IFF Test Switch NOGO Light (red)")
MB_339:defineIndicatorLight("IFF_TEST_REPLY_L", 726, "IFF Lights", "IFF Test Switch REPLY Light (green)")
MB_339:defineIndicatorLight("IFF_ALT_L", 724, "IFF Lights", "IFF ALT Light (red)")
MB_339:defineIndicatorLight("IFF_KIT_L", 725, "IFF Lights", "IFF KIT Light (red)")
MB_339:defineIndicatorLight("IFF_ANT_L", 726, "IFF Lights", "IFF ANT Light (red)")

--Externals
MB_339:defineFloatFromDrawArgument("EXT_SPEED_BRAKE", 21, "External Aircraft Model", "Speed Brake")
MB_339:defineBitFromDrawArgument("EXT_POSITION_LIGHTS", 191, "External Aircraft Model", "Position Lights (red+green)")
MB_339:defineBitFromDrawArgument("EXT_STROBE_TAIL", 192, "External Aircraft Model", "Tail Strobe Light (red)")
MB_339:defineFloatFromDrawArgument("EXT_FORMATION_LIGHTS", 200, "External Aircraft Model", "Formation Lights (light green)")
MB_339:defineBitFromDrawArgument("EXT_BOTTOM_LIGHT", 201, "External Aircraft Model", "Middle Bottom Light (white)")
MB_339:defineBitFromDrawArgument("EXT_TOP_LIGHT", 202, "External Aircraft Model", "Top Light (white)")
MB_339:defineBitFromDrawArgument("EXT_TAIL_LIGHT", 203, "External Aircraft Model", "Tail Light (white)")
MB_339:defineBitFromDrawArgument("EXT_FRONT_LANDLIGHT", 208, "External Aircraft Model", "Front Landing Light (white)")
MB_339:defineBitFromDrawArgument("EXT_WING_LANDLIGHT", 209, "External Aircraft Model", "Wing Landing Light (white)")
MB_339:defineBitFromDrawArgument("EXT_WOW_NOSE", 1, "External Aircraft Model", "Weight ON Wheels Nose Gear")
MB_339:defineBitFromDrawArgument("EXT_WOW_RIGHT", 4, "External Aircraft Model", "Weight ON Wheels Right Gear")
MB_339:defineBitFromDrawArgument("EXT_WOW_LEFT", 6, "External Aircraft Model", "Weight ON Wheels Left Gear")

MB_339:defineReadWriteRadio("FWD_COMM1", 6, 7, 3, 1000, "Forward COMM1")
MB_339:defineReadWriteRadio("FWD_COMM2", 7, 7, 3, 1000, "Forward COMM2")
MB_339:defineReadWriteRadio("AFT_COMM1", 9, 7, 3, 1000, "Aft COMM1")
MB_339:defineReadWriteRadio("AFT_COMM2", 10, 7, 3, 1000, "Aft COMM2")

-- GunsightRepeater
MB_339:define3PosTumb("GUN_REP_PWR", 1, 3305, 409, "Gunsight Repeater", "Gunsight Repeater Power")
MB_339:definePotentiometer("GUN_REP_BRIGHT", 1, 3306, 408, { 0, 1 }, "Gunsight Repeater", "Gunsight Repeater Brightness")

return MB_339
