dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua")
--[[ 
DCS World F16C modified Macro_sequencies.lua for quicker starts
Modded by Korwiin 5/23/2025 for DCS version 2.9.16.10523 and later. 
Credit to https://youtube.com/shorts/MdoB-m5iQm8?si=XOJpgzpmysVmXFXC

v.1 5/23/2025 
	- Initial Release.
v.2 5/24/2025 
	- Reordered to start INS alignment after engine fully starts and passes idle check. 
	- Noted in comments which settings are personal preferences.

]]
-- timeouts and delays
std_message_timeout = 15

local	t_start	= 0.0
local	t_stop	= 0.0
local	dt		= 0.2
local	dt_mto	= 0.5
local	start_sequence_time	= 137.0
local	stop_sequence_time	= 60.0

--
start_sequence_full 	  = {}
stop_sequence_full		  = {}
cockpit_illumination_full = {}

function push_command(sequence, run_t, command)
	sequence[#sequence + 1] =  command
	sequence[#sequence]["time"] = run_t
end

function push_start_command(delta_t, command)
	t_start = t_start + delta_t
	push_command(start_sequence_full,t_start, command)
end

function push_stop_command(delta_t, command)
	t_stop = t_stop + delta_t
	push_command(stop_sequence_full,t_stop, command)
end

--
local count = 0
local function counter()
	count = count + 1
	return count
end

-- conditions
count = -1

F16_AD_NO_FAILURE				= counter()
F16_AD_ERROR					= counter()

F16_AD_THROTTLE_SET_TO_OFF		= counter()
F16_AD_THROTTLE_AT_OFF			= counter()
F16_AD_THROTTLE_SET_TO_IDLE		= counter()
F16_AD_THROTTLE_AT_IDLE			= counter()
F16_AD_THROTTLE_DOWN_TO_IDLE	= counter()

F16_AD_JFS_READY				= counter()
F16_AD_ENG_IDLE_RPM				= counter()
F16_AD_ENG_CHECK_IDLE			= counter()
F16_AD_JFS_VERIFY_OFF			= counter()

F16_AD_INS_CHECK_RDY			= counter()

F16_AD_LEFT_HDPT_CHECK_RDY		= counter()
F16_AD_RIGHT_HDPT_CHECK_RDY 	= counter()

F16_AD_HMCS_ALIGN				= counter()
F16_AD_MIDS_PWR_ON				= counter()
F16_AD_MAV_ALIGN				= counter()

--
alert_messages = {}

alert_messages[F16_AD_ERROR]					= { message = _("FM MODEL ERROR"),							message_timeout = std_message_timeout}

alert_messages[F16_AD_THROTTLE_SET_TO_OFF]		= { message = _("THROTTLE - TO OFF"),						message_timeout = std_message_timeout}
alert_messages[F16_AD_THROTTLE_AT_OFF]			= { message = _("THROTTLE MUST BE AT OFF"),					message_timeout = std_message_timeout}
alert_messages[F16_AD_THROTTLE_SET_TO_IDLE]		= { message = _("THROTTLE - TO IDLE"),						message_timeout = std_message_timeout}
alert_messages[F16_AD_THROTTLE_AT_IDLE]			= { message = _("THROTTLE MUST BE AT IDLE"),				message_timeout = std_message_timeout}
alert_messages[F16_AD_THROTTLE_DOWN_TO_IDLE]	= { message = _("THROTTLE - TO IDLE"),						message_timeout = std_message_timeout}

alert_messages[F16_AD_JFS_READY]				= { message = _("JFS RUN LIGHT MUST BE ON WITHIN 30 SEC"),	message_timeout = std_message_timeout}
alert_messages[F16_AD_ENG_IDLE_RPM]				= { message = _("ENGINE RPM FAILURE"),						message_timeout = std_message_timeout}
alert_messages[F16_AD_ENG_CHECK_IDLE]			= { message = _("ENGINE PARAMETERS FAILURE"),				message_timeout = std_message_timeout}
alert_messages[F16_AD_JFS_VERIFY_OFF]			= { message = _("JFS MUST BE OFF"),							message_timeout = std_message_timeout}

alert_messages[F16_AD_INS_CHECK_RDY]			= { message = _("INS NOT READY"),							message_timeout = std_message_timeout}

alert_messages[F16_AD_LEFT_HDPT_CHECK_RDY]		= { message = "",											message_timeout = std_message_timeout}
alert_messages[F16_AD_RIGHT_HDPT_CHECK_RDY]		= { message = "",											message_timeout = std_message_timeout}


----------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------
-- Start sequence
push_start_command(1.0,	{message = _("F16C QUICKSTART v.3 by Korwiin - RUNNING"), message_timeout = start_sequence_time})

-- Before Starting Engine
push_start_command(dt,		{device = devices.SAI,					action = sai_commands.reference,				value = 0.5})
push_start_command(dt,		{device = devices.SAI,					action = sai_commands.cage,						value = 1.0})
push_start_command(dt,		{device = devices.SAI,					action = sai_commands.reference,				value = 0.625})
push_start_command(dt,		{device = devices.SAI,					action = sai_commands.cage,						value = 0.0})
-- Battery Switch to Main Power
push_start_command(dt,		{device = devices.ELEC_INTERFACE,		action = elec_commands.MainPwrSw,				value = 1.0})
-- Jet Fuel to Start 2
push_start_command(dt,		{device = devices.ENGINE_INTERFACE,		action = engine_commands.JfsSwStart2,			value = -1.0})
push_start_command(dt,		{device = devices.ENGINE_INTERFACE,		action = engine_commands.JfsSwStart2,			value = 0.0})
push_start_command(dt,		{										check_condition = F16_AD_THROTTLE_DOWN_TO_IDLE,	message_timeout = dt_mto})
push_start_command(dt,		{										check_condition = F16_AD_THROTTLE_SET_TO_OFF,	message_timeout = dt_mto})
push_start_command(1.0,		{										check_condition = F16_AD_THROTTLE_AT_OFF,		message_timeout = dt_mto})
-- Wait for for RPM to 20%
push_start_command(dt,		{device = devices.UHF_CONTROL_PANEL,	action = uhf_commands.FunctionKnob,				value = 0.2}) -- Set to BOTH (COM1 + Guard Freq).
push_start_command(dt,		{device = devices.INTERCOM,				action = intercom_commands.COM1_ModeKnob,		value = 0.5}) -- Set SQL on
push_start_command(dt,		{device = devices.INTERCOM,				action = intercom_commands.COM2_ModeKnob,		value = 0.5}) -- Set SQL on
push_start_command(dt,		{device = devices.INTERCOM,				action = intercom_commands.COM1_PowerKnob,		value = 0.1}) -- set COM1 Volume to personal prefs
push_start_command(dt,		{device = devices.INTERCOM,				action = intercom_commands.COM2_PowerKnob,		value = 0.1}) -- set COM2 Volume to personal prefs
push_start_command(dt,		{device = devices.INTERCOM,				action = intercom_commands.TACAN_Knob,			value = 0.1}) -- lower TACAN volume on Intercom
push_start_command(dt,		{device = devices.INTERCOM,				action = intercom_commands.ILS_PowerKnob,		value = 0.1}) -- lower ILS volume on Intercom
push_start_command(dt,		{device = devices.UHF_CONTROL_PANEL,	action = uhf_commands.FreqSelector100Mhz,		value = 0.1}) -- Set COM1 to 251 Mhz for CTAF: Personal Preference
push_start_command(dt,		{device = devices.UHF_CONTROL_PANEL,	action = uhf_commands.FreqSelector10Mhz,		value = 0.5}) -- CTAF: Personal Preference
push_start_command(dt,		{device = devices.UHF_CONTROL_PANEL,	action = uhf_commands.FreqSelector1Mhz,			value = 0.1}) -- CTAF: Personal Preference

-- Throttle to Idle
push_start_command(9.0,		{								check_condition = F16_AD_JFS_READY,				message_timeout = 0.0})
for i = 0, 15, 1 do
	push_start_command(1.0,		{							check_condition = F16_AD_THROTTLE_SET_TO_IDLE,	message_timeout = 0.0})
end
-- Close and lock the Canopy
push_start_command(dt,		{device = devices.CPT_MECH,		action = cpt_commands.CanopyHandle,					value = 0.0})
push_start_command(dt,		{device = devices.CPT_MECH,		action = cpt_commands.CanopySwitchClose,			value = -1.0})
push_start_command(8.0,		{device = devices.CPT_MECH,		action = cpt_commands.CanopySwitchClose,			value = 0.0})
push_start_command(dt,		{device = devices.CPT_MECH,		action = cpt_commands.CanopyHandle,					value = 1.0})
push_start_command(dt,		{device = devices.CPT_MECH,		action = cpt_commands.EjectionSafetyLever,			value = 1.0})
-- After Engine Start
push_start_command(dt,		{								check_condition = F16_AD_THROTTLE_AT_IDLE,		message_timeout = 0.0})
push_start_command(5.0,		{								check_condition = F16_AD_JFS_VERIFY_OFF,		message_timeout = 0.0})
push_start_command(2.5,		{								check_condition = F16_AD_ENG_IDLE_RPM,			message_timeout = 0.0})
push_start_command(1.0,		{								check_condition = F16_AD_ENG_CHECK_IDLE,		message_timeout = 0.0})
-- Turn on MMC, ST STA, MFS, UFC, MAP, GPS, DataLink
push_start_command(dt,		{device = devices.MMC,					action = ecs_commands.AirSourceKnob,			value = 1.0})
push_start_command(dt,		{device = devices.SMS,					action = sms_commands.StStaSw,					value = 1.0})
push_start_command(dt,		{device = devices.MMC,					action = mmc_commands.MFD,						value = 1.0})
push_start_command(dt,		{device = devices.UFC,					action = ufc_commands.UFC_Sw,					value = 1.0})
push_start_command(dt,		{device = devices.MAP,					action = map_commands.PwrSw,					value = 1.0}) -- not modeled in game
push_start_command(dt,		{device = devices.GPS,					action = gps_commands.PwrSw,					value = 1.0})
push_start_command(dt,		{device = devices.IDM,					action = idm_commands.PwrSw,					value = 1.0})
push_start_command(dt,		{device = devices.MIDS,					action = mids_commands.PwrSw,					value = 0.1})
-- INS to Align Stored Heading
push_start_command(dt,		{message = _("- INS STORED ALIGNMENT IN PROGRESS"),										message_timeout = 91.0})
push_start_command(dt,		{device = devices.INS,					action = ins_commands.ModeKnob,					value = 0.1}) -- INS Alignment clock starts here
-- Turn on Left and Right Hardpoints, FCR, RALT, HUD ON, 
push_start_command(dt,		{device = devices.SMS,					action = sms_commands.LeftHDPT,					value = 1.0}) -- Turn on HAD
push_start_command(dt,		{device = devices.SMS,					action = sms_commands.RightHDPT,				value = 1.0}) -- Turn on TGP
push_start_command(dt,		{device = devices.FCR,					action = fcr_commands.PwrSw,					value = 1.0})
push_start_command(dt,		{device = devices.RALT,					action = ralt_commands.PwrSw,					value = 1.0})
push_start_command(dt,		{device = devices.UFC,					action = ufc_commands.SYM_Knob,					value = 0.5})
-- Uncage Attitude Indicator
push_start_command(dt,		{device = devices.SAI,					action = sai_commands.reference,				value = 0.5})
push_start_command(dt,		{device = devices.SAI,					action = sai_commands.reference,				value = 0.52})
-- Altimeter Elec
push_start_command(dt,		{device = devices.AAU34,		action = alt_commands.ELEC,							value = -1.0})
push_start_command(2.0,		{device = devices.AAU34,		action = alt_commands.ELEC,							value = 0.0})
-- RWR On
push_start_command(dt,		{device = devices.RWR,			action = rwr_commands.Power,						value = 1.0})
-- Turn On CMDS - RWR, JMR, Chaff, Flare
push_start_command(dt,		{device = devices.CMDS,			action = cmds_commands.RwrSrc,					value = 1.0})
push_start_command(dt,		{device = devices.CMDS,			action = cmds_commands.JmrSrc,					value = 1.0})
push_start_command(dt,		{device = devices.CMDS,			action = cmds_commands.MwsSrc,					value = 1.0}) -- Not modeled in game
push_start_command(dt,		{device = devices.CMDS,			action = cmds_commands.ChExp,					value = 1.0})
push_start_command(dt,		{device = devices.CMDS,			action = cmds_commands.FlExp,					value = 1.0})
push_start_command(dt,		{device = devices.CMDS,			action = cmds_commands.Prgm,					value = 0.4}) -- Set to Personal Preference
push_start_command(dt,		{device = devices.CMDS,			action = cmds_commands.Mode,					value = 0.3}) -- Set to Personal Preference
-- Skipping FLCS Built in Test
-- Leaving Datalink to default Simple Mode
-- IFF Master to Normal
push_start_command(dt,		{device = devices.IFF_CONTROL_PANEL,	action = iff_commands.MasterKnob,				value = 0.3})

-- Personal Preferences while waiting for align
push_start_command(dt,		{device = devices.EXTLIGHTS_SYSTEM,		action = extlights_commands.Master,				value = 0.0}) -- Turn Lights off: Personal Preference
push_start_command(1.0,		{device = devices.FUEL_INTERFACE,		action = fuel_commands.FuelQtySelSw,			value = 0.5}) -- Fuel Select: Personal Preference
push_start_command(dt,		{device = devices.ECM_INTERFACE,		action = ecm_commands.PwrSw,					value = 1})
push_start_command(dt,		{device = devices.ECM_INTERFACE,		action = ecm_commands.XmitSw,					value = 1})
push_start_command(dt,		{device = devices.MFD_LEFT,				action = mfd_commands.BRT_Rocker_UP,			value = 1.0})
push_start_command(2.0,		{device = devices.MFD_LEFT,				action = mfd_commands.BRT_Rocker_UP,			value = 0.0})
push_start_command(dt,		{device = devices.MFD_RIGHT,			action = mfd_commands.BRT_Rocker_UP,			value = 1.0})
push_start_command(2.0,		{device = devices.MFD_RIGHT,			action = mfd_commands.BRT_Rocker_UP,			value = 0.0})

-- When ALIGN is flashing on the HUD turn INS to NAV
push_start_command(79,		{message = _("- INS ALIGN - READY"),	check_condition = F16_AD_INS_CHECK_RDY,			message_timeout = 3.0}) -- Delay 75 is manual set, depends on timing of preceding commands 
push_start_command(dt,		{device = devices.INS,					action = ins_commands.ModeKnob,					value = 0.3})
push_start_command(dt,		{device = devices.UFC,					action = ufc_commands.DCS_RTN,					value = -1.0})
push_start_command(dt,		{device = devices.UFC,					action = ufc_commands.DCS_RTN,					value = 0.0})
-- MAV Align (Enables Datalink, ED Video forgot this step!)
push_start_command(dt,		{device = devices.SMS,					check_condition = F16_AD_MAV_ALIGN})
push_start_command(dt,		{device = devices.MIDS,					action = mids_commands.PwrSw,					value = 0.2})
-- Turn on and align HMD
push_start_command(dt,		{device = devices.HMCS,					action = hmcs_commands.IntKnob,					value = 0.8})
push_start_command(dt,		{device = devices.hmcs_commands,		check_condition = F16_AD_HMCS_ALIGN})
-- Nose Wheel Steering On
push_start_command(dt,		{device = devices.HOTAS,				action = hotas_commands.STICK_NWS_AR_DISC_MSL_STEP,		value = 1.0}) -- Turn NWS On: Personal Pref
push_start_command(dt,		{device = devices.HOTAS,				action = hotas_commands.STICK_NWS_AR_DISC_MSL_STEP,		value = 0.0}) -- Turn NWS On: Personal Pref

push_start_command(dt,		{message = _("AUTOSTART COMPLETE - Good Hunting o7"),									message_timeout = 8})

----------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------
-- Stop sequence
push_stop_command(2.0,	{message = _("AUTOSTOP SEQUENCE IS RUNNING"),	message_timeout = stop_sequence_time})
--

-- After Landing
push_stop_command(dt,		{message = _("- PROBE HEAT SWITCH - OFF"),												message_timeout = dt_mto})
push_stop_command(dt,		{device = devices.ELEC_INTERFACE,		action = elec_commands.ProbeHeatSw,				value = 0.0})
-- ECM POWER - OFF
push_stop_command(dt,		{message = _("- SPEEDBRAKES - CLOSE"),													message_timeout = dt_mto})
push_stop_command(dt,		{device = devices.HOTAS,				action = hotas_commands.THROTTLE_SPEED_BRAKE,	value = 1.0})
push_stop_command(1.5,		{device = devices.HOTAS,				action = hotas_commands.THROTTLE_SPEED_BRAKE,	value = 0.0})
push_stop_command(dt,		{message = _("- EJECTION SAFETY LEVER - SAFE (UP)"),									message_timeout = dt_mto})
push_stop_command(dt,		{device = devices.CPT_MECH,				action = cpt_commands.EjectionSafetyLever,		value = 0.0})
push_stop_command(dt,		{message = _("- IFF MASTER KNOB - STBY"),												message_timeout = dt_mto})
push_stop_command(dt,		{device = devices.IFF_CONTROL_PANEL,	action = iff_commands.MasterKnob,				value = 0.1})
push_stop_command(dt,		{message = _("- IFF M-4 CODE SWITCH - HOLD"),											message_timeout = dt_mto})
push_stop_command(dt,		{device = devices.IFF_CONTROL_PANEL,	action = iff_commands.M4CodeSw,					value = -1.0})
push_stop_command(dt,		{message = _("- CANOPY HANDLE - UP"),													message_timeout = dt_mto})
push_stop_command(dt,		{device = devices.CPT_MECH,		action = cpt_commands.CanopyHandle,						value = 0.0})

push_stop_command(dt,		{message = _("- ARMAMENT SWITCH - OFF, SAFE OR NORMAL"),								message_timeout = dt_mto})
push_stop_command(dt,		{device = devices.MMC,					action = mmc_commands.MasterArmSw,				value = 0.0})
push_stop_command(dt,		{device = devices.SMS,					action = sms_commands.LaserSw,					value = 0.0})
-- NUCLEAR CONSENT SWITCH - OFF
-- Prior to Engine Shutdown
push_stop_command(dt,		{message = _("- EPU SWITCH - OFF"),														message_timeout = dt_mto})
push_stop_command(dt,		{device = devices.ENGINE_INTERFACE,		action = engine_commands.EpuSwCvrOff,			value = 1.0})
push_stop_command(dt,		{device = devices.ENGINE_INTERFACE,		action = engine_commands.EpuSw,					value = -1.0})
-- AVTR POWER SWITCH - UNTHRD
push_stop_command(dt,		{message = _("- C&I KNOB - BACKUP"),													message_timeout = 5.0})
push_stop_command(dt,		{device = devices.IFF_CONTROL_PANEL,	action = iff_commands.CNI_Knob,					value = 0.0})
push_stop_command(5.0,		{message = _("- INS KNOB - OFF"),														message_timeout = dt_mto})
push_stop_command(dt,		{device = devices.INS,					action = ins_commands.ModeKnob,					value = 0.0})
push_stop_command(dt,		{message = _("- AVIONICS - OFF"),														message_timeout = 10.0})
push_stop_command(dt,		{device = devices.UFC,					action = ufc_commands.SYM_Knob,					value = 0.0})
push_stop_command(dt,		{device = devices.SMS,					action = sms_commands.LeftHDPT,					value = 0.0})
push_stop_command(dt,		{device = devices.SMS,					action = sms_commands.RightHDPT,				value = 0.0})
push_stop_command(dt,		{device = devices.FCR,					action = fcr_commands.PwrSw,					value = 0.0})
push_stop_command(dt,		{device = devices.RALT,					action = ralt_commands.PwrSw,					value = -1.0})
push_stop_command(dt,		{device = devices.MMC,					action = ecs_commands.AirSourceKnob,			value = 0.0})
push_stop_command(dt,		{device = devices.SMS,					action = sms_commands.StStaSw,					value = 0.0})
push_stop_command(dt,		{device = devices.MMC,					action = mmc_commands.MFD,						value = 0.0})
push_stop_command(dt,		{device = devices.UFC,					action = ufc_commands.UFC_Sw,					value = 0.0})
push_stop_command(dt,		{device = devices.MAP,					action = map_commands.PwrSw,					value = 0.0})
push_stop_command(dt,		{device = devices.GPS,					action = gps_commands.PwrSw,					value = 0.0})
push_stop_command(dt,		{device = devices.IDM,					action = idm_commands.PwrSw,					value = 0.0})
push_stop_command(dt,		{device = devices.HMCS,					action = hmcs_commands.IntKnob,					value = 0.0})
push_stop_command(dt,		{device = devices.INTERCOM,				action = intercom_commands.COM1_ModeKnob,		value = 0.0})
push_stop_command(dt,		{device = devices.INTERCOM,				action = intercom_commands.COM2_ModeKnob,		value = 0.0})
-- Engine Shutdown
push_stop_command(8.0,		{message = _("- THROTTLE - OFF"),		check_condition = F16_AD_THROTTLE_DOWN_TO_IDLE,	message_timeout = 21.0})
push_stop_command(dt,		{										check_condition = F16_AD_THROTTLE_SET_TO_OFF,	message_timeout = dt_mto})
push_stop_command(1.0,		{										check_condition = F16_AD_THROTTLE_AT_OFF,		message_timeout = dt_mto})
push_stop_command(20.0,		{message = _("- MAIN PWR SWITCH - OFF"),												message_timeout = dt_mto})
push_stop_command(dt,		{device = devices.ELEC_INTERFACE,		action = elec_commands.MainPwrSw,				value = -1.0})
push_stop_command(dt,		{message = _("- OXYGEN REGULATOR - ON AND NORM"),										message_timeout = dt_mto})
push_stop_command(dt,		{device = devices.OXYGEN_INTERFACE,		action = oxygen_commands.SupplyLever,			value = 0.5})
push_stop_command(dt,		{device = devices.OXYGEN_INTERFACE,		action = oxygen_commands.DiluterLever,			value = 0.0})
push_stop_command(dt,		{device = devices.OXYGEN_INTERFACE,		action = oxygen_commands.EmergencyLever,		value = 0.0})
push_stop_command(dt,		{message = _("- CANOPY - OPEN"),														message_timeout = 14.0})
push_stop_command(dt,		{device = devices.CPT_MECH,				action = cpt_commands.CanopySwitchOpen,			value = 1.0})
push_stop_command(14.0,		{device = devices.CPT_MECH,				action = cpt_commands.CanopySwitchOpen,			value = 0.0})

--
push_stop_command(3.0,	{message = _("AUTOSTOP COMPLETE"),	message_timeout = std_message_timeout})