--NIGHTSTORM Added AIM-9X-2, AIM-9X-3, AIM-120A, AIM-120C-7, AIM-120D, LAU-115/LAU-127 Launchers for external pylons

dofile('Scripts/Database/Weapons/warheads.lua')

function copyTable(target, src)
	for i, v in pairs(src) do
		if type(v) == 'table' then
			if not target[i] then
				target[i] = { }
			end
			copyTable(target[i], v)
		else
			target[i] = v
		end
	end
end


--*******************************************AIM-9X-2*************************************************

local AIM_9X2 = { 

	category		= CAT_AIR_TO_AIR,
	name			= _("AIM_9X2"),
	user_name		= _("AIM-9X-2"),
	wsTypeOfWeapon	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile, WSTYPE_PLACEHOLDER},
	NatoName		= "(AIM-9X2)",

	shape_table_data =
	{
		{
			name = "AIM-9X2";
			file = "AIM-9X2";
			life = 1;
			fire = { 0, 1};
			username = "AIM-9X2";	--	имя ракеты
			index = WSTYPE_PLACEHOLDER,
		},
	},

        Escort = 0,				--0-No, 1-La launch, 2-other La, 3-C ground
        Head_Type = 1,			--1-InfraredSeeker, 2-ActiveRadar, 3-AntiRadar, 4-Laserhooming, 5-Autopilot (GPS, TV, IIR), 6-SemiActiveRadar, 7-SemiAutoAT (control from platform)
		sigma = {1.01, 1.01, 1.01},		-- Sigma = {x, y, z}, maximum aiming error in meters, in target coordinates. X-longitudinal axis of the target, y-axis virtualna purpose, Z - axis, transverse target
        M = 85.5,				--Gross weight in kg
        H_max = 25000.0,		--Maximum flight altitude in meters. 18Km=59100feet 20km = 65600
        H_min = -1,				--Minimum flight height in meters.
        Diam = 127.0,			--Case Diameter in mm
        Cx_pil = 1.88,			--Cx as suspension (Drag value is assumed)
        D_max = 37000.0,		--Maximum Launch range at low altitude in meters
        D_min = 300.0,			--Minimum Launch range at low altitude in meters
        Head_Form = 0,			--False - hemispherical head shape / True-animate (~conic)
        Life_Time = 100.0,		--Lifetime (self-destruct timer), sec		--NIGHTSTORM 60
        Nr_max = 90,			--Maximum overload during turns
		v_min = 140.0,	  		--Minimum speed
		v_mid = 1029.0,	  		--Average Speed		
        Mach_max = 3.7,			--Maximum Mach number
        t_b = 0.0,				--Engine start time
        t_acc = 35.0,			--Time of operation of the accelerator		--NIGHTSTORM 5.0
        t_marsh = 0.0,			--Operating time in marching mode			--NIGHTSTORM 15.0
        Range_max = 40800.0,	--Maximum launch range at maximum altitude	--NIGHTSTORM 14000
        H_min_t = 1.0,			--Minimum height of the target above the terrain in meters
        Fi_start = 1.57, 		--Angle of tracking and sighting at launch (Angle off boresight)
        Fi_rak = 3.14152,		--Acceptable angle of view of the target (radians)
        Fi_excort = 1.57, 		--Angle of tracking (sight) of the target by the missile. (Gimbal Angle Limit)
        Fi_search = 2.5, 		--Limit angle of free search (Field of View)
        OmViz_max = 1.10, 		--Maximum line-of-sight speed (Gimbl Ang Rate Lim 63°/s)
        warhead = directional_a2a_warhead(11.0),	--Warhead type or definition	--NIGHTSTORM enhanced_a2a_warhead
        exhaust = { 0.7, 0.7, 0.7, 0.08 };	--Exhaust definition
		X_back = -1.82,			--X coordinates of the nozzle center in the rocket axes
        Y_back = 0.0,			--Y coordinates of the nozzle center in the rocket axes
        Z_back = 0.0,			--Z coordinates of the nozzle center in the rocket axes
        Reflection = 0.0182,	--Effective radio reflection surface, square meters (RADAR cross section)		--NIGHTSTORM 0.03
        KillDistance = 15.0,		--Distance is used to start the fuse
		loft = 0,				--Can missile loft to target based on range 1/0
		hoj = 0,				--Can missile home on an active jamming source 1/0
		SeekerSensivityDistance = 41000, -- The range of target with IR value = 1. In meters. In forward hemisphere.	--NIGHTSTORM 25000
		ccm_k0 = 0.01,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolute resistance to countermeasures. Default = 1 (medium probability) --NIGHTSTORM 0.2
		SeekerCooled = true, -- True is cooled seeker and false is not cooled seeker.
		rad_correction = 0,
		
		PN_coeffs = {3, 				-- Number of Entries	
					3000.0 ,1.0,		-- Less 3 km to target Pn = 1
					5000.0, 0.5,		-- Between 5 and 3 km  to target, Pn smoothly changes from 0.5 to 1.0. 
					10000.0, 0.2};		-- Between 10 and 5 km  to target, Pn smoothly changes from 0.2 to 0.5. Longer then 10 km Pn = 0.2.		

				ModelData = {   58 ,  -- model params count
						
						0.35 ,   -- characteristic square (характеристическая площадь)
						
						-- Drag (Сx)  
						0.04 , -- Cx_k0 Cd0 at low mach ( M << 1) 
						0.08 , -- Cx_k1 Peak Cd0 value 
						0.02 , -- Cx_k2 steepness of the drag curve before the transonic wave crisis 
						0.05, -- Cx_k3 Cd0 at high mach (M>>1)
						1.2 , -- Cx_k4 steepness of the drag curve after the transonic wave crisis  
						1.0 , --“polar dump factor"
						
						-- Lift (Cy) 
						0.9 , -- Cy_k0 Clmax at low mach ( M << 1)
						0.8	 , -- Cy_k0 Clmax at high mach ( M >> 1)
						1.2  , -- Cy_k2 steepness of the lift curve after the transonic wave crisis  
						
						0.9 , -- alpha max
						10.0, -- Extra G by thrust vector
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_boost		t_sustain		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	35.0,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	1.24,	    0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
						 0.0,		0.0,	7802.0,  	0.0,		0.0,			0.0,		0.0,           -- thrust, newtons  312,000 newtons total

						 1.0e9, -- Selfdestruction time in sec.
						 100.0, -- lifetime in seconds		--NIGHTSTORM 60.0
						 0, -- Minimum height in M
						 0.03, -- Autopilot delay, sec		--NIGHTSTORM 0.3
						 1.0e9, -- Lofting logic Rmin 
						 1.0e9, -- Range to target at which loft is complete (must be larger than previous value)  
						 0.0,  -- Angle in radians of loft 
						 30.0, -- продольное ускорения взведения взрывателя
						 0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
						 1.19, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
						 1.0, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
						 2.0, -- характристика системы САУ-РАКЕТА,  полоса пропускания контура управления
					
					-- DLZ. Data for calculating launch ranges (indication on the sight)
						9.0, 		-- range with respect to carrier speed at an altitude of 1 km
						-13.0, 		-- range with respect to target speed at an altitude of 1 km
						-2.1, 		-- derivative with respect to height of derivative of range with respect to target speed
						23422.0, 	-- range angle 180 degrees (towards), H = 5,000m, V = 900km / h, m	H = 16,404ft V = 486kts (12.65nm)
						8311.0, 	-- range angle 0 (in pursuit) deg, H = 5,000m, V = 900km / h, m	 H = 16,404ft V = 486kts (4.49nm)
						40800.0, 	-- range angle 180 (towards) deg, H = 10,000m, V = 900km / h, m  H = 32,808ft, V = 486kts  (22.03nm)
						15111.0,  	-- range angle 0 (in pursuit) deg, H = 10,000m, V = 900km / h, m H = 32,808ft, V = 486kts  (8.16nm)
						15867.0, 	-- range angle 180 (towards) deg, H = 1,000m, V = 900km / h, m	  H = 3,281ft, V = 486kts (8.57nm)
						5289.0, 	-- range angle 0 (in pursuit) deg, H = 1,000m, V = 900km / h, m	   H = 3,281ft, V = 486kts (2.86nm)
						2500.0, 	-- backward offset from the backsight point of the reachable zone
						0.55, 		-- percentage of guaranteed range from range in PPS at an altitude of 1 km
						-0.01, 	-- derivative of the percentage of guaranteed range in PPP by height
						0.5, 		-- Changing the slope coefficients of the curve in the upper and lower hemispheres from the height of the carrier.
					
					},
		fuze_proximity = {
			ignore_inp_armed	= 1,
			arm_delay			= 1.5,
			radius				= 4,
				},						
}

declare_weapon(AIM_9X2)

declare_loadout(
	{		
		category		= CAT_AIR_TO_AIR,
		CLSID			= "{AIM-9X2}",
		attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
		wsTypeOfWeapon	= AIM_9X2.wsTypeOfWeapon,
		Count			= 1,
		Picture			= "us_AIM-9X2.png",
--		displayName		= AIM_9X3.user_name, -- weapon name in the loadout menu
		displayName		= _("AIM-9X-2 Sidewinder IR AAM"),
		Weight			= 85.5,
		Cx_pil			= 0.0001,
		Elements		={
			[1] =
			{
				DrawArgs	=	
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
				Position	=	{0,	0,	0},
				ShapeName	=	"AIM-9X2",
			},
		},
	}
)


--*******************************************AIM-9X-3*************************************************

local AIM_9X3 = { 

	category		= CAT_AIR_TO_AIR,
	name			= _("AIM_9X3"),
	user_name		= _("AIM-9X-3"),
	wsTypeOfWeapon	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile, WSTYPE_PLACEHOLDER},
	NatoName		= "(AIM-9X3)",

	shape_table_data =
	{
		{
			name = "AIM-9X3";
			file = "AIM-9X3";
			life = 1;
			fire = { 0, 1};
			username = "AIM-9X3";	--	имя ракеты
			index = WSTYPE_PLACEHOLDER,
		},
	},

        Escort = 0,				--0-No, 1-La launch, 2-other La, 3-C ground
        Head_Type = 1,			--1-InfraredSeeker, 2-ActiveRadar, 3-AntiRadar, 4-Laserhooming, 5-Autopilot (GPS, TV, IIR), 6-SemiActiveRadar, 7-SemiAutoAT (control from platform)
		sigma = {1.01, 1.01, 1.01},		-- Sigma = {x, y, z}, maximum aiming error in meters, in target coordinates. X-longitudinal axis of the target, y-axis virtualna purpose, Z - axis, transverse target
        M = 85.5,				--Gross weight in kg
        H_max = 25000.0,		--Maximum flight altitude in meters. 18Km=59100feet 20km = 65600
        H_min = -1,				--Minimum flight height in meters.
        Diam = 127.0,			--Case Diameter in mm
        Cx_pil = 1.88,			--Cx as suspension (Drag value is assumed)
        D_max = 37000.0,		--Maximum Launch range at low altitude in meters
        D_min = 300.0,			--Minimum Launch range at low altitude in meters
        Head_Form = 0,			--False - hemispherical head shape / True-animate (~conic)
        Life_Time = 100.0,		--Lifetime (self-destruct timer), sec
        Nr_max = 90,			--Maximum overload during turns
		v_min = 140.0,	  		--Minimum speed
		v_mid = 1029.0,	  		--Average Speed		
        Mach_max = 4.0,			--Maximum Mach number
        t_b = 0.0,				--Engine start time
        t_acc = 50.0,			--Time of operation of the accelerator		--NIGHTSTORM 5.0
        t_marsh = 0.0,			--Operating time in marching mode			--NIGHTSTORM 15.0
        Range_max = 61200.0,	--Maximum launch range at maximum altitude		--NIGHTSTORM 40000
        H_min_t = 1.0,			--Minimum height of the target above the terrain in meters
        Fi_start = 1.57, 		--Angle of tracking and sighting at launch (Angle off boresight)
        Fi_rak = 3.14152,		--Acceptable angle of view of the target (radians)
        Fi_excort = 3, 			--Angle of tracking (sight) of the target by the missile. (Gimbal Angle Limit)
        Fi_search = 2.5, 		--Limit angle of free search (Field of View)
        OmViz_max = 1.10, 		--Maximum line-of-sight speed (Gimbl Ang Rate Lim 63°/s)
        warhead = simple_warhead(0.0001); -- inert warhead for training munition
        exhaust = { 0.7, 0.7, 0.7, 0.08 };	--Exhaust definition
		X_back = -1.82,			--X coordinates of the nozzle center in the rocket axes
        Y_back = 0.0,			--Y coordinates of the nozzle center in the rocket axes
        Z_back = 0.0,			--Z coordinates of the nozzle center in the rocket axes
        Reflection = 0.0182,	--Effective radio reflection surface, square meters (RADAR cross section)
        KillDistance = 15.0,		--Distance is used to start the fuse
		loft = 0,				--Can missile loft to target based on range 1/0
		hoj = 0,				--Can missile home on an active jamming source 1/0
		SeekerSensivityDistance = 62000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
		ccm_k0 = 0.005,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolute resistance to countermeasures. Default = 1 (medium probability)
		SeekerCooled = true, -- True is cooled seeker and false is not cooled seeker.
		rad_correction = 0,
		
	supersonic_A_coef_skew = 0.25, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.0068, -- площадь выходного сечения сопла
		PN_coeffs = {3, 				-- Number of Entries	
					3000.0 ,1.0,		-- Less 3 km to target Pn = 1
					5000.0, 0.5,		-- Between 5 and 3 km  to target, Pn smoothly changes from 0.5 to 1.0. 
					10000.0, 0.2};		-- Between 10 and 5 km  to target, Pn smoothly changes from 0.2 to 0.5. Longer then 10 km Pn = 0.2.		

				ModelData = {   58 ,  -- model params count
						
						0.35 ,   -- characteristic square (характеристическая площадь)
						
						-- Drag (Сx)  
						0.04 , -- Cx_k0 Cd0 at low mach ( M << 1) 
						0.08 , -- Cx_k1 Peak Cd0 value 
						0.02 , -- Cx_k2 steepness of the drag curve before the transonic wave crisis 
						0.05, -- Cx_k3 Cd0 at high mach (M>>1)
						1.2 , -- Cx_k4 steepness of the drag curve after the transonic wave crisis  
						1.0 , --“polar dump factor"
						
						-- Lift (Cy) 
						0.9 , -- Cy_k0 Clmax at low mach ( M << 1)
						0.8	 , -- Cy_k0 Clmax at high mach ( M >> 1)
						1.2  , -- Cy_k2 steepness of the lift curve after the transonic wave crisis  
						
						0.9 , -- alpha max
						15.0, -- Extra G by thrust vector
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	50.0,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	1.24,	    0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
						 0.0,		0.0,	7802.0,  	0.0,		0.0,			0.0,		0.0,           -- thrust, newtons  312,000 newtons total

						 1.0e9, -- Selfdestruction time in sec.
						 100.0, -- lifetime in seconds
						 0, -- Minimum height in M
						 0.03, -- Autopilot delay, sec
						 1.0e9, -- Lofting logic Rmin 
						 1.0e9, -- Range to target at which loft is complete (must be larger than previous value)  
						 0.0,  -- Angle in radians of loft 
						 30.0, -- продольное ускорения взведения взрывателя
						 0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
						 1.19, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
						 1.0, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
						 2.0, -- характристика системы САУ-РАКЕТА,  полоса пропускания контура управления

					-- DLZ. Data for calculating launch ranges (indication on the sight)
						9.0, 		-- range with respect to carrier speed at an altitude of 1 km
						-13.0, 		-- range with respect to target speed at an altitude of 1 km
						-2.1, 		-- derivative with respect to height of derivative of range with respect to target speed
						35133.0, 	-- range angle 180 degrees (towards), H = 5,000m, V = 900km / h, m	H = 16,404ft V = 486kts (18.97nm)
						12467.0, 	-- range angle 0 (in pursuit) deg, H = 5,000m, V = 900km / h, m	 H = 16,404ft V = 486kts (6.73nm)
						61200.0, 	-- range angle 180 (towards) deg, H = 10,000m, V = 900km / h, m  H = 32,808ft, V = 486kts  (33.05nm)
						22666.0,  	-- range angle 0 (in pursuit) deg, H = 10,000m, V = 900km / h, m H = 32,808ft, V = 486kts  (12.24nm)
						23800.0, 	-- range angle 180 (towards) deg, H = 1,000m, V = 900km / h, m	  H = 3,281ft, V = 486kts (12.85nm)
						7934.0, 	-- range angle 0 (in pursuit) deg, H = 1,000m, V = 900km / h, m	   H = 3,281ft, V = 486kts (4.28nm)
						2500.0, 	-- backward offset from the backsight point of the reachable zone
						0.55, 		-- percentage of guaranteed range from range in PPS at an altitude of 1 km
						-0.01, 	-- derivative of the percentage of guaranteed range in PPP by height
						0.5, 		-- Changing the slope coefficients of the curve in the upper and lower hemispheres from the height of the carrier.

						
						
					},
		fuze_proximity = {
			ignore_inp_armed	= 1,
			arm_delay			= 1.5,
			radius				= 4,
				},		} 

declare_weapon(AIM_9X3)

declare_loadout(
	{		
		category		= CAT_AIR_TO_AIR,
		CLSID			= "{AIM-9X3}",
		attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
		wsTypeOfWeapon	= AIM_9X3.wsTypeOfWeapon,
		Count			= 1,
		Picture			= "us_AIM-9X3.png",
--		displayName		= AIM_9X3.user_name, -- weapon name in the loadout menu
		displayName		= _("AIM-9X-3 Sidewinder IR AAM"),
		Weight			= 85.5,
		Cx_pil			= 0.0001,
		Elements		={
			[1] =
			{
				DrawArgs	=	
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
				Position	=	{0,	0,	0},
				ShapeName	=	"AIM-9X3",
			},
		},
	}
)
--*******************************************CATM-9M*************************************************

local CATM_9M = { 

	category		= CAT_AIR_TO_AIR,
	name			= _("CATM_9M"),
	user_name		= _("CATM-9M"),
	wsTypeOfWeapon	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile, WSTYPE_PLACEHOLDER},
	NatoName		= "(CATM-9M)",

	shape_table_data =
	{
		{
			name = "CATM-9M";
			file = "CATM-9M";
			life = 1;
			fire = { 0, 1};
			username = "CATM-9M";	--	имя ракеты
			index = WSTYPE_PLACEHOLDER,
		},
	},

        Escort = 1,				--0-No, 1-La launch, 2-other La, 3-C ground
        Head_Type = 5,			--1-InfraredSeeker, 2-ActiveRadar, 3-AntiRadar, 4-Laserhooming, 5-Autopilot (GPS, TV, IIR), 6-SemiActiveRadar, 7-SemiAutoAT (control from platform)
		sigma = {1.01, 1.01, 1.01},		-- Sigma = {x, y, z}, maximum aiming error in meters, in target coordinates. X-longitudinal axis of the target, y-axis virtualna purpose, Z - axis, transverse target
        M = 85.5,				--Gross weight in kg
        H_max = 25000.0,		--Maximum flight altitude in meters. 18Km=59100feet 20km = 65600
        H_min = -1,				--Minimum flight height in meters.
        Diam = 127.0,			--Case Diameter in mm
        Cx_pil = 1.88,			--Cx as suspension (Drag value is assumed)
        D_max = 37000.0,		--Maximum Launch range at low altitude in meters
        D_min = 300.0,			--Minimum Launch range at low altitude in meters
        Head_Form = 0,			--False - hemispherical head shape / True-animate (~conic)
        Life_Time = 100.0,		--Lifetime (self-destruct timer), sec
        Nr_max = 90,			--Maximum overload during turns
		v_min = 140.0,	  		--Minimum speed
		v_mid = 1029.0,	  		--Average Speed		
        Mach_max = 4.0,			--Maximum Mach number
        t_b = 0.0,				--Engine start time
        t_acc = 50.0,			--Time of operation of the accelerator		--NIGHTSTORM 5.0
        t_marsh = 0.0,			--Operating time in marching mode			--NIGHTSTORM 15.0
        Range_max = 61200.0,	--Maximum launch range at maximum altitude		--NIGHTSTORM 40000
        H_min_t = 1.0,			--Minimum height of the target above the terrain in meters
        Fi_start = 1.57, 		--Angle of tracking and sighting at launch (Angle off boresight)
        Fi_rak = 3.14152,		--Acceptable angle of view of the target (radians)
        Fi_excort = 3, 			--Angle of tracking (sight) of the target by the missile. (Gimbal Angle Limit)
        Fi_search = 2.5, 		--Limit angle of free search (Field of View)
        OmViz_max = 1.10, 		--Maximum line-of-sight speed (Gimbl Ang Rate Lim 63°/s)
        warhead = simple_warhead(0.0001); -- inert warhead for training munition
        exhaust = { 0.7, 0.7, 0.7, 0.08 };	--Exhaust definition
		X_back = -1.82,			--X coordinates of the nozzle center in the rocket axes
        Y_back = 0.0,			--Y coordinates of the nozzle center in the rocket axes
        Z_back = 0.0,			--Z coordinates of the nozzle center in the rocket axes
        Reflection = 0.0182,	--Effective radio reflection surface, square meters (RADAR cross section)
        KillDistance = 15.0,		--Distance is used to start the fuse
		loft = 0,				--Can missile loft to target based on range 1/0
		hoj = 0,				--Can missile home on an active jamming source 1/0
		SeekerSensivityDistance = 62000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
		ccm_k0 = 0.005,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolute resistance to countermeasures. Default = 1 (medium probability)
		SeekerCooled = true, -- True is cooled seeker and false is not cooled seeker.
		rad_correction = 0,
		
	supersonic_A_coef_skew = 0.25, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.0068, -- площадь выходного сечения сопла
		PN_coeffs = {3, 				-- Number of Entries	
					3000.0 ,1.0,		-- Less 3 km to target Pn = 1
					5000.0, 0.5,		-- Between 5 and 3 km  to target, Pn smoothly changes from 0.5 to 1.0. 
					10000.0, 0.2};		-- Between 10 and 5 km  to target, Pn smoothly changes from 0.2 to 0.5. Longer then 10 km Pn = 0.2.		

				ModelData = {   58 ,  -- model params count
						
						0.35 ,   -- characteristic square (характеристическая площадь)
						
						-- Drag (Сx)  
						0.04 , -- Cx_k0 Cd0 at low mach ( M << 1) 
						0.08 , -- Cx_k1 Peak Cd0 value 
						0.02 , -- Cx_k2 steepness of the drag curve before the transonic wave crisis 
						0.05, -- Cx_k3 Cd0 at high mach (M>>1)
						1.2 , -- Cx_k4 steepness of the drag curve after the transonic wave crisis  
						1.0 , --“polar dump factor"
						
						-- Lift (Cy) 
						0.9 , -- Cy_k0 Clmax at low mach ( M << 1)
						0.8	 , -- Cy_k0 Clmax at high mach ( M >> 1)
						1.2  , -- Cy_k2 steepness of the lift curve after the transonic wave crisis  
						
						0.9 , -- alpha max
						15.0, -- Extra G by thrust vector
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	550.0,  	0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	1.08,	    1.01,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
						 0.0,		0.0,	2802.0,  	2000.0,		0.0,			0.0,		0.0,           -- thrust, newtons  312,000 newtons total

						 1.0e9, -- Selfdestruction time in sec.
						 100.0, -- lifetime in seconds
						 0, -- Minimum height in M
						 0.03, -- Autopilot delay, sec
						 1.0e9, -- Lofting logic Rmin 
						 1.0e9, -- Range to target at which loft is complete (must be larger than previous value)  
						 0.0,  -- Angle in radians of loft 
						 30.0, -- продольное ускорения взведения взрывателя
						 0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
						 1.19, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
						 1.0, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
						 2.0, -- характристика системы САУ-РАКЕТА,  полоса пропускания контура управления

					-- DLZ. Data for calculating launch ranges (indication on the sight)
						9.0, 		-- range with respect to carrier speed at an altitude of 1 km
						-13.0, 		-- range with respect to target speed at an altitude of 1 km
						-2.1, 		-- derivative with respect to height of derivative of range with respect to target speed
						35133.0, 	-- range angle 180 degrees (towards), H = 5,000m, V = 900km / h, m	H = 16,404ft V = 486kts (18.97nm)
						12467.0, 	-- range angle 0 (in pursuit) deg, H = 5,000m, V = 900km / h, m	 H = 16,404ft V = 486kts (6.73nm)
						61200.0, 	-- range angle 180 (towards) deg, H = 10,000m, V = 900km / h, m  H = 32,808ft, V = 486kts  (33.05nm)
						22666.0,  	-- range angle 0 (in pursuit) deg, H = 10,000m, V = 900km / h, m H = 32,808ft, V = 486kts  (12.24nm)
						23800.0, 	-- range angle 180 (towards) deg, H = 1,000m, V = 900km / h, m	  H = 3,281ft, V = 486kts (12.85nm)
						7934.0, 	-- range angle 0 (in pursuit) deg, H = 1,000m, V = 900km / h, m	   H = 3,281ft, V = 486kts (4.28nm)
						2500.0, 	-- backward offset from the backsight point of the reachable zone
						0.55, 		-- percentage of guaranteed range from range in PPS at an altitude of 1 km
						-0.01, 	-- derivative of the percentage of guaranteed range in PPP by height
						0.5, 		-- Changing the slope coefficients of the curve in the upper and lower hemispheres from the height of the carrier.

						
						
					},
		fuze_proximity = {
			ignore_inp_armed	= 1,
			arm_delay			= 1.5,
			radius				= 4,
				},		} 

declare_weapon(CATM_9M)

declare_loadout(
	{		
		category		= CAT_AIR_TO_AIR,
		CLSID			= "{CATM-9M}",
		attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
		wsTypeOfWeapon	= CATM_9M.wsTypeOfWeapon,
		Count			= 1,
		Picture			= "us_CATM-9M.png",
		displayName		= _("CATM-9M Sidewinder - Training Missile"),
		Weight			= 85.5,
		Cx_pil			= 0.0001,
		Elements		={
			[1] =
			{
				DrawArgs	=	
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
				Position	=	{0,	0,	0},
				ShapeName	=	"CATM-9M",
			},
		},
	}
)

--*******************************************CATM-9X*************************************************

local CATM_9X = { 

	category		= CAT_AIR_TO_AIR,
	name			= _("CATM_9X"),
	user_name		= _("CATM-9X"),
	wsTypeOfWeapon	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile, WSTYPE_PLACEHOLDER},
	NatoName		= "(CATM-9X)",

	shape_table_data =
	{
		{
			name = "CATM-9X";
			file = "CATM-9X";
			life = 1;
			fire = { 0, 1};
			username = "CATM-9X";	--	имя ракеты
			index = WSTYPE_PLACEHOLDER,
		},
	},


        Escort = 0,				--0-No, 1-La launch, 2-other La, 3-C ground
        Head_Type = 5,			--1-InfraredSeeker, 2-ActiveRadar, 3-AntiRadar, 4-Laserhooming, 5-Autopilot (GPS, TV, IIR), 6-SemiActiveRadar, 7-SemiAutoAT (control from platform)
		sigma = {5, 5, 5},		-- Sigma = {x, y, z}, maximum aiming error in meters, in target coordinates. X-longitudinal axis of the target, y-axis virtualna purpose, Z - axis, transverse target
        M = 85.5,				--Gross weight in kg
        H_max = 0.0,			--Maximum flight altitude in meters. 18Km=59100feet 20km = 65600
        H_min = -1,				--Minimum flight height in meters.
        Diam = 127.0,			--Case Diameter in mm
        Cx_pil = 1.88,			--Cx as suspension (Drag value is assumed)
        D_max = 0.0,			--Maximum Launch range at low altitude in meters
        D_min = 0.0,			--Minimum Launch range at low altitude in meters
        Head_Form = 0,			--False - hemispherical head shape / True-animate (~conic)
        Life_Time = 550.0,		--Lifetime (self-destruct timer), sec		--NIGHTSTORM 60
        Nr_max = 0,				--Maximum overload during turns
		v_min = 0.0,	  		--Minimum speed
		v_mid = 0.0,	  		--Average Speed		
        Mach_max = 0.0,			--Maximum Mach number
        t_b = 0.0,				--Engine start time
        t_acc = 0.0,			--Time of operation of the accelerator
        t_marsh = 0.0,			--Operating time in marching mode
        Range_max = 0.0,		--Maximum launch range at maximum altitude	--NIGHTSTORM 14000
        H_min_t = 0.0,			--Minimum height of the target above the terrain in meters
        Fi_start = 1.57, 		--Angle of tracking and sighting at launch (Angle off boresight)
        Fi_rak = 3.14152,		--Acceptable angle of view of the target (radians)
        Fi_excort = 1.57, 		--Angle of tracking (sight) of the target by the missile. (Gimbal Angle Limit)
        Fi_search = 0.09, 		--Limit angle of free search (Field of View)
        OmViz_max = 1.10, 		--Maximum line-of-sight speed (Gimbl Ang Rate Lim 63°/s)
        warhead = simple_warhead(0.0001); -- inert warhead for training munition
        exhaust = { 0.0, 0.0, 0.0, 0.0 };	--Exhaust definition
		X_back = -1.92,			--X coordinates of the nozzle center in the rocket axes
        Y_back = 0.0,			--Y coordinates of the nozzle center in the rocket axes
        Z_back = 0.0,			--Z coordinates of the nozzle center in the rocket axes
        Reflection = 0.0182,	--Effective radio reflection surface, square meters (RADAR cross section)		--NIGHTSTORM 0.03
        KillDistance = 0.0,		--Distance is used to start the fuse				
}

declare_weapon(CATM_9X)

declare_loadout(
	{		
		category		= CAT_AIR_TO_AIR,
		CLSID			= "{CATM-9X}",
		attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
		wsTypeOfWeapon	= CATM_9X.wsTypeOfWeapon,
		Count			= 1,
		Picture			= "us_CATM-9X.png",
		displayName		= _("CATM-9X Sidewinder - Training Missile"),
		Weight			= 85.5,
		Cx_pil			= 0.0001,
		Elements		={
			[1] =
			{
				DrawArgs	=	
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
				Position	=	{0,	0,	0},
				ShapeName	=	"CATM-9X",
			},
		},
	}
)

--*******************************************AIM-120A*************************************************
--Used on the F-15C

local AIM_120A =	 {
		category		= CAT_AIR_TO_AIR,
		name			= "AIM_120A",
		user_name		= _("AIM-120A"),
		wsTypeOfWeapon	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
		Escort = 1,				--0-No, 1-La launch, 2-other La, 3-C ground
		Head_Type = 5,			--1-InfraredSeeker, 2-ActiveRadar, 3-AntiRadar, 4-Laserhooming, 5-Autopilot (GPS, TV, IIR), 6-SemiActiveRadar, 7-SemiAutoAT (control from platform)
		sigma = {4, 4, 4},		-- Sigma = {x, y, z}, maximum aiming error in meters, in target coordinates. X-longitudinal axis of the target, y-axis virtualna purpose, Z - axis, transverse target
		M = 250.0,				--Gross weight in kg
		H_max = 26000.0,		--Maximum flight altitude in meters. 18Km=59100feet 20km = 65600
		H_min = 1.0,			--Minimum flight height in meters.
		Diam = 160.0,			--Case Diameter in mm
		Cx_pil = 2.5,			--Cx as suspension (Drag value is assumed)		
		D_max = 95000.0,		--Maximum Launch range at low altitude in meters
		D_min = 500.0,			--Minimum Launch range at low altitude in meters
		Head_Form = 1,			--False - hemispherical head shape / True-animate (~conic)
		Life_Time = 420.0,		--Lifetime (self-destruct timer), sec		
		Nr_max = 100,			--Maximum overload during turns		
		v_min = 140.0,	  		-- Minimum speed
		v_mid = 500.0,	  		-- Average Speed
		Mach_max = 2.0,			--Maximum Mach number
		t_b = 0.15,				--Engine start time
		t_acc = 52.0,			--Time of operation of the accelerator
		t_marsh = 25.0,			--Operating time in marching mode	
		Range_max = 140000.0,	--Maximum launch range at maximum altitude
		H_min_t = 1.0,			--Minimum height of the target above the terrain in meters		
		Fi_start = 9910.5, 		--Angle of tracking and sighting at launch (Angle off boresight)		
		Fi_rak = 3.14152,		--Acceptable angle of view of the target (radians)
        Fi_excort = 9911.05, 	--Angle of tracking (sight) of the target by the missile. (Gimbal Angle Limit)
        Fi_search = 9911.05, 	--Limit angle of free search (Field of View)
		OmViz_max = 9910.52,	--Maximum line-of-sight speed (Gimbl Ang Rate Lim 63°/s)
		warhead = warheads["AIM_120C"],	--Warhead type or definition		
        exhaust = {0.8, 0.8, 0.8, 0.05 };	--Exhaust definition
        X_back = -1.98,			--X coordinates of the nozzle center in the rocket axes
        Y_back = 0.0,			--Y coordinates of the nozzle center in the rocket axes
        Z_back = 0.0,			--Z coordinates of the nozzle center in the rocket axes
        Reflection = 0.0329,	--Effective radio reflection surface, square meters (RADAR cross section)
		KillDistance = 20.0,	--Distance is used to start the fuse
		loft = 1,				--Can missile loft to target based on range 0/1
		hoj = 1,				--Can missile home on an active jamming source 0/1
--		loft_factor = 4.5,			
		loft_factor = -0.5,		--NIGHTSTORM Reduced loft factor by 50% for new seeker code to avoid overshoot.  Max range ~110NM.		
		
		ccm_k0 = 0.001,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolute resistance to countermeasures. Default = 1 (medium probability)
--		go_active_by_default = 0,		--Seeker active by default 0/1
		go_active_by_default = 1,		--Seeker active by default 0/1		
		active_radar_lock_dist = 65000,	--Seeker lock maximaum range in meters

		PN_coeffs = {11,				 -- Number of Entries
					0.0, 1.0,
					4000.0, 0.295,
					5000.0, 0.19,
					6000.0, 0.17,
					7000.0, 0.14,
					10000.0, 0.12,
					15000.0, 0.10,
					20000.0, 0.09,
					30000.0, 0.08,
					40000.0, 0.07,
					100000.0, 0.05,
					};

		supersonic_A_coef_skew = 0.1, 	--The slope of the straight coefficient of the polar dump at supersonic
		nozzle_exit_area =	0.02322576, --Nozzle outlet area

		shape_table_data =
		{
			{
				name	 = "AIM-120A",
				file	 = "AIM-120A",
				life	 = 1,
				fire	 = { 0, 1},
				username = "AIM-120A",				
				index = WSTYPE_PLACEHOLDER,
			},
		},

		ModelData = {   58 ,  -- model params count
						0.4 ,   -- characteristic square (характеристическая площадь)
						
						-- Drag (Сx)  
						0.016 , -- Cx_k0 Cd0 at low mach ( M << 1) 
						0.045 , -- Cx_k1 Peak Cd0 value 
						0.02 , -- Cx_k2 steepness of the drag curve before the transonic wave crisis 
						0.016, -- Cx_k3 Cd0 at high mach (M>>1)
						1.25 , -- Cx_k4 steepness of the drag curve after the transonic wave crisis  
						1.2 , --“polar dump factor"
						
						-- Lift (Cy) 
						1.40 , -- Cy_k0 Clmax at low mach ( M << 1)
						0.60 , -- Cy_k0 Clmax at high mach ( M >> 1)
						1.2  , -- Cy_k2 steepness of the lift curve after the transonic wave crisis  
						
						0.5 , -- alpha max
						0.0, --Additional g’s due to thrust vectoring/rocket motors 
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end		-- Stage
						-1.0,	   	0.15,	495.0,		5.0,		0.0,			0.0,		1.0e9,		-- time of stage, sec
						 0.0,		0.0,	1.0,		0.4,		0.0,			0.0,		0.0,		-- fuel flow rate in second, kg/sec
						 0.0,		0.0,	360.0,		360.0,		0.0,			0.0,		0.0,		-- thrust, newtons		--NIGHTSTORM Values uses with LOFT enabled.				 

						 1.0e9, -- таймер самоликвидации, сек
						 420.0, -- lifetime in seconds							 
						 0, -- Minimum height in M
						 1.0, -- Autopilot delay, sec
						 60000.0, -- Lofting logic Rmin 
						 80000.0, -- Range to target at which loft is complete (must be larger than previous value) in meters
						 0.52356,	-- Angle in radians of loft 
						 20.0, -- longitudinal acceleration of fuse cocking
						 0.0, -- speed module communicated by a catapult device, expelling charge, etc.
						 1.19, -- characteristic of the SAU-RAKETA system, second-order filter coefficient K0
						 1.0, -- characteristic of the SAU-Raketa system, second order filter coefficient K1
						 2.0, -- characteristic of the SAU-RAKETA system, control loop bandwidth

					  -- DLZ. Data for calculating launch ranges (indication on the sight)
						21.0, 		-- range with respect to carrier speed at an altitude of 1 km
						-23.0, 		-- range with respect to target speed at an altitude of 1 km
						-3.0, 		-- derivative with respect to height of derivative of range with respect to target speed
						109200, 	-- range angle 180 degrees (towards), H = 5,000m, V = 900km / h, m	H = 16,404ft V = 486kts (58.96nm)
						37200, 		-- range angle 0 (in pursuit) deg, H = 5,000m, V = 900km / h, m  H = 16,404ft V = 486kts (20..09nm)
						180000,		-- range angle 180 (towards) deg, H = 10,000m, V = 900km / h, m  H = 32,808ft, V = 486kts  (97.19nm)
						70800, 		-- range angle 0 (in pursuit) deg, H = 10,000m, V = 900km / h, m  H = 32,808ft, V = 486kts  (38.23nm)
						74400, 		-- range angle 180 (towards) deg, H = 1,000m, V = 900km / h, m  H = 3,281ft, V = 486kts (40.17nm)
						21600, 		-- range angle 0 (in pursuit) deg, H = 1,000m, V = 900km / h, m  H = 3,281ft, V = 486kts (11.66m)
						4000, 		-- backward offset from the backsight point of the reachable zone
						0.4, 		-- percentage of guaranteed range from range in PPS at an altitude of 1 km
						-0.015, 	-- derivative of the percentage of guaranteed range in PPP by height
						0.5,		-- Changing the slope coefficients of the curve in the upper and lower hemispheres from the height of the carrier.




					}, 
					proximity_fuze = {
								ignore_inp_armed	= 1,
								radius		= 15,
								arm_delay	= 3.0,
													},
	}
	
	

declare_weapon(AIM_120A)


declare_loadout({
	category		= CAT_AIR_TO_AIR,
	CLSID			= "{AIM-120A}",
	Picture			= "us_AIM-120A.png",
	attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= AIM_120A.wsTypeOfWeapon,
	displayName		= _("AIM-120A AMRAAM - Active Rdr AAM"),
	Count			= 1,
	Weight			= 156,
	Elements		={
			[1] =
			{
				DrawArgs	=	
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
				Position	=	{0,	0,	0},
				ShapeName	=	"AIM-120A",
			},
		},
	}
)

--*******************************************AIM-120C-6*************************************************
--Used on F-15C and F-22A


local AIM_120C_6 =	 {
		category		= CAT_AIR_TO_AIR,
		name			= "AIM_120C_6",
		user_name		= _("AIM-120C-6"),
		wsTypeOfWeapon	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
		Escort = 1,				--0-No, 1-La launch, 2-other La, 3-C ground
		Head_Type = 5,			--1-InfraredSeeker, 2-ActiveRadar, 3-AntiRadar, 4-Laserhooming, 5-Autopilot (GPS, TV, IIR), 6-SemiActiveRadar, 7-SemiAutoAT (control from platform)
		sigma = {4, 4, 4},		-- Sigma = {x, y, z}, maximum aiming error in meters, in target coordinates. X-longitudinal axis of the target, y-axis virtualna purpose, Z - axis, transverse target
		M = 160.0,				--Gross weight in kg
		H_max = 26000.0,		--Maximum flight altitude in meters. 18Km=59100feet 20km = 65600
		H_min = 1500.0,			--Minimum flight height in meters.
		Diam = 160.0,			--Case Diameter in mm
		Cx_pil = 2.5,			--Cx as suspension (Drag value is assumed)		
		D_max = 95000.0,		--Maximum Launch range at low altitude in meters
		D_min = 100.0,			--Minimum Launch range at low altitude in meters
		Head_Form = 1,			--False - hemispherical head shape / True-animate (~conic)
		Life_Time = 400.0,		--Lifetime (self-destruct timer), sec		
		Nr_max = 400,			--Maximum overload during turns		
		v_min = 140.0,	  		-- Minimum speed
		v_mid = 700.0,	  		-- Average Speed
		Mach_max = 2.0,			--Maximum Mach number
		t_b = 0.15,				--Engine start time
		t_acc = 52.0,			--Time of operation of the accelerator
		t_marsh = 25.0,			--Operating time in marching mode	
		Range_max = 140000.0,	--Maximum launch range at maximum altitude
		H_min_t = 1.0,			--Minimum height of the target above the terrain in meters		
		Fi_start = 9910.5, 		--Angle of tracking and sighting at launch (Angle off boresight)		
		Fi_rak = 3.14152,		--Acceptable angle of view of the target (radians)
        Fi_excort = 9911.05, 	--Angle of tracking (sight) of the target by the missile. (Gimbal Angle Limit)
        Fi_search = 9911.05, 	--Limit angle of free search (Field of View)
		OmViz_max = 9910.52,	--Maximum line-of-sight speed (Gimbl Ang Rate Lim 63°/s)
		warhead = warheads["AIM_120C"],	--Warhead type or definition		
        exhaust = {1.1, 1.1, 1.1, 0.05 };	--Exhaust definition
        X_back = -1.98,			--X coordinates of the nozzle center in the rocket axes
        Y_back = 0.0,			--Y coordinates of the nozzle center in the rocket axes
        Z_back = 0.0,			--Z coordinates of the nozzle center in the rocket axes
        Reflection = 0.0329,	--Effective radio reflection surface, square meters (RADAR cross section)
		KillDistance = 20.0,	--Distance is used to start the fuse
		loft = 1,				--Can missile loft to target based on range 0/1
		hoj = 1,				--Can missile home on an active jamming source 0/1
--		loft_factor = 4.5,			
		loft_factor = 0.00001,		--NIGHTSTORM Reduced loft factor by 50% for new seeker code to avoid overshoot.  Max range ~110NM.		
		
		ccm_k0 = 0.001,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolute resistance to countermeasures. Default = 1 (medium probability)
--		go_active_by_default = 0,		--Seeker active by default 0/1
		go_active_by_default = 1,		--Seeker active by default 0/1		
		active_radar_lock_dist = 65000,	--Seeker lock maximaum range in meters

		PN_coeffs = {11,				 -- Number of Entries
					0.0, 1.0,
					4000.0, 0.295,
					5000.0, 0.19,
					6000.0, 0.17,
					7000.0, 0.14,
					10000.0, 0.12,
					15000.0, 0.10,
					20000.0, 0.09,
					30000.0, 0.08,
					40000.0, 0.07,
					100000.0, 0.05,
					};

		supersonic_A_coef_skew = 0.1, 	--The slope of the straight coefficient of the polar dump at supersonic
		nozzle_exit_area =	0.02322576, --Nozzle outlet area

		shape_table_data =
		{
			{
				name	 = "AIM_120C_6",
				file	 = "AIM-120C",
				life	 = 1,
				fire	 = { 0, 1},
				username = "AIM-120C",				
				index = WSTYPE_PLACEHOLDER,
			},
		},

		ModelData = {   58 ,  -- model params count
						0.4 ,   -- characteristic square (характеристическая площадь)
						
						-- Drag (Сx)  
						0.016 , -- Cx_k0 Cd0 at low mach ( M << 1) 
						0.035 , -- Cx_k1 Peak Cd0 value 
						0.02 , -- Cx_k2 steepness of the drag curve before the transonic wave crisis 
						0.016, -- Cx_k3 Cd0 at high mach (M>>1)
						1.25 , -- Cx_k4 steepness of the drag curve after the transonic wave crisis  
						1.2 , --“polar dump factor"
						
						-- Lift (Cy) 
						1.40 , -- Cy_k0 Clmax at low mach ( M << 1)
						0.60 , -- Cy_k0 Clmax at high mach ( M >> 1)
						1.2  , -- Cy_k2 steepness of the lift curve after the transonic wave crisis  
						
						0.5 , -- alpha max
						0.0, --Additional g’s due to thrust vectoring/rocket motors 
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end		-- Stage
						-1.0,	   	0.15,	495.0,		0.0,		0.0,			0.0,		1.0e9,		-- time of stage, sec
						 0.0,		0.0,	1.0,		0.0,		0.0,			0.0,		0.0,		-- fuel flow rate in second, kg/sec
						 0.0,		0.0,	12000.0,	0.0,		0.0,			0.0,		0.0,		-- thrust, newtons		--NIGHTSTORM Values uses with LOFT enabled.				 

						 1.0e9, -- таймер самоликвидации, сек
						 420.0, -- lifetime in seconds							 
						 0, -- Minimum height in M
						 2.0, -- Autopilot delay, sec
						 60000.0, -- Lofting logic Rmin 
						 80000.0, -- Range to target at which loft is complete (must be larger than previous value) in meters
						 0.52356,	-- Angle in radians of loft 
						 20.0, -- longitudinal acceleration of fuse cocking
						 0.0, -- speed module communicated by a catapult device, expelling charge, etc.
						 1.19, -- characteristic of the SAU-RAKETA system, second-order filter coefficient K0
						 1.0, -- characteristic of the SAU-Raketa system, second order filter coefficient K1
						 2.0, -- characteristic of the SAU-RAKETA system, control loop bandwidth

					  -- DLZ. Data for calculating launch ranges (indication on the sight)
						21.0, 		-- range with respect to carrier speed at an altitude of 1 km
						-23.0, 		-- range with respect to target speed at an altitude of 1 km
						-3.0, 		-- derivative with respect to height of derivative of range with respect to target speed
						109200, 	-- range angle 180 degrees (towards), H = 5,000m, V = 900km / h, m	H = 16,404ft V = 486kts (58.96nm)
						37200, 		-- range angle 0 (in pursuit) deg, H = 5,000m, V = 900km / h, m  H = 16,404ft V = 486kts (20..09nm)
						180000,		-- range angle 180 (towards) deg, H = 10,000m, V = 900km / h, m  H = 32,808ft, V = 486kts  (97.19nm)
						70800, 		-- range angle 0 (in pursuit) deg, H = 10,000m, V = 900km / h, m  H = 32,808ft, V = 486kts  (38.23nm)
						74400, 		-- range angle 180 (towards) deg, H = 1,000m, V = 900km / h, m  H = 3,281ft, V = 486kts (40.17nm)
						21600, 		-- range angle 0 (in pursuit) deg, H = 1,000m, V = 900km / h, m  H = 3,281ft, V = 486kts (11.66m)
						4000, 		-- backward offset from the backsight point of the reachable zone
						0.4, 		-- percentage of guaranteed range from range in PPS at an altitude of 1 km
						-0.015, 	-- derivative of the percentage of guaranteed range in PPP by height
						0.5,		-- Changing the slope coefficients of the curve in the upper and lower hemispheres from the height of the carrier.




					}, 
					proximity_fuze = {
								ignore_inp_armed	= 1,
								radius		= 15,
								arm_delay	= 3.0,
													},
	}

declare_weapon(AIM_120C_6)


declare_loadout({
	category		= CAT_AIR_TO_AIR,
	CLSID			= "{AIM-120C-6}",
	Picture			= "us_AIM-120C.png",
	attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= AIM_120C_6.wsTypeOfWeapon,
	displayName		= _("AIM-120C-6 AMRAAM - Active Rdr AAM"),		
	Count			= 1,
	Weight			= 160.5,
	Elements		={
			[1] =
			{
				DrawArgs	=	
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
				Position	=	{0,	0,	0},
				ShapeName	=	"AIM-120C",
			},
		},
	}
)

--*******************************************AIM-120C-7*************************************************
--Used on F-15C and F-22A


local AIM_120C_7 =	 {
		category		= CAT_AIR_TO_AIR,
		name			= "AIM_120C_7",
		user_name		= _("AIM-120C-7"),
		wsTypeOfWeapon	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
		Escort = 1,				--0-No, 1-La launch, 2-other La, 3-C ground
		Head_Type = 5,			--1-InfraredSeeker, 2-ActiveRadar, 3-AntiRadar, 4-Laserhooming, 5-Autopilot (GPS, TV, IIR), 6-SemiActiveRadar, 7-SemiAutoAT (control from platform)
		sigma = {0.0001, 0.0001, 0.0001},		-- Sigma = {x, y, z}, maximum aiming error in meters, in target coordinates. X-longitudinal axis of the target, y-axis virtualna purpose, Z - axis, transverse target
		M = 250.0,				--Gross weight in kg
		H_max = 26000.0,		--Maximum flight altitude in meters. 18Km=59100feet 20km = 65600
		H_min = 1500.0,			--Minimum flight height in meters.
		Diam = 160.0,			--Case Diameter in mm
		Cx_pil = 2.5,			--Cx as suspension (Drag value is assumed)		
		D_max = 95000.0,		--Maximum Launch range at low altitude in meters
		D_min = 1500.0,			--Minimum Launch range at low altitude in meters
		Head_Form = 1,			--False - hemispherical head shape / True-animate (~conic)
		Life_Time = 400.0,		--Lifetime (self-destruct timer), sec		
		Nr_max = 100,			--Maximum overload during turns		
		v_min = 50.0,	  		-- Minimum speed
		v_mid = 420.0,	  		-- Average Speed
		Mach_max = 2.0,			--Maximum Mach number
		t_b = 0.45,				--Engine start time
		t_acc = 15.0,			--Time of operation of the accelerator
		t_marsh = 15.0,			--Operating time in marching mode	
		Range_max = 140000.0,	--Maximum launch range at maximum altitude
		H_min_t = 1.0,			--Minimum height of the target above the terrain in meters		
		Fi_start = 9910.5, 		--Angle of tracking and sighting at launch (Angle off boresight)		
		Fi_rak = 3.14152,		--Acceptable angle of view of the target (radians)
        Fi_excort = 9911.05, 	--Angle of tracking (sight) of the target by the missile. (Gimbal Angle Limit)
        Fi_search = 9911.05, 	--Limit angle of free search (Field of View)
		OmViz_max = 9910.52,	--Maximum line-of-sight speed (Gimbl Ang Rate Lim 63°/s)
		warhead = warheads["AIM_120C"],	--Warhead type or definition		
        exhaust = {1.1, 1.1, 1.1, 0.05 };	--Exhaust definition
        X_back = -1.98,			--X coordinates of the nozzle center in the rocket axes
        Y_back = 0.0,			--Y coordinates of the nozzle center in the rocket axes
        Z_back = 0.0,			--Z coordinates of the nozzle center in the rocket axes
        Reflection = 0.0329,	--Effective radio reflection surface, square meters (RADAR cross section)
		KillDistance = 20.0,	--Distance is used to start the fuse
		loft = 1,				--Can missile loft to target based on range 0/1
		hoj = 1,				--Can missile home on an active jamming source 0/1
--		loft_factor = 4.5,			
		loft_factor = -0.1,		--NIGHTSTORM Reduced loft factor by 50% for new seeker code to avoid overshoot.  Max range ~110NM.		
		
		ccm_k0 = 0.001,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolute resistance to countermeasures. Default = 1 (medium probability)
--		go_active_by_default = 0,		--Seeker active by default 0/1
		go_active_by_default = 1,		--Seeker active by default 0/1		
		active_radar_lock_dist = 65000,	--Seeker lock maximaum range in meters

		PN_coeffs = {11,				 -- Number of Entries
					0.0, 1.0,
					4000.0, 0.295,
					5000.0, 0.19,
					6000.0, 0.17,
					7000.0, 0.14,
					10000.0, 0.12,
					15000.0, 0.10,
					20000.0, 0.09,
					30000.0, 0.08,
					40000.0, 0.07,
					100000.0, 0.05,
					};

		supersonic_A_coef_skew = 0.1, 	--The slope of the straight coefficient of the polar dump at supersonic
		nozzle_exit_area =	0.02322576, --Nozzle outlet area

		shape_table_data =
		{
			{
				name	 = "AIM_120C_7",
				file	 = "AIM-120C",
				life	 = 1,
				fire	 = { 0, 1},
				username = "AIM-120C",				
				index = WSTYPE_PLACEHOLDER,
			},
		},

		ModelData = {   58 ,  -- model params count
						0.4 ,   -- characteristic square (характеристическая площадь)
						
						-- Drag (Сx)  
						0.026 , -- Cx_k0 Cd0 at low mach ( M << 1) 
						0.025 , -- Cx_k1 Peak Cd0 value 
						0.02 , -- Cx_k2 steepness of the drag curve before the transonic wave crisis 
						0.026, -- Cx_k3 Cd0 at high mach (M>>1)
						1.25 , -- Cx_k4 steepness of the drag curve after the transonic wave crisis  
						1.2 , --“polar dump factor"
						
						-- Lift (Cy) 
						2.0 , -- Cy_k0 Clmax at low mach ( M << 1)
						1.50 , -- Cy_k0 Clmax at high mach ( M >> 1)
						1.4  , -- Cy_k2 steepness of the lift curve after the transonic wave crisis  
						
						0.5 , -- alpha max
						0.0, --Additional g’s due to thrust vectoring/rocket motors 
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end		-- Stage
						-1.0,	   	0.15,	440.0,  	0.0,		0.0,			0.0,		1.0e9,		-- time of stage, sec
						 0.1,		0.0,	1.01,		0.0,		0.0,			0.0,		0.0,		-- fuel flow rate in second, kg/sec
						 0.1,		0.0,	270.0,    	0.0,		0.0,			0.0,		0.0,		-- thrust, newtons		--NIGHTSTORM Values uses with LOFT enabled.				 

						 1.0e9, -- таймер самоликвидации, сек
						 420.0, -- lifetime in seconds							 
						 10000, -- Minimum height in M
						 2.0, -- Autopilot delay, sec
						 60000.0, -- Lofting logic Rmin 
						 80000.0, -- Range to target at which loft is complete (must be larger than previous value) in meters
						 0.52356,	-- Angle in radians of loft 
						 2000.0, -- longitudinal acceleration of fuse cocking
						 0.0, -- speed module communicated by a catapult device, expelling charge, etc.
						 1.19, -- characteristic of the SAU-RAKETA system, second-order filter coefficient K0
						 1.0, -- characteristic of the SAU-Raketa system, second order filter coefficient K1
						 2.0, -- characteristic of the SAU-RAKETA system, control loop bandwidth

					  -- DLZ. Data for calculating launch ranges (indication on the sight)
						21.0, 		-- range with respect to carrier speed at an altitude of 1 km
						-23.0, 		-- range with respect to target speed at an altitude of 1 km
						-3.0, 		-- derivative with respect to height of derivative of range with respect to target speed
						109200, 	-- range angle 180 degrees (towards), H = 5,000m, V = 900km / h, m	H = 16,404ft V = 486kts (58.96nm)
						37200, 		-- range angle 0 (in pursuit) deg, H = 5,000m, V = 900km / h, m  H = 16,404ft V = 486kts (20..09nm)
						180000,		-- range angle 180 (towards) deg, H = 10,000m, V = 900km / h, m  H = 32,808ft, V = 486kts  (97.19nm)
						70800, 		-- range angle 0 (in pursuit) deg, H = 10,000m, V = 900km / h, m  H = 32,808ft, V = 486kts  (38.23nm)
						74400, 		-- range angle 180 (towards) deg, H = 1,000m, V = 900km / h, m  H = 3,281ft, V = 486kts (40.17nm)
						21600, 		-- range angle 0 (in pursuit) deg, H = 1,000m, V = 900km / h, m  H = 3,281ft, V = 486kts (11.66m)
						4000, 		-- backward offset from the backsight point of the reachable zone
						0.4, 		-- percentage of guaranteed range from range in PPS at an altitude of 1 km
						-0.015, 	-- derivative of the percentage of guaranteed range in PPP by height
						0.5,		-- Changing the slope coefficients of the curve in the upper and lower hemispheres from the height of the carrier.




					}, 
					proximity_fuze = {
								ignore_inp_armed	= 1,
								radius		= 15,
								arm_delay	= 3.0,
													},
	}

declare_weapon(AIM_120C_7)


declare_loadout({
	category		= CAT_AIR_TO_AIR,
	CLSID			= "{AIM-120C-7}",
	Picture			= "us_AIM-120C.png",
	attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= AIM_120C_7.wsTypeOfWeapon,
	displayName		= _("AIM-120C-7 AMRAAM - Active Rdr AAM"),		
	Count			= 1,
	Weight			= 161.5,
	Elements		={
			[1] =
			{
				DrawArgs	=	
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
				Position	=	{0,	0,	0},
				ShapeName	=	"AIM-120C",
			},
		},
	}
)



--*******************************************AIM-120D*************************************************
--Used on F-15C and F-22A


local AIM_120D =	 {
		category		= CAT_AIR_TO_AIR,
		name			= "AIM_120D",
		user_name		= _("AIM-120D"),		
		wsTypeOfWeapon	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
		Escort = 0,				--0-No, 1-La launch, 2-other La, 3-C ground
		Head_Type = 2,			--1-InfraredSeeker, 2-ActiveRadar, 3-AntiRadar, 4-Laserhooming, 5-Autopilot (GPS, TV, IIR), 6-SemiActiveRadar, 7-SemiAutoAT (control from platform)
		sigma = {3, 3, 3},		-- Sigma = {x, y, z}, maximum aiming error in meters, in target coordinates. X-longitudinal axis of the target, y-axis virtualna purpose, Z - axis, transverse target
		M = 170.0,				--Gross weight in kg
		H_max = 26000.0,		--Maximum flight altitude in meters. 18Km=59100feet 20km = 65600
		H_min = 1.0,			--Minimum flight height in meters.
		Diam = 160.0,			--Case Diameter in mm
		Cx_pil = 2.5,			--Cx as suspension (Drag value is assumed)		
		D_max = 75000.0,		--Maximum Launch range at low altitude in meters
		D_min = 500.0,			--Minimum Launch range at low altitude in meters
		Head_Form = 1,			--False - hemispherical head shape / True-animate (~conic)
		Life_Time = 120.0,		--Lifetime (self-destruct timer), sec		
		Nr_max = 40,			--Maximum overload during turns		
		v_min = 140.0,	  		-- Minimum speed
		v_mid = 800.0,	  		-- Average Speed
		Mach_max = 6.0,			--Maximum Mach number
		t_b = 0.15,				--Engine start time
		t_acc = 5.0,			--Time of operation of the accelerator
		t_marsh = 25.0,			--Operating time in marching mode	
		Range_max = 180000.0,	--Maximum launch range at maximum altitude
		H_min_t = 1.0,			--Minimum height of the target above the terrain in meters		
		Fi_start = 0.5, 		--Angle of tracking and sighting at launch (Angle off boresight)		
		Fi_rak = 3.14152,		--Acceptable angle of view of the target (radians)
        Fi_excort = 1.05, 		--Angle of tracking (sight) of the target by the missile. (Gimbal Angle Limit)
        Fi_search = 1.05, 		--Limit angle of free search (Field of View)
		OmViz_max = 0.52,		--Maximum line-of-sight speed (Gimbl Ang Rate Lim 63°/s)
		warhead = warheads["AIM_120C"],	--Warhead type or definition		
        exhaust = {1.1, 1.1, 1.1, 0.05 };	--Exhaust definition
        X_back = -1.98,			--X coordinates of the nozzle center in the rocket axes
        Y_back = 0.0,			--Y coordinates of the nozzle center in the rocket axes
        Z_back = 0.0,			--Z coordinates of the nozzle center in the rocket axes
        Reflection = 0.0329,	--Effective radio reflection surface, square meters (RADAR cross section)
		KillDistance = 20.0,	--Distance is used to start the fuse
		loft = 1,				--Can missile loft to target based on range 0/1
		hoj = 1,				--Can missile home on an active jamming source 0/1
--		loft_factor = 4.5,			
		loft_factor = 2.25,		--NIGHTSTORM Reduced loft factor by 50% for new seeker code to avoid overshoot.  Max range ~110NM.		
		
		ccm_k0 = 0.001,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolute resistance to countermeasures. Default = 1 (medium probability)
--		go_active_by_default = 0,		--Seeker active by default 0/1
		go_active_by_default = 1,		--Seeker active by default 0/1		
		active_radar_lock_dist = 25000,	--Seeker lock maximaum range in meters

		PN_coeffs = {11,				 -- Number of Entries
					0.0, 1.0,
					4000.0, 0.995,
					5000.0, 0.99,
					6000.0, 0.97,
					7000.0, 0.94,
					10000.0, 0.80,
					15000.0, 0.50,
					20000.0, 0.35,
					30000.0, 0.20,
					40000.0, 0.14,
					100000.0, 0.05,
					};

		supersonic_A_coef_skew = 0.1, 	--The slope of the straight coefficient of the polar dump at supersonic
		nozzle_exit_area =	0.02322576, --Nozzle outlet area

		shape_table_data =
		{
			{
				name	 = "AIM-120D",
				file	 = "AIM-120D",
				life	 = 1,
				fire	 = { 0, 1},
				username = "AIM-120D",
				index = WSTYPE_PLACEHOLDER,
			},
		},

		ModelData = {   58 ,  -- model params count
						0.4 ,   -- characteristic square (характеристическая площадь)
						
						-- Drag (Сx)  
						0.016 , -- Cx_k0 Cd0 at low mach ( M << 1) 
						0.045 , -- Cx_k1 Peak Cd0 value 
						0.02 , -- Cx_k2 steepness of the drag curve before the transonic wave crisis 
						0.016, -- Cx_k3 Cd0 at high mach (M>>1)
						1.25 , -- Cx_k4 steepness of the drag curve after the transonic wave crisis  
						1.2 , --“polar dump factor"
						
						-- Lift (Cy) 
						1.40 , -- Cy_k0 Clmax at low mach ( M << 1)
						0.60 , -- Cy_k0 Clmax at high mach ( M >> 1)
						1.2  , -- Cy_k2 steepness of the lift curve after the transonic wave crisis  
						
						0.5 , -- alpha max
						0.0, --Additional g’s due to thrust vectoring/rocket motors 
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end		-- Stage
						-1.0,	   	0.15,	5.0,		25.0,		0.0,			0.0,		1.0e9,		-- time of stage, sec
						 0.0,		0.0,	6.67,		1.0,		0.0,			0.0,		0.0,		-- fuel flow rate in second, kg/sec
						 0.0,		0.0,	35000.0,	7000.0,		0.0,			0.0,		0.0,		-- thrust, newtons		--NIGHTSTORM Values uses with LOFT enabled.				 

						 1.0e9, -- таймер самоликвидации, сек
						 120.0, -- lifetime in seconds							 
						 0, -- Minimum height in M
						 2.0, -- Autopilot delay, sec
						 60000.0, -- Lofting logic Rmin 
						 80000.0, -- Range to target at which loft is complete (must be larger than previous value) in meters
						 0.52356,	-- Angle in radians of loft 
						 30.0, -- longitudinal acceleration of fuse cocking
						 0.0, -- speed module communicated by a catapult device, expelling charge, etc.
						 1.19, -- characteristic of the SAU-RAKETA system, second-order filter coefficient K0
						 1.0, -- characteristic of the SAU-Raketa system, second order filter coefficient K1
						 2.0, -- characteristic of the SAU-RAKETA system, control loop bandwidth

					  -- DLZ. Data for calculating launch ranges (indication on the sight)
						21.0, 		-- range with respect to carrier speed at an altitude of 1 km
						-23.0, 		-- range with respect to target speed at an altitude of 1 km
						-3.0, 		-- derivative with respect to height of derivative of range with respect to target speed
						109200, 	-- range angle 180 degrees (towards), H = 5,000m, V = 900km / h, m	H = 16,404ft V = 486kts (58.96nm)
						37200, 		-- range angle 0 (in pursuit) deg, H = 5,000m, V = 900km / h, m  H = 16,404ft V = 486kts (20..09nm)
						180000,		-- range angle 180 (towards) deg, H = 10,000m, V = 900km / h, m  H = 32,808ft, V = 486kts  (97.19nm)
						70800, 		-- range angle 0 (in pursuit) deg, H = 10,000m, V = 900km / h, m  H = 32,808ft, V = 486kts  (38.23nm)
						74400, 		-- range angle 180 (towards) deg, H = 1,000m, V = 900km / h, m  H = 3,281ft, V = 486kts (40.17nm)
						21600, 		-- range angle 0 (in pursuit) deg, H = 1,000m, V = 900km / h, m  H = 3,281ft, V = 486kts (11.66m)
						4000, 		-- backward offset from the backsight point of the reachable zone
						0.4, 		-- percentage of guaranteed range from range in PPS at an altitude of 1 km
						-0.015, 	-- derivative of the percentage of guaranteed range in PPP by height
						0.5,		-- Changing the slope coefficients of the curve in the upper and lower hemispheres from the height of the carrier.
					
					}, 
					proximity_fuze = {
								ignore_inp_armed	= 1,
								radius		= 15,
								arm_delay	= 3.0,
													},
	}

declare_weapon(AIM_120D)


declare_loadout({
	category		= CAT_AIR_TO_AIR,
	CLSID			= "{AIM-120D}",
	Picture			= "us_AIM-120D.png",
	attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= AIM_120D.wsTypeOfWeapon,
	displayName		= _("AIM-120D AMRAAM - Active Rdr AAM"),		
	Count			= 1,
	Weight			= 170,
	Elements		={
			[1] =
			{
				DrawArgs	=	
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
				Position	=	{0,	0,	0},
				ShapeName	=	"AIM-120D",
			},
		},
	}
)

--*******************************************CATM-120C*************************************************
local CATM_120C =	 {
		category		= CAT_AIR_TO_AIR,
		name			= "CATM_120C",
		user_name		= _("CATM-120C"),		
		wsTypeOfWeapon	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},

		shape_table_data =
		{
			{
				name	 = "CATM-120C",
				file	 = "CATM-120C",
				life	 = 1,
				fire	 = { 0, 1},
				username = "CATM-120C",
				index = WSTYPE_PLACEHOLDER,
			},
		},

        Escort = 0,				--0-No, 1-La launch, 2-other La, 3-C ground
        Head_Type = 5,			--1-InfraredSeeker, 2-ActiveRadar, 3-AntiRadar, 4-Laserhooming, 5-Autopilot (GPS, TV, IIR), 6-SemiActiveRadar, 7-SemiAutoAT (control from platform)
		sigma = {5, 5, 5},		-- Sigma = {x, y, z}, maximum aiming error in meters, in target coordinates. X-longitudinal axis of the target, y-axis virtualna purpose, Z - axis, transverse target
		M = 161.5,				--Gross weight in kg
        H_max = 0.0,			--Maximum flight altitude in meters. 18Km=59100feet 20km = 65600
        H_min = -1,				--Minimum flight height in meters.
		Diam = 160.0,			--Case Diameter in mm
 		Cx_pil = 2.5,			--Cx as suspension (Drag value is assumed)		
        D_max = 0.0,			--Maximum Launch range at low altitude in meters
        D_min = 0.0,			--Minimum Launch range at low altitude in meters
        Head_Form = 0,			--False - hemispherical head shape / True-animate (~conic)
        Life_Time = 0.0,		--Lifetime (self-destruct timer), sec		--NIGHTSTORM 60
        Nr_max = 0,				--Maximum overload during turns
		v_min = 0.0,	  		--Minimum speed
		v_mid = 0.0,	  		--Average Speed		
        Mach_max = 0.0,			--Maximum Mach number
        t_b = 0.0,				--Engine start time
        t_acc = 0.0,			--Time of operation of the accelerator
        t_marsh = 0.0,			--Operating time in marching mode
        Range_max = 0.0,		--Maximum launch range at maximum altitude	--NIGHTSTORM 14000
        H_min_t = 0.0,			--Minimum height of the target above the terrain in meters
        Fi_start = 1.57, 		--Angle of tracking and sighting at launch (Angle off boresight)
        Fi_rak = 3.14152,		--Acceptable angle of view of the target (radians)
        Fi_excort = 1.57, 		--Angle of tracking (sight) of the target by the missile. (Gimbal Angle Limit)
        Fi_search = 0.09, 		--Limit angle of free search (Field of View)
        OmViz_max = 1.10, 		--Maximum line-of-sight speed (Gimbl Ang Rate Lim 63°/s)
        warhead = simple_warhead(0.0001); -- inert warhead for training munition
        exhaust = { 0.0, 0.0, 0.0, 0.0 };	--Exhaust definition
		X_back = -1.92,			--X coordinates of the nozzle center in the rocket axes
        Y_back = 0.0,			--Y coordinates of the nozzle center in the rocket axes
        Z_back = 0.0,			--Z coordinates of the nozzle center in the rocket axes
        Reflection = 0.0182,	--Effective radio reflection surface, square meters (RADAR cross section)		--NIGHTSTORM 0.03
        KillDistance = 0.0,		--Distance is used to start the fuse		
	}

declare_weapon(CATM_120C)


declare_loadout({
	category		= CAT_AIR_TO_AIR,
	CLSID			= "{CATM-120C}",
	Picture			= "us_CATM-120C.png",
	attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= CATM_120C.wsTypeOfWeapon,
	displayName		= _("CATM-120C AMRAAM - Training Missile"),
	Count			= 1,
	Weight			= 161.5,
	Elements		={
			[1] =
			{
				DrawArgs	=	
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
				Position	=	{0,	0,	0},
				ShapeName	=	"CATM-120C",
			},
		},
	}
)


--*******************************************CATM-120C/AIM-120A/AIM-120C-6/AIM-120C-7/AIM-120D External***********************************************************************
--Used on F-22A

local aim120_variants =
{
	["AIM-120A"] 		= {display_name = _("AIM-120A AMRAAM - Active Rdr AAM"), Picture	=	"us_AIM-120A.png", PictureBlendColor = "0xffffffff", wstype = AIM_120A.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = 156.0},
	["AIM-120C-6"]  	= {display_name = _("AIM-120C-6 AMRAAM - Active Rdr AAM"), Picture	=	"us_AIM-120C.png", PictureBlendColor = "0xffffffff", wstype = AIM_120C_6.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = 161.5},	
	["AIM-120C-7"]  	= {display_name = _("AIM-120C-7 AMRAAM - Active Rdr AAM"), Picture	=	"us_AIM-120C.png", PictureBlendColor = "0xffffffff", wstype = AIM_120C_7.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = 161.5},
	["AIM-120D"] 		= {display_name = _("AIM-120D AMRAAM - Active Rdr AAM"), Picture	=	"us_AIM-120D.png", PictureBlendColor = "0xffffffff", wstype = AIM_120D.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = 170.0},
	["CATM-120C"]  		= {display_name = _("CATM-120C AMRAAM - Training Missile"), Picture	=	"us_CATM-120C.png", PictureBlendColor = "0xffffffff", wstype = CATM_120C.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = 170.0},	
}

local function lau_115_2x127_amraam(clsid,element,left,right)
	local var 	   = aim120_variants[element] or aim120_variants["AIM-120"]
	local var_mass = var.mass or 85.5
	
	local ret = {
		category			=	var.category,
		CLSID				=	clsid,
		Picture				=	var.Picture,
        PictureBlendColor   =   var.PictureBlendColor,
		wsTypeOfWeapon		=	var.wstype,
		attribute			=	{4,	4,	32,	WSTYPE_PLACEHOLDER},
		Cx_pil				=	0.001959765625,
		Elements 			= {{ShapeName	=	"LAU-115C+2_LAU127",IsAdapter  	   =   true  }}
	}
	if left then 	ret.Elements[#ret.Elements + 1] = {ShapeName	    =	 element,connector_name =	"Point03" }	end --rotation because LAU-127 have bugged connector pos
	if right then	ret.Elements[#ret.Elements + 1] = {ShapeName		=	 element,connector_name =	"Point02" }	end --rotation because LAU-127 have bugged connector pos
	
	local sz = #ret.Elements - 1
	ret.Count  = sz
	ret.Weight = lau115_weight + lau127_weight * 2 + var_mass * sz

	if sz > 1 then
		ret.displayName =	_("LAU-115 with").." 2 x LAU-127 "..var.display_name
	else
		ret.displayName =	_("LAU-115 with").." 1 x LAU-127 "..var.display_name
	end
	declare_loadout(ret)
end

lau_115_2x127_amraam("LAU-115_2*LAU-127_AIM-120A"	,"AIM-120A",true,true)
lau_115_2x127_amraam("LAU-115_2*LAU-127_AIM-120C-6"	,"AIM-120C-6",true,true)
lau_115_2x127_amraam("LAU-115_2*LAU-127_AIM-120C-7"	,"AIM-120C-7",true,true)
lau_115_2x127_amraam("LAU-115_2*LAU-127_AIM-120D"	,"AIM-120D",true,true)
lau_115_2x127_amraam("LAU-115_2*LAU-127_CATM-120C"	,"CATM-120C",true,true)

lau_115_2x127_amraam("{LAU-115 - AIM-120A}"		,"AIM-120A",true,false)
lau_115_2x127_amraam("{LAU-115 - AIM-120C-6}"	,"AIM-120C-6",true,false)
lau_115_2x127_amraam("{LAU-115 - AIM-120C-7}"	,"AIM-120C-7",true,false)
lau_115_2x127_amraam("{LAU-115 - AIM-120D}"		,"AIM-120D",true,false)
lau_115_2x127_amraam("{LAU-115 - CATM-120C}"	,"CATM-120C",true,false)

lau_115_2x127_amraam("{LAU-115 - AIM-120A_R}"	,"AIM-120A",false,true)
lau_115_2x127_amraam("{LAU-115 - AIM-120C-6_R}"	,"AIM-120C-6",false,true)
lau_115_2x127_amraam("{LAU-115 - AIM-120C-7_R}"	,"AIM-120C-7",false,true)
lau_115_2x127_amraam("{LAU-115 - AIM-120D_R}"	,"AIM-120D",false,true)
lau_115_2x127_amraam("{LAU-115 - CATM-120C_R}"	,"CATM-120C",false,true)

lau_115_2x127_amraam("{LAU-115 - AIM-120A}"		,"AIM-120A",false,true)
lau_115_2x127_amraam("{LAU-115 - AIM-120C-6}"	,"AIM-120C-6",false,true)
lau_115_2x127_amraam("{LAU-115 - AIM-120C-7}"	,"AIM-120C-7",false,true)
lau_115_2x127_amraam("{LAU-115 - AIM-120D}"		,"AIM-120D",false,true)
lau_115_2x127_amraam("{LAU-115 - CATM-120C}"	,"CATM-120C",true,false)




--*********************************************************CATM-9M/CATM-9X/AIM-9X-2/AIM-9X-3 External***********************************************************************
--Used on F-22A

local aim9_variants =
{

	["AIM-9X2"] 		= {picture = "us_AIM-9X.png",   CLSID = "{AIM-9X2}", display_name = _("AIM-9X-2 Sidewinder IR AAM"),  wstype = AIM_9X2.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = 85.5	},
	["AIM-9X3"] 		= {picture = "us_AIM-9X.png",   CLSID = "{AIM-9X3}", display_name = _("AIM-9X-3 Sidewinder IR AAM"),  wstype = AIM_9X3.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = 85.5	},	
	["CATM-9M"] 		= {picture = "us_CATM-9.png",   CLSID = "{CATM-9M}", display_name = _("CATM-9M"),  wstype = CATM_9M.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = 85.5	},		
	["CATM-9X"] 		= {picture = "us_CATM-9.png",   CLSID = "{CATM-9X}", display_name = _("us_AIM-9X3.png"),  wstype = CATM_9X.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = 85.5	},			

}


local function lau_115_2x127_sidewinder(clsid,element,left,right)
	local var 	   = aim9_variants[element] or aim9_variants["AIM-9P"]
	local var_mass = var.mass or 85.5
	
	local ret = {
		category			=	var.category,
		CLSID				=	clsid,
		Picture				=	var.picture,
        PictureBlendColor   = "0xffffffff",
		wsTypeOfWeapon		=	var.wstype,
		attribute			=	{4,	4,	32,	146},
		Cx_pil				=	0.00014,
		Elements 			= {{ShapeName	=	"LAU-115C+2_LAU127",IsAdapter  	   =   true  }}
	}
	if left then 	ret.Elements[#ret.Elements + 1] = {ShapeName	    =	 element,connector_name =	"Point03" }	end --rotation because LAU-127 have bugged connector pos
	if right then	ret.Elements[#ret.Elements + 1] = {ShapeName		=	 element,connector_name =	"Point02" }	end --rotation because LAU-127 have bugged connector pos
	
	local sz = #ret.Elements - 1
	ret.Count			= sz
	ret.Weight_Empty	= lau115_weight + lau127_weight * 2
	ret.Weight			= lau115_weight + lau127_weight * 2 + var_mass * sz

	if sz > 1 then
		ret.displayName =	_("LAU-115 with").." 2 x LAU-127 "..var.display_name
	else
		ret.displayName =	_("LAU-115 with").." 1 x LAU-127 "..var.display_name
	end
	declare_loadout(ret)
end

lau_115_2x127_sidewinder("LAU-115_2*LAU-127_AIM-9X2"	,"AIM-9X2",true,true)
lau_115_2x127_sidewinder("LAU-115_2*LAU-127_AIM-9X3"	,"AIM-9X3",true,true)
lau_115_2x127_sidewinder("LAU-115_2*LAU-127_CATM-9M"	,"CATM-9M",true,true)
lau_115_2x127_sidewinder("LAU-115_2*LAU-127_CATM-9X"	,"CATM-9X",true,true)

