-- View scripts 
-- Copyright (C) 2004, Eagle Dynamics.
DisableCombatViews				= false -- F5 & Ctrl-F5
ExternalObjectsLockDistance 	= 10000.0
ShowTargetInfo 					= false
CameraTerrainRestriction 		= true
hAngleCustomDefault 			=  0.0
vAngleCustomDefault 			= -8.0
vAngleCustomMin    				= -90.0
vAngleCustomMax    				= 90.0

UseGreenieBoardLandingDataHistory = true	-- For Carrier Air Wing Briefing Room
UseKillBoardDataHistory = true

--reformatted per-unit data to be mod system friendly 
--this file is no longer should be edited for adding new flyable aircraft , DCS automatically check core database (i.e. where you define your aircraft in aircraft table just define ViewSettings and SnapViews tables)

function default_fighter_player(t)
	local res = { 
		CameraViewAngleLimits  = {20.000000,140.000000},
		CameraAngleRestriction = {false	   ,90.000000,0.500000},
		EyePoint               = {0.05     ,0.000000 ,0.000000},
		limits_6DOF            = {x = {-0.050000,0.4500000},y ={-0.300000,0.100000},z = {-0.220000,0.220000},roll = 90.000000},
		Allow360rotation	   = false,
		CameraAngleLimits      = {200,-80.000000,110.000000},
		ShoulderSize 		   = 0.2,  -- move body when azimuth value more then 90 degrees
	}
	if t then 
		for i,o in pairs(t) do
			res[i] = o
		end
	end
	return res
end

function fulcrum()
	return {
		Cockpit = {
			default_fighter_player({CockpitLocalPoint = {4.71,1.28,0.000000}})
		},
		Chase   = {
			LocalPoint      = {1.220000,3.750000,0.000000},
			AnglesDefault   = {180.000000,-8.000000},
		}, -- Chase 
		Arcade = {
			LocalPoint      = {-15.080000,6.350000,0.000000},
			AnglesDefault   = {0.000000,-8.000000},
		}, -- Arcade 
	}
end

ViewSettings = {}



ViewSettings["MiG-29A"] 	= fulcrum()
ViewSettings["MiG-29G"] 	= fulcrum()
ViewSettings["MiG-29S"] 	= fulcrum()

ViewSettings["Su-25"] = {
	Cockpit = {
	[1] = default_fighter_player({CockpitLocalPoint      = {3.352000,0.506000,0.000000}}),-- player slot 1
	}, -- Cockpit 
	Chase = {
		LocalPoint      = {-0.348000,2.906000,0.000000},
		AnglesDefault   = {180.000000,-8.000000},
	}, -- Chase 
	Arcade = {
		LocalPoint      = {-16.648001,5.506000,0.000000},
		AnglesDefault   = {0.000000,-8.000000},
	}, -- Arcade 
}

ViewSettings["Su-25T"] = {
	Cockpit = {
	[1] = default_fighter_player({CockpitLocalPoint      = {3.406000,0.466000,0.000000}}),-- player slot 1
	}, -- Cockpit 
	Chase = {
		LocalPoint      = {-0.294000,2.866000,0.000000},
		AnglesDefault   = {180.000000,-8.000000},
	}, -- Chase 
	Arcade = {
		LocalPoint      = {-16.594000,5.466000,0.000000},
		AnglesDefault   = {0.000000,-8.000000},
	}, -- Arcade 
}

ViewSettings["Su-27"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["Su-33"] = ViewSettings["Su-27"]

ViewSettings["F-16C_50"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["FA-18C_hornet"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["M-2000C"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["F-14A-135-GR"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["F-14B"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["A-10C_2"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["AJS37"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["AV8BNA"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["F-15ESE"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["F-4E-45MC"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["J-11A"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["JF-17"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["EA-18G"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["FA-18E"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["FA-18F"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["T-45"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["AH-64D_BLKII"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["UH-1H"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["Mi-8MT"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["SA342Minigun"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["Mi-24P"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["Ka-50_3"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["OH58D"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["CH-47Fbl1"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["F4U-1D_CW"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["F-15C"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["F-14A-135-GR-Early"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["FW-190D9"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["F-86F Sabre"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["Bf-109K-4"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["MiG-21Bis"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["MiG-15Bis"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["C-101CC"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["C-101EB"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["L-39ZA"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["L-39C"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["SpitfireLFMkiXCW"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["Yak-52"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["Christen Eagle II"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["MiG-19P"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["I-16"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["FW-190A8"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["P-47D-40"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["MosquitoFBMkVI"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["Mirage-F1BE"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["Mirage-F1CE"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["Mirage-F1EE"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["MB-339A"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["MB-339APAN"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["P-51D-30-NA"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["F-5E-3"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["MiG-29 Fulcrum"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["C-130j-30"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["A-4E-C"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}

ViewSettings["A-10A"] = {
	Cockpit = {
	[1] = {	-- player slot 1
		
		ShoulderSize           = 0,
		Allow360rotation		 = true,
		limits_6DOF            = {x = {-50,50},y = {-50,50},z = {-50,50},roll =  90.000000}
	},
	}, -- Cockpit 
}
