--[[

This is the configuration page for the SatonoDiamond livery on the F-15E. You can customize it by adjusting the options below.
此为 F-15E 的 SatonoDiamond 涂装配置页面，您可以调整以下指定的几项配置来进行个性化调整

Please include this download link when sharing the livery: https://www.digitalcombatsimulator.com/en/files/3346480/
转发涂装时请附上此下载链接：https://www.digitalcombatsimulator.com/en/files/3346480/

]]--

name = "F-15E SatonoDiamond" 
-- Please DO NOT modify this entry, otherwise the livery will not be visible in multiplayer games.
-- 请_不要_修改此项，否则将无法在联机游戏中显示涂装

order = -500 
-- Changing this value will alter the livery's position in the selection list and affect which livery is auto-selected when using dynamic slots.
-- (A value of -500 moves it to the top of the list for auto-selection, while 500 moves it to the bottom. Deleting this line entirely will apply default alphabetical sorting.)
-- 改变此项可以更改涂装在涂装列表显示的位置，同时会影响到使用动态战位时自动选择的涂装
--（-500为排至列表最上层并自动选中，500为排至列表末尾，完全删除此行则为应用默认的字母排序）

livery = {

--The following are configurable options (it is recommended to use a code editor for editing)
------------------------- 以下为可配置项 (建议使用代码编辑器进行编辑) ---------------------------

-- #01 Enable(False)/Disable(True) Weapon Liveries
-- #01 启用(False)/禁用(True) 对应挂载物涂装
	{"AIM-9L",	    DIFFUSE					,	"aim-9m_diff"		, false}; -- AIM-9L
	{"AIM-9M",	    DIFFUSE					,	"aim-9m_diff"		, false}; -- AIM-9M
	{"AIM-7M",		DIFFUSE					,	"aim_7m_diff"		, false}; -- AIM-7M & AIM-7MH
	{"AIM_120С",	DIFFUSE					,	"aim_120c_diff"		, false}; -- AIM-120C
	--{"AIM_120B",	DIFFUSE					,	"aim_120c_diff"		, false}; -- AIM-120B
	{"F-15E_13",	0						,   "F-15E_E13_d"		, false}; -- DropTanks

-- #02 Enable(False)/Disable(True) High Fuel Flow Marking
-- #02 启用(False)/禁用(True) 高燃油流量标注 [前座-发动机状态显示器]
	{"FF1-10000",		0,	"emd_FF1", 		false};
	{"FF2-10000",		0,	"emd_FF1", 		false};

-- #03 Enable(False)/Disable(True) Cockpit photo
-- #03 启用(False)/禁用(True) 座舱照片
	{"F-15E_INT12",	 	0,	"F-15E_T12", 	false};

-- #04 Enable(False)/Disable(True) Canopy Sticker
-- #04 启用(False)/禁用(True) 座舱盖贴纸 [前座]
	{"GLASS_CANOPY",	0,	"f-15e_t0",  	false};

-- #05 Enable(False)/Disable(True) Canopy Rail Sticker
-- #05 启用(False)/禁用(True) 座舱盖轨道贴纸 [前座]
	{"F-15E_INT8",	DIFFUSE					,	"f-15e_t8"			, false};
	{"F-15E_INT8",	NORMAL_MAP				,	"f-15e_t8_nrm"		, false};
	{"F-15E_INT8",	ROUGHNESS_METALLIC		,	"f-15e_t8_roughmet"	, false};

-- #06 Enable(False)/Disable(True) Lock/Launch Light Recolor
-- #06 启用(False)/禁用(True) 锁定/发射灯换色 [前座-座舱盖导轨]
	{"Indicator LIGHTS_SHOOT",	DIFFUSE				,	"f-15e_lts1", false};
	{"Indicator LIGHTS_SHOOT",	SELF_ILLUMINATION	,	"f-15e_lts1", false};
	{"Indicator LIGHTS_SHOOTNVG",DIFFUSE			,	"f-15e_lts2", false};
	{"Indicator LIGHTS_SHOOTNVG",SELF_ILLUMINATION	,	"f-15e_lts2", false};

-- #07 Enable(False)/Disable(True) Backup Compass Recolor
-- #07 启用(False)/禁用(True) 备用罗盘换色 [前座-座舱盖导轨]
	{"F-15E_INT19",	DIFFUSE					,	"f-15e_t19"			, false};

-- #08 Enable(False)/Disable(True) RWR Symbol Memory Card
-- #08 启用(False)/禁用(True) RWR符号记忆卡 [前座-左侧控制台]
	{"F-15E_INT13",	DIFFUSE					,	"f-15e_t13"			, false};

-- #09 Enable(False)/Disable(True) DLZ and CMD Memory Card
-- #09 启用(False)/禁用(True) 动态发射区(DLZ)和对抗措施布撒(CMD)记忆卡 [前座-右侧控制台]
	{"F-15E_INT14",	DIFFUSE					,	"f-15e_t14"			, false};

-- #10 Enable(False)/Disable(True) Promotional Image Sticker
-- #10 启用(False)/禁用(True) 宣传图贴纸 [后座-左侧控制台]
	{"F-15E_INT33",	DIFFUSE					,	"f-15e_t33"			, false};
	{"F-15E_INT33",	ROUGHNESS_METALLIC		,	"f-15e_t33_roughmet", false};

-- #11 Enable(False)/Disable(True) Throttle Quadrant Arc Sticker
-- #11 启用(False)/禁用(True) 油门弧座贴纸 [11-前座/32-后座]
	{"F-15E_INT11",	DIFFUSE					,	"f-15e_t11"			, false};
	{"F-15E_INT32",	DIFFUSE					,	"f-15e_t32"			, false};


--------------------------------End of configurable options.---------------------------------
--------------------------------------- 以上为可配置项 ---------------------------------------

-- MISC
	{"F-15E_INT9",	DIFFUSE					,	"f-15e_t9"			, false};--MASTER_ARM
	{"F-15E_INT34",	DIFFUSE					,	"f-15e_t34"			, false};--WSO_R

-- NOSE
	{"F-15E_01",	0,	                "F-15E_E01_d",				false};
	{"F-15E_01",	1,	                "F-15E_E01_NRM",			false};
	{"F-15E_01",	ROUGHNESS_METALLIC,	"F-15E_E01_RoughMet", 		false};
	{"F-15E_01",	DECAL,	    		"F-15E_DECAL",				true};
	
-- TOP
	{"F-15E_02",	0,	                "F-15E_E02_d",				false};
	{"F-15E_02",	1,	                "F-15E_E02_NRM",			false};
	{"F-15E_02",	ROUGHNESS_METALLIC,	"F-15E_E02_RoughMet", 		false};

	{"F-15E_02SB",	0,	                "F-15E_E02_d",				false};
	{"F-15E_02SB",	1,	                "F-15E_E02_NRM",			false};
	{"F-15E_02SB",	ROUGHNESS_METALLIC,	"F-15E_E02_RoughMet", 		false};
	
-- BOTTOM
	{"F-15E_03",	0,	                "F-15E_E03_d",				false};
	{"F-15E_03",	1,	                "F-15E_E03_NRM",			false};
	{"F-15E_03",	ROUGHNESS_METALLIC,	"F-15E_E03_RoughMet", 		false};
	
-- WING1
	{"F-15E_04",	0,	                "F-15E_E04_d",				false};
	{"F-15E_04",	1,	                "F-15E_E04_NRM",			false};
	{"F-15E_04",	ROUGHNESS_METALLIC,	"F-15E_E04_RoughMet", 		false};
 --AILERON1	
 	{"F-15E_04AT",	0,	                "F-15E_E04_d",				false};
 	{"F-15E_04AT",	1,	                "F-15E_E04_NRM",			false};
 	{"F-15E_04AT",	ROUGHNESS_METALLIC,	"F-15E_E04_RoughMet", 		false};
 
 	{"F-15E_04AB",	0,	                "F-15E_E04_d",				false};
 	{"F-15E_04AB",	1,	                "F-15E_E04_NRM",			false};
 	{"F-15E_04AB",	ROUGHNESS_METALLIC,	"F-15E_E04_RoughMet", 		false};
 --FLAP1
 	{"F-15E_04FT",	0,	                "F-15E_E04_d",				false};
 	{"F-15E_04FT",	1,	                "F-15E_E04_NRM",			false};
 	{"F-15E_04FT",	ROUGHNESS_METALLIC,	"F-15E_E04_RoughMet", 		false};
 
 	{"F-15E_04FB",	0,	                "F-15E_E04_d",				false};
 	{"F-15E_04FB",	1,	                "F-15E_E04_NRM",			false};
 	{"F-15E_04FB",	ROUGHNESS_METALLIC,	"F-15E_E04_RoughMet", 		false};
 	
--- WING2
 	{"F-15E_05",	0,	                "F-15E_E05_d",				false};
 	{"F-15E_05",	1,	                "F-15E_E05_NRM",			false};
 	{"F-15E_05",	ROUGHNESS_METALLIC,	"F-15E_E05_RoughMet", 		false};
 --ALIERON2			
 	{"F-15E_05AT",	0,	                "F-15E_E05_d",				false};
 	{"F-15E_05AT",	1,	                "F-15E_E05_NRM",			false};
 	{"F-15E_05AT",	ROUGHNESS_METALLIC,	"F-15E_E05_RoughMet",	 	false};
 
 	{"F-15E_05AB",	0,	                "F-15E_E05_d",				false};
 	{"F-15E_05AB",	1,	                "F-15E_E05_NRM",			false};
 	{"F-15E_05AB",	ROUGHNESS_METALLIC,	"F-15E_E05_RoughMet", 		false};
 --FLAP2
 	{"F-15E_05FT",	0,	                "F-15E_E05_d",				false};
 	{"F-15E_05FT",	1,	                "F-15E_E05_NRM",			false};
 	{"F-15E_05FT",	ROUGHNESS_METALLIC,	"F-15E_E05_RoughMet", 		false};
 
 	{"F-15E_05FB",	0,	                "F-15E_E05_d",				false};
 	{"F-15E_05FB",	1,	                "F-15E_E05_NRM",			false};
 	{"F-15E_05FB",	ROUGHNESS_METALLIC,	"F-15E_E05_RoughMet", 		false};
 
--- TAIL
 	{"F-15E_06",	0,	                "f-15e_e06_d.dds",			false};
 	{"F-15E_06",	1,	                "F-15E_E06_NRM",			false};
 	{"F-15E_06",	ROUGHNESS_METALLIC,	"F-15E_E06_RoughMet", 		false};
 	{"F-15E_06",	DECAL,	    		"F-15E_DECAL",				true};
 --LEFT STAB
 	{"F-15E_06LS",	0,	                "F-15E_E06_d",				false};
 	{"F-15E_06LS",	1,	                "F-15E_E06_NRM",			false};
 	{"F-15E_06LS",	ROUGHNESS_METALLIC,	"F-15E_E06_RoughMet", 		false};
 	{"F-15E_06LS",	DECAL,	    		"F-15E_DECAL",				true};
 --RIGHT STAB	
 	{"F-15E_06RS",	0,	                "F-15E_E06_d",				false};
 	{"F-15E_06RS",	1,	                "F-15E_E06_NRM",			false};
 	{"F-15E_06RS",	ROUGHNESS_METALLIC,	"F-15E_E06_RoughMet", 		false};
 	{"F-15E_06RS",	DECAL,	    		"F-15E_DECAL",				true};
 --LEFT RUDDER	
 	{"F-15E_06LR",	0,	                "F-15E_E06_d",				false};
 	{"F-15E_06LR",	1,	                "F-15E_E06_NRM",			false};
 	{"F-15E_06LR",	ROUGHNESS_METALLIC,	"F-15E_E06_RoughMet", 		false};
 	{"F-15E_06LR",	DECAL,	    		"F-15E_DECAL",				true};
 --RIGHT RUDDER
 	{"F-15E_06RR",	0,	                "F-15E_E06_d",				false};
 	{"F-15E_06RR",	1,	                "F-15E_E06_NRM",			false};
 	{"F-15E_06RR",	ROUGHNESS_METALLIC,	"F-15E_E06_RoughMet",		false};
 	{"F-15E_06RR",	DECAL,	    		"F-15E_DECAL",				true};

-- CFT
	{"F-15E_07",	0,	                "F-15E_E07_d",				false};
	{"F-15E_07",	1,	                "F-15E_E07_NRM",			true};
	{"F-15E_07",	ROUGHNESS_METALLIC,	"F-15E_E07_RoughMet",		true};
	{"F-15E_07",	DECAL,	    		"F-15E_DECAL",				true};
	
-- EXTRA
	{"F-15E_08",	0,	                "F-15E_E08_d",				false};
	{"F-15E_08",	1,	                "F-15E_E08_NRM",			true};
	{"F-15E_08",	ROUGHNESS_METALLIC,	"F-15E_E08_RoughMet", 		true};
	
-- DROP TANKS
	{"F-15E_13",	1,	                "F-15E_E13_NRM",			true};
	{"F-15E_13",	ROUGHNESS_METALLIC,	"F-15E_E13_RoughMet", 		true};
	
-- NAVPOD PYLON
	{"F-15E_14",	0,	                "F-15E_E14_d",				false};
	{"F-15E_14",	1,	                "F-15E_E14_NRM",			true};
	{"F-15E_14",	ROUGHNESS_METALLIC,	"F-15E_E14_RoughMet", 		true};

--NUMBER----------------------------------------------------------------------------------------
--[[
--F-15E_NOSE-NUMBER
	{"F-15E_REFUEL-NUMBER",	0,	                "F-15E_NOSE_Numbers", false};
	
--F-15E_TAIL-NUMBER                             
    {"F-15E_TAIL-NUMBER",	0,	                "F-15E_TAIL_Numbers", false};

--F-15E_TAIL-NUMBER-L
 	{"F-15E_TAIL-NUMBER-L",	0,	                "F-15E_E06", false};
 	{"F-15E_TAIL-NUMBER-L",	1,	                "F-15E_E06_NRM", true};
 	{"F-15E_TAIL-NUMBER-L",	ROUGHNESS_METALLIC,	"F-15E_E06_RoughMet", true};
    {"F-15E_TAIL-NUMBER-L",	DECAL,	            "F-15E_TAIL_Numbers", false};
	
--F-15E_TAIL-NUMBER-R                             
 	{"F-15E_TAIL-NUMBER-R",	0,	                "F-15E_E06", false};
 	{"F-15E_TAIL-NUMBER-R",	1,	                "F-15E_E06_NRM", true};
 	{"F-15E_TAIL-NUMBER-R",	ROUGHNESS_METALLIC,	"F-15E_E06_RoughMet", true};
    {"F-15E_TAIL-NUMBER-R",	DECAL,	            "F-15E_TAIL_Numbers", false};
]]


--F-15E_REFUEL-DECAL	
    {"F-15E_REFUEL-DECAL",	0,	                "f-15e_tail_satono_decal",		false};

--F-15E_REFUEL-NUMBER
    {"F-15E_REFUEL-NUMBER",	0,	                "f-15e_satono_numbers",			false};
	
--F-15E_TAIL-DECAL	
	{"F-15E_TAIL-DECAL",	0,	                "empty",						true};

--F-15E_TAIL-NUMBER                             
	{"F-15E_TAIL-NUMBER",	0,	                "empty",						true};

--F-15E_TAIL-DECAL-L	
   	--{"F-15E_TAIL-DECAL-L",	0,	                "F-15E_E06_d",				false};
	--{"F-15E_TAIL-DECAL-L",	1,	                "F-15E_E06_NRM",			false};
	--{"F-15E_TAIL-DECAL-L",	ROUGHNESS_METALLIC,	"F-15E_E06_RoughMet", 		false};
    --{"F-15E_TAIL-DECAL-L",	DECAL,	            "F-15E_TAIL_AF",			false};

--F-15E_TAIL-DECAL-R
    --{"F-15E_TAIL-DECAL-R",	0,	                "F-15E_E06_d",				false};
	--{"F-15E_TAIL-DECAL-R",	1,	                "F-15E_E06_NRM",			false};
	--{"F-15E_TAIL-DECAL-R",	ROUGHNESS_METALLIC,	"F-15E_E06_RoughMet", 		false};
    --{"F-15E_TAIL-DECAL-R",	DECAL,	            "F-15E_TAIL_AF",			false};

--F-15E_TAIL-NUMBER-L
 	{"F-15E_TAIL-NUMBER-L",	0,	                "F-15E_E06_d",					false};
 	--{"F-15E_TAIL-NUMBER-L",	1,	                "F-15E_E06_NRM",			false};
 	--{"F-15E_TAIL-NUMBER-L",	ROUGHNESS_METALLIC,	"F-15E_E06_RoughMet",		false};
	{"F-15E_TAIL-NUMBER-L",	DECAL,	            "empty",						true};
	
--F-15E_TAIL-NUMBER-R                             
 	{"F-15E_TAIL-NUMBER-R",	0,	                "F-15E_E06_d",					false};
 	--{"F-15E_TAIL-NUMBER-R",	1,	                "F-15E_E06_NRM",			false};
 	--{"F-15E_TAIL-NUMBER-R",	ROUGHNESS_METALLIC,	"F-15E_E06_RoughMet", 		false};
	{"F-15E_TAIL-NUMBER-R",	DECAL,	            "empty",						true};


--PILOT
	{"F-15EC_05",	0,	                "F-15E_EC05A1",					true};
	{"F-15EC_05",	1,	                "F-15E_EC05_NRM",				true};
	{"F-15EC_05",	ROUGHNESS_METALLIC,	"F-15E_EC05_RoughMet", 			true};

	{"F-15EC_06",	0,	                "F-15E_EC06A1",					true};
	{"F-15EC_06",	1,	                "F-15E_EC06_NRM",				true};
	{"F-15EC_06",	ROUGHNESS_METALLIC,	"F-15E_EC06_RoughMet", 			true};

	{"F-15EC_07",	0,	                "F-15E_EC07",					true};
	{"F-15EC_07",	1,	                "F-15E_EC07_NRM",				true};
	{"F-15EC_07",	ROUGHNESS_METALLIC,	"F-15E_EC07_RoughMet", 			true};
--    {"F-15EC_07",	DECAL,	            "F-15EC_07_Decal",				true};

--WSO
	{"F-15EC_05R",	0,	                "F-15E_EC05A1",					true};
	{"F-15EC_05R",	1,	                "F-15E_EC05_NRM",				true};
	{"F-15EC_05R",	ROUGHNESS_METALLIC,	"F-15E_EC05_RoughMet", 			true};

	{"F-15EC_06R",	0,	                "F-15E_EC06A1",					true};
	{"F-15EC_06R",	1,	                "F-15E_EC06_NRM",				true};
	{"F-15EC_06R",	ROUGHNESS_METALLIC,	"F-15E_EC06_RoughMet", 			true};

	{"F-15EC_07R",	0,	                "F-15E_EC07",					true};
	{"F-15EC_07R",	1,	                "F-15E_EC07_NRM",				true};
	{"F-15EC_07R",	ROUGHNESS_METALLIC,	"F-15E_EC07_RoughMet", 			true};
--    {"F-15EC_07R",	DECAL,	            "F-15EC_07_Decal",			true};


-----------------------------VR/OTHER PILOTS-----------------------------------------

--PILOT
	{"F-15E_VR-Pilot1",	0,	                	"F-15E_TP1A1",				true};
	{"F-15E_VR-Pilot1",	1,	                	"F-15E_TP1_NRM",			true};
	{"F-15E_VR-Pilot1",	ROUGHNESS_METALLIC,		"F-15E_TP1_RoughMet", 		true};

	{"F-15E_VR-Pilot2",	0,	                	"F-15E_TP2A1",				true};
	{"F-15E_VR-Pilot2",	1,	                	"F-15E_TP2_NRM",			true};
	{"F-15E_VR-Pilot2",	ROUGHNESS_METALLIC,		"F-15E_TP2_RoughMet", 		true};

	{"F-15E_VR-Pilot3",	0,	                	"F-15E_TP3",				true};
	{"F-15E_VR-Pilot3",	1,	                	"F-15E_TP3_NRM",			true};
	{"F-15E_VR-Pilot3",	ROUGHNESS_METALLIC,		"F-15E_TP3_RoughMet", 		true};

--WSO
	{"F-15E_VR-Pilot1R",	0,	                "F-15E_TP1A1",				true};
	{"F-15E_VR-Pilot1R",	1,	                "F-15E_TP1_NRM",			true};
	{"F-15E_VR-Pilot1R",	ROUGHNESS_METALLIC,	"F-15E_TP1_RoughMet", 		true};

	{"F-15E_VR-Pilot2R",	0,	                "F-15E_TP2A1",				true};
	{"F-15E_VR-Pilot2R",	1,	                "F-15E_TP2_NRM",			true};
	{"F-15E_VR-Pilot2R",	ROUGHNESS_METALLIC,	"F-15E_TP2_RoughMet", 		true};

	{"F-15E_VR-Pilot3R",	0,	                "F-15E_TP3",				true};
	{"F-15E_VR-Pilot3R",	1,	                "F-15E_TP3_NRM",			true};
	{"F-15E_VR-Pilot3R",	ROUGHNESS_METALLIC,	"F-15E_TP3_RoughMet", 		true};

--Visor
	{"F-15EC_07_Visor",	0,	                	"F-15E_EC07",				true};
	{"F-15EC_07_Visor",	1,	                	"F-15E_EC07_NRM",			true};
	{"F-15EC_07_Visor",	ROUGHNESS_METALLIC,		"F-15E_EC07_RoughMet", 		true};

	{"F-15EC_07R_Visor",	0,	                "F-15E_EC07",				true};
	{"F-15EC_07R_Visor",	1,	                "F-15E_EC07_NRM",			true};
	{"F-15EC_07R_Visor",	ROUGHNESS_METALLIC,	"F-15E_EC07_RoughMet", 		true};
}


--name = "15E_SatonoDiamond"
--name = "[F-15E] (!TEST!) SatonoDiamond"
countries = {ALL}


custom_args = 
{
[32]   = 0.5, -- 1
[31]   = 0.6, -- 10
[442]  = 0.7, -- 100 
[1000] = 0.4, -- change of type of board number (0.0 - No Numbers, 0.1 - 3 Numbers, 0.2 - 4 Numbers starts with "1", 0.3 - Full 4 Numbers, 0.4 - IDF Numbers)
[1001] = 0.1, -- vis refuel board number (0.0 - No Numbers, 0.1 Numbers, 0.2 - Numbers Early)
[1002] = 0.4, -- change of type intake board number (0.4 - IDF Nose/Fuselage Numbers and Model Change)
[1003] = 0.4, -- vis Nose Gear board number (0.0 - 4 Numbers 0.0 to 0.05 adjusts the placement, 0.1 - 5 Numbers, 0.4 - No Numbers)
}

