--
-- file prepared: 6 September 2025 21:47:22.265, using fd689c
--
self_ID = "lightning"
declare_plugin(self_ID,
{
	displayName = _("lightning"),
	developerName = _("Half Science, the 'clay pigeon' series"),  --see artistic credits in the readme.txt

	image = "FC.bmp",
	installed = true,
	dirName = current_mod_path,
	fileMenuName = _("lightning"),

	version = " ",
	state = "installed",
	info = _("The English Electric Lightning is a British fighter aircraft that served as an interceptor during the 1960s, the 1970s and into the late 1980s. The Lightning was designed and developed as an interceptor to defend the airfields of the British 'V bomber' strategic nuclear force from attack by anticipated future nuclear-armed supersonic Soviet bombers such as the Tupolev Tu-22 'Blinder'. With a top speed above Mach 2, the Lightning has exceptional rate of climb and described by some of its pilots as 'being saddled to a skyrocket'. This performance, and the initially limited fuel supply, confined it to missions of limited range. Overwing fuel tank fittings were installed in the F6 variant and gave an extended range, but limited maximum speed to a reported 1,000 miles per hour (1,600 km/h). Later variants were employed for aerial reconnaissance and ground-attack. It was operated by the Royal Air Force (RAF), the Kuwait Air Force (KAF), and the Royal Saudi Air Force (RSAF). source: https://en.wikipedia.org/wiki/English_Electric_Lightning#Specifications_(Lightning_F.6) "),

	update_id = "lightning",

	Skins =
	{
		{
			name = _("lightning"),
			dir = "Theme"
		},
	},
	Missions =
	{
		{
			name = _("lightning"),
			dir = "Missions",
		},
	},
	LogBook =
	{
		{
			name = _("lightning"),
			type = "lightning",
		},
	},
	InputProfiles =
	{
		["lightning"] = current_mod_path .. '/Input/lightning',
	},
})
----------------------------------------------------------------------------------------
mount_vfs_texture_path(current_mod_path.."/Textures")
mount_vfs_model_path(current_mod_path.."/Shapes")
dofile(current_mod_path.."/Views.lua")
dofile(current_mod_path.."/weapons.lua")
make_view_settings('lightning', ViewSettings, SnapViews)
make_flyable('lightning', current_mod_path..'/Cockpit/Scripts/', { nil, old = 54 }, current_mod_path..'/comm.lua')
dofile(current_mod_path..'/lightning.lua')
------------------------------------------------------------------------------------ -
plugin_done()

