-- Specified by device_init.lua, but called by EDGE
-- Responsible for loading the model (shape_name) for the cockpit,
-- as well as connecting parameters to animation args via Gauges

dofile(LockOn_Options.script_path.."/Utilities/logging.lua")  -- Mod logging functions
-- dofile(LockOn_Options.script_path.."/Utilities/dump_data.lua")  -- Debug scripts

local aircraft = get_aircraft_type()
FCCLOG.info("Current aircraft: " .. aircraft)
shape_name = ""

-- Set the clickable cockpit model based on the current aircraft
if aircraft == "A-10A" then
  shape_name = "FCClickable_A-10A"
elseif aircraft == "F-5E-3_FC" then
  shape_name = "FCClickable_F-5E"
elseif aircraft == "F-15C" then
  shape_name = "FCClickable_F-15C"
elseif aircraft == "F-86F_FC" then
  shape_name = "FCClickable_F-86"
elseif aircraft == "MiG-15bis_FC" then
  shape_name = "FCClickable_MiG-15"
elseif aircraft == "MiG-29A" or aircraft == "MiG-29G" or aircraft == "MiG-29S" then
  shape_name = "FCClickable_MiG-29"
elseif aircraft == "Su-25" then
  shape_name = "FCClickable_Su-25"
elseif aircraft == "Su-25T" then
  shape_name = "FCClickable_Su-25T"
elseif aircraft == "Su-27" or aircraft == "J-11A" then
  shape_name = "FCClickable_Su-27"
elseif aircraft == "Su-33" then
  shape_name = "FCClickable_Su-33"
end

FCCLOG.info("SHAPE set to " .. shape_name)

local controllers = LoRegisterPanelControls()
-- dump_table(controllers)  -- Print all of the parameters to the log
-- show_param_handles_list()  -- Opens a window in-game to show the values of different parameters in real-time

-- Animation "gauges" declared here
-- These will match the animated position of our connectors to the state of the actual cockpit
--
-- Because these animations are driven by the gauges and not user input, we must tell the connectors to update
-- their positions periodically or they won't move.
-- This is handled by the device FCC_ANIMATOR (clickable_animator.lua)
FCC_CANOPY                    = CreateGauge()
FCC_CANOPY.arg_number         = 1
FCC_CANOPY.input              = {0,1}
FCC_CANOPY.output             = {0,1}
FCC_CANOPY.controller         = controllers.base_gauge_CanopyPos

FCC_GEARLEVER                 = CreateGauge()
FCC_GEARLEVER.arg_number      = 2
FCC_GEARLEVER.input           = {0,1}
FCC_GEARLEVER.output          = {1,0}  -- This is inverted for some reason
FCC_GEARLEVER.controller      = controllers.base_gauge_LandingGearHandlePos

-- FCCLOG.info("mainpanel_init INIT")

need_to_be_closed = true
