--
-- file prepared:  2025 00:57:07.190, using fd653a
--
--SFM_characteristics.lua (file 2 for assembly)

yak23 = {

	Name = 'yak23',

	DisplayName = _('yak23'),
	ViewSettings = ViewSettings,
	Countries = { "Abkhazia","Australia","Austria","Belarus","Belgium","Brazil","Bulgaria","Canada","China",
			 "Croatia","Czech Republic","Denmark","Egypt","ESA","Finland","France","Georgia",
			 "German Empire","Germany","Greece","Hungary","Imperial Japan","India","Insurgents","Iran",
			 "Iraq","Israel","Italy","Japan","Kazakhstan","NASA","North Korea","Norway",
			 "Pakistan","Poland","Romania","Russia","Saudi Arabia","Serbia","Slovakia","South Korea",
			 "South Ossetia","Spain","Sweden","Switzerland","Syria","The Netherlands","Third Reich","Turkey","UK",
			 "Ukraine","USA","USAF Aggressors","USSR","Vietnam"},

	HumanCockpit = false,
	HumanCockpitPath = current_mod_path..'/Cockpit/',
	Picture = "yak23.png",
	Rate = 50,
	Shape = "yak23",

	shape_table_data =
	{
		{
			file = 'yak23';
			life = 20;
			vis = 3;
			fire = { 300, 2};
			username = 'yak23';
			index = WSTYPE_PLACEHOLDER;
		},
	},
	------------------------ -
	mapclasskey = "P0091000024",
	attribute = {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER, "Multirole fighters", "Refuelable", "Datalink", "Link16"},
	Categories = {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},

	---------	General	Characteristics	---------
	length = 8.13,
	height = 3.31,
	wing_area = 13.5,
	wing_span = 8.73,
	wing_tip_pos = { 0.8, 1, 4.5},
	RCS = 1.5,											-- (estimated from height, length and wing surface area)
	air_refuel_receptacle_pos = { 0, 0, 0},
	has_speedbrake = true,								-- default
	brakeshute_name = 4,								-- default
	is_tanker = false,									-- default
	tanker_type = 2,									-- default
	stores_number = 8,
	wing_type = 0,										-- default
	crew_size = 1,										-- default
	crew_size = 1,										-- default

	------- Weight & Fuel Characteristics -------
	M_empty = 1980,
	M_nominal = 3384,
	M_max = 4250,
	M_fuel_max = 850,
	H_max = 14813,										-- (calculated from service_ceiling)
	CAS_min = 57,
	average_fuel_consumption = 1,						-- default

	----------_ AI Flight Parameters -----------
	V_opt = 184,
	V_take_off = 59,
	V_land = 56,								-- note: default calculation override for yak23
	V_max_sea_level = 119,
	V_max_h = 142,
	Vy_max = 47,
	Mach_max = 0.77,
	Ny_min = -3,										-- default
	Ny_max = 8,											-- default
	Ny_max_e = 8,										-- default
	AOA_take_off = 0.16,								-- default
	bank_angle_max = 60,								-- default
	range = 3000,										-- default
	flaps_maneuver = 1,									-- default

	-------- Suspension Characteristics -------
	and_gear_max = 1,									-- default
	nose_gear_pos = { 1.25, -0.4, 0},
	nose_gear_wheel_diameter = 0.5,						-- default
	nose_gear_amortizer_direct_stroke = 0.05,			-- default
	nose_gear_amortizer_reversal_stroke = -0.25,		-- default
	nose_gear_amortizer_normal_weight_stroke = -0.05,	-- default
	main_gear_pos = { 0.7, -0.36, 0.98},
	main_gear_wheel_diameter = 0.75,					-- default
	main_gear_amortizer_direct_stroke = 0.1,			-- default
	main_gear_amortizer_reversal_stroke = -0.275,		-- default
	main_gear_amortizer_normal_weight_stroke = -0.1,	-- default

	---------- Engine Characteristics ---------
	has_afteburner = false,
	thrust_sum_max = 1588.6,
	thrust_sum_ab = 1588.6,
	engines_count = 1,
	IR_emission_coeff = 0.05,							-- default
	IR_emission_coeff_ab = 0.05,						-- default

	--------- Sensors Characteristics ---------
	detection_range_max = 250,							-- default
	radar_can_see_ground = true,						-- default


---------------------------------------------------------------------------------------------------------------------------------------------

	crew_members =
	{
		[1] =
		{
			ejection_seat_name = 9,
			drop_canopy_name = "aircraft_canopy",
			canopy_pos = {1.25, 0.55, 0},
			canopy_ejection_dir = {0.0, 0.5, -0.5},
			pos = {1.25, -0.4, 0},
		}, --end of[1]
		--[2] =
		--{
			--ejection_seat_name = 9,
			--drop_canopy_name = "aircraft_canopy_2",
			--canopy_pos = {1.25, 0.55, 0},
			--canopy_ejection_dir = {0.0, 0.5, 0.5},
			--pos = {1.25, -0.4, 0},
			--canopy_arg = 421,
		--}, --end of[2]
	}, --end of crew_members

---------------------------------------------------------------------------------------------------------------------------------------------


	--------- Engine, nozzles and exhaust ---------

	engines_nozzles = {
		[1] =
		{
			pos = {-0.5, 0.5, 0},
			elevation = 0.5,
			diameter = 0.675,							-- default
			exhaust_length_ab = 3,						-- default
			exhaust_length_ab_K = 0.707,				-- default
			smokiness_level = 0.2,
		}, -- end of [1]
	}, -- end of engines_nozzles


---------------------------------------------------------------------------------------------------------------------------------------------


	Guns = {
		Nr37({ muzzle_pos = {3.75, 0.5, 0.35},_connector =  "Point_Gun_02",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		Nr23({ muzzle_pos = {3.75, 0.5, -0.35},_connector =  "Point_Gun_03",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
	},


	Pylons = {
		pylon(1, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon1", arg = 308, arg_value = 0,
			},
			{
			} 
		),
		pylon(2, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon2", arg = 309, arg_value = 0,
			},
			{
			} 
		),
		pylon(3, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon3", arg = 310, arg_value = 0,
			},
			{
			} 
		),
		pylon(4, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon4", arg = 311, arg_value = 0,
			},
			{
			} 
		),
		pylon(5, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon5", arg = 312, arg_value = 0,
			},
			{
			} 
		),
		pylon(6, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon6", arg = 313, arg_value = 0,
			},
			{
			} 
		),
		pylon(7, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon7", arg = 314, arg_value = 0,
			},
			{
			} 
		),
		pylon(8, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon8", arg = 315, arg_value = 0,
			},
			{
			} 
		),
	},

---------------------------------------------------------------------------------------------------------------------------------------------

		 -- calibrate_countermeasures 

---------------------------------------------------------------------------------------------------------------------------------------------



	fires_pos =
	{
		[1] = { -0.125, 1, 0.0},
		[2] = { -0.05, 1, 0.35},
		[3] = { -0.075, 1, -0.35},
		[4] = { 1, 1, 1.125},
		[5] = { 1, 1, -1.125},
		[6] = { 1, 1, 3.6},
		[7] = { 1, 1, -3.6},
		[8] = { -0.5, 0.5, 0.35},
		[9] = { -0.5, 0.5, -0.35},
		[10] = { -0.25, 1, 0.35},
		[11] = { -0.25, 1, -0.35},
	},	-- end of fires_pos

---------------------------------------------------------------------------------------------------------------------------------------------


--(file 3 for aessembly)

	--[[
	fires_pos =
	{
		[1] = 	{-1.594,	-0.064,		0},
		[2] = 	{-1.073,	0.319,		2.304},
		[3] = 	{-1.187,	0.338,		-4.678},
		[4] = 	{-0.82,		0.265,		2.774},
		[5] = 	{-0.82,		0.265,		-2.774},
		[6] = 	{-0.82,		0.255,		4.274},
		[7] = 	{-0.82,		0.255,		-4.274},
		[8] = 	{-5.889,	-0.257,		1.193},
		[9] = 	{-5.889,	-0.257,		-1.193},
		[10] = 	{-1.257,	0.283,		3.05},
		[11] = 	{-1.257,	0.283,		-3.05},
	}, -- end of fires_pos
	]]--

	--[[

	-- Countermeasures
	passivCounterm = {
		CMDS_Edit = true,
		SingleChargeTotal = 128,
		-- PPR-26
		chaff = {default = 64, increment = 3, chargeSz = 1},
		-- PPI-26
		flare = {default = 64, increment = 3, chargeSz = 1}
	},
	]]--

	attribute 		= { wsType_Air, wsType_Airplane, wsType_Fighter, Su_34,"Bombers", "Refuelable"},
	CanopyGeometry	=  makeAirplaneCanopyGeometry(LOOK_GOOD, LOOK_AVERAGE, LOOK_AVERAGE),
	
	--[[
	Sensors =
	{
		RADAR = "N-011M",
		OPTIC = "Su-34 FLIR",
		RWR   = "Abstract RWR"
	},
	]]--

	Tasks =
	{
		aircraft_task(AFAC),
		aircraft_task(SEAD),
		aircraft_task(AntishipStrike),
		aircraft_task(CAS),
		aircraft_task(CAP),
		aircraft_task(Intercept),
		aircraft_task(PinpointStrike),
		aircraft_task(GroundAttack),
		aircraft_task(RunwayAttack),
	},
	DefaultTask = aircraft_task(CAP),

	--SFM_aerodynamics.lua (file 4 for assembly)

	SFM_Data = {
		aerodynamics = --Cx = Cx_0 + Cy ^ 2 * B2 + Cy ^ 4 * B4
		{

			Cy0 = 0,
			Mzalfa = 4.355,					-- default
			Mzalfadt = 0.8,					-- default
			kjx = 3,						-- default
			kjz = 0.00125,					-- default
			Czbe = -0.016,					-- default
			cx_gear = 0.02,					-- default
			cx_flap = 0.08,					-- default
			cy_flap = 0.25,					-- default
			cx_brk = 0.1,					-- default

			table_data = {
				--M     Cx0     Cya     B       B4      Omxmax  Aldop   Cymax
				{0,		0.015,	0.0439,	0.0458,	0.0085,	2.3,	11.7,	0.515,		},
				{0.1,	0.015,	0.0398,	0.0458,	0.0085,	6.25,	13,	0.515,		},
				{0.2,	0.015,	0.0499,	0.0458,	0.0085,	6.25,	14.3,	0.715,		},
				{0.3,	0.015,	0.0888,	0.0458,	0.0085,	6.25,	15.8,	1.28,		},
				{0.4,	0.015,	0.128,	0.0458,	0.0085,	6.25,	17.5,	2,		},
				{0.5,	0.015,	0.104,	0.0409,	0.0115,	6.25,	17.5,	1.85,		},
				{0.6,	0.015,	0.0876,	0.0358,	0.0141,	6.25,	17.5,	1.56,		},
				{0.7,	0.015,	0.0733,	0.0325,	0.0183,	6.25,	17.5,	1.31,		},
				{0.8,	0.0213,	0.0619,	0.0176,	0.0139,	2.3,	17.5,	1.1,		},
				{0.9,	0.0575,	0.03,	0.00145,	0.00019,	2.01,	17.5,	1,		},
				{1,		0.0675,	0.03,	0.0015,	0.0002,	1.76,	16.6,	0.951,		},
				{1.1,	0.0775,	0.03,	0.00155,	0.00021,	1.54,	15.8,	0.905,		},
			}, --end of table_data
		}, --end of aerodynamics
		engine = 
		{
			Nmg = 50,					-- default
			MinRUD = 0,
			MaxRUD = 1,
			MaksRUD  = 1,
			ForsRUD  = 1,
			typeng  = 0,
			hMaxEng	= 19,				-- default
			dcx_eng = 0.015,			-- default
			cemax  = 1.24,				-- default
			cefor  = 2.56,				-- default
			dpdh_m = 1000,
			dpdh_f = 2000,

			--[[			table_data = {
				--M 	Pmax	Pafb
				{0,	5791,	5791,		},
				{0.2,	8686,	8686,		},
				{0.4,	11582,	11582,		},
				{0.6,	11582,	11582,		},
				{0.8,	11582,	11582,		},
				{1,	11582,	11582,		},
				{1.2,	11582,	11582,		},
				{1.4,	11582,	11582,		},
				{1.6,	11582,	11582,		},
				{1.8,	11582,	11582,		},
				{2,	8686,	8686,		},
				{2.2,	5791,	5791,		},
			}, --end of table_data
			--]]

			table_data = {
				--M 	Pmax	Pafb
				{0.0,	0.0,	0.0,		},
				{ 2.0,	0.0,	0.0,		},
			}, --end of table_data


			--[[
				engine calibration worksheet (for in-game testing)
				alt     	vel		adj
				0 k ft		0.m		adj:+/-
				15 k ft		0.m		adj:+/-
				32 k ft		0.m		adj:+/-
				33 k ft		0.m		adj:+/-
				40 k ft		0.m		adj:+/-
				46 k ft		0.m		adj:+/-
				50 k ft		0.m		adj:+/-
				52 k ft		0.m		adj:+/-
			]]--

			extended = {

				thrust_max = {
					M = { 0.000000, 0.200000, 0.400000, 0.600000, 0.800000, 1.000000, 1.200000, 1.400000, 1.600000, 1.800000, 2.000000, 2.200000, }, 
					H = { 0, 4571, 9753, 10241, 12487, 14048, 15297, 15999 }, 
					thrust = {
						{ 5451,   8176,   10902,  10902,  10902,  10902,  10902,  10902,  10902,  10902,  10902,  10902  }, 
						{ 5781,   8672,   11562,  11562,  11562,  11562,  11562,  11562,  11562,  11562,  11562,  11562  }, 
						{ 5258,   7887,   10516,  10516,  10516,  10516,  10516,  10516,  10516,  10516,  10516,  10516  }, 
						{ 4418,   6627,   8837,   8837,   8837,   8837,   8837,   8837,   8837,   8837,   8837,   8837   }, 
						{ 2920,   4380,   5840,   5840,   5840,   5840,   5840,   5840,   5840,   5840,   5840,   5840   }, 
						{ 2920,   4380,   5840,   5840,   5840,   5840,   5840,   5840,   5840,   5840,   5840,   5840   }, 
						{ 2571,   3857,   5142,   5142,   5142,   5142,   5142,   5142,   5142,   5142,   5142,   5142   }, 
						{ 311,    467,    623,    623,    623,    623,    623,    623,    623,    623,    623,    623    }, 
					}, -- thrust = {

				}, --thrust_max = {

				thrust_afterburner  = {
					M = { 0.000000, 0.200000, 0.400000, 0.600000, 0.800000, 1.000000, 1.200000, 1.400000, 1.600000, 1.800000, 2.000000, 2.200000, }, 
					H = { 0, 4571, 9753, 10241, 12487, 14048, 15297, 15999 }, 
					thrust = {
						{ 5451,   8176,   10902,  10902,  10902,  10902,  10902,  10902,  10902,  10902,  10902,  10902  }, 
						{ 5781,   8672,   11562,  11562,  11562,  11562,  11562,  11562,  11562,  11562,  11562,  11562  }, 
						{ 5258,   7887,   10516,  10516,  10516,  10516,  10516,  10516,  10516,  10516,  10516,  10516  }, 
						{ 4418,   6627,   8837,   8837,   8837,   8837,   8837,   8837,   8837,   8837,   8837,   8837   }, 
						{ 2920,   4380,   5840,   5840,   5840,   5840,   5840,   5840,   5840,   5840,   5840,   5840   }, 
						{ 2920,   4380,   5840,   5840,   5840,   5840,   5840,   5840,   5840,   5840,   5840,   5840   }, 
						{ 2571,   3857,   5142,   5142,   5142,   5142,   5142,   5142,   5142,   5142,   5142,   5142   }, 
						{ 311,    467,    623,    623,    623,    623,    623,    623,    623,    623,    623,    623    }, 
					}, -- thrust = {

				}, --thrust_afterburner = {

			}, -- extended = {

		}, --end of engine

	},

	DamageParts =
	{
		[1] = "yak23-collision",
	},

	-- (file 5 for aessembly)

	-- new
	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
		[0]		= {critical_damage = 5, args = {146}},
		[3]		= {critical_damage = 20,args = {65}}  ,
		[4]		= {critical_damage = 20, args = {150}},
		[5]		= {critical_damage = 20, args = {147}},
		[7]		= {critical_damage = 4, args = {249}} ,
		[9]		= {critical_damage = 3, args = {154}},
		[10]	= {critical_damage = 3, args = {153}},
		[11]	= {critical_damage = 3, args = {167}},
		[12]	= {critical_damage = 3, args = {161}},
		[15]	= {critical_damage = 5, args = {267}},
		[16]	= {critical_damage = 5, args = {266}},
		[23]	= {critical_damage = 8, args = {223}, deps_cells = {25}},
		[24]	= {critical_damage = 8, args = {213}, deps_cells = {26, 60}},
		[25]	= {critical_damage = 3, args = {226}},
		[26]	= {critical_damage = 3, args = {216}},
		[29]	= {critical_damage = 9, args = {224}, deps_cells = {31, 25, 23}},
		[30]	= {critical_damage = 9, args = {214}, deps_cells = {32, 26, 24, 60}},
		[31]	= {critical_damage = 4, args = {229}},
		[32]	= {critical_damage = 4, args = {219}},
		[35]	= {critical_damage = 10, args = {225}, deps_cells = {29, 31, 25, 23}},
		[36]	= {critical_damage = 10, args = {215}, deps_cells = {30, 32, 26, 24, 60}} ,
		[37]	= {critical_damage = 4, args = {227}},
		[38]	= {critical_damage = 4, args = {217}},
		[39]	= {critical_damage = 7,	args = {244}, deps_cells = {53}},
		[40]	= {critical_damage = 7, args = {241}, deps_cells = {54}},
		[45]	= {critical_damage = 9, args = {235}, deps_cells = {39, 51, 53}},
		[46]	= {critical_damage = 9, args = {233}, deps_cells = {40, 52, 54}},
		[51]	= {critical_damage = 3, args = {239}},
		[52]	= {critical_damage = 3, args = {237}},
		[53]	= {critical_damage = 3, args = {248}},
		[54]	= {critical_damage = 3, args = {247}},
		[55]	= {critical_damage = 20, args = {81}, deps_cells = {39, 40, 45, 46, 51, 52, 53, 54}},
		[59]	= {critical_damage = 5, args = {148}},
		[60]	= {critical_damage = 1, args = {144}},

		[83]	= {critical_damage = 3, args = {134}} ,-- nose wheel
		[84]	= {critical_damage = 3, args = {136}}, -- left wheel
		[85]	= {critical_damage = 3, args = {135}} ,-- right wheel
	},


	-- solve triangle to have B_end == C_end with given A
	-- B_start assumed to be A_start
	-- C_start assumed to be A_end
	
	SolveTriangles = 
	{
		-- left gear post kinematics 
		{
			A_start   = "bracing_centr004",
			A_end     = "bracing_centr003",
			B_end     = "bracing_004",
			B_control = 484,
			C_end	  = "bracing_003",
			C_control = 483,
			B_scale   =  1/math.rad(46);
			C_scale   =  1/math.rad(25);
		},
		-- right gear post kinematics 
		{
			A_start   = "bracing_centr006",
			A_end     = "bracing_centr005",
			B_end     = "bracing_006",
			B_control = 486,
			C_end	  = "bracing_005",
			C_control = 485,
			B_scale   =  1/math.rad(46);
			C_scale   =  1/math.rad(25);
		},
	},  --SolveTriangles


}



--SFM_add.lua (file 6 for assembly)

add_aircraft(yak23)


