
SU22M4 =  {
      
		Name 			= 'SU22M4',--AG
		DisplayName		= _('Su-22M4'),--AG
        Picture 		= "Su-17M4.png",
        Rate 			= "50",	
        WorldID			=  48, --WSTYPE_PLACEHOLDER
        Shape			= "SU22M4",--AG
        
	shape_table_data 	= 
	{
		{
			file  	 	= 'SU22M4';--AG
			life  	 	= 15; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    	= 'f-4e-oblomok'; -- Name of destroyed object file name
			fire  	 	= { 300, 2}; 			-- Fire on the ground after destoyed: 300sec 2m
			username	= 'SU22M4';--AG
			index       =  48;
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
		},
		{
			name  		= "f-4e-oblomok";
			file  		= "f-4e-oblomok";
			fire  		= { 240, 2};
		},
	},
	
	LandRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of LandRWCategories
        TakeOffRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of TakeOffRWCategories
	
	mapclasskey 		= "P0091000024",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, 48, "Fighters", "Refuelable", "Datalink", "Link16"},
	Categories= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},
	
		M_empty						=	10670,	-- kg  with pilot and nose load, F15
		M_nominal					=	15230,	-- kg (Empty Plus Full Internal Fuel)
		M_max						=	19430,	-- kg (Maximum Take Off Weight)
		M_fuel_max					=	3770,	-- kg (Internal Fuel Only)
		H_max						=	15200,	-- m  (Maximum Operational Ceiling)
		average_fuel_consumption	=	0.06,
		CAS_min						=	58,		-- Minimum CAS speed (m/s) (for AI)
		V_opt						=	220,	-- Cruise speed (m/s) (for AI)
		V_take_off					=	61,		-- Take off speed in m/s (for AI)
		V_land						=	71,		-- Land speed in m/s (for AI)
		has_afteburner				=	true,
		has_speedbrake				=	true,
		radar_can_see_ground		=	true,
		input_profile_entry = 	"SU22M4",

		nose_gear_pos 				                = {3.875, -1.81, 0},   -- nosegear coord 
	    nose_gear_amortizer_direct_stroke   		=  0,  -- down from nose_gear_pos !!!
	    nose_gear_amortizer_reversal_stroke  		=  0,  -- up 
	    nose_gear_amortizer_normal_weight_stroke 	=  0,   -- up 
	    nose_gear_wheel_diameter 	                =  0.754, -- in m
	
	    main_gear_pos 						 	    = {-1.691, -1.637, 1.939}, -- main gear coords 
	    main_gear_amortizer_direct_stroke	 	    =   0, --  down from main_gear_pos !!!
	    main_gear_amortizer_reversal_stroke  	    =   0, --  up 
	    main_gear_amortizer_normal_weight_stroke    =   0,-- down from main_gear_pos
	    main_gear_wheel_diameter 				    =   0.972, -- in m

		AOA_take_off				=	0.14,	-- AoA in take off (for AI)
		stores_number				=	8,
		bank_angle_max				=	60,		-- Max bank angle (for AI)
		Ny_min						=	-2,		-- Min G (for AI)
		Ny_max						=	6,		-- Max G (for AI)
		V_max_sea_level				=	423,	-- Max speed at sea level in m/s (for AI)
		V_max_h						=	736.11,	-- Max speed at max altitude in m/s (for AI)
		wing_area					=	38.5,	-- wing area in m2
		thrust_sum_max				=	7800,	-- thrust in kgf (64.3 kN)
		thrust_sum_ab				=	11250,	-- thrust in kgf (95.1 kN)
		Vy_max						=	200,	-- Max climb speed in m/s (for AI)
		flaps_maneuver				=	1,
		Mach_max					=	1.7,	-- Max speed in Mach (for AI)
		range						=	1760,	-- Max range in km (for AI)
		RCS							=	7,		-- Radar Cross Section m2
		Ny_max_e					=	6,		-- Max G (for AI)
		detection_range_max			=	50,
		IR_emission_coeff			=	0.68,	-- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
		IR_emission_coeff_ab		=	3,		-- With afterburner
		tand_gear_max				=	0.58,--XX  1.732 FA18 3.73, 
		tanker_type					=	0,--F14=2/S33=4/ M29=0/S27=0/F15=1/ F16=1/To=0/F18=2/A10A=1/ M29K=4/F4=0/
		wing_span					=	13.68,--XX  wing spain in m
		wing_type 					= 	1,-- 0=FIXED_WING/ 1=VARIABLE_GEOMETRY/ 2=FOLDED_WING/ 3=ARIABLE_GEOMETRY_FOLDED
		length						=	19.26,
		height						=	5.13,
		crew_size					=	1, --XX
		engines_count				=	1, --XX
		wing_tip_pos 				= 	{-4, -0.2, 6.75},
		
		--EPLRS 						= true,--?
		TACAN_AA					= true,--?
		launch_bar_connected_arg_value	= 0.815,--0.885,--0.745
		
		mechanimations = {
        Door0 = {
            {Transition = {"Close", "Open"},  Sequence = {{C = {{"Arg", 38, "to", 0.9, "in", 9.0},},},}, Flags = {"Reversible"},},
            {Transition = {"Open", "Close"},  Sequence = {{C = {{"Arg", 38, "to", 0.0, "in", 6.0},},},}, Flags = {"Reversible", "StepsBackwards"},},
            {Transition = {"Any", "Bailout"}, Sequence = {{C = {{"JettisonCanopy", 0},},},},},
        },
        FoldableWings = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"Arg", 8, "to", 0.0, "in", 5.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Extend", "Retract"}, Sequence = {{C = {{"Arg", 8, "to", 1.0, "in", 5.0}}}}, Flags = {"Reversible", "StepsBackwards"}},
        },
		ServiceHatches = {--Parkposition
            {Transition = {"Close", "Open"}, Sequence = {{C = {{"PosType", 3}, {"Sleep", "for", 30.0}}}, {C = {{"Arg", 24, "set", 1.0}}}}},
            {Transition = {"Open", "Close"}, Sequence = {{C = {{"PosType", 6}, {"Sleep", "for", 5.0}}}, {C = {{"Arg", 24, "set", 0.0}}}}},
        },
        LaunchBar = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"ChangeDriveTo", "HydraulicGravityAssisted"}, {"VelType", 3}, {"Arg", 85, "to", 0.881, "in", 4.4}}}}},
            {Transition = {"Retract", "Stage"},  Sequence = {{C = {{"ChangeDriveTo", "HydraulicGravityAssisted"}, {"VelType", 3}, {"Arg", 85, "to", 0.815, "in", 4.4}}}}},
			{Transition = {"Any", "Retract"},  Sequence = {{C = {{"ChangeDriveTo", "Hydraulic"}, {"VelType", 2}, {"Arg", 85, "to", 0.000, "in", 4.5}}}}},
            {Transition = {"Extend", "Stage"},   Sequence = {
                    {C = {{"ChangeDriveTo", "Mechanical"}, {"Sleep", "for", 0.000}}},
                    {C = {{"Arg", 85, "from", 0.881, "to", 0.766, "in", 0.600}}},
                    {C = {{"Arg", 85, "from", 0.766, "to", 0.753, "in", 0.300}}},
                    {C = {{"Sleep", "for", 0.45}}},
                    {C = {{"Arg", 85, "from", 0.753, "to", 0.784, "in", 0.1, "sign", 2}}},
                    {C = {{"Arg", 85, "from", 0.784, "to", 0.881, "in", 1.0}}},
                },
            },
			{Transition = {"Stage", "Pull"},  Sequence = {
					{C = {{"ChangeDriveTo", "Mechanical"}, {"VelType", 2}, {"Arg", 85,"from", 0.881, "to", launch_bar_connected_arg_value_, "in", 0.15}}},
					{C = {{"ChangeDriveTo", "Mechanical"}, {"VelType", 2}, {"Arg", 85, "to", 0.78, "speed", 0.1}}},
					{C = {{"ChangeDriveTo", "Mechanical"}, {"VelType", 2}, {"Arg", 85, "to", 0.7792, "speed", 0.02}}},
					}
			},
            {Transition = {"Stage", "Extend"},   Sequence = {{C = {{"ChangeDriveTo", "HydraulicGravityAssisted"}, {"VelType", 3}, {"Arg", 85, "from", 0.815, "to", 0.881, "in", 0.2}}}}},
        },
    }, -- end of mechanimations
		
		engines_nozzles = 
		{
			[1] = 
			{
				pos = 	{-8.596, 0.216, 0},
				elevation	=	0,--3.7
				diameter	=	1.00,--0.965
				exhaust_length_ab	=	8.6,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.4, 
				--afterburner_effect_texture = "afterburner_f-18c",
			}, -- end of [1]
		}, -- end of engines_nozzles
		crew_members = 
		{
			[1] = 
			{
				ejection_seat_name	=	9,
				drop_canopy_name	=	44,
				pos = 	{4.2, 1.3, 0},
				role = "pilot",
				role_display_name = "Pilot",
			}, -- end of [1]
		}, -- end of crew_members
		brakeshute_name	=	4,
		is_tanker	=	false,
		air_refuel_receptacle_pos = 	{0,	0,	0},
		fires_pos = 
		{
			[1] = 	{-0.664,	-0.496,	0},
			[2] = 	{0.173,	-0.307,	1.511},
			[3] = 	{0.173,	-0.307,	-1.511},
			[4] = 	{-0.82,	0.265,	1.774},
			[5] = 	{-0.82,	0.265,	-1.774},
			[6] = 	{-0.82,	0.255,	2.274},
			[7] = 	{-0.82,	0.255,	-2.274},
			[8] = 	{-6.899,	-0.212,	0.611},
			[9] = 	{-6.899,	-0.212,	-0.611},
			[10] = 	{-0.896,	1.118,	0},
			[11] = 	{0.445,	-0.436,	0},
		}, -- end of fires_pos
		
		effects_presets = {
			{effect = "OVERWING_VAPOR", file = current_mod_path.."/Effects/SU22M4_overwingVapor.lua"},
		},
		
		chaff_flare_dispenser = 
		{
			[1] = 
			{
				dir = 	{0,	1,	0.3},
				pos = 	{-8.5, 0.5, 0},
			}, -- end of [1]
			[2] = 
			{
				dir = 	{0,	1,	-0.3},
				pos = 	{-8.5, 0.5, 0},
			}, -- end of [2]
		}, -- end of chaff_flare_dispenser

        -- Countermeasures
passivCounterm 		= {
CMDS_Edit 			= true,
SingleChargeTotal 	= 128,
chaff 				= {default = 64, increment = 32, chargeSz = 1},
flare 				= {default = 64, increment = 32, chargeSz = 1}
 },
	
	
        CanopyGeometry 	= {
            azimuth 	= {-145.0, 145.0},-- pilot view horizontal (AI)
            elevation 	= {-50.0, 90.0}-- pilot view vertical (AI)
        },

Sensors = {
RADAR 	= "Kopyo",
OPTIC = "Shkval",
RWR 	= "Abstract RWR"
},
Countermeasures = {
--ECM 			= "AN/ALQ-135"
},
	Failures = {
			{ id = 'asc', 		label = _('ASC'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'autopilot', label = _('AUTOPILOT'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hydro',  	label = _('HYDRO'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'l_engine',  label = _('L-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'r_engine',  label = _('R-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'radar',  	label = _('RADAR'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  --{ id = 'eos',  		label = _('EOS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  --{ id = 'helmet',  	label = _('HELMET'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mlws',  	label = _('MLWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'rws',  		label = _('RWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'ecm',   	label = _('ECM'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hud',  		label = _('HUD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mfd',  		label = _('MFD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },		
	},
	HumanRadio = {
		frequency 		= 127.5,  -- Radio Freq
		editable 		= true,
		minFrequency	= 100.000,
		maxFrequency 	= 156.000,
		modulation 		= MODULATION_AM
	},

Guns = {gun_mount("M_61", { count = 240 },{muzzle_pos = {2.544, 0.113, -0.953}}),
},

pylons_enumeration = {3, 6, 4, 5, 1, 8, 2, 7},

	Pylons =     {

        pylon(1, 1, -1.784, -0.43, -2.526,
            {
                --
            },
            {
			    { CLSID	= "{FB3CE165-BF07-4979-887C-92B87F13276B}" },
			    { CLSID	= "{0511E528-EA28-4caf-A212-00D1408DF10A}" },
			    { CLSID	= "{37DCC01E-9E02-432F-B61D-10C166CA2798}" },
			    { CLSID	= "{D5435F26-F120-4FA3-9867-34ACE562EF1B}" },
			    { CLSID	= "{7AEC222D-C523-425e-B714-719C0D1EB14D}" },
			    { CLSID	= "{96A7F676-F956-404A-AD04-F33FB2C74884}" },
			    { CLSID	= "{96A7F676-F956-404A-AD04-F33FB2C74881}" },
			    { CLSID	= "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}" },
			    { CLSID	= "{BD289E34-DF84-4C5E-9220-4B14C346E79D}" },
			    { CLSID	= "{6A367BB4-327F-4A04-8D9E-6D86BDC98E7E}" },
			    { CLSID	= "{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}" },
			    { CLSID	= "{5A1AC2B4-CA4B-4D09-A1AF-AC52FBC4B60B}" },
			    { CLSID	= "{E659C4BE-2CD8-4472-8C08-3F28ACB61A8A}" },
			    { CLSID	= "{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}" },
			    { CLSID	= "{E86C5AA5-6D49-4F00-AD2E-79A62D6DDE26}" },
			    { CLSID	= "{292960BB-6518-41AC-BADA-210D65D5073C}" },
			    { CLSID	= "{414E383A-59EB-41BC-8566-2B5E0788ED1F}" },
			    { CLSID	= "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}" },
			    { CLSID	= "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}" },
			    { CLSID	= "{FC56DF80-9B09-44C5-8976-DCFAFF219062}" },
			    { CLSID	= "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}" },
			    { CLSID	= "{A0648264-4BC0-4EE8-A543-D119F6BA4257}" },
			    { CLSID	= "{S_25_O}" },
			    { CLSID	= "{3DFB7320-AB0E-11d7-9897-000476191836}" },
			    { CLSID	= "{4203753F-8198-4E85-9924-6F8FF679F9FF}" },
			    { CLSID	= "{RBK_250_275_AO_1SCH}" },
			    { CLSID	= "{Kh-25MP}" },
			    { CLSID	= "B-8M1 - 20 S-8OFP2" },
			    { CLSID	= "{PTB_800_MIG21}" },
			    { CLSID	= "{X-29L}", attach_point_position = {0.0, 0.02 , 0.0} },
			    { CLSID	= "{X-29T}", attach_point_position = {0.0, 0.02 , 0.0} },
            }
        ),
		pylon(2, 0, 0.46, -0.304, -1.853,
            {
                --
            },
            {
			    { CLSID	= "{APU-60-1_R_60M}" }, --R60M
			    { CLSID	= "{R-60}" }, --R60
			    { CLSID	= "{FBC29BFE-3D24-4C64-B81D-941239D12249}", attach_point_position = {-0.1, 0.0 , 0.0} }, --R73
            }
        ),
        pylon(3, 0, 1.5, -0.384, -1.22,
            {
                --
            },
            {
			    { CLSID	= "{FB3CE165-BF07-4979-887C-92B87F13276B}" },
			    { CLSID	= "{0511E528-EA28-4caf-A212-00D1408DF10A}" },
			    { CLSID	= "{37DCC01E-9E02-432F-B61D-10C166CA2798}" },
			    { CLSID	= "{D5435F26-F120-4FA3-9867-34ACE562EF1B}" },
			    { CLSID	= "{7AEC222D-C523-425e-B714-719C0D1EB14D}" },
			    { CLSID	= "{96A7F676-F956-404A-AD04-F33FB2C74884}" },
			    { CLSID	= "{96A7F676-F956-404A-AD04-F33FB2C74881}" },
			    { CLSID	= "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}" },
			    { CLSID	= "{BD289E34-DF84-4C5E-9220-4B14C346E79D}" },
			    { CLSID	= "{6A367BB4-327F-4A04-8D9E-6D86BDC98E7E}" },
			    { CLSID	= "{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}" },
			    { CLSID	= "{5A1AC2B4-CA4B-4D09-A1AF-AC52FBC4B60B}" },
			    { CLSID	= "{E659C4BE-2CD8-4472-8C08-3F28ACB61A8A}" },
			    { CLSID	= "{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}" },
			    { CLSID	= "{E86C5AA5-6D49-4F00-AD2E-79A62D6DDE26}" },
			    { CLSID	= "{292960BB-6518-41AC-BADA-210D65D5073C}" },
			    { CLSID	= "{414E383A-59EB-41BC-8566-2B5E0788ED1F}" },
			    { CLSID	= "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}" },
			    { CLSID	= "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}" },
			    { CLSID	= "{FC56DF80-9B09-44C5-8976-DCFAFF219062}" },
			    { CLSID	= "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}" },
			    { CLSID	= "{A0648264-4BC0-4EE8-A543-D119F6BA4257}" },
			    { CLSID	= "{S_25_O}" },
			    { CLSID	= "{3DFB7320-AB0E-11d7-9897-000476191836}" },
			    { CLSID	= "{4203753F-8198-4E85-9924-6F8FF679F9FF}" },
			    { CLSID	= "{RBK_250_275_AO_1SCH}" },
			    { CLSID	= "{Kh-25MP}" },
			    { CLSID	= "B-8M1 - 20 S-8OFP2" },
			    { CLSID	= "{PTB_800_MIG21}" },
			    { CLSID	= "{X-29L}", attach_point_position = {0.0, 0.02 , 0.0} },
			    { CLSID	= "{X-29T}", attach_point_position = {0.0, 0.02 , 0.0} },
            }
        ),
        pylon(4, 1, 1.18, -0.745, -0.417,
            {
                --
            },
            {
			    { CLSID	= "{FB3CE165-BF07-4979-887C-92B87F13276B}" },
			    { CLSID	= "{0511E528-EA28-4caf-A212-00D1408DF10A}" },
			    { CLSID	= "{37DCC01E-9E02-432F-B61D-10C166CA2798}" },
			    { CLSID	= "{D5435F26-F120-4FA3-9867-34ACE562EF1B}" },
			    { CLSID	= "{7AEC222D-C523-425e-B714-719C0D1EB14D}" },
			    { CLSID	= "{96A7F676-F956-404A-AD04-F33FB2C74884}" },
			    { CLSID	= "{96A7F676-F956-404A-AD04-F33FB2C74881}" },
			    { CLSID	= "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}" },
			    { CLSID	= "{BD289E34-DF84-4C5E-9220-4B14C346E79D}" },
			    { CLSID	= "{6A367BB4-327F-4A04-8D9E-6D86BDC98E7E}" },
			    { CLSID	= "{5A1AC2B4-CA4B-4D09-A1AF-AC52FBC4B60B}" },
			    { CLSID	= "{E659C4BE-2CD8-4472-8C08-3F28ACB61A8A}" },
			    { CLSID	= "{414E383A-59EB-41BC-8566-2B5E0788ED1F}" },
			    { CLSID	= "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}" },
			    { CLSID	= "{4203753F-8198-4E85-9924-6F8FF679F9FF}" },
			    { CLSID	= "{RBK_250_275_AO_1SCH}" },
			    { CLSID	= "{PTB_800_MIG21}" },
			    { CLSID	= "{0519A264-0AB6-11d6-9193-00A0249B6F00}", attach_point_position = {0.0, 0.2 , 0.417} },
            }
        ),
        pylon(5, 1, 1.18, -0.745, 0.417,
            {
                --
            },
            {
			    { CLSID	= "{FB3CE165-BF07-4979-887C-92B87F13276B}" },
			    { CLSID	= "{0511E528-EA28-4caf-A212-00D1408DF10A}" },
			    { CLSID	= "{37DCC01E-9E02-432F-B61D-10C166CA2798}" },
			    { CLSID	= "{D5435F26-F120-4FA3-9867-34ACE562EF1B}" },
			    { CLSID	= "{7AEC222D-C523-425e-B714-719C0D1EB14D}" },
			    { CLSID	= "{96A7F676-F956-404A-AD04-F33FB2C74884}" },
			    { CLSID	= "{96A7F676-F956-404A-AD04-F33FB2C74881}" },
			    { CLSID	= "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}" },
			    { CLSID	= "{BD289E34-DF84-4C5E-9220-4B14C346E79D}" },
			    { CLSID	= "{6A367BB4-327F-4A04-8D9E-6D86BDC98E7E}" },
			    { CLSID	= "{5A1AC2B4-CA4B-4D09-A1AF-AC52FBC4B60B}" },
			    { CLSID	= "{E659C4BE-2CD8-4472-8C08-3F28ACB61A8A}" },
			    { CLSID	= "{414E383A-59EB-41BC-8566-2B5E0788ED1F}" },
			    { CLSID	= "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}" },
			    { CLSID	= "{4203753F-8198-4E85-9924-6F8FF679F9FF}" },
			    { CLSID	= "{RBK_250_275_AO_1SCH}" },
			    { CLSID	= "{PTB_800_MIG21}" },
            }
        ),
        pylon(6, 1, 1.5, -0.384, 1.22,
            {
                --
            },
            {
			    { CLSID	= "{FB3CE165-BF07-4979-887C-92B87F13276B}" },
			    { CLSID	= "{0511E528-EA28-4caf-A212-00D1408DF10A}" },
			    { CLSID	= "{37DCC01E-9E02-432F-B61D-10C166CA2798}" },
			    { CLSID	= "{D5435F26-F120-4FA3-9867-34ACE562EF1B}" },
			    { CLSID	= "{7AEC222D-C523-425e-B714-719C0D1EB14D}" },
			    { CLSID	= "{96A7F676-F956-404A-AD04-F33FB2C74884}" },
			    { CLSID	= "{96A7F676-F956-404A-AD04-F33FB2C74881}" },
			    { CLSID	= "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}" },
			    { CLSID	= "{BD289E34-DF84-4C5E-9220-4B14C346E79D}" },
			    { CLSID	= "{6A367BB4-327F-4A04-8D9E-6D86BDC98E7E}" },
			    { CLSID	= "{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}" },
			    { CLSID	= "{5A1AC2B4-CA4B-4D09-A1AF-AC52FBC4B60B}" },
			    { CLSID	= "{E659C4BE-2CD8-4472-8C08-3F28ACB61A8A}" },
			    { CLSID	= "{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}" },
			    { CLSID	= "{E86C5AA5-6D49-4F00-AD2E-79A62D6DDE26}" },
			    { CLSID	= "{292960BB-6518-41AC-BADA-210D65D5073C}" },
			    { CLSID	= "{414E383A-59EB-41BC-8566-2B5E0788ED1F}" },
			    { CLSID	= "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}" },
			    { CLSID	= "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}" },
			    { CLSID	= "{FC56DF80-9B09-44C5-8976-DCFAFF219062}" },
			    { CLSID	= "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}" },
			    { CLSID	= "{A0648264-4BC0-4EE8-A543-D119F6BA4257}" },
			    { CLSID	= "{S_25_O}" },
			    { CLSID	= "{3DFB7320-AB0E-11d7-9897-000476191836}" },
			    { CLSID	= "{4203753F-8198-4E85-9924-6F8FF679F9FF}" },
			    { CLSID	= "{RBK_250_275_AO_1SCH}" },
			    { CLSID	= "{Kh-25MP}" },
			    { CLSID	= "B-8M1 - 20 S-8OFP2" },
			    { CLSID	= "{PTB_800_MIG21}" },
			    { CLSID	= "{X-29L}", attach_point_position = {0.0, 0.02 , 0.0} },
			    { CLSID	= "{X-29T}", attach_point_position = {0.0, 0.02 , 0.0} },
            }
        ),
        pylon(7, 1, 0.46, -0.304, 1.853,
            {
                --
            },
            {
			    { CLSID	= "{APU-60-1_R_60M}" }, --R60M
			    { CLSID	= "{R-60}" }, --R60
			    { CLSID	= "{FBC29BFE-3D24-4C64-B81D-941239D12249}", attach_point_position = {-0.1, 0.0 ,0.0} }, --R73
            }
        ),
        pylon(8, 1, -1.784, -0.43, 2.526,
            {
                --
            },
            {
			    { CLSID	= "{FB3CE165-BF07-4979-887C-92B87F13276B}" },
			    { CLSID	= "{0511E528-EA28-4caf-A212-00D1408DF10A}" },
			    { CLSID	= "{37DCC01E-9E02-432F-B61D-10C166CA2798}" },
			    { CLSID	= "{D5435F26-F120-4FA3-9867-34ACE562EF1B}" },
			    { CLSID	= "{7AEC222D-C523-425e-B714-719C0D1EB14D}" },
			    { CLSID	= "{96A7F676-F956-404A-AD04-F33FB2C74884}" },
			    { CLSID	= "{96A7F676-F956-404A-AD04-F33FB2C74881}" },
			    { CLSID	= "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}" },
			    { CLSID	= "{BD289E34-DF84-4C5E-9220-4B14C346E79D}" },
			    { CLSID	= "{6A367BB4-327F-4A04-8D9E-6D86BDC98E7E}" },
			    { CLSID	= "{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}" },
			    { CLSID	= "{5A1AC2B4-CA4B-4D09-A1AF-AC52FBC4B60B}" },
			    { CLSID	= "{E659C4BE-2CD8-4472-8C08-3F28ACB61A8A}" },
			    { CLSID	= "{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}" },
			    { CLSID	= "{E86C5AA5-6D49-4F00-AD2E-79A62D6DDE26}" },
			    { CLSID	= "{292960BB-6518-41AC-BADA-210D65D5073C}" },
			    { CLSID	= "{414E383A-59EB-41BC-8566-2B5E0788ED1F}" },
			    { CLSID	= "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}" },
			    { CLSID	= "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}" },
			    { CLSID	= "{FC56DF80-9B09-44C5-8976-DCFAFF219062}" },
			    { CLSID	= "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}" },
			    { CLSID	= "{A0648264-4BC0-4EE8-A543-D119F6BA4257}" },
			    { CLSID	= "{S_25_O}" },
			    { CLSID	= "{3DFB7320-AB0E-11d7-9897-000476191836}" },
			    { CLSID	= "{4203753F-8198-4E85-9924-6F8FF679F9FF}" },
			    { CLSID	= "{RBK_250_275_AO_1SCH}" },
			    { CLSID	= "{Kh-25MP}" },
			    { CLSID	= "B-8M1 - 20 S-8OFP2" },
			    { CLSID	= "{PTB_800_MIG21}" },
			    { CLSID	= "{X-29L}", attach_point_position = {0.0, 0.02 , 0.0} },
			    { CLSID	= "{X-29T}", attach_point_position = {0.0, 0.02 , 0.0} },
            }
        ),
},
	
	Tasks = {
        --aircraft_task(CAP),
     	aircraft_task(PinpointStrike),
      	--aircraft_task(FighterSweep),
		--aircraft_task(Intercept),
		aircraft_task(Reconnaissance),
    	aircraft_task(GroundAttack),
     	aircraft_task(CAS),
        aircraft_task(AFAC),
        aircraft_task(SEAD),
	    aircraft_task(RunwayAttack),
  	aircraft_task(AntishipStrike),
    },	
	DefaultTask = aircraft_task(CAS),

	SFM_Data = {
	aerodynamics = 
		{
			Cy0	=	0,
			Mzalfa	=	4.355,
			Mzalfadt	=	0.8,
			kjx = 2.7,
			kjz = 0.00125,
			Czbe = -0.016,
			cx_gear = 0.0268,
			cx_flap = 0.05,
			cy_flap = 0.5,
			cx_brk = 0.0275,
			table_data = 
			{
			--      M	 Cx0		 Cya		 B		 B4	      Omxmax	Aldop	Cymax
				{0, 0.0235, 0.07, 0.0921, 0, 0.5, 30, 1.1 }, { 0.2, 0.0235, 0.07, 0.0921, 0, 1.5, 30, 1.1 }, { 0.4, 0.0235, 0.07, 0.0921, 0, 2.5, 30, 1.1 }, { 0.6, 0.0235, 0.073, 0.0921, 0, 3.5, 30, 1.1 }, { 0.7, 0.022, 0.076, 0.3, 0.052, 3.5, 28.666666666667, 1.0911111111111 }, { 0.8, 0.022, 0.079, 0.3, 0.052, 3.5, 27.333333333333, 1.0822222222222 }, { 0.9, 0.0235, 0.083, 0.324, 0.0536, 3.5, 26, 1.0733333333333 }, { 1, 0.03, 0.085, 0.348, 0.0552, 3.5, 24.666666666667, 1.0644444444444 }, { 1.05, 0.0325, 0.0855, 0.36, 0.056, 3.5, 24, 1.06 },
 { 1.1, 0.035, 0.086, 0.372, 0.0568, 3.15, 18, 1.04 }, { 1.2, 0.036, 0.083, 0.396, 0.0584, 2.45, 17, 1.02 }, { 1.3, 0.035, 0.077, 0.42, 0.06, 1.75, 16, 1 }, { 1.5, 0.033, 0.062, 0.488571, 0.06, 1.5, 13, 0.9 }, { 1.7, 0.031666666666667, 0.051333333333333, 0.557143, 0.06, 0.9, 12, 0.7 }, { 1.8, 0.031, 0.046, 0.591429, 0.06, 0.86, 11.4, 0.64 }, { 2, 0.029, 0.039, 0.66, 0.06, 0.78, 10.2, 0.52 }, { 2.2, 0.028, 0.034, 0.227, 3.2, 0.7, 9, 0.4 }, { 2.5, 0.027, 0.033, 0.25, 4.5, 0.7, 9, 0.4 }, { 3.9, 0.027, 0.033, 0.35, 6, 0.7, 9, 0.4 },
			}, -- end of table_data
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	60.2,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	0.85,
			ForsRUD	=	0.91,
			type	=	"TurboJet",
			hMaxEng	=	19.1,
			dcx_eng	=	0.0124,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	5500,
			dpdh_f	=	8700.0,
			table_data = {
			--   M		Pmax		 Pfor
				{0, 76440, 109760 }, { 0.2, 72000, 112023.1 }, { 0.4, 69000, 112000 }, { 0.6, 72000, 121000 }, { 0.7, 72000, 132000 }, { 0.8, 72000, 138000 }, { 0.9, 74000, 141000 }, { 1, 75000, 149000 }, { 1.1, 74000, 154000 }, { 1.2, 77000, 159000 }, { 1.3, 79000, 162000 }, { 1.4, 79000, 168000 }, { 1.596, 75000, 162000 }, { 1.8, 72000, 149000 }, { 2.2, 79000, 134000 }, { 2.35, 80000, 130000 }, { 3.9, 89641.8, 120000},
			}, -- end of table_data
		}, -- end of engine
	},


	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {

	[0]  = {critical_damage = 5,  args = {146}},
	[1]  = {critical_damage = 3,  args = {296}},
	[2]  = {critical_damage = 3,  args = {297}},
	[3]  = {critical_damage = 5, args = {65}},
	[4]  = {critical_damage = 2,  args = {298}},
	[5]  = {critical_damage = 2,  args = {301}},
	[7]  = {critical_damage = 2,  args = {249}},
	[8]  = {critical_damage = 3,  args = {265}},
	[9]  = {critical_damage = 3,  args = {154}},
	[10] = {critical_damage = 3,  args = {153}},
	[11] = {critical_damage = 1,  args = {167}},
	[12] = {critical_damage = 1,  args = {161}},
	[13] = {critical_damage = 2,  args = {169}},
	[14] = {critical_damage = 2,  args = {163}},
	[15] = {critical_damage = 2,  args = {267}},
	[16] = {critical_damage = 2,  args = {266}},
	[17] = {critical_damage = 2,  args = {168}},
	[18] = {critical_damage = 2,  args = {162}},
	[20] = {critical_damage = 2,  args = {183}},
	[23] = {critical_damage = 5, args = {223}},
	[24] = {critical_damage = 5, args = {213}},
	[25] = {critical_damage = 2,  args = {226}},
	[26] = {critical_damage = 2,  args = {216}},
	[29] = {critical_damage = 5, args = {224}, deps_cells = {23, 25}},
	[30] = {critical_damage = 5, args = {214}, deps_cells = {24, 26}},
	[35] = {critical_damage = 5, args = {225}, deps_cells = {23, 29, 25, 37}},
	[36] = {critical_damage = 5, args = {215}, deps_cells = {24, 30, 26, 38}}, 
	[37] = {critical_damage = 2,  args = {228}},
	[38] = {critical_damage = 2,  args = {218}},
	[39] = {critical_damage = 2,  args = {244}, deps_cells = {53}}, 
	[40] = {critical_damage = 2,  args = {241}, deps_cells = {54}}, 
	[43] = {critical_damage = 2,  args = {243}, deps_cells = {39, 53}},
	[44] = {critical_damage = 2,  args = {242}, deps_cells = {40, 54}}, 
	[51] = {critical_damage = 2,  args = {240}}, 
	[52] = {critical_damage = 2,  args = {238}},
	[53] = {critical_damage = 2,  args = {248}},
	[54] = {critical_damage = 2,  args = {247}},
	[56] = {critical_damage = 2,  args = {158}},
	[57] = {critical_damage = 2,  args = {157}},
	[59] = {critical_damage = 3,  args = {148}},
	[61] = {critical_damage = 2,  args = {147}},
	[82] = {critical_damage = 2,  args = {152}},
	},
	
	DamageParts = 
	{  
		[1] = "MIG-23-OBLOMOK-WING-R", -- wing R
		[2] = "MIG-23-OBLOMOK-WING-L", -- wing L
	},
	
	lights_data = { typename = "collection", lights = {
		
	    [WOLALIGHT_NAVLIGHTS] = {
         typename = "argumentlight",
         argument = 49, },

        [WOLALIGHT_SPOTS] = {
            typename = "collection",
            lights = {
                [1] = {
                    typename = "Collection",
                    lights = {
                        {
                            typename = "Spot", connector = "MAIN_SPOT_PTR", dir_correction = {elevation = math.rad(8.0)}, argument = 51,
                            proto = lamp_prototypes.LFS_P_27_600,
                        },
                    },
                },
            }
        },
        [WOLALIGHT_TAXI_LIGHTS] = {
            typename = "collection",
            lights = {
                [1] = {
                    typename = "Collection",
                    lights = {
                        {
                            typename = "Spot", position = { 2.542, -0.826, 0.789 }, dir_correction = {elevation = math.rad(8.0)}, argument = 51,
                            proto = lamp_prototypes.LFS_R_27_180,},
                        },
                    },
                },
            }
        },
	},
}

add_aircraft(SU22M4) --AG
