dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua") -- "script_path" is main scripts folder. common is local.

local rate = 0.5
make_default_activity(rate) -- gets plane info

local Data = get_base_data() 

local dev = GetSelf()

function post_initialize()
    print("post_initialize called in Smoke.lua")
    smoke_station0 = false	--pylon 15
     

    smoke_any = false
	smk_tog = false
	smoke_on = false
	deselect = false
	burnerLit = false 
	smoke_toggle_num = 0
	current_smoke = false
	smoke_armed = true --change to initially be false if you want to use the arming system
	center_smoke_equipped = false
	tip_smoke_equipped = false
	count = 0 --Will keep track of how long the burners are activated
	
	--Smokes equipable
	Smoke1 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E741}"
	Smoke2 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E742}"
	Smoke3 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E743}"
	Smoke4 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E744}"
	Smoke5 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E745}"
	Smoke6 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E746}"


	SmokeINV1 = "{INV-SMOKE-RED}"
	SmokeINV2 = "{INV-SMOKE-GREEN}"
	SmokeINV3 = "{INV-SMOKE-BLUE}"
	SmokeINV4 = "{INV-SMOKE-WHITE}"
	SmokeINV5 = "{INV-SMOKE-YELLOW}"
	SmokeINV6 = "{INV-SMOKE-ORANGE}"

end

--dev:listen_command(7003) -- Smoke Armed
dev:listen_command(7010)


-- station 1 and 15 are the outermost ones (on a pylon)
-- station 5 and 11 are the cheeks
-- station 8 is center (on a pylon)
function Logic()

	-- pylon 15, SMK
	ST0 = dev:get_station_info(14)
	ST0CLSID = ST0.CLSID
	

	if((ST0CLSID == SmokeINV1) or (ST0CLSID == SmokeINV2) or (ST0CLSID == SmokeINV3) or (ST0CLSID == SmokeINV4) or (ST0CLSID == SmokeINV5) or (ST0CLSID == SmokeINV6)) then
		smoke_station0 = true
	else
		smoke_station0 = false
	end

	

	-- if smoke_station0 == true or smoke_station1 == true or smoke_station2 == true or smoke_station3 == true then
	-- if smoke_station0 == true or smoke_station1 == true or smoke_station2 == true  then

	-- include the whole range...
	-- if smoke_station0 == true or smoke_station1 == true or smoke_station2 == true or smoke_station3 == true then
	-- only one left for now...
	if smoke_station0 == true then
		smoke_any = true
	end


	--If the left engine is in afterburner and the smoke is on the smoke will automatically be turned off.
	--[[
	if smoke_on == true then 
		-- if(center_smoke_equipped and tip_smoke_equipped) then
		if(tip_smoke_equipped) then
			dev:launch_station(0);
			dev:launch_station(1);
			dev:launch_station(2);
			dev:launch_station(3);		
		end
		smoke_on = true
		deselect = true --This variable is deselecting the smoke while in AB
	end
	--]]

	

	--If the smoke button has been pressed an odd number of times since the last update, or if the AB has been on since the last press the smoke will be toggled
	--IF AB is on nothing happens, and the toggle remains true so each update the AB state is checked again until the AB is deselected
	--This allows for you to toggle smoke while in AB without causing any smoke to be dispensed
	smoke_toggle = smoke_toggle_num % 2 -- this will either equal 1 or 0, if it equals 1 that means an odd number of presses has occured, and the next if statement will pass
	if smoke_toggle == 1 and smoke_armed == true then 
		
		-- pylon 15, smk
		if(smoke_station0 == true) then
			dev:launch_station(14);
		end

			
		--Resetting values for next presses
		smoke_toggle = 0
		smoke_toggle_num = 0
		if smoke_on == true then
			smoke_on = false
			print_message_to_user("Smoke Off")
		else --If the smoke is off
			smoke_on = true
			print_message_to_user("Smoke On")
		end
		
	end
end


function SetCommand(command,value)
	
	if (command == 7010) and smoke_any == true then --and track_is_reading() == false then
		smoke_toggle_num = smoke_toggle_num + 1  --Activates a variable to turn on or off smoke when appropriate once the smoke toggle has been pressed (keeps track of how many times the button is pressed).
	end
end

function update() -- Ties into "local rate" at top. Updates twice a second
Logic()
end

need_to_be_closed = false