local cockpit = folder .. "../../../Cockpit/"
local f4einput = folder .. "../../../Input/"
dofile(cockpit .. "devices.lua")
dofile(cockpit .. "command_defs.lua")
dofile(f4einput .. "utils.lua")
dofile(f4einput .. "bind_dsl.lua")
dofile(f4einput .. "bind_categories.lua")

res = {
    keyCommands = {},
    axisCommands = {},
    forceFeedback = {},
}

local keyboard_binds = external_profile(f4einput .. "F-4E-Pilot/keyboard/default.lua")
join_override(res.keyCommands, keyboard_binds.keyCommands)
join_override(res.axisCommands, keyboard_binds.axisCommands)

local DCS_common_binds = external_profile("Config/Input/Aircrafts/common_joystick_binding.lua")
join_override(res.keyCommands, DCS_common_binds.keyCommands)
join_override(res.axisCommands, DCS_common_binds.axisCommands)
join_override(res.forceFeedback, DCS_common_binds.forceFeedback)

join_override(res.forceFeedback, {
    trimmer = 1.0,
    shake = 0.5,
    swapAxes = false,
    invertX = false,
    invertY = false,
})

-------------------------------------

local binds = {
    -- WSO Binds (until Jester is better)
    { name = _('[WSO] Antenna Hand Control Slew X'), action = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_X, cockpit_device_id = devices.RADAR, category = categories.wso_temp },
    { name = _('[WSO] Antenna Hand Control Slew Y'), action = device_commands.RADAR_ANTENNA_HAND_CONTROL_SLEW_Y, cockpit_device_id = devices.RADAR, category = categories.wso_temp },
    { name = _('[WSO] Antenna Elevation'), action = device_commands.RADAR_ANTENNA_HAND_CONTROL_ELEVATION, cockpit_device_id = devices.RADAR, category = categories.wso_temp },

    -- TrackIR axes
    { name = _('Absolute Camera Vertical View'), action = iCommandViewVerticalAbs, category = { categories.view_cockpit, axis_categories.other } },
    { name = _('Absolute Camera Horizontal View'), action = iCommandViewHorizontalAbs, category = { categories.view_cockpit, axis_categories.other } },
    { name = _('Absolute Horizontal Shift Camera View'), action = iCommandViewHorTransAbs, category = { categories.view_cockpit, axis_categories.other } },
    { name = _('Absolute Vertical Shift Camera View'), action = iCommandViewVertTransAbs, category = { categories.view_cockpit, axis_categories.other } },
    { name = _('Absolute Longitude Shift Camera View'), action = iCommandViewLongitudeTransAbs, category = { categories.view_cockpit, axis_categories.other } },
    { name = _('Absolute Roll Shift Camera View'), action = iCommandViewRollAbs, category = { categories.view_cockpit, axis_categories.other } },
    { name = _('Zoom View'), action = iCommandViewZoomAbs, category = { categories.view_cockpit, axis_categories.other } },

    -- main axes
    { name = _('Roll'), action = iCommandPlaneRoll, category = { categories.flight_controls, categories.stick, axis_categories.other } },
    { name = _('Pitch'), action = iCommandPlanePitch, category = { categories.flight_controls, categories.stick, axis_categories.other } },
    { name = _('Rudder'), action = iCommandPlaneRudder, category = { categories.flight_controls, categories.pedals, axis_categories.other } },

    { name = _('Throttle (Both)'), action = iCommandPlaneThrustCommon, category = { categories.flight_controls, categories.throttle, axis_categories.other } },
    { name = _('Throttle (Left)'), action = iCommandPlaneThrustLeft, category = { categories.flight_controls, categories.throttle, axis_categories.other } },
    { name = _('Throttle (Right)'), action = iCommandPlaneThrustRight, category = { categories.flight_controls, categories.throttle, axis_categories.other } },

    { name = _('Wheel Brake (Both)'), action = iCommandWheelBrake, category = { categories.gears_brakes_hook, categories.pedals, axis_categories.other } },
    { name = _('Wheel Brake (Left)'), action = iCommandLeftWheelBrake, category = { categories.gears_brakes_hook, categories.pedals, axis_categories.other } },
    { name = _('Wheel Brake (Right)'), action = iCommandRightWheelBrake, category = { categories.gears_brakes_hook, categories.pedals, axis_categories.other } },

    -- Jester
    bind_templates.jester_wheel({ name = _('Jester UI Cursor X'), action = device_commands.PILOT_JESTER_OPTION_STICK_X }),
    bind_templates.jester_wheel({ name = _('Jester UI Cursor Y'), action = device_commands.PILOT_JESTER_OPTION_STICK_Y }),

    -- Left Console
    bind_templates.weapons_controls_view({ name = _('Weapon Slew (Forward Hand Control) X'), action = device_commands.MAVERICK_SLEW_XAxisKey }),
    bind_templates.weapons_controls_view({ name = _('Weapon Slew (Forward Hand Control) Y'), action = device_commands.MAVERICK_SLEW_YAxisKey }),
}

join_override(res.axisCommands, binds)

-- smoke
join_override(res.keyCommands,
	{
		{down = 7010,		cockpit_device_id = devices.Smoke,	value_down = 1,	value_up = 0,	name = _('Smoke Toggle'), category = _('Smoke')}
	}
)

return res
