--
-- file prepared:  2025 14:39:06.707, using fd653a
--
--SFM_characteristics.lua (file 2 for assembly)

a5 = {

	Name = 'a5',

	DisplayName = _('a5'),
	ViewSettings = ViewSettings,
	Countries = { "Abkhazia","Australia","Austria","Belarus","Belgium","Brazil","Bulgaria","Canada","China",
			 "Croatia","Czech Republic","Denmark","Egypt","ESA","Finland","France","Georgia",
			 "German Empire","Germany","Greece","Hungary","Imperial Japan","India","Insurgents","Iran",
			 "Iraq","Israel","Italy","Japan","Kazakhstan","NASA","North Korea","Norway",
			 "Pakistan","Poland","Romania","Russia","Saudi Arabia","Serbia","Slovakia","South Korea",
			 "South Ossetia","Spain","Sweden","Switzerland","Syria","The Netherlands","Third Reich","Turkey","UK",
			 "Ukraine","USA","USAF Aggressors","USSR","Vietnam"},

	HumanCockpit = false,
	HumanCockpitPath = current_mod_path..'/Cockpit/',
	Picture = "a5.png",
	Rate = 50,
	Shape = "a5",

	shape_table_data =
	{
		{
			file = 'a5';
			life = 20;
			vis = 3;
			fire = { 300, 2};
			username = 'a5';
			index = WSTYPE_PLACEHOLDER;
		},
	},
	------------------------ -
	mapclasskey = "P0091000024",
	attribute = {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER, "Multirole fighters", "Refuelable", "Datalink", "Link16"},
	Categories = {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},

	---------	General	Characteristics	---------
	length = 23.32,
	height = 5.91,
	wing_area = 65.1,
	wing_span = 16.16,
	wing_tip_pos = { -7.5, 2.33, 8.25},
	RCS = 7.6,											-- (estimated from height, length and wing surface area)
	air_refuel_receptacle_pos = { 0, 0, 0},
	has_speedbrake = true,								-- default
	brakeshute_name = 4,								-- default
	is_tanker = false,									-- default
	tanker_type = 2,									-- default
	stores_number = 8,
	wing_type = 0,										-- default
	crew_size = 1,										-- default
	crew_size = 1,										-- default

	------- Weight & Fuel Characteristics -------
	M_empty = 14870,
	M_nominal = 21605,
	M_max = 28615,
	M_fuel_max = 3200,
	H_max = 15880,										-- (calculated from service_ceiling)
	CAS_min = 72,
	average_fuel_consumption = 1,						-- default

	----------_ AI Flight Parameters -----------
	V_opt = 466,
	V_take_off = 75,
	V_land = 72,								-- note: default calculation override for a5
	V_max_sea_level = 617,								-- note: default calculation override for a5
	V_max_h = 438,
	Vy_max = 41,
	Mach_max = 2.005,
	Ny_min = -3,										-- default
	Ny_max = 8,											-- default
	Ny_max_e = 8,										-- default
	AOA_take_off = 0.16,								-- default
	bank_angle_max = 60,								-- default
	range = 3000,										-- default
	flaps_maneuver = 1,									-- default

	-------- Suspension Characteristics -------
	and_gear_max = 1,									-- default
	nose_gear_pos = { 3.05, -1.15, 0},
	nose_gear_wheel_diameter = 0.5,						-- default
	nose_gear_amortizer_direct_stroke = 0.05,			-- default
	nose_gear_amortizer_reversal_stroke = -0.25,		-- default
	nose_gear_amortizer_normal_weight_stroke = -0.05,	-- default
	main_gear_pos = { -3.2, -0.95, 1.98},
	main_gear_wheel_diameter = 0.75,					-- default
	main_gear_amortizer_direct_stroke = 0.1,			-- default
	main_gear_amortizer_reversal_stroke = -0.275,		-- default
	main_gear_amortizer_normal_weight_stroke = -0.1,	-- default

	---------- Engine Characteristics ---------
	has_afteburner = true,
	thrust_sum_max = 9895,
	thrust_sum_ab = 15433,
	engines_count = 2,
	IR_emission_coeff = 0.05,							-- default
	IR_emission_coeff_ab = 0.05,						-- default

	--------- Sensors Characteristics ---------
	detection_range_max = 250,							-- default
	radar_can_see_ground = true,						-- default


---------------------------------------------------------------------------------------------------------------------------------------------

	crew_members =
	{
		[1] =
		{
			ejection_seat_name = 9,
			drop_canopy_name = "aircraft_canopy",
			canopy_pos = {3.05, -0.2, 0},
			canopy_ejection_dir = {0.0, 0.5, -0.5},
			pos = {3.05, -1.15, 0},
		}, --end of[1]
		--[2] =
		--{
			--ejection_seat_name = 9,
			--drop_canopy_name = "aircraft_canopy_2",
			--canopy_pos = {3.05, -0.2, 0},
			--canopy_ejection_dir = {0.0, 0.5, 0.5},
			--pos = {3.05, -1.15, 0},
			--canopy_arg = 421,
		--}, --end of[2]
	}, --end of crew_members

---------------------------------------------------------------------------------------------------------------------------------------------


	--------- Engine, nozzles and exhaust ---------

	engines_nozzles = {
		[1] =
		{
			pos = {-9, 1.25, 1.15},
			elevation = 1.25,
			diameter = 1.1,								-- default
			exhaust_length_ab = 8,						-- default
			exhaust_length_ab_K = 0.707,				-- default
			smokiness_level = 0.2,
			afterburner_circles_count = 7,				-- default
			afterburner_circles_pos = { 0.2, 0.8 },		-- default
			afterburner_circles_scale = 0.95,			-- default
		}, -- end of [1]
		[2] =
		{
			pos = {-9, 1.25, -1.15},
			elevation = 1.25,
			diameter = 1.1,							-- default
			exhaust_length_ab = 8,					-- default
			exhaust_length_ab_K = 0.707,				-- default
			smokiness_level = 0.2,
			afterburner_circles_count = 7,			-- default
			afterburner_circles_pos = { 0.2, 0.8 },	-- default
			afterburner_circles_scale = 0.95,		-- default
		}, -- end of [2]
	}, -- end of engines_nozzles


---------------------------------------------------------------------------------------------------------------------------------------------


	Guns = {
	},


	Pylons = {
		pylon(1, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon1", arg = 308, arg_value = 0,
			},
			{
			} 
		),
		pylon(2, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon2", arg = 309, arg_value = 0,
			},
			{
			} 
		),
		pylon(3, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon3", arg = 310, arg_value = 0,
			},
			{
			} 
		),
		pylon(4, 0, -2.75, 1.75, 3.05, --
			{
				use_full_connector_position = true, connector = "Pylon4", arg = 311, arg_value = 0,
			},
			{
				{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}" }, --MK-83 
				{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" }, --MK-84 
			} 
		),
		pylon(5, 0, -2.75, 1.75, -3.05, --
			{
				use_full_connector_position = true, connector = "Pylon5", arg = 312, arg_value = 0,
			},
			{
				{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}" }, --MK-83 
				{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" }, --MK-84 
			} 
		),
		pylon(6, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon6", arg = 313, arg_value = 0,
			},
			{
			} 
		),
		pylon(7, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon7", arg = 314, arg_value = 0,
			},
			{
			} 
		),
		pylon(8, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon8", arg = 315, arg_value = 0,
			},
			{
			} 
		),
	},

---------------------------------------------------------------------------------------------------------------------------------------------

		 -- calibrate_countermeasures 

---------------------------------------------------------------------------------------------------------------------------------------------



	fires_pos =
	{
		[1] = { -2.25, 2.33, 0.0},
		[2] = { -0.9, 2.33, 0.2},
		[3] = { -1.35, 2.33, -0.2},
		[4] = { -2.75, 2.33, 2.0625},
		[5] = { -2.75, 2.33, -2.0625},
		[6] = { -2.75, 2.33, 6.6},
		[7] = { -2.75, 2.33, -6.6},
		[8] = { -9, 1.25, 0.2},
		[9] = { -9, 1.25, -0.2},
		[10] = { -4.5, 2.33, 0.2},
		[11] = { -4.5, 2.33, -0.2},
	},	-- end of fires_pos

---------------------------------------------------------------------------------------------------------------------------------------------


--(file 3 for aessembly)

	--[[
	fires_pos =
	{
		[1] = 	{-1.594,	-0.064,		0},
		[2] = 	{-1.073,	0.319,		2.304},
		[3] = 	{-1.187,	0.338,		-4.678},
		[4] = 	{-0.82,		0.265,		2.774},
		[5] = 	{-0.82,		0.265,		-2.774},
		[6] = 	{-0.82,		0.255,		4.274},
		[7] = 	{-0.82,		0.255,		-4.274},
		[8] = 	{-5.889,	-0.257,		1.193},
		[9] = 	{-5.889,	-0.257,		-1.193},
		[10] = 	{-1.257,	0.283,		3.05},
		[11] = 	{-1.257,	0.283,		-3.05},
	}, -- end of fires_pos
	]]--

	--[[

	-- Countermeasures
	passivCounterm = {
		CMDS_Edit = true,
		SingleChargeTotal = 128,
		-- PPR-26
		chaff = {default = 64, increment = 3, chargeSz = 1},
		-- PPI-26
		flare = {default = 64, increment = 3, chargeSz = 1}
	},
	]]--

	attribute 		= { wsType_Air, wsType_Airplane, wsType_Fighter, Su_34,"Bombers", "Refuelable"},
	CanopyGeometry	=  makeAirplaneCanopyGeometry(LOOK_GOOD, LOOK_AVERAGE, LOOK_AVERAGE),
	
	--[[
	Sensors =
	{
		RADAR = "N-011M",
		OPTIC = "Su-34 FLIR",
		RWR   = "Abstract RWR"
	},
	]]--

	Tasks =
	{
		aircraft_task(AFAC),
		aircraft_task(SEAD),
		aircraft_task(AntishipStrike),
		aircraft_task(CAS),
		aircraft_task(CAP),
		aircraft_task(Intercept),
		aircraft_task(PinpointStrike),
		aircraft_task(GroundAttack),
		aircraft_task(RunwayAttack),
	},
	DefaultTask = aircraft_task(CAP),

	--SFM_aerodynamics.lua (file 4 for assembly)

	SFM_Data = {
		aerodynamics = --Cx = Cx_0 + Cy ^ 2 * B2 + Cy ^ 4 * B4
		{

			Cy0 = 0,
			Mzalfa = 4.355,					-- default
			Mzalfadt = 2.25,					-- note: set to this value for a5 to improve in-flight handling
			kjx = 3,						-- default
			kjz = 0.00125,					-- default
			Czbe = -0.016,					-- default
			cx_gear = 0.02,					-- default
			cx_flap = 0.08,					-- default
			cy_flap = 0.25,					-- default
			cx_brk = 0.1,					-- default

			table_data = {
				--M     Cx0     Cya     B       B4      Omxmax  Aldop   Cymax
				{0,		0.015,	0.0456,	0.171,	0.0463,	1.75,	11.7,	0.535,		},
				{0.1,	0.015,	0.0413,	0.171,	0.0463,	4.75,	13,	0.535,		},
				{0.2,	0.015,	0.0374,	0.171,	0.0463,	4.75,	14.3,	0.535,		},
				{0.3,	0.015,	0.0715,	0.171,	0.0463,	4.75,	15.8,	0.735,		},
				{0.4,	0.015,	0.106,	0.171,	0.0463,	4.75,	17.5,	1.89,		},
				{0.5,	0.015,	0.0829,	0.173,	0.0762,	4.75,	17.5,	1.48,		},
				{0.6,	0.015,	0.0695,	0.164,	0.103,	4.75,	17.5,	1.24,		},
				{0.7,	0.015,	0.06,	0.155,	0.13,	4.75,	17.5,	1.07,		},
				{0.8,	0.0213,	0.0457,	0.172,	0.249,	1.75,	17.5,	1,		},
				{0.9,	0.035,	0.03,	0.0765,	0.111,	1.53,	17.5,	1,		},
				{1,		0.0428,	0.03,	0.0803,	0.116,	1.34,	16.6,	0.951,		},
				{1.1,	0.0387,	0.03,	0.0844,	0.122,	1.17,	15.8,	0.905,		},
				{1.2,	0.035,	0.03,	0.0886,	0.128,	1.03,	15.1,	0.861,		},
				{1.3,	0.0317,	0.03,	0.093,	0.135,	0.897,	14.3,	0.819,		},
				{1.4,	0.0287,	0.03,	0.0976,	0.141,	0.785,	13.6,	0.779,		},
				{1.5,	0.026,	0.03,	0.103,	0.148,	0.687,	13,	0.741,		},
				{1.6,	0.0235,	0.03,	0.108,	0.156,	0.601,	12.3,	0.705,		},
				{1.7,	0.0213,	0.03,	0.113,	0.164,	0.526,	11.7,	0.67,		},
				{1.8,	0.0192,	0.03,	0.119,	0.172,	0.461,	11.2,	0.638,		},
				{1.9,	0.0174,	0.03,	0.125,	0.18,	0.403,	10.6,	0.607,		},
				{2,		0.0157,	0.03,	0.131,	0.189,	0.353,	10.1,	0.577,		},
				{2.1,	0.0142,	0.0312,	0.137,	0.199,	0.309,	9.6,	0.549,		},
				{2.2,	0.0129,	0.0328,	0.144,	0.209,	0.27,	9.14,	0.522,		},
				{2.3,	0.0117,	0.0345,	0.151,	0.219,	0.236,	8.69,	0.497,		},
				{2.4,	0.0106,	0.0363,	0.159,	0.23,	0.207,	8.27,	0.472,		},
			}, --end of table_data
		}, --end of aerodynamics
		engine = 
		{
			Nmg = 50,					-- default
			MinRUD = 0,
			MaxRUD = 1,
			MaksRUD  = 0.85,
			ForsRUD  = 0.91,
			typeng  = 1,
			hMaxEng	= 19,				-- default
			dcx_eng = 0.015,			-- default
			cemax  = 1.24,				-- default
			cefor  = 2.56,				-- default
			dpdh_m = 1000,
			dpdh_f = 2000,

			--[[			table_data = {
				--M 	Pmax	Pafb
				{0,	41941,	66406,		},
				{0.2,	62911,	99610,		},
				{0.4,	83882,	132813,		},
				{0.6,	83882,	132813,		},
				{0.8,	83882,	132813,		},
				{1,	83882,	132813,		},
				{1.2,	83882,	132813,		},
				{1.4,	83882,	132813,		},
				{1.6,	83882,	132813,		},
				{1.8,	83882,	132813,		},
				{2,	62911,	99610,		},
				{2.2,	41941,	66406,		},
			}, --end of table_data
			--]]

			table_data = {
				--M 	Pmax	Pafb
				{0.0,	0.0,	0.0,		},
				{ 3.25,	0.0,	0.0,		},
			}, --end of table_data


			--[[
				engine calibration worksheet (for in-game testing)
				alt     	vel		adj
				0 k ft		0.m		adj:+/-
				15 k ft		0.m		adj:+/-
				40 k ft		0.m		adj:+/-
				42 k ft		0.m		adj:+/-
				44 k ft		0.m		adj:+/-
				49 k ft		0.m		adj:+/-
				54 k ft		0.m		adj:+/-
				56 k ft		0.m		adj:+/-
			]]--

			extended = {

				thrust_max = {
					M = { 0.000000, 0.200000, 0.400000, 0.600000, 0.800000, 1.000000, 1.200000, 1.400000, 1.600000, 1.800000, 2.000000, 2.200000, }, 
					H = { 0, 4571, 12191, 12801, 13498, 15185, 16535, 17294 }, 
					thrust = {
						{ 48505,  72757,  97010,  97010,  97010,  97010,  97010,  97010,  97010,  97010,  97010,  97010  }, 
						{ 42383,  63575,  84767,  84767,  84767,  84767,  84767,  84767,  84767,  84767,  84767,  84767  }, 
						{ 28695,  43043,  57391,  57391,  57391,  57391,  57391,  57391,  57391,  57391,  57391,  57391  }, 
						{ 23621,  35432,  47243,  47243,  47243,  47243,  47243,  47243,  47243,  47243,  47243,  47243  }, 
						{ 19285,  28928,  38571,  38571,  38571,  38571,  38571,  38571,  38571,  38571,  38571,  38571  }, 
						{ 18189,  27284,  36378,  36378,  36378,  36378,  36378,  36378,  36378,  36378,  36378,  36378  }, 
						{ 16016,  24024,  32032,  32032,  32032,  32032,  32032,  32032,  32032,  32032,  32032,  32032  }, 
						{ 1940,   2910,   3880,   3880,   3880,   3880,   3880,   3880,   3880,   3880,   3880,   3880   }, 
					}, -- thrust = {

				}, --thrust_max = {

				thrust_afterburner  = {
					M = { 0.000000, 0.200000, 0.400000, 0.600000, 0.800000, 1.000000, 1.200000, 1.400000, 1.600000, 1.800000, 2.000000, 2.200000, }, 
					H = { 0, 4571, 12191, 12801, 13498, 15185, 16535, 17294 }, 
					thrust = {
						{ 75650,  113475, 151300, 151300, 151300, 151300, 151300, 151300, 151300, 151300, 151300, 151300 }, 
						{ 66102,  99154,  132205, 132205, 132205, 132205, 132205, 132205, 132205, 132205, 132205, 132205 }, 
						{ 44754,  67131,  89509,  89509,  89509,  89509,  89509,  89509,  89509,  89509,  89509,  89509  }, 
						{ 36841,  55262,  73683,  73683,  73683,  73683,  73683,  73683,  73683,  73683,  73683,  73683  }, 
						{ 30078,  45117,  60156,  60156,  60156,  60156,  60156,  60156,  60156,  60156,  60156,  60156  }, 
						{ 28368,  42553,  56737,  56737,  56737,  56737,  56737,  56737,  56737,  56737,  56737,  56737  }, 
						{ 24979,  37469,  49959,  49959,  49959,  49959,  49959,  49959,  49959,  49959,  49959,  49959  }, 
						{ 3026,   4539,   6052,   6052,   6052,   6052,   6052,   6052,   6052,   6052,   6052,   6052   }, 
					}, -- thrust = {

				}, --thrust_afterburner = {

			}, -- extended = {

		}, --end of engine

	},

	DamageParts =
	{
		[1] = "a5-collision",
	},

	-- (file 5 for aessembly)

	-- new
	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
		[0]		= {critical_damage = 5, args = {146}},
		[3]		= {critical_damage = 20,args = {65}}  ,
		[4]		= {critical_damage = 20, args = {150}},
		[5]		= {critical_damage = 20, args = {147}},
		[7]		= {critical_damage = 4, args = {249}} ,
		[9]		= {critical_damage = 3, args = {154}},
		[10]	= {critical_damage = 3, args = {153}},
		[11]	= {critical_damage = 3, args = {167}},
		[12]	= {critical_damage = 3, args = {161}},
		[15]	= {critical_damage = 5, args = {267}},
		[16]	= {critical_damage = 5, args = {266}},
		[23]	= {critical_damage = 8, args = {223}, deps_cells = {25}},
		[24]	= {critical_damage = 8, args = {213}, deps_cells = {26, 60}},
		[25]	= {critical_damage = 3, args = {226}},
		[26]	= {critical_damage = 3, args = {216}},
		[29]	= {critical_damage = 9, args = {224}, deps_cells = {31, 25, 23}},
		[30]	= {critical_damage = 9, args = {214}, deps_cells = {32, 26, 24, 60}},
		[31]	= {critical_damage = 4, args = {229}},
		[32]	= {critical_damage = 4, args = {219}},
		[35]	= {critical_damage = 10, args = {225}, deps_cells = {29, 31, 25, 23}},
		[36]	= {critical_damage = 10, args = {215}, deps_cells = {30, 32, 26, 24, 60}} ,
		[37]	= {critical_damage = 4, args = {227}},
		[38]	= {critical_damage = 4, args = {217}},
		[39]	= {critical_damage = 7,	args = {244}, deps_cells = {53}},
		[40]	= {critical_damage = 7, args = {241}, deps_cells = {54}},
		[45]	= {critical_damage = 9, args = {235}, deps_cells = {39, 51, 53}},
		[46]	= {critical_damage = 9, args = {233}, deps_cells = {40, 52, 54}},
		[51]	= {critical_damage = 3, args = {239}},
		[52]	= {critical_damage = 3, args = {237}},
		[53]	= {critical_damage = 3, args = {248}},
		[54]	= {critical_damage = 3, args = {247}},
		[55]	= {critical_damage = 20, args = {81}, deps_cells = {39, 40, 45, 46, 51, 52, 53, 54}},
		[59]	= {critical_damage = 5, args = {148}},
		[60]	= {critical_damage = 1, args = {144}},

		[83]	= {critical_damage = 3, args = {134}} ,-- nose wheel
		[84]	= {critical_damage = 3, args = {136}}, -- left wheel
		[85]	= {critical_damage = 3, args = {135}} ,-- right wheel
	},


	-- solve triangle to have B_end == C_end with given A
	-- B_start assumed to be A_start
	-- C_start assumed to be A_end
	
	SolveTriangles = 
	{
		-- left gear post kinematics 
		{
			A_start   = "bracing_centr004",
			A_end     = "bracing_centr003",
			B_end     = "bracing_004",
			B_control = 484,
			C_end	  = "bracing_003",
			C_control = 483,
			B_scale   =  1/math.rad(46);
			C_scale   =  1/math.rad(25);
		},
		-- right gear post kinematics 
		{
			A_start   = "bracing_centr006",
			A_end     = "bracing_centr005",
			B_end     = "bracing_006",
			B_control = 486,
			C_end	  = "bracing_005",
			C_control = 485,
			B_scale   =  1/math.rad(46);
			C_scale   =  1/math.rad(25);
		},
	},  --SolveTriangles


}



--SFM_add.lua (file 6 for assembly)

add_aircraft(a5)


