--mounting 3d model paths and texture paths 
mount_vfs_model_path	(current_mod_path.."/Shapes")
mount_vfs_liveries_path (current_mod_path.."/Liveries")
mount_vfs_texture_path  (current_mod_path.."/Textures/mi-24p")
mount_vfs_texture_path  (current_mod_path.."/Textures/9m114_pylon2")
mount_vfs_texture_path  (current_mod_path.."/Textures/9m120_pylon2")
--to ease possible checksum test
--dofile(current_mod_path.."/Views.lua")


rot_nil = {}
rot_nil[1] = 0.0
rot_nil[2] = 0.0

arg_ch_rng = {}
arg_ch_rng[1] = 0.0
arg_ch_rng[2] = 1.0




local function YakB_12_7_mi24v(tbl)

    tbl.category = CAT_GUN_MOUNT
    tbl.name      = "YakB_12_7_mi24v"
    tbl.supply      =
    {
        shells = {"YakB_12_7_T", "YakB_12_7"},
        mixes  = {
				{1,2}
        },
        count  = 1470,
    }
    if tbl.mixes then
       tbl.supply.mixes = tbl.mixes
       tbl.mixes        = nil
    end
    tbl.gun =
    {
        max_burst_length    = 400,
        rates               = {4500,2250},
        recoil_coeff        = 0.5*1.3,
        barrels_count       = 4,
    }
    if tbl.rates then
       tbl.gun.rates        =  tbl.rates
       tbl.rates            = nil
    end
    tbl.ejector_pos             = tbl.ejector_pos or {-1.16, 0.016, -0.11}					-- front/back, left/right, up/down
    tbl.ejector_pos_connector   = tbl.ejector_pos_connector     or  {-1.16, 0.016, -0.11}
    tbl.ejector_dir             = {-1.0, -1.0, -10.0} -- left/right; back/front;?/?
    tbl.supply_position         = tbl.supply_position   or {0, 0, 0}
    tbl.aft_gun_mount           = false
    tbl.effective_fire_distance = 1300
    tbl.drop_cartridge          = 204
    tbl.muzzle_pos              = tbl.muzzle_pos            or  {6.689, -1.049,  0.0}     -- all position from connector
    tbl.muzzle_pos_connector    = tbl.muzzle_pos_connector  or  "Gun_point" -- all position from connector
    tbl.azimuth_initial         = tbl.azimuth_initial       or  0
    tbl.elevation_initial       = tbl.elevation_initial     or  0
    if  tbl.effects == nil then
        tbl.effects = {{ arg = 350, attenuation = 2, duration = 0.02, light_pos = { 0.5, 0, 0 }, name = "FireEffect" },
						{arg = 351, barrels_n = 4, name = "GatlingEffect"},
                       { name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
                       { name = "SmokeEffect"}}
    end
    return declare_weapon(tbl)
end






local function inboardTbl(KORD_STATION, KORD_CLSID)

return {
		{ CLSID = "B_8V20A_CM", forbidden = {{station = KORD_STATION, loadout = {KORD_CLSID}}}, arg_value = 0.1},
		{ CLSID = "B_8V20A_OFP2", forbidden = {{station = KORD_STATION, loadout = {KORD_CLSID}}}, arg_value = 0.1},
		{ CLSID = "B_8V20A_OM", forbidden = {{station = KORD_STATION, loadout = {KORD_CLSID}}}, arg_value = 0.1},
		{ CLSID = "{UB-32A-24}", forbidden = {{station = KORD_STATION, loadout = {KORD_CLSID}}}, arg_value = 0.1},--UB-32A-24 pod - 32 x S-5KO
		{ CLSID = "{UB32A24_S5KP}", forbidden = {{station = KORD_STATION, loadout = {KORD_CLSID}}}, arg_value = 0.1},--UB-32A-24 pod - 32 x S-5KP
		{ CLSID = "{UB32A24_S5M}", forbidden = {{station = KORD_STATION, loadout = {KORD_CLSID}}}, arg_value = 0.1},--UB-32A-24 pod - 32 x S-5M
		{ CLSID = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}", forbidden = {{station = KORD_STATION, loadout = {KORD_CLSID}}}, arg_value = 0.1},--B-8V20A pod - 20 x S-8KOM
		{ CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}" , arg_value = 0.0},--FAB-100 - 100kg GP Bomb LD"
		{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}" , arg_value = 0.0},--FAB-250 - 250kg GP Bomb LD
		{ CLSID = "{FAB_250_M62}" , arg_value = 0.0},						 --FAB-250 M-62 - 250kg GP Bomb LD
		{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", arg_value = 0.0},--FAB-500 M-62 - 500kg GP Bomb LD

		{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", arg_value = 0.0},-- RBK-250 PTAB-2.5M
		{ CLSID = "{RBK_250_275_AO_1SCH}", arg_value = 0.0},				-- RBK-250-275 AO-1SCh
		{ CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", arg_value = 0.0},-- RBK-500 PTAB-10-5
		{ CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}", arg_value = 0.0},-- RBK-500 PTAB-1M
		{ CLSID = "{RBK_500U_OAB_2_5RT}", arg_value = 0.0},					-- RBK-500U OAB-2.5RT

		{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}" , arg_value = 0.1},--KMGU-2 - 96 x AO-2.5RT Dispenser (CBU) HE/Frag
		{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}" , arg_value = 0.1},--KMGU-2 - 96 x AO-2.5KO Dispenser (CBU) HE/Frag
		{ CLSID = "{PTB_450}" , arg_value = 0.0},		--PTB-450
		{ CLSID = "{APU_68_S-24}", forbidden = {{station = KORD_STATION, loadout = {KORD_CLSID}}}},	--S-24
		{ CLSID = "GUV_YakB_GSHP", forbidden = {{station = KORD_STATION, loadout = {KORD_CLSID}}}, arg_value = 0.1},
		{ CLSID = "GUV_VOG", forbidden = {{station = KORD_STATION, loadout = {KORD_CLSID}}}, arg_value = 0.1},
	}
end

local inboardR = inboardTbl(8, "KORD_12_7_MI24_R")
local inboardL = inboardTbl(7, "KORD_12_7_MI24_L")


local outboard = {
	{ CLSID = "B_8V20A_CM" , arg_value = 0.1},
	{ CLSID = "B_8V20A_OFP2" , arg_value = 0.1},
	{ CLSID = "B_8V20A_OM" , arg_value = 0.1},
	{ CLSID = "{UB-32A-24}" , arg_value = 0.1},--UB-32A-24 pod - 32 x S-5KO
	{ CLSID = "{UB32A24_S5KP}" , arg_value = 0.1},--UB-32A-24 pod - 32 x S-5KP
	{ CLSID = "{UB32A24_S5M}" , arg_value = 0.1},--UB-32A-24 pod - 32 x S-5M
	{ CLSID = "{2x9M114_with_adapter}"},-- 9M114 Shturm-V-2
	{ CLSID = "{2x9M120_Ataka_V_with_adapter}"}, -- 9M120 Ataka-V-2
	{ CLSID = "{2x9M120F_Ataka_V_with_adapter}"}, -- 9M120F Ataka-V-2
	{ CLSID = "{2x9M220_Ataka_V_with_adapter}"}, -- 9M220O Ataka-V-2
	{ CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}" , arg_value = 0.1},--B-13L pod - 5 x S-13-OF
	{ CLSID = "{PTB_450}" , arg_value = 0.0},		--PTB-450
	{ CLSID = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}", arg_value = 0.1 },--B-8V20A pod - 20 x S-8KOM
	{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", arg_value = 0.0 },--FAB-250 - 250kg GP Bomb LD
	{ CLSID = "{FAB_250_M62}", arg_value = 0.0 },						 --FAB-250 M-62 - 250kg GP Bomb LD
	{ CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}", arg_value = 0.0 },--FAB-100 - 100kg GP Bomb LD"
	{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", arg_value = 0.0},-- RBK-250 PTAB-2.5M
	{ CLSID = "{RBK_250_275_AO_1SCH}", arg_value = 0.0},					-- RBK-250-275 AO-1SCh
	{ CLSID = "{APU_68_S-24}"},	--S-24
	{ CLSID = "GUV_VOG", arg_value = 0.1},
	{ CLSID = "{APU-60-1_R_60M}"},
}


local function joinTbl(orig, to, from)
	for i, value in ipairs(orig) do
		to[i] = value
	end
	for i, value in ipairs(from) do
		table.insert(to, value)
	end
	return to
end

local outboardLeft = {}	-- left
joinTbl(outboard, outboardLeft,{
	{ CLSID = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}"},--paired R-60 left
})

local outboardRight = {}	-- Right
joinTbl(outboard, outboardRight,{
	{ CLSID = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}"}, --paired R-60 right
})


local wingtips = {
    { CLSID = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}" }, -- 9M114 Shturm-V-2
	{ CLSID = "{2x9M120_Ataka_V}" }, -- 9M120 Ataka-V-2
	{ CLSID = "{2x9M120F_Ataka_V}" }, -- 9M120F Ataka-V-2
	{ CLSID = "{2x9M220_Ataka_V}" }, -- 9M220O Ataka-V-2
	{ CLSID = "{9M114 Shturm-V-2 Rack}" },
}



Mi_24 =  {
        
	Name 				=   'Mi-24',
	DisplayName			= _('Mi-24V'),
	Picture 			= "Mi-24V.png",
	Rate 				= 30, -- RewardPoint in Multiplayer
	Shape 				= "mi-24w",
	
	country_of_origin = "RUS",

	shape_table_data 	= 
	{
		{
			file  	 = 'mi-24w';
			life  	 = 20; -- прочность объекта (методом lifebar*) -- The strength of the object (ie. lifebar *)
			vis   	 = 3; -- множитель видимости (для маленьких объектов лучше ставить поменьше). Visibility factor (For a small objects is better to put lower nr).
			desrt    = "mi-24w-oblomok"; -- Name of destroyed object file name
			fire  	 = { 300, 4}; -- Fire on the ground after destoyed: 300sec 4m
			username = 'Mi-24';
			index    =  WSTYPE_PLACEHOLDER;
			classname = "lLandPlane";
			positioning = "BYNORMAL";
		},
		{
			file  = "mi-24w-oblomok";
			fire  = { 0, 1};
		}
	},
	mapclasskey = "P0091000021",
	sounderName = "Aircraft/Helicopters/Mi-24",
	attribute  			= {wsType_Air, wsType_Helicopter, wsType_Battleplane, WSTYPE_PLACEHOLDER ,"Attack helicopters",},
	InternalCargo = {
			nominalCapacity = 800,
			maximalCapacity = 800,
			area 	  	  = {1.4, 1.5, 1.4},-- cargo bay dimensions
			far_wall_pos  = {1.8,-0.75,0}, -- coordinates on  point on corner of floor and centerline of far wall , together with area  it will give  geometry of cargo compartment in BCS
			out_door = {
				main_left = {large = true, x = 0, z = -1.4, heading = math.rad(-90),
                    mechanicals = {
						close = {"Door2", "Close"},
						board = {"Door2", "Open"},
						boardable = {{mechanism = "Door2", states = {"Open"}},},
                    },
                },
				main_right = {large = true, x = 0, z = 1.4, heading = math.rad(90),
                    mechanicals = {
						close = {"Door3", "Close"},
						board = {"Door3", "Open"},
						boardable = {{mechanism = "Door3", states = {"Open"}},},
                    },
                },
			},
			distrubPilons = {{id = 7, size = {0.7, 0.0, 0.0},}, {id = 8, size = {0.7, 0.0, 0.0},},},
		},

	Categories = {
        },




	Countermeasures = {
		DISPENSER = "UV-26"
	},
	
	turret_data = {
		H_Max = 60,
		H_Min = -60,
		H_Vel = 20,
		V_Max = 20,
		V_Min = -60,
		V_Vel = 20
		},	
	-------------------------
	undercarriage_movement = 1,
	tail_rotor_RPM = 1124,
	M_empty = 8870,
	M_fuel_max = 1704,
	MaxFuelWeight = "1704",
	MaxHeight = "4500",
	MaxSpeed = "320",
	MaxTakeOffWeight = "11500",	
	EmptyWeight = "8870",
	AmmoWeight = 215.6,
	bigParkingRamp = false,	
	
	
	length	=	20.953,
	height	=	4.354,
	rotor_height	=	2.43,
	rotor_diameter	=	17.3,
	blades_number	=	5,
	blade_area	=	3.34,
	rotor_RPM	=	-240,
	engines_count	=	2,
	blade_chord	=	0.58,
	rotor_MOI	=	14300,
	rotor_pos = 	{0.108,	2.44,	0},
	thrust_correction	=	0.7,
	fuselage_Cxa0	=	0.5,
	fuselage_Cxa90	=	5.9,
	fuselage_area	=	4.8,
	centering	=	-0.09,
	tail_pos = 	{-10.658,	2.611,	0},
	tail_fin_area	=	3.15,
	tail_stab_area	=	1.47,
	M_nominal	=	11200,
	M_max	=	11500,
	MOI = 	{16562,	77634,	75047},
	V_max	=	330,
	V_max_cruise	=	270,
	Vy_max	=	12.5,
	H_stat_max_L	=	2500,
	H_stat_max	=	2200,
	H_din_two_eng	=	4500,
	H_din_one_eng	=	3000,
	range	=	500,
	flight_time_typical	=	120,
	flight_time_maximum	=	240,
	main_gear_pos = 	{ -1.105, -1.69, 1.3 },
	nose_gear_pos = 	{3.3,	-1.92,	0},
	lead_stock_main	=	0.438,
	lead_stock_support	=	0.356,
	stores_number	=	6,
	scheme	=	0,
	fire_rate	=	625,
    doors_movement  = 2,
	--crew_size	=	3,
	crew_size	=	2,
	crew_members = 
	{
		[1] = 
		{
			ejection_seat_name	=	0,
			drop_canopy_name	=	0,
            pos = {3.3, 0.0, 1.0},
			canopy_arg = 131,
            canopy_args = {133, 0.15, 131, 2.0, 38, 0.1, 86, 0.1},			
            ejection_added_speed = {0.0, 0.0, 1.0},
			can_be_playable 	= true,
			role 				= "pilot",
			role_display_name	= _("Pilot"),
		}, -- end of [1]
		[2] = 
		{
			ejection_seat_name	=	0,
			drop_canopy_name	=	0,
            pos = {4.9, -0.5, -1.0},
			canopy_arg = 133,
            canopy_args = {133, 2.0, 131, 0.15, 38, 0.1, 86, 0.1},
            ejection_added_speed = {0.0, 0.0, -1.0},
            canopy_arg = 38,
			can_be_playable 	= true,
			role 				= "pilot",
			role_display_name	= _("Copilot-gunner"),
		}, -- end of [1]
--		[3] = {-- player slot 3
--			ejection_seat_name	=	0,
--			drop_canopy_name	=	0,
--            pos = {1.5, -0.5, 0.0},
----			canopy_arg = 133,
----            canopy_args = {133, 2.0, 131, 0.15, 38, 0.1, 86, 0.1},
--            ejection_added_speed = {0.0, 0.0, -1.0},
--            canopy_arg = 133,
--			can_be_playable 	= true,
--			role 				= "gunner",
--			role_display_name	= _("KORD-gunner"),
--		},
			
	}, -- end of crew_members
	crew_stations = "Hybrid",
	mechanimations = {
		Door0 = { {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "Arg", 38, "to", 1, "in", 1.25 } }
					} },
				Transition = { "Close", "Open" }
			}, {
				Flags = { "Reversible", "StepsBackwards" },
				Sequence = { {
						C = { { "Arg", 38, "to", 0, "in", 1.25 } }
					} },
				Transition = { "Open", "Close" }
			} },
		Door1 = {
			DuplicateOf = "Door0"
		},
		Door4 = { -- sight door external
			{Transition = {"Close", "Open"},  Sequence = {{C = {{"Arg", 336, "to", 0.9, "in", 1.0},},},}, Flags = {"Reversible"},},
			{Transition = {"Open", "Close"},  Sequence = {{C = {{"Arg", 336, "to", 0.0, "in", 1.0},},},}, Flags = {"Reversible", "StepsBackwards"},},
		},
		HeadLights = { {
				Sequence = { {
						C = { { "Arg", 208, "to", 0, "speed", 0.14 } }
					} },
				Transition = { "Any", "Retract" }
			}, {
				Sequence = { {
						C = { { "Arg", 208, "to", 0.8, "speed", 0.14 } }
					} },
				Transition = { "Any", "Taxi" }
			}, {
				Sequence = { {
						C = { { "Arg", 208, "to", 0.9, "speed", 0.14 } }
					} },
				Transition = { "Any", "High" }
			} }
	},

	net_animation =
	{
		208, 			-- searchlight

		65,				-- died/alive
		
		81,				-- no tail

		213,			-- left wing tip damage	
		214,			-- left wing damage
		223,			-- right wing tip damage
		224,		    -- right wing damage
		235,			-- tail stab damage
		
		39,				-- Pilot head turn
		337,			-- Operator head turn
		336,			-- 9K113 sight doors

	},

	RCS	=	12,
	detection_range_max	=	0,
	IR_emission_coeff	=	0.5,
	Vy_land_max	=	12.8,
	Ny_max	=	2.5,
	radar_can_see_ground	=	false,
	sound_name	=	"Aircrafts/Engines/RotorMi24",

	--cannon_sight_type			=
	--cargo_max_weight			=
	--cargo_radius_in_menu		=
	helicopter_hook_pos		= {0, -1.0, 0},
	h_max_gear_hook			= 2.0,


	engines_nozzles =
	{
		[1] =
		{
			exhaust_length_ab_K	=	0.3,
			azimuth = 10,
			diameter = 3,
			engine_number = 1,
			exhaust_length_ab = 3,
			orientation = { 0.5, 0.5, 1 },
			pos = { 0.78, 1.095, -0.902 }			
		}, -- end of [1]
		[2] =
		{
			exhaust_length_ab_K	=	0.3,
			azimuth = -10,
			diameter = 3,
			engine_number = 2,
			exhaust_length_ab = 3,
			orientation = { 0.5, 0.5, -1 },
			pos = { 0.78, 1.095, 0.902 }			
		}, -- end of [1]
	}, -- end of engines_nozzles

	engine_data = 
	{
		power_take_off	=	1470,
		power_max	=	1618,
		power_WEP	=	1618,
		power_TH_k = 
		{
			[1] = 	{0,	-230.8,	2245.6},
			[2] = 	{0,	-230.8,	2245.6},
			[3] = 	{0,	-325.4,	2628.9},
			[4] = 	{0,	-235.6,	1931.9},
		}, -- end of power_TH_k
		SFC_k = 	{2.045e-007,	-0.0006328,	0.803},
		power_RPM_k = 	{-0.08639,	0.24277,	0.84175},
		power_RPM_min	=	9.1384,
		sound_name	=	"Aircrafts/Engines/EngineTV3117",
	}, -- end of engine_data
	cannon_sight_type	=	0,
	fires_pos = 
	{
		[1] = 	{0,	0.7,	0},
		[2] = 	{1.63,	0.95,	-0.6},
		[3] = 	{1.63,	0.95,	0.6},
		[4] = 	{-8.4,	0.96,	0},
		[5] = 	{-1.34,	0.65,	0},
		[6] = 	{1.21,	-1.06,	0},
		[7] = 	{0,	0,	0},
		[8] = 	{0,	0,	0},
		[9] = 	{0,	0,	0},
		[10] = 	{0,	0,	0},
		[11] = 	{0,	0,	0},
	}, -- end of fires_pos
	 effects_presets = {
            {effect = "APU_STARTUP_BLAST", preset = "mi8mtv2", ttl = 3.0},
        },
	
		
	--sensors
	
	detection_range_max		 = 30,
	radar_can_see_ground 	 = true, -- this should be examined (what is this exactly?)
	
	CanopyGeometry = makeHelicopterCanopyGeometry(LOOK_GOOD, LOOK_GOOD, LOOK_AVERAGE),

	Sensors = {
            OPTIC = "Raduga-Sh",
            RWR = "Abstract RWR"
        },

-- Countermeasures
	passivCounterm = {
		CMDS_Edit = true,
		ChaffNoEdit = true,
		SingleChargeTotal = 192,
		chaff = {default = 0, increment = 32, chargeSz = 1},
		flare = {default = 192, increment = 32, chargeSz = 1}
	},
	
	chaff_flare_dispenser = 
		{
			[1] = 
			{
				dir = 	{0.2578,	0.0871,	-0.9623},
				pos = 	{-3.0,	1.0,	-1.28},
			}, -- end of [1]
			[2] = 
			{
				dir = 	{0.2578,	0.0871,	0.9623},
				pos = 	{-3.0,	1.0,	1.28},
			}, -- end of [2]
		}, -- end of chaff_flare_dispenser


	HumanRadio = {
			editable = true,
			frequency = 127.5,
			minFrequency = 100,
			maxFrequency = 400,
			modulation = MODULATION_AM
	},

	panelRadio = {
       [1] = {  
				name = _("R-863"),
				range = {min = 100.0, max = 399.9},
				channels = {
					[1] = { name = _("Channel 0"),		default = 127.5, modulation = _("AM"), connect = true}, -- default
					[2] = { name = _("Channel 1"),		default = 135.0, modulation = _("AM")},	-- min. water
					[3] = { name = _("Channel 2"),		default = 136.0, modulation = _("AM")},	-- nalchik
					[4] = { name = _("Channel 3"),		default = 127.0, modulation = _("AM")},	-- sochi
					[5] = { name = _("Channel 4"),		default = 125.0, modulation = _("AM")},	-- maykop
					[6] = { name = _("Channel 5"),		default = 121.0, modulation = _("AM")},	-- anapa
					[7] = { name = _("Channel 6"),		default = 141.0, modulation = _("AM")},	-- beslan
					[8] = { name = _("Channel 7"),		default = 128.0, modulation = _("AM")},	-- krasnodar-pashk.
					[9] = { name = _("Channel 8"),		default = 126.0, modulation = _("AM")},	-- gelenjik
					[10] = { name = _("Channel 9"),		default = 133.0, modulation = _("AM")},	-- kabuleti
					[11] = { name = _("Channel 10"),	default = 130.0, modulation = _("AM")},	-- gudauta
					[12] = { name = _("Channel 11"),	default = 129.0, modulation = _("AM")},	-- Sukhumi - Babushara
					[13] = { name = _("Channel 12"),	default = 123.0, modulation = _("AM")},	-- Novorossiysk
					[14] = { name = _("Channel 13"),	default = 131.0, modulation = _("AM")},	-- batumi
					[15] = { name = _("Channel 14"),	default = 134.0, modulation = _("AM")},	-- kutaisi
					[16] = { name = _("Channel 15"),	default = 132.0, modulation = _("AM")},	-- senaki
					[17] = { name = _("Channel 16"),	default = 138.0, modulation = _("AM")},	-- Tbilisi - Lochini
					[18] = { name = _("Channel 17"),	default = 122.0, modulation = _("AM")},	-- krasnodar-center
					[19] = { name = _("Channel 18"),	default = 124.0, modulation = _("AM")},	-- krymsk
					[20] = { name = _("Channel 19"),	default = 137.0, modulation = _("AM")}, -- mozdok
				}
			},--[1]
			[2] = {  
				name = _("R-828"),
				range = {min = 20.0, max = 59.9},
				channels = {
					[1] = { name = _("Channel 0"),		default = 21.5, modulation = _("FM")}, -- default
					[2] = { name = _("Channel 1"),		default = 25.7, modulation = _("FM")},
					[3] = { name = _("Channel 2"),		default = 27.0, modulation = _("FM")},
					[4] = { name = _("Channel 3"),		default = 28.0, modulation = _("FM")},
					[5] = { name = _("Channel 4"),		default = 30.0, modulation = _("FM")},
					[6] = { name = _("Channel 5"),		default = 32.0, modulation = _("FM")},
					[7] = { name = _("Channel 6"),		default = 40.0, modulation = _("FM")},
					[8] = { name = _("Channel 7"),		default = 50.0, modulation = _("FM")},
					[9] = { name = _("Channel 8"),		default = 55.5, modulation = _("FM")},
					[10] = { name = _("Channel 9"),		default = 59.9, modulation = _("FM")},
				}
			},--[2]			
    },



    Guns = {
            YakB_12_7_mi24v({muzzle_pos_connector = "Gun_point",
                rates = {4500,2250},
                effect_arg_number = 350,
                }),

    },


	Pylons = {
		 pylon(1, 0, -1.150000, -0.732000, -3.208000,
            {
				use_full_connector_position = true,
				connector = "hardpoint-1",
				DisplayName = _("@MSL"),

            },
           wingtips
        ),
        pylon(2, 0, -1.073000, -0.191000, -2.282000,
            {
				arg = 309,
				arg_value = 0.3,
                use_full_connector_position = true,
				connector = "hardpoint-2",
				DisplayName = _("1"),
				--FiZ = 2.0,
            },
            outboardLeft
        ),
        pylon(3, 0, -1.073000, -0.067000, -1.689000,
            {
				arg = 310,
				arg_value = 0.3,
				use_full_connector_position = true,--если TRUE, то читается положение из 3Дмодели, иначе - согласно координат от ц.м. в строке
				connector = "hardpoint-3",
				DisplayName = _("2"),
				FiZ = 0.0,--угол поворота по тангажу (Z) для ВСЕГО оружия, 
				--и в зависимости значения use_full_connector_position , 
				--добавляет это значение либо к позиции коннектора, либо к СГФ
            },
           inboardL
        ),
        pylon(4, 0, -1.073000, -0.139000, 1.769000,
            {
				arg = 311,
				arg_value = 0.3,
				use_full_connector_position = true,--если TRUE, то читается положение из 3Дмодели, иначе - согласно координат от ц.м. в строке
				connector = "hardpoint-4",--
				DisplayName = _("3"),
				FiZ = 0.0,--угол поворота по тангажу (Z) для ВСЕГО оружия, 
				--и в зависимости значения use_full_connector_position , добавляет это значение либо к позиции коннектора, либо к СГФ				
            },
            inboardR
        ),
        pylon(5, 0, -1.073000, -0.272000, 2.363000,
            {
				arg = 312,
				arg_value = 0.3,
				use_full_connector_position = true,
				connector = "hardpoint-5",
				DisplayName = _("4"),

            },
           outboardRight
        ),
        pylon(6, 0, -1.150000, -0.828000, 3.289000,
            {
				use_full_connector_position = true,
				connector = "hardpoint-6",
				DisplayName = _("@MSL"),

            },
           wingtips
        ),
--		pylon(7, 0, 0.000, 0.000, 0.0000,
--            {
--				use_full_connector_position=true, connector = "GUNNER_POINT1", arg = 38 , arg_value = 0, DisplayName = _("L MG"),
--            },
--            {
--				{ CLSID = "KORD_12_7_MI24_L", forbidden = {{station = 8, loadout = {"KORD_12_7_MI24_R"}}, 
--															{station = 3, loadout = {"B_8V20A_CM"}},
--															{station = 3, loadout = {"B_8V20A_OFP2"}},
--															{station = 3, loadout = {"B_8V20A_OM" }},
--															{station = 3, loadout = {"{UB-32A-24}"}},--UB-32A-24 pod - 32 x S-5KO
--															{station = 3, loadout = {"{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}"}},--B-8V20A pod - 20 x S-8KOM
--															{station = 3, loadout = {"{APU_68_S-24}"}},	--S-24
--															{station = 3, loadout = {"GUV_YakB_GSHP"}},
--															{station = 3, loadout = {"GUV_VOG"}}
--															}, 
--															arg_value = 1},
--            }
--        ),
--		pylon(8, 0, 0.000, 0.000, 0.0000,
--            {
--				use_full_connector_position=true, connector = "GUNNER_POINT", arg = 86 , arg_value = 0, DisplayName = _("R MG"),
--            },
--            {
--				{ CLSID = "KORD_12_7_MI24_R", forbidden = {{station = 7, loadout = {"KORD_12_7_MI24_L"}}, 
--															{station = 4, loadout = {"B_8V20A_CM"}},
--															{station = 4, loadout = {"B_8V20A_OFP2"}},
--															{station = 4, loadout = {"B_8V20A_OM" }},
--															{station = 4, loadout = {"{UB-32A-24}"}},--UB-32A-24 pod - 32 x S-5KO
--															{station = 4, loadout = {"{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}"}},--B-8V20A pod - 20 x S-8KOM
--															{station = 4, loadout = {"{APU_68_S-24}"}},	--S-24
--															{station = 4, loadout = {"GUV_YakB_GSHP"}},
--															{station = 4, loadout = {"GUV_VOG"}}
--															}, 
--															arg_value = 1},
--            }
--        ),

    },
	
	Tasks = {
		aircraft_task(CAS),
        aircraft_task(GroundAttack),
		aircraft_task(Escort),
        aircraft_task(Transport),
        aircraft_task(AFAC),
        aircraft_task(AntishipStrike)
    },	
	DefaultTask = aircraft_task(CAS),
	
	LandRWCategories =
	{
		[1] = 
		{
			Name = "AircraftCarrier",
		}, -- end of [1]
		[2] = 
		{
			Name = "HelicopterCarrier",
		}, -- end of [2]
	}, -- end of LandRWCategories
	TakeOffRWCategories =
	{
		[1] = 
		{
			Name = "AircraftCarrier",
		}, -- end of [1]
		[2] = 
		{
			Name = "HelicopterCarrier",
		}, -- end of [2]
	}, -- end of TakeOffRWCategories
	
	SFM_Data = {
		aerodynamics = -- Cx = Cx_0 + Cy^2*B2 +Cy^4*B4
		{
			Cy0	=	0.0668, -- zero AoA lift coefficient*
			Mzalfa	=	4.355, -- coefficients for pitch agility
			Mzalfadt	=	0.8,  -- coefficients for pitch agility
			kjx	=	2,--2.3, -- Inertia parametre X - Dimension (clean) airframe drag coefficient at X (Top) Simply the wing area in square meters (as that is a major factor in drag calculations)
			kjz	=	0.01,--0.0011, -- Inertia parametre Z - Dimension (clean) airframe drag coefficient at Z (Front) Simply the wing area in square meters (as that is a major factor in drag calculations)
			Czbe	=	-0.014, -- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
			cx_gear	=	0.02, -- coefficient, drag, gear ??
			cx_flap	=	0.06, -- coefficient, drag, full flaps
			cy_flap	=	0.35, -- coefficient, normal force, lift, flaps
			cx_brk	=	0.026, -- coefficient, drag, breaks
			table_data = 
			{	--      M		Cx0*	 	Cya*		B2		 	B4	 		Omxmax		Aldop*		Cymax*
				{ 0.0,	0.018	,	0.067	,	0.074	,	0.01 	,	0.372	,	17.3	,	1.1},		
				{ 0.1,	0.018	,	0.067	,	0.074	,	0.01 	,	0.372	,	17.3	,	1.1},
				{ 0.2,	0.0172	,	0.067	,	0.074	,	0.01	   ,	0.741	,	17.3	,	1.1},
				{ 0.3,	0.0165	,	0.067	,	0.074	,	0.01    ,	1.089	,	17.3	,	1.1},
				{ 0.4,	0.016	,	0.0682	,	0.074	,	0.01  	,	1.489	,	17.3	,	1.1},
				{ 0.5,	0.016	,	0.0708	,	0.074	,	0.01 	,	1.489	,	16.9	,	1.075},
				{ 0.6,	0.016	,	0.0746	,	0.074	,	0.01 	,	1.208	,	16.2	,	1.031},
				{ 0.7,	0.016	,	0.0798	,	0.074	,	0.01 	,	0.475	,	15.3	,	0.974},
				{ 0.8,	0.0168	,	0.0850	,	0.08 	,	0.01 	,	0.103	,	13.9	,	0.882},
				{ 0.86,	0.018	,	0.0822	,	0.082	,	0.11		,	0.028	,	12.8	,	0.815},
				{ 0.9,	0.0232	,	0.076	,	0.088	,	0.36 	,	0.008   ,	11.6	,	0.737},
				{ 0.94,	0.0402	,	0.0737	,	0.125	,	0.43	   ,	0.006	,	9.8	,	0.625},
				{ 1,	    0.0598	,	0.0735	,	0.15 	,	0.56   	,	0.004	,	8	,	0.511},
				{ 1.04,	0.063	,	0.0744	,	0.23 	,	0.84 	,	0.002	,	7.4	,	0.469},
				{ 1.2,	0.0642	,	0.0760	,	0.26 	,	1   	,	0.001 	,	6.7	,	0.425},
			}, -- end of table_data
			-- M - Mach number
			-- Cx0 - Coefficient, drag, profile, of the airplane
			-- Cya - Normal force coefficient of the wing and body of the aircraft in the normal direction to that of flight. Inversely proportional to the available G-loading at any Mach value. (lower the Cya value, higher G available) per 1 degree AOA
			-- B2 - Polar 2nd power coeff
			-- B4 - Polar 4th power coeff
			-- Omxmax - roll rate, rad/s
			-- Aldop - Alfadop Max AOA at current M - departure threshold
			-- Cymax - Coefficient, lift, maximum possible (ignores other calculations if current Cy > Cymax)
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	35, -- RPM at idle
			MinRUD	=	0, -- Min state of the РУД
			MaxRUD	=	1, -- Max state of the РУД
			MaksRUD	=	1, -- Military power state of the РУД
			ForsRUD	=	1, -- Afterburner state of the РУД
			type	=	"TurboShaft",
			hMaxEng	=	19, -- Max altitude for safe engine operation in km
			dcx_eng	=	0.0134, -- Engine drag coeficient
			cemax	=	1.24, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			cefor	=	2.56, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			dpdh_m	=	1340, --  altitude coefficient for max thrust
			dpdh_f	=	1340, --  altitude coefficient for AB thrust
			table_data = 
			{		--   M			Pmax		 Pfor	
				{ 0.0	,	26000	,	26000	},
				{ 0.1	,	26000	,	26000	},
				{ 0.2	,	24430	,	24430	},
				{ 0.3	,	23040	,	23040	},
				{ 0.4	,	22090	,	22090	},
				{ 0.5	,	21490	,	21490	},
				{ 0.6	,	21310	,	21310	},
				{ 0.7	,	21400	,	21400    },
				{ 0.8	,	22090	,	22090	},
				{ 0.86,	22780	,	22780	},
				{ 0.9	,	23300	,	23300	},
				{ 0.94,	23650	,	23650	},
				{ 1	,	24260	,	24260	},
				{ 1.04,	24600	,	24600	},
				{ 1.1	,	25640	,	25640	},
				
				
			}, -- end of table_data
			-- M - Mach number
			-- Pmax - Engine thrust at military power
			-- Pfor - Engine thrust at AFB
		}, -- end of engine
	},

	Failures = {
			{ id = 'APU_Fire',							label = _('AI-98 Tank-3 Fire'),					enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'LeftEngine_Fire',					label = _('Left Engine Fire'),					enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'RightEngine_Fire',					label = _('Right Engine Fire'),					enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'MainReducer_Fire',					label = _('Main Reducer Fire'),					enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
	},

	Damage = {
		[0] = {
			critical_damage = 10
		},
		[3] = {
			args = { 65 },
			critical_damage = 10
		},
		[4] = {
			args = { 150 },
			critical_damage = 10
		},
		[5] = {
			args = { 149 },
			critical_damage = 10
		},
		[7] = {
			args = { 249 },
			critical_damage = 4
		},
		[9] = {
			args = { 154, 298, 299 },
			critical_damage = 5
		},
		[10] = {
			args = { 153, 301, 302 },
			critical_damage = 5
		},
		[11] = {
			args = { 167 },
			critical_damage = 1
		},
		[12] = {
			args = { 161 },
			critical_damage = 1
		},
		[23] = {
			args = { 223 },
			critical_damage = 5
		},
		[24] = {
			args = { 213 },
			critical_damage = 5
		},
		[35] = {
			args = { 224 },
			critical_damage = 5,
			deps_cells = { 23 }
		},
		[36] = {
			args = { 214 },
			critical_damage = 5,
			deps_cells = { 24 }
		},
		[45] = {
			args = { 235 },
			critical_damage = 3
		},
		[46] = {
			args = { 233 },
			critical_damage = 3
		},
		[55] = {
			args = { 159 },
			critical_damage = 4,
			deps_cells = { 45, 46 }
		},
		[56] = {
			args = { 81, 158 },
			critical_damage = 14,
			deps_cells = { 55, 45, 46 }
		},
		[57] = {
			args = { 81, 157 },
			critical_damage = 14,
			deps_cells = { 55, 45, 46 }
		},
		[58] = {
			critical_damage = 10
		},
		[59] = {
			args = { 148 },
			critical_damage = 5
		},
		[60] = {
			args = { 144 },
			critical_damage = 1
		},
		[64] = {
			critical_damage = 3
		},
		[67] = {
			critical_damage = 3
		},
		[70] = {
			critical_damage = 3
		},
		[73] = {
			critical_damage = 3
		},
		[76] = {
			critical_damage = 3
		},
		[82] = {
			args = { 152 },
			critical_damage = 3
		},
		[137] = {
			args = { -1 },
			construction = {
				durability = 99999.99999,
				skin = "Water"
			},
			critical_damage = 99999
		},
		[138] = {
			args = { -1 },
			construction = {
				durability = 99999.99999,
				skin = "Water"
			},
			critical_damage = 99999
		},
		[139] = {
			args = { -1 },
			construction = {
				durability = 99999.99999,
				skin = "Water"
			},
			critical_damage = 99999
		},
		cell_indices = {
			FRONT_WHEEL = 137,
			LEFT_WHEEL = 138,
			RIGHT_WHEEL = 139
		}
	},
	
	DamageParts = 
	{  
	[1] = "mi-24v-wing-r",
	[2] = "mi-24v-wing-l",
	[4] = "Mi-24V-TAIL",
	[5] = "mi-24p_blade",
	},


	lights_data = {
		lights = {
			[2] = {
				lights = { {
						lights = { {
								argument = 45,
								connector = "MAIN_SPOT_PTR",
								movable = true,
								proto = {
									angle_change_rate = 0.10471975511966,
									angle_max = 0.22689280275926,
									angle_min = 0.19198621771938,
									color = { 255, 201, 125, 0.28690682760248 },
									cool_down_t = 1.12,
									power_up_t = 1.12,
									range = 3600
								},
								typename = "spotlight"
							}, {
								connector = "MAIN_SPOT_PTR",
								movable = true,
								proto = {
									angle_change_rate = 0.20943951023932,
									angle_max = 0.83775804095728,
									angle_min = 0,
									color = { 255, 201, 125, 0.15545341380124 },
									cool_down_t = 1.12,
									power_up_t = 1.12,
									range = 360
								},
								typename = "spotlight"
							}, {
								connector = "MAIN_SPOT_PTR",
								movable = true,
								pos_correction = { 0.25, 0, 0 },
								proto = {
									angle_change_rate = 0.10471975511966,
									angle_max = 0.22689280275926,
									angle_min = 0.19198621771938,
									color = { 255, 201, 125, 0.28690682760248 },
									cool_down_t = 1.12,
									power_up_t = 1.12,
									range = 3600
								},
								range = 8,
								typename = "omnilight"
							} },
						typename = "collection"
					} },
				typename = "collection"
			},
			[3] = {
				lights = { {
						lights = { {
								argument = 190,
								connector = "BANO_1",
								dir_correction = {
									elevation = -0.78539816339745
								},
								proto = {
									angle_max = 2.6179938779915,
									angle_min = 1.5707963267949,
									color = { 1, 0.35, 0.15, 0.15 },
									range = 40
								},
								typename = "Spot"
							}, {
								argument = 191,
								connector = "BANO_2",
								dir_correction = {
									elevation = 0.95993108859688
								},
								proto = {
									angle_max = 2.6179938779915,
									angle_min = 1.5707963267949,
									color = { 0, 0.894, 0.6, 0.15 },
									range = 40
								},
								typename = "Spot"
							}, {
								argument = 192,
								connector = "BANO_0",
								dir_correction = {
									azimuth = 3.1415926535898
								},
								proto = {
									angle_max = 3.1415926535898,
									color = { 1, 1, 1, 0.12 },
									range = 18
								},
								typename = "Spot"
							} },
						typename = "collection"
					} },
				typename = "collection"
			},
			[WOLALIGHT_TIPS_LIGHTS] = {
				lights = { {
						argument = 47,
						typename = "argumentlight"
					} },
				typename = "collection"
			},
			[6] = {
				lights = { {
						lights = { {
								argument = 45,
								connector = "MAIN_SPOT_PTR",
								movable = true,
								proto = {
									angle_change_rate = 0.10471975511966,
									angle_max = 0.22689280275926,
									angle_min = 0.19198621771938,
									color = { 255, 201, 125, 0.28690682760248 },
									cool_down_t = 1.12,
									power_up_t = 1.12,
									range = 3600
								},
								typename = "spotlight"
							}, {
								connector = "MAIN_SPOT_PTR",
								movable = true,
								proto = {
									angle_change_rate = 0.20943951023932,
									angle_max = 0.83775804095728,
									angle_min = 0,
									color = { 255, 201, 125, 0.15545341380124 },
									cool_down_t = 1.12,
									power_up_t = 1.12,
									range = 360
								},
								typename = "spotlight"
							}, {
								connector = "MAIN_SPOT_PTR",
								movable = true,
								pos_correction = { 0.25, 0, 0 },
								proto = {
									angle_change_rate = 0.10471975511966,
									angle_max = 0.22689280275926,
									angle_min = 0.19198621771938,
									color = { 255, 201, 125, 0.28690682760248 },
									cool_down_t = 1.12,
									power_up_t = 1.12,
									range = 3600
								},
								range = 8,
								typename = "omnilight"
							} },
						typename = "collection"
					} },
				typename = "collection"
			},
			[7] = {
				lights = { {
						lights = { {
								argument = 193,
								connector = "RED_BEACON",
								emitter_shift_x = -0.2,
								proto = {
									angle_max = 0.78539816339745,
									angle_min = 0.61086523819802,
									angular_velocity = 6.2831853071796,
									color = { 1, 0, 0, 0.19049409439665 },
									cups = 2,
									range = 40
								},
								typename = "RotatingBeacon"
							} },
						typename = "Collection"
					} },
				typename = "collection"
			}
		},
		typename = "collection"
	},




	AddPropAircraft = {			
			{ id = "LeftEngineResource", control = 'slider', xCtrl = 195, label = _('Left Engine Resource'), defValue = 90, min = 40, max = 100, dimension = '%'	,playerOnly = true},
			{ id = "RightEngineResource", control = 'slider', xCtrl = 195, label = _('Right Engine Resource'), defValue = 90, min = 40, max = 100, dimension = '%'	,playerOnly = true},
			{ id = "ExhaustScreen" , control = 'checkbox', label = _('Exhaust Dispenser'), defValue = true, weight = 160, arg = 457},
			{ id = "NS430allow" , control = 'checkbox', label = _('NS 430 allow'), defValue = true		, playerOnly = true},
			{ id = "PilotNVG" , control = 'checkbox', label = _('Allow Pilots NVG'), defValue = true},
			{ id = "OperatorNVG" , control = 'checkbox', label = _('Allow Operators NVG'), defValue = true},
			{ id = "R60equipment" , control = 'checkbox', label = _('R-60 equipment'), defValue = true,
				weaponRestricted= { ["{APU-60-1_R_60M}"] = true,  -- true - оружие разрешено при установленной галке
									["{275A2855-4A79-4B2D-B082-91EA2ADF4691}"] = true,
									["{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}"] = true,
				},
			},
						-- AI HELPER SECTION
			{ id = "ai_Label", control = 'label', label = _('AI HELPER'), xLbl = 150,},
			{ id = "OverrideIFF", control = 'comboList', label = _('AI IFF Detection Mode'), playerOnly = true,
				values = {{id = 0, dispName = _("Auto")},
					{id = 1, dispName = _("Simple")},
					{id = 2, dispName = _("Label Only")},
					{id = 3, dispName = _("Realistic")}
				},
				defValue  = 0,
				wCtrl     = 150,
			},
			{ id = "GunnersAISkill" , control = 'slider', xCtrl = 195, label = _('Gunners AI Skill'), defValue = 90, min = 10, max = 100, dimension = '%'},
			{ id = "SimplifiedAI" , control = 'checkbox', label = _('Simplified AI'), defValue = false},
			{ id = "HideAngleBoxes" , control = 'checkbox', label = _('Hide boxes in Pilot AI menu'), defValue = false	,playerOnly = true},
			{ id = "TrackAirTargets" , control = 'checkbox', label = _('Track air targets'), defValue = true},
						-- MULTIPLAYER SECTION
			{ id = "mul_Label", control = 'label', label = _('MULTIPLAYER'), xLbl = 150, playerOnly = true},	
			{ id = "NetCrewControlPriority" , control = 'comboList', label = _('Aircraft Control Priority'), playerOnly = true,
				values = {{id =  0, dispName = _("Pilot")},
					{id =  1, dispName = _("Copilot-gunner")},
					{id = -1, dispName = _("Ask Always")},
					{id = -2, dispName = _("Equally Responsible")}
				},
				defValue  = 0,
				wCtrl     = 150,
			},
			{ id = "HumanOrchestra" , control = 'checkbox', label = _('Disable Multicrew'), defValue = false	,playerOnly = true},
	},
	
	input_profile_entry = "Mi-24_pilot",
	
	rotor_animation = 
	{
		tail_rotor = 
		{
			blades_count	= 3,
			modelBlade_FBX 	= "/models/mi-24p_blade.FBX", 
			rotor_direction = -1,
			rotor_locations = {{pos = {-10.682161, 2.644318, -0.580},yaw = math.rad(90),roll = math.rad(30)}},
		},
		rotor_locations	= {{pos   = {0.015594, 2.440141, 0.143468}}},
		rotor_models 	= 
		{{
			modelRotorHub_EDM  		=  "mi-24p_rotor_hub",
			modelRotorHubLod_FBX 	=  "/models/mi-24p_rotor_hub_lod.fbx",
			boundRotorHub_FBX		=  "/models/mi-24p_rotor_hub_bound.FBX",
			boundBlade_FBX			=  "/models/mi-24p_rotor_blade_bound.fbx",
			modelBlade_FBX 			= { "/models/mi-24p_rotor_blade.fbx", "/models/mi-24p_rotor_blade_damage_1.fbx", "/models/mi-24p_rotor_blade_damage_2.fbx", "/models/mi-24p_rotor_blade_damage_3.fbx" },
		}}
	}	


}

add_aircraft(Mi_24)