--
-- file prepared: 4 September 2025 20:41:19.881, using fd689c
--
--SFM_characteristics.lua (file 2 for assembly)

javelin = {

	Name = 'javelin',

	DisplayName = _('javelin'),
	ViewSettings = ViewSettings,
	Countries = { "Abkhazia","Australia","Austria","Belarus","Belgium","Brazil","Bulgaria","Canada","China",
			 "Croatia","Czech Republic","Denmark","Egypt","ESA","Finland","France","Georgia",
			 "German Empire","Germany","Greece","Hungary","Imperial Japan","India","Insurgents","Iran",
			 "Iraq","Israel","Italy","Japan","Kazakhstan","NASA","North Korea","Norway",
			 "Pakistan","Poland","Romania","Russia","Saudi Arabia","Serbia","Slovakia","South Korea",
			 "South Ossetia","Spain","Sweden","Switzerland","Syria","The Netherlands","Third Reich","Turkey","UK",
			 "Ukraine","USA","USAF Aggressors","USSR","Vietnam"},

	HumanCockpit = false,
	HumanCockpitPath = current_mod_path..'/Cockpit/',
	Picture = "javelin.png",
	Rate = 50,
	Shape = "javelin",

	shape_table_data =
	{
		{
			file = 'javelin';
			life = 20;
			vis = 3;
			fire = { 300, 2};
			username = 'javelin';
			index = WSTYPE_PLACEHOLDER;
		},
	},
	------------------------ -
	mapclasskey = "P0091000024",
	attribute = {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER, "Multirole fighters", "Refuelable", "Datalink", "Link16"},
	Categories = {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},

	---------	General	Characteristics	---------



		--This is not an accurate flight model for this aircraft.  The values used in this file are not based on any technical, military or restricted content related to the aircraft, nor are they derived from real world operation or testing.
		--The values in this file are based on publicly available data (examples: airframe dimensions, weights, engine type/power, operating speeds and altitudes).  Thus, this will not provide an accurate representation in game of either actual real-world performance nor of the flight characteristics of this aircraft.
		--Values for the following were obtained from Wikipedia: the maximum speed of the aircraft, its climb rate and service ceiling as well as aircraft attributes such as engine thrust, weights, wing surface area and other aircraft dimensions.
		--Estimates for the following were obtained from Google AI search queries, or Google Gemini queries: sustained turn rate performance, operational g limit, stall speed, altitude at which maximum speed is attained, maximum speed at sea level.
		--Values for the engine table and for the aerodynamics table were refined by in-game testing, with the objective of permitting the user to fly the aircraft in DCS World as 'player' to the max velocity, and service ceiling corresponding to the aircraft as found on the sources disucssed above.

	length = 17.3,
	height = 4.9,
	wing_area = 86.1,
	wing_span = 16,
	wing_tip_pos = { -4.07, -0.2, 7.63},
	RCS = 6.4,											--(estimated as 0.0375*((height*length) + wing surface area)) )
	air_refuel_receptacle_pos = { 6.11, 0.51, 1.02},
	has_speedbrake = true,								-- default
	brakeshute_name = 4,								-- default
	is_tanker = false,									-- default
	tanker_type = 2,									-- default
	stores_number = 8,
	wing_type = 0,										-- default
	crew_size = 2,										-- default

	------- Weight & Fuel Characteristics -------
	M_empty = 10886,
	M_nominal = 14324,
	M_max = 19579,
	M_fuel_max = 4000,
	H_max = 16093,										-- (calculated from service_ceiling)
	CAS_min = 69,
	average_fuel_consumption = 1,						-- default

	----------_ AI Flight Parameters -----------
	V_opt = 216,
	V_take_off = 72,
	V_land = 72,
	V_max_sea_level = 135,
	V_max_h = 199,
	Vy_max = 27,
	Mach_max = 0.93,
	Ny_min = -3,										-- default
	Ny_max = 4,											-- note: default level override for javelin
	Ny_max_e = 4,										-- note: default level override for javelin
	AOA_take_off = 0.16,								-- default
	bank_angle_max = 71.2,								-- note: default level override for javelin
	range = 3000,										-- default
	flaps_maneuver = 1,									-- default

	-------- Suspension Characteristics -------
	and_gear_max = 1,									-- default
	nose_gear_pos = { 6.33, -2.9, 0},
	nose_gear_wheel_diameter = 0.5,						-- default
	nose_gear_amortizer_direct_stroke = 0.05,			-- default
	nose_gear_amortizer_reversal_stroke = -0.25,		-- default
	nose_gear_amortizer_normal_weight_stroke = -0.05,	-- default
	main_gear_pos = { -0.4, -2.41, 3.33},
	main_gear_wheel_diameter = 0.75,					-- default
	main_gear_amortizer_direct_stroke = 0.1,			-- default
	main_gear_amortizer_reversal_stroke = -0.275,		-- default
	main_gear_amortizer_normal_weight_stroke = -0.1,	-- default

	---------- Engine Characteristics ---------
	has_afteburner = true,
	thrust_sum_max = 9985.8,
	thrust_sum_ab = 11166,
	engines_count = 2,
	IR_emission_coeff = 0.05,							-- default
	IR_emission_coeff_ab = 0.05,						-- default

	--------- Sensors Characteristics ---------
	detection_range_max = 250,							-- default
	radar_can_see_ground = true,						-- default


---------------------------------------------------------------------------------------------------------------------------------------------

	crew_members =
	{
		[1] =
		{
			ejection_seat_name = 9,
			drop_canopy_name = "aircraft_canopy",
			canopy_pos = {6.33, -1.95, 0},
			canopy_ejection_dir = {0.0, 0.5, -0.5},
			pos = {6.33, -2.9, 0},
		}, --end of[1]
		[2] =
		{
			ejection_seat_name = 9,
			drop_canopy_name = "aircraft_canopy_2",
			canopy_pos = {6.33, -1.95, 0},
			canopy_ejection_dir = {0.0, 0.5, 0.5},
			pos = {6.33, -2.9, 0},
			canopy_arg = 421,
		}, --end of[2]
	}, --end of crew_members

---------------------------------------------------------------------------------------------------------------------------------------------


	--------- Engine, nozzles and exhaust ---------

	engines_nozzles = {
		[1] =
		{
			pos = {-6.25, -0.4, 0.5},
			elevation = -0.4,
			diameter = 1.1,								-- default
			exhaust_length_ab = 8,						-- default
			exhaust_length_ab_K = 0.707,				-- default
			smokiness_level = 0.15,
			afterburner_circles_count = 7,				-- default
			afterburner_circles_pos = { 0.2, 0.8 },		-- default
			afterburner_circles_scale = 0.95,			-- default
		}, -- end of [1]
		[2] =
		{
			pos = {-6.25, -0.4, -0.5},
			elevation = -0.4,
			diameter = 1.1,							-- default
			exhaust_length_ab = 8,					-- default
			exhaust_length_ab_K = 0.707,				-- default
			smokiness_level = 0.15,
			afterburner_circles_count = 7,			-- default
			afterburner_circles_pos = { 0.2, 0.8 },	-- default
			afterburner_circles_scale = 0.95,		-- default
		}, -- end of [2]
	}, -- end of engines_nozzles


---------------------------------------------------------------------------------------------------------------------------------------------


	Guns = {
		ADEN({ muzzle_pos = {1.25, -0.3, 3.85},_connector =  "Point_Gun_01",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		ADEN({ muzzle_pos = {1, -0.25, 4.15},_connector =  "Point_Gun_02",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		ADEN({ muzzle_pos = {1, -0.25, -4.15},_connector =  "Point_Gun_03",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		ADEN({ muzzle_pos = {1.25, -0.3, -3.85},_connector =  "Point_Gun_04",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
	},


	Pylons = {
		pylon(1, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon1", arg = 308, arg_value = 0,
			},
			{
			} 
		),
		pylon(2, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon2", arg = 309, arg_value = 0,
			},
			{
			} 
		),
		pylon(3, 0, -1.5, -0.9, 2.5, --
			{
				use_full_connector_position = true, connector = "Pylon3", arg = 310, arg_value = 0,
			},
			{
				{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" }, --AIM-9M
				{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" }, --AIM-9P
			} 
		),
		pylon(4, 0, -1.5, -0.9, 3.5, --
			{
				use_full_connector_position = true, connector = "Pylon4", arg = 311, arg_value = 0,
			},
			{
				{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" }, --AIM-9M
				{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" }, --AIM-9P
			} 
		),
		pylon(5, 0, -1.5, -0.9, -3.5, --
			{
				use_full_connector_position = true, connector = "Pylon5", arg = 312, arg_value = 0,
			},
			{
				{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" }, --AIM-9M
				{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" }, --AIM-9P
			} 
		),
		pylon(6, 0, -1.5, -0.9, -2.5, --
			{
				use_full_connector_position = true, connector = "Pylon6", arg = 313, arg_value = 0,
			},
			{
				{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" }, --AIM-9M
				{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" }, --AIM-9P
			} 
		),
		pylon(7, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon7", arg = 314, arg_value = 0,
			},
			{
			} 
		),
		pylon(8, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon8", arg = 315, arg_value = 0,
			},
			{
			} 
		),
	},

	chaff_flare_dispenser =
	{
		[1] =
		{
			dir = {0, 1, 0},
			pos = {-5.09, 0.33, -1.07},
		}, --end of[1]
	}, --end of chaff_flare_dispenser

	--Countermeasures
	passivCounterm = {
		CMDS_Edit = true,
		SingleChargeTotal = 128,
		chaff = {default = 64, increment = 3, chargeSz = 1},
		flare = {default = 64, increment = 3, chargeSz = 1}
	},


---------------------------------------------------------------------------------------------------------------------------------------------


	fires_pos =
	{
		[1] = { -1.5625, -0.2, 0.0},
		[2] = { -0.625, -0.2, 4.15},
		[3] = { -0.9375, -0.2, -4.15},
		[4] = { -1.5, -0.2, 1.9075},
		[5] = { -1.5, -0.2, -1.9075},
		[6] = { -1.5, -0.2, 6.104},
		[7] = { -1.5, -0.2, -6.104},
		[8] = { -6.25, -0.4, 4.15},
		[9] = { -6.25, -0.4, -4.15},
		[10] = { -3.125, -0.2, 4.15},
		[11] = { -3.125, -0.2, -4.15},
	},	-- end of fires_pos

---------------------------------------------------------------------------------------------------------------------------------------------


--(file 3 for aessembly)

	--[[
	fires_pos =
	{
		[1] = 	{-1.594,	-0.064,		0},
		[2] = 	{-1.073,	0.319,		2.304},
		[3] = 	{-1.187,	0.338,		-4.678},
		[4] = 	{-0.82,		0.265,		2.774},
		[5] = 	{-0.82,		0.265,		-2.774},
		[6] = 	{-0.82,		0.255,		4.274},
		[7] = 	{-0.82,		0.255,		-4.274},
		[8] = 	{-5.889,	-0.257,		1.193},
		[9] = 	{-5.889,	-0.257,		-1.193},
		[10] = 	{-1.257,	0.283,		3.05},
		[11] = 	{-1.257,	0.283,		-3.05},
	}, -- end of fires_pos
	]]--

	--[[

	-- Countermeasures
	passivCounterm = {
		CMDS_Edit = true,
		SingleChargeTotal = 128,
		-- PPR-26
		chaff = {default = 64, increment = 3, chargeSz = 1},
		-- PPI-26
		flare = {default = 64, increment = 3, chargeSz = 1}
	},
	]]--

	attribute 		= { wsType_Air, wsType_Airplane, wsType_Fighter, Su_34,"Bombers", "Refuelable"},
	CanopyGeometry	=  makeAirplaneCanopyGeometry(LOOK_GOOD, LOOK_AVERAGE, LOOK_AVERAGE),
	
	--[[
	Sensors =
	{
		RADAR = "N-011M",
		OPTIC = "Su-34 FLIR",
		RWR   = "Abstract RWR"
	},
	]]--

	Tasks =
	{
		aircraft_task(AFAC),
		aircraft_task(SEAD),
		aircraft_task(AntishipStrike),
		aircraft_task(CAS),
		aircraft_task(CAP),
		aircraft_task(Intercept),
		aircraft_task(PinpointStrike),
		aircraft_task(GroundAttack),
		aircraft_task(RunwayAttack),
	},
	DefaultTask = aircraft_task(CAP),

	--SFM_aerodynamics.lua (file 4 for assembly)

	SFM_Data = {
		aerodynamics = --Cx = Cx_0 + Cy ^ 2 * B2 + Cy ^ 4 * B4
		{

			Cy0 = 0,
			Mzalfa = 4.355,					-- default
			Mzalfadt = 0.8,					-- default
			kjx = 3,						-- default
			kjz = 0.00125,					-- default
			Czbe = -0.016,					-- default
			cx_gear = 0.02,					-- default
			cx_flap = 0.08,					-- default
			cy_flap = 0.25,					-- default
			cx_brk = 0.1,					-- default

			table_data = {
				--M     Cx0     Cya     B       B4      Omxmax  Aldop   Cymax
				{0,		0.015,	0.023,	0.495,	0.747,	2.3,	12.8,	0.294,		},
				{0.1,	0.015,	0.0208,	0.495,	0.747,	6.25,	14.1,	0.294,		},
				{0.2,	0.015,	0.0188,	0.495,	0.747,	6.25,	15.6,	0.294,		},
				{0.3,	0.015,	0.0299,	0.495,	0.747,	6.25,	17.3,	0.494,		},
				{0.4,	0.015,	0.041,	0.495,	0.747,	6.25,	19.1,	1,		},
				{0.5,	0.015,	0.0314,	0.509,	1.31,	6.25,	19.1,	1,		},
				{0.6,	0.015,	0.03,	0.471,	1.74,	6.25,	19.1,	1,		},
				{0.7,	0.015,	0.03,	0.532,	3.35,	6.25,	19.1,	1,		},
				{0.8,	0.0213,	0.03,	0.519,	3.27,	2.3,	19.1,	1,		},
				{0.9,	0.035,	0.03,	0.00145,	0.00019,	2.01,	19.1,	1,		},
				{1,		0.0575,	0.03,	0.0015,	0.0002,	1.76,	18.2,	0.951,		},
				{1.1,	0.0675,	0.03,	0.00155,	0.00021,	1.54,	17.3,	0.905,		},
				{1.2,	0.0775,	0.03,	0.0016,	0.00022,	1.35,	16.4,	0.861,		},
				{1.3,	0.0875,	0.03,	0.00165,	0.00023,	1.18,	15.6,	0.819,		},
			}, --end of table_data

		--This is not an accurate flight model for this aircraft.  The values used in this file are not based on any technical, military or restricted content related to the aircraft, nor are they derived from real world operation or testing.
		--The values in this file are based on publicly available data (examples: airframe dimensions, weights, engine type/power, operating speeds and altitudes).  Thus, this will not provide an accurate representation in game of either actual real-world performance nor of the flight characteristics of this aircraft.
		--Values for the following were obtained from Wikipedia: the maximum speed of the aircraft, its climb rate and service ceiling as well as aircraft attributes such as engine thrust, weights, wing surface area and other aircraft dimensions.
		--Estimates for the following were obtained from Google AI search queries, or Google Gemini queries: sustained turn rate performance, operational g limit, stall speed, altitude at which maximum speed is attained, maximum speed at sea level.
		--Values for the engine table and for the aerodynamics table were refined by in-game testing, with the objective of permitting the user to fly the aircraft in DCS World as 'player' to the max velocity, and service ceiling corresponding to the aircraft as found on the sources disucssed above.

		}, --end of aerodynamics
		engine = 
		{
			Nmg = 50,					-- default
			MinRUD = 0,					-- default
			MaxRUD = 1,					-- default
			MaksRUD  = 0.85,					-- default
			ForsRUD  = 0.91,					-- default
			typeng  = 1,
			hMaxEng	= 19,				-- default
			dcx_eng = 0.015,			-- default
			cemax  = 1.24,				-- default
			cefor  = 2.56,				-- default
			dpdh_m = 1000,					-- default
			dpdh_f = 2000,					-- default

			--[[			table_data = {
				--M 	Pmax	Pafb
				{0,	84948,	95350,		},
				{0.2,	84948,	95350,		},
				{0.4,	84948,	95350,		},
				{0.6,	84948,	95350,		},
				{0.8,	84948,	95350,		},
				{1,	84948,	95350,		},
				{1.2,	84948,	95350,		},
				{1.4,	84948,	95350,		},
				{1.6,	84948,	95350,		},
				{1.8,	84948,	95350,		},
				{2,	84948,	95350,		},
				{2.2,	84948,	95350,		},
			}, --end of table_data
			--]]

			table_data = {
				--M 	Pmax	Pafb
				{0.0,	0.0,	0.0,		},
				{ 2.0,	0.0,	0.0,		},
			}, --end of table_data


			--[[
				engine calibration worksheet (for in-game testing)
				alt     	vel		adj
				0 k ft		0.m		adj:+/-
				15 k ft		0.m		adj:+/-
				40 k ft		0.m		adj:+/-
				42 k ft		0.m		adj:+/-
				46 k ft		0.m		adj:+/-
				51 k ft		0.m		adj:+/-
				56 k ft		0.m		adj:+/-
				59 k ft		0.m		adj:+/-
			]]--

			extended = {

				thrust_max = {
					M = { 0.000000, 0.200000, 0.400000, 0.600000, 0.800000, 1.000000, 1.200000, 1.400000, 1.600000, 1.800000, 2.000000, 2.200000, }, 
					H = { 0, 4571, 12191, 12801, 14066, 15825, 17231, 18023 }, 
					thrust = {
						{ 85173,  85173,  85173,  85173,  85173,  85173,  85173,  85173,  85173,  85173,  85173,  85173  }, 
						{ 84859,  84859,  84859,  84859,  84859,  84859,  84859,  84859,  84859,  84859,  84859,  84859  }, 
						{ 54148,  54148,  54148,  54148,  54148,  54148,  54148,  54148,  54148,  54148,  54148,  54148  }, 
						{ 43927,  43927,  43927,  43927,  43927,  43927,  43927,  43927,  43927,  43927,  43927,  43927  }, 
						{ 36712,  36712,  36712,  36712,  36712,  36712,  36712,  36712,  36712,  36712,  36712,  36712  }, 
						{ 36712,  36712,  36712,  36712,  36712,  36712,  36712,  36712,  36712,  36712,  36712,  36712  }, 
						{ 16153,  16153,  16153,  16153,  16153,  16153,  16153,  16153,  16153,  16153,  16153,  16153  }, 
						{ 1958,   1958,   1958,   1958,   1958,   1958,   1958,   1958,   1958,   1958,   1958,   1958   }, 
					}, -- thrust = {

				}, --thrust_max = {

				thrust_afterburner  = {
					M = { 0.000000, 0.200000, 0.400000, 0.600000, 0.800000, 1.000000, 1.200000, 1.400000, 1.600000, 1.800000, 2.000000, 2.200000, }, 
					H = { 0, 4571, 12191, 12801, 14066, 15825, 17231, 18023 }, 
					thrust = {
						{ 95238,  95238,  95238,  95238,  95238,  95238,  95238,  95238,  95238,  95238,  95238,  95238  }, 
						{ 94888,  94888,  94888,  94888,  94888,  94888,  94888,  94888,  94888,  94888,  94888,  94888  }, 
						{ 60547,  60547,  60547,  60547,  60547,  60547,  60547,  60547,  60547,  60547,  60547,  60547  }, 
						{ 49119,  49119,  49119,  49119,  49119,  49119,  49119,  49119,  49119,  49119,  49119,  49119  }, 
						{ 41051,  41051,  41051,  41051,  41051,  41051,  41051,  41051,  41051,  41051,  41051,  41051  }, 
						{ 41051,  41051,  41051,  41051,  41051,  41051,  41051,  41051,  41051,  41051,  41051,  41051  }, 
						{ 18062,  18062,  18062,  18062,  18062,  18062,  18062,  18062,  18062,  18062,  18062,  18062  }, 
						{ 2189,   2189,   2189,   2189,   2189,   2189,   2189,   2189,   2189,   2189,   2189,   2189   }, 
					}, -- thrust = {

				}, --thrust_afterburner = {

			}, -- extended = {

		--This is not an accurate flight model for this aircraft.  The values used in this file are not based on any technical, military or restricted content related to the aircraft, nor are they derived from real world operation or testing.
		--The values in this file are based on publicly available data (examples: airframe dimensions, weights, engine type/power, operating speeds and altitudes).  Thus, this will not provide an accurate representation in game of either actual real-world performance nor of the flight characteristics of this aircraft.
		--Values for the following were obtained from Wikipedia: the maximum speed of the aircraft, its climb rate and service ceiling as well as aircraft attributes such as engine thrust, weights, wing surface area and other aircraft dimensions.
		--Estimates for the following were obtained from Google AI search queries, or Google Gemini queries: sustained turn rate performance, operational g limit, stall speed, altitude at which maximum speed is attained, maximum speed at sea level.
		--Values for the engine table and for the aerodynamics table were refined by in-game testing, with the objective of permitting the user to fly the aircraft in DCS World as 'player' to the max velocity, and service ceiling corresponding to the aircraft as found on the sources disucssed above.


		}, --end of engine

	},

	DamageParts =
	{
		[1] = "javelin-collision",
	},

	-- (file 5 for aessembly)

	-- new
	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
		[0]		= {critical_damage = 5, args = {146}},
		[3]		= {critical_damage = 20,args = {65}}  ,
		[4]		= {critical_damage = 20, args = {150}},
		[5]		= {critical_damage = 20, args = {147}},
		[7]		= {critical_damage = 4, args = {249}} ,
		[9]		= {critical_damage = 3, args = {154}},
		[10]	= {critical_damage = 3, args = {153}},
		[11]	= {critical_damage = 3, args = {167}},
		[12]	= {critical_damage = 3, args = {161}},
		[15]	= {critical_damage = 5, args = {267}},
		[16]	= {critical_damage = 5, args = {266}},
		[23]	= {critical_damage = 8, args = {223}, deps_cells = {25}},
		[24]	= {critical_damage = 8, args = {213}, deps_cells = {26, 60}},
		[25]	= {critical_damage = 3, args = {226}},
		[26]	= {critical_damage = 3, args = {216}},
		[29]	= {critical_damage = 9, args = {224}, deps_cells = {31, 25, 23}},
		[30]	= {critical_damage = 9, args = {214}, deps_cells = {32, 26, 24, 60}},
		[31]	= {critical_damage = 4, args = {229}},
		[32]	= {critical_damage = 4, args = {219}},
		[35]	= {critical_damage = 10, args = {225}, deps_cells = {29, 31, 25, 23}},
		[36]	= {critical_damage = 10, args = {215}, deps_cells = {30, 32, 26, 24, 60}} ,
		[37]	= {critical_damage = 4, args = {227}},
		[38]	= {critical_damage = 4, args = {217}},
		[39]	= {critical_damage = 7,	args = {244}, deps_cells = {53}},
		[40]	= {critical_damage = 7, args = {241}, deps_cells = {54}},
		[45]	= {critical_damage = 9, args = {235}, deps_cells = {39, 51, 53}},
		[46]	= {critical_damage = 9, args = {233}, deps_cells = {40, 52, 54}},
		[51]	= {critical_damage = 3, args = {239}},
		[52]	= {critical_damage = 3, args = {237}},
		[53]	= {critical_damage = 3, args = {248}},
		[54]	= {critical_damage = 3, args = {247}},
		[55]	= {critical_damage = 20, args = {81}, deps_cells = {39, 40, 45, 46, 51, 52, 53, 54}},
		[59]	= {critical_damage = 5, args = {148}},
		[60]	= {critical_damage = 1, args = {144}},

		[83]	= {critical_damage = 3, args = {134}} ,-- nose wheel
		[84]	= {critical_damage = 3, args = {136}}, -- left wheel
		[85]	= {critical_damage = 3, args = {135}} ,-- right wheel
	},


	-- solve triangle to have B_end == C_end with given A
	-- B_start assumed to be A_start
	-- C_start assumed to be A_end
	
	SolveTriangles = 
	{
		-- left gear post kinematics 
		{
			A_start   = "bracing_centr004",
			A_end     = "bracing_centr003",
			B_end     = "bracing_004",
			B_control = 484,
			C_end	  = "bracing_003",
			C_control = 483,
			B_scale   =  1/math.rad(46);
			C_scale   =  1/math.rad(25);
		},
		-- right gear post kinematics 
		{
			A_start   = "bracing_centr006",
			A_end     = "bracing_centr005",
			B_end     = "bracing_006",
			B_control = 486,
			C_end	  = "bracing_005",
			C_control = 485,
			B_scale   =  1/math.rad(46);
			C_scale   =  1/math.rad(25);
		},
	},  --SolveTriangles


}



--SFM_add.lua (file 6 for assembly)

add_aircraft(javelin)


