local R550_M1 =
{
    category = CAT_AIR_TO_AIR,
	name = "R_550_M1",
	user_name = _("R550 Magic 1"),
	display_name_short	= _("R550"),
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
    Escort = 0,
    Head_Type = 1,
	sigma = {3, 3, 3}, 
    M = 89.0,
    H_max = 15000.0,
    H_min = 1.0,
    Diam = 157.0,
    Cx_pil = 2,
    D_max = 7000.0,
    D_min = 500.0,
    Head_Form = 0,
    Life_Time = 30.0,
    Nr_max = 35,
    v_min = 140.0,
    v_mid = 400.0,
    Mach_max = 2.0,
    t_b = 0.0,
    t_acc = 2.0,
    t_marsh = 0.0,
    Range_max = 10000.0,
    H_min_t = 10.0,
    Fi_start = 0.53,
    Fi_rak = 1.1,
    Fi_excort = 0.53,
    Fi_search = 0.044,
    OmViz_max = 0.52,
    warhead = predefined_warhead("R_550"),
    exhaust = { 0.7, 0.7, 0.7, 1.0 },
    X_back = -1.45,
    Y_back = 0.0,
    Z_back = 0.0,
    Reflection = 0.03,
    KillDistance = 5.0,
	--seeker sensivity params
    SeekerSensivityDistance = 10000, -- The range of target with IR value = 1. In meters. 
	ccm_k0 = 2.0,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.	
	supersonic_A_coef_skew = 0.25, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.016, -- площадь выходного сечения сопла
	
	shape_table_data =
	{
		{
			name	 = "magic-r550_1",
			file	 = "magic-r550_1",
			life	 = 1,
			fire	 = {0, 1},
			username = "magic-r550_1",
			index 	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	ModelData = {   58 ,  -- model params count
		0.4 ,   -- characteristic square (характеристическая площадь)
			
		-- параметры зависимости Сx
		0.05 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
		0.1 , -- Cx_k1 высота пика волнового кризиса
		0.01 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
		0.001, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
		0.5 , -- Cx_k4 крутизна спада за волновым кризисом 
		0.8 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
		
		-- параметры зависимости Cy
		2.5, -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
		0.8, -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
		1.2, -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
		
		0.13, -- 7 Alfa_max  максимальный балансировачный угол, радианы
		0.0, --угловая скорость создаваймая моментом газовых рулей
		
		-- Engine data. Time, fuel flow, thrust.	
		--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end		   -- Stage
		-1.0,		   -1.0,	2.0,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
		0.0,		    0.0,	11.8,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
		0.0,		    0.0,	25000.0,	0.0,	    0.0,			0.0,		0.0,           -- thrust, newtons
		
		30.0, -- таймер самоликвидации, сек
		30.0, -- время работы энергосистемы, сек
		0, -- абсолютная высота самоликвидации, м
		0.3, -- время задержки включения управления (маневр отлета, безопасности), сек
		1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
		1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
		0.0,  -- синус угла возвышения траектории набора горки
		370, -- продольное ускорения взведения взрывателя
		0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
		1.19, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
		1.0, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
		2.0, -- характеристика системы САУ-РАКЕТА,  полоса пропускания контура управления
		-- ЗРП. Данные для рассчета дальностей пуска (индикация на прицеле)
		6.0, -- производная дальности по скорости носителя на высоте 1км, ППС
		-8.0, -- производная дальности по скорости цели на высоте 1км, ЗПС
		-1.2, -- производная по высоте производной дальности по скорости цели, ЗПС
		8900, -- дальность ракурс 180(навстречу) град, Н=5000м, V=900км/ч, м
		2900.0, -- дальность ракурс 0(в догон) град, Н=5000м, V=900км/ч, м
		14000.0, -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м
		5300.0, -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
		6700.0, -- дальность ракурс 180(навстречу) град, Н=1000м,  V=900км/ч, м
		1800.0, -- дальность ракурс 0(в догон) град, Н=1000м, V=900км/ч, м
		2500.0, -- смещение назад отнсительно нуля задней точки зоны достижимости
		0.35, -- процент гарантированной дальности от дальности в ППС на высоте 1км
		-0.01, -- производная процента гарантированной дальности в ППС по высоте
		0.5, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя.
	},
}

declare_weapon(R550_M1)

local R550_M2 =
{
	category = CAT_AIR_TO_AIR,
	name = "R_550",
	user_name = _("R550 Magic 2"),
	display_name_short	= _("R550"),
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,R_550},
    Escort = 0,
    Head_Type = 1,
	sigma = {3, 3, 3}, 
    M = 89.0,
    H_max = 18000.0,
    H_min = 1.0,
    Diam = 157.0,
    Cx_pil = 2,
    D_max = 4000.0,
    D_min = 500.0,
    Head_Form = 0,
    Life_Time = 30.0,
    Nr_max = 30,
    v_min = 140.0,
    v_mid = 400.0,
    Mach_max = 2.0,
    t_b = 0.0,
    t_acc = 1.88,
    t_marsh = 0.0,
    Range_max = 10000.0,
    H_min_t = 10.0,
    Fi_start = 0.96,
    Fi_rak = 3.14152,
    Fi_excort = 0.96,
    Fi_search = 0.044,
    OmViz_max = 0.52,
    warhead = predefined_warhead("R_550"),
    exhaust = { 0.7, 0.7, 0.7, 1.0 },
    X_back = -1.45,
    Y_back = 0.0,
    Z_back = 0.0,
    Reflection = 0.03,
    KillDistance = 5.0,
	--seeker sensivity params
	SeekerSensivityDistance = 20000, -- The range of target with IR value = 1. In meters. 
	ccm_k0 = 0.5,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.	
	supersonic_A_coef_skew = 0.25, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.016, -- площадь выходного сечения сопла
	
	shape_table_data =
	{
		{
			name	 = "magic-r550",
			file	 = "magic-r550",
			life	 = 1,
			fire	 = {0, 1},
			username = "magic-r550",
			index 	 = R_550,
		},
	},
	
	ModelData = {   58 ,  -- model params count
		0.4 ,   -- characteristic square (характеристическая площадь)
			
		-- параметры зависимости Сx
		0.05 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
		0.1 , -- Cx_k1 высота пика волнового кризиса
		0.01 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
		0.001, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
		0.5 , -- Cx_k4 крутизна спада за волновым кризисом 
		0.8 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
			
		-- параметры зависимости Cy
		2.5, -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
		0.8, -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
		1.2, -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
		
		0.13, -- 7 Alfa_max  максимальный балансировачный угол, радианы
		0.0, --угловая скорость создаваймая моментом газовых рулей
		
		-- Engine data. Time, fuel flow, thrust.	
		--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
		-1.0,		   -1.0,	1.88,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
		0.0,		    0.0,	12.58,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
		0.0,		    0.0,	29750.0,	0.0,	    0.0,			0.0,		0.0,           -- thrust, newtons
		
		30.0, -- таймер самоликвидации, сек
		30.0, -- время работы энергосистемы, сек
		0, -- абсолютная высота самоликвидации, м
		0.3, -- время задержки включения управления (маневр отлета, безопасности), сек
		1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
		1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
		0.0,  -- синус угла возвышения траектории набора горки
		450, -- продольное ускорения взведения взрывателя
		0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
		1.19, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
		1.0, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
		2.0, -- характеристика системы САУ-РАКЕТА,  полоса пропускания контура управления
		-- ЗРП. Данные для рассчета дальностей пуска (индикация на прицеле)
		6.0, -- производная дальности по скорости носителя на высоте 1км, ППС
		-8.0, -- производная дальности по скорости цели на высоте 1км, ЗПС
		-1.2, -- производная по высоте производной дальности по скорости цели, ЗПС
		10000, -- дальность ракурс 180(навстречу) град, Н=5000м, V=900км/ч, м
		3300.0, -- дальность ракурс 0(в догон) град, Н=5000м, V=900км/ч, м
		16000.0, -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м
		6000.0, -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
		7500.0, -- дальность ракурс 180(навстречу) град, Н=1000м,  V=900км/ч, м
		2100.0, -- дальность ракурс 0(в догон) град, Н=1000м, V=900км/ч, м
		2500.0, -- смещение назад отнсительно нуля задней точки зоны достижимости
		0.35, -- процент гарантированной дальности от дальности в ППС на высоте 1км
		-0.01, -- производная процента гарантированной дальности в ППС по высоте
		0.5, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя.
	},
}

declare_weapon(R550_M2)

local R530F_EM =
{
	category = CAT_AIR_TO_AIR,
	name = "R_530F_EM",
	user_name = _("R530F EM"),
	display_name_short = "R530",
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
    Escort = 1,
    Head_Type = 6,
	sigma = {10, 10, 10}, 
    M = 195.0,
    H_max = 21000.0,
    H_min = 1.0,
    Diam = 260.0,
    Cx_pil = 2,
    D_max = 10000.0,
    D_min = 1500.0,
    Head_Form = 0,
    Life_Time = 30.0,
    Nr_max = 15,
    v_min = 140.0,
    v_mid = 400.0,
    Mach_max = 2.0,
    t_b = 0.0,
    t_acc = 2.5,
    t_marsh = 6.0,
    Range_max = 10000.0,
    H_min_t = 10.0,
    Fi_start = 0.52,
    Fi_rak = 3.14152,
    Fi_excort = 0.73,
    Fi_search = 0.2,
    OmViz_max = 0.18,
    warhead = simple_aa_warhead(30.0),
    exhaust = { 0.7, 0.7, 0.7, 1.0 },
    X_back = -1.6,
    Y_back = -0.168,
    Z_back = 0.0,
    Reflection = 0.11,
    KillDistance = 30.0,
	PN_gain = 3,
	ccm_k0 = 3.0,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	supersonic_A_coef_skew = 0.25, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.025, -- площадь выходного сечения сопла
	
	shape_table_data =
	{
		{
			name	 = "R530F EM",
			file	 = "matra-r530",
			life	 = 1,
			fire	 = {0, 1},
			username = "R530F EM",
			index 	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	ModelData = {   58 ,  -- model params count
		1.0 ,   -- characteristic square (характеристическая площадь)
			
		-- параметры зависимости Сx
		0.0257 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
		0.06 , -- Cx_k1 высота пика волнового кризиса
		0.01 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
		-0.002, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
		0.32 , -- Cx_k4 крутизна спада за волновым кризисом 
		1.2 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
			
		-- параметры зависимости Cy
		1.8, -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
		0.8, -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
		1.2, -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
		
		0.26, -- 7 Alfa_max  максимальный балансировачный угол, радианы
		0.0, --угловая скорость создаваймая моментом газовых рулей
		
		-- Engine data. Time, fuel flow, thrust.	
		--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
		-1.0,		   -1.0,	2.5,  		6.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
		0.0,		    0.0,	8.0,		3.98,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
		0.0,		    0.0,	15930.0,	7420.0,	    0.0,			0.0,		0.0,           -- thrust, newtons
		
		25.0, -- таймер самоликвидации, сек
		25.0, -- время работы энергосистемы, сек
		0, -- абсолютная высота самоликвидации, м
		1.5, -- время задержки включения управления (маневр отлета, безопасности), сек
		1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
		1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
		0.0,  -- синус угла возвышения траектории набора горки
		130, -- продольное ускорения взведения взрывателя
		0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
		1.19, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
		1.0, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
		2.0, -- характеристика системы САУ-РАКЕТА,  полоса пропускания контура управления
		-- ЗРП. Данные для рассчета дальностей пуска (индикация на прицеле)
		6.0, -- производная дальности по скорости носителя на высоте 1км, ППС
		-8.0, -- производная дальности по скорости цели на высоте 1км, ЗПС
		-1.2, -- производная по высоте производной дальности по скорости цели, ЗПС
		12000, -- дальность ракурс 180(навстречу) град, Н=5000м, V=900км/ч, м
		3000.0, -- дальность ракурс 0(в догон) град, Н=5000м, V=900км/ч, м
		18000.0, -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м
		6000.0, -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
		8500.0, -- дальность ракурс 180(навстречу) град, Н=1000м,  V=900км/ч, м
		1600.0, -- дальность ракурс 0(в догон) град, Н=1000м, V=900км/ч, м
		2500.0, -- смещение назад отнсительно нуля задней точки зоны достижимости
		0.4, -- процент гарантированной дальности от дальности в ППС на высоте 1км
		-0.01, -- производная процента гарантированной дальности в ППС по высоте
		0.5, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя.
	},
}

declare_weapon(R530F_EM)

local R530F_IR =
{
	category = CAT_AIR_TO_AIR,
	name = "R_530F_IR",
	user_name = _("R530F IR"),
	display_name_short = "R530",
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
    Escort = 0,
    Head_Type = 1,
	sigma = {3, 3, 3}, 
    M = 192.0,
    H_max = 21000.0,
    H_min = 1.0,
    Diam = 260.0,
    Cx_pil = 2,
    D_max = 10000.0,
    D_min = 1500.0,
    Head_Form = 0,
    Life_Time = 30.0,
    Nr_max = 15,
    v_min = 140.0,
    v_mid = 400.0,
    Mach_max = 2.0,
    t_b = 0.0,
    t_acc = 2.5,
    t_marsh = 6.0,
    Range_max = 10000.0,
    H_min_t = 10.0,
    Fi_start = 0.52,
    Fi_rak = 2.4,
    Fi_excort = 0.73,
    Fi_search = 0.05,
    OmViz_max = 0.21,
    warhead = simple_aa_warhead(30.0),
    exhaust = { 0.7, 0.7, 0.7, 1.0 },
    X_back = -1.6,
    Y_back = -0.168,
    Z_back = 0.0,
    Reflection = 0.11,
    KillDistance = 30.0,
	PN_gain = 3,
	--seeker sensivity params
    SeekerSensivityDistance = 10000, -- The range of target with IR value = 1. In meters. 
	ccm_k0 = 2.0,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.
	supersonic_A_coef_skew = 0.25, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.025, -- площадь выходного сечения сопла
	
	shape_table_data =
	{
		{
			name	 = "R530F IR",
			file	 = "matra-r530e",
			life	 = 1,
			fire	 = {0, 1},
			username = "R530F IR",
			index 	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	ModelData = {   58 ,  -- model params count
		1.0 ,   -- characteristic square (характеристическая площадь)
			
		-- параметры зависимости Сx
		0.0257 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
		0.06 , -- Cx_k1 высота пика волнового кризиса
		0.01 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
		-0.002, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
		0.32 , -- Cx_k4 крутизна спада за волновым кризисом 
		1.2 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
			
		-- параметры зависимости Cy
		1.8, -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
		0.8, -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
		1.2, -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
		
		0.26, -- 7 Alfa_max  максимальный балансировачный угол, радианы
		0.0, --угловая скорость создаваймая моментом газовых рулей
		
		-- Engine data. Time, fuel flow, thrust.	
		--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
		-1.0,		   -1.0,	2.5,  		6.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
		0.0,		    0.0,	8.0,		3.98,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
		0.0,		    0.0,	15930.0,	7420.0,	    0.0,			0.0,		0.0,           -- thrust, newtons
		
		25.0, -- таймер самоликвидации, сек
		25.0, -- время работы энергосистемы, сек
		0, -- абсолютная высота самоликвидации, м
		1.5, -- время задержки включения управления (маневр отлета, безопасности), сек
		1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
		1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
		0.0,  -- синус угла возвышения траектории набора горки
		130, -- продольное ускорения взведения взрывателя
		0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
		1.19, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
		1.0, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
		2.0, -- характеристика системы САУ-РАКЕТА,  полоса пропускания контура управления
		-- ЗРП. Данные для рассчета дальностей пуска (индикация на прицеле)
		6.0, -- производная дальности по скорости носителя на высоте 1км, ППС
		-8.0, -- производная дальности по скорости цели на высоте 1км, ЗПС
		-1.2, -- производная по высоте производной дальности по скорости цели, ЗПС
		12000, -- дальность ракурс 180(навстречу) град, Н=5000м, V=900км/ч, м
		3000.0, -- дальность ракурс 0(в догон) град, Н=5000м, V=900км/ч, м
		18000.0, -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м
		6000.0, -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
		8500.0, -- дальность ракурс 180(навстречу) град, Н=1000м,  V=900км/ч, м
		1600.0, -- дальность ракурс 0(в догон) град, Н=1000м, V=900км/ч, м
		2500.0, -- смещение назад отнсительно нуля задней точки зоны достижимости
		0.4, -- процент гарантированной дальности от дальности в ППС на высоте 1км
		-0.01, -- производная процента гарантированной дальности в ППС по высоте
		0.5, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя.
	},
}

declare_weapon(R530F_IR)

local S530F =
{
	category = CAT_AIR_TO_AIR,
	name = "Super_530F",
	user_name = _("S530F"),
	display_name_short = "530F",
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
    Escort = 1,
    Head_Type = 6,
	sigma = {5.6, 5, 5.6},
    M = 245.0,
    H_max = 23000.0, -- 24400.0
    H_min = 1.0,
    Diam = 263.0,
    Cx_pil = 3,
    D_max = 12000.0,
    D_min = 1500.0,
    Head_Form = 1,
    Life_Time = 28.0, -- 45.0
    Nr_max = 25,
    v_min = 140.0,
    v_mid = 1000.0,
    Mach_max = 4.0,
    t_b = 0.0,
    t_acc = 8.0,
    t_marsh = 0.0,
    Range_max = 25000.0, -- 40000.0
    H_min_t = 20.0,
    Fi_start = 0.79,
    Fi_rak = 3.14152,
    Fi_excort = 0.87,
    Fi_search = 0.09,
    OmViz_max = 0.35,
    warhead = predefined_warhead("Super_530D"),
    exhaust = { 0.7, 0.7, 0.7, 1.0 },
    X_back = -1.9,
    Y_back = 0.0,
    Z_back = 0.0,
    Reflection = 0.08,
    KillDistance = 10.0,
	PN_gain = 4,
	ccm_k0 = 1.0,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	supersonic_A_coef_skew = 0.25, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.0227, -- площадь выходного сечения сопла
	
	shape_table_data =
	{
		{
			name	 = "Super_530F",
			file	 = "s530f",
			life	 = 1,
			fire	 = {0, 1},
			username = "Super-530F",
			index 	 = WSTYPE_PLACEHOLDER,
		},
	},
		
	ModelData = {   58 ,  -- model params count
		1.0 ,   -- characteristic square (характеристическая площадь)

		-- параметры зависимости Сx
		0.024 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
		0.056 , -- Cx_k1 высота пика волнового кризиса
		0.01 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
		-0.045, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
		0.26 , -- Cx_k4 крутизна спада за волновым кризисом
		0.7 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
	
		-- параметры зависимости Cy
		0.9 , -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
		0.6	 , -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
		1.2  , -- Cy_k2 крутизна спада(фронта) за волновым кризисом  

		0.4 , -- 7 Alfa_max  максимальный балансировачный угол, радианы
		0.0, --угловая скорость создаваймая моментом газовых рулей
	
		-- Engine data. Time, fuel flow, thrust.	
		--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
			-1.0,		-1.0,		5.0, 		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
			0.0,		0.0,		15.0,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
			0.0,		0.0,		33860.0,	0.0,		0.0,			0.0,		0.0,           -- thrust, newtons

		28.0, -- 45.0 -- minuterie d'autodestruction (sec)
		28.0, -- 45.0 -- temps de fonctionnement du système d’alimentation (sec)
		0, -- hauteur absolue d’auto-élimination (m)
		1.0, -- délai d’activation de la commande (manœuvre de départ, sécurité) (sec)
		1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть меньше или равен предыдущему параметру), м 
		1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
		0.0,  -- angle d’élévation sinusoïdale de la trajectoire de pente
		230, -- accélération longitudinale
		0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
		1.19, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
		1.0, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
		2.0, -- характеристика системы САУ-РАКЕТА,  полоса пропускания контура управления
		-- ЗРП. Данные для рассчета дальностей пуска (индикация на прицеле)
		13.72, -- производная дальности по скорости носителя на высоте 1км, ППС
		-15.78, -- производная дальности по скорости цели на высоте 1км, ЗПС
		-3.2, -- производная по высоте производной дальности по скорости цели, ЗПС
		23660.0, -- дальность ракурс 180(навстречу) град, Н=5000м, V=900км/ч, м
		7741.0, -- дальность ракурс 0(в догон) град, Н=5000м, V=900км/ч, м
		39224.0, -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м
		14472.0, -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
		16343.0, -- дальность ракурс 180(навстречу) град, Н=1000м,  V=900км/ч, м
		4887.0, -- дальность ракурс 0(в догон) град, Н=1000м, V=900км/ч, м
		2500.0, -- смещение назад отнсительно нуля задней точки зоны достижимости
		0.45, -- процент гарантированной дальности от дальности в ППС на высоте 1км
		-0.014, -- производная процента гарантированной дальности в ППС по высоте
		0.5, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя.
	},
}

declare_weapon(S530F)

local S530D = 
{
	category = CAT_AIR_TO_AIR,
	name = "Super_530D",
	user_name = _("S530D"),
	display_name_short = "530D",
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,Super_530D},
    Escort = 1,
    Head_Type = 6,
	sigma = {5.6, 5, 5.6},
    M = 270.0,
    H_max = 24400.0,
    H_min = 1.0,
    Diam = 263.0,
    Cx_pil = 3,
    D_max = 12000.0,
    D_min = 1500.0,
    Head_Form = 1,
    Life_Time = 45.0,
    Nr_max = 30,
    v_min = 140.0,
    v_mid = 1000.0,
    Mach_max = 4.0,
    t_b = 0.0,
    t_acc = 8.0,
    t_marsh = 0.0,
    Range_max = 40000.0,
    H_min_t = 20.0,
    Fi_start = 0.79,
    Fi_rak = 3.14152,
    Fi_excort = 0.87,
    Fi_search = 0.09,
    OmViz_max = 0.35,
    warhead = predefined_warhead("Super_530D"),
    exhaust = { 0.7, 0.7, 0.7, 1.0 },
    X_back = -2.05,
    Y_back = 0.0,
    Z_back = 0.0,
    Reflection = 0.08,
    KillDistance = 10.0,
	PN_gain = 4,
	ccm_k0 = 0.5,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	supersonic_A_coef_skew = 0.25, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.0227, -- площадь выходного сечения сопла
	
	shape_table_data =
	{
		{
			name	 = "Super_530D",
			file	 = "super-530",
			life	 = 1,
			fire	 = {0, 1},
			username = "Super-530D",
			index 	 = Super_530D,
		},
	},
		
	ModelData = {   58 ,  -- model params count
		1.0 ,   -- characteristic square (характеристическая площадь)

		-- параметры зависимости Сx
		0.026 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
		0.053 , -- Cx_k1 высота пика волнового кризиса
		0.01 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
		-0.245, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
		0.075 , -- Cx_k4 крутизна спада за волновым кризисом 
		0.7 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
	
		-- параметры зависимости Cy
		0.9 , -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
		0.6	 , -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
		1.2  , -- Cy_k2 крутизна спада(фронта) за волновым кризисом  

		0.4 , -- 7 Alfa_max  максимальный балансировачный угол, радианы
		0.0, --угловая скорость создаваймая моментом газовых рулей
	
		-- Engine data. Time, fuel flow, thrust.	
		--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
			-1.0,			-1.0,	2.5,  		7.5,		0.0,			0.0,		1.0e9,         -- time of stage, sec
			0.0,			0.0,	13.55,		6.75,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
			0.0,			0.0,	32180.0,	15560.0,	0.0,			0.0,		0.0,           -- thrust, newtons

		45.0, -- таймер самоликвидации, сек
		45.0, -- время работы энергосистемы, сек
		0, -- абсолютная высота самоликвидации, м
		1.0, -- время задержки включения управления (маневр отлета, безопасности), сек
		1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть меньше или равен предыдущему параметру), м 
		1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
		0.0,  -- синус угла возвышения траектории набора горки
		230, -- продольное ускорения взведения взрывателя
		0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
		1.19, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
		1.0, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
		2.0, -- характеристика системы САУ-РАКЕТА,  полоса пропускания контура управления
		-- ЗРП. Данные для рассчета дальностей пуска (индикация на прицеле)
		17.0, -- производная дальности по скорости носителя на высоте 1км, ППС
		-18.0, -- производная дальности по скорости цели на высоте 1км, ЗПС
		-3.3, -- производная по высоте производной дальности по скорости цели, ЗПС
		28000, -- дальность ракурс 180(навстречу) град, Н=5000м, V=900км/ч, м
		9600.0, -- дальность ракурс 0(в догон) град, Н=5000м, V=900км/ч, м
		46000.0, -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м
		18000.0, -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
		19000.0, -- дальность ракурс 180(навстречу) град, Н=1000м,  V=900км/ч, м
		5500.0, -- дальность ракурс 0(в догон) град, Н=1000м, V=900км/ч, м
		2500.0, -- смещение назад отнсительно нуля задней точки зоны достижимости
		0.45, -- процент гарантированной дальности от дальности в ППС на высоте 1км
		-0.014, -- производная процента гарантированной дальности в ППС по высоте
		0.5, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя.
	},
}

declare_weapon(S530D)

local desc_IR = " ".._("IR AAM")

local R550_variants =
{
	["Magic_2"] = {picture = "r60.png",   CLSID = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}", display_name = R550_M2.user_name ..desc_IR, wstype = R550_M2.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = R550_M2.M },
	["Magic_1"] = {picture = "r60.png",   CLSID = "{R550_Magic_1}",                         display_name = R550_M1.user_name ..desc_IR, wstype = R550_M1.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = R550_M1.M },
}

local R550_DRAG  			  = R550_M1.Cx_pil / 4096.0 -- 4096 - magic number from long time ago when flanker was 1.5 
local R550_DRAG_WITH_ADAPTER  = 0.00014 -- TODO verify this value 


local R530_variants =
{
	["EM"] = {picture = "r27erem.png", display_name = R530F_EM.user_name, wstype = R530F_EM.wsTypeOfWeapon, category = CAT_AIR_TO_AIR, mass = R530F_EM.M },
	["IR"] = {picture = "r27et.png",   display_name = R530F_IR.user_name, wstype = R530F_IR.wsTypeOfWeapon, category = CAT_AIR_TO_AIR, mass = R530F_IR.M },
}

local S530_variants =
{
	["530F"] = {picture = "super530.png", display_name = S530F.user_name, wstype = S530F.wsTypeOfWeapon, category = CAT_AIR_TO_AIR, mass = S530F.M },
	["530D"] = {picture = "super530.png", display_name = S530D.user_name, wstype = S530D.wsTypeOfWeapon, category = CAT_AIR_TO_AIR, mass = S530D.M },
}

--[[
local function r550_with_adapter(CLSID, r550_variant)
	local var = R550_variants[r550_variant] or R550_variants["Magic_1"]
	declare_loadout({
		category			= var.category,
		CLSID 				= CLSID,
		Picture				= var.picture,
        PictureBlendColor   = "0xffffffff",
		displayName			=	"LM-39 with".." "..var.display_name,
		wsTypeOfWeapon		=   var.wstype,
		attribute			=	{4,	4,	32,	111},--  TODO update this
		Cx_pil				=	R550_DRAG_WITH_ADAPTER,
		Count				=	1,
		Weight_Empty		=	39,
		Weight				=	39 + var.mass,
		Elements			=	
		{
			{ShapeName	=	"aero-3b",	    IsAdapter  	   =   true  }, -- TODO replace adapter model!!!
			{ShapeName	=	r550_variant,	connector_name =  "Point"},
		}-- end of Elements
	})
end--]]

local function r550_without_adapter(CLSID, r550_variant)
	local var = R550_variants[r550_variant] or R550_variants["Magic_1"]
	declare_loadout({
		category			= 	var.category,
		CLSID 				= 	CLSID,
		Picture				=	var.picture,
--      PictureBlendColor   =   "0xffffffff",
		displayName			=	var.display_name,
		attribute			=	var.wstype,
		Cx_pil				=	R550_DRAG,
		Count				=	1,
		Weight				=	var.mass,
		Elements			=  {{ShapeName = r550_variant}}-- end of Elements
	})
end

local function r530_without_adapter(CLSID, r530_variant)
	local var = R530_variants[r530_variant] or R530_variants["EM"]
	declare_loadout({
		category			= 	var.category,
		CLSID 				= 	CLSID,
		Picture				=	var.picture,
--      PictureBlendColor   =   "0xffffffff",
		displayName			=	var.display_name,
		attribute			=	var.wstype,
		Cx_pil				=	R530F_EM.Cx_pil,
		Count				=	1,
		Weight				=	var.mass,
		Elements			=  {{ShapeName = r530_variant}}-- end of Elements
	})
end

local function s530_without_adapter(CLSID, s530_variant)
	local var = S530_variants[s530_variant] or S530_variants["530F"]
	declare_loadout({
		category			= 	var.category,
		CLSID 				= 	CLSID,
		Picture				=	var.picture,
--      PictureBlendColor   =   "0xffffffff",
		displayName			=	var.display_name,
		attribute			=	var.wstype,
		Cx_pil				=	S530F.Cx_pil,
		Count				=	1,
		Weight				=	var.mass,
		Elements			=  {{ShapeName = s530_variant}}-- end of Elements
	})
end

---------------------------------------------------------------------------------
r550_without_adapter("{R550_Magic_1}",                            "Magic_1")
r550_without_adapter("{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",    "Magic_2")
---------------------------------------------------------------------------------
--r550_with_adapter	 ("{LM_39_with_R550_Magic_1}",                "Magic_1")
--r550_with_adapter	 ("{LM_39_with_R550_Magic_2}",                "Magic_2")
---------------------------------------------------------------------------------
--/////////////////////////////////////////////////////////////////////////////--
---------------------------------------------------------------------------------
r530_without_adapter("{R530F_EM}",    "EM")
r530_without_adapter("{R530F_IR}",    "IR")
---------------------------------------------------------------------------------
--/////////////////////////////////////////////////////////////////////////////--
---------------------------------------------------------------------------------
s530_without_adapter("{S530F}", "530F")
s530_without_adapter("{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}",  "530D")
---------------------------------------------------------------------------------