-- Atlis II

declare_sensor({
	category = SENSOR_OPTICAL,
	Name = "Atlis II CCD TV",
	type = OPTIC_SENSOR_TV,
	scan_volume =
	{
		azimuth = {-150.0, 150.0},
		elevation = {-150.0, 45.0}
	},
	view_volume_max =
	{
		azimuth_sector = 18.4,
		elevation_sector = 24.1
	},
	magnifications = {20.0, 100.0, 280.0},
	resolution = 0.07,
	laserRanger = true,
	laserDesignator = true,
})

declare_loadout({
	category 		= CAT_PODS,
	CLSID			= "{Atlis II for M-2000}",
	attribute		= {4, 15, 44, WSTYPE_PLACEHOLDER},
	Count 			= 1,
	Weight			= 160,
	Cx_pil			= 0.0002,
	Picture			= "wmd7.png",
	displayName		= _("Atlis II Targeting Pod for M-2000"),
	
	shape_table_data =
	{
		{
			--file = "aaq-28LEFT litening",
			file = "wmd7",
			life = 1,
			fire = { 0, 1},
			username = "aaq-28LEFT litening",
			index = WSTYPE_PLACEHOLDER,
		},
	},
	
	Elements =
	{
		{
			--ShapeName = "aaq-28LEFT litening",
			ShapeName = "wmd7",
		}
	},	

	Sensors	 =
	{
		--OPTIC  = {"Litening AN/AAQ-28 FLIR", "Litening AN/AAQ-28 CCD TV"}
		OPTIC  = {"Atlis II CCD TV"}
	}
})

declare_loadout({
	category 		= CAT_PODS,
	CLSID			= "{Atlis II backup}",
	attribute		= {4, 15, 44, WSTYPE_PLACEHOLDER},
	Count 			= 1,
	Weight			= 160,
	Cx_pil			= 0.0002,
	Picture			= "wmd7.png",
	displayName		= _("Atlis II Targeting Pod"),
	
	shape_table_data =
	{
		{
			file = "wmd7",
			life = 1,
			fire = { 0, 1},
			username = "WMD7 POD",
			index = WSTYPE_PLACEHOLDER,
		},
	},
	
	Elements =
	{
		{
			ShapeName = "wmd7",
		}
	},	

	Sensors	 =
	{
		--OPTIC  = {"LANTIRN AAQ-14 FLIR"}
		OPTIC  = {"Atlis II CCD TV"}
	}
})