-----<<<<<mod begin>>>>>
local cockpit = folder.."../../../Cockpit_M2000C-S3/"
-----<<<<<mod end>>>>>
dofile(cockpit.."devices.lua")
dofile(cockpit.."command_defs.lua")

local res = external_profile("Config/Input/Aircrafts/common_joystick_binding.lua")

join(res.keyCommands,{
	--HOTAS Stick
	{category = _('HOTAS'), name = _('MiCRoB/Trigger 1st Stage'),					down = cmds.MICROB_1,		up = cmds.MICROB_1,	value_up = 0, value_down = 1,					},
	{category = _('HOTAS'), name = _('MiCRoB/Trigger 2nd Stage'),					down = cmds.MICROB_2,		up = cmds.MICROB_2,	value_up = 0, value_down = 1,					},
	{category = _('HOTAS'), name = _('Autopilot Standby Mode'),						down = iCommandPlaneAutopilotOverrideOn,	up = iCommandPlaneAutopilotOverrideOff,				},
	{category = _('HOTAS'), name = _('Nosewheel Steering/IFF Interrogate'),			down = iCommandPlane_HOTAS_BoatSwitchAft,	up = iCommandPlane_HOTAS_BoatSwitchForward,			},
	{category = _('HOTAS'), name = _('STT/TWS Toggle'),								down = cmds.RadarSTT,																			},
	{category = _('HOTAS'), name = _('Trim UP'),									pressed = iCommandPlaneTrimUp,				up = iCommandPlaneTrimStop,							},
	{category = _('HOTAS'), name = _('Trim DOWN'),									pressed = iCommandPlaneTrimDown,			up = iCommandPlaneTrimStop,							},
	{category = _('HOTAS'), name = _('Trim LEFT'),									pressed = iCommandPlaneTrimLeft,			up = iCommandPlaneTrimStop,							},
	{category = _('HOTAS'), name = _('Trim RIGHT'),									pressed = iCommandPlaneTrimRight,			up = iCommandPlaneTrimStop,							},
	{category = _('HOTAS'), name = _('Decoy Program release'),						down = iCommandPlaneDropFlareOnce,																},
	{category = _('HOTAS'), name = _('Autopilot Disconnect/Exceed Elastic Limit'),	down = iCommandPlane_HOTAS_PinkySwitchAft,	up = iCommandPlane_HOTAS_PinkySwitchForward,		},
	{category = _('HOTAS'), name = _('Autopilot Disconnect'),						down = cmds.AP_Disconnect,		up = cmds.AP_Disconnect,	value_up = 0, value_down = 1,		},
	{category = _('HOTAS'), name = _('Exceed Elastic Limit'),						down = cmds.ExcdElasLimit,		up = cmds.ExcdElasLimit,	value_up = 0, value_down = 1,		},
	{category = _('HOTAS'), name = _('Autopilot Standby Mode Inverted'),			down = iCommandPlaneAutopilotOverrideOff,	up = iCommandPlaneAutopilotOverrideOn				},
	{category = _('HOTAS'), name = _('NAV Update/MAGIC unlock'),					down = iCommandPlaneCircuitBreaker_12,															},
    {category = _('HOTAS'), name = _('Weapons SystemCMD Depress'),					down = iCommandPlaneChangeWeapon, 			value_down = 0,										},
	{category = _('HOTAS'), name = _('Weapons SystemCMD FWD'),						down = iCommandPlaneChangeWeapon,			value_down = 1,										},
	{category = _('HOTAS'), name = _('Weapons SystemCMD AFT'),						down = iCommandPlaneChangeWeapon,			value_down = 2,										},
	{category = _('HOTAS'), name = _('Gun Trigger'),								down = cmds.GUN_TRIGGER,	up = cmds.GUN_TRIGGER, value_up = 0, value_down = 1,				},
	{category = _('HOTAS'), name = _('BRM Release'),								down = cmds.BRM_RELEASE,	up = cmds.BRM_RELEASE, value_up = 0, value_down = 1,				},
	
	--HOTAS Throttle
	{category = _('HOTAS'), name = _('CNM AA Gun'),										down = iCommandPlaneModeCannon,																},
	{category = _('HOTAS'), name = _('V/UHF GREEN Radio Menu'),							down = cmds.VUHF_Menu,																		},
	{category = _('HOTAS'), name = _('UHF RED Radio Menu'),								down = cmds.UHF_Menu,																		},
	{category = _('HOTAS'), name = _('V/UHF GREEN Radio PTT'),							down = cmds.VUHF_PTT,	up = cmds.VUHF_PTT,	value_down = 1, value_up = 0,					},
	{category = _('HOTAS'), name = _('UHF RED Radio PTT'),								down = cmds.UHF_PTT,	up = cmds.UHF_PTT,	value_down = 1, value_up = 0,					},
	{category = _('HOTAS'), name = _('Airbrake TOGGLE'),								down = iCommandPlaneAirBrake,																},
	{category = _('HOTAS'), name = _('Airbrake ON'),									down = iCommandPlaneAirBrakeOn,																},
	{category = _('HOTAS'), name = _('Airbrake OFF'),									down = iCommandPlaneAirBrakeOff,															},
	{category = _('HOTAS'), name = _('TDC UP'),											down = cmds.TDC_V,	up = cmds.TDC_V,		value_down = 1.0, value_up = 0.0,				},
	{category = _('HOTAS'), name = _('TDC DOWN'),										down = cmds.TDC_V,	up = cmds.TDC_V,		value_down =-1.0, value_up = 0.0,				},
	{category = _('HOTAS'), name = _('TDC LEFT'),										down = cmds.TDC_H,	up = cmds.TDC_H,		value_down =-1.0, value_up = 0.0,				},
	{category = _('HOTAS'), name = _('TDC RIGHT'),										down = cmds.TDC_H,	up = cmds.TDC_H,		value_down = 1.0, value_up = 0.0,				},
	{category = _('HOTAS'), name = _('Decoy PANIC release'),							down = iCommandPlaneDropChaffOnce,															},
	{category = _('HOTAS'), name = _('Jammer PCM Override Toggle'),						down = iCommandActiveJamming,																},
	{category = _('HOTAS'), name = _('CNM neutral (PCA SELECT)'),						down = iCommandPlaneModeGrid,																},
	{category = _('HOTAS'), name = _('CNM MAGIC'),										down = iCommandPlaneModeFI0,																},
	{category = _('HOTAS'), name = _('Magic Slave/AG Designate/INS Position Update'),	down = iCommandAutoLockOnNearestSurfaceTarget,												},
	{category = _('HOTAS'), name = _('TDC DEPRESS (Lock Target)'),						down = iCommandPlaneRadarCenter,															},
	{category = _('HOTAS'), name = _('Radar Antenna UP'),								down = cmds.RadarAntElev, up = cmds.RadarAntElev, value_down=1,	value_up=0,					},
	{category = _('HOTAS'), name = _('Radar Antenna DOWN'),								down = cmds.RadarAntElev, up = cmds.RadarAntElev, value_down=-1,value_up=0,					},
	{category = _('HOTAS'), name = _('Airbrake ON, else OFF'),							down = iCommandPlaneAirBrakeOn,				up = iCommandPlaneAirBrakeOff,					},
	{category = _('HOTAS'), name = _('AA Gun SELECT, else PCA SELECT'),					down = iCommandPlaneModeCannon,				up = iCommandPlaneModeGrid,						},
    {category = _('HOTAS'), name = _('MAGIC SELECT, else PCA SELECT'),					down = iCommandPlaneModeFI0,				up = iCommandPlaneModeGrid,						},
	
	--PCA
	{category = _('PCA Weapons Management'), name = _('Gun Arm TOGGLE'),							down = iCommandPlaneAHCPGUNArm,																},
	{category = _('PCA Weapons Management'), name = _('Master Arm TOGGLE'),							down = iCommandSwitchMasterArm,																},
	{category = _('PCA Weapons Management'), name = _('Selective Jettison TOGGLE'),					down = cmds.SelJett_TOGGLE, 																},
	{category = _('PCA Weapons Management'), name = _('Smoke'),										down = iCommandPlaneWingtipSmokeOnOff,														}, 
	{category = _('PCA Weapons Management'), name = _('Emergency Jettison'),						cockpit_device_id = devices.PCA, down = 3409, up = 3409, value_down = 1, value_up = 0,		},
	{category = _('PCA Weapons Management'), name = _('PCA Button 1 SELECT'),						cockpit_device_id = devices.PCA, down = 3235, up = 3235, value_down = 1, value_up = 0,		},
	{category = _('PCA Weapons Management'), name = _('PCA Button 2 SELECT'),						cockpit_device_id = devices.PCA, down = 3237, up = 3237, value_down = 1, value_up = 0,		},		
	{category = _('PCA Weapons Management'), name = _('PCA Button 3 SELECT'),						cockpit_device_id = devices.PCA, down = 3239, up = 3239, value_down = 1, value_up = 0,		},
	{category = _('PCA Weapons Management'), name = _('PCA Button 4 SELECT'),						cockpit_device_id = devices.PCA, down = 3241, up = 3241, value_down = 1, value_up = 0,		},
	{category = _('PCA Weapons Management'), name = _('PCA Button 5 SELECT'),						cockpit_device_id = devices.PCA, down = 3243, up = 3243, value_down = 1, value_up = 0,		},
	{category = _('PCA Weapons Management'), name = _('AG Gun  SELECT'),							cockpit_device_id = devices.PCA, down = 3245, up = 3245, value_down = 1, value_up = 0,		},
	{category = _('PCA Weapons Management'), name = _('Stores 1 SELECT'),							cockpit_device_id = devices.PCA, down = 3250, up = 3250, value_down = 1, value_up = 0,		},
	{category = _('PCA Weapons Management'), name = _('Stores 2 SELECT'),							cockpit_device_id = devices.PCA, down = 3253, up = 3253, value_down = 1, value_up = 0,		},
	{category = _('PCA Weapons Management'), name = _('Stores 3 SELECT'),							cockpit_device_id = devices.PCA, down = 3256, up = 3256, value_down = 1, value_up = 0,		},
	{category = _('PCA Weapons Management'), name = _('Stores 4 SELECT'),							cockpit_device_id = devices.PCA, down = 3259, up = 3259, value_down = 1, value_up = 0,		},
	{category = _('PCA Weapons Management'), name = _('Stores 5 SELECT'),							cockpit_device_id = devices.PCA, down = 3262, up = 3262, value_down = 1, value_up = 0,		},
	{category = _('PCA Weapons Management'), name = _('Selective Jettison ON'),						cockpit_device_id = devices.PCA, down = 3249, up = 3249, value_down = 1,					},
	{category = _('PCA Weapons Management'), name = _('Selective Jettison OFF'),					cockpit_device_id = devices.PCA, down = 3249, up = 3249, value_down = 0,					},
	{category = _('PCA Weapons Management'), name = _('Selective Jettison Safety Cover OPEN'),		cockpit_device_id = devices.PCA, down = 3248, up = 3248, value_down = 1,					},
	{category = _('PCA Weapons Management'), name = _('Selective Jettison Safety Cover CLOSED'),	cockpit_device_id = devices.PCA, down = 3248, up = 3248, value_down = 0,					},
	{category = _('PCA Weapons Management'), name = _('Selective Jettison OPEN&ON else CLOSED'),	cockpit_device_id = devices.PCA, down = 3249, up = 3248, value_down = 2, value_up = 0		},
	{category = _('PCA Weapons Management'), name = _('Master Arm ARMED'),							cockpit_device_id = devices.PCA, down = 3234, value_down = 1,								},
	{category = _('PCA Weapons Management'), name = _('Master Arm SAFE'),							cockpit_device_id = devices.PCA, down = 3234, value_down = -1,								},
	{category = _('PCA Weapons Management'), name = _('Master ARMED, else SAFE'),					cockpit_device_id = devices.PCA, down = 3234, up = 3234, value_up = -1, value_down = 1,		},
    {category = _('PCA Weapons Management'), name = _('Gun ARMED, else SAFE'),						cockpit_device_id = devices.PCA, down = 3463, up = 3463, value_up = 0, value_down = 1,		},
    {category = _('PCA Weapons Management'), name = _('Selective Jettison ON, else OFF'),			cockpit_device_id = devices.PCA, down = 3249, up = 3249, value_up = 0, value_down = 1,		},
	
    --PPA
    {category = _('PPA Weapons Preparation'), name = _('PPA Test Switch - Test'),							cockpit_device_id = devices.PPA, down = 3275, up = 3275, value_down = -1, value_up = 0,	},
    {category = _('PPA Weapons Preparation'), name = _('PPA Test Switch - Weapon Loadout'),					cockpit_device_id = devices.PPA, down = 3275, up = 3275, value_down =  1, value_up = 0,	},
	{category = _('PPA Weapons Preparation'), name = _('Missile Selector: Fire Left 530D First'),			cockpit_device_id = devices.PPA, down = 3265, up = 3265, value_down =  1,				},
	{category = _('PPA Weapons Preparation'), name = _('Missile Selector: Automatic 530D Fire Selection'),	cockpit_device_id = devices.PPA, down = 3265, up = 3265, value_down =  0,				},
	{category = _('PPA Weapons Preparation'), name = _('Missile Selector: Fire Right 530D First'),			cockpit_device_id = devices.PPA, down = 3265, up = 3265, value_down = -1,				},
	{category = _('PPA Weapons Preparation'), name = _('Bomb Fuze: INERT'),									cockpit_device_id = devices.PPA, down = 3276, up = 3276, value_down =  1,				},
	{category = _('PPA Weapons Preparation'), name = _('Bomb Fuze: RET'),									cockpit_device_id = devices.PPA, down = 3276, up = 3276, value_down =  0.5,				},
	{category = _('PPA Weapons Preparation'), name = _('Bomb Fuze: INST'),									cockpit_device_id = devices.PPA, down = 3276, up = 3276, value_down =  0,				},
	{category = _('PPA Weapons Preparation'), name = _('Bomb Qty Increase'),								cockpit_device_id = devices.PPA, down = 3277, up = 3277, value_down =  1, value_up = 0,	},
	{category = _('PPA Weapons Preparation'), name = _('Bomb Qty Decrease'),								cockpit_device_id = devices.PPA, down = 3277, up = 3277, value_down = -1, value_up = 0,	},
	{category = _('PPA Weapons Preparation'), name = _('Bomb Release Interval Increase'),					cockpit_device_id = devices.PPA, down = 3278, up = 3278, value_down =  1, value_up = 0,	},
	{category = _('PPA Weapons Preparation'), name = _('Bomb Release Interval Decrease'),					cockpit_device_id = devices.PPA, down = 3278, up = 3278, value_down = -1, value_up = 0,	},
	{category = _('PPA Weapons Preparation'), name = _('AUTO/MAN Toggle'),									cockpit_device_id = devices.PPA, down = 3269, up = 3269, value_down =  1, value_up = 0,	},
	{category = _('PPA Weapons Preparation'), name = _('MIS PREP: Super 530D Standby Toggle'),				cockpit_device_id = devices.PPA, down = 3266, up = 3266, value_down =  1, value_up = 0,	},
	{category = _('PPA Weapons Preparation'), name = _('MAG PREP: MAGIC II Standby Toggle'),				cockpit_device_id = devices.PPA, down = 3272, up = 3272, value_down =  1, value_up = 0,	},
	{category = _('PPA Weapons Preparation'), name = _('530D/Rockets/Guns TOT/PAR Firing Mode Toggle'),		cockpit_device_id = devices.PPA, down = 3279, up = 3279, value_down =  1, value_up = 0,	},
	
	--Radio
	{category = _('Radio'), name = _('UHF MODE Rotate CCW'), 	down = cmds.UHF_MODE_INC,			  		  value_down =-1, 							},
	{category = _('Radio'), name = _('UHF MODE Rotate CW'),  	down = cmds.UHF_MODE_INC,			  		  value_down = 1,  							},
	{category = _('Radio'), name = _('UHF Channel Knob Dec'),  	down = cmds.UHF_CH_INC,				  		  value_down =-1, 							},
	{category = _('Radio'), name = _('UHF Channel Knob Inc'),  	down = cmds.UHF_CH_INC,				  		  value_down = 1,  							},
	{category = _('Radio'), name = _('V/UHF MODE Rotate CCW'), 	down = cmds.VUHF_MODE_INC,			  		  value_down =-1, 							},
	{category = _('Radio'), name = _('V/UHF MODE Rotate CW'),  	down = cmds.VUHF_MODE_INC, 			  		  value_down = 1,  							},
	{category = _('Radio'), name = _('V/UHF Channel Knob Dec'),	down = cmds.VUHF_CH_INC, 			  		  value_down =-1, 							},
	{category = _('Radio'), name = _('V/UHF Channel Knob Inc'),	down = cmds.VUHF_CH_INC, 			  		  value_down = 1,  							},
    {category = _('Radio'), name = _('UHF MODE AR'),			cockpit_device_id = devices.UHF, down = 3433, value_down = 0.0, 						},
    {category = _('Radio'), name = _('UHF MODE M'),				cockpit_device_id = devices.UHF, down = 3433, value_down = 0.25,						},
    {category = _('Radio'), name = _('UHF MODE F1'),			cockpit_device_id = devices.UHF, down = 3433, value_down = 0.50,						},
    {category = _('Radio'), name = _('UHF MODE H'),				cockpit_device_id = devices.UHF, down = 3433, value_down = 0.75,						},
    {category = _('Radio'), name = _('V/UHF MODE OFF'),			cockpit_device_id = devices.VHF, down = 3950, value_down = 0.0, 						},
    {category = _('Radio'), name = _('V/UHF MODE FF'),			cockpit_device_id = devices.VHF, down = 3950, value_down = 0.1, 						},
    {category = _('Radio'), name = _('V/UHF MODE HQ'),			cockpit_device_id = devices.VHF, down = 3950, value_down = 0.2, 						},
    {category = _('Radio'), name = _('V/UHF MODE SV'),			cockpit_device_id = devices.VHF, down = 3950, value_down = 0.3, 						},
    {category = _('Radio'), name = _('V/UHF MODE DL'),			cockpit_device_id = devices.VHF, down = 3950, value_down = 0.4, 						},
    {category = _('Radio'), name = _('V/UHF MODE G'),			cockpit_device_id = devices.VHF, down = 3950, value_down = 0.5, 						},
    {category = _('Radio'), name = _('V/UHF MODE EN'),			cockpit_device_id = devices.VHF, down = 3950, value_down = 0.6, 						},
	{category = _('Radio'), name = _('V/UHF MEM/CLR'),			cockpit_device_id = devices.VHF, down = 3952, up = 3952, value_down = 1, value_up = 0,	},
	{category = _('Radio'), name = _('V/UHF VLD/XFR'),			cockpit_device_id = devices.VHF, down = 3953, up = 3953, value_down = 1, value_up = 0,	},
	{category = _('Radio'), name = _('V/UHF 1/READ'),			cockpit_device_id = devices.VHF, down = 3954, up = 3954, value_down = 1, value_up = 0,	},
	{category = _('Radio'), name = _('V/UHF 2/SQL'),			cockpit_device_id = devices.VHF, down = 3955, up = 3955, value_down = 1, value_up = 0,	},
	{category = _('Radio'), name = _('V/UHF 3/GR'),				cockpit_device_id = devices.VHF, down = 3956, up = 3956, value_down = 1, value_up = 0,	},
	{category = _('Radio'), name = _('V/UHF 4'),				cockpit_device_id = devices.VHF, down = 3957, up = 3957, value_down = 1, value_up = 0,	},
	{category = _('Radio'), name = _('V/UHF 5/20/LOW'),			cockpit_device_id = devices.VHF, down = 3958, up = 3958, value_down = 1, value_up = 0,	},
	{category = _('Radio'), name = _('V/UHF 6/TONE'),			cockpit_device_id = devices.VHF, down = 3959, up = 3959, value_down = 1, value_up = 0,	},
	{category = _('Radio'), name = _('V/UHF 7'),				cockpit_device_id = devices.VHF, down = 3960, up = 3960, value_down = 1, value_up = 0,	},
	{category = _('Radio'), name = _('V/UHF 8/TOD'),			cockpit_device_id = devices.VHF, down = 3961, up = 3961, value_down = 1, value_up = 0,	},
	{category = _('Radio'), name = _('V/UHF 9/ZERO'),			cockpit_device_id = devices.VHF, down = 3962, up = 3962, value_down = 1, value_up = 0,	},
	{category = _('Radio'), name = _('V/UHF 0'),				cockpit_device_id = devices.VHF, down = 3963, up = 3963, value_down = 1, value_up = 0,	},
	{category = _('Radio'), name = _('V/UHF CONF'),				cockpit_device_id = devices.VHF, down = 3964, up = 3964, value_down = 1, value_up = 0,	},  
    {category = _('Radio'), name = _('TAF Channel Inc'),		cockpit_device_id = devices.TAF, down = 3968, 			 value_down = 0.05, 			},
    {category = _('Radio'), name = _('TAF Channel Dec'),		cockpit_device_id = devices.TAF, down = 3968, 			 value_down = -0.05,			},
	
	{category = {_('Radio'), _('VOIP'), _('HOTAS')}, name = _('V/UHF GREEN Radio VOIP PTT'),	down = iCommandVoIPRadioPushToTalkEnableDisableVoice,	up = iCommandVoIPRadioPushToTalkEnableDisableVoice,		value_down = 1, value_up = 0, },
	{category = {_('Radio'), _('VOIP'), _('HOTAS')}, name = _('UHF RED Radio VOIP PTT'),		down = iCommandVoIPRadioPushToTalkEnableDisableVoice_1,	up = iCommandVoIPRadioPushToTalkEnableDisableVoice_1,	value_down = 1, value_up = 0, },
	
	-- Engine & Fuel
	{category = _('Engine & Fuel'), name = _('Engines START'),								down = iCommandLeftEngineStart, up = iCommandLeftEngineStart,	value_down = 1, 	value_up = 0	},
	{category = _('Engine & Fuel'), name = _('Engines STOP'),								down = iCommandLeftEngineStop,  												},
	{category = _('Engine & Fuel'), name = _('Fuel Dump START'),							down = iCommandPlaneFuelOn, up   = iCommandPlaneFuelOff,    					},
	{category = _('Engine & Fuel'), name = _('Throttle Cutoff Unlock'), 					down = 3467, up = 3467, cockpit_device_id = 7, value_down = 1, 	value_up = 0	},
	{category = _('Engine & Fuel'), name = _('Left Fuel Boost Pump ON'), 					down = 3647, up = 3647, cockpit_device_id = 4, value_down = 1,   				},
	{category = _('Engine & Fuel'), name = _('Left Fuel Boost Pump OFF'),					down = 3647, up = 3647, cockpit_device_id = 4, value_down = 0,   				},
	{category = _('Engine & Fuel'), name = _('Right Fuel Boost Pump ON'),					down = 3648, up = 3648, cockpit_device_id = 4, value_down = 1,   				},
	{category = _('Engine & Fuel'), name = _('Right Fuel Boost Pump OFF'),					down = 3648, up = 3648, cockpit_device_id = 4, value_down = 0,   				},
	{category = _('Engine & Fuel'), name = _('Emergency Throttle Cover'),					down = 3464, up = 3464, cockpit_device_id = 7, value_down = 1,	value_up = 0,	},
	{category = _('Engine & Fuel'), name = _('Emergency Throttle Increase'),				down = 3465, up = 3465, cockpit_device_id = 7, value_down = 1,	value_up = 0,	},
    {category = _('Engine & Fuel'), name = _('Emergency Throttle Decrease'),				down = 3465, up = 3465, cockpit_device_id = 7, value_down =-1,	value_up = 0,	},
    {category = _('Engine & Fuel'), name = _('Fuel Emergency Cutoff Cover CLOSE'), 			down = 3651, up = 3651, cockpit_device_id = 7, value_down = 0,   				},
    {category = _('Engine & Fuel'), name = _('Fuel Emergency Cutoff Cover OPEN'),			down = 3651, up = 3651, cockpit_device_id = 7, value_down = 1,   				},
    {category = _('Engine & Fuel'), name = _('Fuel Emergency Cutoff Cover OPEN else CLOSE'),down = 3651, up = 3651, cockpit_device_id = 7, value_down = 1,	value_up = 0,	},
    {category = _('Engine & Fuel'), name = _('Fuel Emergency Cutoff Switch ON'),			down = 3652, up = 3652, cockpit_device_id = 7, value_down = 0,   				},
    {category = _('Engine & Fuel'), name = _('Fuel Emergency Cutoff Switch OFF'),			down = 3652, up = 3652, cockpit_device_id = 7, value_down = 1,   				},
    {category = _('Engine & Fuel'), name = _('Fuel Emergency Cutoff Switch ON else OFF'),	down = 3652, up = 3652, cockpit_device_id = 7, value_down = 1,	value_up = 0,	},
	{category = _('Engine & Fuel'), name = _('Start Button Safety Cover CLOSED'),			down = 3645, up = 3645, cockpit_device_id = 7, value_down = 0,   				},
	{category = _('Engine & Fuel'), name = _('Start Button Safety Cover OPEN'), 			down = 3645, up = 3645, cockpit_device_id = 7, value_down = 1,   				},
	{category = _('Engine & Fuel'), name = _('Start Button Safety Cover OPEN else CLOSED'), down = 3645, up = 3645, cockpit_device_id = 7, value_down = 1,	value_up = 0,	},
	{category = _('Engine & Fuel'), name = _('Starter Fuel Pump ON'),						down = 3646, up = 3646, cockpit_device_id = 7, value_down = 1,   				},
	{category = _('Engine & Fuel'), name = _('Starter Fuel Pump OFF'),						down = 3646, up = 3646, cockpit_device_id = 7, value_down = 0,   				},
	{category = _('Engine & Fuel'), name = _('Starter Fuel Pump ON else OFF'),				down = 3646, up = 3646, cockpit_device_id = 7, value_down = 1,	value_up = 0,	},
	{category = _('Engine & Fuel'), name = _('Ignition Selector Switch RIGHT'),				down = 3650, up = 3650, cockpit_device_id = 7, value_down = 1,   				},
	{category = _('Engine & Fuel'), name = _('Ignition Selector Switch LEFT'),				down = 3650, up = 3650, cockpit_device_id = 7, value_down = 0,	 				},
	{category = _('Engine & Fuel'), name = _('Ignition Selector Switch OFF'),				down = 3650, up = 3650, cockpit_device_id = 7, value_down = -1,   				},
	{category = _('Engine & Fuel'), name = _('Ignition Selector Switch RIGHT else LEFT'),	down = 3650, up = 3650, cockpit_device_id = 7, value_down = 1,	value_up = 0,	},
	{category = _('Engine & Fuel'), name = _('Ignition Selector Switch OFF else LEFT'),		down = 3650, up = 3650, cockpit_device_id = 7, value_down = -1,	value_up = 0,	},
	{category = _('Engine & Fuel'), name = _('In-Flight Start Switch OFF'),					down = 3468, up = 3468, cockpit_device_id = 7, value_down = 0,   				},
	{category = _('Engine & Fuel'), name = _('In-Flight Start Switch ON'),					down = 3468, up = 3468, cockpit_device_id = 7, value_down = 1,   				},
    {category = _('Engine & Fuel'), name = _('Air Refuel Transfer Switch OFF '),			down = 3193, up = 3193, cockpit_device_id = 7, value_down = 0,   				},
	{category = _('Engine & Fuel'), name = _('Air Refuel Transfer Switch ON (DAY)'),		down = 3193, up = 3193, cockpit_device_id = 7, value_down = 0.5, 				},
    {category = _('Engine & Fuel'), name = _('Air Refuel Transfer Switch ON (NIGHT)'),		down = 3193, up = 3193, cockpit_device_id = 7, value_down = 1,   				},
	{category = _('Engine & Fuel'), name = _('Air Refuel Transfer Switch OFF else DAY'),	down = 3193, up = 3193, cockpit_device_id = 7, value_down = 0,	value_up = 0.5,	},
	{category = _('Engine & Fuel'), name = _('Air Refuel Transfer Switch NIGHT else DAY'),	down = 3193, up = 3193, cockpit_device_id = 7, value_down = 1,	value_up = 0.5,	},
    {category = _('Engine & Fuel'), name = _('Afterburner Cutoff Switch Cover CLOSE'),		down = 3471, up = 3471, cockpit_device_id = 4, value_down = 0,   				},
    {category = _('Engine & Fuel'), name = _('Afterburner Cutoff Switch Cover OPEN'),		down = 3471, up = 3471, cockpit_device_id = 4, value_down = 1,   				},
    {category = _('Engine & Fuel'), name = _('Afterburner Cutoff Switch OFF'),				down = 3472, up = 3472, cockpit_device_id = 4, value_down = 0,   				},
    {category = _('Engine & Fuel'), name = _('Afterburner Cutoff Switch ON'),				down = 3472, up = 3472, cockpit_device_id = 4, value_down = 1,   				},
	{category = _('Engine & Fuel'), name = _('BINGO Fuel 1000kg Inc'),						down = cmds.BINGO_THOUSANDS_INC, 			   value_down = 1, 					},
	{category = _('Engine & Fuel'), name = _('BINGO Fuel 1000kg Dec'),						down = cmds.BINGO_THOUSANDS_INC, 			   value_down =-1,					},
	{category = _('Engine & Fuel'), name = _('BINGO Fuel 100kg Inc'),						down = cmds.BINGO_HUNDREDS_INC, 			   value_down = 1,					},
	{category = _('Engine & Fuel'), name = _('BINGO Fuel 100kg Dec'),						down = cmds.BINGO_HUNDREDS_INC, 			   value_down =-1,					},
	{category = _('Engine & Fuel'), name = _('BINGO Fuel Combo Inc'), 						down = cmds.BINGO_COMBO_INC, 				   value_down = 1,					},
	{category = _('Engine & Fuel'), name = _('BINGO Fuel Combo Dec'), 						down = cmds.BINGO_COMBO_INC, 				   value_down =-1,					},
    {category = _('Engine & Fuel'), name = _('Left Fuel Boost Pump ON, else OFF'),			down = 3647, up = 3647, cockpit_device_id = 4, value_down = 1, value_up = 0,	},
    {category = _('Engine & Fuel'), name = _('Right Fuel Boost Pump ON, else OFF'),			down = 3648, up = 3648, cockpit_device_id = 4, value_down = 1, value_up = 0,	},
    {category = _('Engine & Fuel'), name = _('Fuel Detot Increase'),						down = 3355, up = 3355, cockpit_device_id = 4, value_down = 1, value_up = 0,	},
    {category = _('Engine & Fuel'), name = _('Fuel Detot Decrease'),						down = 3355, up = 3355, cockpit_device_id = 4, value_down =-1, value_up = 0,	},
	{category = _('Engine & Fuel'), name = _('CALC SEC Switch Rearm'),                      down = 3476, up = 3476, cockpit_device_id = 7, value_down = 0, value_up = 0.5,  },


	-- Flight Control
	{category = _('Flight Control'), name = _('Aircraft Pitch DOWN'), 				pressed = iCommandPlaneUpStart,    up = iCommandPlaneUpStop,    							},
	{category = _('Flight Control'), name = _('Aircraft Pitch UP'),   				pressed = iCommandPlaneDownStart,  up = iCommandPlaneDownStop,  							},
	{category = _('Flight Control'), name = _('Aircraft Bank LEFT'),  				pressed = iCommandPlaneLeftStart,  up = iCommandPlaneLeftStop,  							},
	{category = _('Flight Control'), name = _('Aircraft Bank RIGHT'), 				pressed = iCommandPlaneRightStart, up = iCommandPlaneRightStop, 							},
	{category = _('Flight Control'), name = _('Aircraft Rudder LEFT'),  			pressed = iCommandPlaneLeftRudderStart,  up = iCommandPlaneLeftRudderStop,  				},
	{category = _('Flight Control'), name = _('Aircraft Rudder RIGHT'), 			pressed = iCommandPlaneRightRudderStart, up = iCommandPlaneRightRudderStop, 				},
	{category = _('Flight Control'), name = _('Throttle UP'),   					pressed = iCommandThrottleIncrease, up = iCommandThrottleStop,  							},
	{category = _('Flight Control'), name = _('Throttle DOWN'), 					pressed = iCommandThrottleDecrease, up = iCommandThrottleStop,  							},
	{category = _('Flight Control'), name = _('Trim RUDDER LEFT'),  				pressed = iCommandPlaneTrimLeftRudder,  up = iCommandPlaneTrimStop, 						},
	{category = _('Flight Control'), name = _('Trim RUDDER RIGHT'), 				pressed = iCommandPlaneTrimRightRudder, up = iCommandPlaneTrimStop, 						},
	{category = _('Flight Control'), name = _('FBW G-Limiter Mode TOGGLE'), 		down = iCommandPlaneCobra,             														},
	{category = _('Flight Control'), name = _('FBW Spin Switch TOGGLE'),    		down = iCommandPlaneEmerFlightControl, 														},
    {category = _('Flight Control'), name = _('Drag Chute DEPLOY'),         		down = iCommandPlaneParachute,  															},
	{category = _('Flight Control'), name = _('Slats RETRACT'), 					down = 3462, up = 3462, cockpit_device_id = 14, value_down = -1, 							},
	{category = _('Flight Control'), name = _('Slats AUTO'),    					down = 3462, up = 3462, cockpit_device_id = 14, value_down = 0,  							},
	{category = _('Flight Control'), name = _('Slats EXTEND'),  					down = 3462, up = 3462, cockpit_device_id = 14, value_down = 1,  							},
	{category = _('Flight Control'), name = _('FBW Gain Cover CLOSED'), 			down = 3420, up = 3420, cockpit_device_id = 3, value_down = 0,   							},
	{category = _('Flight Control'), name = _('FBW Gain Cover OPEN'),   			down = 3420, up = 3420, cockpit_device_id = 3, value_down = 1,   							},
	{category = _('Flight Control'), name = _('FBW Gain NORM'),         			down = 3421, up = 3421, cockpit_device_id = 3, value_down = 0,   							},
	{category = _('Flight Control'), name = _('FBW Gain EMER'),         			down = 3421, up = 3421, cockpit_device_id = 3, value_down = 1,   							},
	{category = _('Flight Control'), name = _('FBW Channel 5 Cover CLOSED'), 		down = 3479, up = 3479, cockpit_device_id = 17, value_down = 0,   							},
	{category = _('Flight Control'), name = _('FBW Channel 5 Cover OPEN'),   		down = 3479, up = 3479, cockpit_device_id = 17, value_down = 1,   							},
	{category = _('Flight Control'), name = _('FBW Channel 5 DISABLE'),        		down = 3480, up = 3480, cockpit_device_id = 17, value_down = 0,   							},
	{category = _('Flight Control'), name = _('FBW Channel 5 ENABLE'),       		down = 3480, up = 3480, cockpit_device_id = 17, value_down = 1,   							},
	{category = _('Flight Control'), name = _('FBW RESET'),        					down = 3423, 			cockpit_device_id = 17, value_down = 1,   							},
	{category = _('Flight Control'), name = _('Slats RETRACT, else AUTO'),			down = 3462, up = 3462, cockpit_device_id = 14,	value_down = -1, value_up = 0,				},
	{category = _('Flight Control'), name = _('Slats EXTEND, else AUTO'),			down = 3462, up = 3462, cockpit_device_id = 14,	value_down = 1, value_up = 0,				},
	{category = _('Flight Control'), name = _('FBW G-Limiter AA else CHARGES'),		down = 3422, up = 3422, cockpit_device_id = devices.ENGINE,	value_down = 0,	value_up = 1,	},
	{category = _('Flight Control'), name = _('FBW Gain NORM, else EMER'),			down = 3421, up = 3421, cockpit_device_id = 3, value_down = 0, value_up = 1,				},
    {category = _('Flight Control'), name = _('FBW Spin Switch NORM, else SPIN'),	down = 3330, up = 3330, cockpit_device_id = 3, value_down = 0, value_up = 1,				},
	
	-- External Lights
	{category = _('External Lights'), name = _('Landing Lights TOGGLE'),       	down = iCommandPlaneHeadLightOnOff,       							},
	{category = _('External Lights'), name = _('Formation Lights TOGGLE'),     	down = iCommandPlaneFormationLights,      							},
	{category = _('External Lights'), name = _('Navigation Lights TOGGLE'),    	down = iCommandPlaneLightsOnOff,          							},
	{category = _('External Lights'), name = _('Anti-Collision Lights TOGGLE'),	down = iCommandPlaneAntiCollisionLights,  							},
	{category = _('External Lights'), name = _('Police Lights Disabled'), 		down = 3449, up = 3449, cockpit_device_id = 16, value_down = 0, 	},
	{category = _('External Lights'), name = _('Police Lights Enabled'),  		down = 3449, up = 3449, cockpit_device_id = 16, value_down = 1, 	},
	{category = _('External Lights'), name = _('Landing Lights OFF'),     		down = 3450, up = 3450, cockpit_device_id = 16, value_down = 0.0, 	},
	{category = _('External Lights'), name = _('Landing Lights TAXI'),    		down = 3450, up = 3450, cockpit_device_id = 16, value_down = 0.5, 	},
	{category = _('External Lights'), name = _('Landing Lights LANDING'), 		down = 3450, up = 3450, cockpit_device_id = 16, value_down = 1.0, 	},
	{category = _('External Lights'), name = _('Refuel Lights Disabled'), 		down = 3452, up = 3452, cockpit_device_id = 16, value_down = 0.0, 	},
	{category = _('External Lights'), name = _('Refuel Lights Enabled'),  		down = 3452, up = 3452, cockpit_device_id = 16, value_down = 1.0, 	},
	{category = _('External Lights'), name = _('Anti-Collision Lights OFF'),   	down = 3453, up = 3453, cockpit_device_id = 16, value_down = 0.0, 	},
    {category = _('External Lights'), name = _('Anti-Collision Lights DIM'),   	down = 3453, up = 3453, cockpit_device_id = 16, value_down = 0.5, 	},
	{category = _('External Lights'), name = _('Anti-Collision Lights BRIGHT'),	down = 3453, up = 3453, cockpit_device_id = 16, value_down = 1.0, 	},
	{category = _('External Lights'), name = _('Navigation Lights OFF'),    	down = 3454, up = 3454, cockpit_device_id = 16, value_down = 0.0, 	},
    {category = _('External Lights'), name = _('Navigation Lights DIM'),    	down = 3454, up = 3454, cockpit_device_id = 16, value_down = 0.5, 	},
	{category = _('External Lights'), name = _('Navigation Lights BRIGHT'), 	down = 3454, up = 3454, cockpit_device_id = 16, value_down = 1.0, 	},
	{category = _('External Lights'), name = _('Formation Lights OFF'),     	down = 3455, up = 3455, cockpit_device_id = 16, value_down = 0.0, 	},
    {category = _('External Lights'), name = _('Formation Lights DIM'),     	down = 3455, up = 3455, cockpit_device_id = 16, value_down = 0.5, 	},
	{category = _('External Lights'), name = _('Formation Lights BRIGHT'),  	down = 3455, up = 3455, cockpit_device_id = 16, value_down = 1.0, 	},
	
	--Radar
	{category = _('RDI Radar'), name = _('Radar Gain DECREASE'),				down = cmds.RadarGain_INC,		up = cmds.RadarGain_INC,	value_down =-1,	value_up = 0,	},
	{category = _('RDI Radar'), name = _('Radar Gain INCREASE'),				down = cmds.RadarGain_INC,		up = cmds.RadarGain_INC,	value_down = 1,	value_up = 0,	},
	
	{category = _('RDI Radar'), name = _('Radar Range DECREASE'),				down = cmds.RadarRange_INC, 	value_down =-1,												},
	{category = _('RDI Radar'), name = _('Radar Range INCREASE'),				down = cmds.RadarRange_INC, 	value_down = 1,												},
	{category = _('RDI Radar'), name = _('Radar Power CCW'),					down = cmds.RadarPower_INC, 	value_down =-1, 											},
	{category = _('RDI Radar'), name = _('Radar Power CW'),						down = cmds.RadarPower_INC, 	value_down = 1, 											},
	{category = _('RDI Radar'), name = _('PRF Selector Toggle'),				down = cmds.PRF_INC, 			value_down = 0,												},
-----<<<<<mod begin>>>>>
	{category = _('RDI Radar'), name = _('PRF Selector Up'),					down = cmds.PRF_INC, 			value_down = 0,
								},
-----<<<<<mod end>>>>>
	{category = _('RDI Radar'), name = _('PRF Selector Down'),					down = cmds.PRF_INC, 			value_down =-1,												},
	{category = _('RDI Radar'), name = _('Doppler Reject Toggle'),				down = cmds.DoppRej_INC, 		value_down = 0,
							},
	{category = _('RDI Radar'), name = _('Doppler Reject Up'),				down = cmds.DoppRej_INC, 		value_down = 1,
							},
	{category = _('RDI Radar'), name = _('Doppler Reject Down'),				down = cmds.DoppRej_INC, 		value_down =-1,
							},
	{category = _('RDI Radar'), name = _('Radar Scan Line Toggle'),				down = cmds.RadarLines_INC, 	value_down = 0,												},
	{category = _('RDI Radar'), name = _('Radar Scan Line Increase'),			down = cmds.RadarLines_INC, 	value_down = 1,												},
	{category = _('RDI Radar'), name = _('Radar Scan Line Decrease'),			down = cmds.RadarLines_INC, 	value_down =-1,												},
	{category = _('RDI Radar'), name = _('Radar Azimuth Toggle'),				down = cmds.RadarAzRange_INC, 	value_down = 0,												},
	{category = _('RDI Radar'), name = _('Radar Azimuth Wider'),				down = cmds.RadarAzRange_INC, 	value_down = 1,												},
	{category = _('RDI Radar'), name = _('Radar Azimuth Narrower'),				down = cmds.RadarAzRange_INC, 	value_down =-1,												},
	{category = _('RDI Radar'), name = _('PRF Selector BFR'),					cockpit_device_id = 11,	down = 3109,	value_down =-1,		 								},
	{category = _('RDI Radar'), name = _('PRF Selector ENT'),					cockpit_device_id = 11,	down = 3109,	value_down = 0,
		},
-----<<<<<mod begin>>>>>
	{category = _('RDI Radar'), name = _('PRF Selector HFR'),					cockpit_device_id = 11,	down = 3109,	value_down = 0,
		 },
-----<<<<<mod end>>>>>
	{category = _('RDI Radar'), name = _('PRF Selector BFR, else ENT'),			cockpit_device_id = 11,	down = 3109,	value_down = -1,	 up = 3109, value_up = 0,		},
-----<<<<<mod begin>>>>>
	{category = _('RDI Radar'), name = _('PRF Selector HFR, else ENT'),			cockpit_device_id = 11,	down = 3109,	value_down = 0,		 up = 3109, value_up = 0,		},
-----<<<<<mod end>>>>>
	{category = _('RDI Radar'), name = _('Radar Azimuth 60'),					cockpit_device_id = 11,	down = 3506,	value_down = 0.0,	 								},
	{category = _('RDI Radar'), name = _('Radar Azimuth 30'),					cockpit_device_id = 11,	down = 3506,	value_down = 0.5,	 								},
	{category = _('RDI Radar'), name = _('Radar Azimuth 15'),					cockpit_device_id = 11,	down = 3506,	value_down = 1.0,	 								},
	{category = _('RDI Radar'), name = _('Radar Azimuth 60, else 30'),			cockpit_device_id = 11,	down = 3506,	value_down = 0,		up = 3506,	value_up = 0.5,		},
	{category = _('RDI Radar'), name = _('Radar Azimuth 15, else 30'),			cockpit_device_id = 11,	down = 3506,	value_down = 1,		up = 3506,	value_up = 0.5,		},
	{category = _('RDI Radar'), name = _('Radar Scan Line 4'),					cockpit_device_id = 11,	down = 3502,	value_down = 0.0,	 								},
	{category = _('RDI Radar'), name = _('Radar Scan Line 2'),					cockpit_device_id = 11,	down = 3502,	value_down = 0.5,	 								},
	{category = _('RDI Radar'), name = _('Radar Scan Line 1'),					cockpit_device_id = 11,	down = 3502,	value_down = 1.0,	 								},
	{category = _('RDI Radar'), name = _('Radar Scan Line 4, else 2'),			cockpit_device_id = 11,	down = 3502,	value_down = 0,		up = 3502,	value_up = 0.5,		},
	{category = _('RDI Radar'), name = _('Radar Scan Line 1, else 2'),			cockpit_device_id = 11,	down = 3502,	value_down = 1,		up = 3502,	value_up = 0.5,		},
	{category = _('RDI Radar'), name = _('Radar Power A Off'),					cockpit_device_id = 11,	down = 3486, 	value_down = 0.0,									},
	{category = _('RDI Radar'), name = _('Radar Power PCH Warm-up'), 			cockpit_device_id = 11,	down = 3486, 	value_down = .33,									},
	{category = _('RDI Radar'), name = _('Radar Power SIL Standby'), 			cockpit_device_id = 11,	down = 3486, 	value_down = .67,									},
	{category = _('RDI Radar'), name = _('Radar Power EM On'),					cockpit_device_id = 11,	down = 3486, 	value_down = 1.0,									},
	{category = _('RDI Radar'), name = _('Radar PPI Mode'), 					cockpit_device_id = 11,	down = 3499, 	value_down = 0.0,									},
	{category = _('RDI Radar'), name = _('Radar B-Scope Mode'), 				cockpit_device_id = 11,	down = 3499, 	value_down = 1.0,									},
	{category = _('RDI Radar'), name = _('TDC Mode Switch S'),					cockpit_device_id = 11,	down = 3710, 	value_down = 0.0,									},
-----<<<<<mod begin>>>>>
	{category = _('RDI Radar'), name = _('TDC Mode Switch Z'),					cockpit_device_id = 11,	down = 3710, 	value_down = 0.0,									},
-----<<<<<mod end>>>>>
	{category = _('RDI Radar'), name = _('Remanence N (Off)'),					cockpit_device_id = 11,	down = 3500, 	value_down = 0.0,									},
	{category = _('RDI Radar'), name = _('Remanence R (On)'),					cockpit_device_id = 11,	down = 3500, 	value_down = 1.0,									},
	{category = _('RDI Radar'), name = _('Doppler Reject OFF'),					cockpit_device_id = 11,	down = 3484,	value_down = -1,									},
	{category = _('RDI Radar'), name = _('Doppler Reject AUTO'),				cockpit_device_id = 11,	down = 3484,	value_down = 0,										},
	{category = _('RDI Radar'), name = _('Doppler Reject ON'),					cockpit_device_id = 11,	down = 3484,	value_down = 1,										},
	{category = _('RDI Radar'), name = _('Doppler Reject OFF, else AUTO'),		cockpit_device_id = 11,	down = 3484,	value_down = -1,	up = 3484,	value_up = 0,		},
	{category = _('RDI Radar'), name = _('Doppler Reject ON, else AUTO'),		cockpit_device_id = 11,	down = 3484,	value_down = 1,		up = 3484,	value_up = 0,		},
	{category = _('RDI Radar'), name = _('Radar PPI Mode, else B-Scope Mode'),	cockpit_device_id = 11,	down = 3499,	value_down = 0,		up = 3499,	value_up = 1,		},
    {category = _('RDI Radar'), name = _('Radar ON, else STANDBY'),				cockpit_device_id = 11,	down = 3486,	value_up = 0.67,	up = 3486,	value_down = 1,		},
    {category = _('RDI Radar'), name = _('Radar WARM UP, else OFF'),			cockpit_device_id = 11,	down = 3486,	value_up = 0,		up = 3486,	value_down = 0.33,	},
-----<<<<<mod begin>>>>>
	{category = _('RDI Radar'), name = _('TDC Mode S, else Z'),					cockpit_device_id = 11,	down = 3710,	value_down = 0,		up = 3710,	value_up = 0.1,		},
-----<<<<<mod end>>>>>
	{category = _('RDI Radar'), name = _('A Switch'),							cockpit_device_id = 11,	down = 3491,	value_down = 1,		up = 3491,	value_up = 0,		},
	{category = _('RDI Radar'), name = _('DEC Switch'),							cockpit_device_id = 11,	down = 3493,	value_down = 1,		up = 3493,	value_up = 0,		},
	{category = _('RDI Radar'), name = _('VISU Switch'),						cockpit_device_id = 11,	down = 3495,	value_down = 1,		up = 3495,	value_up = 0,		},
	{category = _('RDI Radar'), name = _('PSIC Switch'),						cockpit_device_id = 11,	down = 3504,	value_down = 1,		up = 3504,	value_up = 0,		},

	-- IFF interrogator
	{category = _('IFF Interrogator'), name = _('IFF Mode 1'),				down = 3598, up = 3598, cockpit_device_id = devices.PCR, value_down = 0.0, 	},
	{category = _('IFF Interrogator'), name = _('IFF Mode 4'),				down = 3598, up = 3598, cockpit_device_id = devices.PCR, value_down = 0.2, 	},
	{category = _('IFF Interrogator'), name = _('IFF Mode 3/2'),			down = 3598, up = 3598, cockpit_device_id = devices.PCR, value_down = 0.4, 	},
	{category = _('IFF Interrogator'), name = _('IFF Mode 3/3'),			down = 3598, up = 3598, cockpit_device_id = devices.PCR, value_down = 0.6, 	},
	{category = _('IFF Interrogator'), name = _('IFF Mode 3/4'),			down = 3598, up = 3598, cockpit_device_id = devices.PCR, value_down = 0.8, 	},
	{category = _('IFF Interrogator'), name = _('IFF Mode 2'),				down = 3598, up = 3598, cockpit_device_id = devices.PCR, value_down = 1.0, 	},
	{category = _('IFF Interrogator'), name = _('IFF L Selector'),			down = 3599, up = 3599, cockpit_device_id = devices.PCR, value_down = 0.0, 	},
	{category = _('IFF Interrogator'), name = _('IFF R Selector'),			down = 3599, up = 3599, cockpit_device_id = devices.PCR, value_down = 1.0, 	},
	{category = _('IFF Interrogator'), name = _('IFF OFF'),					down = 3600, up = 3600, cockpit_device_id = devices.PCR, value_down = 0.0, 	},
	{category = _('IFF Interrogator'), name = _('IFF SECTOR'),				down = 3600, up = 3600, cockpit_device_id = devices.PCR, value_down = 0.5, 	},
	{category = _('IFF Interrogator'), name = _('IFF CONT'),				down = 3600, up = 3600, cockpit_device_id = devices.PCR, value_down = 1.0, 	},
	{category = _('IFF Interrogator'), name = _('IFF Digits 0001 INCR'), 	down = cmds.IFF_INT_Code_0001_INC,	value_down = 1,  						},
	{category = _('IFF Interrogator'), name = _('IFF Digits 0001 DECR'), 	down = cmds.IFF_INT_Code_0001_INC,	value_down =-1, 						},
	{category = _('IFF Interrogator'), name = _('IFF Digits 0010 INCR'), 	down = cmds.IFF_INT_Code_0010_INC,	value_down = 1,  						},
	{category = _('IFF Interrogator'), name = _('IFF Digits 0010 DECR'), 	down = cmds.IFF_INT_Code_0010_INC,	value_down =-1, 						},
	{category = _('IFF Interrogator'), name = _('IFF Digits 0100 INCR'), 	down = cmds.IFF_INT_Code_0100_INC,	value_down = 1,  						},
	{category = _('IFF Interrogator'), name = _('IFF Digits 0100 DECR'), 	down = cmds.IFF_INT_Code_0100_INC,	value_down =-1, 						},
	{category = _('IFF Interrogator'), name = _('IFF Digits 1000 INCR'), 	down = cmds.IFF_INT_Code_1000_INC,	value_down = 1,  						},
	{category = _('IFF Interrogator'), name = _('IFF Digits 1000 DECR'), 	down = cmds.IFF_INT_Code_1000_INC,	value_down =-1, 						},
	
	
	-- IFF transponder
	{category = _('IFF Responder'), name = _('IFF Mode 4 HOLD'),			down = 3389, up = 3389, cockpit_device_id = devices.IFF, value_down = 0.00, value_up = 0.25 },
	{category = _('IFF Responder'), name = _('IFF Mode 4 A'),				down = 3389, 			cockpit_device_id = devices.IFF, value_down = 0.25, 				},
	{category = _('IFF Responder'), name = _('IFF Mode 4 B'),				down = 3389, 			cockpit_device_id = devices.IFF, value_down = 0.50, 				},
	{category = _('IFF Responder'), name = _('IFF Mode 4 ZERO'),			down = 3389, 			cockpit_device_id = devices.IFF, value_down = 0.75, 				},
	{category = _('IFF Responder'), name = _('IFF Master OFF'),				down = 3392, 			cockpit_device_id = devices.IFF, value_down = 0.00, 				},
	{category = _('IFF Responder'), name = _('IFF Master SBY'),				down = 3392, 			cockpit_device_id = devices.IFF, value_down = 0.25, 				},
	{category = _('IFF Responder'), name = _('IFF Master N'),				down = 3392, 			cockpit_device_id = devices.IFF, value_down = 0.50, 				},
	{category = _('IFF Responder'), name = _('IFF Master EMERG'),			down = 3392, 			cockpit_device_id = devices.IFF, value_down = 0.75, 				},
	{category = _('IFF Responder'), name = _('IFF Ident/Mic IDENT'),		down = 3383, up = 3383, cockpit_device_id = devices.IFF, value_down = 1.0,  value_up = 0.0 	},
	{category = _('IFF Responder'), name = _('IFF Ident/Mic OUT'),			down = 3383, 			cockpit_device_id = devices.IFF, value_down = 0.0, 					},
	{category = _('IFF Responder'), name = _('IFF Ident/Mic MIC'),			down = 3383, 			cockpit_device_id = devices.IFF, value_down =-1.0, 					},
	{category = _('IFF Responder'), name = _('IFF Mode 1 OFF'),				down = 3384, 			cockpit_device_id = devices.IFF, value_down = 0.0, 					},
	{category = _('IFF Responder'), name = _('IFF Mode 1 ON'),				down = 3384, 			cockpit_device_id = devices.IFF, value_down = 1.0, 					},
	{category = _('IFF Responder'), name = _('IFF Mode 2 OFF'),				down = 3385, 			cockpit_device_id = devices.IFF, value_down = 0.0, 					},
	{category = _('IFF Responder'), name = _('IFF Mode 2 ON'),				down = 3385, 			cockpit_device_id = devices.IFF, value_down = 1.0, 					},
	{category = _('IFF Responder'), name = _('IFF Mode 3 OFF'),				down = 3386, 			cockpit_device_id = devices.IFF, value_down = 0.0, 					},
	{category = _('IFF Responder'), name = _('IFF Mode 3 ON'),				down = 3386, 			cockpit_device_id = devices.IFF, value_down = 1.0, 					},
	{category = _('IFF Responder'), name = _('IFF Mode C OFF'),				down = 3387, 			cockpit_device_id = devices.IFF, value_down = 0.0, 					},
	{category = _('IFF Responder'), name = _('IFF Mode C ON'),				down = 3387, 			cockpit_device_id = devices.IFF, value_down = 1.0, 					},
	{category = _('IFF Responder'), name = _('IFF Mode 4 OFF'),				down = 3390, 			cockpit_device_id = devices.IFF, value_down = 0.0, 					},
	{category = _('IFF Responder'), name = _('IFF Mode 4 ON'),				down = 3390, 			cockpit_device_id = devices.IFF, value_down = 1.0, 					},
	{category = _('IFF Responder'), name = _('IFF Mode 4 AUDIO'),			down = 3391,			cockpit_device_id = devices.IFF, value_down = 1.0,					},
	{category = _('IFF Responder'), name = _('IFF Mode 4 OUT'),				down = 3391, 			cockpit_device_id = devices.IFF, value_down = 0.0, 					},
	{category = _('IFF Responder'), name = _('IFF Mode 4 LIGHT'),			down = 3391, 			cockpit_device_id = devices.IFF, value_down =-1.0, 					},
	{category = _('IFF Responder'), name = _('IFF Test'),					down = 3393, up = 3393,	cockpit_device_id = devices.IFF, value_down = 1.0, 	value_up = 0.0	},
	{category = _('IFF Responder'), name = _('IFF Mode 1 01 INCR'), 		down = cmds.IFF_TRN_Mode1_01_INC,		value_down = 1,  									},
	{category = _('IFF Responder'), name = _('IFF Mode 1 01 DECR'), 		down = cmds.IFF_TRN_Mode1_01_INC,		value_down =-1, 									},
	{category = _('IFF Responder'), name = _('IFF Mode 1 10 INCR'), 		down = cmds.IFF_TRN_Mode1_10_INC,		value_down = 1,  									},
	{category = _('IFF Responder'), name = _('IFF Mode 1 10 DECR'), 		down = cmds.IFF_TRN_Mode1_10_INC,		value_down =-1, 									},
	{category = _('IFF Responder'), name = _('IFF Mode 2/3A 0001 INCR'), 	down = cmds.IFF_TRN_Mode23_0001_INC,	value_down = 1,  									},
	{category = _('IFF Responder'), name = _('IFF Mode 2/3A 0001 DECR'), 	down = cmds.IFF_TRN_Mode23_0001_INC,	value_down =-1, 									},
	{category = _('IFF Responder'), name = _('IFF Mode 2/3A 0010 INCR'), 	down = cmds.IFF_TRN_Mode23_0010_INC,	value_down = 1,  									},
	{category = _('IFF Responder'), name = _('IFF Mode 2/3A 0010 DECR'), 	down = cmds.IFF_TRN_Mode23_0010_INC,	value_down =-1, 									},
	{category = _('IFF Responder'), name = _('IFF Mode 2/3A 0100 INCR'), 	down = cmds.IFF_TRN_Mode23_0100_INC,	value_down = 1,  									},
	{category = _('IFF Responder'), name = _('IFF Mode 2/3A 0100 DECR'), 	down = cmds.IFF_TRN_Mode23_0100_INC,	value_down =-1, 									},
	{category = _('IFF Responder'), name = _('IFF Mode 2/3A 1000 INCR'), 	down = cmds.IFF_TRN_Mode23_1000_INC,	value_down = 1,  									},
	{category = _('IFF Responder'), name = _('IFF Mode 2/3A 1000 DECR'), 	down = cmds.IFF_TRN_Mode23_1000_INC,	value_down =-1, 									},
	
	--Countermeasures
	{category = _('Countermeasures'), name = _('Decoy Release Program Knob Up'),	down = iCommandPlaneCMDChangeRippleQuantity,    									},
	{category = _('Countermeasures'), name = _('Decoy Release Program Knob Down'),	down = iCommandPlaneCMDChangeRippleQuantityOff, 									},
	{category = _('Countermeasures'), name = _('RWR Brightness INC'),    			pressed = cmds.RWRBrightness_INC, value_pressed=0.1									}, 
	{category = _('Countermeasures'), name = _('RWR Brightness DEC'),    			pressed = cmds.RWRBrightness_INC, value_pressed=-0.1								},
	{category = _('Countermeasures'), name = _('RWR OFF'),  						down = 3607, up = 3607, cockpit_device_id = 13, value_down = 0,						},
    {category = _('Countermeasures'), name = _('RWR ON'),   						down = 3607, up = 3607, cockpit_device_id = 13, value_down = 0.5,					},
    {category = _('Countermeasures'), name = _('RWR TEST'), 						down = 3607, up = 3607, cockpit_device_id = 13, value_down = 1.0,					},
	{category = _('Countermeasures'), name = _('RWR OFF else ON'),					down = 3607, up = 3607, cockpit_device_id = 13, value_down = 0.0,	value_up = 0.5,	},
	{category = _('Countermeasures'), name = _('RWR TEST else ON'),					down = 3607, up = 3607, cockpit_device_id = 13, value_down = 1.0,	value_up = 0.5,	},
	{category = _('Countermeasures'), name = _('D2M OFF'),  						down = 3608, up = 3608, cockpit_device_id = 13, value_down = 0.0,					},
    {category = _('Countermeasures'), name = _('D2M ON'),   						down = 3608, up = 3608, cockpit_device_id = 13, value_down = 0.5,					},
    {category = _('Countermeasures'), name = _('D2M TEST'), 						down = 3608, up = 3608, cockpit_device_id = 13, value_down = 1.0,					},
	{category = _('Countermeasures'), name = _('D2M OFF else ON'),					down = 3608, up = 3608, cockpit_device_id = 13, value_down = 0.0,	value_up = 0.5,	},
	{category = _('Countermeasures'), name = _('D2M TEST else ON'),					down = 3608, up = 3608, cockpit_device_id = 13, value_down = 1.0,	value_up = 0.5,	},
	{category = _('Countermeasures'), name = _('Decoy Release Mode OFF'),			down = 3609, up = 3609, cockpit_device_id = 13, value_down = 0.0,					},
    {category = _('Countermeasures'), name = _('Decoy Release Mode Semi-Auto'),		down = 3609, up = 3609, cockpit_device_id = 13, value_down = 0.5,					},
    {category = _('Countermeasures'), name = _('Decoy Release Mode Automatic'),		down = 3609, up = 3609, cockpit_device_id = 13, value_down = 1.0,					},
    {category = _('Countermeasures'), name = _('Decoy Release OFF else SA'),		down = 3609, up = 3609, cockpit_device_id = 13, value_down = 0.0,	value_up = 0.5,	},
    {category = _('Countermeasures'), name = _('Decoy Release AUTO else SA'),		down = 3609, up = 3609, cockpit_device_id = 13, value_down = 1.0,	value_up = 0.5,	},
	{category = _('Countermeasures'), name = _('Decoy Release Program OFF'),		down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.0,					},
	{category = _('Countermeasures'), name = _('Decoy Release Program 01'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.1,					},
	{category = _('Countermeasures'), name = _('Decoy Release Program 02'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.2,					},
	{category = _('Countermeasures'), name = _('Decoy Release Program 03'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.3,					},
	{category = _('Countermeasures'), name = _('Decoy Release Program 04'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.4,					},
	{category = _('Countermeasures'), name = _('Decoy Release Program 05'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.5,					},
	{category = _('Countermeasures'), name = _('Decoy Release Program 06'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.6,					},
	{category = _('Countermeasures'), name = _('Decoy Release Program 07'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.7,					},
	{category = _('Countermeasures'), name = _('Decoy Release Program 08'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.8,					},
	{category = _('Countermeasures'), name = _('Decoy Release Program 09'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.9,					},
	{category = _('Countermeasures'), name = _('Decoy Release Program 10'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 1.0,					},
	{category = _('Countermeasures'), name = _('Jammer OFF'),						down = 3606, up = 3606, cockpit_device_id = 13, value_down = 0.0,					},
	{category = _('Countermeasures'), name = _('Jammer ON'),						down = 3606, up = 3606, cockpit_device_id = 13, value_down = 0.5,					},
	{category = _('Countermeasures'), name = _('Jammer TEST'),						down = 3606, up = 3606, cockpit_device_id = 13, value_down = 1.0,					},
	{category = _('Countermeasures'), name = _('Jammer OFF else ON'),				down = 3606, up = 3606, cockpit_device_id = 13, value_down = 0.0,	value_up = 0.5,	},
	{category = _('Countermeasures'), name = _('Jammer TEST else ON'),				down = 3606, up = 3606, cockpit_device_id = 13, value_down = 1.0,	value_up = 0.5,	},
	{category = _('Countermeasures'), name = _('Jammer Mode Veille'),				down = 3605, up = 3605, cockpit_device_id = 13, value_down =-1.0,					},
	{category = _('Countermeasures'), name = _('Jammer Mode []'),					down = 3605, up = 3605, cockpit_device_id = 13, value_down = 0.0,					},
	{category = _('Countermeasures'), name = _('Jammer Mode PCM'),					down = 3605, up = 3605, cockpit_device_id = 13, value_down = 1.0,					},
	
    -- Electrical
	{category = _('Electrical'), name = _('Main Battery TOGGLE'), 			down = iCommandBatteryPower, 													},
    {category = _('Electrical'), name = _('Master Caution RESET'), 			down = 3191, up = 3191, cockpit_device_id = 16,	value_down= 1.0, value_up= 0.0  },
	{category = _('Electrical'), name = _('Main Battery OFF'),				down = 3520, up = 3520, cockpit_device_id = 18, value_down= 0.0, 				},
	{category = _('Electrical'), name = _('Main Battery ON'),				down = 3520, up = 3520, cockpit_device_id = 18, value_down= 1.0, 				},
	{category = _('Electrical'), name = _('Electric Power Transfer OFF'),	down = 3521, up = 3521, cockpit_device_id = 18, value_down= 0.0, 				},
	{category = _('Electrical'), name = _('Electric Power Transfer ON'),	down = 3521, up = 3521, cockpit_device_id = 18, value_down= 1.0, 				},
	{category = _('Electrical'), name = _('Alternator 1 OFF'),				down = 3522, up = 3522, cockpit_device_id = 18, value_down= 0.0, 				},
	{category = _('Electrical'), name = _('Alternator 1 ON'),				down = 3522, up = 3522, cockpit_device_id = 18, value_down= 1.0, 				},
	{category = _('Electrical'), name = _('Alternator 2 OFF'),				down = 3523, up = 3523, cockpit_device_id = 18, value_down= 0.0, 				},
	{category = _('Electrical'), name = _('Alternator 2 ON'),				down = 3523, up = 3523, cockpit_device_id = 18, value_down= 1.0, 				},
	{category = _('Electrical'), name = _('Audio Warning Switch OFF'),		down = 3658, up = 3658, cockpit_device_id = 16, value_down= 0.0, 				},
	{category = _('Electrical'), name = _('Audio Warning Switch ON'),		down = 3658, up = 3658, cockpit_device_id = 16, value_down= 0.5, 				},
	{category = _('Electrical'), name = _('Audio Warning Switch Test?'),	down = 3658, up = 3658, cockpit_device_id = 16, value_down= 1.0, 				},
    {category = _('Electrical'), name = _('Pitot Heat Cover Closed'), 		down = 3659, up = 3659, cockpit_device_id = 22, value_down= 0.0, 				},
    {category = _('Electrical'), name = _('Pitot Heat Cover Opened'), 		down = 3659, up = 3659, cockpit_device_id = 22, value_down= 1.0, 				},
    {category = _('Electrical'), name = _('Pitot Heat Switch OFF'),   		down = 3660, up = 3660, cockpit_device_id = 22, value_down= 1.0, 				},
    {category = _('Electrical'), name = _('Pitot Heat Switch ON'),    		down = 3660, up = 3660, cockpit_device_id = 22, value_down= 0.0, 				},

    -- Interior Lights
	{category = _('Interior Lights'), name = _('Dashboard Flood Lights INC'),    	pressed = cmds.DashFloodLight_INC, value_pressed=0.1							}, 
	{category = _('Interior Lights'), name = _('Dashboard Flood Lights DEC'),    	pressed = cmds.DashFloodLight_INC, value_pressed=-0.1							}, 
	{category = _('Interior Lights'), name = _('Dashboard Panel Lights INC'),    	pressed = cmds.DashPanelLight_INC, value_pressed=0.1							}, 
	{category = _('Interior Lights'), name = _('Dashboard Panel Lights DEC'),    	pressed = cmds.DashPanelLight_INC, value_pressed=-0.1							}, 
	{category = _('Interior Lights'), name = _('Console Flood Lights INC'),    		pressed = cmds.ConsoleFloodLight_INC, value_pressed=0.1							}, 
	{category = _('Interior Lights'), name = _('Console Flood Lights DEC'),    		pressed = cmds.ConsoleFloodLight_INC, value_pressed=-0.1						}, 
	{category = _('Interior Lights'), name = _('Console Panel Lights INC'),    		pressed = cmds.ConsolePanelLight_INC, value_pressed=0.1							}, 
	{category = _('Interior Lights'), name = _('Console Panel Lights DEC'),    		pressed = cmds.ConsolePanelLight_INC, value_pressed=-0.1						}, 
	{category = _('Interior Lights'), name = _('White Flood Lights INC'),    		pressed = cmds.WhiteFloodLight_INC, value_pressed=0.1							}, 
	{category = _('Interior Lights'), name = _('White Flood Lights DEC'),    		pressed = cmds.WhiteFloodLight_INC, value_pressed=-0.1							}, 
	{category = _('Interior Lights'), name = _('Caution Lights INC'),    			pressed = cmds.CautionLight_INC, value_pressed=0.1								}, 
	{category = _('Interior Lights'), name = _('Caution Lights DEC'),    			pressed = cmds.CautionLight_INC, value_pressed=-0.1								},
    {category = _('Interior Lights'), name = _('Warning Lights TEST'), 				down = 3524, up = 3524, cockpit_device_id = 8, value_up= 0, value_down= 1, 		},
	{category = _('Interior Lights'), name = _('NVG Lights Filter ON else OFF'),	down = 3672, up = 3672, cockpit_device_id = 16, value_down = 1, value_up = 0,	},

	
	-- VTH
    {category = _('HUD'), name = _('HUD Brightness UP'), 				pressed = iCommandHUDBrightnessUp,    											},
    {category = _('HUD'), name = _('HUD Brightness DOWN'), 				pressed = iCommandHUDBrightnessDown, 											},
    {category = _('HUD'), name = _('HUD OFF'), 							down = 3201, up = 3201,		cockpit_device_id = devices.VTH, value_down =-1.0,	},
    {category = _('HUD'), name = _('HUD ON'), 							down = 3201, up = 3201,		cockpit_device_id = devices.VTH, value_down = 0.0, 	},
    {category = _('HUD'), name = _('HUD TEST'), 						down = 3201, up = 3201,		cockpit_device_id = devices.VTH, value_down = 1.0, 	},
	{category = _('HUD'), name = _('HUD Declutter'), 					down = 3203, up = 3203,		cockpit_device_id = devices.VTH, value_down = 1.0, 	},
	{category = _('HUD'), name = _('Auxiliary Gunsight OFF'),			down = 3206, up = 3206,		cockpit_device_id = devices.VTH, value_down = 0.0,	},
	{category = _('HUD'), name = _('Auxiliary Gunsight ON'),			down = 3206, up = 3206,		cockpit_device_id = devices.VTH, value_down = 1.0,	},
    {category = _('HUD'), name = _('Auxiliary Gunsight Angle INC'),		down = cmds.AUX_SIGHT_INC,									 value_down = 0.2,	},
    {category = _('HUD'), name = _('Auxiliary Gunsight Angle DEC'),		down = cmds.AUX_SIGHT_INC,									 value_down =-0.2,	},
	
	-- RADAR ALTIMETER
 	{category = _('HUD'), name = _('Radar Altimeter ON, else OFF'),		down = 3205, up = 3205, cockpit_device_id = devices.RS,	value_down = 0.5, value_up = 0,		},
	{category = _('HUD'), name = _('Radar Altimeter ZB'), 				down = 3204, up = 3204, cockpit_device_id = devices.RS, value_down = 0.0, 					},
	{category = _('HUD'), name = _('Radar Altimeter H'), 				down = 3204, up = 3204, cockpit_device_id = devices.RS, value_down = 0.5, 					},
	{category = _('HUD'), name = _('Radar Altimeter SELH'), 			down = 3204, up = 3204, cockpit_device_id = devices.RS, value_down = 1.0, 					},
    {category = _('HUD'), name = _('Radar Altimeter OFF'), 				down = 3205, up = 3205, cockpit_device_id = devices.RS, value_down = 0.0, 					},
    {category = _('HUD'), name = _('Radar Altimeter ON'), 				down = 3205, up = 3205, cockpit_device_id = devices.RS, value_down = 0.5, 					},
    {category = _('HUD'), name = _('Radar Altimeter TEST'), 			down = 3205, up = 3205, cockpit_device_id = devices.RS, value_down = 1.0, 					},
    {category = _('HUD'), name = _('Minimum Altitude INC'), 			down = cmds.SELH_INC,									value_down = 0.2, 					},
    {category = _('HUD'), name = _('Minimum Altitude DEC'), 			down = cmds.SELH_INC,									value_down =-0.2, 					},

	-- VTB
    {category = _('HDD'), name = _('VTB Viewport ON/OFF'), 											down = iCommandPlaneCDU_CLR, 																},
    {category = _('HDD'), name = _('Radar Screen OFF'),												cockpit_device_id = devices.VTB, down = 3221, up = 3221, value_down =  0,    				},
    {category = _('HDD'), name = _('Radar Screen ON'), 												cockpit_device_id = devices.VTB, down = 3221, up = 3221, value_down =  1,    				},
	{category = _('HDD'), name = _('Radar Target Data Manual Entry Begin'),							cockpit_device_id = devices.VTB, down = 3213, up = 3213, value_down =  1,	value_up = 0,	},
	{category = _('HDD'), name = _('Radar Target Data Manual Entry Ends'),							cockpit_device_id = devices.VTB, down = 3213, up = 3213, value_down = -1,	value_up = 0,	},
    {category = _('HDD'), name = _('N Switch (Waypoint Selector Increase)'),						cockpit_device_id = devices.VTB, down = 3214, up = 3214, value_down =  1,	value_up = 0,	},
	{category = _('HDD'), name = _('N Switch (Waypoint Selector Decrease)'),						cockpit_device_id = devices.VTB, down = 3214, up = 3214, value_down = -1,	value_up = 0,	},
    {category = _('HDD'), name = _('Rho Switch Up (Target Range from Bullseye Increase)'),			cockpit_device_id = devices.VTB, down = 3215, up = 3215, value_down =  1,	value_up = 0,	},
	{category = _('HDD'), name = _('Rho Switch Down (Target Range from Bullseye Decrease)'),		cockpit_device_id = devices.VTB, down = 3215, up = 3215, value_down = -1,	value_up = 0,	},
    {category = _('HDD'), name = _('Theta Switch Up (Target Bearing from Bullsweye Increase)'),		cockpit_device_id = devices.VTB, down = 3216, up = 3216, value_down =  1,	value_up = 0,	},
	{category = _('HDD'), name = _('Theta Switch Down (Target Bearing from Bullseye Decrease)'),	cockpit_device_id = devices.VTB, down = 3216, up = 3216, value_down = -1,	value_up = 0,	},
    {category = _('HDD'), name = _('C Switch Up (Target Heading Increase)'),						cockpit_device_id = devices.VTB, down = 3217, up = 3217, value_down =  1,	value_up = 0,	},
	{category = _('HDD'), name = _('C Switch Down (Target Heading Decrease)'),						cockpit_device_id = devices.VTB, down = 3217, up = 3217, value_down = -1,	value_up = 0,	},
    {category = _('HDD'), name = _('Z Switch Up (Target Altitude Increase)'),						cockpit_device_id = devices.VTB, down = 3218, up = 3218, value_down =  1,	value_up = 0,	},
	{category = _('HDD'), name = _('Z Switch Down (Target Altitude Decrease)'),						cockpit_device_id = devices.VTB, down = 3218, up = 3218, value_down = -1,	value_up = 0,	},
    {category = _('HDD'), name = _('M Switch Up (Target Mach Number Increase)'),					cockpit_device_id = devices.VTB, down = 3219, up = 3219, value_down =  1,	value_up = 0,	},
	{category = _('HDD'), name = _('M Switch Down (Target Mach Number Decrease)'),					cockpit_device_id = devices.VTB, down = 3219, up = 3219, value_down = -1,	value_up = 0,	},
    {category = _('HDD'), name = _('T Switch (Target Age Increase)'),								cockpit_device_id = devices.VTB, down = 3220, up = 3220, value_down =  1,	value_up = 0,	},
	{category = _('HDD'), name = _('T Switch (Target Age Decrease)'),								cockpit_device_id = devices.VTB, down = 3220, up = 3220, value_down = -1,	value_up = 0,	},
	{category = _('HDD'), name = _('VTB ALLEG (Declutter)'), 										cockpit_device_id = devices.VTB, down = 3222, up = 3222, value_down =  0,	value_up = 1	},
	{category = _('HDD'), name = _('VTB CADR AR (Map all around) glance'),							cockpit_device_id = devices.VTB, down = 3223, up = 3223, value_down =  1,	value_up = 0	},
	{category = _('HDD'), name = _('VTB CADR AV (Map forward)'),									cockpit_device_id = devices.VTB, down = 3223, value_down = 0,								},
	{category = _('HDD'), name = _('VTB CADR AR (Map all around)'),									cockpit_device_id = devices.VTB, down = 3223, value_down = 1,								},
	
    -- Hydraulic & Mechanical
    {category = _('Hydraulic & Mechanical'), name = _('Wheel Brakes'), 						 	down = iCommandPlaneWheelBrakeOn, up = iCommandPlaneWheelBrakeOff, 				},
    {category = _('Hydraulic & Mechanical'), name = _('Wheel Brake LEFT'), 					 	down = iCommandPlaneWheelBrakeLeftOn, up = iCommandPlaneWheelBrakeLeftOff, 		},
    {category = _('Hydraulic & Mechanical'), name = _('Wheel Brake RIGHT'), 				 	down = iCommandPlaneWheelBrakeRightOn, up = iCommandPlaneWheelBrakeRightOff,	},
    {category = _('Hydraulic & Mechanical'), name = _('Landing Gear UP'), 					 	down = iCommandPlaneGearUp, 													},
    {category = _('Hydraulic & Mechanical'), name = _('Landing Gear DOWN'), 				 	down = iCommandPlaneGearDown, 													},
    {category = _('Hydraulic & Mechanical'), name = _('Canopy Position CYCLE'), 			 	down = cmds.CanopyFullAuto, 													},
    {category = _('Hydraulic & Mechanical'), name = _('Landing Gear TOGGLE'), 				 	down = iCommandPlaneGear, 														},
    {category = _('Hydraulic & Mechanical'), name = _('Hydraulic Emergency Pump OFF'),			down = 3657, cockpit_device_id = 3, value_down= -1.0,		 					},
    {category = _('Hydraulic & Mechanical'), name = _('Hydraulic Emergency Pump ON'),			down = 3657, cockpit_device_id = 3, value_down= 0.0,							},
    {category = _('Hydraulic & Mechanical'), name = _('Hydraulic Emergency Pump OVR'),			down = 3657, cockpit_device_id = 3, value_down= 1.0,							},
    {category = _('Hydraulic & Mechanical'), name = _('Parking Brake OFF'),						down = 3666, up = 3666, cockpit_device_id = 22, value_down= 0,  				},
    {category = _('Hydraulic & Mechanical'), name = _('Parking Brake ON'), 						down = 3666, up = 3666, cockpit_device_id = 22, value_down= 1, 					},
	{category = _('Hydraulic & Mechanical'), name = _('Canopy Jettision'), 						down = 3456, up = 3456, cockpit_device_id = 14, value_down= 1, 					},
	{category = _('Hydraulic & Mechanical'), name = _('Landing Gear UP, else DOWN'),			down = iCommandPlaneGearUp,			up = iCommandPlaneGearDown,					},
	{category = _('Hydraulic & Mechanical'), name = _('Parking Brake ON, else OFF'),			down = 3666, up = 3666, cockpit_device_id = 22,	value_down = 1,	value_up = 0,	},

    -- Navigation
	{category = _('Navigation'), name = _('G-Meter reset'),					down = 3348, up = 3348, cockpit_device_id = devices.FLI, value_down = 1.0,	value_up = 0.0,					},
    {category = _('Navigation'), name = _('Next Waypoint'),     				down = iCommandPlaneNav_PB0, value_down = 1,																	},
    {category = _('Navigation'), name = _('Previous Waypoint'), 				down = iCommandPlaneNav_PB1, value_down = 1,																	},	
    {category = _('Navigation'), name = _('Altimeter Calibration CW'),		down = iCommandAltimeterPressureIncrease, 																			},
    {category = _('Navigation'), name = _('Altimeter Calibration CCW'),		down = iCommandAltimeterPressureDecrease, 																			},
	{category = _('Navigation'), name = _('HSI Mode 1 - Nav Cv'), 			down = 3341, cockpit_device_id = 2, value_down = 0.0, 																},
	{category = _('Navigation'), name = _('HSI Mode 2 - Nav'), 				down = 3341, cockpit_device_id = 2, value_down = 0.1, 																},
	{category = _('Navigation'), name = _('HSI Mode 3 - TAC'), 				down = 3341, cockpit_device_id = 2, value_down = 0.2, 																},
	{category = _('Navigation'), name = _('HSI Mode 4 - VAD'), 				down = 3341, cockpit_device_id = 2, value_down = 0.3, 																},
	{category = _('Navigation'), name = _('HSI Mode 5 - VAD ρ'), 			down = 3341, cockpit_device_id = 2, value_down = 0.4, 																},
	{category = _('Navigation'), name = _('HSI Mode 6 - VAD θ'), 			down = 3341, cockpit_device_id = 2, value_down = 0.5, 																},
	{category = _('Navigation'), name = _('HSI Mode 7 - TEL'), 				down = 3341, cockpit_device_id = 2, value_down = 0.6, 																},
	{category = _('Navigation'), name = _('HSI Mode CCW'), 					down = cmds.HSI_MODE_INC,			value_down = 1.0,																},
	{category = _('Navigation'), name = _('HSI Mode CW'),  					down = cmds.HSI_MODE_INC,			value_down =-1.0,																},
	{category = _('Navigation'), name = _('HSI VAD -'), 					down = 3340, up = 3340, cockpit_device_id = 2, value_down =-1.0, value_up = 0.0, 									},
	{category = _('Navigation'), name = _('HSI VAD +'), 					down = 3340, up = 3340, cockpit_device_id = 2, value_down = 1.0, value_up = 0.0, 									},
	{category = _('Navigation'), name = _('HSI VAD STEP -'), 				down = cmds.HSI_VAD_INC, value_down =-1.0, 																			},
	{category = _('Navigation'), name = _('HSI VAD STEP +'), 				down = cmds.HSI_VAD_INC, value_down = 1.0, 																			},
	{category = _('Navigation'), name = _('Backup ADI Uncage Lock Toggle'), down = cmds.ADI_Cage_Toggle, value_down = 1.0, 																		},
	{category = _('Navigation'), name = _('Backup ADI Uncage Lock Pull'), 	down = cmds.ADI_Cage_Pull, up = cmds.ADI_Cage_Pull, value_down = 1.0, value_up = 0.0, 								},
	{category = _('Navigation'), name = _('Backup ADI Pitch Adjust CCW'), 	down = cmds.ADI_Pitch_CCW,  value_down = 0.05, 																		},
	{category = _('Navigation'), name = _('Backup ADI Pitch Adjust CW'),  	down = cmds.ADI_Pitch_CW, value_down = 0.05, 																		},
    {category = _('Navigation'), name = _('Backup Horizon AFT/OFF'), 		down = 3665, cockpit_device_id = devices.FLI, value_down = 0.0												},
    {category = _('Navigation'), name = _('Backup Horizon MID/POWERED'),	down = 3665, cockpit_device_id = devices.FLI, value_down = 0.5												},
    {category = _('Navigation'), name = _('Backup Horizon FWD/FORCED'),		down = 3665, cockpit_device_id = devices.FLI, value_down = 1.0												},
	{category = _('Navigation'), name = _('Backup Horizon FWD/FORCED, else MID/POWERED'),	down = 3665, up = 3665, cockpit_device_id = devices.FLI, value_down = 1.0,	value_up = 0.5,	},
	{category = _('Navigation'), name = _('Backup Horizon AFT/OFF, else MID/POWERED'),		down = 3665, up = 3665, cockpit_device_id = devices.FLI, value_down = 0.0,	value_up = 0.5,	},

    -- Autopilot
    {category = _('Autopilot'), name = _('Autopilot'), 					down = 3282, up = 3282, cockpit_device_id = 17,	value_down= 1.0, value_up= 0.0 },
    {category = _('Autopilot'), name = _('Altitude Hold Mode'), 		down = 3285, up = 3285, cockpit_device_id = 17,	value_down= 1.0, value_up= 0.0 },
    {category = _('Autopilot'), name = _('Selected Altitude Hold Mode'),down = 3288, up = 3288, cockpit_device_id = 17,	value_down= 1.0, value_up= 0.0 },
    {category = _('Autopilot'), name = _('Approach Hold Mode'),			down = 3294, up = 3294, cockpit_device_id = 17,	value_down= 1.0, value_up= 0.0 },
	{category = _('Autopilot'), name = _('Selected Alt FL 100 Inc'), 	down = cmds.SEL_ALT_FL100_INC,		value_down = 1,  	},
	{category = _('Autopilot'), name = _('Selected Alt FL 100 Dec'), 	down = cmds.SEL_ALT_FL100_INC,		value_down =-1, 	},
	{category = _('Autopilot'), name = _('Selected Alt FL 10 Inc'), 	down = cmds.SEL_ALT_FL10_INC,		value_down = 1,  	},
	{category = _('Autopilot'), name = _('Selected Alt FL 10 Dec'), 	down = cmds.SEL_ALT_FL10_INC,		value_down =-1, 	},
	{category = _('Autopilot'), name = _('Selected Alt FL 1 Inc'), 		down = cmds.SEL_ALT_FL1_INC,		value_down = 1,  	},
	{category = _('Autopilot'), name = _('Selected Alt FL 1 Dec'), 		down = cmds.SEL_ALT_FL1_INC,		value_down =-1, 	},
	{category = _('Autopilot'), name = _('Selected Alt Combo FL+10'), 	down = cmds.SEL_ALT_COMBO_INC,		value_down = 10,	},
	{category = _('Autopilot'), name = _('Selected Alt Combo FL-10'),	down = cmds.SEL_ALT_COMBO_INC,		value_down =-10,	},
	
	-- INS
    {category = _('INS'), name = _('PCN BAD Button'), 				down = 3576, up = 3576, cockpit_device_id = 9, value_up= 0, value_down = 1	},
    {category = _('INS'), name = _('PCN REC Button'), 				down = 3578, up = 3578, cockpit_device_id = 9, value_up= 0, value_down = 1	},
	{category = _('INS'), name = _('PCN MRQ Button'), 				down = 3582, up = 3582, cockpit_device_id = 9, value_up= 0, value_down = 1	},
	{category = _('INS'), name = _('PCN VAL Button'), 				down = 3580, up = 3580, cockpit_device_id = 9, value_up= 0, value_down = 1	},
    {category = _('INS'), name = _('PCN PREP Button'), 				down = 3570, up = 3570, cockpit_device_id = 9, value_up= 0, value_down = 1	},
    {category = _('INS'), name = _('PCN DEST Button'), 				down = 3572, up = 3572, cockpit_device_id = 9, value_up= 0, value_down = 1	},
    {category = _('INS'), name = _('PCN ENTER Button'), 			down = 3596, up = 3596, cockpit_device_id = 9, value_up= 0, value_down = 1	},
    {category = _('INS'), name = _('PCN Clear Button'), 			down = 3594, up = 3594, cockpit_device_id = 9, value_up= 0, value_down = 1	},
    {category = _('INS'), name = _('PCN Button 0'), 				down = 3593, up = 3593, cockpit_device_id = 9, value_up= 0, value_down = 1	},
    {category = _('INS'), name = _('PCN Button 1'), 				down = 3584, up = 3584, cockpit_device_id = 9, value_up= 0, value_down = 1	},
    {category = _('INS'), name = _('PCN Button 2'), 				down = 3585, up = 3585, cockpit_device_id = 9, value_up= 0, value_down = 1	},
    {category = _('INS'), name = _('PCN Button 3'), 				down = 3586, up = 3586, cockpit_device_id = 9, value_up= 0, value_down = 1	},
    {category = _('INS'), name = _('PCN Button 4'), 				down = 3587, up = 3587, cockpit_device_id = 9, value_up= 0, value_down = 1	},
    {category = _('INS'), name = _('PCN Button 5'), 				down = 3588, up = 3588, cockpit_device_id = 9, value_up= 0, value_down = 1	},
    {category = _('INS'), name = _('PCN Button 6'), 				down = 3589, up = 3589, cockpit_device_id = 9, value_up= 0, value_down = 1	},
    {category = _('INS'), name = _('PCN Button 7'), 				down = 3590, up = 3590, cockpit_device_id = 9, value_up= 0, value_down = 1	},
    {category = _('INS'), name = _('PCN Button 8'), 				down = 3591, up = 3591, cockpit_device_id = 9, value_up= 0, value_down = 1	},
    {category = _('INS'), name = _('PCN Button 9'), 				down = 3592, up = 3592, cockpit_device_id = 9, value_up= 0, value_down = 1	},
    {category = _('INS'), name = _('PCN Parameter TR/VS'), 			down = 3574, cockpit_device_id = 9, value_down = 0.0						},
    {category = _('INS'), name = _('PCN Parameter D/RLT'), 			down = 3574, cockpit_device_id = 9, value_down = 0.1						},
    {category = _('INS'), name = _('PCN Parameter CP/PD'), 			down = 3574, cockpit_device_id = 9, value_down = 0.2						},
    {category = _('INS'), name = _('PCN Parameter ALT'), 			down = 3574, cockpit_device_id = 9, value_down = 0.3						},
    {category = _('INS'), name = _('PCN Parameter L/G'), 			down = 3574, cockpit_device_id = 9, value_down = 0.4						},
    {category = _('INS'), name = _('PCN Parameter RD/TD'), 			down = 3574, cockpit_device_id = 9, value_down = 0.5						},
    {category = _('INS'), name = _('PCN Parameter ΔL/ΔG'), 			down = 3574, cockpit_device_id = 9, value_down = 0.6						},
    {category = _('INS'), name = _('PCN Parameter ΔALT'), 			down = 3574, cockpit_device_id = 9, value_down = 0.7						},
    {category = _('INS'), name = _('PCN Parameter P/Ө'), 			down = 3574, cockpit_device_id = 9, value_down = 0.8						},
    {category = _('INS'), name = _('PCN Parameter DEC'), 			down = 3574, cockpit_device_id = 9, value_down = 0.9						},
    {category = _('INS'), name = _('PCN Parameter DV/FV'), 			down = 3574, cockpit_device_id = 9, value_down = 1.0						},
	{category = _('INS'), name = _('PCN Parameter CCW'), 			down = cmds.INSParamSelect_INC,		value_down =-1.0						},
	{category = _('INS'), name = _('PCN Parameter CW'), 			down = cmds.INSParamSelect_INC,		value_down = 1.0						},
    {category = _('INS'), name = _('INS Mode Selector - OFF (AR)'), down = 3627, cockpit_device_id = 9, value_down = 0.0						},
    {category = _('INS'), name = _('INS Mode Selector - VEI'), 		down = 3627, cockpit_device_id = 9, value_down = 0.1						},
    {category = _('INS'), name = _('INS Mode Selector - CAL'), 		down = 3627, cockpit_device_id = 9, value_down = 0.2						},
    {category = _('INS'), name = _('INS Mode Selector - TST'), 		down = 3627, cockpit_device_id = 9, value_down = 0.3						},
    {category = _('INS'), name = _('INS Mode Selector - ALN'), 		down = 3627, cockpit_device_id = 9, value_down = 0.4						},
    {category = _('INS'), name = _('INS Mode Selector - ALCM'),		down = 3627, cockpit_device_id = 9, value_down = 0.5						},
    {category = _('INS'), name = _('INS Mode Selector - NAV'),		down = 3627, cockpit_device_id = 9, value_down = 0.6						},
    {category = _('INS'), name = _('INS Mode Selector - SEC'),		down = 3627, cockpit_device_id = 9, value_down = 0.7						},
	{category = _('INS'), name = _('INS Mode CCW'), 				down = cmds.INSModeSelect_INC,		value_down =-1.0						},
	{category = _('INS'), name = _('INS Mode CW'), 					down = cmds.INSModeSelect_INC,		value_down = 1.0 						},
    {category = _('INS'), name = _('INS Operational Mode - N'),		down = 3629, cockpit_device_id = 9, value_down = 0.0						},
    {category = _('INS'), name = _('INS Operational Mode - STS'),	down = 3629, cockpit_device_id = 9, value_down = 0.1						},
    {category = _('INS'), name = _('INS Operational Mode - DCI'),	down = 3629, cockpit_device_id = 9, value_down = 0.2						},
    {category = _('INS'), name = _('INS Operational Mode - CRV'),	down = 3629, cockpit_device_id = 9, value_down = 0.3						},
    {category = _('INS'), name = _('INS Operational Mode - MAIN'),	down = 3629, cockpit_device_id = 9, value_down = 0.4						},
	{category = _('INS'), name = _('INS PCN Operational Mode CCW'), down = cmds.INSOperMode_INC,		value_down = 1.0						},
	{category = _('INS'), name = _('INS PCN Operational Mode CW'),	down = cmds.INSOperMode_INC,		value_down =-1.0						},
	{category = _('INS'), name = _('MIP Cartridge Next'),			down = cmds.MIP_Next,				value_down = 1.0						},
	{category = _('INS'), name = _('MIP Cartridge Previous'),		down = cmds.MIP_Next,				value_down =-1.0						},
	{category = _('INS'), name = _('MIP Cartridge Load'),			down = cmds.MIP_Load,				value_down = 1.0						},
	{category = _('INS'), name = _('MIP Cartridge Remove'),			down = cmds.MIP_Remove,				value_down = 1.0						},

	--TACAN & ILS
	{category = _('TACAN & ILS'), name = _('VOR/ILS Freq MHz Dec'),	down = iCommandPlane_ILS_MHz_Decrease,																					},
	{category = _('TACAN & ILS'), name = _('VOR/ILS Freq MHz Inc'),	down = iCommandPlane_ILS_MHz_Increase,																					},
	{category = _('TACAN & ILS'), name = _('VOR/ILS Freq kHz Dec'),	down = iCommandPlane_ILS_KHz_Decrease,																					},
	{category = _('TACAN & ILS'), name = _('VOR/ILS Freq kHz Inc'),	down = iCommandPlane_ILS_KHz_Increase,																					},
	{category = _('TACAN & ILS'), name = _('VOR/ILS Freq Decrease'),down = cmds.VORILS_Frec_INC, value_down=-1.0, 																			},
	{category = _('TACAN & ILS'), name = _('VOR/ILS Freq Increase'),down = cmds.VORILS_Frec_INC, value_down=1.0,  																			},
	{category = _('TACAN & ILS'), name = _('VOR/ILS OFF'),			down = cmds.Button_617, cockpit_device_id = devices.VORILS, value_down = 0.0,											},
	{category = _('TACAN & ILS'), name = _('VOR/ILS ON'),			down = cmds.Button_617, cockpit_device_id = devices.VORILS, value_down = 1.0,											},
	{category = _('TACAN & ILS'), name = _('VOR/ILS ON/OFF'),		down = iCommandPlane_ILS_Power,																							},
	{category = _('TACAN & ILS'), name = _('VOR/ILS Test HG'),		down = cmds.Button_619, up = cmds.Button_619, cockpit_device_id = devices.VORILS, value_down = 0.0,		value_up = 0.5,	},
	{category = _('TACAN & ILS'), name = _('VOR/ILS Test BD'),		down = cmds.Button_619, up = cmds.Button_619, cockpit_device_id = devices.VORILS, value_down = 1.0,		value_up = 0.5,	},
	{category = _('TACAN & ILS'), name = _('TACAN CH 1-'),			down = iCommandPlane_TACAN_Chanel_Ones_Decrease,																		},
	{category = _('TACAN & ILS'), name = _('TACAN CH 1+'),			down = iCommandPlane_TACAN_Chanel_Ones_Increase,																		},
	{category = _('TACAN & ILS'), name = _('TACAN CH 10-'),			down = iCommandPlane_TACAN_Chanel_Tens_Decrease,																		},
	{category = _('TACAN & ILS'), name = _('TACAN CH 10+'),			down = iCommandPlane_TACAN_Chanel_Tens_Increase,																		},
	{category = _('TACAN & ILS'), name = _('TACAN CH Decrease'), 	down = cmds.TAC_CH_INC,	value_down=-1.0,		 																		},
	{category = _('TACAN & ILS'), name = _('TACAN CH Increase'), 	down = cmds.TAC_CH_INC, value_down=1.0,  																				},
	{category = _('TACAN & ILS'), name = _('TACAN CH XY Switch'), 	down = iCommandPlane_TACAN_Chanel_XY_Mode, 																				},
	{category = _('TACAN & ILS'), name = _('TACAN CH X'), 			down = cmds.Button_624, cockpit_device_id = devices.TACAN, value_down = 0.0, 											},
	{category = _('TACAN & ILS'), name = _('TACAN CH Y'), 			down = cmds.Button_624, cockpit_device_id = devices.TACAN, value_down = 1.0, 											},
	{category = _('TACAN & ILS'), name = _('TACAN Mode OFF'),  		down = iCommandPlane_TACAN_Mode_Off,  																					},
	{category = _('TACAN & ILS'), name = _('TACAN Mode REC'),  		down = iCommandPlane_TACAN_Mode_Rec,  																					},
	{category = _('TACAN & ILS'), name = _('TACAN Mode TR'),   		down = iCommandPlane_TACAN_Mode_TR,   																					},
	{category = _('TACAN & ILS'), name = _('TACAN Mode AA'),   		down = iCommandPlane_TACAN_Mode_AATR, 																					},
	{category = _('TACAN & ILS'), name = _('TACAN Mode Next'), 		down = cmds.TAC_MODE_INC, value_down=1.0,  																				},
	{category = _('TACAN & ILS'), name = _('TACAN Mode Prev'), 		down = cmds.TAC_MODE_INC, value_down=-1.0, 																				},
	{category = _('TACAN & ILS'), name = _('TACAN Mode Cycle'), 	down = cmds.TAC_MODE_Cycle,  																							},

	--Volumes
	{category = _('Volumes'), name = _('VOR/ILS Volume Dec'), 			down = cmds.VOL_VORILS_INC,		value_down=-0.5,	},
	{category = _('Volumes'), name = _('VOR/ILS Volume Inc'), 			down = cmds.VOL_VORILS_INC,		value_down=0.5,		},
	{category = _('Volumes'), name = _('TACAN Volume Dec'), 			down = cmds.VOL_TACAN_INC,		value_down=-0.5, 	},
	{category = _('Volumes'), name = _('TACAN Volume Inc'), 			down = cmds.VOL_TACAN_INC,		value_down=0.5, 	},
	{category = _('Volumes'), name = _('MISSILE Volume Dec'),			down = cmds.VOL_MISSILE_INC,	value_down=-0.5,	},
	{category = _('Volumes'), name = _('MISSILE Volume Inc'), 			down = cmds.VOL_MISSILE_INC,	value_down=0.5,		},
	{category = _('Volumes'), name = _('INTERCOM/APPROACH Volume Dec'),	down = cmds.VOL_TBAPP_INC,		value_down=-0.5,	},
	{category = _('Volumes'), name = _('INTERCOM/APPROACH Volume Inc'),	down = cmds.VOL_TBAPP_INC,		value_down=0.5, 	},
	{category = _('Volumes'), name = _('TP/MARKER Volume Dec'),		 	down = cmds.VOL_TPMKR_INC,		value_down=-0.5,	},
	{category = _('Volumes'), name = _('TP/MARKER Volume Inc'),			down = cmds.VOL_TPMKR_INC,		value_down=0.5,		},
	{category = _('Volumes'), name = _('UHF RED Volume Dec'), 			down = cmds.VOL_UHF_INC,		value_down=-0.5, 	},
	{category = _('Volumes'), name = _('UHF RED Volume Inc'),			down = cmds.VOL_UHF_INC,		value_down=0.5,		},
	{category = _('Volumes'), name = _('V/UHF GREEN Volume Dec'),		down = cmds.VOL_VUHF_INC,		value_down=-0.5,	},
	{category = _('Volumes'), name = _('V/UHF GREEN Volume Inc'),		down = cmds.VOL_VUHF_INC,		value_down=0.5,		},	
	
	
	-- Pilot & Seat Controls    
	{category = _('Pilot & Seat Controls'), name = _('NVG Toggle'),						down = iCommandViewNightVisionGogglesOn,											},
	{category = _('Pilot & Seat Controls'), name = _('Stow/Unstow NVG'),				down = iCommandPlaneDLK_Target3,													},
	{category = _('Pilot & Seat Controls'), name = _('Sun Visor Toggle'),				down = iCommandPlaneDLK_Target2,													},
	{category = _('Pilot & Seat Controls'), name = _('Toggle Mount NVG on helmet'),		down = iCommandPlaneDLK_Target1,													},
	{category = _('Pilot & Seat Controls'), name = _('Pilot Body TOGGLE'),				down = iCommandCockpitShowPilotOnOff,												},
	{category = _('Pilot & Seat Controls'), name = _('Mirrors TOGGLE'),					down = iCommandToggleMirrors,														},
	{category = _('Pilot & Seat Controls'), name = _('Eject (3 times)'),				down = iCommandPlaneEject,															},	
	{category = _('Pilot & Seat Controls'), name = _('Seat RAISE'),						pressed = iCommandPilotSeatAdjustmentUp, up = iCommandPilotSeatAdjustmentStop,		},
	{category = _('Pilot & Seat Controls'), name = _('Seat LOWER'),						pressed = iCommandPilotSeatAdjustmentDown, up = iCommandPilotSeatAdjustmentStop,	},
	{category = _('Pilot & Seat Controls'), name = _('Eject'),							pressed = iCommandPlaneEject 														},	
	{category = _('Pilot & Seat Controls'), name = _('Hide/Show Control Stick'),		down = iCommandPlaneCircuitBreaker_10 												},
	{category = _('Pilot & Seat Controls'), name = _('Hide/Show Throttle'),				down = iCommandPlaneCircuitBreaker_11 												},
	{category = _('Pilot & Seat Controls'), name = _('NVG Gain Increase'), 				pressed = iCommandPlane_Helmet_Brightess_Up 										},	
	{category = _('Pilot & Seat Controls'), name = _('NVG Gain Decrease'), 				pressed = iCommandPlane_Helmet_Brightess_Down 										},	
    
    -- Flight Timer
	{category = _('Timer'),	name = _('Flight Timer START/STOP/RESET'), 	down = 3923, up = 3923, cockpit_device_id = 43,	value_down = 1, value_up = 0        },
	{category = _('Timer'),	name = _('Flight Timer SET TIME ON'),      	down = 3924,            cockpit_device_id = 43,	value_down = 1,                     },
	{category = _('Timer'),	name = _('Flight Timer SET TIME OFF'),      down = 3924,            cockpit_device_id = 43,	value_down = 0,                     },
	{category = _('Timer'),	name = _('Flight Timer KNOB CW'),       	down = 3922,            cockpit_device_id = 43,	value_down =  1.0/60,               },
	{category = _('Timer'),	name = _('Flight Timer KNOB CCW'),      	down = 3922,            cockpit_device_id = 43,	value_down = -1.0/60,               },
	{category = _('Timer'),	name = _('Flight Timer RING CCW'),      	down = 3925,            cockpit_device_id = 43,	value_down = -1.0/60,               },

	-- Communications
	{category = _('Communications'), name = _('Request AWACS Available Tanker'), 		down = iCommandAWACSTankerBearing				},
	{category = _('Communications'), name = _('Receive Mode'), 					 		down = iCommandToggleReceiveMode				},
	{category = _('Communications'), name = _('Tanker - Ready for precontact'),			down = iCommandPlaneRefuelingReadyPreContact	},

	-- Cheat
	{category = _('Cheat'), name = _('Start Procedure'), 	down = iCommandEnginesStart, 	},
    {category = _('Cheat'), name = _('Stop Procedure'),  	down = iCommandEnginesStop,  	},
    {category = _('Cheat'), name = _('AoA Always visible'), down = cmds.AOA_Show			},
	
	--DEBUG
	{category = _('Debug'), name = _('Debug Incr'),		down = iCommandPlane_ABRIS_Axis_Increase },
	{category = _('Debug'), name = _('Debug Decr'),		down = iCommandPlane_ABRIS_Axis_Decrease },
	{category = _('Debug'), name = _('Debug Push'),		down = iCommandPlane_ABRIS_Axis_Push },
	{category = _('Debug'), name = _('Test Feature'),			down = iCommandPlane_ADF_Test			 },
}) 

join(res.axisCommands,{
	{combos = defaultDeviceAssignmentFor("roll")  ,  action = iCommandPlaneRoll		   , name = _('Roll')	},
	{combos = defaultDeviceAssignmentFor("pitch") ,  action = iCommandPlanePitch	   , name = _('Pitch')	},
	{combos = defaultDeviceAssignmentFor("rudder"),  action = iCommandPlaneRudder	   , name = _('Rudder')	},
	{combos = defaultDeviceAssignmentFor("thrust"),  action = iCommandPlaneThrustCommon, name = _('Thrust')	},
	{action = iCommandPlaneSelecterHorizontalAbs, 						name = _('TDC Slew Horizontal')},
	{action = iCommandPlaneSelecterVerticalAbs	, 						name = _('TDC Slew Vertical')},
	{action = iCommandWheelBrake,										name = _('Wheel Brakes')},
	{action = iCommandLeftWheelBrake,									name = _('Wheel Brake Left')},
	{action = iCommandRightWheelBrake,									name = _('Wheel Brake Right')},
	{action = cmds.Button_701,		cockpit_device_id = devices.SYSLIGHTS,	name = _('VOR/ILS Volume')},
	{action = cmds.Button_702,		cockpit_device_id = devices.SYSLIGHTS,	name = _('TACAN Volume')},
	{action = cmds.Button_703,		cockpit_device_id = devices.SYSLIGHTS,	name = _('MISSILE Volume')},
	{action = cmds.Button_704,		cockpit_device_id = devices.SYSLIGHTS,	name = _('INTERCOM/APPROACH Volume')},
	{action = cmds.Button_705,		cockpit_device_id = devices.SYSLIGHTS,	name = _('TP/MARKER Volume')},
	{action = cmds.Button_706,		cockpit_device_id = devices.SYSLIGHTS,	name = _('UHF RED Volume')},
	{action = cmds.Button_707,		cockpit_device_id = devices.SYSLIGHTS,	name = _('V/UHF Radio Volume')},
	{action = cmds.Button_309,		cockpit_device_id = devices.FLI,	name = _('Altimeter Calibration')},
	{action = cmds.Button_328,		cockpit_device_id = devices.FLI,	name = _('Backup ADI Pitch Adjust')},
	{action = cmds.Button_488,		cockpit_device_id = devices.PCR, 		name = _('Radar Gain Dial')},
	{action = cmds.Button_209,		cockpit_device_id = devices.VTH,		name = _('Target Wingspan Knob')},
	{action = cmds.Button_228,		cockpit_device_id = devices.SYSLIGHTS,	name = _('RWR Light Brightnes Control')},
	{action = cmds.Button_639,		cockpit_device_id = devices.SYSLIGHTS,	name = _('Dashboard U.V. Lights Knob')},
	{action = cmds.Button_640,		cockpit_device_id = devices.SYSLIGHTS,	name = _('Dashboard Panel Lights Knob')},
	{action = cmds.Button_641,		cockpit_device_id = devices.SYSLIGHTS,	name = _('Red Flood Lights Knob')},
	{action = cmds.Button_642,		cockpit_device_id = devices.SYSLIGHTS,	name = _('Console Panel Lights Knob')},
	{action = cmds.Button_643,		cockpit_device_id = devices.SYSLIGHTS,	name = _('Caution/Advisory Lights Knob')},
	{action = cmds.Button_644,		cockpit_device_id = devices.SYSLIGHTS,	name = _('White Flood Lights Knob')},
	{action = cmds.Button_575,		cockpit_device_id = devices.PCN,		name = _('PCN Brightness')},
	{action = cmds.Button_920,		cockpit_device_id = devices.SYSLIGHTS,	name = _('Refuel Lights Brightness Knob')},
	{action = cmds.Button_906,		cockpit_device_id = devices.Helmet_NVG,	name = _('Helmet Sun Visor')},
	{action = cmds.HUD_BRT_AXIS,											name = _('HUD Brightness')},
	{action = cmds.SELH_KNOB,  												name = _('Minimum Altitude Selector')},
	{action = cmds.AUX_SIGHT_KNOB,											name = _('Auxiliary Sight Deflection')},


}) return res
