local wingOutbdPylonMass	= 58.1		-- [kg]	(128 lb)
local wingInbdPylonMass		= 55.3		-- [kg]	(122 lb)
local ctrPylonMass			= 77.1		-- [kg]	(170 lb)

local tips =
{
	{ CLSID = "{R-13M}"							  	  ,		Cx_gain = 0.302},			-- R-13M
	{ CLSID = "{R-13M1}"							  ,		Cx_gain = 0.302},			-- R-13M1
	{ CLSID = "{R-3S}"								  ,		Cx_gain = 0.302},			-- R-3S
	{ CLSID = "{R-3R}"								  ,		Cx_gain = 0.302},			-- R-3R

	{ CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E741}",		Cx_gain = 0.22},			-- Smokewinder red
	{ CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E742}",		Cx_gain = 0.22},			-- Smokewinder green
	{ CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E743}",		Cx_gain = 0.22},			-- Smokewinder blue
	{ CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E744}",		Cx_gain = 0.22},			-- Smokewinder white
	{ CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E745}",		Cx_gain = 0.22},			-- Smokewinder yellow
	{ CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E746}",		Cx_gain = 0.22},			-- Smokewinder orange
}
local outboard =
{
	{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",  attach_point_position = {0.1, -0.07, 0}, arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- R73

	{ CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}", arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- FAB-100
 	{ CLSID = "{FAB_250_M62}",							arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- FAB_250_M62
 	{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",	arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- FAB-250
	{ CLSID = "{FAB-100-4}", 							arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- FAB-100-4
	{ CLSID = "{FAB-250-M54-TU}", 						arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- FAB-250-M54-TU
	{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- RBK-250 PTAB

	{ CLSID = "{UB-16_S5M}", arg_value = 0.0, add_mass = wingOutbdPylonMass	},	 
	{ CLSID = "{UB-32_S5M}", arg_value = 0.0, add_mass = wingOutbdPylonMass	},	 
	{ CLSID = "{S-24B}", arg_value = 0.0, add_mass = wingOutbdPylonMass	},	 
	{ CLSID = "{S-24A}", arg_value = 0.0, add_mass = wingOutbdPylonMass	},	

}
local inboard =
{
	{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",  attach_point_position = {0.1, -0.07, 0}, arg_value = 0.0, add_mass = wingOutbdPylonMass	}, -- R73
	{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",  attach_point_position = {0.1, -0.1, 0}, arg_value = 0.0, add_mass = wingOutbdPylonMass	}, -- R27R
	{ CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}",  attach_point_position = {0.1, -0.1, 0}, arg_value = 0.0, add_mass = wingOutbdPylonMass	}, -- R27T

	{ CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}", arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- FAB-100
 	{ CLSID = "{FAB_250_M62}",							arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- FAB_250_M62
	{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}", arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- Mk-83
 	{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- FAB-250
	{ CLSID = "{FAB-100-4}",							arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- FAB-100-4
	{ CLSID = "{FAB-250-M54-TU}", 						arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- FAB-250-M54-TU
	{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- RBK-250 PTAB

	{ CLSID = "{UB-16_S5M}", arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- LAU-68-MK5
	{ CLSID = "{UB-32_S5M}", arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- LAU-68-M151
	{ CLSID = "{S-24B}", arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- LAU-68-MK156
	{ CLSID = "{S-24A}", arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- LAU-68-M257

	{ CLSID = "{0395076D-2F77-4420-9D33-087A4398130B}", arg_value = 0.0, add_mass = wingInbdPylonMass	},												-- 275 gal drop tank
	{ CLSID = "{PTB-150GAL}",							arg_value = 0.0, add_mass = wingInbdPylonMass	},												-- 150 gal drop tank
}
local centerline =
{
	{ CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}", arg_value = 0.0, add_mass = ctrPylonMass	},  -- FAB-100
    { CLSID = "{FAB_250_M62}",							arg_value = 0.0, add_mass = ctrPylonMass	},	-- FAB_250_M62
	{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", arg_value = 0.0, add_mass = ctrPylonMass	},	-- FAB-500
	{ CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}", arg_value = 0.0, add_mass = ctrPylonMass	},	-- BetAB-500
	{ CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}", arg_value = 0.0, add_mass = ctrPylonMass	},	-- BetAB-500ShP
	{ CLSID = "{FAB-100-4}",							arg_value = 0.0, add_mass = ctrPylonMass	},	-- FAB-100-4
	{ CLSID = "{FAB-250-M54-TU}", 						arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- FAB-250-M54-TU
	{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- RBK-250 PTAB

	{ CLSID = "{0395076D-2F77-4420-9D33-087A4398130B}", arg_value = 0.0, add_mass = ctrPylonMass	},	-- 275 gal drop tank
	{ CLSID = "{PTB-150GAL}",							arg_value = 0.0, add_mass = ctrPylonMass	},	-- 150 gal drop tank
}

function f5e3_fc_settings(unit_name, display_name)
	local f5_local_settings = f5e3_settings(unit_name, display_name)

	f5_local_settings.encyclopedia_hidden = true
	f5_local_settings.Shape			= 'f-5e3_fc'
	f5_local_settings.Name			= unit_name
	f5_local_settings.desrt			= 'f-5e3_fc_oblomok'
	f5_local_settings.DamageParts 	= {
		[1] = "f-5e3_fc_oblomok_wing_r",
		[2] = "f-5e3_fc_oblomok_wing_l",
	}
	f5_local_settings.Pylons		= {
		pylon(1, 0, -1.319000, -0.332000, -4.099000,
			{
				use_full_connector_position = true,
				connector		= "Pylon1",
			},
			tips
		),
		pylon(2, 0, -1.122000, -0.861000, -3.132000,
			{
				use_full_connector_position = true,
				connector		= "Pylon2",
				arg				= 309,
				arg_value		= 1,
				droppable_shape	= "F-5e3_fc_pylon_02",
			},
			outboard
		),
		pylon(3, 0, -1.190000, -0.922000, -2.334000,
			{
				use_full_connector_position = true,
				connector		= "Pylon3",
				arg				= 310,
				arg_value		= 1,
				droppable_shape	= "F-5e3_fc_pylon_03",
			},
			inboard
		),
		pylon(4, 0,  0.065000, -0.930000,  0.000000,
			{
				use_full_connector_position = true,
				connector		= "Pylon4",
				arg				= 311,
				arg_value		= 1,
				droppable_shape	= "F-5e3_fc_pylon_04c",
			},
			centerline
		),
		pylon(5, 0, -1.190000, -0.922000,  2.334000,
			{
				use_full_connector_position = true,
				connector		= "Pylon5",
				arg				= 312,
				arg_value		= 1,
				droppable_shape	= "F-5e3_fc_pylon_05",
			},
			inboard
		),
		pylon(6, 0, -1.122000, -0.861000,  3.132000,
			{
				use_full_connector_position = true,
				connector		= "Pylon6",
				arg				= 313,
				arg_value		= 1,
				droppable_shape	= "F-5e3_fc_pylon_06",
			},
			outboard
		),
		pylon(7, 0, -1.319000, -0.332000,  4.099000,
			{
				use_full_connector_position = true,
				connector		= "Pylon7",
			},
			tips
		),
	}

	return f5_local_settings
end

make_tiger(f5e3_fc_settings('MiG-28', _('MiG-28')))