--[[
############################################################################################

BluForAC - Blue ("Friendly") Force AI Aircraft script

This script will spawn 1-4 friendly force AI aircraft (repeatable), which can be fighter, 
attack, multi-purpose aircraft, or helicopter types.  AI aircraft types, engagement scenarios 
(e.g. CAP, CAS, SEAD, Anti-Ship) and some pre-set target waypoint distances are selectable from 
the F10 menu, under the F10 menu item: "Spawn AI BluFor Aircraft At Will".  Just point your
client/player aircraft directly at the enemy ground/sea target(s) you wish them to attack, and
(as applicable) choose the distance you want them to fly as they search for targets.  For enemy
aircraft targets, pointing your client/player aircraft at them will help, but is not necessary.


by Joe AKA_Relent Camilleri

*************************
***** Instructions: *****
*************************

*** Loading script: ***

Load the script in the DCS mission editor by first clicking the "Set rules for trigger" button
on the left vertical tool bar. 

Next, click the "NEW" button under the TRIGGERS, CONDITIONS, and ACTIONS columns, as described below:

Single Player (SP) missions (i.e. with one Player aircraft/helicopter, NO Clients):
	TRIGGERS: Set trigger to MISSION START (will not work in SP otherwise)
	ACTIONS: Set action to DO SCRIPT FILE, then navigate to and select BluForAC.lua script

Multi Player (MP) missions (i.e. with one or more Client aircraft/helicopter):
	Option 1:
		TRIGGERS: Set trigger to MISSION START
		ACTIONS: Set action to DO SCRIPT FILE, then navigate to and select BluForAC.lua script
	Option 2: (if there are issues loading script at mission start)
		TRIGGERS: Set trigger to ONCE
		CONDITIONS: Set condition to TIME MORE(x) (where x = desired delay in seconds from mission start)
		ACTIONS: Set action to DO SCRIPT FILE, then navigate to and select BluForAC.lua script
		NOTE: With this option, before you spawn in an aircraft, un-pause the mission first, or the script
			will not have loaded yet

*** Coalitions: ***

	To avoid neutral scenarios where AI BluFor aircraft may not attack RED/BLUE aircraft/ground/sea targets,
	the script assumes the following countries are on the coalitions listed (NOTE: This is the default 
	condition when creating a new mission.  However, older missions may not have all of these countries 
	mapped to the coalitions listed).  Please verify and if necessary, assign to the coalitions listed below.
	Click the "Changing	coalitions" button on the left vertical tool bar to check the coalition assignments.

	BLUE:
		country.id.CJTF_BLUE (i.e. Combined Joint Task Forces Blue)
		country.id.FRANCE
		country.id.UK
		country.id.USA
		
	RED:
		country.id.CHINA
		country.id.CJTF_RED (i.e. Combined Joint Task Forces Red)
		country.id.NORTH_KOREA
		country.id.RUSSIA

*** Creating Exclusion Zones: ***

	You can prevent BluFor AI aircraft from spawning in or travelling through an exclusion zone(s);  
	Simply create one or more circular trigger zones that include "Blue Exclusion Zone" or 
	"blue exclusion zone" in the trigger name.  Click the "Create trigger zone" button on the left 
	vertical tool bar to create a circular trigger zone(s).
		
		
*** Known issues: ***
	- For multi player missions, when a Client(player) is shot down, if they wish to use the same
		aircraft/helicopter	slot, they may need to move to Spectator first, then back to the 
		aircraft/helicopter	client slot.  Otherwise, the main BluForAC menu (i.e. 
		"Spawn AI BluFor Aircraft At Will") may be duplicated and not work.
	- When mission is flown in single player mode, kills are not being recorded properly in the
		debrief screen (e.g. if you switched sides, and shot down formerly BluFor aircraft that
		are now OpFor).  It is suggested to play all missions (i.e. with Client or Player) in multi-
		player mode (i.e. "Launch Multiplayer Server") if you wish to see the kills recorded.

==========================================================================================================		

*** Features: ***

Version 1.2
- AI BluFor aircraft coalition will be the same coalition of the aircraft or helicopter 
	the	client (MP) or player (SP) spawns in (please see *** Coalitions: *** above)
- BluForAC script now works for dynamic spawn slots
- The same AI BluFor aircraft type can be re-spawned as many times as desired
- One to four AI BluFor aircraft can be spawned at a time
- AI BluFor aircraft load-out depends on engagement scenario (e.g. Anti-Ship, CAP, CAS, SEAD)
- AI BluFor aircraft skill defaults to "Random", but can be changed via 'Options' menu.  Note 
	that the updated AI skill persists for the initiating player name, for the duration of the mission
- AI BluFor aircraft starting altitude AGL defaults to "Co-Alt+", but can be changed via 'Options' menu
	using pre-set low/medium/high altitudes AGL.  Note that the updated starting AI altitude AGL persists 
	for the initiating player name, for the duration of the mission
- AI BluFor aircraft spawn directly behind client/player aircraft with the same heading as the
	initiating client/player aircraft;  To maximize the ability of the AI BluFor aircraft to find
	enemy targets (especially for Anti-Ship, CAS and to a lesser degree SEAD missions), point your 
	client/player aircraft directly at the enemy target(s) you wish them to attack
- AI BluFor aircraft spawn at a similar altitude as the client/player by default (i.e. "Co-Alt+"), but
	can be changed to pre-set altitudes via Options menu;	AI helicopters spawn at ~500 feet AGL max
- AI BluFor aircraft's second and final waypoint is fixed for CAP mission types (20 miles, as defined
	by glbCAPDistBluFor), but is selectable via F10 menus for Anti-Ship and SEAD missions; for CAS
	missions, the second and final waypoint is variable depending on how far ahead ground/sea targets
	are found;  If no targets are found, CAS BluFor aircraft will not spawn
- AI BluFor CAS aircraft aircraft will only spawn if enemy ground units are inside the "target search
	circle", which is in front of the second waypoint (the distance to which is calculated, depending
	on if ground units are located ahead of the Client/Single Player aircraft);  The target search
	circle is 10 miles in diameter, as defined by the glbCASSearchRadius variable
- Once an AI BluFor aircraft returns to a friendly/neutral base and lands, it will be de-spawned
	once the aircraft stops (there is a function that checks for this every 120 seconds)
- A maximum of 24 AI BluFor aircraft can be spawned and active (alive) at a time, as defined by
	the glbMaxBluForSpawnable variable;  If you attempt to spawn AI BluFor aircraft and it
	would cause the total number of active (alive) AI BluFor aircraft to exceed this maximum number,
	you will see a message telling you they cannot be spawned, until the number of active AI BluFor
	aircraft is reduced by attrition or they land and de-spawn
- You can prevent BluFor AI aircraft from spawning in or travelling through an exclusion zones; 
	Simply create one or more circular trigger zones that include "Blue Exclusion Zone" or 
	"blue exclusion zone" in the trigger name.

##################################### GLOBALS ##############################################
]]

-- Maximum BlueFor AI spawned aircraft allowed at one time
glbMaxBluForSpawnable = 24

debugFlgBluFor = 0
tblPlayerListBluFor = {}
tblClientUnitBluFor = {}
tblExclZoneListBluFor = {}
tblLoadoutPresetsBluFor = {}
tblFuFlChLiPresetsBluFor = {}
tblOneToFourBluFor = {"One", "Two", "Three", "Four"}
glbUnitIdBluFor = 7000
glbGroupIdBluFor = 7000
tblBlueCallSignsBluFor = {"Enfield", "Springfield", "Uzi", "Colt", "Dodge", "Ford", "Chevy", "Pontiac"}
glbCurrentBlueCallSignBluFor = 1
glbOnBoardNumBluFor = 400
glbDefSkillBluFor = "Random"
glbDefAAltBluFor = "Co-Alt+"
glbDefDirBluFor = "12oc"
glbOfacTopMenuBluFor = "Spawn AI BluFor Aircraft At Will"

-- CAP, Helo, WW2 spawn distances to second waypoint in Km - to convert to Mi, divide by 1.609344
glbCAPDistBluFor = 32.1868 -- 20 miles
glbHeloDistBluFor = 20.1168 -- 12.5 miles
glbWW2DistBluFor = 20.1168 -- 12.5 miles

-- CAS distances to target search (second) waypoint in Km - to convert to Mi, divide by 1.609344
glbCASDistBluFor40 = 64.3736 -- 40 miles
glbCASDistBluFor30 = 48.2802 -- 30 miles
glbCASDistBluFor20 = 32.1868 -- 20 miles
glbCASDistBluFor10 = 16.0934 -- 10 miles
glbCASDistBluFor5 = 8.04672 -- 5 miles
glbCASDistBluFor1 = 1.6093 -- 1 mile
glbCASDistBluForAuto = 01212015 -- special value for auto search

-- CAS target search circle radius ahead of target (second) waypoint
--glbCASSearchRadius = 12.07008 -- 7.5 miles
glbCASSearchRadius = 8.0467 -- 5 miles

-- Table to store CAS automatic search circle distances ahead of Client/Player for aircraft
tblCASDistBluForAuto = {glbCASDistBluFor1, glbCASSearchRadius*2, glbCASSearchRadius*4, glbCASSearchRadius*6, glbCASSearchRadius*8}

-- Table to store CAS automatic search circle distances ahead of Client/Player for helicopters
tblCASHeloDistBluForAuto = {glbCASDistBluFor1, glbCASSearchRadius*2, glbCASSearchRadius*4}

tblCASHeloTypesBluFor = {"AH-1W", "AH-64D_BLK_II", "Ka-50", "Mi-8MT", "Mi-24P", "Mi-28N", "SA342L", "UH-1H"}

-- added distance ahead of target (second) waypoint for CAS search circle 
glbCASWP2buff = 1.609344 -- 1 miles
--glbCASWP2buff = 4.02335 -- 2.5 miles
--glbCASWP2buff = 8.0467 -- 5 miles

-- High/Medium/Low pre-set aircraft altitudes in meters, for first (CAP and CAS) and second (CAP only) waypoint
glbHiAltBluFor = 8000 -- ~26,200 feet
glbMedAltBluFor = 3000 -- ~9,800 feet
glbLowAltBluFor = 1000 -- ~3,300 feet

-- Minimum altitude for CAS aircraft (for second waypoint) to help avoid SHORAD defences
glbMedHiAltBluFor = 4500 -- ~14,700 feet

-- Preset speeds (meters per second) for aircraft and helos, and alt (meters) for helos
glbHeloSpeedBluFor = 27 -- ~60 mph
glbHeloAltBluFor = 150 -- ~500 feet
glbACSpeedBluFor = 179 -- ~400 mph

-- Added buffer for distance behind and above Client aircraft for spawning AI BluFor aircraft
glbBufferBluFor = 50
glbBufferAltBluFor = 25

glbFlgSPBluFor = 0

glbWeaponTypeAuto = 9663676414
glbWeaponTypeGuided = 268402702
glbWeaponTypeUnguided = 805339120
glbWeaponType = glbWeaponTypeAuto

glbTblBluForSpawned = {}
glbBluForSpawned = 0

--[[
############################################################################################
Function:	AddRadioCommandsBluFor
Purpose:	Adds F10 radio menu items to spawn BluFor aircraft
Parameters:	pUnitName - Initiator unit name
			pPlayerName - Initiator player name
			pEnterUnit = Entered unit flag (true, false)
Returns:	nothing
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]
function AddRadioCommandsBluFor(pUnitName, pPlayerName, pEnterUnit)
	if (debugFlgBluFor == 2) then
		trigger.action.outText("DEBUG: Unit Name=" .. pUnitName, 5)
	end
	local lUnit = Unit.getByName(pUnitName)
	if (lUnit == nil) then
		return
	end
	
	local lUid = lUnit:getID()
	local lGid = GetGroupIDbyUnitIDBluFor(lUnit:getID())
	local lCid = GetCoalitionbyUnitIDBluFor(lUnit:getID())
	
	local lSkill = "Random"
	local lCurSkl = "Random"
	local lSelRnd = " "
	local lSelRk = " "
	local lSelT = " "
	local lSelV = " "
	local lSelA = " "
	
	local lAAlt = "Co-Alt+"
	local lCurAAlt = "Co-Alt+"
	local lSelARndA = " "
	local lSelALowA = " "
	local lSelAMedA = " "
	local lSelAHighA = " "
		
	local lDir = "12oc"
	local lCurDir = "12oc"
		
	if (debugFlgBluFor == 2) then
		trigger.action.outText("AddRadioCommandsBluFor: player name = " .. pPlayerName .. "lUnit:getID (lGid) =" .. lGid .. ", lUnit:getTypeName = " .. lUnit:getTypeName() ..
			", aircraft coalition: " .. lCid, 20)
	end
	
	lSkill = glbDefSkillBluFor
	lCurSkl = glbDefSkillBluFor
	if (debugFlgBluFor == 2) then
		trigger.action.outText("AddRadioCommandsBluFor: #tblPlayerListBluFor = " .. #tblPlayerListBluFor, 20)
	end
	for i=1, #tblPlayerListBluFor do
		if (debugFlgBluFor == 2) then
			trigger.action.outText("AddRadioCommandsBluFor: tblPlayerListBluFor[" .. i .. "].pName = " .. tblPlayerListBluFor[i].pName .. ", pPlayerName =" .. pPlayerName, 20)
		end
		if (tblPlayerListBluFor[i].pName == pPlayerName) then
			lSkill = tblPlayerListBluFor[i].optSkl
			lCurSkl = tblPlayerListBluFor[i].optCurSkl
			if (debugFlgBluFor == 2) then
				trigger.action.outText("AddRadioCommandsBluFor: tblPlayerListBluFor[" .. i .. "].optSkl = " .. tblPlayerListBluFor[i].optSkl .. "tblPlayerListBluFor[" .. i .. "].optCurSkl =" .. 
					tblPlayerListBluFor[i].optCurSkl, 20)
			end
			break
		end
	end
	
	-- Set indicator for which skill option is currently selected for this unit/player
	if (lCurSkl == "Random") then
		lSelRnd = "*"
	elseif (lCurSkl == "Rookie") then
		lSelRk = "*"
	elseif (lCurSkl == "Trained") then
		lSelT = "*"
	elseif (lCurSkl == "Veteran") then
		lSelV = "*"
	elseif (lCurSkl == "Ace") then
		lSelA = "*"
	end
	if (debugFlgBluFor == 2) then
		trigger.action.outText("lSelRnd=" .. lSelRnd .. ", lSelRk=" .. lSelRk .. ", lSelT=" .. lSelT .. ", lSelV=" .. lSelV .. ", lSelA=" .. lSelA, 20)
	end

	lAAlt = glbDefAAltBluFor
	lCurAAlt = glbDefAAltBluFor	
	if (debugFlgBluFor == 2) then
		trigger.action.outText("AddRadioCommandsBluFor: #tblPlayerListBluFor = " .. #tblPlayerListBluFor, 20)
	end
	for i=1, #tblPlayerListBluFor do
		if (debugFlgBluFor == 2) then
			trigger.action.outText("AddRadioCommandsBluFor: tblPlayerListBluFor[" .. i .. "].pName = " .. tblPlayerListBluFor[i].pName .. "pPlayerName =" .. pPlayerName, 20)
		end
		if (tblPlayerListBluFor[i].pName == pPlayerName) then
			lAAlt = tblPlayerListBluFor[i].optAAlt
			lCurAAlt = tblPlayerListBluFor[i].optCurAAlt
			if (debugFlgBluFor == 2) then
				trigger.action.outText("AddRadioCommandsBluFor: tblPlayerListBluFor[" .. i .. "].optAAlt = " .. tblPlayerListBluFor[i].optAAlt .. "tblPlayerListBluFor[" .. i .. "].optCurAAlt =" .. 
					tblPlayerListBluFor[i].optCurAAlt, 20)
			end
			break
		end
	end
	
	-- Set indicator for which aircraft starting altitude option is currently selected for this unit/player
	if (lCurAAlt == "Co-Alt+") then
		lSelARndA = "*"
	elseif (lCurAAlt == "Low") then
		lSelALowA = "*"
	elseif (lCurAAlt == "Medium") then
		lSelAMedA = "*"
	elseif (lCurAAlt == "High") then
		lSelAHighA = "*"
	end
	if (debugFlgBluFor == 2) then
		trigger.action.outText("lSelARndA=" .. lSelARndA .. ", lSelALowA=" .. lSelALowA .. ", lSelAMedA=" .. lSelAMedA .. ", lSelAHighA=" .. lSelAHighA, 20)
	end
	
	lDir = glbDefDirBluFor
	lCurDir = glbDefDirBluFor	
	if (debugFlgBluFor == 2) then
		trigger.action.outText("AddRadioCommandsBluFor: #tblPlayerListBluFor = " .. #tblPlayerListBluFor, 20)
	end
	for i=1, #tblPlayerListBluFor do
		if (debugFlgBluFor == 2) then
			trigger.action.outText("AddRadioCommandsBluFor: tblPlayerListBluFor[" .. i .. "].pName = " .. tblPlayerListBluFor[i].pName .. "pPlayerName =" .. pPlayerName, 20)
		end
		if (tblPlayerListBluFor[i].pName == pPlayerName) then
			lDir = tblPlayerListBluFor[i].optDir
			lCurDir = tblPlayerListBluFor[i].optCurDir
			if (debugFlgBluFor == 2) then
				trigger.action.outText("AddRadioCommandsBluFor: tblPlayerListBluFor[" .. i .. "].optDir = " .. tblPlayerListBluFor[i].optDir .. "tblPlayerListBluFor[" .. i .. "].optCurDir =" .. 
					tblPlayerListBluFor[i].optCurDir, 20)
			end
			break
		end
	end
	
	local ofacOmenuID = {}
	local ofacFmenuID = {}
	local ofacAmenuID = {}
	local ofacHmenuID = {}
	local ofacVFmenuID = {}
	local ofacVAmenuID = {}
	local ofacWFmenuID = {}

	local playerFound = False
	if (lGid ~= nil) then
		for i=1, #tblPlayerListBluFor do
			if (tblPlayerListBluFor[i].pName == pPlayerName) then
				tblPlayerListBluFor[i].rMenuID = missionCommands.addSubMenuForGroup(lGid, glbOfacTopMenuBluFor)
				ofacOmenuID = missionCommands.addSubMenuForGroup(lGid, "Options", tblPlayerListBluFor[i].rMenuID)
				ofacFmenuID = missionCommands.addSubMenuForGroup(lGid, "CAP Fighters", tblPlayerListBluFor[i].rMenuID)
				ofacAmenuID = missionCommands.addSubMenuForGroup(lGid, "CAS/SEAD/Anti-Ship Aircraft", tblPlayerListBluFor[i].rMenuID)
				ofacHmenuID = missionCommands.addSubMenuForGroup(lGid, "CAS Helicopters", tblPlayerListBluFor[i].rMenuID)
				ofacVFmenuID = missionCommands.addSubMenuForGroup(lGid, "CAP Vietnam/70's Era Fighters", tblPlayerListBluFor[i].rMenuID)
				ofacVAmenuID = missionCommands.addSubMenuForGroup(lGid, "CAS/SEAD Vietnam/70's Era Aircraft", tblPlayerListBluFor[i].rMenuID)
				ofacWFmenuID = missionCommands.addSubMenuForGroup(lGid, "CAP WW2 & Korea Era Fighters", tblPlayerListBluFor[i].rMenuID)			
				playerFound = true
				break
			end
		end
		
		if (playerFound == true) then
		
		-- Global options
		local ofacSSkill = missionCommands.addSubMenuForGroup(lGid, "Set AI Aircraft Pilot Skill", ofacOmenuID)
		local ofacSRand = missionCommands.addCommandForGroup(lGid, lSelRnd .. " Random (default)", ofacSSkill, SetSkillBluFor, lUid, pUnitName, pPlayerName, "Random")
		local ofacSRook = missionCommands.addCommandForGroup(lGid, lSelRk .. " Rookie", ofacSSkill, SetSkillBluFor, lUid, pUnitName, pPlayerName, "Rookie")
		local ofacSTrn = missionCommands.addCommandForGroup(lGid, lSelT .. " Trained", ofacSSkill, SetSkillBluFor, lUid, pUnitName, pPlayerName, "Trained")
		local ofacSVet = missionCommands.addCommandForGroup(lGid, lSelV .. " Veteran", ofacSSkill, SetSkillBluFor, lUid, pUnitName, pPlayerName, "Veteran")
		local ofacSAce = missionCommands.addCommandForGroup(lGid, lSelA .. " Ace", ofacSSkill, SetSkillBluFor, lUid, pUnitName, pPlayerName, "Ace")

		local ofacSAAlt = missionCommands.addSubMenuForGroup(lGid, "Set AI Aircraft Starting Altitude AGL", ofacOmenuID)
		local ofacSARand = missionCommands.addCommandForGroup(lGid, lSelARndA .. " Co-Alt+ (default)", ofacSAAlt, SetAltBluFor, lUid, pUnitName, pPlayerName, "AC", "Co-Alt+")
		local ofacSALow = missionCommands.addCommandForGroup(lGid, lSelALowA .. " Low", ofacSAAlt, SetAltBluFor, lUid, pUnitName, pPlayerName, "AC", "Low")
		local ofacSAMed = missionCommands.addCommandForGroup(lGid, lSelAMedA .. " Medium", ofacSAAlt, SetAltBluFor, lUid, pUnitName, pPlayerName, "AC", "Medium")
		local ofacSAHigh = missionCommands.addCommandForGroup(lGid, lSelAHighA .. " High", ofacSAAlt, SetAltBluFor, lUid, pUnitName, pPlayerName, "AC", "High")

		
		-- Red Player/Client coalition BluFor aircraft options
		if (lCid == coalition.side.RED) then

			-- AI fighter options
			
			-- J-11A options
			local ofacFmID_J11 = missionCommands.addSubMenuForGroup(lGid, "J-11A", ofacFmenuID)
			local tblofacFmID_J11 = {}
			tblofacFmID_J11[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles w/ECM", ofacFmID_J11)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_J11[1], CallSpawnBluForACGroup, pUnitName, country.id.CHINA, "J-11A", i, lSkill, lAAlt, lDir, "BVR_LRE", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_J11[2] = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles", ofacFmID_J11)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_J11[2], CallSpawnBluForACGroup, pUnitName, country.id.CHINA, "J-11A", i, lSkill, lAAlt, lDir, "BVR_LR", glbCAPDistBluFor, "CAP")
			end

			-- JF-17 options
			local ofacRFmID_JF17 = missionCommands.addSubMenuForGroup(lGid, "JF-17", ofacFmenuID)
			local tblofacRFmID_JF17B = {}
			tblofacRFmID_JF17B[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles", ofacRFmID_JF17)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacRFmID_JF17B[1], CallSpawnBluForACGroup, pUnitName, country.id.CHINA, "JF-17", i, lSkill, lAAlt, lDir, "BVR", glbCAPDistBluFor, "CAP")
			end
			tblofacRFmID_JF17B[2] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles", ofacRFmID_JF17)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacRFmID_JF17B[2], CallSpawnBluForACGroup, pUnitName, country.id.CHINA, "JF-17", i, lSkill, lAAlt, lDir, "ACM_IR", glbCAPDistBluFor, "CAP")
			end

			-- M-2000C options
			local ofacRFmID_M2K = missionCommands.addSubMenuForGroup(lGid, "M-2000C", ofacFmenuID)
			local tblofacRFmID_M2K = {}
			tblofacRFmID_M2K[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles", ofacRFmID_M2K)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacRFmID_M2K[1], CallSpawnBluForACGroup, pUnitName, country.id.CJTF_RED, "M-2000C", i, lSkill, lAAlt, lDir, "BVR", glbCAPDistBluFor, "CAP")
			end
			tblofacRFmID_M2K[2] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles", ofacRFmID_M2K)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacRFmID_M2K[2], CallSpawnBluForACGroup, pUnitName, country.id.CJTF_RED, "M-2000C", i, lSkill, lAAlt, lDir, "ACM_IR", glbCAPDistBluFor, "CAP")
			end
			
			-- MiG-29A/S options
			local ofacFmID_M29AS = missionCommands.addSubMenuForGroup(lGid, "MiG-29A/S", ofacFmenuID)
			local tblofacFmID_M29AS = {}
			tblofacFmID_M29AS[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles", ofacFmID_M29AS)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_M29AS[1], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "MiG-29S", i, lSkill, lAAlt, lDir, "BVR_LR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_M29AS[2] = missionCommands.addSubMenuForGroup(lGid, "BVR w/ER SARH Missiles", ofacFmID_M29AS)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_M29AS[2], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "MiG-29A", i, lSkill, lAAlt, lDir, "BVR_LR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_M29AS[3] = missionCommands.addSubMenuForGroup(lGid, "BVR w/R SARH Missiles", ofacFmID_M29AS)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_M29AS[3], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "MiG-29A", i, lSkill, lAAlt, lDir, "BVR_MR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_M29AS[4] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles", ofacFmID_M29AS)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_M29AS[4], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "MiG-29A", i, lSkill, lAAlt, lDir, "ACM_IR", glbCAPDistBluFor, "CAP")
			end
			
			-- MiG-31 options
			local ofacFmID_M31 = missionCommands.addSubMenuForGroup(lGid, "MiG-31", ofacFmenuID)
			local tblofacFmID_M31 = {}
			tblofacFmID_M31[1] = missionCommands.addSubMenuForGroup(lGid, "BVR", ofacFmID_M31)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_M31[1], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "MiG-31", i, lSkill, lAAlt, lDir, "BVR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_M31[2] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles", ofacFmID_M31)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_M31[2], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "MiG-31", i, lSkill, lAAlt, lDir, "ACM_IR", glbCAPDistBluFor, "CAP")
			end
				
			-- Su-27 options
			local ofacFmID_S27 = missionCommands.addSubMenuForGroup(lGid, "Su-27", ofacFmenuID)
			local tblofacFmID_S27 = {}
			tblofacFmID_S27[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/ER SARH Missiles", ofacFmID_S27)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_S27[1], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-27", i, lSkill, lAAlt, lDir, "BVR_LR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_S27[2] = missionCommands.addSubMenuForGroup(lGid, "BVR w/R SARH Missiles", ofacFmID_S27)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_S27[2], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-27", i, lSkill, lAAlt, lDir, "BVR_MR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_S27[3] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles", ofacFmID_S27)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_S27[3], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-27", i, lSkill, lAAlt, lDir, "ACM_IR", glbCAPDistBluFor, "CAP")
			end

			-- Su-30 options
			local ofacFmID_S30 = missionCommands.addSubMenuForGroup(lGid, "Su-30", ofacFmenuID)
			local tblofacFmID_S30 = {}
			tblofacFmID_S30[1] = missionCommands.addSubMenuForGroup(lGid, "BVR ARH Missiles w/ECM", ofacFmID_S30)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_S30[1], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-30", i, lSkill, lAAlt, lDir, "BVR_LRE", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_S30[2] = missionCommands.addSubMenuForGroup(lGid, "BVR ARH Missiles", ofacFmID_S30)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_S30[2], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-30", i, lSkill, lAAlt, lDir, "BVR_LR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_S30[3] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles", ofacFmID_S30)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_S30[3], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-30", i, lSkill, lAAlt, lDir, "ACM_IR", glbCAPDistBluFor, "CAP")
			end

			-- Su-33 options
			local ofacFmID_S33 = missionCommands.addSubMenuForGroup(lGid, "Su-33", ofacFmenuID)
			local tblofacFmID_S33 = {}
			tblofacFmID_S33[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/ER SARH Missiles w/ECM", ofacFmID_S33)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_S33[1], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-33", i, lSkill, lAAlt, lDir, "BVR_LRE", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_S33[2] = missionCommands.addSubMenuForGroup(lGid, "BVR w/ER SARH Missiles", ofacFmID_S33)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_S33[2], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-33", i, lSkill, lAAlt, lDir, "BVR_LR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_S33[3] = missionCommands.addSubMenuForGroup(lGid, "BVR w/R SARH Missiles", ofacFmID_S33)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_S33[3], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-33", i, lSkill, lAAlt, lDir, "BVR_MR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_S33[4] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles", ofacFmID_S33)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_S33[4], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-33", i, lSkill, lAAlt, lDir, "ACM_IR", glbCAPDistBluFor, "CAP")
			end
			
			-- AI attacker and multi-role fighter options

			-- JF-17 multi-role options
			local ofacRFmID_JF17M = missionCommands.addSubMenuForGroup(lGid, "JF-17 (Anti-Ship/SEAD)", ofacAmenuID)
			local tblofacRAmID_JF17 = {}
			tblofacRAmID_JF17[1] = missionCommands.addSubMenuForGroup(lGid, "w/Anti-Ship Missiles", ofacRFmID_JF17M)
			local tblAmID_JF17A = {}
			tblAmID_JF17A[1] = missionCommands.addSubMenuForGroup(lGid, "Search ships for " .. tostring(math.ceil(glbCASDistBluFor10/1.609344)) .. "+ mi", tblofacRAmID_JF17[1])
			tblAmID_JF17A[2] = missionCommands.addSubMenuForGroup(lGid, "Search ships for " .. tostring(math.ceil(glbCASDistBluFor20/1.609344)) .. "+ mi", tblofacRAmID_JF17[1])
			tblAmID_JF17A[3] = missionCommands.addSubMenuForGroup(lGid, "Search ships for " .. tostring(math.ceil(glbCASDistBluFor30/1.609344)) .. "+ mi", tblofacRAmID_JF17[1])
			tblAmID_JF17A[4] = missionCommands.addSubMenuForGroup(lGid, "Search ships for " .. tostring(math.ceil(glbCASDistBluFor40/1.609344)) .. "+ mi", tblofacRAmID_JF17[1])
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_JF17A[1], CallSpawnBluForACGroup, pUnitName, country.id.CHINA, "JF-17", i, lSkill, lAAlt, lDir, "ANTISHIP", glbCASDistBluFor10, "AntiShip")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_JF17A[2], CallSpawnBluForACGroup, pUnitName, country.id.CHINA, "JF-17", i, lSkill, lAAlt, lDir, "ANTISHIP", glbCASDistBluFor20, "AntiShip")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_JF17A[3], CallSpawnBluForACGroup, pUnitName, country.id.CHINA, "JF-17", i, lSkill, lAAlt, lDir, "ANTISHIP", glbCASDistBluFor30, "AntiShip")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_JF17A[4], CallSpawnBluForACGroup, pUnitName, country.id.CHINA, "JF-17", i, lSkill, lAAlt, lDir, "ANTISHIP", glbCASDistBluFor40, "AntiShip")
			end
			
			tblofacRAmID_JF17[2] = missionCommands.addSubMenuForGroup(lGid, "w/Anti-Radiation missiles (SEAD)", ofacRFmID_JF17M)
			local tblAmID_JF17S = {}
			tblAmID_JF17S[1] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs directly ahead", tblofacRAmID_JF17[2])
			tblAmID_JF17S[2] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor5/1.609344)) .. "+ mi", tblofacRAmID_JF17[2])
			tblAmID_JF17S[3] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor10/1.609344)) .. "+ mi", tblofacRAmID_JF17[2])
			tblAmID_JF17S[4] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor20/1.609344)) .. "+ mi", tblofacRAmID_JF17[2])
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_JF17S[1], CallSpawnBluForACGroup, pUnitName, country.id.CHINA, "JF-17", i, lSkill, lAAlt, lDir, "SEAD", glbCASDistBluFor1, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_JF17S[2], CallSpawnBluForACGroup, pUnitName, country.id.CHINA, "JF-17", i, lSkill, lAAlt, lDir, "SEAD", glbCASDistBluFor5, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_JF17S[3], CallSpawnBluForACGroup, pUnitName, country.id.CHINA, "JF-17", i, lSkill, lAAlt, lDir, "SEAD", glbCASDistBluFor10, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_JF17S[4], CallSpawnBluForACGroup, pUnitName, country.id.CHINA, "JF-17", i, lSkill, lAAlt, lDir, "SEAD", glbCASDistBluFor20, "SEAD")
			end

			-- Su-25A options
			local AmID_S25 = missionCommands.addSubMenuForGroup(lGid, "Su-25 (CAS)", ofacAmenuID)
			local tblAmID_S25 = {}
			tblAmID_S25[1] = missionCommands.addSubMenuForGroup(lGid, "w/GP Bombs, Rockets", AmID_S25)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_S25[1], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-25", i, lSkill, lAAlt, lDir, "GPBOMB_RKT", glbCASDistBluForAuto, "CAS")
			end
			
			tblAmID_S25[2] = missionCommands.addSubMenuForGroup(lGid, "w/Air-to-Ground missiles", AmID_S25)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_S25[2], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-25", i, lSkill, lAAlt, lDir, "AGM", glbCASDistBluForAuto, "CAS")
			end
			
			-- Su-25T options
			AmID_S25T = missionCommands.addSubMenuForGroup(lGid, "Su-25T (CAS/SEAD)", ofacAmenuID)
			local tblAmID_S25T = {}
			tblAmID_S25T[1] = missionCommands.addSubMenuForGroup(lGid, "w/Air-to-Ground missiles (CAS)", AmID_S25T)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_S25T[1], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-25T", i, lSkill, lAAlt, lDir, "AGM", glbCASDistBluForAuto, "CAS")
			end
			
			tblAmID_S25T[2] = missionCommands.addSubMenuForGroup(lGid, "w/Anti-Radiation missiles (SEAD)", AmID_S25T)
			local tblAmID_S25TBAS = {}
			tblAmID_S25TBAS[1] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs directly ahead", tblAmID_S25T[2])
			tblAmID_S25TBAS[2] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor5/1.609344)) .. "+ mi", tblAmID_S25T[2])
			tblAmID_S25TBAS[3] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor10/1.609344)) .. "+ mi", tblAmID_S25T[2])
			tblAmID_S25TBAS[4] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor20/1.609344)) .. "+ mi", tblAmID_S25T[2])
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_S25TBAS[1], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-25T", i, lSkill, lAAlt, lDir, "SEAD", glbCASDistBluFor1, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_S25TBAS[2], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-25T", i, lSkill, lAAlt, lDir, "SEAD", glbCASDistBluFor5, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_S25TBAS[3], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-25T", i, lSkill, lAAlt, lDir, "SEAD", glbCASDistBluFor10, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_S25TBAS[4], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-25T", i, lSkill, lAAlt, lDir, "SEAD", glbCASDistBluFor20, "SEAD")
			end

			-- Su-34 options
			local AmID_S34 = missionCommands.addSubMenuForGroup(lGid, "Su-34 (Anti-Ship/CAS/SEAD/)", ofacAmenuID)
			local tblAmID_S34 = {}
			tblAmID_S34[1] = missionCommands.addSubMenuForGroup(lGid, "w/Anti-Ship Missiles", AmID_S34)
			local tblAmID_S34BS = {}
			tblAmID_S34BS[1] = missionCommands.addSubMenuForGroup(lGid, "Search ships for " .. tostring(math.ceil(glbCASDistBluFor10/1.609344)) .. "+ mi", tblAmID_S34[1])
			tblAmID_S34BS[2] = missionCommands.addSubMenuForGroup(lGid, "Search ships for " .. tostring(math.ceil(glbCASDistBluFor20/1.609344)) .. "+ mi", tblAmID_S34[1])
			tblAmID_S34BS[3] = missionCommands.addSubMenuForGroup(lGid, "Search ships for " .. tostring(math.ceil(glbCASDistBluFor30/1.609344)) .. "+ mi", tblAmID_S34[1])
			tblAmID_S34BS[4] = missionCommands.addSubMenuForGroup(lGid, "Search ships for " .. tostring(math.ceil(glbCASDistBluFor40/1.609344)) .. "+ mi", tblAmID_S34[1])
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_S34BS[1], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-34", i, lSkill, lAAlt, lDir, "ANTISHIP", glbCASDistBluFor10, "AntiShip")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_S34BS[2], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-34", i, lSkill, lAAlt, lDir, "ANTISHIP", glbCASDistBluFor20, "AntiShip")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_S34BS[3], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-34", i, lSkill, lAAlt, lDir, "ANTISHIP", glbCASDistBluFor30, "AntiShip")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_S34BS[4], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-34", i, lSkill, lAAlt, lDir, "ANTISHIP", glbCASDistBluFor40, "AntiShip")
			end
			
			tblAmID_S34[2] = missionCommands.addSubMenuForGroup(lGid, "w/Air-to-Ground missiles (CAS)", AmID_S34)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_S34[2], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-34", i, lSkill, lAAlt, lDir, "AGM", glbCASDistBluForAuto, "CAS")
			end
			
			tblAmID_S34[3] = missionCommands.addSubMenuForGroup(lGid, "w/Anti-Radiation missiles (SEAD)", AmID_S34)
			local tblAmID_S34BR = {}
			tblAmID_S34BR[1] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs directly ahead", tblAmID_S34[3])
			tblAmID_S34BR[2] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor5/1.609344)) .. "+ mi", tblAmID_S34[3])
			tblAmID_S34BR[3] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor10/1.609344)) .. "+ mi", tblAmID_S34[3])
			tblAmID_S34BR[4] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor20/1.609344)) .. "+ mi", tblAmID_S34[3])
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_S34BR[1], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-34", i, lSkill, lAAlt, lDir, "SEAD", glbCASDistBluFor1, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_S34BR[2], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-34", i, lSkill, lAAlt, lDir, "SEAD", glbCASDistBluFor5, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_S34BR[3], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-34", i, lSkill, lAAlt, lDir, "SEAD", glbCASDistBluFor10, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_S34BR[4], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-34", i, lSkill, lAAlt, lDir, "SEAD", glbCASDistBluFor20, "SEAD")
			end
			
			
			-- AI helicopter CAS options

			-- Ka-50 options
			local HmID_K50 = missionCommands.addSubMenuForGroup(lGid, "Ka-50", ofacHmenuID)
			local HmID_K50A = missionCommands.addSubMenuForGroup(lGid, "w/Air-to-Ground missiles", HmID_K50)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", HmID_K50A, CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Ka-50", i, lSkill, lAAlt, lDir, "AGM", glbCASDistBluForAuto, "CAS")
			end

			-- Mi-8MT options
			local HmID_M8 = missionCommands.addSubMenuForGroup(lGid, "Mi-8MT", ofacHmenuID)
			local HmID_M8A = missionCommands.addSubMenuForGroup(lGid, "w/Rockets", HmID_M8)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", HmID_M8A, CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Mi-8MT", i, lSkill, lAAlt, lDir, "RKT", glbCASDistBluForAuto, "CAS")
			end
			
			-- Mi-24P options
			local HmID_M24 = missionCommands.addSubMenuForGroup(lGid, "Mi-24P", ofacHmenuID)
			local tblHmID_M24 = {}
			tblHmID_M24[1] = missionCommands.addSubMenuForGroup(lGid, "w/Air-to-Ground Missiles, Rockets, AAM", HmID_M24)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblHmID_M24[1], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Mi-24P", i, lSkill, lAAlt, lDir, "AGM_RKT_IR", glbCASDistBluForAuto, "CAS")
			end
			
			tblHmID_M24[2] = missionCommands.addSubMenuForGroup(lGid, "w/Air-to-Ground missiles, Rockets", HmID_M24)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblHmID_M24[2], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Mi-24P", i, lSkill, lAAlt, lDir, "AGM_RKT", glbCASDistBluForAuto, "CAS")
			end
		
			-- Mi-28N options
			local HmID_M28 = missionCommands.addSubMenuForGroup(lGid, "Mi-28N", ofacHmenuID)
			HmID_M28A = missionCommands.addSubMenuForGroup(lGid, "w/Air-to-Ground missiles, Rockets", HmID_M28)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", HmID_M28A, CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Mi-28N", i, lSkill, lAAlt, lDir, "AGM_RKT", glbCASDistBluForAuto, "CAS")
			end

			-- AI Vietnam/70's era aircraft CAP options
			
			-- F-5E-3 options
			local ofacRFmID_F5 = missionCommands.addSubMenuForGroup(lGid, "F-5E-3", ofacVFmenuID)
			local ofacRFmID_F5AI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles", ofacRFmID_F5)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", ofacRFmID_F5AI, CallSpawnBluForACGroup, pUnitName, country.id.CJTF_RED, "F-5E-3", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbCAPDistBluFor, "CAP")
			end
			local ofacRFmID_F5AIR = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles", ofacRFmID_F5)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", ofacRFmID_F5AIR, CallSpawnBluForACGroup, pUnitName, country.id.CJTF_RED, "F-5E-3", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbCAPDistBluFor, "CAP")
			end
			
			-- F-14A-135-GR options
			local ofacRFmID_F14 = missionCommands.addSubMenuForGroup(lGid, "F-14A-135-GR", ofacVFmenuID)
			local tblofacRFmID_F14 = {}
			tblofacRFmID_F14[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles", ofacRFmID_F14)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacRFmID_F14[1], CallSpawnBluForACGroup, pUnitName, country.id.CJTF_RED, "F-14A-135-GR", i, lSkill, lAAlt, lDir, "BVR_LR", glbCAPDistBluFor, "CAP")
			end
			tblofacRFmID_F14[2] = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles", ofacRFmID_F14)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacRFmID_F14[2], CallSpawnBluForACGroup, pUnitName, country.id.CJTF_RED, "F-14A-135-GR", i, lSkill, lAAlt, lDir, "BVR_MR", glbCAPDistBluFor, "CAP")
			end
			tblofacRFmID_F14[3] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles", ofacRFmID_F14)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacRFmID_F14[3], CallSpawnBluForACGroup, pUnitName, country.id.CJTF_RED, "F-14A-135-GR", i, lSkill, lAAlt, lDir, "ACM_IR", glbCAPDistBluFor, "CAP")
			end
			
			-- MiG-19P options
			local ofacFmID_M19 = missionCommands.addSubMenuForGroup(lGid, "MiG-19P", ofacVFmenuID)
			local ofacFmID_M19AI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles", ofacFmID_M19)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", ofacFmID_M19AI, CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "MiG-19P", i, lSkill, lAAlt, lDir, "ACM_IR", glbCAPDistBluFor, "CAP")
			end
					
			-- MiG-21Bis options
			local ofacFmID_M21 = missionCommands.addSubMenuForGroup(lGid, "MiG-21Bis", ofacVFmenuID)
			local tblofacFmID_M21 = {}
			tblofacFmID_M21[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles", ofacFmID_M21)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_M21[1], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "MiG-21Bis", i, lSkill, lAAlt, lDir, "BVR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_M21[2] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles)", ofacFmID_M21)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_M21[2], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "MiG-21Bis", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_M21[3] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles)", ofacFmID_M21)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_M21[3], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "MiG-21Bis", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbCAPDistBluFor, "CAP")
			end
								
			-- MiG-23MLD options
			local ofacFmID_M23 = missionCommands.addSubMenuForGroup(lGid, "MiG-23MLD", ofacVFmenuID)
			local tblofacFmID_M23 = {}
			tblofacFmID_M23[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles", ofacFmID_M23)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_M23[1], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "MiG-23MLD", i, lSkill, lAAlt, lDir, "BVR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_M23[2] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles", ofacFmID_M23)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_M23[2], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "MiG-23MLD", i, lSkill, lAAlt, lDir, "ACM_IR", glbCAPDistBluFor, "CAP")
			end
			
			-- Mirage-F1CE options
			local ofacRFmID_F1 = missionCommands.addSubMenuForGroup(lGid, "Mirage-F1CE", ofacVFmenuID)
			local tblofacRFmID_F1 = {}
			tblofacRFmID_F1[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles", ofacRFmID_F1)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacRFmID_F1[1], CallSpawnBluForACGroup, pUnitName, country.id.CJTF_RED, "Mirage-F1CE", i, lSkill, lAAlt, lDir, "BVR", glbCAPDistBluFor, "CAP")
			end
			tblofacRFmID_F1[2] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles", ofacRFmID_F1)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacRFmID_F1[2], CallSpawnBluForACGroup, pUnitName, country.id.CJTF_RED, "Mirage-F1CE", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbCAPDistBluFor, "CAP")
			end
			tblofacRFmID_F1[3] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles", ofacRFmID_F1)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacRFmID_F1[3], CallSpawnBluForACGroup, pUnitName, country.id.CJTF_RED, "Mirage-F1CE", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbCAPDistBluFor, "CAP")
			end

			-- AI Vietnam/70's era aircraft CAS options

			-- Su-17M4 options
			local AmID_S17 = missionCommands.addSubMenuForGroup(lGid, "Su-17M4", ofacVAmenuID)
			local tblAmID_S17 = {}
			tblAmID_S17[1] = missionCommands.addSubMenuForGroup(lGid, "w/GP Bombs", AmID_S17)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_S17[1], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-17M4", i, lSkill, lAAlt, lDir, "GPBOMB", glbCASDistBluForAuto, "CAS")
			end
			
			tblAmID_S17[2] = missionCommands.addSubMenuForGroup(lGid, "w/Air-to-Ground Missiles", AmID_S17)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_S17[2], CallSpawnBluForACGroup, pUnitName, country.id.RUSSIA, "Su-17M4", i, lSkill, lAAlt, lDir, "AGM", glbCASDistBluFor20, "CAS")
			end
			
			-- AI WWII and Korea era fighter options

			-- Bf-109K-4 options
			local ofacWFmID_B109 = missionCommands.addSubMenuForGroup(lGid, "Bf-109K-4", ofacWFmenuID)
			local ofacWFmID_B109A = missionCommands.addSubMenuForGroup(lGid, "ACM", ofacWFmID_B109)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", ofacWFmID_B109A, CallSpawnBluForACGroup, pUnitName, country.id.CJTF_RED, "Bf-109K-4", i, lSkill, lAAlt, lDir, "ACM", glbWW2DistBluFor, "CAP")
			end

			-- FW-190A8 options
			local ofacWFmID_B190 = missionCommands.addSubMenuForGroup(lGid, "FW-190A8", ofacWFmenuID)
			local ofacWFmID_B190A = missionCommands.addSubMenuForGroup(lGid, "ACM", ofacWFmID_B190)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", ofacWFmID_B190A, CallSpawnBluForACGroup, pUnitName, country.id.CJTF_RED, "FW-190A8", i, lSkill, lAAlt, lDir, "ACM", glbWW2DistBluFor, "CAP")
			end

			-- FW-190D9 options
			local ofacWFmID_F190D = missionCommands.addSubMenuForGroup(lGid, "FW-190D9", ofacWFmenuID)
			local ofacWFmID_F190DA = missionCommands.addSubMenuForGroup(lGid, "ACM", ofacWFmID_F190D)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", ofacWFmID_F190DA, CallSpawnBluForACGroup, pUnitName, country.id.CJTF_RED, "FW-190D9", i, lSkill, lAAlt, lDir, "ACM", glbWW2DistBluFor, "CAP")
			end
			
			-- MiG-15bis options
			local ofacWFmID_M15 = missionCommands.addSubMenuForGroup(lGid, "MiG-15bis", ofacWFmenuID)
			local ofacWFmID_M15A = missionCommands.addSubMenuForGroup(lGid, "ACM", ofacWFmID_M15)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", ofacWFmID_M15A, CallSpawnBluForACGroup, pUnitName, country.id.NORTH_KOREA, "MiG-15bis", i, lSkill, lAAlt, lDir, "ACM", glbCAPDistBluFor, "CAP")
			end

			
		-- Blue Player/Client coalition BluFor aircraft options
		elseif (lCid == coalition.side.BLUE) then
		
			-- AI fighter options
			
			-- F-14B options
			local ofacFmID_F14B = missionCommands.addSubMenuForGroup(lGid, "F-14B", ofacFmenuID)
			local tblofacFmID_F14B = {}
			tblofacFmID_F14B[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles", ofacFmID_F14B)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_F14B[1], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-14B", i, lSkill, lAAlt, lDir, "BVR_LR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_F14B[2] = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles", ofacFmID_F14B)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_F14B[2], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-14B", i, lSkill, lAAlt, lDir, "BVR_MR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_F14B[3] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles", ofacFmID_F14B)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_F14B[3], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-14B", i, lSkill, lAAlt, lDir, "ACM_IR", glbCAPDistBluFor, "CAP")
			end
			
			-- F-15C options
			local ofacFmID_F15 = missionCommands.addSubMenuForGroup(lGid, "F-15C", ofacFmenuID)
			local tblofacFmID_F15 = {}
			tblofacFmID_F15[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles", ofacFmID_F15)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_F15[1], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-15C", i, lSkill, lAAlt, lDir, "BVR_LR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_F15[2] = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles", ofacFmID_F15)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_F15[2], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-15C", i, lSkill, lAAlt, lDir, "BVR_MR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_F15[3] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles", ofacFmID_F15)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_F15[3], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-15C", i, lSkill, lAAlt, lDir, "ACM_IR", glbCAPDistBluFor, "CAP")
			end
			
			-- F-16C_50 options
			local ofacFmID_F16 = missionCommands.addSubMenuForGroup(lGid, "F-16C_50", ofacFmenuID)
			local tblofacFmID_F16 = {}
			tblofacFmID_F16[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles", ofacFmID_F16)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_F16[1], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-16C_50", i, lSkill, lAAlt, lDir, "BVR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_F16[2] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR 9X Missiles", ofacFmID_F16)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_F16[2], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-16C_50", i, lSkill, lAAlt, lDir, "ACM_IRX", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_F16[3] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR 9M Missiles", ofacFmID_F16)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_F16[3], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-16C_50", i, lSkill, lAAlt, lDir, "ACM_IR", glbCAPDistBluFor, "CAP")
			end
			
			-- FA-18C_hornet options
			local ofacFmID_F18 = missionCommands.addSubMenuForGroup(lGid, "FA-18C_hornet", ofacFmenuID)
			local tblofacFmID_F18 = {}
			tblofacFmID_F18[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles", ofacFmID_F18)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_F18[1], CallSpawnBluForACGroup, pUnitName, country.id.USA, "FA-18C_hornet", i, lSkill, lAAlt, lDir, "BVR_LR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_F18[2] = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles", ofacFmID_F18)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_F18[2], CallSpawnBluForACGroup, pUnitName, country.id.USA, "FA-18C_hornet", i, lSkill, lAAlt, lDir, "BVR_MR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_F18[3] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles", ofacFmID_F18)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_F18[3], CallSpawnBluForACGroup, pUnitName, country.id.USA, "FA-18C_hornet", i, lSkill, lAAlt, lDir, "ACM_IR", glbCAPDistBluFor, "CAP")
			end
			
			-- JF-17 options
			local ofacBFmID_JF17 = missionCommands.addSubMenuForGroup(lGid, "JF-17", ofacFmenuID)
			local tblofacBFmID_JF17 = {}
			tblofacBFmID_JF17[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles", ofacBFmID_JF17)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacBFmID_JF17[1], CallSpawnBluForACGroup, pUnitName, country.id.CJTF_BLUE, "JF-17", i, lSkill, lAAlt, lDir, "BVR", glbCAPDistBluFor, "CAP")
			end
			tblofacBFmID_JF17[2] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles", ofacBFmID_JF17)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacBFmID_JF17[2], CallSpawnBluForACGroup, pUnitName, country.id.CJTF_BLUE, "JF-17", i, lSkill, lAAlt, lDir, "ACM_IR", glbCAPDistBluFor, "CAP")
			end
			
			-- M-2000C options
			local ofacBFmID_M2K = missionCommands.addSubMenuForGroup(lGid, "M-2000C", ofacFmenuID)
			local tblofacBFmID_M2K = {}
			tblofacBFmID_M2K[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles", ofacBFmID_M2K)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacBFmID_M2K[1], CallSpawnBluForACGroup, pUnitName, country.id.FRANCE, "M-2000C", i, lSkill, lAAlt, lDir, "BVR", glbCAPDistBluFor, "CAP")
			end
			tblofacBFmID_M2K[2] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles", ofacBFmID_M2K)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacBFmID_M2K[2], CallSpawnBluForACGroup, pUnitName, country.id.FRANCE, "M-2000C", i, lSkill, lAAlt, lDir, "ACM_IR", glbCAPDistBluFor, "CAP")
			end
						
			-- AI attacker and multi-role CAS/SEAD/Anti-Ship options

			-- A-10A options
			local AmID_A10A = missionCommands.addSubMenuForGroup(lGid, "A-10A (CAS)", ofacAmenuID)
			local AmID_A10ABAA = missionCommands.addSubMenuForGroup(lGid, "w/Air-to-Ground missiles", AmID_A10A)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", AmID_A10ABAA, CallSpawnBluForACGroup, pUnitName, country.id.USA, "A-10A", i, lSkill, lAAlt, lDir, "AGM", glbCASDistBluForAuto, "CAS")
			end
			
			-- A-10C_2 options
			local AmID_A10C = missionCommands.addSubMenuForGroup(lGid, "A-10C_2 (CAS)", ofacAmenuID)
			local tblAmID_A10C = {}
			tblAmID_A10C[1] = missionCommands.addSubMenuForGroup(lGid, "w/Air-to-Ground missiles", AmID_A10C)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_A10C[1], CallSpawnBluForACGroup, pUnitName, country.id.USA, "A-10C_2", i, lSkill, lAAlt, lDir, "AGM", glbCASDistBluForAuto, "CAS")
			end
			
			tblAmID_A10C[2] = missionCommands.addSubMenuForGroup(lGid, "w/Laser Guided Bombs", AmID_A10C)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_A10C[2], CallSpawnBluForACGroup, pUnitName, country.id.USA, "A-10C_2", i, lSkill, lAAlt, lDir, "LGB", glbCASDistBluForAuto, "CAS")
			end
			
			-- AJS37 options
			local AmID_A37 = missionCommands.addSubMenuForGroup(lGid, "AJS37 (CAS)", ofacAmenuID)
			local AmID_A37BAA = missionCommands.addSubMenuForGroup(lGid, "w/Air-to-Ground missiles", AmID_A37)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", AmID_A37BAA, CallSpawnBluForACGroup, pUnitName, country.id.USA, "AJS37", i, lSkill, lAAlt, lDir, "AGM", glbCASDistBluForAuto, "CAS")
			end

			
			-- AV8BNA options
			local AmID_A8 = missionCommands.addSubMenuForGroup(lGid, "AV8BNA (CAS)", ofacAmenuID)
			local AmID_A8BAA = missionCommands.addSubMenuForGroup(lGid, "w/Air-to-Ground missiles", AmID_A8)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", AmID_A8BAA, CallSpawnBluForACGroup, pUnitName, country.id.USA, "AV8BNA", i, lSkill, lAAlt, lDir, "AGM", glbCASDistBluForAuto, "CAS")
			end
			
			-- F-16C_50 multi-role options
			local AmID_F16 = missionCommands.addSubMenuForGroup(lGid, "F-16C_50 (CAS/SEAD)", ofacAmenuID)
			local tblAmID_F16B = {}
			tblAmID_F16B[1] = missionCommands.addSubMenuForGroup(lGid, "w/Air-to-Ground Missiles (CAS)", AmID_F16)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F16B[1], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-16C_50", i, lSkill, lAAlt, lDir, "AGM", glbCASDistBluForAuto, "CAS")
			end
			
			tblAmID_F16B[2] = missionCommands.addSubMenuForGroup(lGid, "w/Laser Guided Bombs (CAS)", AmID_F16)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F16B[2], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-16C_50", i, lSkill, lAAlt, lDir, "LGB", glbCASDistBluForAuto, "CAS")
			end
			
			tblAmID_F16B[3] = missionCommands.addSubMenuForGroup(lGid, "w/Anti-Radiation Missiles (SEAD)", AmID_F16)
			local tblAmID_F16BAS = {}
			tblAmID_F16BAS[1] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs directly ahead", tblAmID_F16B[3])
			tblAmID_F16BAS[2] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor5/1.609344)) .. "+ mi", tblAmID_F16B[3])
			tblAmID_F16BAS[3] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor10/1.609344)) .. "+ mi", tblAmID_F16B[3])
			tblAmID_F16BAS[4] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor20/1.609344)) .. "+ mi", tblAmID_F16B[3])
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F16BAS[1], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-16C_50", i, lSkill, lAAlt, lDir, "HARM", glbCASDistBluFor1, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F16BAS[2], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-16C_50", i, lSkill, lAAlt, lDir, "HARM", glbCASDistBluFor5, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F16BAS[3], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-16C_50", i, lSkill, lAAlt, lDir, "HARM", glbCASDistBluFor10, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F16BAS[4], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-16C_50", i, lSkill, lAAlt, lDir, "HARM", glbCASDistBluFor20, "SEAD")
			end

			-- FA-18C_hornet multi-role options
			local AmID_F18 = missionCommands.addSubMenuForGroup(lGid, "FA-18C_hornet (Anti-Ship/CAS/SEAD)", ofacAmenuID)
			local tblAmID_F18B = {}
			tblAmID_F18B[1] = missionCommands.addSubMenuForGroup(lGid, "w/Anti-Ship Missiles", AmID_F18)
			local tblAmID_F18BAS = {}
			tblAmID_F18BAS[1] = missionCommands.addSubMenuForGroup(lGid, "Search ships for " .. tostring(math.ceil(glbCASDistBluFor10/1.609344)) .. "+ mi", tblAmID_F18B[1])
			tblAmID_F18BAS[2] = missionCommands.addSubMenuForGroup(lGid, "Search ships for " .. tostring(math.ceil(glbCASDistBluFor20/1.609344)) .. "+ mi", tblAmID_F18B[1])
			tblAmID_F18BAS[3] = missionCommands.addSubMenuForGroup(lGid, "Search ships for " .. tostring(math.ceil(glbCASDistBluFor30/1.609344)) .. "+ mi", tblAmID_F18B[1])
			tblAmID_F18BAS[4] = missionCommands.addSubMenuForGroup(lGid, "Search ships for " .. tostring(math.ceil(glbCASDistBluFor40/1.609344)) .. "+ mi", tblAmID_F18B[1])
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F18BAS[1], CallSpawnBluForACGroup, pUnitName, country.id.USA, "FA-18C_hornet", i, lSkill, lAAlt, lDir, "HARPOON", glbCASDistBluFor10, "AntiShip")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F18BAS[2], CallSpawnBluForACGroup, pUnitName, country.id.USA, "FA-18C_hornet", i, lSkill, lAAlt, lDir, "HARPOON", glbCASDistBluFor20, "AntiShip")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F18BAS[3], CallSpawnBluForACGroup, pUnitName, country.id.USA, "FA-18C_hornet", i, lSkill, lAAlt, lDir, "HARPOON", glbCASDistBluFor30, "AntiShip")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F18BAS[4], CallSpawnBluForACGroup, pUnitName, country.id.USA, "FA-18C_hornet", i, lSkill, lAAlt, lDir, "HARPOON", glbCASDistBluFor40, "AntiShip")
			end
			tblAmID_F18B[2] = missionCommands.addSubMenuForGroup(lGid, "w/Air-to-Ground Missiles (CAS)", AmID_F18)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F18B[2], CallSpawnBluForACGroup, pUnitName, country.id.USA, "FA-18C_hornet", i, lSkill, lAAlt, lDir, "AGM", glbCASDistBluForAuto, "CAS")
			end
			
			tblAmID_F18B[3] = missionCommands.addSubMenuForGroup(lGid, "w/Laser Guided Bombs (CAS)", AmID_F18)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F18B[3], CallSpawnBluForACGroup, pUnitName, country.id.USA, "FA-18C_hornet", i, lSkill, lAAlt, lDir, "LGB", glbCASDistBluForAuto, "CAS")
			end
			
			tblAmID_F18B[4] = missionCommands.addSubMenuForGroup(lGid, "w/Anti-Radiation Missiles (SEAD)", AmID_F18)
			local tblAmID_F18BAR = {}
			tblAmID_F18BAR[1] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs directly ahead", tblAmID_F18B[4])
			tblAmID_F18BAR[2] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor5/1.609344)) .. "+ mi", tblAmID_F18B[4])
			tblAmID_F18BAR[3] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor10/1.609344)) .. "+ mi", tblAmID_F18B[4])
			tblAmID_F18BAR[4] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor20/1.609344)) .. "+ mi", tblAmID_F18B[4])
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F18BAR[1], CallSpawnBluForACGroup, pUnitName, country.id.USA, "FA-18C_hornet", i, lSkill, lAAlt, lDir, "HARM", glbCASDistBluFor1, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F18BAR[2], CallSpawnBluForACGroup, pUnitName, country.id.USA, "FA-18C_hornet", i, lSkill, lAAlt, lDir, "HARM", glbCASDistBluFor5, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F18BAR[3], CallSpawnBluForACGroup, pUnitName, country.id.USA, "FA-18C_hornet", i, lSkill, lAAlt, lDir, "HARM", glbCASDistBluFor10, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F18BAR[4], CallSpawnBluForACGroup, pUnitName, country.id.USA, "FA-18C_hornet", i, lSkill, lAAlt, lDir, "HARM", glbCASDistBluFor20, "SEAD")
			end
			

			
			-- AI helicopter CAS options

			-- AH-1W options
			local HmID_A1 = missionCommands.addSubMenuForGroup(lGid, "AH-1W", ofacHmenuID)
			local HmID_A1A = missionCommands.addSubMenuForGroup(lGid, "w/Air-to-Ground Missiles, Rockets", HmID_A1)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", HmID_A1A, CallSpawnBluForACGroup, pUnitName, country.id.USA, "AH-1W", i, lSkill, lAAlt, lDir, "AGM_RKT", glbCASDistBluForAuto, "CAS")
			end

			-- AH-64D_BLK_II options
			local HmID_A64 = missionCommands.addSubMenuForGroup(lGid, "AH-64D_BLK_II", ofacHmenuID)
			local HmID_A64A = missionCommands.addSubMenuForGroup(lGid, "w/Air-to-Ground Missiles, Rockets", HmID_A64)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", HmID_A64A, CallSpawnBluForACGroup, pUnitName, country.id.USA, "AH-64D_BLK_II", i, lSkill, lAAlt, lDir, "AGM_RKT", glbCASDistBluForAuto, "CAS")
			end

			-- OH58D options
			local HmID_OH58D = missionCommands.addSubMenuForGroup(lGid, "OH58D", ofacHmenuID)
			local HmID_OH58DA = missionCommands.addSubMenuForGroup(lGid, "w/Air-to-Ground Missiles, Gun", HmID_OH58D)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", HmID_OH58DA, CallSpawnBluForACGroup, pUnitName, country.id.USA, "OH58D", i, lSkill, lAAlt, lDir, "AGM_GUN", glbCASDistBluForAuto, "CAS")
			end

			-- SA342L options
			local HmID_S342L = missionCommands.addSubMenuForGroup(lGid, "SA342L", ofacHmenuID)
			local HmID_S342LA = missionCommands.addSubMenuForGroup(lGid, "w/Rockets", HmID_S342L)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", HmID_S342LA, CallSpawnBluForACGroup, pUnitName, country.id.USA, "SA342L", i, lSkill, lAAlt, lDir, "RKT", glbCASDistBluForAuto, "CAS")
			end

			-- UH-1H options
			local HmID_U1 = missionCommands.addSubMenuForGroup(lGid, "UH-1H", ofacHmenuID)
			local HmID_U1A = missionCommands.addSubMenuForGroup(lGid, "w/Rockets", HmID_U1)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", HmID_U1A, CallSpawnBluForACGroup, pUnitName, country.id.USA, "UH-1H", i, lSkill, lAAlt, lDir, "RKT", glbCASDistBluForAuto, "CAS")
			end


			-- AI Vietnam/70's era aircraft CAP options
			
			-- F-4E options
			local ofacFmID_F4 = missionCommands.addSubMenuForGroup(lGid, "F-4E-45MC", ofacVFmenuID)
			local tblofacFmID_F4B = {}
			tblofacFmID_F4B[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles", ofacFmID_F4)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_F4B[1], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "BVR", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_F4B[2] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles", ofacFmID_F4)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_F4B[2], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbCAPDistBluFor, "CAP")
			end
			tblofacFmID_F4B[3] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles", ofacFmID_F4)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacFmID_F4B[3], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbCAPDistBluFor, "CAP")
			end
			
			-- F-5E-3 options
			local ofacFmID_F5 = missionCommands.addSubMenuForGroup(lGid, "F-5E-3", ofacVFmenuID)
			local ofacFmID_F5BA = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles", ofacFmID_F5)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", ofacFmID_F5BA, CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-5E-3", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbCAPDistBluFor, "CAP")
			end
			local ofacFmID_F5BR = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles", ofacFmID_F5)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", ofacFmID_F5BR, CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-5E-3", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbCAPDistBluFor, "CAP")
			end
			
			-- F-14A-135-GR options
			local ofacBFmID_F14 = missionCommands.addSubMenuForGroup(lGid, "F-14A-135-GR", ofacVFmenuID)
			local tblofacBFmID_F14B = {}
			tblofacBFmID_F14B[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles", ofacBFmID_F14)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacBFmID_F14B[1], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-14A-135-GR", i, lSkill, lAAlt, lDir, "BVR_LR", glbCAPDistBluFor, "CAP")
			end
			tblofacBFmID_F14B[2] = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles", ofacBFmID_F14)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacBFmID_F14B[2], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-14A-135-GR", i, lSkill, lAAlt, lDir, "BVR_MR", glbCAPDistBluFor, "CAP")
			end
			tblofacBFmID_F14B[3] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles", ofacBFmID_F14)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacBFmID_F14B[3], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-14A-135-GR", i, lSkill, lAAlt, lDir, "ACM_IR", glbCAPDistBluFor, "CAP")
			end
			
			-- Mirage-F1CE options
			local ofacBFmID_F1 = missionCommands.addSubMenuForGroup(lGid, "Mirage-F1CE", ofacVFmenuID)
			local tblofacBFmID_F1 = {}
			tblofacBFmID_F1[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles", ofacBFmID_F1)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacBFmID_F1[1], CallSpawnBluForACGroup, pUnitName, country.id.FRANCE, "Mirage-F1CE", i, lSkill, lAAlt, lDir, "BVR", glbCAPDistBluFor, "CAP")
			end
			tblofacBFmID_F1[2] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles", ofacBFmID_F1)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacBFmID_F1[2], CallSpawnBluForACGroup, pUnitName, country.id.FRANCE, "Mirage-F1CE", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbCAPDistBluFor, "CAP")
			end
			tblofacBFmID_F1[3] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles", ofacBFmID_F1)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacBFmID_F1[3], CallSpawnBluForACGroup, pUnitName, country.id.FRANCE, "Mirage-F1CE", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbCAPDistBluFor, "CAP")
			end
			
			-- AI Vietnam/70's era aircraft CAS/SEAD options
			
			-- F-4E options
			local ofacAmID_F4 = missionCommands.addSubMenuForGroup(lGid, "F-4E-45MC (CAS/SEAD)", ofacVAmenuID)
			local tblofacAmID_F4B = {}
			tblofacAmID_F4B[1] = missionCommands.addSubMenuForGroup(lGid, "w/GP Bombs", ofacAmID_F4)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacAmID_F4B[1], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "GPBOMB", glbCASDistBluForAuto, "CAS")
			end			
			tblofacAmID_F4B[2] = missionCommands.addSubMenuForGroup(lGid, "w/GP Bombs, Rockets", ofacAmID_F4)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacAmID_F4B[2], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "GPBOMB_RKT", glbCASDistBluForAuto, "CAS")
			end	
			tblofacAmID_F4B[3] = missionCommands.addSubMenuForGroup(lGid, "w/TV Guided Bombs (AGM-62)", ofacAmID_F4)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacAmID_F4B[3], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "TV_AGM", glbCASDistBluForAuto, "CAS")
			end	
			tblofacAmID_F4B[4] = missionCommands.addSubMenuForGroup(lGid, "w/IR Mavericks (AGM-65)", ofacAmID_F4)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacAmID_F4B[4], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "IR_AGM", glbCASDistBluForAuto, "CAS")
			end	
			tblofacAmID_F4B[5] = missionCommands.addSubMenuForGroup(lGid, "w/AGM-45s (SEAD) Mk37 SA-2/3/5/8 SR", ofacAmID_F4)
			local tblAmID_F4BAS = {}
			tblAmID_F4BAS[1] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs directly ahead", tblofacAmID_F4B[5])
			tblAmID_F4BAS[2] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor5/1.609344)) .. "+ mi", tblofacAmID_F4B[5])
			tblAmID_F4BAS[3] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor10/1.609344)) .. "+ mi", tblofacAmID_F4B[5])
			tblAmID_F4BAS[4] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor20/1.609344)) .. "+ mi", tblofacAmID_F4B[5])
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F4BAS[1], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "SHRIKEMK37", glbCASDistBluFor1, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F4BAS[2], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "SHRIKEMK37", glbCASDistBluFor5, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F4BAS[3], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "SHRIKEMK37", glbCASDistBluFor10, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F4BAS[4], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "SHRIKEMK37", glbCASDistBluFor20, "SEAD")
			end
			tblofacAmID_F4B[6] = missionCommands.addSubMenuForGroup(lGid, "w/AGM-45s (SEAD) Mk49M1 SA-3/6/10/11 TR", ofacAmID_F4)
			local tblAmID_F4BAS = {}
			tblAmID_F4BAS[1] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs directly ahead", tblofacAmID_F4B[6])
			tblAmID_F4BAS[2] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor5/1.609344)) .. "+ mi", tblofacAmID_F4B[6])
			tblAmID_F4BAS[3] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor10/1.609344)) .. "+ mi", tblofacAmID_F4B[6])
			tblAmID_F4BAS[4] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor20/1.609344)) .. "+ mi", tblofacAmID_F4B[6])
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F4BAS[1], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "SHRIKEMK49", glbCASDistBluFor1, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F4BAS[2], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "SHRIKEMK49", glbCASDistBluFor5, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F4BAS[3], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "SHRIKEMK49", glbCASDistBluFor10, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F4BAS[4], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "SHRIKEMK49", glbCASDistBluFor20, "SEAD")
			end
			tblofacAmID_F4B[7] = missionCommands.addSubMenuForGroup(lGid, "w/AGM-45s (SEAD) Mk50 SA-10 SR SA-5/15/19 TR", ofacAmID_F4)
			local tblAmID_F4BAS = {}
			tblAmID_F4BAS[1] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs directly ahead", tblofacAmID_F4B[7])
			tblAmID_F4BAS[2] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor5/1.609344)) .. "+ mi", tblofacAmID_F4B[7])
			tblAmID_F4BAS[3] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor10/1.609344)) .. "+ mi", tblofacAmID_F4B[7])
			tblAmID_F4BAS[4] = missionCommands.addSubMenuForGroup(lGid, "Search radar SAMs for " .. tostring(math.ceil(glbCASDistBluFor20/1.609344)) .. "+ mi", tblofacAmID_F4B[7])
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F4BAS[1], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "SHRIKEMK50", glbCASDistBluFor1, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F4BAS[2], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "SHRIKEMK50", glbCASDistBluFor5, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F4BAS[3], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "SHRIKEMK50", glbCASDistBluFor10, "SEAD")
			end
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblAmID_F4BAS[4], CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "SHRIKEMK50", glbCASDistBluFor20, "SEAD")
			end
			
			-- F-5E-3 options
			local ofacBAmID_F5 = missionCommands.addSubMenuForGroup(lGid, "F-5E-3 (CAS)", ofacVAmenuID)
			local ofacBAmID_F5B = missionCommands.addSubMenuForGroup(lGid, "w/GP Bombs, Rockets", ofacBAmID_F5)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", ofacBAmID_F5B, CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-5E-3", i, lSkill, lAAlt, lDir, "GPBOMB_RKT", glbCASDistBluForAuto, "CAS")
			end

			-- Mirage-F1CE options
			local ofacBAmID_F1 = missionCommands.addSubMenuForGroup(lGid, "Mirage-F1CE (CAS)", ofacVAmenuID)
			local tblofacBAmID_F1 = {}
			tblofacBAmID_F1[1] = missionCommands.addSubMenuForGroup(lGid, "w/GP Bombs, Rockets", ofacBAmID_F1)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacBAmID_F1[1], CallSpawnBluForACGroup, pUnitName, country.id.FRANCE, "Mirage-F1CE", i, lSkill, lAAlt, lDir, "GPBOMB_RKT", glbCASDistBluForAuto, "CAS")
			end
			
			tblofacBAmID_F1[2] = missionCommands.addSubMenuForGroup(lGid, "w/Rockets", ofacBAmID_F1)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", tblofacBAmID_F1[2], CallSpawnBluForACGroup, pUnitName, country.id.FRANCE, "Mirage-F1CE", i, lSkill, lAAlt, lDir, "RKT", glbCASDistBluForAuto, "CAS")
			end
			
			-- AI WWII and Korea era fighter options

			-- F-86F Sabre options
			local ofacWFmID_F86 = missionCommands.addSubMenuForGroup(lGid, "F-86F Sabre", ofacWFmenuID)
			local ofacWFmID_F86A = missionCommands.addSubMenuForGroup(lGid, "ACM", ofacWFmID_F86)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", ofacWFmID_F86A, CallSpawnBluForACGroup, pUnitName, country.id.USA, "F-86F Sabre", i, lSkill, lAAlt, lDir, "ACM", glbWW2DistBluFor, "CAP")
			end

			-- I-16 options
			local ofacWFmID_I16 = missionCommands.addSubMenuForGroup(lGid, "I-16", ofacWFmenuID)
			local ofacWFmID_I16A = missionCommands.addSubMenuForGroup(lGid, "ACM", ofacWFmID_I16)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", ofacWFmID_I16A, CallSpawnBluForACGroup, pUnitName, country.id.CJTF_BLUE, "I-16", i, lSkill, lAAlt, lDir, "ACM", glbWW2DistBluFor, "CAP")
			end

			-- P-47D-40 options
			local ofacWFmID_P47 = missionCommands.addSubMenuForGroup(lGid, "P-47D-40", ofacWFmenuID)
			local ofacWFmID_P47A = missionCommands.addSubMenuForGroup(lGid, "ACM", ofacWFmID_P47)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", ofacWFmID_P47A, CallSpawnBluForACGroup, pUnitName, country.id.USA, "P-47D-40", i, lSkill, lAAlt, lDir, "ACM", glbWW2DistBluFor, "CAP")
			end

			-- P-51D-30-NA options
			local ofacWFmID_P51 = missionCommands.addSubMenuForGroup(lGid, "P-51D-30-NA", ofacWFmenuID)
			local ofacWFmID_P51A = missionCommands.addSubMenuForGroup(lGid, "ACM", ofacWFmID_P51)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", ofacWFmID_P51A, CallSpawnBluForACGroup, pUnitName, country.id.USA, "P-51D-30-NA", i, lSkill, lAAlt, lDir, "ACM", glbWW2DistBluFor, "CAP")
			end

			-- SpitfireLFMkIX options
			local ofacWFmID_Spit = missionCommands.addSubMenuForGroup(lGid, "SpitfireLFMkIX", ofacWFmenuID)
			local ofacWFmID_SpitA = missionCommands.addSubMenuForGroup(lGid, "ACM", ofacWFmID_Spit)
			for i=1, #tblOneToFourBluFor do
				missionCommands.addCommandForGroup(lGid, tblOneToFourBluFor[i] .. " aircraft", ofacWFmID_SpitA, CallSpawnBluForACGroup, pUnitName, country.id.UK, "SpitfireLFMkIX", i, lSkill, lAAlt, lDir, "ACM", glbWW2DistBluFor, "CAP")
			end
			
		end
		end
	end
	
end

--[[
############################################################################################
Function:	BuildClientUnitListBluFor
Purpose:	Build a table of client unit IDs with mapped group ID, unit type, unit name
			group name and coalition
Parameters:	None
Returns:	nothing
Author:		AKA_Relent
DCS ver:	1.5.4
############################################################################################
]]
function BuildClientUnitListBluFor()

	for coal_key, coal_data in pairs (env.mission.coalition) do
		if (((coal_key == "blue") or (coal_key == "red")) and type(coal_data) == "table") then
			if (coal_data.country) then --there is a country table
				for cntry_id, cntry_data in pairs(coal_data.country) do
					for obj_type_name, obj_type_data in pairs(cntry_data) do
						if ((type(obj_type_data) == "table") and obj_type_data.group and (type(obj_type_data.group) == "table") and
								(#obj_type_data.group > 0)) then  --there's a group!
							for group_num, group_data in pairs(obj_type_data.group) do
								for unit_num, unit_data in pairs(group_data.units) do
									if (unit_data.skill == "Client" or unit_data.skill == "Player") then
										table.insert(tblClientUnitBluFor, {uID = unit_data.unitId, gID = group_data.groupId,
											uTyp = unit_data.type, uNam = unit_data.name, gNam = group_data.name, coal = coal_key,
											uSkl = unit_data.skill, optSkl = glbDefSkillBluFor, optCurSkl = glbDefSkillBluFor,
											optAAlt = glbDefAAltBluFor, optCurAAlt = glbDefAAltBluFor})
										if (debugFlgBluFor == 2) then
											trigger.action.outText("BuildClientUnitListBluFor: uID = " .. unit_data.unitId .. ", gID = " .. 	group_data.groupId .. ", uTyp = " .. unit_data.type .. ", uNam = " .. unit_data.name .. ", gNam =  " .. group_data.name .. ", coal = " .. coal_key ..
											", uSkl = " .. unit_data.skill .. ", optSkl = " .. glbDefSkillBluFor .. ", optCurSkl = " .. glbDefSkillBluFor, 30)
										end
									end
								end
							end
						end
					end
				end
			end
		end
	end
end

do
	BuildClientUnitListBluFor()
end

--[[
############################################################################################
Function:	BuildExclZoneListBluFor
Purpose:	Build a table of exclusion zones where BluFor aircraft cannot spawn
Parameters:	None
Returns:	nothing
Author:		AKA_Relent
DCS ver:	1.5.4
############################################################################################
]]
function BuildExclZoneListBluFor()
	for i=1, #env.mission.triggers.zones do
		if (env.mission.triggers.zones[i].type == 0 and (string.find(env.mission.triggers.zones[i].name, "Blue Exclusion Zone") or
				string.find(env.mission.triggers.zones[i].name, "blue exclusion zone"))) then
			table.insert(tblExclZoneListBluFor, {name=env.mission.triggers.zones[i].name})
		end
	end
	
end

do
	BuildExclZoneListBluFor()
end

--[[
############################################################################################
Function:	CalcCurrentPointBluFor
Purpose:	calculate the position (point) and heading of unit
Parameters:	pUnitName - unit name
Returns:	point (table), heading (in radians)
Author:		AKA_Relent
DCS ver:	1.5.4
############################################################################################
]]
function CalcCurrentPointBluFor(pUnitName)
	lUnit = Unit.getByName(pUnitName)
	if (lUnit == nil) then
		return
	end
	local point = {x=lUnit:getPoint().x, z=lUnit:getPoint().z, y=lUnit:getPoint().y}
	--local headingRad = math.rad(math.atan2(lUnit:getPosition().x.z, lUnit:getPosition().x.x)+2*math.pi)
	local headingRad = math.atan2(lUnit:getPosition().x.z, lUnit:getPosition().x.x)
	if (headingRad < 0) then
		headingRad = headingRad + 2*math.pi
	end
	
	if (debugFlgBluFor == 2) then
		trigger.action.outText("CalcCurrentPointBluFor: headingDeg: " .. math.deg(headingRad) .. ", headingRad: " .. headingRad .. ", point.x: " ..
			point.x .. ", point.z: " .. point.z .. ", point.y: " .. point.y, 30)
	end
	
	
return point, headingRad
end

--[[
############################################################################################
Function:	CalcNewRelativePointBluFor
Purpose:	Calculates a new point in 3D space that is the specified
			distance and heading from the passed-in point
Parameters:	pPoint - Vec3 table of x, y and z coordinates for the position
						(point) of an object in 3D space
			pHeadingRad - Heading of object with the passed-in point in radians
			pDistance - Requested distance from the passed-in point in meters
Returns:	Point (vec3 table) in 3D space that is the specified distance and heading
			from the passed-in point
Author:		AKA_Relent
DCS ver:	1.5.4
############################################################################################
]]
function CalcNewRelativePointBluFor(pPoint, pHeadingRad, pDistance)
	if (pPoint == nil or pHeadingRad == nil or pDistance == nil)  then
		return nil
	end
	
	local vec = {
		x = pDistance * math.cos(pHeadingRad),
		z = pDistance * math.sin(pHeadingRad),
	}
	
	if (debugFlgBluFor == 2) then
		trigger.action.outText("CalcNewRelativePointBluFor: headingDeg: " .. math.deg(pHeadingRad) .. ", headingRad: " .. pHeadingRad .. ", pPoint.x: " ..
			pPoint.x .. ", pPoint.z: " .. pPoint.z .. ", pPoint.y: " .. pPoint.y .. ", pDistance: " .. pDistance, 30)
	end

	return { x = pPoint.x + vec.x , z = pPoint.z + vec.z , y = pPoint.y }
end

--[[
############################################################################################
Function:	CallSpawnBluForACGroup
Purpose:	Call SpawnBluForACGroup function, adding vector, heading and speed at waypoints
Parameters:	pUnitName - Unit name initiating the spawning of units
			pCountry - Country ID of group to be spawned (country.id enum)
			pType - Unit type
			pNum - Number of units
			pSkill - Skill of unit(s)
			pAlt - Altitude of unit(s)
			pDir - Direction of unit(s)
			pEngScen - Engagement scenario
			pDistance - Distance from unit spawn initiates, in kilometers
			pMissionType - Mission type designation (e.g. CAP, CAS)
Returns:	Group object
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]
function CallSpawnBluForACGroup(pUnitName, pCountry, pType, pNum, pSkill, pAlt, pDir, pEngScen, pDistance, pMissionType)

	if (pUnitName == nil or pCountry == nil or pType == nil or pNum == nil or pSkill == nil or 
		pAlt == nil or pDir == nil or pEngScen == nil or pDistance == nil or pMissionType == nil) then
		return
	end
	
	trigger.action.outText("Spawning " .. pNum .. " " .. pSkill .. " ".. pType, 10)
	
	local currPoint, headingRad = CalcCurrentPointBluFor(pUnitName)
	local headingDeg = math.deg(headingRad)
	local newHeadingRad
	local newHeadingDeg
	
	-- local relativeDeg = 180
	local relativeDeg = 0
	
	-- if (pDir == "12oc") then
		-- relativeDeg = 180
	-- elseif (pDir == "9to3oc") then
		-- relativeDeg = math.random(90, 270)
	-- elseif (pDir == "Random") then
		-- relativeDeg = math.random(1,360)
	-- end
	
	if (headingDeg >= 180 and headingDeg <= 360) then
		newHeadingDeg = headingDeg - relativeDeg
	elseif (headingDeg >= 0 and headingDeg < 180) then
		newHeadingDeg = headingDeg + relativeDeg
	end
	newHeadingRad = math.rad(newHeadingDeg)
	
	if (newHeadingDeg >= 180 and newHeadingDeg <= 360) then
		-- headingRad = math.rad(newHeadingDeg - 180)
		headingRad = math.rad(newHeadingDeg)
	elseif (newHeadingDeg >=0 and newHeadingDeg < 180) then
		-- headingRad = math.rad(newHeadingDeg + 180)
		headingRad = math.rad(newHeadingDeg)
	end

	if (debugFlgBluFor == 2) then
		trigger.action.outText("CallSpawnBluForACGroup: Initiator aircraft: headingDeg: " .. headingDeg .. ", headingRad: " .. headingRad .. ", AI newHeadingDeg: " .. newHeadingDeg .. ", newHeadingRad: " .. newHeadingRad .. ", pDistance: " .. pDistance .. ", pType: " .. pType, 30)
	end
	
	local distMeters = pDistance * 1000
	
	local wp1Point = CalcNewRelativePointBluFor(currPoint, headingRad, (-750 - glbBufferBluFor))
	glbBufferBluFor = glbBufferBluFor + 50
	if (glbBufferBluFor > 100) then
		glbBufferBluFor = 50
	end
	local wp2Point = CalcNewRelativePointBluFor(currPoint, headingRad, distMeters)
	
	local wp1Alt = wp1Point.y
	local wp1ASL = land.getHeight({x=wp1Point.x, y=wp1Point.z})
	
	local wp2Alt = wp2Point.y
	local wp2ASL = land.getHeight({x=wp2Point.x, y=wp2Point.z})
	
	local lSpeed = glbACSpeedBluFor
	
	local wpCASSearch = {}
	local CASSearchZone = {}
	local lOpForCoalition = coalition.side.RED
	local lObjPoint = {}
	local lxDiff
	local lzDiff
	local ldistance
	local tblTargetId = {}
	local bTargetFound = false
	local bValidTarget = false
	local lIdx = 1
	local lMaxTargetGroups = 3
	local lNumSearchAreas = 1
	local bHeloFlag = false
	
	-- Look for ground unit groups within search zone if mission type is CAS
	if (pMissionType == "CAS") then

		for t = 1, #tblCASHeloTypesBluFor do
			if (pType == tblCASHeloTypesBluFor[t]) then
				bHeloFlag = true
				break
			end
		end
		
		-- If auto search, loop through table of distances in ahead of Client/Player, otherwise just use waypoint #2
		if (pDistance == glbCASDistBluForAuto) then
			if (bHeloFlag == true) then
				lNumSearchAreas = #tblCASHeloDistBluForAuto
			else
				lNumSearchAreas = #tblCASDistBluForAuto
			end
		else
			lNumSearchAreas = 1
		end
		
		for idxSrch = 1, lNumSearchAreas do
		
			wpCASSearch = CalcNewRelativePointBluFor(wp2Point, headingRad, (glbCASSearchRadius + glbCASWP2buff) * 1000)
			CASSearchZone = {
					point = wpCASSearch,
					radius = glbCASSearchRadius * 1000
					}
			
			if (pCountry == country.id.USA or pCountry == country.id.FRANCE or pCountry == country.id.CJTF_BLUE) then
				lOpForCoalition = coalition.side.RED
			else
				lOpForCoalition = coalition.side.BLUE
			end

			-- Search for GROUND units in search area
			for i, grp in pairs(coalition.getGroups(lOpForCoalition, Group.Category.GROUND)) do
				lObjPoint = Group.getUnit(grp, 1):getPoint()
				lxDiff = lObjPoint.x - CASSearchZone.point.x
				lzDiff = lObjPoint.z - CASSearchZone.point.z
				ldistance = math.sqrt(lxDiff * lxDiff + lzDiff * lzDiff)
				if (ldistance <= CASSearchZone.radius) then
					for idx, theUnit in pairs(Group.getUnits(grp)) do
	--					if (Unit.isExist(theUnit) == true and Unit.getLife(theUnit) >= 1) then
						if (Unit.isActive(theUnit) == true and Unit.getLife(theUnit) >= 1) then
	--					if (theUnit and Unit.getLife(theUnit) >= 1) then
							bValidTarget = true
							break
						end 
					end
					if (bValidTarget == true) then
						--trigger.action.outText("Valid OpFor group in CAS search zone: " .. Group.getName(grp) .. " (gid: " .. Group.getID(grp) .. ")", 10)
						table.insert(tblTargetId, {grpID = Group.getID(grp)})
						bTargetFound = true
						if (lIdx >= lMaxTargetGroups) then
							break
						end
						lIdx = lIdx + 1	
					end
				end
			end		 
			
			-- Search for SHIP units in search area (if ground target not found)
			if (bTargetFound == false) then
				for i, grp in pairs(coalition.getGroups(lOpForCoalition, Group.Category.SHIP)) do
					lObjPoint = Group.getUnit(grp, 1):getPoint()
					lxDiff = lObjPoint.x - CASSearchZone.point.x
					lzDiff = lObjPoint.z - CASSearchZone.point.z
					ldistance = math.sqrt(lxDiff * lxDiff + lzDiff * lzDiff)
					if (ldistance <= CASSearchZone.radius) then
						for idx, theUnit in pairs(Group.getUnits(grp)) do
		--					if (Unit.isExist(theUnit) == true and Unit.getLife(theUnit) >= 1) then
							if (Unit.isActive(theUnit) == true and Unit.getLife(theUnit) >= 1) then
		--					if (theUnit and Unit.getLife(theUnit) >= 1) then
								bValidTarget = true
								break
							end 
						end
						if (bValidTarget == true) then
							--trigger.action.outText("Valid OpFor group in CAS search zone: " .. Group.getName(grp) .. " (gid: " .. Group.getID(grp) .. ")", 10)
							table.insert(tblTargetId, {grpID = Group.getID(grp)})
							bTargetFound = true
							if (lIdx >= lMaxTargetGroups) then
								break
							end
							lIdx = lIdx + 1	
						end
					end
				end		 
			end
			if (bTargetFound == true) then
				break
			else
				if (bHeloFlag == true) then
					wp2Point = CalcNewRelativePointBluFor(currPoint, headingRad, tblCASHeloDistBluForAuto[idxSrch]*1000)
				else
					wp2Point = CalcNewRelativePointBluFor(currPoint, headingRad, tblCASDistBluForAuto[idxSrch]*1000)
				end
			end
		end
	end

	for i=1, #tblFuFlChLiPresetsBluFor do 
		if (tblFuFlChLiPresetsBluFor[i].ut == pType and tblFuFlChLiPresetsBluFor[i].co == pCountry) then
			unitCategory = tblFuFlChLiPresetsBluFor[i].cat
			break
		end
	end
	
	local lAAlt = glbMedAltBluFor
	if (pAlt == "Low") then
		lAAlt = glbLowAltBluFor
	elseif (pAlt == "Medium") then
		lAAlt = glbMedAltBluFor
	elseif (pAlt == "High") then
		lAAlt = glbHiAltBluFor
	else -- pAlt = "Co-Alt+"
		lAAlt = wp1Alt + glbBufferAltBluFor
		glbBufferAltBluFor = glbBufferAltBluFor + 25
		if (glbBufferAltBluFor > 50) then
			glbBufferAltBluFor = 25
		end
	end
	
	-- Set speed (mph) and spawn altitude (meters) depending on spawned aircraft type
	if (unitCategory == Group.Category.HELICOPTER) then
		lSpeed = glbHeloSpeedBluFor
		wp1Point.y = wp1ASL + math.min(lAAlt, glbHeloAltBluFor)
		wp2Point.y = wp2ASL + glbHeloAltBluFor
	else -- Aircraft
		lSpeed = glbACSpeedBluFor
		wp1Point.y = wp1ASL + lAAlt
		wp2Point.y = wp2ASL + math.max(lAAlt, glbMedHiAltBluFor)
	end
	
	if (debugFlgBluFor == 2) then
		trigger.action.outText("CallSpawnBluForACGroup: pUnitName: " .. pUnitName .. ", pCountry: " .. pCountry .. ", pType: " ..
			pType .. ", pNum: " .. pNum .. ", pSkill: " .. pSkill .. ", pEngScen: " .. pEngScen .. ", newHeadingDeg: " ..
			math.deg(newHeadingRad) .. ", speed: " .. lSpeed, 30)
	end

	local pointInZone = false
	for i=1, #tblExclZoneListBluFor do
		if (IsPointInZoneBluFor(wp1Point, tblExclZoneListBluFor[i].name) or IsPointInZoneBluFor(wp2Point, tblExclZoneListBluFor[i].name)) then
			pointInZone = true
			break
		end
	end
	
	if (pointInZone == true) then
		trigger.action.outText("Can NOT spawn " .. pNum .. " " .. pSkill .. " ".. pType .. ", move BluFor aircraft spawn and destination points away from exclusion zone.", 10)
		return
	elseif (pMissionType == "CAS" and bTargetFound == false) then
		trigger.action.outText("Can NOT spawn " .. pNum .. " " .. pSkill .. " ".. pType .. " for CAS tasking, no valid OpFor ground units in search area, 0-" .. 
			tostring(math.ceil(glbCASSearchRadius*8/1.609344)) .. " miles ahead.", 10)
		return
	else	
		return SpawnBluForACGroup(pUnitName, pCountry, pType, pNum, pSkill, pEngScen, newHeadingRad, wp1Point, wp2Point, lSpeed, pMissionType, tblTargetId)
	end
end

--[[
############################################################################################
Function:	CheckForSinglePlayerBluFor
Purpose:	Checks the tblClientUnitBluFor table for a unit skill of "Player";  If a single player
			mission, there will be one "Player" skilled unit;  If a multi player mission,
			there would be one or more "Client" skilled units, no "Player" skilled units.
			If a "Player" skilled aircraft exists, and no "Client" skilled aircraft exist,
			call the AddRadioCommandsBluFor function
Parameters:	none
Returns:	nothing
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]
function CheckForSinglePlayerBluFor()

	local numClient = 0
	local numPlayer = 0
	local unitName = ""
	for key, data in pairs (tblClientUnitBluFor) do
		if (data.uSkl == "Player") then
			unitName = data.uNam
			numPlayer = numPlayer + 1
		elseif (data.uSkl == "Client") then
			numClient = numClient + 1
		end
	end
	if (debugFlgBluFor == 2) then
		trigger.action.outText("CheckForSinglePlayerBluFor: numPlayer: " .. numPlayer .. ", numClient: " .. numClient, 20)
	end	
	if ((numPlayer == 1) and (numClient == 0)) then
		glbFlgSPBluFor = 1
		table.insert(tblPlayerListBluFor, {pName = "Player", optSkl = glbDefSkillBluFor, optCurSkl = glbDefSkillBluFor,
			optAAlt = glbDefAAltBluFor, optCurAAlt = glbDefAAltBluFor, optDir = glbDefDirBluFor, optCurDir = glbDefDirBluFor, rMenuID = nil})
		AddRadioCommandsBluFor(unitName, "Player", "true")
		if (debugFlgBluFor == 2) then
			trigger.action.outText("CheckForSinglePlayerBluFor: called AddRadioCommandsBluFor", 20)
		end	
	end
end

--[[
############################################################################################
Function:	EngagementScenarioLoadOutPresetBluFor
Purpose:	Returns load-out pre-sets for each aircraft engagement scenario from 
			tblLoadoutPresetsBluFor table
Parameters:	unitType - Unit (aircraft) type
			unitScenario - Type of engagement scenario for this BluFor aircraft
Returns:	Pylons table for given unit type and unit scenario
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]
function EngagementScenarioLoadOutPresetBluFor(punitType, punitScenario)
	for i=1, #tblLoadoutPresetsBluFor do
		if (tblLoadoutPresetsBluFor[i].ut == punitType and tblLoadoutPresetsBluFor[i].us == punitScenario) then
			if (debugFlgBluFor == 2) then
				trigger.action.outText("Found preset loadout for: " .. punitType .. ", " .. punitScenario, 10)	
			end
			return tblLoadoutPresetsBluFor[i].lp
		end
	end
	return {}
end

--[[
############################################################################################
Function:	GetCoalitionbyUnitIDBluFor
Purpose:	Return the coalition of the Unit with the unit ID passed in.  Used for groups
			that contain a unit with a skill of Client, parsing a table of unit IDs
			with mapped group IDs and coalitions
Parameters:	pUnitID - Unit ID
Returns:	coalition enum value
Author:		AKA_Relent
DCS ver:	1.5.4
############################################################################################
]]
function GetCoalitionbyUnitIDBluFor(pUnitID)
	if (pUnitID == "" or pUnitID == nil) then
		return nil
	end
	for key, data in pairs (tblClientUnitBluFor) do
		if (tonumber(data.uID) == tonumber(pUnitID)) then
			if (debugFlgBluFor == 2) then
				trigger.action.outText("GetCoalitionbyUnitIDBluFor: UnitID: " .. data.uID .. ", coalition: " .. data.coal, 10)
			end
			if (data.coal == "blue") then
				return coalition.side.BLUE
			elseif (data.coal == "red") then
				return coalition.side.RED
			elseif (data.coal == "neutral") then
				return coalition.side.NEUTRAL
			else
				return nil
			end
		end
	end
end

--[[
############################################################################################
Function:	GetGroupIDbyUnitIDBluFor
Purpose:	Return the group ID based on the unit ID passed in.  Used for groups
			that contain a unit with a skill of Client, parsing a table of unit IDs
			with mapped group IDs and coalitions
Parameters:	pUnitID - Unit ID
Returns:	nothing
Author:		AKA_Relent
DCS ver:	1.5.4
############################################################################################
]]
function GetGroupIDbyUnitIDBluFor(pUnitID)
	if (debugFlgBluFor == 2) then
		trigger.action.outText("GetGroupIDbyUnitIDBluFor: pUnitID=" .. pUnitID, 20)
	end
	if (pUnitID == nil) then
		return nil
	end
	for key, data in pairs (tblClientUnitBluFor) do
		if (debugFlgBluFor == 2) then
			trigger.action.outText("GetGroupIDbyUnitIDBluFor: data.uID=" .. data.uID .. ", pUnitID=" .. pUnitID, 20)
		end
		if (tonumber(data.uID) == tonumber(pUnitID)) then
			if (debugFlgBluFor == 2) then
				trigger.action.outText("GetGroupIDbyUnitIDBluFor: found it - groupID=" .. data.gID, 20)
			end
			return data.gID
		end
	end
end

--[[
############################################################################################
Function:	HandlePlayerEnterExitUnitBluFor
Purpose:	Calls AddRadioCommandsBluFor and RemoveRadioCommandsBluFor based on
			a player entering and exiting a unit
Parameters:	event
Returns:	nothing
Author:		AKA_Relent
DCS ver:	1.5.4
############################################################################################
]]
HandlePlayerEnterExitUnitBluFor = {}
function HandlePlayerEnterExitUnitBluFor:onEvent(event)
    local _status, _err = pcall(function(_args)
		-- Display all events for the initiator
		--if (debugFlgBluFor == 99) then
			-- local m = {}
			-- m[#m+1] = "Event ID: "
			-- m[#m+1] = event.id
			-- if event.initiator then
				-- m[#m+1] "\nInitiator : "
				-- m[#m+1] = event.initiator:getName()
			-- end
			-- trigger.action.outText("HandlePlayerEnterExitUnitBluFor: " .. table.concat(m),5)
		--end

		if (event.id == world.event.S_EVENT_BIRTH and event.initiator ~= nil) then
			local enterUnit = event.initiator
			if (enterUnit ~= nil) then
				local unitName = enterUnit:getName()
				if (unitName ~= nil) then
					if (Unit.getByName(unitName):getPlayerName()) then
						local playerName = enterUnit:getPlayerName()
						if (debugFlgBluFor == 2) then
							trigger.action.outText(playerName .. "/" .. unitName .. " entered " .. enterUnit:getTypeName(),5)
						end
						-- Check if player name is already in tblPlayerListBluFor table
						local lFoundPlayer = 0
						for key, data in pairs (tblPlayerListBluFor) do
							if (data.pName == playerName) then
								lFoundPlayer = 1
								if (debugFlgBluFor == 2) then
									trigger.action.outText("HandlePlayerEnterExitUnitBluFor: lFoundPlayer: " .. lFoundPlayer, 20)
								end
								break
							end
						end
						-- Add player name to tblPlayerListBluFor table if not already in the table
						if (lFoundPlayer == 0) then
							table.insert(tblPlayerListBluFor, {pName = playerName, optSkl = glbDefSkillBluFor, optCurSkl = glbDefSkillBluFor,
								optAAlt = glbDefAAltBluFor, optCurAAlt = glbDefAAltBluFor, optDir = glbDefDirBluFor, optCurDir = glbDefDirBluFor, rMenuID = nil})
							if (debugFlgBluFor == 2) then
								trigger.action.outText("HandlePlayerEnterExitUnitBluFor: " .. playerName .. " added to tblPlayerListBluFor", 20)
								for i=1, #tblPlayerListBluFor do
									trigger.action.outText("tblPlayerListBluFor[" .. i .. "].pName = " .. tblPlayerListBluFor[i].pName, 20)
								end
							end	
						end
						-- Check if client unit is already in tblClientUnitBluFor table
						local lFoundUnit = 0
						for key, data in pairs (tblClientUnitBluFor) do
							if (debugFlgBluFor == 2) then
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: data.uID: " .. data.uID .. " vs enterUnit:getID(): " .. enterUnit:getID(), 30)
							end
							if (tonumber(data.uID) == tonumber(enterUnit:getID())) then
								lFoundUnit = 1
								if (debugFlgBluFor == 3) then
									trigger.action.outText("HandlePlayerEnterExitUnitOpFor: lFoundUnit: " .. lFoundUnit, 30)
								end
								break
							end
						end
						-- Add client unit to tblClientUnitBluFor table if not already in the table (i.e. for dynamic spawn slots)
						if (lFoundUnit == 0) then
							if (debugFlgBluFor == 3) then
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: lFoundUnit: " .. lFoundUnit, 30)
							end
							local lUnitID = enterUnit:getID()
							local lCoal = "neutral" 
							if (debugFlgBluFor == 3) then
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: coalition number: " .. enterUnit:getCoalition(), 30)
							end
							if (enterUnit:getCoalition() == coalition.side.BLUE) then
								lCoal = "blue"
							elseif (enterUnit:getCoalition() == coalition.side.RED) then
								lCoal = "red"
							end
							if (debugFlgBluFor == 3) then
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: Adding uID " .. lUnitID .. " to tblClientUnitBluFor", 30)
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: uTyp=" .. enterUnit:getTypeName(), 30)
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: uNam=" .. enterUnit:getName(), 30)
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: gID=" .. enterUnit:getGroup():getID(), 30)
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: gNam=" .. enterUnit:getGroup():getName(), 30)
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: coal=" .. lCoal, 30)
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: uSkl= Client", 30)
							end
							table.insert(tblClientUnitBluFor, {uID = lUnitID, gID = enterUnit:getGroup():getID(),
										uTyp = enterUnit:getTypeName(), uNam = enterUnit:getName(), gNam = enterUnit:getGroup():getName(), 
										coal = lCoal, uSkl = "Client", optSkl = glbDefSkillBluFor, optCurSkl = glbDefSkillBluFor,
										optAAlt = glbDefAAltBluFor, optCurAAlt = glbDefAAltBluFor})
							if (debugFlgBluFor == 3) then
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: " .. lUnitID .. " added to tblClientUnitBluFor; table contents:", 30)
								for i=1, #tblClientUnitBluFor do
									trigger.action.outText("tblClientUnitBluFor[" .. i .. "].uID = " .. tblClientUnitBluFor[i].uID, 30)
								end
							end	
						end

						-- add slight delay for multiplayer timing
						for i = 1, 333333333 do --[[ do nothing ]] end
						-- Have to clean up radio commands prior to entering a unit
						for i=1, #tblPlayerListBluFor do
							if (tblPlayerListBluFor[i].pName == playerName and tblPlayerListBluFor[i].rMenuID ~= nil) then
								RemoveRadioCommandsBluFor(unitName, tblPlayerListBluFor[i].rMenuID)
								if (debugFlgBluFor == 2) then
									trigger.action.outText("HandlePlayerEnterExitUnitBluFor: called 1st RemoveRadioCommandsBluFor", 20)
								end
								break
							end
						end
						AddRadioCommandsBluFor(unitName, playerName, "true")
						if (debugFlgBluFor == 2) then
							trigger.action.outText("HandlePlayerEnterExitUnitBluFor: called AddRadioCommandsBluFor", 20)
						end	
					end
				end
			end
		elseif ((event.id == world.event.S_EVENT_EJECTION and event.initiator ~= nil) or
				(event.id == world.event.S_EVENT_PILOT_DEAD and event.initiator ~= nil) or
				(event.id == world.event.S_EVENT_CRASH and event.initiator ~= nil) or
				(event.id == world.event.S_EVENT_DEAD and event.initiator ~= nil)) then
			local leftUnit = event.initiator
			if (leftUnit ~= nil) then
				local lUnitName = leftUnit:getName()
				if (lUnitName ~= nil) then
					if (Unit.getByName(lUnitName):getPlayerName()) then
						local playerName = leftUnit:getPlayerName() -- check if getPlayerName() is nil, throwing an error
						if (debugFlgBluFor == 2) then
							trigger.action.outText(lUnitName .. " left " .. leftUnit:getTypeName() .. " or ejected or died",5)
						end
						-- add slight delay for multiplayer timing
						for i = 1, 333333333 do --[[ do nothing ]] end
						-- Have to clean up radio commands after exiting a unit
						for i=1, #tblPlayerListBluFor do
							if (tblPlayerListBluFor[i].pName == playerName) then
								RemoveRadioCommandsBluFor(lUnitName, tblPlayerListBluFor[i].rMenuID)
								if (debugFlgBluFor == 2) then
									trigger.action.outText("HandlePlayerEnterExitUnitBluFor: called 2nd RemoveRadioCommandsBluFor", 20)
								end
								break
							end
						end
					end
				end
			end
		end
    end, _arguments)

    if (not _status) then
        env.error(string.format("BluForAC: HandlePlayerEnterExitUnitBluFor ERROR: %s", _err))
    end
end
local ehHPEEUId = world.addEventHandler(HandlePlayerEnterExitUnitBluFor)

--[[
############################################################################################
Function:	IsPointInZoneBluFor
Purpose:	Checks if point in the specified circular trigger zone
Parameters:	pPoint - Vec3 table of x, y and z coordinates for the position
						(point) of an object in 3D space
			pZone - trigger zone name
Returns:	boolean
Author:		AKA_Relent
DCS ver:	1.5.4
############################################################################################
]]
function IsPointInZoneBluFor(pPoint, pZone)
	if (pPoint == nil) then
		return false
	end
	
	local zone = trigger.misc.getZone(pZone)
	if (zone == nil) then
		return false
	end
	local xDiff = pPoint.x - zone.point.x
	local zDiff = pPoint.z - zone.point.z
	local distance = math.sqrt(xDiff * xDiff + zDiff * zDiff)
	if (distance <= zone.radius) then
		return true
	else
		return false
	end	
end

--[[
############################################################################################
Function:	RemoveRadioCommandsBluFor
Purpose:	Removes F10 radio menu items for the player unit with the passed-in unit name
Parameters:	pUnitName - Initiator unit name
			pPath - F10 sub-menu path
Returns:	nothing
Author:		AKA_Relent
DCS ver:	1.5.4
############################################################################################
]]
function RemoveRadioCommandsBluFor(pUnitName, pPath)
	local lUnit = Unit.getByName(pUnitName)
	if (lUnit == nil or pPath == nil) then
		return
	end
	local gid = GetGroupIDbyUnitIDBluFor(lUnit:getID())
	if (gid == nil) then
		return
	end
	if (debugFlgBluFor == 2) then
		trigger.action.outText("RemoveRadioCommandsBluFor: pUnitName: " .. pUnitName .. ", gid: " .. gid, 20)
	end
	missionCommands.removeItemForGroup(gid, pPath)
end

--[[
############################################################################################
Function:	SetAltBluFor
Purpose:	Set altitude string optAAlt in global table tblClientUnitBluFor to the passed in string 
			argument pAlt
Parameters:	pUid - Player unit id
			pUnitName - Player unit name
			pPlayerName - Player name
			pACType - Player aircraft type
			pAlt - AI unit altitude
Returns:	nothing
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]
function SetAltBluFor(pUid, pUnitName, pPlayerName, pACType, pAlt)
	if (debugFlgBluFor == 2) then
		trigger.action.outText("SetAltBluFor: pPlayerName: " .. pPlayerName .. ", pUid: " .. pUid .. ", pAlt: " .. pAlt, 20)
	end
	if (pAlt ~= "Random" and pAlt ~= "Low" and pAlt ~= "Medium" and 
			pAlt ~= "High" and pACType ~= "AC" and pACType ~= "Helo") then
		return
	end
	if (pACType == "AC") then
		for i=1, #tblPlayerListBluFor do
			if (debugFlgBluFor == 2) then
				trigger.action.outText("SetAltBluFor: #tblPlayerListBluFor = " .. #tblPlayerListBluFor, 20)
				trigger.action.outText("SetAltBluFor: tblPlayerListBluFor[" .. i .. "].pName = " .. tblPlayerListBluFor[i].pName, 20)
			end
			if (tblPlayerListBluFor[i].pName == pPlayerName) then
				tblPlayerListBluFor[i].optAAlt = pAlt
				tblPlayerListBluFor[i].optCurAAlt = pAlt
				if (debugFlgBluFor == 2) then
					trigger.action.outText("SetAltBluFor (found player): tblPlayerListBluFor[" .. i .. "].pName = " .. tblPlayerListBluFor[i].pName .. ", pUid: " .. pUid .. ", pAlt: " .. pAlt .. 
					", tblPlayerListBluFor[" .. i .. "].optAAlt: " .. tblPlayerListBluFor[i].optAAlt .. ", tblPlayerListBluFor[" .. i .. "].optCurAAlt: " .. tblPlayerListBluFor[i].optCurAAlt, 20)
				end
				RemoveRadioCommandsBluFor(pUnitName, tblPlayerListBluFor[i].rMenuID)
				if (debugFlgBluFor == 2) then
					trigger.action.outText("SetAltBluFor: called RemoveRadioCommandsBluFor", 20)
				end
				AddRadioCommandsBluFor(pUnitName, pPlayerName, "false")
				if (debugFlgBluFor == 2) then
					trigger.action.outText("SetAltBluFor: called AddRadioCommandsBluFor", 20)
				end	
				break
			end
		end
	elseif (pACType == "Helo") then
	-- No options for Helo's right now, keep at default alt glbHeloAltBluFor
	end
end

--[[
############################################################################################
Function:	SetSkillBluFor
Purpose:	Set skill string optSkl in global table tblClientUnitBluFor to the passed in string 
			argument pSkill
Parameters:	pUid - Player unit id
			pUnitName - Player unit name
			pPlayerName - Player name
			pSkill - AI unit skill
Returns:	nothing
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]
function SetSkillBluFor(pUid, pUnitName, pPlayerName, pSkill)
	if (debugFlgBluFor == 2) then
		trigger.action.outText("SetSkillBluFor: pPlayerName: " .. pPlayerName .. ", pUid: " .. pUid .. ", pSkill: " .. pSkill, 20)
	end
	if (pSkill ~= "Random" and pSkill ~= "Rookie" and pSkill ~= "Trained" and 
			pSkill ~= "Veteran" and pSkill ~= "Ace") then
		return
	end
	for i=1, #tblPlayerListBluFor do
		if (debugFlgBluFor == 2) then
			trigger.action.outText("SetSkillBluFor: #tblPlayerListBluFor = " .. #tblPlayerListBluFor, 20)
			trigger.action.outText("SetSkillBluFor: tblPlayerListBluFor[" .. i .. "].pName = " .. tblPlayerListBluFor[i].pName, 20)
		end
		if (tblPlayerListBluFor[i].pName == pPlayerName) then
			tblPlayerListBluFor[i].optSkl = pSkill
			tblPlayerListBluFor[i].optCurSkl = pSkill
			if (debugFlgBluFor == 2) then
				trigger.action.outText("SetSkillBluFor (found player): tblPlayerListBluFor[" .. i .. "].pName = " .. tblPlayerListBluFor[i].pName .. ", pUid: " .. pUid .. ", pSkill: " .. pSkill .. 
				", tblPlayerListBluFor[" .. i .. "].optSkl: " .. tblPlayerListBluFor[i].optSkl .. ", tblPlayerListBluFor[" .. i .. "].optCurSkl: " .. tblPlayerListBluFor[i].optCurSkl, 20)
			end
			RemoveRadioCommandsBluFor(pUnitName, tblPlayerListBluFor[i].rMenuID)
			if (debugFlgBluFor == 2) then
				trigger.action.outText("SetSkillBluFor: called RemoveRadioCommandsBluFor", 20)
			end
			AddRadioCommandsBluFor(pUnitName, pPlayerName, "false")
			if (debugFlgBluFor == 2) then
				trigger.action.outText("SetSkillBluFor: called AddRadioCommandsBluFor", 20)
			end	
			break
		end
	end
end

--[[
############################################################################################
Function:	SetDirBluFor
Purpose:	Set direction string optDir in global table tblClientUnitBluFor to the passed in string 
			argument pDir
Parameters:	pUid - Player unit id
			pUnitName - Player unit name
			pPlayerName - Player name
			pDir - AI unit direction relative to player
Returns:	nothing
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]
function SetDirBluFor(pUid, pUnitName, pPlayerName, pDir)
	if (debugFlgBluFor == 2) then
		trigger.action.outText("SetDirBluFor: pPlayerName: " .. pPlayerName .. ", pUid: " .. pUid .. ", pDir: " .. pDir, 20)
	end
	if (pDir ~= "12oc" and pDir ~= "9to3oc" and pDir ~= "Random") then
		return
	end
	for i=1, #tblPlayerListBluFor do
		if (debugFlgBluFor == 2) then
			trigger.action.outText("SetDirBluFor: #tblPlayerListBluFor = " .. #tblPlayerListBluFor, 20)
			trigger.action.outText("SetDirBluFor: tblPlayerListBluFor[" .. i .. "].pName = " .. tblPlayerListBluFor[i].pName, 20)
		end
		if (tblPlayerListBluFor[i].pName == pPlayerName) then
			tblPlayerListBluFor[i].optDir = pDir
			tblPlayerListBluFor[i].optCurDir = pDir
			if (debugFlgBluFor == 2) then
				trigger.action.outText("SetDirBluFor (found player): tblPlayerListBluFor[" .. i .. "].pName = " .. tblPlayerListBluFor[i].pName .. ", pUid: " .. pUid .. ", pDir: " .. pDir .. 
				", tblPlayerListBluFor[" .. i .. "].optDir: " .. tblPlayerListBluFor[i].optDir .. ", tblPlayerListBluFor[" .. i .. "].optCurDir: " .. tblPlayerListBluFor[i].optCurDir, 20)
			end
			RemoveRadioCommandsBluFor(pUnitName, tblPlayerListBluFor[i].rMenuID)
			if (debugFlgBluFor == 2) then
				trigger.action.outText("SetDirBluFor: called RemoveRadioCommandsBluFor", 20)
			end
			AddRadioCommandsBluFor(pUnitName, pPlayerName, "false")
			if (debugFlgBluFor == 2) then
				trigger.action.outText("SetDirBluFor: called AddRadioCommandsBluFor", 20)
			end	
			break
		end
	end
end

--[[
############################################################################################
Function:	SetUpFuFlChLiPresetsBluFor
Purpose:	Adds fuel, flare, chaff, livery pre-sets for each aircraft into a table
Parameters:	none
Returns:	nothing
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]

function SetUpFuFlChLiPresetsBluFor()

	local unitType = ""
	local unitCountry
	local unitFuel
	local unitFlares
	local unitChaff
	local unitLivery = ""
	local unitCategory
	local unitCoalition = coalition.side.NEUTRAL
	
	--[[ Red fighters ]]
	
	unitType = "J-11A"
	unitCountry = country.id.CHINA
	unitFuel = 9400
	unitFlares = 96
	unitChaff = 96
	unitLivery = "PLAAF 19th AD"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "JF-17"
	unitCountry = country.id.CHINA
	unitFuel = 2325
	unitFlares = 32
	unitChaff = 36
	unitLivery = "PLAAF 125th AB (Fictional)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "M-2000C"
	unitCountry = country.id.CJTF_RED
	unitFuel = 3165
	unitFlares = 64
	unitChaff = 234
	unitLivery = "UAE Air Force"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "MiG-29A"
	unitCountry = country.id.RUSSIA
	unitFuel = 3376
	unitFlares = 30
	unitChaff = 30
	unitLivery = "Air Force Standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "MiG-29S"
	unitCountry = country.id.RUSSIA
	unitFuel = 3493
	unitFlares = 30
	unitChaff = 30
	unitLivery = "Air Force Standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "MiG-31"
	unitCountry = country.id.RUSSIA
	unitFuel = 15500
	unitFlares = 0
	unitChaff = 0
	unitLivery = "af standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Su-27"
	unitCountry = country.id.RUSSIA
	unitFuel = 9400
	unitFlares = 96
	unitChaff = 96
	unitLivery = "Air Force Standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "Su-30"
	unitCountry = country.id.RUSSIA
	unitFuel = 9400
	unitFlares = 96
	unitChaff = 96
	unitLivery = "af standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "Su-33"
	unitCountry = country.id.RUSSIA
	unitFuel = 9500
	unitFlares = 48
	unitChaff = 48
	unitLivery = "279th kiap 1st squad navy"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	--[[ Red attackers ]]
	
	unitType = "Su-25"
	unitCountry = country.id.RUSSIA
	unitFuel = 2835
	unitFlares = 128
	unitChaff = 128
	unitLivery = "field camo scheme #1 (native)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Su-25T"
	unitCountry = country.id.RUSSIA
	unitFuel = 3790
	unitFlares = 128
	unitChaff = 128
	unitLivery = "af standard 1"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Su-34"
	unitCountry = country.id.RUSSIA
	unitFuel = 9800
	unitFlares = 64
	unitChaff = 64
	unitLivery = "Russian Air Force"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	--[[ Red helicopters ]]
	
	unitType = "Ka-50"
	unitCountry = country.id.RUSSIA
	unitFuel = 1450
	unitFlares = 128
	unitChaff = 0
	unitLivery = "Russia Standard Army"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Mi-8MT"
	unitCountry = country.id.RUSSIA
	unitFuel = 1640
	unitFlares = 128
	unitChaff = 0
	unitLivery = "Russia_VVS_Standard"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Mi-24P"
	unitCountry = country.id.RUSSIA
	unitFuel = 1310
	unitFlares = 128
	unitChaff = 64
	unitLivery = "Russian Air Force"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "Mi-26"
	unitCountry = country.id.RUSSIA
	unitFuel = 9600
	unitFlares = 192
	unitChaff = 0
	unitLivery = "RF Air Force"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "Mi-28N"
	unitCountry = country.id.RUSSIA
	unitFuel = 1500
	unitFlares = 128
	unitChaff = 0
	unitLivery = "standard"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	--[[ Red Vietnam/70's era aircraft ]]
	
	unitType = "F-5E-3"
	unitCountry = country.id.CJTF_RED
	unitFuel = 2046
	unitFlares = 15
	unitChaff = 30
	unitLivery = "ir iriaf 43rd tfs"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "F-14A-135-GR"
	unitCountry = country.id.CJTF_RED
	unitFuel = 7348
	unitFlares = 60
	unitChaff = 140
	unitLivery = "rogue nation(top gun - maverick)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "MiG-19P"
	unitCountry = country.id.RUSSIA
	unitFuel = 1800
	unitFlares = 0
	unitChaff = 0
	unitLivery = "default"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "MiG-21Bis"
	unitCountry = country.id.RUSSIA
	unitFuel = 2280
	unitFlares = 40
	unitChaff = 18
	unitLivery = "VVS - 185th GvIAP"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "MiG-23MLD"
	unitCountry = country.id.RUSSIA
	unitFuel = 3800
	unitFlares = 60
	unitChaff = 60
	unitLivery = "af standard-2"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Mirage-F1CE"
	unitCountry = country.id.CJTF_RED
	unitFuel = 3356
	unitFlares = 15
	unitChaff = 30
	unitLivery = "Jordan Air Force (FICTIONAL C VERSION)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Su-17M4"
	unitCountry = country.id.RUSSIA
	unitFuel = 3770
	unitFlares = 64
	unitChaff = 64
	unitLivery = "af standard (RUS)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	--[[ Red WW2 & Korea era fighters ]]
	
	unitType = "Bf-109K-4"
	unitCountry = country.id.CJTF_RED
	unitFuel = 296
	unitFlares = 0
	unitChaff = 0
	unitLivery = "Bf-109 K4 Jagdgeschwader 53"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "FW-190A8"
	unitCountry = country.id.CJTF_RED
	unitFuel = 409
	unitFlares = 0
	unitChaff = 0
	unitLivery = "Factory skin"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "FW-190D9"
	unitCountry = country.id.CJTF_RED
	unitFuel = 388
	unitFlares = 0
	unitChaff = 0
	unitLivery = "FW-190D9_13.JG 51_Heinz Marquardt"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "MiG-15bis"
	unitCountry = country.id.NORTH_KOREA
	unitFuel = 1172
	unitFlares = 0
	unitChaff = 0
	unitLivery = "North_Korea_Air Force_Major_ Arkady_ Boitsow"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	
	--[[ Blue fighters ]]
	
	unitType = "F-14B"
	unitCountry = country.id.USA
	unitFuel = 7348
	unitFlares = 60
	unitChaff = 140
	unitLivery = "VF-102 Diamondbacks"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "F-15C"
	unitCountry = country.id.USA
	unitFuel = 6103
	unitFlares = 60
	unitChaff = 120
	unitLivery = "12th Fighter SQN (AK)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "F-16C_50"
	unitCountry = country.id.USA
	unitFuel = 3249
	unitFlares = 60
	unitChaff = 60
	unitLivery = "default"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "FA-18C_hornet"
	unitCountry = country.id.USA
	unitFuel = 4900
	unitFlares = 60
	unitChaff = 60
	unitLivery = "VFA-37"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "JF-17"
	unitCountry = country.id.CJTF_BLUE
	unitFuel = 2325
	unitFlares = 32
	unitChaff = 36
	unitLivery = "PAKAF Black Spider (default)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "M-2000C"
	unitCountry = country.id.FRANCE
	unitFuel = 3165
	unitFlares = 64
	unitChaff = 234
	unitLivery = "AdA Alsace LF-2"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	--[[ Blue attackers ]]

	unitType = "A-10A"
	unitCountry = country.id.USA
	unitFuel = 5029
	unitFlares = 120
	unitChaff = 240
	unitLivery = "66th WS Nellis AFB, Nevada (WA)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "A-10C_2"
	unitCountry = country.id.USA
	unitFuel = 5029
	unitFlares = 240
	unitChaff = 240
	unitLivery = "25th FS Osan AB, Korea (OS)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "AJS37"
	unitCountry = country.id.SWEDEN
	unitFuel = 4476
	unitFlares = 72
	unitChaff = 208
	unitLivery = "37"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "AV8BNA"
	unitCountry = country.id.USA
	unitFuel = 3519
	unitFlares = 120
	unitChaff = 60
	unitLivery = "default"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	--[[ Blue helicopters ]]
	
	unitType = "AH-1W"
	unitCountry = country.id.USA
	unitFuel = 925
	unitFlares = 30
	unitChaff = 30
	unitLivery = "standard"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "AH-64D_BLK_II"
	unitCountry = country.id.USA
	unitFuel = 1438
	unitFlares = 60
	unitChaff = 30
	unitLivery = "default"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "OH58D"
	unitCountry = country.id.USA
	unitFuel = 300
	unitFlares = 30
	unitChaff = 0
	unitLivery = "default"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "SA342L"
	unitCountry = country.id.USA
	unitFuel = 416
	unitFlares = 32
	unitChaff = 0
	unitLivery = "US Marines Fictional"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "UH-1H"
	unitCountry = country.id.USA
	unitFuel = 404
	unitFlares = 60
	unitChaff = 0
	unitLivery = "Army Standard"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "UH-60A"
	unitCountry = country.id.USA
	unitFuel = 1100
	unitFlares = 30
	unitChaff = 30
	unitLivery = "standard"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	--[[ Blue Vietnam/70's era aircraft ]]
	
	unitType = "F-4E-45MC"
	unitCountry = country.id.USA
	unitFuel = 5510.5
	unitFlares = 30
	unitChaff = 120
	unitLivery = "rs68-517_sea_526tfs"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "F-5E-3"
	unitCountry = country.id.USA
	unitFuel = 2046
	unitFlares = 15
	unitChaff = 30
	unitLivery = "USAF 'Southeast Asia'"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "F-14A-135-GR"
	unitCountry = country.id.USA
	unitFuel = 7348
	unitFlares = 60
	unitChaff = 140
	unitLivery = "Top Gun 114 HB Weather V2"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Mirage-F1CE"
	unitCountry = country.id.FRANCE
	unitFuel = 3356
	unitFlares = 15
	unitChaff = 30
	unitLivery = "RC 130 Normandie Niemen (FICTIONAL CT VERSION)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	--[[ Blue WW2 & Korea era aircraft ]]
	
	unitType = "F-86F Sabre"
	unitCountry = country.id.USA
	unitFuel = 1282
	unitFlares = 0
	unitChaff = 0
	unitLivery = "US Air Force"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "I-16"
	unitCountry = country.id.CJTF_BLUE
	unitFuel = 191
	unitFlares = 0
	unitChaff = 0
	unitLivery = "Red Army Standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "MosquitoFBMkVI"
	unitCountry = country.id.UK
	unitFuel = 996
	unitFlares = 0
	unitChaff = 0
	unitLivery = "RAF"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
		
	unitType = "P-47D-40"
	unitCountry = country.id.USA
	unitFuel = 676
	unitFlares = 0
	unitChaff = 0
	unitLivery = "Lt_Col_Benjamin_Mayo"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "P-51D-30-NA"
	unitCountry = country.id.USA
	unitFuel = 497
	unitFlares = 0
	unitChaff = 0
	unitLivery = "USAF 84th FS"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "SpitfireLFMkIX"
	unitCountry = country.id.UK
	unitFuel = 247
	unitFlares = 0
	unitChaff = 0
	unitLivery = "RAF Standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresetsBluFor, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

end

--[[
############################################################################################
Function:	SetUpLoadOutPresetsBluFor
Purpose:	Adds load-out pre-sets for each aircraft/weapon combo into a table
Parameters:	none
Returns:	nothing
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]

function SetUpLoadOutPresetsBluFor()

	local unitType = ""
	local unitScenario = ""
	local loadoutPresets = {}

	--[[ Red fighters ]]
	
	--[[ J-11A pre-sets ]]	
	unitType = "J-11A"
	unitScenario = "BVR_LRE"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{RKL609_L}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{RKL609_R}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "J-11A"
	unitScenario = "BVR_LR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	
		--[[ JF-17 pre-sets ]]	
	unitType = "JF-17"
	unitScenario = "BVR"
	loadoutPresets = {	
			   [1] = 
				{
					["CLSID"] = "DIS_PL-5EII",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "DIS_SD-10_DUAL_L",
				}, -- end of [2]
				[4] = 
				{
					["CLSID"] = "DIS_TANK800",
				}, -- end of [4]
				[6] = 
				{
					["CLSID"] = "DIS_SD-10_DUAL_R",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "DIS_PL-5EII",
				} -- end of [7]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})	
	
	unitType = "JF-17"
	unitScenario = "ACM_IR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "DIS_PL-5EII",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "DIS_PL-5EII",
				}, -- end of [2]
				[4] = 
				{
					["CLSID"] = "DIS_TANK800",
				}, -- end of [4]
				[6] = 
				{
					["CLSID"] = "DIS_PL-5EII",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "DIS_PL-5EII",
				} -- end of [7]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "JF-17"
	unitScenario = "ACM"
	loadoutPresets = {	
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "JF-17"
	unitScenario = "ANTISHIP"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "DIS_PL-5EII",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "DIS_SD-10_DUAL_L",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "DIS_C-802AK",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "DIS_TANK800",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "DIS_C-802AK",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "DIS_SD-10_DUAL_R",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "DIS_PL-5EII",
				}, -- end of [7]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "JF-17"
	unitScenario = "SEAD"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "DIS_PL-5EII",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "DIS_LD-10_DUAL_L",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "DIS_TANK1100",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "DIS_SPJ_POD",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "DIS_TANK1100",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "DIS_LD-10_DUAL_R",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "DIS_PL-5EII",
				}, -- end of [7]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	
	--[[ M-2000C pre-sets ]]
	unitType = "M-2000C"
	unitScenario = "BVR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{MMagicII}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{Matra_S530D}",
				}, -- end of [2]
				[8] = 
				{
					["CLSID"] = "{Matra_S530D}",
				}, -- end of [8]
				[10] = 
				{
					["CLSID"] = "{Eclair}",
				}, -- end of [10]
				[9] = 
				{
					["CLSID"] = "{MMagicII}",
				}, -- end of [9]
				[5] = 
				{
					["CLSID"] = "{M2KC_RPL_522}",
				} -- end of [5]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "M-2000C"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{MMagicII}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{MMagicII}",
				}, -- end of [2]
				[8] = 
				{
					["CLSID"] = "{MMagicII}",
				}, -- end of [8]
				[10] = 
				{
					["CLSID"] = "{Eclair}",
				}, -- end of [10]
				[9] = 
				{
					["CLSID"] = "{MMagicII}",
				}, -- end of [9]
				[5] = 
				{
					["CLSID"] = "{M2KC_RPL_522}",
				} -- end of [5]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "M-2000C"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ MiG-29A pre-sets ]]
	unitType = "MiG-29A"
	unitScenario = "BVR_LR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [7]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-29A"
	unitScenario = "BVR_MR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				} -- end of [7]
 	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-29A"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [7]
 	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-29A"
	unitScenario = "ACM"
	loadoutPresets = {
 	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ MiG-29S pre-sets ]]
	unitType = "MiG-29S"
	unitScenario = "BVR_LR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [7]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	
	--[[ MiG-31 pre-sets ]]
	unitType = "MiG-31"
	unitScenario = "BVR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{5F26DBC2-FB43-4153-92DE-6BBCE26CB0FF}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{5F26DBC2-FB43-4153-92DE-6BBCE26CB0FF}",
				} -- end of [6]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-31"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
				}, -- end of [1]
				[6] = 
				{
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
				} -- end of [6]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-31"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Su-27 pre-sets ]]
	unitType = "Su-27"
	unitScenario = "BVR_LR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Su-27"
	unitScenario = "BVR_MR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{88DAC840-9F75-4531-8689-B46E64E42E53}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{88DAC840-9F75-4531-8689-B46E64E42E53}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-27"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [3]
				[8] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [8]
				[10] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [10]
				[9] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-27"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	
	--[[ Su-30 pre-sets ]]	
	unitType = "Su-30"
	unitScenario = "BVR_LRE"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "Su-30"
	unitScenario = "BVR_LR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-30"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [3]
				[8] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [8]
				[10] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [10]
				[9] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Su-30"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	
	--[[ Su-33 pre-sets ]]	
	unitType = "Su-33"
	unitScenario = "BVR_LRE"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}",
				} -- end of [12]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "Su-33"
	unitScenario = "BVR_LR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [12]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-33"
	unitScenario = "BVR_MR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{88DAC840-9F75-4531-8689-B46E64E42E53}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{88DAC840-9F75-4531-8689-B46E64E42E53}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [12]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-33"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [3]
				[11] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [11]
				[10] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [10]
				[12] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [12]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Su-33"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Red attacker presets ]]
	
	--[[ Su-17M4 presets ]]
	unitType = "Su-17M4"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{APU-60-1_R_60M}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{APU-60-1_R_60M}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				} -- end of [8]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Su-17M4"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Su-17M4"
	unitScenario = "GPBOMB"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{5A1AC2B4-CA4B-4D09-A1AF-AC52FBC4B60B}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{5A1AC2B4-CA4B-4D09-A1AF-AC52FBC4B60B}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{5A1AC2B4-CA4B-4D09-A1AF-AC52FBC4B60B}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{5A1AC2B4-CA4B-4D09-A1AF-AC52FBC4B60B}",
				}, -- end of [8]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Su-17M4"
	unitScenario = "AGM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{292960BB-6518-41AC-BADA-210D65D5073C}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{APU-60-1_R_60M}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{292960BB-6518-41AC-BADA-210D65D5073C}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{292960BB-6518-41AC-BADA-210D65D5073C}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{APU-60-1_R_60M}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{292960BB-6518-41AC-BADA-210D65D5073C}",
				}, -- end of [8]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Su-25 presets ]]
	unitType = "Su-25"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{4203753F-8198-4E85-9924-6F8FF679F9FF}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{4203753F-8198-4E85-9924-6F8FF679F9FF}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Su-25"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Su-25"
	unitScenario = "GPBOMB_RKT"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{29A828E2-C6BB-11d8-9897-000476191836}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{29A828E2-C6BB-11d8-9897-000476191836}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{29A828E2-C6BB-11d8-9897-000476191836}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{29A828E2-C6BB-11d8-9897-000476191836}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [10]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Su-25"
	unitScenario = "AGM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [10]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Su-25T presets ]]
	unitType = "Su-25T"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{F789E86A-EE2E-4E6B-B81E-D5E5F903B6ED}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}",
				}, -- end of [5]
				[7] = 
				{
					["CLSID"] = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F789E86A-EE2E-4E6B-B81E-D5E5F903B6ED}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				} -- end of [11]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-25T"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-25T"
	unitScenario = "AGM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{F789E86A-EE2E-4E6B-B81E-D5E5F903B6ED}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}",
				}, -- end of [5]
				[7] = 
				{
					["CLSID"] = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F789E86A-EE2E-4E6B-B81E-D5E5F903B6ED}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [11]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-25T"
	unitScenario = "SEAD"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82D}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{752AF1D2-EBCC-4bd7-A1E7-2357F5601C70}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{752AF1D2-EBCC-4bd7-A1E7-2357F5601C70}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{0519A264-0AB6-11d6-9193-00A0249B6F00}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{752AF1D2-EBCC-4bd7-A1E7-2357F5601C70}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{752AF1D2-EBCC-4bd7-A1E7-2357F5601C70}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82C}",
				}, -- end of [11]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Su-34 presets ]]
	unitType = "Su-34"
	unitScenario = "BVR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}",
				} -- end of [12]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Su-34"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [5]
				[8] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}",
				} -- end of [12]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-34"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-34"
	unitScenario = "AGM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [5]
				[8] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}",
				}, -- end of [12]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-34"
	unitScenario = "SEAD"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{X-31P}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{X-31P}",
				}, -- end of [4]
				[6] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [7]
				[9] = 
				{
					["CLSID"] = "{X-31P}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{X-31P}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}",
				}, -- end of [12]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-34"
	unitScenario = "ANTISHIP"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{X-31A}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{X-31A}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{X-31A}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{X-31A}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}",
				}, -- end of [12]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Red helicopter presets ]]
	
	--[[ Ka-50 presets ]]
	unitType = "Ka-50"
	unitScenario = "AGM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{A6FD14D3-6D30-4C85-88A7-8D17BEE120E2}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{A6FD14D3-6D30-4C85-88A7-8D17BEE120E2}",
				} -- end of [4]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Mi-8MT presets ]]
	unitType = "Mi-8MT"
	unitScenario = "RKT"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "GUV_YakB_GSHP",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "GUV_YakB_GSHP",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "KORD_12_7",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "PKT_7_62",
				} -- end of [8]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Mi-24P presets ]]
	unitType = "Mi-24P"
	unitScenario = "AGM_RKT_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{2x9M120_Ataka_V}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{2x9M120_Ataka_V}",
				} -- end of [6]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Mi-24P"
	unitScenario = "AGM_RKT"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{2x9M120_Ataka_V}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{2x9M120_Ataka_V}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{2x9M120_Ataka_V}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{2x9M120_Ataka_V}",
				} -- end of [6]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Mi-26"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Mi-28N"
	unitScenario = "AGM_RKT"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{57232979-8B0F-4db7-8D9A-55197E06B0F5}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{57232979-8B0F-4db7-8D9A-55197E06B0F5}",
				} -- end of [4]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Red Vietnam/70's era presets ]]
	
	--[[ MiG-19P pre-sets ]]
	unitType = "MiG-19P"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{K-13A}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "PTB760_MIG19",
				}, -- end of [2]
				[5] = 
				{
					["CLSID"] = "PTB760_MIG19",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{K-13A}",
				}, -- end of [6]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-19P"
	unitScenario = "ACM"
	loadoutPresets = {
				[5] = 
				{
					["CLSID"] = "PTB760_MIG19",
				}, -- end of [5]
				[2] = 
				{
					["CLSID"] = "PTB760_MIG19",
				}, -- end of [2]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ MiG-21Bis pre-sets ]]
	unitType = "MiG-21Bis"
	unitScenario = "BVR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{R-60M 2L}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{R-3R}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{PTB_800_MIG21}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{R-3R}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{R-60M 2R}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{ASO-2}",
				} -- end of [6]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-21Bis"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{R-60M}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{R-60M}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{PTB_800_MIG21}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{R-60M}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{R-60M}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{ASO-2}",
				} -- end of [6]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-21Bis"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{R-3S}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{R-13M1}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{PTB_800_MIG21}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{R-13M1}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{R-3S}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{ASO-2}",
				}, -- end of [6]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-21Bis"
	unitScenario = "ACM"
	loadoutPresets = {
				[3] = 
				{
					["CLSID"] = "{PTB_490C_MIG21}",
				}, -- end of [3]
				[6] = 
				{
					["CLSID"] = "{ASO-2}",
				} -- end of [6]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	--[[ MiG-23MLD pre-sets ]]
	unitType = "MiG-23MLD"
	unitScenario = "BVR"
	loadoutPresets = {
				[2] = 
				{
					["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
				} -- end of [6]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-23MLD"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[3] = 
				{
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
				} -- end of [5]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-23MLD"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	--[[ Mirage-F1CE pre-sets ]]
	unitType = "Mirage-F1CE"
	unitScenario = "BVR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{R550_Magic_1}",
				}, -- end of [1]
				[3] = 
				{
					["CLSID"] = "{R530F_EM}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "PTB-1200-F1",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{R530F_EM}",
				}, -- end of [5]
				[7] = 
				{
					["CLSID"] = "{R550_Magic_1}",
				} -- end of [7]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Mirage-F1CE"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{R550_Magic_1}",
				}, -- end of [1]
				[7] = 
				{
					["CLSID"] = "{R550_Magic_1}",
				}, -- end of [7]
				[4] = 
				{
					["CLSID"] = "PTB-1200-F1",
				} -- end of [4]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Mirage-F1CE"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
				}, -- end of [1]
				[7] = 
				{
					["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
				}, -- end of [7]
				[4] = 
				{
					["CLSID"] = "PTB-1200-F1",
				}, -- end of [4]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Mirage-F1CE"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Mirage-F1CE"
	unitScenario = "GPBOMB_RKT"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{R550_Magic_1}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{MATRA_F1_SNEBT257}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{SAMP400LD}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{CLB4_SAMP400LD}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{SAMP400LD}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{MATRA_F1_SNEBT257}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{R550_Magic_1}",
				}, -- end of [7]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Mirage-F1CE"
	unitScenario = "RKT"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{R550_Magic_1}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{MATRA_F1_SNEBT253}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{MATRA_F1_SNEBT253}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "PTB-1200-F1",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{MATRA_F1_SNEBT253}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{MATRA_F1_SNEBT253}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{R550_Magic_1}",
				}, -- end of [7]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Red WW2 & Korea fighter presets ]]
	
	--[[ Bf-109K-4 presets ]]
	unitType = "Bf-109K-4"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ FW-190A8 presets ]]
	unitType = "FW-190A8"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ FW-190D9 presets ]]
	unitType = "FW-190D9"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ MiG-15bis presets ]]
	unitType = "MiG-15bis"
	unitScenario = "ACM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "PTB300_MIG15",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "PTB300_MIG15",
				} -- end of [2]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Blue fighters ]]
	
	--[[ F-14B pre-sets ]]	
	unitType = "F-14B"
	unitScenario = "BVR_LR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{SHOULDER AIM-7MH}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{AIM_54C_Mk47}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{AIM_54C_Mk47}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{AIM_54C_Mk47}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{AIM_54C_Mk47}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{SHOULDER AIM-7MH}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-14B"
	unitScenario = "BVR_MR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{SHOULDER AIM-7MH}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{BELLY AIM-7MH}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{BELLY AIM-7MH}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{BELLY AIM-7MH}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{BELLY AIM-7MH}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{SHOULDER AIM-7MH}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-14B"
	unitScenario = "ACM_IR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{LAU-7 - AIM-9M}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{LAU-7 - AIM-9M}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-14B"
	unitScenario = "ACM"
	loadoutPresets = {	
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	
	--[[ F-15C pre-sets ]]	
	unitType = "F-15C"
	unitScenario = "BVR_LR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [5]
				[7] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				} -- end of [11]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-15C"
	unitScenario = "BVR_MR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{AIM-7H}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{AIM-7H}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{AIM-7H}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{AIM-7H}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				} -- end of [11]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-15C"
	unitScenario = "ACM_IR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [3]
				[11] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [11]
				[10] = 
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [10]
				[9] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-15C"
	unitScenario = "ACM"
	loadoutPresets = {	
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	
	--[[ F-16C_50 pre-sets ]]	
	unitType = "F-16C_50"
	unitScenario = "BVR_E"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "ALQ_184_Long",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "F-16C_50"
	unitScenario = "BVR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})	
	
	unitType = "F-16C_50"
	unitScenario = "ACM_IRX"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "F-16C_50"
	unitScenario = "ACM_IR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "F-16C_50"
	unitScenario = "ACM"
	loadoutPresets = {	
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-16C_50"
	unitScenario = "AGM"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{DAC53A2F-79CA-42FF-A77A-F5649B601308}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{DAC53A2F-79CA-42FF-A77A-F5649B601308}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [9]
				[11] = 
				{
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
				}, -- end of [11]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "F-16C_50"
	unitScenario = "LGB"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{TER_9A_2L*GBU-12}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{TER_9A_2R*GBU-12}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [9]
				[11] = 
				{
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
				}, -- end of [11]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "F-16C_50"
	unitScenario = "HARM"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "ALQ_184_Long",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{AN_ASQ_213}",
				}, -- end of [10]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ FA-18C_hornet pre-sets ]]	
	unitType = "FA-18C_hornet"
	unitScenario = "BVR_LR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})	
	
	unitType = "FA-18C_hornet"
	unitScenario = "BVR_MR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{LAU-115 - AIM-7H}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{LAU-115 - AIM-7H}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{AIM-7H}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{AIM-7H}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{LAU-115 - AIM-7H}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{LAU-115 - AIM-7H}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})	
	
	unitType = "FA-18C_hornet"
	unitScenario = "ACM_IRX"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "LAU-115_2*LAU-127_AIM-9X",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [3]
				[5] = 
				{
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
				}, -- end of [5]
				[7] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "LAU-115_2*LAU-127_AIM-9X",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "FA-18C_hornet"
	unitScenario = "ACM_IR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "LAU-115_2*LAU-127_AIM-9M",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [3]
				[5] = 
				{
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
				}, -- end of [5]
				[7] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "LAU-115_2*LAU-127_AIM-9M",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})	
	
	unitType = "FA-18C_hornet"
	unitScenario = "ACM"
	loadoutPresets = {	
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "FA-18C_hornet"
	unitScenario = "AGM"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "LAU_117_AGM_65F",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "LAU_117_AGM_65F",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{AN_ASQ_228}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "LAU_117_AGM_65F",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "LAU_117_AGM_65F",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
                                                }, -- end of [9]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "FA-18C_hornet"
	unitScenario = "HARPOON"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{AGM_84D}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{AGM_84D}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{AN_ASQ_228}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{AGM_84D}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{AGM_84D}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [9]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "FA-18C_hornet"
	unitScenario = "LGB"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{BRU33_2X_GBU-12}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{BRU33_2X_GBU-12}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{AN_ASQ_228}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{BRU33_2X_GBU-12}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{BRU33_2X_GBU-12}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [9]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "FA-18C_hornet"
	unitScenario = "HARM"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [9]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	
	--[[ Blue attacker presets ]]
	
	--[[ A-10A presets ]]
	unitType = "A-10A"
	unitScenario = "AGM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",
				}, -- end of [1]
				[3] = 
				{
					["CLSID"] = "{DAC53A2F-79CA-42FF-A77A-F5649B601308}",
				}, -- end of [3]
				[9] = 
				{
					["CLSID"] = "{DAC53A2F-79CA-42FF-A77A-F5649B601308}",
				}, -- end of [9]
				[11] = 
				{
					["CLSID"] = "{DB434044-F5D0-4F1F-9BA9-B73027E18DD3}",
				}, -- end of [11]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})


	--[[ A-10C_2 presets ]]
	unitType = "A-10C_2"
	unitScenario = "AGM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "ALQ_184",
				}, -- end of [1]
				[11] = 
				{
					["CLSID"] = "{DB434044-F5D0-4F1F-9BA9-B73027E18DD3}",
				}, -- end of [11]
				[10] = 
				{
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
				}, -- end of [10]
				[9] = 
				{
					["CLSID"] = "{DAC53A2F-79CA-42FF-A77A-F5649B601308}",
				}, -- end of [9]
				[3] = 
				{
					["CLSID"] = "{DAC53A2F-79CA-42FF-A77A-F5649B601308}",
				}, -- end of [3]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "A-10C_2"
	unitScenario = "LGB"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "ALQ_184",
				}, -- end of [1]
				[3] = 
				{
					["CLSID"] = "BRU-42_3*GBU-12",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "Fuel_Tank_FT600",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "BRU-42_3*GBU-12",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{DB434044-F5D0-4F1F-9BA9-B73027E18DD3}",
				}, -- end of [11]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})


	--[[ AJS37 presets ]]
	unitType = "AJS37"
	unitScenario = "AGM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{Robot24J}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{RB75}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{RB75}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{VIGGEN_X-TANK}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{RB75}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{RB75}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{Robot24J}",
				}, -- end of [7]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "AJS37"
	unitScenario = "RB04"
	loadoutPresets = {
				[2] = 
				{
					["CLSID"] = "{Rb04}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{Robot74}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{VIGGEN_X-TANK}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{Robot74}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{Rb04}",
				}, -- end of [6]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "AJS37"
	unitScenario = "RB15"
	loadoutPresets = {
				[2] = 
				{
					["CLSID"] = "{Rb15}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{Robot74}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{VIGGEN_X-TANK}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{Robot74}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{Rb15}",
				}, -- end of [6]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ AV8BNA presets ]]
	unitType = "AV8BNA"
	unitScenario = "AGM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{AGM_122_SIDEARM}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "LAU_117_AGM_65F",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "LAU_117_AGM_65F",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{GAU_12_Equalizer}",
				}, -- end of [4]
				[6] = 
				{
					["CLSID"] = "LAU_117_AGM_65F",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "LAU_117_AGM_65F",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [8]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Blue helicopter presets ]]
	
	--[[ AH-1W presets ]]
	unitType = "AH-1W"
	unitScenario = "AGM_RKT"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "M260_HYDRA",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "M260_HYDRA",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}",
				} -- end of [4]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ AH-64D_BLK_II presets ]]
	unitType = "AH-64D_BLK_II"
	unitScenario = "AGM_RKT"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "M261_MK151",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "M261_MK151",
				} -- end of [4]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ OH58D presets ]]
	unitType = "OH58D"
	unitScenario = "AGM_GUN"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "OH58D_M3P_L500",
				}, -- end of [1]
				[5] = 
				{
					["CLSID"] = "OH58D_AGM_114_R",
				}, -- end of [5]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ SA342L presets ]]
	unitType = "SA342L"
	unitScenario = "RKT"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{GIAT_M621_APHE}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{TELSON8_SNEBT253}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{FAS}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{IR_Deflector}",
				}, -- end of [4]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ UH-1H presets ]]
	unitType = "UH-1H"
	unitScenario = "RKT"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "M134_L",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "M261_MK151",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "M60_SIDE_L",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "M60_SIDE_R",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "M261_MK151",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "M134_R",
				} -- end of [6]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ UH-60A presets ]]
	unitType = "UH-60A"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	
	--[[ Blue Vietnam/70's era aircraft presets ]]

	--[[ F-4E pre-sets ]]	
	unitType = "F-4E-45MC"
	unitScenario = "BVR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{F4_SARGENT_TANK_370_GAL}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{AIM-9M}",
				}, -- end of [2]
				[4] = 
				{
					["CLSID"] = "{AIM-9M}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7M}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7M}",
				}, -- end of [6]
				[8] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7M}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7M}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{AIM-9M}",
				}, -- end of [10]
				[12] = 
				{
					["CLSID"] = "{AIM-9M}",
				}, -- end of [12]
				[13] = 
				{
					["CLSID"] = "{F4_SARGENT_TANK_370_GAL_R}",
				}, -- end of [13]
				[14] = 
				{
					["CLSID"] = "{HB_ALE_40_30_60}",
				}, -- end of [14]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "F-4E-45MC"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{F4_SARGENT_TANK_370_GAL}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{AIM-9M}",
				}, -- end of [2]
				[4] = 
				{
					["CLSID"] = "{AIM-9M}",
				}, -- end of [4]
				[14] = 
				{
					["CLSID"] = "{HB_ALE_40_30_60}",
				}, -- end of [14]
				[10] = 
				{
					["CLSID"] = "{AIM-9M}",
				}, -- end of [10]
				[12] = 
				{
					["CLSID"] = "{AIM-9M}",
				}, -- end of [12]
				[13] = 
				{
					["CLSID"] = "{F4_SARGENT_TANK_370_GAL_R}",
				}, -- end of [13]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "F-4E-45MC"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{F4_SARGENT_TANK_370_GAL}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{AIM-9J}",
				}, -- end of [2]
				[4] = 
				{
					["CLSID"] = "{AIM-9J}",
				}, -- end of [4]
				[14] = 
				{
					["CLSID"] = "{HB_ALE_40_30_60}",
				}, -- end of [14]
				[10] = 
				{
					["CLSID"] = "{AIM-9J}",
				}, -- end of [10]
				[12] = 
				{
					["CLSID"] = "{AIM-9J}",
				}, -- end of [12]
				[13] = 
				{
					["CLSID"] = "{F4_SARGENT_TANK_370_GAL_R}",
				}, -- end of [13]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "F-4E-45MC"
	unitScenario = "ACM"
	loadoutPresets = {	
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-4E-45MC"
	unitScenario = "GPBOMB"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{HB_F4E_MK-82_6x}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{HB_F4E_MK-82_2x_SWA}",
					["settings"] = 
					{
						["NFP_VIS_DrawArgNo_57"] = 0,
						["arm_delay_ctrl_M904E4"] = 2,
						["arm_delay_ctrl_M905"] = 4,
						["function_delay_ctrl_M905"] = 0,
						["NFP_fuze_type_tail"] = "M905",
						["NFP_fuze_type_nose"] = "M904E4",
						["function_delay_ctrl_M904E4"] = 0,
					}, -- end of ["settings"]
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7E-2}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7E-2}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{HB_F4E_MK-82_6x}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7E-2}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7E-2}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{HB_F4E_MK-82_2x_SWA}",
					["settings"] = 
					{
						["NFP_VIS_DrawArgNo_57"] = 0,
						["arm_delay_ctrl_M904E4"] = 2,
						["arm_delay_ctrl_M905"] = 4,
						["function_delay_ctrl_M905"] = 0,
						["NFP_fuze_type_tail"] = "M905",
						["NFP_fuze_type_nose"] = "M904E4",
						["function_delay_ctrl_M904E4"] = 0,
					}, -- end of ["settings"]
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [12]
				[13] = 
				{
					["CLSID"] = "{HB_F4E_MK-82_6x}",
				}, -- end of [13]
				[14] = 
				{
					["CLSID"] = "{HB_ALE_40_30_60}",
				}, -- end of [14]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})	
	
	unitType = "F-4E-45MC"
	unitScenario = "GPBOMB_RKT"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{HB_F4E_MK-82_6x}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{LAU3_FFAR_MK5HEAT}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7E-2}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7E-2}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{HB_F4E_MK-82_6x}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7E-2}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7E-2}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{LAU3_FFAR_MK5HEAT}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [12]
				[13] = 
				{
					["CLSID"] = "{HB_F4E_MK-82_6x}",
				}, -- end of [13]
				[14] = 
				{
					["CLSID"] = "{HB_ALE_40_30_60}",
				}, -- end of [14]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-4E-45MC"
	unitScenario = "TV_AGM"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{AGM_62_I}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{AGM_62_I}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7E-2}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7E-2}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{F4_SARGENT_TANK_600_GAL}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7E-2}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7E-2}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{AGM_62_I}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [12]
				[13] = 
				{
					["CLSID"] = "{AGM_62_I}",
				}, -- end of [13]
				[14] = 
				{
					["CLSID"] = "{HB_ALE_40_30_60}",
				}, -- end of [14]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-4E-45MC"
	unitScenario = "IR_AGM"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{F4_SARGENT_TANK_370_GAL}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{HB_F4EAGM-65D_LAU88_3x_Left}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7E-2}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{HB_ALQ-131_ON_ADAPTER_IN_AERO7}",
				}, -- end of [6]
				[8] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7E-2}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7E-2}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{HB_F4EAGM-65D_LAU88_3x_Right}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [12]
				[13] = 
				{
					["CLSID"] = "{F4_SARGENT_TANK_370_GAL_R}",
				}, -- end of [13]
				[14] = 
				{
					["CLSID"] = "{HB_ALE_40_30_60}",
				}, -- end of [14]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-4E-45MC"
	unitScenario = "SHRIKEMK37"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{LAU_34_AGM_45A}",
					["settings"] = 
					{
						["rf_upper_limit_ctrl_Mk37"] = 1000000000,
						["NFP_PRESID"] = "AGM_45",
						["NFP_PRESVER"] = 1,
						["NFP_rfgu_type"] = 7,
						["EAS_bypass_ctrl"] = 0,
						["smoke_marker"] = 0,
						["rf_lower_limit_ctrl_Mk37"] = 800000000,
					}, -- end of ["settings"]
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{LAU_34_AGM_45A_SWA}",
					["settings"] = 
					{
						["rf_upper_limit_ctrl_Mk37"] = 1000000000,
						["NFP_rfgu_type"] = 7,
						["NFP_PRESID"] = "AGM_45",
						["rf_lower_limit_ctrl_Mk37"] = 800000000,
						["EAS_bypass_ctrl"] = 0,
						["smoke_marker"] = 0,
						["NFP_PRESVER"] = 1,
					}, -- end of ["settings"]
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7F}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{HB_ALQ-131_ON_ADAPTER_IN_AERO7}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{F4_SARGENT_TANK_600_GAL}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7F}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7F}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{LAU_34_AGM_45A_SWA}",
					["settings"] = 
					{
						["rf_upper_limit_ctrl_Mk37"] = 1000000000,
						["NFP_rfgu_type"] = 7,
						["NFP_PRESID"] = "AGM_45",
						["rf_lower_limit_ctrl_Mk37"] = 800000000,
						["EAS_bypass_ctrl"] = 0,
						["smoke_marker"] = 0,
						["NFP_PRESVER"] = 1,
					}, -- end of ["settings"]
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [12]
				[13] = 
				{
					["CLSID"] = "{LAU_34_AGM_45A}",
					["settings"] = 
					{
						["rf_upper_limit_ctrl_Mk37"] = 1000000000,
						["NFP_rfgu_type"] = 7,
						["NFP_PRESID"] = "AGM_45",
						["rf_lower_limit_ctrl_Mk37"] = 800000000,
						["EAS_bypass_ctrl"] = 0,
						["smoke_marker"] = 0,
						["NFP_PRESVER"] = 1,
					}, -- end of ["settings"]
				}, -- end of [13]
				[14] = 
				{
					["CLSID"] = "{HB_ALE_40_30_60}",
				}, -- end of [14]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-4E-45MC"
	unitScenario = "SHRIKEMK49"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{LAU_34_AGM_45A}",
					["settings"] = 
					{
						["rf_lower_limit_ctrl_Mk49Mod1"] = 6000000000,
						["rf_upper_limit_ctrl_Mk49Mod1"] = 10000000000,
						["NFP_PRESID"] = "AGM_45",
						["NFP_PRESVER"] = 1,
						["smoke_marker"] = 0,
						["EAS_bypass_ctrl"] = 0,
						["NFP_rfgu_type"] = 9,
						["G_bias"] = true,
					}, -- end of ["settings"]
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{LAU_34_AGM_45A_SWA}",
					["settings"] = 
					{
						["rf_lower_limit_ctrl_Mk49Mod1"] = 6000000000,
						["rf_upper_limit_ctrl_Mk49Mod1"] = 10000000000,
						["NFP_PRESID"] = "AGM_45",
						["NFP_PRESVER"] = 1,
						["smoke_marker"] = 0,
						["EAS_bypass_ctrl"] = 0,
						["NFP_rfgu_type"] = 9,
						["G_bias"] = true,
					}, -- end of ["settings"]
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7F}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{HB_ALQ-131_ON_ADAPTER_IN_AERO7}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{F4_SARGENT_TANK_600_GAL}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7F}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7F}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{LAU_34_AGM_45A_SWA}",
					["settings"] = 
					{
						["rf_lower_limit_ctrl_Mk49Mod1"] = 6000000000,
						["rf_upper_limit_ctrl_Mk49Mod1"] = 10000000000,
						["NFP_PRESID"] = "AGM_45",
						["NFP_PRESVER"] = 1,
						["smoke_marker"] = 0,
						["EAS_bypass_ctrl"] = 0,
						["NFP_rfgu_type"] = 9,
						["G_bias"] = true,
					}, -- end of ["settings"]
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [12]
				[13] = 
				{
					["CLSID"] = "{LAU_34_AGM_45A}",
					["settings"] = 
					{
						["rf_lower_limit_ctrl_Mk49Mod1"] = 6000000000,
						["rf_upper_limit_ctrl_Mk49Mod1"] = 10000000000,
						["NFP_PRESVER"] = 1,
						["NFP_PRESID"] = "AGM_45",
						["smoke_marker"] = 0,
						["EAS_bypass_ctrl"] = 0,
						["NFP_rfgu_type"] = 9,
						["G_bias"] = true,
					}, -- end of ["settings"]
				}, -- end of [13]
				[14] = 
				{
					["CLSID"] = "{HB_ALE_40_30_60}",
				}, -- end of [14]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-4E-45MC"
	unitScenario = "SHRIKEMK50"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{LAU_34_AGM_45A}",
					["settings"] = 
					{
						["rf_upper_limit_ctrl_Mk50"] = 6000000000,
						["NFP_rfgu_type"] = 10,
						["NFP_PRESVER"] = 1,
						["smoke_marker"] = 0,
						["EAS_bypass_ctrl"] = 0,
						["NFP_PRESID"] = "AGM_45",
						["rf_lower_limit_ctrl_Mk50"] = 2000000000,
					}, -- end of ["settings"]
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{LAU_34_AGM_45A_SWA}",
					["settings"] = 
					{
						["rf_upper_limit_ctrl_Mk50"] = 6000000000,
						["NFP_rfgu_type"] = 10,
						["NFP_PRESVER"] = 1,
						["smoke_marker"] = 0,
						["EAS_bypass_ctrl"] = 0,
						["NFP_PRESID"] = "AGM_45",
						["rf_lower_limit_ctrl_Mk50"] = 2000000000,
					}, -- end of ["settings"]
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7F}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{HB_ALQ-131_ON_ADAPTER_IN_AERO7}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{F4_SARGENT_TANK_600_GAL}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7F}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7F}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{LAU_34_AGM_45A_SWA}",
					["settings"] = 
					{
						["rf_upper_limit_ctrl_Mk50"] = 6000000000,
						["NFP_rfgu_type"] = 10,
						["NFP_PRESVER"] = 1,
						["smoke_marker"] = 0,
						["EAS_bypass_ctrl"] = 0,
						["NFP_PRESID"] = "AGM_45",
						["rf_lower_limit_ctrl_Mk50"] = 2000000000,
					}, -- end of ["settings"]
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{AIM-9L}",
				}, -- end of [12]
				[13] = 
				{
					["CLSID"] = "{LAU_34_AGM_45A}",
					["settings"] = 
					{
						["NFP_PRESVER"] = 1,
						["rf_upper_limit_ctrl_Mk50"] = 6000000000,
						["NFP_PRESID"] = "AGM_45",
						["NFP_rfgu_type"] = 10,
						["EAS_bypass_ctrl"] = 0,
						["smoke_marker"] = 0,
						["rf_lower_limit_ctrl_Mk50"] = 2000000000,
					}, -- end of ["settings"]
				}, -- end of [13]
				[14] = 
				{
					["CLSID"] = "{HB_ALE_40_30_60}",
				}, -- end of [14]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	
	--[[ F-5E-3 pre-sets ]]	
	unitType = "F-5E-3"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{AIM-9P5}",
				}, -- end of [1]
				[7] = 
				{
					["CLSID"] = "{AIM-9P5}",
				}, -- end of [7]
				[4] = 
				{
					["CLSID"] = "{0395076D-2F77-4420-9D33-087A4398130B}",
				} -- end of [4]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-5E-3"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
				}, -- end of [1]
				[7] = 
				{
					["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
				}, -- end of [7]
				[4] = 
				{
					["CLSID"] = "{0395076D-2F77-4420-9D33-087A4398130B}",
				}, -- end of [4]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-5E-3"
	unitScenario = "ACM"
	loadoutPresets = {	
				[4] = 
				{
					["CLSID"] = "{0395076D-2F77-4420-9D33-087A4398130B}",
				} -- end of [4]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "F-5E-3"
	unitScenario = "GPBOMB_RKT"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{AIM-9P5}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "LAU3_HE5",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{MER-5E_MK82x5}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "LAU3_HE5",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{AIM-9P5}",
				}, -- end of [7]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	
	--[[ F-14A-135-GR pre-sets ]]	
	unitType = "F-14A-135-GR"
	unitScenario = "BVR_LR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{SHOULDER AIM-7MH}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{AIM_54A_Mk60}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{AIM_54A_Mk60}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{AIM_54A_Mk60}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{AIM_54A_Mk60}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{SHOULDER AIM-7MH}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	unitType = "F-14A-135-GR"
	unitScenario = "BVR_MR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{SHOULDER AIM-7MH}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{BELLY AIM-7MH}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{BELLY AIM-7MH}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{BELLY AIM-7MH}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{BELLY AIM-7MH}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{SHOULDER AIM-7MH}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	unitType = "F-14A-135-GR"
	unitScenario = "ACM_IR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{LAU-7 - AIM-9M}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{LAU-7 - AIM-9M}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	unitType = "F-14A-135-GR"
	unitScenario = "ACM"
	loadoutPresets = {	
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	
	--[[ Blue WW2 & Korea aircraft presets ]]
	
	
	--[[ F-86F Sabre presets ]]
	unitType = "F-86F Sabre"
	unitScenario = "ACM"
	loadoutPresets = {
				[4] = 
				{
					["CLSID"] = "{PTB_120_F86F35}",
				}, -- end of [4]
				[7] = 
				{
					["CLSID"] = "{PTB_120_F86F35}",
				} -- end of [7]
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ I-16 presets ]]
	unitType = "I-16"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ MosquitoFBMkVI presets ]]
	unitType = "MosquitoFBMkVI"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ P-47D-40 presets ]]
	unitType = "P-47D-40"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ P-51D-30-NA presets ]]
	unitType = "P-51D-30-NA"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ SpitfireLFMkIX presets ]]
	unitType = "SpitfireLFMkIX"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresetsBluFor, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	if (debugFlgBluFor == 2) then
		for i=1, #tblLoadoutPresetsBluFor do
			trigger.action.outText("tblLoadoutPresetsBluFor row #: " .. i .. ", Preset type: " .. tblLoadoutPresetsBluFor[i].ut .. ", Preset scenario: " .. tblLoadoutPresetsBluFor[i].us, 10)	
		end
	end
end

--[[
############################################################################################
Function:	SpawnBluForACGroup
Purpose:	Spawns 1-4 units of the specified unit type, with two waypoints as specified
Parameters:	pUnitName - Unit name initiating the spawning of units
			pCountry - Country ID of group to be spawned (country.id enum)
			pType - Unit type
			pNum - Number of units
			pSkill - Skill of unit(s)
			pEngScen - Engagement scenario 
			pHeadingRad - Unit heading in radians
			pWP1Vec3 - Vec3 table (point) w/altitude, longitude and latitude of waypoint 1
			pWP2Vec3 - Vec3 table (point) w/altitude, longitude and latitude of waypoint 2
			pSpeed - Unit speed at both waypoints
			pMissionType - Mission type designation (e.g. CAP, CAS)
			ptblTargetId - Table of ground target group ids, only applicable to CAS
Returns:	Group object
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]
function SpawnBluForACGroup(pUnitName, pCountry, pType, pNum, pSkill, pEngScen, pHeadingRad, pWP1Vec3, pWP2Vec3, pSpeed, pMissionType, ptblTargetId)
	if (debugFlgBluFor == 2) then
		trigger.action.outText("SpawnBluForACGroup 1", 20)	
	end

	if (pUnitName == nil or pCountry == nil or pType == nil or pNum == nil or pSkill == nil or pEngScen == nil or
			pHeadingRad == nil or pWP1Vec3 == nil or pWP2Vec3 == nil or pSpeed == nil or pMissionType == nil or
			ptblTargetId == nil) then
		return
	end
	
	
	glbUnitIdBluFor = glbUnitIdBluFor + 1
	glbGroupIdBluFor = glbGroupIdBluFor + 1
	glbOnBoardNumBluFor = glbOnBoardNumBluFor + 1
	
	local lName = tostring(pType) .. "-" .. tostring(glbUnitIdBluFor)
	local lGroupID = glbGroupIdBluFor
		
	local lAlt1 = pWP1Vec3.y
	local lLongX1 = pWP1Vec3.x
	local lLattY1 = pWP1Vec3.z
	local lAlt2 = pWP2Vec3.y
	local lLongX2 = pWP2Vec3.x
	local lLattY2 = pWP2Vec3.z

	local unitFuel = 2000
	local unitFlares = 32
	local unitChaff = 32
	local unitLivery = ""
	local unitCategory = Group.Category.AIRPLANE
	local unitCoalition = coalition.side.NEUTRAL
	
	local tblWP1Tasks = {}
	local tblWP2Tasks = {}
	
	local lExpendAmt = "Auto"
	
	if (debugFlgBluFor == 2) then
		trigger.action.outText("SpawnBluForACGroup 2; lName=" .. lName, 30)	
	end

	for i=1, #tblFuFlChLiPresetsBluFor do 
		if (tblFuFlChLiPresetsBluFor[i].ut == pType and tblFuFlChLiPresetsBluFor[i].co == pCountry) then
			unitFuel = tblFuFlChLiPresetsBluFor[i].fu
			unitFlares = tblFuFlChLiPresetsBluFor[i].fl
			unitChaff = tblFuFlChLiPresetsBluFor[i].ch
			unitLivery = tblFuFlChLiPresetsBluFor[i].li
			unitCategory = tblFuFlChLiPresetsBluFor[i].cat
			unitCoalition =  tblFuFlChLiPresetsBluFor[i].cl
			break
		end
	end
	
	if (debugFlgBluFor == 2) then
		trigger.action.outText("SpawnBluForACGroup 3", 30)	
	end

	local lUnit = Unit.getByName(pUnitName)
	local lUid = Unit.getID(lUnit)

	if (debugFlgBluFor == 2) then
		trigger.action.outText("SpawnBluForACGroup 4, unitCategory = " .. unitCategory, 30)	
	end
	
	if (debugFlgBluFor == 2) then
		trigger.action.outText("SpawnBluForACGroup: pUnitName: " .. pUnitName .. ", lUid: " .. lUid, 30)	
	end
	
	-- table for first waypoint tasks
	if (pMissionType == "CAP") then
		tblWP1Tasks = {
							[1] = 
							{
								["enabled"] = true,
								["key"] = "CAP",
								["id"] = "EngageTargets",
								["number"] = 1,
								["auto"] = true,
								["params"] = 
								{
									["targetTypes"] = {
										[1] = "Air",
									}, -- end of ["targetTypes"]
									["priority"] = 0,
								}, -- end of ["params"]
							}, -- end of [1]
							[2] = 
							{
								["enabled"] = true,
								["auto"] = true,
								["id"] = "WrappedAction",
								["number"] = 2,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["value"] = true,
											["name"] = 17,
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [2]
							[3] = 
							{
								["enabled"] = true,
								["auto"] = true,
								["id"] = "WrappedAction",
								["number"] = 3,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["value"] = 4,
											["name"] = 18,
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [3]
							[4] = 
							{
								["enabled"] = true,
								["auto"] = true,
								["id"] = "WrappedAction",
								["number"] = 4,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["value"] = true,
											["name"] = 19,
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [4]
							[5] = 
							{
								["enabled"] = true,
								["auto"] = true,
								["id"] = "WrappedAction",
								["number"] = 5,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["targetTypes"] = 
											{
											}, -- end of ["targetTypes"]
											["name"] = 21,
											["value"] = "none;",
											["noTargetTypes"] = 
											{
												[1] = "Fighters",
												[2] = "Multirole fighters",
												[3] = "Bombers",
												[4] = "Helicopters",
												[5] = "Infantry",
												[6] = "Fortifications",
												[7] = "Tanks",
												[8] = "IFV",
												[9] = "APC",
												[10] = "Artillery",
												[11] = "Unarmed vehicles",
												[12] = "AAA",
												[13] = "SR SAM",
												[14] = "MR SAM",
												[15] = "LR SAM",
												[16] = "Aircraft Carriers",
												[17] = "Cruisers",
												[18] = "Destroyers",
												[19] = "Frigates",
												[20] = "Corvettes",
												[21] = "Light armed ships",
												[22] = "Unarmed ships",
												[23] = "Submarines",
												[24] = "Cruise missiles",
												[25] = "Antiship Missiles",
												[26] = "AA Missiles",
												[27] = "AG Missiles",
												[28] = "SA Missiles",
												[29] = "UAVs",
											}, -- end of ["noTargetTypes"]
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [5]
						}
	elseif (pMissionType == "CAS") then
		tblWP1Tasks = {
							[1] = 
							{
								["enabled"] = false,
								["auto"] = true,
								["id"] = "EngageTargets",
								["number"] = 1,
								["key"] = "CAS",
								["params"] = 
								{
									["targetTypes"] = 
									{
										[1] = "Helicopters",
										[2] = "Ground Units",
										[3] = "Light armed ships",
									}, -- end of ["targetTypes"]
									["priority"] = 0,
								}, -- end of ["params"]
							}, -- end of [1]
							[2] = 
							{
								["number"] = 2,
								["auto"] = true,
								["id"] = "WrappedAction",
								["enabled"] = true,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["value"] = 2,
											["name"] = 1,
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [2]
							[3] = 
							{
								["number"] = 3,
								["auto"] = true,
								["id"] = "WrappedAction",
								["enabled"] = true,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["value"] = 1,
											["name"] = 3,
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [3]
							[4] = 
							{
								["number"] = 4,
								["auto"] = true,
								["id"] = "WrappedAction",
								["enabled"] = true,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["variantIndex"] = 2,
											["name"] = 5,
											["formationIndex"] = 2,
											["value"] = 131074,
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [4]
							[5] = 
							{
								["number"] = 5,
								["auto"] = true,
								["id"] = "WrappedAction",
								["enabled"] = true,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["value"] = true,
											["name"] = 15,
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [5]
							[6] = 
							{
								["number"] = 6,
								["auto"] = true,
								["id"] = "WrappedAction",
								["enabled"] = true,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["targetTypes"] = 
											{
											}, -- end of ["targetTypes"]
											["name"] = 21,
											["value"] = "none;",
											["noTargetTypes"] = 
											{
												[1] = "Fighters",
												[2] = "Multirole fighters",
												[3] = "Bombers",
												[4] = "Helicopters",
												[5] = "UAVs",
												[6] = "Infantry",
												[7] = "Fortifications",
												[8] = "Tanks",
												[9] = "IFV",
												[10] = "APC",
												[11] = "Artillery",
												[12] = "Unarmed vehicles",
												[13] = "AAA",
												[14] = "SR SAM",
												[15] = "MR SAM",
												[16] = "LR SAM",
												[17] = "Aircraft Carriers",
												[18] = "Cruisers",
												[19] = "Destroyers",
												[20] = "Frigates",
												[21] = "Corvettes",
												[22] = "Light armed ships",
												[23] = "Unarmed ships",
												[24] = "Submarines",
												[25] = "Cruise missiles",
												[26] = "Antiship Missiles",
												[27] = "AA Missiles",
												[28] = "AG Missiles",
												[29] = "SA Missiles",
											}, -- end of ["noTargetTypes"]
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [6]
							[7] = 
							{
								["number"] = 7,
								["auto"] = true,
								["id"] = "WrappedAction",
								["enabled"] = true,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["value"] = true,
											["name"] = 19,
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [7]
						}
	elseif (pMissionType == "SEAD") then
		tblWP1Tasks = {
							[1] = 
							{
								["number"] = 1,
								["key"] = "SEAD",
								["id"] = "EngageTargets",
								["enabled"] = true,
								["auto"] = true,
								["params"] = 
								{
									["targetTypes"] = 
									{
										[1] = "Air Defence",
									}, -- end of ["targetTypes"]
									["priority"] = 0,
								}, -- end of ["params"]
							}, -- end of [1]
							[2] = 
							{
								["number"] = 2,
								["auto"] = true,
								["id"] = "WrappedAction",
								["enabled"] = true,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["value"] = 2,
											["name"] = 1,
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [2]
							[3] = 
							{
								["number"] = 3,
								["auto"] = true,
								["id"] = "WrappedAction",
								["enabled"] = true,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["value"] = 2,
											["name"] = 13,
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [3]
							[4] = 
							{
								["number"] = 4,
								["auto"] = true,
								["id"] = "WrappedAction",
								["enabled"] = true,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["value"] = true,
											["name"] = 19,
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [4]
							[5] = 
							{
								["number"] = 5,
								["auto"] = true,
								["id"] = "WrappedAction",
								["enabled"] = true,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["targetTypes"] = 
											{
												[1] = "Air Defence",
											}, -- end of ["targetTypes"]
											["name"] = 21,
											["value"] = "Air Defence;",
											["noTargetTypes"] = 
											{
												[1] = "Fighters",
												[2] = "Multirole fighters",
												[3] = "Bombers",
												[4] = "Helicopters",
												[5] = "UAVs",
												[6] = "Infantry",
												[7] = "Fortifications",
												[8] = "Tanks",
												[9] = "IFV",
												[10] = "APC",
												[11] = "Artillery",
												[12] = "Unarmed vehicles",
												[13] = "Aircraft Carriers",
												[14] = "Cruisers",
												[15] = "Destroyers",
												[16] = "Frigates",
												[17] = "Corvettes",
												[18] = "Light armed ships",
												[19] = "Unarmed ships",
												[20] = "Submarines",
												[21] = "Cruise missiles",
												[22] = "Antiship Missiles",
												[23] = "AA Missiles",
												[24] = "AG Missiles",
												[25] = "SA Missiles",
											}, -- end of ["noTargetTypes"]
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [5]
						}
	elseif (pMissionType == "AntiShip") then
		tblWP1Tasks = {
							[1] = 
							{
								["enabled"] = true,
								["key"] = "AntiShip",
								["id"] = "EngageTargets",
								["number"] = 1,
								["auto"] = true,
								["params"] = 
								{
									["targetTypes"] = 
									{
										[1] = "Ships",
									}, -- end of ["targetTypes"]
									["priority"] = 0,
								}, -- end of ["params"]
							}, -- end of [1]
							[2] = 
							{
								["enabled"] = true,
								["auto"] = true,
								["id"] = "WrappedAction",
								["number"] = 2,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["value"] = 1,
											["name"] = 1,
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [2]
							[3] = 
							{
								["enabled"] = true,
								["auto"] = true,
								["id"] = "WrappedAction",
								["number"] = 3,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["value"] = 1,
											["name"] = 3,
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [3]
							[4] = 
							{
								["enabled"] = true,
								["auto"] = true,
								["id"] = "WrappedAction",
								["number"] = 4,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["variantIndex"] = 2,
											["name"] = 5,
											["formationIndex"] = 2,
											["value"] = 131074,
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [4]
							[5] = 
							{
								["enabled"] = true,
								["auto"] = true,
								["id"] = "WrappedAction",
								["number"] = 5,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["value"] = true,
											["name"] = 15,
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [5]
							[6] = 
							{
								["enabled"] = true,
								["auto"] = true,
								["id"] = "WrappedAction",
								["number"] = 6,
								["params"] = 
								{
									["action"] = 
									{
										["id"] = "Option",
										["params"] = 
										{
											["targetTypes"] = 
											{
											}, -- end of ["targetTypes"]
											["name"] = 21,
											["value"] = "none;",
											["noTargetTypes"] = 
											{
												[1] = "Fighters",
												[2] = "Multirole fighters",
												[3] = "Bombers",
												[4] = "Helicopters",
												[5] = "UAVs",
												[6] = "Infantry",
												[7] = "Fortifications",
												[8] = "Tanks",
												[9] = "IFV",
												[10] = "APC",
												[11] = "Artillery",
												[12] = "Unarmed vehicles",
												[13] = "AAA",
												[14] = "SR SAM",
												[15] = "MR SAM",
												[16] = "LR SAM",
												[17] = "Aircraft Carriers",
												[18] = "Cruisers",
												[19] = "Destroyers",
												[20] = "Frigates",
												[21] = "Corvettes",
												[22] = "Light armed ships",
												[23] = "Unarmed ships",
												[24] = "Submarines",
												[25] = "Cruise missiles",
												[26] = "Antiship Missiles",
												[27] = "AA Missiles",
												[28] = "AG Missiles",
												[29] = "SA Missiles",
											}, -- end of ["noTargetTypes"]
										}, -- end of ["params"]
									}, -- end of ["action"]
								}, -- end of ["params"]
							}, -- end of [6]
						}
	end
		
	-- table for second waypoint tasks
	if (pMissionType == "CAP" or pMissionType == "SEAD" or pMissionType == "AntiShip") then
		tblWP2Tasks = {}
		--trigger.action.outText("SpawnBluForACGroup second CAP if then, pMissionType = " .. pMissionType, 20)	
	elseif (pMissionType == "CAS") then 
		if (pEngScen == "AGM" or pEngScen == "LGB") then
			glbWeaponType = glbWeaponTypeGuided
			lExpendAmt = "Auto"
		elseif (pEngScen == "AGM_RKT" or pEngScen == "AGM_RKT_IR") then
			glbWeaponType = glbWeaponTypeAuto
			lExpendAmt = "Auto"
		elseif (pEngScen == "GPBOMB" or pEngScen == "RKT" or pEngScen == "GPBOMB_RKT") then
			glbWeaponType = glbWeaponTypeUnguided
			lExpendAmt = "Half"
		else
			glbWeaponType = glbWeaponTypeAuto
			lExpendAmt = "Auto"
		end
		
		if (TableLengthBluFor(ptblTargetId) == 1) then
			tblWP2Tasks = {
							[1] = 
							{
								["number"] = 1,
								["auto"] = false,
								["id"] = "AttackGroup",
								["enabled"] = true,
								["params"] = 
								{
									["groupAttack"] = "false",
									["groupId"] = ptblTargetId[1].grpID,
									["attackQtyLimit"] = false,
									["attackQty"] = 4,
									["expend"] = lExpendAmt,
									["altitude"] = lAlt2,
									["directionEnabled"] = false,
									["direction"] = 0,
									["weaponType"] = glbWeaponType,
									["altitudeEnabled"] = false,
								}, -- end of ["params"]
							}, -- end of [1]
						}
		elseif (TableLengthBluFor(ptblTargetId) == 2) then
			tblWP2Tasks = {
							[1] = 
							{
								["number"] = 1,
								["auto"] = false,
								["id"] = "AttackGroup",
								["enabled"] = true,
								["params"] = 
								{
									["groupAttack"] = "false",
									["groupId"] = ptblTargetId[1].grpID,
									["attackQtyLimit"] = false,
									["attackQty"] = 4,
									["expend"] = lExpendAmt,
									["altitude"] = lAlt2,
									["directionEnabled"] = false,
									["direction"] = 0,
									["weaponType"] = glbWeaponType,
									["altitudeEnabled"] = false,
								}, -- end of ["params"]
							}, -- end of [1]
							[2] = 
							{
								["number"] = 1,
								["auto"] = false,
								["id"] = "AttackGroup",
								["enabled"] = true,
								["params"] = 
								{
									["groupAttack"] = "false",
									["groupId"] = ptblTargetId[2].grpID,
									["attackQtyLimit"] = false,
									["attackQty"] = 4,
									["expend"] = lExpendAmt,
									["altitude"] = lAlt2,
									["directionEnabled"] = false,
									["direction"] = 0,
									["weaponType"] = glbWeaponType,
									["altitudeEnabled"] = false,
								}, -- end of ["params"]
							}, -- end of [2]
						}
		elseif (TableLengthBluFor(ptblTargetId) == 3) then
			tblWP2Tasks = {
							[1] = 
							{
								["number"] = 1,
								["auto"] = false,
								["id"] = "AttackGroup",
								["enabled"] = true,
								["params"] = 
								{
									["groupAttack"] = "false",
									["groupId"] = ptblTargetId[1].grpID,
									["attackQtyLimit"] = false,
									["attackQty"] = 4,
									["expend"] = lExpendAmt,
									["altitude"] = lAlt2,
									["directionEnabled"] = false,
									["direction"] = 0,
									["weaponType"] = glbWeaponType,
									["altitudeEnabled"] = false,
								}, -- end of ["params"]
							}, -- end of [1]
							[2] = 
							{
								["number"] = 1,
								["auto"] = false,
								["id"] = "AttackGroup",
								["enabled"] = true,
								["params"] = 
								{
									["groupAttack"] = "false",
									["groupId"] = ptblTargetId[2].grpID,
									["attackQtyLimit"] = false,
									["attackQty"] = 4,
									["expend"] = lExpendAmt,
									["altitude"] = lAlt2,
									["directionEnabled"] = false,
									["direction"] = 0,
									["weaponType"] = glbWeaponType,
									["altitudeEnabled"] = false,
								}, -- end of ["params"]
							}, -- end of [2]
							[3] = 
							{
								["number"] = 1,
								["auto"] = false,
								["id"] = "AttackGroup",
								["enabled"] = true,
								["params"] = 
								{
									["groupAttack"] = "false",
									["groupId"] = ptblTargetId[3].grpID,
									["attackQtyLimit"] = false,
									["attackQty"] = 4,
									["expend"] = lExpendAmt,
									["altitude"] = lAlt2,
									["directionEnabled"] = false,
									["direction"] = 0,
									["weaponType"] = glbWeaponType,
									["altitudeEnabled"] = false,
								}, -- end of ["params"]
							}, -- end of [3]
						}
		else
			tblWP2Tasks = {}
		end
	end
	
	local lMissionType = pMissionType
	if (pMissionType == "AntiShip") then
		lMissionType = "Antiship Strike"
	end
	
	local callSignName = ""
	local callSignNameNumber1 = ""
	if (coalition.getCountryCoalition(pCountry) == coalition.side.RED) then
		callSignName = tostring(glbOnBoardNumBluFor)
		callSignNameNumber1 = callSignName
	elseif (coalition.getCountryCoalition(pCountry) == coalition.side.BLUE) then
		callSignName = tblBlueCallSignsBluFor[glbCurrentBlueCallSignBluFor]
		callSignNameNumber1 = callSignName .. "11"
	else
		callSignName = tostring(glbOnBoardNumBluFor)
		callSignNameNumber1 = callSignName
	end
	

	
	local groupData = 
	{
		["lateActivation"] = false,
		["tasks"] = 
		{
		}, -- end of ["tasks"]
		["radioSet"] = false,
		["task"] = lMissionType,
		["uncontrolled"] = false,
		["route"] = 
		{
			["routeRelativeTOT"] = false,
			["points"] = 
			{
				[1] = 
				{
					["alt"] = lAlt1,
					["action"] = "Turning Point",
					["alt_type"] = "BARO",
					["speed"] = pSpeed,
					["task"] = 
					{
						["id"] = "ComboTask",
						["params"] = 
						{
							["tasks"] = tblWP1Tasks, -- end of ["tasks"]
						}, -- end of ["params"]
					}, -- end of ["task"]
					["type"] = "Turning Point",
					["ETA"] = 0,
					["ETA_locked"] = true,
					["y"] = lLattY1,
					["x"] = lLongX1,
					["formation_template"] = "",
					["speed_locked"] = true,
				}, -- end of [1]
				[2] = 
				{
					["alt"] = lAlt2,
					["action"] = "Turning Point",
					["alt_type"] = "BARO",
					["speed"] = pSpeed,
					["task"] = 
					{
						["id"] = "ComboTask",
						["params"] = 
						{
							["tasks"] = tblWP2Tasks, -- end of ["tasks"]
						}, -- end of ["params"]
					}, -- end of ["task"]
					["type"] = "Turning Point",
					["ETA"] = 601.84765346067,
					["ETA_locked"] = false,
					["y"] = lLattY2,
					["x"] = lLongX2,
					["formation_template"] = "",
					["speed_locked"] = true,
				}, -- end of [2]
			}, -- end of ["points"]
		}, -- end of ["route"]
		["groupId"] = lGroupID,
		["hidden"] = "false",
		["units"] = 
		{
			[1] = 
			{
				["alt"] = lAlt1,
				["alt_type"] = "RADIO",
				["hardpoint_racks"] = true,
				["alt_type"] = "BARO",
				["livery_id"] = unitLivery,
				["skill"] = pSkill,
				["speed"] = pSpeed,
				["AddPropAircraft"] = 
				{
				}, -- end of ["AddPropAircraft"]
				["type"] = pType,
				["unitId"] = glbUnitIdBluFor,
				["psi"] = pHeadingRad*(-1),
				["y"] = lLattY1,
				["x"] = lLongX1,
				["name"] = lName,
				["payload"] = 
				{
					["pylons"] = EngagementScenarioLoadOutPresetBluFor(pType, pEngScen),
					["fuel"] = unitFuel,
					["flare"] = unitFlares,
					["chaff"] = unitChaff,
					["gun"] = 100,
				}, -- end of ["payload"]
				["heading"] = pHeadingRad,
				["callsign"] = 
				{
					[1] = 1,
					[2] = 1,
					["name"] = callSignNameNumber1,
					[3] = 1,
				}, -- end of ["callsign"]
				["onboard_num"] = tostring(glbOnBoardNumBluFor),
			}, -- end of [1]
		}, -- end of ["units"]
		["y"] = lLattY1,
		["x"] = lLongX1,
		["name"] = lName,
		["communication"] = true,
		["start_time"] = 0,
		["modulation"] = 0,
		["frequency"] = 127.5,
	}
	
	--[[ Add 2nd through Nth units to group ]]
	if (pNum > 1 and pNum < 5) then
		for i = 2,pNum do  
			lLongX1 = lLongX1 + 30
			lLattY1 = lLattY1 + 30
			groupData.units[i] = AddUnitToGroupBluFor(pType, pCountry, pEngScen, lLongX1, lLattY1, pHeadingRad, lAlt1, i)      
		end
	end

	glbCurrentBlueCallSignBluFor = glbCurrentBlueCallSignBluFor + 1
	if (glbCurrentBlueCallSignBluFor > #tblBlueCallSignsBluFor) then
		glbCurrentBlueCallSignBluFor = 1
	end

	if (debugFlgBluFor == 1) then
		trigger.action.outText("SpawnBluForACGroup 5: coalition.getCountryCoalition(" .. pCountry .. "): " .. coalition.getCountryCoalition(pCountry), 30)	
	end
	
	if ((glbBluForSpawned + #groupData.units) <= glbMaxBluForSpawnable) then
		for i=1, #groupData.units do 
			--trigger.action.outText("SpawnBluForACGroup: Unit[" .. i .. "]:unitId: " .. groupData.units[i].unitId .. ", Unit[" .. i .. "].name: " .. groupData.units[i].name, 20)
			table.insert(glbTblBluForSpawned, {gID = groupData.groupId, uID = groupData.units[i].unitId, uName = groupData.units[i].name})
		end
		--trigger.action.outText("about to spawn BluFor; glbBluForSpawned: " .. glbBluForSpawned .. ", #groupData.units: " .. #groupData.units, 10)
		return coalition.addGroup(pCountry, unitCategory, groupData)
	else
		trigger.action.outText("Cannot spawn any more BluFor aircraft, exceeds the maximum active allowed: " .. glbMaxBluForSpawnable, 10)
		trigger.action.outText("Retry after some active BluFor aircraft are destroyed or land.", 10)
		return
	end
  
end

function AddUnitToGroupBluFor(pType, pCountry, pEngScen, pLongX1, pLattY1, pHeadingRad, pAlt1, pI)

	if (pType == nil or pCountry == nil or pEngScen == nil or pLongX1 == nil or pLattY1 == nil or 
			pHeadingRad == nil or pAlt1 == nil) then
		return
	end
	
	local unitFuel = 2000
	local unitFlares = 32
	local unitChaff = 32
	local unitLivery = ""
	local lCallSignName = ""
	
	glbOnBoardNumBluFor = glbOnBoardNumBluFor + 1
	
	if (coalition.getCountryCoalition(pCountry) == coalition.side.RED) then
		lCallSignName = tostring(glbOnBoardNumBluFor)
	elseif (coalition.getCountryCoalition(pCountry) == coalition.side.BLUE) then
		lCallSignName = tblBlueCallSignsBluFor[glbCurrentBlueCallSignBluFor] .. tostring(pI) .. "1"
	else
		lCallSignName = tostring(glbOnBoardNumBluFor)
	end	

	for i=1, #tblFuFlChLiPresetsBluFor do 
		if (tblFuFlChLiPresetsBluFor[i].ut == pType and tblFuFlChLiPresetsBluFor[i].co == pCountry) then
			unitFuel = tblFuFlChLiPresetsBluFor[i].fu
			unitFlares = tblFuFlChLiPresetsBluFor[i].fl
			unitChaff = tblFuFlChLiPresetsBluFor[i].ch
			unitLivery = tblFuFlChLiPresetsBluFor[i].li
			break
		end
	end
	
	glbUnitIdBluFor = glbUnitIdBluFor + 1
	local lName = tostring(pType) .. "-" .. tostring(glbUnitIdBluFor)
    local unit =
	{
		["alt"] = pAlt1,
		["alt_type"] = "RADIO",
		["hardpoint_racks"] = true,
		["alt_type"] = "BARO",
		["livery_id"] = unitLivery,
		["skill"] = pSkill,
		["speed"] = pSpeed,
		["AddPropAircraft"] = 
		{
		}, -- end of ["AddPropAircraft"]
		["type"] = pType,
		["unitId"] = glbUnitIdBluFor,
		["psi"] = pHeadingRad*(-1),
		["y"] = pLattY1,
		["x"] = pLongX1,
		["name"] = lName,
		["payload"] = 
		{
			["pylons"] = EngagementScenarioLoadOutPresetBluFor(pType, pEngScen),
			["fuel"] = unitFuel,
			["flare"] = unitFlares,
			["chaff"] = unitChaff,
			["gun"] = 100,
		}, -- end of ["payload"]
		["heading"] = pHeadingRad,
		["callsign"] = 
		{
			[1] = pI,
			[2] = pI,
			["name"] = lCallSignName,
			[3] = 1,
		}, -- end of ["callsign"]
		["onboard_num"] = tostring(glbOnBoardNumBluFor),
    }
    return unit    
end

--[[
############################################################################################
Function:	TableLengthBluFor
Purpose:	Loops through table to determine the number of key value pairs within it
Parameters:	T - Table
Returns:	# key value pairs in a table
Author:		AKA_Relent
############################################################################################
]]
function TableLengthBluFor(T)
  local count = 0
  for _ in pairs(T) do count = count + 1 end
  return count
end

--[[
############################################################################################
Function:	CheckBluForUnitsLanded
Purpose:	Loops through glbTblBluForSpawned table every 120 seconds to check if spawned
			BluFor units are alive and have landed/stopped - then destroys (despawns) them;
			Also keeps track of how many BluFor AI aircraft are currently alive
Parameters:	pArgument (required, but nothing is passed)
			pTime - time to run this function in the future
Returns:	current time + 120 seconds
Author:		AKA_Relent
############################################################################################
]]
function CheckBluForUnitsLanded(pArgument, pTime)
	local tblVelVec3 = {}
	local lKnts = 0
	glbBluForSpawned = 0
	for i=1, #glbTblBluForSpawned do 
		tblVelVec3 = {}
		lKnts = 0
		--table.insert(glbTblBluForSpawned, {gID = groupData.groupId, uID = groupData.units[i].unitId, uName = groupData.units[i].name})
		if (Unit.getByName(glbTblBluForSpawned[i].uName) ~= nil) then
			tblVelVec3 = Unit.getByName(glbTblBluForSpawned[i].uName):getVelocity()
			lKnts = (math.sqrt (tblVelVec3.x^2 + tblVelVec3.y^2 + tblVelVec3.z^2)) * 1.9438
			--trigger.action.outText("CheckBluForUnitsLanded: unitId: " .. glbTblBluForSpawned[i].uID .. ", name: " .. glbTblBluForSpawned[i].uName ..
				--"Unit speed in knots: " .. lKnts, 20)
			if (Unit.getByName(glbTblBluForSpawned[i].uName):isActive() == true) then
				if (Unit.getByName(glbTblBluForSpawned[i].uName):inAir() == false and lKnts == 0) then
					Unit.getByName(glbTblBluForSpawned[i].uName):destroy()
				else
					glbBluForSpawned = glbBluForSpawned + 1
				end
			end
		end
	end
	--trigger.action.outText("glbBluForSpawned: " .. glbBluForSpawned, 10)
  return pTime + 120
end
timer.scheduleFunction(CheckBluForUnitsLanded, "", timer.getTime() + 120)

--[[
######################################### MAIN #############################################
]]

SetUpFuFlChLiPresetsBluFor()
SetUpLoadOutPresetsBluFor()
CheckForSinglePlayerBluFor()

trigger.action.outText(" ", 20)
trigger.action.outText("Loading BluForAC script: Blue ('Friendly') Force AI Aircraft script", 20)
trigger.action.outText(" ", 20)
trigger.action.outText("This script will spawn 1-4 friendly force AI aircraft (repeatable), which can be fighter,", 20)
trigger.action.outText("attack, multi-purpose aircraft, or helicopter types.  AI aircraft types, engagement scenarios", 20)
trigger.action.outText("(e.g. CAP, CAS, SEAD, Anti-Ship) and some pre-set target waypoint distances are selectable from", 20)
trigger.action.outText("the F10 menu, under the F10 menu item: '" .. glbOfacTopMenuBluFor .. "'", 20)
trigger.action.outText(" ", 20)



