-- Place this file in C:\Users\<username>\Saved Games\DCS_F4E\jester\mods\
local Class = require('base.Class')
local Behavior = require('base.Behavior')
local Interactions = require('base.Interactions')

local default_interval = s(5)

local Clicky = Class(Behavior)

local isFirstTick = true

local lighting_preset = 0;

function LightingDay()
    -- contrast and brightness knobs around the radar screen
    ClickRaw(Interactions.devices.HUD_AN_ASG_26, Interactions.device_commands.HUD_AdjustIntensity_AXIS, -1) -- HUD brightness       - Full bright
    ClickRaw(Interactions.devices.RADAR, Interactions.device_commands.PILOT_DSCG_SCALE_AXIS, -1)            -- Scale brightness     - Full bright
    ClickRaw(Interactions.devices.RADAR, Interactions.device_commands.PILOT_DSCG_BRIGHTNESS_AXIS, -1)       -- Screen brightness    - Full bright

    -- RWR Display Brightness
    ClickRaw(Interactions.devices.RWR_INTERFACE, Interactions.device_commands.PILOT_RWR_KNOB_AXIS, -1)     -- RWR display brightness    - Full bright
    ClickRaw(Interactions.devices.RWR_INTERFACE, Interactions.device_commands.PILOT_APR_DIM_KNOB_AXIS, -1) -- RWR button brightness     - Full bright

    -- Light settings interior
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_RIGHT_WALL_INSTRUMENT_FLOODLIGHT_BRIGHTNESS_SWITCH_AXIS, 0)  -- Instrument flood switch   - Off
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_CONSOLE_FLOODLIGHT_BRIGHTNESS_SWITCH_AXIS, 0) -- Red Flood switch          - Dim
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_WHITE_FLOODLIGHT_SWITCH_AXIS, 1)              -- White flood switch        - Off
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_CONSOLE_BRIGHTNESS_KNOB_AXIS, 1)              -- Console light knob        - Minimum
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_INSTRUMENT_PANEL_BRIGHTNESS_KNOB_AXIS, 1)     -- Instrument light knob     - Minimum
end

function LightingMid()
    -- contrast and brightness knobs around the radar screen
    ClickRaw(Interactions.devices.HUD_AN_ASG_26, Interactions.device_commands.HUD_AdjustIntensity_AXIS, -0.6) -- HUD brightness     - Mostly bright
    ClickRaw(Interactions.devices.RADAR, Interactions.device_commands.PILOT_DSCG_SCALE_AXIS, -0.6)            -- Scale brightness   - Mostly bright
    ClickRaw(Interactions.devices.RADAR, Interactions.device_commands.PILOT_DSCG_BRIGHTNESS_AXIS, -0.6)       -- Screen brightness  - Mostly bright

    -- RWR Display Brightness
    ClickRaw(Interactions.devices.RWR_INTERFACE, Interactions.device_commands.PILOT_RWR_KNOB_AXIS, -0.6)     -- RWR display brightness    - Mostly bright
    ClickRaw(Interactions.devices.RWR_INTERFACE, Interactions.device_commands.PILOT_APR_DIM_KNOB_AXIS, -0.6) -- RWR button brightness     - Mostly bright

    -- Light settings interior
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_RIGHT_WALL_INSTRUMENT_FLOODLIGHT_BRIGHTNESS_SWITCH_AXIS, 1)  -- Instrument flood switch   - Off
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_CONSOLE_FLOODLIGHT_BRIGHTNESS_SWITCH_AXIS, 1) -- Red Flood switch          - Dim //
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_WHITE_FLOODLIGHT_SWITCH_AXIS, 1)              -- White flood switch        - Off
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_CONSOLE_BRIGHTNESS_KNOB_AXIS, 0)              -- Console light knob        - Half
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_INSTRUMENT_PANEL_BRIGHTNESS_KNOB_AXIS, 0)     -- Instrument light knob     - Half
end

function LightingNight()
    -- contrast and brightness knobs around the radar screen
    ClickRaw(Interactions.devices.HUD_AN_ASG_26, Interactions.device_commands.HUD_AdjustIntensity_AXIS, 0.5) -- HUD brightness  - Mostly dim
    ClickRaw(Interactions.devices.RADAR, Interactions.device_commands.PILOT_DSCG_SCALE_AXIS, 0.5)    -- Scale brightness        - Mostly dim
    ClickRaw(Interactions.devices.RADAR, Interactions.device_commands.PILOT_DSCG_BRIGHTNESS_AXIS, 0.5) -- Screen brightness     - Mostly dim

    -- RWR Display Brightness
    ClickRaw(Interactions.devices.RWR_INTERFACE, Interactions.device_commands.PILOT_RWR_KNOB_AXIS, 0.5)     -- RWR display brightness   - Dim
    ClickRaw(Interactions.devices.RWR_INTERFACE, Interactions.device_commands.PILOT_APR_DIM_KNOB_AXIS, 0.5) -- RWR button brightness    - Dim

    -- Light settings interior
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_RIGHT_WALL_INSTRUMENT_FLOODLIGHT_BRIGHTNESS_SWITCH_AXIS, -1)  -- Instrument flood switch   - On
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_CONSOLE_FLOODLIGHT_BRIGHTNESS_SWITCH_AXIS, -1)  -- Red Flood switch          - Bright //
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_WHITE_FLOODLIGHT_SWITCH_AXIS, 0)               -- White flood switch        - On
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_CONSOLE_BRIGHTNESS_KNOB_AXIS, -1)              -- Console light knob        - Full bright
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_INSTRUMENT_PANEL_BRIGHTNESS_KNOB_AXIS, -1)     -- Instrument light knob     - Full bright
end

function RandomizeSwitchPositions()
    -- ********************
    --       Radio/IFF
    --********************
    -- Radio preset and Frequency knobs
    -- Random presets between 1 and 10 for pri, 1 to 5 for aux
    ClickRaw(Interactions.devices.ARC164, Interactions.device_commands.PILOT_UHF_Communication_Channel_Control_Knob_AXIS, math.random()) -- Pri
    ClickRaw(Interactions.devices.ARC164, Interactions.device_commands.PILOT_UHF_AUX_Channel_Control_Knob_AXIS, math.random(0,5))        -- Aux
    --TODO freq knobs

    --Mode 3 code rollers
    local mode_3_axis_values = {-1.0, -0.666666666666, -0.333333333333, 0.0, 0.333333333333, 0.666666666666, 1.0}
    ClickRaw(Interactions.devices.IFF, Interactions.device_commands.PILOT_IFF_MODE3_CODE_THOUSANDS_AXIS, mode_3_axis_values[math.random(1, #mode_3_axis_values)]) -- Thousands roller
    ClickRaw(Interactions.devices.IFF, Interactions.device_commands.PILOT_IFF_MODE3_CODE_HUNDREDS_AXIS, mode_3_axis_values[math.random(1, #mode_3_axis_values)])  -- Hundreds roller
    ClickRaw(Interactions.devices.IFF, Interactions.device_commands.PILOT_IFF_MODE3_CODE_TENS_AXIS, mode_3_axis_values[math.random(1, #mode_3_axis_values)])      -- Tens roller
    ClickRaw(Interactions.devices.IFF, Interactions.device_commands.PILOT_IFF_MODE3_CODE_ONES_AXIS, mode_3_axis_values[math.random(1, #mode_3_axis_values)])      -- Ones roller


    -- ********************
    --       Lighting
    --********************
    local lighting_functions = {LightingDay, LightingMid, LightingNight}
    local random_index = math.random(1, #lighting_functions)
    lighting_functions[random_index]()


    -- ********************
    --       Misc
    --********************
    -- Aural audio alert sound (the Shrike and Sidewinder tone volume), 
    -- Random full range
    ClickRaw(Interactions.devices.AOASYSTEM, Interactions.device_commands.PILOT_AURAL_TONE_VOLUME_KNOB_AXIS, math.random() * 2 - 1)

end

function SetupMenus()
    local Click_Switches_Btn = Wheel.Item.new({
        name = "Click Switches",
          action = "Click_Switches",
    })

    Wheel.AddItem(Click_Switches_Btn, {})
end

function Clicky:Constructor()
	Behavior.Constructor(self)
end

function Clicky:Tick()
	if isFirstTick then
		isFirstTick = false

        --Setup menu and listener
        -- Cycle through lighting presets with button. Uncomment lines below to use
        -- SetupMenus()        

        -- ListenTo("Click_Switches", "Click_Switches", function()  
        --     if lighting_preset == 0 then
        --         LightingDay()
        --         lighting_preset = 1
        --     elseif lighting_preset == 1 then
        --         LightingMid()
        --         lighting_preset = 2
        --     elseif lighting_preset == 2 then
        --         LightingNight()
        --         lighting_preset = 0
        --     end
        -- end)

        -- Get Jester awareness of gen_switch_left
        local gen_switch_left_value = GetJester().awareness.observations.gen_switch_left.value

        -- Activate automatically on first tick if cold start
        if gen_switch_left_value == 1 then
            RandomizeSwitchPositions()
        end

    end-- End first tick
end -- End tick

Clicky:Seal()
return Clicky