----------------------- INIT -------------------------------------------------------------
-- Version: 1.3
local evento = {};
zeus = {};
zeus.target = {};

groundUnitDB ={}

napalmCounter = 1

options = {
  ["napalm"] = false, 
  ["phosphor"] = false, 
}

airUnitDB =
    {
    {AAName = "mig29"},
    {AAName = "mig23"},
    {AAName = "mig21"},
    {AAName = "j11"},
    {AAName = "m2k"},
    {AAName = "f14"},
    {AAName = "f15"},
    {AAName = "f16"},
    {AAName = "f18"},
    {AAName = "f1"},
    {AAName = "f5"},
    {AAName = "f4"},
    {AAName = "mig28"},
    {AAName = "jtac"},
    {AAName = "texaco"},
    {AAName = "arco"},
    {AAName = "p51"},
    {AAName = "spit"},
    {AAName = "mossie"},
    {AAName = "bf109"},
    {AAName = "fw190d9"},
    {AAName = "fw190a8"},
    {AAName = "ju88"},

    }

----------------------- VARIABLES -------------------------------------------------------------

zeus.target.aircraftName = "";
zeus.target.aircraftPos = nil;
zeus.target.markerPos = nil;



---------------------- FUNCTIONS ----------------------------------------------------------------------
function evento:onEvent(event)

    if (world.event.S_EVENT_MARK_CHANGE == event.id) then
        local s = event.text
        local model,unitname = s:match("(.+);(.+)")
            if (string.match(event.text, model) ~= nil) and isValidAircraft(model) == true then
                if coalition.getPlayers(coalition.side.RED)[1] ~= nil or coalition.getPlayers(coalition.side.BLUE)[1] ~= nil then
                    local index1 = string.find(event.text, ";", 0)
                    zeus.target.aircraftName = zeus.trim(string.sub(event.text, index1 + 1, string.len(event.text)))
                    zeus.target.aircraftPos = event.pos
                    if zeus.target.aircraftPos ~= nil then
                        zeus.createAircraft(model)
                        trigger.action.outText("spwan succeeded ", 10, false)
                    else
                        trigger.action.outText("INFO: You need to create a mark: aircraft_type:unitname in F10 map", 10, false)
                    end
                else
                    trigger.action.outText("There is no player in the mission. You Can't talk to zeus", 10, false)
                end
            elseif (string.match(event.text, "destroy;") ~= nil) then
                local index1 = string.find(event.text, ";", 0)
                local spawnname = zeus.trim(string.sub(event.text, index1 + 1, string.len(event.text)))
                zeus.dismissPackage(spawnname)
            elseif (string.match(event.text, "illumin;") ~= nil) then
                zeus.target.markerPos = event.pos
                zeus.illuminationBombOnMark(zeus.target.markerPos)
            elseif (string.match(event.text, "smoke;") ~= nil) then
                zeus.target.markerPos = event.pos
                local index1 = string.find(event.text, ";", 0)
                local colors = zeus.trim(string.sub(event.text, index1 + 1, string.len(event.text)))
                zeus.triggerSmoke(zeus.target.markerPos, colors)
            elseif (string.match(event.text, "strike;") ~= nil) then
                zeus.target.markerPos = event.pos
                zeus.strikeOnMark(zeus.target.markerPos)
            end
    end
end;

function zeus.trim(s)
	return (string.gsub(s, "^%s*(.-)%s*$", "%1"))
end;

function zeus.dismissPackage(spawnname)
	if Group.getByName(spawnname):getUnit(1) ~= nil then
        Group.getByName(spawnname):destroy()
	end
end;


function isValidAircraft(pmodel)
	for i, aircraft in ipairs(airUnitDB) do
		if aircraft.AAName == pmodel then
			return true
		end
	end
    --trigger.action.outText("INFO: aircraft not in zeus list or wrong name in mark ", 10, false)
	return false
end;

function zeus.illuminationBombOnMark(position)
    timer.scheduleFunction(zeus.illuminationBombOnMarkDelay, position, timer.getTime() + 15)
   
end;
function zeus.triggerIllumBomb(mark)
    trigger.action.illuminationBomb(mark, 1000000 )
end;

function zeus.illuminationBombOnMarkDelay(position)

    local altitude = math.random(600, 1200)
    local r1 = math.random(200, 300)
    local r2 = math.random(50, 150)

    local mark0 = {x = position.x, y = altitude, z = position.z}
    local mark1 = {x = position.x + r1, y = altitude, z = position.z}
    local mark2 = {x = position.x + r2, y = altitude, z = position.z}
    local mark3 = {x = position.x - r2, y = altitude, z = position.z}
    local mark4 = {x = position.x - r1, y = altitude, z = position.z}

    timer.scheduleFunction(zeus.triggerIllumBomb, mark1, timer.getTime() + 5)
    timer.scheduleFunction(zeus.triggerIllumBomb, mark2, timer.getTime() + 7)
    timer.scheduleFunction(zeus.triggerIllumBomb, mark0, timer.getTime() + 9)
    timer.scheduleFunction(zeus.triggerIllumBomb, mark3, timer.getTime() + 11)
    timer.scheduleFunction(zeus.triggerIllumBomb, mark4, timer.getTime() + 13)

end;

function zeus.strikeOnMark(position)
    for i = 5, 20 do
		timer.scheduleFunction(zeus.triggerExplosion, position, timer.getTime() + i)			
	end
end;

function zeus.explodeNapalm(vec3)
    trigger.action.explosion(vec3, 10)
end

function zeus.removeNapalm(staticName) 
StaticObject.getByName(staticName):destroy()
end

function zeus.phosphor(vec3) 
	for i =	1,math.random(3, 10) do 
        azimuth = 30 * i
		--angle = mist.utils.toRadian((math.random(1, 360)))
		--local randVec = mist.utils.makeVec3GL((mist.getRandPointInCircle(vec3, 5, 1, 0, 360)))
		trigger.action.signalFlare(vec3, 2, azimuth)
	end
end
function zeus.triggerExplosion(position)
    

        local impact = {x = position.x + math.random(-30,30), y = position.y + math.random(0,5), z = position.z + math.random(-30,30)}
        trigger.action.explosion(impact, math.random(50,200))
        
       -- function napalmOnImpact(impactPoint)
        local napalmName = "napalmImpact" .. napalmCounter
        napalmCounter = napalmCounter + 1
        local owngroupID = math.random(9999,99999)
        local cvnunitID = math.random(9999,99999)
        _dataFuel =   
            {
                ["groupId"] = owngroupID,
                ["category"] = "Fortifications",
                ["shape_name"] = "toplivo-bak",
                ["type"] = "Fuel tank",
                ["unitId"] = cvnunitID,
                ["rate"] = 100,
                ["y"] = impact.z,
                ["x"] = impact.x,
                ["name"] = napalmName,
                ["heading"] = 0,
                ["dead"] = false,
                ["hidden"] = true,
        
            } -- end of function
            
        
            
            if options.napalm == true then
                coalition.addStaticObject(country.id.CJTF_BLUE, _dataFuel )
                timer.scheduleFunction(zeus.explodeNapalm, impact, timer.getTime() + 0.1)
                timer.scheduleFunction(zeus.removeNapalm, napalmName, timer.getTime() + 0.12)
            end
          
            if options.phosphor == true then
                timer.scheduleFunction(zeus.phosphor, impact, timer.getTime() + 0.12)
            end
end;

function zeus.triggerSmoke(position, colors)
    if colors == "red" then
        trigger.action.smoke(position , trigger.smokeColor.Red)
    elseif colors == "green" then
        trigger.action.smoke(position , trigger.smokeColor.Green)
    elseif colors == "white" then
        trigger.action.smoke(position , trigger.smokeColor.White)
    end
    
end;



function zeus.createAircraft(pmodel)

    local model = pmodel
    local owngroupID = math.random(9999,99999)
    local callname = math.random(1,8)
    if model == "f5" then
        liveryID = "aggressor desert scheme"
    elseif model == "mig28" then
        liveryID = "black 'Mig-28'"
    end
	local _country = country.id.CJTF_BLUE
    if model == "jtac" or model == "texaco" or model == "arco" then
        if coalition.getPlayers(coalition.side.RED)[1] ~= nil then
            _country = country.id.CJTF_RED
        elseif coalition.getPlayers(coalition.side.BLUE)[1] ~= nil then
            _country = country.id.CJTF_BLUE
        end
    else
        if coalition.getPlayers(coalition.side.RED)[1] ~= nil then
            _country = country.id.CJTF_BLUE
        elseif coalition.getPlayers(coalition.side.BLUE)[1] ~= nil then
            _country = country.id.CJTF_RED
        end
    end

	local _droneData =
                        {
                            ["modulation"] = 0,
                                ["tasks"] =
                                {
                                }, -- end of ["tasks"]
                                ["radioSet"] = false,
                                ["task"] = "AFAC",
                                ["uncontrolled"] = false,
                                ["route"] =
                                {
                                    ["points"] =
                                    {
                                        [1] =
                                        {
                                            ["alt"] = 7620,
                                            ["action"] = "Turning Point",
                                            ["alt_type"] = "BARO",
                                            ["properties"] =
                                            {
                                                ["addopt"] =
                                                {
                                                }, -- end of ["addopt"]
                                            }, -- end of ["properties"]
                                            ["speed"] = 61.666666666667,
                                            ["task"] =
                                            {
                                                ["id"] = "ComboTask",
                                                ["params"] =
                                                {
                                                    ["tasks"] =
                                                    {
                                                        [1] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "FAC",
                                                            ["number"] = 1,
                                                            ["params"] =
                                                            {
                                                                ["number"] = 1,
                                                                ["designation"] = "Auto",
                                                                ["modulation"] = 0,
                                                                ["callname"] = callname, -- 3
                                                                ["datalink"] = true,
                                                                ["frequency"] = 134000000,
                                                            }, -- end of ["params"]
                                                        }, -- end of [1]
                                                        [2] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 2,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "EPLRS",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["groupId"] = owngroupID,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [2]
                                                        [3] =
                                                        {
                                                            ["number"] = 3,
                                                            ["auto"] = false,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "SetInvisible",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [3]
                                                        [4] =
                                                        {
                                                            ["number"] = 4,
                                                            ["auto"] = false,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "SetImmortal",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [4]
                                                    }, -- end of ["tasks"]
                                                }, -- end of ["params"]
                                            }, -- end of ["task"]
                                            ["type"] = "Turning Point",
                                            ["ETA"] = 0,
                                            ["ETA_locked"] = true,
                                            ["y"] = zeus.target.aircraftPos.z + 1000, -- spawn coord zeus.target.laserPos.z + 1000
                                            ["x"] = zeus.target.aircraftPos.x + 1000, -- spawn coord zeus.target.laserPos.x + 1000
                                            ["name"] = "Initial Point",
                                            ["speed_locked"] = true,
                                            ["formation_template"] = "",
                                        }, -- end of [1]
                                        [2] =
                                        {
                                            ["alt"] = 7620,
                                            ["action"] = "Turning Point",
                                            ["alt_type"] = "BARO",
                                            ["properties"] =
                                            {
                                                ["addopt"] =
                                                {
                                                }, -- end of ["addopt"]
                                            }, -- end of ["properties"]
                                            ["speed"] = 61.666666666667,
                                            ["task"] =
                                            {
                                                ["id"] = "ComboTask",
                                                ["params"] =
                                                {
                                                    ["tasks"] =
                                                    {
                                                        [1] =
                                                        {
                                                            ["number"] = 1,
                                                            ["auto"] = false,
                                                            ["id"] = "Orbit",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["altitude"] = 7620,
                                                                ["pattern"] = "Circle",
                                                                ["speed"] = 55.555555555556,
                                                            }, -- end of ["params"]
                                                        }, -- end of [1]
                                                    }, -- end of ["tasks"]
                                                }, -- end of ["params"]
                                            }, -- end of ["task"]
                                            ["type"] = "Turning Point",
                                            ["ETA"] = 96.011094947238,
                                            ["ETA_locked"] = false,
                                            ["y"] = zeus.target.aircraftPos.z, -- orbit spot coord zeus.target.laserPos.z
                                            ["x"] = zeus.target.aircraftPos.x, -- orbit spot coord zeus.target.laserPos.x
                                            ["name"] = "spot",
                                            ["speed_locked"] = true,
                                            ["formation_template"] = "",
                                        }, -- end of [2]
                                    }, -- end of ["points"]
                                }, -- end of ["route"]
                                ["groupId"] = owngroupID,
                                ["hidden"] = false,
                                ["units"] =
                                {
                                    [1] =
                                    {
                                        ["alt"] = 7620,
                                        ["alt_type"] = "BARO",
                                        ["livery_id"] = "'camo' scheme",
                                        ["skill"] = "High",
                                        ["speed"] = 61.666666666667,
                                        ["type"] = "MQ-9 Reaper",
                                        ["unitId"] = 1,
                                        ["psi"] = 0,
                                        ["onboard_num"] = "010",
                                        ["y"] = zeus.target.aircraftPos.z + 1000, -- spawn coord zeus.target.laserPos.z + 1000
                                        ["x"] = zeus.target.aircraftPos.x + 1000,  -- spawn coord zeus.target.laserPos.x + 1000,
                                        ["name"] = zeus.target.aircraftName, --zeus.target.aircraftName
                                        ["payload"] =
                                        {
                                            ["pylons"] =
                                            {
                                            }, -- end of ["pylons"]
                                            ["fuel"] = 1300,
                                            ["flare"] = 0,
                                            ["chaff"] = 0,
                                            ["gun"] = 100,
                                        }, -- end of ["payload"]
                                        ["heading"] = 0,
                                        ["callsign"] =
                                        {
                                            [1] = 3,
                                            [2] = 1,
                                            ["name"] = zeus.target.aircraftName,  --Uzi
                                            [3] = 1,
                                        }, -- end of ["callsign"]
                                    }, -- end of [1]
                                }, -- end of ["units"]
                                ["y"] = zeus.target.aircraftPos.z + 1000, -- 0
                                ["x"] = zeus.target.aircraftPos.x + 1000, -- 0
                                ["name"] = zeus.target.aircraftName, -- zeus.target.aircraftName
                                ["communication"] = true,
                                ["start_time"] = 0,
                                ["frequency"] = 251,
                        }

    local _mig29sData =
                        {
                            ["modulation"] = 0,
                                ["tasks"] =
                                {
                                }, -- end of ["tasks"]
                                ["radioSet"] = false,
                                ["task"] = "CAP",
                                ["uncontrolled"] = false,
                                ["route"] =
                                {
                                    ["points"] =
                                    {
                                        [1] =
                                        {
                                            ["alt"] = 8534.4,
                                            ["action"] = "Turning Point",
                                            ["alt_type"] = "BARO",
                                            ["properties"] =
                                            {
                                                ["addopt"] =
                                                {
                                                }, -- end of ["addopt"]
                                            }, -- end of ["properties"]
                                            ["speed"] = 220.97222222222,
                                            ["task"] =
                                            {
                                                ["id"] = "ComboTask",
                                                ["params"] =
                                                {
                                                    ["tasks"] =
                                                    {
                                                        [1] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["key"] = "CAP",
                                                            ["id"] = "EngageTargets",
                                                            ["number"] = 1,
                                                            ["auto"] = true,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Air",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                            }, -- end of ["params"]
                                                        }, -- end of [1]
                                                        [2] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 2,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 17,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [2]
                                                        [3] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 3,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = 3,
                                                                        ["name"] = 18,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [3]
                                                        [4] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 4,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 19,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [4]
                                                        [5] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 5,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["targetTypes"] =
                                                                        {
                                                                        }, -- end of ["targetTypes"]
                                                                        ["name"] = 21,
                                                                        ["value"] = "none;",
                                                                        ["noTargetTypes"] =
                                                                        {
                                                                            [1] = "Fighters",
                                                                            [2] = "Multirole fighters",
                                                                            [3] = "Bombers",
                                                                            [4] = "Helicopters",
                                                                            [5] = "UAVs",
                                                                            [6] = "Infantry",
                                                                            [7] = "Fortifications",
                                                                            [8] = "Tanks",
                                                                            [9] = "IFV",
                                                                            [10] = "APC",
                                                                            [11] = "Artillery",
                                                                            [12] = "Unarmed vehicles",
                                                                            [13] = "AAA",
                                                                            [14] = "SR SAM",
                                                                            [15] = "MR SAM",
                                                                            [16] = "LR SAM",
                                                                            [17] = "Aircraft Carriers",
                                                                            [18] = "Cruisers",
                                                                            [19] = "Destroyers",
                                                                            [20] = "Frigates",
                                                                            [21] = "Corvettes",
                                                                            [22] = "Light armed ships",
                                                                            [23] = "Unarmed ships",
                                                                            [24] = "Submarines",
                                                                            [25] = "Cruise missiles",
                                                                            [26] = "Antiship Missiles",
                                                                            [27] = "AA Missiles",
                                                                            [28] = "AG Missiles",
                                                                            [29] = "SA Missiles",
                                                                        }, -- end of ["noTargetTypes"]
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [5]
                                                        [6] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = false,
                                                            ["id"] = "Orbit",
                                                            ["number"] = 6,
                                                            ["params"] =
                                                            {
                                                                ["altitude"] = 8534.4,
                                                                ["pattern"] = "Circle",
                                                                ["speed"] = 138.88888888889,
                                                            }, -- end of ["params"]
                                                        }, -- end of [6]
                                                        [7] =
                                                        {
                                                            ["number"] = 7,
                                                            ["auto"] = false,
                                                            ["id"] = "EngageTargets",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Planes",
                                                                }, -- end of ["targetTypes"]
                                                                ["noTargetTypes"] =
                                                                {
                                                                    [1] = "Helicopters",
                                                                    [2] = "UAVs",
                                                                    [3] = "Cruise missiles",
                                                                    [4] = "Antiship Missiles",
                                                                    [5] = "AA Missiles",
                                                                    [6] = "AG Missiles",
                                                                    [7] = "SA Missiles",
                                                                }, -- end of ["noTargetTypes"]
                                                                ["value"] = "Planes;",
                                                                ["priority"] = 0,
                                                                ["maxDistEnabled"] = false,
                                                                ["maxDist"] = 15000,
                                                            }, -- end of ["params"]
                                                        }, -- end of [7]
                                                    }, -- end of ["tasks"]
                                                }, -- end of ["params"]
                                            }, -- end of ["task"]
                                            ["type"] = "Turning Point",
                                            ["ETA"] = 0,
                                            ["ETA_locked"] = true,
                                            ["y"] = zeus.target.aircraftPos.z,
                                            ["x"] = zeus.target.aircraftPos.x,
                                            ["speed_locked"] = true,
                                            ["formation_template"] = "",
                                        }, -- end of [1]
                                    }, -- end of ["points"]
                                }, -- end of ["route"]
                                ["groupId"] = owngroupID,
                                ["hidden"] = false,
                                ["units"] =
                                {
                                    [1] =
                                    {
                                        ["alt"] = 8534.4,
                                        ["hardpoint_racks"] = true,
                                        ["alt_type"] = "BARO",
                                        ["livery_id"] = "Air Force Standard",
                                        ["skill"] = "Excellent",
                                        ["speed"] = 220.97222222222,
                                        ["type"] = "MiG-29S",
                                        ["unitId"] = 1,
                                        ["psi"] = 0,
                                        ["onboard_num"] = "010",
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["name"] = zeus.target.aircraftName,--"zeus_mig29-1",
                                        ["payload"] =
                                        {
                                            ["pylons"] =
                                            {
                                                [1] =
                                                {
                                                    ["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
                                                }, -- end of [1]
                                                [2] =
                                                {
                                                    ["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
                                                }, -- end of [2]
                                                [3] =
                                                {
                                                    ["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
                                                }, -- end of [3]
                                                [4] =
                                                {
                                                    ["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
                                                }, -- end of [4]
                                                [5] =
                                                {
                                                    ["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
                                                }, -- end of [5]
                                                [6] =
                                                {
                                                    ["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
                                                }, -- end of [6]
                                                [7] =
                                                {
                                                    ["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
                                                }, -- end of [7]
                                            }, -- end of ["pylons"]
                                            ["fuel"] = "3493",
                                            ["flare"] = 30,
                                            ["chaff"] = 30,
                                            ["gun"] = 100,
                                        }, -- end of ["payload"]
                                        ["heading"] = 0,
                                        ["callsign"] = 100,
                                    }, -- end of [1]
                                }, -- end of ["units"]
                                ["y"] = zeus.target.aircraftPos.z,
                                ["x"] = zeus.target.aircraftPos.x,
                                ["name"] = zeus.target.aircraftName, --"zeus_mig29",
                                ["communication"] = true,
                                ["start_time"] = 0,
                                ["frequency"] = 124,
                        }

    local _f5Data =
                        {
                            ["modulation"] = 0,
                                ["tasks"] =
                                {
                                }, -- end of ["tasks"]
                                ["radioSet"] = false,
                                ["task"] = "CAP",
                                ["uncontrolled"] = false,
                                ["taskSelected"] = true,
                                ["route"] =
                                {
                                    ["points"] =
                                    {
                                        [1] =
                                        {
                                            ["alt"] = 7620,
                                            ["action"] = "Turning Point",
                                            ["alt_type"] = "BARO",
                                            ["properties"] =
                                            {
                                                ["addopt"] =
                                                {
                                                }, -- end of ["addopt"]
                                            }, -- end of ["properties"]
                                            ["speed"] = 174.72222222222,
                                            ["task"] =
                                            {
                                                ["id"] = "ComboTask",
                                                ["params"] =
                                                {
                                                    ["tasks"] =
                                                    {
                                                        [1] =
                                                        {
                                                            ["number"] = 1,
                                                            ["key"] = "CAP",
                                                            ["id"] = "EngageTargets",
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Air",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                            }, -- end of ["params"]
                                                        }, -- end of [1]
                                                        [2] =
                                                        {
                                                            ["number"] = 2,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 17,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [2]
                                                        [3] =
                                                        {
                                                            ["number"] = 3,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = 4,
                                                                        ["name"] = 18,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [3]
                                                        [4] =
                                                        {
                                                            ["number"] = 4,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 19,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [4]
                                                        [5] =
                                                        {
                                                            ["number"] = 5,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["targetTypes"] =
                                                                        {
                                                                        }, -- end of ["targetTypes"]
                                                                        ["name"] = 21,
                                                                        ["value"] = "none;",
                                                                        ["noTargetTypes"] =
                                                                        {
                                                                            [1] = "Fighters",
                                                                            [2] = "Multirole fighters",
                                                                            [3] = "Bombers",
                                                                            [4] = "Helicopters",
                                                                            [5] = "UAVs",
                                                                            [6] = "Infantry",
                                                                            [7] = "Fortifications",
                                                                            [8] = "Tanks",
                                                                            [9] = "IFV",
                                                                            [10] = "APC",
                                                                            [11] = "Artillery",
                                                                            [12] = "Unarmed vehicles",
                                                                            [13] = "AAA",
                                                                            [14] = "SR SAM",
                                                                            [15] = "MR SAM",
                                                                            [16] = "LR SAM",
                                                                            [17] = "Aircraft Carriers",
                                                                            [18] = "Cruisers",
                                                                            [19] = "Destroyers",
                                                                            [20] = "Frigates",
                                                                            [21] = "Corvettes",
                                                                            [22] = "Light armed ships",
                                                                            [23] = "Unarmed ships",
                                                                            [24] = "Submarines",
                                                                            [25] = "Cruise missiles",
                                                                            [26] = "Antiship Missiles",
                                                                            [27] = "AA Missiles",
                                                                            [28] = "AG Missiles",
                                                                            [29] = "SA Missiles",
                                                                        }, -- end of ["noTargetTypes"]
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [5]
                                                        [6] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = false,
                                                            ["id"] = "Orbit",
                                                            ["number"] = 6,
                                                            ["params"] =
                                                            {
                                                                ["altitude"] = 7620,
                                                                ["pattern"] = "Circle",
                                                                ["speed"] = 138.88888888889,
                                                            }, -- end of ["params"]
                                                        }, -- end of [6]
                                                        [7] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = false,
                                                            ["id"] = "EngageTargets",
                                                            ["number"] = 7,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Planes",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                                ["value"] = "Planes;",
                                                                ["noTargetTypes"] =
                                                                {
                                                                    [1] = "Helicopters",
                                                                    [2] = "UAVs",
                                                                    [3] = "Cruise missiles",
                                                                    [4] = "Antiship Missiles",
                                                                    [5] = "AA Missiles",
                                                                    [6] = "AG Missiles",
                                                                    [7] = "SA Missiles",
                                                                }, -- end of ["noTargetTypes"]
                                                                ["maxDistEnabled"] = false,
                                                                ["maxDist"] = 15000,
                                                            }, -- end of ["params"]
                                                        }, -- end of [7]
                                                    }, -- end of ["tasks"]
                                                }, -- end of ["params"]
                                            }, -- end of ["task"]
                                            ["type"] = "Turning Point",
                                            ["ETA"] = 0,
                                            ["ETA_locked"] = true,
                                            ["y"] = zeus.target.aircraftPos.z,
                                            ["x"] = zeus.target.aircraftPos.x,
                                            ["name"] = "initial point",
                                            ["speed_locked"] = true,
                                            ["formation_template"] = "",
                                        }, -- end of [1]
                                    }, -- end of ["points"]
                                }, -- end of ["route"]
                                ["groupId"] = owngroupID,
                                ["hidden"] = false,
                                ["units"] =
                                {
                                    [1] =
                                    {
                                        ["alt"] = 7620,
                                        ["hardpoint_racks"] = true,
                                        ["alt_type"] = "BARO",
                                        ["livery_id"] = liveryID, --"aggressor desert scheme",
                                        ["skill"] = "Excellent",
                                        ["speed"] = 174.72222222222,
                                        ["AddPropAircraft"] =
                                        {
                                        }, -- end of ["AddPropAircraft"]
                                        ["type"] = "F-5E-3",
                                        ["unitId"] = 1,
                                        ["psi"] = 0,
                                        ["onboard_num"] = "010",
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["name"] = zeus.target.aircraftName,
                                        ["payload"] =
                                        {
                                            ["pylons"] =
                                            {
                                                [1] =
                                                {
                                                    ["CLSID"] = "{AIM-9P5}",
                                                }, -- end of [1]
                                                [7] =
                                                {
                                                    ["CLSID"] = "{AIM-9P5}",
                                                }, -- end of [7]
                                            }, -- end of ["pylons"]
                                            ["fuel"] = 2046,
                                            ["flare"] = 15,
                                            ["ammo_type"] = 2,
                                            ["chaff"] = 30,
                                            ["gun"] = 100,
                                        }, -- end of ["payload"]
                                        ["heading"] = 0,
                                        ["callsign"] =
                                        {
                                            [1] = 1,
                                            [2] = 1,
                                            ["name"] = zeus.target.aircraftName,
                                            [3] = 1,
                                        }, -- end of ["callsign"]
                                    }, -- end of [1]
                                }, -- end of ["units"]
                                ["y"] = zeus.target.aircraftPos.z,
                                ["x"] = zeus.target.aircraftPos.z,
                                ["name"] = zeus.target.aircraftName,
                                ["communication"] = true,
                                ["start_time"] = 0,
                                ["frequency"] = 305,
                        }

    local _mig21Data =
                        {
                            ["modulation"] = 0,
                                ["tasks"] =
                                {
                                }, -- end of ["tasks"]
                                ["radioSet"] = false,
                                ["task"] = "CAP",
                                ["uncontrolled"] = false,
                                ["taskSelected"] = true,
                                ["route"] =
                                {
                                    ["points"] =
                                    {
                                        [1] =
                                        {
                                            ["alt"] = 7620,
                                            ["action"] = "Turning Point",
                                            ["alt_type"] = "BARO",
                                            ["properties"] =
                                            {
                                                ["addopt"] =
                                                {
                                                }, -- end of ["addopt"]
                                            }, -- end of ["properties"]
                                            ["speed"] = 220.97222222222,
                                            ["task"] =
                                            {
                                                ["id"] = "ComboTask",
                                                ["params"] =
                                                {
                                                    ["tasks"] =
                                                    {
                                                        [1] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["key"] = "CAP",
                                                            ["id"] = "EngageTargets",
                                                            ["number"] = 1,
                                                            ["auto"] = true,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Air",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                            }, -- end of ["params"]
                                                        }, -- end of [1]
                                                        [2] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 2,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 17,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [2]
                                                        [3] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 3,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = 4,
                                                                        ["name"] = 18,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [3]
                                                        [4] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 4,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 19,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [4]
                                                        [5] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 5,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["targetTypes"] =
                                                                        {
                                                                        }, -- end of ["targetTypes"]
                                                                        ["name"] = 21,
                                                                        ["value"] = "none;",
                                                                        ["noTargetTypes"] =
                                                                        {
                                                                            [1] = "Fighters",
                                                                            [2] = "Multirole fighters",
                                                                            [3] = "Bombers",
                                                                            [4] = "Helicopters",
                                                                            [5] = "UAVs",
                                                                            [6] = "Infantry",
                                                                            [7] = "Fortifications",
                                                                            [8] = "Tanks",
                                                                            [9] = "IFV",
                                                                            [10] = "APC",
                                                                            [11] = "Artillery",
                                                                            [12] = "Unarmed vehicles",
                                                                            [13] = "AAA",
                                                                            [14] = "SR SAM",
                                                                            [15] = "MR SAM",
                                                                            [16] = "LR SAM",
                                                                            [17] = "Aircraft Carriers",
                                                                            [18] = "Cruisers",
                                                                            [19] = "Destroyers",
                                                                            [20] = "Frigates",
                                                                            [21] = "Corvettes",
                                                                            [22] = "Light armed ships",
                                                                            [23] = "Unarmed ships",
                                                                            [24] = "Submarines",
                                                                            [25] = "Cruise missiles",
                                                                            [26] = "Antiship Missiles",
                                                                            [27] = "AA Missiles",
                                                                            [28] = "AG Missiles",
                                                                            [29] = "SA Missiles",
                                                                        }, -- end of ["noTargetTypes"]
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [5]
                                                        [6] =
                                                        {
                                                            ["number"] = 6,
                                                            ["auto"] = false,
                                                            ["id"] = "Orbit",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["altitude"] = 7620,
                                                                ["pattern"] = "Circle",
                                                                ["speed"] = 138.88888888889,
                                                            }, -- end of ["params"]
                                                        }, -- end of [6]
                                                        [7] =
                                                        {
                                                            ["number"] = 7,
                                                            ["auto"] = false,
                                                            ["id"] = "EngageTargets",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Planes",
                                                                }, -- end of ["targetTypes"]
                                                                ["noTargetTypes"] =
                                                                {
                                                                    [1] = "Helicopters",
                                                                    [2] = "UAVs",
                                                                    [3] = "Cruise missiles",
                                                                    [4] = "Antiship Missiles",
                                                                    [5] = "AA Missiles",
                                                                    [6] = "AG Missiles",
                                                                    [7] = "SA Missiles",
                                                                }, -- end of ["noTargetTypes"]
                                                                ["value"] = "Planes;",
                                                                ["priority"] = 0,
                                                                ["maxDistEnabled"] = false,
                                                                ["maxDist"] = 15000,
                                                            }, -- end of ["params"]
                                                        }, -- end of [7]
                                                    }, -- end of ["tasks"]
                                                }, -- end of ["params"]
                                            }, -- end of ["task"]
                                            ["type"] = "Turning Point",
                                            ["ETA"] = 0,
                                            ["ETA_locked"] = true,
                                            ["y"] = zeus.target.aircraftPos.z,
                                            ["x"] = zeus.target.aircraftPos.x,
                                            ["name"] = "initial point",
                                            ["speed_locked"] = true,
                                            ["formation_template"] = "",
                                        }, -- end of [1]
                                    }, -- end of ["points"]
                                }, -- end of ["route"]
                                ["groupId"] = owngroupID,
                                ["hidden"] = false,
                                ["units"] =
                                {
                                    [1] =
                                    {
                                        ["alt"] = 7620,
                                        ["hardpoint_racks"] = true,
                                        ["alt_type"] = "BARO",
                                        ["livery_id"] = "vvs - metal",
                                        ["skill"] = "Excellent",
                                        ["speed"] = 220.97222222222,
                                        ["type"] = "MiG-21Bis",
                                        ["unitId"] = 1,
                                        ["psi"] = 0,
                                        ["onboard_num"] = "010",
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["name"] = zeus.target.aircraftName,
                                        ["payload"] =
                                        {
                                            ["pylons"] =
                                            {
                                                [1] =
                                                {
                                                    ["CLSID"] = "{R-60 2L}",
                                                }, -- end of [1]
                                                [2] =
                                                {
                                                    ["CLSID"] = "{R-3R}",
                                                }, -- end of [2]
                                                [3] =
                                                {
                                                    ["CLSID"] = "{PTB_800_MIG21}",
                                                }, -- end of [3]
                                                [4] =
                                                {
                                                    ["CLSID"] = "{R-3R}",
                                                }, -- end of [4]
                                                [5] =
                                                {
                                                    ["CLSID"] = "{R-60 2R}",
                                                }, -- end of [5]
                                                [6] =
                                                {
                                                    ["CLSID"] = "{ASO-2}",
                                                }, -- end of [6]
                                            }, -- end of ["pylons"]
                                            ["fuel"] = 2280,
                                            ["flare"] = 40,
                                            ["ammo_type"] = 1,
                                            ["chaff"] = 18,
                                            ["gun"] = 100,
                                        }, -- end of ["payload"]
                                        ["heading"] = 0,
                                        ["callsign"] = 101,
                                    }, -- end of [1]
                                }, -- end of ["units"]
                                ["y"] = zeus.target.aircraftPos.z,
                                ["x"] = zeus.target.aircraftPos.x,
                                ["name"] = zeus.target.aircraftName,
                                ["communication"] = true,
                                ["start_time"] = 0,
                                ["frequency"] = 124,
                        }

    local _mig23Data =
                        {
                            ["modulation"] = 0,
                                ["tasks"] =
                                {
                                }, -- end of ["tasks"]
                                ["radioSet"] = false,
                                ["task"] = "CAP",
                                ["uncontrolled"] = false,
                                ["route"] =
                                {
                                    ["points"] =
                                    {
                                        [1] =
                                        {
                                            ["alt"] = 7620,
                                            ["action"] = "Turning Point",
                                            ["alt_type"] = "BARO",
                                            ["properties"] =
                                            {
                                                ["addopt"] =
                                                {
                                                }, -- end of ["addopt"]
                                            }, -- end of ["properties"]
                                            ["speed"] = 210.69444444444,
                                            ["task"] =
                                            {
                                                ["id"] = "ComboTask",
                                                ["params"] =
                                                {
                                                    ["tasks"] =
                                                    {
                                                        [1] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["key"] = "CAP",
                                                            ["id"] = "EngageTargets",
                                                            ["number"] = 1,
                                                            ["auto"] = true,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Air",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                            }, -- end of ["params"]
                                                        }, -- end of [1]
                                                        [2] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 2,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 17,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [2]
                                                        [3] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 3,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = 4,
                                                                        ["name"] = 18,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [3]
                                                        [4] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 4,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 19,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [4]
                                                        [5] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 5,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["targetTypes"] =
                                                                        {
                                                                        }, -- end of ["targetTypes"]
                                                                        ["name"] = 21,
                                                                        ["value"] = "none;",
                                                                        ["noTargetTypes"] =
                                                                        {
                                                                            [1] = "Fighters",
                                                                            [2] = "Multirole fighters",
                                                                            [3] = "Bombers",
                                                                            [4] = "Helicopters",
                                                                            [5] = "UAVs",
                                                                            [6] = "Infantry",
                                                                            [7] = "Fortifications",
                                                                            [8] = "Tanks",
                                                                            [9] = "IFV",
                                                                            [10] = "APC",
                                                                            [11] = "Artillery",
                                                                            [12] = "Unarmed vehicles",
                                                                            [13] = "AAA",
                                                                            [14] = "SR SAM",
                                                                            [15] = "MR SAM",
                                                                            [16] = "LR SAM",
                                                                            [17] = "Aircraft Carriers",
                                                                            [18] = "Cruisers",
                                                                            [19] = "Destroyers",
                                                                            [20] = "Frigates",
                                                                            [21] = "Corvettes",
                                                                            [22] = "Light armed ships",
                                                                            [23] = "Unarmed ships",
                                                                            [24] = "Submarines",
                                                                            [25] = "Cruise missiles",
                                                                            [26] = "Antiship Missiles",
                                                                            [27] = "AA Missiles",
                                                                            [28] = "AG Missiles",
                                                                            [29] = "SA Missiles",
                                                                        }, -- end of ["noTargetTypes"]
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [5]
                                                        [6] =
                                                        {
                                                            ["number"] = 6,
                                                            ["auto"] = false,
                                                            ["id"] = "Orbit",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["altitude"] = 7620,
                                                                ["pattern"] = "Circle",
                                                                ["speed"] = 138.88888888889,
                                                            }, -- end of ["params"]
                                                        }, -- end of [6]
                                                        [7] =
                                                        {
                                                            ["number"] = 7,
                                                            ["auto"] = false,
                                                            ["id"] = "EngageTargets",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Planes",
                                                                }, -- end of ["targetTypes"]
                                                                ["noTargetTypes"] =
                                                                {
                                                                    [1] = "Helicopters",
                                                                    [2] = "UAVs",
                                                                    [3] = "Cruise missiles",
                                                                    [4] = "Antiship Missiles",
                                                                    [5] = "AA Missiles",
                                                                    [6] = "AG Missiles",
                                                                    [7] = "SA Missiles",
                                                                }, -- end of ["noTargetTypes"]
                                                                ["value"] = "Planes;",
                                                                ["priority"] = 0,
                                                                ["maxDistEnabled"] = false,
                                                                ["maxDist"] = 15000,
                                                            }, -- end of ["params"]
                                                        }, -- end of [7]
                                                    }, -- end of ["tasks"]
                                                }, -- end of ["params"]
                                            }, -- end of ["task"]
                                            ["type"] = "Turning Point",
                                            ["ETA"] = 0,
                                            ["ETA_locked"] = true,
                                            ["y"] = zeus.target.aircraftPos.z,
                                            ["x"] = zeus.target.aircraftPos.x,
                                            ["speed_locked"] = true,
                                            ["formation_template"] = "",
                                        }, -- end of [1]
                                    }, -- end of ["points"]
                                }, -- end of ["route"]
                                ["groupId"] = owngroupID,
                                ["hidden"] = false,
                                ["units"] =
                                {
                                    [1] =
                                    {
                                        ["alt"] = 7620,
                                        ["hardpoint_racks"] = true,
                                        ["alt_type"] = "BARO",
                                        ["livery_id"] = "af standard",
                                        ["skill"] = "Excellent",
                                        ["speed"] = 210.69444444444,
                                        ["type"] = "MiG-23MLD",
                                        ["unitId"] = 1,
                                        ["psi"] = 0,
                                        ["onboard_num"] = "010",
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["name"] = zeus.target.aircraftName,
                                        ["payload"] =
                                        {
                                            ["pylons"] =
                                            {
                                                [2] =
                                                {
                                                    ["CLSID"] = "{6980735A-44CC-4BB9-A1B5-591532F1DC69}",
                                                }, -- end of [2]
                                                [3] =
                                                {
                                                    ["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
                                                }, -- end of [3]
                                                [4] =
                                                {
                                                    ["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
                                                }, -- end of [4]
                                                [5] =
                                                {
                                                    ["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
                                                }, -- end of [5]
                                                [6] =
                                                {
                                                    ["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
                                                }, -- end of [6]
                                            }, -- end of ["pylons"]
                                            ["fuel"] = "3800",
                                            ["flare"] = 60,
                                            ["chaff"] = 60,
                                            ["gun"] = 100,
                                        }, -- end of ["payload"]
                                        ["heading"] = 0,
                                        ["callsign"] = 105,
                                    }, -- end of [1]
                                }, -- end of ["units"]
                                ["y"] = zeus.target.aircraftPos.z,
                                ["x"] = zeus.target.aircraftPos.z,
                                ["name"] = zeus.target.aircraftName,
                                ["communication"] = true,
                                ["start_time"] = 0,
                                ["frequency"] = 251,
                        }

    local _m2kData =
                        {
                            ["modulation"] = 0,
                                ["tasks"] =
                                {
                                }, -- end of ["tasks"]
                                ["radioSet"] = false,
                                ["task"] = "CAP",
                                ["uncontrolled"] = false,
                                ["taskSelected"] = true,
                                ["route"] =
                                {
                                    ["points"] =
                                    {
                                        [1] =
                                        {
                                            ["alt"] = 7620,
                                            ["action"] = "Turning Point",
                                            ["alt_type"] = "BARO",
                                            ["properties"] =
                                            {
                                                ["addopt"] =
                                                {
                                                }, -- end of ["addopt"]
                                            }, -- end of ["properties"]
                                            ["speed"] = 251.80555555556,
                                            ["task"] =
                                            {
                                                ["id"] = "ComboTask",
                                                ["params"] =
                                                {
                                                    ["tasks"] =
                                                    {
                                                        [1] =
                                                        {
                                                            ["number"] = 1,
                                                            ["key"] = "CAP",
                                                            ["id"] = "EngageTargets",
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Air",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                            }, -- end of ["params"]
                                                        }, -- end of [1]
                                                        [2] =
                                                        {
                                                            ["number"] = 2,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 17,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [2]
                                                        [3] =
                                                        {
                                                            ["number"] = 3,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = 4,
                                                                        ["name"] = 18,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [3]
                                                        [4] =
                                                        {
                                                            ["number"] = 4,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 19,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [4]
                                                        [5] =
                                                        {
                                                            ["number"] = 5,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["targetTypes"] =
                                                                        {
                                                                        }, -- end of ["targetTypes"]
                                                                        ["name"] = 21,
                                                                        ["value"] = "none;",
                                                                        ["noTargetTypes"] =
                                                                        {
                                                                            [1] = "Fighters",
                                                                            [2] = "Multirole fighters",
                                                                            [3] = "Bombers",
                                                                            [4] = "Helicopters",
                                                                            [5] = "UAVs",
                                                                            [6] = "Infantry",
                                                                            [7] = "Fortifications",
                                                                            [8] = "Tanks",
                                                                            [9] = "IFV",
                                                                            [10] = "APC",
                                                                            [11] = "Artillery",
                                                                            [12] = "Unarmed vehicles",
                                                                            [13] = "AAA",
                                                                            [14] = "SR SAM",
                                                                            [15] = "MR SAM",
                                                                            [16] = "LR SAM",
                                                                            [17] = "Aircraft Carriers",
                                                                            [18] = "Cruisers",
                                                                            [19] = "Destroyers",
                                                                            [20] = "Frigates",
                                                                            [21] = "Corvettes",
                                                                            [22] = "Light armed ships",
                                                                            [23] = "Unarmed ships",
                                                                            [24] = "Submarines",
                                                                            [25] = "Cruise missiles",
                                                                            [26] = "Antiship Missiles",
                                                                            [27] = "AA Missiles",
                                                                            [28] = "AG Missiles",
                                                                            [29] = "SA Missiles",
                                                                        }, -- end of ["noTargetTypes"]
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [5]
                                                        [6] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = false,
                                                            ["id"] = "Orbit",
                                                            ["number"] = 6,
                                                            ["params"] =
                                                            {
                                                                ["altitude"] = 7620,
                                                                ["pattern"] = "Circle",
                                                                ["speed"] = 138.88888888889,
                                                            }, -- end of ["params"]
                                                        }, -- end of [6]
                                                        [7] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = false,
                                                            ["id"] = "EngageTargets",
                                                            ["number"] = 7,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Planes",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                                ["value"] = "Planes;",
                                                                ["noTargetTypes"] =
                                                                {
                                                                    [1] = "Helicopters",
                                                                    [2] = "UAVs",
                                                                    [3] = "Cruise missiles",
                                                                    [4] = "Antiship Missiles",
                                                                    [5] = "AA Missiles",
                                                                    [6] = "AG Missiles",
                                                                    [7] = "SA Missiles",
                                                                }, -- end of ["noTargetTypes"]
                                                                ["maxDistEnabled"] = false,
                                                                ["maxDist"] = 15000,
                                                            }, -- end of ["params"]
                                                        }, -- end of [7]
                                                    }, -- end of ["tasks"]
                                                }, -- end of ["params"]
                                            }, -- end of ["task"]
                                            ["type"] = "Turning Point",
                                            ["ETA"] = 0,
                                            ["ETA_locked"] = true,
                                            ["y"] = zeus.target.aircraftPos.z,
                                            ["x"] = zeus.target.aircraftPos.x,
                                            ["speed_locked"] = true,
                                            ["formation_template"] = "",
                                        }, -- end of [1]
                                    }, -- end of ["points"]
                                }, -- end of ["route"]
                                ["groupId"] = owngroupID,
                                ["hidden"] = false,
                                ["units"] =
                                {
                                    [1] =
                                    {
                                        ["alt"] = 7620,
                                        ["hardpoint_racks"] = true,
                                        ["alt_type"] = "BARO",
                                        ["livery_id"] = "M2000C-N_2-30_NoeZ",
                                        ["skill"] = "Excellent",
                                        ["speed"] = 251.80555555556,
                                        ["AddPropAircraft"] =
                                        {
                                            ["ReadyALCM"] = true,
                                            ["WpBullseye"] = 0,
                                            ["LoadNVGCase"] = false,
                                            ["ForceINSRules"] = false,
                                            ["InitHotDrift"] = 0,
                                            ["EnableTAF"] = true,
                                        }, -- end of ["AddPropAircraft"]
                                        ["type"] = "M-2000C",
                                        ["unitId"] = 1,
                                        ["psi"] = 0,
                                        ["onboard_num"] = "010",
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["name"] = zeus.target.aircraftName,
                                        ["payload"] =
                                        {
                                            ["pylons"] =
                                            {
                                                [1] =
                                                {
                                                    ["CLSID"] = "{MMagicII}",
                                                }, -- end of [1]
                                                [2] =
                                                {
                                                    ["CLSID"] = "{Matra_S530D}",
                                                }, -- end of [2]
                                                [8] =
                                                {
                                                    ["CLSID"] = "{Matra_S530D}",
                                                }, -- end of [8]
                                                [10] =
                                                {
                                                    ["CLSID"] = "{Eclair}",
                                                }, -- end of [10]
                                                [9] =
                                                {
                                                    ["CLSID"] = "{MMagicII}",
                                                }, -- end of [9]
                                                [5] =
                                                {
                                                    ["CLSID"] = "{M2KC_RPL_522}",
                                                }, -- end of [5]
                                            }, -- end of ["pylons"]
                                            ["fuel"] = 3165,
                                            ["flare"] = 64,
                                            ["ammo_type"] = 1,
                                            ["chaff"] = 234,
                                            ["gun"] = 100,
                                        }, -- end of ["payload"]
                                        ["heading"] = 0,
                                        ["callsign"] = 100,
                                    }, -- end of [1]
                                }, -- end of ["units"]
                                ["y"] = zeus.target.aircraftPos.z,
                                ["x"] = zeus.target.aircraftPos.x,
                                ["name"] = zeus.target.aircraftName,
                                ["communication"] = true,
                                ["start_time"] = 0,
                                ["frequency"] = 251,
                        }

    local _f15Data =
                        {
                            ["modulation"] = 0,
                                ["tasks"] =
                                {
                                }, -- end of ["tasks"]
                                ["radioSet"] = false,
                                ["task"] = "CAP",
                                ["uncontrolled"] = false,
                                ["taskSelected"] = true,
                                ["route"] =
                                {
                                    ["points"] =
                                    {
                                        [1] =
                                        {
                                            ["alt"] = 7620,
                                            ["action"] = "Turning Point",
                                            ["alt_type"] = "BARO",
                                            ["properties"] =
                                            {
                                                ["addopt"] =
                                                {
                                                }, -- end of ["addopt"]
                                            }, -- end of ["properties"]
                                            ["speed"] = 220.97222222222,
                                            ["task"] =
                                            {
                                                ["id"] = "ComboTask",
                                                ["params"] =
                                                {
                                                    ["tasks"] =
                                                    {
                                                        [1] =
                                                        {
                                                            ["number"] = 1,
                                                            ["key"] = "CAP",
                                                            ["id"] = "EngageTargets",
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Air",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                            }, -- end of ["params"]
                                                        }, -- end of [1]
                                                        [2] =
                                                        {
                                                            ["number"] = 2,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 17,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [2]
                                                        [3] =
                                                        {
                                                            ["number"] = 3,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = 4,
                                                                        ["name"] = 18,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [3]
                                                        [4] =
                                                        {
                                                            ["number"] = 4,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 19,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [4]
                                                        [5] =
                                                        {
                                                            ["number"] = 5,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["targetTypes"] =
                                                                        {
                                                                        }, -- end of ["targetTypes"]
                                                                        ["name"] = 21,
                                                                        ["value"] = "none;",
                                                                        ["noTargetTypes"] =
                                                                        {
                                                                            [1] = "Fighters",
                                                                            [2] = "Multirole fighters",
                                                                            [3] = "Bombers",
                                                                            [4] = "Helicopters",
                                                                            [5] = "UAVs",
                                                                            [6] = "Infantry",
                                                                            [7] = "Fortifications",
                                                                            [8] = "Tanks",
                                                                            [9] = "IFV",
                                                                            [10] = "APC",
                                                                            [11] = "Artillery",
                                                                            [12] = "Unarmed vehicles",
                                                                            [13] = "AAA",
                                                                            [14] = "SR SAM",
                                                                            [15] = "MR SAM",
                                                                            [16] = "LR SAM",
                                                                            [17] = "Aircraft Carriers",
                                                                            [18] = "Cruisers",
                                                                            [19] = "Destroyers",
                                                                            [20] = "Frigates",
                                                                            [21] = "Corvettes",
                                                                            [22] = "Light armed ships",
                                                                            [23] = "Unarmed ships",
                                                                            [24] = "Submarines",
                                                                            [25] = "Cruise missiles",
                                                                            [26] = "Antiship Missiles",
                                                                            [27] = "AA Missiles",
                                                                            [28] = "AG Missiles",
                                                                            [29] = "SA Missiles",
                                                                        }, -- end of ["noTargetTypes"]
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [5]
                                                        [6] =
                                                        {
                                                            ["number"] = 6,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "EPLRS",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["groupId"] = owngroupID,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [6]
                                                        [7] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = false,
                                                            ["id"] = "Orbit",
                                                            ["number"] = 7,
                                                            ["params"] =
                                                            {
                                                                ["altitude"] = 7620,
                                                                ["pattern"] = "Circle",
                                                                ["speed"] = 138.88888888889,
                                                            }, -- end of ["params"]
                                                        }, -- end of [7]
                                                        [8] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = false,
                                                            ["id"] = "EngageTargets",
                                                            ["number"] = 8,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Planes",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                                ["value"] = "Planes;",
                                                                ["noTargetTypes"] =
                                                                {
                                                                    [1] = "Helicopters",
                                                                    [2] = "UAVs",
                                                                    [3] = "Cruise missiles",
                                                                    [4] = "Antiship Missiles",
                                                                    [5] = "AA Missiles",
                                                                    [6] = "AG Missiles",
                                                                    [7] = "SA Missiles",
                                                                }, -- end of ["noTargetTypes"]
                                                                ["maxDistEnabled"] = false,
                                                                ["maxDist"] = 15000,
                                                            }, -- end of ["params"]
                                                        }, -- end of [8]
                                                    }, -- end of ["tasks"]
                                                }, -- end of ["params"]
                                            }, -- end of ["task"]
                                            ["type"] = "Turning Point",
                                            ["ETA"] = 0,
                                            ["ETA_locked"] = true,
                                            ["y"] = zeus.target.aircraftPos.z,
                                            ["x"] = zeus.target.aircraftPos.x,
                                            ["speed_locked"] = true,
                                            ["formation_template"] = "",
                                        }, -- end of [1]
                                    }, -- end of ["points"]
                                }, -- end of ["route"]
                                ["groupId"] = owngroupID,
                                ["hidden"] = false,
                                ["units"] =
                                {
                                    [1] =
                                    {
                                        ["alt"] = 7620,
                                        ["hardpoint_racks"] = true,
                                        ["alt_type"] = "BARO",
                                        ["livery_id"] = "65th Aggressor SQN (WA) Flanker",
                                        ["skill"] = "Excellent",
                                        ["speed"] = 220.97222222222,
                                        ["AddPropAircraft"] =
                                        {
                                            ["VoiceCallsignLabel"] = "ED",
                                            ["VoiceCallsignNumber"] = "11",
                                            ["STN_L16"] = "00201",
                                        }, -- end of ["AddPropAircraft"]
                                        ["type"] = "F-15C",
                                        ["unitId"] = 1,
                                        ["psi"] = 0,
                                        ["onboard_num"] = "010",
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["name"] = zeus.target.aircraftName,
                                        ["payload"] =
                                        {
                                            ["pylons"] =
                                            {
                                                [1] =
                                                {
                                                    ["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
                                                }, -- end of [1]
                                                [3] =
                                                {
                                                    ["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
                                                }, -- end of [3]
                                                [4] =
                                                {
                                                    ["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
                                                }, -- end of [4]
                                                [5] =
                                                {
                                                    ["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
                                                }, -- end of [5]
                                                [6] =
                                                {
                                                    ["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
                                                }, -- end of [6]
                                                [7] =
                                                {
                                                    ["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
                                                }, -- end of [7]
                                                [8] =
                                                {
                                                    ["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
                                                }, -- end of [8]
                                                [9] =
                                                {
                                                    ["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
                                                }, -- end of [9]
                                                [11] =
                                                {
                                                    ["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
                                                }, -- end of [11]
                                            }, -- end of ["pylons"]
                                            ["fuel"] = "6103",
                                            ["flare"] = 60,
                                            ["chaff"] = 120,
                                            ["gun"] = 100,
                                        }, -- end of ["payload"]
                                        ["heading"] = 0,
                                        ["callsign"] =
                                        {
                                            [1] = 1,
                                            [2] = 1,
                                            ["name"] = zeus.target.aircraftName,
                                            [3] = 1,
                                        }, -- end of ["callsign"]
                                    }, -- end of [1]
                                }, -- end of ["units"]
                                ["y"] = zeus.target.aircraftPos.z,
                                ["x"] = zeus.target.aircraftPos.x,
                                ["name"] = zeus.target.aircraftName,
                                ["communication"] = true,
                                ["start_time"] = 0,
                                ["frequency"] = 124,
                        }

    local _f14Data =
                        {
                            ["modulation"] = 0,
                                ["tasks"] =
                                {
                                }, -- end of ["tasks"]
                                ["radioSet"] = false,
                                ["task"] = "CAP",
                                ["uncontrolled"] = false,
                                ["taskSelected"] = true,
                                ["route"] =
                                {
                                    ["points"] =
                                    {
                                        [1] =
                                        {
                                            ["alt"] = 8534.4,
                                            ["action"] = "Turning Point",
                                            ["alt_type"] = "BARO",
                                            ["properties"] =
                                            {
                                                ["addopt"] =
                                                {
                                                }, -- end of ["addopt"]
                                            }, -- end of ["properties"]
                                            ["speed"] = 220.97222222222,
                                            ["task"] =
                                            {
                                                ["id"] = "ComboTask",
                                                ["params"] =
                                                {
                                                    ["tasks"] =
                                                    {
                                                        [1] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["key"] = "CAP",
                                                            ["id"] = "EngageTargets",
                                                            ["number"] = 1,
                                                            ["auto"] = true,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Air",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                            }, -- end of ["params"]
                                                        }, -- end of [1]
                                                        [2] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 2,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 17,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [2]
                                                        [3] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 3,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = 4,
                                                                        ["name"] = 18,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [3]
                                                        [4] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 4,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 19,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [4]
                                                        [5] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 5,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["targetTypes"] =
                                                                        {
                                                                        }, -- end of ["targetTypes"]
                                                                        ["name"] = 21,
                                                                        ["value"] = "none;",
                                                                        ["noTargetTypes"] =
                                                                        {
                                                                            [1] = "Fighters",
                                                                            [2] = "Multirole fighters",
                                                                            [3] = "Bombers",
                                                                            [4] = "Helicopters",
                                                                            [5] = "UAVs",
                                                                            [6] = "Infantry",
                                                                            [7] = "Fortifications",
                                                                            [8] = "Tanks",
                                                                            [9] = "IFV",
                                                                            [10] = "APC",
                                                                            [11] = "Artillery",
                                                                            [12] = "Unarmed vehicles",
                                                                            [13] = "AAA",
                                                                            [14] = "SR SAM",
                                                                            [15] = "MR SAM",
                                                                            [16] = "LR SAM",
                                                                            [17] = "Aircraft Carriers",
                                                                            [18] = "Cruisers",
                                                                            [19] = "Destroyers",
                                                                            [20] = "Frigates",
                                                                            [21] = "Corvettes",
                                                                            [22] = "Light armed ships",
                                                                            [23] = "Unarmed ships",
                                                                            [24] = "Submarines",
                                                                            [25] = "Cruise missiles",
                                                                            [26] = "Antiship Missiles",
                                                                            [27] = "AA Missiles",
                                                                            [28] = "AG Missiles",
                                                                            [29] = "SA Missiles",
                                                                        }, -- end of ["noTargetTypes"]
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [5]
                                                        [6] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = false,
                                                            ["id"] = "Orbit",
                                                            ["number"] = 6,
                                                            ["params"] =
                                                            {
                                                                ["altitude"] = 8534.4,
                                                                ["pattern"] = "Circle",
                                                                ["speed"] = 138.88888888889,
                                                            }, -- end of ["params"]
                                                        }, -- end of [6]
                                                        [7] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = false,
                                                            ["id"] = "EngageTargets",
                                                            ["number"] = 7,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Planes",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                                ["value"] = "Planes;",
                                                                ["noTargetTypes"] =
                                                                {
                                                                    [1] = "Helicopters",
                                                                    [2] = "UAVs",
                                                                    [3] = "Cruise missiles",
                                                                    [4] = "Antiship Missiles",
                                                                    [5] = "AA Missiles",
                                                                    [6] = "AG Missiles",
                                                                    [7] = "SA Missiles",
                                                                }, -- end of ["noTargetTypes"]
                                                                ["maxDistEnabled"] = false,
                                                                ["maxDist"] = 15000,
                                                            }, -- end of ["params"]
                                                        }, -- end of [7]
                                                    }, -- end of ["tasks"]
                                                }, -- end of ["params"]
                                            }, -- end of ["task"]
                                            ["type"] = "Turning Point",
                                            ["ETA"] = 0,
                                            ["ETA_locked"] = true,
                                            ["y"] = zeus.target.aircraftPos.z,
                                            ["x"] = zeus.target.aircraftPos.z,
                                            ["speed_locked"] = true,
                                            ["formation_template"] = "",
                                        }, -- end of [1]
                                    }, -- end of ["points"]
                                }, -- end of ["route"]
                                ["groupId"] = owngroupID,
                                ["hidden"] = false,
                                ["units"] =
                                {
                                    [1] =
                                    {
                                        ["alt"] = 8534.4,
                                        ["hardpoint_racks"] = true,
                                        ["alt_type"] = "BARO",
                                        ["livery_id"] = "rogue nation(top gun - maverick)",
                                        ["skill"] = "Excellent",
                                        ["speed"] = 220.97222222222,
                                        ["AddPropAircraft"] =
                                        {
                                        }, -- end of ["AddPropAircraft"]
                                        ["type"] = "F-14B",
                                        ["unitId"] = 1,
                                        ["psi"] = 0,
                                        ["onboard_num"] = "010",
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["name"] = zeus.target.aircraftName,
                                        ["payload"] =
                                        {
                                            ["pylons"] =
                                            {
                                                [1] =
                                                {
                                                    ["CLSID"] = "{LAU-138 wtip - AIM-9M}",
                                                }, -- end of [1]
                                                [2] =
                                                {
                                                    ["CLSID"] = "{SHOULDER AIM-7P}",
                                                }, -- end of [2]
                                                [3] =
                                                {
                                                    ["CLSID"] = "{F14-300gal}",
                                                }, -- end of [3]
                                                [4] =
                                                {
                                                    ["CLSID"] = "{AIM_54C_Mk60}",
                                                }, -- end of [4]
                                                [5] =
                                                {
                                                    ["CLSID"] = "{AIM_54C_Mk60}",
                                                }, -- end of [5]
                                                [6] =
                                                {
                                                    ["CLSID"] = "{AIM_54C_Mk60}",
                                                }, -- end of [6]
                                                [7] =
                                                {
                                                    ["CLSID"] = "{AIM_54C_Mk60}",
                                                }, -- end of [7]
                                                [8] =
                                                {
                                                    ["CLSID"] = "{F14-300gal}",
                                                }, -- end of [8]
                                                [9] =
                                                {
                                                    ["CLSID"] = "{SHOULDER AIM-7P}",
                                                }, -- end of [9]
                                                [10] =
                                                {
                                                    ["CLSID"] = "{LAU-138 wtip - AIM-9M}",
                                                }, -- end of [10]
                                            }, -- end of ["pylons"]
                                            ["fuel"] = 7348,
                                            ["flare"] = 60,
                                            ["ammo_type"] = 1,
                                            ["chaff"] = 140,
                                            ["gun"] = 100,
                                        }, -- end of ["payload"]
                                        ["heading"] = 0,
                                        ["callsign"] =
                                        {
                                            [1] = 2,
                                            [2] = 1,
                                            ["name"] = zeus.target.aircraftName,
                                            [3] = 1,
                                        }, -- end of ["callsign"]
                                    }, -- end of [1]
                                }, -- end of ["units"]
                                ["y"] = zeus.target.aircraftPos.z,
                                ["x"] = zeus.target.aircraftPos.x,
                                ["name"] = zeus.target.aircraftName,
                                ["communication"] = true,
                                ["start_time"] = 0,
                                ["frequency"] = 124,
                        }

    local _f16Data =
                        {
                            ["modulation"] = 0,
                                ["tasks"] =
                                {
                                }, -- end of ["tasks"]
                                ["radioSet"] = false,
                                ["task"] = "CAP",
                                ["uncontrolled"] = false,
                                ["taskSelected"] = true,
                                ["route"] =
                                {
                                    ["points"] =
                                    {
                                        [1] =
                                        {
                                            ["alt"] = 8534.4,
                                            ["action"] = "Turning Point",
                                            ["alt_type"] = "BARO",
                                            ["properties"] =
                                            {
                                                ["addopt"] =
                                                {
                                                }, -- end of ["addopt"]
                                            }, -- end of ["properties"]
                                            ["speed"] = 220.97222222222,
                                            ["task"] =
                                            {
                                                ["id"] = "ComboTask",
                                                ["params"] =
                                                {
                                                    ["tasks"] =
                                                    {
                                                        [1] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["key"] = "CAP",
                                                            ["id"] = "EngageTargets",
                                                            ["number"] = 1,
                                                            ["auto"] = true,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Air",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                            }, -- end of ["params"]
                                                        }, -- end of [1]
                                                        [2] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 2,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 17,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [2]
                                                        [3] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 3,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = 4,
                                                                        ["name"] = 18,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [3]
                                                        [4] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 4,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 19,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [4]
                                                        [5] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 5,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["targetTypes"] =
                                                                        {
                                                                        }, -- end of ["targetTypes"]
                                                                        ["name"] = 21,
                                                                        ["value"] = "none;",
                                                                        ["noTargetTypes"] =
                                                                        {
                                                                            [1] = "Fighters",
                                                                            [2] = "Multirole fighters",
                                                                            [3] = "Bombers",
                                                                            [4] = "Helicopters",
                                                                            [5] = "UAVs",
                                                                            [6] = "Infantry",
                                                                            [7] = "Fortifications",
                                                                            [8] = "Tanks",
                                                                            [9] = "IFV",
                                                                            [10] = "APC",
                                                                            [11] = "Artillery",
                                                                            [12] = "Unarmed vehicles",
                                                                            [13] = "AAA",
                                                                            [14] = "SR SAM",
                                                                            [15] = "MR SAM",
                                                                            [16] = "LR SAM",
                                                                            [17] = "Aircraft Carriers",
                                                                            [18] = "Cruisers",
                                                                            [19] = "Destroyers",
                                                                            [20] = "Frigates",
                                                                            [21] = "Corvettes",
                                                                            [22] = "Light armed ships",
                                                                            [23] = "Unarmed ships",
                                                                            [24] = "Submarines",
                                                                            [25] = "Cruise missiles",
                                                                            [26] = "Antiship Missiles",
                                                                            [27] = "AA Missiles",
                                                                            [28] = "AG Missiles",
                                                                            [29] = "SA Missiles",
                                                                        }, -- end of ["noTargetTypes"]
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [5]
                                                        [6] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 6,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "EPLRS",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["groupId"] = owngroupID,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [6]
                                                        [7] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = false,
                                                            ["id"] = "Orbit",
                                                            ["number"] = 7,
                                                            ["params"] =
                                                            {
                                                                ["altitude"] = 8534.4,
                                                                ["pattern"] = "Circle",
                                                                ["speed"] = 138.88888888889,
                                                            }, -- end of ["params"]
                                                        }, -- end of [7]
                                                        [8] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = false,
                                                            ["id"] = "EngageTargets",
                                                            ["number"] = 8,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Planes",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                                ["value"] = "Planes;",
                                                                ["noTargetTypes"] =
                                                                {
                                                                    [1] = "Helicopters",
                                                                    [2] = "UAVs",
                                                                    [3] = "Cruise missiles",
                                                                    [4] = "Antiship Missiles",
                                                                    [5] = "AA Missiles",
                                                                    [6] = "AG Missiles",
                                                                    [7] = "SA Missiles",
                                                                }, -- end of ["noTargetTypes"]
                                                                ["maxDistEnabled"] = false,
                                                                ["maxDist"] = 15000,
                                                            }, -- end of ["params"]
                                                        }, -- end of [8]
                                                    }, -- end of ["tasks"]
                                                }, -- end of ["params"]
                                            }, -- end of ["task"]
                                            ["type"] = "Turning Point",
                                            ["ETA"] = 0,
                                            ["ETA_locked"] = true,
                                            ["y"] = zeus.target.aircraftPos.z,
                                            ["x"] = zeus.target.aircraftPos.x,
                                            ["speed_locked"] = true,
                                            ["formation_template"] = "",
                                        }, -- end of [1]
                                    }, -- end of ["points"]
                                }, -- end of ["route"]
                                ["groupId"] = owngroupID,
                                ["hidden"] = false,
                                ["units"] =
                                {
                                    [1] =
                                    {
                                        ["alt"] = 8534.4,
                                        ["hardpoint_racks"] = true,
                                        ["alt_type"] = "BARO",
                                        ["livery_id"] = "default",
                                        ["skill"] = "Excellent",
                                        ["speed"] = 220.97222222222,
                                        ["AddPropAircraft"] =
                                        {
                                            ["STN_L16"] = "00203",
                                            ["VoiceCallsignNumber"] = "11",
                                            ["VoiceCallsignLabel"] = "UI",
                                        }, -- end of ["AddPropAircraft"]
                                        ["type"] = "F-16C_50",
                                        ["unitId"] = 1,
                                        ["psi"] = 0,
                                        ["onboard_num"] = "011",
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["name"] = zeus.target.aircraftName,
                                        ["payload"] =
                                        {
                                            ["pylons"] =
                                            {
                                            }, -- end of ["pylons"]
                                            ["fuel"] = 3249,
                                            ["flare"] = 60,
                                            ["ammo_type"] = 5,
                                            ["chaff"] = 60,
                                            ["gun"] = 100,
                                        }, -- end of ["payload"]
                                        ["heading"] = 0,
                                        ["callsign"] =
                                        {
                                            [1] = 3,
                                            [2] = 1,
                                            ["name"] = zeus.target.aircraftName,
                                            [3] = 1,
                                        }, -- end of ["callsign"]
                                        ["datalinks"] =
                                        {
                                            ["Link16"] =
                                            {
                                                ["settings"] =
                                                {
                                                    ["flightLead"] = true,
                                                    ["transmitPower"] = 3,
                                                    ["specialChannel"] = 1,
                                                    ["fighterChannel"] = 1,
                                                    ["missionChannel"] = 1,
                                                }, -- end of ["settings"]
                                                ["network"] =
                                                {
                                                    ["teamMembers"] =
                                                    {
                                                        [1] =
                                                        {
                                                            ["TDOA"] = true,
                                                            ["missionUnitId"] = 3,
                                                        }, -- end of [1]
                                                    }, -- end of ["teamMembers"]
                                                    ["donors"] =
                                                    {
                                                    }, -- end of ["donors"]
                                                }, -- end of ["network"]
                                            }, -- end of ["Link16"]
                                        }, -- end of ["datalinks"]
                                    }, -- end of [1]
                                }, -- end of ["units"]
                                ["y"] = zeus.target.aircraftPos.z,
                                ["x"] = zeus.target.aircraftPos.x,
                                ["name"] = zeus.target.aircraftName,
                                ["communication"] = true,
                                ["start_time"] = 0,
                                ["frequency"] = 305,
                        }

    local _f18Data =
                        {
                            ["modulation"] = 0,
                                ["tasks"] =
                                {
                                }, -- end of ["tasks"]
                                ["radioSet"] = false,
                                ["task"] = "CAP",
                                ["uncontrolled"] = false,
                                ["taskSelected"] = true,
                                ["route"] =
                                {
                                    ["points"] =
                                    {
                                        [1] =
                                        {
                                            ["alt"] = 8534.4,
                                            ["action"] = "Turning Point",
                                            ["alt_type"] = "BARO",
                                            ["properties"] =
                                            {
                                                ["addopt"] =
                                                {
                                                }, -- end of ["addopt"]
                                            }, -- end of ["properties"]
                                            ["speed"] = 179.86111111111,
                                            ["task"] =
                                            {
                                                ["id"] = "ComboTask",
                                                ["params"] =
                                                {
                                                    ["tasks"] =
                                                    {
                                                        [1] =
                                                        {
                                                            ["number"] = 1,
                                                            ["key"] = "CAP",
                                                            ["id"] = "EngageTargets",
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Air",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                            }, -- end of ["params"]
                                                        }, -- end of [1]
                                                        [2] =
                                                        {
                                                            ["number"] = 2,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 17,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [2]
                                                        [3] =
                                                        {
                                                            ["number"] = 3,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = 4,
                                                                        ["name"] = 18,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [3]
                                                        [4] =
                                                        {
                                                            ["number"] = 4,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 19,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [4]
                                                        [5] =
                                                        {
                                                            ["number"] = 5,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["targetTypes"] =
                                                                        {
                                                                        }, -- end of ["targetTypes"]
                                                                        ["name"] = 21,
                                                                        ["value"] = "none;",
                                                                        ["noTargetTypes"] =
                                                                        {
                                                                            [1] = "Fighters",
                                                                            [2] = "Multirole fighters",
                                                                            [3] = "Bombers",
                                                                            [4] = "Helicopters",
                                                                            [5] = "UAVs",
                                                                            [6] = "Infantry",
                                                                            [7] = "Fortifications",
                                                                            [8] = "Tanks",
                                                                            [9] = "IFV",
                                                                            [10] = "APC",
                                                                            [11] = "Artillery",
                                                                            [12] = "Unarmed vehicles",
                                                                            [13] = "AAA",
                                                                            [14] = "SR SAM",
                                                                            [15] = "MR SAM",
                                                                            [16] = "LR SAM",
                                                                            [17] = "Aircraft Carriers",
                                                                            [18] = "Cruisers",
                                                                            [19] = "Destroyers",
                                                                            [20] = "Frigates",
                                                                            [21] = "Corvettes",
                                                                            [22] = "Light armed ships",
                                                                            [23] = "Unarmed ships",
                                                                            [24] = "Submarines",
                                                                            [25] = "Cruise missiles",
                                                                            [26] = "Antiship Missiles",
                                                                            [27] = "AA Missiles",
                                                                            [28] = "AG Missiles",
                                                                            [29] = "SA Missiles",
                                                                        }, -- end of ["noTargetTypes"]
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [5]
                                                        [6] =
                                                        {
                                                            ["number"] = 6,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "EPLRS",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["groupId"] = owngroupID,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [6]
                                                        [7] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = false,
                                                            ["id"] = "Orbit",
                                                            ["number"] = 7,
                                                            ["params"] =
                                                            {
                                                                ["altitude"] = 8534.4,
                                                                ["pattern"] = "Circle",
                                                                ["speed"] = 138.88888888889,
                                                            }, -- end of ["params"]
                                                        }, -- end of [7]
                                                        [8] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = false,
                                                            ["id"] = "EngageTargets",
                                                            ["number"] = 8,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Planes",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                                ["value"] = "Planes;",
                                                                ["noTargetTypes"] =
                                                                {
                                                                    [1] = "Helicopters",
                                                                    [2] = "UAVs",
                                                                    [3] = "Cruise missiles",
                                                                    [4] = "Antiship Missiles",
                                                                    [5] = "AA Missiles",
                                                                    [6] = "AG Missiles",
                                                                    [7] = "SA Missiles",
                                                                }, -- end of ["noTargetTypes"]
                                                                ["maxDistEnabled"] = false,
                                                                ["maxDist"] = 15000,
                                                            }, -- end of ["params"]
                                                        }, -- end of [8]
                                                    }, -- end of ["tasks"]
                                                }, -- end of ["params"]
                                            }, -- end of ["task"]
                                            ["type"] = "Turning Point",
                                            ["ETA"] = 0,
                                            ["ETA_locked"] = true,
                                            ["y"] = zeus.target.aircraftPos.z,
                                            ["x"] = zeus.target.aircraftPos.x,
                                            ["speed_locked"] = true,
                                            ["formation_template"] = "",
                                        }, -- end of [1]
                                    }, -- end of ["points"]
                                }, -- end of ["route"]
                                ["groupId"] = owngroupID,
                                ["hidden"] = false,
                                ["units"] =
                                {
                                    [1] =
                                    {
                                        ["alt"] = 8534.4,
                                        ["hardpoint_racks"] = true,
                                        ["alt_type"] = "BARO",
                                        ["livery_id"] = "fictional russia air force",
                                        ["skill"] = "Excellent",
                                        ["speed"] = 179.86111111111,
                                        ["AddPropAircraft"] =
                                        {
                                            ["VoiceCallsignLabel"] = "CT",
                                            ["VoiceCallsignNumber"] = "11",
                                            ["STN_L16"] = "00204",
                                        }, -- end of ["AddPropAircraft"]
                                        ["type"] = "FA-18C_hornet",
                                        ["unitId"] = 1,
                                        ["psi"] = 0,
                                        ["onboard_num"] = "012",
                                        ["dataCartridge"] =
                                        {
                                            ["GroupsPoints"] =
                                            {
                                                ["Initial Point"] =
                                                {
                                                }, -- end of ["Initial Point"]
                                                ["Sequence 2 Red"] =
                                                {
                                                }, -- end of ["Sequence 2 Red"]
                                                ["PB"] =
                                                {
                                                }, -- end of ["PB"]
                                                ["Sequence 1 Blue"] =
                                                {
                                                }, -- end of ["Sequence 1 Blue"]
                                                ["Sequence 3 Yellow"] =
                                                {
                                                }, -- end of ["Sequence 3 Yellow"]
                                                ["A/A Waypoint"] =
                                                {
                                                }, -- end of ["A/A Waypoint"]
                                                ["PP"] =
                                                {
                                                }, -- end of ["PP"]
                                                ["Start Location"] =
                                                {
                                                }, -- end of ["Start Location"]
                                            }, -- end of ["GroupsPoints"]
                                            ["Points"] =
                                            {
                                            }, -- end of ["Points"]
                                        }, -- end of ["dataCartridge"]
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["name"] = zeus.target.aircraftName,
                                        ["payload"] =
                                        {
                                            ["pylons"] =
                                            {
                                                [1] =
                                                {
                                                    ["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
                                                }, -- end of [1]
                                                [2] =
                                                {
                                                    ["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
                                                }, -- end of [2]
                                                [3] =
                                                {
                                                    ["CLSID"] = "<CLEAN>",
                                                }, -- end of [3]
                                                [4] =
                                                {
                                                    ["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
                                                }, -- end of [4]
                                                [5] =
                                                {
                                                    ["CLSID"] = "{FPU_8A_FUEL_TANK}",
                                                }, -- end of [5]
                                                [6] =
                                                {
                                                    ["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
                                                }, -- end of [6]
                                                [7] =
                                                {
                                                    ["CLSID"] = "<CLEAN>",
                                                }, -- end of [7]
                                                [8] =
                                                {
                                                    ["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
                                                }, -- end of [8]
                                                [9] =
                                                {
                                                    ["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
                                                }, -- end of [9]
                                            }, -- end of ["pylons"]
                                            ["fuel"] = 4900,
                                            ["flare"] = 60,
                                            ["ammo_type"] = 1,
                                            ["chaff"] = 60,
                                            ["gun"] = 100,
                                        }, -- end of ["payload"]
                                        ["heading"] = 0,
                                        ["callsign"] =
                                        {
                                            [1] = 4,
                                            [2] = 1,
                                            ["name"] = zeus.target.aircraftName,
                                            [3] = 1,
                                        }, -- end of ["callsign"]
                                        ["datalinks"] =
                                        {
                                            ["Link16"] =
                                            {
                                                ["settings"] =
                                                {
                                                    ["FF1_Channel"] = 2,
                                                    ["FF2_Channel"] = 3,
                                                    ["transmitPower"] = 0,
                                                    ["AIC_Channel"] = 1,
                                                    ["VOCA_Channel"] = 4,
                                                    ["VOCB_Channel"] = 5,
                                                }, -- end of ["settings"]
                                                ["network"] =
                                                {
                                                    ["teamMembers"] =
                                                    {
                                                        [1] =
                                                        {
                                                            ["missionUnitId"] = 4,
                                                        }, -- end of [1]
                                                    }, -- end of ["teamMembers"]
                                                    ["donors"] =
                                                    {
                                                    }, -- end of ["donors"]
                                                }, -- end of ["network"]
                                            }, -- end of ["Link16"]
                                        }, -- end of ["datalinks"]
                                    }, -- end of [1]
                                }, -- end of ["units"]
                                ["y"] = zeus.target.aircraftPos.z,
                                ["x"] = zeus.target.aircraftPos.x,
                                ["name"] = zeus.target.aircraftName,
                                ["communication"] = true,
                                ["start_time"] = 0,
                                ["frequency"] = 305,
                        }

    local _j11Data =
                        {
                            ["modulation"] = 0,
                                ["tasks"] =
                                {
                                }, -- end of ["tasks"]
                                ["radioSet"] = false,
                                ["task"] = "CAP",
                                ["uncontrolled"] = false,
                                ["taskSelected"] = true,
                                ["route"] =
                                {
                                    ["points"] =
                                    {
                                        [1] =
                                        {
                                            ["alt"] = 7620,
                                            ["action"] = "Turning Point",
                                            ["alt_type"] = "BARO",
                                            ["properties"] =
                                            {
                                                ["addopt"] =
                                                {
                                                }, -- end of ["addopt"]
                                            }, -- end of ["properties"]
                                            ["speed"] = 169.58333333333,
                                            ["task"] =
                                            {
                                                ["id"] = "ComboTask",
                                                ["params"] =
                                                {
                                                    ["tasks"] =
                                                    {
                                                        [1] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["key"] = "CAP",
                                                            ["id"] = "EngageTargets",
                                                            ["number"] = 1,
                                                            ["auto"] = true,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Air",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                            }, -- end of ["params"]
                                                        }, -- end of [1]
                                                        [2] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 2,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 17,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [2]
                                                        [3] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 3,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = 4,
                                                                        ["name"] = 18,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [3]
                                                        [4] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 4,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 19,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [4]
                                                        [5] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["number"] = 5,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["targetTypes"] =
                                                                        {
                                                                        }, -- end of ["targetTypes"]
                                                                        ["name"] = 21,
                                                                        ["value"] = "none;",
                                                                        ["noTargetTypes"] =
                                                                        {
                                                                            [1] = "Fighters",
                                                                            [2] = "Multirole fighters",
                                                                            [3] = "Bombers",
                                                                            [4] = "Helicopters",
                                                                            [5] = "UAVs",
                                                                            [6] = "Infantry",
                                                                            [7] = "Fortifications",
                                                                            [8] = "Tanks",
                                                                            [9] = "IFV",
                                                                            [10] = "APC",
                                                                            [11] = "Artillery",
                                                                            [12] = "Unarmed vehicles",
                                                                            [13] = "AAA",
                                                                            [14] = "SR SAM",
                                                                            [15] = "MR SAM",
                                                                            [16] = "LR SAM",
                                                                            [17] = "Aircraft Carriers",
                                                                            [18] = "Cruisers",
                                                                            [19] = "Destroyers",
                                                                            [20] = "Frigates",
                                                                            [21] = "Corvettes",
                                                                            [22] = "Light armed ships",
                                                                            [23] = "Unarmed ships",
                                                                            [24] = "Submarines",
                                                                            [25] = "Cruise missiles",
                                                                            [26] = "Antiship Missiles",
                                                                            [27] = "AA Missiles",
                                                                            [28] = "AG Missiles",
                                                                            [29] = "SA Missiles",
                                                                        }, -- end of ["noTargetTypes"]
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [5]
                                                        [6] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = false,
                                                            ["id"] = "Orbit",
                                                            ["number"] = 6,
                                                            ["params"] =
                                                            {
                                                                ["altitude"] = 7620,
                                                                ["pattern"] = "Circle",
                                                                ["speed"] = 138.88888888889,
                                                            }, -- end of ["params"]
                                                        }, -- end of [6]
                                                        [7] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = false,
                                                            ["id"] = "EngageTargets",
                                                            ["number"] = 7,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Planes",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                                ["value"] = "Planes;",
                                                                ["noTargetTypes"] =
                                                                {
                                                                    [1] = "Helicopters",
                                                                    [2] = "UAVs",
                                                                    [3] = "Cruise missiles",
                                                                    [4] = "Antiship Missiles",
                                                                    [5] = "AA Missiles",
                                                                    [6] = "AG Missiles",
                                                                    [7] = "SA Missiles",
                                                                }, -- end of ["noTargetTypes"]
                                                                ["maxDistEnabled"] = false,
                                                                ["maxDist"] = 15000,
                                                            }, -- end of ["params"]
                                                        }, -- end of [7]
                                                    }, -- end of ["tasks"]
                                                }, -- end of ["params"]
                                            }, -- end of ["task"]
                                            ["type"] = "Turning Point",
                                            ["ETA"] = 0,
                                            ["ETA_locked"] = true,
                                            ["y"] = zeus.target.aircraftPos.z,
                                            ["x"] = zeus.target.aircraftPos.x,
                                            ["speed_locked"] = true,
                                            ["formation_template"] = "",
                                        }, -- end of [1]
                                    }, -- end of ["points"]
                                }, -- end of ["route"]
                                ["groupId"] = owngroupID,
                                ["hidden"] = false,
                                ["units"] =
                                {
                                    [1] =
                                    {
                                        ["alt"] = 7620,
                                        ["hardpoint_racks"] = true,
                                        ["alt_type"] = "BARO",
                                        ["livery_id"] = "plaaf 14th ad",
                                        ["skill"] = "Excellent",
                                        ["speed"] = 169.58333333333,
                                        ["type"] = "J-11A",
                                        ["unitId"] = 1,
                                        ["psi"] = 0,
                                        ["onboard_num"] = "013",
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["name"] = zeus.target.aircraftName,
                                        ["payload"] =
                                        {
                                            ["pylons"] =
                                            {
                                                [1] =
                                                {
                                                    ["CLSID"] = "{RKL609_L}",
                                                }, -- end of [1]
                                                [2] =
                                                {
                                                    ["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
                                                }, -- end of [2]
                                                [3] =
                                                {
                                                    ["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
                                                }, -- end of [3]
                                                [4] =
                                                {
                                                    ["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
                                                }, -- end of [4]
                                                [7] =
                                                {
                                                    ["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
                                                }, -- end of [7]
                                                [8] =
                                                {
                                                    ["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
                                                }, -- end of [8]
                                                [10] =
                                                {
                                                    ["CLSID"] = "{RKL609_R}",
                                                }, -- end of [10]
                                                [9] =
                                                {
                                                    ["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
                                                }, -- end of [9]
                                            }, -- end of ["pylons"]
                                            ["fuel"] = 9400,
                                            ["flare"] = 96,
                                            ["chaff"] = 96,
                                            ["gun"] = 100,
                                        }, -- end of ["payload"]
                                        ["heading"] = 0,
                                        ["callsign"] = 101,
                                    }, -- end of [1]
                                }, -- end of ["units"]
                                ["y"] = zeus.target.aircraftPos.z,
                                ["x"] = zeus.target.aircraftPos.x,
                                ["name"] = zeus.target.aircraftName,
                                ["communication"] = true,
                                ["start_time"] = 0,
                                ["frequency"] = 127.5,
                        }

    local _f1Data =
                        {
                            ["modulation"] = 0,
                                ["tasks"] =
                                {
                                }, -- end of ["tasks"]
                                ["radioSet"] = false,
                                ["task"] = "CAP",
                                ["uncontrolled"] = false,
                                ["taskSelected"] = true,
                                ["route"] =
                                {
                                    ["points"] =
                                    {
                                        [1] =
                                        {
                                            ["alt"] = 6096,
                                            ["action"] = "Turning Point",
                                            ["alt_type"] = "BARO",
                                            ["properties"] =
                                            {
                                                ["addopt"] =
                                                {
                                                }, -- end of ["addopt"]
                                            }, -- end of ["properties"]
                                            ["speed"] = 254.91922185783,
                                            ["task"] =
                                            {
                                                ["id"] = "ComboTask",
                                                ["params"] =
                                                {
                                                    ["tasks"] =
                                                    {
                                                        [1] =
                                                        {
                                                            ["number"] = 1,
                                                            ["key"] = "CAP",
                                                            ["id"] = "EngageTargets",
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Air",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                            }, -- end of ["params"]
                                                        }, -- end of [1]
                                                        [2] =
                                                        {
                                                            ["number"] = 2,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 17,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [2]
                                                        [3] =
                                                        {
                                                            ["number"] = 3,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = 4,
                                                                        ["name"] = 18,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [3]
                                                        [4] =
                                                        {
                                                            ["number"] = 4,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["value"] = true,
                                                                        ["name"] = 19,
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [4]
                                                        [5] =
                                                        {
                                                            ["number"] = 5,
                                                            ["auto"] = true,
                                                            ["id"] = "WrappedAction",
                                                            ["enabled"] = true,
                                                            ["params"] =
                                                            {
                                                                ["action"] =
                                                                {
                                                                    ["id"] = "Option",
                                                                    ["params"] =
                                                                    {
                                                                        ["targetTypes"] =
                                                                        {
                                                                        }, -- end of ["targetTypes"]
                                                                        ["name"] = 21,
                                                                        ["value"] = "none;",
                                                                        ["noTargetTypes"] =
                                                                        {
                                                                            [1] = "Fighters",
                                                                            [2] = "Multirole fighters",
                                                                            [3] = "Bombers",
                                                                            [4] = "Helicopters",
                                                                            [5] = "UAVs",
                                                                            [6] = "Infantry",
                                                                            [7] = "Fortifications",
                                                                            [8] = "Tanks",
                                                                            [9] = "IFV",
                                                                            [10] = "APC",
                                                                            [11] = "Artillery",
                                                                            [12] = "Unarmed vehicles",
                                                                            [13] = "AAA",
                                                                            [14] = "SR SAM",
                                                                            [15] = "MR SAM",
                                                                            [16] = "LR SAM",
                                                                            [17] = "Aircraft Carriers",
                                                                            [18] = "Cruisers",
                                                                            [19] = "Destroyers",
                                                                            [20] = "Frigates",
                                                                            [21] = "Corvettes",
                                                                            [22] = "Light armed ships",
                                                                            [23] = "Unarmed ships",
                                                                            [24] = "Submarines",
                                                                            [25] = "Cruise missiles",
                                                                            [26] = "Antiship Missiles",
                                                                            [27] = "AA Missiles",
                                                                            [28] = "AG Missiles",
                                                                            [29] = "SA Missiles",
                                                                        }, -- end of ["noTargetTypes"]
                                                                    }, -- end of ["params"]
                                                                }, -- end of ["action"]
                                                            }, -- end of ["params"]
                                                        }, -- end of [5]
                                                        [6] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = false,
                                                            ["id"] = "Orbit",
                                                            ["number"] = 6,
                                                            ["params"] =
                                                            {
                                                                ["altitude"] = 6096,
                                                                ["pattern"] = "Circle",
                                                                ["speed"] = 138.88888888889,
                                                            }, -- end of ["params"]
                                                        }, -- end of [6]
                                                        [7] =
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = false,
                                                            ["id"] = "EngageTargets",
                                                            ["number"] = 7,
                                                            ["params"] =
                                                            {
                                                                ["targetTypes"] =
                                                                {
                                                                    [1] = "Planes",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                                ["value"] = "Planes;",
                                                                ["noTargetTypes"] =
                                                                {
                                                                    [1] = "Helicopters",
                                                                    [2] = "UAVs",
                                                                    [3] = "Cruise missiles",
                                                                    [4] = "Antiship Missiles",
                                                                    [5] = "AA Missiles",
                                                                    [6] = "AG Missiles",
                                                                    [7] = "SA Missiles",
                                                                }, -- end of ["noTargetTypes"]
                                                                ["maxDistEnabled"] = false,
                                                                ["maxDist"] = 15000,
                                                            }, -- end of ["params"]
                                                        }, -- end of [7]
                                                    }, -- end of ["tasks"]
                                                }, -- end of ["params"]
                                            }, -- end of ["task"]
                                            ["type"] = "Turning Point",
                                            ["ETA"] = 0,
                                            ["ETA_locked"] = true,
                                            ["y"] = zeus.target.aircraftPos.z,
                                            ["x"] = zeus.target.aircraftPos.x,
                                            ["speed_locked"] = true,
                                            ["formation_template"] = "",
                                        }, -- end of [1]
                                    }, -- end of ["points"]
                                }, -- end of ["route"]
                                ["groupId"] = owngroupID,
                                ["hidden"] = false,
                                ["units"] =
                                {
                                    [1] =
                                    {
                                        ["alt"] = 6096,
                                        ["hardpoint_racks"] = true,
                                        ["alt_type"] = "BARO",
                                        ["livery_id"] = "iriaf 3-6205 _ 2010s asia minor (eq variant)",
                                        ["skill"] = "Excellent",
                                        ["speed"] = 254.91922185783,
                                        ["AddPropAircraft"] =
                                        {
                                        }, -- end of ["AddPropAircraft"]
                                        ["type"] = "Mirage-F1CE",
                                        ["unitId"] = 1,
                                        ["psi"] = 0,
                                        ["onboard_num"] = "013",
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["name"] = zeus.target.aircraftName,
                                        ["payload"] =
                                        {
                                            ["pylons"] =
                                            {
                                                [1] =
                                                {
                                                    ["CLSID"] = "{AIM-9JULI}",
                                                }, -- end of [1]
                                                [3] =
                                                {
                                                    ["CLSID"] = "{R530F_IR}",
                                                }, -- end of [3]
                                                [4] =
                                                {
                                                    ["CLSID"] = "PTB-1200-F1",
                                                }, -- end of [4]
                                                [5] =
                                                {
                                                    ["CLSID"] = "{R530F_IR}",
                                                }, -- end of [5]
                                                [7] =
                                                {
                                                    ["CLSID"] = "{AIM-9JULI}",
                                                }, -- end of [7]
                                            }, -- end of ["pylons"]
                                            ["fuel"] = 3356,
                                            ["flare"] = 15,
                                            ["chaff"] = 30,
                                            ["gun"] = 100,
                                        }, -- end of ["payload"]
                                        ["heading"] = 0,
                                        ["callsign"] =
                                        {
                                            [1] = 5,
                                            [2] = 1,
                                            ["name"] = zeus.target.aircraftName,
                                            [3] = 1,
                                        }, -- end of ["callsign"]
                                    }, -- end of [1]
                                }, -- end of ["units"]
                                ["y"] = zeus.target.aircraftPos.z,
                                ["x"] = zeus.target.aircraftPos.x,
                                ["name"] = zeus.target.aircraftName,
                                ["communication"] = true,
                                ["start_time"] = 0,
                                ["frequency"] = 127.5,
                        }
    
    local _texacoData =
                        {
                            ["modulation"] = 0,
                            ["tasks"] = 
                            {
                            }, -- end of ["tasks"]
                            ["radioSet"] = true,
                            ["task"] = "Refueling",
                            ["uncontrolled"] = false,
                            ["taskSelected"] = true,
                            ["route"] = 
                            {
                                ["points"] = 
                                {
                                    [1] = 
                                    {
                                        ["alt"] = 7315.2,
                                        ["action"] = "Turning Point",
                                        ["alt_type"] = "BARO",
                                        ["properties"] = 
                                        {
                                            ["addopt"] = 
                                            {
                                            }, -- end of ["addopt"]
                                        }, -- end of ["properties"]
                                        ["speed"] = 207.02274359335,
                                        ["task"] = 
                                        {
                                            ["id"] = "ComboTask",
                                            ["params"] = 
                                            {
                                                ["tasks"] = 
                                                {
                                                    [1] = 
                                                    {
                                                        ["number"] = 1,
                                                        ["auto"] = true,
                                                        ["id"] = "Tanker",
                                                        ["enabled"] = true,
                                                        ["params"] = 
                                                        {
                                                        }, -- end of ["params"]
                                                    }, -- end of [1]
                                                    [2] = 
                                                    {
                                                        ["number"] = 2,
                                                        ["auto"] = true,
                                                        ["id"] = "WrappedAction",
                                                        ["enabled"] = true,
                                                        ["params"] = 
                                                        {
                                                            ["action"] = 
                                                            {
                                                                ["id"] = "ActivateBeacon",
                                                                ["params"] = 
                                                                {
                                                                    ["type"] = 4,
                                                                    ["AA"] = false,
                                                                    ["callsign"] = "TEX",
                                                                    ["system"] = 4,
                                                                    ["channel"] = 68,
                                                                    ["modeChannel"] = "X",
                                                                    ["unitId"] = 1,
                                                                    ["bearing"] = true,
                                                                    ["frequency"] = 1155000000,
                                                                }, -- end of ["params"]
                                                            }, -- end of ["action"]
                                                        }, -- end of ["params"]
                                                    }, -- end of [2]
                                                    [3] = 
                                                    {
                                                        ["number"] = 3,
                                                        ["auto"] = true,
                                                        ["id"] = "WrappedAction",
                                                        ["enabled"] = true,
                                                        ["params"] = 
                                                        {
                                                            ["action"] = 
                                                            {
                                                                ["id"] = "EPLRS",
                                                                ["params"] = 
                                                                {
                                                                    ["value"] = true,
                                                                    ["groupId"] = owngroupID,
                                                                }, -- end of ["params"]
                                                            }, -- end of ["action"]
                                                        }, -- end of ["params"]
                                                    }, -- end of [3]
                                                    [4] = 
                                                    {
                                                        ["number"] = 4,
                                                        ["auto"] = false,
                                                        ["id"] = "WrappedAction",
                                                        ["enabled"] = true,
                                                        ["params"] = 
                                                        {
                                                            ["action"] = 
                                                            {
                                                                ["id"] = "SetInvisible",
                                                                ["params"] = 
                                                                {
                                                                    ["value"] = true,
                                                                }, -- end of ["params"]
                                                            }, -- end of ["action"]
                                                        }, -- end of ["params"]
                                                    }, -- end of [4]
                                                    [5] = 
                                                    {
                                                        ["number"] = 5,
                                                        ["auto"] = false,
                                                        ["id"] = "WrappedAction",
                                                        ["enabled"] = true,
                                                        ["params"] = 
                                                        {
                                                            ["action"] = 
                                                            {
                                                                ["id"] = "SetImmortal",
                                                                ["params"] = 
                                                                {
                                                                    ["value"] = true,
                                                                }, -- end of ["params"]
                                                            }, -- end of ["action"]
                                                        }, -- end of ["params"]
                                                    }, -- end of [5]
                                                }, -- end of ["tasks"]
                                            }, -- end of ["params"]
                                        }, -- end of ["task"]
                                        ["type"] = "Turning Point",
                                        ["ETA"] = 0,
                                        ["ETA_locked"] = true,
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["speed_locked"] = true,
                                        ["formation_template"] = "",
                                    }, -- end of [1]
                                    [2] = 
                                    {
                                        ["alt"] = 7315.2,
                                        ["action"] = "Turning Point",
                                        ["alt_type"] = "BARO",
                                        ["properties"] = 
                                        {
                                            ["addopt"] = 
                                            {
                                            }, -- end of ["addopt"]
                                        }, -- end of ["properties"]
                                        ["speed"] = 207.02274359335,
                                        ["task"] = 
                                        {
                                            ["id"] = "ComboTask",
                                            ["params"] = 
                                            {
                                                ["tasks"] = 
                                                {
                                                    [1] = 
                                                    {
                                                        ["number"] = 1,
                                                        ["auto"] = false,
                                                        ["id"] = "Orbit",
                                                        ["enabled"] = true,
                                                        ["params"] = 
                                                        {
                                                            ["altitude"] = 7315.2,
                                                            ["pattern"] = "Race-Track",
                                                            ["speed"] = 207.02274359335,
                                                            ["speedEdited"] = true,
                                                        }, -- end of ["params"]
                                                    }, -- end of [1]
                                                }, -- end of ["tasks"]
                                            }, -- end of ["params"]
                                        }, -- end of ["task"]
                                        ["type"] = "Turning Point",
                                        ["ETA"] = 56.622391387966,
                                        ["ETA_locked"] = false,
                                        ["y"] = zeus.target.aircraftPos.z + 1000,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["speed_locked"] = true,
                                        ["formation_template"] = "",
                                    }, -- end of [2]
                                    [3] = 
                                    {
                                        ["alt"] = 7315.2,
                                        ["action"] = "Turning Point",
                                        ["alt_type"] = "BARO",
                                        ["properties"] = 
                                        {
                                            ["addopt"] = 
                                            {
                                            }, -- end of ["addopt"]
                                        }, -- end of ["properties"]
                                        ["speed"] = 207.02274359335,
                                        ["task"] = 
                                        {
                                            ["id"] = "ComboTask",
                                            ["params"] = 
                                            {
                                                ["tasks"] = 
                                                {
                                                }, -- end of ["tasks"]
                                            }, -- end of ["params"]
                                        }, -- end of ["task"]
                                        ["type"] = "Turning Point",
                                        ["ETA"] = 444.43347384281,
                                        ["ETA_locked"] = false,
                                        ["y"] = zeus.target.aircraftPos.z + 75000,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["speed_locked"] = true,
                                        ["formation_template"] = "",
                                    }, -- end of [3]
                                }, -- end of ["points"]
                            }, -- end of ["route"]
                            ["groupId"] = owngroupID,
                            ["hidden"] = false,
                            ["units"] = 
                            {
                                [1] = 
                                {
                                    ["alt"] = 7315.2,
                                    ["alt_type"] = "BARO",
                                    ["livery_id"] = "22nd arw",
                                    ["skill"] = "Excellent",
                                    ["speed"] = 207.02274359335,
                                    ["type"] = "KC135MPRS",
                                    ["unitId"] = 1,
                                    ["psi"] = -1.5707963267949,
                                    ["onboard_num"] = "010",
                                    ["y"] = zeus.target.aircraftPos.z,
                                    ["x"] = zeus.target.aircraftPos.x,
                                    ["name"] = zeus.target.aircraftName,
                                    ["payload"] = 
                                    {
                                        ["pylons"] = 
                                        {
                                        }, -- end of ["pylons"]
                                        ["fuel"] = 90700,
                                        ["flare"] = 60,
                                        ["chaff"] = 120,
                                        ["gun"] = 100,
                                    }, -- end of ["payload"]
                                    ["heading"] = 1.5707963267949,
                                    ["callsign"] = 
                                    {
                                        [1] = 1,
                                        [2] = 5,
                                        ["name"] = Texaco51,
                                        [3] = 1,
                                    }, -- end of ["callsign"]
                                }, -- end of [1]
                            }, -- end of ["units"]
                            ["y"] = zeus.target.aircraftPos.z,
                            ["x"] = zeus.target.aircraftPos.x,
                            ["name"] = zeus.target.aircraftName,
                            ["communication"] = true,
                            ["start_time"] = 0,
                            ["frequency"] = 283,

                        }

    local _arcoData =
                        {
                            ["modulation"] = 0,
                            ["tasks"] = 
                            {
                            }, -- end of ["tasks"]
                            ["radioSet"] = true,
                            ["task"] = "Refueling",
                            ["uncontrolled"] = false,
                            ["taskSelected"] = true,
                            ["route"] = 
                            {
                                ["points"] = 
                                {
                                    [1] = 
                                    {
                                        ["alt"] = 6096,
                                        ["action"] = "Turning Point",
                                        ["alt_type"] = "BARO",
                                        ["properties"] = 
                                        {
                                            ["addopt"] = 
                                            {
                                            }, -- end of ["addopt"]
                                        }, -- end of ["properties"]
                                        ["speed"] = 210.33622240736,
                                        ["task"] = 
                                        {
                                            ["id"] = "ComboTask",
                                            ["params"] = 
                                            {
                                                ["tasks"] = 
                                                {
                                                    [1] = 
                                                    {
                                                        ["number"] = 1,
                                                        ["auto"] = true,
                                                        ["id"] = "Tanker",
                                                        ["enabled"] = true,
                                                        ["params"] = 
                                                        {
                                                        }, -- end of ["params"]
                                                    }, -- end of [1]
                                                    [2] = 
                                                    {
                                                        ["number"] = 2,
                                                        ["auto"] = true,
                                                        ["id"] = "WrappedAction",
                                                        ["enabled"] = true,
                                                        ["params"] = 
                                                        {
                                                            ["action"] = 
                                                            {
                                                                ["id"] = "ActivateBeacon",
                                                                ["params"] = 
                                                                {
                                                                    ["type"] = 4,
                                                                    ["AA"] = false,
                                                                    ["unitId"] = 1,
                                                                    ["system"] = 4,
                                                                    ["channel"] = 69,
                                                                    ["modeChannel"] = "X",
                                                                    ["callsign"] = "ARC",
                                                                    ["bearing"] = true,
                                                                    ["frequency"] = 1156000000,
                                                                }, -- end of ["params"]
                                                            }, -- end of ["action"]
                                                        }, -- end of ["params"]
                                                    }, -- end of [2]
                                                    [3] = 
                                                    {
                                                        ["number"] = 3,
                                                        ["auto"] = true,
                                                        ["id"] = "WrappedAction",
                                                        ["enabled"] = true,
                                                        ["params"] = 
                                                        {
                                                            ["action"] = 
                                                            {
                                                                ["id"] = "EPLRS",
                                                                ["params"] = 
                                                                {
                                                                    ["value"] = true,
                                                                    ["groupId"] = owngroupID,
                                                                }, -- end of ["params"]
                                                            }, -- end of ["action"]
                                                        }, -- end of ["params"]
                                                    }, -- end of [3]
                                                    [4] = 
                                                    {
                                                        ["number"] = 4,
                                                        ["auto"] = false,
                                                        ["id"] = "WrappedAction",
                                                        ["enabled"] = true,
                                                        ["params"] = 
                                                        {
                                                            ["action"] = 
                                                            {
                                                                ["id"] = "SetInvisible",
                                                                ["params"] = 
                                                                {
                                                                    ["value"] = true,
                                                                }, -- end of ["params"]
                                                            }, -- end of ["action"]
                                                        }, -- end of ["params"]
                                                    }, -- end of [4]
                                                    [5] = 
                                                    {
                                                        ["number"] = 5,
                                                        ["auto"] = false,
                                                        ["id"] = "WrappedAction",
                                                        ["enabled"] = true,
                                                        ["params"] = 
                                                        {
                                                            ["action"] = 
                                                            {
                                                                ["id"] = "SetImmortal",
                                                                ["params"] = 
                                                                {
                                                                    ["value"] = true,
                                                                }, -- end of ["params"]
                                                            }, -- end of ["action"]
                                                        }, -- end of ["params"]
                                                    }, -- end of [5]
                                                }, -- end of ["tasks"]
                                            }, -- end of ["params"]
                                        }, -- end of ["task"]
                                        ["type"] = "Turning Point",
                                        ["ETA"] = 0,
                                        ["ETA_locked"] = true,
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["speed_locked"] = true,
                                        ["formation_template"] = "",
                                    }, -- end of [1]
                                    [2] = 
                                    {
                                        ["alt"] = 6096,
                                        ["action"] = "Turning Point",
                                        ["alt_type"] = "BARO",
                                        ["properties"] = 
                                        {
                                            ["addopt"] = 
                                            {
                                            }, -- end of ["addopt"]
                                        }, -- end of ["properties"]
                                        ["speed"] = 210.33622240736,
                                        ["task"] = 
                                        {
                                            ["id"] = "ComboTask",
                                            ["params"] = 
                                            {
                                                ["tasks"] = 
                                                {
                                                    [1] = 
                                                    {
                                                        ["number"] = 1,
                                                        ["auto"] = false,
                                                        ["id"] = "Orbit",
                                                        ["enabled"] = true,
                                                        ["params"] = 
                                                        {
                                                            ["altitude"] = 6096,
                                                            ["pattern"] = "Race-Track",
                                                            ["speed"] = 210.33622240736,
                                                            ["speedEdited"] = true,
                                                        }, -- end of ["params"]
                                                    }, -- end of [1]
                                                }, -- end of ["tasks"]
                                            }, -- end of ["params"]
                                        }, -- end of ["task"]
                                        ["type"] = "Turning Point",
                                        ["ETA"] = 55.730404776667,
                                        ["ETA_locked"] = false,
                                        ["y"] = zeus.target.aircraftPos.z + 1000,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["speed_locked"] = true,
                                        ["formation_template"] = "",
                                    }, -- end of [2]
                                    [3] = 
                                    {
                                        ["alt"] = 6096,
                                        ["action"] = "Turning Point",
                                        ["alt_type"] = "BARO",
                                        ["properties"] = 
                                        {
                                            ["addopt"] = 
                                            {
                                            }, -- end of ["addopt"]
                                        }, -- end of ["properties"]
                                        ["speed"] = 210.33622240736,
                                        ["task"] = 
                                        {
                                            ["id"] = "ComboTask",
                                            ["params"] = 
                                            {
                                                ["tasks"] = 
                                                {
                                                }, -- end of ["tasks"]
                                            }, -- end of ["params"]
                                        }, -- end of ["task"]
                                        ["type"] = "Turning Point",
                                        ["ETA"] = 433.35770542907,
                                        ["ETA_locked"] = false,
                                        ["y"] = zeus.target.aircraftPos.z + 75000,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["speed_locked"] = true,
                                        ["formation_template"] = "",
                                    }, -- end of [3]
                                }, -- end of ["points"]
                            }, -- end of ["route"]
                            ["groupId"] = owngroupID,
                            ["hidden"] = false,
                            ["units"] = 
                            {
                                [1] = 
                                {
                                    ["alt"] = 6096,
                                    ["alt_type"] = "BARO",
                                    ["livery_id"] = "standard usaf",
                                    ["skill"] = "Excellent",
                                    ["speed"] = 210.33622240736,
                                    ["AddPropAircraft"] = 
                                    {
                                        ["VoiceCallsignLabel"] = "AO",
                                        ["VoiceCallsignNumber"] = "11",
                                        ["STN_L16"] = "00202",
                                    }, -- end of ["AddPropAircraft"]
                                    ["type"] = "KC-135",
                                    ["unitId"] = 1,
                                    ["psi"] = -1.610249527892,
                                    ["onboard_num"] = "011",
                                    ["y"] = zeus.target.aircraftPos.z,
                                    ["x"] = zeus.target.aircraftPos.x,
                                    ["name"] = zeus.target.aircraftName,
                                    ["payload"] = 
                                    {
                                        ["pylons"] = 
                                        {
                                        }, -- end of ["pylons"]
                                        ["fuel"] = 90700,
                                        ["flare"] = 0,
                                        ["chaff"] = 0,
                                        ["gun"] = 100,
                                    }, -- end of ["payload"]
                                    ["heading"] = 1.610249527892,
                                    ["callsign"] = 
                                    {
                                        [1] = 2,
                                        [2] = 5,
                                        ["name"] = Arco51,
                                        [3] = 1,
                                    }, -- end of ["callsign"]
                                }, -- end of [1]
                            }, -- end of ["units"]
                            ["y"] = zeus.target.aircraftPos.z,
                            ["x"] = zeus.target.aircraftPos.x,
                            ["name"] = zeus.target.aircraftName,
                            ["communication"] = true,
                            ["start_time"] = 0,
                            ["frequency"] = 140.35,
                        }

    local _p51Data =
                        {
                            ["modulation"] = 0,
                            ["tasks"] = 
                            {
                            }, -- end of ["tasks"]
                            ["radioSet"] = false,
                            ["task"] = "CAP",
                            ["uncontrolled"] = false,
                            ["taskSelected"] = true,
                            ["route"] = 
                            {
                                ["points"] = 
                                {
                                    [1] = 
                                    {
                                        ["alt"] = 1524,
                                        ["action"] = "Turning Point",
                                        ["alt_type"] = "BARO",
                                        ["properties"] = 
                                        {
                                            ["addopt"] = 
                                            {
                                            }, -- end of ["addopt"]
                                        }, -- end of ["properties"]
                                        ["speed"] = 92.5,
                                        ["task"] = 
                                        {
                                            ["id"] = "ComboTask",
                                            ["params"] = 
                                            {
                                                ["tasks"] = 
                                                {
                                                    [1] = 
                                                    {
                                                        ["enabled"] = true,
                                                        ["auto"] = true,
                                                        ["id"] = "EngageTargets",
                                                        ["number"] = 1,
                                                        ["key"] = "CAP",
                                                        ["params"] = 
                                                        {
                                                            ["targetTypes"] = 
                                                            {
                                                                [1] = "Air",
                                                            }, -- end of ["targetTypes"]
                                                            ["priority"] = 0,
                                                        }, -- end of ["params"]
                                                    }, -- end of [1]
                                                }, -- end of ["tasks"]
                                            }, -- end of ["params"]
                                        }, -- end of ["task"]
                                        ["type"] = "Turning Point",
                                        ["ETA"] = 0,
                                        ["ETA_locked"] = true,
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["speed_locked"] = true,
                                        ["formation_template"] = "",
                                    }, -- end of [1]
                                }, -- end of ["points"]
                            }, -- end of ["route"]
                            ["groupId"] = owngroupID,
                            ["hidden"] = false,
                            ["units"] = 
                            {
                                [1] = 
                                {
                                    ["alt"] = 1524,
                                    ["alt_type"] = "BARO",
                                    ["livery_id"] = "USAF 363rd FS, 357th FG DESERT RAT",
                                    ["skill"] = "Excellent",
                                    ["speed"] = 92.5,
                                    ["type"] = "P-51D-30-NA",
                                    ["unitId"] = 1,
                                    ["psi"] = 0,
                                    ["onboard_num"] = "010",
                                    ["y"] = zeus.target.aircraftPos.z,
                                    ["x"] = zeus.target.aircraftPos.x,
                                    ["name"] = zeus.target.aircraftName,
                                    ["payload"] = 
                                    {
                                        ["pylons"] = 
                                        {
                                        }, -- end of ["pylons"]
                                        ["fuel"] = 732,
                                        ["flare"] = 0,
                                        ["ammo_type"] = 1,
                                        ["chaff"] = 0,
                                        ["gun"] = 100,
                                    }, -- end of ["payload"]
                                    ["heading"] = 2.7938256657328,
                                    ["callsign"] = 
                                    {
                                        [1] = 3,
                                        [2] = 1,
                                        ["name"] = "Uzi11",
                                        [3] = 1,
                                    }, -- end of ["callsign"]
                                }, -- end of [1]
                            }, -- end of ["units"]
                            ["y"] = zeus.target.aircraftPos.z,
                            ["x"] = zeus.target.aircraftPos.x,
                            ["name"] = zeus.target.aircraftName,
                            ["communication"] = true,
                            ["start_time"] = 0,
                            ["frequency"] = 124,

                        }

    local _spitData =
                        {
                            ["modulation"] = 0,
                                ["tasks"] = 
                                {
                                }, -- end of ["tasks"]
                                ["radioSet"] = false,
                                ["task"] = "CAP",
                                ["uncontrolled"] = false,
                                ["route"] = 
                                {
                                    ["points"] = 
                                    {
                                        [1] = 
                                        {
                                            ["alt"] = 1524,
                                            ["action"] = "Turning Point",
                                            ["alt_type"] = "BARO",
                                            ["properties"] = 
                                            {
                                                ["addopt"] = 
                                                {
                                                }, -- end of ["addopt"]
                                            }, -- end of ["properties"]
                                            ["speed"] = 92.5,
                                            ["task"] = 
                                            {
                                                ["id"] = "ComboTask",
                                                ["params"] = 
                                                {
                                                    ["tasks"] = 
                                                    {
                                                        [1] = 
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["id"] = "EngageTargets",
                                                            ["number"] = 1,
                                                            ["key"] = "CAP",
                                                            ["params"] = 
                                                            {
                                                                ["targetTypes"] = 
                                                                {
                                                                    [1] = "Air",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                            }, -- end of ["params"]
                                                        }, -- end of [1]
                                                    }, -- end of ["tasks"]
                                                }, -- end of ["params"]
                                            }, -- end of ["task"]
                                            ["type"] = "Turning Point",
                                            ["ETA"] = 0,
                                            ["ETA_locked"] = true,
                                            ["y"] = zeus.target.aircraftPos.z,
                                            ["x"] = zeus.target.aircraftPos.x,
                                            ["speed_locked"] = true,
                                            ["formation_template"] = "",
                                        }, -- end of [1]
                                    }, -- end of ["points"]
                                }, -- end of ["route"]
                                ["groupId"] = owngroupID,
                                ["hidden"] = false,
                                ["units"] = 
                                {
                                    [1] = 
                                    {
                                        ["alt"] = 1524,
                                        ["alt_type"] = "BARO",
                                        ["livery_id"] = "403 rcaf beurling",
                                        ["skill"] = "Excellent",
                                        ["speed"] = 92.5,
                                        ["type"] = "SpitfireLFMkIX",
                                        ["unitId"] = 1,
                                        ["psi"] = 0,
                                        ["onboard_num"] = "011",
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["name"] = zeus.target.aircraftName,
                                        ["payload"] = 
                                        {
                                            ["pylons"] = 
                                            {
                                            }, -- end of ["pylons"]
                                            ["fuel"] = 247,
                                            ["flare"] = 0,
                                            ["ammo_type"] = 1,
                                            ["chaff"] = 0,
                                            ["gun"] = 100,
                                        }, -- end of ["payload"]
                                        ["heading"] = 0,
                                        ["callsign"] = 
                                        {
                                            [1] = 1,
                                            [2] = 1,
                                            ["name"] = "Enfield11",
                                            [3] = 1,
                                        }, -- end of ["callsign"]
                                    }, -- end of [1]
                                }, -- end of ["units"]
                                ["y"] = zeus.target.aircraftPos.z,
                                ["x"] = zeus.target.aircraftPos.x,
                                ["name"] = zeus.target.aircraftName,
                                ["communication"] = true,
                                ["start_time"] = 0,
                                ["frequency"] = 124,
                            
                        }

    local _mossieData =
                        {
                            ["modulation"] = 0,
                            ["tasks"] = 
                            {
                            }, -- end of ["tasks"]
                            ["radioSet"] = false,
                            ["task"] = "CAP",
                            ["uncontrolled"] = false,
                            ["route"] = 
                            {
                                ["points"] = 
                                {
                                    [1] = 
                                    {
                                        ["alt"] = 1524,
                                        ["action"] = "Turning Point",
                                        ["alt_type"] = "BARO",
                                        ["properties"] = 
                                        {
                                            ["addopt"] = 
                                            {
                                            }, -- end of ["addopt"]
                                        }, -- end of ["properties"]
                                        ["speed"] = 113.05555555556,
                                        ["task"] = 
                                        {
                                            ["id"] = "ComboTask",
                                            ["params"] = 
                                            {
                                                ["tasks"] = 
                                                {
                                                    [1] = 
                                                    {
                                                        ["number"] = 1,
                                                        ["key"] = "CAP",
                                                        ["id"] = "EngageTargets",
                                                        ["enabled"] = true,
                                                        ["auto"] = true,
                                                        ["params"] = 
                                                        {
                                                            ["targetTypes"] = 
                                                            {
                                                                [1] = "Air",
                                                            }, -- end of ["targetTypes"]
                                                            ["priority"] = 0,
                                                        }, -- end of ["params"]
                                                    }, -- end of [1]
                                                }, -- end of ["tasks"]
                                            }, -- end of ["params"]
                                        }, -- end of ["task"]
                                        ["type"] = "Turning Point",
                                        ["ETA"] = 0,
                                        ["ETA_locked"] = true,
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["speed_locked"] = true,
                                        ["formation_template"] = "",
                                    }, -- end of [1]
                                }, -- end of ["points"]
                            }, -- end of ["route"]
                            ["groupId"] = owngroupID,
                            ["hidden"] = false,
                            ["units"] = 
                            {
                                [1] = 
                                {
                                    ["alt"] = 1524,
                                    ["alt_type"] = "BARO",
                                    ["livery_id"] = "305sqn july",
                                    ["skill"] = "Excellent",
                                    ["speed"] = 113.05555555556,
                                    ["AddPropAircraft"] = 
                                    {
                                        ["ResinLights"] = 0.15,
                                        ["SoloFlight"] = false,
                                    }, -- end of ["AddPropAircraft"]
                                    ["type"] = "MosquitoFBMkVI",
                                    ["unitId"] = 1,
                                    ["psi"] = 0,
                                    ["onboard_num"] = "012",
                                    ["y"] = zeus.target.aircraftPos.z,
                                    ["x"] = zeus.target.aircraftPos.x,
                                    ["name"] = zeus.target.aircraftName,
                                    ["payload"] = 
                                    {
                                        ["pylons"] = 
                                        {
                                        }, -- end of ["pylons"]
                                        ["fuel"] = 1483,
                                        ["flare"] = 0,
                                        ["ammo_type"] = 1,
                                        ["chaff"] = 0,
                                        ["gun"] = 100,
                                    }, -- end of ["payload"]
                                    ["heading"] = 0,
                                    ["callsign"] = 
                                    {
                                        [1] = 2,
                                        [2] = 1,
                                        ["name"] = "Springfield11",
                                        [3] = 1,
                                    }, -- end of ["callsign"]
                                }, -- end of [1]
                            }, -- end of ["units"]
                            ["y"] = zeus.target.aircraftPos.z,
                            ["x"] = zeus.target.aircraftPos.x,
                            ["name"] = zeus.target.aircraftName,
                            ["communication"] = true,
                            ["start_time"] = 0,
                            ["frequency"] = 124,  
                        }

    local _bf109Data =
                        {
                            ["modulation"] = 0,
                            ["tasks"] = 
                            {
                            }, -- end of ["tasks"]
                            ["radioSet"] = false,
                            ["task"] = "CAP",
                            ["uncontrolled"] = false,
                            ["taskSelected"] = true,
                            ["route"] = 
                            {
                                ["points"] = 
                                {
                                    [1] = 
                                    {
                                        ["alt"] = 1524,
                                        ["action"] = "Turning Point",
                                        ["alt_type"] = "BARO",
                                        ["properties"] = 
                                        {
                                            ["addopt"] = 
                                            {
                                            }, -- end of ["addopt"]
                                        }, -- end of ["properties"]
                                        ["speed"] = 92.5,
                                        ["task"] = 
                                        {
                                            ["id"] = "ComboTask",
                                            ["params"] = 
                                            {
                                                ["tasks"] = 
                                                {
                                                    [1] = 
                                                    {
                                                        ["number"] = 1,
                                                        ["key"] = "CAP",
                                                        ["id"] = "EngageTargets",
                                                        ["enabled"] = true,
                                                        ["auto"] = true,
                                                        ["params"] = 
                                                        {
                                                            ["targetTypes"] = 
                                                            {
                                                                [1] = "Air",
                                                            }, -- end of ["targetTypes"]
                                                            ["priority"] = 0,
                                                        }, -- end of ["params"]
                                                    }, -- end of [1]
                                                }, -- end of ["tasks"]
                                            }, -- end of ["params"]
                                        }, -- end of ["task"]
                                        ["type"] = "Turning Point",
                                        ["ETA"] = 0,
                                        ["ETA_locked"] = true,
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["speed_locked"] = true,
                                        ["formation_template"] = "",
                                    }, -- end of [1]
                                }, -- end of ["points"]
                            }, -- end of ["route"]
                            ["groupId"] = owngroupID,
                            ["hidden"] = false,
                            ["units"] = 
                            {
                                [1] = 
                                {
                                    ["alt"] = 1524,
                                    ["alt_type"] = "BARO",
                                    ["livery_id"] = "Bf-109 K4 Jagdgeschwader 53",
                                    ["skill"] = "Excellent",
                                    ["speed"] = 92.5,
                                    ["AddPropAircraft"] = 
                                    {
                                        ["MW50TankContents"] = 1,
                                    }, -- end of ["AddPropAircraft"]
                                    ["type"] = "Bf-109K-4",
                                    ["unitId"] = 1,
                                    ["psi"] = 0,
                                    ["onboard_num"] = "014",
                                    ["y"] = zeus.target.aircraftPos.z,
                                    ["x"] = zeus.target.aircraftPos.x,
                                    ["name"] = zeus.target.aircraftName,
                                    ["payload"] = 
                                    {
                                        ["pylons"] = 
                                        {
                                        }, -- end of ["pylons"]
                                        ["fuel"] = 296,
                                        ["flare"] = 0,
                                        ["ammo_type"] = 1,
                                        ["chaff"] = 0,
                                        ["gun"] = 100,
                                    }, -- end of ["payload"]
                                    ["heading"] = 2.7367008673047,
                                    ["callsign"] = 
                                    {
                                        [1] = 5,
                                        [2] = 1,
                                        ["name"] = "Dodge11",
                                        [3] = 1,
                                    }, -- end of ["callsign"]
                                }, -- end of [1]
                            }, -- end of ["units"]
                            ["y"] = zeus.target.aircraftPos.z,
                            ["x"] = zeus.target.aircraftPos.x,
                            ["name"] = zeus.target.aircraftName,
                            ["communication"] = true,
                            ["start_time"] = 0,
                            ["frequency"] = 40,  
                        }

    local _fw190a8Data =
                        {
                            ["modulation"] = 0,
                                ["tasks"] = 
                                {
                                }, -- end of ["tasks"]
                                ["radioSet"] = false,
                                ["task"] = "CAP",
                                ["uncontrolled"] = false,
                                ["route"] = 
                                {
                                    ["points"] = 
                                    {
                                        [1] = 
                                        {
                                            ["alt"] = 1524,
                                            ["action"] = "Turning Point",
                                            ["alt_type"] = "BARO",
                                            ["properties"] = 
                                            {
                                                ["addopt"] = 
                                                {
                                                }, -- end of ["addopt"]
                                            }, -- end of ["properties"]
                                            ["speed"] = 92.5,
                                            ["task"] = 
                                            {
                                                ["id"] = "ComboTask",
                                                ["params"] = 
                                                {
                                                    ["tasks"] = 
                                                    {
                                                        [1] = 
                                                        {
                                                            ["number"] = 1,
                                                            ["key"] = "CAP",
                                                            ["id"] = "EngageTargets",
                                                            ["enabled"] = true,
                                                            ["auto"] = true,
                                                            ["params"] = 
                                                            {
                                                                ["targetTypes"] = 
                                                                {
                                                                    [1] = "Air",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                            }, -- end of ["params"]
                                                        }, -- end of [1]
                                                    }, -- end of ["tasks"]
                                                }, -- end of ["params"]
                                            }, -- end of ["task"]
                                            ["type"] = "Turning Point",
                                            ["ETA"] = 0,
                                            ["ETA_locked"] = true,
                                            ["y"] = zeus.target.aircraftPos.z,
                                            ["x"] = zeus.target.aircraftPos.x,
                                            ["speed_locked"] = true,
                                            ["formation_template"] = "",
                                        }, -- end of [1]
                                    }, -- end of ["points"]
                                }, -- end of ["route"]
                                ["groupId"] = owngroupID,
                                ["hidden"] = false,
                                ["units"] = 
                                {
                                    [1] = 
                                    {
                                        ["alt"] = 1524,
                                        ["alt_type"] = "BARO",
                                        ["livery_id"] = "FW-190A8_2.JG 54",
                                        ["skill"] = "Excellent",
                                        ["speed"] = 92.5,
                                        ["AddPropAircraft"] = 
                                        {
                                        }, -- end of ["AddPropAircraft"]
                                        ["type"] = "FW-190A8",
                                        ["unitId"] = 1,
                                        ["psi"] = 0,
                                        ["onboard_num"] = "015",
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["name"] = zeus.target.aircraftName,
                                        ["payload"] = 
                                        {
                                            ["pylons"] = 
                                            {
                                            }, -- end of ["pylons"]
                                            ["fuel"] = 409,
                                            ["flare"] = 0,
                                            ["ammo_type"] = 1,
                                            ["chaff"] = 0,
                                            ["gun"] = 100,
                                        }, -- end of ["payload"]
                                        ["heading"] = 0,
                                        ["callsign"] = 
                                        {
                                            [1] = 6,
                                            [2] = 1,
                                            ["name"] = "Ford11",
                                            [3] = 1,
                                        }, -- end of ["callsign"]
                                    }, -- end of [1]
                                }, -- end of ["units"]
                                ["y"] = zeus.target.aircraftPos.z,
                                ["x"] = zeus.target.aircraftPos.x,
                                ["name"] = zeus.target.aircraftName,
                                ["communication"] = true,
                                ["start_time"] = 0,
                                ["frequency"] = 38.4,
                        }

    local _fw190d9Data =
                        {
                            ["modulation"] = 0,
                            ["tasks"] = 
                            {
                            }, -- end of ["tasks"]
                            ["radioSet"] = false,
                            ["task"] = "CAP",
                            ["uncontrolled"] = false,
                            ["route"] = 
                            {
                                ["points"] = 
                                {
                                    [1] = 
                                    {
                                        ["alt"] = 1524,
                                        ["action"] = "Turning Point",
                                        ["alt_type"] = "BARO",
                                        ["properties"] = 
                                        {
                                            ["addopt"] = 
                                            {
                                            }, -- end of ["addopt"]
                                        }, -- end of ["properties"]
                                        ["speed"] = 92.5,
                                        ["task"] = 
                                        {
                                            ["id"] = "ComboTask",
                                            ["params"] = 
                                            {
                                                ["tasks"] = 
                                                {
                                                    [1] = 
                                                    {
                                                        ["number"] = 1,
                                                        ["key"] = "CAP",
                                                        ["id"] = "EngageTargets",
                                                        ["enabled"] = true,
                                                        ["auto"] = true,
                                                        ["params"] = 
                                                        {
                                                            ["targetTypes"] = 
                                                            {
                                                                [1] = "Air",
                                                            }, -- end of ["targetTypes"]
                                                            ["priority"] = 0,
                                                        }, -- end of ["params"]
                                                    }, -- end of [1]
                                                }, -- end of ["tasks"]
                                            }, -- end of ["params"]
                                        }, -- end of ["task"]
                                        ["type"] = "Turning Point",
                                        ["ETA"] = 0,
                                        ["ETA_locked"] = true,
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["speed_locked"] = true,
                                        ["formation_template"] = "",
                                    }, -- end of [1]
                                }, -- end of ["points"]
                            }, -- end of ["route"]
                            ["groupId"] = owngroupID,
                            ["hidden"] = false,
                            ["units"] = 
                            {
                                [1] = 
                                {
                                    ["alt"] = 1524,
                                    ["alt_type"] = "BARO",
                                    ["livery_id"] = "FW-190D9_13.JG 51_Heinz Marquardt",
                                    ["skill"] = "Excellent",
                                    ["speed"] = 92.5,
                                    ["AddPropAircraft"] = 
                                    {
                                    }, -- end of ["AddPropAircraft"]
                                    ["type"] = "FW-190D9",
                                    ["unitId"] = 1,
                                    ["psi"] = 0,
                                    ["onboard_num"] = "016",
                                    ["y"] = zeus.target.aircraftPos.z,
                                    ["x"] = zeus.target.aircraftPos.x,
                                    ["name"] = zeus.target.aircraftName,
                                    ["payload"] = 
                                    {
                                        ["pylons"] = 
                                        {
                                        }, -- end of ["pylons"]
                                        ["fuel"] = 388,
                                        ["flare"] = 0,
                                        ["ammo_type"] = 1,
                                        ["chaff"] = 0,
                                        ["gun"] = 100,
                                    }, -- end of ["payload"]
                                    ["heading"] = -0.38931672183314,
                                    ["callsign"] = 
                                    {
                                        [1] = 7,
                                        [2] = 1,
                                        ["name"] = "Chevy11",
                                        [3] = 1,
                                    }, -- end of ["callsign"]
                                }, -- end of [1]
                            }, -- end of ["units"]
                            ["y"] = zeus.target.aircraftPos.z,
                            ["x"] = zeus.target.aircraftPos.x,
                            ["name"] = zeus.target.aircraftName,
                            ["communication"] = true,
                            ["start_time"] = 0,
                            ["frequency"] = 38.4, 
                        }

    local _ju88Data =
                        {
                            ["modulation"] = 0,
                            ["tasks"] = 
                            {
                            }, -- end of ["tasks"]
                            ["radioSet"] = false,
                            ["task"] = "Ground Attack",
                            ["uncontrolled"] = false,
                            ["taskSelected"] = true,
                            ["route"] = 
                            {
                                ["points"] = 
                                {
                                    [1] = 
                                    {
                                        ["alt"] = 1524,
                                        ["action"] = "Turning Point",
                                        ["alt_type"] = "BARO",
                                        ["properties"] = 
                                        {
                                            ["addopt"] = 
                                            {
                                            }, -- end of ["addopt"]
                                        }, -- end of ["properties"]
                                        ["speed"] = 113.05555555556,
                                        ["task"] = 
                                        {
                                            ["id"] = "ComboTask",
                                            ["params"] = 
                                            {
                                                ["tasks"] = 
                                                {
                                                    [1] = 
                                                    {
                                                        ["number"] = 1,
                                                        ["auto"] = true,
                                                        ["id"] = "WrappedAction",
                                                        ["enabled"] = true,
                                                        ["params"] = 
                                                        {
                                                            ["action"] = 
                                                            {
                                                                ["id"] = "Option",
                                                                ["params"] = 
                                                                {
                                                                    ["value"] = 1,
                                                                    ["name"] = 1,
                                                                }, -- end of ["params"]
                                                            }, -- end of ["action"]
                                                        }, -- end of ["params"]
                                                    }, -- end of [1]
                                                }, -- end of ["tasks"]
                                            }, -- end of ["params"]
                                        }, -- end of ["task"]
                                        ["type"] = "Turning Point",
                                        ["ETA"] = 0,
                                        ["ETA_locked"] = true,
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["speed_locked"] = true,
                                        ["formation_template"] = "",
                                    }, -- end of [1]
                                }, -- end of ["points"]
                            }, -- end of ["route"]
                            ["groupId"] = owngroupID,
                            ["hidden"] = false,
                            ["units"] = 
                            {
                                [1] = 
                                {
                                    ["alt"] = 1524,
                                    ["alt_type"] = "BARO",
                                    ["livery_id"] = "ju-88a4",
                                    ["skill"] = "Excellent",
                                    ["speed"] = 113.05555555556,
                                    ["AddPropAircraft"] = 
                                    {
                                    }, -- end of ["AddPropAircraft"]
                                    ["type"] = "Ju-88A4",
                                    ["unitId"] = 1,
                                    ["psi"] = 0,
                                    ["onboard_num"] = "013",
                                    ["y"] = zeus.target.aircraftPos.z,
                                    ["x"] = zeus.target.aircraftPos.x,
                                    ["name"] = zeus.target.aircraftName,
                                    ["payload"] = 
                                    {
                                        ["pylons"] = 
                                        {
                                        }, -- end of ["pylons"]
                                        ["fuel"] = 2120,
                                        ["flare"] = 0,
                                        ["chaff"] = 0,
                                        ["gun"] = 100,
                                    }, -- end of ["payload"]
                                    ["heading"] = 0,
                                    ["callsign"] = 
                                    {
                                        [1] = 4,
                                        [2] = 1,
                                        ["name"] = "Colt11",
                                        [3] = 1,
                                    }, -- end of ["callsign"]
                                }, -- end of [1]
                            }, -- end of ["units"]
                            ["y"] = zeus.target.aircraftPos.z,
                            ["x"] = zeus.target.aircraftPos.x,
                            ["name"] = zeus.target.aircraftName,
                            ["communication"] = true,
                            ["start_time"] = 0,
                            ["frequency"] = 251, 
                        }

    local _f4Data =
                        {
                            ["modulation"] = 0,
                                ["tasks"] = 
                                {
                                }, -- end of ["tasks"]
                                ["radioSet"] = false,
                                ["task"] = "CAP",
                                ["uncontrolled"] = false,
                                ["route"] = 
                                {
                                    ["points"] = 
                                    {
                                        [1] = 
                                        {
                                            ["alt"] = 6096,
                                            ["action"] = "Turning Point",
                                            ["alt_type"] = "BARO",
                                            ["properties"] = 
                                            {
                                                ["addopt"] = 
                                                {
                                                }, -- end of ["addopt"]
                                            }, -- end of ["properties"]
                                            ["speed"] = 256.94444444444,
                                            ["task"] = 
                                            {
                                                ["id"] = "ComboTask",
                                                ["params"] = 
                                                {
                                                    ["tasks"] = 
                                                    {
                                                        [1] = 
                                                        {
                                                            ["enabled"] = true,
                                                            ["key"] = "CAP",
                                                            ["id"] = "EngageTargets",
                                                            ["number"] = 1,
                                                            ["auto"] = true,
                                                            ["params"] = 
                                                            {
                                                                ["targetTypes"] = 
                                                                {
                                                                    [1] = "Air",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                            }, -- end of ["params"]
                                                        }, -- end of [1]
                                                        [2] = 
                                                        {
                                                            ["enabled"] = true,
                                                            ["auto"] = false,
                                                            ["id"] = "EngageTargets",
                                                            ["number"] = 2,
                                                            ["params"] = 
                                                            {
                                                                ["targetTypes"] = 
                                                                {
                                                                    [1] = "Planes",
                                                                }, -- end of ["targetTypes"]
                                                                ["priority"] = 0,
                                                                ["value"] = "Planes;",
                                                                ["noTargetTypes"] = 
                                                                {
                                                                    [1] = "Helicopters",
                                                                    [2] = "UAVs",
                                                                    [3] = "Cruise missiles",
                                                                    [4] = "Antiship Missiles",
                                                                    [5] = "AA Missiles",
                                                                    [6] = "AG Missiles",
                                                                    [7] = "SA Missiles",
                                                                }, -- end of ["noTargetTypes"]
                                                                ["maxDistEnabled"] = false,
                                                                ["maxDist"] = 15000,
                                                            }, -- end of ["params"]
                                                        }, -- end of [2]
                                                    }, -- end of ["tasks"]
                                                }, -- end of ["params"]
                                            }, -- end of ["task"]
                                            ["type"] = "Turning Point",
                                            ["ETA"] = 0,
                                            ["ETA_locked"] = true,
                                            ["y"] = zeus.target.aircraftPos.z,
                                            ["x"] = zeus.target.aircraftPos.x,
                                            ["speed_locked"] = true,
                                            ["formation_template"] = "",
                                        }, -- end of [1]
                                    }, -- end of ["points"]
                                }, -- end of ["route"]
                                ["groupId"] =owngroupID,
                                ["hidden"] = false,
                                ["units"] = 
                                {
                                    [1] = 
                                    {
                                        ["alt"] = 6096,
                                        ["hardpoint_racks"] = true,
                                        ["alt_type"] = "BARO",
                                        ["livery_id"] = "iriaf-3-6643",
                                        ["skill"] = "Excellent",
                                        ["speed"] = 256.94444444444,
                                        ["AddPropAircraft"] = 
                                        {
                                        }, -- end of ["AddPropAircraft"]
                                        ["type"] = "F-4E-45MC",
                                        ["unitId"] = 2,
                                        ["psi"] = 0,
                                        ["onboard_num"] = "010",
                                        ["y"] = zeus.target.aircraftPos.z,
                                        ["x"] = zeus.target.aircraftPos.x,
                                        ["name"] = zeus.target.aircraftName,
                                        ["payload"] = 
                                        {
                                            ["pylons"] = 
                                            {
                                                [1] = 
                                                {
                                                    ["CLSID"] = "{F4_SARGENT_TANK_370_GAL}",
                                                }, -- end of [1]
                                                [2] = 
                                                {
                                                    ["CLSID"] = "{AIM-9J}",
                                                }, -- end of [2]
                                                [4] = 
                                                {
                                                    ["CLSID"] = "{AIM-9J}",
                                                }, -- end of [4]
                                                [5] = 
                                                {
                                                    ["CLSID"] = "{HB_F4E_AIM-7E}",
                                                }, -- end of [5]
                                                [6] = 
                                                {
                                                    ["CLSID"] = "{HB_ALQ-131_ON_ADAPTER_IN_AERO7}",
                                                }, -- end of [6]
                                                [8] = 
                                                {
                                                    ["CLSID"] = "{HB_F4E_AIM-7E}",
                                                }, -- end of [8]
                                                [9] = 
                                                {
                                                    ["CLSID"] = "{HB_F4E_AIM-7E}",
                                                }, -- end of [9]
                                                [10] = 
                                                {
                                                    ["CLSID"] = "{AIM-9J}",
                                                }, -- end of [10]
                                                [12] = 
                                                {
                                                    ["CLSID"] = "{AIM-9J}",
                                                }, -- end of [12]
                                                [13] = 
                                                {
                                                    ["CLSID"] = "{F4_SARGENT_TANK_370_GAL_R}",
                                                }, -- end of [13]
                                                [14] = 
                                                {
                                                    ["CLSID"] = "{HB_ALE_40_30_60}",
                                                }, -- end of [14]
                                            }, -- end of ["pylons"]
                                            ["fuel"] = 5510.5,
                                            ["flare"] = 30,
                                            ["ammo_type"] = 1,
                                            ["chaff"] = 120,
                                            ["gun"] = 100,
                                        }, -- end of ["payload"]
                                        ["heading"] = 0,
                                        ["callsign"] = 
                                        {
                                            [1] = 1,
                                            [2] = 1,
                                            ["name"] = zeus.target.aircraftName,
                                            [3] = 1,
                                        }, -- end of ["callsign"]
                                    }, -- end of [1]
                                }, -- end of ["units"]
                                ["y"] = zeus.target.aircraftPos.z,
                                ["x"] = zeus.target.aircraftPos.x,
                                ["name"] = zeus.target.aircraftName,
                                ["communication"] = true,
                                ["start_time"] = 0,
                                ["frequency"] = 305,
                        }

    if model == "jtac" then
        data = _droneData
    elseif model == "mig29" then
        data = _mig29sData
    elseif model == "f5" then
        data = _f5Data
    elseif model == "mig28" then
        data = _f5Data
    elseif model == "mig21" then
        data = _mig21Data
    elseif model == "mig23" then
        data = _mig23Data
    elseif model == "m2k" then
        data = _m2kData
    elseif model == "f14" then
        data = _f14Data
    elseif model == "f15" then
        data = _f15Data
    elseif model == "f16" then
        data = _f16Data
    elseif model == "f18" then
        data = _f18Data
    elseif model == "j11" then
        data = _j11Data
    elseif model == "f1" then
        data = _f1Data
    elseif model == "texaco" then
        data = _texacoData
    elseif model == "arco" then
        data = _arcoData
    elseif model == "p51" then
        data = _p51Data
    elseif model == "spit" then
        data = _spitData
    elseif model == "mossie" then
        data = _mossieData
    elseif model == "bf109" then
        data = _bf109Data
    elseif model == "fw190a8" then
        data = _fw190a8Data
    elseif model == "fw190d9" then
        data = _fw190d9Data
    elseif model == "ju88" then
        data = _ju88Data
    elseif model == "f4" then
        data = _f4Data
    end
	coalition.addGroup(_country, Group.Category.AIRPLANE, data)

end;

world.addEventHandler(evento);
trigger.action.outText("zeus NoEZ AA - Script LOADED!", 10)
env.info("zeus NoEZ AA - Script LOADED!", 10)