--
-- file prepared:  2025 01:10:14.583, using fd665a
--
--Ammunition M39
local m39_smoke_scale   = 1.0;
local m39_smoke_opacity = 0.3;


----------------------------------------------------------------------------------------------------------------------

--
-- hispano_mkV round 1 (20.0)
--
declare_weapon({category = CAT_SHELLS,name =   "M39_20_HEI",
  user_name		= _("M39_20_HEI_A"),
  model_name     = "tracer_bullet_yellow",
  v0    		 = 990.0,
  Dv0   		 = 0.0060,
  Da0     		 = 0.0022,
  Da1     		 = 0.0,
  mass      	 = 0.100,
  round_mass 	 = 0.260+0.058,		-- round + link
  cartridge_mass = 0.058,			-- links are collected
  explosive      = 0.110,
  life_time      = 31.0,
  caliber        = 20.0,
  s              = 0.0,
  j              = 0.0,
  l              = 0.0,
  charTime       = 0,
  cx       		 = {0.5,1.27,0.70,0.200,2.30},
  k1       		 = 2.0e-08,
  tracer_on      = 0.01,
  tracer_off     = -100,
  scale_tracer   = 0,
  scale_smoke    = m39_smoke_scale, 
  smoke_opacity  = m39_smoke_opacity,
  cartridge		 = 0,

})


--
-- hispano_mkV round 2 (20.0)
--
declare_weapon({category = CAT_SHELLS,name =   "M39_20_HEI_T",
  user_name		= _("M39_20_HEI_TA"),
  model_name     = "tracer_bullet_yellow",
  v0    		 = 990.0,
  Dv0   		 = 0.0060,
  Da0     		 = 0.0022,
  Da1     		 = 0.0,
  mass      	 = 0.100,
  round_mass 	 = 0.260+0.058,		-- round + link
  cartridge_mass = 0.058,			-- links are collected
  explosive      = 0.110,
  life_time      = 31.0,
  caliber        = 20.0,
  s              = 0.0,
  j              = 0.0,
  l              = 0.0,
  charTime       = 0,
  cx       		 = {0.5,1.27,0.70,0.200,2.30},
  k1       		 = 2.0e-08,
  tracer_on      = 0.07,
  tracer_off     = 3,
  scale_tracer   = 1,
  scale_smoke    = m39_smoke_scale, 
  smoke_opacity  = m39_smoke_opacity,
  cartridge		 = 0,

})

--
-- hispano_mkV round 3 (20.0)
--
declare_weapon({category = CAT_SHELLS, name =   "M39_20_API",
  user_name		= _("M39_20_API"),
  model_name     = "tracer_bullet_yellow",
  v0    		 = 990.0,
  Dv0   		 = 0.0060,
  Da0     		 = 0.0022,
  Da1     		 = 0.0,
  mass      	 = 0.100,
  round_mass 	 = 0.260+0.058,		-- round + link
  cartridge_mass = 0.058,			-- links are collected
  explosive      = 0.000,
  AP_cap_caliber = 20.0,
  life_time      = 31.0,
  caliber        = 20.0,
  s              = 0.0,
  j              = 0.0,
  l              = 0.0,
  charTime       = 0,
  cx       		 = {0.5,1.27,0.70,0.200,2.30},
  k1       		 = 2.0e-08,
  tracer_on      = 0.01,
  tracer_off     = -100,
  scale_tracer   = 0,
  scale_smoke    = m39_smoke_scale, 
  smoke_opacity  = m39_smoke_opacity,
  cartridge		 = 0,

})

--
-- hispano_mkV cannon
--
function hispano_mkV(tbl)

	tbl.category = CAT_GUN_MOUNT 
	tbl.name 	 = "hispano_mkV"
	tbl.supply 	 =
	{
		shells = {"M39_20_HEI","M39_20_HEI_T","M39_20_API"},

		mixes  = {{1,1,3,1,2}},
		count  = 1000,		--250,
	}
	if tbl.mixes then 
	   tbl.supply.mixes =  tbl.mixes
	   tbl.mixes	    = nil
	end
	tbl.gun = 
	{
		max_burst_length = 25,
		rates 			 = {520},		--Type 99	
		recoil_coeff 	 = 0.2*1.3,
		barrels_count 	 = 1,
	}
	if tbl.rates then 
	   tbl.gun.rates    =  tbl.rates
	   tbl.rates	    = nil
	end	
	tbl.ejector_pos 			= tbl.ejector_pos or {-0.4, -1.2, 0.18}
	tbl.ejector_dir 			= {0,-1,0}
	tbl.supply_position  		= tbl.supply_position   or {0,  0.3, -0.3}
	tbl.aft_gun_mount 			= false
	tbl.effective_fire_distance = 1500
	tbl.drop_cartridge 			= 0
	tbl.muzzle_pos				= tbl.muzzle_pos 		 or  {0,0,0} -- all position from connector
	tbl.muzzle_pos_connector	= tbl.muzzle_pos_connector 		 or  "Gun_point" -- all position from connector
	tbl.azimuth_initial 		= tbl.azimuth_initial    or 0   
	tbl.elevation_initial 		= tbl.elevation_initial  or 0   
	if  tbl.effects == nil then
		tbl.effects = {{ name = "FireEffect"     , arg 		 = tbl.effect_arg_number or 436 },
					   { name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
					   { name = "SmokeEffect"}}
	end
	return declare_weapon(tbl)
end




--
--	note: the above is modelled after the example for the M_39 cannon as found in Scripts\Database\Weapons\aircraft_gun_mounts.lua, and
--  the example for the M39_20_HEI, M39_20_HEI_T, and M39_20_API rounds as found in Scripts\Database\Weapons\shell_table.lua
--



