-- for warhead functions and default warheads map (for warheads["AIM_65"])
-- DSplayer Edited 2025-03-21
dofile("Scripts/Database/Weapons/warheads.lua")

local AIM_23 = {
    category		= CAT_AIR_TO_AIR,
    name			= "AIM_23",
    user_name		= _("AIM-23 Hawk"),
    wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},

    shape_table_data =
    {
        {
            name	 = "AIM-23";
            file  = "hawk-r";
            life  = 1;
            fire  = { 0, 1};
            username = "AIM-23 Hawk";
            index = WSTYPE_PLACEHOLDER,
        },
    },
	
	
        Escort = 1,
        Head_Type = 6,
        sigma = {5, 5, 5},
        M = 638.0,
        H_max = 18000.0,
        H_min = 60.0,
        Diam = 356.0,
        Cx_pil = 4,
        D_max = 22000.0,
		D_min = 1500.0,
        Head_Form = 1,
        Life_Time = 110.0,
        Nr_max = 15.0,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 2.3,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 17.0,
        Range_max = 180000.0,
        H_min_t = 25,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["HAWK_RAKETA"],
        exhaust = {1, 1, 1, 1 }; -- smoke "a lot"
        exhaust_effect_type = 1,
        X_back = -2.68,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.1676,
		PN_gain = 4,
        KillDistance = 18,
        ccm_k0 = 0.35,
        hoj = 1,
        SeekerGen = 2,

     -- loft_factor = 2.15,
        supersonic_A_coef_skew = 0.1, -- slope of the straight line of the polar dump coefficient at supersonic
		nozzle_exit_area = 0.041, -- nozzle exit area
        PN_coeffs = {5,                 -- Number of Entries
                    1800.0 ,1.0,			-- Less 1.8 km to target Pn = 1
					4630 , 	0.6,			-- Between 2.5 and .97 Nm  to target, Pn smoothly changes from 1.2 to 1.0. Longer then 15 km Pn = 0.4.
					9260 ,	0.9,			-- Between 10 and 5 Nm  to target, Pn smoothly changes from 1.5 to 1.2. Longer then 15 km Pn = 0.4.	
					18520, 0.6,				-- Between 25 and 10 Nm  to target, Pn smoothly changes from .4 to 1.0. Longer then 15 km Pn = 0.4.
					25000, 0.4
                    };

        ModelData = {   58,  -- model params count
                        1.1,   -- characteristic square (характеристическая площадь)
                        
                        -- параметры зависимости Сx
                        0.041 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
                        0.082 , -- Cx_k1 высота пика волнового кризиса
                        0.01 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
                        -0.21, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
                        0.13 , -- Cx_k4 крутизна спада за волновым кризисом 
                        0.7 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
                        
                        -- параметры зависимости Cy
                        2.1 , -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
                        0.9	, -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
                        0.5 , -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
                        
                        0.23, -- 7 Alfa_max  максимальный балансировачный угол, радианы
                        0.0, --угловая скорость создаваймая моментом газовых рулей  

                    -- Engine data. Time, fuel flow, thrust.
                    --  t_start     t_b     t_accel     t_march     t_inertial      t_break     t_end           -- Stage
                        0.0,       0.0,     5.0,       17,        0.0,            0.0,        1.0e9,         -- time of stage, sec
                        0.0,       0.0,    37.07,       6.44,        0.0,            0.0,        0.0,           -- fuel flow rate in second, kg/sec(ÑÐµÐºÑÐ½Ð´Ð½ÑÐ¹ ÑÐ°ÑÑÐ¾Ð´ Ð¼Ð°ÑÑÑ ÑÐ¾Ð¿Ð»Ð¸Ð²Ð° ÐºÐ³/ÑÐµÐº)
                        0.0,       0.0,    80000.0,    13700.0,        0.0,            0.0,        0.0,           -- thrust, newtons

                        1.0e9, -- таймер самоликвидации, сек
                        110.0, -- время работы энергосистемы, сек
                        0, -- абсолютная высота самоликвидации, м
                        3.5, -- время задержки включения управления (маневр отлета, безопасности), сек
                        1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
                        1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
                        0.0,  -- синус угла возвышения траектории набора горки
                        50.0, -- продольное ускорения взведения взрывателя
                        0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
                        5.9, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
                        2.2, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
                        1.0, -- характеристика системы САУ-РАКЕТА,  полоса пропускания контура управления

                        -- DLZ data. Use numbers below for your implemetation. --From Denis Alekseev
                        -- ЗРП. Данные для рассчета дальностей пуска (индикация на прицеле)
                        24.6, -- производная дальности по скорости носителя на высоте 1км, ППС
                        -32.2, -- производная дальности по скорости цели на высоте 1км, ЗПС
                        -3.2, -- производная по высоте производной дальности по скорости цели, ЗПС
                        37000.0, -- дальность ракурс 180 град(навстречу), Н=5000м, V=900км/ч, м
                        16000.0, -- дальность ракурс 180(в догон) град, Н=5000м, V=900км/ч, м
                        45000.0, -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м
                        21000.0, -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
                        32000.0, -- дальность ракурс 180 град, Н=1000м, V=900км/ч, м
                        11000.0, -- дальность ракурс 180(в догон) град, Н=1000м, V=900км/ч, м
                        2500.0, -- Вертикальная плоскость. Наклон кривой разрешенной дальности пуска в нижнюю полусферу. Уменьшение дальности при стрельбе вниз.
                        0.55, -- Вертикальная плоскость. Наклон кривой разрешенной дальности пуска в верхнюю полусферу. Увеличение дальности при стрельбе вверх.
                        -0.01, -- Вертикальная плоскость. Угол перегиба кривой разрешенной дальности, верхняя - нижняя полусфера.
                        0.5, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя

                    },
}
declare_weapon(AIM_23)

declare_loadout(
	{	-- AIM-23
		category		=	CAT_AIR_TO_AIR,
		CLSID			= 	"{AIM_23}",
		Picture			=	"aim54.png",
		--wsTypeOfWeapon	=	AIM_23.wsTypeOfWeapon,
		displayName		=	AIM_23.user_name,
		--attribute		=	{wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
		attribute		=	AIM_23.wsTypeOfWeapon,
		Cx_pil			=	AIM_23.Cx_pil / 4096.0,
		Count			=	1,
		Weight			=	AIM_23.M,
		Elements	=
		{
			--{	ShapeName	=	"HB_F14_EXT_PHX_ALU"  ,	IsAdapter  	   =   true  },
			
			{
				DrawArgs	=
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
			--	Position	=	{-5, -5, -5}, --DOESNT WORK -DSPLAYER
				--connector_name = "WEP_Phoenix_FrontPallette_L_ALU",
				ShapeName	=	"AIM_23",
			},
		}, -- end of Elements
	}
)

local function shoulder_aim_23(clsid, element, elem_CLSID, side)  -- side L or R AYO THIS FINALLY WORKS CORRECTLY -DSPLAYER
	local ret = {
		category			=	CAT_AIR_TO_AIR,
		CLSID				=	clsid,
		Picture				=	"aim54.png",
		wsTypeOfWeapon		=	element.wsTypeOfWeapon,
		attribute			=	{4,	4,	32,	WSTYPE_PLACEHOLDER},
		Cx_pil				=	1.25 * (element.Cx_pil/4096.0),
								-- per F-14 perf manual:
								-- shoulder AIM54 drag index = 12
								-- AIM54 shoulder adapter index = 3
								-- total drag index = 15, add 25% more drag to shoulder AIM54
		Count				=	1,
		Weight				=	element.M + 45.36,  --100lbs for LAU-93
		JettisonSubmunitionOnly = true,
		Elements			=
		{
			[1]	=
			{
			--	Rotation	=	{-2, -1, 0},
			--	Position	=	{0,	0,	0},
				ShapeName	=	"HB_F14_EXT_SHOULDER_PHX_"..side , IsAdapter = true,
			},
			[2]	=
			{	
				Rotation	=	{0, 0, 0}, --DO NOT CHANGE OR ELSE MISSILE WILL LAUNCH IN A WEIRD DIRECTION
				Position	=	{-0.12, -0.335, 0},
				ShapeName	=	"element",
			},	
		--	{	payload_CLSID = elem_CLSID , connector_name = "WEP_Phoenix_Connector"}
		}-- end of Elements
	}
    ret.displayName = element.user_name
	declare_loadout(ret)
end

shoulder_aim_23("{SHOULDER AIM_23 L}", AIM_23, "{AIM_23}", "L")
shoulder_aim_23("{SHOULDER AIM_23 R}", AIM_23, "{AIM_23}", "R")
