--
-- file prepared:  2025 18:30:29.847, using fd653a
--
self_ID = "folland_gnat"
declare_plugin(self_ID,
{
	displayName = _("folland_gnat"),
	developerName = _("Half Science, the 'clay pigeon' series"),  --see artistic credits in the readme.txt

	image = "FC.bmp",
	installed = true,
	dirName = current_mod_path,
	fileMenuName = _("folland_gnat"),

	version = " ",
	state = "installed",
	info = _("The Folland Gnat is a British compact swept-wing subsonic fighter aircraft that was developed and produced by Folland Aircraft. Envisioned as an affordable light fighter in contrast to the rising cost and size of typical combat aircraft, it was procured as a trainer aircraft for the Royal Air Force (RAF) as well as by export customers, who used the Gnat in both combat and training capacities.  Although never used as a fighter by the Royal Air Force (RAF), the Gnat T.1 jet trainer variant was adopted and operated for some time. In the United Kingdom, the Gnat became well known due to its prominent use as the display aircraft of the RAF's Red Arrows aerobatic team. The Gnat F.1 was exported to Finland, Yugoslavia and India. The Indian Air Force became the largest operator and eventually manufactured the aircraft under licence. Impressed by its performance during combat, India proceeded to develop the improved HAL Ajeet, a modified variant of the Gnat. In British service, the Gnat was replaced by the Hawker Siddeley Hawk. (source: https://en.wikipedia.org/wiki/Folland_Gnat) "),

	update_id = "folland_gnat",

	Skins =
	{
		{
			name = _("folland_gnat"),
			dir = "Theme"
		},
	},
	Missions =
	{
		{
			name = _("folland_gnat"),
			dir = "Missions",
		},
	},
	LogBook =
	{
		{
			name = _("folland_gnat"),
			type = "folland_gnat",
		},
	},
	InputProfiles =
	{
		["folland_gnat"] = current_mod_path .. '/Input/folland_gnat',
	},
})
----------------------------------------------------------------------------------------
mount_vfs_texture_path(current_mod_path.."/Textures")
mount_vfs_model_path(current_mod_path.."/Shapes")
dofile(current_mod_path.."/Views.lua")
dofile(current_mod_path.."/weapons.lua")
make_view_settings('folland_gnat', ViewSettings, SnapViews)
make_flyable('folland_gnat', current_mod_path..'/Cockpit/Scripts/', { nil, old = 54 }, current_mod_path..'/comm.lua')
dofile(current_mod_path..'/folland_gnat.lua')
------------------------------------------------------------------------------------ -
plugin_done()

