local spear3_warhead =
{
    caliber              = 180,
    mass                 = 10.0, 
    expl_mass            = 10.0,
    piercing_mass        = 2,	
    concrete_factors     = { 1, 1, 1 },
    concrete_obj_factor  = 0.0,	
    cumulative_factor    = 0.0,	
    obj_factors          = { 1, 1 },	
    other_factors        = { 1, 1, 1 },
    cumulative_thickness = 1.0, 
}

local spear3_ARM  = 'SPEAR-3 Anti-Radiation Gliding Missile'
local spear3_LSR  = 'SPEAR-3 Laser Gliding Missile'
local spear3_GPS  = 'SPEAR-3 GPS Gliding Missile'
local spear3_shape_name = "jas39_spear-3"
local spear3_mass  = 99

SPEAR3_MISSILE_RACK_4 =
{
	category        = CAT_MISSILES,
    name            = spear3_ARM,
    user_name       = _(spear3_ARM),
    model           = spear3_shape_name,
    mass            = spear3_mass,
	scheme			= "sat_cruise_missile",   
	class_name		= "wAmmunitionCruise",     
	wsTypeOfWeapon  = {wsType_Weapon, wsType_Missile, wsType_AS_Missile, WSTYPE_PLACEHOLDER},
	
	Escort = 0,
    Head_Type = 3,
	sigma = {1, 1, 1},
    M = spear3_mass,
    H_max = 15000.0,
    H_min = -1,
    Diam = 180.0,
	Cx_pil = 6.0,
	D_max = 120000.0,
    D_min = 500.0,
    Head_Form = 0,
	Life_Time = 430,
    Nr_max = 25,
    v_min = 50.0,
    v_mid = 320.0,
	Mach_max = 0.95,
    t_b = 2.0,
    t_acc = 0.0,
	t_marsh = 300.0,
	Range_max = 140000.0,
    H_min_t = 0.0,
    Fi_start = 0.5,
    Fi_rak = 3.14152,
    Fi_excort = 1.05,
    Fi_search = 99.9,
    OmViz_max = 99.9,
	exhaust	= {0.1, 0.1, 0.1, 0.1},
	X_back	= 0.0,
	Y_back	= 0.0,
	Z_back 	= 0.0,
	Reflection	= 0.0254,
	KillDistance= 0.0,
	Engine_Type = 3,
	add_attributes = {"Cruise missiles"},	
	manualWeaponFlag = 1,
		
	shape_table_data =
	{
		{
			name     = spear3_ARM,
			file     = spear3_shape_name,
			life     = 1,
			fire     = {0, 1},
			username = "SPEAR3_ARM",
			index    = WSTYPE_PLACEHOLDER,
		},
	},

	controller =
	{
		boost_start	= 0.00,
		march_start = 2.00,
	},

	booster_animation =
	{
		start_val = 0,
	},
	
	play_booster_animation =
	{
		val = 0,
	},

    fm =
	{
        mass                	= 99,
        caliber             	= 0.180,
        cx_coeff 				= {1, 0.8, 0.8, 0.15, 1.5},
		L 						= 1.8,
		I 						=  1 / 12 * 99 * 1.8 * 1.8,		       
        wind_sigma          	= 0.0,
        wind_time           	= 0.0,
		Sw                  	= 0.6,
        dCydA               	= {0.07, 0.036},
        A                   	= 0.1,
		maxAoa              	= 0.3,
        finsTau             	= 1.2,      
        addDeplSw           	= 1.0,
        wingsDeplDelay      	= 1,
        no_wings_cx_coeff   	= {1, 0.4, 0.8, 0.10, 1.5},		
		Ma 						= 3,						--X-65			
		Ma_x 					= 1.2,     					--X-65
		Ma_z 					= 3,       					--X-65
		Mw 						= 10,        				--X-65
		Mw_x 					= 2.7,     					--X-65
    },
	
	cruise_autopilot =
	{
		delay							= 2,
		auto_terrain_following			= 0,
		auto_terrain_following_height	= 0,		
		Kp_hor_err						= 240,
		Kp_hor_err_croll				= 0.06,
		Kd_hor							= 0,
		Kp_ver							= 9,
		Kii_ver							= 0.2,
		Kd_ver							= 0,
		Kp_eng							= 200,
		Ki_eng							= 0.003,
		Kd_eng							= 0,
		Kp_ver_st1						= 0.009,
		Kd_ver_st1						= 0.015,
		Kp_ver_st2						= 0.00018,
		Kd_ver_st2						= 0.00005,
		alg_points_num					= 7,
		alg_calc_time					= 1.5,
		alg_vel_k						= 6,
		alg_div_k						= 2,
		alg_max_sin_climb				= 0.8,
		alg_section_temp_points			= 3,
		alg_tmp_point_vel_k				= 1.5,
		no_alg_vel_k					= 10,
		max_roll						= 0.8,
		max_start_y_vel					= 35,
		stab_vel						= 160,
		finsLimit						= 0.8,
		estimated_N_max					= 6,
		eng_min_thrust					= -100,
		eng_max_thrust					= 1900,
	},
			
	final_autopilot =
	{
		delay 				= 0,
		K					= 60,
		Ki					= 0,
		Kg					= 4,
		finsLimit			= 0.8,
		useJumpByDefault	= 1,
		J_Power_K			= 1.5,
		J_Diff_K			= 0.4,
		J_Int_K				= 0,
		J_Angle_K			= 0.18,
		J_FinAngle_K		= 0.32,
		J_Angle_W			= 0.8,
		J_Trigger_Vert		= 1,
		hKp_err				= 120,
		hKp_err_croll		= 0.04,
		hKd					= 0.005,
		max_roll			= 0.8,
	},
	
	control_block =
	{
		default_cruise_height		= 9999,		
		seeker_activation_dist		= 40000.0,
		can_update_target_pos		= 1,		
		obj_sensor					= 0,
		use_horiz_dist				= 1,		
		turn_before_point_reach		= 1,
		turn_hor_N					= 0.8,
		turn_point_trigger_dist		= 100,		
		turn_max_calc_angle_deg		= 90,
	},	
	
	boost =
	{
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,						
	},
	
	march =
	{
		fuel_mass 								= 50,
		impulse  								= 500,
		max_thrust  							= 1900,
		min_fuel_rate 							= 0.0025,
		min_thrust  							= -100,
		thrust_Tau  							= 0.0017,
		work_time 								= 300,
		nozzle_position	 						= {{-0.9, -0.15, 0}},
		nozzle_orientationXYZ  					= {{0.0, 0.0, 0.0}},
		tail_width 								= 0.1,
		start_burn_effect 						= 0.0,		
		custom_smoke_dissipation_factor 		= 0.1,			        	--X-65
		smoke_color  							= {0.1, 0.1, 0.1},     		--X-65
		smoke_transparency  					= 0.03,		          		--X-65
		start_effect_delay  					= { 0.0, 0.3, 0.8 },        --X-65
		start_effect_size  						= { 0.09, 0.104, 0.11 },    --X-65
		start_effect_smoke  					= { 0.01, 0.4, 0.01 },      --X-65
		start_effect_time  						= { 0.7, 1, 0.1 },          --X-65
		start_effect_x_dist  					= { 1.1, 0.9, 0 },          --X-65
		start_effect_x_pow  					= { 1, 1, 1 },              --X-65
		start_effect_x_shift  					= { 0.15, 0.15, 0.2 },		--X-65	
	},
	
	seeker =
	{
		coalition					= 2,
		coalition_rnd_coeff			= 5.0,
		can_update_target_pos		= 1,
	},	
		
	warhead = spear3_warhead,
	warhead_air = spear3_warhead,	
	
}

declare_weapon(SPEAR3_MISSILE_RACK_4)


declare_loadout({
    category        = CAT_MISSILES,
    CLSID           = "{SPEAR-3_RACK*4}",
    wsTypeOfWeapon  = SPEAR3_MISSILE_RACK_4.wsTypeOfWeapon,
    attribute       = {4, 4, 32, WSTYPE_PLACEHOLDER},
    Count           = 4,
    Cx_pil          = 0.0045,
    Picture         = "spear-3_rack_4.png",
    displayName     = _('4 x ' .. spear3_ARM),
    Weight          = spear3_mass * 4 + 145.15,
	ejectImpulse    = 150,	
	Elements = {
	
		{
			ShapeName	=	"jas39_bru_61",
			IsAdapter = true,
		},
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},	
			Position	=	{-0.802,	-0.237, -0.125},
			ShapeName	=	spear3_shape_name,
		},			
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},	
			Position	=	{-0.802,	-0.237, 0.125},
			ShapeName	=	spear3_shape_name,
		},		

		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},
			Position	=	{1.02,	-0.237,	-0.125},
			ShapeName	=	spear3_shape_name,
		},
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},
			Position	=	{1.02,	-0.237,	0.125},
			ShapeName	=	spear3_shape_name,
		},		
	},
    
    JettisonSubmunitionOnly = false,
})

declare_loadout({
    category        = CAT_MISSILES,
    CLSID           = "{SPEAR-3_RACK*4_BAY}",
    wsTypeOfWeapon  = SPEAR3_MISSILE_RACK_4.wsTypeOfWeapon,
    attribute       = {4, 4, 32, WSTYPE_PLACEHOLDER},
    Count           = 4,
    Cx_pil          = 0.0,
    Picture         = "spear-3_rack_4.png",
    displayName     = _('4 x ' .. spear3_ARM),
    Weight          = spear3_mass * 4 + 145.15,
	ejectImpulse    = 150,	
	Elements = {
	
		{
			ShapeName	=	"jas39_bru_61",
			IsAdapter = true,
		},
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},	
			Position	=	{-0.802,	-0.237, -0.125},
			ShapeName	=	spear3_shape_name,
		},			
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},	
			Position	=	{-0.802,	-0.237, 0.125},
			ShapeName	=	spear3_shape_name,
		},		

		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},
			Position	=	{1.02,	-0.237,	-0.125},
			ShapeName	=	spear3_shape_name,
		},
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},
			Position	=	{1.02,	-0.237,	0.125},
			ShapeName	=	spear3_shape_name,
		},		
	},
    
    JettisonSubmunitionOnly = false,
})

SPEAR3_MISSILE_RACK_4_LSR =
{
	category        = CAT_MISSILES,
    name            = spear3_LSR,
    user_name       = _(spear3_LSR),
    model           = spear3_shape_name,
    mass            = spear3_mass,
	scheme			= "sat_cruise_missile",   
	class_name		= "wAmmunitionCruise",     
	wsTypeOfWeapon  = {wsType_Weapon, wsType_Missile, wsType_AS_Missile, WSTYPE_PLACEHOLDER},
	
	Escort = 0,
	Head_Type = 4,
	sigma = {1, 1, 1},
    M = spear3_mass,
    H_max = 15000.0,
    H_min = -1,
    Diam = 180.0,
	Cx_pil = 6.0,
	D_max = 120000.0,
    D_min = 500.0,
    Head_Form = 0,
	Life_Time = 430,
    Nr_max = 25,
    v_min = 50.0,
    v_mid = 320.0,
	Mach_max = 0.95,
    t_b = 2.0,
    t_acc = 0.0,
	t_marsh = 300.0,
	Range_max = 140000.0,
    H_min_t = 0.0,
    Fi_start = 0.5,
    Fi_rak = 3.14152,
    Fi_excort = 1.05,
    Fi_search = 99.9,
    OmViz_max = 99.9,
	exhaust	= {0.1, 0.1, 0.1, 0.1},
	X_back	= 0.0,
	Y_back	= 0.0,
	Z_back 	= 0.0,
	Reflection	= 0.0254,
	KillDistance= 0.0,
	Engine_Type = 3,
	add_attributes = {"Cruise missiles"},	
	manualWeaponFlag = 1,
		
		shape_table_data =
	{
		{
			name     = spear3_LSR,
			file     = spear3_shape_name,
			life     = 1,
			fire     = {0, 1},
			username = "SPEAR3_LSR",
			index    = WSTYPE_PLACEHOLDER,
		},
	},

	controller =
	{
		boost_start	= 0.00,
		march_start = 2.00,
	},

	booster_animation =
	{
		start_val = 0,
	},
	
	play_booster_animation =
	{
		val = 0,
	},

    fm =
	{
        mass                	= 99,
        caliber             	= 0.180,
        cx_coeff 				= {1, 0.8, 0.8, 0.15, 1.5},
		L 						= 1.8,
		I 						=  1 / 12 * 99 * 1.8 * 1.8,		       
        wind_sigma          	= 0.0,
        wind_time           	= 0.0,
		Sw                  	= 0.6,
        dCydA               	= {0.07, 0.036},
        A                   	= 0.1,
		maxAoa              	= 0.3,
        finsTau             	= 1.2,      
        addDeplSw           	= 1.0,
        wingsDeplDelay      	= 1,
        no_wings_cx_coeff   	= {1, 0.4, 0.8, 0.10, 1.5},		
		Ma 						= 3,						--X-65			
		Ma_x 					= 1.2,     					--X-65
		Ma_z 					= 3,       					--X-65
		Mw 						= 10,        				--X-65
		Mw_x 					= 2.7,     					--X-65
    },
	
	cruise_autopilot =
	{
		delay							= 2,
		auto_terrain_following			= 0,
		auto_terrain_following_height	= 0,		
		Kp_hor_err						= 240,
		Kp_hor_err_croll				= 0.06,
		Kd_hor							= 0,
		Kp_ver							= 9,
		Kii_ver							= 0.2,
		Kd_ver							= 0,
		Kp_eng							= 200,
		Ki_eng							= 0.003,
		Kd_eng							= 0,
		Kp_ver_st1						= 0.009,
		Kd_ver_st1						= 0.015,
		Kp_ver_st2						= 0.00018,
		Kd_ver_st2						= 0.00005,
		alg_points_num					= 7,
		alg_calc_time					= 1.5,
		alg_vel_k						= 6,
		alg_div_k						= 2,
		alg_max_sin_climb				= 0.8,
		alg_section_temp_points			= 3,
		alg_tmp_point_vel_k				= 1.5,
		no_alg_vel_k					= 10,
		max_roll						= 0.8,
		max_start_y_vel					= 35,
		stab_vel						= 160,
		finsLimit						= 0.8,
		estimated_N_max					= 6,
		eng_min_thrust					= -100,
		eng_max_thrust					= 1900,
	},
			
	final_autopilot =
	{
		delay 				= 0,
		K					= 60,
		Ki					= 0,
		Kg					= 4,
		finsLimit			= 0.8,
		useJumpByDefault	= 1,
		J_Power_K			= 1.5,
		J_Diff_K			= 0.4,
		J_Int_K				= 0,
		J_Angle_K			= 0.18,
		J_FinAngle_K		= 0.32,
		J_Angle_W			= 0.8,
		J_Trigger_Vert		= 1,
		hKp_err				= 120,
		hKp_err_croll		= 0.04,
		hKd					= 0.005,
		max_roll			= 0.8,
	},
	
	control_block =
	{
		default_cruise_height		= 9999,		
		seeker_activation_dist		= 40000.0,
		can_update_target_pos		= 1,		
		obj_sensor					= 0,
		use_horiz_dist				= 1,		
		turn_before_point_reach		= 1,
		turn_hor_N					= 0.8,
		turn_point_trigger_dist		= 100,		
		turn_max_calc_angle_deg		= 90,
	},	
	
	boost =
	{
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,						
	},
	
	march =
	{
		fuel_mass 								= 50,
		impulse  								= 500,
		max_thrust  							= 1900,
		min_fuel_rate 							= 0.0025,
		min_thrust  							= -100,
		thrust_Tau  							= 0.0017,
		work_time 								= 300,
		nozzle_position	 						= {{-0.9, -0.15, 0}},
		nozzle_orientationXYZ  					= {{0.0, 0.0, 0.0}},
		tail_width 								= 0.1,
		start_burn_effect 						= 0.0,		
		custom_smoke_dissipation_factor 		= 0.1,			        	--X-65
		smoke_color  							= {0.1, 0.1, 0.1},     		--X-65
		smoke_transparency  					= 0.03,		          		--X-65
		start_effect_delay  					= { 0.0, 0.3, 0.8 },        --X-65
		start_effect_size  						= { 0.09, 0.104, 0.11 },    --X-65
		start_effect_smoke  					= { 0.01, 0.4, 0.01 },      --X-65
		start_effect_time  						= { 0.7, 1, 0.1 },          --X-65
		start_effect_x_dist  					= { 1.1, 0.9, 0 },          --X-65
		start_effect_x_pow  					= { 1, 1, 1 },              --X-65
		start_effect_x_shift  					= { 0.15, 0.15, 0.2 },		--X-65	
	},
	
	seeker =
	{
		coalition					= 2,
		coalition_rnd_coeff			= 5.0,
		can_update_target_pos		= 1,
	},	
	
	laser_spot_seeker = {
		FOV							= math.rad(32),
		max_seeker_range			= 140000.0,     
	},	
		
	warhead = spear3_warhead,
	warhead_air = spear3_warhead,
	
}

declare_weapon(SPEAR3_MISSILE_RACK_4_LSR)


declare_loadout({
    category        = CAT_MISSILES,
    CLSID           = "{SPEAR-3_RACK*4_LSR}",
    wsTypeOfWeapon  = SPEAR3_MISSILE_RACK_4_LSR.wsTypeOfWeapon,
    attribute       = {4, 4, 32, WSTYPE_PLACEHOLDER},
    Count           = 4,
    Cx_pil          = 0.0045,
    Picture         = "spear-3_rack_4.png",
    displayName     = _('4 x ' .. spear3_LSR),
    Weight          = spear3_mass * 4 + 145.15,
	ejectImpulse    = 150,	
	Elements = {
	
		{
			ShapeName	=	"jas39_bru_61",
			IsAdapter = true,
		},
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},	
			Position	=	{-0.802,	-0.237, -0.125},
			ShapeName	=	spear3_shape_name,
		},			
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},	
			Position	=	{-0.802,	-0.237, 0.125},
			ShapeName	=	spear3_shape_name,
		},		

		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},
			Position	=	{1.02,	-0.237,	-0.125},
			ShapeName	=	spear3_shape_name,
		},
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},
			Position	=	{1.02,	-0.237,	0.125},
			ShapeName	=	spear3_shape_name,
		},		
	},
    
    JettisonSubmunitionOnly = false,
})

declare_loadout({
    category        = CAT_MISSILES,
    CLSID           = "{SPEAR-3_RACK*4_LSR_BAY}",
    wsTypeOfWeapon  = SPEAR3_MISSILE_RACK_4_LSR.wsTypeOfWeapon,
    attribute       = {4, 4, 32, WSTYPE_PLACEHOLDER},
    Count           = 4,
    Cx_pil          = 0.0,
    Picture         = "spear-3_rack_4.png",
    displayName     = _('4 x ' .. spear3_LSR),
    Weight          = spear3_mass * 4 + 145.15,
	ejectImpulse    = 150,	
	Elements = {
	
		{
			ShapeName	=	"jas39_bru_61",
			IsAdapter = true,
		},
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},	
			Position	=	{-0.802,	-0.237, -0.125},
			ShapeName	=	spear3_shape_name,
		},			
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},	
			Position	=	{-0.802,	-0.237, 0.125},
			ShapeName	=	spear3_shape_name,
		},		

		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},
			Position	=	{1.02,	-0.237,	-0.125},
			ShapeName	=	spear3_shape_name,
		},
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},
			Position	=	{1.02,	-0.237,	0.125},
			ShapeName	=	spear3_shape_name,
		},		
	},
    
    JettisonSubmunitionOnly = false,
})


SPEAR3_MISSILE_RACK_4_GPS =
{
	category        = CAT_MISSILES,
    name            = spear3_GPS,
    user_name       = _(spear3_GPS),
    model           = spear3_shape_name,
    mass            = spear3_mass,  
	wsTypeOfWeapon  = {wsType_Weapon, wsType_Missile, wsType_AS_Missile, WSTYPE_PLACEHOLDER},
	class_name		= "wAmmunitionSelfHoming", 
	
	Escort = 0,
	Head_Type = 4,
	sigma = {1, 1, 1},
    M = spear3_mass,
    H_max = 15000.0,
    H_min = -1,
    Diam = 180.0,
	Cx_pil = 6.0,
	D_max = 120000.0,
    D_min = 500.0,
    Head_Form = 0,
	Life_Time = 999,
    Nr_max = 25,
    v_min = 50.0,
	v_mid = 1050.0,
	Mach_max = 0.0,
    t_b = 2.0,
    t_acc = 230.0,
	t_marsh = 230.0,
	Range_max = 140000.0,
	H_min_t = 0.0,
    Fi_start = 0.5,
    Fi_rak = 3.14152,
    Fi_excort = 1.05,
    Fi_search = 99.9,
    OmViz_max = 99.9,
	X_back	= -0.9,
	Y_back	= -0.15,
	Z_back 	= 0.0,
	Reflection	= 0.0254,
	KillDistance= 0.0,		
	Engine_Type = 3,	
	add_attributes = {"Cruise missiles"},	
	manualWeaponFlag = 1,
		

		shape_table_data =
	{
		{
			name     = spear3_GPS,
			file     = spear3_shape_name,
			life     = 1,
			fire     = {0, 1},
			username = "SPEAR3_GPS",
			index    = WSTYPE_PLACEHOLDER,
		},
	},

	controller = 
	{
		boost_start	= 0.00,
		march_start = 2.00,
	},

    fm =
	{
        mass                = 99,
        caliber             = 0.180,
        cx_coeff            = {1, 0.8, 0.8, 0.15, 1.5},
		L = 1.8,
		I =  1 / 12 * 99 * 1.8 * 1.8,	       
        wind_sigma          = 0.0,
        wind_time           = 0.0,
		Sw                  = 0.6,
        dCydA               = {0.07, 0.036},
        A                   = 0.1,
		maxAoa              = 0.3,
        finsTau             = 1.2,
        addDeplSw           = 0.6,
        wingsDeplDelay      = 1,
        no_wings_cx_coeff   = {1, 0.4, 0.8, 0.10, 1.5},		
		Ma          = 3,	
		Mw          = 10,
		Ma_x		= 1.2,
		Ma_z		= 3,
		Mw_x		= 2.7,		
    },
	
	control_block =
	{
		default_cruise_height		= 9999,		
		seeker_activation_dist		= 40000.0,
		can_update_target_pos		= 1,		
		obj_sensor					= 0,
		use_horiz_dist				= 1,		
		turn_before_point_reach		= 1,
		turn_hor_N					= 0.8,
		turn_point_trigger_dist		= 100,		
		turn_max_calc_angle_deg		= 90,
	},
	
	final_autopilot =
	{
		delay 				= 0,
		K					= 60,
		Ki					= 0,
		Kg					= 4,
		finsLimit			= 0.8,
		useJumpByDefault	= 1,
		J_Power_K			= 1.5,
		J_Diff_K			= 0.4,
		J_Int_K				= 0,
		J_Angle_K			= 0.18,
		J_FinAngle_K		= 0.32,
		J_Angle_W			= 0.8,
		J_Trigger_Vert		= 1,
		hKp_err				= 120,
		hKp_err_croll		= 0.04,
		hKd					= 0.005,
		max_roll			= 0.8,
	},
		
	cruise_autopilot = 
	{
		delay							= 1,
		Kp_hor_err						= 240,
		Kp_hor_err_croll				= 0.06,
		Kd_hor							= 0,
		Kp_ver							= 9,
		Kii_ver							= 0.2,
		Kd_ver							= 0,
		Kp_eng							= 200,
		Ki_eng							= 0.003,
		Kd_eng							= 0,
		Kp_ver_st1						= 0.009,
		Kd_ver_st1						= 0.015,
		Kp_ver_st2						= 0.00018,
		Kd_ver_st2						= 0.00005,		
		auto_terrain_following			= 1,
		auto_terrain_following_height	= 5000,	
		alg_points_num					= 7,
		alg_calc_time					= 1.5,
		alg_vel_k						= 6,
		alg_div_k						= 2,
		alg_max_sin_climb				= 0.8,
		alg_section_temp_points			= 3,
		alg_tmp_point_vel_k				= 1.5,
		no_alg_vel_k					= 10,
		max_roll						= 0.8,
		max_start_y_vel					= 35,
		stab_vel						= 160,
		finsLimit						= 0.8,
		estimated_N_max					= 6,
		eng_min_thrust					= -100,
		eng_max_thrust					= 3000,
	},


	
	boost = 
	{
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,						
	},
	
	booster_animation = 
	{
		start_val = 0,
	},
	
	play_booster_animation = 
	{
		val = 0,
	},
	
	march = 
	{
		fuel_mass = 50,
		impulse = 500,
		max_thrust = 1900,
		min_fuel_rate = 0.0025,
		min_thrust = -100,
		thrust_Tau = 0.0017,
		work_time = 330,
		nozzle_position							= {{-0.9, -0.15, 0}},
		nozzle_orientationXYZ					= {{0.0, 0.0, 0.0}},
		tail_width								= 0.1,	
		start_burn_effect						= 0,
		custom_smoke_dissipation_factor 		= 0.1,			        	--X-65
		smoke_color  							= {0.1, 0.1, 0.1},     		--X-65
		smoke_transparency  					= 0.03,		          		--X-65
		start_effect_delay  					= { 0.0, 0.3, 0.8 },        --X-65
		start_effect_size  						= { 0.09, 0.104, 0.11 },    --X-65
		start_effect_smoke  					= { 0.01, 0.4, 0.01 },      --X-65
		start_effect_time  						= { 0.7, 1, 0.1 },          --X-65
		start_effect_x_dist  					= { 1.1, 0.9, 0 },          --X-65
		start_effect_x_pow  					= { 1, 1, 1 },              --X-65
		start_effect_x_shift  					= { 0.15, 0.15, 0.2 },		--X-65	
	},	
	
	seeker =
	{
		coalition					= 2,
		coalition_rnd_coeff			= 5.0,
		can_update_target_pos		= 1,
	},	
	
	laser_spot_seeker = 
	{
		FOV							= math.rad(32),
		max_seeker_range			= 140000.0,     
	},		
	
	
	PN_autopilot = 
	{
		K			  =  0.014,       
		Ki			= 0.001,        
		Kg			= 2.5,          
		Kx			= 0.02,        
		fins_limit	=  0.3,     
		K_GBias		= 9.26,       
	},

	
	warhead = spear3_warhead,
	warhead_air = spear3_warhead,
	
}

declare_weapon(SPEAR3_MISSILE_RACK_4_GPS)


declare_loadout({
    category        = CAT_MISSILES,
    CLSID           = "{SPEAR-3_RACK*4_GPS}",
    wsTypeOfWeapon  = SPEAR3_MISSILE_RACK_4_GPS.wsTypeOfWeapon,
    attribute       = {4, 4, 32, WSTYPE_PLACEHOLDER},
    Count           = 4,
    Cx_pil          = 0.0045,
    Picture         = "spear-3_rack_4.png",
    displayName     = _('4 x ' .. spear3_GPS),
    Weight          = spear3_mass * 4 + 145.15,
	ejectImpulse    = 150,	
	Elements = {
	
		{
			ShapeName	=	"jas39_bru_61",
			IsAdapter = true,
		},
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},	
			Position	=	{-0.802,	-0.237, -0.125},
			ShapeName	=	spear3_shape_name,
		},			
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},	
			Position	=	{-0.802,	-0.237, 0.125},
			ShapeName	=	spear3_shape_name,
		},		

		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},
			Position	=	{1.02,	-0.237,	-0.125},
			ShapeName	=	spear3_shape_name,
		},
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},
			Position	=	{1.02,	-0.237,	0.125},
			ShapeName	=	spear3_shape_name,
		},		
	},
    
    JettisonSubmunitionOnly = false,
})

declare_loadout({
    category        = CAT_MISSILES,
    CLSID           = "{SPEAR-3_RACK*4_GPS_BAY}",
    wsTypeOfWeapon  = SPEAR3_MISSILE_RACK_4_GPS.wsTypeOfWeapon,
    attribute       = {4, 4, 32, WSTYPE_PLACEHOLDER},
    Count           = 4,
    Cx_pil          = 0.0,
    Picture         = "spear-3_rack_4.png",
    displayName     = _('4 x ' .. spear3_GPS),
    Weight          = spear3_mass * 4 + 145.15,
	ejectImpulse    = 150,	
	Elements = {
	
		{
			ShapeName	=	"jas39_bru_61",
			IsAdapter = true,
		},
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},	
			Position	=	{-0.802,	-0.237, -0.125},
			ShapeName	=	spear3_shape_name,
		},			
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},	
			Position	=	{-0.802,	-0.237, 0.125},	
			ShapeName	=	spear3_shape_name,
		},		

		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},
			Position	=	{1.02,	-0.237,	-0.125},
			ShapeName	=	spear3_shape_name,
		},
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},
			Position	=	{1.02,	-0.237,	0.125},	
			ShapeName	=	spear3_shape_name,
		},		
	},
    
    JettisonSubmunitionOnly = false,
})