--DSplayer Edited 2025-10-25

db_path = db_path or "./Scripts/Database/";
dofile(db_path.."db_countries.lua");

-------- PYLON DEFINITIONS --------
local pylon_1 = 1 -- 1
local pylon_2 = 2 -- 2L
local pylon_3 = 3 -- 2
local pylon_4 = 4 -- 2R
local pylon_5 = 5 -- 3
local pylon_6 = 6 -- 4
local pylon_7 = 7 -- 5
local pylon_8 = 8 -- 6
local pylon_9 = 9 -- 7
local pylon_10 = 10 -- 8L
local pylon_11 = 11 -- 8
local pylon_12 = 12 -- 8R
local pylon_13 = 13 -- 9
local pylon_14 = 14 -- CMS

local pylon_names = {"1", "2L", "2", "2R", "3", "4", "5", "6", "7", "8L", "8", "8R", "9", "CMS"}

-------- GUN ---------
local m61_20_hei = {
  category = CAT_SHELLS,
  name = "M56A3_HE_RED",
  user_name = _("M56A3 20mm HEI"),
  model_name    = "tracer_bullet_red",
    projectile      = "HE",
    payloadEffect   = "Thermal",
    payloadMaterial = "RDX",
    payload = 0.110,
  v0    = 3320*0.3048,
  Dv0   = 50.0/3320.0,
  Da0     = 0.001,
  Da1     = 0.0,
  mass      = 0.110,
  round_mass = 0.349,
  explosive     = 0.110, -- 0.0170 kg in real
  life_time     = 30,
  caliber     = 20.0,
  s         = 0.0,
  j         = 0.0,
  l         = 0.0,
  charTime    = 0,
  cx        = {0.5,1.27,0.70,0.200,2.30},
  k1        = 2.0e-08,
  tracer_off    = -1,
  tracer_on    = -1,
  scale_tracer  = 0,

  smoke_tail_life_time = 0.2,
  scale_smoke = 1,
  smoke_opacity = 0.1,

  cartridge = 0,
}
declare_weapon(m61_20_hei)

local m61_20_api = {
  category = CAT_SHELLS,
  name = "M53_AP_RED",
  user_name = _("M53 20mm API"),
  model_name    = "tracer_bullet_red",
    projectile      = "AP",
  v0    = 3380*0.3048,
  Dv0   = 50.0/3380.0,
  Da0     = 0.001,
  Da1     = 0.0,
  mass      = 0.110,
  round_mass = 0.349,
  explosive     = 0.0,
  life_time     = 30,
  caliber     = 20.0,
  s         = 0.0,
  j         = 0.0,
  l         = 0.0,
  charTime    = 0,
  cx        = {0.5,1.27,0.70,0.200,2.30},
  k1        = 2.0e-08,
  tracer_off    = -1,
  tracer_on    = -1,
  scale_tracer  = 0,

  smoke_tail_life_time = 0.2,
  scale_smoke = 1,
  smoke_opacity = 0.1,

  cartridge = 0,
}
declare_weapon(m61_20_api)

-- M55A2  TP ball hollow
local m61_20_tp = {
  category = CAT_SHELLS,
  name = "M55A2_TP_RED",
  user_name = _("M55A2 20mm TP"),
  model_name    = "tracer_bullet_red",
    projectile      = "Ball",
    payloadEffect   = "HollowCharge",
  v0    = 3380*0.3048,
  Dv0   = 50.0/3380.0,
  Da0     = 0.001,
  Da1     = 0.0,
  mass      = 0.110,
  round_mass = 0.349,
  explosive     = 0.0,
  life_time     = 30,
  caliber     = 20.0,
  s         = 0.0,
  j         = 0.0,
  l         = 0.0,
  charTime    = 0,
  cx        = {0.5,1.27,0.70,0.200,2.30},
  k1        = 2.0e-08,
  tracer_off    = -1,
  tracer_on    = -1,
  scale_tracer  = 0,

  smoke_tail_life_time = 0.2,
  scale_smoke = 1,
  smoke_opacity = 0.1,

  cartridge = 0,
}
declare_weapon(m61_20_tp)

local m61_20_tracer = {
  category = CAT_SHELLS,
  name = "M53_APT_RED",
  user_name = _("20mm tracer"),
  model_name    = "tracer_bullet_red",
    projectile      = "AP",
  v0    = 3380*0.3048,
  Dv0   = 50.0/3380.0,
  Da0     = 0.001,
  Da1     = 0.0,
  mass      = 0.110,
  round_mass = 0.349,
  explosive     = 0.0,
  life_time     = 30,
  caliber     = 20.0,
  s         = 0.0,
  j         = 0.0,
  l         = 0.0,
  charTime    = 0,
  cx        = {0.5,1.27,0.70,0.200,2.30},
  k1        = 2.0e-08,
  tracer_off = 6.1,
  tracer_on = 0.01,
  scale_tracer = 1,

  smoke_tail_life_time = 1.5,
  scale_smoke = 1,
  smoke_opacity = 0.1,

  cartridge = 0,
}
declare_weapon(m61_20_tracer)
-- TODO: PGU-28 (for F-14B, as mentioned in F14AAP-1) [slightly faster, less drag, e.g. https://www.gd-ots.com/munitions/medium-caliber-ammunition/20mm-x-102-pgu/]

local ils_decimal_frequencies = {
    {id =  0, dispName = _(".00")},
    {id =  1, dispName = _(".05")},
    {id =  2, dispName = _(".10")},
    {id =  3, dispName = _(".15")},
    {id =  4, dispName = _(".20")},
    {id =  5, dispName = _(".25")},
    {id =  6, dispName = _(".30")},
    {id =  7, dispName = _(".35")},
    {id =  8, dispName = _(".40")},
    {id =  9, dispName = _(".45")},
    {id = 10, dispName = _(".50")},
    {id = 11, dispName = _(".55")},
    {id = 12, dispName = _(".60")},
    {id = 13, dispName = _(".65")},
    {id = 14, dispName = _(".70")},
    {id = 15, dispName = _(".75")},
    {id = 16, dispName = _(".80")},
    {id = 17, dispName = _(".85")},
    {id = 18, dispName = _(".90")},
    {id = 19, dispName = _(".95")}
}

local function m61a1()
	local tbl = {}
    tbl.category = CAT_GUN_MOUNT
	tbl.name = "M-61A1"
	tbl.display_name = _("M-61A1")
	tbl.supply = {
		shells = { "M56A3_HE_RED", "M53_AP_RED", "M55A2_TP_RED", "M53_APT_RED" },
		mixes = { { 1, 1, 1, 1, 4 }, { 2, 2, 2, 2, 4 }, { 1, 2, 1, 2, 4 }, { 3, 3, 3, 3, 4 } },
		count = 639, -- according to Weapons Delivery Manual
    }
	tbl.gun = {
		max_burst_length = 100000,
		rates = { 6000, 4000 },
		recoil_coeff = 0.7 * 1.3,
		barrels_count = 1,
    }

	tbl.ejector_pos = { 0, 0, 0 }
	tbl.ejector_pos_connector = "pnt_shell"
	tbl.ejector_dir = { 0, 0, 0 }
	tbl.supply_position = { 0, 0, 0 }
	tbl.aft_gun_mount = false
    tbl.effective_fire_distance = 2700
	tbl.drop_cartridge = 0-- set to 204 (shell_50cal model) to let it eject bullet shells
	tbl.muzzle_pos = { 0, 0, 0 }
	tbl.muzzle_pos_connector = "PNT_GUN"
	tbl.azimuth_initial = 0
	tbl.elevation_initial = 0.0
	tbl.smoke_dir = { 0, -1, -0.2 }
        tbl.effects = {
		gatling_effect(351, 6),
		fire_effect(350, 0.02, 2, { 0, 0, 0 }),
		{ name = "SmokeEffect", smoke_exhaust = "PNT_GUN", add_speed = { 5, 0, 0 }, sparks_enabled = true },
	}
    return declare_weapon(tbl)
end



-- Shallow Doesn't matter for our purpose
function merge_tables(t1, t2)
	local result = {}

	for i,v in ipairs(t1) do
		result[#result+1] = v
	end

	for i,v in ipairs(t2) do
		result[#result+1] = v
	end

	return result
end

-- Drag calculated using ratio of Drag Index to known DCS drag value.
-- MK-83 Cx_pil = 0.00035
-- MK-83 index = 1.8
-- (Store index / MK-83 index) * MK-83 Cx_pil
-- 0.00054 - AIM-7E
-- AIM-7E Actual Cxp_pil = (1.3 / 1.8) * 0.00035 = 0.00025
-- Cx_gain = 0.00025 / 0.00054 = 0.47
local aim7_cx_gain = 0.47

local aim7_loadout = {
	{ CLSID = "{HB_F4E_AIM-7F}", Cx_gain = aim7_cx_gain },
	{ CLSID = "{HB_F4E_AIM-7E}", Cx_gain = aim7_cx_gain, use_full_connector_position = false },
	{ CLSID = "{HB_F4E_AIM-7E-2}", Cx_gain = aim7_cx_gain, use_full_connector_position = false },
	--{ CLSID = "{HB_F4E_AIM-7E-3}", use_full_connector_position = false }, -- Disabled for Now Until we have enough Difference
	{ CLSID = "{HB_F4E_AIM-7M}", Cx_gain = aim7_cx_gain },
	{ CLSID = "{HB_F4E_AIM-7MH}", Cx_gain = aim7_cx_gain },
	{ CLSID = "{HB_F4E_AIM-7P}", Cx_gain = aim7_cx_gain },
	{ CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}", Cx_gain = aim7_cx_gain },	--AIM-120B
	{ CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", Cx_gain = aim7_cx_gain },	--AIM-120C-5
}

local aim7_loadout_QF4 = {
}

local aim7_equipment_loadout = {
	{CLSID = "{HB_PAVE_SPIKE_ON_ADAPTER_IN_AERO7}", connector = "PNT_AIM7_POD_ATTACH", arg = 611, arg_value = 1.0},
	{CLSID = "{HB_PAVE_SPIKE_FAST_ON_ADAPTER_IN_AERO7}", connector = "PNT_AIM7_POD_ATTACH", arg = 611, arg_value = 1.0},
	{CLSID = "{HB_ALQ-131_ON_ADAPTER_IN_AERO7}", connector = "PNT_AIM7_POD_ATTACH"},
	{CLSID = "{HB_ALQ-184_ON_ADAPTER_IN_AERO7}", connector = "PNT_AIM7_POD_ATTACH"},
	{CLSID = "{HB_LITENING_ON_ADAPTER_IN_AERO7}", connector = "PNT_AIM7_POD_ATTACH"},
}

local aim7_equipment_loadout_QF4 = {
}

function set_pylon_argument(tbl, value)
	for i, v in pairs(tbl) do
		if v.use_default_arg ~= true and v.arg_value == nil then
			v.arg_value = value
		end
	end
end

function set_pylon_connector(tbl, value)
	for i,v in pairs(tbl) do
		if v.connector == nil and v.use_alternate_connector == true then
			v.connector = value
		end
	end
end

local args_info = {

	outer = {
		positions = {
			empty = 1,
			tank = 0,
			weapon = 0.5,
			weapon_aft = 0.75,
		},

		left_arg = 308,
		right_arg = 316,
	},

	-- inner not setup yet
	inner = {
		positions = {
			empty = 1,
			swa = 0.5,
			weapon = 0,
		},

		left_arg = 3004, -- Dummy args
		right_arg = 3005,
	},

	centre = {
		positions = {
			empty = 0,
			weapon = 0.3,
			weapon_aft = 0.5,
			sway_brace = 1,
		},
		arg = 312,
	},

	sidewinder = {
		positions = {
			empty = 0,
			weapon = 1
		},
		left_arg_inner = 504,
		left_arg_outer = 506,
		right_arg_inner = 505,
		right_arg_outer = 507,
	},

	falcon = {
		positions = {
			empty = 0,
			weapon = 1
		},
		left = 2500,
		right = 2501,
	},
}

local pylon_mass = { -- Source 1995 -1
	aero3 = 24.95, -- ((inbd + 2 aim9) - inbd) / 2
	inboard_armament = 119.7,
	centerline = 32.2,
	swa = 29.9,
	outboard_armament = 86.1
}

function GetCMSRestrictions()
	local result = {
		{station = pylon_3, loadout = { "<CLEAN>" }},
		{station = pylon_11, loadout = { "<CLEAN>" } },
	}

	return result
end


function Aim9RestrictCat(pylon)
	return "sidewinder_"..tostring(pylon)
end

function Aim9Restrict(side)

	if side == "left" then
		return { Aim9RestrictCat(pylon_2), Aim9RestrictCat(pylon_4) }
	elseif side == "right" then
		return { Aim9RestrictCat(pylon_10), Aim9RestrictCat(pylon_12) }
	end
	
	return {}
end

function InnerClean(side)

	local left_required = {
		{station = pylon_2, loadout = {"<CLEAN>"} },
		{station = pylon_4, loadout = {"<CLEAN>"} },
	}

	local right_required = {
		{station = pylon_10, loadout = {"<CLEAN>"} },
		{station = pylon_12, loadout = {"<CLEAN>"} },
	}

	if side == "left" then
		return left_required
	elseif side == "right" then
		return right_required
	end
	
	return {}

end

-- "left" for left
-- "right" for right
function create_aim9_loadout(side, pylon)
	-- Can add the connectors to this list later.
	local aim9_loadout = {
		{ CLSID = "{AIM-9B}" },
		{ CLSID = "{AIM-9J}" },
		{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" }, --P
		{ CLSID = "{AIM-9L}" },
		{ CLSID = "{AIM-9JULI}" }, -- German Ones?
		{ CLSID = "{AIM-9M}" },
		{ CLSID = "CATM-9M" },
		{ CLSID = "{AIM-9P5}" },
		{ CLSID = "{AIM-9P3}" },
		{ CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E741}" }, -- Smokewinder red
		{ CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E742}" }, -- Smokewinder green
		{ CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E743}" }, -- Smokewinder blue
		{ CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E744}" }, -- Smokewinder white
		{ CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E745}" }, -- Smokewinder yellow
		{ CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E746}" }, -- Smokewinder orange
		{ CLSID = "{AIS_ASQ_T50}" }, -- ACMI Pod

		-- DSplayer Custom Navy AIM-9s
		{ CLSID = "{AIM-9D}" },
		{ CLSID = "{AIM-9G}" },
		{ CLSID = "{AIM-9H}" },
	}

	local result = {
		{ CLSID = "<CLEAN>", arg_value = args_info.sidewinder.positions.empty, add_mass = -pylon_mass.aero3 },
	
	}
	for i,aim9 in pairs(aim9_loadout) do
		aim9["restrict"] = { Aim9RestrictCat(pylon) }
		result[#result+1] = aim9
	end

	if side == "left" and pylon == pylon_4 then
		local aim4_inner = {
			{CLSID = "{AIM-4D}",	arg = args_info.falcon.left, arg_value = args_info.falcon.positions,	connector = "PNT_PYLON_2_Lau42_L",},
		}
		result = merge_tables(aim4_inner, result)
	elseif side == "right" and pylon == pylon_10 then
		local aim4_inner = {
			{CLSID = "{AIM-4D}",	arg = args_info.falcon.right, arg_value = args_info.falcon.positions,	connector = "PNT_PYLON_2_Lau42_R"},
		}
		result = merge_tables(aim4_inner, result)
	end

	if side == "left" and pylon == pylon_2 then
		local aim4_lower = {
			{CLSID = "{AIM-4D}",	arg = args_info.falcon.left, arg_value = args_info.falcon.positions,	connector = "PNT_PYLON_2_Lau43_L"},
		}
		result = merge_tables(aim4_lower, result)
	elseif side == "right" and pylon == pylon_12 then
		local aim4_lower = {
			{CLSID = "{AIM-4D}",	arg = args_info.falcon.right, arg_value = args_info.falcon.positions,	connector = "PNT_PYLON_2_Lau43_R"},
		}
		result = merge_tables(aim4_lower, result)
	end

	return result
end

function create_aim9_loadout_QF4(side, pylon)
	local result = {
		{ CLSID = "<CLEAN>", arg_value = args_info.sidewinder.positions.empty, add_mass = -pylon_mass.aero3 },
	}
	return result
end

-- Translate from Bomb Name in the bomb_data to single carriage CLSID, just makes it easier
local bomb_to_clsid = {
	["MK-81"] = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}",
	["MK-82"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", -- MK-82
	["MK-82_Snakeye"] = "{Mk82SNAKEYE}",
	["MK-82AIR"] = "{Mk82AIR}", -- MK-82 AIR
	["ROCKEYE"] = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}", -- MK-20
	["MK-83"] = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}",
	["M117"] = "{00F5DAC4-0466-4122-998F-B1A298E34113}", -- M117
	["BDU-50LD"] = "{BDU-50LD}",
	["BDU-50HD"] = "{BDU-50HD}",
	["CBU-87"] = "{CBU-87}",
	["CBU-52B"] = "{CBU-52B}",
	["GBU-12"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
	["BDU_45LGB"] = "{BDU_45LG}",
	["BL755"] = "{08164777-5E9C-4B08-B48E-5AA7AFB246E2}", -- BL755 for F-4F
	["SAMP-250LD"] = "{SAMP250LD}", -- Matra 250 LD for F-4F
	["SAMP-250HD"] = "{SAMP250HD}", -- Matra 250 HD for F-4F
}

function create_inner_wing_loadout(side)

	local swa_entry = function(clsid)
		return { CLSID = clsid, use_alternate_connector = true, arg_value = args_info.inner.positions.swa, add_mass = pylon_mass.swa }
	end

	local inner_wing_pylon = {
		-- Bombs
		
		-- CBU-87
		{CLSID = "{CBU-87}",								restrict = Aim9Restrict(side), required = InnerClean(side)},
		swa_entry("{HB_CBU-87_SWA}"),
		{CLSID = "{HB_F4E_CBU-87_2x}",						restrict = Aim9Restrict(side)},
		swa_entry("{HB_F4E_CBU-87_2x_SWA}"),
		
		-- CBU-52
		{CLSID = "{CBU-52B}",								restrict = Aim9Restrict(side), required = InnerClean(side)},
		swa_entry("{HB_CBU-52B_SWA}"),
		{CLSID = "{HB_F4E_CBU-52B_2x}", 					restrict = Aim9Restrict(side)},
		swa_entry("{HB_F4E_CBU-52B_2x_SWA}"),
		
		-- BLU-107B
		{CLSID = "{HB_F4E_BLU-107B_3x}",					restrict = Aim9Restrict(side)},
		swa_entry("{HB_F4E_BLU-107B_3x_SWA}"),
		
		-- MK-83
		{CLSID = "{HB_F4E_MK-83_3x}",						restrict = Aim9Restrict(side)},
		
		-- M117
		{CLSID = "{HB_F4E_M117_3x}",						restrict = Aim9Restrict(side)},

		-- BL755
		{CLSID = "{HB_F4E_BL755_TER_3x}",						restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_BL755_TER_2x_opposed}",				restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_BL755_TER_1x_SingleRight}",			restrict = Aim9Restrict(side)},
		
		-- SAMP250LD
		{CLSID = "{HB_F4E_SAMP250LD_TER_3x}",						restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_SAMP250LD_TER_2x_opposed}",				restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_SAMP250LD_TER_1x_SingleRight}",			restrict = Aim9Restrict(side)},
		
		-- SAMP250HD
		{CLSID = "{HB_F4E_SAMP250HD_TER_3x}",						restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_SAMP250HD_TER_2x_opposed}",				restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_SAMP250HD_TER_1x_SingleRight}",			restrict = Aim9Restrict(side)},

		-- MK-84 AIR - Allowed for same reason GBU-10 allowed clearance.
		{CLSID = "{Mk_84AIR_GP}",							restrict = Aim9Restrict(side), required = InnerClean(side)},
		
		-- LGB --
		{CLSID = "{34759BBC-AF1E-4AEE-A581-498FF7A6EBCE}",	restrict = Aim9Restrict(side), required = InnerClean(side)}, -- GBU-24A/B Airforce Variant
		{CLSID = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",	restrict = Aim9Restrict(side), required = InnerClean(side)}, -- GBU-10

		-- GBU-12
		{CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",	restrict = Aim9Restrict(side), required = InnerClean(side)},
		swa_entry("{HB_GBU-12_SWA}"),
		{CLSID = "{HB_F4E_GBU-12_2x}",						restrict = Aim9Restrict(side)},
		swa_entry("{HB_F4E_GBU-12_2x_SWA}"),

		-- Training GBU-12
		{CLSID = "{BDU_45LG}",								restrict = Aim9Restrict(side), required = InnerClean(side)},
		swa_entry("{HB_BDU_45LGB_SWA}"),
		{CLSID = "{HB_F4E_BDU_45LGB_2x}",					restrict = Aim9Restrict(side)},
		swa_entry("{HB_F4E_BDU_45LGB_2x_SWA}"),

		-- Missiles --
		-- Mavericks added below in add_maverick, with the exception of G
		{CLSID = "{HB_F4E_AGM-65G_LAU117}",							restrict = Aim9Restrict(side), required = InnerClean(side)},
		{CLSID = "{HB_F4E_AGM-65F_LAU117}",							restrict = Aim9Restrict(side), required = InnerClean(side)},
		{CLSID = "{HB_F4E_AGM-65K_LAU117}",							restrict = Aim9Restrict(side), required = InnerClean(side)},
		{CLSID = "{HB_F4E_AGM-65L_LAU117}",							restrict = Aim9Restrict(side), required = InnerClean(side)},

		{CLSID = "{HB_F4E_TGM-65G_LAU117}",							restrict = Aim9Restrict(side), required = InnerClean(side)},
		{CLSID = "{HB_F4E_CATM-65K_LAU117}",							restrict = Aim9Restrict(side), required = InnerClean(side)},

		{CLSID = "{LAU_34_AGM_45A}",								restrict = Aim9Restrict(side), required = InnerClean(side)},
		swa_entry("{LAU_34_AGM_45A_SWA}"),

		{CLSID = "{LAU_34_AGM_45B}",								restrict = Aim9Restrict(side), required = InnerClean(side)},
		swa_entry("{LAU_34_AGM_45B_SWA}"),

		{CLSID = "{LAU_77_AGM_78A}",								restrict = Aim9Restrict(side), required = InnerClean(side)},
		{CLSID = "{LAU_77_AGM_78B}",								restrict = Aim9Restrict(side), required = InnerClean(side)},

		{CLSID = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",			restrict = Aim9Restrict(side), required = InnerClean(side)},

		{CLSID = "{C40A1E3A-DD05-40D9-85A4-217729E37FAE}",	restrict = Aim9Restrict(side), required = InnerClean(side)}, -- AGM-62 Walleye II
		{CLSID = "{AGM_62_I}",								restrict = Aim9Restrict(side), required = InnerClean(side)}, -- AGM-62 Walleye I
		{CLSID = "{GBU_8_B}",							restrict = Aim9Restrict(side), required = InnerClean(side)}, -- HOBOS

		{CLSID = "{GBU-15V1}",							restrict = Aim9Restrict(side), required = InnerClean(side)}, -- GBU-15

		{CLSID = "{AGM_12A}",								restrict = Aim9Restrict(side), required = InnerClean(side)},
		{CLSID = "{AGM_12B}",								restrict = Aim9Restrict(side), required = InnerClean(side)},
		{CLSID = "{AGM_12C}",								restrict = Aim9Restrict(side), required = InnerClean(side)},

		-- Rockets
		{CLSID = "{HB_F4E_LAU-68_MK5_1x}",					restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_LAU-68_MK1_1x}",					restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_LAU-68_WP156_1x}",				restrict = Aim9Restrict(side)},

		{CLSID = "{HB_F4E_LAU-68_MK5_3x}",					restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_LAU-68_MK1_3x}",					restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_LAU-68_WP156_3x}",				restrict = Aim9Restrict(side)},

		{CLSID = "{LAU68_FFAR_WP156}"},
		{CLSID = "{LAU68_FFAR_MK1HE}"},
		{CLSID = "{LAU68_FFAR_MK5HEAT}"},

		{CLSID = "{HB_F4E_LAU-3_WP156_1x}",					restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_LAU-3_MK1_1x}",					restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_LAU-3_MK5_1x}",					restrict = Aim9Restrict(side)},

		{CLSID = "{HB_F4E_LAU-3_WP156_3x}",					restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_LAU-3_MK1_3x}",					restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_LAU-3_MK5_3x}",					restrict = Aim9Restrict(side)},

		{CLSID = "{HB_F4E_LAU-10_ZUNI_3x}",					restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_LAU-10_ZUNI_2x_Opposed}",			restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_LAU-10_ZUNI_1x}",					restrict = Aim9Restrict(side)},
		{CLSID = "{F3EFE0AB-E91A-42D8-9CA2-B63C91ED570A}"},	--LAU-10 Zunis

		{CLSID = "{LAU3_FFAR_WP156}"},
		{CLSID = "{LAU3_FFAR_MK1HE}"},
		{CLSID = "{LAU3_FFAR_MK5HEAT}"},

		-- Pods
		{CLSID = "{SUU_23_POD}"},
		{CLSID = "{GPU_5_POD}"},

		-- Pods
		{CLSID = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",	restrict = Aim9Restrict(side)}, -- ALQ-131
		{CLSID = "ALQ_184_LONG",							restrict = Aim9Restrict(side)}, -- ALQ-184

		-- Clean
		{ CLSID = "<CLEAN>", arg_value = args_info.inner.positions.empty, restrict = Aim9Restrict(side), add_mass = -pylon_mass.inboard_armament, required = InnerClean(side) }, -- Clean
	}

	-- These bombs all follow a similar pattern.
	-- 3x, 2x, 2x SWA and Single Carriage + Single Carriage SWA
	local add_gp_bomb = function(bomb) -- Shortcut for adding GP bombs
		table.insert(inner_wing_pylon, { CLSID = "{HB_F4E_"..bomb.."_3x}",	restrict = Aim9Restrict(side) })
		table.insert(inner_wing_pylon, { CLSID = "{HB_F4E_"..bomb.."_2x}",	restrict = Aim9Restrict(side) })
		table.insert(inner_wing_pylon, swa_entry("{HB_F4E_"..bomb.."_2x_SWA}"))
	end

	add_gp_bomb("MK-81")
	add_gp_bomb("MK-82")
	add_gp_bomb("MK-82_Snakeye")
	add_gp_bomb("ROCKEYE")
	add_gp_bomb("MK-82AIR")
	add_gp_bomb("BDU-50LD")
	add_gp_bomb("BDU-50HD")
	add_gp_bomb("BDU-33")

	local inner_wing_pylon_left = {
		{CLSID = "{HB_F4E_MK-83_2x_Left}",				restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_M117_2x_Left}",				restrict = Aim9Restrict(side)},

		-- Rockets
		{CLSID = "{HB_F4E_LAU-68_MK5_2x_Left}",			restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_LAU-68_MK1_2x_Left}",			restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_LAU-68_WP156_2x_Left}",		restrict = Aim9Restrict(side)},

		{CLSID = "{HB_F4E_LAU-3_MK5_2x_Left}",			restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_LAU-3_MK1_2x_Left}",			restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_LAU-3_WP156_2x_Left}",		restrict = Aim9Restrict(side)},

		{CLSID = "{HB_F4E_LAU-10_ZUNI_2x_Left}",		restrict = Aim9Restrict(side)},

		-- {CLSID = "{AIM-4D}",	arg = args_info.falcon.left, arg_value = args_info.falcon.positions.weapon, connector = "PNT_PYLON_2_Lau43_L"},
	}

	local inner_wing_pylon_right = {
		{CLSID = "{HB_F4E_MK-83_2x_Right}",				restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_M117_2x_Right}",				restrict = Aim9Restrict(side)},

		-- Rockets
		{CLSID = "{HB_F4E_LAU-68_MK5_2x_Right}",		restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_LAU-68_MK1_2x_Right}",		restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_LAU-68_WP156_2x_Right}",		restrict = Aim9Restrict(side)},

		{CLSID = "{HB_F4E_LAU-3_MK5_2x_Right}",			restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_LAU-3_MK1_2x_Right}",			restrict = Aim9Restrict(side)},
		{CLSID = "{HB_F4E_LAU-3_WP156_2x_Right}",		restrict = Aim9Restrict(side)},

		{CLSID = "{HB_F4E_LAU-10_ZUNI_2x_Right}",		restrict = Aim9Restrict(side)},

		-- {CLSID = "{AIM-4D}",	arg = args_info.falcon.right, arg_value = args_info.falcon.positions.weapon, connector = "PNT_PYLON_2_Lau43_R"},
	}

	local add_maverick = function(maverick)

		table.insert(inner_wing_pylon, {CLSID = "{HB_F4E_"..maverick.."_LAU117}", restrict = Aim9Restrict(side)})
		table.insert(inner_wing_pylon, swa_entry("{HB_F4E_"..maverick.."_LAU117_SWA}"))

		table.insert(inner_wing_pylon_left, { CLSID = "{HB_F4E"..maverick.."_LAU88_3x_Left}", 	restrict = Aim9Restrict(side), required = InnerClean(side) })
		table.insert(inner_wing_pylon_left, { CLSID = "{HB_F4E"..maverick.."_LAU88_2x_Left}", 	restrict = Aim9Restrict(side), required = InnerClean(side) })

		table.insert(inner_wing_pylon_right, { CLSID = "{HB_F4E"..maverick.."_LAU88_3x_Right}", restrict = Aim9Restrict(side), required = InnerClean(side) })
		table.insert(inner_wing_pylon_right, { CLSID = "{HB_F4E"..maverick.."_LAU88_2x_Right}", restrict = Aim9Restrict(side), required = InnerClean(side) })

		table.insert(inner_wing_pylon, { CLSID = "{HB_F4E"..maverick.."_LAU88_1x}", restrict = Aim9Restrict(side), required = InnerClean(side) })
	end
	add_maverick("AGM-65A")
	add_maverick("AGM-65B")
	add_maverick("AGM-65D")

	-- DSplayer Modded
	add_maverick("TGM-65D")
	add_maverick("AGM-65H")
	add_maverick("TGM-65H")


	local result = {}
	if side == "left" then
		result = merge_tables(inner_wing_pylon_left, inner_wing_pylon)
		set_pylon_connector(result, "PNT_PYLON_2_SWA_L") -- set SWA connector
	elseif side == "right" then
		result = merge_tables(inner_wing_pylon_right, inner_wing_pylon)
		set_pylon_connector(result, "PNT_PYLON_2_SWA_R") -- set SWA connector
	end

	set_pylon_argument(result, args_info.inner.positions.weapon)

	return result
end

function create_inner_wing_loadout_QF4(side)

	local inner_wing_pylon = {
		-- Clean
		{ CLSID = "<CLEAN>", arg_value = args_info.inner.positions.empty, restrict = Aim9Restrict(side), add_mass = -pylon_mass.inboard_armament, required = InnerClean(side) }, -- Clean
	}

	local inner_wing_pylon_left = {
	}

	local inner_wing_pylon_right = {
	}

    local result = {}
    if side == "left" then
        result = merge_tables(inner_wing_pylon_left, inner_wing_pylon)
        set_pylon_connector(result, "PNT_PYLON_2_SWA_L") -- set SWA connector
    elseif side == "right" then
        result = merge_tables(inner_wing_pylon_right, inner_wing_pylon)
        set_pylon_connector(result, "PNT_PYLON_2_SWA_R") -- set SWA connector
    end

	set_pylon_argument(result, args_info.inner.positions.weapon)

	return result
end

-- "left" for left
-- "right" for right
function create_outer_wing_loadout(side)

	local aft_mount = function(clsid)
		return {CLSID = clsid, arg_value = args_info.outer.positions.weapon_aft}
	end

	local outer_wing_pylon = {
		-- Bombs --

		-- Multiple Carriage Bombs --
		{CLSID = "{HB_F4E_MK-81_6x}" },
		{CLSID = "{HB_F4E_MK-82_6x}" },
		{CLSID = "{HB_F4E_MK-82_Snakeye_6x}" },
		-- No MK-20 MER Loadout on outer
		{CLSID = "{HB_F4E_MK-82AIR_6x}" },
		{CLSID = "{HB_F4E_BDU-50LD_6x}" },
		{CLSID = "{HB_F4E_BDU-50HD_6x}" },
		{CLSID = "{HB_F4E_BDU-33_6x}" },
		aft_mount("{HB_F4E_MK-83_MER_2x}"),


		-- Single Carriage Bombs --
		-- bigger bombs
		{CLSID = "{CBU-87}"},
		{CLSID = "{CBU-52B}"},
		{CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}"}, --Mk-84
		{CLSID = "{Mk_84AIR_GP}"},

		-- LGB --
		{CLSID = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}"}, -- GBU-10
		{CLSID = "{34759BBC-AF1E-4AEE-A581-498FF7A6EBCE}"}, -- GBU-24A/B
		{CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}"}, -- GBU-12
		{CLSID = "{BDU_45LG}"}, -- GBU-12 Training
		
		-- EO Bombs
		{CLSID = "{GBU_8_B}"}, -- HOBOS
		{CLSID = "{AGM_62_I}"}, -- AGM-62 Walleye I
		
		
		-- Rockets
		{CLSID = "{LAU3_FFAR_WP156}"},
		{CLSID = "{LAU3_FFAR_MK1HE}"},
		{CLSID = "{LAU3_FFAR_MK5HEAT}"},

		aft_mount("{HB_F4E_LAU-3_WP156_MER_3x}"),
		aft_mount("{HB_F4E_LAU-3_MK1_MER_3x}"),
		aft_mount("{HB_F4E_LAU-3_MK5_MER_3x}"),

		-- {CLSID = "{HB_F4E_LAU-10_ZUNI_3x}"},
		-- {CLSID = "{HB_F4E_LAU-10_ZUNI_1x}"},
		
		{CLSID = "{F3EFE0AB-E91A-42D8-9CA2-B63C91ED570A}"},	--LAU-10 Zunis
		aft_mount("{HB_F4E_LAU-10_ZUNI_MER_3x}"),
		aft_mount("{HB_F4E_LAU-10_ZUNI_MER_2x}"),
		aft_mount("{HB_F4E_LAU-10_ZUNI_MER_1x}"),

		aft_mount("{HB_F4E_LAU-3_WP156_MER_3x}"),
		aft_mount("{HB_F4E_LAU-3_MK1_MER_3x}"),
		aft_mount("{HB_F4E_LAU-3_MK5_MER_3x}"),

		-- Dispensers
		{CLSID = "{CAE48299-A294-4bad-8EE6-89EFC5DCDF00}"}, -- SUU-25 Flares

		-- Missiles
		{CLSID = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}"},
		{CLSID = "{LAU_34_AGM_45A}"},
		{CLSID = "{LAU_34_AGM_45B}"},
		{CLSID = "{AGM_12A}"},
		{CLSID = "{AGM_12B}"},

		{CLSID = "{LAU_77_AGM_78A}"},
		{CLSID = "{LAU_77_AGM_78B}"},

		-- Pods
		{CLSID = "{SUU_23_POD}"},

		-- Clean
		{ CLSID = "<CLEAN>", arg_value = args_info.outer.positions.empty, add_mass = -pylon_mass.outboard_armament }, -- Clean
	}

	local outer_wing_pylon_left = {
		aft_mount("{HB_F4E_MK-83_MER_1x_Left_Ripple}"),
		{ CLSID = "{HB_F4E_M117_MER_3x_Left}" },
		{ CLSID = "{HB_F4E_CBU-87_MER_3x_Left}" },
		{ CLSID = "{HB_F4E_CBU-52B_MER_3x_Left}" },
		{ CLSID = "{HB_F4E_SUU-25_MER_2x_Left}" },
		
		-- BL755 --
		{ CLSID = "{HB_F4E_BL755_TER_2x_Left}" },
		{ CLSID = "{HB_F4E_BL755_TER_1x_SingleLeft}"},
		
		-- SAMP250LD --
		{ CLSID = "{HB_F4E_SAMP250LD_TER_3x}"},
		{ CLSID = "{HB_F4E_SAMP250LD_TER_2x_Left}" },
		{ CLSID = "{HB_F4E_SAMP250LD_TER_1x_SingleLeft}"},
		
		-- SAMP250HD --
		{ CLSID = "{HB_F4E_SAMP250HD_TER_3x}"},
		{ CLSID = "{HB_F4E_SAMP250HD_TER_2x_Left}" },
		{ CLSID = "{HB_F4E_SAMP250HD_TER_1x_SingleLeft}"},

		-- SUU-7 --
		{ CLSID = "{HB_F4E_CBU-1A_MER_2x_Left}" },
		{ CLSID = "{HB_F4E_CBU-2A_MER_2x_Left}" },
		{ CLSID = "{HB_F4E_CBU-2BA_MER_2x_Left}" },
		{ CLSID = "{HB_F4E_CBU-1A_MER_1x_Left}" },
		{ CLSID = "{HB_F4E_CBU-2A_MER_1x_Left}" },
		{ CLSID = "{HB_F4E_CBU-2BA_MER_1x_Left}" },

		-- Tanks --
		{CLSID ="{F4_SARGENT_TANK_370_GAL}", arg_value = args_info.outer.positions.tank, use_alternate_connector=true, add_mass = -pylon_mass.outboard_armament},
		{CLSID ="{F4_SARGENT_TANK_370_GAL_EMPTY}", arg_value = args_info.outer.positions.tank, use_alternate_connector=true, add_mass = -pylon_mass.outboard_armament},
	}

	local outer_wing_pylon_right = {
		aft_mount("{HB_F4E_MK-83_MER_1x_Right_Ripple}"),
		{ CLSID = "{HB_F4E_M117_MER_3x_Right}" },
		{ CLSID = "{HB_F4E_CBU-87_MER_3x_Right}" },
		{ CLSID = "{HB_F4E_CBU-52B_MER_3x_Right}" },
		{ CLSID = "{HB_F4E_SUU-25_MER_2x_Right}" },
		
		-- BL755 --
		{ CLSID = "{HB_F4E_BL755_TER_2x_Right}" },
		{ CLSID = "{HB_F4E_BL755_TER_1x_SingleRight}"},
		
		-- SAMP250LD --
		{ CLSID = "{HB_F4E_SAMP250LD_TER_3x}"},
		{ CLSID = "{HB_F4E_SAMP250LD_TER_2x_Right}" },
		{ CLSID = "{HB_F4E_SAMP250LD_TER_1x_SingleRight}"},

		-- SAMP250HD --
		{ CLSID = "{HB_F4E_SAMP250HD_TER_3x}"},
		{ CLSID = "{HB_F4E_SAMP250HD_TER_2x_Right}" },
		{ CLSID = "{HB_F4E_SAMP250HD_TER_1x_SingleRight}"},

		-- SUU-7
		{ CLSID = "{HB_F4E_CBU-1A_MER_2x_Right}" },
		{ CLSID = "{HB_F4E_CBU-2A_MER_2x_Right}" },
		{ CLSID = "{HB_F4E_CBU-2BA_MER_2x_Right}" },
		{ CLSID = "{HB_F4E_CBU-1A_MER_1x_Right}" },
		{ CLSID = "{HB_F4E_CBU-2A_MER_1x_Right}" },
		{ CLSID = "{HB_F4E_CBU-2BA_MER_1x_Right}" },

		-- Tanks --
		{CLSID ="{F4_SARGENT_TANK_370_GAL_R}", arg_value = args_info.outer.positions.tank, use_alternate_connector=true, add_mass = -pylon_mass.outboard_armament},
		{CLSID ="{F4_SARGENT_TANK_370_GAL_R_EMPTY}", arg_value = args_info.outer.positions.tank, use_alternate_connector=true, add_mass = -pylon_mass.outboard_armament},
	}

	local result = {}
	if side == "left" then
		result = merge_tables(outer_wing_pylon_left, outer_wing_pylon)
		set_pylon_connector(result, "PNT_PYLON_1") -- set fuel tank connector
	elseif side == "right" then
		result = merge_tables(outer_wing_pylon_right, outer_wing_pylon)
		set_pylon_connector(result, "PNT_PYLON_9") -- set fuel tank connector
	end

	set_pylon_argument(result, args_info.outer.positions.weapon)

	return result
end

-- "left" for left
-- "right" for right
function create_outer_wing_loadout_QF4(side)
	local outer_wing_pylon = {
		-- Clean
		{ CLSID = "<CLEAN>", arg_value = args_info.outer.positions.empty, add_mass = -pylon_mass.outboard_armament }, -- Clean
	}

	local outer_wing_pylon_left = {
		-- Tanks --
		{CLSID ="{F4_SARGENT_TANK_370_GAL}", arg_value = args_info.outer.positions.tank, use_alternate_connector=true, add_mass = -pylon_mass.outboard_armament},
		{CLSID ="{F4_SARGENT_TANK_370_GAL_EMPTY}", arg_value = args_info.outer.positions.tank, use_alternate_connector=true, add_mass = -pylon_mass.outboard_armament},
	}

	local outer_wing_pylon_right = {
		-- Tanks --
		{CLSID ="{F4_SARGENT_TANK_370_GAL_R}", arg_value = args_info.outer.positions.tank, use_alternate_connector=true, add_mass = -pylon_mass.outboard_armament},
		{CLSID ="{F4_SARGENT_TANK_370_GAL_R_EMPTY}", arg_value = args_info.outer.positions.tank, use_alternate_connector=true, add_mass = -pylon_mass.outboard_armament},
	}

	local result = {}
	if side == "left" then
		result = merge_tables(outer_wing_pylon_left, outer_wing_pylon)
		set_pylon_connector(result, "PNT_PYLON_1") -- set fuel tank connector
	elseif side == "right" then
		result = merge_tables(outer_wing_pylon_right, outer_wing_pylon)
		set_pylon_connector(result, "PNT_PYLON_9") -- set fuel tank connector
	end

	set_pylon_argument(result, args_info.outer.positions.weapon)

	return result
end

function create_centre_pylon_loadout()

	local aft_mount = function(clsid)
		return {CLSID = clsid, arg_value = args_info.centre.positions.weapon_aft, add_mass = pylon_mass.centerline}
	end

	local centre_pylon = {
		{CLSID = "{HB_F4E_MK-81_6x}", 			add_mass = pylon_mass.centerline },
		{CLSID = "{HB_F4E_MK-82_6x}", 			add_mass = pylon_mass.centerline },
		{CLSID = "{HB_F4E_MK-82_Snakeye_6x}", 	add_mass = pylon_mass.centerline },
		{CLSID = "{HB_F4E_ROCKEYE_6x}", 		add_mass = pylon_mass.centerline },
		{CLSID = "{HB_F4E_MK-82AIR_6x}", 		add_mass = pylon_mass.centerline },
		{CLSID = "{HB_F4E_BDU-50LD_6x}", 		add_mass = pylon_mass.centerline },
		{CLSID = "{HB_F4E_BDU-50HD_6x}", 		add_mass = pylon_mass.centerline },
		{CLSID = "{HB_F4E_BDU-33_6x}", 			add_mass = pylon_mass.centerline },
		{CLSID = "{HB_F4E_BLU-107B_6x}", 		add_mass = pylon_mass.centerline },
		{CLSID = "{HB_F4E_CBU-87_MER_4x}", 		add_mass = pylon_mass.centerline },
		{CLSID = "{HB_F4E_CBU-52B_6x}", 		add_mass = pylon_mass.centerline },
		{CLSID = "{HB_F4E_M117_MER_5x}", 		add_mass = pylon_mass.centerline },

		{CLSID = "{HB_F4E_MK-83_MER_3x}", 		add_mass = pylon_mass.centerline},
		{CLSID = "{HB_F4E_MK-83_MER_3x_Ripple}",add_mass = pylon_mass.centerline},

		-- BL755 --
		{CLSID = "{HB_F4E_BL755_TER_3x}", 					add_mass = pylon_mass.centerline },
		{CLSID = "{HB_F4E_BL755_TER_2x_opposed}", 			add_mass = pylon_mass.centerline },
		{ CLSID = "{HB_F4E_BL755_TER_1x_SingleRight}", 		add_mass = pylon_mass.centerline },
		
		-- SAMP 250KG LD--
		{CLSID = "{HB_F4E_SAMP250LD_TER_3x}", 				add_mass = pylon_mass.centerline },
		{CLSID = "{HB_F4E_SAMP250LD_TER_2x_opposed}", 		add_mass = pylon_mass.centerline },
		{CLSID = "{HB_F4E_SAMP250LD_TER_1x_SingleRight}",	add_mass = pylon_mass.centerline },
		
		-- SAMP 250KG HD--
		{CLSID = "{HB_F4E_SAMP250HD_TER_3x}", 				add_mass = pylon_mass.centerline },
		{CLSID = "{HB_F4E_SAMP250HD_TER_2x_opposed}", 		add_mass = pylon_mass.centerline },
		{CLSID = "{HB_F4E_SAMP250HD_TER_1x_SingleRight}",	add_mass = pylon_mass.centerline },

		-- Only single carriage bomb allowed
		{CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}", 	add_mass = pylon_mass.centerline}, --Mk-84

		-- Rockets
		aft_mount("{HB_F4E_LAU-3_WP156_MER_3x}"),
		aft_mount("{HB_F4E_LAU-3_MK1_MER_3x}"),
		aft_mount("{HB_F4E_LAU-3_MK5_MER_3x}"),

		-- aft_mount("{HB_F4E_LAU-10_ZUNI_MER_3x}"),

		-- Dispensers
		{ CLSID = "{HB_F4E_SUU-25_MER_2x}", add_mass = pylon_mass.centerline },
		{ CLSID = "{HB_F4E_CBU-1A_MER_1x}", add_mass = pylon_mass.centerline },
		{ CLSID = "{HB_F4E_CBU-2A_MER_1x}", add_mass = pylon_mass.centerline },
		{ CLSID = "{HB_F4E_CBU-2BA_MER_1x}", add_mass = pylon_mass.centerline },

		-- Pod
		{CLSID = "{SUU_23_POD}", add_mass = pylon_mass.centerline},
		{CLSID = "{GPU_5_POD}", add_mass = pylon_mass.centerline},
		{CLSID = "{AN_AXQ_14}", add_mass = pylon_mass.centerline, arg_value=args_info.centre.positions.weapon}, -- Set sway brace
		-- {CLSID = "{HB_AVQ_26_Pave_Tack}", add_mass = pylon_mass.centerline, arg_value=args_info.centre.positions.empty},

		-- Tanks
		{CLSID ="{F4_SARGENT_TANK_600_GAL}", arg_value=args_info.centre.positions.sway_brace, use_alternate_connector=true }, -- Set sway brace
		{CLSID ="{F4_SARGENT_TANK_600_GAL_EMPTY}", arg_value=args_info.centre.positions.sway_brace, use_alternate_connector=true }, -- Set sway brace
	}

	set_pylon_argument( centre_pylon, args_info.centre.positions.weapon )
	set_pylon_connector(centre_pylon, "PNT_PYLON_5")

	return centre_pylon

end

function create_centre_pylon_loadout_QF4()
    local centre_pylon = {
        -- Tanks
        {CLSID ="{F4_SARGENT_TANK_600_GAL}", arg_value=args_info.centre.positions.sway_brace, use_alternate_connector=true }, -- Set sway brace
        {CLSID ="{F4_SARGENT_TANK_600_GAL_EMPTY}", arg_value=args_info.centre.positions.sway_brace, use_alternate_connector=true }, -- Set sway brace
    }

    set_pylon_argument( centre_pylon, args_info.centre.positions.weapon )
	set_pylon_connector(centre_pylon, "PNT_PYLON_5")

	return centre_pylon
end

function create_flare_chaff_loadout()
	local flare_chaff_pylon = {
		{CLSID = "{HB_ALE_40_0_0}", arg_value = 0.1, 	forbidden=GetCMSRestrictions() },
		{CLSID = "{HB_ALE_40_0_120}", arg_value = 0.25, forbidden=GetCMSRestrictions() },
		{CLSID = "{HB_ALE_40_30_60}", arg_value = 0.5, 	forbidden=GetCMSRestrictions() },
		{CLSID = "{HB_ALE_40_15_90}", arg_value = 0.75, forbidden=GetCMSRestrictions() },
		{CLSID = "{HB_ALE_40_30_0}", arg_value = 1.0, 	forbidden=GetCMSRestrictions() },
	}

	return flare_chaff_pylon
end

-- The way this function works is it looks for
-- restrict tables on each weapon entry. These
-- are lists of categories for which they fall under
-- any other loadouts on other pylon(s) which fall under
-- the same category will be restricted with this loadout and
-- vice versa. 
function RestrictLoadouts(loadout)
	categories = {

	}
    -- This simply collects the restrictions into restriction
    -- categories example entry may look like
    --[[
    sidewinder_10 = {
        [3] = { "{HB_F4E_CBU-52B_2x}" },
        [10] = { "{AIM-9B}", "{AIM-9J}", "{AIM-9P3}" },
    }
    ]]--
    -- Where the index in the category is the pylon number
	for pylon_no, pylon_loadout in pairs(loadout) do

		for i, weapon in ipairs(pylon_loadout) do
			if weapon["restrict"] ~= nil then
				for i2, category in pairs(weapon["restrict"]) do
					
					if categories[category] == nil then
						categories[category] = {}
					end

					if categories[category][pylon_no] == nil then
						categories[category][pylon_no] = {}
					end

					table.insert(categories[category][pylon_no], weapon.CLSID)

				end

                weapon["restrict"] = nil -- Delete the Restict Table we are done with it now
			end
		end
	end

    -- Get Reference to Table to be Altered
    local find_weapon_table = function(pylon_table, clsid)
        for i,v in ipairs(pylon_table) do
            if v.CLSID == clsid then
                return v
            end
        end
    end

    -- DCS Boilerplate for adding weapon restriction
    local add_restriction = function(weapon_table, restricted_pylon, restricted_clsid)
        
        if weapon_table["forbidden"] == nil then
            weapon_table["forbidden"] = {}
        end

        table.insert(weapon_table["forbidden"], {
            station = restricted_pylon,
            loadout = {restricted_clsid}
        })
    end

    -- Go through all the categories and apply the restrictions
    for category, pylons in pairs(categories) do

        -- Go through each pylon to add restrictions to the "current_pylon"
        for current_pylon, current_weapons in pairs(pylons) do

            -- Go through other pylons to get the restrictions from "restricted_pylon"
            for restricted_pylon, restricted_weapons in pairs(pylons) do

                -- This precludes us restricting ourself.
                if current_pylon ~= restricted_pylon then
                    
                    -- Go through current weapons and add restrictions to "current_weapon"
                    for i1,current_weapon in ipairs(current_weapons) do
                        -- Go through other weapons on "restricted_pylon" and add them as restrictions
                        -- to current_pylons -> current_weapon
                        for i2,restricted_weapon in ipairs(restricted_weapons) do
                            local weapon_table = find_weapon_table(loadout[current_pylon], current_weapon)
                            add_restriction(weapon_table, restricted_pylon, restricted_weapon)
                        end
                    end

                end
            end
        end
    end
end


-- Collect all here first.
local weapons_loadouts = {
	[pylon_1] = create_outer_wing_loadout("left"),
	[pylon_2] = create_aim9_loadout("left", pylon_2),
	[pylon_3] = create_inner_wing_loadout("left"),
	[pylon_4] = create_aim9_loadout("left", pylon_4),
	[pylon_5] = aim7_loadout,
	[pylon_6] = merge_tables(aim7_loadout, aim7_equipment_loadout),
	[pylon_7] = create_centre_pylon_loadout(),
	[pylon_8] = aim7_loadout,
	[pylon_9] = aim7_loadout,
	[pylon_10] = create_aim9_loadout("right", pylon_10),
	[pylon_11] = create_inner_wing_loadout("right"),
	[pylon_12] = create_aim9_loadout("right", pylon_12),
	[pylon_13] = create_outer_wing_loadout("right")
}

RestrictLoadouts(weapons_loadouts)

local weapons_loadouts_QF4 = {
	[pylon_1] = create_outer_wing_loadout_QF4("left"),
	[pylon_2] = create_aim9_loadout_QF4("left", pylon_2),
	[pylon_3] = create_inner_wing_loadout_QF4("left"),
	[pylon_4] = create_aim9_loadout_QF4("left", pylon_4),
	[pylon_5] = aim7_loadout_QF4,
	[pylon_6] = merge_tables(aim7_loadout_QF4, aim7_equipment_loadout_QF4),
	[pylon_7] = create_centre_pylon_loadout_QF4(),
	[pylon_8] = aim7_loadout_QF4,
	[pylon_9] = aim7_loadout_QF4,
	[pylon_10] = create_aim9_loadout_QF4("right", pylon_10),
	[pylon_11] = create_inner_wing_loadout_QF4("right"),
	[pylon_12] = create_aim9_loadout_QF4("right", pylon_12),
	[pylon_13] = create_outer_wing_loadout_QF4("right")
}

function makeF4(rewrite_settings)

if rewrite_settings and rewrite_settings.Name == "QF-4E" then
    weapons_loadouts = weapons_loadouts_QF4
end

F4 =  {

	Name 				=   'F-4E-45MC',
	DisplayName			= _('F-4E-45MC'),
	ViewSettings			= ViewSettings,

	Picture 			= "F-4E-45-MC.png",
	Rate 				= 40, -- RewardPoint in Multiplayer
	Shape 				= "HB_F-4E",

	shape_table_data 	=
	{
		{
			file  	 = 'HB_F-4E';
			life  	 = 18; -- lifebar
			vis   	 = 3;  -- visibility gain.
			desrt    = 'su-25-oblomok'; -- Name of destroyed object file name
			fire  	 = { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username = 'F-4E-45MC';
			index    =  WSTYPE_PLACEHOLDER;
		},
		{
			name  = "su-25-oblomok";
			file  = "su-25-oblomok";
			fire  = { 240, 2};
		},

	},

	mapclasskey 		= "P0091000024",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER ,"Fighters", "Refuelable"},
	Categories 			= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},

	Navpoint_Panel = true,
	-------------------------
	M_empty 					= 14742, -- kg
	M_nominal 					= 20252, -- kg
	M_max 						= 28122, -- kg
	M_fuel_max 					= 5510.5, -- kg --Internal fuel
	H_max 					 	= 18000, -- m
	average_fuel_consumption 	= 0.85, -- this is highly relative, but good estimates are 36-40l/min = 28-31kg/min = 0.47-0.52kg/s -- 45l/min = 35kg/min = 0.583kg/s
	CAS_min 					= 60, -- if this is not OVERAL FLIGHT TIME, but jus LOITER TIME, than it sholud be 10-15 minutes.....CAS capability in minute (for AI)
	V_opt 						= 257,-- Cruise speed (for AI)
	V_take_off 					= 91, -- Take off speed in m/s (for AI)
	V_land 						= 77, -- Land speed in m/s (for AI)
	V_max_sea_level 			= 400, -- Max speed at sea level in m/s (for AI)
	V_max_h 					= 612, -- Max speed at max altitude in m/s (for AI)
	Vy_max 						= 210, -- Max climb speed in m/s (for AI)
	Mach_max 					= 2.23, -- Max speed in Mach (for AI)
	Ny_min 						= -3, -- Min G (for AI)
	Ny_max 						= 6.5,  -- Max G (for AI)
	Ny_max_e 					= 8.5,  -- Max G (for AI)
	AOA_take_off 				= 0.20, -- AoA in take off (for AI)
	bank_angle_max 				= 85, -- Max bank angle (for AI)


	has_afteburner 				= true, -- AFB yes/no
	has_speedbrake 				= true, -- Speedbrake yes/no


	tand_gear_max								=	3.73, --2.747477, -- tangent of degrees of rotation max of nose wheel steering (one side)
	nose_gear_pos								= 	{5.973, -2.552, 0},

	nose_gear_amortizer_direct_stroke			= 	0.0,
	nose_gear_amortizer_reversal_stroke			=	-0.58,		-- Full compression length
	nose_gear_amortizer_normal_weight_stroke	=	-0.48,		-- Compression at normal weight
	nose_gear_wheel_diameter 					=   0.4572, -- 18 in
	nose_gear_door_close_after_retract			=	true,

	--main_gear_pos								= 	{1.085, -2.45, -2.73},
	main_gear_pos								= 	{-1.085, -2.40, -2.73},
	main_gear_amortizer_direct_stroke			=	0.0,
	main_gear_amortizer_reversal_stroke			=	-0.40,		-- Full compression length
	main_gear_amortizer_normal_weight_stroke	=	-0.34,		-- Compression at normal weight
	main_gear_wheel_diameter 	                =   0.762, -- 30 in
	main_gear_door_close_after_retract			=	true,



	tanker_type 				= 1, -- 0 = no AAR, 1 = AAR by Boom, 2 = AAR by Basket
	wing_area 					= 49.2, -- wing area in m2
	wing_span 					= 11.7, -- wing spain in m
	wing_type 					= 0,
	thrust_sum_max 				= 5384*2, -- thrust in kg
	thrust_sum_ab 				= 8119*2, -- thrust in kg
	length 						= 19.2, -- full lenght in m
	height 						= 5.0, -- height in m
	flaps_maneuver 				= 1.0, -- Max flaps in take-off and maneuver (0.5 = 1st stage; 1.0 = 2nd stage) (for AI)
	range 						= 2000, -- Max range in km (for AI)
	RCS 						= 6, -- Radar Cross Section m2
	IR_emission_coeff 			= 0.8, -- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
	IR_emission_coeff_ab 		= 4.0, -- With afterburner
	wing_tip_pos                =  {-3.991,    0.267, -5.818}, -- wingtip coords for visual effects
	brakeshute_name 			= 0, -- Landing - brake chute visual shape after separation
	is_tanker 					= false, -- Tanker yes/no
	air_refuel_receptacle_pos 	= "AIR_REFUELING_RECEPTACLE", -- refuel coords

	engines_count				= 2, -- Engines count

	engines_nozzles = {
		[1] =
		{
			pos 		=  {-4.938,	-0.069,	-0.617}, -- nozzle coords
			elevation   =  -1.5, -- AFB cone elevation
			diameter	 = 1.0, -- AFB cone diameter
			exhaust_length_ab   = 11, -- lenght in m
			exhaust_length_ab_K = 0.8, -- AB animation
			afterburner_circles_count = 8,
			afterburner_circles_pos = {0.05, 0.8},
			afterburner_circles_scale = 1.0,
			afterburner_effect_texture = "afterburner_f-16c",
			smokiness_level = 0.55, -- 0.4 previously
		},
		[2] =
		{
			pos 		=  {4.938,	-0.069,	0.617}, -- nozzle coords
			elevation   =  -1.5, -- AFB cone elevation
			diameter	 = 1.0, -- AFB cone diameter
			exhaust_length_ab   = 11, -- lenght in m
			exhaust_length_ab_K = 0.8, -- AB animation
			afterburner_circles_count = 8,
			afterburner_circles_pos = {0.05, 0.8},
			afterburner_circles_scale = 1.0,
			afterburner_effect_texture = "afterburner_f-16c",
			smokiness_level = 0.55, -- 0.4 previously
		},
	},
	-- end of engines_nozzles

    mechanimations = {

		Door0 = {
			--{Transition = {"Close", "Open"},  Sequence = {{C = {{"Arg", 38, "to", 0.9, "in", 9.0},},},}, Flags = {"Reversible"},},
			--{Transition = {"Open", "Close"},  Sequence = {{C = {{"Arg", 38, "to", 0.0, "in", 6.0},},},}, Flags = {"Reversible", "StepsBackwards"},},
			{Transition = {"Any", "Bailout"}, Sequence = {{C = {{"JettisonCanopy", 0},},},},},
		},
		
		Door1 = {
			--{Transition = {"Close", "Open"},  Sequence = {{C = {{"Arg", 38, "to", 0.9, "in", 9.0},},},}, Flags = {"Reversible"},},
			--{Transition = {"Open", "Close"},  Sequence = {{C = {{"Arg", 38, "to", 0.0, "in", 6.0},},},}, Flags = {"Reversible", "StepsBackwards"},},
			{Transition = {"Any", "Bailout"}, Sequence = {{C = {{"JettisonCanopy", 0},},},},},
		},
		--[[
		Undercarriage = {
            {Transition = {"Close", "Open"}, Sequence = {{C = {{"Arg", 6, "to", 0.0, "in", 1.0}}}}},
			{Transition = {"Open", "Close"}, Sequence = {{C = {{"Arg", 6, "to", 1.0, "in", 1.0}}}}}
		},]]

	},

	crew_size		= 2,
	crew_stations	= "HumanOrchestra",
	crew_members	=
	{
		-- Pilot
		[1] =
		{
			pilot_name				= "F-4E_Pilot",
			ejection_seat_name		= "F-4E_Seat_Pilot",
			drop_canopy_name		= "hb_f4e_pilotcanopy",
			drop_parachute_name		= "F-4E_Parachute_Pilot",
			bailout_arg 		 	= -1,
			role					= "pilot",
			role_display_name		= _("Pilot"),
			can_be_playable			= true,

			pos						= {5, 0.8, 0},
			canopy_pos				= {5, 0.8, 0},
			ejection_added_speed	= {-3, 15, 0},

			canopy_arg				= 38,
			canopy_args				= {38, 1},
			pilot_body_arg			= 50,
			ejection_order			= 2,
			g_suit					= 2.0,
		},

		-- WSO
		[2] =
		{
			pilot_name				= "F-4E_WSO",
			ejection_seat_name		= "F-4E_Seat_WSO",
			drop_canopy_name		= "hb_f4e_wsocanopy",
			drop_parachute_name		= "F-4E_Parachute_WSO",
			bailout_arg 		 	= -1,
			role					= "instructor",
			role_display_name		= _("WSO"),
			can_be_playable			= true,

			pos						= {3.7, 1, 0},
			canopy_pos				= {3.7, 1, 0},
			ejection_added_speed	= {-3, 15, 0},
			--canopy_ejection_dir		= {-1, 1.0, 0.0},

			canopy_arg				= 700,
			canopy_args				= {700, 1},
			pilot_body_arg  	    = 701,
			ejection_order			= 1,
			g_suit					= 2.0,
		},
	},
	-- end of crew_members

	net_animation =
	{
		-- The rules what is auto-synced by ED already are quite unclear.
		-- This table is constructed mostly through manual testing of player to player (not pilot to wso).
		-- DCS can sync 16 args per frame (F-14 has ~60)
		
		38,  -- Canopy Pilot, CANOPY_Open
		700, -- Canopy WSO,   CANOPY_WSO_Open

		89,  -- Right Nozzle, ENGINES_NozzleRight
		90,  -- Left Nozzle,  ENGINES_NozzleLeft
		435, -- Right Afterburner, ENGINE_RightReheat
		436, -- Left Afterburner, ENGINE_LeftReheat

		513,	-- Aux engine door L
		514,	-- Aux engine door R

		--  NOTE This block of control surfaces is already synchronized for AI and P2P
		--  due to them being DCS default args. However, Pil2Wso sync is not covered by that naturally.
		--  Syncing the args is a temporary solution and ideally they should be computed locally for the WSO instead.

		2,   -- Nose-Gear steering, CONTROL_NoseGear_Steer_Right_To_Left
		9,   -- Flap right, CONTROL_FlapRight
		10,  -- Flap left, CONTROL_FlapLeft
		11,  -- Aileron right, CONTROL_AileronRight
		12,  -- Aileron left, CONTROL_AileronLeft
		182, -- Speed Brake left CONTROL_LeftSpeedBrake
		184, -- Speed Brake right CONTROL_RightSpeedBrake

		13,  -- Inner Slats right, CONTROL_SlatRight
		14,  -- Inner Slats left, CONTROL_SlatLeft
		131, -- Outer Slats right, CONTROL_SlatRight_Outboard
		133, -- Outer Slats left, CONTROL_SlatLeft_Outboard
		120, -- Spoiler right, CONTROL_SpoilerRight
		123, -- Spoiler left, CONTROL_SpoilerLeft
		2020, -- Tail hook, CONTROL_ArrestingHook_CUSTOM

		-- NOTE Parachute animations can be reduced in precision or moved to
		-- sounder if in need for less args send around the wire
		35,  -- Parachute open, PARACHUTE_Deploy
		36,  -- PARACHUTE_Pitch
		37,  -- PARACHUTE_Yaw
		869, -- PARACHUTE_Door
		870, -- wobble movement, PARACHUTE_Noise
		871, -- rotation, PARACHUTE_Twist
		872, -- rope and chute move down to ground, PARACHUTE_Collapse
		873, -- chute collapses "deflates", PARACHUTE_Drop
		874, -- chute crumbles and is not fully opened, PARACHUTE_Fail

		1900, -- RBF helmet stuff..
		1903, -- RBF helmet stuff..
		1910, -- RBF helmet stuff..
		1913, -- RBF helmet stuff..

		2005, -- Ground Cart, AM32A_CART_Visibility

		2006, -- Helmet cust, needed due to visibility.
		2008, -- Helmet customization, needed due to visibility.

		2010, -- Pilot visor.
		2011, -- WSO visor.
		2012, -- Sunglasses, etc
		2013, -- Sunglasses, etc, WSO

		2016, -- stache swapping
		2017, -- stashe swapping

		2018,  -- Chocks
		2019,  -- Chocks

		69,   -- Pilot Cockpit Lighting
		2601, -- WSO Cockpit Lighting

		3002, -- CUSTOM GEAR ARG - needs to be synced due to optimization arg. NOTE: Maybe will cause flashing?
		3003, -- CUSTOM GEAR ARG - needs to be synced due to optimization arg. NOTE: Maybe will cause flashing?

		3006, -- SYNC_ARG_ENGINE
		3007, -- SYNC_ARG_GPU
		3008, -- SYNC_ARG_FUEL_DUMP
		3009, -- SYNC_ARG_LIGHTS_1
		3010, -- SYNC_ARG_LIGHTS_2

		3011, -- SYNC_ARG_PILOT_HEAD_LEFT_RIGHT
		3012, -- SYNC_ARG_PILOT_HEAD_UP_DOWN
		3013, -- SYNC_ARG_WSO_HEAD_LEFT_RIGHT
		3014, -- SYNC_ARG_WSO_HEAD_UP_DOWN
		3015, -- SYNC_ARG_PILOT_LEAN_FWD_BACK
		3016, -- SYNC_ARG_WSO_LEAN_FWD_BACK
		3017, -- SYNC_ARG_WSO_LEAN_LEFT_RIGHT
		3018, -- SYNC_ARG_PILOT_LEAN_LEFT_RIGHT

		3021, -- SYNC_ARG_RUDDER_HORZ_TAIL
		3022, -- SYNC_ARG_RUDDER

		22    -- Trying to add the refueling door here to see if it fixes the syncing bug in MP.
	},

	fires_pos =
		{
			[1] = 	{0.20194864,	-0.5,	0},			--Unclear
			[2] = 	{0.00194864,	-0.5,	1.85},		--Wingroots
			[3] = 	{-0.20194864,	-0.5,	-1.85},		--Wingroots
			[4] = 	{-0.82,	0.265,	2.774},
			[5] = 	{-0.82,	0.265,	-2.774},
			--[6] = 	{-0.82,	-0.255,	4.274},				--Outer wing
			--[7] = 	{-0.82,	-0.255,	-4.274},			--Outer Wing
			[8] = 	{-4.7,	-0.3,	-0.6},				--Engine L / R
			[9] = 	{-4.7,	-0.3,	0.6},				--Engine L / R
			[10] = 	{0.304,	-0.748,	0.442},
			[11] = 	{0.304,	-0.748,	-0.442},
		--	[12] =  {-5.0,-5.0,5.0}, --was causing error in the log
		}, -- end of fires_pos


	effects_presets = {
	},

	detection_range_max		 = 60,
	radar_can_see_ground 	 = true, -- this should be examined (what is this exactly?)
	CanopyGeometry = {
		azimuth   = {-160.0, 160.0}, -- pilot view horizontal (AI)
		elevation = {-50.0, 90.0}    -- pilot view vertical (AI)
	},

	Sensors = {
		RWR = "Abstract RWR", -- RWR type
		RADAR = "HB_ANAPQ_120", -- Radar typd
	},
	laserEquipment = {
		-- TODO To mitigate issues with the AI not being able to recognize and use the Pave Spike properly (see https://heatblur.youtrack.cloud/issue/F4E-1605)
		laserDesignator = true,
		laserRangefinder = true,
	},

	HumanRadio = {
		frequency = 305.000,  -- Radio Freq
		editable = true,
		minFrequency = 225.000,
		maxFrequency = 399.950,
		modulation = MODULATION_AM
	},

	passivCounterm = {
	   CMDS_Edit = false,
	   SingleChargeTotal = 150, -- 4x30 + 2x15
	   chaff = {default = 120, increment = 1, chargeSz = 1}, -- 4x30
	   flare = {default = 30, increment = 1, chargeSz = 1}, -- 2x15
	   -- set to theoretical max of each type of cms because it is done by loadout
	},

	chaff_flare_dispenser =
	{
		{
			-- left chaff
			dir = {-1, 0, 0},
			pos = {-1, -1.2, -2.15},
		},
		{
			-- right chaff
			dir = {-1, 0, 0},
			pos = {-1, -1.2, 2.15},
		},
		{
			-- left flare
			dir = {-1, -1, 0},
			pos = {-1.3, -2.2, -2.15},
		},
		{
			-- right flare
			dir = {-1, -1, 0},
			pos = {-1.3, -2.2, 2.15},
		},
	},
	-- {backward/forward, down/up, left/right}

	Tasks = {
		aircraft_task(CAP),
        aircraft_task(Escort),
        aircraft_task(FighterSweep),
        aircraft_task(Intercept),
        aircraft_task(GroundAttack),
        aircraft_task(RunwayAttack),
        aircraft_task(PinpointStrike),
        aircraft_task(CAS),
        aircraft_task(AFAC),
        aircraft_task(SEAD),
		aircraft_task(AntishipStrike),
		aircraft_task(Reconnaissance),
    },
	DefaultTask = aircraft_task(CAP),

	SFM_Data = {
		aerodynamics = -- Cx = Cx_0 + Cy^2*B2 +Cy^4*B4
		{
			Cy0			=	0.1671,      -- zero AoA lift coefficient
			Mzalfa		=	4.355,  -- coefficients for pitch agility
			Mzalfadt	=	0.8,    -- coefficients for pitch agility
			kjx			=	2.75,
			kjz			=	0.00125,
			Czbe		=	-0.016, -- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
			cx_gear		=	0.0268,    -- coefficient, drag, gear
			cx_flap		=	0.03,   -- coefficient, drag, full flaps
			cy_flap		=	0.24,    -- coefficient, normal force, lift, flaps
			cx_brk		=	0.06,   -- coefficient, drag, breaks
			table_data  =
			{	--      M		Cx0		 Cya		B	        B4	      Omxmax	Aldop	Cymax
				[1] = 	{0,	    0.025,	0.067,	    0.162,	    0.285,	    0.36,	16,	    1.15},
                [2] = 	{0.2,	0.025,	0.067,	    0.162,	    0.285,	    0.573,	16,	    1.15},
                [3] = 	{0.5,	0.025,	0.069,	    0.162,	    0.285,	    3.584,	16,	    1.15},
                [4] = 	{0.6,	0.025,	0.070,	    0.162,	    0.285,	    5.162,	16,	    1.15},
                [5] = 	{0.7,	0.025,	0.072,	    0.162,	    0.285,	    5.103,	16,	    1.15},
                [6] = 	{0.8,	0.025,	0.074,	    0.162,	    0.285,	    4.957,	16,	    1.15},
                [7] = 	{0.9,	0.025,	0.076,	    0.163,	    0.286,	    4.752,	16,	    1.15},
                [8] = 	{0.95,	0.025,	0.078,	    0.164,	    0.288,	    4.662,	16,	    1.08},
                [9] = 	{1,	    0.031,	0.080,	    0.169,	    0.297,	    4.534,	16,	    1.08},
                [10] = 	{1.05,	0.035,	0.081,	    0.211,	    0.371,	    4.490,	16,	    1.06},
                [11] = 	{1.1,	0.037,	0.079,	    0.217,	    0.381,	    4.131,	15,	    1.04},
                [12] = 	{1.2,	0.039,	0.054,	    0.262,	    0.460,	    3.319,	14,	    1.02},
                [13] = 	{1.3,	0.039,	0.051,	    0.301,	    0.528,	    2.853,	13,	    1},
                [14] = 	{1.5,	0.040,	0.045,	    0.363,	    0.638,	    2.023,	12,	    0.9},
                [15] = 	{1.7,	0.040,	0.040,	    0.332,	    0.584,	    1.480,	11,	    0.7},
                [16] = 	{1.8,	0.040,	0.037,	    0.332,	    0.584,	    1.287,	10, 	0.64},
                [17] = 	{2,	    0.040,	0.032,	    0.332,	    0.6,	    1.128,	10,	    0.52},
                [18] = 	{2.2,	0.040,	0.029,	    0.5,	    0.7,	    1.1,	9,	    0.4},
                [19] = 	{2.5,	0.040,	0.024,	    0.7,	    0.7,	    1.1,	9,	    0.4},
                [20] = 	{3, 	0.040,	0.024,	    1.0,	    0.7,	    1.1,	9,	    0.4},
                [21] = 	{3.9,	0.040,	0.024,	    1.0,	    0.7,	    1,1,	9,	    0.4},
			}, -- end of table_data
			-- M - Mach number
			-- Cx0 - Coefficient, drag, profile, of the airplane
			-- Cya - Normal force coefficient of the wing and body of the aircraft in the normal direction to that of flight. Inversely proportional to the available G-loading at any Mach value. (lower the Cya value, higher G available) per 1 degree AOA
			-- B - Polar quad coeff
			-- B4 - Polar 4th power coeff
			-- Omxmax - roll rate, rad/s
			-- Aldop - Alfadop Max AOA at current M - departure threshold
			-- Cymax - Coefficient, lift, maximum possible (ignores other calculations if current Cy > Cymax)
		}, -- end of aerodynamics
		engine =
		{
			Nmg	    =	65, -- RPM at idle
			MinRUD	=	0, -- Min state of the throttle
			MaxRUD	=	1, -- Max state of the throttle
			MaksRUD	=	0.60, -- Military power state of the throttle
			ForsRUD	=	0.71, -- Afterburner state of the throttle
			typeng	=	1,
-- 			--[[
-- 				E_TURBOJET = 0
-- 				E_TURBOJET_AB = 1
-- 				E_PISTON = 2
-- 				E_TURBOPROP = 3
-- 				E_TURBOFAN = 4
-- 				E_TURBOSHAFT = 5
-- 			--]]

			hMaxEng	=	18,     -- Max altitude for safe engine operation in km
			dcx_eng	=	0.0144, -- Engine drag coefficient
			cemax	=	1.24,   -- not used for fuel calculation, only for AI routines to check flight time ( fuel calculation algorithm is built in )
			cefor	=	2.56,   -- not used for fuel calculation, only for AI routines to check flight time ( fuel calculation algorithm is built in )
			dpdh_m	=	7000,   -- altitude coefficient for MIL thrust; Mirage F1 lua: "Loss of thrust in N per 1000 m"
			dpdh_f	=	12300,  -- altitude coefficient for AB thrust;  Mirage F1 lua: "Loss of thrust in N per 1000 m"
			table_data =
			{   --                  M		    Pmax		Pfor
                [	1	]	=	{	0.00	,	105601 * 1,	159246 * 1	},
                [	2	]	=	{	0.40	,	108407 * 1,	175289 * 1	},
                [	3	]	=	{	0.45	,	107830 * 1,	176658 * 1	},
                [	4	]	=	{	0.50	,	107313 * 1,	178098 * 1	},
                [	5	]	=	{	0.55	,	109942 * 1,	182689 * 1	},
                [	6	]	=	{	0.60	,	112600 * 1,	187315 * 1	},
                [	7	]	=	{	0.65	,	115365 * 1,	192049 * 1	},
                [	8	]	=	{	0.70	,	118323 * 1,	196979 * 1	},
                [	9	]	=	{	0.75	,	121085 * 1,	201713 * 1	},
                [	10	]	=	{	0.80	,	123231 * 1,	205831 * 1	},
                [	11	]	=	{	0.85	,	125332 * 1,	209906 * 1	},
                [	12	]	=	{	0.90	,	127416 * 1,	213964 * 1	},
                [	13	]	=	{	0.95	,	129373 * 1,	217904 * 1	},
                [	14	]	=	{	1.00	,	131219 * 1,	221870 * 1	},
                [	15	]	=	{	1.05	,	132884 * 1,	227581 * 1	},
            }, -- end of table_data
			-- M - Mach number
			-- Pmax - Engine thrust at military power
			-- Pfor - Engine thrust at AFB
		}, -- end of engine
	},


	--Damage --------------------------------------
	Damage = verbose_to_dmg_properties(
	{
				-- Critical Damage means a part is totally inop or often ripped entirely off.
				-- Damage arguments are increased stepwise in 0.01 increments; but generally we set light at 0.25, medium at 0.5, heavy at 0.7 and ripped off at 1.0.
				-- Some things are already gone at 0.7 though; e.g. the Vertical Stab at 0.7 (heavy) is missing the rudder.
				-- If a part is critically damaged, it will also fail the dependency (i.e. inner wing will rip off outer wing).

				--PILOTS - Is this needed or automatic? Can't remember.
				["CREW_1"]                  = {critical_damage = 7},   --Pilot
				["CREW_2"]                  = {critical_damage = 7},   --WSO - Needed for Jester to die.

				--MAIN-----------------------------------------------------------------------------------
				["FRONT"]					= {args = {3204}, critical_damage = 3, deps_cells = {"PILOT_PROBE"}},-- Nosecone.

				["COCKPIT"]					= {args = {65},  critical_damage = 6},								-- "Cockpit" - Needed for pilots to die.

				["FUSELAGE_LEFT_SIDE"]		= {args = {3202}, critical_damage = 5},								-- FUSELAGE_LEFT_SIDE
				["FUSELAGE_RIGHT_SIDE"]		= {args = {3203}, critical_damage = 5},								-- FUSELAGE_RIGHT_SIDE
				["FUSELAGE_TOP"]			= {args = {3217}, critical_damage = 5},
				["FUSELAGE_BOTTOM"]			= {args = {3205}, critical_damage = 5},

				["TAIL"]					= {args = {3200}, critical_damage = 7, deps_cells = {"RUDDER", "STABILIZATOR_L", "STABILIZATOR_R"}}, 	-- Main Tail Part - Rudder/VSTab as a dependency.

				["GUN"]			= {critical_damage = 2},
				["DASHBOARD_PILOT"]			= {critical_damage = 3},
				["DASHBOARD_WSO"]			= {critical_damage = 3},
				["EJECTION_SEAT_PILOT"]		= {critical_damage = 5},
				["EJECTION_SEAT_WSO"]		= {critical_damage = 5},

				["PaveSpike_Main"]		= {critical_damage = 2},
				["PaveSpike_Head"]		= {args = {615}, critical_damage = 2},
				["PaveSpike_Body"]		= {args = {617}, critical_damage = 2},
				["PaveSpike_Tail"]		= {args = {616}, critical_damage = 2},

				--The following main fuselage parts are custom (non ED)
				["ENGINE_L"]				= {args = {3218}, critical_damage = 3},
				["ENGINE_R"]				= {args = {3219}, critical_damage = 3},
				["FUSELAGE_REAR_TOP"]		= {args = {3220}, critical_damage = 6},												--This one is custom (non ED - beware.)

				--LEFT WING--------------------------------------------------------------------------------------------------------------------------
				["WING_L_IN"]				= {args = {3207}, critical_damage = 7
					, deps_cells = {"WING_L_OUT", "FLAP_L", "FUEL_TANK_LEFT_SIDE", "FLAPERON_L_01", "FLAPERON_L_02", "WING_L_IN_SLAT"
					,"Airbrake_L","PYLON_01","PYLON_02"}},	    -- Inner Wing Left Side
				["WING_L_OUT"]				= {args = {3206}, critical_damage = 4, deps_cells = { "WING_L_OUT_SLAT" }},		-- Left Outer Wing- Past wingfold
				--["AILERON_L"]				= {args = {998}, critical_damage = 3},											-- Left Aileron- we have flaperons
				["FLAP_L"]					= { critical_damage = 2},										                -- Left Flap --args = {227},

				--RIGHT WING-------------------------------------------------------------------------------------------------
				["WING_R_IN"]				= {args = {3208}, critical_damage = 7
					, deps_cells = {"WING_R_OUT", "FLAP_R", "FUEL_TANK_RIGHT_SIDE", "FLAPERON_R_01", "FLAPERON_R_02", "WING_R_IN_SLAT"
					,"Airbrake_R", "PYLON_03","PYLON_04"}},	    -- Inner Right Wing - R Outer is dep.
				["WING_R_OUT"]				= {args = {3209}, critical_damage = 4, deps_cells = { "WING_R_OUT_SLAT" }},		-- Outer Right Wing (past wingfold)
			--	["AILERON_R"]				= {args = {216}, critical_damage = 3},											-- Right Aileron
				["FLAP_R"]				    = { critical_damage = 2},											            -- Right Flap --args = {801},

				-- PYLONS -----------------------------------------------------------------------------------------------------
				["PYLON_01"]				= {critical_damage = 2},	--Left Inner
				["PYLON_02"]				= {critical_damage = 2},	--Left Outer
				["PYLON_03"]				= {critical_damage = 2},	--Right Inner
				["PYLON_04"]				= {critical_damage = 2},	--Right outer.

			-- HORIZONTAL STABS -----------------------------------------------------------------
				["STABILIZATOR_L"]			= {args = {3213}, critical_damage = 6},										-- Left HSTab
				["STABILIZATOR_R"]			= {args = {3214}, critical_damage = 6},										-- Right HSTab

			--VERTICAL TAILPLANE--------------------------------------------------------
				["RUDDER"]					= {args = {3201}, critical_damage = 6, deps_cells = {"RUDDER_01", "Stab_feel_probe"}},			-- Not Really Rudder - The entire vertical stabilizer!

			--TIRES-----------------------------------------------------------------------
				["WHEEL_F"]					= {args = {134}, critical_damage = 3},										-- WHEEL_F TODO: Check all these tires.
				["WHEEL_L"]					= {args = {136}, critical_damage = 3},										-- WHEEL_L TODO: Check all these tires.
				["WHEEL_R"]					= {args = {135}, critical_damage = 3},										-- WHEEL_R TODO: Check all these tires.

				--New cells
				["Airbrake_L"] = {critical_damage = 2},
				["Airbrake_R"] = {critical_damage = 2},
				["AOA_Probe"] = {critical_damage = 1},
				["COCKPIT_SIDEWALL_L"] = {critical_damage = 3},
				["COCKPIT_SIDEWALL_R"] = {critical_damage = 3},
				["ENGINE_L_AB"] = {critical_damage = 3},
				["Engine_L_Compressor"] = {critical_damage = 3},
				["Engine_L_Equipment"] = {critical_damage = 3},
				["Engine_L_Gen"] = {critical_damage = 3},
				["ENGINE_L_Main"] = {critical_damage = 3},
				["Engine_L_Pump"] = {critical_damage = 3},
				["ENGINE_R_AB"] = {critical_damage = 3},
				["Engine_R_Compressor"] = {critical_damage = 3},
				["Engine_R_Equipment"] = {critical_damage = 3},
				["Engine_R_Gen"] = {critical_damage = 3},
				["ENGINE_R_Main"] = {critical_damage = 3},
				["Engine_R_Pump"] = {critical_damage = 3},
				["EQUIPMENT_BAY_1"] = {critical_damage = 2},
				["FLAPERON_L_01"] = {critical_damage = 3},
				["FLAPERON_L_02"] = {critical_damage = 3},
				["FLAPERON_R_01"] = {critical_damage = 3},
				["FLAPERON_R_02"] = {critical_damage = 3},
				["FUEL_TANK_01"] = {critical_damage = 2},
				["FUEL_TANK_03"] = {critical_damage = 2},
				["FUEL_TANK_04"] = {critical_damage = 2},
				["FUEL_TANK_05"] = {critical_damage = 2},
				["FUEL_TANK_06"] = {critical_damage = 2},
				["FUEL_TANK_07"] = {critical_damage = 2},
				["FUEL_TANK_LEFT_SIDE"] = {critical_damage = 2},
				["FUEL_TANK_RIGHT_SIDE"] = {critical_damage = 2},
				["Internal_Belly_01"] = {critical_damage = 3},
				["Internal_Belly_02"] = {critical_damage = 3},
				["Internal_Belly_03"] = {critical_damage = 3},
				["PILOT_PROBE"] = {critical_damage = 2},
				["RUDDER_01"] = {critical_damage = 2},
				["STAB_CONTROLS"] = {critical_damage = 3},
				["Stab_feel_probe"] = {critical_damage = 2},
				["TAILHOOK"] = {critical_damage = 3},
				["WING_L_IN_SLAT"] = {critical_damage = 3},
				["WING_L_OUT_SLAT"] = {critical_damage = 3},
				["WING_R_IN_SLAT"] = {critical_damage = 3},
				["WING_R_OUT_SLAT"] = {critical_damage = 3},
	}),


	DamageParts =
	{
		--Parts that can fall off and their .edm models.
		--Parts that can fall off and their .edm models.
		[1000 + 36] = "F-4E_DMG_Wing_In_R",			-- Wing in R
		[1000 + 35] = "F-4E_DMG_Wing_In_L", 			-- Wing in L
		[1000 + 24] = "F-4E_DMG_Wing_Out_R", 		--Wing out R
		[1000 + 23] = "F-4E_DMG_Wing_Out_L", 		--Wing out L
		[1000 + 47] = "F-4E_DMG_H_Stab_L", 		--H stab L
		[1000 + 48] = "F-4E_DMG_H_Stab_R", 		--H stab R
		[4] = "F-4E_DMG_Tail", 		--Tail

		--[1000 + 37] = "DMG_AJS37_LCANARD",

		--damage_cells["AILERON_R"] = 26
		--damage_cells["FLAP_L"] = 37
		--damage_cells["FLAP_R"] = 38 AJS37-part-canardflap
		--damage_cells["ELEVATOR_L_IN"] = 51
		--damage_cells["ELEVATOR_R_IN"] = 52
	},

		Failures = {
		{ id = '/F-4E-45-MC/Air Data Computer:Total Failure',	  	  label = _('Air Data Computer: Total'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Air Data Computer/Altitude Encoder:Altitude Encoder Failed',	  	  	label = _('Air Data Computer: Altitude Encoder'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Air Data Computer/Static Pressure Compensator/On-Off logic Calculator:SPC Failed',	  	  	label = _('Air Data Computer: Static Pressure Compensator'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/UHF Radio/UHF Radio:UHF ARC 164 Radio Failed',	  	  label = _('UHF Radio: Total'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/ASN-63/Mode Logic:Failed',	  	  label = _('INS: Total'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Cockpit/Pilot Right Console/Radio Panel/Panel Logic:Panel failed',	  	  label = _('UHF Radio: Pilot Module'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Cockpit/WSO Left Console/Radio Panel/Panel Logic:Panel failed',	  	  label = _('UHF Radio: WSO Module'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/UHF Radio:Upper Antenna Damaged',	  	  label = _('UHF Radio: Upper Antenna'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/UHF Radio:Lower Antenna Damaged',	  	  label = _('UHF Radio: Lower Antenna'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/UHF Radio/ADF:ADF Damaged',	  	  label = _('UHF Radio: ADF'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Cockpit/Pilot Left Console/Intercom Panel:Full Damage',	  	  label = _('Intercom Total Damage: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Cockpit/Pilot Left Console/Intercom Panel:Normal Amplifier Failure',	  	  label = _('Intercom Normal Amplifier: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Cockpit/Pilot Left Console/Intercom Panel:Backup Amplifier Failure',	  	  label = _('Intercom Backup Amplifier: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Cockpit/Pilot Left Console/Intercom Panel:Internal Failure',	  	  label = _('Intercom Internal Failure: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Cockpit/Pilot Left Console/Intercom Panel:Microphone Failure',	  	  label = _('Microphone: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Cockpit/WSO Left Console/Intercom Panel:Full Damage',	  	  label = _('Intercom Total Damage: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Cockpit/WSO Left Console/Intercom Panel:Normal Amplifier Failure',	  	  label = _('Intercom Normal Amplifier: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Cockpit/WSO Left Console/Intercom Panel:Backup Amplifier Failure',	  	  label = _('Intercom Backup Amplifier: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Cockpit/WSO Left Console/Intercom Panel:Internal Failure',	  	  label = _('Intercom Internal Failure: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Cockpit/WSO Left Console/Intercom Panel:Microphone Failure',	  	  label = _('Microphone: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/TACAN/Tacan Transmitter-Receiver:Total Damage',	  	  label = _('TACAN: Total'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Cockpit/Pilot Right Console/TACAN Panel:Panel failed',	  	  label = _('TACAN: Pilot Module'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Cockpit/WSO Left Console/TACAN Panel:Panel failed',	  	  label = _('TACAN: WSO Module'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/TACAN/Tacan Transmitter-Receiver:Transmitter Damage',	  	  label = _('TACAN: Transmitter'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/TACAN/Tacan Transmitter-Receiver:Receiver Damage',	  	  label = _('TACAN: Receiver'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Navigation Computer:Nav Comp Damaged',	  	  	label = _('Navigation Computer: Total'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
        { id = '/F-4E-45-MC/Navigation Computer/Test Cap Off Light:NAV Comp Test Cap failed',	  	  	label = _('Navigation Computer: Test Cap'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
        { id = '/F-4E-45-MC/Ground Speed Indicator:Ground Speed Indicator Stuck',	  	  	label = _('Ground Speed Indicator'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Accelerometer:G-Meter Stuck',	  	  	label = _('Accelerometer: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Accelerometer:G-Meter Stuck',	  	  	label = _('Accelerometer: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot True Airspeed Indicator:True Airspeed Indicator Stuck',	  	  	label = _('True Airspeed Indicator: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO True Airspeed Indicator:True Airspeed Indicator Stuck',	  	  	label = _('True Airspeed Indicator: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Vertical Velocity Indicator/Vertical Velocity Meter:Vertical Velocity Indicator Stuck',	  	  	label = _('Vertical Velocity Indicator stuck: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Vertical Velocity Indicator/Vertical Velocity Meter/Vertical Speed From Pressure Calculator:Vertical Velocity Indicator Calibrated Leak Clogged',	  	  	label = _('Vertical Velocity Indicator calibrated leak clogged: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Vertical Velocity Indicator/Vertical Velocity Meter/Vertical Speed From Pressure Calculator:Vertical Velocity Indicator Pressure Leak Clogged',	  	  	label = _('Vertical Velocity Indicator pressure leak clogged: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Vertical Velocity Indicator/Vertical Velocity Meter:Vertical Velocity Indicator Stuck',	  	  	label = _('Vertical Velocity Indicator stuck: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Vertical Velocity Indicator/Vertical Velocity Meter/Vertical Speed From Pressure Calculator:Vertical Velocity Indicator Calibrated Leak Clogged',	  	  	label = _('Vertical Velocity Indicator calibrated leak clogged: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Vertical Velocity Indicator/Vertical Velocity Meter/Vertical Speed From Pressure Calculator:Vertical Velocity Indicator Pressure Leak Clogged',	  	  	label = _('Vertical Velocity Indicator pressure leak clogged: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Servoed Altimeter:Altimeter Stuck',	  	  	label = _('Altimeter Stuck: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Servoed Altimeter/Altitude Meter/Operation Mode Logic:Electric Servo Failed',	  	  	label = _('Altimeter - Electric Servo failed: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Servoed Altimeter/Altitude Meter/Output Calculator:Needle Stuck',	  	  	label = _('Altimeter - Needle Stuck: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Servoed Altimeter/Altitude Meter/Output Calculator:Altitude Rollers Stuck',	  	  	label = _('Altimeter - Altitude Rollers Stuck: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Servoed Altimeter/Altitude Meter/Output Calculator:Pressure Set Rollers Stuck',	  	  	label = _('Altimeter - Reference Pressure Rollers Stuck: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Servoed Altimeter/Reference Pressure Knob:Broken',	  	  	label = _('Altimeter - Reference Pressure Knob Broken: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Servoed Altimeter/Three Position Switch:Broken',	  	  	label = _('Altimeter - 3-Pos Switch Broken: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Servoed Altimeter:Altimeter Stuck',	  	  	label = _('Altimeter Stuck: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Servoed Altimeter/Altitude Meter/Operation Mode Logic:Electric Servo Failed',	  	  	label = _('Altimeter - Electric Servo failed: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Servoed Altimeter/Altitude Meter/Output Calculator:Needle Stuck',	  	  	label = _('Altimeter - Needle Stuck: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Servoed Altimeter/Altitude Meter/Output Calculator:Altitude Rollers Stuck',	  	  	label = _('Altimeter - Altitude Rollers Stuck: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Servoed Altimeter/Altitude Meter/Output Calculator:Pressure Set Rollers Stuck',	  	  	label = _('Altimeter - Reference Pressure Rollers Stuck: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Servoed Altimeter/Reference Pressure Knob:Broken',	  	  	label = _('Altimeter - Reference Pressure Knob Broken: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
	    { id = '/F-4E-45-MC/WSO Servoed Altimeter/Three Position Switch:Broken',	  	  	label = _('Altimeter - 3-Pos Switch Broken: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
	    { id = '/F-4E-45-MC/Pilot Mach And Airspeed Indicator:Mach And Airspeed Stuck',	  	  	label = _('Mach And Airspeed Indicator: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Mach And Airspeed Indicator:Mach And Airspeed Stuck',	  	  	label = _('Mach And Airspeed Indicator: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Bearing Distance Heading Indicator/BDHI Meter:BDHI Stuck',	  	  	label = _('BDHI'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Horizontal Situation Indicator/HSI Meter:HSI Stuck',	  	  	label = _('HSI'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Attitude Indicator (Rear Cockpit)/Meter:Attitude Indicator Stuck',	  	  	label = _('Attitude Indicator: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Angle Of Attack Indicator Pilot/Servo:AoA Indicator Failure',	  	  	label = _('Angle Of Attack Indicator: Pilot'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Angle Of Attack Indicator WSO/Servo:AoA Indicator Failure',	  	  	label = _('Angle Of Attack Indicator: WSO'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Main ADI:Failed',	  	  	label = _('ADI'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Landing Gear/Left Main Landing Gear/Side Brace Actuator/Actuator:Mechanical Failure',	  	  	label = _('Left Main Landing Gear Actuator Mechanical Failure'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Landing Gear/Right Main Landing Gear/Side Brace Actuator/Actuator:Mechanical Failure',	  	  	label = _('Right Main Landing Gear Actuator Mechanical Failure'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Landing Gear/Nose Landing Gear/Drag Brace Actuator/Actuator:Mechanical Failure',	  	  	label = _('Nose Landing Gear Actuator Mechanical Failure'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Seat:Seat Motor Overheated', label = _('Seat Motor: Pilot'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Seat:Seat Motor Overheated', label = _('Seat Motor: WSO'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/KY-28:Failure',	  	  label = _('KY28: Total Failure'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/IFF Transponder:Failure',	  	  label = _('IFF Transponder: Total Failure'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Weapons/Nosegun:Gun Damage', label = _('Gun Damage'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Hud:HUD Damage', label = _('HUD Damage'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Aural Tone System:Aural Tone Damage', label = _('Aural Tone Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Aural Tone System:Stall Vibrator Damage', label = _('Stall Vibrator Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Airborne Video Tape Recorder (AVTR):AVTR Damage', label = _('AVTR Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/IFF Interrogator System:IFF Interrogator Damage', label = _('IFF Interrogator Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/UHF Remote Indicator Pilot:Frequency Channel Indicator Damage', label = _('Frequency Channel Indicator Pilot Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/UHF Remote Indicator WSO:Frequency Channel Indicator Damage', label = _('Frequency Channel Indicator WSO Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Cockpit/Pilot Right Console/Interior Lights:Interior Light Damage', label = _('Interior Light Pilot Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Cockpit/WSO Right Console/Interior Lights:Interior Light Damage', label = _('Interior Light WSO Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Cockpit/Pilot Front Panel/VOR ILS:VOR ILS Malfunction', label = _('VOR ILS System Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Cockpit/Pilot Front Panel/VOR ILS/Pilot ARN-127 Aural Tone Generator:VOR ILS Aural Tone Generator Malfunction', label = _('VOR ILS Tone Generator Pilot Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Cockpit/Pilot Front Panel/VOR ILS/WSO ARN-127 Aural Tone Generator:VOR ILS Aural Tone Generator Malfunction', label = _('VOR ILS Tone Generator WSO Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Cockpit/Pilot Front Panel/VOR ILS/VOR ARN-127 Positioning Aid:VOR Receiver Malfunction', label = _('VOR Receiver Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Pilot Cockpit/Pilot Front Panel/VOR ILS/ILS ARN-127 Landing Aid:ILS Antenna Malfunction', label = _('ILS Antenna Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Exterior Lights/Taxi Light Damage:HitDamage', label = _('Taxi Light Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Exterior Lights/Landing Light Damage:HitDamage', label = _('Landing Light Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Exterior Lights/Formation Lights Left Damage:HitDamage', label = _('Formation Lights Left Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Exterior Lights/Formation Lights Right Damage:HitDamage', label = _('Formation Lights Right Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Exterior Lights/Refueling Light Damage:HitDamage', label = _('Refueling Light Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Exterior Lights/Wing Pos Light Left Damage:HitDamage', label = _('Wing Pos Light Left Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Exterior Lights/Wing Pos Light Right Damage:HitDamage', label = _('Wing Pos Light Right Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Exterior Lights/Joinup Light Left Damage:HitDamage', label = _('Joinup Light Left Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Exterior Lights/Joinup Light Right Damage:HitDamage', label = _('Joinup Light Right Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Exterior Lights/Tail Pos Light Damage:HitDamage', label = _('Tail Pos Light Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Exterior Lights/Anti-Coll Lights Damage:HitDamage', label = _('Anti-Coll Lights Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Exterior Lights/Fuselage Light Top Damage:HitDamage', label = _('Fuselage Light Top Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Exterior Lights/Fuselage Lights Bottom Damage:HitDamage', label = _('Fuselage Lights Bottom Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Cockpit/WSO Front Panel/ECM System Left:ECM Broken', label = _('ECM System Left Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/WSO Cockpit/WSO Front Panel/ECM System Right:ECM Broken', label = _('ECM System Right Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/EO TGT Designator System/Pave Spike/Cooling Damage:HitDamage', label = _('Pave Spike Cooling Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/EO TGT Designator System/Pave Spike/Camera Damage:HitDamage', label = _('Pave Spike Camera Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/EO TGT Designator System/Pave Spike:System Damage', label = _('Pave Spike System Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/EO TGT Designator System/Target Designator Set Control:Damage', label = _('Target Designator Set Control Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/EO TGT Designator System/Laser Coder Control:Damage', label = _('Laser Coder Control Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/EO TGT Designator System/Range Indicator:Damage', label = _('Range Indicator Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/EO TGT Designator System/Azimuth Elevation Indicator:Damage', label = _('Azimuth Elevation Indicator Failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Left Engine/Fire Detection:Engine Fire', label = _('Left Engine Fire'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Left Engine/Engine Oil System:Oil Leak', label = _('Left Engine Oil Leak'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Left Engine/Spool Dynamics:Seizure', label = _('Left Engine Seize'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Left Engine/Nozzle Controller:Failure', label = _('Left Engine Nozzle Control'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Left Engine/Gas Generator:Compressor Stall', label = _('Left Engine Compressor Stall'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Right Engine/Fire Detection:Engine Fire', label = _('Right Engine Fire'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Right Engine/Engine Oil System:Oil Leak', label = _('Right Engine Oil Leak'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Right Engine/Spool Dynamics:Seizure', label = _('Right Engine Seize'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Right Engine/Nozzle Controller:Failure', label = _('Right Engine Nozzle Control'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = '/F-4E-45-MC/Right Engine/Gas Generator:Compressor Stall', label = _('Right Engine Compressor Stall'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },

		},
		--************** EDITOR CUSTOM SUBMENU ***************

		panelRadio = {
			[1] = {
				name = _("UHF AN/ARC-164 COMM channels"),
				range = {min = 225.0, max = 399.95},
				channels = {
					[1] = { name = _("COMM Channel 1"), default = 305.0, modulation = _("AM"), connect = true}, -- default
					[2] = { name = _("COMM Channel 2"), default = 264.0, modulation = _("AM")},
					[3] = { name = _("COMM Channel 3"), default = 265.0, modulation = _("AM")},
					[4] = { name = _("COMM Channel 4"), default = 256.0, modulation = _("AM")},
					[5] = { name = _("COMM Channel 5"), default = 254.0, modulation = _("AM")},
					[6] = { name = _("COMM Channel 6"), default = 250.0, modulation = _("AM")},
					[7] = { name = _("COMM Channel 7"), default = 270.0, modulation = _("AM")},
					[8] = { name = _("COMM Channel 8"), default = 257.0, modulation = _("AM")},
					[9] = { name = _("COMM Channel 9"), default = 255.0, modulation = _("AM")},
					[10] = { name = _("COMM Channel 10"), default = 262.0, modulation = _("AM")},
					[11] = { name = _("COMM Channel 11"), default = 259.0, modulation = _("AM")},
					[12] = { name = _("COMM Channel 12"), default = 268.0, modulation = _("AM")},
					[13] = { name = _("COMM Channel 13"), default = 269.0, modulation = _("AM")},
					[14] = { name = _("COMM Channel 14"), default = 260.0, modulation = _("AM")},
					[15] = { name = _("COMM Channel 15"), default = 263.0, modulation = _("AM")},
					[16] = { name = _("COMM Channel 16"), default = 261.0, modulation = _("AM")},
					[17] = { name = _("COMM Channel 17"), default = 267.0, modulation = _("AM")},
					[18] = { name = _("COMM Channel 18"), default = 251.0, modulation = _("AM")},
				}
			},
			[2] = {
				name = _("UHF AN/ARC-164 AUX channels"),
				range = {min = 265.0, max = 284.9},
				channels = {
					[1] = { name = _("AUX Channel 1"), default = 284.0, modulation = _("AM"),}, -- default
					[2] = { name = _("AUX Channel 2"), default = 283.0, modulation = _("AM")},
					[3] = { name = _("AUX Channel 3"), default = 265.0, modulation = _("AM")},
					[4] = { name = _("AUX Channel 4"), default = 281.0, modulation = _("AM")},
					[5] = { name = _("AUX Channel 5"), default = 280.0, modulation = _("AM")},
					[6] = { name = _("AUX Channel 6"), default = 279.0, modulation = _("AM")},
					[7] = { name = _("AUX Channel 7"), default = 270.0, modulation = _("AM")},
					[8] = { name = _("AUX Channel 8"), default = 277.0, modulation = _("AM")},
					[9] = { name = _("AUX Channel 9"), default = 276.0, modulation = _("AM")},
					[10] = { name = _("AUX Channel 10"), default = 275.0, modulation = _("AM")},
					[11] = { name = _("AUX Channel 11"), default = 274.0, modulation = _("AM")},
					[12] = { name = _("AUX Channel 12"), default = 268.0, modulation = _("AM")},
					[13] = { name = _("AUX Channel 13"), default = 269.0, modulation = _("AM")},
					[14] = { name = _("AUX Channel 14"), default = 271.0, modulation = _("AM")},
					[15] = { name = _("AUX Channel 15"), default = 278.0, modulation = _("AM")},
					[16] = { name = _("AUX Channel 16"), default = 273.0, modulation = _("AM")},
					[17] = { name = _("AUX Channel 17"), default = 267.0, modulation = _("AM")},
					[18] = { name = _("AUX Channel 18"), default = 272.0, modulation = _("AM")},
					[19] = { name = _("AUX Channel 19"), default = 282.0, modulation = _("AM")},
					[20] = { name = _("AUX Channel 20"), default = 266.0, modulation = _("AM")},
				}
			},
		},
		TACAN_AA	= true,

		Guns = { m61a1() },

		ammo_type ={ _("20mm HEI"),
                 _("20mm API"),
                 _("20mm AP&HE"),
                 _("20mm TP"),
		},

		Pylons = {
		-- Left Outer Pylon:
		 pylon(pylon_1, 0, 1.613, -0.639, 2.071,
             {
                DisplayName = pylon_names[pylon_1],
                connector = "PNT_PYLON_1B",
                use_full_connector_position = true,
				arg = args_info.outer.left_arg,
				arg_value = args_info.outer.positions.weapon,
             },
             weapons_loadouts[pylon_1]
		 ),
		-- Left Inner Pylon (left spacer):
		 pylon(pylon_2, 0, -0.221000, -0.882000, -1.487000,
			{
				DisplayName = pylon_names[pylon_2],
				connector = "PNT_PYLON_2A",
				use_full_connector_position = true,
				arg = args_info.sidewinder.left_arg_outer,
				arg_value = args_info.sidewinder.positions.weapon,
			},
			weapons_loadouts[pylon_2]
         ),
			-- Left Inner Pylon (middle):
		 pylon(pylon_3, 0, -0.221000, -0.882000, -1.487000,
			{
				DisplayName = pylon_names[pylon_3],
				connector = "PNT_PYLON_2",
				use_full_connector_position = true,
				arg = args_info.inner.left_arg,
				arg_value = args_info.inner.positions.weapon,
			},
			weapons_loadouts[pylon_3]
		 ),
			-- Left Inner Pylon (right spacer):
		 pylon(pylon_4, 0, -0.221000, -0.882000, -1.487000,
			{
				DisplayName = pylon_names[pylon_4],
				connector = "PNT_PYLON_2B",
				use_full_connector_position = true,
				arg = args_info.sidewinder.left_arg_inner,
				arg_value = args_info.sidewinder.positions.weapon,
			},
			weapons_loadouts[pylon_4]
		 ),
		 -- Left Rear Pylon:
         pylon(pylon_5, 1, 2.749000, -0.462000, -0.520000,
			{
				DisplayName = pylon_names[pylon_5],
				connector = "PNT_AIM7_3",
				use_full_connector_position = true,
			},
			weapons_loadouts[pylon_5]
         ),
		 -- Left Forward Pylon:
         pylon(pylon_6, 1, -1.783000, -0.385000, -0.520000,
			{
				DisplayName = pylon_names[pylon_6],
				connector = "PNT_AIM7_4",
				use_full_connector_position = true,
			},
			weapons_loadouts[pylon_6]
         ),
		 -- Central Pylon:
         pylon(pylon_7, 1, -1.783000, -0.385000, 0.492000,
			{
				DisplayName = pylon_names[pylon_7],
				connector = "PNT_PYLON_5B",
				use_full_connector_position = true,
				arg = args_info.centre.arg,
				arg_value = args_info.centre.positions.empty,
			},
			weapons_loadouts[pylon_7]
         ),
		 -- Right Front Pylon:
         pylon(pylon_8, 1, 2.749000, -0.462000, 0.492000,
			{
				DisplayName = pylon_names[pylon_8],
				connector = "PNT_AIM7_6",
				use_full_connector_position = true,
			},
			weapons_loadouts[pylon_8]
         ),
		 -- Right Rear Pylon:
         pylon(pylon_9, 1, -0.221000, -0.882000, 1.487000,
			{
				DisplayName = pylon_names[pylon_9],
				connector = "PNT_AIM7_7",
				use_full_connector_position = true,
			},
			weapons_loadouts[pylon_9]
         ),
		 -- Right Inner Pylon (Left Spacer):
         pylon(pylon_10, 0, 0.900000, -0.230000, 3.125000,
			{
				DisplayName = pylon_names[pylon_10],
				connector = "PNT_PYLON_8A",
				use_full_connector_position = true,
				arg = args_info.sidewinder.right_arg_inner,
				arg_value = args_info.sidewinder.positions.weapon,
			},
			weapons_loadouts[pylon_10]
         ),
			-- Right Inner Pylon:
		 pylon(pylon_11, 0, 0.900000, -0.230000, 3.125000,
			{
				DisplayName = pylon_names[pylon_11],
				connector = "PNT_PYLON_8",
				use_full_connector_position = true,
				arg = args_info.inner.right_arg,
				arg_value = args_info.inner.positions.weapon,
			},
			weapons_loadouts[pylon_11]
		 ),
		 -- Right Inner Pylon (Right Spacer):
		 pylon(pylon_12, 0, 0.900000, -0.230000, 3.125000,
			{
				DisplayName = pylon_names[pylon_12],
				connector = "PNT_PYLON_8B",
				use_full_connector_position = true,
				arg = args_info.sidewinder.right_arg_outer,
				arg_value = args_info.sidewinder.positions.weapon,
			},
			weapons_loadouts[pylon_12]
		 ),
		 -- Right Outer Pylon:
         pylon(pylon_13, 0, 0.900000, -0.230000, 3.125000,
			{
				DisplayName = pylon_names[pylon_13],
				connector = "PNT_PYLON_9B",
				use_full_connector_position = true,
				arg = args_info.outer.right_arg,
				arg_value = args_info.outer.positions.weapon,
			},
			weapons_loadouts[pylon_13]
         ),
		 -- Flare/Chaff Pylon:
		 pylon(pylon_14, 1, -0.2, -0.9, 0,
		 {
			 DisplayName = pylon_names[pylon_14],
			 --connector = "PNT_PYLON_9B",
			 --use_full_connector_position = true,
			 arg = 510,
			 arg_value = 0.0,
		 },
		 create_flare_chaff_loadout()
	  )
		},

   		AddPropAircraft = {
   		    { id = "Quality" , control = 'spinbox', label = _('Aircraft Condition'), defValue = 100, min = 0, max = 100, playerOnly = true},
   		    { id = "Wear" , control = 'spinbox', label = _('Aircraft Wear and Tear'), defValue = 0, min = 0, max = 100, playerOnly = true},
            { id = "UseReferenceAircraft", control = 'comboList', label = _('Aircraft Type On Spawn'), defValue = 0, values = { {id = 0, dispName = _("Random")}, {id =  1, dispName = _("Reference") }, {id =  2, dispName = _("Persistent") } }, playerOnly = true}, --leave old id so that missions are not destroyed
			{ id = "INSAlignmentStored", control = 'checkbox', label = _('INS Reference Alignment Stored'), defValue = true, playerOnly = true},
        	{ id = "PersistentAircraftKey", control = 'editbox',  label = _('Persistent Aircraft Key'), defValue = "", maxLength = 128, playerOnly = true},
	        { id = "IsModifiedJesterAllowed", control = 'checkbox', label = _('Allow Jester Modifications'), defValue = true, playerOnly = true},
	        { id = "IsNvgAllowed", control = 'checkbox', label = _('Allow Night Vision Goggles'), defValue = true, playerOnly = true},
	        { id = "IsEfbAllowed", control = 'checkbox', label = _('Allow use of EFB'), defValue = true, playerOnly = true},
	        { id = "CombatTreeSpoofable", control = 'comboList', label = _('Combat-Tree Spoofable'), defValue = 2, values = { {id = 0, dispName = _("All")}, {id =  1, dispName = _("Historical") }, {id =  2, dispName = _("None") } }, playerOnly = true},
			{ id = "TacanChannel" , control = 'spinbox', label = _('TACAN Channel Presel (0 = Auto)'), defValue = 0, min = 0, max = 126, playerOnly = true},
			{ id = "TacanBand", control = 'comboList', label = _('TACAN Band'), defValue = 0, values = { {id =  0, dispName = _("X")}, {id =  1, dispName = _("Y") } }, playerOnly = true},
			{ id = "VORILSFrequencyMHZ" , control = 'spinbox', label = _('VOR/ILS Frequency [MHz]'), defValue = 108, min = 108, max = 117, playerOnly = true},
			{ id = "VORILSFrequencyDecimalMHZ" , control = 'comboList', label = _('VOR/ILS Frequency [decimal MHz]'), defValue = 0, values = ils_decimal_frequencies, playerOnly = true},
			{ id = "KY28Key" , control = 'spinbox', label = _('KY-28 Encryption Key'), defValue = 1, min = 1, max = 255, playerOnly = true},
            { id = "ChaffDoubleDispense", control = 'checkbox', label = _('Chaff Double Dispense'), defValue = false, playerOnly = true},
            { id = "IffMode2Digit1", control = 'spinbox',  label = _('IFF Mode 2 Code 1st Digit'), defValue = 0, min = 0, max = 7, dimension = ' ', playerOnly = true},
            { id = "IffMode2Digit2", control = 'spinbox',  label = _('IFF Mode 2 Code 2nd Digit'), defValue = 0, min = 0, max = 7, dimension = ' ', playerOnly = true},
            { id = "IffMode2Digit3", control = 'spinbox',  label = _('IFF Mode 2 Code 3rd Digit'), defValue = 0, min = 0, max = 7, dimension = ' ', playerOnly = true},
            { id = "IffMode2Digit4", control = 'spinbox',  label = _('IFF Mode 2 Code 4th Digit'), defValue = 0, min = 0, max = 7, dimension = ' ', playerOnly = true},
            { id = "LaserCodeDigit1", control = 'spinbox',  label = _('TGP Laser Code 1st Digit'), defValue = 1, min = 1, max = 1, dimension = ' ', playerOnly = true},
            { id = "LaserCodeDigit2", control = 'spinbox',  label = _('TGP Laser Code 2nd Digit'), defValue = 6, min = 5, max = 7, dimension = ' ', playerOnly = true},
            { id = "LaserCodeDigit3", control = 'spinbox',  label = _('TGP Laser Code 3rd Digit'), defValue = 8, min = 1, max = 8, dimension = ' ', playerOnly = true},
            { id = "LaserCodeDigit4", control = 'spinbox',  label = _('TGP Laser Code 4th Digit'), defValue = 8, min = 1, max = 8, dimension = ' ', playerOnly = true},
		},

	lights_data = { -- Light Definitions so that the AI understands how to use them
		typename = "collection",
		lights = {
			[WOLALIGHT_STROBES] = { -- Anti-Collision Lights
				typename = "collection",
				lights = {
					{ typename = "argumentlight", argument = 83 }, -- Anti-Collision Light 1 (red)
					{ typename = "argnatostrobelight", argument = 192, period = 0.75, flash_time = 0.5 }, -- Anti-Collision Light 2 (red, Flasher)
					{ typename = "argumentlight", argument = 196 }, -- Fuselage Belly Lights (white, left & right)
					{ typename = "argumentlight", argument = 209 }, -- Fuselage Top Light (white)
				},
			},
			[WOLALIGHT_LANDING_LIGHTS] = {
				typename = "collection",
				lights = { { typename = "argumentlight", argument = 51 } }, -- Landing Light
			},
			[WOLALIGHT_TAXI_LIGHTS] = {
				typename = "collection",
				lights = { { typename = "argumentlight", argument = 208 } }, -- Taxi Light
			},
			[WOLALIGHT_NAVLIGHTS] = { -- Position Lights
				typename = "collection",
				lights = {
					{ typename = "argumentlight", argument = 190 }, -- Wing-Tip Red & Green
					{ typename = "argumentlight", argument = 191 }, -- Join-Up Red & Green
					{ typename = "argnatostrobelight", argument = 193, period = 0.75, flash_time = 0.5 }, -- Tail-Position White
				},
			},
			[WOLALIGHT_FORMATION_LIGHTS] = {
				typename = "collection",
				lights = { { typename = "argumentlight", argument = 88 } }, -- Formation Lights
			},
			[WOLALIGHT_REFUEL_LIGHTS] = {
				typename = "collection",
				lights = { { typename = "argumentlight", argument = 210 } }, -- AAR door
			},
			[WOLALIGHT_CABIN_NIGHT] = {
				typename = "collection",
				lights = { { typename = "argumentlight", argument = 69 } }, -- Pilot interior cockpit lighting
			},
		},
	},
}

if rewrite_settings then
   for i,o in pairs(rewrite_settings) do
        F4[i] = o
   end
end

return F4

end

F4E = makeF4()
add_aircraft(F4E)

--https://en.wikipedia.org/wiki/McDonnell_Douglas_F-4_Phantom_II
--https://en.wikipedia.org/wiki/McDonnell_Douglas_F-4_Phantom_II_non-U.S._operators
declare_service_life("F-4E-45MC", "USA", 1963, 1996)
declare_service_life("F-4E-45MC", "Australia", 1970, 1973)
declare_service_life("F-4E-45MC", "Egypt", 1977, 2020)
declare_service_life("F-4E-45MC", "Germany", 1978, 2013)
declare_service_life("F-4E-45MC", "Greece", 1974, 2024)
declare_service_life("F-4E-45MC", "Iran", 1971, 9999)
declare_service_life("F-4E-45MC", "Israel", 1969, 2004)
declare_service_life("F-4E-45MC", "Japan", 1971, 2021)
declare_service_life("F-4E-45MC", "South Korea", 1977, 2024)
declare_service_life("F-4E-45MC", "Turkey", 1974, 9999)

QF4E = makeF4({Name = 'QF-4E', DisplayName = _('QF-4E'), crew_members = {}, DefaultTask = aircraft_task(Nothing), mapclasskey = "P0091000023"})
add_aircraft(QF4E)
