--------------------------------------------------------------------------------------------------
-- Bf109E Lua file by SKRAVIG Corp.
--------------------------------------------------------------------------------------------------

-- Setting up model container
mount_vfs_model_path(current_mod_path .. "/Shapes")
mount_vfs_texture_path(current_mod_path .. "/Textures/Bf109E")
mount_vfs_liveries_path(current_mod_path .. "/Liveries")
-- end of Setting up model container

---------------------------------------------------------------------------------------------------------------------------------------------------

    -- [1] = Cartridge, 7.92x57, S.m.K. - Spitzgeschoss mit Kern
    declare_weapon({category = CAT_SHELLS, name = "Mauser7.92x57_S.m.K.", user_name = _("Mauser7.92x57_S.m.K."),
        model_name      = "tracer_bullet_yellow",
        projectile      = "AP",
        mass            = 0.0115, -- Bullet mass
        round_mass      = 0.024 + 0.009, -- Assembled shell + link
        cartridge_mass  = 0.006 + 0.009, -- Empty shell (+ link if links are stored as well)
        explosive       = 0,
        v0              = 865.0,
        Dv0             = 0.0080,
        Da0             = 0.00045,
        Da1             = 0.0,
        life_time       = 3.0,
        caliber         = 7.62,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {1.0, 0.62, 0.65, 0.175, 1.80},
        k1              = 2.3e-08,
        tracer_off      = -1,
        smoke_tail_life_time = 0,
        cartridge       = 0,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
    })

    -- [2] = Cartridge, 7.92x57, S.m.K.H. - Spitzgeschoss mit Kern, Hart
    declare_weapon({category = CAT_SHELLS, name = "Mauser7.92x57_S.m.K.H.", user_name = _("Mauser7.92x57_S.m.K.H."),
        model_name      = "tracer_bullet_yellow",
        projectile      = "AP",
        mass            = 0.0115, -- Bullet mass
        round_mass      = 0.024 + 0.009, -- Assembled shell + link
        cartridge_mass  = 0.006 + 0.009, -- Empty shell (+ link if links are stored as well)
        explosive       = 0,
        v0              = 868.0,
        Dv0             = 0.0080,
        Da0             = 0.00045,
        Da1             = 0.0,
        life_time       = 3.0,
        caliber         = 6.00,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {1.0, 0.62, 0.65, 0.175, 1.80},
        k1              = 2.3e-08,
        tracer_off      = -1,
        smoke_tail_life_time = 0,
        cartridge       = 0,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
    })

    -- [3] = Cartridge, 7.92x57, S.m.K. L'spur (gelb) - Spitzgeschoss mit Kern, Leuchtspur (gelb)
    declare_weapon({category = CAT_SHELLS, name = "Mauser7.92x57_S.m.K._L'spur(gelb)", user_name = _("Mauser7.92x57_S.m.K._L'spur(gelb)"),
        model_name      = "tracer_bullet_yellow",
        projectile      = "AP",
        mass            = 0.01015, -- Bullet mass
        round_mass      = 0.024 + 0.009, -- Assembled shell + link
        cartridge_mass  = 0.006 + 0.009, -- Empty shell (+ link if links are stored as well)
        explosive       = 0,
        v0              = 905.0,
        Dv0             = 0.0080,
        Da0             = 0.00045,
        Da1             = 0.0,
        life_time       = 5.0,
        caliber         = 7.62,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {1.0, 0.62, 0.65, 0.175, 1.80},
        k1              = 2.3e-08,
        tracer_off      = 5.0,
        smoke_tail_life_time = 0,
        cartridge       = 0,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
    })

    -- [4] = Cartridge, 7.92x57, S.m.K. L'spur (weiss) - Spitzgeschoss mit Kern, Leuchtspur (weiss)
    declare_weapon({category = CAT_SHELLS, name = "Mauser7.92x57_S.m.K._L'spur(weiss)", user_name = _("Mauser7.92x57_S.m.K._L'spur(weiss)"),
        model_name      = "tracer_bullet_white",
        projectile      = "AP",
        mass            = 0.01015, -- Bullet mass
        round_mass      = 0.024 + 0.009, -- Assembled shell + link
        cartridge_mass  = 0.006 + 0.009, -- Empty shell (+ link if links are stored as well)
        explosive       = 0,
        v0              = 905.0,
        Dv0             = 0.0080,
        Da0             = 0.00045,
        Da1             = 0.0,
        life_time       = 5.0,
        caliber         = 7.62,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {1.0, 0.62, 0.65, 0.175, 1.80},
        k1              = 2.3e-08,
        tracer_off      = 5.0,
        smoke_tail_life_time = 0,
        cartridge       = 0,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
    })

    -- [5] = Cartridge, 7.92x57, S.m.K. Ub.m.Zerl. - Spitzgeschoss mit Kern Ubungsmunition mit Zerleger
    declare_weapon({category = CAT_SHELLS, name = "Mauser7.92x57_S.m.K._Ub.m.Zerl.", user_name = _("Mauser7.92x57_S.m.K._Ub.m.Zerl."),
        model_name      = "tracer_bullet_yellow",
        projectile      = "AP",
        mass            = 0.0115, -- Bullet mass
        round_mass      = 0.024 + 0.009, -- Assembled shell + link
        cartridge_mass  = 0.006 + 0.009, -- Empty shell (+ link if links are stored as well)
        --explosive       = 0,
        payload         = 0.0005,
        payloadEffect   = "Concussion",
        payloadMaterial = "Amatol",
        v0              = 865.0,
        Dv0             = 0.0080,
        Da0             = 0.00045,
        Da1             = 0.0,
        life_time       = 1.0,
        caliber         = 7.62,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {1.0, 0.62, 0.65, 0.175, 1.80},
        k1              = 2.3e-08,
        tracer_off      = -1,
        smoke_tail_life_time = 0,
        cartridge       = 0,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
        silent_self_destruction = false,
    })

    -- [6] = Cartridge, 7.92x57, P.m.K. - Phosphor mit Stahlkern
    declare_weapon({category = CAT_SHELLS, name = "Mauser7.92x57_P.m.K.", user_name = _("Mauser7.92x57_P.m.K."),
        model_name      = "tracer_bullet_yellow",
        projectile      = "AP",
        mass            = 0.01015, -- Bullet mass
        round_mass      = 0.024 + 0.009, -- Assembled shell + link
        cartridge_mass  = 0.006 + 0.009, -- Empty shell (+ link if links are stored as well)
        --explosive       = 0,
        payload         = 0.0005,
        payloadEffect   = "Thermal",
        payloadMaterial = "Phosphor",
        v0              = 905.0,
        Dv0             = 0.0080,
        Da0             = 0.00045,
        Da1             = 0.0,
        life_time       = 4.0,
        caliber         = 7.62,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {1.0, 0.62, 0.65, 0.175, 1.80},
        k1              = 2.3e-08,
        tracer_off      = -1,
        smoke_tail_life_time = 0,
        cartridge       = 0,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
        silent_self_destruction = true,
    })

    -- [7] = Cartridge, 7.92x57, B. - Beobachtung
    declare_weapon({category = CAT_SHELLS, name = "Mauser7.92x57_B.", user_name = _("Mauser7.92x57_B."),
        model_name      = "tracer_bullet_yellow",
        projectile      = "HE",
        mass            = 0.01085, -- Bullet mass
        round_mass      = 0.024 + 0.009, -- Assembled shell + link
        cartridge_mass  = 0.006 + 0.009, -- Empty shell (+ link if links are stored as well)
        --explosive       = 0,
        payload         = 0.0005,
        payloadEffect   = "Concussion",
        payloadMaterial = "Amatol",
        v0              = 855.0,
        Dv0             = 0.0080,
        Da0             = 0.00045,
        Da1             = 0.0,
        life_time       = 4.0,
        caliber         = 7.62,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {1.0, 0.62, 0.65, 0.175, 1.80},
        k1              = 2.3e-08,
        tracer_off      = -1,
        smoke_tail_life_time = 0,
        cartridge       = 0,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
        silent_self_destruction = true,
    })

    -- MG 17
    function MG_17 ( tbl )
        tbl.category = CAT_GUN_MOUNT
        tbl.name = "MG_17"
        tbl.display_name = _("MG 17")
        tbl.supply = {
            shells = {
                --[[ 1 ]]   "Mauser7.92x57_S.m.K.",
                --[[ 2 ]]   "Mauser7.92x57_S.m.K.H.",
                --[[ 3 ]]   "Mauser7.92x57_S.m.K._L'spur(gelb)",
                --[[ 4 ]]   "Mauser7.92x57_S.m.K._L'spur(weiss)",
                --[[ 5 ]]   "Mauser7.92x57_S.m.K._Ub.m.Zerl.",
                --[[ 6 ]]   "Mauser7.92x57_P.m.K.",
                --[[ 7 ]]   "Mauser7.92x57_B.",
            },
            mixes = {{3, 6, 3, 6}},
            count = tbl.count or 500,
        }
        if tbl.mixes then
            tbl.supply.mixes = tbl.mixes
            tbl.mixes = nil
        end
        if tbl.count then
            tbl.supply.count = tbl.count
            tbl.count = nil
        end
        tbl.gun = {
            max_burst_length = 65535,
            rates = {1000}, -- synchronized mount
	    --rates = {1200}, -- unsynchronized mount
            recoil_coeff = 1.0,
            barrels_count = 1,
        }
        if tbl.rates then
            tbl.gun.rates = tbl.rates
            tbl.rates = nil
        end
        tbl.ejector_pos = tbl.ejector_pos or {0.0, 0.05, 0.0}
        tbl.ejector_dir = tbl.ejector_dir or {0, -1, 0}
        --tbl.effect_arg_number = tbl.effect_arg_number or 436
        tbl.supply_position = tbl.supply_position or {0, 0.3, -0.3}
        tbl.aft_gun_mount = false
        tbl.effective_fire_distance = 900
        tbl.drop_cartridge = 0
        tbl.muzzle_pos = {0, 0, 0} -- all position from connector
        tbl.azimuth_initial = tbl.azimuth_initial or 0
        tbl.elevation_initial = tbl.elevation_initial or 0
       --[[if  tbl.effects == nil then
		if tbl.muzzle_pos[3] > 0.5 or tbl.muzzle_pos[3] < -0.5 then  -- wing guns
			tbl.effects = {
				{ name = "FireEffect"     , arg = tbl.effect_arg_number or 436 },
				{ name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
				{ name = "SmokeEffect"}
			}
		else  -- nose guns with synchronizer
			tbl.effects = {
				{ name = "GunSynchronizer", sectors = 2, reduction_gear = 1.55, engine_rpm_nominal = 2500, dead_angle_degrees = 30},
				{ name = "FireEffect"     , arg = tbl.effect_arg_number or 436 },
				{ name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
				{ name = "SmokeEffect"}
			}
		end
	end]]

        return declare_weapon(tbl)
   end
---------------------------------------------------------------------------------------------------------------------------------------------------

-- [1] = Cartridge, MG FF HET
    declare_weapon({category = CAT_SHELLS, name = "MG_FF_HE/T", user_name = _("MG FF HE/T"),
        model_name      = "tracer_bullet_red",
        projectile      = "HE",
        mass            = 0.117, -- Bullet mass
        round_mass      = 0.220, -- Assembled shell + link
        cartridge_mass  = 0.056, -- Empty shell (+ link if links are stored as well)
        --explosive       = 0.01,
        payload         = 0.0090,
        payloadEffect   = "Concussion",
        payloadMaterial = "TNT",
        v0              = 600.0,
        Dv0             = 0.0080,
        Da0             = 0.0006,
        Da1             = 0.0,
        life_time       = 7.0,
        caliber         = 20,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {0.6, 0.94, 0.65, 0.29, 1.88},
        k1              = 3.3e-08,
        tracer_off      = 1.7,
        smoke_tail_life_time = 1.7,
        cartridge       = 0,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
    })


-- [2] = Cartridge, MG FF/M APT
    declare_weapon({category = CAT_SHELLS, name = "MG_FF/M_APT", user_name = _("MG FF/M APT"),
        model_name      = "tracer_bullet_red",
        projectile      = "AP",
        mass            = 0.117, -- Bullet mass
        round_mass      = 0.220, -- Assembled shell + link
        cartridge_mass  = 0.056, -- Empty shell (+ link if links are stored as well)
        --explosive       = 0,
        payload         = 0.0010,
        payloadEffect   = "Thermal",
        payloadMaterial = "Thermite",
        v0              = 575.0,
        Dv0             = 0.0080,
        Da0             = 0.0006,
        Da1             = 0.0,
        life_time       = 7.0,
        caliber         = 20,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {1.3, 0.93, 0.55, 0.36, 1.8},
        k1              = 3.6e-08,
        tracer_off      = -1,
        smoke_tail_life_time = 0,
        cartridge       = 0,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
    })


-- [3] = Cartridge, MG FF/M M-Gsch
    declare_weapon({category = CAT_SHELLS, name = "MG_FF/M_M-Gsch", user_name = _("MG FF/M M-Gsch"),
        model_name      = "tracer_bullet_red",
        projectile      = "HE",
        mass            = 0.092, -- Bullet mass
        round_mass      = 0.190, -- Assembled shell + link
        cartridge_mass  = 0.056, -- Empty shell (+ link if links are stored as well)
        --explosive       = 0.01,
        payload         = 0.0190,
        payloadEffect   = "Concussion",
        payloadMaterial = "PETN",
        v0              = 700.0,
        Dv0             = 0.0080,
        Da0             = 0.0006,
        Da1             = 0.0,
        life_time       = 7.0,
        caliber         = 20,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {1.0, 1.22, 0.3, 0.36, 1.9},
        k1              = 5.2e-08,
        tracer_off      = -1,
        smoke_tail_life_time = 0,
        cartridge       = 0,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
    })


    -- MG FF
    function MG_FF ( tbl )
        tbl.category = CAT_GUN_MOUNT 
        tbl.name = "MG_FF"
        tbl.display_name = _("MG FF")
        tbl.supply = {
            shells = {
                --[[ 1 ]]   "MG FF HE/T",
                --[[ 2 ]]   "MG FF/M APT",
		--[[ 3 ]]   "MG FF/M M-Gsch",
            },
            mixes = {{1, 1, 1}},
            count = tbl.count or 60,
        }
        if tbl.mixes then
            tbl.supply.mixes = tbl.mixes
            tbl.mixes = nil
        end
        if tbl.count then
            tbl.supply.count = tbl.count
            tbl.count = nil
        end
        tbl.gun = {
            max_burst_length = 65535,
            rates = {530}, -- unsynchronized mount
            recoil_coeff = 1.0,
            barrels_count = 1,
        }
        if tbl.rates then
            tbl.gun.rates = tbl.rates
            tbl.rates = nil
        end
        tbl.ejector_pos = tbl.ejector_pos or {0.0, 0.05, 0.0}
        tbl.ejector_dir = tbl.ejector_dir or {0, -1, 0}
        tbl.supply_position = tbl.supply_position or {0, -0.3, -1.5}
        tbl.aft_gun_mount = false
        tbl.effective_fire_distance = 900
        --tbl.drop_cartridge = 204
        tbl.muzzle_pos = tbl.muzzle_pos or {0, 0, 0}
        tbl.azimuth_initial = tbl.azimuth_initial or 0
        tbl.elevation_initial = tbl.elevation_initial or 0
        tbl.effects = {
            {name = "FireEffect", arg = tbl.effect_arg_number or 436},
            {name = "HeatEffectExt", shot_heat = 20.9, barrel_k = 0.462 * 16.6, body_k = 0.462 * 35.4},
            {name = "SmokeEffect"}
        }

        return declare_weapon(tbl)
    end

---------------------------------------------------------------------------------------------------------------------------------------------------

-- Declaring aircraft
function  make_Bf109E ( rewrite_settings )

gunConvergence = 200 -- Target distance (in meters) for gun convergence

local AIRCRAFT = {
        
	Name 		    	=   "Bf109E",
	DisplayName	    	= _("Bf109E"),
	date_of_introduction 	= 1939.0,
        country_of_origin   	= "Third Reich",
        Countries 		= {"Bulgaria","Germany","Hungary","Romania","Spain","Switzerland","Third Reich","Yugoslavia"},

	Picture 		= "Bf109E.png",
	Rate 			= 20, -- RewardPoint in Multiplayer
	Shape			= "Bf109E",
	propellorShapeType 	= '3ARG',
	WeightLossForCivil	= 71, -- kg -- 1x Hispano HS404 + 4x MAC 1934
	shape_table_data	= {
	    {
		file  	 = "";
		life  	 = 18; -- lifebar
		vis   	 = 3; -- visibility gain.
		desrt    = 'p51-oblomoki'; -- Name of destroyed object file name
		fire  	 = { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
		username = "";
		index    =  WSTYPE_PLACEHOLDER;
		classname = "lLandPlane";
		positioning = "BYNORMAL";
		drawonmap = true;
	    },
	    {
		name = "p51-oblomoki";
                file = "p51-oblomoki";
                fire = {240, 2};
	    },

	},
	mapclasskey 	= "P0091000025",
	attribute  	= {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER ,"Battleplanes",},
	Categories 	= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},	

-----------------------------------------------------------------------------------
--- Flight Characteristics Section
-----------------------------------------------------------------------------------

        M_empty         = 2010, -- kg
        M_nominal       = 2667, -- kg
        M_max           = 2870, -- kg
        M_fuel_max      = 303, -- kg
        M_fuel_per_tank = {1, 1, 1, 300}, -- kg
        defFuelRatio    = 0.68, -- default percentage of fuel quantity / 100
        H_max           = 11200, -- m
        average_fuel_consumption = 0.0757, -- 232 gr/ch/heure -- 232/1000/3600*1175 = 0.0757 kg/s
        CAS_min         = 56, -- if this is not OVERALL FLIGHT TIME, but just LOITER TIME, than it should be 10-15 minutes.....CAS capability in minute (for AI)
        V_opt           = 125,-- Cruise speed (for AI)
        V_take_off      = 39, -- Take off speed in m/s (for AI)
        V_land          = 35, -- Land speed in m/s (for AI)
        V_max_sea_level = 234, -- Max speed at sea level in m/s (for AI)
        V_max_h         = 218, -- Max speed at max altitude in m/s (for AI)
        Vy_max          = 12, -- Max climb speed in m/s (for AI)
        Mach_max        = 0.7, -- Max speed in Mach (for AI)
        Ny_min          = -4.0, -- Min G (for AI)
        Ny_max          = 8.0,  -- Max G (for AI)
        Ny_max_e        = 8.0,  -- Max G (for AI)
        AOA_take_off    = 0.14, -- AoA in take off (for AI)
        bank_angle_max  = 60.0, -- Max bank angle (for AI)

        has_afteburner  		= false, -- AFB yes/no
        has_speedbrake  		= false, -- Air brake yes/no
        has_differential_stabilizer 	= false, -- Differential stabilizers yes/no
        flaps_transmission 		= "Hydraulic",
        undercarriage_transmission 	= "Hydraulic",
        aim_error_level_bombing 	= 20.0,
        aim_error_dive_bombing  	= 10.0,

-----------------------------------------------------------------------------------
---  Landing Gear Section
-----------------------------------------------------------------------------------
---- {forward/backward, up/down, left/right}

        nose_gear_pos                            = {-4.928, -0.270, 0.000}, -- Central gear coordinates
        nose_gear_amortizer_direct_stroke      	 = 0.067, -- down from nose_gear_pos (in meter)
        nose_gear_amortizer_reversal_stroke      = -0.0, -- up from nose_gear_pos (in meter)
        nose_gear_amortizer_normal_weight_stroke = -0.0, -- down from nose_gear_pos (in meter)
        nose_gear_wheel_diameter                 = 0.295, -- wheel diameter (in meter)
        tand_gear_max                            = 0.577, -- tangent on maximum yaw angle of front wheel, ex : 65 degrees -> tan(65deg)

        main_gear_pos                            = {0.809, -1.730, 0.883}, -- Main gear coordinates
        main_gear_amortizer_direct_stroke        = 0.15, -- down from main_gear_pos (in meter)
        main_gear_amortizer_reversal_stroke      = -0.0, -- up from main_gear_pos (in meter)
        main_gear_amortizer_normal_weight_stroke = -0.0, -- down from main_gear_pos (in meter)
        main_gear_wheel_diameter                 = 0.65, -- wheel diameter (in meter)

-----------------------------------------------------------------------------------
---  Dimensions Section
-----------------------------------------------------------------------------------

        wing_area       	= 16.4, -- Wing area in m2
        wing_span       	= 9.9, -- Wing span in m
        wing_type       	= 0, -- 0 = Fixed wing, 1 = Variable geometry, 2 = Fold-able wing
        thrust_sum_max  	= 8224, -- Thrust in kg (44kN) (only for jet)
        thrust_sum_ab   	= 8224, -- Thrust in kg (71kN) (only for jet)
        length          	= 8.76, -- Full length in m
        height          	= 3.39, -- Height in m
        flaps_maneuver  	= 0.5, -- Max flaps in take-off and manoeuvre (0.5 = 1st stage; 1.0 = 2nd stage) (for AI)
        range           	= 660, -- Max range in km (for AI)
        RCS             	= 2.5, -- Radar Cross Section m2
        IR_emission_coeff 	= 0.1, -- Normal engine -- IR_emission_coeff = 1.0 @ Su-27 without afterburner. It is a reference value.
        IR_emission_coeff_ab 	= 0, -- Same with afterburner
        wing_tip_pos    	= {-2.200, 0.000, 5.100}, -- Wing tip coordinates for visual effects
        brakeshute_name 	= 0, -- Landing - brake chute visual shape after separation
        engines_count 		= 1, -- Engines count

-----------------------------------------------------------------------------------
---  Engine Nozzle Section
-----------------------------------------------------------------------------------
---- {forward/backward, up/down, left/right}

        engines_nozzles = {
            [1] = {
                pos                 = {1.625499, 0.047866, -0.560}, -- Nozzle coordinates
                elevation           = 0, -- AFB cone elevation
                diameter            = 0 * 0.1, -- AFB cone diameter
                exhaust_length_ab   = -3.0, -- Length in m
                exhaust_length_ab_K = 0.3, -- AB animation
                engine_number       = 1, -- Both to first engine
            }, -- end of [1]
            [2] = {
                pos                 = {1.62499, 0.047866, 0.560}, -- Nozzle coordinates
                elevation           = 0, -- AFB cone elevation
                diameter            = 0 * 0.1, -- AFB cone diameter
                exhaust_length_ab   = -3.0, -- Length in m
                exhaust_length_ab_K = 0.3, -- AB animation
                engine_number       = 1, -- Both to first engine
            }, -- end of [2]
        }, -- end of engines_nozzles

-----------------------------------------------------------------------------------
---  Crew Section
-----------------------------------------------------------------------------------
---- {forward/backward, up/down, left/right}
  
  	crew_members = {
             [1] = {
                role                = "pilot";
                pilot_name          = "pilot_raf",
                ejection_seat_name  = 0,
                drop_canopy_name    = 57,
                pos                 = {-0.20, -0.055, 0.000},
                canopy_pos          = {0.000, 0.000, 0.000},
                drop_parachute_name = "pilot_raf_parachute",
            }, -- end of [1]
        }, -- end of crew_members

        fires_pos = {
            [1]  = {-2.000, 0.595, 0.500};
            [2]  = {0.000, 0.000, 2.237};
            [3]  = {0.000, 0.000, -2.237};
            [4]  = {0.265, 0.000, 1.500};
            [5]  = {-0.265, 0.000, -1.500};
            [6]  = {0.500, 0.000, 4.274};
            [7]  = {0.500, 0.000, -4.274};
            [8]  = {-5.000, 0.500, 0.000};
            [9]  = {-5.000, 0.500, 0.000};
            [10] = {-5.000, 0.500, 0.000};
            [11] = {-5.000, 0.500, 0.000};
        }, -- end of fires_pos

        -- Countermeasures
        SingleChargeTotal   = 0,
        CMDS_Incrementation = 0,
        ChaffDefault        = 0,
        ChaffChargeSize     = 0,
        FlareDefault        = 0,
        FlareChargeSize     = 0,
        CMDS_Edit           = false,

        mechanimations = {
            Door0 = {
                {Transition = {"Close", "Open"},  Sequence = {{C = {{"Arg", 38, "to", 0.9, "at", 0.11111111111111},},},}, Flags = {"Reversible"},},
                {Transition = {"Open", "Close"},  Sequence = {{C = {{"Arg", 38, "to", 0.0, "at", 0.16666666666667},},},}, Flags = {"Reversible", "StepsBackwards"},},
                {Transition = {"Any", "Bailout"}, Sequence = {{C = {{"TearCanopy", 0},},},},},
            },
        },

        net_animation = {
            420,
        },  



        -- Sensors
        detection_range_max     = 0,
        radar_can_see_ground    = false,
        CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_BAD, LOOK_GOOD, LOOK_GOOD),
        Sensors = {
           -- OPTIC = "Merkury LLTV", -- For night goggles imitation
           -- RWR = "Abstract RWR"
        },

-----------------------------------------------------------------------------------
---  Radio Section
-----------------------------------------------------------------------------------

        -- Radio
        HumanRadio = {
            frequency = 5.000,
            editable = true,
            minFrequency = 2.500,
            maxFrequency = 7.500,
            modulation = MODULATION_AM
        },

        -- Mission editor radio panel
        panelRadio = {
            [1] = {
		ID = "FuG_7",  
                name = _("FuG 7"),
		displayUnits = "MHz",
                range = {min = 2.5, max = 7.5},
                channels = {
                    [1] = { name = _("ButtonA"), default = 3, modulation = _("AM"), connect = true},
                    [2] = { name = _("ButtonB"), default = 4, modulation = _("AM")},
                    [3] = { name = _("ButtonC"), default = 5, modulation = _("AM")},
                    [4] = { name = _("ButtonD"), default = 6, modulation = _("AM")},
                }
            },
        },

-----------------------------------------------------------------------------------
---  Gun Section
-----------------------------------------------------------------------------------
---- {forward/backward, up/down, left/right}

        -- Guns
  	Guns = {

	-- Right MG17
            MG_17({
                muzzle_pos = {2.88, 0.46, 0.23},
                effect_arg_number = 436,
                barrel_circular_error = 0.0,
                azimuth_initial = 0,
                elevation_initial = 0,
                supply_position = {2.88, 0.46, 0.23},
                ejector_pos = {2.88, 0.46, 0.23},
            }),

	-- Left MG17
            MG_17({
                muzzle_pos = {2.88, 0.46, -0.23},
                effect_arg_number = 435,
                barrel_circular_error = 0.0,
                azimuth_initial = 0,
                elevation_initial = 0,
                supply_position = {2.88, 0.46, -0.23},
                ejector_pos = {2.88, 0.46, -0.23},
            }),

	-- Left wing MG FF
            MG_FF({
                muzzle_pos = {0.89, -0.27, -2.29},
                effect_arg_number = 434,
                barrel_circular_error = 0.0,
                azimuth_initial = -180/3.14*2.29/gunConvergence,
                elevation_initial = 0,
                supply_position = {0.00, -0.27, -2.00},
                ejector_pos = {0.89, -0.27, -2.29},
            }),

	-- Right wing MG FF
            MG_FF({
                muzzle_pos = {0.89, -0.27, 2.29},
                effect_arg_number = 433,
                barrel_circular_error = 0.0,
                azimuth_initial = 180/3.14*2.29/gunConvergence,
                elevation_initial = 0,
                supply_position = {0.00, -0.27, 2.00},
                ejector_pos = {0.89, -0.27, 2.29},
            }),		 
	},

-----------------------------------------------------------------------------------
---  Loadout Section
-----------------------------------------------------------------------------------
---- {forward/backward, up/down, left/right}
	
	Pylons =  {  
	 -- Pylon 1
	},

-----------------------------------------------------------------------------------
---  Tasks Section
-----------------------------------------------------------------------------------

        -- Tasks
        Tasks = {
            aircraft_task(CAP),
            aircraft_task(Escort),
	    aircraft_task(Intercept),
            aircraft_task(FighterSweep),
            aircraft_task(GroundAttack),
            aircraft_task(CAS),
            aircraft_task(AFAC),
            aircraft_task(RunwayAttack),
            aircraft_task(AntishipStrike),
  	},
        DefaultTask = aircraft_task(CAP),

-----------------------------------------------------------------------------------
---  SFM Section
-----------------------------------------------------------------------------------

        -- SFM Data
        SFM_Data = {
            aerodynamics = { -- Cx = Cx_0 + Cy^2*B2 +Cy^4*B4
                Cy0         = 0.1, -- zero AoA lift coefficient
                Mzalfa      = 4.355, -- coefficients for pitch agility
                Mzalfadt    = 0.8, -- coefficients for pitch agility
                kjx         = 2.25,
                kjz         = 0.00125,
                Czbe        = -0.016, -- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
                cx_gear     = 0.0277, -- coefficient, drag, gear
                cx_flap     = 0.095, -- coefficient, drag, full flaps
                cy_flap     = 0.31, -- coefficient, normal force, lift, flaps
                cx_brk      = 0.06, -- coefficient, drag, breaks
                table_data  = 
                {   --M		Cx0		Cya		B		B4		Omxmax		Aldop		Cymax
                    {0,		0.0270,		0.1100, 	0.012,		0.061,		0.15,		20,		1.33},
                    {0.2,	0.0270, 	0.1100,		0.012,		0.061,		0.796144,	20,		1.33},
                    {0.3,	0.0270, 	0.1100,		0.012,		0.061,		1.24,		19,		1.33}, -- Vclimb
		    {0.35,	0.0270, 	0.1100,		0.012,		0.061,		1.24,		19,		1.33},
		    {0.40,	0.0270, 	0.1100,		0.012,		0.061,		1.24,		18,		1.33}, -- Vmax low altitude
		    {0.45,	0.0280, 	0.1100,		0.012,		0.061,		1.323,		17,		1.33},
		    {0.47,	0.0275, 	0.1100,		0.012,		0.061,		1.323,		17,		1.33},
		    {0.48,	0.0275, 	0.1100,		0.012,		0.061,		1.323,		17,		1.33},
                    {0.49,	0.0285, 	0.1100,		0.012,		0.061,		1.323,		17,		1.33},
                    {0.6,	0.0650, 	0.1100,		0.012,		0.061,		1.129077,	16,		1.33},
                    {0.7,	0.0650, 	0.1100,		0.012,		0.061,		0.943,		14.5,		1.33},
                    {0.8,	0.0650,		0.1100,		0.012,		0.061,		0.456,		6,		1.33},
                    {0.9,	0.0650,		0.1100,		0.012,		0.061,		0.076,		3,		1.33},
		    {1.0,	0.0650,		0.1100,		0.012,		0.061,		0.076,		3,		1.33},
                }, -- end of table_data
                -- M - Mach number
                -- Cx0 - Coefficient, drag, profile, of the airplane
                -- Cya - Normal force coefficient of the wing and body of the aircraft in the normal direction to that of flight. Inversely proportional to the available G-loading at any Mach value. (lower the Cya value, higher G available) per 1 degree AOA
                -- B - Polar quad coeff
                -- B4 - Polar 4th power coeff
                -- Omxmax - roll rate, rad/s
                -- Aldop - Alfadop Max AOA at current M - departure threshold
                -- Cymax - Coefficient, lift, maximum possible (ignores other calculations if current Cy > Cymax)
            }, -- end of aerodynamics
            engine = {
                Nominal_RPM 	= 2500.0,
                Nmg     	= 20.5, -- RPM at idle
                MinRUD  	= 0, -- Min state of the throttle
                MaxRUD  	= 1, -- Max state of the throttle
                MaksRUD 	= 1, -- Military power state of the throttle
                ForsRUD 	= 1, -- Afterburner state of the throttle
                type    	= "Piston",

                hMaxEng 	= 11.7, -- Max altitude for safe engine operation in km
                dcx_eng 	= 0.0015, -- Engine drag coefficient
                cemax   	= 0.37, -- not used for fuel calculation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
                cefor   	= 0.37, -- not used for fuel calculation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
                dpdh_m  	= 1800, -- Loss of thrust in N per 1000 m (only for jet)
                dpdh_f  	= 1800, -- Loss of thrust in N per 1000 m (only for jet)
                k_adiab_1           = 0.038,
                k_adiab_2           = 0.0562,
                MAX_Manifold_P_1    = 117323, -- Max pressure at the end of exhaust cycle (compressor pressure)
                MAX_Manifold_P_2    = 1374623, -- Max pressure at the end of compression cycle
                MAX_Manifold_P_3    = 4994982, -- Max pressure at the end of combustion cycle
                k_after_cool        = 0.54,
                Displ               = 33.9, -- Engine displacement (in liters)
                k_Eps               = 6.9, -- compression ratio ???
                Stroke              = 0.160, -- Engine stroke (in m)
                V_pist_0            = 12, -- Engine cylinders
                Nu_0                = 1.2, -- What is the influence ???
                Nu_1                = 0.87, -- What is the influence ???
                Nu_2                = 0.001, -- What is the influence ???
                N_indic_0           = 1023040*1175/1770, -- has huge influence on engine max power
                N_fr_0              = 0.092, -- What is the influence ???
                N_fr_1              = 0.4, -- What is the influence ???
                Init_Mom            = 220,
                D_prop              = 3.05, -- Propeller diameter (in m)
                MOI_prop            = 65, -- Propeller moment of inertia (in kg/cm² ???)
                k_gearbox           = 1.55, -- Propeller RPM reduction ratio
                P_oil               = 588399, -- Oil pressure (in pascals)
                k_boost             = 3,
                k_cfug              = 0.003,
                k_oil               = 0.00004,
                k_piston            = 3000,
                k_reg               = 0.003,
                k_vel               = 0.017,
                table_data = {
                --   M          Pmax	(only for jet)
                    {0.0,       16620.0},
                    {0.1,       15600.0},
                    {0.2,       14340.0},
                    {0.3,       13320.0},
                    {0.4,       12230.0},
                    {0.5,       11300.0},
                    {0.6,       10600.0},
                    {0.7,       10050.0},
                    {0.8,        9820.0},
                    {0.9,        5902.0},
                    {1.9,        3469.0}
                },
                -- M - Mach number
                -- Pmax - Engine thrust at military power
                -- Pfor - Engine thrust at AFB
                --cylinder_firing_order = {1,3,4,2},
            }, -- end of engine
        },

-----------------------------------------------------------------------------------
---  Damage Section
-----------------------------------------------------------------------------------
-- Damage, index meaning see in Scripts\Aircrafts\_Common\Damage.lua

        Damage = verbose_to_dmg_properties({
            -- Fuselage
            ["FUSELAGE_BOTTOM"] = {
                critical_damage = 5, args = {152}, damage_boundary = 0.01,
                construction = {durability = 3.208, skin = "Aluminum"},
                droppable = false,
                children = {"NOSE_BOTTOM", "CABIN_LEFT_SIDE", "CABIN_RIGHT_SIDE", "COCKPIT"},
                innards = {
                    {id = "XEng0OilRadiator", skin = "Steel", wall = 0.002},
                    {id = "XEng0OilHose0", skin = "Rubber", wall = 0.012, plenum = 0.02},
                    {id = "XEng0WaterRadiator", skin = "Steel", wall = 0.002},
                },
                failures = {
                    {"OIL_RADIATOR_WIRING", 0.025},
                    {"OIL_RADIATOR_MOTOR", 0.025},
                    {"OIL_RADIATOR_SENSOR", 0.05},
                },
            },
            ["COCKPIT"] = {
                critical_damage = 3, args = {65},
                construction = {durability = 0.840, skin = "Glass", spar = "Truss"},
                detachable = {shape = "P-51D-Fonar"},
                innards = {
                    {id = "XArmor01", skin = "Steel", wall = 0.000}, -- Headrest armor
                },
            },
            ["CABIN_LEFT_SIDE"] = {
                critical_damage = 5, args = {154}, damage_boundary = 0.03,
                construction = {durability = 2.809, skin = "Aluminum"},
                children = {"NOSE_LEFT_SIDE", "TAIL_LEFT_SIDE", "WING_L_IN"},
                innards = {
                    {id = "XCrew0"},
                    {id = "XCrew0H"},
                    {id = "XCtrlEng0Quadrant", skin = "Steel", wall = 0.001},
                    {id = "XCockpitElement01", skin = "Steel", wall = 0.001,
                        failures = {
                            {"K14_NO_POWER_SUPPLY",      0.3},
                            {"K14_FIXED_LAMP_DEFECTIVE", 0.3},
                            {"K14_MOV_LAMP_DEFECTIVE",   0.3},
                            {"K14_MOTOR_DEFECTIVE",      0.3},
                        },
                    },
                    {id = "XCockpitElement02", skin = "Steel", wall = 0.001,
                        failures = {
                            {"ELEC_DASHBOARD_HARNESS_CUT", 0.05},
                            {"ELEC_PITOT_HEAT_WIRING", 0.15},
                            {"ELEC_STARTER_LOOM_SEVERED", 0.15},
                            {"BOOSTER_COIL", 0.15},
                            {"TACH_BREAK_CIRCUIT", 0.15},
                            {"TACH_BREAK_IN_INDICATOR", 0.15},
                            {"TACH_POOR_CONNECTION", 0.15},
                            {"TACH_RESISTANCE_ADJ", 0.15},
                            {"OIL_DILUTION_WIRE", 0.15},
                            {"DEFECTIVE_INSTRUMENT", 0.15},
                            {"DEFECTIVE_MECHANISM", 0.15},
                            {"MANIFOLD_SHIFT", 0.15},
                            {"MANIFOLD_LINE_LEAK", 0.15},
                            {"COOLANT_BREAK_BULB", 0.05},
                            {"COOLANT_DEFECTIVE_IND", 0.05},
                            {"COOLANT_POOR_CONNTECT", 0.05},
                            {"COOLANT_SHORT_CIRCUIT", 0.05},
                            {"CARBAIR_SHORT_CIRCUIT", 0.1},
                            {"CARBAIR_SHORT_CIRCUIT_LEADS", 0.1},
                            {"CARBAIR_GND_LEAD", 0.1},
                            {"CARBAIR_SHORT_CIRCUIT_BLB", 0.1},
                            {"CARBAIR_BREAK_LEADS", 0.1},
                            {"CARBAIR_OPEN_CIRCUIT_BLB", 0.1},
                            {"ELEC_STARTER_LOOM_SEVERED", 0.01},
                        },
                    },
                    {id = "XArmor02", skin = "ReinforcedGlass", wall = 0.000}, -- Glass armor
                    {id = "XArmor00", skin = "Steel", wall = 0.000}, -- Back seat armor
                    {id = "XCtrlCrew0Stick", skin = "Steel", wall = 0.044},
                    {id = "XCtrlLineEng0", skin = "Steel", wall = 0.007, plenum = 0.01},
                    {id = "XArmor03", skin = "Steel", wall = 0.000}, -- Firewall armor
                },
            },
            ["CABIN_RIGHT_SIDE"] = {
                critical_damage = 5, args = {153}, damage_boundary = 0.03,
                construction = {durability = 2.809, skin = "Aluminum"},
                children = {"NOSE_RIGHT_SIDE", "TAIL_RIGHT_SIDE", "WING_R_IN"},
                innards = {
                    {id = "XElecIFF", skin = "Steel", wall = 0.001},
                    {id = "XHydroQuadrant", skin = "Steel", wall = 0.034},
                    {id = "XOxygenHose", skin = "Rubber", wall = 0.055},
                    {id = "XOxygenHose0", skin = "Rubber", wall = 0.055},
                    {id = "XOxygenHose1", skin = "Rubber", wall = 0.055},
                    {id = "XOxygenCrew0Gear", skin = "Steel", wall = 0.008},
                },
            },
            --

            -- Nose
            ["ENGINE"] = {
                critical_damage = 3, args = {147}, damage_boundary = 0.02,
                construction = {durability = 1.671, skin = "Aluminum"},
                detachable = {shape = "P-51D-Fonar"}, -- TODO implement
            },
            ["ROTOR"] = {
                critical_damage = 6, args = {53}, damage_boundary = 0.01,
                construction = {durability = 0.25, skin = "Aluminum", refractory = true},
                children = {"BLADE_1_IN", "BLADE_1_OUT", "BLADE_2_IN", "BLADE_2_OUT", "BLADE_3_IN", "BLADE_3_OUT", "BLADE_4_IN", "BLADE_4_OUT"},
            },
            ["BLADE_1_IN"] = {
                critical_damage = 3, args = {429},
                construction = {durability = 0.11, skin = "Aluminum"},
            },
            ["BLADE_1_OUT"] = {
                critical_damage = 3, args = {380},
                construction = {durability = 0.11, skin = "Aluminum", min_max_arg_to_break = {minimal = 0.3, maximal = 0.6},},
            },
            ["BLADE_2_IN"] = {
                critical_damage = 3, args = {430},
                construction = {durability = 0.11, skin = "Aluminum"},
            },
            ["BLADE_2_OUT"] = {
                critical_damage = 3, args = {381},
                construction = {durability = 0.11, skin = "Aluminum", min_max_arg_to_break = {minimal = 0.6, maximal = 0.9},},
            },
            ["BLADE_3_IN"] = {
                critical_damage = 3, args = {431},
                construction = {durability = 0.11, skin = "Aluminum"},
            },
            ["BLADE_3_OUT"] = {
                critical_damage = 3, args = {382},
                construction = {durability = 0.11, skin = "Aluminum", min_max_arg_to_break = {minimal = 0.82, maximal = 0.16},},
            },
            ["BLADE_4_IN"] = {
                critical_damage = 3, args = {119},
                construction = {durability = 0.11, skin = "Aluminum"},
            },
            ["BLADE_4_OUT"] = {
                critical_damage = 3, args = {383},
                construction = {durability = 0.11, skin = "Aluminum", min_max_arg_to_break = {minimal = 0.1, maximal = 0.4},},
            },
            ["NOSE_LEFT_SIDE"] = {
                critical_damage = 5, args = {150}, damage_boundary = 0.01,
                construction = {durability = 2.627, skin = "Aluminum"},
                failures = {
                    {"PUMP_SEPARATOR_CLOGGED", 0.05},
                    {"PUMP_RELIEF_VALVE_SCREEN_CLOGGED", 0.05},
                    {"PUMP_RELIEF_VALVE_LEAKS", 0.05},
                    {"PUMP_FAILS", 0.01},
                    {"MANIFOLD_LINE_LEAK", 0.01},
		    {"WEAP_GUN_01_AMMO_BELT_SEVERED", 0.11},
                },
            },
            ["NOSE_RIGHT_SIDE"] = {
                critical_damage = 5, args = {149}, damage_boundary = 0.01,
                construction = {durability = 2.627, skin = "Aluminum"},
                failures = {
                    {"MANIFOLD_LINE_LEAK", 0.01},
		    {"WEAP_GUN_00_AMMO_BELT_SEVERED", 0.11},
                },
            },
            ["NOSE_BOTTOM"] = {
                critical_damage = 5, args = {148}, damage_boundary = 0.01,
                construction = {durability = 2.468, skin = "Aluminum"},
                children = {"ROTOR", "ENGINE"},
                innards = {
                    {id = "XEng0Case", skin = "CastIron", wall = 0.010},
                    {id = "XEng0HeadsLH", count = 6, skin = "Aluminum", wall = 0.010, plenum = 0.75, durability = 0.9},
                    {id = "XEng0HeadsRH", count = 6, skin = "Aluminum", wall = 0.010, plenum = 0.75, durability = 0.9},
                    {id = "XEng0Magneto0", skin = "Plastic", wall = 0.010},
                    {id = "XEng0Magneto1", skin = "Plastic", wall = 0.010},
                    {id = "XEng0PropGear", skin = "Steel", wall = 0.012, spar = "HeavySprocket"},
                    {id = "XEng0Supercharger", skin = "Steel", wall = 0.004},
                    {id = "XEng0Intercooler", skin = "Steel", wall = 0.002},
                    {id = "XEng0FuelPump", skin = "Steel", wall = 0.012},
                    {id = "XEng0Intake", skin = "Aluminum", wall = 0.002,
                        failures = {
                            {"MANIFOLD_LINE_LEAK", 0.25},
                        },
                    },
                    {id = "XHydroTank", skin = "Plastic", wall = 0.006},
                    {id = "XHydroHose", skin = "Rubber", wall = 0.004, plenum = 0.1},
                    {id = "XHydroHoseWBrake", skin = "Rubber", wall = 0.004, plenum = 0.001},
                    {id = "XHydroPump0", skin = "Steel", wall = 0.035},
                    {id = "XElecGenerator", skin = "Steel", wall = 0.010},
                    {id = "XEng0Governor", skin = "Steel", spar = "HeavySprocket", wall = 0.012},
                    {id = "XEng0OilTank", skin = "Steel", wall = 0.003},
                    {id = "XEng0OilPump", skin = "Steel", wall = 0.005},
                    {id = "XEng0WaterTank", skin = "Plastic", wall = 0.012},
                    {id = "XEng0WaterHose0", skin = "Rubber", wall = 0.010, plenum = 0.01},
                    {id = "XEng0WaterHose1", skin = "Rubber", wall = 0.010, plenum = 0.01},
                    {id = "XElecEng0Starter", skin = "Steel", wall = 0.032},
                    {id = "XEng0Carburettor", skin = "Steel", wall = 0.014},
                },
                failures = {
                    {"INSUF_FUEL_PRES", 0.05},
                },
            },
            --

            -- Tail less Sporn
            ["TAIL_LEFT_SIDE"] = {
                critical_damage = 5, args = {158}, damage_boundary = 0.02,
                construction = {durability = 1.353, skin = "Aluminum"},
                children = {"TAIL"},
                innards = {
                    {id = "XElecBattery", skin = "Plastic", wall = 0.010},
                    {id = "XElecRadio", skin = "Plastic", wall = 0.012, spar = "Rod", plenum = 0.75, durability = 0.05,
                        failures = {
                            {"VHF_CRYSTAL", 0.5},
                            {"VHF_SHORTED_CTL_BOX", 0.2},
                            {"VHF_VT_BURNED_OUT", 0.1},
                            {"VHF_VT207_DEFECTIVE", 0.01},
                            {"VHF_SQUELCH_RELAY", 0.8},
                        },
                    },
                    {id = "XFuelTank3", skin = "Rubber", wall = 0.036, lining = "FoamFilledRubber",
                        failures = {
                            {"ELEC_BOOSTER_FUEL_PUMP_2_FAILURE", 0.01},
                        },
                    },
                    {id = "XFuelBoosterPump2", skin = "Steel", wall = 0.001},
                    {id = "XFuelLine3", skin = "Rubber", wall = 0.014},
                    {id = "XFuelLine4", skin = "Rubber", wall = 0.014},
                    {id = "XHydroFlapsJack", skin = "Steel", wall = 0.004},
                    {id = "XCtrlLineFlaps", skin = "Steel", wall = 0.004},
                },
            },
            ["TAIL_RIGHT_SIDE"] = {
                critical_damage = 5, args = {157}, damage_boundary = 0.02,
                construction = {durability = 1.353, skin = "Aluminum"},
            },
            ["TAIL"] = {
                critical_damage = 7, args = {81},
                construction = {durability = 1.550, skin = "Aluminum", refractory = true},
                detachable = {shape = "Bf109E-oblomok_tail"},
                children = {"FIN_L_BOTTOM", "STABILIZER_L_IN", "STABILIZER_R_IN", "WHEEL_REAR"},
                innards = {
                    {id = "XCtrlLineRudder", skin = "Steel", wall = 0.004, plenum = 0.002},
                    {id = "XCtrlLineElevator", skin = "Steel", wall = 0.004, plenum = 0.002},
                    {id = "XOxygenTank", skin = "CastIron", wall = 0.012,
                        failures = {
                            {"F2_TOP_CYLINDER", 0.25},
                            {"F2_BOTTOM_CYLINDER", 0.25},
                            {"D2_LEFT_CYLINDER", 0.25},
                            {"D2_RIGHT_CYLINDER", 0.25},
                        },
                    },
                },
                failures = {
                    --{"TAIL_GEAR_FAIL_GO_DOWN", 0.01},
                    --{"TAIL_GEAR_FAIL_GO_UP", 0.01},
                    {"TAIL_GEAR_C_CABLE", 0.05},
                },
            },
            --

            -- Keel & Rudder
            ["FIN_L_BOTTOM"] = {
                critical_damage = 6, args = {243}, damage_boundary = 0.015,
                construction = {durability = 0.444, skin = "Aluminum", spar = "FlangeBeam", refractory = true},
                detachable = {shape = "Bf109E-oblomok_tail"},
                children = {"FIN_L_CENTER"},
            },
            ["FIN_L_CENTER"] = {
                critical_damage = 4, args = {242}, damage_boundary = 0.013,
                construction = {durability = 0.234, skin = "Aluminum", spar = "FlangeBeam", refractory = true},
                detachable = {shape = "Bf109E-oblomok_tail"},
                children = {"FIN_L_TOP"},
                innards = {
                    {id = "XSparKeelIn", skin = "Aluminum", wall = 0.005, plenum = 0.25, durability = 2.5},
                },
            },
            ["FIN_L_TOP"] = {
                critical_damage = 4, args = {242},
                construction = {durability = 0.268, skin = "Aluminum", spar = "FlangeBeam", refractory = true},
                detachable = {shape = "Bf109E-oblomok_tail"},
                children = {"RUDDER"},
                innards = {
                    {id = "XSparKeelOut", skin = "Aluminum", wall = 0.005, plenum = 0.25, durability = 2.5},
                },
            },
            ["RUDDER"] = {
                critical_damage = 3, args = {247},
                construction = {durability = 0.97, skin = "Aluminum", spar = "Truss"},
                detachable = {shape = "Bf109E-oblomok_tail"},
                innards = {
                    {id = "XElecElement02", skin = "Glass", wall = 0.004,
                        failures = {
                            {"ELEC_NAVLIGHT_WHITE_FAILURE", 1.0},
                        },
                    },
                    {id = "XJointR", skin = "Steel", wall = 0.015, count = 2},
                },
            },
            --

            -- Stabilizers & Elevators
            ["STABILIZER_L_IN"] = {
                critical_damage = 6, args = {236}, damage_boundary = 0.01,
                construction = {durability = 0.594, skin = "Aluminum", spar = "FlangeBeam", refractory = true},
                detachable = {shape = "Bf109E-oblomok_tail"},
                children = {"STABILIZER_L_OUT"},
                innards = {
                    {id = "XSparStabLHIn", skin = "Aluminum", wall = 0.005, durability = 2.5},
                },
            },
            ["STABILIZER_L_OUT"] = {
                critical_damage = 4, args = {235}, damage_boundary = 0.01,
                construction = {durability = 0.453, skin = "Aluminum", spar = "FlangeBeam", refractory = true},
                detachable = {shape = "Bf109E-oblomok_tail"},
                children = {"ELEVATOR_L_OUT"},
                innards = {
                    {id = "XSparStabLHOut", skin = "Aluminum", wall = 0.005, durability = 2.5},
                },
            },
            ["ELEVATOR_L_OUT"] = {
                critical_damage = 3, args = {240},
                construction = {durability = 0.605, skin = "Aluminum", spar = "Truss"},
                detachable = {shape = "Bf109E-oblomok_tail"},
                innards = {
                    {id = "XJointELH", skin = "Steel", wall = 0.015, count = 2},
                },
            },
            ["STABILIZER_R_IN"] = {
                critical_damage = 6, args = {234}, damage_boundary = 0.01,
                construction = {durability = 0.594, skin = "Aluminum", spar = "FlangeBeam", refractory = true},
                detachable = {shape = "Bf109E-oblomok_tail"},
                children = {"STABILIZER_R_OUT"},
                innards = {
                    {id = "XSparStabRHIn", skin = "Aluminum", wall = 0.005, durability = 2.5},
                },
            },
            ["STABILIZER_R_OUT"] = {
                critical_damage = 4, args = {233}, damage_boundary = 0.01,
                construction = {durability = 0.453, skin = "Aluminum", spar = "FlangeBeam", refractory = true},
                detachable = {shape = "Bf109E-oblomok_tail"},
                children = {"ELEVATOR_R_OUT"},
                innards = {
                    {id = "XSparStabRHOut", skin = "Aluminum", wall = 0.005, durability = 2.5},
                },
            },
            ["ELEVATOR_R_OUT"] = {
                critical_damage = 3, args = {238},
                construction = {durability = 0.605, skin = "Aluminum", spar = "Truss"},
                detachable = {shape = "Bf109E-oblomok_tail"},
                innards = {
                    {id = "XJointERH", skin = "Steel", wall = 0.015, count = 2},
                },
            },
            --

            -- Left Wing
            ["WING_L_IN"] = {
                critical_damage = 7, args = {225}, damage_boundary = 0.06,
                construction = {durability = 3.42, skin = "Aluminum", spar = "FlangeBeam"},
                detachable = {shape = "Bf109E-part-wing-L"},
                children = {"WING_L_CENTER", "WHEEL_L"},
                innards = {
                    {id = "XUCLockLHU", skin = "Steel", wall = 0.009,
                        failures = {
                            {"L_GEAR_DLK_FAULT", 0.05},
			    {"COOLANT_RADIATOR_WIRING", 0.025},
                    	    {"COOLANT_RADIATOR_MOTOR", 0.025},
                    	    {"COOLANT_RADIATOR_SENSOR", 0.05},
                        },
                    },
                    {id = "XSparWLHIn", skin = "Aluminum", wall = 0.005, count = 2, plenum = 0.2},
                    {id = "XHydroGearJackLH", skin = "Steel", wall = 0.004},
                    {id = "XFuelTank0", skin = "Rubber", wall = 0.036, lining = "FoamFilledRubber"},
                    {id = "XFuelBoosterPump0", skin = "Steel", wall = 0.001},
                    {id = "XFuelLine0", skin = "Rubber", wall = 0.014},
                    {id = "XHydroHoseWBrakeLH", skin = "Rubber", wall = 0.004, plenum = 0.001},
                    {id = "XCtrlLineFlapsLH", skin = "Steel", wall = 0.004},
                },
            },
            ["WING_L_CENTER"] = {
                critical_damage = 7, args = {224}, damage_boundary = 0.025,
                construction = {durability = 3.46, skin = "Aluminum", spar = "FlangeBeam", refractory = true},
                detachable = {shape = "Bf109E-part-wing-L"},
                children = {"WING_L_OUT", "FLAP_L_IN"},
                innards = {
                    {id = "XGun-100", skin = "Steel", wall = 0.006},
                    {id = "XGun-101", skin = "Steel", wall = 0.006},
                    {id = "XGun-102", skin = "Steel", wall = 0.006},
                    {id = "XSparWLHMid", skin = "Aluminum", wall = 0.005, count = 2, plenum = 0.2},
                    {id = "XAmmoBox-100", skin = "Aluminum", wall = 0.006,
                        failures = {
                            {"WEAP_GUN_02_AMMO_BELT_SEVERED", 0.11},
                        },
                    },
                },
            },
            ["WING_L_OUT"] = {
                critical_damage = 7, args = {223}, damage_boundary = 0.02,
                construction = {durability = 2.83, skin = "Aluminum", spar = "FlangeBeam", refractory = true},
                detachable = {shape = "Bf109E-part-wing-L"},
                children = {"AILERON_L"},
                innards = {
                    {id = "XCtrlLineAileronLH", skin = "Steel", wall = 0.002},
                    {id = "XSparWLHOut", skin = "Aluminum", wall = 0.005, count = 2, plenum = 0.1},
                    {id = "XElecElement00", skin = "Glass", wall = 0.004, plenum = 0.001,
                        failures = {
                            {"ELEC_NAVLIGHT_RED_FAILURE", 1.0},
                        },
                    },
                },
            },
            ["AILERON_L"] = {
                critical_damage = 3, args = {226}, damage_boundary = 0.6,
                construction = {durability = 0.625, skin = "Aluminum", spar = "Truss", refractory = true},
                detachable = {shape = "Bf109E-part-wing-L"},
                innards = {
                    {id = "XJointALH", skin = "Steel", wall = 0.015, count = 2},
                },
            },
            ["FLAP_L_IN"] = {
                critical_damage = 4, args = {227}, damage_boundary = 0.03,
                construction = {durability = 1.2, skin = "Aluminum", spar = "Truss", refractory = true},
                detachable = {shape = "Bf109E-part-wing-L"},
                innards = {
                    {id = "XJointFlapLH", skin = "Steel", wall = 0.015, count = 2},
                },
            },
            --

            -- Right Wing
            ["WING_R_IN"] = {
                critical_damage = 7, args = {215}, damage_boundary = 0.06,
                construction = {durability = 3.42, skin = "Aluminum", spar = "FlangeBeam"},
                detachable = {shape = "Bf109E-part-wing-R"},
                children = {"WING_R_CENTER", "WHEEL_R"},
                innards = {
                    {id = "XUCLockRHU", skin = "Steel", wall = 0.009,
                        failures = {
                            {"R_GEAR_DLK_FAULT", 0.05},
			    {"COOLANT_RADIATOR_WIRING", 0.025},
                    	    {"COOLANT_RADIATOR_MOTOR", 0.025},
                    	    {"COOLANT_RADIATOR_SENSOR", 0.05},
                        },
                    },
                    {id = "XSparWRHIn", skin = "Aluminum", wall = 0.005, count = 2, plenum = 0.2},
                    {id = "XHydroGearJackRH", skin = "Steel", wall = 0.004},
                    {id = "XFuelTank1", skin = "Rubber", wall = 0.036, lining = "FoamFilledRubber"},
                    {id = "XFuelBoosterPump1", skin = "Steel", wall = 0.001},
                    {id = "XFuelLine1", skin = "Rubber", wall = 0.014},
                    {id = "XHydroHoseWBrakeRH", skin = "Rubber", wall = 0.004, plenum = 0.001},
                    {id = "XCtrlLineFlapsRH", skin = "Steel", wall = 0.004},
                },
            },
            ["WING_R_CENTER"] = {
                critical_damage = 7, args = {214}, damage_boundary = 0.025,
                construction = {durability = 3.46, skin = "Aluminum", spar = "FlangeBeam", refractory = true},
                detachable = {shape = "Bf109E-part-wing-R"},
                children = {"WING_R_OUT", "FLAP_R_IN"},
                innards = {
                    {id = "XGun-103", skin = "Steel", wall = 0.006},
                    {id = "XGun-104", skin = "Steel", wall = 0.006},
                    {id = "XGun-105", skin = "Steel", wall = 0.006},
                    {id = "XSparWRHMid", skin = "Aluminum", wall = 0.005, count = 2, plenum = 0.2},
                    {id = "XAmmoBox-101", skin = "Aluminum", wall = 0.006,
                        failures = {
                            {"WEAP_GUN_03_AMMO_BELT_SEVERED", 0.11},
                        },
                    },
                },
            },
            ["WING_R_OUT"] = {
                critical_damage = 7, args = {213}, damage_boundary = 0.02,
                construction = {durability = 2.83, skin = "Aluminum", spar = "FlangeBeam", refractory = true},
                detachable = {shape = "Bf109E-part-wing-R"},
                children = {"AILERON_R"},
                innards = {
                    {id = "XCtrlLineAileronRH", skin = "Steel", wall = 0.002},
                    {id = "XSparWRHOut", skin = "Aluminum", wall = 0.005, count = 2, plenum = 0.1},
                    {id = "XElecElement01", skin = "Glass", wall = 0.004,
                        failures = {
                            {"ELEC_NAVLIGHT_GREEN_FAILURE", 1.0},
                        },
                    },
                },
            },
            ["AILERON_R"] = {
                critical_damage = 3, args = {216}, damage_boundary = 0.5,
                construction = {durability = 0.625, skin = "Aluminum", spar = "Truss", refractory = true},
                detachable = {shape = "Bf109E-part-wing-R"},
                innards = {
                    {id = "XJointARH", skin = "Steel", wall = 0.015, count = 2},
                },
            },
            ["FLAP_R_IN"] = {
                critical_damage = 4, args = {217}, damage_boundary = 0.3,
                construction = {durability = 1.2, skin = "Aluminum", spar = "Truss", refractory = true},
                detachable = {shape = "Bf109E-part-wing-R"},
                innards = {
                    {id = "XJointFlapRH", skin = "Steel", wall = 0.015, count = 2},
                },
            },
            --

            -- Undercarriage
            ["WHEEL_REAR"] = {
                critical_damage = 2, args = {134}, damage_boundary = 1.0,
                construction = {durability = 0.15, skin = "Rubber", refractory = true},
                innards = {
                    {id = "XUCShockC", skin = "Steel", wall = 0.010},
                },
            },
            ["WHEEL_R"] = {
                critical_damage = 3, args = {135}, damage_boundary = 1.0,
                construction = {durability = 0.25, skin = "Rubber", refractory = true},
                innards = {
                    {id = "XUCShockRH", skin = "Steel", wall = 0.009},
                },
            },
            ["WHEEL_L"] = {
                critical_damage = 3, args = {136}, damage_boundary = 1.0,
                construction = {durability = 0.25, skin = "Rubber", refractory = true},
                innards = {
                    {id = "XUCShockLH", skin = "Steel", wall = 0.009},
                },
            },
            --
        }),

        DamageParts = {
            [1] = "Bf109E-part-wing-R", -- wing R
            [2] = "Bf109E-part-wing-L", -- wing L
          --[3] = "D520-oblomok_nose", -- nose
            [4] = "Bf109E-oblomok_tail", -- tail
        },



        --[[AddPropAircraft = {
        },]]--



        Failures = verbose_to_failures_table({
	    { id = 'WEAP_GUN_00_AMMO_BELT_SEVERED',         label = _('HS.404 ammo belt damaged'),                          },
	    { id = 'WEAP_GUN_01_AMMO_BELT_SEVERED',         label = _('MAC 1934 ammo belt damaged'),                        },
            { id = 'WEAP_GUN_02_AMMO_BELT_SEVERED',         label = _('MAC 1934 ammo belt damaged'),                        },
	    { id = 'WEAP_GUN_03_AMMO_BELT_SEVERED',         label = _('MAC 1934 ammo belt damaged'),                        },
	    { id = 'WEAP_GUN_04_AMMO_BELT_SEVERED',         label = _('MAC 1934 ammo belt damaged'),                        },
	    { id = 'HORIZON_BAR_NOT_SETTLE',                label = _('Artificial Horizon'),                                },
            { id = 'TURNIND_POINTER_FAILS_NO_VACUUM',       label = _('Turn ind. No vac.'),                                 },
            { id = 'TURNIND_POINTER_FAILS_DEFECTIVE',       label = _('Turn ind. defective'),                               },
            { id = 'TURNIND_INCORRECT_SENS_DEFECTIVE',      label = _('Turn ind. Incorrect  sens.'),                        },
            { id = 'TURNIND_INCORRECT_SENS_VAC_HIGH',       label = _('Turn ind. Vacuum high'),                             },
            { id = 'TURNIND_INCORRECT_SENS_VAC_LOW',        label = _('Turn ind. Vacuum low'),                              },
            { id = 'TURNIND_POINTER_NOT_SET_ZERO',          label = _('Turn ind. Pointer does not set on 0(N/F)'),          },
            { id = 'TURNIND_POINTER_VIBRATES',              label = _('Turn ind. Pointer vibrates(N/F)'),                   },
            { id = 'PUMP_SEPARATOR_CLOGGED',                label = _('Vacuum pump separator clogged'),                     },
            { id = 'PUMP_RELIEF_VALVE_SCREEN_CLOGGED',      label = _('Vacuum valve screen clogged'),                       },
            { id = 'PUMP_RELIEF_VALVE_LEAKS',               label = _('Vacuum relief valve leaks'),                         },
            { id = 'PUMP_FAILS',                            label = _('Vacuum pump fails'),                                 },
            { id = 'MANIFOLD_SHIFT',                        label = _('Manifold pressure ind. pointer shifted'),            },
            { id = 'MANIFOLD_LINE_LEAK',                    label = _('Manifold pressure ind. line leak'),                  },

            { id = 'COOLANT_RADIATOR_WIRING',               label = _('Coolant radiator flap. No volt.'),                   },
            { id = 'COOLANT_RADIATOR_MOTOR',                label = _('Coolant radiator flap. Motor fault.'),               },
            { id = 'COOLANT_RADIATOR_SENSOR',               label = _('Coolant radiator sensor fault.'),                    },

            { id = 'OIL_RADIATOR_WIRING',                   label = _('Oil radiator flap. No volt.'),                       },
            { id = 'OIL_RADIATOR_MOTOR',                    label = _('Oil radiator flap. Motor fault.'),                   },
            { id = 'OIL_RADIATOR_SENSOR',                   label = _('Oil radiator sensor fault.'),                        },
            { id = 'OIL_LEAK',                              label = _('Oil Leak.'),                                         },

            { id = 'COMPASS_NO_TORQUE',                     label = _('Remote Compass. No torque'),                         },
            { id = 'COMPASS_ERRATIC_OPERATION',             label = _('Remote Compass. Erratic operation'),                 },
            { id = 'COMPASS_POINTER_PULLS',                 label = _('Remote Compass. Pointer pulls'),                     },
            { id = 'COMPASS_ERRATIC_INDIACATON',            label = _('Remote Compass. Loose pointer'),                     },

            { id = 'DEFECTIVE_INSTRUMENT',                  label = _('Directional gyro fail'),                             },
            { id = 'DEFECTIVE_MECHANISM',                   label = _('Directional gyro mechanism fail'),                   },

            { id = 'ELEC_PITOT_HEAT_WIRING',                label = _('Pitot heating wire broken'),                         },
            { id = 'ELEC_PITOT_HEAT_ELEMENT',               label = _('Pitot heating element burned out'),                  },
            { id = 'BAT_SOLENOID_WIRING',                   label = _('Bat. solenoid wiring fault'),                        },
            { id = 'BAT_SOLENOID_DEFECTIVE',                label = _('Bat. solenoid defective'),                           },

            { id = 'SUPERCHARGER_LIGHT',                    label = _('Supercharger light fault'),                          },
            { id = 'SUPERCHARGER_WIRE',                     label = _('Supercharger wiring fault'),                         },
            { id = 'SUPERCHARGER_SOLENOID',                 label = _('Supercharger solenoid fault'),                       },
            { id = 'OIL_DILUTION_SOLENOID',                 label = _('Oil dilution solenoid fault'),                       },
            { id = 'OIL_DILUTION_WIRE',                     label = _('Oil dilution wiring fault'),                         },

            { id = 'TACH_BREAK_CIRCUIT',                    label = _('Tachometer circuit break'),                          },
            { id = 'TACH_BREAK_IN_INDICATOR',               label = _('Tachometer indicator break'),                        },
            { id = 'TACH_POOR_CONNECTION',                  label = _('Tachometer poor connection'),                        },
            { id = 'TACH_RESISTANCE_ADJ',                   label = _('Tachometer indicator adjustment fault'),             },

            { id = 'VHF_CRYSTAL',                           label = _('Radio. Crystal or tube failure'),                    },
            { id = 'VHF_SHORTED_CTL_BOX',                   label = _('Radio. Shorted control box'),                        },
            { id = 'VHF_VT_BURNED_OUT',                     label = _('Radio. Receiver burned out'),                        },
            { id = 'VHF_VT207_DEFECTIVE',                   label = _('Radio. Squelch tube burned out'),                    },
            { id = 'VHF_SQUELCH_RELAY',                     label = _('Radio. Squelch relay not working'),                  },

            { id = 'F2_TOP_CYLINDER',                       label = _('Top oxygen cylinder leakage'),                       },
            { id = 'F2_BOTTOM_CYLINDER',                    label = _('Bottom oxygen cylinder leakage'),                    },
            { id = 'D2_LEFT_CYLINDER',                      label = _('Left oxygen cylinder leakage'),                      },
            { id = 'D2_RIGHT_CYLINDER',                     label = _('Right oxygen cylinder leakage'),                     },

            { id = 'COOLANT_BREAK_BULB',                    label = _('Coolant temp. ind. bulb fault'),                     },
            { id = 'COOLANT_DEFECTIVE_IND',                 label = _('Coolant temp. ind. defective'),                      },
            { id = 'COOLANT_POOR_CONNTECT',                 label = _('Coolant temp. ind. poor connection'),                },
            { id = 'COOLANT_SHORT_CIRCUIT',                 label = _('Coolant temp. ind. short circuit'),                  },

            { id = 'CARBAIR_SHORT_CIRCUIT',                 label = _('Carb. air ind. open or short circuit'),              },
            { id = 'CARBAIR_SHORT_CIRCUIT_LEADS',           label = _('Carb. air ind. short circuit in leads'),             },
            { id = 'CARBAIR_GND_LEAD',                      label = _('Carb. air ind. gnd in leads'),                       },
            { id = 'CARBAIR_SHORT_CIRCUIT_BLB',             label = _('Carb. air ind. bulb short circuit'),                 },
            { id = 'CARBAIR_BREAK_LEADS',                   label = _('Carb. air ind. breaks in leads'),                    },
            { id = 'CARBAIR_OPEN_CIRCUIT_BLB',              label = _('Carb. air ind. open circuit in bulb'),               },

            { id = 'HYDR_EXTERNAL_LEAKAGE',                 label = _('External hydro leak'),                               },
            { id = 'HYDR_INTERNAL_LEAKAGE',                 label = _('Internal hydro leak'),                               },
            { id = 'HYDR_ACCUMULATOR_LOW_AIR_PRESSURE',     label = _('Hydro acc. low air pressure'),                       },
            { id = 'HYDR_UNLOAD_VALVE_NOT_LOAD',            label = _('Hydro relief valve stuck in unload'),                },
            { id = 'HYDR_UNLOAD_VALVE_NOT_UNLOAD',          label = _('Hydro relief valve stuck in load'),                  },

            { id = 'UNCR_LH_STRUT_DOWN_LOCK_FAILURE',       label = _('Left gear downlock fail'),                           },
            { id = 'UNCR_RH_STRUT_DOWN_LOCK_FAILURE',       label = _('Right gear downlock fail'),                          },
            { id = 'UNCR_C_STRUT_DOWN_LOCK_FAILURE',        label = _('Tail gear downlock fail'),                           },
            { id = 'UNCR_C_STRUT_UP_LOCK_FAILURE',          label = _('Tail gear lock spring broken'),                      },
            --{ id = 'TAIL_GEAR_FAIL_GO_DOWN',                label = _('Tail gear up-latch cable broken'),                   },
            --{ id = 'TAIL_GEAR_FAIL_GO_UP',                  label = _('Tail gear down-lock cable broken'),                  },
            { id = 'TAIL_GEAR_C_CABLE',                     label = _('Tail gear cable jammed'),                            },
            { id = 'UNCR_LH_STRUT_UP_LOCK_FAILURE',         label = _('Left gear up-latch locked'),                         },
            { id = 'UNCR_RH_STRUT_UP_LOCK_FAILURE',         label = _('Right gear up-latch locked'),                        },
            { id = 'L_GEAR_DLK_FAULT',                      label = _('Left gear down-lock locked'),                        },
            { id = 'R_GEAR_DLK_FAULT',                      label = _('Right gear down-lock locked'),                       },
            { id = 'DOORS_TV_JAMMED',                       label = _('Doors timing valve jammed'),                         },
            { id = 'DOORS_TVC_BROKEN',                      label = _('Doors timing valve cable broken'),                   },

            { id = 'IGNITION_NO_OUTPUT',                    label = _('Ignition condenser burned out'),                     },
            { id = 'IGNITION_TERM_CONNECT',                 label = _('Ignition terminal connection fault'),                },
            { id = 'BOOSTER_COIL',                          label = _('Booster coil fault'),                                },

            { id = 'ELEC_STARTER_LOOM_SEVERED',             label = _('Starter wiring fault'),                              },
            { id = 'ELEC_STARTER_RELAY_FAILURE',            label = _('Starter relay fault'),                               },
            { id = 'ELEC_STARTER_SOLENOID_FAILURE',         label = _('Starter solenoid fault'),                            },
            { id = 'ELEC_GENERATOR_FAILURE',                label = _('Generator failure'),                                 },
            { id = 'ELEC_NAVLIGHT_RED_FAILURE',             label = _('LH nav. light failure'),                             },
            { id = 'ELEC_NAVLIGHT_GREEN_FAILURE',           label = _('RH nav. light failure'),                             },
            { id = 'ELEC_NAVLIGHT_WHITE_FAILURE',           label = _('Aft nav. light failure'),                            },

            { id = 'FUEL_ENGINE0_FUEL_PUMP_FAILURE',        label = _('Fuel pump defective'),                               },
            { id = 'INSUF_FUEL_PRES',                       label = _('Fuel pressure insufficient'),                        },
            { id = 'CLOGGED_FUEL_STRAINER',                 label = _('Fuel strainer clogged'),                             },
            { id = 'FUEL_VALVE_LEAK',                       label = _('Fuel valve leak'),                                   },
            { id = 'FUEL_BOOSTER_FUEL_PUMP_0_FAILURE',      label = _('Left tank pump fault'),                              },
            { id = 'FUEL_BOOSTER_FUEL_PUMP_1_FAILURE',      label = _('Right tank pump fault'),                             },
            { id = 'FUEL_TANK_00_LEAK_STOPPED',             label = _('Left fuel tank leak stopped'),     hidden = true,    },
            { id = 'FUEL_TANK_00_MINOR_LEAK',               label = _('Left fuel tank minor leak'),       hidden = true,    },
            { id = 'FUEL_TANK_00_MEDIUM_LEAK',              label = _('Left fuel tank major leak'),       hidden = true,    },
            { id = 'FUEL_TANK_00_MAJOR_LEAK',               label = _('Left fuel tank ruptured'),         hidden = true,    },
            { id = 'FUEL_TANK_00_FIRE_STOPPED',             label = _('Left fuel tank fire stopped'),     hidden = true,    },
            { id = 'FUEL_TANK_00_FIRE',                     label = _('Left fuel tank is on fire'),       hidden = true,    },
            { id = 'FUEL_TANK_00_EXPLODED',                 label = _('Left fuel tank exploded'),         hidden = true,    },
            { id = 'FUEL_TANK_01_LEAK_STOPPED',             label = _('Right fuel tank leak stopped'),  hidden = true,      },
            { id = 'FUEL_TANK_01_MINOR_LEAK',               label = _('Right fuel tank minor leak'),    hidden = true,      },
            { id = 'FUEL_TANK_01_MEDIUM_LEAK',              label = _('Right fuel tank major leak'),    hidden = true,      },
            { id = 'FUEL_TANK_01_MAJOR_LEAK',               label = _('Right fuel tank ruptured'),      hidden = true,      },
            { id = 'FUEL_TANK_01_FIRE_STOPPED',             label = _('Right fuel tank fire stopped'),  hidden = true,      },
            { id = 'FUEL_TANK_01_FIRE',                     label = _('Right fuel tank is on fire'),    hidden = true,      },
            { id = 'FUEL_TANK_01_EXPLODED',                 label = _('Right fuel tank exploded'),      hidden = true,      },
            { id = 'FUEL_TANK_03_LEAK_STOPPED',             label = _('Fuselage fuel tank leak stopped'),     hidden = true,},
            { id = 'FUEL_TANK_03_MINOR_LEAK',               label = _('Fuselage fuel tank minor leak'),       hidden = true,},
            { id = 'FUEL_TANK_03_MEDIUM_LEAK',              label = _('Fuselage fuel tank major leak'),       hidden = true,},
            { id = 'FUEL_TANK_03_MAJOR_LEAK',               label = _('Fuselage fuel tank ruptured'),         hidden = true,},
            { id = 'FUEL_TANK_03_FIRE_STOPPED',             label = _('Fuselage fuel tank fire stopped'),     hidden = true,},
            { id = 'FUEL_TANK_03_FIRE',                     label = _('Fuselage fuel tank is on fire'),       hidden = true,},
            { id = 'FUEL_TANK_03_EXPLODED',                 label = _('Fuselage fuel tank exploded'),         hidden = true,},

            { id = 'ENG0_BOOST_REGULATOR_MALFUNCTION',      label = _('Boost regulator failure'),                           },
            { id = 'ENG0_GOVERNOR_FAILURE',                 label = _('Prop governor failure'),                             },
            { id = 'ENG0_MAGNETO0',                         label = _('Magneto 1 failure'),                                 },
            { id = 'ENG0_MAGNETO1',                         label = _('Magneto 2 failure'),                                 },
            { id = 'ENG0_JAMMED',                           label = _('Engine jam'),                                        },
            { id = 'COOLANT_UNPRES',                        label = _('Coolant system unpressurized'),                      },
            { id = 'ELEC_BATTERY_OVERHEAT',                 label = _('Battery overheated'),                                },
            { id = 'ELEC_STARTER_BURNOUT',                  label = _('Starter burn out'),                                  },

            { id = 'K14_NO_POWER_SUPPLY',                   label = _('K-14. No power supply.'),                            },
            { id = 'K14_FIXED_LAMP_DEFECTIVE',              label = _('K-14. Fixed reticle lamp defective'),                },
            { id = 'K14_MOV_LAMP_DEFECTIVE',                label = _('K-14. Movable reticle lamp defective'),              },
            { id = 'K14_MOTOR_DEFECTIVE',                   label = _('K-14. Motor defective'),                             },
        }),

-----------------------------------------------------------------------------------
---  Light Section
-----------------------------------------------------------------------------------

    lights_data = {
        typename = "collection",
	lights = {
                [WOLALIGHT_LANDING_LIGHTS] = {
                    typename = "collection",
                    lights = {
                        {
                            typename = "collection",
                            lights = {
                                {
                                    typename = "Spot", position = {3.853, -1.112, -0.106}, argument = 208,   dir_correction = {elevation = math.rad(-6.0)},
                                    proto = lamp_prototypes.LFS_P_27_200, angle_max = math.rad(50.0), angle_max = math.rad(40.0),
                                    exposure = {{5, 0.090, 0.095}}, movable = true, power_up_t = 0.9,
                                },
                                {
                                    typename = "Spot", position = {3.853, -1.112, -0.206}, 
                                    proto = lamp_prototypes.LFS_P_27_200, range = 18.0, angle_max = math.rad(180.0), angle_max = math.rad(180.0),
                                    exposure = {{5, 0.090, 0.095}}, movable = true, power_up_t = 0.9,
                                },
                            },
                        },
                    },
                },
                [WOLALIGHT_TAXI_LIGHTS] = {
                    typename = "collection",
                    lights = {
                        {
                            typename = "collection",
                            lights = {
                                {
                                   typename = "Spot", position = {3.853, -1.112, -0.106}, argument = 208,   dir_correction = {elevation = math.rad(-6.0)}, 
                                    proto = lamp_prototypes.LFS_P_27_200, angle_max = math.rad(50.0), angle_max = math.rad(40.0),
                                    exposure = {{5, 0.090, 0.095}}, movable = true, power_up_t = 0.9,
                                },
                                {
                                    typename = "Spot", position = {3.853, -1.112, -0.106},  
                                    proto = lamp_prototypes.LFS_P_27_200, range = 18.0, angle_max = math.rad(180.0), angle_max = math.rad(180.0),
                                    exposure = {{5, 0.090, 0.095}}, movable = true, power_up_t = 0.9,
                                },
                            },
                        },
                    },
                },
	
				 
				
              	[3] = {
			typename = "collection", -- left nav light
			lights = {
				{typename = "argumentlight",argument = 190}, -- left nav light red
				{typename = "argumentlight",argument = 191}, -- tail nav light white
				{typename = "argumentlight",argument = 192}, -- right nav light green
			},
		},
		[4] = { 
			typename = "collection", -- tail nav light
			lights = {
				{typename = "argnatostrobelight",connector = "RED_BEACON R",argument = 83,period = 2.0,color = {1.0, 0.0, 0.0},phase_shift = 0.0},
				{typename = "argnatostrobelight",connector = "RED_BEACON R",argument = 802,period = 2.0,color = {1.0, 0.0, 0.0},phase_shift = 0.0},
                     		{typename = "argumentlight",argument = 200}, 
			},
		},			    
	}
    }, -- end lights_data


}

    if rewrite_settings then 
       for i,o in pairs(rewrite_settings) do
            AIRCRAFT[i] = o
       end
    end

    AIRCRAFT.shape_table_data[1].file     = AIRCRAFT.Shape
    AIRCRAFT.shape_table_data[1].username = AIRCRAFT.Name

    return AIRCRAFT

end   


add_aircraft(make_Bf109E({
    Name = "Bf109E-3",
    DisplayName = _("Bf 109E-3"),
    Shape = "Bf109E",
}))
