param(
    # Root folder where all the aircraft joystick folders live
    # Example: "C:\Users\YOU\Saved Games\DCS.openbeta\Config\Input"
    [string]$Root = "."
)

# Map: OLD UUID  ->  NEW UUID
$GuidMap = @{
    '758B9BE0-CBDD-11f0-8001-444553540000' = 'E1324450-E7FF-11f0-800D-444553540000' # Orion Throttle
    '8F8340C0-CBDD-11f0-8002-444553540000' = 'E1324450-E7FF-11f0-8010-444553540000' # JGRIP F16 Base
    '9D3B3740-CBDD-11f0-8003-444553540000' = 'E1324450-E7FF-11f0-800E-444553540000' # Rudder Pedals
    # Add more here if needed
}

# Backup root for any "new" files we overwrite
$backupRoot = Join-Path $Root ("backup_before_uuid_rename_" + (Get-Date -Format "yyyyMMddHHmmss"))
New-Item -ItemType Directory -Path $backupRoot -Force | Out-Null

Get-ChildItem -Path $Root -Recurse -Filter '*.diff.lua' | ForEach-Object {
    $file = $_

    foreach ($oldGuid in $GuidMap.Keys) {
        # We look for {OLDGUID} in the filename
        $pattern = "{${oldGuid}}"
        if ($file.Name -like "*$pattern*") {
            $newGuid = $GuidMap[$oldGuid]
            $newPattern = "{${newGuid}}"

            $newName = $file.Name -replace [Regex]::Escape($pattern), $newPattern
            $newPath = Join-Path $file.DirectoryName $newName

            # If a file with the new GUID already exists (the default new one),
            # move it into backup before renaming the old one.
            if (Test-Path $newPath) {
                # Recreate directory structure under backup folder
                $relativeDir = $file.DirectoryName.Substring($Root.Length).TrimStart('\','/')
                $backupDir   = Join-Path $backupRoot $relativeDir
                New-Item -ItemType Directory -Path $backupDir -Force | Out-Null

                $backupTarget = Join-Path $backupDir (Split-Path $newPath -Leaf)
                Move-Item -Path $newPath -Destination $backupTarget -Force
            }

            Rename-Item -Path $file.FullName -NewName $newName -Force
            Write-Host "Renamed:`n  $($file.FullName)`n  -> $newName`n"
            break
        }
    }
}

Write-Host "Done. Backup of overwritten files is in:"
Write-Host "  $backupRoot"
