--Initial campaign triggers (static file, not updated)
--Copied to Status/camp_triggers.lua in first mission and subsequently read and updated there
--Campaign triggers are defined with conditions and actions
-------------------------------------------------------------------------------------------------------

--List of Return functions to build conditions:
--Return.Time()												returns time of day in seconds
--Return.Day()												returns day of month
--Return.Month()											returns month as number
--Return.Year()												returns year as number
--Return.Mission()											returns campaign mission number
--Return.CampFlag(flag-n)									returns value of campaign flag
--Return.AirUnitActive("UnitName")							returned boolean whether the air unit is active			
--Return.AirUnitReady("UnitName")							returns amount of ready aircraft in unit
--Return.AirUnitAlive("UnitName")							returns amount of ready and damaged aircraft in unit
--Return.AirUnitBase("UnitName")							returns the name of the airbase the unit operats from
--Return.AirUnitPlayer("UnitName")							returns boolean whether the air units is playable
--Return.TargetAlive("TargetName")							returns percentage of alive sub elements in target
--Return.UnitDead(unitname)									(ADD) return vehicle/ship units dead (ADD)
--Return.GroupHidden("GroupName")							returns group hidden status
--Return.GroupProbability("GroupName")						returns group spawn probability value between 0 and 1
--Return.ShipGroupInPoly(GroupName, PolyZonesTable)			(ADD) return boolean whether ship group is in polygon (ADD)

--List of Action functions for trigger actions:
--Action.None()
--Action.Text("your briefing text")
--Action.TextPlayMission(arg)																--add trigger text to briefing text of this mission only if it is playable
--Action.SetCampFlag(flag-n, boolean/number)												--
--Action.AddCampFlag(flag-n, number)														--
--Action.AddImage("filname.jpg")															--
--Action.CampaignEnd("win"/"draw"/"loss")													--
--Action.TargetActive("TargetName", boolean)												--
--Action.AirUnitActive("UnitName", boolean)													--
--Action.AirUnitBase("UnitName", "BaseName")												--
--Action.AirUnitPlayer("UnitName", boolean)													--
--Action.AirUnitReinforce("SourceUnitName", "DestinationUnitName", destNumber)				--
--Action.AirUnitRepair()																	--
--Action.GroundUnitRepair()																	-- (ADD) M19.f : Repair Ground
--Action.AddGroundTargetIntel("sideName")													--
--Action.GroupHidden("GroupName", boolean)													--
--Action.GroupProbability("GroupName", number 0-1)											--
--Action.GroupMove(GroupName, ZoneName)														-- (ADD) move vehicle group to refpoint (See the DC_CheckTriggers.lua file for more explanation)
--Action.GroupSlave(GroupName, master, bearing, distance)									-- (ADD)
--Action.ShipMission(GroupName, WPtable, CruiseSpeed, PatrolSpeed, StartTime)				-- (ADD) assign and run a movement mission to a ship group (See the DC_CheckTriggers.lua file for more explanation)
--Action.TemplateActive(TabFile)															-- (ADD) M40 : Template Active GroundGroup moving front (single file : active template) (if tab file: random activation)



--Important notes:
--for condition and action strings: outside with single quotes '', inside with double quotes ""!

camp_triggers = {
	
	----- CAMPAIGN INTRO ----
	["Campaign Briefing"] = {										--Trigger name
		active = true,												--Trigger is active
		once = true,												--Trigger is fired once
		condition = 'true',											--Condition of the trigger to return true or false embedded as string
		action = {													--Trigger action function embedded as string
			[1] = 'Action.Text("In a desperate try to free from russian tyrany, Georgia patriots tried to bring down the governement. This action was reprimed with violence by russian troops and loyal Georgian forces. Many civilians were killed and tortured to prevent any other freedom movements. United Nations were not able to stop russians violences and the United States of America decided to do something to convince Russia to stop this. Turkish government was not ready to open his bases to US attack planes and only one Navy Task Force can be sent near Georgian coasts to show Russia they have to stop violence in Georgia.")',
			[2] = 'Action.Text("The US Navy has sent considerable forces near Georgia. The Task Force 71 is leaded by the CVN-71 Theodore Roosevelt. At the forefront are the F/A-18C of the VFA-106 and VMFA-312 who are tasked to attack Russian air defenses, Airbases and many strategical targets in Georgia like bridges train stations and Harbors with the help of VA-176 and VA-65 A-6E Intruders. Air superiority and strikers escort will be the mission of the VF-31 and VF-143 with their legendary F-14A Tomcats. E-2D will provide AWACS constant cover. Together these squadrons form a powerful and mighty force. We hope to have USAF Bombers support soon with B-1B and B-52H long range missions.")',
			[3] = 'Action.Text("The Russian Air Force is flying a mix of MiG-21, MiG-25 and MiG-23 fighters directed by ground based early warning radar. Air bases and target complexes of high value are protected by a variety of surface-air missile systems, such as the Sa-2 Guindeline, SA-6 Gainful, the SA-8 Gecko and the SA-3 Goa, as well as short-range IR-SAMs and AAA. Our goal will be to gain air superiority over Georgia by neutralizing main bases in the country and destroying SAM systems. Russia Homeland is strictly forbidden. You are not allowed to attack ground target in Russia but air to air combat can be initiated near and over Russia. Our Task Force can be targeted by Russians anti-ship fleet : Su-24, Tu-22 and TU-142 with dangerous missiles")',
			[4] = 'Action.AddImage("Newspaper_FirstNight_blue.jpg", "blue")',
			[5] = 'Action.AddImage("Newspaper_FirstNight_red.jpg", "red")',
		},
	},
	
----- CAMPAIGN SITUATION -----
	["Campaign first destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 100',
		action = {
			[1] = 'Action.Text("First targets have been destroyed. Keep up the good work")',
		},
	},
	["Campaign 20 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 80',
		action = {
			[1] = 'Action.Text("Enemy targets have sustained fair damages. Keep up the good work")',
		},
	},
	["Campaign 40 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 60',
		action = {
			[1] = 'Action.Text("Enemy targets have sustained great damages. Strike missions are really efficient and we will win this war soon")',
		},
	},
	["Campaign 50 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 50',
		action = {
			[1] = 'Action.Text("More than half of our targets are neutralized. Intelligence think that the enemy will ask for a cease fire soon")',
		},
	},

	
	----- CAMPAIGN END -----
	["Campaign End Victory 1"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 60',
		action = {
			'Action.CampaignEnd("win")',
			'Action.Text("The US Navy units deployed off the coasts of Georgia have successfully destroyed all the targets that they were assigned by US Central Command. With the complete destruction of the Russian airforce over Georgia, the air campaign of this war comes to an end. Russian will soon begin to withdraw from Georgia. Well done.")',
			'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Victory 2"] = {
		active = true,
		once = true,
		condition = 'Return.totalAirUnitAliveBySide("red") < 10',
		action = {
			'Action.CampaignEnd("win")',
			'Action.Text("Russian forces are completly defeated. After repeated air strikes and disastrous losses in air-air combat, the russians are no longer able to produce any sorties or offer any resistance. The US Navy now owns complete air superiority. With the disappearance of the air threat, we hope that russians will decide to leave Georgia quickly. Well done.")',
			'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("VFA-106") < 2 or Return.AirUnitActive("VFA-106") == false',
		action = {
			'Action.CampaignEnd("loss")',
			'Action.Text("Ongoing combat operations have exhausted your squadron. Loss rate has reached a level where reinforcements are no longer able to sustain combat operations. With the failure of US Navy Air Force to attain air superiority, US Central Command has decided to call of the air campaign against the Russians. They will be abble to stay in Georgia and our diplomatic power in the world is really weaked by this defeat.")',
			'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss 2"] = {
		active = true,
		once = true,
		condition = 'Return.UnitDead("CVN-72 Abraham Lincoln") and Return.UnitDead("CVN-71 Theodore Roosevelt")',
		action = {
			'Action.CampaignEnd("loss")',
			'Action.Text("After all CVN have been hit by air strikes and sunk, Squadrons are no longer able to fly. Most of their planes are deep into the Caucasian waters and it will need a long time to restore those unit s capabilities. This is a bitter failure for the Navy")',
			'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			'NoMoreNewspaper = true',
		},
	},	
	["Campaign End Draw"] = {
		active = true,
		once = true,
		condition = 'MissionInstance == 40',
		action = {
			'Action.CampaignEnd("draw")',
			'Action.Text("The air campaign has seen a sustained period of inactivity. Seemingly unable to complete the destruction of the Russian Air Force and infrastructure, US Central Command has called off all squadrons from offensive operations. We hope negociations with Russians will convince them to withdraw from Georgia")',
			'NoMoreNewspaper = true',
		},
	},
	["CVN-72 Abraham Lincoln sunk"] = {
		active = true,
		condition = 'Return.UnitDead("CVN-72 Abraham Lincoln")',
		action = {
			-- 'db_airbases["CVN-73 George Washington"].inactive = true',
			-- 'Action.moveToAnotherBaseOrDeactivate("VMFA-312", { "CVN-71 Theodore Roosevelt"})',
			-- 'Action.moveToAnotherBaseOrDeactivate("VF-143", { "CVN-71 Theodore Roosevelt"})',
			-- 'Action.moveToAnotherBaseOrDeactivate("VAW-125-2", { "CVN-71 Theodore Roosevelt"})',
			-- 'Action.moveToAnotherBaseOrDeactivate("174 ARW-2", { "CVN-71 Theodore Roosevelt"})',
			-- 'Action.moveToAnotherBaseOrDeactivate("175 ARW-2", { "CVN-71 Theodore Roosevelt"})',
			'Action.Text("After the CVN-72 Abraham Lincoln has been hit by air strikes and sunk, Squadrons will try to transfert to CVN-71 or will not be able to fly anymore")',
		}
	},	
	
	
	----- CARRIER MOVEMENT -----
	["TF-71 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("TF-71", {{"Indy 1-1", "Indy 1-2", "Indy 1-3", "Indy 1-4"}}, 10, 8, nil)',
	},
	["TF-72 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("TF-72", {{"Indy 2-1", "Indy 2-2", "Indy 2-3", "Indy 2-4"}}, 10, 8, nil)',
	},
	["LHA-Group Far from Georgian Coasts"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = {
			[1] = 'Action.ShipMission("LHA-Group", {{"Indy 3-1", "Indy 3-2", "Indy 3-3", "Indy 3-4"}}, 10, 8, nil)',
		}	
	},
	["LHA Group Close to Georgian Coasts"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitReady("368.ShAP") + Return.AirUnitReady("559.BAP") + Return.AirUnitReady("52.TBAP") + Return.AirUnitReady("959.BAP") + Return.AirUnitReady("79.TBAP") < 10',
		action = {
			[1] = 'Action.ShipMission("LHA Group", {{"Indy 3-5", "Indy 3-6", "Indy 3-7", "Indy 3-8"}}, 10, 8, nil)',
			[2] = 'Action.Text("After the estimated near destruction of all the enemy anti-ship air squadrons, LHA Group is allowed to move closer of Georgian coast.")',
		}	
	},
	
	 ----- SQUADRON RELOCALIZATION --------------
	
	
	["All Missions relocalization after CVN-71 loss"] = {
		active = true,
		once = true,
		condition = 'Return.UnitDead("CVN-71 Theodore Roosevelt")',
		action = {						
			'Action.TargetActive("CVN-71 Theodore Roosevelt Interception", false)',
			'Action.TargetActive("Battle Group CAP", false)',
			'Action.TargetActive("Battle Group CAP 2", false)',
			'Action.TargetActive("Battle Group AEW", false)',
			'Action.TargetActive("Roosevelt SAR Alert", false)',			
			'Action.TargetActive("Mission Support Tanker", false)',
			'Action.TargetActive("Mission Support Tanker 2", false)',
			'Action.TargetActive("Recovery Tanker", false)',
			'Action.TargetActive("Recovery Tanker 2", false)',
			'Action.TargetActive("Battle Group CAP 2-CVN72", true)',
			'Action.TargetActive("Mission Support Tanker 2-CVN72", true)',
			'Action.TargetActive("Recovery Tanker-CVN72", true)',
			'Action.TargetActive("Recovery Tanker 2-CVN72", true)',
		},
	},
	["All Missions relocalization after CVN-72 loss"] = {
		active = true,
		once = true,
		condition = 'Return.UnitDead("CVN-72 Abraham Lincoln")',
		action = {						
			'Action.TargetActive("CVN-72 Abraham Lincoln Interception", false)',
			'Action.TargetActive("Battle Group CAP-CVN72", false)',
			'Action.TargetActive("Battle Group CAP 2-CVN72", false)',
			'Action.TargetActive("Battle Group AEW-CVN72", false)',
			'Action.TargetActive("Lincoln SAR Alert", false)',			
			'Action.TargetActive("Mission Support Tanker-CVN72", false)',
			'Action.TargetActive("Mission Support Tanker 2-CVN72", false)',
			'Action.TargetActive("Recovery Tanker-CVN72", false)',
			'Action.TargetActive("Recovery Tanker 2-CVN72", false)',
		},
	},
	["All Squadrons relocalization after LHA Tarawa loss"] = {
		active = true,
		once = true,
		condition = 'Return.UnitDead("LHA_Tarawa")',      
		action = {
			'Action.Text("After the LHA Tarawa has been hit by air strikes, all squadrons planes are no longer able to operate from this platform.")',
		},
	},
	["All Missions relocalization after LHA Tarawa"] = {
		active = true,
		once = true,
		condition = 'Return.UnitDead("LHA_Tarawa")',
		action = {
			'Action.TargetActive("Tarawa SAR Alert", false)',
		},
	},

	----- CONVOY MOVEMENT -----
	["Cargo convoy 1 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("Cargo convoy 1", {{"Ships 1-1", "Ships 1-2", "Ships 1-3", "Ships 1-4"}}, 8, 5, nil)',
	},
	["Cargo convoy 2 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("Cargo convoy 2", {{"Ships 1-5", "Ships 1-4", "Ships 1-3", "Ships 1-2"}}, 8, 5, nil)',
	},


	----- UNIT ACTIVATION -----
	["Unit Activate B-52H"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("SA-2 Guideline Site N1") == 0 and Return.TargetAlive("SA-2 Guideline Site N2") == 0 and Return.TargetAlive("SA-2 Guideline Site C1") == 0 and Return.TargetAlive("SA-2 Guideline Site S1") == 0',
		action = {
			[1] = 'Action.AirUnitActive("96 BW", true)',
			[2] = 'Action.AirUnitActive("69 BS", true)',
			[3] = 'Action.Text("After Russians SAM sites destruction, B-52H from 96 BS will begin long range missions against important targets such as airbases, railway stations and bridges. They will need air protection")',
			-- [4] = 'Action.AddImage("Newspaper_Phantom.jpg")',
		},
	},	

	
	
	----- RED CAP -----
	["CAP After EWR Destroyed"] = {
		active = true,
		condition = 'Return.TargetAlive("EWR 1 501") == 0 and Return.TargetAlive("EWR 2 502") == 0 and Return.TargetAlive("EWR 3 503") == 0',
		action = {
			'Action.TargetActive("CAP Red North", true)',
			'Action.TargetActive("CAP Red Center", true)',
			'Action.TargetActive("CAP Red South", true)',
			'Action.TargetActive("Batumi Interception 1", false)',
			'Action.TargetActive("Sukhumi Interception 1", false)',
			'Action.TargetActive("Gudauta Interception 1", false)',
			'Action.TargetActive("Kutaisi Interception 1", false)',
			'Action.TargetActive("Mozdok Interception 1", false)',
			'Action.Text("With the recent destruction of all Early Warning Radar sites in the operations area, the ability of the enemy to launch interceptors against our strike packages was severely degraded. Intelligence expects that the enemy will increasingly depend on Combat Air Patrols to compensate, though without the support of ground controllers these are estimated to be of limited effectiveness.")',
		},
	},
	
	
	----- REPAIR AND REINFORCEMENTS -----
	["Repair"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitRepair()',
	},
	["GroundUnitRepair"] = {
		active = true,
		condition = 'true',
		action = 'Action.GroundUnitRepair()',
	},

	
	---- GROUND TARGET STATUS ---
	["Blue Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("blue")',
	},
	["Red Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("red")',
	},
}


