
local RP35_empty_w = 160.0

local fuelTank_RP35_cmn =
{
	category   			= CAT_FUEL_TANKS,
	attribute  			= {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
	Picture   			= "ftm1.png",
	Cx_pil				= 0.001,
	Weight_Empty  		= RP35_empty_w,
	Capacity   			= 898.0,
	
	shape_table_data =
	{
		{
			file    	= "PTB_1200_F1";
			life    	= 1;
			fire    	= {0, 1};
			username 	= "RP35 Pylon Fuel Tank (1137 l usable)";
			index 		= WSTYPE_PLACEHOLDER;
		},
	},
	
	Elements = 
	{
		{
			Position 	= {0, 0, 0},
			Rotation 	= {0, 0, 0},
			ShapeName 	= "PTB_1200_F1",
		},
	}, 
}

-- fuel tank 1200 liters (full)
local fuelTank_RP35_full = {}
copyTable(fuelTank_RP35_cmn, fuelTank_RP35_full)

fuelTank_RP35_full.CLSID    	= "PTB-1200-F1"
fuelTank_RP35_full.displayName	= _("RP35 Pylon Fuel Tank (1137 l usable)")
fuelTank_RP35_full.Weight    	= RP35_empty_w + 898.0

declare_loadout(fuelTank_RP35_full)

-- fuel tank 1200 liters (empty)
local fuelTank_RP35_empty = {}
copyTable(fuelTank_RP35_cmn, fuelTank_RP35_empty)

fuelTank_RP35_empty.CLSID    	= "PTB-1200-F1-EMPTY"
fuelTank_RP35_empty.displayName	= _("RP35 Pylon Fuel Tank (1137 l usable) [Empty]")
fuelTank_RP35_empty.Weight    	= RP35_empty_w

declare_loadout(fuelTank_RP35_empty)


local RPL201_empty_w = 265.0

local fuelTank_RPL201_cmn =
{
	category   			= CAT_FUEL_TANKS,
	attribute  			=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
	Picture   			= "ftm1.png",
	Cx_pil				= 0.001,
	Weight_Empty  		= RPL201_empty_w,
	Capacity    		= 1825.0,
	
	shape_table_data = 
	{
		{
			file    	= "PTB_580G_F1";
			life    	= 1;
			fire    	= { 0, 1};
			username 	= "RPL201 Pylon Fuel Tank (2310 l usable)";
			index 		= WSTYPE_PLACEHOLDER;
		},
	},
	
	Elements = 
	{
		{
			Position 	= {0, 0, 0},
			Rotation 	= {0, 0, 0},
			ShapeName 	= "PTB_580G_F1",
		}, 
	}, 
}

-- fuel tank 580 gal (full)
local fuelTank_RPL201_full = {}
copyTable(fuelTank_RPL201_cmn, fuelTank_RPL201_full)

fuelTank_RPL201_full.CLSID    		= "PTB-580G-F1"
fuelTank_RPL201_full.displayName	= _("RPL201 Pylon Fuel Tank (2310 l usable)")
fuelTank_RPL201_full.Weight    	= RPL201_empty_w + 1825.0

declare_loadout(fuelTank_RPL201_full)

-- fuel tank 580 gal (empty)
local fuelTank_RPL2201_empty = {}
copyTable(fuelTank_RPL201_cmn, fuelTank_RPL2201_empty)

fuelTank_RPL2201_empty.CLSID    	= "PTB-580G-F1-EMPTY"
fuelTank_RPL2201_empty.displayName	= _("RPL201 Pylon Fuel Tank (2310 l usable) [Empty]")
fuelTank_RPL2201_empty.Weight    	= RPL201_empty_w

declare_loadout(fuelTank_RPL2201_empty)

declare_loadout(
	{
		category 			= CAT_PODS,
		CLSID				= "BARAX_ECM",
		Picture				= "ALQ184.png",
		attribute			= {4, 15, 45, WSTYPE_PLACEHOLDER},
		Weight				= 85,
		Cx_pil				= 0.00070256637315,
		displayName			= _("BARAX - ECM Pod"),

		shape_table_data =
		{
			{
				file 		= "BARAX",
				life 		= 1,
				fire 		= {0, 1},
				username 	= "BARAX",
				index 		= WSTYPE_PLACEHOLDER,
			},
		},
		
		Elements =
		{
			{ShapeName = "BARAX",}
		},
	}
)

declare_loadout(
	{
		category 			= CAT_PODS,
		CLSID				= "PHIMAT_CM",
		Picture				= "ALQ184.png",
		attribute			= {4, 15, 45, WSTYPE_PLACEHOLDER},
		Weight				= 105,
		Cx_pil				= 0.00070256637315,
		displayName			= _("PHIMAT - Chaff Pod"),
		
		shape_table_data =
		{
			{
				file 		= "MATRA-PHIMAT",
				life 		= 1,
				fire 		= {0, 1},
				username 	= "PHIMAT",
				index 		= WSTYPE_PLACEHOLDER,
			},
		},

		Elements =
		{
			{ShapeName = "MATRA-PHIMAT",}
		},
	}
)

declare_loadout(
	{
		category 			= CAT_PODS,
		CLSID				= "PRESTO",
		Picture				= "PRESTO.png",
		attribute			= {4, 15, 45, WSTYPE_PLACEHOLDER},
		Weight				= 521,
		Cx_pil				= 0.001,
		displayName			= _("PRESTO - Reco Pod"),
		
		shape_table_data =
		{
			{
				file 		= "PRESTO",
				life 		= 1,
				fire 		= {0, 1},
				username 	= "PRESTO",
				index 		= WSTYPE_PLACEHOLDER,
			},
		},

		Elements =
		{
			{ShapeName = "PRESTO",}
		},
	}
)

declare_loadout(
	{
		category 			= CAT_PODS,
		CLSID				= "ASTAC",
		Picture				= "ASTAC.png",
		attribute			= {4, 15, 45, WSTYPE_PLACEHOLDER},
		Weight				= 521,
		Cx_pil				= 0.001,
		displayName			= _("ASTAC - Elint Pod"),
		
		shape_table_data =
		{
			{
				file 		= "ASTAC",
				life 		= 1,
				fire 		= {0, 1},
				username 	= "ASTAC",
				index 		= WSTYPE_PLACEHOLDER,
			},
		},

		Elements =
		{
			{ShapeName = "ASTAC",}
		},
	}
)

function DEFA_553(tbl)

	tbl.category 		 = CAT_GUN_MOUNT 
	tbl.name 	 		 = "defa_553"
	tbl.supply 	 		 = 
	{
		shells 			 = {"DEFA552_30"},
		mixes  			 = {{1,2,2,1,2,2}}, 
		count  			 = 135,
	}
	
	if tbl.mixes then 
	   tbl.supply.mixes  = tbl.mixes
	   tbl.mixes	     = nil
	end
	
	tbl.gun = 
	{
		max_burst_length = 25,
		rates 			 = {1200},
		recoil_coeff 	 = 1,
		barrels_count 	 = 1,
	}
	
	if tbl.rates then 
	    tbl.gun.rates    = tbl.rates
	    tbl.rates	     = nil
	end
	
	drop_cartridge 				= cartridge_30mm
	tbl.ejector_pos 			= tbl.ejector_pos or {-0.4, -1.2, 0.18}
	tbl.ejector_dir 			= {0,-1,0}
	tbl.supply_position  		= tbl.supply_position or {0,  0.3, -0.3}
	tbl.aft_gun_mount 			= false
	tbl.effective_fire_distance = 1800
	tbl.drop_cartridge 			= 0
	tbl.muzzle_pos				= tbl.muzzle_pos or {0,0,0} -- all position from connector
	tbl.muzzle_pos_connector	= tbl.muzzle_pos_connector or "Gun_point" -- all position from connector
	tbl.azimuth_initial 		= tbl.azimuth_initial or 0
	tbl.elevation_initial 		= tbl.elevation_initial or 0
	
	if tbl.effects == nil then
		tbl.effects = {{ name = "FireEffect", arg = tbl.effect_arg_number or 436 },
					   { name = "HeatEffectExt", shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
					   { name = "SmokeEffect"}}
	end
	
	return declare_weapon(tbl)
end

function declareGuns(Name)
	local gunsSpecifics = {
		left = {muzzle_pos_connector = "Gun_point_1",
		 rates = {1249},
		 mixes = {{2,1,1,1,1,1}},
		 effect_arg_number = 434,
		 azimuth_initial = 0,
		 elevation_initial = 0,
		 supply_position = {0.646, -0.876, -0.205}
		},
		right = {muzzle_pos_connector = "Gun_point_2",
		 rates = {1229},
		 mixes = {{1,1,2,1,1,1}},
		 effect_arg_number = 435,
		 azimuth_initial = 0,
		 elevation_initial = 0,
		 supply_position = {0.646, -0.876, 0.205}
		}
	}
	
	if Name == 'Mirage-F1CT' then
		-- Right only
		return {DEFA_553(gunsSpecifics.right)}
	elseif Name == 'Mirage-F1CR' then
		-- Left only
		return {DEFA_553(gunsSpecifics.left)}
	else
		-- Left and right
		return {DEFA_553(gunsSpecifics.left), DEFA_553(gunsSpecifics.right)}
	end
end


function CC420(tbl)

	tbl = gun_mount(
		"DEFA553", { count = 180, max_burst_length = 180 }, {
			muzzle_pos_connector = tbl.muzzle_pos_connector or "Gun_point",
			ejector_pos = tbl.ejector_pos or {-1.7, -0.15, 0.0},
			ejector_dir = {0, -5, 0},
			supply_position = tbl.supply_position or {0,  0.3, -0.3},
			effects = {
				{ name = "FireEffect"     , arg 		 = tbl.effect_arg_number or 436 },
				{ name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
				{ name = "SmokeEffect"}
			}
		}
	)
	
	tbl.category = CAT_GUN_MOUNT
	tbl.name 	 = "DEFA_553"
	tbl.drop_cartridge 			= 0
	tbl.aft_gun_mount 			= false
	tbl.azimuth_initial 		= tbl.azimuth_initial    or 0
	tbl.elevation_initial 		= -2.0
	tbl.muzzle_pos				=  {2.213762,-0.346013,-0.000696} -- all position from connector
	return declare_weapon(tbl)
end

declare_loadout({
	category 		=   CAT_PODS,
	CLSID	 		=  "{CC420_GUN_POD}",
	attribute		=   {wsType_Weapon,wsType_GContainer,wsType_Cannon_Cont,WSTYPE_PLACEHOLDER},
	Picture			=	"DEFA.png",
	displayName		=	_("CC420 DEFA-550 gun pod - 30mm Revolver Cannon"),
	Weight			=	205,
	Cx_pil			=	0.001220703125,
	Elements  		= {{ShapeName = "CC420-GUN-POD"}},
	kind_of_shipping = 2,--SOLID_MUNITION
	gun_mounts		= {
			CC420({
			muzzle_pos_connector = "GUN_POD_F1", 
			effect_arg_number = 1050,
			azimuth_initial = 0,
			elevation_initial = 0.0,
			supply_position = {2, -0.3, -0.4}})  
			},
	shape_table_data = {{file  	 = 'CC420-GUN-POD';	username = 'DEFA-553';index    =  WSTYPE_PLACEHOLDER;}}
})


--local JL100 = {
--		attribute			= {wsType_Weapon, wsType_NURS, wsType_Container, WSTYPE_PLACEHOLDER},
--		category			= CAT_ROCKETS,
--		Count				= 18,
--		Cx_pil				= 0.007 / 25,
--		displayNamePrfx		= "JL-100 - 18 x " .. LocStr.UnGdRkts .. ", 68 " .. LocStr.mm .. " rocket launcher fuel tank",
--		Elements			= {{ ShapeName = "JL100", IsAdapter = true }},
--		modelFileName		= "JL100",
--		Picture				= "LAU61.png",
--		Weight_Empty		= 96.5
--}
--
--BatchDeclareLoadout(
--	JL100,
--	{
--		["{JL100_SNEBT250}"]			= { weaponResName = "SNEB_TYPE250_F1B" },
--		["{JL100_SNEBT251}"]			= { weaponResName = "SNEB_TYPE251_F1B" },
--		["{JL100_SNEBT252}"]			= { weaponResName = "SNEB_TYPE252_F1B" },
--		["{JL100_SNEBT253}"]			= { weaponResName = "SNEB_TYPE253_F1B" },
--		["{JL100_SNEBT254_RED}"]		= { weaponResName = "SNEB_TYPE254_F1B_RED" },
--		["{JL100_SNEBT254_YELLOW}"]		= { weaponResName = "SNEB_TYPE254_F1B_YELLOW" },
--		["{JL100_SNEBT254_GREEN}"]		= { weaponResName = "SNEB_TYPE254_F1B_GREEN" },
--		["{JL100_SNEBT256}"]			= { weaponResName = "SNEB_TYPE256_F1B" },
--		["{JL100_SNEBT257}"]			= { weaponResName = "SNEB_TYPE257_F1B" },
--		["{JL100_SNEBT259E}"]			= { weaponResName = "SNEB_TYPE259E_F1B" },
--	},
--	SNEB68_F1B_Variants
--)
