# Mirage-F1 Enhancement Package for DCS World

This package contains custom code designed to modify the Mirage-F1 module in **DCS World version 2.9.14.8394**.

⚠️ **DISCLAIMER**: This project is **no longer maintained**. Future updates to DCS World or the Mirage-F1 module may cause this code to break. You are welcome to modify and fix the code for your own use, but support will not be provided.

---

## 🚀 Features

- Add the ASTAC and PRESTO pods to the Mirage-F1 aircarfts (centerline pylon)
- Designed for **DCS version 2.9.14.8394**.

---

## 📦 Installation

1. Best to use with OpenModManager or OvGME (the OvGME archive structure is not made)
or
1. Backup any original Mirage-F1 files that this package modifies.
2. Copy the contents of this package into your DCS installation directory folder as specified.
4. Restart DCS World.

> **Note:** this code may break integrity check for multiplayer. Use accordingly.

---

## 🔧 Compatibility

- ✅ DCS World Version: **2.9.14.8394**
- ❌ No guarantee of compatibility with future versions
- 🛠️ Manual edits may be required after DCS or Mirage-F1 updates. Refer to the appendix at the of the file for potential help.

---

## 📜 License

This project is released under a **Non-Commercial Open License**:

- You are free to use, modify, and distribute this code **for personal and non-commercial purposes**.
- You may not sell, license, or otherwise use this project or its derivatives for commercial gain.
- Please credit the original author(s) where appropriate.

---

## 🙅‍♂️ No Maintenance Notice

This package is provided **as-is** with **no ongoing support or updates planned**.

Use it, break it, fix it—your responsibility!  
If DCS or the Mirage-F1 is updated, you may need to manually adapt the code.

**Enjoy flying the Mirage-F1!**


---
## Appendix : Code lines to add
In case Mirage F1 updates bring modifications to the files this mod replaces, the code provided may corrupt the update and/or the module.  
In this case, add the following lines into the specified files (this is only valid at this time with the current architecture of the module, it may not be correct in the future if the architecture of the module changes) :
1. CoreMods/aircraft/Mirage-F1/entry.lua :  
    add `mount_vfs_texture_path (current_mod_path.."/Textures/Reco_Pods.zip")` at the end of the similar lines
2. CoreMods/aircraft/Mirage-F1/Payloads.lua :  
    1. after `id_CC420 = "{CC420_GUN_POD}"` add :  
    ```
    id_PRESTO = "PRESTO" -- PRESTO RECO POD
    id_ASTAC = "ASTAC" -- ASTAC ELINT POD
    ```
    2. after `-- Gunpods \n function [...] end` add :  
    ```
    -- Reconnaissance Pod
    function add_reco_pod(pylons, id_weap, ...)

        local attachPt

        attachPt = {0.0, -0.22, 0.0}

        local arg = {...}
        for i, v in ipairs(arg) do
            local launchers = pylons[v].Launchers
            launchers[#launchers + 1] = pylon_loadout(id_weap, 0.0, nil, attachPt)
        end
    end
    -- ELINT Pod
    function add_elint_pod(pylons, id_weap, ...)

        local attachPt

        attachPt = {0.0, 0.0, 0.0}

        local arg = {...}
        for i, v in ipairs(arg) do
            local launchers = pylons[v].Launchers
            launchers[#launchers + 1] = pylon_loadout(id_weap, 0.15, nil, attachPt)
        end
    end
    ```
    3. after `add_gun_pod(Pylons_Common, id_CC420, 3, 4, 5)` add :  
    ```
    add_reco_pod(Pylons_Common, id_PRESTO, 4)
    add_elint_pod(Pylons_Common, id_ASTAC, 4)
    ```
3. CoreMods/aircraft/Mirage-F1/Weapons.lua :
    ```
    declare_loadout(
        {
            category 			= CAT_PODS,
            CLSID				= "PRESTO",
            Picture				= "PRESTO.png",
            attribute			= {4, 15, 45, WSTYPE_PLACEHOLDER},
            Weight				= 521,
            Cx_pil				= 0.001,
            displayName			= _("PRESTO - Reco Pod"),
            
            shape_table_data =
            {
                {
                    file 		= "PRESTO",
                    life 		= 1,
                    fire 		= {0, 1},
                    username 	= "PRESTO",
                    index 		= WSTYPE_PLACEHOLDER,
                },
            },

            Elements =
            {
                {ShapeName = "PRESTO",}
            },
        }
    )

    declare_loadout(
        {
            category 			= CAT_PODS,
            CLSID				= "ASTAC",
            Picture				= "ASTAC.png",
            attribute			= {4, 15, 45, WSTYPE_PLACEHOLDER},
            Weight				= 521,
            Cx_pil				= 0.001,
            displayName			= _("ASTAC - Elint Pod"),
            
            shape_table_data =
            {
                {
                    file 		= "ASTAC",
                    life 		= 1,
                    fire 		= {0, 1},
                    username 	= "ASTAC",
                    index 		= WSTYPE_PLACEHOLDER,
                },
            },

            Elements =
            {
                {ShapeName = "ASTAC",}
            },
        }
    )
    ```