-- Sandown Class Mine Hunter

GT = {};
GT_t.ws = 0;

set_recursive_metatable(GT, GT_t.generic_ship)

GT.visual = {}
GT.visual.shape = "sandown"
GT.visual.shape_dstr = "sandown"

GT.life = 800;
GT.mass = 600000;
GT.max_velocity = 6.69
GT.race_velocity = 6.42
GT.economy_velocity = 5.12
GT.economy_distance = 3000
GT.race_distance = 2.778e+006
GT.shipLength = 52.5 
GT.Width = 10.9 
GT.Height = 2.2 
GT.Length = 52.5 
GT.DeckLevel = 8
GT.X_nose = 26.146
GT.X_tail = -23.421
GT.Tail_Width = 3
GT.draft = 2.8
GT.Gamma_max = 0.35  --
GT.Om = 0.5 --
GT.speedup = 0.900 --
GT.R_min = 80 -- turning

GT.IR_emission_coeff = 0.85
GT.RCS  = 6000

GT.distFindObstacles = 568.4

GT.airWeaponDist = 5000
GT.airFindDist = 14000

GT.exhaust = {
	  [1] = { size = 0.01 , pos = {-6.595, 9.36, 0.0 } },
      --[2] = { size = 0.05 , pos = {-1.9, 29.0, 14.0  } },		--Y, Z, X
}

GT.animation_arguments.water_propeller = 65; 

GT.animation_arguments.radar1_rotation = 1; -- Radar 1 Rotation
GT.radar1_period = 1.5;

GT.animation_arguments.alarm_state = 5; -- For the Jack Staff

--DM
GT.DM = {
    --HULL
    { area_name = "COL_Hull_Bow_R_01", 			area_arg = 70, area_life = 150, area_fire = { connector = "FIRE_HULL_BOW_R_01", size = 0.5}},
	{ area_name = "COL_Hull_Middle_R_01", 		area_arg = 72, area_life = 150, area_fire = { connector = "FIRE_HULL_MIDDLE_R_01", size = 0.5}},
	{ area_name = "COL_Hull_Middle_R_02", 		area_arg = 74, area_life = 150, area_fire = { connector = "FIRE_HULL_MIDDLE_R_02", size = 0.5}},
	{ area_name = "COL_Hull_Stern_R_01", 		area_arg = 76, area_life = 150, area_fire = { connector = "FIRE_HULL_STERN_R_01", size = 0.5}},
    { area_name = "COL_Hull_Stern_R_02", 		area_arg = 78, area_life = 150, area_fire = { connector = "FIRE_HULL_STERN_R_02", size = 0.5}},
	
    { area_name = "COL_Hull_Bow_L_01", 			area_arg = 71, area_life = 150, area_fire = { connector = "FIRE_HULL_BOW_L_01", size = 0.5}},
	{ area_name = "COL_Hull_Middle_L_01", 		area_arg = 73, area_life = 150, area_fire = { connector = "FIRE_HULL_MIDDLE_L_01", size = 0.5}},
    { area_name = "COL_Hull_Middle_L_02", 		area_arg = 75, area_life = 150, area_fire = { connector = "FIRE_HULL_MIDDLE_L_02", size = 0.5}},
	{ area_name = "COL_Hull_Stern_L_01", 		area_arg = 77, area_life = 150, area_fire = { connector = "FIRE_HULL_STERN_L_01", size = 0.5}},
	{ area_name = "COL_Hull_Stern_L_02", 		area_arg = 79, area_life = 150, area_fire = { connector = "FIRE_HULL_STERN_L_02", size = 0.5}},
    --DECK
	{ area_name = "COL_Gun_Base",			    area_arg = 69, area_life = 150},		
	{ area_name = "COL_Deck_Bow_01", 		    area_arg = 80, area_life = 150, area_fire = { connector = "FIRE_DECK_BOW_01", size = 0.5}},
	{ area_name = "COL_Deck_Middle_01",		    area_arg = 81, area_life = 150, area_fire = { connector = "FIRE_DECK_MIDDLE_01", size = 0.8}},
	{ area_name = "COL_Deck_Middle_02",		    area_arg = 82, area_life = 150, area_fire = { connector = "FIRE_DECK_MIDDLE_02", size = 0.8}},
	{ area_name = "COL_Deck_Stern_01",	     	area_arg = 83, area_life = 150, area_fire = { connector = "FIRE_DECK_STERN_01", size = 0.8}},
	--BRIDGE and SUPER STRUCTURE SECTIONS
	{ area_name = "COL_Bridge_Forward", 		area_arg = 90, area_life = 150, area_fire = { connector = "FIRE_BRIDGE_FORWARD", size = 0.8}},
	{ area_name = "COL_Bridge_Mid", 		    area_arg = 91, area_life = 150, area_fire = { connector = "FIRE_BRIDGE_MID", size = 0.8}},
	{ area_name = "COL_Bridge", 				area_arg = 92, area_life = 150, area_fire = { connector = "FIRE_BRIDGE", size = 0.8}},
	{ area_name = "COL_Bridge_Tower",			area_arg = 93, area_life = 150, area_fire = { connector = "FIRE_BRIDGE_TOWER", size = 0.8}},
	{ area_name = "COL_Bridge_Aft",				area_arg = 94, area_life = 150, area_fire = { connector = "FIRE_BRIDGE_AFT", size = 0.8}},
	{ area_name = "COL_Bridge_Rear",			area_arg = 95, area_life = 150, area_fire = { connector = "FIRE_BRIDGE_REAR", size = 0.8}},
	{ area_name = "COL_Hanger",					area_arg = 96, area_life = 130},
	{ area_name = "COL_Mast",					area_arg = 97, area_life = 80},
	{ area_name = "COL_Main",					area_arg = 98, area_life = 30},
	{ area_name = "COL_Bridge_Funnel",			area_arg = 99, area_life = 120},

	
}

--GT.driverViewConnectorName = {"DRIVER_POINT", offset = {0.0, 0.0, 0.0}}
--GT.driverCockpit = "DriverCockpit/DriverCockpitWithIR"

--radar--

GT.WS = {}
GT.WS.maxTargetDetectionRange = 4000;
GT.WS.radar_type = 102 
GT.WS.searchRadarMaxElevation = math.rad(90);

--main gun--
-- DS-30B Mk1 (Source code by Currenthill) Thanks dude

local ws = GT_t.inc_ws();
GT.WS[ws] = {};
GT.WS[ws].area = 'COL_Gun_Base'
GT.WS[ws].center = 'CENTER_TOWER_01'
GT.WS[ws].angles = {
					 {math.rad(100), math.rad(-100), math.rad(-5), math.rad(60)},
					};
GT.WS[ws].drawArgument1 = 25;
GT.WS[ws].drawArgument2 = 26;
GT.WS[ws].omegaY = 1.0472;
GT.WS[ws].omegaZ = 1.0472;
GT.WS[ws].stabilizer = true;
GT.WS[ws].laser = true;

local __LN = add_launcher(GT.WS[ws], GT_t.LN_t.DS30J_MK1);
__LN.beamWidth = math.rad(1);
__LN.BR = {{connector_name = 'POINT_GUN_01',
			recoilArgument = 23,
			recoilTime = 0.2}
		  };
__LN.sightMasterMode = 1;
__LN.sightIndicationMode = 1;

GT.WS[ws].LN[1].customViewPoint = { "genericAAAwithRadar", {0.0, 0.0, 0.0 }, };
GT.WS[ws].pointer = "GUN_SIGHT"

--GPMGs goes here when made--

--info--

GT.Name = "Sandown" -- folder in Liveries
GT.DisplayName = _("Sandown Class Mine hunter") --name in game
GT.Rate = 2000

GT.Sensors = {  OPTIC = {"long-range naval optics", "long-range naval LLTV", "long-range naval FLIR",},
               
            };


GT.DetectionRange	= GT.airFindDist;
GT.ThreatRange		= GT.airWeaponDist;
GT.Singleton		= "yes";
GT.mapclasskey		= "P0091000065";
GT.attribute		= {wsType_Navy, wsType_Ship, wsType_GenericLightArmoredShip, WSTYPE_PLACEHOLDER,
					"low_reflection_vessel",
                    "Light armed ships",
					};
GT.Categories		= {
					
						{name = "Armed Ship"}
					};		

GT.tags  = 
{
	"Support",
}		

add_surface_unit(GT)