--
-- file prepared: 2 November 2025 18:56:26.144, using fd693f
--
----------------------------------------------------------------------------------------------------------------------
--
--  Used for the d3a (2x250kg) and n1k (2x250kg)
--
declare_loadout(	--Type 99 No 25 bomb
	{
		category		= CAT_FUEL_TANKS,
		CLSID			= "{type-99-25}",
		attribute		=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture			= "type_99_25.png",
		displayName		= _("Type 99 No 25"),
		Weight_Empty	= 108.8,												
		Weight			= 1429.6,												
		Cx_pil			= 0.0020,
		shape_table_data =
		{
			{
				name 	= "IJN_Type_99_25",
				file	= "type_99_25";
				life	= 1;
				fire	= { 0, 1};
				username	= "IJN_Type_99_25";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	=
		{
			{
				Position	=	{0,	-0.4, 0},		-- fwd,aft    up,dn    left,right
				ShapeName	= "IJN_Type_99_25",
			},
		},
	}
)





----------------------------------------------------------------------------------------------------------------------
--
--  Used for the d3a (2x250kg) and n1k (2x250kg)
--  temporarily also used for the USN tbd and tbm until suitable replacement found
--

--AN_M64_6 =   
Type_99_30 = --Type 99 No 25 bomb
{
	CLSID        = "{type-99-30}",

	category     = CAT_BOMBS,

	Picture = "type_99_25.png",

	attribute	=	{4,	5,	9,	90},

	displayName		= _("Type 99 No 25"),


	Count	=	1,
	Weight	=	1361,
	
	shape_table_data =
	{
		{
			name 	= "IJN_Type_99_25",
			file	= "type_99_25";
			life	= 1;
			fire	= { 0, 1};
			username	= "IJN_Type_99_25";
			index	= WSTYPE_PLACEHOLDER;
		},
	},
	Elements	=	
	{
		[1]	=	
		{
			Position	=	{0,	0.5, 0},
			ShapeName	= "IJN_Type_99_25",
		}, 
	}, -- end of Elements
}
declare_loadout(Type_99_30)

--Ammunition M39
local m39_smoke_scale   = 1.0;
local m39_smoke_opacity = 0.3;


----------------------------------------------------------------------------------------------------------------------

--
-- Type 97 round 1 (7.62)
--
declare_weapon({category = CAT_SHELLS,name = "PKT_7_62",
  user_name		= _("PKT_7_62"),
  model_name    = "tracer_bullet_red",
  v0    = 855.0,
  Dv0   = 0.0082,
  Da0     = 0.0004,
  Da1     = 0.0,
  mass      = 0.0096,
  explosive     = 0.0000,
  life_time     = 7,
  caliber     = 7.62,
  s         = 0.0,
  j         = 0.0,
  l         = 0.0,
  charTime    = 0,
  cx        = {1.0,0.62,0.65,0.175,1.8},
  k1        = 2.9e-08,
  tracer_off    = -100,
  scale_tracer  = 1, 
  cartridge = 0,

  --tracer_on		= tracer_on_time,
  --smoke_tail_life_time = 0.7,
  --round_mass = 0.567,

})


--
-- Type 97 round 2 (7.62)
--
declare_weapon({category = CAT_SHELLS, name =   "PKT_7_62_T",
  user_name		= _("PKT_7_62_T"),
  model_name    = "tracer_bullet_red",
  v0    = 855.0,
  Dv0   = 0.0082,
  Da0     = 0.0004,
  Da1     = 0.0,
  mass      = 0.0096,
  explosive     = 0.0000,
  life_time     = 7,
  caliber     = 7.62,
  s         = 0.0,
  j         = 0.0,
  l         = 0.0,
  charTime    = 0,
  cx        = {1.0,0.62,0.65,0.175,1.8},
  k1        = 2.9e-08,
  tracer_off    = 3,
  scale_tracer  = 1,
  cartridge = 0,
 
  --round_mass 	 = 0.260+0.058,		-- round + link
  --cartridge_mass = 0.058,			-- links are collected
  --tracer_on      = 0.01,

})


--
-- Type 97 cannon (7.62)
--
function Type_97(tbl)

	tbl.category = CAT_GUN_MOUNT 
	tbl.name 	 = "Type_97"
	tbl.supply 	 =
	{
		shells = {"PKT_7_62", "PKT_7_62_T" },
		mixes  = {{1,1,2,1,2}},
		count  = 1000,		--250,
	}
	if tbl.mixes then 
	   tbl.supply.mixes =  tbl.mixes
	   tbl.mixes	    = nil
	end
	tbl.gun = 
	{
		max_burst_length = 25,
		rates 			 = {900},		--Type 97 
		recoil_coeff 	 = 0.2*1.3,
		barrels_count 	 = 1,
	}
	if tbl.rates then 
	   tbl.gun.rates    =  tbl.rates
	   tbl.rates	    = nil
	end	
	tbl.ejector_pos 			= tbl.ejector_pos or {-0.4, -1.2, 0.18}
	tbl.ejector_dir 			= {0,-1,0}
	tbl.supply_position  		= tbl.supply_position   or {0,  0.3, -0.3}
	tbl.aft_gun_mount 			= false
	tbl.effective_fire_distance = 1500
	tbl.drop_cartridge 			= 0
	tbl.muzzle_pos				= tbl.muzzle_pos 		 or  {0,0,0} -- all position from connector
	tbl.muzzle_pos_connector	= tbl.muzzle_pos_connector 		 or  "Gun_point" -- all position from connector
	tbl.azimuth_initial 		= tbl.azimuth_initial    or 0   
	tbl.elevation_initial 		= tbl.elevation_initial  or 0   
	if  tbl.effects == nil then
		tbl.effects = {{ name = "FireEffect"     , arg 		 = tbl.effect_arg_number or 436 },
					   { name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
					   { name = "SmokeEffect"}}
	end
	return declare_weapon(tbl)
end


--
--	note: the above is modelled after the example for the GSHG_7_62 cannon as found in Scripts\Database\Weapons\aircraft_gun_mounts.lua, and
--  the example for the PKT_7_62, and PKT_7_62_T rounds as found in Scripts\Database\Weapons\shell_table.lua
--



