--
-- file prepared: 3 November 2025 21:16:20.657, using fd693f
--
--SFM_heading.lua (file 1 for assembly)

dofile(current_mod_path.."/Views.lua")

ki61 = {

	Name = 'ki61',
	DisplayName = _('ki61'),

	EmptyWeight = 2630,					-- value found on Wikipedia, or from Google AI or Google Gemini search
	MaxFuelWeight = 440,					-- guess
	MaxHeight = 11613,					-- value found on Wikipedia, or from Google AI or Google Gemini search
	MaxSpeed = 581,					-- value found on Wikipedia, or from Google AI or Google Gemini search
	MaxTakeOffWeight = 4310,					-- value found on Wikipedia, or from Google AI or Google Gemini search
	Picture = "ki61.png",
	Rate = 20, 

	WingSpan = 12,					-- value found on Wikipedia, or from Google AI or Google Gemini search
	WorldID = ki61,
	defFuelRatio = 0.68,					-- default

	country_of_origin = "Japan",

	Shape = "ki61",
	propellorShapeType = "3ARG_PROC_BLUR",
	propellorShapeName = "P-51D_blade.FBX",
	shape_table_data =
	{
		{
			file = 'ki61';
			life = 18;
			vis = 3;
			--desrt = "p51-oblomoki";
			fire = { 300, 2};
			username = 'ki61';
			index = ki61;
			drawonmap = true;
		},
	},
	------------------------ -
--(file 2 for aessembly)

	mapclasskey = "P0091000026",
	attribute = { wsType_Air, wsType_Airplane, wsType_Fighter, KI61, "Battleplanes" },

--SFM_characteristics.lua (file 3 for assembly)

	---------	General	Characteristics	---------

	--This is not an accurate flight model for this aircraft.  The values used in this file are not based on any technical, military or restricted content related to the aircraft, nor are they derived from real world operation or testing.
	--The values in this file are based on publicly available data (examples: airframe dimensions, weights, engine type/power, operating speeds and altitudes).  Thus, this will not provide an accurate representation in game of either actual real-world performance nor of the flight characteristics of this aircraft.
	--Values for the following were obtained from Wikipedia: the maximum speed of the aircraft, its climb rate and service ceiling as well as aircraft attributes such as engine thrust, weights, wing surface area and other aircraft dimensions.
	--Estimates for the following were obtained from Google AI search queries, or Google Gemini queries: sustained turn rate performance, operational g limit, stall speed, altitude at which maximum speed is attained, maximum speed at sea level.
	--Values for the engine table and for the aerodynamics table were refined by in-game testing, with the objective of permitting the user to fly the aircraft in DCS World as 'player' to the max velocity, and service ceiling corresponding to the aircraft as found on the sources disucssed above.

	length = 8.94,					-- value found on Wikipedia, or from Google AI or Google Gemini search
	height = 3.7,					-- value found on Wikipedia, or from Google AI or Google Gemini search
	wing_area = 20,
	wing_span = 12,
	wing_tip_pos = { 1.33, 1, 6.25},
	RCS = 1.9,											--(estimated as 0.0375*((height*length)+wing surface area)) )
	air_refuel_receptacle_pos = { 0, 0, 0},
	has_speedbrake = true,								-- default
	brakeshute_name = 4,								-- default
	is_tanker = false,									-- default
	tanker_type = 2,									-- default
	stores_number = 8,
	wing_type = 0,										-- default
	crew_size = 1,										-- default

	------- Weight & Fuel Characteristics -------
	M_empty = 2630,					-- value found on Wikipedia, or from Google AI or Google Gemini search
	M_nominal = 3470,					-- value found on Wikipedia, or from Google AI or Google Gemini search
	M_max = 4310,					-- value found on Wikipedia, or from Google AI or Google Gemini search
	M_fuel_max = 440,					-- guess
	H_max = 11613,					-- value found on Wikipedia, or from Google AI or Google Gemini search
	CAS_min = 30,					-- value found on Wikipedia, or from Google AI or Google Gemini search
	average_fuel_consumption = 0.302,					-- default 

	----------_ AI Flight Parameters -----------
	V_opt = 122,					-- derived from value found on Wikipedia, or from Google AI or Google Gemini search
	V_take_off = 31,					-- derived from value found on Wikipedia, or from Google AI or Google Gemini search
	V_land = 31,					-- derived from value found on Wikipedia, or from Google AI or Google Gemini search
	V_max_sea_level = 95,					-- derived from value found on Wikipedia, or from Google AI or Google Gemini search
	V_max_h = 76,					-- derived from value found on Wikipedia, or from Google AI or Google Gemini search
	Vy_max = 15,					-- derived from value found on Wikipedia, or from Google AI or Google Gemini search
	Mach_max = 0.483,					-- value found on Wikipedia, or from Google AI or Google Gemini search
	Ny_min = -3,										-- default
	Ny_max = 6,					-- derived from value found on Wikipedia, or from Google AI or Google Gemini search
	Ny_max_e = 6,					-- derived from value found on Wikipedia, or from Google AI or Google Gemini search
	AOA_take_off = 0.16,								-- default
	bank_angle_max = 80.4,					-- derived from value found on Wikipedia, or from Google AI or Google Gemini search
	range = 3000,										-- default
	flaps_maneuver = 1,									-- default

	-------- Suspension Characteristics -------
	and_gear_max = 1,									-- default
	nose_gear_pos = { 1.88, -1.18, 2.1},
	nose_gear_wheel_diameter = 0.5,						-- default
	nose_gear_amortizer_direct_stroke = 0.05,			-- default
	nose_gear_amortizer_reversal_stroke = -0.25,		-- default
	nose_gear_amortizer_normal_weight_stroke = -0.05,	-- default
	main_gear_pos = { -3.5, 0.13, 0},
	main_gear_wheel_diameter = 0.75,					-- default
	main_gear_amortizer_direct_stroke = 0.1,			-- default
	main_gear_amortizer_reversal_stroke = -0.275,		-- default
	main_gear_amortizer_normal_weight_stroke = -0.1,	-- default

	---------- Engine Characteristics ---------
	has_afteburner = false,
	thrust_sum_max = 715.07,					-- value found on Wikipedia, or from Google AI or Google Gemini search
	thrust_sum_ab = 715.07,					-- value found on Wikipedia, or from Google AI or Google Gemini search
	engines_count = 1,					-- value found on Wikipedia, or from Google AI or Google Gemini search
	IR_emission_coeff = 0.05,							-- default
	IR_emission_coeff_ab = 0.05,						-- default

	--------- Sensors Characteristics ---------
	detection_range_max = 250,							-- default
	radar_can_see_ground = true,						-- default


---------------------------------------------------------------------------------------------------------------------------------------------

	crew_members =
	{
		[1] =
		{
			pilot_name = 56,
			ejection_seat_name = 0,
			drop_canopy_name = "aircraft_canopy", 
			pos = {1.88, -0.23, 2.1},
			canopy_pos = {1.88, -0.23, 2.1},
			drop_parachute_name = "pilot_parachute",
		}, --end of[1]
	}, --end of crew_members


---------------------------------------------------------------------------------------------------------------------------------------------


	--------- Engine, nozzles and exhaust ---------

	engines_nozzles = {
		[1] =
		{
			pos = {0, 0.15, 0},
			elevation = 0.15,
			diameter = 0.675,							-- default
			exhaust_length_ab = 3,						-- default
			exhaust_length_ab_K = 0.707,				-- default
			smokiness_level = 0.2,
		}, -- end of [1]
	}, -- end of engines_nozzles


---------------------------------------------------------------------------------------------------------------------------------------------


	Guns = {
		Type_89({ muzzle_pos = {2.8, 1.4, 0.2},_connector =  "Point_Gun_02",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		Ho_103({ muzzle_pos = {2.8, 1.4, 0.2},_connector =  "Point_Gun_02",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		Ho_103({ muzzle_pos = {2.8, 1.4, -0.2},_connector =  "Point_Gun_03",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		Type_89({ muzzle_pos = {2.8, 1.4, -0.2},_connector =  "Point_Gun_03",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
	},


	Pylons = {
		pylon(1, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon1", arg = 308, arg_value = 0,
			},
			{
			} 
		),
		pylon(2, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon2", arg = 309, arg_value = 0,
			},
			{
			} 
		),
		pylon(3, 0, 1.33, 0.5, 2.93, --
			{
				use_full_connector_position = true, connector = "Pylon3", arg = 310, arg_value = 0,
			},
			{
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
			} 
		),
		pylon(4, 0, 1.33, 0.5, 2.08, --
			{
				use_full_connector_position = true, connector = "Pylon4", arg = 311, arg_value = 0,
			},
			{
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82 
			} 
		),
		pylon(5, 0, 1.33, 0.5, -2.08, --
			{
				use_full_connector_position = true, connector = "Pylon5", arg = 312, arg_value = 0,
			},
			{
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82 
			} 
		),
		pylon(6, 0, 1.33, 0.5, -2.93, --
			{
				use_full_connector_position = true, connector = "Pylon6", arg = 313, arg_value = 0,
			},
			{
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
			} 
		),
		pylon(7, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon7", arg = 314, arg_value = 0,
			},
			{
			} 
		),
		pylon(8, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon8", arg = 315, arg_value = 0,
			},
			{
			} 
		),
	},



---------------------------------------------------------------------------------------------------------------------------------------------


	fires_pos =
	{
		[1] = { 0, 1, 0.0},
		[2] = { 0, 1, 0.2},
		[3] = { 0, 1, -0.2},
		[4] = { 1.33, 1, 1.5625},
		[5] = { 1.33, 1, -1.5625},
		[6] = { 1.33, 1, 5},
		[7] = { 1.33, 1, -5},
		[8] = { 0, 0.15, 0.2},
		[9] = { 0, 0.15, -0.2},
		[10] = { 0, 1, 0.2},
		[11] = { 0, 1, -0.2},
	},	-- end of fires_pos

---------------------------------------------------------------------------------------------------------------------------------------------
-- (file 4 for assembly)

	--[[
	fires_pos = 
	{
		[1] = 	{-2,	0.595,	0.5},
		[2] = 	{0,	0,	2.237},
		[3] = 	{0,	0,	-2.237},
		[4] = 	{0.265,	0,	1.5},
		[5] = 	{-0.265,	0,	-1.5},
		[6] = 	{0.5,	0,	4.274},
		[7] = 	{0.5,	0,	-4.274},
		[8] = 	{-5,	0.5,	0},
		[9] = 	{-5,	0.5,	0},
		[10] = 	{-5,	0.5,	0},
		[11] = 	{-5,	0.5,	0},
	}, -- end of fires_pos
	]]--

	--[[
    mechanimations = {
        Door0 = {
            {Transition = {"Close", "Open"},  Sequence = {{C = {{"Arg", 38, "to", 0.9, "at", 0.11111111111111},},},}, Flags = {"Reversible"},},
            {Transition = {"Open", "Close"},  Sequence = {{C = {{"Arg", 38, "to", 0.0, "at", 0.16666666666667},},},}, Flags = {"Reversible", "StepsBackwards"},},
            {Transition = {"Any", "Bailout"}, Sequence = {{C = {{"TearCanopy", 0},},},},},
        },
    },
	]]--

	net_animation = { 420 --[[external_model_throttle_arg]]},
	
	detection_range_max		 = 0,
	radar_can_see_ground 	 = false, 
	CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_BAD, LOOK_GOOD, LOOK_GOOD),

	--[[
	Sensors = {
		OPTIC = "Merkury LLTV", -- For night goggles imitation
   	},
	]]--

	--[[
	HumanRadio = {
			frequency = 124.0,
			editable = true,
			minFrequency = 100.000,
			maxFrequency = 156.000,
			modulation = MODULATION_AM
	},
	]]--
	
	Tasks ={
        aircraft_task(Reconnaissance),
	    aircraft_task(CAP),                 
        aircraft_task(CAS),                 
        aircraft_task(SEAD),                
        aircraft_task(GroundAttack),        
        aircraft_task(AFAC),                
        aircraft_task(RunwayAttack),
        aircraft_task(AntishipStrike),
        aircraft_task(Refueling),           
    },
	DefaultTask = aircraft_task(CAP),
	
	--SFM_aerodynamics.lua (file 5 for assembly)

	SFM_Data = {
		aerodynamics = --Cx = Cx_0 + Cy ^ 2 * B2 + Cy ^ 4 * B4
		{

			Cy0 = 0,
			Mzalfa = 4.355,					-- default
			Mzalfadt = 0.8,					-- default
			kjx = 3,						-- default
			kjz = 0.00125,					-- default
			Czbe = -0.016,					-- default
			cx_gear = 0.02,					-- default
			cx_flap = 0.08,					-- default
			cy_flap = 0.25,					-- default
			cx_brk = 0.1,					-- default

			table_data = {
				--M     Cx0     Cya     B       B4      Omxmax  Aldop   Cymax
				{0,		0.015,	0.107,	0.0153,	0.000812,	2.24,	13.6,	1.46,		},
				{0.05,	0.015,	0.102,	0.0153,	0.000812,	6.09,	14.3,	1.46,		},
				{0.1,	0.015,	0.0971,	0.0153,	0.000812,	6.09,	15.1,	1.46,		},
				{0.15,	0.015,	0.107,	0.0153,	0.000812,	6.09,	13.6,	1.46,		},
				{0.2,	0.015,	0.116,	0.0153,	0.000812,	6.09,	14.3,	1.66,		},
				{0.25,	0.015,	0.07,	0.015,	0.00131,	6.09,	17.5,	2,		},
				{0.3,	0.015,	0.0579,	0.014,	0.00178,	6.09,	17.5,	2,		},
				{0.35,	0.015,	0.04,	0.0191,	0.00508,	6.09,	17.5,	1.4,		},
				{0.4,	0.015,	0.03,	0.0372,	0.0294,	6.09,	17.5,	1,		},
				{0.45,	0.015,	0.03,	0.15,	0.118,	2.24,	17.5,	1,		},
				{0.5,	0.015,	0.03,	0.158,	0.124,	1.98,	17.1,	0.975,		},
				{0.55,	0.015,	0.03,	0.165,	0.13,	1.74,	16.6,	0.951,		},
			}, --end of table_data

		--This is not an accurate flight model for this aircraft.  The values used in this file are not based on any technical, military or restricted content related to the aircraft, nor are they derived from real world operation or testing.
		--The values in this file are based on publicly available data (examples: airframe dimensions, weights, engine type/power, operating speeds and altitudes).  Thus, this will not provide an accurate representation in game of either actual real-world performance nor of the flight characteristics of this aircraft.
		--Values for the following were obtained from Wikipedia: the maximum speed of the aircraft, its climb rate and service ceiling as well as aircraft attributes such as engine thrust, weights, wing surface area and other aircraft dimensions.
		--Estimates for the following were obtained from Google AI search queries, or Google Gemini queries: sustained turn rate performance, operational g limit, stall speed, altitude at which maximum speed is attained, maximum speed at sea level.
		--Values for the engine table and for the aerodynamics table were refined by in-game testing, with the objective of permitting the user to fly the aircraft in DCS World as 'player' to the max velocity, and service ceiling corresponding to the aircraft as found on the sources disucssed above.

		}, --end of aerodynamics
		engine = 
		{
			Nmg = 23.0,					-- default 
			MinRUD = 0,					-- default 
			MaxRUD = 1,					-- default 
			MaksRUD  = 1,					-- default 
			ForsRUD  = 1,					-- default 
			typeng  = 2,
			hMaxEng	= 19,				-- default
			dcx_eng = 0.015,			-- default
			cemax  = 1.24,				-- default
			cefor  = 2.56,				-- default
			dpdh_m = 1000,					-- default 
			dpdh_f = 2000,					-- default 
			k_adiab_1 = 0.037923,					-- default 
			k_adiab_2 = 0.0562,						-- default 
			MAX_Manifold_P_1 = 155774,				-- default 
			MAX_Manifold_P_2 = 206570,				-- default 
			MAX_Manifold_P_3 = 226648,				-- default 
			k_after_cool = 0.54,					-- default 
			Displ = 27,								-- default 
			k_Eps = 6,								-- default 
			Stroke = 0.152,							-- default 
			V_pist_0 = 12,							-- default 
			Nu_0 = 1.2,								-- default 
			Nu_1 = 0.9,								-- default 
			Nu_2 = 0.001,							-- default 
			N_indic_0 = 1023040,					-- default 
			N_fr_0 = 0.072,							-- default 
			N_fr_1 = 0.02,							-- default 
			Init_Mom = 220,							-- default 
			D_prop = 3.45,							-- default 
			MOI_prop = 65,							-- default 
			k_gearbox = 2.088,						-- default 
			P_oil = 495438,							-- default 
			k_boost = 3,							-- default 
			k_cfug = 0.003,							-- default 
			k_oil = 0.00004,						-- default 
			k_piston = 3000,						-- default 
			k_reg = 0.003,							-- default 
			k_vel = 0.017,							-- default 
			--[[
			table_data = {
				--M 	Pmax
				{0,	4594	},
				{0.2,	4594	},
				{0.4,	4594	},
				{0.6,	4594	},
				{0.8,	4594	},
				{1,	4594	},
				{1.2,	4594	},
				{1.4,	4594	},
				{1.6,	4594	},
				{1.8,	4594	},
				{2,	4594	},
				{2.2,	4594	},
			}, --end of table_data
			--]]

			table_data = {
				--M 	Pmax	Pafb
				{0.0,	0.0,	0.0,		},
				{ 2.0,	0.0,	0.0,		},
			}, --end of table_data


			--[[
				engine calibration worksheet (for in-game testing)
				alt     	vel		adj
				0 k ft		0.m		adj:+/-
				15 k ft		0.m		adj:+/-
				17 k ft		0.m		adj:+/-
				18 k ft		0.m		adj:+/-
				31 k ft		0.m		adj:+/-
				35 k ft		0.m		adj:+/-
				38 k ft		0.m		adj:+/-
				40 k ft		0.m		adj:+/-
			]]--

			extended = {

				thrust_max = {
					M = { 0.000000, 0.200000, 0.400000, 0.600000, 0.800000, 1.000000, 1.200000, 1.400000, 1.600000, 1.800000, 2.000000, 2.200000, }, 
					H = { 0, 4571, 5430, 5701, 9601, 10801, 11761, 12301 }, 
					thrust = {
						{ 3987,   3987,   3987,   3987,   3987,   3987,   3987,   3987,   3987,   3987,   3987,   3987   }, 
						{ 4594,   4594,   4594,   4594,   4594,   4594,   4594,   4594,   4594,   4594,   4594,   4594   }, 
						{ 5843,   5843,   5843,   5843,   5843,   5843,   5843,   5843,   5843,   5843,   5843,   5843   }, 
						{ 5189,   5189,   5189,   5189,   5189,   5189,   5189,   5189,   5189,   5189,   5189,   5189   }, 
						{ 2366,   2366,   2366,   2366,   2366,   2366,   2366,   2366,   2366,   2366,   2366,   2366   }, 
						{ 2366,   2366,   2366,   2366,   2366,   2366,   2366,   2366,   2366,   2366,   2366,   2366   }, 
						{ 1041,   1041,   1041,   1041,   1041,   1041,   1041,   1041,   1041,   1041,   1041,   1041   }, 
						{ 140,    140,    140,    140,    140,    140,    140,    140,    140,    140,    140,    140    }, 
					}, -- thrust = {

				}, --thrust_max = {

			}, -- extended = {

			Startup_Prework = 15.0,					-- default 
			Startup_RPMs = {						-- default 
				{0.0, 0},							-- default 
				{1.0, 60},							-- default 
				{7.0, 60},							-- default 
				{9.0, 400},							-- default 
				{11.0, 880},						-- default 
				{15.0, 550},						-- default 
			},
			Startup_Ignition_Time = 8.0,			-- default 
			Shutdown_Duration = 9.8,				-- default 
			Nominal_RPM = 3000.0,					-- default 
			prop_pitch_min = 23.0,					-- default 
			prop_pitch_max = 65.0,					-- default 
			prop_pitch_feather = 80.0,				-- default 
			prop_blades_count = 4,					-- default 
			prop_locations = {
				{ 4, 0.88, 0}, {0.0, 0.0, math.rad(-1.87)},
			},

		--This is not an accurate flight model for this aircraft.  The values used in this file are not based on any technical, military or restricted content related to the aircraft, nor are they derived from real world operation or testing.
		--The values in this file are based on publicly available data (examples: airframe dimensions, weights, engine type/power, operating speeds and altitudes).  Thus, this will not provide an accurate representation in game of either actual real-world performance nor of the flight characteristics of this aircraft.
		--Values for the following were obtained from Wikipedia: the maximum speed of the aircraft, its climb rate and service ceiling as well as aircraft attributes such as engine thrust, weights, wing surface area and other aircraft dimensions.
		--Estimates for the following were obtained from Google AI search queries, or Google Gemini queries: sustained turn rate performance, operational g limit, stall speed, altitude at which maximum speed is attained, maximum speed at sea level.
		--Values for the engine table and for the aerodynamics table were refined by in-game testing, with the objective of permitting the user to fly the aircraft in DCS World as 'player' to the max velocity, and service ceiling corresponding to the aircraft as found on the sources disucssed above.


		}, --end of engine

	},

	DamageParts =
	{
		[1] = "ki61-collision",
	},

-- (file 6 for aessembly)

	Damage = {
		[11]		= {critical_damage = 3, args = {147}}, -- engine l
		[39]		= {critical_damage = 4, args = {242}}, -- fin top left
		[43]		= {critical_damage = 6, args = {243}, deps_cells = {39, 54, 45, 46, 49, 50}}, -- fin bottom left
		[54]		= {critical_damage = 3, args = {247}}, -- rudder right
		[45]		= {critical_damage = 4, args = {235}}, -- stabilizer out left
		[47]		= {critical_damage = 6, args = {236}, deps_cells = {49}} ,-- stabilizer in left
		[46]		= {critical_damage = 4, args = {233}}, -- stabilizer out right
		[48]		= {critical_damage = 6, args = {234}, deps_cells = {50}}, -- stabilizer in right
		[49]		= {critical_damage = 3, args = {240}},-- elevator out left
		[50]		= {critical_damage = 3, args = {238}},-- elevator out right
		[4]		    = {critical_damage = 5, args = {154}},-- cabin left
		[5]		    = {critical_damage = 5, args = {153}},-- cabin right
		[82]		= {critical_damage = 5, args = {152}},-- fuselage bottom
		[56]		= {critical_damage = 5, args = {158}},-- tail left
		[57]		= {critical_damage = 5, args = {157}},-- tail right
		[55]		= {critical_damage = 7, args = {81}, deps_cells = {43, 54, 45, 46}}, -- tail 
		[3]		    = {critical_damage = 3, args = {296}}, -- cockpit 
		[59]		= {critical_damage = 5, args = {148}}, -- nose bottom 
		[1]		    = {critical_damage = 5, args = {150}}, -- nose left
		[2]		    = {critical_damage = 5, args = {149}}, -- nose right
		[24]		= {critical_damage = 7, args = {213}, deps_cells = {26}},-- wing out right 
		[30]		= {critical_damage = 7, args = {214}, deps_cells = {24, 26, 38}},-- wing center right 
		[36]		= {critical_damage = 7, args = {215}, deps_cells = {30, 24, 26, 38}}, -- wing in right 
		[26]		= {critical_damage = 3, args = {216}}, -- eleron right 
		[38]		= {critical_damage = 4, args = {217}},-- flap in right 
		[23]		= {critical_damage = 7, args = {223}, deps_cells = {25}}, -- wing out left
		[29]		= {critical_damage = 7, args = {224}, deps_cells = {23, 25, 37}}, -- wing center left 
		[35]		= {critical_damage = 7, args = {225}, deps_cells = {29, 23, 25, 37}}, -- wing in left 
		[25]		= {critical_damage = 3, args = {226}}, -- eleron left 
		[37]		= {critical_damage = 4, args = {227}}, -- flap in left 
		[83]		= {critical_damage = 2, args = {134}}, -- wheel nose 
		[85]		= {critical_damage = 3, args = {135}}, -- wheel right 
		[84]		= {critical_damage = 3, args = {136}}, -- wheel left 
		[63]		= {critical_damage = 6, args = {53}, deps_cells = {66, 69, 72, 75}}, -- rotor
		[66]		= {critical_damage = 3, args = {380}}, -- blade 1 out  (for contact model!)
		[69]		= {critical_damage = 3, args = {381}}, -- blade 2 out  (for contact model!)
		[72]		= {critical_damage = 3, args = {382}}, -- blade 3 out  (for contact model!)
		[75]		= {critical_damage = 3, args = {383}}, -- blade 4 out  (for contact model!)
		[64]		= {critical_damage = 3, args = {429}}, -- blade 1 in
		[67]		= {critical_damage = 3, args = {430}}, -- blade 2 in
		[70]		= {critical_damage = 3, args = {431}}, -- blade 3 in
		[73]		= {critical_damage = 3, args = {119}}, -- blade 4 in
	},
	
	--[[
	Failures = {
		{ id = 'HORIZON_BAR_NOT_SETTLE',	  	  label = _('Artificial Horizon'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TURNIND_POINTER_FAILS_NO_VACUUM', label = _('Turn ind. No vac.'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TURNIND_POINTER_FAILS_DEFECTIVE', label = _('Turn ind. defective'),	 enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TURNIND_INCORRECT_SENS_DEFECTIVE',label = _('Turn ind. Incorrect  sens.'),	 enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TURNIND_INCORRECT_SENS_VAC_HIGH', label = _('Turn ind. Vacuum high'),		 enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TURNIND_INCORRECT_SENS_VAC_LOW',  label = _('Turn ind. Vacuum low'),			 enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TURNIND_POINTER_NOT_SET_ZERO',	  label = _('Turn ind. Pointer does not set on 0(N/F)'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TURNIND_POINTER_VIBRATES',	  	  label = _('Turn ind. Pointer vibrates(N/F)'),		 enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'PUMP_SEPARATOR_CLOGGED',	  	  label = _('Vacuum pump separator clogged'),		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'PUMP_RELIEF_VALVE_SCREEN_CLOGGED',	label = _('Vacuum valve screen clogged'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'PUMP_RELIEF_VALVE_LEAKS',	  		label = _('Vacuum relief valve leaks'),		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'PUMP_FAILS',	  					label = _('Vacuum pump fails'),		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'MANIFOLD_SHIFT',					label = _('Manifold pressure ind. pointer shifted'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'MANIFOLD_LINE_LEAK',				label = _('Manifold pressure ind. line leak'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			
		{ id = 'COOLANT_RADIATOR_WIRING',		label = _('Coolant radiator flap. No volt.'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COOLANT_RADIATOR_MOTOR',		label = _('Coolant radiator flap. Motor fault.'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COOLANT_RADIATOR_SENSOR',		label = _('Coolant radiator sensor fault.'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			
		{ id = 'OIL_RADIATOR_WIRING',			label = _('Oil radiator flap. No volt.'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'OIL_RADIATOR_MOTOR',			label = _('Oil radiator flap. Motor fault.'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'OIL_RADIATOR_SENSOR',			label = _('Oil radiator sensor fault.'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'OIL_LEAK',						label = _('Oil Leak.'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },

		{ id = 'COMPASS_NO_TORQUE',	  			label = _('Remote Compass. No torque'),				enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COMPASS_ERRATIC_OPERATION',	  	label = _('Remote Compass. Erratic operation'),		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COMPASS_POINTER_PULLS',	  		label = _('Remote Compass. Pointer pulls'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COMPASS_ERRATIC_INDIACATON',	label = _('Remote Compass. Loose pointer'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			
		{ id = 'DEFECTIVE_INSTRUMENT',	  		label = _('Directional gyro fail'),					enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'DEFECTIVE_MECHANISM',			label = _('Directional gyro mechanism fail'),		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		
		{ id = 'PITOT_HEAT_WIRING',				label = _('Pitot heating wire broken'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'PITOT_HEAT_ELEMENT',			label = _('Pitot heating element burned out'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'BAT_SOLENOID_WIRING',			label = _('Bat. solenoid wiring fault'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'BAT_SOLENOID_DEFECTIVE',		label = _('Bat. solenoid defective'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			
		{ id = 'SUPERCHARGER_LIGHT',		label = _('Supercharger light fault'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'SUPERCHARGER_WIRE',			label = _('Supercharger wiring fault'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'SUPERCHARGER_SOLENOID',		label = _('Supercharger solenoid fault'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'OIL_DILUTION_SOLENOID',		label = _('Oil dilution solenoid fault'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'OIL_DILUTION_WIRE',			label = _('Oil dilution wiring fault'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			
		{ id = 'TACH_BREAK_CIRCUIT',		label = _('Tachometer circuit break'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TACH_BREAK_IN_INDICATOR',	label = _('Tachometer indicator break'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TACH_POOR_CONNECTION',		label = _('Tachometer poor connection'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TACH_RESISTANCE_ADJ',		label = _('Tachometer indicator adjustment fault'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		
		{ id = 'VHF_CRYSTAL',				label = _('Radio. Crystal or tube failure'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'VHF_SHORTED_CTL_BOX',		label = _('Radio. Shorted control box'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'VHF_VT_BURNED_OUT',			label = _('Radio. Receiver burned out'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'VHF_VT207_DEFECTIVE',		label = _('Radio. Squelch tube burned out'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'VHF_SQUELCH_RELAY',			label = _('Radio. Squelch relay not working'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },

		{ id = 'F2_TOP_CYLINDER',		label = _('Top oxygen cylinder leakage'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'F2_BOTTOM_CYLINDER',	label = _('Bottom oxygen cylinder leakage'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'D2_LEFT_CYLINDER',		label = _('Left oxygen cylinder leakage'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'D2_RIGHT_CYLINDER',		label = _('Right oxygen cylinder leakage'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
	
		{ id = 'COOLANT_BREAK_BULB',		label = _('Coolant temp. ind. bulb fault'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COOLANT_DEFECTIVE_IND',		label = _('Coolant temp. ind. defective'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COOLANT_POOR_CONNTECT',		label = _('Coolant temp. ind. poor connection'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COOLANT_SHORT_CIRCUIT',		label = _('Coolant temp. ind. short circuit'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			
		{ id = 'CARBAIR_SHORT_CIRCUIT',		label = _('Carb. air ind. open or short circuit'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CARBAIR_SHORT_CIRCUIT_LEADS',label = _('Carb. air ind. short circuit in leads'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CARBAIR_GND_LEAD',			label = _('Carb. air ind. gnd in leads'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CARBAIR_SHORT_CIRCUIT_BLB',	label = _('Carb. air ind. bulb short circuit'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CARBAIR_BREAK_LEADS',		label = _('Carb. air ind. breaks in leads'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CARBAIR_OPEN_CIRCUIT_BLB',	label = _('Carb. air ind. open circuit in bulb'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		
		{ id = 'EXT_HYDRO_LEAK',	  		label = _('External hydro leak'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
        { id = 'INT_HYDRO_LEAK',	  		label = _('Internal hydro leak'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'HYDRO_LOW_AIR_PRESSURE',	label = _('Hydro acc. low air pressure'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'UNLOAD_VALVE_NOT_LOAD',	  	label = _('Hydro relief valve stuck in unload'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'UNLOAD_VALVE_NOT_UNLOAD',	label = _('Hydro relief valve stuck in load'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
	
		{ id = 'MAIN_L_GEAR_D_LOCK',	label = _('Left gear downlock fail'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'MAIN_R_GEAR_D_LOCK',	label = _('Right gear downlock fail'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TAIL_GEAR_D_LOCK',		label = _('Tail gear downlock fail'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TAIL_GEAR_U_LOCK',		label = _('Tail gear lock spring broken'), 	  enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TAIL_GEAR_FAIL_GO_DOWN',label = _('Tail gear up-latch cable broken'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TAIL_GEAR_FAIL_GO_UP',	label = _('Tail gear down-lock cable broken'),enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'TAIL_GEAR_C_CABLE',		label = _('Tail gear cable jammed'), 		  enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'L_GEAR_UPL_FAULT',		label = _('Left gear up-latch locked'),	 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'R_GEAR_UPL_FAULT',		label = _('Right gear up-latch locked'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'L_GEAR_DLK_FAULT',		label = _('Left gear down-lock locked'),	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'R_GEAR_DLK_FAULT',		label = _('Right gear down-lock locked'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'DOORS_TV_JAMMED',		label = _('Doors timing valve jammed'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'DOORS_TVC_BROKEN',		label = _('Doors timing valve cable broken'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },	
			
		{ id = 'IGNITION_NO_OUTPUT',	label = _('Ignition condenser burned out'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'IGNITION_TERM_CONNECT',	label = _('Ignition terminal connection fault'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'BOOSTER_COIL',			label = _('Booster coil fault'), 			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		
		{ id = 'STARTER_WIRING',		label = _('Starter wiring fault'), 			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'STARTER_RELAY',			label = _('Starter relay fault'), 			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'STARTER_SOLENOID',		label = _('Starter solenoid fault'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			
		{ id = 'FUEL_PUMP_FAILURE',		label = _('Fuel pump defective'),	 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'INSUF_FUEL_PRES',		label = _('Fuel pressure insufficient'),	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CLOGGED_FUEL_STRAINER',	label = _('Fuel strainer clogged'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'FUEL_VALVE_LEAK',		label = _('Fuel valve leak'),				enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'LEFT_WING_TANK_LEAK',	label = _('Left fuel tank leak'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'RIGHT_WING_TANK_LEAK',	label = _('Right fuel tank leak'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'LEFT_TANK_PUMP_FAULT',	label = _('Left tank pump fault'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'RIGHT_TANK_PUMP_FAULT',	label = _('Right tank pump fault'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },

		{ id = 'BOOST_REG',				label = _('Boost regulator failure'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'PROP_GOVERNOR',			label = _('Prop governor failure'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'MAGNETO_1',				label = _('Magneto 1 failure'),				enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'MAGNETO_2',				label = _('Magneto 2 failure'),				enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ENGINE_JAM',			label = _('Engine jam'),					enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COOLANT_UNPRES',		label = _('Coolant system unpressurized'),	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'BATTERY_OVERHEAT',		label = _('Battery overheated'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'STARTER_BURNOUT',		label = _('Starter burn out'),				enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			
		{ id = 'GENERATOR_FAULT',		label = _('Generator failure'),				enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
	},
	]]--

	--[[
    lights_data = {
        typename = "collection",
        lights = {
            [WOLALIGHT_LANDING_LIGHTS] = {
                typename = "collection",
                lights = {
                    {
                        typename = "collection",
                        lights = {
                            {
                                typename = "spotlight", connector = "RESERV_SPOT_PTR", dir_correction = {elevation = math.rad(-6.0)}, argument = 208,
                                proto = lamp_prototypes.LFS_P_27_200, angle_max = math.rad(50.0), angle_max = math.rad(40.0),
                                exposure = {{5, 0.090, 0.095}}, movable = true, power_up_t = 0.9,
                            },
                            {
                                typename = "spotlight", connector = "RESERV_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_200, range = 18.0, angle_max = math.rad(180.0), angle_max = math.rad(180.0),
                                exposure = {{5, 0.090, 0.095}}, movable = true, power_up_t = 0.9,
                            },
                        },
                    },
                },
            },
            [WOLALIGHT_TAXI_LIGHTS] = {
                typename = "collection",
                lights = {
                    {
                        typename = "collection",
                        lights = {
                            {
                                typename = "spotlight", connector = "RESERV_SPOT_PTR", dir_correction = {elevation = math.rad(-6.0)}, argument = 208,
                                proto = lamp_prototypes.LFS_P_27_200, angle_max = math.rad(50.0), angle_max = math.rad(40.0),
                                exposure = {{5, 0.090, 0.095}}, movable = true, power_up_t = 0.9,
                            },
                            {
                                typename = "spotlight", connector = "RESERV_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_200, range = 18.0, angle_max = math.rad(180.0), angle_max = math.rad(180.0),
                                exposure = {{5, 0.090, 0.095}}, movable = true, power_up_t = 0.9,
                            },
                        },
                    },
                },
            },
            [WOLALIGHT_NAVLIGHTS] = {
                typename = "collection",
                lights = {
                    { -- 0 -- Left Position Light (RED)
                        typename = "Spot", connector = "BANO_2", dir_correction = {elevation = math.rad(-45.0)}, argument = 190,
                        proto = lamp_prototypes.ANO_3_Kr, angle_max = math.rad(150.0), angle_min = math.rad(90.0),
                    },
                    { -- 1 -- Right Position Light (GREEN)
                        typename = "Spot", connector = "BANO_1", dir_correction = {elevation = math.rad(45.0)}, argument = 191,
                        proto = lamp_prototypes.ANO_3_Zl, angle_max = math.rad(150.0), angle_min = math.rad(90.0),
                    },
                    { -- 2 -- Tail Position Light (white)
                        typename = "collection",
                        lights = {
                            {
                                typename = "Spot", connector = "BANO_0", dir_correction = {azimuth = math.rad(180.0)}, argument = 192,
                                proto = lamp_prototypes.ANO_3_Bl,
                                movable = true,
                            },
                            {
                                typename = "Omni", connector = "BANO_0",
                                proto = lamp_prototypes.ANO_3_Bl, range = 6.2,
                                movable = true,
                            },
                        },
                    },
                },
            },
            [WOLALIGHT_AUX_LIGHTS] = {
                typename = "collection",
                lights = {
                    {
                        typename = "spotlight", connector = "FORM_LIGHTS_1", argument = 200,
                        color = {0.99, 0.11, 0.3, 0.22}, range = 30.0, angle_max = math.rad(60.0), angle_min = math.rad(0.0),
                        power_up_t = 0.050,
                    },
                    {
                        typename = "spotlight", connector = "FORM_LIGHTS_2", argument = 201,
                        color = {0.0, 0.894, 0.6, 0.25}, range = 30.0, angle_max = math.rad(60.0), angle_min = math.rad(0.0),
                        power_up_t = 0.050,
                    },
                    {
                        typename = "spotlight", connector = "FORM_LIGHTS_3", argument = 202,
                        color = {1.0, 0.5, 0.0, 0.25}, range = 30.0, angle_max = math.rad(60.0), angle_min = math.rad(0.0),
                        power_up_t = 0.050,
                    },
                }
            },
        }
    },
	]]--
	
	ViewSettings = ViewSettings,
	SnapViews	 = SnapViews,
	
	Countries = { "Abkhazia","Australia","Austria","Belarus","Belgium","Brazil","Bulgaria","Canada",
	"China","Croatia","Czech Republic","Denmark","Egypt","ESA","Finland","France",
	"Georgia","German Empire","Germany","Greece","Hungary","Imperial Japan","India","Insurgents",
	"Iran","Iraq","Israel","Italy","Italian Social Republic","Japan","Kazakhstan","NASA","North Korea",
	"Norway","Pakistan","Poland","Romania","Russia","Saudi Arabia","Serbia","Slovakia",
	"South Korea","South Ossetia","Spain","Sweden","Switzerland","Syria","The Netherlands","Third Reich","Turkey",
	"UK","Ukraine","USA","USAF Aggressors","USSR","Vietnam"}


}

--SFM_add.lua (file 7 for assembly)

add_aircraft(ki61)


