--[[
############################################################################################

OpForAC - Opposing Force AI Aircraft script

This script will spawn 1-4 opposing force AI aircraft (repeatable), which can be fighter, 
attack, bomber, trainer aircraft, or helicopter types.  AI aircraft types, engagement scenarios 
(i.e. BVR, ACM) and pre-set spawn distances are selectable from the F10 menu, under the F10 
menu item: "Spawn AI OpFor Aircraft At Will".

by Joe AKA_Relent Camilleri

*************************
***** Instructions: *****
*************************

*** Loading script: ***

Load the script in the DCS mission editor by first clicking the "Set rules for trigger" button
on the left vertical tool bar. 

Next, click the "NEW" button under the TRIGGERS, CONDITIONS, and ACTIONS columns, as described below:

Single Player (SP) missions (i.e. with one Player aircraft/helicopter, NO Clients):
	TRIGGERS: Set trigger to MISSION START (will not work in SP otherwise)
	ACTIONS: Set action to DO SCRIPT FILE, then navigate to and select OpForAC.lua script

Multi Player (MP) missions (i.e. with one or more Client aircraft/helicopter):
	Option 1:
		TRIGGERS: Set trigger to MISSION START
		ACTIONS: Set action to DO SCRIPT FILE, then navigate to and select OpForAC.lua script
	Option 2: (if there are issues loading script at mission start)
		TRIGGERS: Set trigger to ONCE
		CONDITIONS: Set condition to TIME MORE(x) (where x = desired delay in seconds from mission start)
		ACTIONS: Set action to DO SCRIPT FILE, then navigate to and select OpForAC.lua script
		NOTE: With this option, before you spawn in an aircraft, un-pause the mission first, or the script
			will not have loaded yet

*** Coalitions: ***

	To avoid blue-on-blue/neutral engagements, the script assumes the following countries are on the
	coalitions listed (NOTE: This is the default condition when creating a new mission.  However, 
	older missions may not have all of these countries mapped to the coalitions listed).
	Please verify and if necessary, assign to the coalitions listed below.  Click the "Changing
	coalitions" button on the left vertical tool bar to check the coalition assignments.

	BLUE:
		country.id.CJTF_BLUE (i.e. Combined Joint Task Forces Blue)
		country.id.FRANCE
		country.id.UK
		country.id.USA
		
	RED:
		country.id.CHINA
		country.id.CJTF_RED (i.e. Combined Joint Task Forces Red)
		country.id.NORTH_KOREA
		country.id.RUSSIA

*** Creating Exclusion Zones: ***

	You can prevent OpFor AI aircraft from spawning in or travelling through an exclusion zone(s), so they 
	do not readily attack players focused on non air-to-air activities;  Simply create one or more circular
	trigger zones that include "Exclusion Zone" or "exclusion zone" in the trigger name.  Click the
	"Create trigger zone" button on the left vertical tool bar to create a circular trigger zone(s).
		
		
*** Known issues: ***
	- For multi player missions, when a Client(player) is shot down, if they wish to use the same
		aircraft/helicopter	slot, they may need to move to Spectator first, then back to the 
		aircraft/helicopter	client slot.  Otherwise, the main OpForAC menu (i.e. 
		"Spawn AI OpFor Aircraft At Will") may be duplicated and not work.
	- When mission is flown in single player mode, kills are not being recorded properly in the
		debrief screen.  It is suggested to play all missions (i.e. with Client or Player) in multi-
		player mode (i.e. "Launch Multiplayer Server") if you wish to see the kills recorded.

==========================================================================================================		

*** Features: ***

Version 1.52
- AI OpFor aircraft coalition will be opposing the coalition of the aircraft or helicopter 
	the	client (MP) or player (SP) spawns in
- OpForAC script now works for dynamic spawn slots in MP missions
- The same AI OpFor aircraft type can be re-spawned as many times as desired
- One to four AI OpFor aircraft can be spawned at a time
- AI OpFor aircraft load-out depends on engagement scenario (e.g. for jet fighters: BVR vs ACM)
- AI OpFor aircraft skill defaults to "Random", but can be changed via 'Options' menu.  Note 
	that the updated AI skill persists for the initiating player name, for the duration of the mission
- AI OpFor aircraft altitude AGL defaults to "Random", but can be changed via 'Options' menu
	using pre-set low/medium/high altitudes AGL.  Note that the updated AI altitude AGL persists 
	for the initiating player name, for the duration of the mission
- AI OpFor aircraft spawn directly in front of client/player aircraft with a reverse heading
	towards the initiating client/player aircraft by default, but the starting point can be changed
	via Options menu.    Note that the updated AI starting point setting persists 
	for the initiating player name, for the duration of the mission
- AI OpFor aircraft spawn at a random altitude ~3k-26k feet AGL by default, but can be changed to
	pre-set altitudes via Options menu;	AI helicopters spawn at ~500 feet AGL
- AI OpFor aircraft spawn at a distance from the initiating aircraft of ~90 miles for BVR 
	engagements, ~25 miles for ACM, ~12 miles for helicopters and WW2 aircraft
- Once an AI OpFor aircraft returns to a friendly/neutral base and lands, it will be de-spawned
	once the aircraft stops (there is a function that checks for this every 120 seconds)
- A maximum of 24 AI OpFor aircraft can be spawned and active (alive) at a time, as defined by
	the glbMaxOpForSpawnable variable;  If you attempt to spawn AI OpFor aircraft and it
	would cause the total number of active (alive) AI OpFor aircraft to exceed this maximum number,
	you will see a message telling you they cannot be spawned, until the number of active AI OpFor
	aircraft is reduced by attrition or they land and de-spawn
- You can prevent OpFor AI aircraft from spawning in or travelling through an exclusion zones, so they 
	do not readily attack players focused on non air-to-air activities;  Simply create one or more circular
	trigger zones that include "Exclusion Zone" or "exclusion zone" in the trigger name.

##################################### GLOBALS ##############################################
]]

-- Maximum OpFor AI spawned aircraft allowed at one time
glbMaxOpForSpawnable = 24

debugFlgOpFor = 0
tblPlayerList = {}
tblClientUnit = {}
tblExclZoneList = {}
tblLoadoutPresets = {}
tblFuFlChLiPresets = {}
tblOneToFour = {"One", "Two", "Three", "Four"}
glbUnitId = 4000
glbGroupId = 4000
tblBlueCallSignsOpFor = {"Enfield", "Springfield", "Uzi", "Colt", "Dodge", "Ford", "Chevy", "Pontiac"}
glbCurrentBlueCallSignOpFor = 1
glbOnBoardNumOpFor = 200
glbDefSkill = "Random"
glbDefAAlt = "Random"
glbDefDir = "12oc"
glbOfacTopMenu = "Spawn AI OpFor Aircraft At Will"

-- BVR, ACM, Helo, WW2 spawn distances in Km - to convert to Mi, divide by 1.609344
glbBVRDist = 144.84096 -- 90 miles
glbACMDist = 40.2336 -- 25 miles
glbHeloDist = 20.1168 -- 12.5 miles
glbWW2Dist = 20.1168 -- 12.5 miles

-- High/Medium/Low pre-set aircraft altitudes in meters
glbHiAlt = 8000 -- ~26,200 feet
glbMedAlt = 3000 -- ~9,800 feet
glbLowAlt = 1000 -- ~3,300 feet

glbHeloSpeed = 80 -- 50 mph
glbHeloAlt = 150 -- ~500 feet
glbACSpeed = 250 -- 400 mph

glbFlgSPOpFor = 0

glbTblOpForSpawned = {}
glbOpForSpawned = 0

--[[
############################################################################################
Function:	AddRadioCommandsOpFor
Purpose:	Adds F10 radio menu items to spawn OpFor aircraft
Parameters:	pUnitName - Initiator unit name
			pPlayerName - Initiator player name
			pEnterUnit = Entered unit flag (true, false)
Returns:	nothing
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]
function AddRadioCommandsOpFor(pUnitName, pPlayerName, pEnterUnit)
	if (debugFlgOpFor == 2) then
		trigger.action.outText("DEBUG: Unit Name=" .. pUnitName, 5)
	end
	local lUnit = Unit.getByName(pUnitName)
	if (lUnit == nil) then
		return
	end
	
	local lUid = lUnit:getID()
	local lGid = GetGroupIDbyUnitIDOpFor(lUnit:getID())
	local lCid = GetCoalitionbyUnitIDOpFor(lUnit:getID())
	
	local lSkill = "Random"
	local lCurSkl = "Random"
	local lSelRnd = " "
	local lSelRk = " "
	local lSelT = " "
	local lSelV = " "
	local lSelA = " "
	
	local lAAlt = "Random"
	local lCurAAlt = "Random"
	local lSelARndA = " "
	local lSelALowA = " "
	local lSelAMedA = " "
	local lSelAHighA = " "
		
	local lDir = "12oc"
	local lCurDir = "12oc"
	local lSelD12oc = " "
	local lSelD9to3 = " "
	local lSelDRnd = " "
		
	if (debugFlgOpFor == 3) then
		trigger.action.outText("AddRadioCommandsOpFor: player name = " .. pPlayerName .. "lUnit:getID (lGid) =" .. lGid .. ", lUnit:getTypeName = " .. lUnit:getTypeName() ..
			", aircraft coalition: " .. lCid, 30)
	end
	
	lSkill = glbDefSkill
	lCurSkl = glbDefSkill
	if (debugFlgOpFor == 2) then
		trigger.action.outText("AddRadioCommandsOpFor: #tblPlayerList = " .. #tblPlayerList, 20)
	end
	for i=1, #tblPlayerList do
		if (debugFlgOpFor == 2) then
			trigger.action.outText("AddRadioCommandsOpFor: tblPlayerList[" .. i .. "].pName = " .. tblPlayerList[i].pName .. ", pPlayerName =" .. pPlayerName, 20)
		end
		if (tblPlayerList[i].pName == pPlayerName) then
			lSkill = tblPlayerList[i].optSkl
			lCurSkl = tblPlayerList[i].optCurSkl
			if (debugFlgOpFor == 2) then
				trigger.action.outText("AddRadioCommandsOpFor: tblPlayerList[" .. i .. "].optSkl = " .. tblPlayerList[i].optSkl .. "tblPlayerList[" .. i .. "].optCurSkl =" .. 
					tblPlayerList[i].optCurSkl, 20)
			end
			break
		end
	end
	
	-- Set indicator for which skill option is currently selected for this unit/player
	if (lCurSkl == "Random") then
		lSelRnd = "*"
	elseif (lCurSkl == "Rookie") then
		lSelRk = "*"
	elseif (lCurSkl == "Trained") then
		lSelT = "*"
	elseif (lCurSkl == "Veteran") then
		lSelV = "*"
	elseif (lCurSkl == "Ace") then
		lSelA = "*"
	end
	if (debugFlgOpFor == 2) then
		trigger.action.outText("lSelRnd=" .. lSelRnd .. ", lSelRk=" .. lSelRk .. ", lSelT=" .. lSelT .. ", lSelV=" .. lSelV .. ", lSelA=" .. lSelA, 20)
	end

	lAAlt = glbDefAAlt
	lCurAAlt = glbDefAAlt	
	if (debugFlgOpFor == 2) then
		trigger.action.outText("AddRadioCommandsOpFor: #tblPlayerList = " .. #tblPlayerList, 20)
	end
	for i=1, #tblPlayerList do
		if (debugFlgOpFor == 3) then
			trigger.action.outText("AddRadioCommandsOpFor: tblPlayerList[" .. i .. "].pName = " .. tblPlayerList[i].pName .. "pPlayerName =" .. pPlayerName, 20)
		end
		if (tblPlayerList[i].pName == pPlayerName) then
			lAAlt = tblPlayerList[i].optAAlt
			lCurAAlt = tblPlayerList[i].optCurAAlt
			if (debugFlgOpFor == 2) then
				trigger.action.outText("AddRadioCommandsOpFor: tblPlayerList[" .. i .. "].optAAlt = " .. tblPlayerList[i].optAAlt .. "tblPlayerList[" .. i .. "].optCurAAlt =" .. 
					tblPlayerList[i].optCurAAlt, 20)
			end
			break
		end
	end
	
	-- Set indicator for which aircraft altitude option is currently selected for this unit/player
	if (lCurAAlt == "Random") then
		lSelARndA = "*"
	elseif (lCurAAlt == "Low") then
		lSelALowA = "*"
	elseif (lCurAAlt == "Medium") then
		lSelAMedA = "*"
	elseif (lCurAAlt == "High") then
		lSelAHighA = "*"
	end
	if (debugFlgOpFor == 2) then
		trigger.action.outText("lSelARndA=" .. lSelARndA .. ", lSelALowA=" .. lSelALowA .. ", lSelAMedA=" .. lSelAMedA .. ", lSelAHighA=" .. lSelAHighA, 20)
	end
	
	lDir = glbDefDir
	lCurDir = glbDefDir	
	if (debugFlgOpFor == 2) then
		trigger.action.outText("AddRadioCommandsOpFor: #tblPlayerList = " .. #tblPlayerList, 20)
	end
	for i=1, #tblPlayerList do
		if (debugFlgOpFor == 3) then
			trigger.action.outText("AddRadioCommandsOpFor: tblPlayerList[" .. i .. "].pName = " .. tblPlayerList[i].pName .. "pPlayerName =" .. pPlayerName, 20)
		end
		if (tblPlayerList[i].pName == pPlayerName) then
			lDir = tblPlayerList[i].optDir
			lCurDir = tblPlayerList[i].optCurDir
			if (debugFlgOpFor == 2) then
				trigger.action.outText("AddRadioCommandsOpFor: tblPlayerList[" .. i .. "].optDir = " .. tblPlayerList[i].optDir .. "tblPlayerList[" .. i .. "].optCurDir =" .. 
					tblPlayerList[i].optCurDir, 20)
			end
			break
		end
	end
	
	-- Set indicator for which aircraft spawn direction option is currently selected for this unit/player
	if (lCurDir == "12oc") then
		lSelD12oc = "*"
	elseif (lCurDir == "9to3oc") then
		lSelD9to3 = "*"
	elseif (lCurDir == "Random") then
		lSelDRnd = "*"
	end
	if (debugFlgOpFor == 2) then
		trigger.action.outText("lSelD12oc=" .. lSelD12oc .. ", lSelD9to3=" .. lSelD9to3 .. ", lSelDRnd=" .. lSelDRnd, 20)
	end
	
	local ofacOmenuID = {}
	local ofacFmenuID = {}
	local ofacAmenuID = {}
	local ofacBmenuID = {}
	local ofacTmenuID = {}
	local ofacHmenuID = {}
	local ofacVFmenuID = {}
	local ofacWFmenuID = {}

	local playerFound = False
	if (lGid ~= nil) then
		for i=1, #tblPlayerList do
			if (tblPlayerList[i].pName == pPlayerName) then
				tblPlayerList[i].rMenuID = missionCommands.addSubMenuForGroup(lGid, glbOfacTopMenu)
				ofacOmenuID = missionCommands.addSubMenuForGroup(lGid, "Options", tblPlayerList[i].rMenuID)
				ofacFmenuID = missionCommands.addSubMenuForGroup(lGid, "Fighters", tblPlayerList[i].rMenuID)
				ofacAmenuID = missionCommands.addSubMenuForGroup(lGid, "Attackers", tblPlayerList[i].rMenuID)
				ofacBmenuID = missionCommands.addSubMenuForGroup(lGid, "Bombers", tblPlayerList[i].rMenuID)
				ofacTmenuID = missionCommands.addSubMenuForGroup(lGid, "Trainers", tblPlayerList[i].rMenuID)
				ofacHmenuID = missionCommands.addSubMenuForGroup(lGid, "Helicopters", tblPlayerList[i].rMenuID)
				ofacVFmenuID = missionCommands.addSubMenuForGroup(lGid, "Vietnam/70's Era Aircraft", tblPlayerList[i].rMenuID)
				ofacWFmenuID = missionCommands.addSubMenuForGroup(lGid, "WW2 & Korea Era Aircraft", tblPlayerList[i].rMenuID)			
				playerFound = true
				break
			end
		end
		
		if (playerFound == true) then
		
		-- Global options
		local ofacSSkill = missionCommands.addSubMenuForGroup(lGid, "Set AI Aircraft Pilot Skill", ofacOmenuID)
		local ofacSRand = missionCommands.addCommandForGroup(lGid, lSelRnd .. " Random (default)", ofacSSkill, SetSkillOpFor, lUid, pUnitName, pPlayerName, "Random")
		local ofacSRook = missionCommands.addCommandForGroup(lGid, lSelRk .. " Rookie", ofacSSkill, SetSkillOpFor, lUid, pUnitName, pPlayerName, "Rookie")
		local ofacSTrn = missionCommands.addCommandForGroup(lGid, lSelT .. " Trained", ofacSSkill, SetSkillOpFor, lUid, pUnitName, pPlayerName, "Trained")
		local ofacSVet = missionCommands.addCommandForGroup(lGid, lSelV .. " Veteran", ofacSSkill, SetSkillOpFor, lUid, pUnitName, pPlayerName, "Veteran")
		local ofacSAce = missionCommands.addCommandForGroup(lGid, lSelA .. " Ace", ofacSSkill, SetSkillOpFor, lUid, pUnitName, pPlayerName, "Ace")

		local ofacSAAlt = missionCommands.addSubMenuForGroup(lGid, "Set AI Aircraft Altitude AGL", ofacOmenuID)
		local ofacSARand = missionCommands.addCommandForGroup(lGid, lSelARndA .. " Random (default)", ofacSAAlt, SetAltOpFor, lUid, pUnitName, pPlayerName, "AC", "Random")
		local ofacSALow = missionCommands.addCommandForGroup(lGid, lSelALowA .. " Low", ofacSAAlt, SetAltOpFor, lUid, pUnitName, pPlayerName, "AC", "Low")
		local ofacSAMed = missionCommands.addCommandForGroup(lGid, lSelAMedA .. " Medium", ofacSAAlt, SetAltOpFor, lUid, pUnitName, pPlayerName, "AC", "Medium")
		local ofacSAHigh = missionCommands.addCommandForGroup(lGid, lSelAHighA .. " High", ofacSAAlt, SetAltOpFor, lUid, pUnitName, pPlayerName, "AC", "High")

		local ofacSDir = missionCommands.addSubMenuForGroup(lGid, "Set AI Aircraft Direction", ofacOmenuID)
		local ofacSD12oc = missionCommands.addCommandForGroup(lGid, lSelD12oc .. " 12 O'clock (default)", ofacSDir, SetDirOpFor, lUid, pUnitName, pPlayerName, "12oc")
		local ofacSD9to3 = missionCommands.addCommandForGroup(lGid, lSelD9to3 .. " 9 to 3 O'clock", ofacSDir, SetDirOpFor, lUid, pUnitName, pPlayerName, "9to3oc")
		local ofacSDRand = missionCommands.addCommandForGroup(lGid, lSelDRnd .. " Random", ofacSDir, SetDirOpFor, lUid, pUnitName, pPlayerName, "Random")

		
		-- Blue Player/Client coalition OpFor aircraft options
		if (lCid == coalition.side.BLUE) then

			-- AI fighter options
			
			-- J-11A options
			local ofacFmID_J11 = missionCommands.addSubMenuForGroup(lGid, "J-11A", ofacFmenuID)
			local ofacFmID_J11BLE = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles w/ECM (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_J11)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_J11BLE, CallSpawnOpForACGroup, pUnitName, country.id.CHINA, "J-11A", i, lSkill, lAAlt, lDir, "BVR_LRE", glbBVRDist)
			end
			local ofacFmID_J11BL = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_J11)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_J11BL, CallSpawnOpForACGroup, pUnitName, country.id.CHINA, "J-11A", i, lSkill, lAAlt, lDir, "BVR_LR", glbBVRDist)
			end

			-- JF-17 options
			local ofacRFmID_JF17 = missionCommands.addSubMenuForGroup(lGid, "JF-17", ofacFmenuID)
			local ofacRFmID_JF17B = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacRFmID_JF17)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacRFmID_JF17B, CallSpawnOpForACGroup, pUnitName, country.id.CHINA, "JF-17", i, lSkill, lAAlt, lDir, "BVR", glbBVRDist)
			end
			local ofacRFmID_JF17AI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacRFmID_JF17)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacRFmID_JF17AI, CallSpawnOpForACGroup, pUnitName, country.id.CHINA, "JF-17", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local ofacRFmID_JF17A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacRFmID_JF17)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacRFmID_JF17A, CallSpawnOpForACGroup, pUnitName, country.id.CHINA, "JF-17", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end

			-- M-2000C options
			local ofacRFmID_M2K = missionCommands.addSubMenuForGroup(lGid, "M-2000C", ofacFmenuID)
			local ofacRFmID_M2KB = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacRFmID_M2K)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacRFmID_M2KB, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "M-2000C", i, lSkill, lAAlt, lDir, "BVR", glbBVRDist)
			end
			local ofacRFmID_M2KAI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacRFmID_M2K)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacRFmID_M2KAI, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "M-2000C", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local ofacRFmID_M2KA = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacRFmID_M2K)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacRFmID_M2KA, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "M-2000C", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- MiG-29A/S options
			local ofacFmID_M29AS = missionCommands.addSubMenuForGroup(lGid, "MiG-29A/S", ofacFmenuID)
			local ofacFmID_M29SL = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_M29AS)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_M29SL, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-29S", i, lSkill, lAAlt, lDir, "BVR_LR", glbBVRDist)
			end
			local ofacFmID_M29AL = missionCommands.addSubMenuForGroup(lGid, "BVR w/ER SARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_M29AS)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_M29AL, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-29A", i, lSkill, lAAlt, lDir, "BVR_LR", glbBVRDist)
			end
			local ofacFmID_M29AM = missionCommands.addSubMenuForGroup(lGid, "BVR w/R SARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_M29AS)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_M29AM, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-29A", i, lSkill, lAAlt, lDir, "BVR_MR", glbBVRDist)
			end
			local ofacFmID_M29AAI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_M29AS)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_M29AAI, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-29A", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local ofacFmID_M29AA = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_M29AS)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_M29AA, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-29A", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- MiG-31 options
			local ofacFmID_M31 = missionCommands.addSubMenuForGroup(lGid, "MiG-31", ofacFmenuID)
			local ofacFmID_M31B = missionCommands.addSubMenuForGroup(lGid, "BVR (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_M31)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_M31B, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-31", i, lSkill, lAAlt, lDir, "BVR", glbBVRDist)
			end
			local ofacFmID_M31AI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_M31)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_M31AI, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-31", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local ofacFmID_M31A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_M31)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_M31A, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-31", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
				
			-- Su-27 options
			local ofacFmID_S27 = missionCommands.addSubMenuForGroup(lGid, "Su-27", ofacFmenuID)
			local ofacFmID_S27BL = missionCommands.addSubMenuForGroup(lGid, "BVR w/ER SARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_S27)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_S27BL, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-27", i, lSkill, lAAlt, lDir, "BVR_LR", glbBVRDist)
			end
			local ofacFmID_S27BM = missionCommands.addSubMenuForGroup(lGid, "BVR w/R SARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_S27)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_S27BM, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-27", i, lSkill, lAAlt, lDir, "BVR_MR", glbBVRDist)
			end
			local ofacFmID_S27AI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_S27)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_S27AI, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-27", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local ofacFmID_S27A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_S27)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_S27A, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-27", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end

			-- Su-30 options
			local ofacFmID_S30 = missionCommands.addSubMenuForGroup(lGid, "Su-30", ofacFmenuID)
			local ofacFmID_S30BLE = missionCommands.addSubMenuForGroup(lGid, "BVR ARH Missiles w/ECM (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_S30)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_S30BLE, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-30", i, lSkill, lAAlt, lDir, "BVR_LRE", glbBVRDist)
			end
			local ofacFmID_S30BL = missionCommands.addSubMenuForGroup(lGid, "BVR ARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_S30)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_S30BL, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-30", i, lSkill, lAAlt, lDir, "BVR_LR", glbBVRDist)
			end
			local ofacFmID_S30AI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_S30)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_S30AI, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-30", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local ofacFmID_S30A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_S30)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_S30A, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-30", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end

			-- Su-33 options
			local ofacFmID_S33 = missionCommands.addSubMenuForGroup(lGid, "Su-33", ofacFmenuID)
			local ofacFmID_S33BLE = missionCommands.addSubMenuForGroup(lGid, "BVR w/ER SARH Missiles w/ECM (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_S33)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_S33BLE, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-33", i, lSkill, lAAlt, lDir, "BVR_LRE", glbBVRDist)
			end
			local ofacFmID_S33BL = missionCommands.addSubMenuForGroup(lGid, "BVR w/ER SARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_S33)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_S33BL, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-33", i, lSkill, lAAlt, lDir, "BVR_LR", glbBVRDist)
			end
			local ofacFmID_S33BM = missionCommands.addSubMenuForGroup(lGid, "BVR w/R SARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_S33)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_S33BM, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-33", i, lSkill, lAAlt, lDir, "BVR_MR", glbBVRDist)
			end
			local ofacFmID_S33AI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_S33)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_S33AI, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-33", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local ofacFmID_S33A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_S33)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_S33A, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-33", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- AI attacker options

			-- Su-25A options
			local AmID_S25 = missionCommands.addSubMenuForGroup(lGid, "Su-25", ofacAmenuID)
			local tblofacRFmID_S25 = {}
			tblofacRFmID_S25[1] = missionCommands.addSubMenuForGroup(lGid, "w/IR AA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", AmID_S25)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_S25[1], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-25", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbBVRDist)
			end
			tblofacRFmID_S25[2] = missionCommands.addSubMenuForGroup(lGid, "w/IR RA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", AmID_S25)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_S25[2], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-25", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbBVRDist)
			end
			tblofacRFmID_S25[3] = missionCommands.addSubMenuForGroup(lGid, "w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_S25)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_S25[3], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-25", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			tblofacRFmID_S25[4] = missionCommands.addSubMenuForGroup(lGid, "w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_S25)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_S25[4], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-25", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			tblofacRFmID_S25[5] = missionCommands.addSubMenuForGroup(lGid, "No IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_S25)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_S25[5], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-25", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end

			-- Su-25T options
			local AmID_S25T = missionCommands.addSubMenuForGroup(lGid, "Su-25T", ofacAmenuID)
			local tblofacRFmID_S25T = {}
			tblofacRFmID_S25T[1] = missionCommands.addSubMenuForGroup(lGid, "w/IR AA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", AmID_S25T)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_S25T[1], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-25T", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbBVRDist)
			end
			tblofacRFmID_S25T[2] = missionCommands.addSubMenuForGroup(lGid, "w/IR RA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", AmID_S25T)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_S25T[2], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-25T", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbBVRDist)
			end
			tblofacRFmID_S25T[3] = missionCommands.addSubMenuForGroup(lGid, "w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_S25T)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_S25T[3], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-25T", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			tblofacRFmID_S25T[4] = missionCommands.addSubMenuForGroup(lGid, "w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_S25T)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_S25T[4], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-25T", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			tblofacRFmID_S25T[5] = missionCommands.addSubMenuForGroup(lGid, "No IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_S25T)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_S25T[5], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-25T", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end

			-- Su-34 options
			local AmID_S34 = missionCommands.addSubMenuForGroup(lGid, "Su-34", ofacAmenuID)
			local AmID_S34B = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles w/ECM (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", AmID_S34)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_S34B, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-34", i, lSkill, lAAlt, lDir, "BVR", glbBVRDist)
			end
			local AmID_S34AI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_S34)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_S34AI, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-34", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local AmID_S34A = missionCommands.addSubMenuForGroup(lGid, "ACM No IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_S34)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_S34A, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-34", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- AI bomber options

			-- H-6J options
			local BmID_H6 = missionCommands.addSubMenuForGroup(lGid, "H-6J", ofacBmenuID)
			local BmID_H6BA = missionCommands.addSubMenuForGroup(lGid, "Intercept (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", BmID_H6)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", BmID_H6BA, CallSpawnOpForACGroup, pUnitName, country.id.CHINA, "H-6J", i, lSkill, lAAlt, lDir, "ACM", glbBVRDist)
			end
			local BmID_H6A = missionCommands.addSubMenuForGroup(lGid, "Intercept (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", BmID_H6)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", BmID_H6A, CallSpawnOpForACGroup, pUnitName, country.id.CHINA, "H-6J", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end

			-- Su-24M options
			local BmID_S24 = missionCommands.addSubMenuForGroup(lGid, "Su-24M", ofacBmenuID)
			local tblofacRFmID_S24 = {}
			tblofacRFmID_S24[1] = missionCommands.addSubMenuForGroup(lGid, "Intercept w/IR AA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", BmID_S24)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_S24[1], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-24M", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbBVRDist)
			end
			tblofacRFmID_S24[2] = missionCommands.addSubMenuForGroup(lGid, "Intercept w/IR RA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", BmID_S24)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_S24[2], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-24M", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbBVRDist)
			end
			tblofacRFmID_S24[3] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", BmID_S24)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_S24[3], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-24M", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			tblofacRFmID_S24[4] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", BmID_S24)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_S24[4], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-24M", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			tblofacRFmID_S24[5] = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", BmID_S24)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_S24[5], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-24M", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
		
			-- Tu-22M3 options
			local BmID_T22 = missionCommands.addSubMenuForGroup(lGid, "Tu-22M3", ofacBmenuID)
			local BmID_T22BA = missionCommands.addSubMenuForGroup(lGid, "Intercept (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", BmID_T22)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", BmID_T22BA, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Tu-22M3", i, lSkill, lAAlt, lDir, "ACM", glbBVRDist)
			end
			local BmID_T22A = missionCommands.addSubMenuForGroup(lGid, "Intercept (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", BmID_T22)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", BmID_T22A, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Tu-22M3", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- Tu-142 options
			local BmID_T142 = missionCommands.addSubMenuForGroup(lGid, "Tu-142", ofacBmenuID)
			local BmID_T142BA = missionCommands.addSubMenuForGroup(lGid, "Intercept (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", BmID_T142)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", BmID_T142BA, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Tu-142", i, lSkill, lAAlt, lDir, "ACM", glbBVRDist)
			end
			local BmID_T142A = missionCommands.addSubMenuForGroup(lGid, "Intercept (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", BmID_T142)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", BmID_T142A, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Tu-142", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end

			-- AI trainer options
			
			-- C-101CC options
			local ofacTmID_C101 = missionCommands.addSubMenuForGroup(lGid, "C-101CC", ofacTmenuID)
			local ofacTmID_C101B = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR AA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacTmID_C101)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacTmID_C101B, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "C-101CC", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbBVRDist)
			end
			local ofacTmID_C101AIA = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacTmID_C101)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacTmID_C101AIA, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "C-101CC", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			local ofacTmID_C101AIR = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacTmID_C101)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacTmID_C101AIR, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "C-101CC", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			local ofacTmID_C101A = missionCommands.addSubMenuForGroup(lGid, "ACM No IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacTmID_C101)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacTmID_C101A, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "C-101CC", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- Hawk options
			local ofacTmID_Hawk = missionCommands.addSubMenuForGroup(lGid, "Hawk", ofacTmenuID)
			local ofacTmID_HawkB = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR AA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacTmID_Hawk)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacTmID_HawkB, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "Hawk", i, lSkill, lAAlt, lDir, "ACM_IR", glbBVRDist)
			end
			local ofacTmID_HawkAI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacTmID_Hawk)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacTmID_HawkAI, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "Hawk", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local ofacTmID_HawkA = missionCommands.addSubMenuForGroup(lGid, "ACM No IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacTmID_Hawk)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacTmID_HawkA, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "Hawk", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- L-39ZA options
			local TmID_L39 = missionCommands.addSubMenuForGroup(lGid, "L-39ZA", ofacTmenuID)
			local TmID_L39B = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR AA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", TmID_L39)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", TmID_L39B, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "L-39ZA", i, lSkill, lAAlt, lDir, "BVR", glbBVRDist)
			end
			local TmID_L39AIA = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", TmID_L39)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", TmID_L39AIA, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "L-39ZA", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			local TmID_L39AIR = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", TmID_L39)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", TmID_L39AIR, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "L-39ZA", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			local TmID_L39A = missionCommands.addSubMenuForGroup(lGid, "ACM No IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", TmID_L39)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", TmID_L39A, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "L-39ZA", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- AI helicopter options

			-- Ka-50 options
			local HmID_K50 = missionCommands.addSubMenuForGroup(lGid, "Ka-50", ofacHmenuID)
			local HmID_K50A = missionCommands.addSubMenuForGroup(lGid, "AGM, No IR Missiles (" .. tostring(math.ceil(glbHeloDist/1.609344)) .. " mi)", HmID_K50)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", HmID_K50A, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Ka-50", i, lSkill, lAAlt, lDir, "ACM", glbHeloDist)
			end
			
			-- Ka-50 III options
			local HmID_K50_3 = missionCommands.addSubMenuForGroup(lGid, "Ka-50_3", ofacHmenuID)
			local HmID_K50_3A = missionCommands.addSubMenuForGroup(lGid, "AGM, w/IR Missiles (" .. tostring(math.ceil(glbHeloDist/1.609344)) .. " mi)", HmID_K50_3)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", HmID_K50_3A, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Ka-50_3", i, lSkill, lAAlt, lDir, "ACM_IR", glbHeloDist)
			end

			-- Mi-8MT options
			local HmID_M8 = missionCommands.addSubMenuForGroup(lGid, "Mi-8MT", ofacHmenuID)
			local HmID_M8A = missionCommands.addSubMenuForGroup(lGid, "No IR Missiles (" .. tostring(math.ceil(glbHeloDist/1.609344)) .. " mi)", HmID_M8)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", HmID_M8A, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Mi-8MT", i, lSkill, lAAlt, lDir, "ACM", glbHeloDist)
			end
			
			-- Mi-24P options
			local HmID_M24 = missionCommands.addSubMenuForGroup(lGid, "Mi-24P", ofacHmenuID)
			local HmID_M24AI = missionCommands.addSubMenuForGroup(lGid, "AGM, w/IR Missiles (" .. tostring(math.ceil(glbHeloDist/1.609344)) .. " mi)", HmID_M24)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", HmID_M24AI, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Mi-24P", i, lSkill, lAAlt, lDir, "ACM_IR", glbHeloDist)
			end
			local HmID_M24A = missionCommands.addSubMenuForGroup(lGid, "AGM, No IR Missiles (" .. tostring(math.ceil(glbHeloDist/1.609344)) .. " mi)", HmID_M24)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", HmID_M24A, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Mi-24P", i, lSkill, lAAlt, lDir, "ACM", glbHeloDist)
			end
		
			-- Mi-26 options
			local HmID_M26 = missionCommands.addSubMenuForGroup(lGid, "Mi-26", ofacHmenuID)
			local HmID_M26A = missionCommands.addSubMenuForGroup(lGid, "Unarmed (" .. tostring(math.ceil(glbHeloDist/1.609344)) .. " mi)", HmID_M26)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", HmID_M26A, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Mi-26", i, lSkill, lAAlt, lDir, "ACM", glbHeloDist)
			end
	
			-- Mi-28N options
			local HmID_M28 = missionCommands.addSubMenuForGroup(lGid, "Mi-28N", ofacHmenuID)
			local HmID_M28A = missionCommands.addSubMenuForGroup(lGid, "AGM, No IR Missiles (" .. tostring(math.ceil(glbHeloDist/1.609344)) .. " mi)", HmID_M28)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", HmID_M28A, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Mi-28N", i, lSkill, lAAlt, lDir, "ACM", glbHeloDist)
			end

			-- AI Vietnam/70's era aircraft options

			-- F-4E options
			local ofacRFmID_F4 = missionCommands.addSubMenuForGroup(lGid, "F-4E-45MC", ofacVFmenuID)
			local tblofacRFmID_F4E = {}
			tblofacRFmID_F4E[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacRFmID_F4)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_F4E[1], CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "F-4E-45MC", i, lSkill, lAAlt, lDir, "BVR", glbBVRDist)
			end
			tblofacRFmID_F4E[2] = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR RA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacRFmID_F4)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_F4E[2], CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "F-4E-45MC", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbBVRDist)
			end
			tblofacRFmID_F4E[3] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacRFmID_F4)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_F4E[3], CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "F-4E-45MC", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			tblofacRFmID_F4E[4] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacRFmID_F4)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_F4E[4], CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "F-4E-45MC", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			tblofacRFmID_F4E[5] = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacRFmID_F4)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_F4E[5], CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "F-4E-45MC", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- F-5E-3 options
			local ofacRFmID_F5 = missionCommands.addSubMenuForGroup(lGid, "F-5E-3", ofacVFmenuID)
			local tblofacRFmID_F5E = {}
			tblofacRFmID_F5E[1] = missionCommands.addSubMenuForGroup(lGid, "BVR/ACM w/IR AA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacRFmID_F5)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_F5E[1], CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "F-5E-3", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbBVRDist)
			end
			tblofacRFmID_F5E[2] = missionCommands.addSubMenuForGroup(lGid, "BVR/ACM w/IR RA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacRFmID_F5)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_F5E[2], CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "F-5E-3", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbBVRDist)
			end
			tblofacRFmID_F5E[3] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacRFmID_F5)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_F5E[3], CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "F-5E-3", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			tblofacRFmID_F5E[4] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacRFmID_F5)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_F5E[4], CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "F-5E-3", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			tblofacRFmID_F5E[5] = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacRFmID_F5)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_F5E[5], CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "F-5E-3", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- F-14A-135-GR options
			local ofacRFmID_F14 = missionCommands.addSubMenuForGroup(lGid, "F-14A-135-GR", ofacVFmenuID)
			local ofacRFmID_F14BLR = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacRFmID_F14)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacRFmID_F14BLR, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "F-14A-135-GR", i, lSkill, lAAlt, lDir, "BVR_LR", glbBVRDist)
			end
			local ofacRFmID_F14BMR = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacRFmID_F14)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacRFmID_F14BMR, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "F-14A-135-GR", i, lSkill, lAAlt, lDir, "BVR_MR", glbBVRDist)
			end
			local ofacRFmID_F14AI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacRFmID_F14)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacRFmID_F14AI, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "F-14A-135-GR", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local ofacRFmID_F14A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacRFmID_F14)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacRFmID_F14A, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "F-14A-135-GR", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- MiG-19P options
			local ofacFmID_M19 = missionCommands.addSubMenuForGroup(lGid, "MiG-19P", ofacVFmenuID)
			local ofacFmID_M19BAI = missionCommands.addSubMenuForGroup(lGid, "BVR/ACM w/IR RA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_M19)
			for i=1, #tblOneToFour do
			missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_M19BAI, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-19P", i, lSkill, lAAlt, lDir, "ACM_IR", glbBVRDist)
			end
			local ofacFmID_M19AI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_M19)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_M19AI, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-19P", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local ofacFmID_M19A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_M19)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_M19A, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-19P", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
					
			-- MiG-21Bis options
			local ofacFmID_M21 = missionCommands.addSubMenuForGroup(lGid, "MiG-21Bis", ofacVFmenuID)
			local tblofacRFmID_M21 = {}
			tblofacRFmID_M21[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_M21)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_M21[1], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-21Bis", i, lSkill, lAAlt, lDir, "BVR", glbBVRDist)
			end
			tblofacRFmID_M21[2] = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR RA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_M21)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_M21[2], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-21Bis", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbBVRDist)
			end
			tblofacRFmID_M21[3] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_M21)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_M21[3], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-21Bis", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			tblofacRFmID_M21[4] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_M21)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_M21[4], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-21Bis", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			tblofacRFmID_M21[5] = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_M21)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_M21[5], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-21Bis", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
								
			-- MiG-23MLD options
			local ofacFmID_M23 = missionCommands.addSubMenuForGroup(lGid, "MiG-23MLD", ofacVFmenuID)
			local tblofacRFmID_M23 = {}
			tblofacRFmID_M23[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_M23)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_M23[1], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-23MLD", i, lSkill, lAAlt, lDir, "BVR", glbBVRDist)
			end
			tblofacRFmID_M23[2] = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR RA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_M23)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_M23[2], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-23MLD", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbBVRDist)
			end
			tblofacRFmID_M23[3] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_M23)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_M23[3], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-23MLD", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			tblofacRFmID_M23[4] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_M23)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_M23[4], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-23MLD", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			tblofacRFmID_M23[5] = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_M23)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_M23[5], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-23MLD", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- MiG-27K options
			local ofacFmID_M27 = missionCommands.addSubMenuForGroup(lGid, "MiG-27K", ofacVFmenuID)
			local tblofacRFmID_M27 = {}
			tblofacRFmID_M27[1] = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR AA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_M27)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_M27[1], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-27K", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbBVRDist)
			end
			tblofacRFmID_M27[2] = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR RA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_M27)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_M27[2], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-27K", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbBVRDist)
			end
			tblofacRFmID_M27[3] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_M27)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_M27[3], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-27K", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			tblofacRFmID_M27[4] = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_M27)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_M27[4], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-27K", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			tblofacRFmID_M27[5] = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_M27)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", tblofacRFmID_M27[5], CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "MiG-27K", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- Mirage-F1CE options
			local ofacRFmID_F1 = missionCommands.addSubMenuForGroup(lGid, "Mirage-F1CE", ofacVFmenuID)
			local ofacRFmID_F1B = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacRFmID_F1)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacRFmID_F1B, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "Mirage-F1CE", i, lSkill, lAAlt, lDir, "BVR", glbBVRDist)
			end
			local ofacRFmID_F1BRA = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR RA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacRFmID_F1)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacRFmID_F1BRA, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "Mirage-F1CE", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbBVRDist)
			end
			local ofacRFmID_F1AIA = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacRFmID_F1)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacRFmID_F1AIA, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "Mirage-F1CE", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			local ofacRFmID_F1AIR = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacRFmID_F1)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacRFmID_F1AIR, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "Mirage-F1CE", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			local ofacRFmID_F1A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacRFmID_F1)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacRFmID_F1A, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "Mirage-F1CE", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end

			-- Su-17M4 options
			local AmID_S17 = missionCommands.addSubMenuForGroup(lGid, "Su-17M4", ofacVFmenuID)
			local AmID_S17BAAI = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR AA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", AmID_S17)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_S17BAAI, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-17M4", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbBVRDist)
			end
			local AmID_S17BRAI = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR RA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", AmID_S17)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_S17BRAI, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-17M4", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbBVRDist)
			end
			local AmID_S17AAI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_S17)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_S17AAI, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-17M4", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			local AmID_S17RAI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_S17)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_S17RAI, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-17M4", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			local AmID_S17A = missionCommands.addSubMenuForGroup(lGid, "ACM No IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_S17)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_S17A, CallSpawnOpForACGroup, pUnitName, country.id.RUSSIA, "Su-17M4", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- AI WWII and Korea era aircraft options

			-- Bf-109K-4 options
			local ofacWFmID_B109 = missionCommands.addSubMenuForGroup(lGid, "Bf-109K-4", ofacWFmenuID)
			local ofacWFmID_B109A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbWW2Dist/1.609344)) .. " mi)", ofacWFmID_B109)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacWFmID_B109A, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "Bf-109K-4", i, lSkill, lAAlt, lDir, "ACM", glbWW2Dist)
			end

			-- FW-190A8 options
			local ofacWFmID_B190 = missionCommands.addSubMenuForGroup(lGid, "FW-190A8", ofacWFmenuID)
			local ofacWFmID_B190A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbWW2Dist/1.609344)) .. " mi)", ofacWFmID_B190)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacWFmID_B190A, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "FW-190A8", i, lSkill, lAAlt, lDir, "ACM", glbWW2Dist)
			end

			-- FW-190D9 options
			local ofacWFmID_F190D = missionCommands.addSubMenuForGroup(lGid, "FW-190D9", ofacWFmenuID)
			local ofacWFmID_F190DA = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbWW2Dist/1.609344)) .. " mi)", ofacWFmID_F190D)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacWFmID_F190DA, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_RED, "FW-190D9", i, lSkill, lAAlt, lDir, "ACM", glbWW2Dist)
			end
			
			-- MiG-15bis options
			local ofacWFmID_M15 = missionCommands.addSubMenuForGroup(lGid, "MiG-15bis", ofacWFmenuID)
			local ofacWFmID_M15A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacWFmID_M15)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacWFmID_M15A, CallSpawnOpForACGroup, pUnitName, country.id.NORTH_KOREA, "MiG-15bis", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end

			
		-- Red Player/Client coalition OpFor aircraft options
		elseif (lCid == coalition.side.RED) then
		
			-- AI fighter options
			
			-- F-14B options
			local ofacFmID_F14B = missionCommands.addSubMenuForGroup(lGid, "F-14B", ofacFmenuID)
			local ofacFmID_F14BBLR = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_F14B)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F14BBLR, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-14B", i, lSkill, lAAlt, lDir, "BVR_LR", glbBVRDist)
			end
			local ofacFmID_F14BBMR = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_F14B)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F14BBMR, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-14B", i, lSkill, lAAlt, lDir, "BVR_MR", glbBVRDist)
			end
			local ofacFmID_F14BAI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_F14B)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F14BAI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-14B", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local ofacFmID_F14BA = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_F14B)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F14BA, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-14B", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- F-15C options
			local ofacFmID_F15 = missionCommands.addSubMenuForGroup(lGid, "F-15C", ofacFmenuID)
			local ofacFmID_F15BLR = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_F15)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F15BLR, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-15C", i, lSkill, lAAlt, lDir, "BVR_LR", glbBVRDist)
			end
			local ofacFmID_F15BMR = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_F15)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F15BMR, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-15C", i, lSkill, lAAlt, lDir, "BVR_MR", glbBVRDist)
			end
			local ofacFmID_F15AI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_F15)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F15AI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-15C", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local ofacFmID_F15A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_F15)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F15A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-15C", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- F-16C_50 options
			local ofacFmID_F16 = missionCommands.addSubMenuForGroup(lGid, "F-16C_50", ofacFmenuID)
			local ofacFmID_F16BE = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles w/ECM (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_F16)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F16BE, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-16C_50", i, lSkill, lAAlt, lDir, "BVR_E", glbBVRDist)
			end
			local ofacFmID_F16B = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_F16)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F16B, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-16C_50", i, lSkill, lAAlt, lDir, "BVR", glbBVRDist)
			end
			local ofacFmID_F16AIX = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR 9X Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_F16)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F16AIX, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-16C_50", i, lSkill, lAAlt, lDir, "ACM_IRX", glbACMDist)
			end
			local ofacFmID_F16AI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR 9M Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_F16)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F16AI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-16C_50", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local ofacFmID_F16A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_F16)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F16A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-16C_50", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- FA-18C_hornet options
			local ofacFmID_F18 = missionCommands.addSubMenuForGroup(lGid, "FA-18C_hornet", ofacFmenuID)
			local ofacFmID_F18BLR = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_F18)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F18BLR, CallSpawnOpForACGroup, pUnitName, country.id.USA, "FA-18C_hornet", i, lSkill, lAAlt, lDir, "BVR_LR", glbBVRDist)
			end
			local ofacFmID_F18BMR = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_F18)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F18BMR, CallSpawnOpForACGroup, pUnitName, country.id.USA, "FA-18C_hornet", i, lSkill, lAAlt, lDir, "BVR_MR", glbBVRDist)
			end
			local ofacFmID_F18AI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_F18)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F18AI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "FA-18C_hornet", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local ofacFmID_F18A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_F18)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F18A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "FA-18C_hornet", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- JF-17 options
			local ofacBFmID_JF17 = missionCommands.addSubMenuForGroup(lGid, "JF-17", ofacFmenuID)
			local ofacBFmID_JF17B = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacBFmID_JF17)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacBFmID_JF17B, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_BLUE, "JF-17", i, lSkill, lAAlt, lDir, "BVR", glbBVRDist)
			end
			local ofacBFmID_JF17AI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacBFmID_JF17)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacBFmID_JF17AI, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_BLUE, "JF-17", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local ofacBFmID_JF17A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacBFmID_JF17)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacBFmID_JF17A, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_BLUE, "JF-17", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- M-2000C options
			local ofacBFmID_M2K = missionCommands.addSubMenuForGroup(lGid, "M-2000C", ofacFmenuID)
			local ofacBFmID_M2KB = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacBFmID_M2K)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacBFmID_M2KB, CallSpawnOpForACGroup, pUnitName, country.id.FRANCE, "M-2000C", i, lSkill, lAAlt, lDir, "BVR", glbBVRDist)
			end
			local ofacBFmID_M2KAI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacBFmID_M2K)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacBFmID_M2KAI, CallSpawnOpForACGroup, pUnitName, country.id.FRANCE, "M-2000C", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local ofacBFmID_M2KA = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacBFmID_M2K)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacBFmID_M2KA, CallSpawnOpForACGroup, pUnitName, country.id.FRANCE, "M-2000C", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
						
			-- AI attacker options

			-- A-10A options
			local AmID_A10A = missionCommands.addSubMenuForGroup(lGid, "A-10A", ofacAmenuID)
			local AmID_A10ABAI = missionCommands.addSubMenuForGroup(lGid, "w/IR AA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", AmID_A10A)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_A10ABAI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "A-10A", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbBVRDist)
			end
			local AmID_A10ABRAI = missionCommands.addSubMenuForGroup(lGid, "w/IR RA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", AmID_A10A)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_A10ABRAI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "A-10A", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbBVRDist)
			end
			local AmID_A10AAI = missionCommands.addSubMenuForGroup(lGid, "w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_A10A)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_A10AAI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "A-10A", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			local AmID_A10ARAI = missionCommands.addSubMenuForGroup(lGid, "w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_A10A)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_A10ARAI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "A-10A", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			local AmID_A10AA = missionCommands.addSubMenuForGroup(lGid, "No IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_A10A)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_A10AA, CallSpawnOpForACGroup, pUnitName, country.id.USA, "A-10A", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- A-10C_2 options
			local AmID_A10C = missionCommands.addSubMenuForGroup(lGid, "A-10C_2", ofacAmenuID)
			local AmID_A10CBAI = missionCommands.addSubMenuForGroup(lGid, "w/IR Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", AmID_A10C)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_A10CBAI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "A-10C_2", i, lSkill, lAAlt, lDir, "ACM_IR", glbBVRDist)
			end
			local AmID_A10CAI = missionCommands.addSubMenuForGroup(lGid, "w/IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_A10C)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_A10CAI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "A-10C_2", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local AmID_A10CA = missionCommands.addSubMenuForGroup(lGid, "No IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_A10C)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_A10CA, CallSpawnOpForACGroup, pUnitName, country.id.USA, "A-10C_2", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- AJS37 options
			local AmID_A37 = missionCommands.addSubMenuForGroup(lGid, "AJS37", ofacAmenuID)
			local AmID_A37BAI = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR AA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", AmID_A37)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_A37BAI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "AJS37", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbBVRDist)
			end
			local AmID_A37BRAI = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR RA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", AmID_A37)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_A37BRAI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "AJS37", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbBVRDist)
			end
			local AmID_A37AI = missionCommands.addSubMenuForGroup(lGid, "w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_A37)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_A37AI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "AJS37", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			local AmID_A37ARAI = missionCommands.addSubMenuForGroup(lGid, "w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_A37)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_A37ARAI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "AJS37", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			local AmID_A37A = missionCommands.addSubMenuForGroup(lGid, "No IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_A37)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_A37A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "AJS37", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- AV8BNA options
			local AmID_A8 = missionCommands.addSubMenuForGroup(lGid, "AV8BNA", ofacAmenuID)
			local AmID_A8BAI = missionCommands.addSubMenuForGroup(lGid, "w/IR Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", AmID_A8)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_A8BAI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "AV8BNA", i, lSkill, lAAlt, lDir, "ACM_IR", glbBVRDist)
			end
			local AmID_A8AI = missionCommands.addSubMenuForGroup(lGid, "w/IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_A8)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_A8AI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "AV8BNA", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local AmID_A8A = missionCommands.addSubMenuForGroup(lGid, "No IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_A8)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_A8A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "AV8BNA", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- Tornado GR4 options
			local AmID_ATG = missionCommands.addSubMenuForGroup(lGid, "Tornado GR4", ofacAmenuID)
			local AmID_ATGBAI = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR AA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", AmID_ATG)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_ATGBAI, CallSpawnOpForACGroup, pUnitName, country.id.UK, "Tornado GR4", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbBVRDist)
			end
			local AmID_ATGBARAI = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR RA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", AmID_ATG)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_ATGBARAI, CallSpawnOpForACGroup, pUnitName, country.id.UK, "Tornado GR4", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbBVRDist)
			end
			local AmID_ATGAI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_ATG)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_ATGAI, CallSpawnOpForACGroup, pUnitName, country.id.UK, "Tornado GR4", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			local AmID_ATGARAI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_ATG)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_ATGARAI, CallSpawnOpForACGroup, pUnitName, country.id.UK, "Tornado GR4", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			local AmID_ATGA = missionCommands.addSubMenuForGroup(lGid, "ACM No IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", AmID_ATG)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", AmID_ATGA, CallSpawnOpForACGroup, pUnitName, country.id.UK, "Tornado GR4", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end

			-- AI bomber options

			-- B-1B options
			local BmID_B1 = missionCommands.addSubMenuForGroup(lGid, "B-1B", ofacBmenuID)
			local BmID_B1BBA = missionCommands.addSubMenuForGroup(lGid, "Intercept (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", BmID_B1)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", BmID_B1BBA, CallSpawnOpForACGroup, pUnitName, country.id.USA, "B-1B", i, lSkill, lAAlt, lDir, "ACM", glbBVRDist)
			end
			local BmID_B1BA = missionCommands.addSubMenuForGroup(lGid, "Intercept (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", BmID_B1)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", BmID_B1BA, CallSpawnOpForACGroup, pUnitName, country.id.USA, "B-1B", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end

			-- B-52H options
			local BmID_B52 = missionCommands.addSubMenuForGroup(lGid, "B-52H", ofacBmenuID)
			local BmID_B52BA = missionCommands.addSubMenuForGroup(lGid, "Intercept (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", BmID_B52)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", BmID_B52BA, CallSpawnOpForACGroup, pUnitName, country.id.USA, "B-52H", i, lSkill, lAAlt, lDir, "ACM", glbBVRDist)
			end
			local BmID_B52A = missionCommands.addSubMenuForGroup(lGid, "Intercept (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", BmID_B52)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", BmID_B52A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "B-52H", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- AI trainer options
			
			-- C-101CC options
			local TmID_C101 = missionCommands.addSubMenuForGroup(lGid, "C-101CC", ofacTmenuID)
			local TmID_C101B = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR AA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", TmID_C101)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", TmID_C101B, CallSpawnOpForACGroup, pUnitName, country.id.USA, "C-101CC", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbBVRDist)
			end
			local TmID_C101AIA = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", TmID_C101)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", TmID_C101AIA, CallSpawnOpForACGroup, pUnitName, country.id.USA, "C-101CC", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			local TmID_C101AIR = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", TmID_C101)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", TmID_C101AIR, CallSpawnOpForACGroup, pUnitName, country.id.USA, "C-101CC", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			local TmID_C101A = missionCommands.addSubMenuForGroup(lGid, "ACM No IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", TmID_C101)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", TmID_C101A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "C-101CC", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- Hawk options
			local TmID_Hawk = missionCommands.addSubMenuForGroup(lGid, "Hawk", ofacTmenuID)
			local TmID_HawkB = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR AA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", TmID_Hawk)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", TmID_HawkB, CallSpawnOpForACGroup, pUnitName, country.id.USA, "Hawk", i, lSkill, lAAlt, lDir, "ACM_IR", glbBVRDist)
			end
			local TmID_HawkAI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", TmID_Hawk)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", TmID_HawkAI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "Hawk", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local TmID_HawkA = missionCommands.addSubMenuForGroup(lGid, "ACM No IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", TmID_Hawk)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", TmID_HawkA, CallSpawnOpForACGroup, pUnitName, country.id.USA, "Hawk", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- L-39ZA options
			local ofacTmID_L39 = missionCommands.addSubMenuForGroup(lGid, "L-39ZA", ofacTmenuID)
			local ofacTmID_L39B = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR AA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacTmID_L39)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacTmID_L39B, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_BLUE, "L-39ZA", i, lSkill, lAAlt, lDir, "BVR", glbBVRDist)
			end
			local ofacTmID_L39AIA = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacTmID_L39)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacTmID_L39AIA, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_BLUE, "L-39ZA", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			local ofacTmID_L39AIR = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacTmID_L39)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacTmID_L39AIR, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_BLUE, "L-39ZA", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			local ofacTmID_L39A = missionCommands.addSubMenuForGroup(lGid, "ACM No IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacTmID_L39)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacTmID_L39A, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_BLUE, "L-39ZA", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- AI helicopter options

			-- AH-1W options
			local HmID_A1 = missionCommands.addSubMenuForGroup(lGid, "AH-1W", ofacHmenuID)
			local HmID_A1A = missionCommands.addSubMenuForGroup(lGid, "AGM, No IR Missiles (" .. tostring(math.ceil(glbHeloDist/1.609344)) .. " mi)", HmID_A1)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", HmID_A1A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "AH-1W", i, lSkill, lAAlt, lDir, "ACM", glbHeloDist)
			end

			-- AH-64D_BLK_II options
			local HmID_A64 = missionCommands.addSubMenuForGroup(lGid, "AH-64D_BLK_II", ofacHmenuID)
			local HmID_A64A = missionCommands.addSubMenuForGroup(lGid, "AGM, No IR Missiles (" .. tostring(math.ceil(glbHeloDist/1.609344)) .. " mi)", HmID_A64)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", HmID_A64A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "AH-64D_BLK_II", i, lSkill, lAAlt, lDir, "ACM", glbHeloDist)
			end

			-- CH-47Fbl1 options
			local HmID_CH47 = missionCommands.addSubMenuForGroup(lGid, "CH-47Fbl1", ofacHmenuID)
			local HmID_CH47A = missionCommands.addSubMenuForGroup(lGid, "No IR Missiles (" .. tostring(math.ceil(glbHeloDist/1.609344)) .. " mi)", HmID_CH47)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", HmID_CH47A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "CH-47Fbl1", i, lSkill, lAAlt, lDir, "ACM", glbHeloDist)
			end
			
			-- OH58D options
			local HmID_OH58D = missionCommands.addSubMenuForGroup(lGid, "OH58D", ofacHmenuID)
			local HmID_OH58DA = missionCommands.addSubMenuForGroup(lGid, "No IR Missiles (" .. tostring(math.ceil(glbHeloDist/1.609344)) .. " mi)", HmID_OH58D)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", HmID_OH58DA, CallSpawnOpForACGroup, pUnitName, country.id.USA, "OH58D", i, lSkill, lAAlt, lDir, "ACM", glbHeloDist)
			end

			local HmID_OH58DAI = missionCommands.addSubMenuForGroup(lGid, "w/IR Missiles (" .. tostring(math.ceil(glbHeloDist/1.609344)) .. " mi)", HmID_OH58D)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", HmID_OH58DAI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "OH58D", i, lSkill, lAAlt, lDir, "ACM_IR", glbHeloDist)
			end
			
			-- SA342L options
			local HmID_S342L = missionCommands.addSubMenuForGroup(lGid, "SA342L", ofacHmenuID)
			local HmID_S342LA = missionCommands.addSubMenuForGroup(lGid, "No IR Missiles (" .. tostring(math.ceil(glbHeloDist/1.609344)) .. " mi)", HmID_S342L)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", HmID_S342LA, CallSpawnOpForACGroup, pUnitName, country.id.USA, "SA342L", i, lSkill, lAAlt, lDir, "ACM", glbHeloDist)
			end

			local HmID_S342LAI = missionCommands.addSubMenuForGroup(lGid, "w/IR Missiles (" .. tostring(math.ceil(glbHeloDist/1.609344)) .. " mi)", HmID_S342L)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", HmID_S342LAI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "SA342L", i, lSkill, lAAlt, lDir, "ACM_IR", glbHeloDist)
			end

			-- UH-1H options
			local HmID_U1 = missionCommands.addSubMenuForGroup(lGid, "UH-1H", ofacHmenuID)
			local HmID_U1A = missionCommands.addSubMenuForGroup(lGid, "No IR Missiles (" .. tostring(math.ceil(glbHeloDist/1.609344)) .. " mi)", HmID_U1)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", HmID_U1A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "UH-1H", i, lSkill, lAAlt, lDir, "ACM", glbHeloDist)
			end

			-- UH-60A options
			local HmID_U60 = missionCommands.addSubMenuForGroup(lGid, "UH-60A", ofacHmenuID)
			local HmID_U60A = missionCommands.addSubMenuForGroup(lGid, "No IR Missiles (" .. tostring(math.ceil(glbHeloDist/1.609344)) .. " mi)", HmID_U60)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", HmID_U60A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "UH-60A", i, lSkill, lAAlt, lDir, "ACM", glbHeloDist)
			end

			-- AI Vietnam/70's era aircraft options
			
			-- F-4E options
			local ofacFmID_F4 = missionCommands.addSubMenuForGroup(lGid, "F-4E-45MC", ofacVFmenuID)
			local ofacFmID_F4B = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_F4)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F4B, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "BVR", glbBVRDist)
			end
			local ofacFmID_F4BRA = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR RA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_F4)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F4BRA, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbBVRDist)
			end
			local ofacFmID_F4AIA = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_F4)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F4AIA, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			local ofacFmID_F4AIR = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_F4)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F4AIR, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			local ofacFmID_F4A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_F4)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F4A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-4E-45MC", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- F-5E-3 options
			local ofacFmID_F5 = missionCommands.addSubMenuForGroup(lGid, "F-5E-3", ofacVFmenuID)
			local ofacFmID_F5B = missionCommands.addSubMenuForGroup(lGid, "BVR/ACM w/IR AA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_F5)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F5B, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-5E-3", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbBVRDist)
			end
			local ofacFmID_F5BRA = missionCommands.addSubMenuForGroup(lGid, "BVR/ACM w/IR RA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacFmID_F5)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F5BRA, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-5E-3", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbBVRDist)
			end
			local ofacFmID_F5AI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_F5)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F5AI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-5E-3", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			local ofacFmID_F5AI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_F5)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F5AI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-5E-3", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			local ofacFmID_F5A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacFmID_F5)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacFmID_F5A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-5E-3", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- F-14A-135-GR options
			local ofacBFmID_F14 = missionCommands.addSubMenuForGroup(lGid, "F-14A-135-GR", ofacVFmenuID)
			local ofacBFmID_F14BLR = missionCommands.addSubMenuForGroup(lGid, "BVR w/ARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacBFmID_F14)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacBFmID_F14BLR, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-14A-135-GR", i, lSkill, lAAlt, lDir, "BVR_LR", glbBVRDist)
			end
			local ofacBFmID_F14BMR = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacBFmID_F14)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacBFmID_F14BMR, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-14A-135-GR", i, lSkill, lAAlt, lDir, "BVR_MR", glbBVRDist)
			end
			local ofacBFmID_F14AI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacBFmID_F14)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacBFmID_F14AI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-14A-135-GR", i, lSkill, lAAlt, lDir, "ACM_IR", glbACMDist)
			end
			local ofacBFmID_F14A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacBFmID_F14)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacBFmID_F14A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-14A-135-GR", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			-- Mirage-F1CE options
			local ofacBFmID_F1 = missionCommands.addSubMenuForGroup(lGid, "Mirage-F1CE", ofacVFmenuID)
			local ofacBFmID_F1B = missionCommands.addSubMenuForGroup(lGid, "BVR w/SARH Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacBFmID_F1)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacBFmID_F1B, CallSpawnOpForACGroup, pUnitName, country.id.FRANCE, "Mirage-F1CE", i, lSkill, lAAlt, lDir, "BVR", glbBVRDist)
			end
			local ofacBFmID_F1BRA = missionCommands.addSubMenuForGroup(lGid, "BVR w/IR RA Missiles (" .. tostring(math.ceil(glbBVRDist/1.609344)) .. " mi)", ofacBFmID_F1)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacBFmID_F1BRA, CallSpawnOpForACGroup, pUnitName, country.id.FRANCE, "Mirage-F1CE", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbBVRDist)
			end
			local ofacBFmID_F1AIA = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR AA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacBFmID_F1)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacBFmID_F1AIA, CallSpawnOpForACGroup, pUnitName, country.id.FRANCE, "Mirage-F1CE", i, lSkill, lAAlt, lDir, "ACM_IR_AA", glbACMDist)
			end
			local ofacBFmID_F1AIR = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacBFmID_F1)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacBFmID_F1AIR, CallSpawnOpForACGroup, pUnitName, country.id.FRANCE, "Mirage-F1CE", i, lSkill, lAAlt, lDir, "ACM_IR_RA", glbACMDist)
			end
			local ofacBFmID_F1A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbACMDist/1.609344)) .. " mi)", ofacBFmID_F1)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacBFmID_F1A, CallSpawnOpForACGroup, pUnitName, country.id.FRANCE, "Mirage-F1CE", i, lSkill, lAAlt, lDir, "ACM", glbACMDist)
			end
			
			
			-- AI WWII and Korea era aircraft options

			-- A-20G options
			local ofacWFmID_A20 = missionCommands.addSubMenuForGroup(lGid, "A-20G", ofacWFmenuID)
			local ofacWFmID_A20A = missionCommands.addSubMenuForGroup(lGid, "Intercept (" .. tostring(math.ceil(glbWW2Dist/1.609344)) .. " mi)", ofacWFmID_A20)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacWFmID_A20A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "A-20G", i, lSkill, lAAlt, lDir, "ACM", glbWW2Dist)
			end

			-- F-86F Sabre options
			local ofacWFmID_F86 = missionCommands.addSubMenuForGroup(lGid, "F-86F Sabre", ofacWFmenuID)
			local ofacWFmID_F86AI = missionCommands.addSubMenuForGroup(lGid, "ACM w/IR RA Missiles (" .. tostring(math.ceil(glbWW2Dist/1.609344)) .. " mi)", ofacWFmID_F86)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacWFmID_F86AI, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-86F Sabre", i, lSkill, lAAlt, lDir, "ACM_IR", glbWW2Dist)
			end
			local ofacWFmID_F86A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbWW2Dist/1.609344)) .. " mi)", ofacWFmID_F86)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacWFmID_F86A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "F-86F Sabre", i, lSkill, lAAlt, lDir, "ACM", glbWW2Dist)
			end

			-- I-16 options
			local ofacWFmID_I16 = missionCommands.addSubMenuForGroup(lGid, "I-16", ofacWFmenuID)
			local ofacWFmID_I16A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbWW2Dist/1.609344)) .. " mi)", ofacWFmID_I16)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacWFmID_I16A, CallSpawnOpForACGroup, pUnitName, country.id.CJTF_BLUE, "I-16", i, lSkill, lAAlt, lDir, "ACM", glbWW2Dist)
			end

			-- MosquitoFBMkVI options
			local ofacWFmID_Mosq = missionCommands.addSubMenuForGroup(lGid, "MosquitoFBMkVI", ofacWFmenuID)
			local ofacWFmID_MosqA = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbWW2Dist/1.609344)) .. " mi)", ofacWFmID_Mosq)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacWFmID_MosqA, CallSpawnOpForACGroup, pUnitName, country.id.UK, "MosquitoFBMkVI", i, lSkill, lAAlt, lDir, "ACM", glbWW2Dist)
			end

			-- P-47D-40 options
			local ofacWFmID_P47 = missionCommands.addSubMenuForGroup(lGid, "P-47D-40", ofacWFmenuID)
			local ofacWFmID_P47A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbWW2Dist/1.609344)) .. " mi)", ofacWFmID_P47)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacWFmID_P47A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "P-47D-40", i, lSkill, lAAlt, lDir, "ACM", glbWW2Dist)
			end

			-- P-51D-30-NA options
			local ofacWFmID_P51 = missionCommands.addSubMenuForGroup(lGid, "P-51D-30-NA", ofacWFmenuID)
			local ofacWFmID_P51A = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbWW2Dist/1.609344)) .. " mi)", ofacWFmID_P51)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacWFmID_P51A, CallSpawnOpForACGroup, pUnitName, country.id.USA, "P-51D-30-NA", i, lSkill, lAAlt, lDir, "ACM", glbWW2Dist)
			end

			-- SpitfireLFMkIX options
			local ofacWFmID_Spit = missionCommands.addSubMenuForGroup(lGid, "SpitfireLFMkIX", ofacWFmenuID)
			local ofacWFmID_SpitA = missionCommands.addSubMenuForGroup(lGid, "ACM (" .. tostring(math.ceil(glbWW2Dist/1.609344)) .. " mi)", ofacWFmID_Spit)
			for i=1, #tblOneToFour do
				missionCommands.addCommandForGroup(lGid, tblOneToFour[i] .. " aircraft", ofacWFmID_SpitA, CallSpawnOpForACGroup, pUnitName, country.id.UK, "SpitfireLFMkIX", i, lSkill, lAAlt, lDir, "ACM", glbWW2Dist)
			end
			
			
			
		end
		end
	end
	
end

--[[
############################################################################################
Function:	BuildClientUnitListOpFor
Purpose:	Build a table of client unit IDs with mapped group ID, unit type, unit name
			group name and coalition
Parameters:	None
Returns:	nothing
Author:		AKA_Relent
DCS ver:	1.5.4
############################################################################################
]]
function BuildClientUnitListOpFor()

	for coal_key, coal_data in pairs (env.mission.coalition) do
		if (((coal_key == "blue") or (coal_key == "red")) and type(coal_data) == "table") then
			if (coal_data.country) then --there is a country table
				for cntry_id, cntry_data in pairs(coal_data.country) do
					for obj_type_name, obj_type_data in pairs(cntry_data) do
						if ((type(obj_type_data) == "table") and obj_type_data.group and (type(obj_type_data.group) == "table") and
								(#obj_type_data.group > 0)) then  --there's a group!
							for group_num, group_data in pairs(obj_type_data.group) do
								for unit_num, unit_data in pairs(group_data.units) do
									if (unit_data.skill == "Client" or unit_data.skill == "Player") then
										table.insert(tblClientUnit, {uID = unit_data.unitId, gID = group_data.groupId,
											uTyp = unit_data.type, uNam = unit_data.name, gNam = group_data.name, coal = coal_key,
											uSkl = unit_data.skill, optSkl = glbDefSkill, optCurSkl = glbDefSkill,
											optAAlt = glbDefAAlt, optCurAAlt = glbDefAAlt})
										if (debugFlgOpFor == 2) then
											trigger.action.outText("BuildClientUnitListOpFor: uID = " .. unit_data.unitId .. ", gID = " .. 	group_data.groupId .. ", uTyp = " .. unit_data.type .. ", uNam = " .. unit_data.name .. ", gNam =  " .. group_data.name .. ", coal = " .. coal_key ..
											", uSkl = " .. unit_data.skill .. ", optSkl = " .. glbDefSkill .. ", optCurSkl = " .. glbDefSkill, 30)
										end
									end
								end
							end
						end
					end
				end
			end
		end
	end
end

do
	BuildClientUnitListOpFor()
end

--[[
############################################################################################
Function:	BuildExclZoneListOpFor
Purpose:	Build a table of exclusion zones where OpFor aircraft cannot spawn
Parameters:	None
Returns:	nothing
Author:		AKA_Relent
DCS ver:	1.5.4
############################################################################################
]]
function BuildExclZoneListOpFor()
	for i=1, #env.mission.triggers.zones do
		if (env.mission.triggers.zones[i].type == 0 and (string.find(env.mission.triggers.zones[i].name, "Exclusion Zone") or
				string.find(env.mission.triggers.zones[i].name, "exclusion zone"))) then
			table.insert(tblExclZoneList, {name=env.mission.triggers.zones[i].name})
		end
	end
	
end

do
	BuildExclZoneListOpFor()
end

--[[
############################################################################################
Function:	CalcCurrentPointOpFor
Purpose:	calculate the position (point) and heading of unit
Parameters:	pUnitName - unit name
Returns:	point (table), heading (in radians)
Author:		AKA_Relent
DCS ver:	1.5.4
############################################################################################
]]
function CalcCurrentPointOpFor(pUnitName)
	lUnit = Unit.getByName(pUnitName)
	if (lUnit == nil) then
		return
	end
	local point = {x=lUnit:getPoint().x, z=lUnit:getPoint().z, y=lUnit:getPoint().y}
	--local headingRad = math.rad(math.atan2(lUnit:getPosition().x.z, lUnit:getPosition().x.x)+2*math.pi)
	local headingRad = math.atan2(lUnit:getPosition().x.z, lUnit:getPosition().x.x)
	if (headingRad < 0) then
		headingRad = headingRad + 2*math.pi
	end
	
	if (debugFlgOpFor == 2) then
		trigger.action.outText("CalcCurrentPointOpFor: headingDeg: " .. math.deg(headingRad) .. ", headingRad: " .. headingRad .. ", point.x: " ..
			point.x .. ", point.z: " .. point.z .. ", point.y: " .. point.y, 30)
	end
	
	
return point, headingRad
end

--[[
############################################################################################
Function:	CalcNewRelativePointOpFor
Purpose:	Calculates a new point in 3D space that is the specified
			distance and heading from the passed-in point
Parameters:	pPoint - Vec3 table of x, y and z coordinates for the position
						(point) of an object in 3D space
			pHeadingRad - Heading of object with the passed-in point in radians
			pDistance - Requested distance from the passed-in point in meters
Returns:	Point (vec3 table) in 3D space that is the specified distance and heading
			from the passed-in point
Author:		AKA_Relent
DCS ver:	1.5.4
############################################################################################
]]
function CalcNewRelativePointOpFor(pPoint, pHeadingRad, pDistance)
	if (pPoint == nil or pHeadingRad == nil or pDistance == nil)  then
		return nil
	end
	
	local vec = {
		x = pDistance * math.cos(pHeadingRad),
		z = pDistance * math.sin(pHeadingRad),
	}
	
	if (debugFlgOpFor == 2) then
		trigger.action.outText("CalcNewRelativePointOpFor: headingDeg: " .. math.deg(pHeadingRad) .. ", headingRad: " .. pHeadingRad .. ", pPoint.x: " ..
			pPoint.x .. ", pPoint.z: " .. pPoint.z .. ", pPoint.y: " .. pPoint.y .. ", pDistance: " .. pDistance, 30)
	end

	return { x = pPoint.x + vec.x , z = pPoint.z + vec.z , y = pPoint.y }
end

--[[
############################################################################################
Function:	CallSpawnOpForACGroup
Purpose:	Call SpawnOpForACGroup function, adding vector, heading and speed at waypoints
Parameters:	pUnitName - Unit name initiating the spawning of units
			pCountry - Country ID of group to be spawned (country.id enum)
			pType - Unit type
			pNum - Number of units
			pSkill - Skill of unit(s)
			pAlt - Altitude of unit(s)
			pDir - Direction of unit(s)
			pEngScen - Engagement scenario
			pDistance - Distance from unit spawn initiates, in kilometers
Returns:	Group object
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]
function CallSpawnOpForACGroup(pUnitName, pCountry, pType, pNum, pSkill, pAlt, pDir, pEngScen, pDistance)

	if (pUnitName == nil or pCountry == nil or pType == nil or pNum == nil or pSkill == nil or 
		pAlt == nil or pDir == nil or pEngScen == nil or pDistance == nil) then
		return
	end
	
	trigger.action.outText("Spawning " .. pNum .. " " .. pSkill .. " ".. pType, 10)
	
	local currPoint, headingRad = CalcCurrentPointOpFor(pUnitName)
	local headingDeg = math.deg(headingRad)
	local newHeadingRad
	local newHeadingDeg
	
	local relativeDeg = 180
	
	if (pDir == "12oc") then
		relativeDeg = 180
	elseif (pDir == "9to3oc") then
		relativeDeg = math.random(90, 270)
	elseif (pDir == "Random") then
		relativeDeg = math.random(1,360)
	end
	
	if (headingDeg >= 180 and headingDeg <= 360) then
		newHeadingDeg = headingDeg - relativeDeg
	elseif (headingDeg >= 0 and headingDeg < 180) then
		newHeadingDeg = headingDeg + relativeDeg
	end
	newHeadingRad = math.rad(newHeadingDeg)
	
	if (newHeadingDeg >= 180 and newHeadingDeg <= 360) then
		headingRad = math.rad(newHeadingDeg - 180)
	elseif (newHeadingDeg >=0 and newHeadingDeg < 180) then
		headingRad = math.rad(newHeadingDeg + 180)
	end

	if (debugFlgOpFor == 2) then
		trigger.action.outText("CallSpawnOpForACGroup: Initiator aircraft: headingDeg: " .. headingDeg .. ", headingRad: " .. headingRad .. ", AI newHeadingDeg: " .. newHeadingDeg .. ", newHeadingRad: " .. newHeadingRad .. ", pDistance: " .. pDistance .. ", pType: " .. pType, 30)
	end
	
	local distMeters = pDistance * 1000
	
	local wp1Point = CalcNewRelativePointOpFor(currPoint, headingRad, distMeters)
	local wp2Point = CalcNewRelativePointOpFor(currPoint, headingRad, 1)
	
	local wp1Alt = wp1Point.y
	local wp1ASL = land.getHeight({x=wp1Point.x, y=wp1Point.z})
	
	local wp2Alt = wp2Point.y
	local wp2ASL = land.getHeight({x=wp2Point.x, y=wp2Point.z})
	
	local lSpeed = glbACSpeed

	for i=1, #tblFuFlChLiPresets do 
		if (tblFuFlChLiPresets[i].ut == pType and tblFuFlChLiPresets[i].co == pCountry) then
			unitCategory = tblFuFlChLiPresets[i].cat
			break
		end
	end
	
	local lAAlt = glbMedAlt
	if (pAlt == "Low") then
		lAAlt = glbLowAlt
	elseif (pAlt == "Medium") then
		lAAlt = glbMedAlt
	elseif (pAlt == "High") then
		lAAlt = glbHiAlt
	else -- pAlt = "Random"
		lAAlt = math.floor((math.random(tonumber(glbLowAlt), tonumber(glbHiAlt))) + 0.5)
		if (debugFlgOpFor == 2) then
			trigger.action.outText("CallSpawnOpForACGroup: lAAlt: " .. lAAlt, 20)
		end

	end
	
	-- Set speed (mph) and spawn altitude (meters) depending on spawned aircraft type
	if (unitCategory == Group.Category.HELICOPTER) then
		lSpeed = glbHeloSpeed
		wp1Point.y = wp1ASL + glbHeloAlt
		wp2Point.y = wp2ASL + glbHeloAlt
	else -- Aircraft
		lSpeed = glbACSpeed
		wp1Point.y = wp1ASL + lAAlt
		wp2Point.y = wp2ASL + lAAlt
	end
	
	if (debugFlgOpFor == 2) then
		trigger.action.outText("CallSpawnOpForACGroup: pUnitName: " .. pUnitName .. ", pCountry: " .. pCountry .. ", pType: " ..
			pType .. ", pNum: " .. pNum .. ", pSkill: " .. pSkill .. ", pEngScen: " .. pEngScen .. ", newHeadingDeg: " ..
			math.deg(newHeadingRad) .. ", speed: " .. lSpeed, 30)
	end

	local pointInZone = false
	for i=1, #tblExclZoneList do
		if (IsPointInZoneOpFor(wp1Point, tblExclZoneList[i].name) or IsPointInZoneOpFor(wp2Point, tblExclZoneList[i].name)) then
			pointInZone = true
			break
		end
	end
	
	if (pointInZone == true) then
		trigger.action.outText("Can NOT spawn " .. pNum .. " " .. pSkill .. " ".. pType .. ", move OpFor aircraft spawn and destination points away from exclusion zone", 10)
		return
	else		
		return SpawnOpForACGroup(pUnitName, pCountry, pType, pNum, pSkill, pEngScen, newHeadingRad, wp1Point, wp2Point, lSpeed)
	end
end

--[[
############################################################################################
Function:	CheckForSinglePlayerOpFor
Purpose:	Checks the tblClientUnit table for a unit skill of "Player";  If a single player
			mission, there will be one "Player" skilled unit;  If a multi player mission,
			there would be one or more "Client" skilled units, no "Player" skilled units.
			If a "Player" skilled aircraft exists, and no "Client" skilled aircraft exist,
			call the AddRadioCommandsOpFor function
Parameters:	none
Returns:	nothing
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]
function CheckForSinglePlayerOpFor()

	local numClient = 0
	local numPlayer = 0
	local unitName = ""
	for key, data in pairs (tblClientUnit) do
		if (data.uSkl == "Player") then
			unitName = data.uNam
			numPlayer = numPlayer + 1
		elseif (data.uSkl == "Client") then
			numClient = numClient + 1
		end
	end
	if (debugFlgOpFor == 2) then
		trigger.action.outText("CheckForSinglePlayerOpFor: numPlayer: " .. numPlayer .. ", numClient: " .. numClient, 20)
	end	
	if ((numPlayer == 1) and (numClient == 0)) then
		glbFlgSPOpFor = 1
		table.insert(tblPlayerList, {pName = "Player", optSkl = glbDefSkill, optCurSkl = glbDefSkill,
			optAAlt = glbDefAAlt, optCurAAlt = glbDefAAlt, optDir = glbDefDir, optCurDir = glbDefDir, rMenuID = nil})
		AddRadioCommandsOpFor(unitName, "Player", "true")
		if (debugFlgOpFor == 2) then
			trigger.action.outText("CheckForSinglePlayerOpFor: called AddRadioCommandsOpFor", 20)
		end	
	end
end

--[[
############################################################################################
Function:	EngagementScenarioLoadOutPresetOpFor
Purpose:	Returns load-out pre-sets for each aircraft engagement scenario from 
			tblLoadoutPresets table
Parameters:	unitType - Unit (aircraft) type
			unitScenario - Type of engagement scenario for this OpFor aircraft
Returns:	Pylons table for given unit type and unit scenario
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]
function EngagementScenarioLoadOutPresetOpFor(punitType, punitScenario)
	for i=1, #tblLoadoutPresets do
		if (tblLoadoutPresets[i].ut == punitType and tblLoadoutPresets[i].us == punitScenario) then
			if (debugFlgOpFor == 2) then
				trigger.action.outText("Found preset loadout for: " .. punitType .. ", " .. punitScenario, 10)	
			end
			return tblLoadoutPresets[i].lp
		end
	end
	return {}
end

--[[
############################################################################################
Function:	GetCoalitionbyUnitIDOpFor
Purpose:	Return the coalition of the Unit with the unit ID passed in.  Used for groups
			that contain a unit with a skill of Client, parsing a table of unit IDs
			with mapped group IDs and coalitions
Parameters:	pUnitID - Unit ID
Returns:	coalition enum value
Author:		AKA_Relent
DCS ver:	1.5.4
############################################################################################
]]
function GetCoalitionbyUnitIDOpFor(pUnitID)
	if (pUnitID == "" or pUnitID == nil) then
		return nil
	end
	for key, data in pairs (tblClientUnit) do
		if (tonumber(data.uID) == tonumber(pUnitID)) then
			if (debugFlgOpFor == 3) then
				trigger.action.outText("GetCoalitionbyUnitIDOpFor: UnitID: " .. data.uID .. ", coalition: " .. data.coal, 30)
			end
			if (data.coal == "blue") then
				return coalition.side.BLUE
			elseif (data.coal == "red") then
				return coalition.side.RED
			elseif (data.coal == "neutral") then
				return coalition.side.NEUTRAL
			else
				return nil
			end
		end
	end
end

--[[
############################################################################################
Function:	GetGroupIDbyUnitIDOpFor
Purpose:	Return the group ID based on the unit ID passed in.  Used for groups
			that contain a unit with a skill of Client, parsing a table of unit IDs
			with mapped group IDs and coalitions
Parameters:	pUnitID - Unit ID
Returns:	nothing
Author:		AKA_Relent
DCS ver:	1.5.4
############################################################################################
]]
function GetGroupIDbyUnitIDOpFor(pUnitID)
	if (debugFlgOpFor == 2) then
		trigger.action.outText("GetGroupIDbyUnitIDOpFor: pUnitID=" .. pUnitID, 20)
	end
	if (pUnitID == nil) then
		return nil
	end
	for key, data in pairs (tblClientUnit) do
		if (debugFlgOpFor == 2) then
			trigger.action.outText("GetGroupIDbyUnitIDOpFor: data.uID=" .. data.uID .. ", pUnitID=" .. pUnitID, 20)
		end
		if (tonumber(data.uID) == tonumber(pUnitID)) then
			if (debugFlgOpFor == 2) then
				trigger.action.outText("GetGroupIDbyUnitIDOpFor: found it - groupID=" .. data.gID, 20)
			end
			return data.gID
		end
	end
end

--[[
############################################################################################
Function:	HandlePlayerEnterExitUnitOpFor
Purpose:	Calls AddRadioCommandsOpFor and RemoveRadioCommandsOpFor based on
			a player entering and exiting a unit
Parameters:	event
Returns:	nothing
Author:		AKA_Relent
DCS ver:	1.5.4
############################################################################################
]]
HandlePlayerEnterExitUnitOpFor = {}
function HandlePlayerEnterExitUnitOpFor:onEvent(event)
    local _status, _err = pcall(function(_args)
		-- Display all events for the initiator
		--if (debugFlgOpFor == 99) then
			-- local m = {}
			-- m[#m+1] = "Event ID: "
			-- m[#m+1] = event.id
			-- if event.initiator then
				-- m[#m+1] "\nInitiator : "
				-- m[#m+1] = event.initiator:getName()
			-- end
			-- trigger.action.outText("HandlePlayerEnterExitUnitOpFor: " .. table.concat(m),5)
		--end

		if (event.id == world.event.S_EVENT_BIRTH and event.initiator ~= nil) then
			local enterUnit = event.initiator
			if (enterUnit ~= nil) then
				local unitName = enterUnit:getName()
				if (unitName ~= nil) then
					if (Unit.getByName(unitName):getPlayerName()) then
						local playerName = enterUnit:getPlayerName()
						if (debugFlgOpFor == 3) then
							trigger.action.outText(playerName .. "/" .. unitName .. " entered " .. enterUnit:getTypeName(),30)
						end
						-- Check if player name is already in tblPlayerList table
						local lFoundPlayer = 0
						for key, data in pairs (tblPlayerList) do
							if (data.pName == playerName) then
								lFoundPlayer = 1
								if (debugFlgOpFor == 3) then
									trigger.action.outText("HandlePlayerEnterExitUnitOpFor: lFoundPlayer: " .. lFoundPlayer, 30)
								end
								break
							end
						end
						-- Add player name to tblPlayerList table if not already in the table
						if (lFoundPlayer == 0) then
							table.insert(tblPlayerList, {pName = playerName, optSkl = glbDefSkill, optCurSkl = glbDefSkill,
								optAAlt = glbDefAAlt, optCurAAlt = glbDefAAlt, optDir = glbDefDir, optCurDir = glbDefDir, rMenuID = nil})
							if (debugFlgOpFor == 3) then
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: " .. playerName .. " added to tblPlayerList", 30)
								for i=1, #tblPlayerList do
									trigger.action.outText("tblPlayerList[" .. i .. "].pName = " .. tblPlayerList[i].pName, 30)
								end
							end	
						end
						-- Check if client unit is already in tblClientUnit table
						local lFoundUnit = 0
						for key, data in pairs (tblClientUnit) do
							if (debugFlgOpFor == 2) then
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: data.uID: " .. data.uID .. " vs enterUnit:getID(): " .. enterUnit:getID(), 30)
							end
							if (tonumber(data.uID) == tonumber(enterUnit:getID())) then
								lFoundUnit = 1
								if (debugFlgOpFor == 3) then
									trigger.action.outText("HandlePlayerEnterExitUnitOpFor: lFoundUnit: " .. lFoundUnit, 30)
								end
								break
							end
						end
						-- Add client unit to tblClientUnit table if not already in the table (i.e. for dynamic spawn slots)
						if (lFoundUnit == 0) then
							if (debugFlgOpFor == 3) then
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: lFoundUnit: " .. lFoundUnit, 30)
							end
							local lUnitID = enterUnit:getID()
							local lCoal = "neutral" 
							if (debugFlgOpFor == 3) then
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: coalition number: " .. enterUnit:getCoalition(), 30)
							end
							if (enterUnit:getCoalition() == coalition.side.BLUE) then
								lCoal = "blue"
							elseif (enterUnit:getCoalition() == coalition.side.RED) then
								lCoal = "red"
							end
							if (debugFlgOpFor == 3) then
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: Adding uID " .. lUnitID .. " to tblClientUnit", 30)
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: uTyp=" .. enterUnit:getTypeName(), 30)
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: uNam=" .. enterUnit:getName(), 30)
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: gID=" .. enterUnit:getGroup():getID(), 30)
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: gNam=" .. enterUnit:getGroup():getName(), 30)
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: coal=" .. lCoal, 30)
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: uSkl= Client", 30)
							end
							table.insert(tblClientUnit, {uID = lUnitID, gID = enterUnit:getGroup():getID(),
										uTyp = enterUnit:getTypeName(), uNam = enterUnit:getName(), gNam = enterUnit:getGroup():getName(), 
										coal = lCoal, uSkl = "Client", optSkl = glbDefSkill, optCurSkl = glbDefSkill,
										optAAlt = glbDefAAlt, optCurAAlt = glbDefAAlt})
							if (debugFlgOpFor == 3) then
								trigger.action.outText("HandlePlayerEnterExitUnitOpFor: " .. lUnitID .. " added to tblClientUnit; table contents:", 30)
								for i=1, #tblClientUnit do
									trigger.action.outText("tblClientUnit[" .. i .. "].uID = " .. tblClientUnit[i].uID, 30)
								end
							end	
						end
						-- add slight delay for multiplayer timing
						for i = 1, 333333333 do --[[ do nothing ]] end
						-- Have to clean up radio commands prior to entering a unit
						for i=1, #tblPlayerList do
							if (tblPlayerList[i].pName == playerName and tblPlayerList[i].rMenuID ~= nil) then
								RemoveRadioCommandsOpFor(unitName, tblPlayerList[i].rMenuID)
								if (debugFlgOpFor == 3) then
									trigger.action.outText("HandlePlayerEnterExitUnitOpFor: called 1st RemoveRadioCommandsOpFor", 30)
								end
								break
							end
						end
						if (debugFlgOpFor == 3) then
							trigger.action.outText("HandlePlayerEnterExitUnitOpFor: CALLING AddRadioCommandsOpFor", 30)
						end	
						AddRadioCommandsOpFor(unitName, playerName, "true")
						if (debugFlgOpFor == 3) then
							trigger.action.outText("HandlePlayerEnterExitUnitOpFor: called AddRadioCommandsOpFor", 30)
						end	
					end
				end
			end
		elseif ((event.id == world.event.S_EVENT_EJECTION and event.initiator ~= nil) or
				(event.id == world.event.S_EVENT_PILOT_DEAD and event.initiator ~= nil) or
				(event.id == world.event.S_EVENT_CRASH and event.initiator ~= nil) or
				(event.id == world.event.S_EVENT_DEAD and event.initiator ~= nil)) then
			local leftUnit = event.initiator
			if (leftUnit ~= nil) then
				local lUnitName = leftUnit:getName()
				if (lUnitName ~= nil) then
					if (Unit.getByName(lUnitName):getPlayerName()) then
						local playerName = leftUnit:getPlayerName() -- check if getPlayerName() is nil, throwing an error
						if (debugFlgOpFor == 3) then
							trigger.action.outText(lUnitName .. " left " .. leftUnit:getTypeName() .. " or ejected or died",30)
						end
						-- add slight delay for multiplayer timing
						for i = 1, 333333333 do --[[ do nothing ]] end
						-- Have to clean up radio commands after exiting a unit
						for i=1, #tblPlayerList do
							if (tblPlayerList[i].pName == playerName) then
								RemoveRadioCommandsOpFor(lUnitName, tblPlayerList[i].rMenuID)
								if (debugFlgOpFor == 3) then
									trigger.action.outText("HandlePlayerEnterExitUnitOpFor: called 2nd RemoveRadioCommandsOpFor", 30)
								end
								break
							end
						end
					end
				end
			end
		end
    end, _arguments)

    if (not _status) then
        env.error(string.format("OpForAC: HandlePlayerEnterExitUnitOpFor ERROR: %s", _err))
    end
end
local ehHPEEUId = world.addEventHandler(HandlePlayerEnterExitUnitOpFor)

--[[
############################################################################################
Function:	IsPointInZoneOpFor
Purpose:	Checks if point in the specified circular trigger zone
Parameters:	pPoint - Vec3 table of x, y and z coordinates for the position
						(point) of an object in 3D space
			pZone - trigger zone name
Returns:	boolean
Author:		AKA_Relent
DCS ver:	1.5.4
############################################################################################
]]
function IsPointInZoneOpFor(pPoint, pZone)
	if (pPoint == nil) then
		return false
	end
	
	local zone = trigger.misc.getZone(pZone)
	if (zone == nil) then
		return false
	end
	local xDiff = pPoint.x - zone.point.x
	local zDiff = pPoint.z - zone.point.z
	local distance = math.sqrt(xDiff * xDiff + zDiff * zDiff)
	
	if (distance <= zone.radius) then
		return true
	else
		return false
	end	
end

--[[
############################################################################################
Function:	RemoveRadioCommandsOpFor
Purpose:	Removes F10 radio menu items for the player unit with the passed-in unit name
Parameters:	pUnitName - Initiator unit name
			pPath - F10 sub-menu path
Returns:	nothing
Author:		AKA_Relent
DCS ver:	1.5.4
############################################################################################
]]
function RemoveRadioCommandsOpFor(pUnitName, pPath)
	local lUnit = Unit.getByName(pUnitName)
	if (lUnit == nil or pPath == nil) then
		return
	end
	local gid = GetGroupIDbyUnitIDOpFor(lUnit:getID())
	if (gid == nil) then
		return
	end
	if (debugFlgOpFor == 2) then
		trigger.action.outText("RemoveRadioCommandsOpFor: pUnitName: " .. pUnitName .. ", gid: " .. gid, 20)
	end
	missionCommands.removeItemForGroup(gid, pPath)
end

--[[
############################################################################################
Function:	SetAltOpFor
Purpose:	Set altitude string optAAlt in global table tblPlayerList to the passed in string 
			argument pAlt
Parameters:	pUid - Player unit id
			pUnitName - Player unit name
			pPlayerName - Player name
			pACType - Player aircraft type
			pAlt - AI unit altitude
Returns:	nothing
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]
function SetAltOpFor(pUid, pUnitName, pPlayerName, pACType, pAlt)
	if (debugFlgOpFor == 2) then
		trigger.action.outText("SetAltOpFor: pPlayerName: " .. pPlayerName .. ", pUid: " .. pUid .. ", pAlt: " .. pAlt, 20)
	end
	if (pAlt ~= "Random" and pAlt ~= "Low" and pAlt ~= "Medium" and 
			pAlt ~= "High" and pACType ~= "AC" and pACType ~= "Helo") then
		return
	end
	if (pACType == "AC") then
		for i=1, #tblPlayerList do
			if (debugFlgOpFor == 2) then
				trigger.action.outText("SetAltOpFor: #tblPlayerList = " .. #tblPlayerList, 20)
				trigger.action.outText("SetAltOpFor: tblPlayerList[" .. i .. "].pName = " .. tblPlayerList[i].pName, 20)
			end
			if (tblPlayerList[i].pName == pPlayerName) then
				tblPlayerList[i].optAAlt = pAlt
				tblPlayerList[i].optCurAAlt = pAlt
				if (debugFlgOpFor == 2) then
					trigger.action.outText("SetAltOpFor (found player): tblPlayerList[" .. i .. "].pName = " .. tblPlayerList[i].pName .. ", pUid: " .. pUid .. ", pAlt: " .. pAlt .. 
					", tblPlayerList[" .. i .. "].optAAlt: " .. tblPlayerList[i].optAAlt .. ", tblPlayerList[" .. i .. "].optCurAAlt: " .. tblPlayerList[i].optCurAAlt, 20)
				end
				RemoveRadioCommandsOpFor(pUnitName, tblPlayerList[i].rMenuID)
				if (debugFlgOpFor == 2) then
					trigger.action.outText("SetAltOpFor: called RemoveRadioCommandsOpFor", 20)
				end
				AddRadioCommandsOpFor(pUnitName, pPlayerName, "false")
				if (debugFlgOpFor == 2) then
					trigger.action.outText("SetAltOpFor: called AddRadioCommandsOpFor", 20)
				end	
				break
			end
		end
	elseif (pACType == "Helo") then
	-- No options for Helo's right now, keep at default alt glbHeloAlt
	end
end

--[[
############################################################################################
Function:	SetSkillOpFor
Purpose:	Set skill string optSkl in global table tblPlayerList to the passed in string 
			argument pSkill
Parameters:	pUid - Player unit id
			pUnitName - Player unit name
			pPlayerName - Player name
			pSkill - AI unit skill
Returns:	nothing
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]
function SetSkillOpFor(pUid, pUnitName, pPlayerName, pSkill)
	if (debugFlgOpFor == 2) then
		trigger.action.outText("SetSkillOpFor: pPlayerName: " .. pPlayerName .. ", pUid: " .. pUid .. ", pSkill: " .. pSkill, 20)
	end
	if (pSkill ~= "Random" and pSkill ~= "Rookie" and pSkill ~= "Trained" and 
			pSkill ~= "Veteran" and pSkill ~= "Ace") then
		return
	end
	for i=1, #tblPlayerList do
		if (debugFlgOpFor == 2) then
			trigger.action.outText("SetSkillOpFor: #tblPlayerList = " .. #tblPlayerList, 20)
			trigger.action.outText("SetSkillOpFor: tblPlayerList[" .. i .. "].pName = " .. tblPlayerList[i].pName, 20)
		end
		if (tblPlayerList[i].pName == pPlayerName) then
			tblPlayerList[i].optSkl = pSkill
			tblPlayerList[i].optCurSkl = pSkill
			if (debugFlgOpFor == 2) then
				trigger.action.outText("SetSkillOpFor (found player): tblPlayerList[" .. i .. "].pName = " .. tblPlayerList[i].pName .. ", pUid: " .. pUid .. ", pSkill: " .. pSkill .. 
				", tblPlayerList[" .. i .. "].optSkl: " .. tblPlayerList[i].optSkl .. ", tblPlayerList[" .. i .. "].optCurSkl: " .. tblPlayerList[i].optCurSkl, 20)
			end
			RemoveRadioCommandsOpFor(pUnitName, tblPlayerList[i].rMenuID)
			if (debugFlgOpFor == 2) then
				trigger.action.outText("SetSkillOpFor: called RemoveRadioCommandsOpFor", 20)
			end
			AddRadioCommandsOpFor(pUnitName, pPlayerName, "false")
			if (debugFlgOpFor == 2) then
				trigger.action.outText("SetSkillOpFor: called AddRadioCommandsOpFor", 20)
			end	
			break
		end
	end
end

--[[
############################################################################################
Function:	SetDirOpFor
Purpose:	Set direction string optDir in global table tblPlayerList to the passed in string 
			argument pDir
Parameters:	pUid - Player unit id
			pUnitName - Player unit name
			pPlayerName - Player name
			pDir - AI unit direction relative to player
Returns:	nothing
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]
function SetDirOpFor(pUid, pUnitName, pPlayerName, pDir)
	if (debugFlgOpFor == 2) then
		trigger.action.outText("SetDirOpFor: pPlayerName: " .. pPlayerName .. ", pUid: " .. pUid .. ", pDir: " .. pDir, 20)
	end
	if (pDir ~= "12oc" and pDir ~= "9to3oc" and pDir ~= "Random") then
		return
	end
	for i=1, #tblPlayerList do
		if (debugFlgOpFor == 2) then
			trigger.action.outText("SetDirOpFor: #tblPlayerList = " .. #tblPlayerList, 20)
			trigger.action.outText("SetDirOpFor: tblPlayerList[" .. i .. "].pName = " .. tblPlayerList[i].pName, 20)
		end
		if (tblPlayerList[i].pName == pPlayerName) then
			tblPlayerList[i].optDir = pDir
			tblPlayerList[i].optCurDir = pDir
			if (debugFlgOpFor == 2) then
				trigger.action.outText("SetDirOpFor (found player): tblPlayerList[" .. i .. "].pName = " .. tblPlayerList[i].pName .. ", pUid: " .. pUid .. ", pDir: " .. pDir .. 
				", tblPlayerList[" .. i .. "].optDir: " .. tblPlayerList[i].optDir .. ", tblPlayerList[" .. i .. "].optCurDir: " .. tblPlayerList[i].optCurDir, 20)
			end
			RemoveRadioCommandsOpFor(pUnitName, tblPlayerList[i].rMenuID)
			if (debugFlgOpFor == 2) then
				trigger.action.outText("SetDirOpFor: called RemoveRadioCommandsOpFor", 20)
			end
			AddRadioCommandsOpFor(pUnitName, pPlayerName, "false")
			if (debugFlgOpFor == 2) then
				trigger.action.outText("SetDirOpFor: called AddRadioCommandsOpFor", 20)
			end	
			break
		end
	end
end

--[[
############################################################################################
Function:	SetUpFuFlChLiPresets
Purpose:	Adds fuel, flare, chaff, livery pre-sets for each aircraft into a table
Parameters:	none
Returns:	nothing
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]

function SetUpFuFlChLiPresets()

	local unitType = ""
	local unitCountry
	local unitFuel
	local unitFlares
	local unitChaff
	local unitLivery = ""
	local unitCategory
	local unitCoalition = coalition.side.NEUTRAL
	
	--[[ Red fighters ]]
	
	unitType = "J-11A"
	unitCountry = country.id.CHINA
	unitFuel = 9400
	unitFlares = 96
	unitChaff = 96
	unitLivery = "PLAAF 19th AD"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "JF-17"
	unitCountry = country.id.CHINA
	unitFuel = 2325
	unitFlares = 32
	unitChaff = 36
	unitLivery = "PLAAF 125th AB (Fictional)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "M-2000C"
	unitCountry = country.id.CJTF_RED
	unitFuel = 3165
	unitFlares = 64
	unitChaff = 234
	unitLivery = "UAE Air Force"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "MiG-29A"
	unitCountry = country.id.RUSSIA
	unitFuel = 3376
	unitFlares = 30
	unitChaff = 30
	unitLivery = "Air Force Standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "MiG-29S"
	unitCountry = country.id.RUSSIA
	unitFuel = 3493
	unitFlares = 30
	unitChaff = 30
	unitLivery = "Air Force Standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "MiG-31"
	unitCountry = country.id.RUSSIA
	unitFuel = 15500
	unitFlares = 0
	unitChaff = 0
	unitLivery = "af standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Su-27"
	unitCountry = country.id.RUSSIA
	unitFuel = 9400
	unitFlares = 96
	unitChaff = 96
	unitLivery = "Air Force Standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "Su-30"
	unitCountry = country.id.RUSSIA
	unitFuel = 9400
	unitFlares = 96
	unitChaff = 96
	unitLivery = "af standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "Su-33"
	unitCountry = country.id.RUSSIA
	unitFuel = 9500
	unitFlares = 48
	unitChaff = 48
	unitLivery = "279th kiap 1st squad navy"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	--[[ Red attackers ]]
	
	unitType = "Su-25"
	unitCountry = country.id.RUSSIA
	unitFuel = 2835
	unitFlares = 128
	unitChaff = 128
	unitLivery = "field camo scheme #1 (native)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Su-25T"
	unitCountry = country.id.RUSSIA
	unitFuel = 3790
	unitFlares = 128
	unitChaff = 128
	unitLivery = "af standard 1"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Su-34"
	unitCountry = country.id.RUSSIA
	unitFuel = 9800
	unitFlares = 64
	unitChaff = 64
	unitLivery = "Russian Air Force"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	--[[ Red bombers ]]
	
	unitType = "H-6J"
	unitCountry = country.id.CHINA
	unitFuel = 25000
	unitFlares = 120
	unitChaff = 120
	unitLivery = "PLANAF Standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Su-24M"
	unitCountry = country.id.RUSSIA
	unitFuel = 11700
	unitFlares = 96
	unitChaff = 96
	unitLivery = "af standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Tu-22M3"
	unitCountry = country.id.RUSSIA
	unitFuel = 50000
	unitFlares = 48
	unitChaff = 48
	unitLivery = "af standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Tu-142"
	unitCountry = country.id.RUSSIA
	unitFuel = 87000
	unitFlares = 48
	unitChaff = 48
	unitLivery = "af standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	--[[ Red trainers ]]
	
	unitType = "C-101CC"
	unitCountry = country.id.CJTF_RED
	unitFuel = 1508
	unitFlares = 0
	unitChaff = 0
	unitLivery = "russia combat fictional"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Hawk"
	unitCountry = country.id.CJTF_RED
	unitFuel = 1272
	unitFlares = 0
	unitChaff = 0
	unitLivery = "1018 - united arab emirates"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "L-39ZA"
	unitCountry = country.id.RUSSIA
	unitFuel = 980
	unitFlares = 0
	unitChaff = 0
	unitLivery = "russian air force"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	--[[ Red helicopters ]]
	
	unitType = "Ka-50"
	unitCountry = country.id.RUSSIA
	unitFuel = 1450
	unitFlares = 128
	unitChaff = 0
	unitLivery = "Russia Standard Army"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Ka-50_3"
	unitCountry = country.id.RUSSIA
	unitFuel = 1450
	unitFlares = 128
	unitChaff = 0
	unitLivery = "default"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Mi-8MT"
	unitCountry = country.id.RUSSIA
	unitFuel = 1640
	unitFlares = 128
	unitChaff = 0
	unitLivery = "Russia_VVS_Standard"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Mi-24P"
	unitCountry = country.id.RUSSIA
	unitFuel = 1310
	unitFlares = 128
	unitChaff = 64
	unitLivery = "Russian Air Force"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "Mi-26"
	unitCountry = country.id.RUSSIA
	unitFuel = 9600
	unitFlares = 192
	unitChaff = 0
	unitLivery = "RF Air Force"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "Mi-28N"
	unitCountry = country.id.RUSSIA
	unitFuel = 1500
	unitFlares = 128
	unitChaff = 0
	unitLivery = "standard"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	--[[ Red Vietnam/70's era aircraft ]]

	unitType = "F-4E-45MC"
	unitCountry = country.id.CJTF_RED
	unitFuel = 5510.5
	unitFlares = 30
	unitChaff = 120
	unitLivery = "iriaf-3-6673"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "F-5E-3"
	unitCountry = country.id.CJTF_RED
	unitFuel = 2046
	unitFlares = 15
	unitChaff = 30
	unitLivery = "ir iriaf 43rd tfs"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "F-14A-135-GR"
	unitCountry = country.id.CJTF_RED
	unitFuel = 7348
	unitFlares = 60
	unitChaff = 140
	unitLivery = "rogue nation(top gun - maverick)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "MiG-19P"
	unitCountry = country.id.RUSSIA
	unitFuel = 1800
	unitFlares = 0
	unitChaff = 0
	unitLivery = "default"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "MiG-21Bis"
	unitCountry = country.id.RUSSIA
	unitFuel = 2280
	unitFlares = 40
	unitChaff = 18
	unitLivery = "VVS - 185th GvIAP"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "MiG-23MLD"
	unitCountry = country.id.RUSSIA
	unitFuel = 3800
	unitFlares = 60
	unitChaff = 60
	unitLivery = "af standard-2"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "MiG-27K"
	unitCountry = country.id.RUSSIA
	unitFuel = 4500
	unitFlares = 60
	unitChaff = 60
	unitLivery = "af standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Mirage-F1CE"
	unitCountry = country.id.CJTF_RED
	unitFuel = 3356
	unitFlares = 15
	unitChaff = 30
	unitLivery = "Jordan Air Force (FICTIONAL C VERSION)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Su-17M4"
	unitCountry = country.id.RUSSIA
	unitFuel = 3770
	unitFlares = 64
	unitChaff = 64
	unitLivery = "af standard (RUS)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	--[[ Red WW2 & Korea era fighters ]]
	
	unitType = "Bf-109K-4"
	unitCountry = country.id.CJTF_RED
	unitFuel = 296
	unitFlares = 0
	unitChaff = 0
	unitLivery = "Bf-109 K4 Jagdgeschwader 53"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "FW-190A8"
	unitCountry = country.id.CJTF_RED
	unitFuel = 409
	unitFlares = 0
	unitChaff = 0
	unitLivery = "Factory skin"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "FW-190D9"
	unitCountry = country.id.CJTF_RED
	unitFuel = 388
	unitFlares = 0
	unitChaff = 0
	unitLivery = "FW-190D9_13.JG 51_Heinz Marquardt"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "MiG-15bis"
	unitCountry = country.id.NORTH_KOREA
	unitFuel = 1172
	unitFlares = 0
	unitChaff = 0
	unitLivery = "North_Korea_Air Force_Major_ Arkady_ Boitsow"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.RED
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	
	--[[ Blue fighters ]]
	
	unitType = "F-14B"
	unitCountry = country.id.USA
	unitFuel = 7348
	unitFlares = 60
	unitChaff = 140
	unitLivery = "VF-102 Diamondbacks"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "F-15C"
	unitCountry = country.id.USA
	unitFuel = 6103
	unitFlares = 60
	unitChaff = 120
	unitLivery = "12th Fighter SQN (AK)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "F-16C_50"
	unitCountry = country.id.USA
	unitFuel = 3249
	unitFlares = 60
	unitChaff = 60
	unitLivery = "default"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "FA-18C_hornet"
	unitCountry = country.id.USA
	unitFuel = 4900
	unitFlares = 60
	unitChaff = 60
	unitLivery = "VFA-37"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "JF-17"
	unitCountry = country.id.CJTF_BLUE
	unitFuel = 2325
	unitFlares = 32
	unitChaff = 36
	unitLivery = "PAKAF Black Spider (default)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "M-2000C"
	unitCountry = country.id.FRANCE
	unitFuel = 3165
	unitFlares = 64
	unitChaff = 234
	unitLivery = "AdA Alsace LF-2"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	--[[ Blue attackers ]]

	unitType = "A-10A"
	unitCountry = country.id.USA
	unitFuel = 5029
	unitFlares = 120
	unitChaff = 240
	unitLivery = "66th WS Nellis AFB, Nevada (WA)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "A-10C_2"
	unitCountry = country.id.USA
	unitFuel = 5029
	unitFlares = 240
	unitChaff = 240
	unitLivery = "25th FS Osan AB, Korea (OS)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "AJS37"
	unitCountry = country.id.SWEDEN
	unitFuel = 4476
	unitFlares = 72
	unitChaff = 208
	unitLivery = "37"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "AV8BNA"
	unitCountry = country.id.USA
	unitFuel = 3519
	unitFlares = 120
	unitChaff = 60
	unitLivery = "default"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "Tornado GR4"
	unitCountry = country.id.UK
	unitFuel = 4663
	unitFlares = 45
	unitChaff = 90
	unitLivery = "bb of 14 squadron raf lossiemouth"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	--[[ Blue bombers ]]

	unitType = "B-1B"
	unitCountry = country.id.USA
	unitFuel = 88450
	unitFlares = 30
	unitChaff = 60
	unitLivery = "usaf standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "B-52H"
	unitCountry = country.id.USA
	unitFuel = 141135
	unitFlares = 192
	unitChaff = 1125
	unitLivery = "usaf standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	--[[ Blue trainers ]]
	
	unitType = "C-101CC"
	unitCountry = country.id.USA
	unitFuel = 1508
	unitFlares = 0
	unitChaff = 0
	unitLivery = "usaf agressor fictional"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Hawk"
	unitCountry = country.id.USA
	unitFuel = 1272
	unitFlares = 0
	unitChaff = 0
	unitLivery = "usaf aggressor 269"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "L-39ZA"
	unitCountry = country.id.CJTF_BLUE
	unitFuel = 980
	unitFlares = 0
	unitChaff = 0
	unitLivery = "splinter camo woodland"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	--[[ Blue helicopters ]]
	
	unitType = "AH-1W"
	unitCountry = country.id.USA
	unitFuel = 925
	unitFlares = 30
	unitChaff = 30
	unitLivery = "standard"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "AH-64D_BLK_II"
	unitCountry = country.id.USA
	unitFuel = 1438
	unitFlares = 60
	unitChaff = 30
	unitLivery = "default"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
		
	unitType = "CH-47Fbl1"
	unitCountry = country.id.USA
	unitFuel = 3054
	unitFlares = 120
	unitChaff = 120
	unitLivery = "us army dark green"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "OH58D"
	unitCountry = country.id.USA
	unitFuel = 300
	unitFlares = 30
	unitChaff = 0
	unitLivery = "default"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "SA342L"
	unitCountry = country.id.USA
	unitFuel = 416
	unitFlares = 32
	unitChaff = 0
	unitLivery = "US Marines Fictional"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "UH-1H"
	unitCountry = country.id.USA
	unitFuel = 404
	unitFlares = 60
	unitChaff = 0
	unitLivery = "Army Standard"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "UH-60A"
	unitCountry = country.id.USA
	unitFuel = 1100
	unitFlares = 30
	unitChaff = 30
	unitLivery = "standard"
	unitCategory = Group.Category.HELICOPTER
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	--[[ Blue Vietnam/70's era aircraft ]]
	
	unitType = "F-4E-45MC"
	unitCountry = country.id.USA
	unitFuel = 5510.5
	unitFlares = 30
	unitChaff = 120
	unitLivery = "rs68-517_sea_526tfs"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "F-5E-3"
	unitCountry = country.id.USA
	unitFuel = 2046
	unitFlares = 15
	unitChaff = 30
	unitLivery = "USAF 'Southeast Asia'"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "F-14A-135-GR"
	unitCountry = country.id.USA
	unitFuel = 7348
	unitFlares = 60
	unitChaff = 140
	unitLivery = "Top Gun 114 HB Weather V2"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "Mirage-F1CE"
	unitCountry = country.id.FRANCE
	unitFuel = 3356
	unitFlares = 15
	unitChaff = 30
	unitLivery = "RC 130 Normandie Niemen (FICTIONAL CT VERSION)"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	--[[ Blue WW2 & Korea era aircraft ]]
	
	unitType = "A-20G"
	unitCountry = country.id.USA
	unitFuel = 1500
	unitFlares = 0
	unitChaff = 0
	unitLivery = "USAF 668th BS"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "F-86F Sabre"
	unitCountry = country.id.USA
	unitFuel = 1282
	unitFlares = 0
	unitChaff = 0
	unitLivery = "US Air Force"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "I-16"
	unitCountry = country.id.CJTF_BLUE
	unitFuel = 191
	unitFlares = 0
	unitChaff = 0
	unitLivery = "Red Army Standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
	
	unitType = "MosquitoFBMkVI"
	unitCountry = country.id.UK
	unitFuel = 996
	unitFlares = 0
	unitChaff = 0
	unitLivery = "RAF"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})
		
	unitType = "P-47D-40"
	unitCountry = country.id.USA
	unitFuel = 676
	unitFlares = 0
	unitChaff = 0
	unitLivery = "Lt_Col_Benjamin_Mayo"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "P-51D-30-NA"
	unitCountry = country.id.USA
	unitFuel = 497
	unitFlares = 0
	unitChaff = 0
	unitLivery = "USAF 84th FS"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

	unitType = "SpitfireLFMkIX"
	unitCountry = country.id.UK
	unitFuel = 247
	unitFlares = 0
	unitChaff = 0
	unitLivery = "RAF Standard"
	unitCategory = Group.Category.AIRPLANE
	unitCoalition = coalition.side.BLUE
	table.insert(tblFuFlChLiPresets, {ut=unitType, co=unitCountry, fu=unitFuel, fl=unitFlares, ch=unitChaff, li=unitLivery, cat=unitCategory, cl=unitCoalition})

end

--[[
############################################################################################
Function:	SetUpLoadOutPresets
Purpose:	Adds load-out pre-sets for each aircraft/weapon combo into a table
Parameters:	none
Returns:	nothing
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]

function SetUpLoadOutPresets()

	local unitType = ""
	local unitScenario = ""
	local loadoutPresets = {}

	--[[ Red fighters ]]
	
	--[[ J-11A pre-sets ]]	
	unitType = "J-11A"
	unitScenario = "BVR_LRE"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{RKL609_L}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{RKL609_R}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "J-11A"
	unitScenario = "BVR_LR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	
		--[[ JF-17 pre-sets ]]	
	unitType = "JF-17"
	unitScenario = "BVR"
	loadoutPresets = {	
			   [1] = 
				{
					["CLSID"] = "DIS_PL-5EII",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "DIS_SD-10_DUAL_L",
				}, -- end of [2]
				[4] = 
				{
					["CLSID"] = "DIS_TANK800",
				}, -- end of [4]
				[6] = 
				{
					["CLSID"] = "DIS_SD-10_DUAL_R",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "DIS_PL-5EII",
				} -- end of [7]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})	
	
	unitType = "JF-17"
	unitScenario = "ACM_IR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "DIS_PL-5EII",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "DIS_PL-5EII",
				}, -- end of [2]
				[4] = 
				{
					["CLSID"] = "DIS_TANK800",
				}, -- end of [4]
				[6] = 
				{
					["CLSID"] = "DIS_PL-5EII",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "DIS_PL-5EII",
				} -- end of [7]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "JF-17"
	unitScenario = "ACM"
	loadoutPresets = {	
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	
	--[[ M-2000C pre-sets ]]
	unitType = "M-2000C"
	unitScenario = "BVR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{MMagicII}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{Matra_S530D}",
				}, -- end of [2]
				[8] = 
				{
					["CLSID"] = "{Matra_S530D}",
				}, -- end of [8]
				[10] = 
				{
					["CLSID"] = "{Eclair}",
				}, -- end of [10]
				[9] = 
				{
					["CLSID"] = "{MMagicII}",
				}, -- end of [9]
				[5] = 
				{
					["CLSID"] = "{M2KC_RPL_522}",
				} -- end of [5]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "M-2000C"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{MMagicII}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{MMagicII}",
				}, -- end of [2]
				[8] = 
				{
					["CLSID"] = "{MMagicII}",
				}, -- end of [8]
				[10] = 
				{
					["CLSID"] = "{Eclair}",
				}, -- end of [10]
				[9] = 
				{
					["CLSID"] = "{MMagicII}",
				}, -- end of [9]
				[5] = 
				{
					["CLSID"] = "{M2KC_RPL_522}",
				} -- end of [5]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "M-2000C"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ MiG-29A pre-sets ]]
	unitType = "MiG-29A"
	unitScenario = "BVR_LR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [7]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-29A"
	unitScenario = "BVR_MR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				} -- end of [7]
 	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-29A"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [7]
 	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-29A"
	unitScenario = "ACM"
	loadoutPresets = {
 	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ MiG-29S pre-sets ]]
	unitType = "MiG-29S"
	unitScenario = "BVR_LR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [7]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	
	--[[ MiG-31 pre-sets ]]
	unitType = "MiG-31"
	unitScenario = "BVR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{5F26DBC2-FB43-4153-92DE-6BBCE26CB0FF}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{5F26DBC2-FB43-4153-92DE-6BBCE26CB0FF}",
				} -- end of [6]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-31"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
				}, -- end of [1]
				[6] = 
				{
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
				} -- end of [6]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-31"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Su-27 pre-sets ]]
	unitType = "Su-27"
	unitScenario = "BVR_LR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Su-27"
	unitScenario = "BVR_MR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{88DAC840-9F75-4531-8689-B46E64E42E53}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{88DAC840-9F75-4531-8689-B46E64E42E53}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-27"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [3]
				[8] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [8]
				[10] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [10]
				[9] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-27"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	
	--[[ Su-30 pre-sets ]]	
	unitType = "Su-30"
	unitScenario = "BVR_LRE"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "Su-30"
	unitScenario = "BVR_LR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-30"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [3]
				[8] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [8]
				[10] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [10]
				[9] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Su-30"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	
	--[[ Su-33 pre-sets ]]	
	unitType = "Su-33"
	unitScenario = "BVR_LRE"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}",
				} -- end of [12]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "Su-33"
	unitScenario = "BVR_LR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [12]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-33"
	unitScenario = "BVR_MR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{88DAC840-9F75-4531-8689-B46E64E42E53}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{88DAC840-9F75-4531-8689-B46E64E42E53}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [12]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-33"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [3]
				[11] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [11]
				[10] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [10]
				[12] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				} -- end of [12]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Su-33"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Red attacker presets ]]
	
	--[[ Su-17M4 presets ]]
	unitType = "Su-17M4"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{APU-60-1_R_60M}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{APU-60-1_R_60M}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				} -- end of [8]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Su-17M4"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{R-60}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{R-60}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				} -- end of [8]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Su-17M4"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Su-25 presets ]]
	unitType = "Su-25"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{4203753F-8198-4E85-9924-6F8FF679F9FF}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{4203753F-8198-4E85-9924-6F8FF679F9FF}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Su-25"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{R_60}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{4203753F-8198-4E85-9924-6F8FF679F9FF}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{4203753F-8198-4E85-9924-6F8FF679F9FF}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{R_60}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Su-25"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Su-25T presets ]]
	unitType = "Su-25T"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{F789E86A-EE2E-4E6B-B81E-D5E5F903B6ED}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}",
				}, -- end of [5]
				[7] = 
				{
					["CLSID"] = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F789E86A-EE2E-4E6B-B81E-D5E5F903B6ED}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				} -- end of [11]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-25T"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{R_60}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{F789E86A-EE2E-4E6B-B81E-D5E5F903B6ED}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}",
				}, -- end of [5]
				[7] = 
				{
					["CLSID"] = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F789E86A-EE2E-4E6B-B81E-D5E5F903B6ED}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{R_60}",
				}, -- end of [11]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-25T"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Su-34 presets ]]
	unitType = "Su-34"
	unitScenario = "BVR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}",
				} -- end of [12]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Su-34"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [5]
				[8] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{X-29T}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}",
				} -- end of [12]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-34"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Red bomber presets ]]
	
	--[[ H-6J presets ]]
	unitType = "H-6J"
	unitScenario = "ACM"
	loadoutPresets = {
				[8] = 
				{
					["CLSID"] = "DIS_H6_250_2_N24",
				} -- end of [8]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	--[[ Su-24M presets ]]
	unitType = "Su-24M"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{APU-60-1_R_60M}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{APU-60-1_R_60M}",
				} -- end of [8]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

		unitType = "Su-24M"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{R-60}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{R-60}",
				} -- end of [8]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Su-24M"
	unitScenario = "ACM"
	loadoutPresets = {
				[2] = 
				{
					["CLSID"] = "{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}",
				}, -- end of [7]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Tu-22M3 presets ]]
	unitType = "Tu-22M3"
	unitScenario = "ACM"
	loadoutPresets = {
				[3] = 
				{
					["CLSID"] = "{BDAD04AA-4D4A-4E51-B958-180A89F963CF}",
				} -- end of [3]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Tu-142 presets ]]
	unitType = "Tu-142"
	unitScenario = "ACM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{C42EE4C3-355C-4B83-8B22-B39430B8F4AE}",
				} -- end of [1]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Red trainer presets ]]
	
	--[[ L-39ZA presets ]]
	unitType = "L-39ZA"
	unitScenario = "BVR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{APU-60-1_R_60M}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{PK-3}",
				}, -- end of [2]
				[4] = 
				{
					["CLSID"] = "{PK-3}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{APU-60-1_R_60M}",
				} -- end of [5]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "L-39ZA"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{APU-60-1_R_60M}",
				}, -- end of [1]
				[5] = 
				{
					["CLSID"] = "{APU-60-1_R_60M}",
				} -- end of [5]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "L-39ZA"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{R-3S}",
				}, -- end of [1]
				[5] = 
				{
					["CLSID"] = "{R-3S}",
				}, -- end of [5]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "L-39ZA"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	
	--[[ Red helicopter presets ]]
	
	--[[ Ka-50 presets ]]
	unitType = "Ka-50"
	unitScenario = "ACM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{A6FD14D3-6D30-4C85-88A7-8D17BEE120E2}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{A6FD14D3-6D30-4C85-88A7-8D17BEE120E2}",
				}, -- end of [4]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
		--[[ Ka-50_3 presets ]]
	unitType = "Ka-50_3"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{A6FD14D3-6D30-4C85-88A7-8D17BEE120E2}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{A6FD14D3-6D30-4C85-88A7-8D17BEE120E2}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{9S846_2xIGLA}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{9S846_2xIGLA}",
				}, -- end of [6]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Mi-8MT presets ]]
	unitType = "Mi-8MT"
	unitScenario = "ACM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "GUV_YakB_GSHP",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "GUV_YakB_GSHP",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "KORD_12_7",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "PKT_7_62",
				} -- end of [8]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Mi-24P presets ]]
	unitType = "Mi-24P"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{2x9M120_Ataka_V}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{2x9M120_Ataka_V}",
				} -- end of [6]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Mi-24P"
	unitScenario = "ACM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{2x9M120_Ataka_V}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{2x9M120_Ataka_V}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{2x9M120_Ataka_V}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{2x9M120_Ataka_V}",
				} -- end of [6]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Mi-26"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Mi-28N"
	unitScenario = "ACM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{57232979-8B0F-4db7-8D9A-55197E06B0F5}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{57232979-8B0F-4db7-8D9A-55197E06B0F5}",
				} -- end of [4]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Red Vietnam/70's era presets ]]
	
	--[[ MiG-19P pre-sets ]]
	unitType = "MiG-19P"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{K-13A}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "PTB760_MIG19",
				}, -- end of [2]
				[5] = 
				{
					["CLSID"] = "PTB760_MIG19",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{K-13A}",
				}, -- end of [6]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-19P"
	unitScenario = "ACM"
	loadoutPresets = {
				[5] = 
				{
					["CLSID"] = "PTB760_MIG19",
				}, -- end of [5]
				[2] = 
				{
					["CLSID"] = "PTB760_MIG19",
				}, -- end of [2]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ MiG-21Bis pre-sets ]]
	unitType = "MiG-21Bis"
	unitScenario = "BVR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{R-60M 2L}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{R-3R}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{PTB_800_MIG21}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{R-3R}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{R-60M 2R}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{ASO-2}",
				} -- end of [6]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-21Bis"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{R-60M}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{R-60M}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{PTB_800_MIG21}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{R-60M}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{R-60M}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{ASO-2}",
				}, -- end of [6]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-21Bis"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{R-3S}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{R-13M1}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{PTB_800_MIG21}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{R-13M1}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{R-3S}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{ASO-2}",
				}, -- end of [6]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-21Bis"
	unitScenario = "ACM"
	loadoutPresets = {
				[3] = 
				{
					["CLSID"] = "{PTB_490C_MIG21}",
				}, -- end of [3]
				[6] = 
				{
					["CLSID"] = "{ASO-2}",
				}, -- end of [6]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	--[[ MiG-23MLD pre-sets ]]
	unitType = "MiG-23MLD"
	unitScenario = "BVR"
	loadoutPresets = {
				[2] = 
				{
					["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
				}, -- end of [6]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-23MLD"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {
				[3] = 
				{
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
				}, -- end of [5]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-23MLD"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {
				[3] = 
				{
					["CLSID"] = "{R-60 2L}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{R-60 2R}",
				}, -- end of [5]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-23MLD"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	
	--[[ MiG-27K pre-sets ]]
	unitType = "MiG-27K"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {
				[2] = 
				{
					["CLSID"] = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{APU-60-1_R_60M}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{APU-60-1_R_60M}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}",
				}, -- end of [8]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-27K"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {
				[2] = 
				{
					["CLSID"] = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{R-60}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{R-60}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}",
				}, -- end of [8]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "MiG-27K"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	
	--[[ Mirage-F1CE pre-sets ]]
	unitType = "Mirage-F1CE"
	unitScenario = "BVR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{R550_Magic_1}",
				}, -- end of [1]
				[3] = 
				{
					["CLSID"] = "{R530F_EM}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "PTB-1200-F1",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{R530F_EM}",
				}, -- end of [5]
				[7] = 
				{
					["CLSID"] = "{R550_Magic_1}",
				}, -- end of [7]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Mirage-F1CE"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{R550_Magic_1}",
				}, -- end of [1]
				[7] = 
				{
					["CLSID"] = "{R550_Magic_1}",
				}, -- end of [7]
				[4] = 
				{
					["CLSID"] = "PTB-1200-F1",
				}, -- end of [4]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Mirage-F1CE"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
				}, -- end of [1]
				[7] = 
				{
					["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
				}, -- end of [7]
				[4] = 
				{
					["CLSID"] = "PTB-1200-F1",
				}, -- end of [4]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Mirage-F1CE"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Red WW2 & Korea fighter presets ]]
	
	--[[ Bf-109K-4 presets ]]
	unitType = "Bf-109K-4"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ FW-190A8 presets ]]
	unitType = "FW-190A8"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ FW-190D9 presets ]]
	unitType = "FW-190D9"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ MiG-15bis presets ]]
	unitType = "MiG-15bis"
	unitScenario = "ACM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "PTB300_MIG15",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "PTB300_MIG15",
				}, -- end of [2]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Blue fighters ]]
	
	--[[ F-14B pre-sets ]]	
	unitType = "F-14B"
	unitScenario = "BVR_LR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{SHOULDER AIM-7MH}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{AIM_54C_Mk47}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{AIM_54C_Mk47}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{AIM_54C_Mk47}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{AIM_54C_Mk47}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{SHOULDER AIM-7MH}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				}, -- end of [10]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-14B"
	unitScenario = "BVR_MR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{SHOULDER AIM-7MH}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{BELLY AIM-7MH}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{BELLY AIM-7MH}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{BELLY AIM-7MH}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{BELLY AIM-7MH}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{SHOULDER AIM-7MH}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				}, -- end of [10]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-14B"
	unitScenario = "ACM_IR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{LAU-7 - AIM-9M}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{LAU-7 - AIM-9M}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-14B"
	unitScenario = "ACM"
	loadoutPresets = {	
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	
	--[[ F-15C pre-sets ]]	
	unitType = "F-15C"
	unitScenario = "BVR_LR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [5]
				[7] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				} -- end of [11]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-15C"
	unitScenario = "BVR_MR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{AIM-7H}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{AIM-7H}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{AIM-7H}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{AIM-7H}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				} -- end of [11]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-15C"
	unitScenario = "ACM_IR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [3]
				[11] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [11]
				[10] = 
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [10]
				[9] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-15C"
	unitScenario = "ACM"
	loadoutPresets = {	
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	
	--[[ F-16C_50 pre-sets ]]	
	unitType = "F-16C_50"
	unitScenario = "BVR_E"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "ALQ_184_Long",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "F-16C_50"
	unitScenario = "BVR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})	
	
	unitType = "F-16C_50"
	unitScenario = "ACM_IRX"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "F-16C_50"
	unitScenario = "ACM_IR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "F-16C_50"
	unitScenario = "ACM"
	loadoutPresets = {	
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	
	--[[ FA-18C_hornet pre-sets ]]	
	unitType = "FA-18C_hornet"
	unitScenario = "BVR_LR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})	
	
	unitType = "FA-18C_hornet"
	unitScenario = "BVR_MR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{LAU-115 - AIM-7H}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{LAU-115 - AIM-7H}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{AIM-7H}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{AIM-7H}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{LAU-115 - AIM-7H}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{LAU-115 - AIM-7H}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})	
	
	unitType = "FA-18C_hornet"
	unitScenario = "ACM_IRX"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "LAU-115_2*LAU-127_AIM-9X",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [3]
				[5] = 
				{
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
				}, -- end of [5]
				[7] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "LAU-115_2*LAU-127_AIM-9X",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "FA-18C_hornet"
	unitScenario = "ACM_IR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "LAU-115_2*LAU-127_AIM-9M",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [3]
				[5] = 
				{
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
				}, -- end of [5]
				[7] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "LAU-115_2*LAU-127_AIM-9M",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})	
	
	unitType = "FA-18C_hornet"
	unitScenario = "ACM"
	loadoutPresets = {	
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	
	--[[ Blue attacker presets ]]
	
	--[[ A-10A presets ]]
	unitType = "A-10A"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "ALQ_184",
				}, -- end of [1]
				[3] = 
				{
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{CBU-87}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{5335D97A-35A5-4643-9D9B-026C75961E52}",
				}, -- end of [5]
				[7] = 
				{
					["CLSID"] = "{5335D97A-35A5-4643-9D9B-026C75961E52}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{CBU-87}",
				}, -- end of [8]
				[11] = 
				{
					["CLSID"] = "{DB434044-F5D0-4F1F-9BA9-B73027E18DD3}",
				}, -- end of [11]
				[9] = 
				{
					["CLSID"] = "LAU_88_AGM_65H_2_R",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "A-10A"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "ALQ_184",
				}, -- end of [1]
				[3] = 
				{
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{CBU-87}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{5335D97A-35A5-4643-9D9B-026C75961E52}",
				}, -- end of [5]
				[7] = 
				{
					["CLSID"] = "{5335D97A-35A5-4643-9D9B-026C75961E52}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{CBU-87}",
				}, -- end of [8]
				[11] = 
				{
					["CLSID"] = "{3C0745ED-8B0B-42eb-B907-5BD5C1717447}",
				}, -- end of [11]
				[9] = 
				{
					["CLSID"] = "LAU_88_AGM_65H_2_R",
				} -- end of [9]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "A-10A"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ A-10C_2 presets ]]
	unitType = "A-10C_2"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "ALQ_184",
				}, -- end of [1]
				[3] = 
				{
					["CLSID"] = "LAU_88_AGM_65H_2_L",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{5335D97A-35A5-4643-9D9B-026C75961E52}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{CBU-87}",
				}, -- end of [5]
				[7] = 
				{
					["CLSID"] = "{CBU-87}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{5335D97A-35A5-4643-9D9B-026C75961E52}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{DB434044-F5D0-4F1F-9BA9-B73027E18DD3}",
				} -- end of [11]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "A-10C_2"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ AJS37 presets ]]
	unitType = "AJS37"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{Robot24J}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{KB}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{Robot74}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{VIGGEN_X-TANK}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{Robot74}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{AKAN}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{Robot24J}",
				} -- end of [7]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "AJS37"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{Robot24}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{KB}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{Robot24}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{VIGGEN_X-TANK}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{Robot24}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{AKAN}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{Robot24}",
				} -- end of [7]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "AJS37"
	unitScenario = "ACM"
	loadoutPresets = {
				[2] = 
				{
					["CLSID"] = "{KB}",
				}, -- end of [2]
				[4] = 
				{
					["CLSID"] = "{VIGGEN_X-TANK}",
				}, -- end of [4]
				[6] = 
				{
					["CLSID"] = "{AKAN}",
				} -- end of [6]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ AV8BNA presets ]]
	unitType = "AV8BNA"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{AIM-9M-ON-ADAPTER}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "LAU_117_AGM_65F",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{GAU_12_Equalizer}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "LAU_117_AGM_65F",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{AIM-9M-ON-ADAPTER}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				} -- end of [8]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "AV8BNA"
	unitScenario = "ACM"
	loadoutPresets = {
				[4] = 
				{
					["CLSID"] = "{GAU_12_Equalizer}",
				} -- end of [4]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Tornado GR4 presets ]]
	unitType = "Tornado GR4"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{8C3F26A2-FA0F-11d5-9190-00A0249B6F00}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{EF124821-F9BB-4314-A153-E0E2FE1162C4}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{EF124821-F9BB-4314-A153-E0E2FE1162C4}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{8C3F26A1-FA0F-11d5-9190-00A0249B6F00}",
				} -- end of [12]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Tornado GR4"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{8C3F26A2-FA0F-11d5-9190-00A0249B6F00}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{EF124821-F9BB-4314-A153-E0E2FE1162C4}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{EF124821-F9BB-4314-A153-E0E2FE1162C4}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{8C3F26A1-FA0F-11d5-9190-00A0249B6F00}",
				}, -- end of [12]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "Tornado GR4"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	
	--[[ Blue bomber presets ]]
	
	--[[ B-1B presets ]]
	unitType = "B-1B"
	unitScenario = "ACM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "B-1B_Mk-84*8",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "B-1B_Mk-84*8",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "B-1B_Mk-84*8",
				} -- end of [3]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ B-52H presets ]]
	unitType = "B-52H"
	unitScenario = "ACM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{585D626E-7F42-4073-AB70-41E728C333E2}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{6C47D097-83FF-4FB2-9496-EAB36DDF0B05}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{585D626E-7F42-4073-AB70-41E728C333E2}",
				} -- end of [3]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	
	--[[ Blue trainer presets ]]
	
	--[[ C-101CC presets ]]
	unitType = "C-101CC"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [1]
				[7] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [7]
				[4] = 
				{
					["CLSID"] = "{C-101-DEFA553}",
				} -- end of [4]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "C-101CC"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
				}, -- end of [1]
				[7] = 
				{
					["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
				}, -- end of [7]
				[4] = 
				{
					["CLSID"] = "{C-101-DEFA553}",
				}, -- end of [4]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "C-101CC"
	unitScenario = "ACM"
	loadoutPresets = {
				[4] = 
				{
					["CLSID"] = "{C-101-DEFA553}",
				} -- end of [4]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	--[[ Hawk presets ]]
	unitType = "Hawk"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{AIM-9M-ON-ADAPTER}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{Matra155RocketPod}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{ADEN_GUNPOD}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{Matra155RocketPod}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{AIM-9M-ON-ADAPTER}",
				} -- end of [5]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "Hawk"
	unitScenario = "ACM"
	loadoutPresets = {
				[3] = 
				{
					["CLSID"] = "{ADEN_GUNPOD}",
				} -- end of [3]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ Blue helicopter presets ]]
	
	--[[ AH-1W presets ]]
	unitType = "AH-1W"
	unitScenario = "ACM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "M260_HYDRA",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "M260_HYDRA",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}",
				} -- end of [4]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ AH-64D_BLK_II presets ]]
	unitType = "AH-64D_BLK_II"
	unitScenario = "ACM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "M261_MK151",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "M261_MK151",
				} -- end of [4]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
		--[[ CH-47Fbl1 presets ]]
	unitType = "CH-47Fbl1"
	unitScenario = "ACM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{CH47_PORT_M60D}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{CH47_STBD_M60D}",
				}, -- end of [2]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ OH58D presets ]]
	unitType = "OH58D"
	unitScenario = "ACM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "OH58D_M3P_L500",
				}, -- end of [1]
				[5] = 
				{
					["CLSID"] = "OH58D_AGM_114_R",
				}, -- end of [5]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "OH58D"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "OH58D_M3P_L500",
				}, -- end of [1]
				[5] = 
				{
					["CLSID"] = "OH58D_FIM_92_R",
				}, -- end of [5]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ SA342L presets ]]
	unitType = "SA342L"
	unitScenario = "ACM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{GIAT_M621_APHE}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{TELSON8_SNEBT253}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{FAS}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{IR_Deflector}",
				}, -- end of [4]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	unitType = "SA342L"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{SA342_Mistral_R2}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{SA342_Mistral_L2}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{FAS}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{IR_Deflector}",
				}, -- end of [4]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ UH-1H presets ]]
	unitType = "UH-1H"
	unitScenario = "ACM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "M134_L",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "M261_MK151",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "M60_SIDE_L",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "M60_SIDE_R",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "M261_MK151",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "M134_R",
				} -- end of [6]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ UH-60A presets ]]
	unitType = "UH-60A"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	
	--[[ Blue Vietnam/70's era aircraft presets ]]

	--[[ F-4E pre-sets ]]	
	unitType = "F-4E-45MC"
	unitScenario = "BVR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{F4_SARGENT_TANK_370_GAL}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{AIM-9M}",
				}, -- end of [2]
				[4] = 
				{
					["CLSID"] = "{AIM-9M}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7M}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7M}",
				}, -- end of [6]
				[8] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7M}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{HB_F4E_AIM-7M}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{AIM-9M}",
				}, -- end of [10]
				[12] = 
				{
					["CLSID"] = "{AIM-9M}",
				}, -- end of [12]
				[13] = 
				{
					["CLSID"] = "{F4_SARGENT_TANK_370_GAL_R}",
				}, -- end of [13]
				[14] = 
				{
					["CLSID"] = "{HB_ALE_40_30_60}",
				}, -- end of [14]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "F-4E-45MC"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{AIM-9M}",
				}, -- end of [2]
				[4] = 
				{
					["CLSID"] = "{AIM-9M}",
				}, -- end of [4]
				[14] = 
				{
					["CLSID"] = "{HB_ALE_40_30_60}",
				}, -- end of [14]
				[10] = 
				{
					["CLSID"] = "{AIM-9M}",
				}, -- end of [10]
				[12] = 
				{
					["CLSID"] = "{AIM-9M}",
				}, -- end of [12]
				[13] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [13]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "F-4E-45MC"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{AIM-9J}",
				}, -- end of [2]
				[4] = 
				{
					["CLSID"] = "{AIM-9J}",
				}, -- end of [4]
				[14] = 
				{
					["CLSID"] = "{HB_ALE_40_30_60}",
				}, -- end of [14]
				[13] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [13]
				[12] = 
				{
					["CLSID"] = "{AIM-9J}",
				}, -- end of [12]
				[10] = 
				{
					["CLSID"] = "{AIM-9J}",
				}, -- end of [10]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	unitType = "F-4E-45MC"
	unitScenario = "ACM"
	loadoutPresets = {	
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	
	--[[ F-5E-3 pre-sets ]]	
	unitType = "F-5E-3"
	unitScenario = "ACM_IR_AA"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{AIM-9P5}",
				}, -- end of [1]
				[7] = 
				{
					["CLSID"] = "{AIM-9P5}",
				}, -- end of [7]
				[4] = 
				{
					["CLSID"] = "{0395076D-2F77-4420-9D33-087A4398130B}",
				} -- end of [4]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-5E-3"
	unitScenario = "ACM_IR_RA"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{AIM-9J}",
				}, -- end of [1]
				[7] = 
				{
					["CLSID"] = "{AIM-9J}",
				}, -- end of [7]
				[4] = 
				{
					["CLSID"] = "{0395076D-2F77-4420-9D33-087A4398130B}",
				}, -- end of [4]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	unitType = "F-5E-3"
	unitScenario = "ACM"
	loadoutPresets = {	
				[4] = 
				{
					["CLSID"] = "{0395076D-2F77-4420-9D33-087A4398130B}",
				} -- end of [4]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	
	--[[ F-14A-135-GR pre-sets ]]	
	unitType = "F-14A-135-GR"
	unitScenario = "BVR_LR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{SHOULDER AIM-7MH}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{AIM_54A_Mk60}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{AIM_54A_Mk60}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{AIM_54A_Mk60}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{AIM_54A_Mk60}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{SHOULDER AIM-7MH}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	unitType = "F-14A-135-GR"
	unitScenario = "BVR_MR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{SHOULDER AIM-7MH}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{BELLY AIM-7MH}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{BELLY AIM-7MH}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{BELLY AIM-7MH}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{BELLY AIM-7MH}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{SHOULDER AIM-7MH}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	unitType = "F-14A-135-GR"
	unitScenario = "ACM_IR"
	loadoutPresets = {	
				[1] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{LAU-7 - AIM-9M}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "<CLEAN>",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F14-300gal}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{LAU-7 - AIM-9M}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
				} -- end of [10]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		
	unitType = "F-14A-135-GR"
	unitScenario = "ACM"
	loadoutPresets = {	
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})		

	
	--[[ Blue WW2 & Korea aircraft presets ]]
	
	--[[ A-20G presets ]]
	unitType = "A-20G"
	unitScenario = "ACM"
	loadoutPresets = {
				[1] = 
				{
					["CLSID"] = "{4xAN-M64_on_InvCountedAttachmentPoints}",
				} -- end of [1]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ F-86F Sabre presets ]]
	unitType = "F-86F Sabre"
	unitScenario = "ACM_IR"
	loadoutPresets = {
				[5] = 
				{
					["CLSID"] = "{GAR-8}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{GAR-8}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{PTB_120_F86F35}",
				}, -- end of [7]
				[4] = 
				{
					["CLSID"] = "{PTB_120_F86F35}",
				}, -- end of [4]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})
	
	unitType = "F-86F Sabre"
	unitScenario = "ACM"
	loadoutPresets = {
				[4] = 
				{
					["CLSID"] = "{PTB_120_F86F35}",
				}, -- end of [4]
				[7] = 
				{
					["CLSID"] = "{PTB_120_F86F35}",
				} -- end of [7]
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ I-16 presets ]]
	unitType = "I-16"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ MosquitoFBMkVI presets ]]
	unitType = "MosquitoFBMkVI"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ P-47D-40 presets ]]
	unitType = "P-47D-40"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ P-51D-30-NA presets ]]
	unitType = "P-51D-30-NA"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	--[[ SpitfireLFMkIX presets ]]
	unitType = "SpitfireLFMkIX"
	unitScenario = "ACM"
	loadoutPresets = {
	}
	table.insert(tblLoadoutPresets, {ut=unitType, us=unitScenario, lp=loadoutPresets})

	
	if (debugFlgOpFor == 2) then
		for i=1, #tblLoadoutPresets do
			trigger.action.outText("tblLoadoutPresets row #: " .. i .. ", Preset type: " .. tblLoadoutPresets[i].ut .. ", Preset scenario: " .. tblLoadoutPresets[i].us, 10)	
		end
	end
end

--[[
############################################################################################
Function:	SpawnOpForACGroup
Purpose:	Spawns 1-4 units of the specified unit type, with two waypoints as specified
Parameters:	pUnitName - Unit name initiating the spawning of units
			pCountry - Country ID of group to be spawned (country.id enum)
			pType - Unit type
			pNum - Number of units
			pSkill - Skill of unit(s)
			pEngScen - Engagement scenario 
			pHeadingRad - Unit heading in radians
			pWP1Vec3 - Vec3 table (point) w/altitude, longitude and latitude of waypoint 1
			pWP2Vec3 - Vec3 table (point) w/altitude, longitude and latitude of waypoint 2
			pSpeed - Unit speed at both waypoints
Returns:	Group object
Author:		AKA_Relent
DCS ver:	2.7
############################################################################################
]]
function SpawnOpForACGroup(pUnitName, pCountry, pType, pNum, pSkill, pEngScen, pHeadingRad, pWP1Vec3, pWP2Vec3, pSpeed)
	if (debugFlgOpFor == 2) then
		trigger.action.outText("SpawnOpForACGroup 1", 30)	
	end

	if (pUnitName == nil or pCountry == nil or pType == nil or pNum == nil or pSkill == nil or pEngScen == nil or
			pHeadingRad == nil or pWP1Vec3 == nil or pWP2Vec3 == nil or pSpeed == nil) then
		return
	end
	
	
	glbUnitId = glbUnitId + 1
	glbGroupId = glbGroupId + 1
	glbOnBoardNumOpFor = glbOnBoardNumOpFor + 1
	
	local lName = tostring(pType) .. "-" .. tostring(glbUnitId)
	local lGroupID = glbGroupId
		
	local lAlt1 = pWP1Vec3.y
	local lLongX1 = pWP1Vec3.x
	local lLattY1 = pWP1Vec3.z
	local lAlt2 = pWP2Vec3.y
	local lLongX2 = pWP2Vec3.x
	local lLattY2 = pWP2Vec3.z

	local unitFuel = 2000
	local unitFlares = 32
	local unitChaff = 32
	local unitLivery = ""
	local unitCategory = Group.Category.AIRPLANE
	local unitCoalition = coalition.side.NEUTRAL
	
	if (debugFlgOpFor == 2) then
		trigger.action.outText("SpawnOpForACGroup 2; lName=" .. lName, 30)	
	end

	for i=1, #tblFuFlChLiPresets do 
		if (tblFuFlChLiPresets[i].ut == pType and tblFuFlChLiPresets[i].co == pCountry) then
			unitFuel = tblFuFlChLiPresets[i].fu
			unitFlares = tblFuFlChLiPresets[i].fl
			unitChaff = tblFuFlChLiPresets[i].ch
			unitLivery = tblFuFlChLiPresets[i].li
			unitCategory = tblFuFlChLiPresets[i].cat
			unitCoalition =  tblFuFlChLiPresets[i].cl
			break
		end
	end
	
	if (debugFlgOpFor == 2) then
		trigger.action.outText("SpawnOpForACGroup 3", 30)	
	end

	local lUnit = Unit.getByName(pUnitName)
	local lUid = Unit.getID(lUnit)

	if (debugFlgOpFor == 2) then
		trigger.action.outText("SpawnOpForACGroup 4, unitCategory = " .. unitCategory, 30)	
	end
	
	if (debugFlgOpFor == 2) then
		trigger.action.outText("SpawnOpForACGroup: pUnitName: " .. pUnitName .. ", lUid: " .. lUid, 30)	
	end

	local callSignName = ""
	local callSignNameNumber1 = ""
	if (coalition.getCountryCoalition(pCountry) == coalition.side.RED) then
		callSignName = tostring(glbOnBoardNumOpFor)
		callSignNameNumber1 = callSignName
	elseif (coalition.getCountryCoalition(pCountry) == coalition.side.BLUE) then
		callSignName = tblBlueCallSignsOpFor[glbCurrentBlueCallSignOpFor]
		callSignNameNumber1 = callSignName .. "11"
	else
		callSignName = tostring(glbOnBoardNumOpFor)
		callSignNameNumber1 = callSignName
	end
	
	
	
	
	local groupData = 
	{
		["lateActivation"] = false,
		["tasks"] = 
		{
		}, -- end of ["tasks"]
		["radioSet"] = false,
		["task"] = "CAP",
		["uncontrolled"] = false,
		["route"] = 
		{
			["routeRelativeTOT"] = false,
			["points"] = 
			{
				[1] = 
				{
					["alt"] = lAlt1,
					["action"] = "Turning Point",
					["alt_type"] = "BARO",
					["speed"] = pSpeed,
					["task"] = 
					{
						["id"] = "ComboTask",
						["params"] = 
						{
							["tasks"] = 
							{
								[1] = 
								{
									["enabled"] = true,
									["key"] = "CAP",
									["id"] = "EngageTargets",
									["number"] = 1,
									["auto"] = true,
									["params"] = 
									{
										["targetTypes"] = 
										{
											[1] = "Air",
										}, -- end of ["targetTypes"]
										["priority"] = 0,
									}, -- end of ["params"]
								}, -- end of [1]
								[2] = 
								{
									["enabled"] = true,
									["auto"] = true,
									["id"] = "WrappedAction",
									["number"] = 2,
									["params"] = 
									{
										["action"] = 
										{
											["id"] = "Option",
											["params"] = 
											{
												["value"] = true,
												["name"] = 17,
											}, -- end of ["params"]
										}, -- end of ["action"]
									}, -- end of ["params"]
								}, -- end of [2]
								[3] = 
								{
									["enabled"] = true,
									["auto"] = true,
									["id"] = "WrappedAction",
									["number"] = 3,
									["params"] = 
									{
										["action"] = 
										{
											["id"] = "Option",
											["params"] = 
											{
												["value"] = 4,
												["name"] = 18,
											}, -- end of ["params"]
										}, -- end of ["action"]
									}, -- end of ["params"]
								}, -- end of [3]
								[4] = 
								{
									["enabled"] = true,
									["auto"] = true,
									["id"] = "WrappedAction",
									["number"] = 4,
									["params"] = 
									{
										["action"] = 
										{
											["id"] = "Option",
											["params"] = 
											{
												["value"] = true,
												["name"] = 19,
											}, -- end of ["params"]
										}, -- end of ["action"]
									}, -- end of ["params"]
								}, -- end of [4]
								[5] = 
								{
									["enabled"] = true,
									["auto"] = true,
									["id"] = "WrappedAction",
									["number"] = 5,
									["params"] = 
									{
										["action"] = 
										{
											["id"] = "Option",
											["params"] = 
											{
												["targetTypes"] = 
												{
												}, -- end of ["targetTypes"]
												["name"] = 21,
												["value"] = "none;",
												["noTargetTypes"] = 
												{
													[1] = "Fighters",
													[2] = "Multirole fighters",
													[3] = "Bombers",
													[4] = "Helicopters",
													[5] = "Infantry",
													[6] = "Fortifications",
													[7] = "Tanks",
													[8] = "IFV",
													[9] = "APC",
													[10] = "Artillery",
													[11] = "Unarmed vehicles",
													[12] = "AAA",
													[13] = "SR SAM",
													[14] = "MR SAM",
													[15] = "LR SAM",
													[16] = "Aircraft Carriers",
													[17] = "Cruisers",
													[18] = "Destroyers",
													[19] = "Frigates",
													[20] = "Corvettes",
													[21] = "Light armed ships",
													[22] = "Unarmed ships",
													[23] = "Submarines",
													[24] = "Cruise missiles",
													[25] = "Antiship Missiles",
													[26] = "AA Missiles",
													[27] = "AG Missiles",
													[28] = "SA Missiles",
												}, -- end of ["noTargetTypes"]
											}, -- end of ["params"]
										}, -- end of ["action"]
									}, -- end of ["params"]
								}, -- end of [5]
							}, -- end of ["tasks"]
						}, -- end of ["params"]
					}, -- end of ["task"]
					["type"] = "Turning Point",
					["ETA"] = 0,
					["ETA_locked"] = true,
					["y"] = lLattY1,
					["x"] = lLongX1,
					["formation_template"] = "",
					["speed_locked"] = true,
				}, -- end of [1]
				[2] = 
				{
					["alt"] = lAlt2,
					["action"] = "Turning Point",
					["alt_type"] = "BARO",
					["speed"] = pSpeed,
					["task"] = 
					{
						["id"] = "ComboTask",
						["params"] = 
						{
							["tasks"] = 
							{
							}, -- end of ["tasks"]
						}, -- end of ["params"]
					}, -- end of ["task"]
					["type"] = "Turning Point",
					["ETA"] = 601.84765346067,
					["ETA_locked"] = false,
					["y"] = lLattY2,
					["x"] = lLongX2,
					["formation_template"] = "",
					["speed_locked"] = true,
				}, -- end of [2]
			}, -- end of ["points"]
		}, -- end of ["route"]
		["groupId"] = lGroupID,
		["hidden"] = "false",
		["units"] = 
		{
			[1] = 
			{
				["alt"] = lAlt1,
				["alt_type"] = "RADIO",
				["hardpoint_racks"] = true,
				["alt_type"] = "BARO",
				["livery_id"] = unitLivery,
				["skill"] = pSkill,
				["speed"] = pSpeed,
				["AddPropAircraft"] = 
				{
				}, -- end of ["AddPropAircraft"]
				["type"] = pType,
				["unitId"] = glbUnitId,
				["psi"] = pHeadingRad*(-1),
				["y"] = lLattY1,
				["x"] = lLongX1,
				["name"] = lName,
				["payload"] = 
				{
					["pylons"] = EngagementScenarioLoadOutPresetOpFor(pType, pEngScen),
					["fuel"] = unitFuel,
					["flare"] = unitFlares,
					["chaff"] = unitChaff,
					["gun"] = 100,
				}, -- end of ["payload"]
				["heading"] = pHeadingRad,
				--["callsign"] = glbOnBoardNumOpFor,
				["callsign"] = 
				{
					[1] = 1,
					[2] = 1,
					["name"] = callSignNameNumber1,
					[3] = 1,
				}, -- end of ["callsign"]
				["onboard_num"] = tostring(glbOnBoardNumOpFor),
			}, -- end of [1]
		}, -- end of ["units"]
		["y"] = lLattY1,
		["x"] = lLongX1,
		["name"] = lName,
		["communication"] = true,
		["start_time"] = 0,
		["modulation"] = 0,
		["frequency"] = 127.5,
	}
	
	--[[ Add 2nd through Nth units to group ]]
	if (pNum > 1 and pNum < 5) then
		for i = 2,pNum do  
			lLongX1 = lLongX1 + 30
			lLattY1 = lLattY1 + 30
			groupData.units[i] = AddUnitToGroupOpFor(pType, pCountry, pEngScen, lLongX1, lLattY1, pHeadingRad, lAlt1, i)      
		end
	end

	glbCurrentBlueCallSignOpFor = glbCurrentBlueCallSignOpFor + 1
	if (glbCurrentBlueCallSignOpFor > #tblBlueCallSignsOpFor) then
		glbCurrentBlueCallSignOpFor = 1
	end

	if (debugFlgOpFor == 1) then
		trigger.action.outText("SpawnOpForACGroup 5: coalition.getCountryCoalition(" .. pCountry .. "): " .. coalition.getCountryCoalition(pCountry), 30)	
	end

	if ((glbOpForSpawned + #groupData.units) <= glbMaxOpForSpawnable) then
		for i=1, #groupData.units do 
			table.insert(glbTblOpForSpawned, {gID = groupData.groupId, uID = groupData.units[i].unitId, uName = groupData.units[i].name})
		end
		return coalition.addGroup(pCountry, unitCategory, groupData)
	else
		trigger.action.outText("Cannot spawn any more OpFor aircraft, exceeds the maximum active allowed: " .. glbMaxOpForSpawnable, 10)
		trigger.action.outText("Retry after some active OpFor aircraft are destroyed or land.", 10)
		return
	end


	
	return coalition.addGroup(pCountry, unitCategory, groupData)
  
end

function AddUnitToGroupOpFor(pType, pCountry, pEngScen, pLongX1, pLattY1, pHeadingRad, pAlt1, pI)

	if (pType == nil or pCountry == nil or pEngScen == nil or pLongX1 == nil or pLattY1 == nil or 
			pHeadingRad == nil or pAlt1 == nil) then
		return
	end
	
	local unitFuel = 2000
	local unitFlares = 32
	local unitChaff = 32
	local unitLivery = ""
	local lCallSignName = ""
	
	glbOnBoardNumOpFor = glbOnBoardNumOpFor + 1

	
	if (coalition.getCountryCoalition(pCountry) == coalition.side.RED) then
		lCallSignName = tostring(glbOnBoardNumOpFor)
	elseif (coalition.getCountryCoalition(pCountry) == coalition.side.BLUE) then
		lCallSignName = tblBlueCallSignsOpFor[glbCurrentBlueCallSignOpFor] .. tostring(pI) .. "1"
	else
		lCallSignName = tostring(glbOnBoardNumOpFor)
	end	
	
	for i=1, #tblFuFlChLiPresets do 
		if (tblFuFlChLiPresets[i].ut == pType and tblFuFlChLiPresets[i].co == pCountry) then
			unitFuel = tblFuFlChLiPresets[i].fu
			unitFlares = tblFuFlChLiPresets[i].fl
			unitChaff = tblFuFlChLiPresets[i].ch
			unitLivery = tblFuFlChLiPresets[i].li
			break
		end
	end
	
	glbUnitId = glbUnitId + 1
	local lName = tostring(pType) .. "-" .. tostring(glbUnitId)
    local unit =
	{
		["alt"] = pAlt1,
		["alt_type"] = "RADIO",
		["hardpoint_racks"] = true,
		["alt_type"] = "BARO",
		["livery_id"] = unitLivery,
		["skill"] = pSkill,
		["speed"] = pSpeed,
		["AddPropAircraft"] = 
		{
		}, -- end of ["AddPropAircraft"]
		["type"] = pType,
		["unitId"] = glbUnitId,
		["psi"] = pHeadingRad*(-1),
		["y"] = pLattY1,
		["x"] = pLongX1,
		["name"] = lName,
		["payload"] = 
		{
			["pylons"] = EngagementScenarioLoadOutPresetOpFor(pType, pEngScen),
			["fuel"] = unitFuel,
			["flare"] = unitFlares,
			["chaff"] = unitChaff,
			["gun"] = 100,
		}, -- end of ["payload"]
		["heading"] = pHeadingRad,
		--["callsign"] = glbOnBoardNumOpFor,
		["callsign"] = 
		{
			[1] = pI,
			[2] = pI,
			["name"] = lCallSignName,
			[3] = 1,
		}, -- end of ["callsign"]
		["onboard_num"] = tostring(glbOnBoardNumOpFor),
    }
    return unit    
end


--[[
############################################################################################
Function:	CheckOpForUnitsLanded
Purpose:	Loops through glbTblOpForSpawned table every 120 seconds to check if spawned
			OpFor units are alive and have landed/stopped - then destroys (despawns) them;
			Also keeps track of how many OpFor AI aircraft are currently alive
Parameters:	pArgument (required, but nothing is passed)
			pTime - time to run this function in the future
Returns:	current time + 120 seconds
Author:		AKA_Relent
############################################################################################
]]
function CheckOpForUnitsLanded(pArgument, pTime)
	local tblVelVec3 = {}
	local lKnts = 0
	glbOpForSpawned = 0
	for i=1, #glbTblOpForSpawned do 
		tblVelVec3 = {}
		lKnts = 0
		--table.insert(glbTblOpForSpawned, {gID = groupData.groupId, uID = groupData.units[i].unitId, uName = groupData.units[i].name})
		if (Unit.getByName(glbTblOpForSpawned[i].uName) ~= nil) then
			tblVelVec3 = Unit.getByName(glbTblOpForSpawned[i].uName):getVelocity()
			lKnts = (math.sqrt (tblVelVec3.x^2 + tblVelVec3.y^2 + tblVelVec3.z^2)) * 1.9438
			--trigger.action.outText("CheckOpForUnitsLanded: unitId: " .. glbTblOpForSpawned[i].uID .. ", name: " .. glbTblOpForSpawned[i].uName ..
				--"Unit speed in knots: " .. lKnts, 20)
			if (Unit.getByName(glbTblOpForSpawned[i].uName):isActive() == true) then
				if (Unit.getByName(glbTblOpForSpawned[i].uName):inAir() == false and lKnts == 0) then
					Unit.getByName(glbTblOpForSpawned[i].uName):destroy()
				else
					glbOpForSpawned = glbOpForSpawned + 1
				end
			end
		end
	end
	--trigger.action.outText("glbOpForSpawned: " .. glbOpForSpawned, 10)
  return pTime + 120
end
timer.scheduleFunction(CheckOpForUnitsLanded, "", timer.getTime() + 120)


--[[
######################################### MAIN #############################################
]]

SetUpFuFlChLiPresets()
SetUpLoadOutPresets()
CheckForSinglePlayerOpFor()

trigger.action.outText(" ", 20)
trigger.action.outText("Loading OpForAC script: Opposing Force AI Aircraft script", 20)
trigger.action.outText(" ", 20)
trigger.action.outText("This script will spawn 1-4 opposing force AI aircraft (repeatable), which can be fighter,", 20)
trigger.action.outText("attack, bomber, trainer aircraft, or helicopter types.  AI aircraft types, engagement scenarios", 20)
trigger.action.outText("(i.e. BVR, ACM) and pre-set spawn distances are selectable from the F10 menu, under the F10", 20)
trigger.action.outText("menu item: '" .. glbOfacTopMenu .. "'", 20)
trigger.action.outText(" ", 20)



