dofile(LockOn_Options.script_path.."Displays/HUD/Indicator/definitions.lua")
dofile(LockOn_Options.script_path..'cockpit_cfg.lua')

local combat_Level = DEFAULT_LEVEL + 4
local combat_Noclip_Level = DEFAULT_NOCLIP_LEVEL + 4

AddBox(nil,Width,Height,nil,nil,'DBG_RED',combat_Noclip_Level,REWRITE_LEVEL,nil,nil,nil,true)
AddBox(nil,Width,Height,nil,nil,'DBG_CLEAR',combat_Noclip_Level,INCREASE_IF_LEVEL)
IS_HUD = true
local z_simple = AddSimple(nil,{0,0,-2},{0,90},nil,{'HUD_Z'},{{AnimalControllor.moveLeftRightUsingParameter,0,-0.2}})
local base_simple = AddSimple(nil,nil,{0,-90},z_simple)
-----------------------------------------------------------------
--[[【HUD 显示调试信息：本机姿态】
-----------------------------------------------------------------
AddText(nil,nil,'unicode_cn_yellow', {0, 0.4 * Height}, -- 屏幕中间偏下
    Align.CC, DEFAULT_FONT_SIZE[4], nil, combat_Level, base_simple,
    {
        '机体姿态 DEG PITCH: %.1f',' ROLL: %.1f\n',
        'HEAD_AZ: %.1f','  HEAD_EL: %.1f\n'
    },
    {
        'DEBUG_PITCH_DEG', 'DEBUG_ROLL_DEG',
        'HEAD_AZ', 'HEAD_EL',
        'DEBUG_SWITCH',
        "DEBUG_IN_HUD"
    },
    {
        {AnimalControllor.textUsingParameter, 0,0},        {AnimalControllor.textUsingParameter, 1,1},
    --	{AnimalControllor.textUsingParameter, 2,2},        {AnimalControllor.textUsingParameter, 3,3},
        {AnimalControllor.parameterCompareWithNumber, 4,1},
        {AnimalControllor.parameterCompareWithNumber, 5,1}
    }
)]]
-----------------------------------------------------------------
--[[【HUD 显示调试信息：头盔姿态】
-----------------------------------------------------------------
AddText(nil,nil,'unicode_cn_yellow', {0, -0.4 * Height}, -- 屏幕中间偏下
    Align.CC, DEFAULT_FONT_SIZE[4], nil, combat_Level, base_simple,
    {
        'DEG PITCH: %.1f',' ROLL: %.1f\n',
        'HEAD_AZ: %.1f','  HEAD_EL: %.1f\n'
    },
    {
        'DEBUG_PITCH_DEG', 'DEBUG_ROLL_DEG',
        'HEAD_AZ', 'HEAD_EL',
        'DEBUG_SWITCH',
        "DEBUG_IN_HUD"
    },
    {
    --	{AnimalControllor.textUsingParameter, 0,0},        {AnimalControllor.textUsingParameter, 1,1},
        {AnimalControllor.textUsingParameter, 2,2},        {AnimalControllor.textUsingParameter, 3,3},
        {AnimalControllor.parameterCompareWithNumber, 4,1},
        {AnimalControllor.parameterCompareWithNumber, 5,1}
    }
)]]
--------------------------------------------------------------------------------
--[[【HUD 显示调试信息：雷达模式】
-- 显示 Radar.mode_h (DEBUG_RADAR_MODE) 和param_debug_acm.status(DEBUG_ACM_STATUS)的调试数据
--------------------------------------------------------------------------------
AddText(
    nil,                                -- name
    nil,                                -- val
    'unicode_cn_yellow',                -- material
    {0, 0.85 * Height},                -- 位置（与其它显示略有偏移）
    Align.CC,                           -- 对齐方式
    DEFAULT_FONT_SIZE[4],               -- 字符串尺寸
    nil,                                -- _h_clip_relation
    combat_Level,                          -- 层级（使用 nav_level）
    base_simple,                        -- 父元素
    {                                   -- 格式化输出：拆分为2个字段，行末带换行符
        "雷达模式: %.0f",             -- 第1字段
        " ACM阶段: %d"                          -- 换行符
    },
    {                                   -- 调试参数名称数组
        "DEBUG_RADAR_MODE","DEBUG_ACM_STATUS",
        'DEBUG_SWITCH',
        "DEBUG_IN_HUD"
    },
    {                                   -- 控制映射
        {AnimalControllor.textUsingParameter, 0, 0},
	--  {AnimalControllor.textUsingParameter, 1, 1},
        {AnimalControllor.parameterCompareWithNumber, 2,1},
        {AnimalControllor.parameterCompareWithNumber, 3,1}
    }
)
AddText(
    nil,                                -- name
    nil,                                -- val
    'unicode_cn_yellow',                -- material
    {0, 0.75 * Height},                -- 位置（与其它显示略有偏移）
    Align.CC,                           -- 对齐方式
    DEFAULT_FONT_SIZE[4],               -- 字符串尺寸
    nil,                                -- _h_clip_relation
    combat_Level,                          -- 层级（使用 nav_level）
    base_simple,                        -- 父元素
    {                                   -- 格式化输出：拆分为2个字段，行末带换行符
        "雷达模式: %.0f",             -- 第1字段
        " ACM阶段: %d"                          -- 换行符
    },
    {                                   -- 调试参数名称数组
        "DEBUG_RADAR_MODE","DEBUG_ACM_STATUS",
        'DEBUG_SWITCH',
        "DEBUG_IN_HUD"
    },
    {                                   -- 控制映射
        --{AnimalControllor.textUsingParameter, 0, 0},
		{AnimalControllor.textUsingParameter, 1, 1},
        {AnimalControllor.parameterCompareWithNumber, 2,1},
        {AnimalControllor.parameterCompareWithNumber, 3,1}
    }
)]]
--------------------------------------------------------------------------------
--[[【HUD 显示调试信息: 扫描中心】
-- 调用 AddText 将调试数据以格式化方式显示到屏幕上（显示层级使用 Nav_Level）。
-- 显示格式保持原来4行输出，每行内字段按要求拆开，并在行末添加换行符 "\n"。
--------------------------------------------------------------------------------
AddText(
    nil,                                -- name
    nil,                                -- val
    'unicode_cn_yellow',                -- material
    {-0.65 * Width,0.3*Height },                -- 位置
    Align.RC,                           -- 对齐方式
    DEFAULT_FONT_SIZE[4],               -- 字符串尺寸
    nil,                                -- _h_clip_relation
    combat_Level,                          -- 层级（使用 Nav_Level）
    base_simple,                        -- 父元素
    {                                   -- 格式化输出，共4行，每行内字段拆开：
        "扫描中心: AZ=%.1fdeg", " EL=%.1fdeg\n",       -- 第1行第1字段 -- 第1行第2字段
        "ACM状态: %1.f", " | 候选数: %1.f", " | 全局计时: %.1fs\n", -- 第2行第1字段 -- 第2行第2字段 -- 第2行第3字段
        "ID: %1.f", " | 目标距离: %.1fkm\n",           -- 第3行第1字段 -- 第3行第2字段
        "目标差值: AZ=%.1fdeg", " EL=%.1fdeg\n",        -- 第4行第1字段 -- 第4行第2字段
        "扫描范围: AZ=%.1fdeg", " EL=%.1fdeg\n"       -- 第5行第1字段 -- 第5行第2字段                         
    },
    {  -- 调试参数名称数组，顺序与上面格式字段依次对应
        "DEBUG_ACM_CENTER_AZ", "DEBUG_ACM_CENTER_EL",
        "DEBUG_ACM_STATUS", "DEBUG_ACM_CANDIDATE_COUNT", "DEBUG_ACM_GLOBAL_TIMEOUT",
        "DEBUG_ACM_TARGET", "DEBUG_ACM_CHOICE_RANGE",
        "DEBUG_ACM_AZ_DIFF", "DEBUG_ACM_EL_DIFF",
        "DEBUG_ACM_MAX_SCAN_AZ", "DEBUG_ACM_MAX_SCAN_EL",
        "DEBUG_SWITCH",           -- 调试开关（用于比对或控制显示）
        "DEBUG_IN_HUD",
        "ATK_MODE",'RADAR_WORK_MODE'
    },
    {                                   -- 控制映射，将每个调试参数与显示占位符对应
        {AnimalControllor.textUsingParameter, 0, 0},
        {AnimalControllor.textUsingParameter, 1, 1},
        {AnimalControllor.textUsingParameter, 2, 2},
        {AnimalControllor.textUsingParameter, 3, 3},
        {AnimalControllor.textUsingParameter, 4, 4},
        {AnimalControllor.textUsingParameter, 5, 5},
        {AnimalControllor.textUsingParameter, 6, 6},
        {AnimalControllor.textUsingParameter, 7, 7},
        {AnimalControllor.textUsingParameter, 8, 8},
        {AnimalControllor.textUsingParameter, 9, 9},
        {AnimalControllor.textUsingParameter, 10, 10},
        {AnimalControllor.parameterCompareWithNumber, 11, 1},
        {AnimalControllor.parameterCompareWithNumber, 12, 1},
        {AnimalControllor.parameterCompareWithNumber, 13, 1},
        {AnimalControllor.parameterInRange, 14, 0.1, 5.1}
    }
)]]
-----------------------------------------------------------------
--STT
local x_scale = 1
local y_scale = 1
local boxa=0.1*Width
local boxt=0.004*Width
local stt_box=AddBoxBorder(nil,boxa,boxa,boxt,nil,nil,'DBG_RED',combat_Level,nil,base_simple,
    {
        "TARGET_BOX_DIS_ENABLE",
        "TARGET_BOX_Y",
        "TARGET_BOX_X","DEBUG_IN_HUD"
    },{
        {AnimalControllor.parameterInRange,0,0.9,1.1},
        {AnimalControllor.moveUpDownUsingParameter,1,y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,2,x_scale},
        {AnimalControllor.parameterCompareWithNumber,3,1}
    }
)
local stt_circle=AddCircle(nil,boxa,boxa-boxt,360,16,nil,nil,'DBG_RED',nil,combat_Level,base_simple,
    {
		"TARGET_BOX_DIS_ENABLE",
        "TARGET_BOX_Y",
        "TARGET_BOX_X"
	},
    {
		{AnimalControllor.parameterInRange,0,0.9,1.1},
        {AnimalControllor.moveUpDownUsingParameter,1,y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,2,x_scale}
    }
)
--STT连线
AddSimpleLine(nil,0.004*Width,{{0,0},{1,0}},nil,nil,'DBG_RED',nil,combat_Level,base_simple,
    {
		"TARGET_BOX_DIS_ENABLE",
		"TARGET_BOX_X",
		"TARGET_BOX_Y",
		"TARGET_BOX_X_2",
		"TARGET_BOX_Y_2",
        "DEBUG_IN_HUD"
	},{
        {AnimalControllor.parameterInRange,0,0.5,1.1},
        {AnimalControllor.lineObjectSetPointUsingParameters,0,1,2,x_scale,y_scale},
        {AnimalControllor.lineObjectSetPointUsingParameters,1,3,4,x_scale,y_scale},
        {AnimalControllor.parameterCompareWithNumber,5,1}
    }
)
AddText(nil,nil,'unicode_cn_red',{0,-boxa},Align.CT,DEFAULT_FONT_SIZE[2],nil,combat_Level,stt_box,
    {'%.2fKM \n',' %s'},{
        "TARGET_RANGE","TARGET_NCTR",
        "TARGET_BOX_DIS_ENABLE",
        "UNIT",
        "DEBUG_IN_HUD"
    },{
        {AnimalControllor.textUsingParameter,	0,0},{AnimalControllor.textUsingParameter,	1,1},
        {AnimalControllor.parameterInRange,		2,0.9,1.1},
        {AnimalControllor.parameterInRange,		3,-0.1,0.1},
        {AnimalControllor.parameterCompareWithNumber,	4,1}
    }
)
AddText(nil,nil,'unicode_cn_red',{1.0*Width,-0.75*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,combat_Level,base_simple,
	{'%.2fKM ',' %s'},{
		"TARGET_RANGE","TARGET_NCTR",
		"TARGET_BOX_DIS_ENABLE",
		"UNIT"
	},{
		{AnimalControllor.textUsingParameter,	0,0},{AnimalControllor.textUsingParameter,	1,1},
        {AnimalControllor.parameterInRange,		2,0.9,1.1},
        {AnimalControllor.parameterInRange,		3,-0.1,0.1}
	}
)
AddText(nil,nil,'unicode_cn_red',{0,-boxa},Align.CT,DEFAULT_FONT_SIZE[2],nil,combat_Level,stt_box,
    {'%.2fNM \n',' %s'},{
		"TARGET_RANGE_NM","TARGET_NCTR",
		"TARGET_BOX_DIS_ENABLE",
		"UNIT","DEBUG_IN_HUD"
	},{
        {AnimalControllor.textUsingParameter,	0,0},{AnimalControllor.textUsingParameter,	1,1},
        {AnimalControllor.parameterInRange,		2,0.9,1.1},
        {AnimalControllor.parameterInRange,		3,0.9,1.1},{AnimalControllor.parameterCompareWithNumber,	4,1}
	}
)
AddText(nil,nil,'unicode_cn_red',{1.0*Width,-0.75*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,combat_Level,base_simple,
	{'%.2fNM ',' %s'},{
		"TARGET_RANGE_NM","TARGET_NCTR",
		"TARGET_BOX_DIS_ENABLE",
		"UNIT"
	},{
		{AnimalControllor.textUsingParameter,	0,0},{AnimalControllor.textUsingParameter,	1,1},
        {AnimalControllor.parameterInRange,		2,0.9,1.1},
        {AnimalControllor.parameterInRange,		3,0.9,1.1}
	}
)
--IR弹
AddCircle(nil,0.3*Width,0.29*Width,360,72,nil,nil,'DBG_GREEN',nil,combat_Level,base_simple,
    {"IR_SEEK_RANGE_DIS",},{
        {AnimalControllor.parameterInRange,0,0.9,1.1}
    }
)
AddCircle(nil,0.07*Width,0.06*Width,360,36,nil,nil,'DBG_GREEN',nil,combat_Level,base_simple,
    {
        "TARGET_ROUND_DIS_ENABLE",
        "TARGET_ROUND_Y",
        "TARGET_ROUND_X"
    },{
        {AnimalControllor.parameterInRange,				0,0.9,1.1},
        {AnimalControllor.moveUpDownUsingParameter,		1,y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,	2,x_scale}
    }
)
--机炮格子
--AddTexture(nil,
--	{
--		{-0.5*Width, 0.5*Height},
--		{ 0.5*Width, 0.5*Height},
--		{ 0.5*Width,-0.5*Height},
--		{-0.5*Width,-0.5*Height}
--	},{0,1,2,2,3,0},Texure_coord_gen(0,0,1024,1024,1024,1024),MakeMaterial(GunSightMatt, {HUD_DAY_COLOR}),nil,nil,nil,combat_Level,base_simple,
--	{"GUN_GRID"},
--	{
--		{AnimalControllor.parameterInRange,0,0.9,1.1}
--	}
--)
--机炮ccip圈
AddCircle(nil,0.07*Width,0.06*Width,360,36,nil,nil,'DBG_GREEN',nil,combat_Level,base_simple,
    {
        "GUN_CCIP_DIS_ENABLE",
        "GUN_CCIP_Y",
        "GUN_CCIP_X"
    },{
        {AnimalControllor.parameterInRange,0,0.5,1.1},
        {AnimalControllor.moveUpDownUsingParameter,1,y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,2,x_scale}
    }
)
--机炮ccip连线
AddSimpleLine(nil,0.004*Width,{{0,0},{1,0}},nil,nil,'DBG_GREEN',nil,combat_Level,base_simple,
    {
        "GUN_CCIP_DIS_ENABLE",
        "GUN_CCIP_X",
        "GUN_CCIP_Y",
        "GUN_CCIP_X_2",
        "GUN_CCIP_Y_2"
    },{
        {AnimalControllor.parameterInRange,0,0.5,1.1},
        {AnimalControllor.lineObjectSetPointUsingParameters,0,1,2,x_scale,y_scale},
        {AnimalControllor.lineObjectSetPointUsingParameters,1,3,4,x_scale,y_scale}
    }
)

--ccip
AddCircle(nil,0.07*Width,0.06*Width,360,36,nil,nil,'DBG_GREEN',nil,combat_Level,base_simple,
    {
        "CCIP_DIS_ENABLE",
        "CCIP_Y",
        "CCIP_X"
    },{
        {AnimalControllor.parameterInRange,0,0.5,1.1},
        {AnimalControllor.moveUpDownUsingParameter,1,y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,2,x_scale}
    }
)
--ccip连线
AddSimpleLine(nil,0.004*Width,{{0,0},{1,0}},nil,nil,'DBG_GREEN',nil,combat_Level,base_simple,
    {
        "CCIP_DIS_ENABLE",
        "CCIP_X",
        "CCIP_Y",
        "CCIP_X_2",
        "CCIP_Y_2"
    },{
        {AnimalControllor.parameterInRange,0,0.5,1.1},
        {AnimalControllor.lineObjectSetPointUsingParameters,0,1,2,x_scale,y_scale},
        {AnimalControllor.lineObjectSetPointUsingParameters,1,3,4,x_scale,y_scale}
    }
)
--ccrp线
AddSimpleLine(nil,0.004*Width,{{0,0},{0,-1}},nil,nil,'DBG_GREEN',nil,combat_Level,base_simple,
    {
        "CCRP_DIS_ENABLE",
        "CCRP_X",
    },{
        {AnimalControllor.parameterInRange,0,0.5,1.1},
        {AnimalControllor.moveLeftRightUsingParameter,1,x_scale}
    }
)
--CCRP命中时间
AddText(nil,nil,'unicode_cn_green',nil,Align.LT,DEFAULT_FONT_SIZE[5],nil,combat_Level,base_simple,
    {'TIME:%.1f'},{
		"CCRP_DIS_ENABLE",
		"CCRP_TIME",
		'CCRP_X'
	},{
        {AnimalControllor.parameterCompareWithNumber,0,1},
        {AnimalControllor.textUsingParameter,1},
        {AnimalControllor.moveUpDownUsingParameter,1,-0.01},
        {AnimalControllor.moveLeftRightUsingParameter,2,x_scale}
    }
)
--武器名称显示
AddText(nil,nil,'unicode_cn_green',{1.0*Width , -1.05*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,combat_Level,base_simple,
    {'%s X ','%.0f'},
    {"WEAPON_NAME",'WEAPON_COUNT',"WEAPON_NAME_DIS",'ATK_MODE','GUN_MODE'},
    {
        {AnimalControllor.textUsingParameter,0,0},
        {AnimalControllor.textUsingParameter,1,1},
        {AnimalControllor.parameterInRange,2,0.5,1.1},
		{AnimalControllor.parameterInRange,3,0.9,2.1},
        {AnimalControllor.parameterCompareWithNumber,4,0}
    }
)
--右下角CCIP/CCRP状态显示
AddText(nil,'CCIP','unicode_cn_green',{1.0*Width,-0.75*Height},Align.RC,DEFAULT_FONT_SIZE[5],nil,combat_Level,base_simple,nil,
	{'CCIP_DIS_ENABLE','ATK_MODE'},{
    {AnimalControllor.parameterCompareWithNumber,0,1},
    {AnimalControllor.parameterCompareWithNumber,1,2}
})
AddText(nil,'CCRP','unicode_cn_green',{1.0*Width,-0.75*Height},Align.RC,DEFAULT_FONT_SIZE[5],nil,combat_Level,base_simple,nil,
	{'CCRP_DIS_ENABLE','ATK_MODE'},{
    {AnimalControllor.parameterCompareWithNumber,0,1},
    {AnimalControllor.parameterCompareWithNumber,1,2}
})

local radarWidth 	= Width*0.65
local radarHeight 	= Width*0.6

local localSimle = AddSimple(nil,{0,-radarWidth},nil,base_simple)
--STT 边线
AddMultiLine(nil,nil,nil,
    {
        {-radarWidth, radarHeight},
        {-radarWidth,-radarHeight},
        { radarWidth, radarHeight},
        { radarWidth,-radarHeight}
    },
    {0,1,2,3},{0,radarHeight},nil,'DBG_GREEN',nil,nil,combat_Level,localSimle,
    {'ATK_MODE','RADAR_WORK_MODE','RADAR_MODE','GUN_MODE'},
    {
        {AnimalControllor.parameterCompareWithNumber,	0,1},
        {AnimalControllor.parameterCompareWithNumber,	1,0 },
        {AnimalControllor.parameterCompareWithNumber,	3,0}
    }
)
--显示最大Range
AddText(nil,nil,'unicode_cn_green',{0.9*radarWidth,0.9*radarHeight},nil,DEFAULT_FONT_SIZE[5],nil,combat_Level,base_simple,
    {'MAX:%.0f'},
	{'MAX_RANGE','ATK_MODE','GUN_MODE'},
    {
        {AnimalControllor.textUsingParameter, 			0 },
        {AnimalControllor.parameterCompareWithNumber,	1,1 },
    	{AnimalControllor.parameterCompareWithNumber,	2,0 }
	}
)

local ud_scale 		= 0.000003200*radarHeight
local lr_scale 		= 0.085*radarWidth
local life_time 	= 2.081
local life_time_low = 0.779
--友方显示圆点，敌方显示方块，未知显示为短线
for i = 1, Targetnum, 1 do
    AddCircle(nil,0.03*radarWidth,0,360,18,nil,nil,'DBG_GREEN',nil,combat_Level,localSimle,
    {
        string.format('RADAR_CONTACT_%02d_ELEVATION',		i),	--0
        string.format('RADAR_CONTACT_%02d_AZIMUTH',		i),	--1
        string.format('RADAR_CONTACT_%02d_RANGE_SCALE',	i),	--2
        string.format('RADAR_CONTACT_%02d_TIME',			i),	--3
        string.format('RADAR_CONTACT_%02d_FRIENDLY',		i),	--4
        string.format('RADAR_CONTACT_%02d_RCS',			i),	--5
        'ATK_MODE',												--6
        'RADAR_WORK_MODE',										--7
		string.format('RADAR_CONTACT_%02d_IN_SC_LIMIT', 	i),	--8
        'GUN_MODE',												--9
    },{
        {AnimalControllor.moveLeftRightUsingParameter,  1,lr_scale},
        {AnimalControllor.moveUpDownUsingParameter,     2,ud_scale},
		{AnimalControllor.parameterInRange,             1,-math.rad(60),math.rad(60)},
		{AnimalControllor.parameterInRange,             2,5000,40000},
        {AnimalControllor.parameterInRange,             3,life_time_low,life_time},
        {AnimalControllor.parameterCompareWithNumber,   4,1},
    --  {AnimalControllor.opacityUsingParameter,        5},
        {AnimalControllor.parameterCompareWithNumber,   6,1},
    --  {AnimalControllor.parameterInRange,   			7,-0.9,5.1},
        {AnimalControllor.parameterCompareWithNumber,   8,1},
        {AnimalControllor.parameterCompareWithNumber,   9,0},
	})

	AddBox(nil,0.03*radarWidth,0.01*radarHeight,nil,nil,'DBG_RED',combat_Level,nil,localSimle,
    {
        string.format('RADAR_CONTACT_%02d_ELEVATION',		i),	--0
        string.format('RADAR_CONTACT_%02d_AZIMUTH',		i),	--1
        string.format('RADAR_CONTACT_%02d_RANGE_SCALE',	i),	--2
        string.format('RADAR_CONTACT_%02d_TIME',			i),	--3
        string.format('RADAR_CONTACT_%02d_FRIENDLY',		i),	--4
        string.format('RADAR_CONTACT_%02d_RCS',			i),	--5
        'ATK_MODE',												--6
        'RADAR_WORK_MODE',										--7
        string.format('RADAR_CONTACT_%02d_IN_SC_LIMIT', 	i),	--8
        'GUN_MODE',												--9
    },{
        {AnimalControllor.moveLeftRightUsingParameter,	1,lr_scale},
        {AnimalControllor.moveUpDownUsingParameter,		2,ud_scale},
		{AnimalControllor.parameterInRange,				1,-math.rad(60),math.rad(60)},
		{AnimalControllor.parameterInRange,				2,5000,40000},
        {AnimalControllor.parameterInRange,				3,life_time_low,life_time},
        {AnimalControllor.parameterCompareWithNumber,	4,0},
    --  {AnimalControllor.opacityUsingParameter,		5},
        {AnimalControllor.parameterCompareWithNumber,	6,1},
    --  {AnimalControllor.parameterInRange,   			7,-0.1,5.1},
        {AnimalControllor.parameterCompareWithNumber,	8,1},
        {AnimalControllor.parameterCompareWithNumber,	9,0},
    })

	AddSimpleLine(nil,0.03*radarWidth,{{-0.055*radarWidth,0},{0.055*radarWidth,0}},nil,nil,'DBG_YELLOW',nil,combat_Level,localSimle,
	{
		string.format('RADAR_CONTACT_%02d_ELEVATION',		i),	--0
        string.format('RADAR_CONTACT_%02d_AZIMUTH',		i), --1
        string.format('RADAR_CONTACT_%02d_RANGE_SCALE',	i), --2
        string.format('RADAR_CONTACT_%02d_TIME',			i), --3
        string.format('RADAR_CONTACT_%02d_FRIENDLY',		i), --4
        string.format('RADAR_CONTACT_%02d_RCS',			i), --5
        'ATK_MODE',                                             --6
        'RADAR_WORK_MODE',                                      --7
        string.format('RADAR_CONTACT_%02d_IN_SC_LIMIT', 	i),	--8
        'GUN_MODE',                                             --9
    },{
        {AnimalControllor.moveLeftRightUsingParameter,	1,lr_scale},
        {AnimalControllor.moveUpDownUsingParameter,		2,ud_scale},
		{AnimalControllor.parameterInRange,				1,-math.rad(60),math.rad(60)},
		{AnimalControllor.parameterInRange,				2,5000,40000},
        {AnimalControllor.parameterInRange,				3,life_time_low,life_time},
        {AnimalControllor.parameterCompareWithNumber,	4,-1},
    --  {AnimalControllor.opacityUsingParameter,		5},
        {AnimalControllor.parameterCompareWithNumber,	6,1},
    --  {AnimalControllor.parameterInRange,   			7,-0.1,5.1},
        {AnimalControllor.parameterCompareWithNumber,	8,1},
        {AnimalControllor.parameterCompareWithNumber,	9,0},
    })
end

--TDC on HUD
local x_size = 0.06*radarWidth
local y_size = 0.06*radarHeight

AddMultiLine(nil,1.5,nil,{{-x_size,-y_size},{-x_size,y_size},{x_size,-y_size},{x_size,y_size}},{0,1,2,3},{ 0, 0 },nil,'DBG_YELLOW',Align.CC,nil,combat_Level,localSimle,
	{
		"RADAR_TDC_RANGE_SCALE",		--0
		"RADAR_TDC_AZIMUTH_RANGE",		--1
        "RADAR_TDC_AZIMUTH",			--2
		"RADAR_MODE",					--3
        'ATK_MODE',						--4
        'RADAR_WORK_MODE',				--5
        'GUN_MODE',						--6
	},
	{
		{ AnimalControllor.moveUpDownUsingParameter, 	0, ud_scale },
		{ AnimalControllor.moveLeftRightUsingParameter, 2, lr_scale },
		{ AnimalControllor.parameterInRange, 			3, -0.1, 2.1 },
        { AnimalControllor.parameterCompareWithNumber,	4,1 },
        { AnimalControllor.parameterCompareWithNumber,	5,0 },
        { AnimalControllor.parameterCompareWithNumber,	6,0 },
	}
)
--BVR
AddText(nil,'BVR','unicode_cn_green',{1.0*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,combat_Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,0 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1 }
	}
)


--广角捕获
local apertureRadius = math.rad(5)/HUD_EL*Width
AddCircle(nil,apertureRadius,apertureRadius-0.01*Width,360,72,nil,nil,'DBG_GREEN',nil,combat_Level,base_simple,
    {
        'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
    },{
        { AnimalControllor.parameterCompareWithNumber,	0,1 },
        { AnimalControllor.parameterCompareWithNumber,	2,1 }
    }
)
AddText(nil,'广角模式','unicode_cn_green',{1.0*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,combat_Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1 }
	}
)
--孔径
apertureRadius = math.rad(1)/HUD_EL*Width
AddCircle(nil,apertureRadius,apertureRadius-0.01*Width,360,36,nil,nil,'DBG_GREEN',nil,combat_Level,base_simple,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE',"DEBUG_IN_HUD"
	},{
		{ AnimalControllor.parameterInRange,			0,2.9,3.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1 },
        { AnimalControllor.parameterCompareWithNumber,	3,1 }
	}
)
AddText(nil,'孔径','unicode_cn_green',{1.0*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,combat_Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,3 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1 }
	}
)
--长孔径
apertureRadius = math.rad(2.5)/HUD_EL*Width
AddCircle(nil,apertureRadius,apertureRadius-0.01*Width,360,36,nil,nil,'DBG_RED',nil,combat_Level,base_simple,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE',"DEBUG_IN_HUD"
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,2 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1 },
        { AnimalControllor.parameterCompareWithNumber,	3,1 }
	}
)

AddText(nil,'长孔径','unicode_cn_green',{1.0*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,combat_Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,2 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1 }
	}
)
--垂扫
apertureRadius = math.rad(2)/HUD_EL*Width
AddMultiLine(nil,nil,nil,
	{
		{-apertureRadius,Height},
		{-apertureRadius,-Height},
		{apertureRadius,Height},
		{apertureRadius,-Height}
	},{0,1,2,3},nil,nil,'DBG_GREEN',nil,nil,combat_Level,base_simple,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
		{ AnimalControllor.parameterCompareWithNumber,		0,4 },
		{ AnimalControllor.parameterCompareWithNumber,		2,1 },
	}
)

AddText(nil,'垂扫模式','unicode_cn_green',{1.0*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,combat_Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
		{ AnimalControllor.parameterCompareWithNumber,		0,4 },
		{ AnimalControllor.parameterCompareWithNumber,		2,1 },
	}
)
--平扫
apertureRadius = math.rad(5)/HUD_EL*Height

AddMultiLine(nil,nil,nil,
	{
		{-Width,apertureRadius},
		{Width,apertureRadius},
		{-Width,-apertureRadius},
		{Width,-apertureRadius}
	},{0,1,2,3},nil,nil,'DBG_GREEN',nil,nil,combat_Level,base_simple,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
		{ AnimalControllor.parameterCompareWithNumber,		0,5 },
		{ AnimalControllor.parameterCompareWithNumber,		2,1 },
	}
)

AddText(nil,'平扫模式','unicode_cn_green',{1.0*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,combat_Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
		{ AnimalControllor.parameterCompareWithNumber,		0,5 },
		{ AnimalControllor.parameterCompareWithNumber,		2,1 },
	}
)

--AG
if Type then
	--FLIR 激光指示
    AddText(nil, '激光', 'unicode_cn_green', { 1.0 * Width, -0.75 * Height }, Align.RC, DEFAULT_FONT_SIZE[5], nil,
        combat_Level, base_simple, nil,
        { 'FLIR_STATUS', 'FLIR_LASER_ON', 'FLIR_LASER_FLASH', 'ATK_MODE' }, {
            { AnimalControllor.parameterCompareWithNumber, 0, 5 },
            { AnimalControllor.parameterCompareWithNumber, 1, 1 },
            { AnimalControllor.parameterInRange,           2, 0.49, 1.01 },
            { AnimalControllor.parameterCompareWithNumber, 3, 2 }
        }
	)
    --EOTS指示符
    local eotsInd = AddSimpleLine(nil, 0.003 * Width,
		{
			{ 0,            0.04 * Height },
			{ 0.02 * Width, 0 },
			{ 0,           -0.04 * Height },
			{-0.02 * Width, 0 },
			{ 0,            0.04 * Height },
		}, nil, nil, 'DBG_RED', nil, combat_Level, base_simple,
		{ 'EOTS_HUD_X', 'EOTS_HUD_Y', 'FLIR_STATUS', 'ATK_MODE' },
        {
            { AnimalControllor.moveLeftRightUsingParameter, 0, x_scale },
            { AnimalControllor.moveUpDownUsingParameter,    1, y_scale },
            { AnimalControllor.parameterCompareWithNumber,  2, 5 },
            { AnimalControllor.parameterCompareWithNumber,  3, 2 },
        }
	)
    AddCircle(nil, 0.007 * Width, 0, 360, 18, nil, nil, 'DBG_GREEN', nil, combat_Level, eotsInd,
        { 'FLIR_STATUS', 'ATK_MODE' }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 5 },
        { AnimalControllor.parameterCompareWithNumber, 1, 2 },
    })
    local combatMskLevel = combat_Level + 2
    local combatMskNoClipLevel = combatMskLevel - 1



    --激光炮
    AddText(nil, nil, 'unicode_cn_green', { 1.0 * Width, -0.95 * Height }, Align.RC, DEFAULT_FONT_SIZE[4], nil,
        combat_Level, base_simple,
        { '%s' },
        { 'ATK_MODE', 'GUN_MODE', 'GUN_NAME' },
        {
            { AnimalControllor.parameterInRange,           0, 0.9, 2.1 },
            { AnimalControllor.parameterCompareWithNumber, 1, 1 },
            { AnimalControllor.textUsingParameter,         2 },
        }
    )
    AddMultiLine(nil, nil, nil, {
        { 0, 0.1 * Height }, { 0, 0.01 * Height },
        { 0, -0.1 * Height }, { 0, -0.01 * Height },
        { -0.1 * Width, 0 }, { -0.01 * Width, 0 },
        { 0.1 * Width, 0 }, { 0.01 * Width, 0 }
    }, { 0, 1, 2, 3, 4, 5, 6, 7 }, nil, nil, 'DBG_GREEN', nil, nil, combat_Level, base_simple, {
        'GUN_MODE', 'GUN_TYPE'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
    })
    local lsrGunInfoSimp = AddSimple(nil, nil, nil, base_simple)
    AddBox(nil, 0.025 * Width, 0.15 * Height, { -0.15 * Width, 0 }, nil, 'DBG_RED', combatMskNoClipLevel, REWRITE_LEVEL,lsrGunInfoSimp,
		{'GUN_MODE', 'GUN_TYPE'}, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
    }, true)
    AddBox(nil, 0.025 * Width, 0.15 * Height, { -0.15 * Width, 0 }, nil, 'DBG_GREEN', combatMskNoClipLevel, INCREASE_IF_LEVEL, lsrGunInfoSimp,
		{'GUN_MODE', 'GUN_TYPE'}, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
    }, true)
    AddBoxBorder(nil, 0.03 * Width, 0.155 * Height, 0.005 * Width, { -0.15 * Width, 0 }, nil, 'DBG_GREEN', combat_Level,
        nil, lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
    })
    AddBoxBorder(nil, 0.05 * Width, 0.175 * Height, 0.005 * Width, { -0.15 * Width, 0 }, nil, 'DBG_GREEN', combat_Level,
        nil, lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE', 'CURRENT_GUN_IDX'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
        { AnimalControllor.parameterCompareWithNumber, 2, 8 },
    })

    AddBox(nil, 0.025 * Width, 0.15 * Height, { -0.15 * Width, -0.3 * Height }, nil, 'DBG_GREEN', combatMskLevel, nil,
        lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE', 'LASER_GUN_CHARGE', 'LASER_GUN_CD1', 'CURRENT_GUN_IDX'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
        { AnimalControllor.parameterInRange,           2, 0, 2.11 },
        { AnimalControllor.moveUpDownUsingParameter,   2, 0.01005 },
        { AnimalControllor.parameterCompareWithNumber, 3, 0 },
        { AnimalControllor.parameterCompareWithNumber, 4, 8 },
    })
    AddBox(nil, 0.025 * Width, 0.15 * Height, { -0.15 * Width, -0.3 * Height }, nil, 'DBG_GREEN', combatMskLevel, nil,
        lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE', 'LASER_GUN_CD1'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
        { AnimalControllor.moveUpDownUsingParameter,   2, 0.01005 * 0.215 },
        { AnimalControllor.parameterInRange,           2, 0, 10.1 }

    })
    AddText(nil, nil, 'unicode_cn_green', { -0.15 * Width, -0.2 * Height }, nil, DEFAULT_FONT_SIZE[5], nil, combat_Level,
        lsrGunInfoSimp,
        { '%.0f' }, {
            'GUN_MODE', 'GUN_TYPE', 'LaserCannonAmmo_L'
        }, {
            { AnimalControllor.parameterCompareWithNumber, 0, 1 },
            { AnimalControllor.parameterCompareWithNumber, 1, 1 },
            { AnimalControllor.textUsingParameter,         2 }
        })


    AddBox(nil, 0.025 * Width, 0.15 * Height, { 0.15 * Width, 0 }, nil, 'DBG_RED', combatMskNoClipLevel, REWRITE_LEVEL,
        lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 }
    }, true)
    AddBox(nil, 0.025 * Width, 0.15 * Height, { 0.15 * Width, 0 }, nil, 'DBG_GREEN', combatMskNoClipLevel,
        INCREASE_IF_LEVEL, lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 }
    }, true)
    AddBoxBorder(nil, 0.03 * Width, 0.155 * Height, 0.005 * Width, { 0.15 * Width, 0 }, nil, 'DBG_GREEN', combat_Level,
        nil, lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 }
    })
    AddBoxBorder(nil, 0.05 * Width, 0.175 * Height, 0.005 * Width, { 0.15 * Width, 0 }, nil, 'DBG_GREEN', combat_Level,
        nil, lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE', 'CURRENT_GUN_IDX'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
        { AnimalControllor.parameterCompareWithNumber, 2, 9 }
    })

    AddBox(nil, 0.025 * Width, 0.15 * Height, { 0.15 * Width, -0.3 * Height }, nil, 'DBG_GREEN', combatMskLevel, nil,
        lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE', 'LASER_GUN_CHARGE', 'LASER_GUN_CD2', 'CURRENT_GUN_IDX'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
        { AnimalControllor.parameterInRange,           2, 0, 2.11 },
        { AnimalControllor.moveUpDownUsingParameter,   2, 0.01005 },
        { AnimalControllor.parameterCompareWithNumber, 3, 0 },
        { AnimalControllor.parameterCompareWithNumber, 4, 9 }
    })
    AddBox(nil, 0.025 * Width, 0.15 * Height, { 0.15 * Width, -0.3 * Height }, nil, 'DBG_GREEN', combatMskLevel, nil,
        lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE', 'LASER_GUN_CD2'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
        { AnimalControllor.moveUpDownUsingParameter,   2, 0.01005 * 0.215 },
        { AnimalControllor.parameterInRange,           2, 0, 10.1 }
    })
    AddText(nil, nil, 'unicode_cn_green', { 0.15 * Width, -0.2 * Height }, nil, DEFAULT_FONT_SIZE[5], nil, combat_Level,
        lsrGunInfoSimp,
        { '%.0f' }, {
            'GUN_MODE', 'GUN_TYPE', 'LaserCannonAmmo_R'
        }, {
            { AnimalControllor.parameterCompareWithNumber, 0, 1 },
            { AnimalControllor.parameterCompareWithNumber, 1, 1 },
            { AnimalControllor.textUsingParameter,         2 }
        })

    AddText(nil, nil, 'unicode_cn_green', { 1.0 * Width, -0.85 * Height }, Align.RC, DEFAULT_FONT_SIZE[4], nil,
        combat_Level, base_simple,
        { '%.0f' },
        { 'GUN_MODE', 'GUN_TYPE', 'GUN_COUNT' },
        {
            { AnimalControllor.parameterCompareWithNumber, 0, 1 },
            { AnimalControllor.parameterCompareWithNumber, 1, 0 },
            { AnimalControllor.textUsingParameter,         2 }
        }
    )
end
--------------------------------------------------------------------------------
-- 公共辅助函数
--------------------------------------------------------------------------------
--life_time 	  = 1
--life_time_low   = 0
local DmaxRange = 550 --最大范围
-- 根据目标序号 i 返回公共参数名称数组
local function GetCommonContactParams(i)
    return {
        string.format('HMD_CONTACT_%02d_Y', i),           -- [0]
        string.format('HMD_CONTACT_%02d_X', i),           -- [1]
        string.format('HMD_CONTACT_%02d_FRIENDLY', i),    -- [2]
        string.format('RADAR_CONTACT_%02d_TIME', i),      -- [3]
        'ATK_MODE',                                         -- [4]
        'RADAR_WORK_MODE',                                  -- [5]
        string.format('HMD_CONTACT_%02d_RANGE_NM', i),    -- [6]
        'DEBUG_IN_HUD'                                      -- [7]    
    }
end

-- 返回 AddBoxBorder 控制映射数组，根据 compareVal 和范围参数设置
local function CommonBoxControllers(compareVal, rangeLimit)
    return {
        {AnimalControllor.moveUpDownUsingParameter,     0, y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,  1, x_scale},
        {AnimalControllor.parameterCompareWithNumber,   2, compareVal},
        {AnimalControllor.parameterInRange,             3, life_time_low, life_time},
        {AnimalControllor.parameterCompareWithNumber,   4, 1},
        {AnimalControllor.parameterInRange,             5, -0.9, 5.1},
        {AnimalControllor.parameterInRange,             6, 0.09, rangeLimit},
        {AnimalControllor.parameterCompareWithNumber,   7, 1}
    }
end

-- 封装创建目标方块（AddBoxBorder），参数 color 例如 'DBG_RED'、'DBG_YELLOW'、'DBG_GREEN'；
-- compareVal：敌为 0，未知为 -1，友为 1；rangeLimit：DmaxRange 或 200
local function CreateContactBox(i, color, compareVal, rangeLimit)
    return AddBoxBorder(
        nil,
        0.1 * Width,
        0.1 * Width,
        0.004 * Width,
        nil,
        nil,
        color,
        combat_Level,
        nil,
        base_simple,
        GetCommonContactParams(i),
        CommonBoxControllers(compareVal, rangeLimit)
    )
end

-- 辅助函数：创建目标连线（AddSimpleLine）
-- 参数 factionVal 为 1（友方）、-1（未知）、0（敌方），决定最后 CompareWithNumber 控制器值
local function CreateContactLine(i, color, factionVal)
    local line_params = {
        string.format('HMD_CONTACT_%02d_X', i),           -- [0]
        string.format('HMD_CONTACT_%02d_Y', i),           -- [1]
        "HMD_TARGET_BOX_X_2",                               -- [2]
        "HMD_TARGET_BOX_Y_2",                               -- [3]
        "ATK_MODE",                                         -- [4]
        "RADAR_WORK_MODE",                                  -- [5]
        string.format('HMD_CONTACT_%02d_RANGE_NM', i),    -- [6]
        string.format('RADAR_CONTACT_%02d_TIME', i),      -- [7]
        string.format('HMD_CONTACT_%02d_FRIENDLY', i),    -- [8]
        "DEBUG_IN_HUD"                                      -- [9] 
    }
    local line_controllers = {
        {AnimalControllor.lineObjectSetPointUsingParameters, 0, 0, 1, x_scale, y_scale},
        {AnimalControllor.lineObjectSetPointUsingParameters, 1, 2, 3, x_scale, y_scale},
        {AnimalControllor.parameterCompareWithNumber, 4, 1},
        {AnimalControllor.parameterInRange, 5, -0.9, 5.1},
        {AnimalControllor.parameterInRange, 6, 0.09, DmaxRange},
        {AnimalControllor.parameterInRange, 7, life_time_low, life_time},
        {AnimalControllor.parameterCompareWithNumber, 8, factionVal},
        {AnimalControllor.parameterCompareWithNumber, 9, 1}
    }
    return AddSimpleLine(nil, 0.004 * Width, {{0, 0}, {1, 0}}, nil, nil, color, nil, combat_Level, base_simple, line_params, line_controllers)
end

-- 辅助函数：创建目标说明文字（AddText），用于显示目标信息（如目标编号、距离等)
-- 参数：
--    parent      : 父对象（对应各方块，如 contact_box, unknown_box, friendly_box）
--    prefix      : 字符串前缀，如 "E "、"U "、"F "
--    color       : 显示颜色，如 'unicode_cn_red'、'unicode_cn_yellow'、'unicode_cn_green'
local function CreateContactText(parent, i, prefix, color)
    -- 第一个 AddText：以公里为单位
    AddText(
        nil,
        nil,
        color,
        {0,-0.1*Height},
        Align.CT,
        DEFAULT_FONT_SIZE[5],
        nil,
        combat_Level,
        parent,
        { prefix .. "%s", " %.2fKM" },
        {
            string.format('HMD_CONTACT_%02d_NCTR', i),        --0
            string.format('HMD_CONTACT_%02d_RANGE_KM', i),    --1
            "UNIT",                                             --2
            "ATK_MODE",                                         --3
            "DEBUG_IN_HUD"                                      --4
        },
        {
            {AnimalControllor.textUsingParameter, 0, 0},
            {AnimalControllor.textUsingParameter, 1, 1},
            {AnimalControllor.parameterInRange, 1, 0.09, DmaxRange},
            {AnimalControllor.parameterInRange, 2, (color == 'unicode_cn_red' and -0.1) or -0.1, (color == 'unicode_cn_red' and 0.1) or 0.1},
            {AnimalControllor.parameterCompareWithNumber, 3, 1},
            {AnimalControllor.parameterInRange, 4, 1}
        }
    )
    -- 第二个 AddText：以海里为单位
    AddText(
        nil,
        nil,
        color,
        {0,0.1*Height},
        Align.CB,
        DEFAULT_FONT_SIZE[5],
        nil,
        combat_Level,
        parent,
        { prefix .."%1.f\n", " %s\n", " %.2fNM" },
        {
            string.format('HMD_CONTACT_%02d_ID', 		i),
            string.format('HMD_CONTACT_%02d_NCTR', i),
            string.format('HMD_CONTACT_%02d_RANGE_NM', i),
            "UNIT",
            "ATK_MODE",
            "DEBUG_IN_HUD"
        },
        {
            {AnimalControllor.textUsingParameter, 0, 0},
            {AnimalControllor.textUsingParameter, 1, 1},
            {AnimalControllor.textUsingParameter, 2, 2},
            {AnimalControllor.parameterInRange, 2, 0.09, DmaxRange},
            {AnimalControllor.parameterInRange, 3, (color == 'unicode_cn_red' and 0.9) or 0.9, (color == 'unicode_cn_red' and 1.1) or 1.1},
            {AnimalControllor.parameterCompareWithNumber, 4, 1},
            {AnimalControllor.parameterInRange, 5, 1}
        }
    )
end

--------------------------------------------------------------------------------
-- 主循环：遍历 1 至 20 的目标
--------------------------------------------------------------------------------
for i = 1, Targetnum do
    -- 创建目标方块
    local contact_box = CreateContactBox(i, 'DBG_RED', 0, DmaxRange)
    local unknown_box = CreateContactBox(i, 'DBG_YELLOW', -1, DmaxRange)
    local friendly_box = CreateContactBox(i, 'DBG_GREEN', 1, 200)

    -- 创建目标连线：分别针对敌方、未知、友方
    CreateContactLine(i, 'DBG_RED', 0)
    --CreateContactLine(i, 'DBG_YELLOW', -1)
    --CreateContactLine(i, 'DBG_GREEN', 1)

    -- 创建目标说明文字（分别依附在各目标方块上）：
    CreateContactText(contact_box, i, "E ", 'unicode_cn_red')
    CreateContactText(unknown_box, i, "U ", 'unicode_cn_yellow')
    CreateContactText(friendly_box, i, "F ", 'unicode_cn_green')
end
