dofile(LockOn_Options.script_path .. "Displays/HUD/Indicator/definitions.lua")

local Nav_Level = DEFAULT_LEVEL + 2
local Nav_Noclip_Level = DEFAULT_NOCLIP_LEVEL + 2

AddBox(nil,Width,Height,nil,nil,'DBG_RED',Nav_Noclip_Level,REWRITE_LEVEL,nil,nil,nil,true)
AddBox(nil,Width,Height,nil,nil,'DBG_CLEAR',Nav_Noclip_Level,INCREASE_IF_LEVEL)
IS_HUD = true
local z_simple = AddSimple(nil,{0,0,-2},{0,90},nil,{'HUD_Z'},{{AnimalControllor.moveLeftRightUsingParameter,0,-0.2}})
local base_simple = AddSimple(nil,nil,{0,-90},z_simple)
--左上角
--过载
AddText(nil,nil,'unicode_cn_green',{-0.85*Width,0.85*Height},Align.LC,DEFAULT_FONT_SIZE[4],nil,Nav_Level,base_simple,{'G:%.1f'},{'OVER_G'},{{AnimalControllor.textUsingParameter,0}})
--全程最大过载显示
AddText(nil,nil,'unicode_cn_green',{-0.85*Width,1.05*Height},Align.LC,DEFAULT_FONT_SIZE[4],nil,Nav_Level,base_simple,{'GM:%.0f'},{'MAX_G'},{{AnimalControllor.textUsingParameter,0}})

--攻角
AddText(nil,nil,'unicode_cn_green',{-0.95*Width,0.75*Height},Align.LC,DEFAULT_FONT_SIZE[4],nil,Nav_Level,base_simple,{'攻角:%.1f','%s'},{'AOA_DEG'},{{AnimalControllor.textUsingParameter,0}})

--左下角
--关键部件
--G3,F2,B,C
AddText(nil,nil,'unicode_cn_green',{-1.0*Width,-0.75*Height},Align.LC,DEFAULT_FONT_SIZE[3],nil,Nav_Level,base_simple,
{'%s ','%s ','%s ','%s'},
{'HUD_GEAR','HUD_FLAP','HUD_BRAKE','HUD_CHUTE'},
{
    {AnimalControllor.textUsingParameter,0,0},
    {AnimalControllor.textUsingParameter,1,1},
    {AnimalControllor.textUsingParameter,2,2},
    {AnimalControllor.textUsingParameter,3,3},
})
--转数
AddText(nil,nil,'unicode_cn_green',{-1.0*Width,-1.05*Height},Align.LC,DEFAULT_FONT_SIZE[3],nil,Nav_Level,base_simple,{'RPM:%.0f,','%.0f'},{'L_ENG_RPM','R_ENG_RPM'},{{AnimalControllor.textUsingParameter,0,0},{AnimalControllor.textUsingParameter,1,1}})

--右下角
--右下航点显示第一行
AddText(nil,nil,'unicode_cn_green',{1.0*Width,-0.75*Height},Align.RC,DEFAULT_FONT_SIZE[5],nil,Nav_Level,base_simple,
    {'%s'},
    {
        "TARGET_NAME",
        "NAV_MODE",
        'ATK_MODE',
    },{
        {AnimalControllor.textUsingParameter,0},
        {AnimalControllor.parameterCompareWithNumber,1,0.9,1.1},
        {AnimalControllor.parameterCompareWithNumber,2,0}
    }
)
--右下航点显示第二行
AddText(nil,nil,'unicode_cn_green',{1.0*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,Nav_Level,base_simple,
    {'%02.0f:','%02.0f:','%02.0f+','%.0f'},
    {
        "TARGET_ETA_HH",
        "TARGET_ETA_mm",
        "TARGET_ETA_ss",
        "TARGET_ETA_dd",
        "NAV_MODE",
        'ATK_MODE'
    },{
        {AnimalControllor.textUsingParameter,0},
        {AnimalControllor.textUsingParameter,1,1},
        {AnimalControllor.textUsingParameter,2,2},
        {AnimalControllor.textUsingParameter,3,3},
        {AnimalControllor.parameterInRange,4,0.9,1.1},
        {AnimalControllor.parameterCompareWithNumber,5,0}
    }
)
--右下航点显示第三行
AddText(nil,nil,'unicode_cn_green',{1.0*Width,-0.95*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,Nav_Level,base_simple,
    {'导航模式:%s'},
    {
        "NAV_TYPE",
        "NAV_MODE",
        'ATK_MODE'
    },{
        {AnimalControllor.textUsingParameter,0},
        {AnimalControllor.parameterInRange,1,0.9,1.1},
        {AnimalControllor.parameterCompareWithNumber,2,0}
    }
)

--姿态
AddSimpleLine(nil,0.004*Width,{{-0.1*Width,0},{0.1*Width,0}},nil,nil,'DBG_GREEN',nil,Nav_Level,base_simple,
    {'ATK_MODE'},
    {{AnimalControllor.parameterCompareWithNumber,0,0},})
local adi_rot_simple = AddSimple(nil,nil,nil,base_simple,{'EADI_ROLL'},{{AnimalControllor.rotateUsingParameter,0,1}})
local adi_mov_simple = AddSimple(nil,nil,nil,adi_rot_simple,{'EADI_PITCH'},{{AnimalControllor.moveUpDownUsingParameter,0,-0.5615}})
local simple = AddSimple(nil,nil,nil,adi_mov_simple)
--左半
--IndicatorName = 'ADI_LINE_GROUP'
AddSimpleLine(nil,0.004*Width,{{-0.55*Width,0},{-0.1*Width,0}},nil,nil,'DBG_GREEN',nil,Nav_Level,simple)
--右半
AddSimpleLine(nil,0.004*Width,{{0.55*Width,0},{0.1*Width,0}},nil,nil,'DBG_GREEN',nil,Nav_Level,simple)
AddText(nil,'0','unicode_cn_green',{-0.6*Width,0},nil,DEFAULT_FONT_SIZE[1],nil,Nav_Level,simple)
AddText(nil,'0','unicode_cn_green',{0.6*Width,0},nil,DEFAULT_FONT_SIZE[1],nil,Nav_Level,simple)
for i = 1, 18, 1 do
    --上半部分
    simple = AddSimple(nil,{0,0.7*i*Height},nil,adi_mov_simple)
    --左半
    AddSimpleLine(nil,0.004*Width,{{-0.3*Width,0.05*Height},{-0.3*Width,0},{-0.1*Width,0}},nil,nil,'DBG_GREEN',nil,Nav_Level,simple)
    --右半
    AddSimpleLine(nil,0.004*Width,{{0.3*Width,0.05*Height},{0.3*Width,0},{0.1*Width,0}},nil,nil,'DBG_GREEN',nil,Nav_Level,simple)
    AddText(nil,tostring(i*5),'unicode_cn_green',{-0.35*Width,0},nil,DEFAULT_FONT_SIZE[1],nil,Nav_Level,simple)
    AddText(nil,tostring(i*5),'unicode_cn_green',{0.35*Width,0},nil,DEFAULT_FONT_SIZE[1],nil,Nav_Level,simple)

    --下半部分
    simple = AddSimple(nil,{0,-0.7*i*Height},nil,adi_mov_simple)
    --左半
    AddSimpleLine(nil,0.004*Width,{{-0.3*Width,-0.05*Height},{-0.3*Width,0},{-0.1*Width,0}},nil,nil,'DBG_GREEN',nil,Nav_Level,simple)
    --右半
    AddSimpleLine(nil,0.004*Width,{{0.3*Width,-0.05*Height},{0.3*Width,0},{0.1*Width,0}},nil,nil,'DBG_GREEN',nil,Nav_Level,simple)
    AddText(nil,tostring(i*5),'unicode_cn_green',{-0.35*Width,0},nil,DEFAULT_FONT_SIZE[1],nil,Nav_Level,simple)
    AddText(nil,tostring(i*5),'unicode_cn_green',{0.35*Width,0},nil,DEFAULT_FONT_SIZE[1],nil,Nav_Level,simple)
end
--矢量符
local fd_simple = AddSimple(nil,nil,nil,base_simple,
    {"FD_X","FD_Y"},
    {{AnimalControllor.moveLeftRightUsingParameter,0,1},{AnimalControllor.moveUpDownUsingParameter,1,1},}
)
AddCircle(nil,0.04*Width,0.035*Width,360,36,nil,nil,'DBG_GREEN',nil,Nav_Level,fd_simple)
AddSimpleLine(nil,0.004*Width,{{0.04*Width,0},{0.08*Width,0}},nil,nil,'DBG_GREEN',nil,Nav_Level,fd_simple)
AddSimpleLine(nil,0.004*Width,{{-0.04*Width,0},{-0.08*Width,0}},nil,nil,'DBG_GREEN',nil,Nav_Level,fd_simple)
AddSimpleLine(nil,0.004*Width,{{0,0.04*Height},{0,0.08*Height}},nil,nil,'DBG_GREEN',nil,Nav_Level,fd_simple)

--IndicatorName = 'HUD'
--警告相关
--注意文字提示
--AddText(nil,'注意','unicode_cn_green',{0,-0.2*Height},nil,DEFAULT_FONT_SIZE[1],nil,nil,base_simple,nil,{'WARNING_FLASH'},{{'parameter_in_range',0,0,0.9}})
--危险文字提示
--AddText(nil,'危险','unicode_cn_green',{0,-0.2*Height},nil,DEFAULT_FONT_SIZE[1],nil,nil,base_simple,nil,{'DANGER_FLASH'},{{'parameter_in_range',0,0,0.9}})

AddCrossHair(nil,0.5*Width,0.5*Width,0.006*Width,nil,{45,0},'DBG_GREEN',nil,Nav_Level,base_simple,{'PULLUP_FLASH'},{{'parameter_in_range',0,0,1.1}})

local x_scale = 1
local y_scale = 1

--目标航路点
local targetWpt_sim = AddSimple(nil,nil,nil,base_simple,{'EADI_ROLL'},{{AnimalControllor.rotateUsingParameter,0,1}})
local targetWpt = AddCircle(nil,0.07*Width,0.06*Width,360,36,nil,nil,'DBG_GREEN',nil,Nav_Level,targetWpt_sim,
    {
        'NAV_MODE',
        'HUD_TARGET_WPT_EL',
        'HUD_TARGET_WPT_AZ',
    },{
        {AnimalControllor.parameterInRange,0,0.9,1.1},
        {AnimalControllor.moveUpDownUsingParameter,1,y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,2,x_scale},
})
AddText(nil,nil,'unicode_cn_green',{0.07*Width,-0.07*Height},Align.LT,DEFAULT_FONT_SIZE[5],nil,Nav_Level,targetWpt,
    {'%s'},
    {'TARGET_WPT_RANGE','NAV_MODE'},
    {
        {AnimalControllor.textUsingParameter,0},
        {AnimalControllor.parameterInRange,1,0,100},
})
local ils_sim = AddSimple(nil,nil,nil,fd_simple)
AddCrossHair(nil,0.15*Width,0.15*Height,0.005*Width,nil,nil,'DBG_GREEN',nil,Nav_Level,ils_sim,
    {'ILS_STATUS','ILS_IS_LOCALIZER_VALID','ILS_IS_GLIDESLOPE_VALID'},
    {
        {AnimalControllor.parameterInRange,0,0.9,1.1},
        {AnimalControllor.parameterInRange,1,0.9,1.1},
        {AnimalControllor.parameterInRange,2,0.9,1.1},
    }
)
AddSimpleLine(nil,0.0025*Width,{{-0.3*Width,0},{0.3*Width,0}},nil,nil,'DBG_GREEN',nil,Nav_Level,ils_sim,
    {'ILS_GLIDESLOPE_DEVIATION','ILS_IS_OUTER_MARKER_SIGNAL','ILS_IS_MIDDLE_MARKER_SIGNAL','ILS_IS_INNER_MARKER_SIGNAL','ILS_IS_GLIDESLOPE_VALID'},
    {
        {AnimalControllor.moveUpDownUsingParameter,0,-1},
        {AnimalControllor.changeColorWhenParameterEqualToNumber,1,1,0,1,0},
        {AnimalControllor.changeColorWhenParameterEqualToNumber,2,1,1,0.5,0},
        {AnimalControllor.changeColorWhenParameterEqualToNumber,3,1,1,0,0},
        {AnimalControllor.parameterInRange,4,0.9,1.1},
    }
)
AddSimpleLine(nil,0.0025*Width,{{0,0.3*Height},{0,-0.3*Height}},nil,nil,'DBG_GREEN',nil,Nav_Level,ils_sim,
    {'ILS_LOCALIZER_DEVIATION','ILS_IS_LOCALIZER_VALID'},
    {
        {AnimalControllor.moveLeftRightUsingParameter,0,1},
        {AnimalControllor.parameterInRange,1,0.9,1.1}
    }
)
AddCircle(nil,0.905*Width,0.895*Width,90,36,nil,{-135,0},'DBG_GREEN',nil,Nav_Level,base_simple,
{'ATK_MODE'},{
    {AnimalControllor.parameterCompareWithNumber,0,2}
})
AddSimpleLine(nil,0.005*Width,{{0,-0.855*Width},{0,-0.895*Width},},nil,{0,0},'DBG_GREEN',nil,Nav_Level,base_simple,
{'ATK_MODE'},{
    {AnimalControllor.parameterCompareWithNumber,0,2}
})
AddSimpleLine(nil,0.005*Width,{{0,-0.855*Width},{0,-0.895*Width},},nil,{45,0},'DBG_GREEN',nil,Nav_Level,base_simple,
{'ATK_MODE'},{
    {AnimalControllor.parameterCompareWithNumber,0,2}
})
AddSimpleLine(nil,0.005*Width,{{0,-0.855*Width},{0,-0.895*Width},},nil,{-45,0},'DBG_GREEN',nil,Nav_Level,base_simple,
{'ATK_MODE'},{
    {AnimalControllor.parameterCompareWithNumber,0,2}
})
AddSimpleLine(nil,0.005*Width,{{0,-0.855*Width},{0,-0.895*Width},},nil,{22.5,0},'DBG_GREEN',nil,Nav_Level,base_simple,
{'ATK_MODE'},{
    {AnimalControllor.parameterCompareWithNumber,0,2}
})
AddSimpleLine(nil,0.005*Width,{{0,-0.855*Width},{0,-0.895*Width},},nil,{-22.5,0},'DBG_GREEN',nil,Nav_Level,base_simple,
{'ATK_MODE'},{
    {AnimalControllor.parameterCompareWithNumber,0,2}
})
