dofile(LockOn_Options.script_path.."Displays/Helmet/Indicator/definitions.lua")
dofile(LockOn_Options.script_path..'cockpit_cfg.lua')
dofile(LockOn_Options.script_path.."utils.lua")
---------------------------------------------------------------------
local Nav_Level = DEFAULT_LEVEL + 2
local Nav_Noclip_Level = DEFAULT_NOCLIP_LEVEL + 2
---------------------------------------------------------------------
AddBox(nil,3*Width,3*Height,nil,nil,'DBG_RED',Nav_Noclip_Level,REWRITE_LEVEL,nil,nil,nil,true)
AddBox(nil,3*Width,3*Height,nil,nil,'DBG_CLEAR',Nav_Noclip_Level,INCREASE_IF_LEVEL)
IS_HUD = true
local base_simple = AddSimple()
IGNORE_BRT = true --使用自定义的透明度控制
---------------------------------------------------------------------
--[[【HUD 显示调试信息：本机和头盔姿态】 辅助函数：CreateHMDDebugText
-- 参数：
--   offsetY    - 水平显示元素相对于屏幕中心的垂直偏移比例（例如 0.25 表示 0.25*Height）
--   txtControllers - 控制映射数组，用于各字段的参数替换，
--                    例如第一个调用传入 { {AnimalControllor.textUsingParameter, 0, 0},
--                                              {AnimalControllor.textUsingParameter, 1, 1},
--                                              {AnimalControllor.parameterCompareWithNumber, 4, 1} }
---------------------------------------------------------------------
local function CreateHMDDebugText(offsetY, txtControllers)
    AddText(
        nil,                                   -- name
        nil,                                   -- val
        'unicode_cn_yellow',                   -- material
        { -Width, offsetY * Height },               -- 位置（以屏幕高度为参考）
        Align.RC,                              -- 对齐方式
        DEFAULT_FONT_SIZE[3],                  -- 字符串尺寸
        nil,                                   -- _h_clip_relation
        Nav_Level,                             -- 层级（使用 Nav_Level，注意大小写）
        base_simple,                           -- 父元素
        {                                      -- 格式化输出（拆分成多个字符串，每行末尾包含 "\n"）
            "机体姿态: DEG PITCH: %.1f",       -- 第一行第1字段
            " ROLL: %.1f\n",                  -- 第一行第2字段
            "HEAD_AZ: %.1f",                  -- 第二行第1字段
            "  HEAD_EL: %.1f\n"                -- 第二行第2字段
        },
        {                                      -- 参数名称数组，依次与格式化输出对应
            "DEBUG_PITCH_DEG", "DEBUG_ROLL_DEG", "HEAD_AZ", "HEAD_EL", "DEBUG_SWITCH"
        },
        txtControllers                       -- 对应的控制映射数组
    )
end

---------------------------------------------------------------------
-- 调用示例：
-- 第1组：显示在屏幕中间偏上（Y=0.25*Height），显示机体姿态的 PITCH/ROLL（取参数索引 0、1）
---------------------------------------------------------------------
CreateHMDDebugText(0.25, {
    {AnimalControllor.textUsingParameter, 0, 0},
    {AnimalControllor.textUsingParameter, 1, 1},
    {AnimalControllor.parameterCompareWithNumber, 4, 1}
})

---------------------------------------------------------------------
-- 第2组：显示在屏幕中间偏下（Y=-0.25*Height），显示 HEAD_AZ/HEAD_EL（取参数索引 2、3）
---------------------------------------------------------------------
CreateHMDDebugText(-0.25, {
    {AnimalControllor.textUsingParameter, 2, 2},
    {AnimalControllor.textUsingParameter, 3, 3},
    {AnimalControllor.parameterCompareWithNumber, 4, 1}
})
]]
-------------------------------------------------------------
--[[【HMD 显示调试信息：heading】
-- 这里根据给定案例创建一个类似于“机体姿态”显示的文本
AddText(nil, nil, 'unicode_cn_yellow', {0.5 * Width, 0.5 * Height},Align.LC, DEFAULT_FONT_SIZE[3], nil, Nav_Level, base_simple,
    {
        '目标速度: vx = %.1f m/s,', ' vy = %.1f m/s',' vz = %.1f m/s\n',
		'目标航向: head = %.1fDEG',' rel_head = %.1fDEG\n',
        '预测DEG AZ = %.2f,', ' EL = %.2f\n',
        '本机速度: Vx0 = %.1f m/s,', ' Vy0 = %.1f m/s,', ' Vz0 = %.1f m/s\n',
		'本机航向: head = %.1fDEG',' HDG = %.1fDEG\n',
        '参考系: %s'
    },
    {
        'DEBUG_TARGET_VX','DEBUG_TARGET_VY', 'DEBUG_TARGET_VZ',
		'DEBUG_TARGET_HEAD', 'DEBUG_TARGET_REL_HEAD',
        'DEBUG_PRED_AZ', 'DEBUG_PRED_EL',
        'DEBUG_SELF_VX', 'DEBUG_SELF_VY', 'DEBUG_SELF_VZ',
		'DEBUG_SELF_HEAD','HDG',
        'DEBUG_REF_MODE'
    },
    {
        {AnimalControllor.textUsingParameter, 0, 0},
        {AnimalControllor.textUsingParameter, 1, 1},
        {AnimalControllor.textUsingParameter, 2, 2},
        {AnimalControllor.textUsingParameter, 3, 3},
        {AnimalControllor.textUsingParameter, 4, 4},
        {AnimalControllor.textUsingParameter, 5, 5},
        {AnimalControllor.textUsingParameter, 6, 6},
        {AnimalControllor.textUsingParameter, 7, 7},
		{AnimalControllor.textUsingParameter, 8, 8},
		{AnimalControllor.textUsingParameter, 9, 9},
		{AnimalControllor.textUsingParameter, 10, 10},
		{AnimalControllor.textUsingParameter, 11, 11},
		{AnimalControllor.textUsingParameter, 12, 12}
    }
)]]
--------------------------------------------------------------------------------
--[[【HMD 显示调试信息：雷达模式】
-- 单独显示 Radar.mode_h 的调试数据
--------------------------------------------------------------------------------
AddText(
    nil,                                -- name
    nil,                                -- val
    'unicode_cn_yellow',                -- material
    {0, 0.8 * Height},                -- 位置（与其它显示略有偏移）
    Align.CC,                           -- 对齐方式
    DEFAULT_FONT_SIZE[5],               -- 字符串尺寸
    nil,                                -- _h_clip_relation
    Nav_Level,                          -- 层级（使用 nav_level）
    base_simple,                        -- 父元素
    {                                   -- 格式化输出：拆分为2个字段，行末带换行符
        "雷达模式: %d   ",             -- 第1字段
        "   ACM阶段: %d\n"                          -- 换行符
    },
    {                                   -- 调试参数名称数组
        "DEBUG_RADAR_MODE","DEBUG_ACM_STATUS"
    },
    {                                   -- 控制映射
        {AnimalControllor.textUsingParameter, 0, 0},
		{AnimalControllor.textUsingParameter, 1, 1}
    }
)]]
--------------------------------------------------------------------------------
--[[【HMD 显示调试信息: 扫描】
-- 调用 AddText 将调试数据以格式化方式显示到屏幕上（显示层级使用 Nav_Level）。
-- 显示格式保持原来4行输出，每行内字段按要求拆开，并在行末添加换行符 "\n"。
--------------------------------------------------------------------------------
AddText(
    nil,                                -- name
    nil,                                -- val
    'unicode_cn_yellow',                -- material
    {-0.5 * Width,0.5 * Height },                -- 位置
    Align.RC,                           -- 对齐方式
    DEFAULT_FONT_SIZE[4],               -- 字符串尺寸
    nil,                                -- _h_clip_relation
    Nav_Level,                          -- 层级（使用 Nav_Level）
    base_simple,                        -- 父元素
    {                                   -- 格式化输出，共6行，每行内字段拆开：
        "扫描中心: AZ=%.1fdeg", " EL=%.1fdeg\n",       -- 第1行第1、2字段
        "ACM状态: %1.f", " | 候选数: %1.f", " | 全局计时: %.1fs\n", -- 第2行第1、2、3字段
        "ID: %1.f", " | 目标距离: %.1fkm\n",					-- 第3行第1、2字段
		"雷达读数: AZ=%.1fdeg", " EL=%.1fdeg\n",           		-- 第4行第1、2字段
        "目标差值: AZ=%.1fdeg", " EL=%.1fdeg\n",        		-- 第5行第1、2字段
        "扫描范围: AZ=%.1fdeg", " EL=%.1fdeg\n"       			-- 第6行第1、2字段 
    },
    {                                   -- 调试参数名称数组，顺序与上面格式字段依次对应
        "DEBUG_ACM_CENTER_AZ", "DEBUG_ACM_CENTER_EL",
        "DEBUG_ACM_STATUS", "DEBUG_ACM_CANDIDATE_COUNT", "DEBUG_ACM_GLOBAL_TIMEOUT",
        "DEBUG_ACM_TARGET", "DEBUG_ACM_CHOICE_RANGE","DEBUG_ACM_TARGET_AZ","DEBUG_ACM_TARGET_EL",
        "DEBUG_ACM_AZ_DIFF", "DEBUG_ACM_EL_DIFF",
        "DEBUG_ACM_MAX_SCAN_AZ", "DEBUG_ACM_MAX_SCAN_EL",
        "DEBUG_SWITCH",           -- 调试开关（用于比对或控制显示）
        "DEBUG_IN_HUD",
        "ATK_MODE",'RADAR_WORK_MODE'
    },
    {                                   -- 控制映射，将每个调试参数与显示占位符对应
        {AnimalControllor.textUsingParameter, 0, 0},
        {AnimalControllor.textUsingParameter, 1, 1},
        {AnimalControllor.textUsingParameter, 2, 2},
        {AnimalControllor.textUsingParameter, 3, 3},
        {AnimalControllor.textUsingParameter, 4, 4},
        {AnimalControllor.textUsingParameter, 5, 5},
        {AnimalControllor.textUsingParameter, 6, 6},
        {AnimalControllor.textUsingParameter, 7, 7},
        {AnimalControllor.textUsingParameter, 8, 8},
        {AnimalControllor.textUsingParameter, 9, 9},
        {AnimalControllor.textUsingParameter, 10, 10},
		{AnimalControllor.textUsingParameter, 11, 11},
		{AnimalControllor.textUsingParameter, 12, 12},
        {AnimalControllor.parameterCompareWithNumber, 13, 1},
    --    {AnimalControllor.parameterCompareWithNumber, 14, 0},
        {AnimalControllor.parameterCompareWithNumber, 15, 1},
        {AnimalControllor.parameterInRange, 16, 0.1, 5.1}
    }
)]]
IGNORE_BRT = false

--------------------------------------------------------------------------------
--位置常驻信息类
--左上角
--全程最大过载显示
AddText(nil,nil,'unicode_cn_green',{-0.9*Width,0.95*Height},Align.LC,DEFAULT_FONT_SIZE[1],nil,Nav_Level,base_simple,{'GM:%.0f'},{'MAX_G'},{{'text_using_parameter',0}})
--过载
AddText(nil,nil,'unicode_cn_green',{-0.9*Width,0.85*Height},Align.LC,DEFAULT_FONT_SIZE[1],nil,Nav_Level,base_simple,{'G:%.1f'},{'OVER_G'},{{'text_using_parameter',0}})
--攻角
AddText(nil,nil,'unicode_cn_green',{-0.95*Width,0.75*Height},Align.LC,DEFAULT_FONT_SIZE[1],nil,Nav_Level,base_simple,{'攻角:%.1f','%s'},{'AOA_DEG'},{{'text_using_parameter',0}})
--左下角
--右上角
--显示最大Range
AddText(nil,nil,'unicode_cn_green',{0.8*Width,0.95*Height},Align.LC,DEFAULT_FONT_SIZE[1],nil,Nav_Level,base_simple,
    {'MAX:%.0f'},
	{'MAX_RANGE','ATK_MODE','GUN_MODE'},
    {
        {AnimalControllor.textUsingParameter, 			0 },
        {AnimalControllor.parameterCompareWithNumber,	1,1 },
    	{AnimalControllor.parameterCompareWithNumber,	2,0 }
	}
)
--右下角
--右下航点显示第一行
AddText(nil,nil,'unicode_cn_green',{0.65*Width,-0.75*Height},Align.LC,DEFAULT_FONT_SIZE[5],nil,Nav_Level,base_simple,
    {'%s'},
    {
        "TARGET_NAME",
        "NAV_MODE",
		"ATK_MODE"
    },
	{
        {AnimalControllor.textUsingParameter,			0},
        {AnimalControllor.parameterCompareWithNumber,	1,1},
		{AnimalControllor.parameterCompareWithNumber,	2,0}
    }
)
--右下航点显示第二行
AddText(nil,nil,'unicode_cn_green',{0.65*Width,-0.85*Height},Align.LC,DEFAULT_FONT_SIZE[4],nil,Nav_Level,base_simple,
    {'%02.0f:','%02.0f:','%02.0f+','%.0f'},
    {
        "TARGET_ETA_HH",
        "TARGET_ETA_mm",
        "TARGET_ETA_ss",
        "TARGET_ETA_dd",
        "NAV_MODE",
		"ATK_MODE"
    },
	{
        {AnimalControllor.textUsingParameter,0,0},
        {AnimalControllor.textUsingParameter,1,1},
        {AnimalControllor.textUsingParameter,2,2},
        {AnimalControllor.textUsingParameter,3,3},
        {AnimalControllor.parameterCompareWithNumber,4,1},
		{AnimalControllor.parameterCompareWithNumber,5,0}
    }
)
--右下航点显示第三行
AddText(nil,nil,'unicode_cn_green',{0.65*Width,-0.95*Height},Align.LC,DEFAULT_FONT_SIZE[4],nil,Nav_Level,base_simple,
    {'导航模式:%s'},
    {
        "NAV_TYPE",
        "ATK_MODE"
    },
	{
        {AnimalControllor.textUsingParameter,0},
        {AnimalControllor.parameterCompareWithNumber,1,0}
    }
)
-----------------------------------------------------------------
--中间的Pullup 告警
AddCrossHair(nil,0.5*Width,0.5*Width,0.006*Width,nil,{45,0},'DBG_YELLOW',nil,Nav_Level,base_simple,{'PULLUP_FLASH'},{{'parameter_in_range',0,0,1.1}})
-----------------------------------------------------------------
--武器相关
--STT
local x_scale = 1
local y_scale = 1
local boxa=0.2*Width
local boxt=0.01*Width
local stt_box=AddBoxBorder(nil,boxa,boxa,boxt,nil,nil,'DBG_RED',Nav_Level,nil,base_simple,
	{
		"TARGET_BOX_DIS_ENABLE",
		"HMD_TARGET_BOX_Y",
		"HMD_TARGET_BOX_X"
	},
	{
		{AnimalControllor.parameterInRange,0,0.9,1.1},
		{AnimalControllor.moveUpDownUsingParameter,1,y_scale},
		{AnimalControllor.moveLeftRightUsingParameter,2,x_scale}
	}
)
local stt_circle=AddCircle(nil,boxa,boxa-boxt,360,16,nil,nil,'DBG_RED',nil,Nav_Level,base_simple,
    {
		"TARGET_BOX_DIS_ENABLE",
        "HMD_TARGET_BOX_Y",
        "HMD_TARGET_BOX_X"
	},
    {
		{AnimalControllor.parameterInRange,0,0.9,1.1},
        {AnimalControllor.moveUpDownUsingParameter,1,y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,2,x_scale}
    }
)
--STT连线
AddSimpleLine(nil,0.004*Width,{{0,0},{1,0}},nil,nil,'DBG_RED',nil,Nav_Level,base_simple,
    {
		"TARGET_BOX_DIS_ENABLE",
		"HMD_TARGET_BOX_X",
		"HMD_TARGET_BOX_Y",
		"HMD_TARGET_BOX_X_2",
		"HMD_TARGET_BOX_Y_2"
	},
    {
        {AnimalControllor.parameterInRange,0,0.5,1.1},
        {AnimalControllor.lineObjectSetPointUsingParameters,0,1,2,x_scale,y_scale},
        {AnimalControllor.lineObjectSetPointUsingParameters,1,3,4,x_scale,y_scale}
    }
)
---------------------------------------------------------------------
-- 辅助函数：CreateTargetRangeText
-- 用于创建显示目标距离的文本元素。
-- 参数说明：
--   pos           - 显示位置（数组形式，例如 {-boxa, 0} 或 {0.65*Width, 0}）
--   parent        - 父元素（例如 stt_box 或 base_simple）
--   fmtStr        - 格式化字符串（例如 '%.2fKM' 或 '%.2fNM'）
--   rangeParam    - 目标距离参数名称（例如 "TARGET_RANGE" 或 "TARGET_RANGE_NM"）
--   mappingRange2 - 对应第三个参数的区间设置（数组形式，例如 {-0.1, 0.1} 对 KM，{0.9, 1.1} 对 NM）
---------------------------------------------------------------------
local function CreateTargetRangeText(pos, parent, fmtStr, rangeParam, mappingRange2)
    AddText(
        nil,                -- name
        nil,                -- val
        'unicode_cn_red',   -- material
        pos,                -- 显示位置
        Align.CB,           -- 对齐方式：居中底部对齐
        DEFAULT_FONT_SIZE[1],  -- 字符串尺寸
        nil,                -- _h_clip_relation
        Nav_Level,          -- 层级（注意 Nav_Level 大小写）
        parent,             -- 父元素
        { fmtStr,' %s' },         -- 格式化输出数组（仅一项）
        {
            rangeParam, "TARGET_NCTR",            -- 第1项：目标距离（KM 或 NM）
            "TARGET_BOX_DIS_ENABLE",-- 第2项
            "UNIT"                  -- 第3项
        },
        {
            {AnimalControllor.textUsingParameter,  0,0},{AnimalControllor.textUsingParameter,	1,1},
            {AnimalControllor.parameterInRange, 2, 0.9, 1.1},
            {AnimalControllor.parameterInRange, 3, mappingRange2[1], mappingRange2[2]}
        }
    )
end

---------------------------------------------------------------------
-- 调用示例
-- 左侧区域，父元素为 stt_box
---------------------------------------------------------------------
CreateTargetRangeText({0,boxa}, stt_box, '%.2fKM', "TARGET_RANGE", 	{-0.1, 0.1})
CreateTargetRangeText({0,boxa}, stt_box, '%.2fNM', "TARGET_RANGE_NM", {0.9, 1.1})

---------------------------------------------------------------------
-- 右侧区域，父元素为 base_simple
---------------------------------------------------------------------
CreateTargetRangeText({0, -0.4*Height}, base_simple, '%.2fKM', "TARGET_RANGE", 	{-0.1, 0.1})
CreateTargetRangeText({0, -0.4*Height}, base_simple, '%.2fNM', "TARGET_RANGE_NM", {0.9, 1.1})


--IR弹
AddCircle(nil,0.3*Width,0.29*Width,360,72,nil,nil,'DBG_GREEN',nil,Nav_Level,base_simple,
	{"IR_SEEK_RANGE_DIS"},
    {
        {AnimalControllor.parameterCompareWithNumber,0,1}
    }
)
AddCircle(nil,0.15*Width,0.14*Width,360,36,nil,nil,'DBG_GREEN',nil,Nav_Level,base_simple,
    {
        "HMD_TARGET_ROUND_DIS_ENABLE",
        "HMD_TARGET_ROUND_Y",
        "HMD_TARGET_ROUND_X"
    },
    {
        {AnimalControllor.parameterCompareWithNumber,0,1},
        {AnimalControllor.moveUpDownUsingParameter,1,y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,2,x_scale}
    }
)
AddCrossHair(nil,0.35*Width,0.35*Height,0.01*Width,nil,{45,0},'DBG_YELLOW',nil,Nav_Level,base_simple,
    {'IR_SEEK_RANGE_DIS','IR_SEEK_LIMIT'},
    {
        {AnimalControllor.parameterCompareWithNumber,0,1},
        {AnimalControllor.parameterCompareWithNumber,1,1}
    }
)
--武器信息
AddText(nil,nil,'unicode_cn_hud',{0 , -0.5*Height},nil,DEFAULT_FONT_SIZE[1],nil,Nav_Level,base_simple,
    {'%s X ','%.0f'},
    {
		"WEAPON_NAME",
		'WEAPON_COUNT',
		"WEAPON_NAME_DIS",
		'ATK_MODE',
		'GUN_MODE'
	},
    {
        {AnimalControllor.textUsingParameter,0,0},
        {AnimalControllor.textUsingParameter,1,1},
        {AnimalControllor.parameterInRange,2,0.5,1.1},
		{AnimalControllor.parameterInRange,3,0.9,2.1},
        {AnimalControllor.parameterCompareWithNumber,4,0}
    }
)

AddText(nil,nil,'unicode_cn_hud',{0 , -0.5*Height},nil,DEFAULT_FONT_SIZE[1],nil,Nav_Level,base_simple,
    {'%s X ','%.0f'},
    {
		"GUN_NAME",
		'GUN_COUNT',
		'ATK_MODE',
		'GUN_MODE'
	},
    {
        {AnimalControllor.textUsingParameter,0,0},
        {AnimalControllor.textUsingParameter,1,1},
		{AnimalControllor.parameterInRange,2,0.9,2.1},
        {AnimalControllor.parameterCompareWithNumber,3,1}
    }
)
--目标航路点
local targetWpt_sim = AddSimple(nil,nil,nil,base_simple,{'EADI_ROLL'},{{AnimalControllor.rotateUsingParameter,0,0}})
local targetWpt = AddCircle(nil,0.07*Width,0.06*Width,360,36,nil,nil,'DBG_GREEN',nil,Nav_Level,targetWpt_sim,
	{'NAV_MODE','HMD_TARGET_WPT_EL','HMD_TARGET_WPT_AZ','ATK_MODE'},
	{
		{AnimalControllor.parameterCompareWithNumber,0,1},
		{AnimalControllor.moveUpDownUsingParameter,1,y_scale},
		{AnimalControllor.moveLeftRightUsingParameter,2,x_scale},
		{AnimalControllor.parameterCompareWithNumber,3,0}
	}
)
AddText(nil,nil,'unicode_cn_green',{0.07*Width,-0.07*Height},Align.LT,DEFAULT_FONT_SIZE[3],nil,Nav_Level,targetWpt,
	{'%s'},
	{'TARGET_WPT_RANGE','NAV_MODE','ATK_MODE'},
	{
		{AnimalControllor.textUsingParameter,0},
		{AnimalControllor.parameterCompareWithNumber,1,1},
		{AnimalControllor.parameterCompareWithNumber,2,0}
	}
)
AddText(nil,nil,'unicode_cn_green',{-0.07*Width,-0.07*Height},Align.RT,DEFAULT_FONT_SIZE[3],nil,Nav_Level,targetWpt,
	{'%s'},
	{'TARGET_NAME','NAV_MODE','ATK_MODE'},
	{
		{AnimalControllor.textUsingParameter,0},
		{AnimalControllor.parameterCompareWithNumber,1,1},
		{AnimalControllor.parameterCompareWithNumber,2,0}
	}
)

--孔径
apertureRadius = math.rad(1)/HUD_EL*Width
AddCircle(nil,apertureRadius,apertureRadius-0.01*Width,360,36,nil,nil,'DBG_GREEN',nil,Nav_Level,base_simple,
	{'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE','HELMET_IN_RADAR_SCAN'},
	{
		{ AnimalControllor.parameterInRange, 			0,  2.9, 3.1 },
		--{ AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,	1 },
		{ AnimalControllor.parameterCompareWithNumber,	3,	1 }
	}
)
AddText(nil,'孔径','unicode_cn_green',{0.08*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[1],nil,Nav_Level,base_simple,
	nil,
	{'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE','HELMET_IN_RADAR_SCAN'},
	{
		{ AnimalControllor.parameterInRange,			0,	2.9,3.1 },
		--{ AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,	1 },
		{ AnimalControllor.parameterCompareWithNumber,	3,	1 }
	}
)
--长孔径
apertureRadius = math.rad(2.5)/HUD_EL*Width
AddCircle(nil,apertureRadius,apertureRadius-0.01*Width,360,36,nil,nil,'DBG_RED',nil,Nav_Level,base_simple,
	{'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE','HELMET_IN_RADAR_SCAN'},
	{
		{ AnimalControllor.parameterInRange,			0,  1.9, 2.1 },
		--{ AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,	1 },
		{ AnimalControllor.parameterCompareWithNumber,	3,	1 }
	}
)

AddText(nil,'长孔径','unicode_cn_green',{0.08*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[1],nil,Nav_Level,base_simple,
	nil,
	{'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE','HELMET_IN_RADAR_SCAN'},
	{
		{ AnimalControllor.parameterInRange,			0,  1.9, 2.1 },
		--{ AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,  1 },
		{ AnimalControllor.parameterCompareWithNumber,	3,  1 }
	}
)

local life_time 	= 2.081 --2.1
local life_time_low = 0.779 --0.1
local DmaxRange 	= 550 	--最大范围

--雷达扫描目标
--敌方红色方块，未知黄色，友方绿色
for i = 1, Targetnum do
	--敌方目标红色方块
	local contact_box=AddBoxBorder(nil,0.1*Width,0.1*Width,0.004*Width,nil,nil,'DBG_RED',Nav_Level,nil,base_simple,
		{
			string.format('HMD_CONTACT_%02d_Y', 			i), --0
			string.format('HMD_CONTACT_%02d_X', 			i), --1
			string.format('HMD_CONTACT_%02d_FRIENDLY', 	i), --2
			string.format('HMD_CONTACT_%02d_TIME', 		i), --3
			'ATK_MODE',											--4
			'RADAR_WORK_MODE',	 								--5
			string.format('HMD_CONTACT_%02d_RANGE_NM', 	i), --6
			string.format('HMD_CONTACT_%02d_TIME_SCALE', i) --7
		},
		{
			{AnimalControllor.moveUpDownUsingParameter,		0,y_scale},
			{AnimalControllor.moveLeftRightUsingParameter,	1,x_scale},
			{AnimalControllor.parameterCompareWithNumber,	2,0},
			{AnimalControllor.parameterInRange,				3,life_time_low,life_time},
			{AnimalControllor.parameterCompareWithNumber,	4,1},
			{AnimalControllor.parameterInRange,   			5,-0.9,5.1},
			{AnimalControllor.parameterInRange,				6,0.09,DmaxRange},
			{AnimalControllor.opacityUsingParameter,        7}
		}
	)
	--未知目标黄色方块
	local unknown_box=AddBoxBorder(nil,0.1*Width,0.1*Width,0.004*Width,nil,nil,'DBG_YELLOW',Nav_Level,nil,base_simple,
		{
			string.format('HMD_CONTACT_%02d_Y', 			i), --0
			string.format('HMD_CONTACT_%02d_X', 			i), --1
			string.format('HMD_CONTACT_%02d_FRIENDLY', 	i), --2
			string.format('HMD_CONTACT_%02d_TIME', 		i), --3
			'ATK_MODE',											--4
			'RADAR_WORK_MODE',	 								--5
			string.format('HMD_CONTACT_%02d_RANGE_NM', 	i), --6
			string.format('HMD_CONTACT_%02d_TIME_SCALE', i) --7
		},
		{
			{AnimalControllor.moveUpDownUsingParameter,		0,y_scale},
			{AnimalControllor.moveLeftRightUsingParameter,	1,x_scale},
			{AnimalControllor.parameterCompareWithNumber,	2,-1},
			{AnimalControllor.parameterInRange,				3,life_time_low,life_time},
			{AnimalControllor.parameterCompareWithNumber,	4,1},
			{AnimalControllor.parameterInRange,   			5,-0.9,5.1},
			{AnimalControllor.parameterInRange,				6,0.09,DmaxRange},
			{AnimalControllor.opacityUsingParameter,        7}
		}
	)
	--友方绿色方块
	local friendly_box=AddBoxBorder(nil,0.1*Width,0.1*Width,0.004*Width,nil,nil,'DBG_GREEN',Nav_Level,nil,base_simple,
		{
			string.format('HMD_CONTACT_%02d_Y', 			i), --0
			string.format('HMD_CONTACT_%02d_X', 			i), --1
			string.format('HMD_CONTACT_%02d_FRIENDLY', 	i), --2
			string.format('HMD_CONTACT_%02d_TIME', 		i), --3
			'ATK_MODE',											--4
			'RADAR_WORK_MODE',	 								--5
			string.format('HMD_CONTACT_%02d_RANGE_NM', 	i), --6
			string.format('HMD_CONTACT_%02d_TIME_SCALE', i) --7
		},
		{
			{AnimalControllor.moveUpDownUsingParameter,		0,y_scale},
			{AnimalControllor.moveLeftRightUsingParameter,	1,x_scale},
			{AnimalControllor.parameterCompareWithNumber,	2,1},
			{AnimalControllor.parameterInRange,				3,life_time_low,life_time},
			{AnimalControllor.parameterCompareWithNumber,	4,1},
			{AnimalControllor.parameterInRange,   			5,-0.9,5.1},
			{AnimalControllor.parameterInRange,				6,0.09,200},
			{AnimalControllor.opacityUsingParameter,        7}
		}
	)
	--雷达扫描目标连线，绿色友方，黄色未知，红色敌方
	--[[AddSimpleLine(nil,0.004*Width,{{0,0},{1,0}},nil,nil,'DBG_GREEN',nil,Nav_Level,base_simple,
    	{
			string.format('HMD_CONTACT_%02d_X', 			i), --0
			string.format('HMD_CONTACT_%02d_Y', 			i), --1
			"HMD_TARGET_BOX_X_2",								--2
			"HMD_TARGET_BOX_Y_2",								--3
			'ATK_MODE',											--4
			'RADAR_WORK_MODE',									--5
			string.format('HMD_CONTACT_%02d_RANGE_NM', 	i), --6
			string.format('HMD_CONTACT_%02d_TIME', 		i), --7
			string.format('HMD_CONTACT_%02d_FRIENDLY', 	i), --8
			string.format('HMD_CONTACT_%02d_TIME_SCALE', i) --9
		},
    	{
    	    {AnimalControllor.lineObjectSetPointUsingParameters,0,0,1,x_scale,y_scale},
    	    {AnimalControllor.lineObjectSetPointUsingParameters,1,2,3,x_scale,y_scale},
			{AnimalControllor.parameterCompareWithNumber,	4,1},
			{AnimalControllor.parameterInRange,   			5,-0.9,4.1},
			{AnimalControllor.parameterInRange,				6,0.09,DmaxRange},
			{AnimalControllor.parameterInRange,				7,life_time_low,life_time},
			{AnimalControllor.parameterCompareWithNumber,	8,1},
			{AnimalControllor.opacityUsingParameter,		9}
    	}
	)]]
	--[[AddSimpleLine(nil,0.004*Width,{{0,0},{1,0}},nil,nil,'DBG_YELLOW',nil,Nav_Level,base_simple,
    	{
			string.format('HMD_CONTACT_%02d_X', 			i), --0
			string.format('HMD_CONTACT_%02d_Y', 			i), --1
			"HMD_TARGET_BOX_X_2",								--2
			"HMD_TARGET_BOX_Y_2",								--3
			'ATK_MODE',											--4
			'RADAR_WORK_MODE',									--5
			string.format('HMD_CONTACT_%02d_RANGE_NM', 	i), --6
			string.format('HMD_CONTACT_%02d_TIME', 		i), --7
			string.format('HMD_CONTACT_%02d_FRIENDLY', 	i), --8
			string.format('HMD_CONTACT_%02d_TIME_SCALE', i) --9
		},
    	{
    	    {AnimalControllor.lineObjectSetPointUsingParameters,0,0,1,x_scale,y_scale},
    	    {AnimalControllor.lineObjectSetPointUsingParameters,1,2,3,x_scale,y_scale},
			{AnimalControllor.parameterCompareWithNumber,	4,1},
			{AnimalControllor.parameterInRange,   			5,-0.9,4.1},
			{AnimalControllor.parameterInRange,				6,0.09,DmaxRange},
			{AnimalControllor.parameterInRange,				7,life_time_low,life_time},
			{AnimalControllor.parameterCompareWithNumber,	8,-1},
			{AnimalControllor.opacityUsingParameter,		9}
    	}
	)]]
	AddSimpleLine(nil,0.004*Width,{{0,0},{1,0}},nil,nil,'DBG_RED',nil,Nav_Level,base_simple,
    	{
			string.format('HMD_CONTACT_%02d_X', 			i), --0
			string.format('HMD_CONTACT_%02d_Y', 			i), --1
			"HMD_TARGET_BOX_X_2",								--2
			"HMD_TARGET_BOX_Y_2",								--3
			'ATK_MODE',											--4
			'RADAR_WORK_MODE',									--5
			string.format('HMD_CONTACT_%02d_RANGE_NM', 	i), --6
			string.format('HMD_CONTACT_%02d_TIME', 		i), --7
			string.format('HMD_CONTACT_%02d_FRIENDLY', 	i), --8
			string.format('HMD_CONTACT_%02d_TIME_SCALE', i) --9
		},
    	{
    	    {AnimalControllor.lineObjectSetPointUsingParameters,0,0,1,x_scale,y_scale},
    	    {AnimalControllor.lineObjectSetPointUsingParameters,1,2,3,x_scale,y_scale},
			{AnimalControllor.parameterCompareWithNumber,	4,1},
		--	{AnimalControllor.parameterInRange,   			5,-0.9,5.1},
			{AnimalControllor.parameterInRange,				6,0.09,DmaxRange},
			{AnimalControllor.parameterInRange,				7,life_time_low,life_time},
			{AnimalControllor.parameterCompareWithNumber,	8,0},
			{AnimalControllor.opacityUsingParameter,		9}
    	}
	)

	AddText(nil,nil,'unicode_cn_red',{0,-0.1*Height},Align.CT,DEFAULT_FONT_SIZE[1],nil,Nav_Level,contact_box,
		{'E%1.f\n',' %s\n',' %.2fKM'},
		{
			string.format('HMD_CONTACT_%02d_ID', 		i),
            string.format('HMD_CONTACT_%02d_NCTR', 		i),
			string.format('HMD_CONTACT_%02d_RANGE_KM', 	i),
			"UNIT",
			'ATK_MODE'
		},
		{
			{AnimalControllor.textUsingParameter,			0,0},
			{AnimalControllor.textUsingParameter,			1,1},
            {AnimalControllor.textUsingParameter,			2,2},
			{AnimalControllor.parameterCompareWithNumber,	3,0},
			{AnimalControllor.parameterCompareWithNumber,	4,1},
			{AnimalControllor.parameterInRange,				2,0.09,DmaxRange}
		}
	)
	AddText(nil,nil,'unicode_cn_red',{0,0.1*Height},Align.CB,DEFAULT_FONT_SIZE[1],nil,Nav_Level,contact_box,
		{'E%1.f\n',' %s\n',' %.2fNM'},
		{
			string.format('HMD_CONTACT_%02d_ID', 		i),
            string.format('HMD_CONTACT_%02d_NCTR', 		i),
			string.format('HMD_CONTACT_%02d_RANGE_NM', 	i),
			"UNIT",
			'ATK_MODE'
		},
		{
			{AnimalControllor.textUsingParameter,			0,0},
			{AnimalControllor.textUsingParameter,			1,1},
            {AnimalControllor.textUsingParameter,			2,2},
			{AnimalControllor.parameterCompareWithNumber,	3,1},
			{AnimalControllor.parameterCompareWithNumber,	4,1},
			{AnimalControllor.parameterInRange,				2,0.09,DmaxRange}
		}
	)
	AddText(nil,nil,'unicode_cn_yellow',{0,-0.1*Height},Align.CT,DEFAULT_FONT_SIZE[1],nil,Nav_Level,unknown_box,
		{'U %s',' %.2fKM'},
		{
			string.format('HMD_CONTACT_%02d_NCTR', 		i),
			string.format('HMD_CONTACT_%02d_RANGE_KM', 	i),
			"UNIT",
			'ATK_MODE'
		},
		{
			{AnimalControllor.textUsingParameter,			0,0},
			{AnimalControllor.textUsingParameter,			1,1},
			{AnimalControllor.parameterInRange,				2,-0.1,0.1},
			{AnimalControllor.parameterCompareWithNumber,	3,1},
			{AnimalControllor.parameterInRange,				1,0.09,DmaxRange}
		}
	)
	AddText(nil,nil,'unicode_cn_yellow',{0,-0.1*Height},Align.CT,DEFAULT_FONT_SIZE[1],nil,Nav_Level,unknown_box,
		{'U %s',' %.2fNM'},
		{
			string.format('HMD_CONTACT_%02d_NCTR', 		i),
			string.format('HMD_CONTACT_%02d_RANGE_NM', 	i),
			"UNIT",
			'ATK_MODE'
		},
		{
			{AnimalControllor.textUsingParameter,			0,0},
			{AnimalControllor.textUsingParameter,			1,1},
			{AnimalControllor.parameterInRange,				2,0.9,1.1},
			{AnimalControllor.parameterCompareWithNumber,	3,1},
			{AnimalControllor.parameterInRange,				1,0.09,DmaxRange}
		}
	)
	--[[AddText(nil,nil,'unicode_cn_green',{0,-0.1*Height},Align.CT,DEFAULT_FONT_SIZE[1],nil,Nav_Level,friendly_box,
		{'F %s',' %.2fKM'},
		{
			string.format('HMD_CONTACT_%02d_NCTR', 		i),
			string.format('HMD_CONTACT_%02d_RANGE_KM', 	i),
			"UNIT",
			'ATK_MODE'
		},
		{
			{AnimalControllor.textUsingParameter,			0,0},
			{AnimalControllor.textUsingParameter,			1,1},
			{AnimalControllor.parameterInRange,				1,0.09,DmaxRange},
			{AnimalControllor.parameterInRange,				2,-0.1,0.1},
			{AnimalControllor.parameterCompareWithNumber,	3,1}
		}
	)]]
	--[[AddText(nil,nil,'unicode_cn_green',{0,-0.1*Height},Align.CT,DEFAULT_FONT_SIZE[1],nil,Nav_Level,friendly_box,
		{'F %s',' %.2fNM'},
		{
			string.format('HMD_CONTACT_%02d_NCTR', 		i),
			string.format('HMD_CONTACT_%02d_RANGE_NM', 	i),
			"UNIT",
			'ATK_MODE'
		},
		{
			{AnimalControllor.textUsingParameter,			0,0},
			{AnimalControllor.textUsingParameter,			1,1},
			{AnimalControllor.parameterInRange,				1,0.09,DmaxRange},
			{AnimalControllor.parameterInRange,				2,0.9,1.1},
			{AnimalControllor.parameterCompareWithNumber,	3,1}
		}
	)]]
end
--===============================
-- 雷达聚类目标显示模块（蓝色显示）
--===============================
-- 此处循环建立显示对象。循环次数可以使用 Targetnum 或者聚类目标数量（例如 clusterTargetCount）
--life_time       = 2.081
life_time_low   = 0.1
for i = 1, Targetnum do
    -- 1. 用蓝色方块标识聚类目标位置
    local cluster_box = AddBoxBorder(
        nil,                                -- name
        0.05 * Width,                        -- 方块宽度
        0.05 * Width,                        -- 方块高度
        0.004 * Width,                      -- 边框厚度
        nil, nil,
        'DBG_BLUE',                         -- 材质使用蓝色（DBG_BLUE）
        Nav_Level,                          -- 层级
        nil,
        base_simple,                        -- 父元素
        {
            string.format('HMD_CLUSTER_TARGET_%02d_Y', i),          --0 用于获取Y坐标的参数名称
            string.format('HMD_CLUSTER_TARGET_%02d_X', i),          --1 用于获取X坐标的参数名称
            string.format('HMD_CLUSTER_TARGET_%02d_FRIENDLY', i),   --2 获取IFF属性
            string.format('HMD_CLUSTER_TARGET_%02d_TIME', i),       --3 时间参数（同扫描目标类似）
            'ATK_MODE',                                             --4 攻击模式参数（直接传字符串即可）
            'RADAR_WORK_MODE',                                      --5 雷达工作模式参数
            string.format('HMD_CLUSTER_TARGET_%02d_RANGE_KM', i),   --6 范围（海里，参考原显示）
            string.format('RADAR_CONTACT_%02d_TIME_SCALE', i)       --7 时间缩放参数
        },
        {
            {AnimalControllor.moveUpDownUsingParameter,         0, y_scale},
            {AnimalControllor.moveLeftRightUsingParameter,      1, x_scale},
            {AnimalControllor.parameterCompareWithNumber,       2, 0},
            {AnimalControllor.parameterInRange,                 3, life_time_low, life_time},
            {AnimalControllor.parameterCompareWithNumber,       4, 1},
            {AnimalControllor.parameterInRange,                 5, -0.9, 5.1}, -- 如有需要可添加
            {AnimalControllor.parameterInRange,                 6, 0.09, DmaxRange},
            {AnimalControllor.opacityUsingParameter,            7}
        }
    )

    -- 2. 用蓝色连线指示该蓝色方块位置，连线通常提示与前一目标盒（或一个固定点）的连线
    -- 此处连线的控制逻辑与参考类似，只是颜色改为 DBG_BLUE
    AddSimpleLine(
        nil,
        0.004 * Width,
        {{0,0}, {1,0}},
        nil, nil,
        'DBG_BLUE',                         -- 连线材质用蓝色
        nil,
        Nav_Level,
        base_simple,
        {
            string.format('HMD_CLUSTER_TARGET_%02d_X', i),          --0 用于连线的目标 X 坐标参数
            string.format('HMD_CLUSTER_TARGET_%02d_Y', i),          --1 用于连线的目标 Y 坐标参数
            "HMD_TARGET_BOX_X_2",                                   --2 预定义的连线起点X坐标（由 Radar_init.lua 中更新）
            "HMD_TARGET_BOX_Y_2",                                   --3 连线起点Y坐标
            'ATK_MODE',                                             --4
            'RADAR_WORK_MODE',                                      --5
            string.format('HMD_CLUSTER_TARGET_%02d_RANGE_NM', i),   --6 连线中可用范围参数
        },
        {
            {AnimalControllor.lineObjectSetPointUsingParameters,    0, 0, 1, x_scale, y_scale},
            {AnimalControllor.lineObjectSetPointUsingParameters,    1, 2, 3, x_scale, y_scale},
            {AnimalControllor.parameterCompareWithNumber,           4, 1},
            {AnimalControllor.parameterInRange,                     5, -0.9, 5.1},
            {AnimalControllor.parameterInRange,                     6, 0.09, DmaxRange},
        }
    )

    -- 3. 在蓝色方块上附着文字信息，显示聚类目标的 id、range（单位 km）和 NCTR
    AddText(
        nil,
        nil,
        'unicode_cn_blue',                  -- 使用蓝色文字（unicode_cn_blue）
        {0, -0.1 * Height},                 -- 文字显示的位置，相对于方块，可根据需求调整
        Align.CT,                           -- 中间对齐
        DEFAULT_FONT_SIZE[1],               -- 字体大小
        nil,
        Nav_Level,
        cluster_box,                        -- 将文字依附于 blue 方块
        {
            "%1.f\n", "%.2fKM\n", "%s\n"
        },
        {
            string.format("HMD_CLUSTER_TARGET_%02d_ID", i),       -- 聚类目标的 ID 参数
            string.format("HMD_CLUSTER_TARGET_%02d_RANGE_KM", i),   -- 聚类目标的距离，单位 km
            string.format("HMD_CLUSTER_TARGET_%02d_NCTR", i)        -- 聚类目标的 NCTR 参数
        },
        {
            {AnimalControllor.textUsingParameter, 0, 0},
            {AnimalControllor.textUsingParameter, 1, 1},
            {AnimalControllor.textUsingParameter, 2, 2}
        }
    )
end

--[[ 4. 显示聚类调试信息：输出聚类目标数量和最新目标时间

AddText(
    nil,
    nil,
    'unicode_cn_yellow',
    {1*Width, 1*Height},
    Align.LC,
    DEFAULT_FONT_SIZE[2],
    nil,
    Nav_Level,
    base_simple,
    {
       "Radar Target Count: %1.f\n", "Cluster Count: %1.f", " | Latest Time: %.1f\n"
    },
    {
        "RADAR_TARGET_COUNT","DEBUG_CLUSTER_COUNT", "DEBUG_CLUSTER_LATEST_TIME"
    },
    {
        {AnimalControllor.textUsingParameter, 0, 0},
        {AnimalControllor.textUsingParameter, 1, 1},
        {AnimalControllor.textUsingParameter, 2, 2}
    }
)]]