dofile(LockOn_Options.script_path.."displays/MFD/Indicator/definitions.lua") --所有页面都包含这个描述文件
local base_sim = AddSimple()
local width = (Width-0.507*Width)*0.5
local height = Height*1.15*0.5

PAGE_NAME = 'INDICATION'

local ud_scale
local lr_scale
if not BackUpIndicator then
    ud_scale 	= 0.00000169
    lr_scale 	= 0.00000169
else
    ud_scale 	= 0.00000152
    lr_scale 	= 0.00000169
end

local page3_sim = AddSimple(nil,{0.248*Width,0.117*Height},nil,base_sim)
local posX = 0
local posY = -0.6*height

local terrainName = get_terrain_related_data('name')
if not terrainName then
    local airdromes = get_terrain_related_data('Airdromes')
    dofile(LockOn_Options.script_path..'utils.lua')
    for k, v in pairs(airdromes) do
        if StringContains(v.roadnet,'Caucasus') then
            terrainName = 'Caucasus'
            break
        elseif StringContains(v.roadnet,'MarianaIslands') then
            terrainName = 'MarianaIslands'
            break
        elseif StringContains(v.roadnet,'Nevada') then
            terrainName = 'Nevada'
            break
        elseif StringContains(v.roadnet,'Normandy') then
            terrainName = 'Normandy'
            break
        elseif StringContains(v.roadnet,'PersianGulf') then
            terrainName = 'PersianGulf'
            break
        elseif StringContains(v.roadnet,'Sinai') then
            terrainName = 'Sinai'
            break
        elseif StringContains(v.roadnet,'Syria') then
            terrainName = 'Syria'
            break
        end
    end
end
AddBox(nil,width,height,nil,nil,'DBG_RED',DEFAULT_MASK_LEVEL + 3,REWRITE_LEVEL,page3_sim,nil,nil,true)
local mapMask = AddBox(nil,width,height,nil,nil,'DBG_RED',DEFAULT_MASK_LEVEL + 3,INCREASE_IF_LEVEL,page3_sim,nil,nil,true)
local mapOffset = AddSimple(nil,{posX,posY},nil,mapMask)
local mapRot = AddSimple(nil,nil,nil,mapOffset,{'HDG'},{{AnimalControllor.rotateUsingParameter,0,math.rad(1)}})

dofile(LockOn_Options.script_path..'displays/MFD/Indicator/mapConfig.lua')

local mapParam = GetMapConfig()
local size = 2.5
local mapMoveSimple = AddSimple(nil,nil,nil,mapRot,{'GPS_LAT_M_SC', 'GPS_LON_M_SC'},{
    { AnimalControllor.moveUpDownUsingParameter,    0, -ud_scale },
    { AnimalControllor.moveLeftRightUsingParameter, 1, -lr_scale },
})

local viewRange = 4188.125
if mapParam[terrainName]~=nil then
    for i = 1, 7, 1 do
        size = size*2
        viewRange = viewRange*2
        local mapCfg = mapParam[terrainName][size]
        local w = mapCfg.size*width
        local h = w
        local viewR = math.ceil(1/mapCfg.size)*3
        for bigY = string.byte(mapCfg.Limit.BigY[1][1]), string.byte(mapCfg.Limit.BigY[1][2]), 1 do
            for bigX = mapCfg.Limit.BigX[1], mapCfg.Limit.BigX[2], 1 do
                for y = mapCfg.Limit.y[1][2], mapCfg.Limit.y[1][1], -1 do
                    for x = mapCfg.Limit.x[1], mapCfg.Limit.x[2], 1 do
                        local areaName = string.format(mapCfg.fmt,'',string.char(bigY),bigX,y,x)
                        local idx = GetIndexOfValInTbl(mapCfg.lostArea,areaName)
                        if idx==nil then
                            local offsetX_unit = bigX*8+x
                            local offsetY_unit = (bigY-string.byte(mapCfg.Limit.BigY[1][1]))*8+(7-y)
                            if size>=20 and size<=40 and terrainName == 'Caucasus' then
                                offsetX_unit = offsetX_unit - 11
                                offsetY_unit = offsetY_unit - 24
                            end
                            local offsetX = offsetX_unit*w*2+w
                            local offsetY = offsetY_unit*h*2+h
                            local latRange = {(offsetY_unit-viewR)*viewRange*mapCfg.size,(offsetY_unit+viewR)*viewRange*mapCfg.size}
                            local lonRange = {(offsetX_unit-viewR)*viewRange*mapCfg.size,(offsetX_unit+viewR)*viewRange*mapCfg.size}
                            AddTexture(nil, { { -w, h }, { w, h }, { w, -h }, { -w, -h } }, { 0, 1, 2, 2, 3, 0 },
                                Texure_coord_gen(0, 0, 1024, 1024, 1024, 1024), MakeMaterial(areaName,{128,128,128,255}), {offsetX,offsetY}, nil, nil, DEFAULT_MASK_LEVEL + 4, mapMoveSimple,
                                { 'MAX_RANGE', 'HSI_MAP','GPS_LAT_M','GPS_LON_M' }, {
                                    { AnimalControllor.parameterInRange,0, size - 0.1, size + 0.1 },
                                    { AnimalControllor.parameterInRange,1, 0.9, 1.1 },
                                    { AnimalControllor.parameterInRange,2,latRange[1],latRange[2] },
                                    { AnimalControllor.parameterInRange,3,lonRange[1],lonRange[2] },
                                }, false
                            )
                        end
                    end
                end
            end
        end
        if #mapCfg.Limit.BigY[2]>0 then
            for bigY = string.byte(mapCfg.Limit.BigY[2][1]), string.byte(mapCfg.Limit.BigY[2][2]), 1 do
                for bigX = mapCfg.Limit.BigX[1], mapCfg.Limit.BigX[2], 1 do
                    for y = mapCfg.Limit.y[2][1], mapCfg.Limit.y[2][2], 1 do
                        for x = mapCfg.Limit.x[1], mapCfg.Limit.x[2], 1 do
                            local areaName = string.format(mapCfg.fmt,'x',string.char(bigY),bigX,y,x)
                            local idx = GetIndexOfValInTbl(mapCfg.lostArea,areaName)
                            if idx==nil then
                                local offsetX_unit = bigX*8+x
                                local offsetY_unit = -((bigY-string.byte(mapCfg.Limit.BigY[2][1]))*8+y)
                                if size>=20 and size<=40 and terrainName=='Caucasus' then
                                    offsetX_unit = offsetX_unit - 11
                                    offsetY_unit = offsetY_unit - 24
                                end
                                local offsetX = offsetX_unit*w*2+w
                                local offsetY = offsetY_unit*h*2-h
                                local latRange = {(offsetY_unit-viewR)*viewRange*mapCfg.size,(offsetY_unit+viewR)*viewRange*mapCfg.size}
                                local lonRange = {(offsetX_unit-viewR)*viewRange*mapCfg.size,(offsetX_unit+viewR)*viewRange*mapCfg.size}
                                AddTexture(nil, { { -w, h }, { w, h }, { w, -h }, { -w, -h } }, { 0, 1, 2, 2, 3, 0 },
                                    Texure_coord_gen(0, 0, 1024, 1024, 1024, 1024), MakeMaterial(areaName,{128,128,128,255}), {offsetX,offsetY}, nil, nil, DEFAULT_MASK_LEVEL + 4, mapMoveSimple,
                                    { 'MAX_RANGE', 'HSI_MAP','GPS_LAT_M','GPS_LON_M' }, {
                                        { AnimalControllor.parameterInRange,0, size - 0.1, size + 0.1 },
                                        { AnimalControllor.parameterInRange,1, 0.9, 1.1 },
                                        { AnimalControllor.parameterInRange,2,latRange[1],latRange[2] },
                                        { AnimalControllor.parameterInRange,3,lonRange[1],lonRange[2] },
                                    }, false
                                )
                            end
                        end
                    end
                end
            end
        end
    end 
end