dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua")
dofile(LockOn_Options.script_path.."Systems/electric_system_api.lua")
dofile(LockOn_Options.script_path.."utils.lua")

local update_time_step = 0.02  --每秒50次刷新
local sensor_data = get_base_data()
make_default_activity(update_time_step)
local terrain = require('terrain')
--[[
local tablePrinted = {}
local pr=0
local file = io.open("e:\\00_00_00_海外组_学习\\test.txt", "w")
assert(file)
function printTableItem(k, v, level)
    for i = 1, level do
        file:write("\t")
    end
    file:write(tostring(k) .. " = " .. tostring(v) .. "\r\n")
    if type(v) == "table" then
        if not tablePrinted[v] then
            tablePrinted[v] = true
            for k, v in pairs(v) do
                printTableItem(k, v, level + 1)
            end
        end
    end
end

--]]

local towns = get_terrain_related_data('towns')

local dev = GetSelf()
dev:listen_command(Keys.PlaneZoomIn)
dev:listen_command(Keys.PlaneZoomOut)
local params_h = {
    maxRange = {get_param_handle('MAX_RANGE'),320},
    HSI_SCALE_UP = {get_param_handle('HSI_SCALE_UP'),0},
    HSI_SCALE_DN = {get_param_handle('HSI_SCALE_DN'),0},
    HSI_MAP = {get_param_handle('HSI_MAP'),0},
    HDG_TYPE = {get_param_handle('HDG_TYPE'),0},
    GPS_LAT = {get_param_handle('GPS_LAT'),'N00-00-00.00'},
    GPS_LON = {get_param_handle('GPS_LON'),'E000-00-00.00'},
    GPS_ALT = {get_param_handle('GPS_ALT'),0},
    GPS_LAT_M = {get_param_handle('GPS_LAT_M'),0},
    GPS_LON_M = {get_param_handle('GPS_LON_M'),0},
    GPS_LAT_M_SC = {get_param_handle('GPS_LAT_M_SC'),0},
    GPS_LON_M_SC = {get_param_handle('GPS_LON_M_SC'),0},
}
local ATKMode_h = get_param_handle('ATK_MODE')

WPT_POS = {}
local c = 0
local function updateGPS()
    local pos_x_loc, alt, pos_y_loc= sensor_data.getSelfCoordinates()
    local coord = lo_to_geo_coords(pos_x_loc, pos_y_loc)
    local lat_m,lon_m = terrain.convertLatLonToMeters(coord.lat,coord.lon)
    local scale = 40/params_h.maxRange[2]
    params_h.GPS_LAT_M_SC[2] = lat_m*scale
    params_h.GPS_LON_M_SC[2] = lon_m*scale
    params_h.GPS_LAT_M[2] = lat_m
    params_h.GPS_LON_M[2] = lon_m
    -- temp_dbg:set(coord.lat)
    params_h.GPS_LAT[2]=DD_to_DMS(coord.lat,1)
    params_h.GPS_LON[2]=DD_to_DMS(coord.lon,2)
    params_h.GPS_ALT[2]=alt
end

local function update_MAX_RANGE_with_RWM()
    local RWM   = get_param_handle("RADAR_WORK_MODE"):get()
    local U     = get_param_handle("UNIT"):get()
    local RM    = get_param_handle("RADAR_MODE"):get()
    local TR    = get_param_handle("TARGET_RANGE"):get()
    local TR_NM = get_param_handle("TARGET_RANGE_NM"):get()
	local RR    = get_param_handle("RADAR_TDC_RANGE"):get()/1000
	local RR_NM = get_param_handle("RADAR_TDC_RANGE"):get()*Meter_TO_NM

    if RM == 2 then
        -- 锁定状态：根据目标距离选择合适的 maxRange 值
        -- 当 U==1 时使用 TR_NM，否则使用 TR
        local d = (U == 1) and RR_NM or RR
        -- 允许的取值列表：5, 10, 20, 40, 80, 160, 320
        local alwd = {5, 10, 20, 40, 80, 160, 320}
        local newR = alwd[#alwd]  -- 默认取最大值320
        for _, v in ipairs(alwd) do
            if d <= v then
                newR = v
                break
            end
        end
        params_h.maxRange[2] = newR
	elseif RM == 3 then
        -- 锁定状态：根据目标距离选择合适的 maxRange 值
        -- 当 U==1 时使用 TR_NM，否则使用 TR
        local d = (U == 1) and TR_NM or TR
        -- 允许的取值列表：5, 10, 20, 40, 80, 160, 320
        local alwd = {5, 10, 20, 40, 80, 160, 320}
        local newR = alwd[#alwd]  -- 默认取最大值320
        for _, v in ipairs(alwd) do
            if d <= v then
                newR = v
                break
            end
        end
        params_h.maxRange[2] = newR
    else
        -- 非锁定状态：根据 RADAR_WORK_MODE 采用原来的 if–elseif 逻辑
        if RWM == 1 then
            params_h.maxRange[2] = 20
        elseif RWM == 3 then
            params_h.maxRange[2] = 40
        elseif RWM == 4 then
            params_h.maxRange[2] = 10
        elseif RWM == 5 then
            params_h.maxRange[2] = 80
        elseif RWM == 2 then
            if U == 0 then
                params_h.maxRange[2] = 160
            else
                params_h.maxRange[2] = 80
            end
        end
    end
end


function post_initialize()
    local pos_x_loc, alt, pos_y_loc= sensor_data.getSelfCoordinates()
    local coord = lo_to_geo_coords(pos_x_loc, pos_y_loc)
    local lat_m,lon_m = terrain.convertLatLonToMeters(42.530195,43.150121)
    local height = terrain.GetHeight(lat_m,lon_m)
    --DebugPrint(height)
    --printTableItem('test',{lat={lat,DD_to_DMS(lat,1)},lon={lon,DD_to_DMS(lon,2)},},0)
end

function SetCommand(command,value)
	if command == MFD_click_cmd.HSI_SCALE_DN then
        params_h.HSI_SCALE_DN[2] = value
        if value == 1 then
            params_h.maxRange[2] = Limit(params_h.maxRange[2]*0.5,5,320)
        end
    elseif command == MFD_click_cmd.HSI_SCALE_UP then
        params_h.HSI_SCALE_UP[2] = value
        if value == 1 then
            params_h.maxRange[2] = Limit(params_h.maxRange[2]*2,5,320)
        end
    elseif command == MFD_click_cmd.HSI_MAP and value == 1 then
        params_h.HSI_MAP[2] = 1 - params_h.HSI_MAP[2]
    elseif command == MFD_click_cmd.HSI_HDG_MODE and value == 1 then
        params_h.HDG_TYPE[2] = 1 - params_h.HDG_TYPE[2]
    elseif command == Keys.PlaneZoomIn and ATKMode_h:get()~=2 then
        dev:performClickableAction(MFD_click_cmd.HSI_SCALE_DN,1)
        dev:performClickableAction(MFD_click_cmd.HSI_SCALE_DN,0)
    elseif command == Keys.PlaneZoomOut and ATKMode_h:get()~=2 then
        dev:performClickableAction(MFD_click_cmd.HSI_SCALE_UP,1)
        dev:performClickableAction(MFD_click_cmd.HSI_SCALE_UP,0)
    end
end

function update()
	update_MAX_RANGE_with_RWM()
	updateGPS()
	for k, v in pairs(params_h) do
        v[1]:set(v[2])
    end
end

need_to_be_closed = false
