dofile(LockOn_Options.script_path.."displays/radar/Indicator/definitions.lua")

local ud_scale 	= 0.000001665*Width*0.8
local lr_scale 	= 0.037*0.8*Width
local life_time 	= 2.081
local life_time_low = 0.779

-------------------------------------------------------------
local baseSimple = AddSimple()
local length = 0.8*Width

for i = -2,2 do
	AddSimpleLine(nil,0.003*Width,{{0,length},{0,-length}},{0.4*i*Width,0},nil,'DBG_GREEN',nil,nil,baseSimple)
	AddSimpleLine(nil,0.003*Width,{{length,0},{-length,0}},{0,0.4*i*Width},nil,'DBG_GREEN',nil,nil,baseSimple)
	AddText(nil,tostring(math.abs(i*30)),'radar_ui_font',{i*0.4*Width,-0.9*Height},nil,DEFAULT_FONT_SIZE[5],nil,nil,baseSimple)
end
AddText(nil,nil,'radar_ui_font',{0.9*Width,0.9*Height},nil,DEFAULT_FONT_SIZE[5],nil,nil,baseSimple,{'%.0f'},{'MAX_RANGE'},
{
	{AnimalControllor.textUsingParameter,0}
})
--AddBoxBorder(nil,length,length,0.01*Width,nil,nil,'DBG_GREEN',nil,nil,baseSimple)

local localSimle = AddSimple(nil,{0,-0.8*Width},nil,baseSimple)

for i = 1, 900, 1 do
    AddSimpleLine(nil,0.025*Width,{{-0.06*Width,0},{0.06*Width,0}},nil,nil,'DBG_GREEN',nil,nil,localSimle,{
		string.format('RADAR_CONTACT_%02.0f_ELEVATION',i),
        string.format('RADAR_CONTACT_%02.0f_AZIMUTH',i),
        string.format('RADAR_CONTACT_%02.0f_RANGE_SCALE',i),
        string.format('RADAR_CONTACT_%02.0f_TIME',i),
        string.format('RADAR_CONTACT_%02.0f_FRIENDLY',i),
        string.format('RADAR_CONTACT_%02.0f_RCS',i)
    },{
		--{"move_up_down_using_parameter"		,0,1.0},
        {AnimalControllor.moveLeftRightUsingParameter	,1,lr_scale},
        {AnimalControllor.moveUpDownUsingParameter		,2,ud_scale},
		{AnimalControllor.parameterInRange		,1,-math.rad(60),math.rad(60)},
		{AnimalControllor.parameterInRange		,2,5000,40000},
        {AnimalControllor.parameterInRange,3,life_time_low,life_time},
        {AnimalControllor.changeColorWhenParameterEqualToNumber,4,-1,1,1,0},
		{AnimalControllor.changeColorWhenParameterEqualToNumber,4,0,1,0,0},
		{AnimalControllor.changeColorWhenParameterEqualToNumber,4,1,0,1,0},
        {AnimalControllor.opacityUsingParameter,5},
    })
end

local x_size = 0.04*Width
local y_size = 0.05*Height
local TDC_cursor = AddMultiLine(nil,nil,nil,{{-x_size,-y_size},{-x_size,y_size},{x_size,-y_size},{x_size,y_size}},{0,1,2,3},{ 0, 0 },nil,'DBG_YELLOW',Align.CC,nil,nil,localSimle,
	{
		"RADAR_TDC_RANGE_SCALE",
		"RADAR_TDC_AZIMUTH_RANGE",
        "RADAR_TDC_AZIMUTH",
		"RADAR_MODE",
	},
	{
		{ AnimalControllor.moveUpDownUsingParameter, 0, ud_scale },
		{ AnimalControllor.moveLeftRightUsingParameter, 2, lr_scale },
		{ AnimalControllor.parameterInRange, 3, -0.1, 2.1 },
	}
)
AddSimpleLine(nil,0.01*Width,{{0,0.9*Width},{0,-0.9*Width}},nil,nil,'DBG_GREEN',nil,nil,baseSimple,{'SCAN_BEAM_AZIMUTH'},{
	{AnimalControllor.moveLeftRightUsingParameter,0,lr_scale}
})

local radar_STT = AddBox(nil,0.03*Width,0.03*Height,nil,nil,'DBG_GREEN',nil,nil,localSimle,
	{
		"RADAR_STT_RANGE",
		"RADAR_STT_AZIMUTH",
		"RADAR_STT_ELEVATION",
		"RADAR_MODE",
		"RADAR_STT_FRIENDLY"
	},
	{
		{ AnimalControllor.moveUpDownUsingParameter, 0, ud_scale },
		{ AnimalControllor.moveLeftRightUsingParameter, 1, lr_scale },
		--{AnimalControllor.moveUpDownUsingParameter,3,1.0},
		{ AnimalControllor.parameterInRange, 3, 2.9, 3.1 },
		{AnimalControllor.changeColorWhenParameterEqualToNumber,4,-1,1,1,0},
		{AnimalControllor.changeColorWhenParameterEqualToNumber,4,0,1,0,0},
		{AnimalControllor.changeColorWhenParameterEqualToNumber,4,1,0,1,0},
	}
)


AddCrossHair(nil,0.09*Width,0.09*Height,0.005*Width,nil,nil,'DBG_GREEN',nil,nil,baseSimple,
{
	"RADAR_STT_RANGE",
	"RADAR_STT_AZIMUTH",
	"RADAR_STT_ELEVATION",
	"RADAR_MODE",
},
{
	{ "move_left_right_using_parameter", 1, lr_scale },
	{ "move_up_down_using_parameter", 2, lr_scale },
	{ "parameter_in_range", 3, 2.9, 3.1 },
})