local isProxy = false
local FM_A_dll
local FM_C_dll
dofile(current_mod_path..'/Cockpit/Scripts/cockpit_cfg.lua')
if isProxy then
	FM_A_dll='J20A-proxy'
	FM_C_dll='J20A-proxy'
else
	FM_A_dll='J20A'
	FM_C_dll='J20C'
end

--模组入口
local self_ID = "J-20A" --定义模组名称，全局使用
local pluginTable = {
	--基础定义区
	installed 	  = true,
	displayName   = _("J-20A"), --模组显示名称
	developerName = _("Round Table Simulate"),	--开发组名称
	dirName	  	  = current_mod_path,

	fileMenuName  = _("J-20A"),
	update_id     = "J-20A",
	version		  = "0.1.0", --当前迭代版本号   
	state		  = "installed",
	info		  = _("J-20A is a developing version of DCS J-20A mods"), --描述信息
	encyclopedia_path = current_mod_path..'/Encyclopedia',
	binaries   =
	{
		FM_A_dll,FM_C_dll
	},

	Skins	=
		{
			{
				name	= _("J-20A"),
				dir		= "Theme"
			},
		},
	Missions =
		{
			{
				name		= _("J-20A"),
				dir			= "Missions",
			},
		},
	LogBook =
		{
			{
				name		= _("J-20A"),
				type		= "J-20A",
			},
		},
	InputProfiles =
		{
			["J-20A"]     = current_mod_path .. '/Input/J-20A',
			["J-20C"]     = current_mod_path .. '/Input/J-20C',
		},

}
if USE_EXT_DLL then
	pluginTable.binaries[#pluginTable.binaries+1] = 'avSimplest'
end
declare_plugin(self_ID,pluginTable)
--------------------------------------------------------------------------------
-- 挂载 3d 模型目录和 贴图 文件目录
-- 挂载 模型
mount_vfs_sound_path(current_mod_path.."/Sounds")
mount_vfs_model_path	(current_mod_path.."/Shapes")
mount_vfs_liveries_path (current_mod_path.."/Liveries")
mount_vfs_texture_path  (current_mod_path.."/Textures/Weapons")
mount_vfs_texture_path  (current_mod_path.."/Textures/V8")
-- 考虑座舱单独
-- mount_vfs_model_path	(current_mod_path.."/Cockpit/Shapes")
-- mount_vfs_texture_path  (current_mod_path.."/Cockpit/Resources/Model/Textures/J-20-CPT-TEXTURES")


---------------------------------------------------------------------------------------
-- Option Cockpit operationnel, HUD partiel
function CopyTable(dest, source)
	for key, value in pairs(source or {}) do
		if type(value) == 'table' then
		  dest[key] = {}
		  CopyTable(dest[key], value)
		else
		  dest[key] = value
		end
	end
end
local FM_A
local FM_C
if FM_A_dll then
    dofile(current_mod_path.."/FM/config.lua")
	FM_A = {}
	CopyTable(FM_A,J20A)
	FM_A.config_path  = current_mod_path..'/FM/config.lua'
	FM_A[1] = self_ID
	FM_A[2] = FM_A_dll
else
    FM_A=nil
end
if FM_A_dll then
    dofile(current_mod_path.."/FM/config.lua")
	FM_C = {}
	CopyTable(FM_C,J20A)
	FM_C.config_path  = current_mod_path..'/FM/config.lua'
	FM_C[1] = self_ID
	FM_C[2] = FM_C_dll
else
    FM_C=nil
end
make_flyable('J-20A', current_mod_path..'/Cockpit/Scripts/', FM_A, current_mod_path..'/commA.lua')
make_flyable('J-20C', current_mod_path..'/Cockpit/Scripts/', FM_C, current_mod_path..'/commC.lua')

-- 加载额外lua文件
dofile(current_mod_path.."/Views.lua")
dofile(current_mod_path.."/J-20A.lua")
--dofile(current_mod_path.."/smoke.lua")

-- 加载视角
make_view_settings('J-20A', ViewSettings, SnapViews)
make_view_settings('J-20C', ViewSettings, SnapViews)

plugin_done()
