-------挂载代码CLSID-----------
--{PLAAF_PL-10E} 			--PL-10E挂载配置 单发
--{PLAAF_PL-10E_DUAL}		--PL-10E挂载配置 PF12挂架双发
--{BayArm_PLAAF_PL-10E_x4}	--PL-10E挂载配置 内藏式无挂架4发
--{J20A_PL15}				--PL-15挂载配置 单发
--J20_PL-15_DUAL			--PL-15挂载配置 PF12挂架双发
--BayArm_J20_PL-15_DUAL		--PL-15挂载配置 内藏式无挂架双发
--{J20A_PL17}				--PL-17挂载配置 单发
--{BayArm_J20_PL-17_x4}		--PL-17挂载配置 内置式无挂架 四发

-----PL-10E-----
local PL10E_mass = 84.46
local pylon_dual_mass = 130.0
local PL10E = {
	category     	= CAT_AIR_TO_AIR,
    Name         	= 'PL-10E_ByJ20A',
	user_name		= _("PL-10E"),
	display_name 	= _('霹雳-10E 格斗导弹'),
    wsTypeOfWeapon  = {4,4,7,WSTYPE_PLACEHOLDER},
	Escort = 0,
    Head_Type = 1,
	sigma = {2, 2, 2},
    M = PL10E_mass,
    H_max = 18000.0,
    H_min = -1,
    Diam = 127.0,
    Cx_pil = 1.03,
    D_max = 11000.0,
    D_min = 200.0,
    Head_Form = 0,
    Life_Time = 60.0,
    Nr_max = 55,
    v_min = 140.0,
    v_mid = 350.0,
    Mach_max = 2.7,
    t_b = 0.0,
    t_acc = 5.0,
    t_marsh = 0.0,
    Range_max = 14000.0,
    H_min_t = 1.0,
    Fi_start = 1.57,
    Fi_rak = 3.14152,
    Fi_excort = 1.57,
    Fi_search = 0.09,
    OmViz_max = 1.10,
    warhead = predefined_warhead("AIM_9"),
    exhaust = { 0.7, 0.7, 0.7, 0.08 },
    X_back = -1.6,
    Y_back = 0.0,
    Z_back = 0.0,
    Reflection = 0.03,
    KillDistance = 7.0,
	--seeker sensivity params
	SeekerSensivityDistance = 25000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
	ccm_k0 = 0.2,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	SeekerCooled = true, -- True is cooled seeker and false is not cooled seeker.
	x_wing_anim = -1,
	PN_gain = 6,

	shape_table_data =
	{
		{
			name	 = "PL-10E_ByJ20A",
			file	 = "PL-10E_ByJ20A",
			life	 = 1,
			fire	 = { 0, 1},
        	username = "PL-10E",
			index = WSTYPE_PLACEHOLDER,
		},
	},

	ModelData = {
		58 ,  -- model params count
		0.35 ,   -- characteristic square (характеристическая площадь)

		-- параметры зависимости Сx
		0.04 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
		0.08 , -- Cx_k1 высота пика волнового кризиса
		0.02 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
		0.05, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
		1.2 , -- Cx_k4 крутизна спада за волновым кризисом 
		1.0 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))

		-- параметры зависимости Cy
		1.2 , -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
		0.8	 , -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
		1.0  , -- Cy_k2 крутизна спада(фронта) за волновым кризисом  

		0.5, -- 7 Alfa_max  максимальный балансировачный угол, радианы
		0.8, -- Alfa_max by trust vectoring

		-- Engine data. Time, fuel flow, thrust.	
		--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
		-1.0,		   -1.0,	5.0,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
		0.0,		    0.0,	5.44,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
		0.0,		    0.0,	12802.0,	0.0,	    0.0,			0.0,		0.0,           -- thrust, newtons

		120, -- таймер самоликвидации, сек
		60.0, -- время работы энергосистемы, сек
		0, -- абсолютная высота самоликвидации, м
		0.3, -- время задержки включения управления (маневр отлета, безопасности), сек
		1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
		1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
		0.0,  -- синус угла возвышения траектории набора горки
		30.0, -- продольное ускорения взведения взрывателя
		0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
		2.2, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
		1.0, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
		1.0, -- характеристика системы САУ-РАКЕТА,  полоса пропускания контура управления
		
		--DLZ 发射距离计算数据（瞄准器上的指示）					
		9.0, 		-- 载机速度对发射距离的影响（海拔 1km，高速迎头拦截）
		-13.0, 		-- 目标速度对发射距离的影响（海拔 1km，追击目标）
		-2.1, 		-- 目标速度影响发射距离的变化率（海拔 1km，追击目标）
					
		15500.0,	-- 目标迎头方向 (180°)，海拔 5000m，速度 900 km/h 时的最大有效射程（单位：米）
		5500.0, 	-- 目标尾追方向 (0°)，海拔 5000m，速度 900 km/h 时的最大有效射程（单位：米）
					                                                            
		27000.0,	-- 目标迎头方向 (180°)，海拔 10000m，速度 900 km/h 时的最大有效射程（单位：米）
		10000.0,	-- 目标尾追方向 (0°)，海拔 10000m，速度 900 km/h 时的最大有效射程（单位：米）
					                                                            
		10500.0,	-- 目标迎头方向 (180°)，海拔 1000m，速度 900 km/h 时的最大有效射程（单位：米）
		3500.0, 	-- 目标尾追方向 (0°)，海拔 1000m，速度 900 km/h 时的最大有效射程（单位：米）
					
		2500.0, 	-- 后方可达区域相对初始点的偏移量
					
		0.55, 		-- 保证命中距离相对于迎头拦截距离的百分比（海拔 1km）
		-0.01, 		-- 保证命中距离对海拔变化的影响（迎头拦截）
		0.5, 		-- 海拔影响导弹弹道曲线的变化率（上半球与下半球的调整系数）
	},
}
declare_weapon(PL10E)
	-----PL-10E挂载配置 单发-----
declare_loadout({
	category		=	CAT_AIR_TO_AIR,
	CLSID			= 	"{PLAAF_PL-10E}",
	Picture			=	"PL-10E.png",
	wsTypeOfWeapon	=	PL10E.wsTypeOfWeapon,
	displayName		=	_('霹雳-10E 格斗导弹'),
	attribute		=	{4,	4,	32,	WSTYPE_PLACEHOLDER},
	Cx_pil         	= 	0,
	Count			=	1,
	Weight			=	PL10E_mass,
	Elements		=
	{
		{
			ShapeName	=	"PL-10E_ByJ20A",
			Position	=	{0,	0,	0}
		},
	}, -- end of Elements
})
	-----PL-10E挂载配置 PF12挂架双发-----
declare_loadout({
    category       = CAT_AIR_TO_AIR,
    CLSID          = "{PLAAF_PL-10E_DUAL}",
    Picture        = 'PL-10E.png',
    wsTypeOfWeapon = PL10E.wsTypeOfWeapon,
    attribute      = {4,4,32,WSTYPE_PLACEHOLDER},
    displayName    = _('霹雳-10E 格斗导弹')..' x 2',
    Count          = 2,
    Weight         = 2 * PL10E_mass + pylon_dual_mass,
    Elements       = {
        { ShapeName = 'JF-17_PF12_twin', IsAdapter = true, },
        { ShapeName = 'PL-10E_ByJ20A',        connector_name = 'dual_PF12L', },
        { ShapeName = 'PL-10E_ByJ20A',        connector_name = 'dual_PF12R', },
    }, -- end of Elements
    JettisonSubmunitionOnly = true,
})
	-----PL-10E挂载配置 内藏式无挂架4发-----
declare_loadout({
	category		=	CAT_AIR_TO_AIR,
	CLSID			= 	"{BayArm_PLAAF_PL-10E_x4}",
	Picture			=	"PL-10E.png",
	wsTypeOfWeapon	=	PL10E.wsTypeOfWeapon,
	displayName		=	_('虚构弹仓版 霹雳-10E 格斗导弹')..' x 4',
	attribute		=	{4,	4,	32,	WSTYPE_PLACEHOLDER},
	Count			=	4,
	Weight			=	4 * PL10E_mass,
	Elements	=
	{
		{
			ShapeName	=	"PL-10E_ByJ20A",
			Position	=	{0,	0,	0}
		},
		{
			ShapeName	=	"PL-10E_ByJ20A",
			Position	=	{0,	0,	0}
		},
		{
			ShapeName	=	"PL-10E_ByJ20A",
			Position	=	{0,	0,	0}
		},
		{
			ShapeName	=	"PL-10E_ByJ20A",
			Position	=	{0,	0,	0}
		},
	}, -- end of Elements
})

-----PL-15-----
local PL15_mass = 210.0
local PL_15_AA = {
	category        = CAT_AIR_TO_AIR,
    name            = 'J20A_PL_15',
    model           = 'PL-15_ByJ20A',
    user_name       = _("PL15"),
	display_name 	= _('霹雳-15 中程导弹'),
    wsTypeOfWeapon  = {4,4,7,WSTYPE_PLACEHOLDER},
    mass            = PL15_mass,
    Escort          = 0,
    Head_Type       = 2,
    sigma           = {5, 5, 5},
    M               = PL15_mass,
    H_max           = 25000.0,
    H_min           = -1.0,
    Diam            = 203.0,
    Cx_pil          = 2.2,
    D_max           = 220000.0,--DLZ的最大射程
    D_min           = 1000.0,--DLZ的最小射程
    Head_Form       = 1,
    Life_Time       = 120.0,
    Nr_max          = 30,
    v_min           = 140.0,
    v_mid           = 1200.0,
    Mach_max        = 4.0,
    t_b             = 0.0,
    t_acc           = 6.0,
    t_marsh         = 4.0,
    Range_max       = 220000.0,
    H_min_t         = 3.0,
    Fi_start        = 0.5,
    Fi_rak          = 3.14152,
    Fi_excort       = 1.05,
    Fi_search       = 1.05,
    OmViz_max       = 0.52,
    exhaust         = { 1.0, 1.0, 1.0, 0.8 },
    X_back          = -1.74,
    Y_back          = 0.0,
    Z_back          = 0.0,
    Reflection      = 0.045,
    KillDistance    = 11.0,

    warhead         = enhanced_a2a_warhead(24, 203),
    warhead_air     = enhanced_a2a_warhead(24, 203),

    shape_table_data = {
		{
			name = "J20A_PL_15",
			file = "PL-15_ByJ20A",
			life = 1,
			fire = {0, 1},
			username = "PL15",
			index = WSTYPE_PLACEHOLDER
		}
	},

    PN_coeffs = { 4,                 -- Number of Entries
                  12000.0, 1.00,
                  18000.0, 0.75,
                  30000.0, 0.50,     -- Less 5 km to target Pn = 1
                  48000.0, 0.20,     -- Between 15 and 5 km  to target, Pn smoothly changes from 0.4 to 1.0. Longer then 15 km Pn = 0.4.
                },

    supersonic_A_coef_skew = 0.1, -- slope of the direct polarity factor of the polar on supersonic
    nozzle_exit_area       = 0.01219, -- the nozzle exit area

    class_name      = 'wAmmunitionSelfHoming',
    --scheme          = 'aa_missile_amraam2',
    scheme          = 'aa_missile_amraam',

    controller = {
        boost_start = 0.5,
        march_start = 48.5,--30.5 二级发动机点火时间√
    },

    boost = {
        impulse                             = 242,--比冲√
        fuel_mass                           = 70.6,--燃料质量√
        work_time                           = 15.0,--发动机工作时间√
        nozzle_position                     = {{-1.94, 0, 0}},--发动机喷口位置
        nozzle_orientationXYZ               = {{0.0, 0.0, 0.0}},--发动机喷口方向
        nozzle_exit_area                    = 0.01219,--发动机喷口面积
        tail_width                          = 0.4,--导弹尾部弹径
        smoke_color                         = {1.0, 1.0, 1.0},--动力段尾烟色
        smoke_transparency                  = 0.5,--烟透明度
        custom_smoke_dissipation_factor     = 0.2,--消散因子速度
    },

    march = {
        impulse                             = 236,
        fuel_mass                           = 30.2,
        work_time                           = 18.0,
        nozzle_position                     = {{-1.74, 0, 0}},
        nozzle_orientationXYZ               = {{0.0, 0.0, 0.0}},
        nozzle_exit_area                    = 0.01219,
        tail_width                          = 0.4,
        smoke_color                         = {1.0, 1.0, 1.0},
        smoke_transparency                  = 0.5,
        custom_smoke_dissipation_factor     = 0.2,
    },

    fm = {--加减速性
        mass                = PL15_mass,
        caliber             = 0.203,
        wind_sigma          = 0.0,
        wind_time           = 0.0,
        tail_first          = 0,
        fins_part_val       = 0,
        rotated_fins_inp    = 0,
        delta_max           = math.rad(20),
        draw_fins_conv      = {math.rad(90),1,1},
        L                   = 0.203,
        S                   = 0.0324,
        Ix                  = 1.5,
        Iy                  = 190,
        Iz                  = 190,

        Mxd                 = 0.1 * 57.3,
        Mxw                 = -15.8,

        table_scale         = 0.2,
        table_degree_values = 1,
        -- Mach   | 0.0        0.2        0.4        0.6        0.8         1.0        1.2         1.4         1.6          1.8          2.0          2.2         2.4         2.6         2.8         3.0         3.2         3.4         3.6         3.8         4.0         4.2         4.4         4.6         4.8         5.0 |
        Cx0 = {    0.4727,    0.4727,    0.4727,    0.4727,    0.4838,    0.7609,     0.8869,     0.86198,    0.81793,     0.76899,     0.72481,     0.68476,    0.64836,    0.61529,    0.58515,    0.55744,    0.53195,    0.50829,    0.48624,    0.46561,    0.4461,     0.42772,    0.41035,    0.3941,     0.37898,    0.366    },
        CxB = {    0.021,     0.021,     0.021,     0.021,     0.021,     0.138,      0.153,      0.146,      0.1382,      0.1272,      0.1167,      0.1073,     0.0987,     0.0909,     0.0837,     0.077,      0.0708,     0.065,      0.0595,     0.0544,     0.0495,     0.0449,     0.0406,     0.0364,     0.0324,     0.0286    },--波阻
        K1  = {    0.00264,   0.00264,   0.00264,   0.00264,   0.00264,   0.00264,    0.0022,     0.001873,   0.0016435,   0.0014752,   0.0013448,   0.0012436,  0.0011534,  0.0010742,  0.0010149,  0.0009484,  0.0009016,  0.0008476,  0.000795,   0.0007529,  0.0007122,  0.0006727,  0.0006343,  0.0006058,  0.0005781,  0.00056    },
        K2  = {    -0.00257,  -0.00257,  -0.00257,  -0.00257,  -0.00257,  -0.00265,   -0.002274,  -0.002034,  -0.0018241,  -0.0016225,  -0.0014468,  -0.001275,  -0.0011248, -0.0009777, -0.0008514, -0.0007274, -0.0006236, -0.0005217, -0.0004393, -0.0003584, -0.0002968, -0.0002363, -0.0001949, -0.0001546, -0.0001335, -0.000114    },
        Cya = {    0.3207,    0.3207,    0.3207,    0.3207,    0.3381,    0.4226,     0.4651,     0.5049,     0.5175,      0.5033,      0.4919,      0.4815,     0.4729,     0.4653,     0.4586,     0.4528,     0.4479,     0.444,      0.441,      0.4371,     0.4341,     0.4321,     0.43,       0.4271,     0.426,      0.424    },
        Cza = {    0.3207,    0.3207,    0.3207,    0.3207,    0.3381,    0.4226,     0.4651,     0.5049,     0.5175,      0.5033,      0.4919,      0.4815,     0.4729,     0.4653,     0.4586,     0.4528,     0.4479,     0.444,      0.441,      0.4371,     0.4341,     0.4321,     0.43,       0.4271,     0.426,      0.424    },
        Mya = {    -0.7724,   -0.7724,   -0.7724,   -0.7724,   -0.8442,   -1.0226,    -0.9581,    -0.85133,   -0.7413,     -0.59726,    -0.49729,    -0.42745,   -0.37784,   -0.3414,    -0.31341,   -0.29077,   -0.27141,   -0.25428,   -0.23854,   -0.22399,   -0.21035,   -0.19771,   -0.18616,   -0.1758,    -0.16696,   -0.16075    },
        Mza = {    -0.7724,   -0.7724,   -0.7724,   -0.7724,   -0.8442,   -1.0226,    -0.9581,    -0.85133,   -0.7413,     -0.59726,    -0.49729,    -0.42745,   -0.37784,   -0.3414,    -0.31341,   -0.29077,   -0.27141,   -0.25428,   -0.23854,   -0.22399,   -0.21035,   -0.19771,   -0.18616,   -0.1758,    -0.16696,   -0.16075    },
        Myw = {    -9.55874,  -9.55874,  -9.55874,  -9.55874,  -9.81248,  -12.17459,  -10.86314,  -10.80419,  -10.7503,    -10.67431,   -10.57881,   -10.46632,  -10.33913,  -10.19945,  -10.04929,  -9.89055,   -9.72493,   -9.55397,   -9.37918,   -9.20172,   -9.02292,   -8.84372,   -8.66508,   -8.48791,   -8.31347,   -8.14394    },
        Mzw = {    -9.55874,  -9.55874,  -9.55874,  -9.55874,  -9.81248,  -12.17459,  -10.86314,  -10.80419,  -10.7503,    -10.67431,   -10.57881,   -10.46632,  -10.33913,  -10.19945,  -10.04929,  -9.89055,   -9.72493,   -9.55397,   -9.37918,   -9.20172,   -9.02292,   -8.84372,   -8.66508,   -8.48791,   -8.31347,   -8.14394    },
        A1trim = { 27.6,      27.6,      27.6,      27.6,      27.55,     30.38,      31.982,     32.774,     33.234,      33.561,      33.829,      34.07,      34.286,     34.491,     34.687,     34.875,     35.056,     35.232,     35.401,     35.564,     35.721,     35.871,     36.015,     36.151,     36.279,     36.4    },
        A2trim = { 27.6,      27.6,      27.6,      27.6,      27.55,     30.38,      31.982,     32.774,     33.234,      33.561,      33.829,      34.07,      34.286,     34.491,     34.687,     34.875,     35.056,     35.232,     35.401,     35.564,     35.721,     35.871,     36.015,     36.151,     36.279,     36.4    },


        model_roll = math.rad(45),
        fins_stall = 1,
    },

    seeker = {
        delay                       = 1.5,
        op_time                     = 300,
        FOV                         = math.rad(120),
        max_w_LOS                   = math.rad(30),
        sens_near_dist              = 100,
        sens_far_dist               = 60000,
        ccm_k0                      = 0.12,
        aim_sigma                   = 3.5,
        height_error_k              = 20,
        height_error_max_vel        = 50,
        height_error_max_h          = 300,
        hoj                         = 1,
        rad_correction              = 1,
        active_radar_lock_dist      = 60000.0,
        active_dist_trig_by_default = 1,
    },
    WCSE = {
        uplink_delay = 0.5,--0.5
        update_period = 0.5, --0.5
        ecm_burn_thru_rng = 35000,
        quant_steps  = 440, --240
    },
    INS = {
        op_time 			= 220,
        --dt 					= 0,
        dlink_outdate_time	= 70,
    },

    gimbal = {--引导头机械伺服机构
        delay                = 0,--启动延迟
        op_time              = 195,--工作时间
        pitch_max            = math.rad(70),--60 俯仰最大角度√
        yaw_max              = math.rad(70),--60 横向最大角度√
        max_tracking_rate    = math.rad(30),--最大跟踪速率
        tracking_gain        = 45,--40 跟踪性能
    },

    autopilot = {--自动姿态伺服机构
        delay                = 0.8,--动作延迟√
        op_time              = 300,--工作时间√
        Tf                   = 0.1,--时间常数
        Knav                 = 4.0,
        Kd                   = 180.0,
        Ka                   = 16.0,
        T1                   = 309.0,
        Tc                   = 0.06,
        Kx                   = 0.1,
        Krx                  = 2.0,
        gload_limit          = 38.0,-- 30.0最大允许过载√√
        fins_limit           = math.rad(30),--24.0 舵面最大偏转角度√
        fins_limit_x         = math.rad(5),
        null_roll            = math.rad(45),--滚转
        accel_coeffs         = { 0, 11.5,-1.2,-0.25, 24.0,
                                 0.0324 * 0.75 * 0.0091 },

        loft_active          = 1,
        loft_factor          = 4.5,
        loft_sin             = math.sin(30/57.3),
        loft_min_range       = 30000,
        loft_off_range       = 18000,
        dV0                  = 393,
    },

    actuator = {
        Tf                   = 0.005,
        D                    = 250.0,
        T1                   = 0.002,
        T2                   = 0.006,
        max_omega            = math.rad(400),--允许最大角速度
        max_delta            = math.rad(22),--20 允许舵面偏转加速度√
        fin_stall            = 1,
        sim_count            = 4,
    },

    proximity_fuze = {--近炸引信
        radius      = 11.0,--10 启动距离
        arm_delay   = 1.6,--延迟（ms）
    },

    -- loft   = 1,
    -- hoj    = 1,
    -- ccm_k0 = 0.08,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
    -- rad_correction = 1,
    -- loft_factor = 4.5,

    ModelData = {
        58 ,  -- model params count
        0.9 ,   -- characteristic square 

        -- параметры зависимости Сx--阻力
        0.015 , -- планка Сx0 на дозвуке ( M << 1) cx_k0
        0.050 , -- высота пика волнового кризиса cx_k1
        0.012 , -- крутизна фронта на подходе к волновому кризису cx_k2
        0.004 , -- планка Cx0 на сверхзвуке ( M >> 1) cx_k3
        1.20  , -- крутизна спада за волновым кризисом cx_k4
        0.90  , -- коэффициент отвала поляры

        -- параметры зависимости Cy
        0.90 , -- планка Сy0 на дозвуке ( M << 1)
        0.75 , -- планка Cy0 на сверхзвуке ( M >> 1)
        1.20 , -- крутизна спада(фронта) за волновым кризисом

        0.5 , -- 7 Alfa_max  максимальный балансировачный угол, радианы
        0.00, --угловая скорость создаваймая моментом газовых рулей

        --    t_statr   t_b      t_accel  t_march   t_inertial   t_break  t_end
        -1.0,   -1.0,       6.0,     4.0,      0.0,          0.0,      1.0e9,           -- time interval
        0.0,    0.0,       9.6,     2.8,      0.0,          0.0,        0.0,           -- fuel flow rate in second kg/sec(секундный расход массы топлива кг/сек)
        0.0,    0.0,   22770.0,  6530.0,      0.0,          0.0,        0.0,           -- thrust

        600, --1.0e9, -- таймер самоликвидации, сек  Self-destructive time, sec
        100.0, -- время работы энергосистемы, сек  Working time of power system, sec
        0, -- абсолютная высота самоликвидации, м  Absolute height of self-destruction, M
        1.0, -- время задержки включения управления (маневр отлета, безопасности), сек  Connection delay time (shunting departure, safety), sec
        30000, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр 'горка', м
        18000, -- дальность до цели, при которой маневр 'горка' завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м
        0.26,  -- синус угла возвышения траектории набора горки
        50.0, -- продольное ускорения взведения взрывателя  Longitudinal acceleration of fuze arming
        0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
        1.19, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
        1.0, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
        2.0, -- характристика системы САУ-РАКЕТА,  полоса пропускания контура управления

		--DLZ 发射距离计算数据（瞄准器上的指示）       
        21.0, 		-- 载机速度对发射距离的影响（海拔 1km，高速迎头拦截）
        -23.0, 		-- 目标速度对发射距离的影响（海拔 1km，追击目标）
        -3.0, 		-- 目标速度影响发射距离的变化率（海拔 1km，追击目标）
		            
        69000.0, 	-- 目标迎头方向 (180°)，海拔 5000m，速度 900 km/h 时的最大有效射程（单位：米）
        28000.0, 	-- 目标尾追方向 (0°)，海拔 5000m，速度 900 km/h 时的最大有效射程（单位：米）
		            
        105000.0, 	-- 目标迎头方向 (180°)，海拔 10000m，速度 900 km/h 时的最大有效射程（单位：米）
        44000.0, 	-- 目标尾追方向 (0°)，海拔 10000m，速度 900 km/h 时的最大有效射程（单位：米）
		            
        44000.0, 	-- 目标迎头方向 (180°)，海拔 1000m，速度 900 km/h 时的最大有效射程（单位：米）
        18500.0, 	-- 目标尾追方向 (0°)，海拔 1000m，速度 900 km/h 时的最大有效射程（单位：米）
		            
        4000.0,     -- 后方可达区域相对初始点的偏移量
		            
        0.4,        -- 保证命中距离相对于迎头拦截距离的百分比（海拔 1km）
        -0.015,     -- 保证命中距离对海拔变化的影响（迎头拦截）
        0.5,        -- 海拔影响导弹弹道曲线的变化率（上半球与下半球的调整系数）						
    },
}
declare_weapon(PL_15_AA)
--PL_15_AA.sounderName = "Weapons/LaserCannon"
PL_15_AA.shape_table_data.index = PL_15_AA.wsTypeOfWeapon[4]
local pl15cx = 0.00150390623
	-----PL-15挂载配置 单发-----
declare_loadout({
	category = CAT_AIR_TO_AIR,
	CLSID = "{J20A_PL15}",
	Picture = "PL15.png",
	attribute = PL_15_AA.wsTypeOfWeapon,
	displayName = _('霹雳-15 空空导弹'),
	Cx_pil = pl15cx,
	Count = 1,
	Weight = PL15_mass,
	Elements = {
		[1] = {
			DrawArgs = {
				[1] = {1, 1},
				[2] = {2, 1}
			},
			Position = {0, -0.5, 0},
			ShapeName = "PL-15_ByJ20A"
		}
	}
})
	-----PL-15挂载配置 PF12挂架双发-----
declare_loadout({
    category       = CAT_AIR_TO_AIR,
    CLSID          = 'J20_PL-15_DUAL',
    Picture        = 'pl15.png',
    wsTypeOfWeapon = PL_15_AA.wsTypeOfWeapon,
    attribute      = {4,4,32,WSTYPE_PLACEHOLDER},
    displayName    = _('霹雳-15 空空导弹')..' x 2',
    Cx_pil         = pl15cx*2,
    Count          = 2,
    Weight         = 2 * PL15_mass + pylon_dual_mass,
    Elements       = {
        { ShapeName = 'JF-17_PF12_twin', IsAdapter = true, },
        { ShapeName = 'PL-15_ByJ20A',        connector_name = 'dual_PF12L', },
        { ShapeName = 'PL-15_ByJ20A',        connector_name = 'dual_PF12R', },
    }, -- end of Elements
    JettisonSubmunitionOnly = true,
})
	-----PL-15挂载配置 内藏式无挂架双发-----
declare_loadout({
    category       = CAT_AIR_TO_AIR,
    CLSID          = 'BayArm_J20_PL-15_DUAL',
    Picture        = 'pl15.png',
    wsTypeOfWeapon = PL_15_AA.wsTypeOfWeapon,
    attribute      = {4,4,32,WSTYPE_PLACEHOLDER},
    displayName    = _('虚构弹仓版 霹雳-15 空空导弹')..' x 2',
    Cx_pil         = 0,
    Count          = 2,
    Weight         = 2 * PL15_mass,
    Elements       =
	{
        { ShapeName = 'PL-15_ByJ20A', Position	=	{0,	0,	0} },
        { ShapeName = 'PL-15_ByJ20A', Position	=	{0,	0,	0} },
    }, -- end of Elements
    --JettisonSubmunitionOnly = true,
})

-----PL-17-----
local J20A_PL17_name = 'J20A_PL_17'
local J20A_PL17_mass = 300 --261.5
	--local pylon_mass = 1.0
local J20A_PL17_AA = {
    category        = CAT_AIR_TO_AIR,
    name            = J20A_PL17_name,
    model           = 'J20A_PL17',
    user_name       = _("PL-17"),
	displayName		= _('霹雳-17'),
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
    mass            = J20A_PL17_mass,

	Escort 			= 0,
    Head_Type 		= 2,
	sigma 			= {5, 5, 5},
    M 				= J20A_PL17_mass,
    H_max 			= 200000.0,
    H_min 			= 100,
    Diam			= 178.0,
    Cx_pil 			= 2,
    D_max 			= 500000.0,
    D_min 			= 500.0,
    Head_Form 		= 1,
    Life_Time 		= 500.0,
    Nr_max 			= 45,
    v_min 			= 140.0,
    v_mid 			= 3000.0,
    Mach_max 		= 6.0,
    t_b 			= 0.0,
    t_acc 			= 10.0,
    t_marsh 		= 30.0,
    Range_max 		= 5000000.0,
    H_min_t 		= 3.0,
    Fi_start 		= 0.5,
    Fi_rak 			= 3.14152,
    Fi_excort 		= 1.05,
    Fi_search 		= 1.05,
    OmViz_max 		= 0.52,
    exhaust 		= {0.8, 0.8, 0.8, 0.05 };
    X_back 			= -3.24,
    Y_back 			= 0.0,
    Z_back 			= 0.0,
    Reflection 		= 0.16,
    KillDistance 	= 15.0,
	loft 			= 1,
	hoj 			= 1,
	ccm_k0 			= 0.2, -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
    rad_correction 	= 1,
    loft_factor 	= 35,
	loft_angle 		= 0.17,
	PN_gain 		= 4,
--	supersonic_A_coef_skew = 0.295,

	active_radar_lock_dist	= 18520.0,
	go_active_by_default	= 0,

	PN_coeffs = {4, 				-- 条目数量	
                 12000.0, 1.00,
                 18000.0, 0.75,
                 30000.0, 0.50,     -- 距目标小于5公里时 Pn = 1
                 48000.0, 0.20,
                };		-- 距目标15至10公里之间，Pn 从0.2平滑变化到0.5。超过15公里时 Pn = 0.2。

    warhead         = enhanced_a2a_warhead(100, 503),
    warhead_air     = enhanced_a2a_warhead(100, 503),
    supersonic_A_coef_skew = 0.1, -- 超音速时极点因子斜率
    nozzle_exit_area       = 0.01219, -- 喷嘴出口面积

    class_name      = 'wAmmunitionSelfHoming',
    --scheme          = 'aa_missile_amraam2',
    scheme          = 'aa_missile_amraam',

    controller = {
        boost_start = 0.5,
        march_start = 50,--30.5 二级发动机点火时间√
    },

    shape_table_data = {
        {
            name     = J20A_PL17_name,
            file     = 'PL-15_ByJ20A', --'J20A_PL17', --射出后的弹体模型
            life     = 1,
            fire     = {0, 1},
            username = "PL-17",		--短名称，用于座舱显示
            index    = WSTYPE_PLACEHOLDER,
        },
    },

    boost = {
        impulse                             = 472,--比冲√
        fuel_mass                           = 70.6,--燃料质量√
        work_time                           = 15.0,--发动机工作时间√
        nozzle_position                     = {{-3.1, 0, 0}},--发动机喷口位置
        nozzle_orientationXYZ               = {{0.0, 0.0, 0.0}},--发动机喷口方向
        nozzle_exit_area                    = 0.01219,--发动机喷口面积
        tail_width                          = 0.4,--导弹尾部弹径
        smoke_color                         = {1.5, 1.0, 1.0},--动力段尾烟色
        smoke_transparency                  = 0.5,--烟透明度
        custom_smoke_dissipation_factor     = 0.2,--消散因子速度
    },

    march = {
        impulse                             = 336,
        fuel_mass                           = 30.2,
        work_time                           = 10.0,
        nozzle_position                     = {{-3.1, 0, 0}},
        nozzle_orientationXYZ               = {{0.0, 0.0, 0.0}},
        nozzle_exit_area                    = 0.01219,
        tail_width                          = 0.4,
        smoke_color                         = {1.0, 1.0, 1.0},
        smoke_transparency                  = 0.5,
        custom_smoke_dissipation_factor     = 0.2,
    },

    fm = {--加减速性
        mass                = PL15_mass,
        caliber             = 0.203,
        wind_sigma          = 0.0,
        wind_time           = 0.0,
        tail_first          = 0,
        fins_part_val       = 0,
        rotated_fins_inp    = 0,
        delta_max           = math.rad(20),
        draw_fins_conv      = {math.rad(90),1,1},
        L                   = 0.203,
        S                   = 0.0324,
        Ix                  = 1.5,
        Iy                  = 190,
        Iz                  = 190,

        Mxd                 = 0.1 * 57.3,
        Mxw                 = -15.8,

        table_scale         = 0.2,
        table_degree_values = 1,
        -- Mach   | 0.0        0.2        0.4        0.6        0.8         1.0        1.2         1.4         1.6          1.8          2.0          2.2         2.4         2.6         2.8         3.0         3.2         3.4         3.6         3.8         4.0         4.2         4.4         4.6         4.8         5.0 |
        Cx0 = {    0.4727,    0.4727,    0.4727,    0.4727,    0.4838,    0.7609,     0.8869,     0.86198,    0.81793,     0.76899,     0.72481,     0.68476,    0.64836,    0.61529,    0.58515,    0.55744,    0.53195,    0.50829,    0.48624,    0.46561,    0.4461,     0.42772,    0.41035,    0.3941,     0.37898,    0.366    },
        CxB = {    0.021,     0.021,     0.021,     0.021,     0.021,     0.138,      0.153,      0.146,      0.1382,      0.1272,      0.1167,      0.1073,     0.0987,     0.0909,     0.0837,     0.077,      0.0708,     0.065,      0.0595,     0.0544,     0.0495,     0.0449,     0.0406,     0.0364,     0.0324,     0.0286    },--波阻
        K1  = {    0.00264,   0.00264,   0.00264,   0.00264,   0.00264,   0.00264,    0.0022,     0.001873,   0.0016435,   0.0014752,   0.0013448,   0.0012436,  0.0011534,  0.0010742,  0.0010149,  0.0009484,  0.0009016,  0.0008476,  0.000795,   0.0007529,  0.0007122,  0.0006727,  0.0006343,  0.0006058,  0.0005781,  0.00056    },
        K2  = {    -0.00257,  -0.00257,  -0.00257,  -0.00257,  -0.00257,  -0.00265,   -0.002274,  -0.002034,  -0.0018241,  -0.0016225,  -0.0014468,  -0.001275,  -0.0011248, -0.0009777, -0.0008514, -0.0007274, -0.0006236, -0.0005217, -0.0004393, -0.0003584, -0.0002968, -0.0002363, -0.0001949, -0.0001546, -0.0001335, -0.000114    },
        Cya = {    0.3207,    0.3207,    0.3207,    0.3207,    0.3381,    0.4226,     0.4651,     0.5049,     0.5175,      0.5033,      0.4919,      0.4815,     0.4729,     0.4653,     0.4586,     0.4528,     0.4479,     0.444,      0.441,      0.4371,     0.4341,     0.4321,     0.43,       0.4271,     0.426,      0.424    },
        Cza = {    0.3207,    0.3207,    0.3207,    0.3207,    0.3381,    0.4226,     0.4651,     0.5049,     0.5175,      0.5033,      0.4919,      0.4815,     0.4729,     0.4653,     0.4586,     0.4528,     0.4479,     0.444,      0.441,      0.4371,     0.4341,     0.4321,     0.43,       0.4271,     0.426,      0.424    },
        Mya = {    -0.7724,   -0.7724,   -0.7724,   -0.7724,   -0.8442,   -1.0226,    -0.9581,    -0.85133,   -0.7413,     -0.59726,    -0.49729,    -0.42745,   -0.37784,   -0.3414,    -0.31341,   -0.29077,   -0.27141,   -0.25428,   -0.23854,   -0.22399,   -0.21035,   -0.19771,   -0.18616,   -0.1758,    -0.16696,   -0.16075    },
        Mza = {    -0.7724,   -0.7724,   -0.7724,   -0.7724,   -0.8442,   -1.0226,    -0.9581,    -0.85133,   -0.7413,     -0.59726,    -0.49729,    -0.42745,   -0.37784,   -0.3414,    -0.31341,   -0.29077,   -0.27141,   -0.25428,   -0.23854,   -0.22399,   -0.21035,   -0.19771,   -0.18616,   -0.1758,    -0.16696,   -0.16075    },
        Myw = {    -9.55874,  -9.55874,  -9.55874,  -9.55874,  -9.81248,  -12.17459,  -10.86314,  -10.80419,  -10.7503,    -10.67431,   -10.57881,   -10.46632,  -10.33913,  -10.19945,  -10.04929,  -9.89055,   -9.72493,   -9.55397,   -9.37918,   -9.20172,   -9.02292,   -8.84372,   -8.66508,   -8.48791,   -8.31347,   -8.14394    },
        Mzw = {    -9.55874,  -9.55874,  -9.55874,  -9.55874,  -9.81248,  -12.17459,  -10.86314,  -10.80419,  -10.7503,    -10.67431,   -10.57881,   -10.46632,  -10.33913,  -10.19945,  -10.04929,  -9.89055,   -9.72493,   -9.55397,   -9.37918,   -9.20172,   -9.02292,   -8.84372,   -8.66508,   -8.48791,   -8.31347,   -8.14394    },
        A1trim = { 27.6,      27.6,      27.6,      27.6,      27.55,     30.38,      31.982,     32.774,     33.234,      33.561,      33.829,      34.07,      34.286,     34.491,     34.687,     34.875,     35.056,     35.232,     35.401,     35.564,     35.721,     35.871,     36.015,     36.151,     36.279,     36.4    },
        A2trim = { 27.6,      27.6,      27.6,      27.6,      27.55,     30.38,      31.982,     32.774,     33.234,      33.561,      33.829,      34.07,      34.286,     34.491,     34.687,     34.875,     35.056,     35.232,     35.401,     35.564,     35.721,     35.871,     36.015,     36.151,     36.279,     36.4    },

        model_roll = math.rad(45),
        fins_stall = 1,
    },

    seeker = {
        delay                       = 1.5,
        op_time                     = 300,
        FOV                         = math.rad(120),
        max_w_LOS                   = math.rad(30),
        sens_near_dist              = 100,
        sens_far_dist               = 60000,
        ccm_k0                      = 0.12,
        aim_sigma                   = 3.5,
        height_error_k              = 20,
        height_error_max_vel        = 50,
        height_error_max_h          = 300,
        hoj                         = 1,
        rad_correction              = 1,
        active_radar_lock_dist      = 60000.0,
        active_dist_trig_by_default = 1,
    },
    WCSE = {
        uplink_delay 				= 0.5,--0.5
        update_period 				= 0.5, --0.5
        ecm_burn_thru_rng 			= 35000,
        quant_steps  				= 440, --240
    },
    INS = {
        op_time 			= 300,
        --dt 					= 0,
        dlink_outdate_time	= 70,
    },

    gimbal = {--引导头机械伺服机构
        delay                = 0,--启动延迟
        op_time              = 300,--工作时间
        pitch_max            = math.rad(70),--60 俯仰最大角度√
        yaw_max              = math.rad(70),--60 横向最大角度√
        max_tracking_rate    = math.rad(30),--最大跟踪速率
        tracking_gain        = 45,--40 跟踪性能
    },

    autopilot = {--自动姿态伺服机构
        delay                = 0.8,--动作延迟√
        op_time              = 300,--工作时间√
        Tf                   = 0.1,--时间常数
        Knav                 = 4.0,
        Kd                   = 180.0,
        Ka                   = 16.0,
        T1                   = 309.0,
        Tc                   = 0.06,
        Kx                   = 0.1,
        Krx                  = 2.0,
        gload_limit          = 38.0,-- 30.0最大允许过载√√
        fins_limit           = math.rad(30),--24.0 舵面最大偏转角度√
        fins_limit_x         = math.rad(5),
        null_roll            = math.rad(45),--滚转
        accel_coeffs         = { 0, 11.5,-1.2,-0.25, 24.0,
                                 0.0324 * 0.75 * 0.0091 },

        loft_active          = 1,
        loft_factor          = 4.5,
        loft_sin             = math.sin(30/57.3),
        loft_min_range       = 30000,
        loft_off_range       = 18000,
        dV0                  = 393,
    },

    actuator = {
        Tf                   = 0.005,
        D                    = 250.0,
        T1                   = 0.002,
        T2                   = 0.006,
        max_omega            = math.rad(400),--允许最大角速度
        max_delta            = math.rad(22),--20 允许舵面偏转加速度√
        fin_stall            = 1,
        sim_count            = 4,
    },

    proximity_fuze = {--近炸引信
        radius      = 11.0,--10 启动距离
        arm_delay   = 1.6,--延迟（ms）
    },

    -- loft   = 1,
    -- hoj    = 1,
    -- ccm_k0 = 0.08,  
    -- rad_correction = 1,
    -- loft_factor = 4.5,

	ModelData = {   58 ,  -- 模型参数数量
					1.1 ,   -- 特征面积 (характеристическая площадь)

					-- Cx 依赖参数
					0.042 , -- Cx_k0 亚音速时的 Cx0 平台值 ( M << 1)
					0.083 , -- Cx_k1 波动危机峰值高度
					0.01 , -- Cx_k2 接近波动危机时的前沿陡峭度
					-0.245, -- Cx_k3 超音速时的 Cx0 平台值 ( M >> 1)
					0.12 , -- Cx_k4 波动危机后的下降陡峭度 
					0.18 , -- 极点偏移系数 (与 sqrt (M^2-1) 成正比)

					-- Cy 依赖参数
					1.6 , -- Cy_k0 亚音速时的 Cy0 平台值 ( M << 1)
					1.3	 , -- Cy_k1 超音速时的 Cy0 平台值 ( M >> 1)
					1.2  , -- Cy_k2 波动危机后的下降(前沿)陡峭度  

					0.35 , -- 7 Alfa_max 最大平衡角度，弧度
					10, --由气动舵产生的角速度

				-- 发动机数据. 时间, 燃料流量, 推力.	
				--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- 阶段
					 0.27,		-1.0,	32.0,  		32.0,		0.0,			0.0,		200,--1.0e9,         -- 阶段时间，秒
					 0.0,		0.0,	1.5,		1.0,		0.0,			0.0,		0.0,           -- 燃料流量，秒内的千克/秒
					 0.0,		0.0,	16000.0,	4700,		0.0,			0.0,		1000,           -- 推力，牛顿

					 1.0e9, -- 自毁计时器，秒
					 200.0, -- 能源系统工作时间，秒
					 0, -- 自毁的绝对高度，米
					 2.5, -- 启动控制的延迟时间（脱离机动，安全性），秒
					 40000, --40000 -- 发射时目标距离，超过此值导弹执行“爬升”机动，米
					 40000, --40000 -- 目标距离，导弹完成“爬升”机动并切换到纯比例导航的距离（应大于或等于前一个参数），米 
					 0.52356,--0.17, -- 爬升轨迹角度的正弦值
					 50.0, -- 引信激活的纵向加速度
					 0.0, -- 弹射装置、弹射药等提供的速度模块
					 36.0, -- 导弹自动控制系统特性，二阶滤波器系数 K0
					 7.8, -- 导弹自动控制系统特性，二阶滤波器系数 K1
					 2.0, -- 导弹自动控制系统特性，控制回路带宽

					--DLZ 发射距离计算数据（瞄准器上的指示）       
					 50.0,  	-- 载机速度对发射距离的影响（海拔 1km，高速迎头拦截）
					 -45.0, 	-- 目标速度对发射距离的影响（海拔 1km，追击目标）
					 -7.0,  	-- 目标速度影响发射距离的变化率（海拔 1km，追击目标）
								
					 72500, 	-- 目标迎头方向 (180°)，海拔 5000m，速度 900 km/h 时的最大有效射程（单位：米）
					 25500, 	-- 目标尾追方向 (0°)，海拔 5000m，速度 900 km/h 时的最大有效射程（单位：米）
								
					 120000,	-- 目标迎头方向 (180°)，海拔 10000m，速度 900 km/h 时的最大有效射程（单位：米）
					 46500, 	-- 目标尾追方向 (0°)，海拔 10000m，速度 900 km/h 时的最大有效射程（单位：米）
								
					 41000, 	-- 目标迎头方向 (180°)，海拔 1000m，速度 900 km/h 时的最大有效射程（单位：米）
					 20000, 	-- 目标尾追方向 (0°)，海拔 1000m，速度 900 km/h 时的最大有效射程（单位：米）
								
					 4000,  	-- 后方可达区域相对初始点的偏移量
								
					 0.4,   	-- 保证命中距离相对于迎头拦截距离的百分比（海拔 1km）
					 -0.015,	-- 保证命中距离对海拔变化的影响（迎头拦截）
					 0.7,   	-- 海拔影响导弹弹道曲线的变化率（上半球与下半球的调整系数）						
    },
}
declare_weapon(J20A_PL17_AA)
	--J20A_PL17_AA.sounderName = "Weapons/LaserCannon"
J20A_PL17_AA.shape_table_data.index = J20A_PL17_AA.wsTypeOfWeapon[4]
	-----PL-17挂载配置 单发-----
declare_loadout({
	category		=	CAT_AIR_TO_AIR,
	CLSID			= 	"{J20A_PL17}",
	Picture			=	"J20A_pl17.png",
	wsTypeOfWeapon	=	J20A_PL17_AA.wsTypeOfWeapon,
	displayName		=	_("霹雳-17"),
	attribute		=	{4,	4,	32,	WSTYPE_PLACEHOLDER},
	Count			=	1,
	Weight			=	J20A_PL17_mass,
	Elements		=
	{
		{
			ShapeName	=	"J20A_PL17",
			Position	=	{0,	0,	0}
		},
	},
})
	-----PL-17挂载配置 虚构弹仓版 四发-----
declare_loadout({
	category		=	CAT_AIR_TO_AIR,
	CLSID			= 	"{BayArm_J20_PL-17_x4}",
	Picture			=	"J20A_pl17.png",
	wsTypeOfWeapon	=	J20A_PL17_AA.wsTypeOfWeapon,
	displayName		=	_("虚构弹仓版 霹雳-17".."x4"),
	attribute		=	{4,	4, 32,	WSTYPE_PLACEHOLDER},
	Cx_pil         	= 	0,
	Count			=	4,
	Weight			=	J20A_PL17_mass*4,
	Elements		=
	{
		{
			ShapeName	=	"",
			Position	=	{0,	0, 0}
		},
		{
			ShapeName	=	"",
			Position	=	{0,	0, 0}
		},
		{
			ShapeName	=	"",
			Position	=	{0,	0, 0}
		},
		{
			ShapeName	=	"",
			Position	=	{0,	0, 0}
		},
	},
})

--GUN---
Comet = {
    category 				= CAT_SHELLS,
	name 					= "Comet_J20",
	user_name 				= _("Comet"),
	model_name    			= "Laser_Ammo",
	v0						= 32000.0,
	Dv0 = 0.001,
	Da0 = 2.5E-4,
	Da1     				= 0.0,
	mass      				= 0.72,
	explosive     			= 0,
	cumulative_mass 		= 0.72,
	cumulative_thickness 	= 0.1,
	life_time     			= 100,
	caliber     			= 31.0,
	s         				= 0.0,
	j         				= 0.0,
	l         				= 0.0,
	charTime    			= 0,
	cx        				= {0.01,0.01,0.01,0.01,0.01},
	k1        				= 1.5e-09,
	tracer_off				= 100,
	cartridge 				= 0,
	aiming_table			=
	{
		precalculateAimingTable = true,
		[1] = { init_vel = 32000.0 }
	},
}
ElectromagneticCannon = {}
CopyTable(ElectromagneticCannon,Comet)
ElectromagneticCannon.name = "J20_Iron_Shot"
ElectromagneticCannon.user_name = _("Iron Shot")
ElectromagneticCannon.model_name = "pula"
ElectromagneticCannon.v0 = 3000
ElectromagneticCannon.mass = 1.0
ElectromagneticCannon.explosive = 70.72
ElectromagneticCannon.cumulative_mass = 70.72
ElectromagneticCannon.cx = {0.01,0.01,0.01,0.01,0.01}
ElectromagneticCannon.aiming_table[1].init_vel = 3000

declare_weapon(Comet)
declare_weapon(ElectromagneticCannon)
Comet.sounderName = "Weapons/LaserCannon"
ElectromagneticCannon.sounderName = "Weapons/LaserCannon"

GunTemplate = {
    ElectromagneticCannon={
        name = "J20_ElectromagneticCannon",

        supply = {
            shells = {
                ElectromagneticCannon
            },
            mixes = {
                { 1 },
            },
            count = 20,
        },
        gun =
        {
            max_burst_length = 1, --按一次扳机，一次性发射多少弹药
            rates            = { 99999 }, --射速
            recoil_coeff     = 1.5, --后座系数
            barrels_count    = 1, --枪口数量，例如多管机枪
        },
        effects = {
            { name = "FireEffect"     , arg = 436 },
			{ name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
			{ name = "SmokeEffect"}
        }
    },
    Comet = {
        name = "J20_Comet",

        supply = {
            shells = {
                Comet
            },
            mixes = {
                { 1 },
            },
            count = 6000,
        },
        gun =
        {
            max_burst_length = 600, --按一次扳机，一次性发射多少弹药
            rates            = { 6000 }, --射速
            recoil_coeff     = 0.0, --后座系数
            barrels_count    = 1, --枪口数量，例如多管机枪
        },
        effects = {}
    },
    GSH_23_2 = {
        name = "J20_GSH_23_2",
        supply = {
            shells = {
                'GSH23_23_HE','GSH23_23_AP','GSH23_23_HE_T'
            },
            mixes = {
                {1},
                {2,2,2,2,1},
                {3}
            },
            count = 648
        },
        gun = {
            max_burst_length = 648,
            rates = {3000},
            recoil_coeff = 0.91,
            barrels_count = 2
        },
        effects = {
            {
                arg = 432,
                attenuation = 2,
                light_pos = { 0.5, 0.5, 0 },
                light_time = 0.1,
                name = "FireEffect"
            },
            {
                barrel_k = 7.6692,
                body_k = 16.3548,
                name = "HeatEffectExt",
                shot_heat = 20.9
            },
            {
                name = "SmokeEffect"
            }
        }
    }
}
function J_20_GunMount(tbl,templateGun)
	tbl.category 	= CAT_GUN_MOUNT
	tbl.name		= "J-20_GunMount"
    if templateGun then
        tbl.supply 	= templateGun.supply
        tbl.gun 	= templateGun.gun
    else
        tbl.supply =
        {
            shells = {
                Comet
            },
            mixes = {
                { 1 },
            },
            count = 20,
        }
        tbl.gun =
        {
            max_burst_length = 1, --按一次扳机，一次性发射多少弹药
            rates            = { 99999 }, --射速
            recoil_coeff     = 0, --后座系数
            barrels_count    = 1, --枪口数量，例如多管机枪
        }
    end
	if tbl.mixes then
	   tbl.supply.mixes =  tbl.mixes
	   tbl.mixes	    = nil
	end
	if tbl.count then
	   tbl.supply.count =  tbl.count
	   tbl.count	    = nil
	end
	if tbl.rates then
	   tbl.gun.rates    =  tbl.rates
	   tbl.rates	    = nil
	end
	tbl.ejector_pos 			= tbl.ejector_pos or {-1.707, -0.322, 0.153}
	tbl.ejector_dir 			= {0,-1,1}
	tbl.supply_position  		= tbl.supply_position or {-1.661,0.021,-0.045}
	tbl.aft_gun_mount 			= false
	tbl.effective_fire_distance = tbl.effective_fire_distance or 24000
	tbl.drop_cartridge 			= tbl.drop_cartridge or 0
	tbl.muzzle_pos				= tbl.muzzle_pos or  {0,0,0} -- all position from connector
	tbl.muzzle_pos_connector	= tbl.muzzle_pos_connector or  "GUN_POINT" -- all position from connector
	tbl.azimuth_initial 		= tbl.azimuth_initial    or 0
	tbl.elevation_initial 		= tbl.elevation_initial  or 0
	if  tbl.effects == nil then
		tbl.effects = {}
	end
	return declare_weapon(tbl)
end
-----电磁、激光炮吊舱-----
declare_loadout(
	{
		category			=  CAT_PODS,
		CLSID				= "J20C_Laser_Cannon_POD",
		displayName			= _("Laser Cannon Pod"),
		Picture				=	"gunpod.png",
		attribute			= {wsType_Weapon, wsType_GContainer, wsType_Cannon_Cont, WSTYPE_PLACEHOLDER},
		wsTypeOfWeapon		= {wsType_Weapon, wsType_Shell, wsType_Shell_A, wsTypeVulkan},
		Weight				= 1000 + (20 * Comet.mass), -- INCLUDE AMMO FOR FULL WEIGHT
        Weight_Empty        = 1000,
		Cx_pil				= 0.01220703125,
		kind_of_shipping	= 2,--SOLID_MUNITION
		gun_mounts			= {
			J_20_GunMount({muzzle_pos_connector = 'GunPoint'},GunTemplate.Comet)
		},
		shape_table_data =
		{
			{
				name		= "J_20C_Laser_Cannon";
				file		= "LaserCannon";
				life		= 1;
				fire		= {0, 1};
				username	= "J_20C_Laser_Cannon";
				index		= WSTYPE_PLACEHOLDER;
			},
		},
		Elements = {
			[1]	= {
				Position	=	{0, 0, 0},
				ShapeName	=	"LaserCannon",
			},
		}, -- end of Elements
	}
)
declare_loadout(
	{
		category			=  CAT_PODS,
		CLSID				= "J20C_EML_POD",
		displayName			= _("Electromagnetic Cannon Pod"),
		Picture				=	"gunpod.png",
		attribute			= {wsType_Weapon, wsType_GContainer, wsType_Cannon_Cont, WSTYPE_PLACEHOLDER},
		wsTypeOfWeapon		= {wsType_Weapon, wsType_Shell, wsType_Shell_A, wsTypeVulkan},
		Weight				= 1000 + (20 * ElectromagneticCannon.mass), -- INCLUDE AMMO FOR FULL WEIGHT
        Weight_Empty        = 1000,
		Cx_pil				= 0.01220703125,
		kind_of_shipping	= 2,--SOLID_MUNITION
		gun_mounts			= {
			J_20_GunMount({muzzle_pos_connector = 'GunPoint'},GunTemplate.ElectromagneticCannon)
		},
		shape_table_data =
		{
			{
				name		= "J_20C_EMC";
				file		= "LaserCannon";
				life		= 1;
				fire		= {0, 1};
				username	= "J_20C_EMC";
				index		= WSTYPE_PLACEHOLDER;
			},
		},
		Elements = {
			[1]	= {
				Position	=	{0, 0, 0},
				ShapeName	=	"LaserCannon",
			},
		}, -- end of Elements
	}
)

--m3_browing({muzzle_pos = {2.91,   0.42,  -0.5 }  	, rates = {1249},mixes = {{2,1,1,1,1,1}},effect_arg_number = 434,azimuth_initial = 0,elevation_initial = 0,supply_position = {2, -0.3, -0.4}}), --up

-----yj12反舰导弹-----
local yj12_name  = 'J20C_YJ-12'
local yj12_model = 'yj12'
local yj12_mass  = 1750.0
local pylon_mass = 50.0

local YJ12_warhead = {
    mass                 = 200,
    caliber              = 480,
    expl_mass            = 100,
    piercing_mass        = 0.0,
    other_factors        = { 1.0, 1.0, 1.0 },
    concrete_factors     = { 3.0, 1.0, 1.0 },
    concrete_obj_factor  = 2.0,
    obj_factors          = { 3.0, 1.0 },
    cumulative_factor    = 2.0,
    cumulative_thickness = 0.0,
}

local yj12_use_scheme = true

YJ12_AS = {
    category       = CAT_MISSILES,
    name           = yj12_name,
    user_name      = _(yj12_name),
    display_name   = _(yj12_name),
    model          = yj12_model,
    mass           = yj12_mass,
    wsTypeOfWeapon = {4, 4, 8, WSTYPE_PLACEHOLDER},

    Escort         = 0,
    Head_Type      = 5, -- 5,
    sigma          = {8, 8, 8},
    M              = yj12_mass,
    H_max          = 15000.0,
    H_min          = -1,
    Diam           = 756.0,
    Cx_pil         = 1,
    D_max          = 400000.0,
    D_min          = 10000.0,
    Head_Form      = 1,
    Life_Time      = 1850.0,
    Nr_max         = 15,
    v_min          = 170.0,
    v_mid          = 850.0,
    Mach_max       = 3.5,
    t_b            = 2.0,
    t_acc          = 5.0,
    t_marsh        = 1800.0,
    Range_max      = 400000.0,
    H_min_t        = 0.0,
    Fi_start       = 3.14152,
    Fi_rak         = 3.14152,
    Fi_excort      = 3.14152, -- 0.35,
    Fi_search      = 99.9,
    OmViz_max      = 99.9,
    Stage_         = 2,
    Engine_Type    = 5,
    X_back         = -2.5,
    Y_back         = 0.0,
    Z_back         = 0.0,
    X_back_acc     = -3.5,
    Y_back_acc     = 0.0,
    Z_back_acc     = 0.0,
    exhaust1       = { 1.0, 1.0, 1.0, 1.0 },
    Reflection     = 1.0,
    KillDistance   = 0.0,

    manualWeaponFlag = 2,

    --[[LaunchDistData =
    {
        -- launch altitude: 500m - 7500m
        -- http://www.sinaimg.cn/dy/slidenews/8_img/2011_45/22159_89924_239722.jpg
          12,        7,
                   100,      125,      150,      175,       200,       250,       300,
         500,    150000,      155000,    160000,      165000,     170000,    175000,       180000,
         600,    152000,      157000,    162000,      167000,     172000,    177000,       182000,
         700,    154000,      159000,    164000,      169000,     174000,    179000,       184000,
         800,    156000,      161000,    166000,      171000,     176000,    181000,       186000,
         900,    158000,      163000,    168000,      173000,     178000,    183000,       188000,
        1000,    160000,      165000,    170000,      175000,     180000,    185000,       190000,
        1200,    163000,      168000,    173000,      178000,     183000,    188000,       193000,
        2200,    170000,      175000,    180000,      185000,     189000,    194000,       199000,
        3200,    176000,      181000,    186000,      191000,     194000,    199000,       204000,
        4200,    181000,      186000,    191000,      196000,     199000,    203000,       208000,
        5200,    185000,      190000,    195000,      199000,     203000,    207000,       212000,
        7500,    190000,      195000,    200000,      204000,     208000,    212000,       217000,

    },]]

    warhead     = YJ12_warhead,
    warhead_air = YJ12_warhead,

    --add_attributes = {"Anti-Ship missiles"},
    add_attributes = {"Cruise missiles"},

    shape_table_data = {
        {
            name     = yj12_name,
            file     = yj12_model,
            life     = 4,
            fire     = {0, 1},
            username = yj12_name,
            index    = WSTYPE_PLACEHOLDER,
        },
    },
}

if yj12_use_scheme then
    YJ12_AS.class_name      = 'wAmmunitionSelfHoming'
    YJ12_AS.scheme          = 'anti_ship_missile_ramjet'

    YJ12_AS.controller = {
        boost_start = 1.000,
        march_start = 6.500,
    }

    YJ12_AS.boost = {
        impulse                              = 250,
        fuel_mass                            = 360,
        work_time                            = 5,
        boost_time                           = 0,
        boost_factor                         = 0,
        nozzle_position                      = {{-3.5, 0, 0}},
        nozzle_orientationXYZ                = {{0.0, 0.0, 0.0}},
        tail_width                           = 0.8,
        smoke_color                          = {1, 1, 1},
        smoke_transparency                   = 1.0,
        custom_smoke_dissipation_factor      = 0.2,
        effect_type                          = 0,
    }

    YJ12_AS.march = {
        impulse                              = 0,
        fuel_mass                            = 550,
        work_time                            = 0,
        boost_time                           = 0,
        boost_factor                         = 0,
        nozzle_position                      = {{-2.5, 0, 0}},
        nozzle_orientationXYZ                = {{0.0, 0.0, 0.0}},
        tail_width                           = 0.2,
        smoke_color                          = {0.9, 0.9, 0.9},
        smoke_transparency                   = 0.1,
        custom_smoke_dissipation_factor      = 0.45,
        effect_type                          = 1,
        min_start_speed                      = 500,

        inlet_area = 0.028 * 4,
        Tchamb_max = 2770,
        LHVof_fuel = 43e6,
        AFR_stoich = 23,
        AEC        = 1.35,
    }

    YJ12_AS.fm = {
        mass        = yj12_mass,
        caliber     = 0.480,
        cx_coeff    = {1,1.0,0.85,0.5,1.5},
        L           = 7.0,
        I           = 1 / 12 * yj12_mass * 7.0 * 7.0,
        Ma          = 0.4,
        Mw          = 1.2,
        wind_sigma  = 0.0,
        wind_time   = 0.0,
        Sw          = 0.7,
        dCydA       = {0.07, 0.036},
        A           = 0.36,
        maxAoa      = 0.28,
        finsTau     = 0.1,
        lockRoll    = 1,

        Ma_x        = 0.001,
        Mw_x        = 0.15,
        I_x         = 60,
    }

    YJ12_AS.fuze_proximity = {
        ignore_inp_armed = 1,
    }

    YJ12_AS.seeker = {
        delay                        = 1.0,
        op_time                      = 900.0,
        FOV                          = math.rad(60),
        max_w_LOS                    = 0.05,
        max_target_speed             = 33.0,
        max_target_speed_rnd_coeff   = 10.0,
        ship_track_by_default        = 0,
        flag_dist                    = 50000.0,
        sens_near_dist               = 10.0,
        sens_far_dist                = 80000.0,
        primary_target_filter        = 0,
        add_y                        = 0.0,
    }

    YJ12_AS.autopilot =
    {
        glide_height                = 2000.0,
        dont_climb_on_cruise_height = 0,
        vel_proj_div                = 25.0,
        default_glide_height        = 2000.0,
        pre_maneuver_glide_height   = 1000.0,
        skim_glide_height           = 200.0,
        use_start_bar_height        = 1,
        altim_vel_k                 = 5.0,

        delay                 = 1.0,
        op_time               = 900,
        Kw                    = 1,
        Ks                    = 8,
        K                     = 50.0,
        Kd                    = 0.1,
        Ki                    = 0.0,
        Kx                    = 0.04,
        Kdx                   = 0.001,
        w_limit               = math.rad(8),
        fins_limit            = math.rad(45),
        fins_limit_x          = math.rad(25),
        rotated_WLOS_input    = 0,
        conv_input            = 0,
        fins_q_div            = 1,
        PN_dist_data          = {2000,    0,
                                  500,    0},

        max_climb_angle       = math.rad(10),
        max_dive_angle        = math.rad(-35),
        max_climb_ang_hdiff   = 200,
        max_dive_ang_hdiff    = -200,

        Ksd                   = 0.1,
        Ksi                   = 0.0,
        integr_val_limit      = 0.5,
        hor_err_limit         = 0.5,

        inertial_km_error     = 2.0, -- m for 1000m dist
        glide_height_eq_error = 0.5, -- percent
    }

    YJ12_AS.final_autopilot = {
        delay                = 1.0,
        op_time              = 900,
        Kw                   = 2,
        Ks                   = 10,
        K                    = 60.0,
        Kd                   = 0.15,
        Ki                   = 0.0,
        Kx                   = 0.0,
        Kix                  = 0.0,
        w_limit              = math.rad(25),
        fins_limit           = math.rad(45),
        rotated_WLOS_input   = 0,
        conv_input           = 0,
        fins_q_div           = 1,
        PN_dist_data         = {100000,    0,
								 80000,	 0.5,
								 50000,	 0.8,
                                 15000,    1},

        add_err_val          = 0.014,
        add_err_vert         = 1,
        add_out_val          = 0,
        add_out_vert         = 0,
        loft_angle           = 0,
        loft_trig_angle      = 0,
        K_loft_err           = 0,
        loft_angle_vert      = 0,
    }

    YJ12_AS.triggers_control = {
        action_wait_timer                 = 3,    -- wait for dist functions n sen, then set default values
        default_sensor_tg_dist            = 60000, -- turn on seeker and start horiz. correction if target is locked
        final_maneuver_by_default         = 1,
        default_final_maneuver_tg_dist    = 30000,
        default_destruct_tg_dist          = 60000,    -- if seeker still can not find a target explode warhead after reaching pred. target point + n. km
        trigger_by_path                   = 1,
    }

    YJ12_AS.encyclopediaAnimation = {
        args = {
            [1] = 1.00,
        },
    }

end
declare_weapon(YJ12_AS)

declare_loadout({
    category       = CAT_MISSILES,
    CLSID          = 'J20_YJ12',
    Picture        = 'yj12.png',
    wsTypeOfWeapon = YJ12_AS.wsTypeOfWeapon,
    attribute      = {4, 4, 32, WSTYPE_PLACEHOLDER},
    displayName    = _('YJ-12'),
    Cx_pil         = 0.0023,
    Count          = 1,
    Weight         = yj12_mass + pylon_mass,
    Elements       = {
        {
            ShapeName = "adapter_df4b",
            IsAdapter = true,
            animation = {
                arg_num    = 1,
                rate_out   = 17.0,
                rate_in    = 1.0,
                init_value = 0.0
            }
        },
        {
            ShapeName = yj12_model,
            connector_name = "adapter_cnt",
        },
    }, -- end of Elements
    JettisonSubmunitionOnly = true,
    ejectVelocity = 2,
})
-----EOTS-----
declare_loadout(
	{
		category		= CAT_PODS,
		CLSID			= "J_20A-EOTS",
		attribute		= {4,	15,	44,	WSTYPE_PLACEHOLDER},
		Weight			= 47.2 + 11.1 + 1.1 + 2.1,
		Count 			= 1,
		Cx_pil			= 0.0005949,
		Picture			= "ANAAS38.png",
--		PictureBlendColor= '0x00000000',		
		displayName		= _("J-20A EOTS"),
		shape_table_data =
		{
			{
				file	= "J-20A_EOTS";
				life	= 1;
				fire	= { 0, 1};
				username	= "J-20A_EOTS";
				index	= WSTYPE_PLACEHOLDER;
			},
		},

		Elements		={
			{
				ShapeName	=	"J-20A_EOTS",
			}
		},
		Sensors	 =
		{
			OPTIC  = {"FLIR Star Safire"},
		},
	}
)
-----激光重型小牛-----
declare_loadout(
	{
		category		= CAT_MISSILES,
		CLSID			= "J_20A_AGM-65E",
		attribute		= {4,	4,	8,	70},
		Weight			= 286,
		Count 			= 1,
		Cx_pil			= 1.7/4096,
		Picture			= "agm65.png",
--		PictureBlendColor= '0x00000000',		
		displayName		= _('AGM-65E 激光重型小牛'),
		Elements		={
			{
				ShapeName	=	"AGM-65E",
			}
		},
	}
)
