-- for warhead functions and default warheads map (for warheads["AIM_65"])
-- DSplayer Edited 2023-01-14 V1.1.0 (MWMF14)
dofile("Scripts/Database/Weapons/warheads.lua")

local AIM_120C = {
    category        = CAT_AIR_TO_AIR,
    name        	= "AIM_120C-5",
    user_name        = _("AIM-120C-5 AMRAAM"),
	--[[
	scheme			= "aa_missile_amraam",
	class_name		= "wAmmunitionSelfHoming",
	model			= "AIM-120C",
	]]
    wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},

    shape_table_data =
    {
        {
            name	 = "AIM_120C";
            file  = "aim-120c";
            life  = 1;
            fire  = { 0, 1};
            username = "AIM-120C AMRAAM";
            index = WSTYPE_PLACEHOLDER,
        },
    },
	
	
        Escort = 0,
        Head_Type = 2,
        sigma = {5, 5, 5},
		M = 161.48,
        H_max = 26000.0,
        H_min = 1.0,
        Diam = 160.0,
        Cx_pil = 2.5,
        D_max = 16000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 90.0,
        Nr_max = 30,
        v_min = 140.0,
        v_mid = 700.0,
        Mach_max = 4.0,
        t_b = 0.5,
        t_acc = 3.0,
        t_marsh = 5.0,
        Range_max = 61000.0,
        H_min_t = 1.0,
        Fi_start = 0.88,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 1.05,
        OmViz_max = 0.52,
        warhead 	= predefined_warhead("AIM_120"),
		warhead_air = predefined_warhead("AIM_120"),
        exhaust = {0.8, 0.8, 0.8, 0.05 };
        X_back = -1.98,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.07,
        KillDistance = 15.0,
        ccm_k0 = 0.225,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
        go_active_by_default = 1,
        active_radar_lock_dist = 18520,
        PN_gain = 4,
        loft = 1,
        hoj = 1,
        loft_factor = 4.5,
		rad_correction = 1,
		smoke_opacity_type	= 1,

        supersonic_A_coef_skew = 0.1, -- slope of the straight line of the polar dump coefficient at supersonic
        nozzle_exit_area = 0.0132, -- nozzle exit area
        

        ModelData = {   58 ,  -- model params count
                        0.5 ,   -- characteristic square (характеристическая площадь)
                	
                        -- параметры зависимости Сx
                       0.029 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
						0.06 , -- Cx_k1 высота пика волнового кризиса
						0.01 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
						-0.245, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
						0.08 , -- Cx_k4 крутизна спада за волновым кризисом 
						0.7 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
					
						-- параметры зависимости Cy
						1.4 , -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
						0.6	 , -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
						1.2  , -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
						
						0.5 , -- 7 Alfa_max  максимальный балансировачный угол, радианы
						0.0, --угловая скорость создаваймая моментом газовых рулей
                        
                        -- Engine data. Time, fuel flow, thrust.	
                        --	t_statr        t_b        t_accel        t_march        t_inertial        t_break        t_end        	-- Stage
                        -1.0,        -1.0,	6.5,          0.0,        0.0,        	0.0,        1.0e9,         -- time of stage, sec
                        0.0,        0.0,	7.886,        0.0,        0.0,        	0.0,        0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
                        0.0,        0.0,	18096.79,	0.0,	0.0,        	0.0,        0.0,           -- thrust, newtons
                	
                        1.0e9, -- таймер самоликвидации, сек
						100.0, -- время работы энергосистемы, сек
						0, -- абсолютная высота самоликвидации, м
						1.0, -- время задержки включения управления (маневр отлета, безопасности), сек
						25000, --40000 -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
						15000, --40000 -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
						0.52356,--0.17, -- синус угла возвышения траектории набора горки
						50.0, -- продольное ускорения взведения взрывателя
						0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
						1.19, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
						1.0, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
						2.0, -- характеристика системы САУ-РАКЕТА,  полоса пропускания контура управления
						-- ЗРП. Данные для рассчета дальностей пуска (индикация на прицеле)
						21.0, -- производная дальности по скорости носителя на высоте 1км, ППС
						-23.0, -- производная дальности по скорости цели на высоте 1км, ЗПС
						-3.0, -- производная по высоте производной дальности по скорости цели, ЗПС
						35000.0, -- дальность ракурс 180 град (навстречу), Н=5000м, V=900км/ч, м
						12000.0, -- дальность ракурс 0(в догон) град, Н=5000м, V=900км/ч, м
						75000.0, -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м 69km
						21500.0, -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
						25000.0, -- дальность ракурс 180 град (навстречу), Н=1000м, V=900км/ч, м
						7500.0, -- дальность ракурс 0(в догон) град, Н=1000м, V=900км/ч, м 
						4000.0, -- смещение назад отнсительно нуля задней точки зоны достижимости
						0.4, -- процент гарантированной дальности от дальности в ППС на высоте 1км
						-0.015, -- производная процента гарантированной дальности в ППС по высоте
						0.5,
                	},
		--[[
		controller = {
			boost_start = 0.5,
			march_start = 2.6,
		},
		
		boost = {
			impulse								= 236,
			fuel_mass							= 18.21,
			work_time							= 2.1,
			nozzle_position						= {{-1.9, 0, 0}},
			nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
			nozzle_exit_area 					= 0.0132,
			tail_width							= 0.4,
			smoke_color							= {0.8, 0.8, 0.8},
			smoke_transparency					= 0.03,
			custom_smoke_dissipation_factor		= 0.2,
		},

		march = {
			impulse								= 227,
			fuel_mass							= 28.33,
			work_time							= 5.0,
			nozzle_position						= {{-1.9, 0, 0}},
			nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
			nozzle_exit_area 					= 0.0132,
			tail_width							= 0.4,
			smoke_color							= {0.8, 0.8, 0.8},
			smoke_transparency					= 0.03,
			custom_smoke_dissipation_factor		= 0.2,

--		fuel_rate_data	=	{	--t		rate
--								0.0,	2.0,
--								4.0,	1.8,
--							},
		},

		fm = {
			mass				= 157.85,
			caliber				= 0.178,
			wind_sigma			= 0.0,
			wind_time			= 0.0,
			tail_first			= 0,
			fins_part_val		= 0,
			rotated_fins_inp	= 0,
			delta_max			= math.rad(20),
			draw_fins_conv		= {math.rad(90),1,1},
			L					= 0.178,
			S					= 0.0248,
			Ix					= 1.24,
			Iy					= 130.12,
			Iz					= 130.12,

			Mxd					= 0.1 * 57.3,
			Mxw					= -15.8,

			table_scale	= 0.2,
			table_degree_values = 1,
		--	Mach	  | 0.0		0.2		0.4		0.6		0.8		1.0		1.2		1.4		1.6		1.8		2.0		2.2		2.4		2.6		2.8		3.0		3.2		3.4		3.6		3.8		4.0	 	4.2		4.4		4.6		4.8		5.0 |
			Cx0 	= {	0.515,	0.515,	0.515,	0.515,	0.527,	0.85,	0.949,	0.905,	0.8605,	0.8094,	0.7636,	0.7204,	0.6813,	0.6458,	0.6135,	0.5839,	0.5567,	0.5316,	0.5082,	0.4864,	0.4659,	0.4468,	0.4288,	0.4121,	0.3968,	0.384  },
			CxB 	= {	0.021,	0.021,	0.021,	0.021,	0.021,	0.138,	0.153,	0.146,	0.1382,	0.1272,	0.1167,	0.1073,	0.0987,	0.0909,	0.0837,	0.077,	0.0708,	0.065,	0.0595,	0.0544,	0.0495,	0.0449,	0.0406,	0.0364,	0.0324,	0.0286 },
			K1		= { 0.0039,	0.0039,	0.0039,	0.0039,	0.0039,	0.0048,	0.004,	0.00325,	0.002845,	0.002602,	0.002378,	0.002176,	0.001994,	0.001832,	0.001689,	0.001564,	0.001456,	0.001366,	0.00129,	0.001229,	0.001182,	0.001147,	0.001123,	0.001108,	0.001101,	0.0011 },
			K2		= { -0.0041,-0.0041,-0.0041,-0.0041,-0.0041,-0.0049,-0.0042,-0.0036,	-0.003121,	-0.002725,	-0.002408,	-0.00213,	-0.001888,	-0.001677,	-0.001494,	-0.001334,	-0.001196,	-0.001077,	-0.000973,	-0.000884,	-0.000808,	-0.000743,	-0.000689,	-0.000646,	-0.000615,	-0.0006 },
			Cya		= { 0.345,	0.345,	0.345,	0.345,	0.357,	0.401,	0.448,	0.495,	0.513,	0.506,	0.5,	0.495,	0.49,	0.486,	0.482,	0.478,	0.474,	0.471,	0.468,	0.465,	0.462,	0.46,	0.457,	0.455,	0.453,	0.451 },
			Cza		= { 0.345,	0.345,	0.345,	0.345,	0.357,	0.401,	0.448,	0.495,	0.513,	0.506,	0.5,	0.495,	0.49,	0.486,	0.482,	0.478,	0.474,	0.471,	0.468,	0.465,	0.462,	0.46,	0.457,	0.455,	0.453,	0.451 },
			Mya		= { -1.316,-1.316,	-1.316,	-1.316,	-1.458,	-1.982,	-1.418,	-1.0883,-0.9411,-0.8255,-0.733,	-0.6574,-0.5942,-0.5403,-0.4935,-0.4525,-0.4164,-0.3846,-0.3568,-0.3328,-0.3125,-0.2959,-0.283,-0.2739,-0.2683,-0.2665 },
			Mza		= { -1.316,-1.316,	-1.316,	-1.316,	-1.458,	-1.982,	-1.418,	-1.0883,-0.9411,-0.8255,-0.733,	-0.6574,-0.5942,-0.5403,-0.4935,-0.4525,-0.4164,-0.3846,-0.3568,-0.3328,-0.3125,-0.2959,-0.283,-0.2739,-0.2683,-0.2665 },
			Myw		= { -16.3145,-16.3145,-16.3145,-16.3145,-16.8944,-19.8659,-18.1868,-17.1716,-16.504,-15.88,-15.2958,-14.7478,-14.2328,-13.7477,-13.2901,-12.8574,-12.4477,-12.0593,-11.6911,-11.3421,-11.0121,-10.7015,-10.4118,-10.1458,-9.9098,-9.7256 },
			Mzw		= { -16.3145,-16.3145,-16.3145,-16.3145,-16.8944,-19.8659,-18.1868,-17.1716,-16.504,-15.88,-15.2958,-14.7478,-14.2328,-13.7477,-13.2901,-12.8574,-12.4477,-12.0593,-11.6911,-11.3421,-11.0121,-10.7015,-10.4118,-10.1458,-9.9098,-9.7256 },
			A1trim	= { 24,		24,		24,		24,		23.5,	23,		25.16,	27.23,	29.04,	30.6,	31.93,	33.08,	34.07,	34.95,	35.74,	36.45,	37.09,	37.68,	38.2,	38.66,	39.06,	39.39,	39.66,	39.85,	39.96,	40 },
			A2trim	= { 24,		24,		24,		24,		23.5,	23,		25.16,	27.23,	29.04,	30.6,	31.93,	33.08,	34.07,	34.95,	35.74,	36.45,	37.09,	37.68,	38.2,	38.66,	39.06,	39.39,	39.66,	39.85,	39.96,	40 },

			model_roll = math.rad(45),
			fins_stall = 1,
		},

		sensor = {
			delay						= 1.5,
			op_time						= 80,
			FOV							= math.rad(15),
			max_w_LOS					= math.rad(30),
			sens_near_dist				= 100,
			sens_far_dist				= 30000,
			ccm_k0						= 0.225,
			aim_sigma					= 4.0,
			height_error_k				= 25,
			height_error_max_vel		= 60,
			height_error_max_h			= 300,
			hoj							= 1,
		},
	
		gimbal = {
			delay				= 0,
			op_time				= 95,
			pitch_max			= math.rad(60),
			yaw_max				= math.rad(60),
			max_tracking_rate	= math.rad(30),
			tracking_gain		= 50,
		},

		autopilot = {
			delay				= 1.0,
			op_time				= 80,
			Tf					= 0.1,
			Knav				= 4.0,
			Kd					= 110.0,
			Ka					= 22.0,
			T1					= 292.0,
			Tc					= 0.04,
			Kx					= 0.1,
			Krx					= 2.0,
			gload_limit			= 30.0,
			fins_limit			= math.rad(18),
			fins_limit_x		= math.rad(5),
			null_roll			= math.rad(45),
			accel_coeffs		= { 0, 3.4, -0.4, -0.2, 13.6,
								0.0248 * 1.0 * 0.009 },

			loft_active			= 1,
			loft_factor			= 4.5,
			loft_sin			= math.sin(30/57.3),
			loft_off_range		= 15000,
			dV0					= 347,
		},

		actuator = {
			Tf					= 0.005,
			D					= 250.0,
			T1					= 0.002,
			T2					= 0.006,
			max_omega			= math.rad(400),
			max_delta			= math.rad(20),
			fin_stall			= 1,
			sim_count			= 4,
		},

		proximity_fuze = {
			radius		= 7.0,
			arm_delay	= 1.6,
		},
		]]
}
declare_weapon(AIM_120C)

declare_loadout(
	{	-- AIM-120C
        category        =	CAT_AIR_TO_AIR,
        CLSID        	= 	"{AIM_120C}",
        Picture        	=	"aim120c.png",
        --wsTypeOfWeapon	=	AIM_120C.wsTypeOfWeapon,
        displayName        =	AIM_120C.user_name,
        --attribute        =	{wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
        attribute        =	AIM_120C.wsTypeOfWeapon,
        Cx_pil        	=	AIM_120C.Cx_pil / 4096.0,
        Count        	=	1,
        Weight        	=	AIM_120C.M,
        Elements	=
        {
        	--{	ShapeName	=	"HB_F14_EXT_PHX_ALU"  ,	IsAdapter  	   =   true  },
        	
        	{
                DrawArgs	=
                {
                	[1]	=	{1,	1},
                	[2]	=	{2,	1},
                }, -- end of DrawArgs
        	--	Position	=	{-5, -5, -5}, --DOESNT WORK -DSPLAYER
                --connector_name = "WEP_Phoenix_FrontPallette_L_ALU",
                ShapeName	=	"aim-120c",
        	},
        }, -- end of Elements
	}
)

local function shoulder_AIM_120C(clsid, element, elem_CLSID)  -- side L or R
	local ret = {
        category        	=	CAT_AIR_TO_AIR,
        CLSID               =	clsid,
        Picture             =	"aim120c.png",
        wsTypeOfWeapon      =	AIM_120C.wsTypeOfWeapon,
        attribute        	=	{4,	4,	32,	WSTYPE_PLACEHOLDER},
        Cx_pil              =	1.33 * (element.Cx_pil/4096.0),
                                -- per F-14 perf manual:
                                -- shoulder AIM54 drag index = 12
                                -- AIM54 shoulder adapter index = 3
                                -- total drag index = 15, add 25% more drag to shoulder AIM54
        Count               =	1,
        Weight              =	element.M + 45.36,  --100lbs for LAU-93
        JettisonSubmunitionOnly = true,
        Elements        	=
        {
        	{	ShapeName	=	"HB_F14_EXT_SPARROW_PYLON" ,IsAdapter  =   true  },
--        	{	payload_CLSID = elem_CLSID , connector_name =  "WEP_Sparrow_Connector", use_full_connector_position = true}
        	{	ShapeName	=	"AIM-120C" , connector_name =  "WEP_Sparrow_Connector", use_full_connector_position = true},
        }-- end of Elements
	}
    -- actually a LAU-93 adapter, the LAU-93 is internal to the adapter (and the rails also have LAU-93)
	--ret.displayName =	_("LAU-93 ").." "..element.name
	--ret.displayName =	element.name
    ret.displayName = element.user_name
	declare_loadout(ret)
end
shoulder_AIM_120C("{SHOULDER AIM-120C}", AIM_120C, "{AIM_120C}")
--[[ Belly AIM-120C
local function f14_belly_AIM_120C(clsid, element, elem_CLSID)
	local ret = {
		category			=	CAT_AIR_TO_AIR,
		CLSID				=	clsid,
		Picture				=	"aim120.png",
		Count				=	1,
		Weight				=	element.M,
        attribute			=   AIM_120C.wsTypeOfWeapon,
		Cx_pil				=	(2.25 / 4096.0),--0.001959765625,
 -- AKO this value is almost 4x higher than 2.21/4096!
								-- note: cannot reduce belly AIM7 drag here without affecting missile flyout performance
		Count				=	1,
		Weight				=	element.M,
		Weight_Empty		=	0,
		Elements			=
		{
			{	ShapeName	=	"AIM-120C"}
		}-- end of Elements
	}
    -- actually LAU-92 adapter, the LAU-92 is internal to the adapter and also internal in the F-14 belly sparrow slots
	--ret.displayName =	_("LAU-92").." "..missilename
    ret.displayName =	element.user_name

	declare_loadout(ret)
end

f14_belly_AIM_120C("{BELLY AIM-120C}", AIM_120C, "{AIM_120C}")
]]

--shoulder_AIM_120C("{SHOULDER AIM-120C}", AIM_120C, "{AIM_120C}")

--AIM-120
local function lau_115_2x127_F14(clsid,weapon_info,left,right,attach_offset)
	
	local lau_115_plus_127_mass = 145
    local lvl2 = weapon_info.level2
    if type(weapon_info.wsType)=="table" then
      lvl2 = weapon_info.wsType[2]
    end
	local ret = {
		category			=	weapon_info.category,
		CLSID				=	clsid,
		Picture				=	weapon_info.picture,
		attribute			=	{wsType_Weapon,	lvl2,	wsType_Container, WSTYPE_PLACEHOLDER},
		Cx_pil				=	0.001,
		Elements 			= { }
	}
    if type(weapon_info.wsType)=="table" and weapon_info.wsType[4] ~= nil then
        ret.wsTypeOfWeapon = weapon_info.wsType
    end
    if type(weapon_info.wsType)=="string" then
        ret.wsTypeOfWeapon = weapon_info.wsType
    end
    ret.Elements[#ret.Elements + 1] = { ShapeName	= "LAU-115C+2_LAU127",IsAdapter  =   true}
    local sz = 0
	if left then
        sz = sz + 1
        ret.Elements[#ret.Elements + 1] = {ShapeName = weapon_info.ShapeName, connector_name =	"Point03"}
		if (attach_offset ~= nil) then
		  ret.Elements[#ret.Elements].attach_point_position = attach_offset
		end
    end
	if right then
        sz = sz + 1
        ret.Elements[#ret.Elements + 1] = {ShapeName = weapon_info.ShapeName, connector_name =	"Point02"}
		if (attach_offset ~= nil) then
		  ret.Elements[#ret.Elements].attach_point_position = attach_offset
		end
    end

	ret.Count  = sz
	ret.Weight = lau_115_plus_127_mass + sz * weapon_info.mass

	ret.Cx_pil = ret.Cx_pil + sz * weapon_info.Cx
	
	if sz > 1 then
		ret.displayName =	"LAU-115 with 2x LAU-127 "..weapon_info.name
	else
		ret.displayName =	"LAU-115 with 1x LAU-127 "..weapon_info.name
	end
	declare_loadout(ret)
    return ret
end

local function harm_adapter_nested(clsid,nested_loadout,position_offset,rotation_offset)
    local harm_adapter_mass = 0.001 -- TODO
	local ret = {
		category			=	nested_loadout.category,
		CLSID				=	clsid,
		Picture				=	nested_loadout.Picture,
		attribute			=	{wsType_Weapon,	nested_loadout.attribute[2],	wsType_Container,	WSTYPE_PLACEHOLDER},
		Cx_pil				=	0.001, -- TODO: what is reasonable?
   		JettisonSubmunitionOnly = true,
		Elements 			= {
        }
	}
    if nested_loadout.wsTypeOfWeapon ~= nil then
        ret.wsTypeOfWeapon		=	nested_loadout.wsTypeOfWeapon
    end
	if (position_offset == nil) then
		position_offset = {0,-0.085,0}
	end
	if (rotation_offset == nil) then
		rotation_offset = {0,0,1.6}
	end
	
    ret.Elements[#ret.Elements + 1] = { ShapeName	= "HB_F14_EXT_LANTIRN_PYLON", IsAdapter  =   true  }
    ret.Elements[#ret.Elements + 1] = {payload_CLSID = nested_loadout.CLSID, Position = position_offset, Rotation = rotation_offset}
	ret.Count  = nested_loadout.Count
	ret.Weight = harm_adapter_mass + nested_loadout.Weight


	ret.Cx_pil = ret.Cx_pil + nested_loadout.Cx_pil

	--ret.displayName =	_("PHX ")..nested_loadout.displayName
	ret.displayName =	nested_loadout.displayName
	declare_loadout(ret)
    return ret
end

local function bru32_adapter_nested(clsid,nested_loadout,attach_offset)
    local bru32_adapter_mass = 0.001 -- TODO
	local ret = {
		category			=	nested_loadout.category,
		CLSID				=	clsid,
		Picture				=	nested_loadout.Picture,
		attribute			=	{wsType_Weapon,	nested_loadout.attribute[2],	wsType_Container,	WSTYPE_PLACEHOLDER},
		Cx_pil				=	0.001, -- TODO: what is reasonable?
   		JettisonSubmunitionOnly = true,
		Elements 			= {
        }
	}
    if nested_loadout.wsTypeOfWeapon ~= nil then
        ret.wsTypeOfWeapon		=	nested_loadout.wsTypeOfWeapon
    end
	if (attach_offset == nil) then
		attach_offset = {0,0,0}
	end
    ret.Elements[#ret.Elements + 1] = { ShapeName	= "HB_F14_EXT_BRU34", IsAdapter  =   true  }
    ret.Elements[#ret.Elements + 1] = {payload_CLSID = nested_loadout.CLSID,connector_name =  "WEP_BRU-34_MK84",attach_point_position = attach_offset}
	ret.Count  = nested_loadout.Count
	ret.Weight = bru32_adapter_mass + nested_loadout.Weight


	ret.Cx_pil = ret.Cx_pil + nested_loadout.Cx_pil

	--ret.displayName =	_("PHX ")..nested_loadout.displayName
	ret.displayName =	nested_loadout.displayName
	declare_loadout(ret)
    return ret
end

local f14_aim120c = {
    category = CAT_AIR_TO_AIR,
	level2 = wsType_Missile,
    name = "AIM-120C-5 AMRAAM",
    payload_CLSID = "{AIM_120C}",
    mass = AIM_120C.M, -- db_weapons_data.lua
--	mass = 60,
    wsType = AIM_120C.wsTypeOfWeapon,
    Cx = 2.5 / 4096.0, -- bombs_data.lua
--	Cx_pil = 4, -- bombs_data.lua
    ShapeName = "aim-120c",
    picture = "aim120c.png"
}

local function amber_rack_f14(clsid,weapon_info,left,right)
	
	local amber_mass = 150
    local lvl2 = weapon_info.level2
    if type(weapon_info.wsType)=="table" then
      lvl2 = weapon_info.wsType[2]
    end
	local ret = {
		category			=	weapon_info.category,
		CLSID				=	clsid,
		Picture				=	weapon_info.picture,
		attribute			=	{wsType_Weapon,	lvl2,	wsType_Container, WSTYPE_PLACEHOLDER},
		Cx_pil				=	0.001,
		JettisonSubmunitionOnly = true,
		Elements 			= { }
	}
    if type(weapon_info.wsType)=="table" and weapon_info.wsType[4] ~= nil then
        ret.wsTypeOfWeapon = weapon_info.wsType
    end
    if type(weapon_info.wsType)=="string" then
        ret.wsTypeOfWeapon = weapon_info.wsType
    end
    ret.Elements[#ret.Elements + 1] = { ShapeName	= "AMBER",	IsAdapter  =   true}
    local sz = 0
	if left then
        sz = sz + 1
        ret.Elements[#ret.Elements + 1] = {ShapeName = weapon_info.ShapeName, Position	=	{0.0,	-0.1,	0.16},}
    end
	if right then
        sz = sz + 1
        ret.Elements[#ret.Elements + 1] = {ShapeName = weapon_info.ShapeName, Position	=	{0.0,	-0.1,	-0.16},}
    end

	ret.Count  = sz
	ret.Weight = amber_mass + sz * weapon_info.mass

	ret.Cx_pil = ret.Cx_pil + sz * weapon_info.Cx

    if sz > 1 then
        ret.displayName =	"AMBER Rack with "..sz.."x "..weapon_info.name
    else
        ret.displayName =	weapon_info.name
    end
	declare_loadout(ret)
    return ret
end

--[[
declare_loadout({
    category        = CAT_AIR_TO_AIR,
    CLSID           = "{F14AMBER_2xAIM120C5}",
    wsTypeOfWeapon  = AIM_120C.wsTypeOfWeapon,
    attribute       = {4, 4, 32, WSTYPE_PLACEHOLDER},
    Count           = 2,
    Picture         = "aim120c.png",
    displayName     = _('AMBER 2*' .. AIM_120C.user_name),
    Weight          = AIM_120C.M * 2 + 150,
	Cx_pil 			= ((AIM_120C.Cx_pil * 2) / 4096) + 0.001
	Elements = {
	
		{
			ShapeName	=	"AMBER",
			IsAdapter = true,
		},
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},
			Position	=	{0.0,	-0.1,	0.16}, --1
			ShapeName	=	"aim-120c",
			Rotation = {-0,0,0},
		},
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},
			Position	=	{0.0,	-0.1,	-0.16}, --2
			ShapeName	=	"aim-120c",
			Rotation = {0,0,0},
		},
		
	},
    
    JettisonSubmunitionOnly = true,
})
]]

local amber_2x120C = amber_rack_f14("{AMBER_2xAIM120C}", f14_aim120c, true, true)
local lau_115_2xAIM120C = lau_115_2x127_F14("{LAU_115_2xAIM120C}", f14_aim120c, true, true)

harm_adapter_nested("{AMBER_SHOULDER_2xAIM_120C}", amber_2x120C, {0,-0.2,0}, nil )
bru32_adapter_nested("{BRU32_AMBER_2xAIM_120C}", amber_2x120C, {0,-0.1,0})

harm_adapter_nested("{SHOULDER_2xAIM_120C}", lau_115_2xAIM120C, nil, nil )
bru32_adapter_nested("{BRU32_2xAIM_120C}", lau_115_2xAIM120C, nil )