-- for warhead functions and default warheads map (for warheads["AIM_65"])
-- DSplayer Edited 2025-01-30 V1.1.11
dofile("Scripts/Database/Weapons/warheads.lua")



--JDAM
local GBU_31_V_2B_F14 = {
	category		= CAT_BOMBS,
	name			= "GBU_31_V_2B_F14",
--	name 			= "Mk-84",
	model			= "GBU-31",
	user_name		= _("GBU-31(V)2/B"),
	displayName		= _("GBU-31(V)2/B - JDAM, 2000lb GPS Guided Bomb"),
	wsTypeOfWeapon	= {wsType_Weapon, wsType_Bomb, wsType_Bomb_A, WSTYPE_PLACEHOLDER},
	scheme			= "bomb-common",
	class_name		= "wAmmunition",
	type			= 0,
	mass			= 934.0,
	hMin			= 400.0,
--	hMin			= 100.0,
	hMax			= 15000.0,
--	hMax			= 10000.0,
	VyHold			= -100.0,
	Ag				= -1.23,

	fm = { -- Mk-82 FM Values (excluding mass)
		mass		= 934.0,
		caliber		= 0.457,
		cx_coeff	= {1.0, 0.39, 0.6, 0.168, 1.31},
		L			= 2.5,
		I			= 864.446267,
		Ma			= 2.746331,
		Mw			= 2.146083,
		wind_time	= 1000.0,
		wind_sigma	= 220.0,
	},
	
--[[
	fm = { --GBU-31 FM Values 
		mass			= 934.0,
		caliber			= 0.457,
		cx_coeff		= {1, 0.45, 0.8, 0.15, 1.55},
		L				= 0.457,
		I				= 515.2,
		Ma				= 6.3,
		Mw				= 3.0,
		wind_time		= 1000.0,
		wind_sigma		= 80.0,
	},
]]

	warhead = predefined_warhead("Mk_84"),

	shape_table_data =
	{
		{
			name		= "GBU_31_V_2B_F14",
			file		= "GBU-31",
			life		= 1,
			fire		= {0, 1},
			username	= _("GBU-31(V)2/B"),
			index		= WSTYPE_PLACEHOLDER,
		},
	},

	targeting_data = {
		char_time = 20.32,
	},
}
declare_weapon(GBU_31_V_2B_F14)

declare_loadout( --GBU-31
{
    category = CAT_BOMBS,
    CLSID	=	"{BRU-32 GBU-31}",
    Picture	=	"gbu31.png",
	displayName	=	_("GBU-31(V)2/B"),
--	displayName	=	GBU_31_V_2B_F14.name,
    Weight_Empty = 57.38,   -- 100lbs+26.5lbs
    Weight	= 57.38 + GBU_31_V_2B_F14.mass,  -- 940kg from wikipedia, db_weapons_data.lua says 1162 though
    wsTypeOfWeapon	= GBU_31_V_2B_F14.wsTypeOfWeapon,
    attribute      = {wsType_Weapon,wsType_Bomb,wsType_Container,WSTYPE_PLACEHOLDER},
    Count = 1,
    Cx_pil = 0.00002,
    Cx_item = 0.000793, -- see bombs_data.lua

    Elements	=
    {
        { ShapeName	= "HB_F14_EXT_BRU34" ,IsAdapter  =   true  },  -- combination ADU-703 & BRU-32
        {
            ShapeName	=	"GBU-31",
            connector_name =  "WEP_BRU-34_MK84",
            --use_full_connector_position = true,
        },
    }, -- end of Elements
})

local GBU_38_F14 = {
	category		= CAT_BOMBS,
	name			= "GBU_38",
--	name			= "Mk-82",
	model			= "GBU-38",
	user_name		= _("GBU-38"),
	displayName		= _("GBU-38 - JDAM, 500lb GPS Guided Bomb"),
	wsTypeOfWeapon	= {wsType_Weapon, wsType_Bomb, wsType_Bomb_A, WSTYPE_PLACEHOLDER},
	scheme			= "bomb-common",
	class_name		= "wAmmunition",
	type			= 0,
	mass 			= 228.0,
	hMin			= 400.0,
--	hMin			= 100.0,
	hMax			= 15000.0,
--	hMax			= 10000.0,
	VyHold			= -100.0,
	Ag				= -1.23,

	fm = { --Mk-82 FM (except mass)
		mass            = 228.0,
		caliber         = 0.273,
		cx_coeff        = {1.0, 0.29, 0.71, 0.14, 1.28},
		L               = 2.21,
		I               = 94.425933,
		Ma              = 2.746331,
		Mw              = 2.146083,
		wind_time       = 1000.0,
		wind_sigma      = 80.0,
	},

	warhead = predefined_warhead("Mk_82"),

	shape_table_data =
	{
		{
			name		= "GBU_38",
			file		= "GBU-38",
			life		= 1,
			fire		= {0, 1},
			username	= _("GBU-38"),
			index		= WSTYPE_PLACEHOLDER,
		},
	},

	targeting_data = {
		char_time = 20.32,
	},
}
declare_weapon(GBU_38_F14)

declare_loadout( --GBU-38
{
    category = CAT_BOMBS,
    CLSID	=	"{BRU-32 GBU-38}",
    Picture	=	"gbu38.png",
	displayName	=	_("GBU-38"),
--	displayName	=	_(GBU_38_F14.name),
    Weight_Empty = 57.38,   -- 100lbs+26.5lbs
    Weight	= 57.38 + GBU_38_F14.mass,  -- see db_weapons_data.lua
    wsTypeOfWeapon	= GBU_38_F14.wsTypeOfWeapon,
    attribute      = {wsType_Weapon,wsType_Bomb,wsType_Container,WSTYPE_PLACEHOLDER},
    Count = 1,
    Cx_pil = 0.00002,
    Cx_item = 0.000640, -- see bombs_data.lua

    Elements	=
    {
        { ShapeName	= "HB_F14_EXT_BRU34" ,IsAdapter  =   true  },  -- combination ADU-703 & BRU-32
        {
            ShapeName	=	"GBU-38",
            connector_name =  "WEP_BRU-34_MK84",
            --use_full_connector_position = true,
        },
    }, -- end of Elements
})

local GBU_54_F14 = {
	category		= CAT_BOMBS,
	name			= "GBU_54",
--	name			= "Mk-82",
	model			= "GBU-54",
	user_name		= _("GBU-54B"),
	displayName		= _("GBU-54B - LJDAM, 500lb Laser & GPS Guided Bomb LD"),
	wsTypeOfWeapon	= {wsType_Weapon, wsType_Bomb, wsType_Bomb_A, WSTYPE_PLACEHOLDER},
	scheme			= "bomb-common",
	class_name		= "wAmmunition",
	type			= 0,
	mass			= 253.0,
	hMin			= 400.0,
--	hMin			= 100.0,
	hMax			= 15000.0,
--	hMax			= 10000.0,
	VyHold			= -100.0,
	Ag				= -1.23,

	fm = { --Mk-82 FM values (except mass)
		mass            = 253.0,
		caliber         = 0.273,
		cx_coeff        = {1.0, 0.29, 0.71, 0.14, 1.28},
		L               = 2.21,
		I               = 94.425933,
		Ma              = 2.746331,
		Mw              = 2.146083,
		wind_time       = 1000.0,
		wind_sigma      = 80.0
	},


	warhead = predefined_warhead("Mk_82"),

	shape_table_data =
	{
		{
			name		= "GBU_54",
			file		= "GBU-54",
			life		= 1,
			fire		= {0, 1},
			username	= _("GBU-54"),
			index		= WSTYPE_PLACEHOLDER,
		},
	},

	targeting_data = {
		char_time = 20.32,
	},
}
declare_weapon(GBU_54_F14)

declare_loadout( --GBU-54
{
    category = CAT_BOMBS,
    CLSID	=	"{BRU-32 GBU-54}",
    Picture	=	"gbu54.png", -- TODO: need GBU24.png ?
	displayName	=	_("GBU-54"),
--	displayName = 	_(GBU_54_F14.name),
    Weight_Empty = 57.38,   -- 100lbs+26.5lbs
    Weight	= 57.38 + GBU_54_F14.mass,  -- 1050kg from wikipedia, 900 from db_weapons_data.lua though
    wsTypeOfWeapon	= GBU_54_F14.wsTypeOfWeapon,
    attribute      = {wsType_Weapon,wsType_Bomb,wsType_Container,WSTYPE_PLACEHOLDER},
    Count = 1,
    Cx_pil = 0.00002,
    Cx_item = 0.000793, -- see bombs_data.lua

    Elements	=
    {
        { ShapeName	= "HB_F14_EXT_BRU34" ,IsAdapter  =   true  },  -- combination ADU-703 & BRU-32
        {
            ShapeName	=	"GBU-54",
            connector_name =  "WEP_BRU-34_MK84",
            --use_full_connector_position = true,
        },
    }, -- end of Elements
})

-- AGM-123 Skipper II | For some reason it only works in the JDAM lua and not any other lua.
-- local AGM_123_F14 =
-- {
-- 	category		= CAT_MISSILES,
-- 	name			= "AGM-123",
-- 	user_name		= _("AGM-123 Skipper II"),
-- 	class_name 		= "wAmmunitionLaserHoming",
-- 	scheme 			= "SKIPPER",  -- Custom Modified AGM-65E scheme
-- 	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
-- 	model			= "gbu-16",
	
-- 	mass	= 582,
-- 	Escort = 1,
--     Head_Type = 4,
-- 	sigma = {5, 5, 5},
-- 	M = 582.0,
-- 	H_max = 10000.0,
-- 	H_min = -1,
-- 	Diam = 305.0,
-- 	Cx_pil = 4,
-- 	D_max = 18520.0,
--     D_min = 1000.0,
-- 	Head_Form = 0,
-- 	Life_Time = 110,
-- 	Nr_max = 16,
-- 	v_min = 50.0,
-- 	v_mid = 290.0,
-- 	Mach_max = 1.5,
-- 	t_b = 0.0,
-- 	t_acc = 4.0,
-- 	t_marsh = 0.0,
-- 	Range_max = 11112.0,
-- 	H_min_t = 0.0,
-- 	Fi_start = 0.5,
-- 	Fi_rak = 3.14152,
-- 	Fi_excort = 1.05,
-- 	Fi_search = 99.9,
-- 	OmViz_max = 99.9,
-- 	exhaust = {1, 1, 1, 1},
-- 	X_back = 0.0,
-- 	Y_back = 0.0,
-- 	Z_back = 0.0,
-- 	Reflection = 0.035,
-- 	KillDistance = 0.0,

-- 	shape_table_data =
-- 	{
-- 		{
-- 			name		= "AGM_123",
-- 			file		= "gbu-16",
-- 			life		= 1,
-- 			fire		= { 0, 1},
-- 			username	= _("AGM-123 Skipper II"),
-- 			index		= WSTYPE_PLACEHOLDER,
-- 		},
-- 	},
-- 	--[[
-- 	fm = {
-- 		mass        = 582,  
-- 		caliber     = 0.356,  
-- 		cx_coeff    = { 1, 0.29, 0.71, 0.13, 1.28 },
-- 		L           = 2.49,
-- 		I           = 1 / 12 * 209 * 2.49 * 2.49,
-- 		Ma          = 0.68,
-- 		Mw          = 1.116,
-- 		wind_sigma	= 0.0,
-- 		wind_time	= 0.0,
-- 		Sw			= 0.55,
-- 		dCydA		= {0.07, 0.036},
-- 		A			= 0.36,
-- 		maxAoa		= 0.1221730476396,
-- 		finsTau		= 0.1,
-- 		Ma_x		= 3,
-- 		Mw_x		= 3.3,
-- 		I_x			= 40,
-- 	},
-- 	]]
-- 	fm = {
-- 		A = 0.36,
-- 		I = 701.206875,
-- 		L = 4.05,
-- 		Ma = 0.70068748047097,
-- 		Ma_x = 0.1,
-- 		Mw = 4.0666945548937,
-- 		Mw_x = 1,
-- 		Sw = 0.6,
-- 		caliber = 0.356,
-- 		cx_coeff = { 1, 0.29, 0.71, 0.13, 1.28 },
-- 		dCydA = { 0.082881465845167, 0.036 },
-- 		finsTau = 0.1,
-- 		mass = 513,
-- 		maxAoa = 0.1221730476396,
-- 		wind_sigma = 0,
-- 		wind_time = 1000,
-- 	},
	
-- 	laser_spot_seeker = {
-- 		FOV					= 0.558,
-- 		max_seeker_range	= 18520,
-- 	},
-- 	--[[
-- 	bang_bang_autopilot = {
-- 		omegaDumpingK = 0.36,
-- 	},
-- 	--]]
	
-- 	PN_autopilot = {
-- 		K			= 0.014,
-- 		Ki			= 0,
-- 		Kg			= 1.4,
-- 		Kx			= 0.02,
-- 		fins_limit	= 0.3,
-- 		K_GBias		= 0.26,
-- 	},
	
-- 	march = {
-- 		fuel_mass   			= 36,
-- 		impulse     			= 160,
-- 		boost_time  			= 0,
-- 		work_time   			= 9,
-- 		boost_factor			= 0,
-- 		nozzle_position 	    = { { -0.5, 0, 0 } },
-- 		nozzle_orientationXYZ   = {{0, 0, 0}},
-- 		tail_width  			= 0.3,
-- 		boost_tail  			= 1,
-- 		work_tail   			= 1,
-- 		smoke_color				= { 0.6, 0.6, 0.6 },
-- 		smoke_transparency		= 0.8,
-- 		custom_smoke_dissipation_factor		= 0.2,		
-- 	},
	
-- 	warhead 	= predefined_warhead("Mk_82"),
-- 	warhead_air = predefined_warhead("Mk_82"),
-- }
-- declare_weapon(AGM_123_F14)

-- Failed APKWS scheme AGM_123

local AGM_123_F14 =
{
	category		= CAT_MISSILES,
	name			= "AGM-123",
	user_name		= _("AGM-123 Skipper II"),
	scheme			= "APKWS",
--	scheme			= "laser_homing_gyrost_missile",
	class_name		= "wAmmunitionLaserHoming",
	model			= "gbu-16",
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	
	mass			= 582,
	Escort			= 1,
	Head_Type		= 4,
	sigma			= {1, 1, 1},
	H_max			= 5000.0,
	H_min			= 1.0,
	Diam			= 70.0,
	Cx_pil			= 4,
	D_max			= 5000.0,
	D_min			= 1000.0,
	Head_Form		= 1,
	Life_Time		= 90.0,
	Nr_max			= 25,
	v_min			= 140.0,
	v_mid			= 500.0,
	Mach_max		= 3.0,
	t_b				= 0.0,
	t_acc			= 0.0,
	t_marsh			= 1.1,
	Range_max		= 5000.0,
	H_min_t			= 15.0,
	Fi_start		= 0.4,
	Fi_rak			= 3.14152,
	Fi_excort		= 1.05,
	Fi_search		= 0.7,
	OmViz_max		= 0.35,
	exhaust			= {0.78, 0.78, 0.78, 0.3};
	X_back			= -2.0,
	Y_back			= -0.0,
	Z_back			= 0.0,
	Reflection		= 0.035,
	KillDistance	= 0.0,
	M				= 582,
	
	warhead		= predefined_warhead("Mk_82"),
	
	shape_table_data =
	{
		{
			name  = "AGM_123";
			file  = "gbu-16";
			life  = 1;
			fire  = { 0, 1};
			username = _("AGM-123 Skipper II"),
			index 	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	march = {
		fuel_mass   			= 36,
		impulse     			= 160,
		boost_time  			= 0,
		work_time   			= 9,
		boost_factor			= 0,
		nozzle_position 	    = { { -0.5, 0, 0 } },
		nozzle_orientationXYZ   = {{0, 0, 0}},
		tail_width  			= 0.3,
		boost_tail  			= 1,
		work_tail   			= 1,
		smoke_color				= { 0.6, 0.6, 0.6 },
		smoke_transparency		= 0.8,
		custom_smoke_dissipation_factor		= 0.2,		
	},
	
	fm = {
		mass        = 582,  
		caliber     = 0.07, 
		cx_coeff    = {1, 1.5, 0.68, 0.7, 1.75},
		L           = 1.81,
		I           = 1 / 12 * 15 * 1.81 * 1.81,
		Ma          = 0.84,
		Mw          = 3.5,
		shapeName   = "gbu-16",
		wind_sigma	= 0.0,
		wind_time	= 1000,
		dCydA		= {0.11, 0.11},
		A			= 0.36,
		Sw			= 0.04,
		maxAoa		= 0.122,	
		finsTau		= 0.1,
		Mx0			= 0.2,
		Ma_x		= 1.8,
		Mw_x		= 1.12,
		I_x			= 1.01,
	},
	seeker = {
		delay				= 0.0,
		FOV					= math.rad(360),
		max_seeker_range	= 18520,
	},

	autopilot = {
		delay				= 0.0,
		op_time				= 45,
		dV_dt				= 20,
		Knav				= 12,
		Tf					= 0.2,
		Kd					= 150,
		Kdx					= 0.2,
		Kix					= 0.8,
		gload_limit			= 10,
		fins_limit			= math.rad(20),
		fins_limit_x		= math.rad(10),
		-- null_roll			= math.rad(0),
	},

	properties =
	{
		targeting_data = 
		{
			fm_type = 2,
		},
	},
}
declare_weapon(AGM_123_F14)


declare_loadout( --AGM-123
{
    category = CAT_MISSILES,
    CLSID	=	"{BRU-32 AGM-123}",
    Picture	=	"gbu16.png", -- TODO: need GBU24.png ?
	displayName	=	_("AGM-123 Skipper II"),
--	displayName = 	_(GBU_54_F14.name),
    Weight_Empty = 57.38,   -- 100lbs+26.5lbs
    Weight	= 57.38 + AGM_123_F14.mass,  -- 1050kg from wikipedia, 900 from db_weapons_data.lua though
    wsTypeOfWeapon	= AGM_123_F14.wsTypeOfWeapon, --{wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
    attribute      = {4,	4,	32,	WSTYPE_PLACEHOLDER},
    Count = 1,
    Cx_pil = 0.00002,
    Cx_item = 0.000793, -- see bombs_data.lua
	settings			= Get_LGU_GUISettings_Preset("WGU59"),

    Elements	=
    {
        { ShapeName	= "HB_F14_EXT_BRU34" ,IsAdapter  =   true  },  -- combination ADU-703 & BRU-32
        {
			ShapeName	=	"gbu-16",
            connector_name =  "WEP_BRU-34_MK84",
            --use_full_connector_position = true,
        },
    }, -- end of Elements
})