-- for warhead functions and default warheads map (for warheads["AIM_65"])
-- DSplayer Edited 2023-01-14 V1.1.0
dofile("Scripts/Database/Weapons/warheads.lua")

local f14_agm65e = {
    category = CAT_MISSILES,
	level2 = wsType_Missile,
    name = "AGM-65E - Maverick E (Laser ASM - Lg Whd)",
    payload_CLSID = "{F16A4DE0-116C-4A71-97F0-2CF85B0313EF}",
	mass = 292.0,
    wsType = "weapons.missiles.AGM_65E",
    Cx = 4 / 4096.0, -- bombs_data.lua
--	Cx_pil = 4, -- bombs_data.lua
    ShapeName = "agm-65e",
    picture = "agm65.png"
}


local function lau_117_maverick_f14(clsid,weapon_info, position_offset)
	
	local lau_117_mass = 53.0
    local lvl2 = weapon_info.level2
    if type(weapon_info.wsType)=="table" then
      lvl2 = weapon_info.wsType[2]
    end
	local ret = {
		category			=	weapon_info.category,
		CLSID				=	clsid,
		Picture				=	weapon_info.picture,
		attribute			=	{wsType_Weapon,	lvl2,	wsType_Container, WSTYPE_PLACEHOLDER},
		Cx_pil				=	(0.00025 + 0.0009765625),
		Elements 			= { }
	}
    if type(weapon_info.wsType)=="table" and weapon_info.wsType[4] ~= nil then
        ret.wsTypeOfWeapon = weapon_info.wsType
    end
    if type(weapon_info.wsType)=="string" then
        ret.wsTypeOfWeapon = weapon_info.wsType
    end
    ret.Elements[#ret.Elements + 1] = { ShapeName	= "LAU-117",IsAdapter  =   true}
    local sz = 1
	if (position_offset == nil) then
		position_offset = {0.18,	-0.078,	0}
	end
	if (sz == 1) then
		ret.Elements[#ret.Elements + 1] = {ShapeName = weapon_info.ShapeName, Position	=	position_offset}
	end

	ret.Count  = sz
	ret.Weight = lau_117_mass + sz * weapon_info.mass

	ret.displayName =	"LAU-117 with "..weapon_info.name
	declare_loadout(ret)
    return ret
end


local function harm_adapter_nested(clsid,nested_loadout,position_offset,rotation_offset)
    local harm_adapter_mass = 0.001 -- TODO
	local ret = {
		category			=	nested_loadout.category,
		CLSID				=	clsid,
		Picture				=	nested_loadout.Picture,
		attribute			=	{wsType_Weapon,	nested_loadout.attribute[2],	wsType_Container,	WSTYPE_PLACEHOLDER},
		Cx_pil				=	0.001, -- TODO: what is reasonable?
   		JettisonSubmunitionOnly = true,
		Elements 			= {
        }
	}
    if nested_loadout.wsTypeOfWeapon ~= nil then
        ret.wsTypeOfWeapon		=	nested_loadout.wsTypeOfWeapon
    end
	if (position_offset == nil) then
		position_offset = {0,-0.085,0}
	end
	if (rotation_offset == nil) then
		rotation_offset = {0,0,1.6}
	end
	
    ret.Elements[#ret.Elements + 1] = { ShapeName	= "HB_F14_EXT_LANTIRN_PYLON", IsAdapter  =   true  }
    ret.Elements[#ret.Elements + 1] = {payload_CLSID = nested_loadout.CLSID, Position = position_offset, Rotation = rotation_offset}
	ret.Count  = nested_loadout.Count
	ret.Weight = harm_adapter_mass + nested_loadout.Weight


	ret.Cx_pil = ret.Cx_pil + nested_loadout.Cx_pil

	--ret.displayName =	_("PHX ")..nested_loadout.displayName
	ret.displayName =	nested_loadout.displayName
	declare_loadout(ret)
    return ret
end

harm_adapter_nested("{SHOULDER_LAU_117_AGM_65E}", lau_117_maverick_f14("{F14_LAU_117_AGM_65E}", f14_agm65e, nil), nil, nil)