-- for warhead functions and default warheads map (for warheads["AIM_65"])
-- DSplayer Edited 2025-01-30 V1.1.11
dofile("Scripts/Database/Weapons/warheads.lua")
--dofile(current_mod_path.."/Entry/Weapons.lua")

--Modern AIM-9s
local modern_aim9_variants =
{
	["AIM-9X"] 		= {picture = "us_AIM-9X.png", display_name = _("AIM-9X")	,wstype = "weapons.missiles.AIM_9X",	category = CAT_AIR_TO_AIR, mass = 84.46	},
	
}

local function modern_aim_9_without_adapter(CLSID,aim_9_variant,name_prefix)
	local var = modern_aim9_variants[aim_9_variant] or modern_aim9_variants["AIM-9X"]
	local var_mass = var.mass or 85.5
    local pic = var.picture or "aim9p.png"
	declare_loadout({
		category			= 	var.category,
		CLSID 				= 	CLSID,
		Picture				=	pic,
		displayName			=	name_prefix..var.display_name,
		attribute			=	var.wstype,
		Cx_pil				=	2.58 / 4096.0,  -- 2.58 from AIM_9L.Cx_pil
		Count				=	1,
		Weight				=	var_mass,
		Elements			=  {{ShapeName = aim_9_variant}}-- end of Elements
	})
end

local function modern_aim_9_with_adapter(CLSID,aim_9_variant)
	local var 	   = modern_aim9_variants[aim_9_variant] or modern_aim9_variants["AIM-9X"]
	local var_mass = var.mass or 85.5
    local name_prefix = "LAU-7 "
    local pic = var.picture or "aim9p.png"
	declare_loadout({
		category			= var.category,
		CLSID 				= CLSID,
		Picture				=	pic,
		displayName			=	name_prefix..var.display_name,
		wsTypeOfWeapon		=   var.wstype,
		attribute			=	{4,	4,	32,	111},
		Cx_pil				=	1.125*(2.58 / 4096.0),  -- 2.58 from AIM_9L.Cx_pil
								-- per F-14 perf manual:
								-- shoulder AIM9 drag index = 8
								-- AIM9 shoulder adapter index = 1
								-- total drag index = 9, add 12.5% (1/8) more drag to shoulder AIM9
		Count				=	1,
		Weight				=	15 + var_mass,
		JettisonSubmunitionOnly = true,
		Elements			=
		{
			{	ShapeName	=	"HB_F14_EXT_LAU-7"	   	  ,	IsAdapter  	   =   true},
			{	ShapeName	=	aim_9_variant	  ,	connector_name =  "WEP_Sidewinder_Extra"},
		}-- end of Elements
	})
end

modern_aim_9_with_adapter("{LAU-7 - AIM-9X}","AIM-9X")
modern_aim_9_without_adapter("{LAU-138 wtip - AIM-9X}","AIM-9X","LAU-138 ")

local function lau_115_2x127_F14(clsid,weapon_info,left,right,attach_offset)
	
	local lau_115_plus_127_mass = 145
    local lvl2 = weapon_info.level2
    if type(weapon_info.wsType)=="table" then
      lvl2 = weapon_info.wsType[2]
    end
	local ret = {
		category			=	weapon_info.category,
		CLSID				=	clsid,
		Picture				=	weapon_info.picture,
		attribute			=	{wsType_Weapon,	lvl2,	wsType_Container, WSTYPE_PLACEHOLDER},
		Cx_pil				=	0.001,
		Elements 			= { }
	}
    if type(weapon_info.wsType)=="table" and weapon_info.wsType[4] ~= nil then
        ret.wsTypeOfWeapon = weapon_info.wsType
    end
    if type(weapon_info.wsType)=="string" then
        ret.wsTypeOfWeapon = weapon_info.wsType
    end
    ret.Elements[#ret.Elements + 1] = { ShapeName	= "LAU-115C+2_LAU127",IsAdapter  =   true}
    local sz = 0
	if left then
        sz = sz + 1
        ret.Elements[#ret.Elements + 1] = {ShapeName = weapon_info.ShapeName, connector_name =	"Point03"}
		if (attach_offset ~= nil) then
		  ret.Elements[#ret.Elements].attach_point_position = attach_offset
		end
    end
	if right then
        sz = sz + 1
        ret.Elements[#ret.Elements + 1] = {ShapeName = weapon_info.ShapeName, connector_name =	"Point02"}
		if (attach_offset ~= nil) then
		  ret.Elements[#ret.Elements].attach_point_position = attach_offset
		end
    end

	ret.Count  = sz
	ret.Weight = lau_115_plus_127_mass + sz * weapon_info.mass

	ret.Cx_pil = ret.Cx_pil + sz * weapon_info.Cx

    if sz > 1 then
		ret.displayName =	"LAU-115 with 2x LAU-127 "..weapon_info.name
	else
		ret.displayName =	"LAU-115 with 1x LAU-127 "..weapon_info.name
	end
	declare_loadout(ret)
    return ret
end

local function harm_adapter_nested(clsid,nested_loadout)
    local harm_adapter_mass = 0.001 -- TODO
	local ret = {
		category			=	nested_loadout.category,
		CLSID				=	clsid,
		Picture				=	nested_loadout.Picture,
		attribute			=	{wsType_Weapon,	nested_loadout.attribute[2],	wsType_Container,	WSTYPE_PLACEHOLDER},
		Cx_pil				=	0.001, -- TODO: what is reasonable?
   		JettisonSubmunitionOnly = true,
		Elements 			= {
        }
	}
    if nested_loadout.wsTypeOfWeapon ~= nil then
        ret.wsTypeOfWeapon		=	nested_loadout.wsTypeOfWeapon
    end
    ret.Elements[#ret.Elements + 1] = { ShapeName	= "HB_F14_EXT_LANTIRN_PYLON", IsAdapter  =   true  }
    ret.Elements[#ret.Elements + 1] = {payload_CLSID = nested_loadout.CLSID,Position={0,-0.085,0}, Rotation={0,0,1.6}}
	ret.Count  = nested_loadout.Count
	ret.Weight = harm_adapter_mass + nested_loadout.Weight


	ret.Cx_pil = ret.Cx_pil + nested_loadout.Cx_pil

	--ret.displayName =	_("PHX ")..nested_loadout.displayName
	ret.displayName =	nested_loadout.displayName
	declare_loadout(ret)
    return ret
end

local f14_aim9x = {
    category = CAT_AIR_TO_AIR,
	level2 = wsType_Missile,
    name = "AIM-9X Sidewinder",
    payload_CLSID = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
    mass = 84.46, -- db_weapons_data.lua
--	mass = 60,
    wsType = "weapons.missiles.AIM_9X",
    Cx = 1.88 / 4096.0, -- bombs_data.lua
--	Cx_pil = 4, -- bombs_data.lua
    ShapeName = "aim-9x",
    picture = "us_AIM-9X.png"
}

harm_adapter_nested("{SHOULDER_2xAIM_9X}", lau_115_2x127_F14("{LAU_115_2x9X}", f14_aim9x, true, true) ) -- Double AIM-9X


--[[JDAM --PS from DSplayer: JDAMs do not track at all when dumb dropped.
declare_loadout(
{
    category = CAT_BOMBS,
    CLSID	=	"{BRU-32 GBU-31}",
    Picture	=	"gbu31.png",
    displayName	=	_("GBU-31"),
    Weight_Empty = 57.38,   -- 100lbs+26.5lbs
    Weight	= 57.38 + 934,  -- 940kg from wikipedia, db_weapons_data.lua says 1162 though
    wsTypeOfWeapon	= {wsType_Weapon, wsType_Bomb, wsType_Bomb_Guided, GBU_31},
    attribute      = {wsType_Weapon,wsType_Bomb,wsType_Container,WSTYPE_PLACEHOLDER},
    Count = 1,
    Cx_pil = 0.00002,
    Cx_item = 0.000793, -- see bombs_data.lua

    Elements	=
    {
        { ShapeName	= "HB_F14_EXT_BRU34" ,IsAdapter  =   true  },  -- combination ADU-703 & BRU-32
        {
            ShapeName	=	"GBU-31",
            connector_name =  "WEP_BRU-34_MK84",
            --use_full_connector_position = true,
        },
    }, -- end of Elements
})

declare_loadout(
{
    category = CAT_BOMBS,
    CLSID	=	"{BRU-32 GBU-38}",
    Picture	=	"gbu38.png",
    displayName	=	_("GBU-38"),
    Weight_Empty = 57.38,   -- 100lbs+26.5lbs
    Weight	= 57.38 + 241,  -- see db_weapons_data.lua
    wsTypeOfWeapon	= {wsType_Weapon, wsType_Bomb, wsType_Bomb_Guided, GBU_38},
    attribute      = {wsType_Weapon,wsType_Bomb,wsType_Container,WSTYPE_PLACEHOLDER},
    Count = 1,
    Cx_pil = 0.00002,
    Cx_item = 0.000640, -- see bombs_data.lua

    Elements	=
    {
        { ShapeName	= "HB_F14_EXT_BRU34" ,IsAdapter  =   true  },  -- combination ADU-703 & BRU-32
        {
            ShapeName	=	"GBU-38",
            connector_name =  "WEP_BRU-34_MK84",
            --use_full_connector_position = true,
        },
    }, -- end of Elements
})


declare_loadout(
{
    category = CAT_BOMBS,
    CLSID	=	"{BRU-32 GBU-54}",
    Picture	=	"gbu54.png", -- TODO: need GBU24.png ?
    displayName	=	_("GBU-54"),
    Weight_Empty = 57.38,   -- 100lbs+26.5lbs
    Weight	= 57.38 + 253,  -- 1050kg from wikipedia, 900 from db_weapons_data.lua though
    wsTypeOfWeapon	= {wsType_Weapon, wsType_Bomb, wsType_Bomb_Guided, 293},
    attribute      = {wsType_Weapon,wsType_Bomb,wsType_Container,WSTYPE_PLACEHOLDER},
    Count = 1,
    Cx_pil = 0.00002,
    Cx_item = 0.000793, -- see bombs_data.lua

    Elements	=
    {
        { ShapeName	= "HB_F14_EXT_BRU34" ,IsAdapter  =   true  },  -- combination ADU-703 & BRU-32
        {
            ShapeName	=	"GBU-54",
            connector_name =  "WEP_BRU-34_MK84",
            --use_full_connector_position = true,
        },
    }, -- end of Elements
})
]]

-- AGM-84D Harpoon

local f14_agm_84d =
{
	category		= CAT_MISSILES,
	level2 			= wsType_Missile,
	name			= "AGM-84D Harpoon Anti-Ship Missile",
    payload_CLSID 	= "{AGM_84D}",
	mass			= 540,
	wsType			= "weapons.missiles.AGM_84D",
	Cx				= 8.0/4096.0, --8 in tactical_decoys.lua
--	Cx_pil 			= 0.0018,
	picture			= "agm84d.png",
	ShapeName		= "agm-84d",
}

local function ds_bru_32_single(clsid,weapon_info,attach_offset)
	
	local bru_32_mass = 57.38
    local lvl2 = weapon_info.level2
    if type(weapon_info.wsType)=="table" then
      lvl2 = weapon_info.wsType[2]
    end
	local ret = {
		category			=	weapon_info.category,
		CLSID				=	clsid,
		Picture				=	weapon_info.picture,
		attribute			=	{wsType_Weapon,	lvl2,	wsType_Container, WSTYPE_PLACEHOLDER},
		Cx_pil				=	0.00002,
		-- settings			= 	weapon_info.settings,
		Elements 			= { }
	}
    if type(weapon_info.wsType)=="table" and weapon_info.wsType[4] ~= nil then
        ret.wsTypeOfWeapon = weapon_info.wsType
    end
    if type(weapon_info.wsType)=="string" then
        ret.wsTypeOfWeapon = weapon_info.wsType
    end
    ret.Elements[#ret.Elements + 1] = { ShapeName	= "HB_F14_EXT_BRU34", IsAdapter  =   true  }
	if (attach_offset == nil) then
		attach_offset = {0.0,	0.0,	0}
	end
    local sz = 1
	if (sz == 1) then
		ret.Elements[#ret.Elements + 1] = {ShapeName = weapon_info.ShapeName, connector_name = "WEP_BRU-34_MK84", attach_point_position = attach_offset}
	end

	ret.Count  = sz
	ret.Weight = bru_32_mass + sz * weapon_info.mass

	ret.displayName =	"BRU-32 with "..weapon_info.name
	declare_loadout(ret)
    return ret
end

local function ds_phx_adapter_nested(clsid,nested_loadout)
    local phx_adapter_mass = 0 -- TODO
	local ret = {
		category			=	nested_loadout.category,
		CLSID				=	clsid,
		Picture				=	nested_loadout.Picture,
		attribute			=	{wsType_Weapon,	nested_loadout.attribute[2],	wsType_Container,	WSTYPE_PLACEHOLDER},
		Cx_pil				=	0.0001, -- TODO: what is reasonable?
   		JettisonSubmunitionOnly = true,
		-- settings			= 	weapon_info.settings,
		Elements 			= {
        }
	}
    if nested_loadout.wsTypeOfWeapon ~= nil then
        ret.wsTypeOfWeapon		=	nested_loadout.wsTypeOfWeapon
    end
    ret.Elements[#ret.Elements + 1] = { ShapeName	= "HB_F14_EXT_SHOULDER_PHX_L", IsAdapter  =   true  }
    ret.Elements[#ret.Elements + 1] = {payload_CLSID = nested_loadout.CLSID, connector_name = "WEP_Phoenix_Connector"}
	ret.Count  = nested_loadout.Count
	ret.Weight = phx_adapter_mass + nested_loadout.Weight


	ret.Cx_pil = ret.Cx_pil + nested_loadout.Cx_pil

	--ret.displayName =	_("PHX ")..nested_loadout.displayName
	ret.displayName =	nested_loadout.displayName
	declare_loadout(ret)
    return ret
end

ds_phx_adapter_nested("{SHOULDER_AGM_84D}", ds_bru_32_single("{BRU32_AGM_84D}", f14_agm_84d, nil))

local function lgz_phx_adapter_nested(clsid,nested_loadout)
    local phx_adapter_mass = 0 -- TODO
	local ret = {
		category			=	nested_loadout.category,
		CLSID				=	clsid,
		Picture				=	nested_loadout.Picture,
		attribute			=	{wsType_Weapon,	nested_loadout.attribute[2],	wsType_Container,	WSTYPE_PLACEHOLDER},
		Cx_pil				=	0.0001, -- TODO: what is reasonable?
   		JettisonSubmunitionOnly = true,
		Elements 			= {
        },
		settings = nested_loadout.settings
	}
    if nested_loadout.wsTypeOfWeapon ~= nil then
        ret.wsTypeOfWeapon		=	nested_loadout.wsTypeOfWeapon
    end
    ret.Elements[#ret.Elements + 1] = { ShapeName	= "HB_F14_EXT_SHOULDER_PHX_L", IsAdapter  =   true  }
    ret.Elements[#ret.Elements + 1] = {payload_CLSID = nested_loadout.CLSID, connector_name = "WEP_Phoenix_Connector"}
	ret.Count  = nested_loadout.Count
	ret.Weight = phx_adapter_mass + nested_loadout.Weight


	ret.Cx_pil = ret.Cx_pil + nested_loadout.Cx_pil

	--ret.displayName =	_("PHX ")..nested_loadout.displayName
	ret.displayName =	nested_loadout.displayName
	declare_loadout(ret)
    return ret
end

--For making the AIM-54C+/AIM-54C ECCM/Sealed
local function DS_make_aim_54(missile, motor, smokey)

	local shape_name = "AIM-54"..missile.name.."_"..motor.name
	local username = "AIM-54"..missile.name.."-"..motor.name

	-- accounts for the mk47 mod0 or mod1
	local smoke = {1, 1, 1, 1}
	if smokey ~= nil and smokey == false then
		smoke = {0.8, 0.8, 0.8, 0.05 }
	end

	local weapon = {
    category		= CAT_AIR_TO_AIR,
    name			= "AIM_54".. missile.name .."_"..motor.name,
    user_name		= _(username),
    wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
    --class_name	= "wAmmunitionPhoenix",
    shape_table_data =
    {
        {
            name	 = shape_name;
            file  = missile.model_name;
            life  = 1;
            fire  = { 0, 1};
            username = username;
            index = WSTYPE_PLACEHOLDER,
        },
    },


        Escort = 0,
        Head_Type = 2,
        sigma = {5, 5, 5},
        M = missile.mass + motor.propellant_mass,
        H_max = 20000.0,
        H_min = 1.0,
        Diam = 380.0,
        Cx_pil = 5,
        D_max = 14000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 200.0,
        Nr_max = 18,
        v_min = 140.0,
        v_mid = 700.0,
        Mach_max = 4.0,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 5.0,
        Range_max = 180000.0,
        H_min_t = 3.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 1.05,
        OmViz_max = 0.52,
        warhead = warheads["AIM_54"],
        exhaust = smoke,
        X_back = -1.72,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.12,
        KillDistance = 15.0,
		ccm_k0 = missile.ccm_k0,
        loft = 1,
        hoj = missile.hoj,
        go_active_by_default = missile.go_active_by_default,
        active_radar_lock_dist = 18520,
        PN_gain = missile.PN_gain,
        loft_factor = missile.loft_factor,
        supersonic_A_coef_skew = 0.295, -- наклон прямой коэффициента отвала поляры на сверхзвуке
		nozzle_exit_area = 1e-6, -- площадь выходного сечения сопла
		smoke_opacity_type	= 1,
		
        PN_coeffs = {
            4,
            15000.0 ,1.0,
            25000.0, 0.85,
            40000.0, 0.65,
            100000.0, 0.3,
        };

        ModelData = {   58,  -- model params count
                        1.1,   -- characteristic square (характеристическая площадь)
                        
                        -- параметры зависимости Сx
                        0.042 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
                        0.083 , -- Cx_k1 высота пика волнового кризиса
                        0.01 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
                        -0.24, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
                        0.12 , -- Cx_k4 крутизна спада за волновым кризисом 
                        0.18 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
                        
                        -- параметры зависимости Cy
                        1.6 , -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
                        1.3	, -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
                        1.2 , -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
                        
                        0.35, -- 7 Alfa_max  максимальный балансировачный угол, радианы
                        0.0, --угловая скорость создаваймая моментом газовых рулей  
                        
                    -- Engine data. Time, fuel flow, thrust.	
                    --  t_statr     t_b     t_accel     t_march     t_inertial      t_break     t_end           -- Stage
                        0.27,       -1.0,   motor.burn_time,       0.1,        0.0,            0.0,        1.0e9,         -- time of stage, sec
                        0.0,       0.0,     motor.propellant_mass / motor.burn_time,       0.0,        0.0,            0.0,        0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
                        0.0,       0.0,     motor.thrust,    0.0,        0.0,            0.0,        0.0,           -- thrust, newtons
            
                        1.0e9, -- таймер самоликвидации, сек
                        200.0, -- время работы энергосистемы, сек
                        0, -- абсолютная высота самоликвидации, м
                        2.5, -- время задержки включения управления (маневр отлета, безопасности), сек
                        40000.0, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
                        30000.0, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
                        missile.loft_angle,  -- синус угла возвышения траектории набора горки
                        30.0, -- продольное ускорения взведения взрывателя
                        0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
                        missile.guidance.k0, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
                        missile.guidance.k1, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
                        missile.guidance.w_cutoff, -- характеристика системы САУ-РАКЕТА,  полоса пропускания контура управления

                        -- DLZ data. Use numbers below for your implemetation. --From Denis Alekseev
                        -- ЗРП. Данные для рассчета дальностей пуска (индикация на прицеле)
                        50.0, -- производная дальности по скорости носителя на высоте 1км, ППС
                        -45.0, -- производная дальности по скорости цели на высоте 1км, ЗПС
                        -7.2, -- производная по высоте производной дальности по скорости цели, ЗПС
                        72000.0, -- дальность ракурс 180 град(навстречу), Н=5000м, V=900км/ч, м
                        28000.0, -- дальность ракурс 180(в догон) град, Н=5000м, V=900км/ч, м
                        120000.0, -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м
                        46000.0, -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
                        44000.0, -- дальность ракурс 180 град, Н=1000м, V=900км/ч, м
                        20000.0, -- дальность ракурс 180(в догон) град, Н=1000м, V=900км/ч, м
                        3500.0, -- Вертикальная плоскость. Наклон кривой разрешенной дальности пуска в нижнюю полусферу. Уменьшение дальности при стрельбе вниз.
                        0.4, -- Вертикальная плоскость. Наклон кривой разрешенной дальности пуска в верхнюю полусферу. Увеличение дальности при стрельбе вверх.
                        -0.012, -- Вертикальная плоскость. Угол перегиба кривой разрешенной дальности, верхняя - нижняя полусфера.
                        0.7, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя
        },
    }

	return weapon
end

local AIM_54C_ECCM_Sealed_missile_properties = {
	name = "C+ ECCM/Sealed",
	model_name = "HB_F14_EXT_AIM54",
	mass = 301.5,
	PN_gain = 5,
	loft_factor = 35.0,
	loft_angle = 0.17, --this is sin(loft_angle)
	go_active_by_default = 1,
	hoj = 1,
	ccm_k0 = 0.2,
	guidance = {
		k0 = 36.0,
		k1 = 7.8,
		w_cutoff = 1.0,
	},
}

local MK47_motor_properties = {
	name = "Mk47",
	propellant_mass = 163.0,
	burn_time = 27.0,
	thrust = 13595.0,
}

local AIM_54C_ECCM_Mk47 = DS_make_aim_54(AIM_54C_ECCM_Sealed_missile_properties, MK47_motor_properties, false)
declare_weapon(AIM_54C_ECCM_Mk47)

declare_loadout({	-- AIM_54C_ECCM_Mk47
    category		=	CAT_AIR_TO_AIR,
    CLSID			= 	"{AIM_54C_ECCM_Mk47}",
    Picture			=	"aim54.png",
    --wsTypeOfWeapon	=	AIM_54C_Mk47.wsTypeOfWeapon,
    displayName		=	AIM_54C_ECCM_Mk47.user_name,
    --attribute		=	{wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
    attribute	    =	AIM_54C_ECCM_Mk47.wsTypeOfWeapon,
    Cx_pil			=	AIM_54C_ECCM_Mk47.Cx_pil / 4096.0,
    Count			=	1,
    Weight			=	AIM_54C_ECCM_Mk47.M,
    Elements	=
    {
		--{	ShapeName	=	"HB_F14_EXT_PHX_ALU"  ,	IsAdapter  	   =   true  },
        {
            DrawArgs	=
            {
                [1]	=	{1,	1},
                [2]	=	{2,	1},
            }, -- end of DrawArgs
            --Position	=	{0,	-0.5,	0},
            --connector_name = "WEP_Phoenix_FrontPallette_L_ALU",
            ShapeName	=	"AIM-54C_ECCM_M47",
        },
    }, -- end of Elements
})

local function shoulder_aim_54(clsid, element, elem_CLSID, side)  -- side L or R
	local ret = {
		category			=	CAT_AIR_TO_AIR,
		CLSID				=	clsid,
		Picture				=	"aim54.png",
		wsTypeOfWeapon		=	element.wsTypeOfWeapon,
		attribute			=	{4,	4,	32,	WSTYPE_PLACEHOLDER},
		Cx_pil				=	1.25 * (element.Cx_pil/4096.0),
								-- per F-14 perf manual:
								-- shoulder AIM54 drag index = 12
								-- AIM54 shoulder adapter index = 3
								-- total drag index = 15, add 25% more drag to shoulder AIM54
		Count				=	1,
		Weight				=	element.M + 45.36,  --100lbs for LAU-93
		JettisonSubmunitionOnly = true,
		Elements			=
		{
			{	ShapeName	=	"HB_F14_EXT_SHOULDER_PHX_"..side  ,	IsAdapter  	   =   true  },
			{	payload_CLSID = elem_CLSID , connector_name = "WEP_Phoenix_Connector"}
		}-- end of Elements
	}
    -- actually a LAU-93 adapter, the LAU-93 is internal to the adapter (and the rails also have LAU-93)
	--ret.displayName =	_("LAU-93 ").." "..element.name
	--ret.displayName =	element.name
    ret.displayName = element.user_name
	declare_loadout(ret)
end

-- Shoulder Phoenix Stations
shoulder_aim_54("{SHOULDER AIM_54C_ECCM_Mk47 L}", AIM_54C_ECCM_Mk47, "{AIM_54C_ECCM_Mk47}", "L")
shoulder_aim_54("{SHOULDER AIM_54C_ECCM_Mk47 R}", AIM_54C_ECCM_Mk47, "{AIM_54C_ECCM_Mk47}", "R")

local function LGZ_bru_42_3x_weapon(clsid,weapon_info,left,right,bottom,attach_offset)

    local bru_42_mass = 128
    local lvl2 = weapon_info.level2
    if type(weapon_info.wsType)=="table" then
		lvl2 = weapon_info.wsType[2]
	  end
	local ret = {
		category			=	weapon_info.category,
		CLSID				=	clsid,
		Picture				=	weapon_info.picture,
		attribute			=	{wsType_Weapon,	lvl2,	wsType_Container, WSTYPE_PLACEHOLDER},
		Cx_pil				=	0.0005,
		Elements 			= 	{ },
		settings = weapon_info.settings
	}
    if weapon_info.ejectVelocity then
		ret.ejectVelocity =	weapon_info.ejectVelocity
	end
	if weapon_info.ejectDirection then
		ret.ejectDirection = weapon_info.ejectDirection
	end
	if weapon_info.ejectPitchRate then
		ret.ejectPitchRate = weapon_info.ejectPitchRate
	end
    if type(weapon_info.wsType)=="table" and weapon_info.wsType[4] ~= nil then
        ret.wsTypeOfWeapon = weapon_info.wsType
    end
    if type(weapon_info.wsType)=="string" then
        ret.wsTypeOfWeapon = weapon_info.wsType
    end
    ret.Elements[#ret.Elements + 1] = { ShapeName	= "HB_F14_EXT_BRU42",IsAdapter  =   true}
    local sz = 0
	if left then
        sz = sz + 1
        ret.Elements[#ret.Elements + 1] = {payload_CLSID = weapon_info.payload_CLSID, connector_name =	"BRU-42_LEFT"}
		if (attach_offset ~= nil) then
		  ret.Elements[#ret.Elements].attach_point_position = attach_offset
		end
    end
	if right then
        sz = sz + 1
        ret.Elements[#ret.Elements + 1] = {payload_CLSID = weapon_info.payload_CLSID, connector_name =	"BRU-42_RIGHT"}
		if (attach_offset ~= nil) then
		  ret.Elements[#ret.Elements].attach_point_position = attach_offset
		end
    end
	if bottom then
        sz = sz + 1
        ret.Elements[#ret.Elements + 1] = {payload_CLSID = weapon_info.payload_CLSID, connector_name =	"BRU-42_LOWER"}
		if (attach_offset ~= nil) then
		  ret.Elements[#ret.Elements].attach_point_position = attach_offset
		end
    end

	ret.Count  = sz
	ret.Weight = bru_42_mass +  sz * weapon_info.mass

	ret.Cx_pil = ret.Cx_pil + sz * weapon_info.Cx

    if sz > 1 then
        ret.displayName =	sz.." "..weapon_info.name
    else
        ret.displayName =	weapon_info.name
    end
	declare_loadout(ret)
    return ret
end

local function LGZ_bru_32_nested(clsid,nested_loadout)
    local adu_703_bru_32_mass = 57.38

    local lvl2 = wsType_Missile
    if type(nested_loadout.attribute)=="table" then
      lvl2 = nested_loadout.attribute[2]
    end
	local ret = {
		category			=	nested_loadout.category,
		CLSID				=	clsid,
		Picture				=	nested_loadout.Picture,
		attribute			=	{wsType_Weapon,	lvl2,	wsType_Container,	WSTYPE_PLACEHOLDER},
		Cx_pil				=	0.00002, -- TODO: what is reasonable?
   		JettisonSubmunitionOnly = true,
		Elements 			= { },
		settings = nested_loadout.settings
	}
	if nested_loadout.ejectVelocity then
		ret.ejectVelocity =	nested_loadout.ejectVelocity
	end
	if nested_loadout.ejectDirection then
		ret.ejectDirection = nested_loadout.ejectDirection
	end
	if nested_loadout.ejectPitchRate then
		ret.ejectPitchRate = nested_loadout.ejectPitchRate
	end
    if nested_loadout.wsTypeOfWeapon ~= nil then
        ret.wsTypeOfWeapon = nested_loadout.wsTypeOfWeapon
    end
    ret.Elements[#ret.Elements + 1] = { ShapeName	= "HB_F14_EXT_BRU34", IsAdapter  =   true  }
    ret.Elements[#ret.Elements + 1] = {payload_CLSID = nested_loadout.CLSID, connector_name = "WEP_BRU-34_BRU-42"}
	ret.Count  = nested_loadout.Count
	ret.Weight = adu_703_bru_32_mass + nested_loadout.Weight

	ret.Cx_pil = ret.Cx_pil + nested_loadout.Cx_pil

	--ret.displayName =	_("BRU-32 ")..nested_loadout.displayName
	ret.displayName =	nested_loadout.displayName
	declare_loadout(ret)
    return ret
end


local Laser_Zunis =
{
	category		= CAT_MISSILES,
	name			= "LGZ",
	user_name		= _("Laser Guided Zuni Mk. 71 HE GP"),
	scheme			= "APKWS",
	class_name		= "wAmmunitionLaserHoming",
	model			= "zuni",
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	mass			= 57.8,
	Escort			= 1,
	Head_Type		= 4,
	sigma			= {1, 1, 1},
	H_max			= 5000.0,
	H_min			= 1.0,
	Diam			= 70.0,
	Cx_pil			= 0.00016444708447773,
	D_max			= 5000.0,
	D_min			= 1000.0,
	Head_Form		= 1,
	Life_Time		= 90.0,
	Nr_max			= 25,
	v_min			= 140.0,
	v_mid			= 500.0,
	Mach_max		= 3.0,
	t_b				= 0.0,
	t_acc			= 0.0,
	t_marsh			= 1.1,
	Range_max		= 5000.0,
	H_min_t			= 15.0,
	Fi_start		= 0.4,
	Fi_rak			= 3.14152,
	Fi_excort		= 1.05,
	Fi_search		= 0.7,
	OmViz_max		= 0.35,
	exhaust			= {0.78, 0.78, 0.78, 0.3},
	X_back			= -2.0,
	Y_back			= -0.0,
	Z_back			= 0.0, -- -0.1,
	Reflection		= 0.04,
	KillDistance	= 0.0,
	M				= 57.8,

	warhead		= {
		caliber = 130,
		concrete_factors = { 1.33, 1.33, 0.1 },
		concrete_obj_factor = 0,
		cumulative_factor = 0,
		cumulative_thickness = 0,
		expl_mass = 4.3,
		fantom = 1,
		mass = 21.7,
		obj_factors = { 1.33, 1.33 },
		other_factors = { 1.33, 1.33, 1.33 },
		piercing_mass = 4.34
	},

	shape_table_data =
	{
		{
			name  = "LGZ";
			file  = "zuni";
			life  = 1;
			fire  = { 0, 1};
			username = _("LGZ"),
			index 	 = WSTYPE_PLACEHOLDER,
		},
	},

	march = {
		fuel_mass   			= 24.5,
		impulse     			= 205,
		boost_time  			= 0,
		work_time   			= 1.4,
		boost_factor			= 1,
		nozzle_position 	    = {{-1, 0, 0}},
		nozzle_orientationXYZ   = {{0, 0, 0}},
		tail_width  			= 0.13,
		boost_tail  			= 1,
		work_tail   			= 1,
		smoke_color				= {0.9, 0.9, 0.9},
		smoke_transparency		= 0.1,
		custom_smoke_dissipation_factor		= 0.2,		
	},

	fm = {
		mass        = 57.8,  
		caliber     = 0.13, 
		cx_coeff    = { 1, 1.5, 0.68, 0.7, 1.75 },
		L           = 2.4,
		I           = 27.744,
		Ma          = 0.50851,
		Mw          = 3.28844,
		shapeName   = "zuni",
		wind_sigma	= 10.0,
		wind_time	= 2.1,
		dCydA		= {0.11, 0.11},
		A			= 0.36,
		Sw			= 0.04,
		maxAoa		= math.rad(8),		
		finsTau		= 0.1,
		Mx0			= 0.2,
		Ma_x		= 1.8,
		Mw_x		= 1.12,
		I_x			= 1.01,
	},

	seeker = {
		delay				= 1.1,
		FOV					= math.rad(40),
		max_seeker_range	= 13000,
	},

	autopilot = {
		delay				= 0.9,
		op_time				= 45,
		dV_dt				= 20,
		Knav				= 12,
		Tf					= 0.2,
		Kd					= 150,
		Kdx					= 0.2,
		Kix					= 0.8,
		gload_limit			= 10,
		fins_limit			= math.rad(20),
		fins_limit_x		= math.rad(10),
	},
}
declare_weapon(Laser_Zunis)

declare_loadout({
	category 			= CAT_MISSILES,
	CLSID	 			= "{LAU10_4x_LGZ}",
	Picture				= "LAU10.png",
	--PictureBlendColor	= "0xffffffff",
	Cx_pil				= 0.001708984375,
	--displayName		= _("LAU-131 - 7 2.75' AGR-20A (HE)"),
	displayName			= _("LAU-10 - 4x Laser Guided Zuni MK 71, UnGd Rkts Mk71, HE/FRAG"),
	Count				= 4,
	Weight				= 288.9,
	wsTypeOfWeapon		= Laser_Zunis.wsTypeOfWeapon,
	attribute			= {4,	4,	32,	WSTYPE_PLACEHOLDER},
	-- attribute 			= { wsType_Weapon, wsType_NURS, wsType_Rocket, WSTYPE_PLACEHOLDER},
	settings			= Get_LGU_GUISettings_Preset("WGU59"),
	Elements			= {
		{
			IsAdapter = true,
			ShapeName = "LAU-10"
		},
		{
			Position = { 0.1, 0.049, 0.072 },
			ShapeName = "zuni"
		},
		{
			Position = { 0.1, 0.049, -0.073 },
			ShapeName = "zuni"
		},
		{
			Position = { 0.1, -0.095, 0.072 },
			ShapeName = "zuni"
		},
		{
			Position = { 0.1, -0.095, -0.073 },
			ShapeName = "zuni"
		}
	},
})
--[[
declare_loadout({	-- LAU-10 - 4 LGZ ZUNI MK 71
    category		=	CAT_MISSILES,
    CLSID			= 	"{LAU10_4x_LGZ}",
    Picture			=	"LAU10.png",
    displayName		=	_("LAU-10 - 4x Laser Guided Zuni MK 71, UnGd Rkts Mk71, HE/FRAG"),
    --attribute		=	{wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= 	Laser_Zunis.wsTypeOfWeapon,
	attribute		= 	{4,	4,	32,	WSTYPE_PLACEHOLDER},
    Cx_pil			=	0.001708984375,
    Count			=	4,
    Weight 			= 	288.9,
	Weight_Empty	= 	61.7,
    Elements		=	{ 
		{
			IsAdapter = true,
			ShapeName = "LAU-10"
		}, 
		{
			Position = { 0.1, 0.049, 0.072 },
			ShapeName = "zuni"
		}, 
		{
			Position = { 0.1, 0.049, -0.073 },
			ShapeName = "zuni"
		}, 
		{
			Position = { 0.1, -0.095, 0.072 },
			ShapeName = "zuni"
		}, 
		{
			Position = { 0.1, -0.095, -0.073 },
			ShapeName = "zuni"
		} 
	},
})]]

local lau10_laser_zuni = {
    category 		= CAT_MISSILES,
	level2 			= wsType_Missile,
    name 			= "LAU-10 - 4 Laser Guided Zuni Mk 71",
    payload_CLSID 	= "{LAU10_4x_LGZ}",
    mass 			= 288.9,
--	wsType 			= {4, 7, 33, 37},
--	wsType 			= {4,	4,	32,	WSTYPE_PLACEHOLDER},
	wsType			= Laser_Zunis.wsTypeOfWeapon,
--	wsType 			= { 4, 4, 8, WSTYPE_PLACEHOLDER },
    Cx 				= 0.001708984375,
    picture 		= "LAU10.png",
	settings		= Get_LGU_GUISettings_Preset("WGU59")
}

LGZ_bru_32_nested("{BRU3242_LGZ_LAU10}", LGZ_bru_42_3x_weapon("{BRU42_LGZ_LAU10}", lau10_laser_zuni, false, true, false) )
LGZ_bru_32_nested("{BRU3242_2xLGZLAU10 L}", LGZ_bru_42_3x_weapon("{BRU42_2xLGZLAU10 L}", lau10_laser_zuni, true, false, true) )
LGZ_bru_32_nested("{BRU3242_2xLGZLAU10 R}", LGZ_bru_42_3x_weapon("{BRU42_2xLGZLAU10 R}", lau10_laser_zuni, true, true, false) )

lgz_phx_adapter_nested("{PHXBRU3242_2xLGZLAU10 RS}", LGZ_bru_32_nested("{BRU3242_2xLGZLAU10 RS}", LGZ_bru_42_3x_weapon("{BRU42_2xLGZLAU10 RS}", lau10_laser_zuni, false, true, true) ) )
lgz_phx_adapter_nested("{PHXBRU3242_2xLGZLAU10 LS}", LGZ_bru_32_nested("{BRU3242_2xLGZLAU10 LS}", LGZ_bru_42_3x_weapon("{BRU42_2xLGZLAU10 LS}", lau10_laser_zuni, true, false, true) ) )


-- local AGM_123_F14 =
-- {
-- 	category		= CAT_MISSILES,
-- 	name			= "AGM-123",
-- 	user_name		= _("AGM-123 Skipper II"),
-- 	scheme			= "APKWS",
-- --	scheme			= "laser_homing_gyrost_missile",
-- 	class_name		= "wAmmunitionLaserHoming",
-- 	model			= "gbu-16",
-- 	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	
-- 	mass			= 582,
-- 	Escort			= 1,
-- 	Head_Type		= 4,
-- 	sigma			= {1, 1, 1},
-- 	H_max			= 5000.0,
-- 	H_min			= 1.0,
-- 	Diam			= 70.0,
-- 	Cx_pil			= 4,
-- 	D_max			= 5000.0,
-- 	D_min			= 1000.0,
-- 	Head_Form		= 1,
-- 	Life_Time		= 90.0,
-- 	Nr_max			= 25,
-- 	v_min			= 140.0,
-- 	v_mid			= 500.0,
-- 	Mach_max		= 3.0,
-- 	t_b				= 0.0,
-- 	t_acc			= 0.0,
-- 	t_marsh			= 1.1,
-- 	Range_max		= 5000.0,
-- 	H_min_t			= 15.0,
-- 	Fi_start		= 0.4,
-- 	Fi_rak			= 3.14152,
-- 	Fi_excort		= 1.05,
-- 	Fi_search		= 0.7,
-- 	OmViz_max		= 0.35,
-- 	exhaust			= {0.78, 0.78, 0.78, 0.3};
-- 	X_back			= -2.0,
-- 	Y_back			= -0.0,
-- 	Z_back			= 0.0,
-- 	Reflection		= 0.035,
-- 	KillDistance	= 0.0,
-- 	M				= 582,
	
-- 	warhead		= predefined_warhead("Mk_82"),
	
-- 	shape_table_data =
-- 	{
-- 		{
-- 			name  = "AGM_123";
-- 			file  = "gbu-16";
-- 			life  = 1;
-- 			fire  = { 0, 1};
-- 			username = _("AGM-123 Skipper II"),
-- 			index 	 = WSTYPE_PLACEHOLDER,
-- 		},
-- 	},
	
-- 	march = {
-- 		fuel_mass   			= 36,
-- 		impulse     			= 160,
-- 		boost_time  			= 0,
-- 		work_time   			= 9,
-- 		boost_factor			= 0,
-- 		nozzle_position 	    = { { -0.5, 0, 0 } },
-- 		nozzle_orientationXYZ   = {{0, 0, 0}},
-- 		tail_width  			= 0.3,
-- 		boost_tail  			= 1,
-- 		work_tail   			= 1,
-- 		smoke_color				= { 0.6, 0.6, 0.6 },
-- 		smoke_transparency		= 0.8,
-- 		custom_smoke_dissipation_factor		= 0.2,		
-- 	},
	
-- 	fm = {
-- 		mass        = 582,  
-- 		caliber     = 0.07, 
-- 		cx_coeff    = {1, 1.5, 0.68, 0.7, 1.75},
-- 		L           = 1.81,
-- 		I           = 1 / 12 * 15 * 1.81 * 1.81,
-- 		Ma          = 0.84,
-- 		Mw          = 3.5,
-- 		shapeName   = "gbu-16",
-- 		wind_sigma	= 0.0,
-- 		wind_time	= 1000,
-- 		dCydA		= {0.11, 0.11},
-- 		A			= 0.36,
-- 		Sw			= 0.04,
-- 		maxAoa		= 0.122,	
-- 		finsTau		= 0.1,
-- 		Mx0			= 0.2,
-- 		Ma_x		= 1.8,
-- 		Mw_x		= 1.12,
-- 		I_x			= 1.01,
-- 	},
-- 	seeker = {
-- 		delay				= 0.0,
-- 		FOV					= math.rad(360),
-- 		max_seeker_range	= 18520,
-- 	},

-- 	autopilot = {
-- 		delay				= 0.0,
-- 		op_time				= 45,
-- 		dV_dt				= 20,
-- 		Knav				= 12,
-- 		Tf					= 0.2,
-- 		Kd					= 150,
-- 		Kdx					= 0.2,
-- 		Kix					= 0.8,
-- 		gload_limit			= 10,
-- 		fins_limit			= math.rad(20),
-- 		fins_limit_x		= math.rad(10),
-- 		-- null_roll			= math.rad(0),
-- 	},

-- 	properties =
-- 	{
-- 		targeting_data = 
-- 		{
-- 			fm_type = 2,
-- 		},
-- 	},
-- }
-- declare_weapon(AGM_123_F14)


-- declare_loadout( --AGM-123
-- {
--     category = CAT_MISSILES,
--     CLSID	=	"{BRU-32 AGM-123}",
--     Picture	=	"gbu16.png", -- TODO: need GBU24.png ?
-- 	displayName	=	_("AGM-123 Skipper II"),
-- --	displayName = 	_(GBU_54_F14.name),
--     Weight_Empty = 57.38,   -- 100lbs+26.5lbs
--     Weight	= 57.38 + AGM_123_F14.mass,  -- 1050kg from wikipedia, 900 from db_weapons_data.lua though
--     wsTypeOfWeapon	= AGM_123_F14.wsTypeOfWeapon, --{wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
--     attribute      = {4,	4,	32,	WSTYPE_PLACEHOLDER},
--     Count = 1,
--     Cx_pil = 0.00002,
--     Cx_item = 0.000793, -- see bombs_data.lua
-- 	settings			= Get_LGU_GUISettings_Preset("WGU59"),

--     Elements	=
--     {
--         { ShapeName	= "HB_F14_EXT_BRU34" ,IsAdapter  =   true  },  -- combination ADU-703 & BRU-32
--         {
-- 			ShapeName	=	"gbu-16",
--             connector_name =  "WEP_BRU-34_MK84",
--             --use_full_connector_position = true,
--         },
--     }, -- end of Elements
-- })