-- for warhead functions and default warheads map (for warheads["AIM_65"])
-- DSplayer Edited 2025-01-30 V1.1.11 (MWMF14)
dofile("Scripts/Database/Weapons/warheads.lua")

local AIM_174B = {
    category		= CAT_AIR_TO_AIR,
    name			= "AIM_174B",
    user_name		= _("AIM-174B"),
    wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
    --class_name	= "wAmmunitionPhoenix",
    shape_table_data =
    {
        {
            name	 = "AIM_174B";
            file  = "rim-66m";
            life  = 1;
            fire  = { 0, 1};
            username = "AIM_174B";
            index = WSTYPE_PLACEHOLDER,
        },
    },


        Escort = 0,
        Head_Type = 2,
        sigma = {5, 5, 5},
        M = 708,
        H_max = 33000.0,
        H_min = 10,
        Diam = 343,
        Cx_pil = 5,
        D_max = 150000,
        D_min = 6500,
        Head_Form = 1,
        Life_Time = 200.0,
        Nr_max = 25,
        v_min = 170,
        v_mid = 600,
        Mach_max = 5,
        t_b = 6,
        t_acc = 4,
        t_marsh = 12,
        Range_max = 153000,
        H_min_t = 10,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 1.05,
        OmViz_max = 0.52,
        warhead = warheads["SM_2"],
		warhead_air = warheads["SM_2"],
        -- exhaust = {1, 1, 1, 1};
		exhaust = {0.8, 0.8, 0.8, 0.05 };
        X_back = -2,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.15,
        KillDistance = 15.0,
		ccm_k0 = 0.2,
		go_active_by_default = 1,
        active_radar_lock_dist = 18520,
        PN_gain = 5,
        loft = 1,
        hoj = 1,
        loft_factor = 4.5,
		rad_correction = 1,
		smoke_opacity_type	= 1,
        SeekerGen = 4,

        supersonic_A_coef_skew = 0.01, -- наклон прямой коэффициента отвала поляры на сверхзвуке
		nozzle_exit_area = 0.025, -- площадь выходного сечения сопла

        -- PN_coeffs = {
        --     4,
        --     15000.0 ,1.0,
        --     25000.0, 0.85,
        --     40000.0, 0.65,
        --     100000.0, 0.3,
        -- };

        ModelData = {   58,  -- model params count
						0.092,   -- characteristic square (характеристическая площадь)

                        -- параметры зависимости Сx
                        0.408 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
                        0.808 , -- Cx_k1 высота пика волнового кризиса
                        0.01 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
                        -2.336, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
                        0.12 , -- Cx_k4 крутизна спада за волновым кризисом 
                        0.1 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))

                        -- параметры зависимости Cy
                        38 , -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
                        27	, -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
                        1.2 , -- Cy_k2 крутизна спада(фронта) за волновым кризисом  

                        0.35, -- 7 Alfa_max  максимальный балансировачный угол, радианы
                        0.0, --угловая скорость создаваймая моментом газовых рулей  

                    -- Engine data. Time, fuel flow, thrust.	
                    --  t_statr     t_b     t_accel     t_march     t_inertial      t_break     t_end           -- Stage
                        0,			0.0,		4,			12,			0.0,		0.0,        1.0e9,         -- time of stage, sec
                        0.0,		0.0,		40,			16.67,		0.0,		0.0,        0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
                        0.0,		0.0,		96138,		40875,		0.0,		0.0,        0.0,           -- thrust, newtons

                        1.0e9, -- таймер самоликвидации, сек
                        200.0, -- время работы энергосистемы, сек
                        0, -- абсолютная высота самоликвидации, м
                        1.5, -- время задержки включения управления (маневр отлета, безопасности), сек
                        1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
                        1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
                        0,  -- синус угла возвышения траектории набора горки
                        50.0, -- продольное ускорения взведения взрывателя
                        0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
                        1.19, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
                        1, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
                        2, -- характеристика системы САУ-РАКЕТА,  полоса пропускания контура управления

                        -- DLZ data. Use numbers below for your implemetation. --From Denis Alekseev -- ЗРП. Данные для рассчета дальностей пуска (индикация на прицеле)
                        22.6, -- производная дальности по скорости носителя на высоте 1км, ППС
                        -20.2, -- производная дальности по скорости цели на высоте 1км, ЗПС
                        -2.96, -- производная по высоте производной дальности по скорости цели, ЗПС
                        66000, -- дальность ракурс 180 град(навстречу), Н=5000м, V=900км/ч, м
                        34000, -- дальность ракурс 180(в догон) град, Н=5000м, V=900км/ч, м
                        83000, -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м
                        37000.0, -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
                        46900.0, -- дальность ракурс 180 град, Н=1000м, V=900км/ч, м
                        17800.0, -- дальность ракурс 180(в догон) град, Н=1000м, V=900км/ч, м
                        2500.0, -- Вертикальная плоскость. Наклон кривой разрешенной дальности пуска в нижнюю полусферу. Уменьшение дальности при стрельбе вниз.
                        0.55, -- Вертикальная плоскость. Наклон кривой разрешенной дальности пуска в верхнюю полусферу. Увеличение дальности при стрельбе вверх.
                        -0.01, -- Вертикальная плоскость. Угол перегиба кривой разрешенной дальности, верхняя - нижняя полусфера.
                        0.5, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя
        			},
}

declare_weapon(AIM_174B)

declare_loadout({	-- AIM_174B
    category		=	CAT_AIR_TO_AIR,
    CLSID			= 	"{AIM_174B}",
    Picture			=	"aim54.png",
    --wsTypeOfWeapon	=	AIM_54C_Mk47.wsTypeOfWeapon,
    displayName		=	AIM_174B.user_name,
    --attribute		=	{wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
    attribute	    =	AIM_174B.wsTypeOfWeapon,
    Cx_pil			=	AIM_174B.Cx_pil / 4096.0,
    Count			=	1,
    Weight			=	AIM_174B.M,
    Elements	=
    {
		--{	ShapeName	=	"HB_F14_EXT_PHX_ALU"  ,	IsAdapter  	   =   true  },
        {
            DrawArgs	=
			{
				{2,	0},
			}, -- end of DrawArgs
            --Position	=	{0,	-0.5,	0},
            --connector_name = "WEP_Phoenix_FrontPallette_L_ALU",
            ShapeName	=	"rim-66m",
        },
    }, -- end of Elements
})

local function shoulder_aim_174(clsid, element, elem_CLSID, side)  -- side L or R
	local ret = {
		category			=	CAT_AIR_TO_AIR,
		CLSID				=	clsid,
		Picture				=	"aim54.png",
		wsTypeOfWeapon		=	element.wsTypeOfWeapon,
		attribute			=	{4,	4,	32,	WSTYPE_PLACEHOLDER},
		Cx_pil				=	1.25 * (element.Cx_pil/4096.0),
								-- per F-14 perf manual:
								-- shoulder AIM54 drag index = 12
								-- AIM54 shoulder adapter index = 3
								-- total drag index = 15, add 25% more drag to shoulder AIM54
		Count				=	1,
		Weight				=	element.M + 45.36,  --100lbs for LAU-93
		JettisonSubmunitionOnly = true,
		Elements			=
		{
			{	ShapeName	=	"HB_F14_EXT_SHOULDER_PHX_"..side  ,	IsAdapter  	   =   true  },
			{	ShapeName	=	"rim-66m", Position = {0,-0.335,0}	}
			-- {	ShapeName	=	"rim-66m", connector_name = "WEP_Phoenix_Connector"}
		}-- end of Elements
	}
    -- actually a LAU-93 adapter, the LAU-93 is internal to the adapter (and the rails also have LAU-93)
	--ret.displayName =	_("LAU-93 ").." "..element.name
	--ret.displayName =	element.name
    ret.displayName = element.user_name
	declare_loadout(ret)
end

local function bru_32_174(clsid, element, elem_CLSID, attach_offset)  -- side L or R
	local ret = {
		category			=	CAT_AIR_TO_AIR,
		CLSID				=	clsid,
		Picture				=	"aim54.png",
		wsTypeOfWeapon		=	element.wsTypeOfWeapon,
		attribute			=	{4,	4,	32,	WSTYPE_PLACEHOLDER},
		Cx_pil				=	0.00002,
								-- per F-14 perf manual:
								-- shoulder AIM54 drag index = 12
								-- AIM54 shoulder adapter index = 3
								-- total drag index = 15, add 25% more drag to shoulder AIM54
		Count				=	1,
		Weight				=	element.M + 57.38,  --100lbs for LAU-93
		JettisonSubmunitionOnly = true,
		Elements			=
		{
			{	ShapeName	=	"HB_F14_EXT_BRU34",	IsAdapter  	   =   true  },
			{	ShapeName	=	"rim-66m", connector_name = "WEP_BRU-34_MK84", attach_point_position = attach_offset}
			-- {	ShapeName	=	"rim-66m", connector_name = "WEP_Phoenix_Connector"}
		}-- end of Elements
	}
    -- actually a LAU-93 adapter, the LAU-93 is internal to the adapter (and the rails also have LAU-93)
	--ret.displayName =	_("LAU-93 ").." "..element.name
	--ret.displayName =	element.name
    ret.displayName = element.user_name
	declare_loadout(ret)
	return ret
end

local function ds_phx_adapter_nested(clsid,nested_loadout,side)
    local phx_adapter_mass = 45.36 -- TODO
	local ret = {
		category			=	nested_loadout.category,
		CLSID				=	clsid,
		Picture				=	nested_loadout.Picture,
		attribute			=	{4,	4,	32,	WSTYPE_PLACEHOLDER},
		Cx_pil				=	0.0001, -- TODO: what is reasonable?
   		JettisonSubmunitionOnly = true,
		Elements 			= {}
	}
    if nested_loadout.wsTypeOfWeapon ~= nil then
        ret.wsTypeOfWeapon		=	nested_loadout.wsTypeOfWeapon
    end
    ret.Elements[#ret.Elements + 1] = { ShapeName	= "HB_F14_EXT_SHOULDER_PHX_"..side  , IsAdapter  =   true  }
    ret.Elements[#ret.Elements + 1] = {	payload_CLSID = nested_loadout.CLSID, connector_name = "WEP_Phoenix_Connector"}
	ret.Count  = nested_loadout.Count
	ret.Weight = phx_adapter_mass + nested_loadout.Weight


	ret.Cx_pil = ret.Cx_pil + nested_loadout.Cx_pil

	--ret.displayName =	_("PHX ")..nested_loadout.displayName
	ret.displayName =	nested_loadout.displayName
	declare_loadout(ret)
    return ret
end

local BRU_AIM174B = bru_32_174("{BRU32_AIM_174B}", AIM_174B, nil, {0,-0.15,0})

ds_phx_adapter_nested("{SHOULDER AIM_174B L}", BRU_AIM174B, "L")
ds_phx_adapter_nested("{SHOULDER AIM_174B R}", BRU_AIM174B, "R")

-- shoulder_aim_174("{SHOULDER AIM_174B L}", AIM_174B, "{AIM_174B}", "L")
-- shoulder_aim_174("{SHOULDER AIM_174B R}", AIM_174B, "{AIM_174B}", "R")