--dofile(LockOn_Options.script_path.."clickable_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua")
dofile(LockOn_Options.script_path.."command_defs.lua")

local dev = GetSelf()

local update_time_step = 0.02
make_default_activity(update_time_step)

local sensor_data = get_base_data()


local GUN_POSITION_X = 0	
local GUN_POSITION_Y = 0	
local CENTER = 0	

local GUN_POSITION_X_ARGUMENT = 19	
local GUN_POSITION_Y_ARGUMENT = 20	

local JOYSTICK_HORIZONTAL = 0
local JOYSTICK_VERTICAL = 0

local THRESHOLD_P = 0.01
local THRESHOLD_N = -0.01

	
	dev:listen_command(Keys.iCommandPlaneRadarLeft) 				--88
	dev:listen_command(Keys.iCommandPlaneRadarRight) 				--89
	dev:listen_command(Keys.iCommandPlaneRadarUp) 					--90
	dev:listen_command(Keys.iCommandPlaneRadarDown)					--91
	dev:listen_command(Keys.iCommandPlaneRadarCenter)				--92
	
	dev:listen_command(Keys.PlaneSelecterHorizontalAbs)				-- 2033
	dev:listen_command(Keys.PlaneSelecterVerticalAbs)				-- 2034	
	

function post_initialize()

    local birth = LockOn_Options.init_conditions.birth_place
	
    if birth == "GROUND_COLD" then
		GUN_POSITION_Y = 1    
		set_aircraft_draw_argument_value(GUN_POSITION_Y_ARGUMENT,GUN_POSITION_Y)
	
    elseif birth == "GROUND_HOT" then
		GUN_POSITION_Y = 1  
		set_aircraft_draw_argument_value(GUN_POSITION_Y_ARGUMENT,GUN_POSITION_Y)
	
    elseif birth == "AIR_HOT" then
		GUN_POSITION_Y = 0
		set_aircraft_draw_argument_value(GUN_POSITION_Y_ARGUMENT,GUN_POSITION_Y)	
    end

	set_aircraft_draw_argument_value(65,-1)

end


		
function SetCommand(command,value)  
	if command == Keys.iCommandPlaneRadarLeft	then
		GUN_POSITION_X = GUN_POSITION_X - 0.004		
		if (GUN_POSITION_X < -1 ) then
			GUN_POSITION_X = -1
		end
	end
	if command == Keys.iCommandPlaneRadarRight	then
		GUN_POSITION_X = GUN_POSITION_X + 0.004		
		if (GUN_POSITION_X > 1 ) then
			GUN_POSITION_X = 1
		end
	end
	if command == Keys.iCommandPlaneRadarUp	then
		GUN_POSITION_Y = GUN_POSITION_Y + 0.01		
		if (GUN_POSITION_Y > 1 ) then
			GUN_POSITION_Y = 1
		end
	end
	if command == Keys.iCommandPlaneRadarDown	then
		GUN_POSITION_Y = GUN_POSITION_Y - 0.01			
		if (GUN_POSITION_Y < -1 ) then
			GUN_POSITION_Y = -1
		end
	end
	if command == Keys.iCommandPlaneRadarCenter	then
		CENTER = 1
	end
	
	-- Axis input
	if command == Keys.PlaneSelecterHorizontalAbs then
        JOYSTICK_HORIZONTAL = value
    elseif command == Keys.PlaneSelecterVerticalAbs then
        JOYSTICK_VERTICAL = value
    end
	
end




function update()

	-- Joystick inputs
	if JOYSTICK_HORIZONTAL < THRESHOLD_P and JOYSTICK_HORIZONTAL > THRESHOLD_N then
		JOYSTICK_HORIZONTAL = 0
	end	

	if JOYSTICK_VERTICAL < THRESHOLD_P and JOYSTICK_VERTICAL > THRESHOLD_N then
		JOYSTICK_VERTICAL = 0
	end	

	GUN_POSITION_X = GUN_POSITION_X + JOYSTICK_HORIZONTAL * 0.008
	GUN_POSITION_Y = GUN_POSITION_Y + JOYSTICK_VERTICAL * 0.02
	
	-- Clamping [-1, 1] for joystick input
	GUN_POSITION_X = math.max(-1, math.min(1, GUN_POSITION_X))
	GUN_POSITION_Y = math.max(-1, math.min(1, GUN_POSITION_Y))

	-- Turret update position
    if (GUN_POSITION_X >= -1 and GUN_POSITION_X <= 1 ) then
        set_aircraft_draw_argument_value(GUN_POSITION_X_ARGUMENT,GUN_POSITION_X)
    end
    
    if (GUN_POSITION_Y >= -1 and GUN_POSITION_Y <= 1 ) then
        set_aircraft_draw_argument_value(GUN_POSITION_Y_ARGUMENT,GUN_POSITION_Y)
    end   

    -- reset position to the center
    if (CENTER == 1) then
        if GUN_POSITION_X > 0 then
            GUN_POSITION_X = GUN_POSITION_X - 0.004
            if GUN_POSITION_X < 0 then
                GUN_POSITION_X = 0
            end
        elseif GUN_POSITION_X < 0 then
            GUN_POSITION_X = GUN_POSITION_X + 0.004
            if GUN_POSITION_X > 0 then
                GUN_POSITION_X = 0
            end
        end
        
        if GUN_POSITION_Y > 0 then
            GUN_POSITION_Y = GUN_POSITION_Y - 0.01
            if GUN_POSITION_Y < 0 then
                GUN_POSITION_Y = 0
            end
        elseif GUN_POSITION_Y < 0 then
            GUN_POSITION_Y = GUN_POSITION_Y + 0.01
            if GUN_POSITION_Y > 0 then
                GUN_POSITION_Y = 0
            end
        end

        set_aircraft_draw_argument_value(GUN_POSITION_X_ARGUMENT,GUN_POSITION_X)
        set_aircraft_draw_argument_value(GUN_POSITION_Y_ARGUMENT,GUN_POSITION_Y)
		
        if GUN_POSITION_X == 0 and GUN_POSITION_Y == 0 then
            CENTER = 0
		end
		
    end
	
end

need_to_be_closed = false