--
-- file prepared: 4 September 2025 16:56:18.226, using fd689c
--
--SFM_characteristics.lua (file 2 for assembly)

canberra = {

	Name = 'canberra',

	DisplayName = _('canberra'),
	ViewSettings = ViewSettings,
	Countries = { "Abkhazia","Australia","Austria","Belarus","Belgium","Brazil","Bulgaria","Canada","China",
			 "Croatia","Czech Republic","Denmark","Egypt","ESA","Finland","France","Georgia",
			 "German Empire","Germany","Greece","Hungary","Imperial Japan","India","Insurgents","Iran",
			 "Iraq","Israel","Italy","Japan","Kazakhstan","NASA","North Korea","Norway",
			 "Pakistan","Poland","Romania","Russia","Saudi Arabia","Serbia","Slovakia","South Korea",
			 "South Ossetia","Spain","Sweden","Switzerland","Syria","The Netherlands","Third Reich","Turkey","UK",
			 "Ukraine","USA","USAF Aggressors","USSR","Vietnam"},

	HumanCockpit = false,
	HumanCockpitPath = current_mod_path..'/Cockpit/',
	Picture = "canberra.png",
	Rate = 50,
	Shape = "canberra",

	shape_table_data =
	{
		{
			file = 'canberra';
			life = 20;
			vis = 3;
			fire = { 300, 2};
			username = 'canberra';
			index = WSTYPE_PLACEHOLDER;
		},
	},
	------------------------ -
	mapclasskey = "P0091000024",
	attribute = {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER, "Multirole fighters", "Refuelable", "Datalink", "Link16"},
	Categories = {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},

	---------	General	Characteristics	---------



		--This is not an accurate flight model for this aircraft.  The values used in this file are not based on any technical, military or restricted content related to the aircraft, nor are they derived from real world operation or testing.
		--The values in this file are based on publicly available data (examples: airframe dimensions, weights, engine type/power, operating speeds and altitudes).  Thus, this will not provide an accurate representation in game of either actual real-world performance nor of the flight characteristics of this aircraft.
		--Values for the following were obtained from Wikipedia: the maximum speed of the aircraft, its climb rate and service ceiling as well as aircraft attributes such as engine thrust, weights, wing surface area and other aircraft dimensions.
		--Estimates for the following were obtained from Google AI search queries, or Google Gemini queries: sustained turn rate performance, operational g limit, stall speed, altitude at which maximum speed is attained, maximum speed at sea level.
		--Values for the engine table and for the aerodynamics table were refined by in-game testing, with the objective of permitting the user to fly the aircraft in DCS World as 'player' to the max velocity, and service ceiling corresponding to the aircraft as found on the sources disucssed above.

	length = 19.96,
	height = 4.78,
	wing_area = 89,
	wing_span = 19.51,
	wing_tip_pos = { -0.9, 1.05, 10},
	RCS = 6.9,											--(estimated as 0.0375*((height*length) + wing surface area)) )
	air_refuel_receptacle_pos = { 7, 1, 1},
	has_speedbrake = true,								-- default
	brakeshute_name = 4,								-- default
	is_tanker = false,									-- default
	tanker_type = 2,									-- default
	stores_number = 8,
	wing_type = 0,										-- default
	crew_size = 1,										-- default

	------- Weight & Fuel Characteristics -------
	M_empty = 9820,
	M_nominal = 20865,
	M_max = 24948,
	M_fuel_max = 4500,
	H_max = 14630,										-- (calculated from service_ceiling)
	CAS_min = 55,
	average_fuel_consumption = 1,						-- default

	----------_ AI Flight Parameters -----------
	V_opt = 202,
	V_take_off = 57,
	V_land = 57,
	V_max_sea_level = 126,
	V_max_h = 209,
	Vy_max = 17,
	Mach_max = 0.873,
	Ny_min = -3,										-- default
	Ny_max = 3.75,											-- note: default level override for canberra
	Ny_max_e = 3.75,										-- note: default level override for canberra
	AOA_take_off = 0.16,								-- default
	bank_angle_max = 60,								-- default
	range = 3000,										-- default
	flaps_maneuver = 1,									-- default

	-------- Suspension Characteristics -------
	and_gear_max = 1,									-- default
	nose_gear_pos = { 4.8, -1.2, 0},
	nose_gear_wheel_diameter = 0.5,						-- default
	nose_gear_amortizer_direct_stroke = 0.05,			-- default
	nose_gear_amortizer_reversal_stroke = -0.25,		-- default
	nose_gear_amortizer_normal_weight_stroke = -0.05,	-- default
	main_gear_pos = { -0.4, -1.5, 1.75},
	main_gear_wheel_diameter = 0.75,					-- default
	main_gear_amortizer_direct_stroke = 0.1,			-- default
	main_gear_amortizer_reversal_stroke = -0.275,		-- default
	main_gear_amortizer_normal_weight_stroke = -0.1,	-- default

	---------- Engine Characteristics ---------
	has_afteburner = false,
	thrust_sum_max = 6717.7,
	thrust_sum_ab = 6717.7,
	engines_count = 2,
	IR_emission_coeff = 0.05,							-- default
	IR_emission_coeff_ab = 0.05,						-- default

	--------- Sensors Characteristics ---------
	detection_range_max = 250,							-- default
	radar_can_see_ground = true,						-- default


---------------------------------------------------------------------------------------------------------------------------------------------

	crew_members =
	{
		[1] =
		{
			ejection_seat_name = 9,
			drop_canopy_name = "aircraft_canopy",
			canopy_pos = {4.8, -0.25, 0},
			canopy_ejection_dir = {0.0, 0.5, -0.5},
			pos = {4.8, -1.2, 0},
		}, --end of[1]
		--[2] =
		--{
			--ejection_seat_name = 9,
			--drop_canopy_name = "aircraft_canopy_2",
			--canopy_pos = {4.8, -0.25, 0},
			--canopy_ejection_dir = {0.0, 0.5, 0.5},
			--pos = {4.8, -1.2, 0},
			--canopy_arg = 421,
		--}, --end of[2]
	}, --end of crew_members

---------------------------------------------------------------------------------------------------------------------------------------------


	--------- Engine, nozzles and exhaust ---------

	engines_nozzles = {
		[1] =
		{
			pos = {-3.75, 0.55, 3},
			elevation = 0.55,
			diameter = 0.675,							-- default
			exhaust_length_ab = 3,						-- default
			exhaust_length_ab_K = 0.707,				-- default
			smokiness_level = 0.15,
		}, -- end of [1]
		[2] =
		{
			pos = {-3.75, 0.55, -3},
			elevation = 0.55,
			diameter = 0.675,							-- default
			exhaust_length_ab = 3,						-- default
			exhaust_length_ab_K = 0.707,				-- default
			smokiness_level = 0.15,
		}, -- end of [2]
	}, -- end of engines_nozzles


---------------------------------------------------------------------------------------------------------------------------------------------


	Guns = {
		M_39({ muzzle_pos = {0.01, -0.05, 0.08},_connector =  "Point_Gun_01",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		M_39({ muzzle_pos = {0.01, -0.08, 0.03},_connector =  "Point_Gun_02",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		M_39({ muzzle_pos = {0.01, -0.08, -0.03},_connector =  "Point_Gun_03",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		M_39({ muzzle_pos = {0.01, -0.05, -0.08},_connector =  "Point_Gun_04",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
	},


	Pylons = {
		pylon(1, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon1", arg = 308, arg_value = 0,
			},
			{
			} 
		),
		pylon(2, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon2", arg = 309, arg_value = 0,
			},
			{
			} 
		),
		pylon(3, 0, -0.1, 0.45, 5, --
			{
				use_full_connector_position = true, connector = "Pylon3", arg = 310, arg_value = 0,
			},
			{
				{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" }, --AIM-9M
				{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" }, --AIM-9P
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82 
				{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}" }, --MK-83 
				{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" }, --MK-84 
			} 
		),
		pylon(4, 0, 0.01, 0.38, 4, --
			{
				use_full_connector_position = true, connector = "Pylon4", arg = 311, arg_value = 0,
			},
			{
				{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" }, --AIM-9M
				{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" }, --AIM-9P
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82 
				{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}" }, --MK-83 
				{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" }, --MK-84 
			} 
		),
		pylon(5, 0, 0.01, 0.38, -4, --
			{
				use_full_connector_position = true, connector = "Pylon5", arg = 312, arg_value = 0,
			},
			{
				{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" }, --AIM-9M
				{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" }, --AIM-9P
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82 
				{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}" }, --MK-83 
				{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" }, --MK-84 
			} 
		),
		pylon(6, 0, -0.1, 0.45, -5, --
			{
				use_full_connector_position = true, connector = "Pylon6", arg = 313, arg_value = 0,
			},
			{
				{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" }, --AIM-9M
				{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" }, --AIM-9P
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82 
				{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}" }, --MK-83 
				{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" }, --MK-84 
			} 
		),
		pylon(7, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon7", arg = 314, arg_value = 0,
			},
			{
			} 
		),
		pylon(8, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon8", arg = 315, arg_value = 0,
			},
			{
			} 
		),
	},

	chaff_flare_dispenser =
	{
		[1] =
		{
			dir = {0, 1, 0},
			pos = {-5, 1, -0.75},
		}, --end of[1]
	}, --end of chaff_flare_dispenser

	--Countermeasures
	passivCounterm = {
		CMDS_Edit = true,
		SingleChargeTotal = 128,
		chaff = {default = 64, increment = 3, chargeSz = 1},
		flare = {default = 64, increment = 3, chargeSz = 1}
	},


---------------------------------------------------------------------------------------------------------------------------------------------


	fires_pos =
	{
		[1] = { -0.9375, 1.05, 0.0},
		[2] = { -0.375, 1.05, 0.03},
		[3] = { -0.5625, 1.05, -0.03},
		[4] = { 0.01, 1.05, 2.5},
		[5] = { 0.01, 1.05, -2.5},
		[6] = { 0.01, 1.05, 8},
		[7] = { 0.01, 1.05, -8},
		[8] = { -3.75, 0.55, 0.03},
		[9] = { -3.75, 0.55, -0.03},
		[10] = { -1.875, 1.05, 0.03},
		[11] = { -1.875, 1.05, -0.03},
	},	-- end of fires_pos

---------------------------------------------------------------------------------------------------------------------------------------------


--(file 3 for aessembly)

	--[[
	fires_pos =
	{
		[1] = 	{-1.594,	-0.064,		0},
		[2] = 	{-1.073,	0.319,		2.304},
		[3] = 	{-1.187,	0.338,		-4.678},
		[4] = 	{-0.82,		0.265,		2.774},
		[5] = 	{-0.82,		0.265,		-2.774},
		[6] = 	{-0.82,		0.255,		4.274},
		[7] = 	{-0.82,		0.255,		-4.274},
		[8] = 	{-5.889,	-0.257,		1.193},
		[9] = 	{-5.889,	-0.257,		-1.193},
		[10] = 	{-1.257,	0.283,		3.05},
		[11] = 	{-1.257,	0.283,		-3.05},
	}, -- end of fires_pos
	]]--

	--[[

	-- Countermeasures
	passivCounterm = {
		CMDS_Edit = true,
		SingleChargeTotal = 128,
		-- PPR-26
		chaff = {default = 64, increment = 3, chargeSz = 1},
		-- PPI-26
		flare = {default = 64, increment = 3, chargeSz = 1}
	},
	]]--

	attribute 		= { wsType_Air, wsType_Airplane, wsType_Fighter, Su_34,"Bombers", "Refuelable"},
	CanopyGeometry	=  makeAirplaneCanopyGeometry(LOOK_GOOD, LOOK_AVERAGE, LOOK_AVERAGE),
	
	--[[
	Sensors =
	{
		RADAR = "N-011M",
		OPTIC = "Su-34 FLIR",
		RWR   = "Abstract RWR"
	},
	]]--

	Tasks =
	{
		aircraft_task(AFAC),
		aircraft_task(SEAD),
		aircraft_task(AntishipStrike),
		aircraft_task(CAS),
		aircraft_task(CAP),
		aircraft_task(Intercept),
		aircraft_task(PinpointStrike),
		aircraft_task(GroundAttack),
		aircraft_task(RunwayAttack),
	},
	DefaultTask = aircraft_task(CAP),

	--SFM_aerodynamics.lua (file 4 for assembly)

	SFM_Data = {
		aerodynamics = --Cx = Cx_0 + Cy ^ 2 * B2 + Cy ^ 4 * B4
		{

			Cy0 = 0,
			Mzalfa = 4.355,					-- default
			Mzalfadt = 0.8,					-- default
			kjx = 3,						-- default
			kjz = 0.00125,					-- default
			Czbe = -0.016,					-- default
			cx_gear = 0.02,					-- default
			cx_flap = 0.08,					-- default
			cy_flap = 0.25,					-- default
			cx_brk = 0.1,					-- default

			table_data = {
				--M     Cx0     Cya     B       B4      Omxmax  Aldop   Cymax
				{0,		0.015,	0.0461,	0.288,	0.519,	2.02,	11.7,	0.541,		},
				{0.1,	0.015,	0.0417,	0.288,	0.519,	5.5,	13,	0.541,		},
				{0.2,	0.015,	0.0517,	0.288,	0.519,	5.5,	14.3,	0.741,		},
				{0.3,	0.015,	0.0463,	0.288,	0.519,	5.5,	15.8,	1,		},
				{0.4,	0.015,	0.041,	0.288,	0.519,	5.5,	17.5,	1,		},
				{0.5,	0.015,	0.03,	0.334,	1.24,	5.5,	17.5,	1,		},
				{0.6,	0.015,	0.03,	0.33,	2.08,	5.5,	17.5,	1,		},
				{0.7,	0.015,	0.03,	0.303,	3.12,	5.5,	17.5,	1,		},
				{0.8,	0.0213,	0.03,	0.296,	3.04,	2.02,	17.5,	1,		},
				{0.9,	0.035,	0.03,	0.00145,	0.00019,	1.77,	17.5,	1,		},
				{1,		0.0575,	0.03,	0.0015,	0.0002,	1.55,	16.6,	0.951,		},
				{1.1,	0.0675,	0.03,	0.00155,	0.00021,	1.36,	15.8,	0.905,		},
				{1.2,	0.0775,	0.03,	0.0016,	0.00022,	1.19,	15.1,	0.861,		},
			}, --end of table_data

		--This is not an accurate flight model for this aircraft.  The values used in this file are not based on any technical, military or restricted content related to the aircraft, nor are they derived from real world operation or testing.
		--The values in this file are based on publicly available data (examples: airframe dimensions, weights, engine type/power, operating speeds and altitudes).  Thus, this will not provide an accurate representation in game of either actual real-world performance nor of the flight characteristics of this aircraft.
		--Values for the following were obtained from Wikipedia: the maximum speed of the aircraft, its climb rate and service ceiling as well as aircraft attributes such as engine thrust, weights, wing surface area and other aircraft dimensions.
		--Estimates for the following were obtained from Google AI search queries, or Google Gemini queries: sustained turn rate performance, operational g limit, stall speed, altitude at which maximum speed is attained, maximum speed at sea level.
		--Values for the engine table and for the aerodynamics table were refined by in-game testing, with the objective of permitting the user to fly the aircraft in DCS World as 'player' to the max velocity, and service ceiling corresponding to the aircraft as found on the sources disucssed above.

		}, --end of aerodynamics
		engine = 
		{
			Nmg = 50,					-- default
			MinRUD = 0,					-- default
			MaxRUD = 1,					-- default
			MaksRUD  = 1,					-- default
			ForsRUD  = 1,					-- default
			typeng  = 0,
			hMaxEng	= 19,				-- default
			dcx_eng = 0.015,			-- default
			cemax  = 1.24,				-- default
			cefor  = 2.56,				-- default
			dpdh_m = 1000,					-- default
			dpdh_f = 2000,					-- default

			--[[			table_data = {
				--M 	Pmax	Pafb
				{0,	52707,	52707,		},
				{0.2,	52707,	52707,		},
				{0.4,	52707,	52707,		},
				{0.6,	52707,	52707,		},
				{0.8,	52707,	52707,		},
				{1,	52707,	52707,		},
				{1.2,	52707,	52707,		},
				{1.4,	52707,	52707,		},
				{1.6,	52707,	52707,		},
				{1.8,	52707,	52707,		},
				{2,	52707,	52707,		},
				{2.2,	52707,	52707,		},
			}, --end of table_data
			--]]

			table_data = {
				--M 	Pmax	Pafb
				{0.0,	0.0,	0.0,		},
				{ 2.0,	0.0,	0.0,		},
			}, --end of table_data


			--[[
				engine calibration worksheet (for in-game testing)
				alt     	vel		adj
				0 k ft		0.m		adj:+/-
				15 k ft		0.m		adj:+/-
				40 k ft		0.m		adj:+/-
				42 k ft		0.m		adj:+/-
				44 k ft		0.m		adj:+/-
				49 k ft		0.m		adj:+/-
				53 k ft		0.m		adj:+/-
				56 k ft		0.m		adj:+/-
			]]--

			extended = {

				thrust_max = {
					M = { 0.000000, 0.200000, 0.400000, 0.600000, 0.800000, 1.000000, 1.200000, 1.400000, 1.600000, 1.800000, 2.000000, 2.200000, }, 
					H = { 0, 4571, 12191, 12801, 13441, 15103, 16446, 17201 }, 
					thrust = {
						{ 51370,  51370,  51370,  51370,  51370,  51370,  51370,  51370,  51370,  51370,  51370,  51370  }, 
						{ 52595,  52595,  52595,  52595,  52595,  52595,  52595,  52595,  52595,  52595,  52595,  52595  }, 
						{ 326730, 326730, 326730, 326730, 32673,  32673,  32673,  32673,  32673,  32673,  32673,  32673  }, 
						{ 259480, 259480, 259480, 259480, 25948,  25948,  25948,  25948,  25948,  25948,  25948,  25948  }, 
						{ 395160, 395160, 395160, 395160, 39516,  39516,  39516,  39516,  39516,  39516,  39516,  39516  }, 
						{ 296430, 296430, 296430, 296430, 29643,  29643,  29643,  29643,  29643,  29643,  29643,  29643  }, 
						{ 20759,  20759,  20759,  20759,  20759,  20759,  20759,  20759,  20759,  20759,  20759,  20759  }, 
						{ 1317,   1317,   1317,   1317,   1317,   1317,   1317,   1317,   1317,   1317,   1317,   1317   }, 
					}, -- thrust = {

				}, --thrust_max = {

				thrust_afterburner  = {
					M = { 0.000000, 0.200000, 0.400000, 0.600000, 0.800000, 1.000000, 1.200000, 1.400000, 1.600000, 1.800000, 2.000000, 2.200000, }, 
					H = { 0, 4571, 12191, 12801, 13441, 15103, 16446, 17201 }, 
					thrust = {
						{ 51370,  51370,  51370,  51370,  51370,  51370,  51370,  51370,  51370,  51370,  51370,  51370  }, 
						{ 52595,  52595,  52595,  52595,  52595,  52595,  52595,  52595,  52595,  52595,  52595,  52595  }, 
						{ 326730, 326730, 326730, 326730, 32673,  32673,  32673,  32673,  32673,  32673,  32673,  32673  }, 
						{ 259480, 259480, 259480, 259480, 25948,  25948,  25948,  25948,  25948,  25948,  25948,  25948  }, 
						{ 395160, 395160, 395160, 395160, 39516,  39516,  39516,  39516,  39516,  39516,  39516,  39516  }, 
						{ 296430, 296430, 296430, 296430, 29643,  29643,  29643,  29643,  29643,  29643,  29643,  29643  }, 
						{ 20759,  20759,  20759,  20759,  20759,  20759,  20759,  20759,  20759,  20759,  20759,  20759  }, 
						{ 1317,   1317,   1317,   1317,   1317,   1317,   1317,   1317,   1317,   1317,   1317,   1317   }, 
					}, -- thrust = {

				}, --thrust_afterburner = {

			}, -- extended = {

		--This is not an accurate flight model for this aircraft.  The values used in this file are not based on any technical, military or restricted content related to the aircraft, nor are they derived from real world operation or testing.
		--The values in this file are based on publicly available data (examples: airframe dimensions, weights, engine type/power, operating speeds and altitudes).  Thus, this will not provide an accurate representation in game of either actual real-world performance nor of the flight characteristics of this aircraft.
		--Values for the following were obtained from Wikipedia: the maximum speed of the aircraft, its climb rate and service ceiling as well as aircraft attributes such as engine thrust, weights, wing surface area and other aircraft dimensions.
		--Estimates for the following were obtained from Google AI search queries, or Google Gemini queries: sustained turn rate performance, operational g limit, stall speed, altitude at which maximum speed is attained, maximum speed at sea level.
		--Values for the engine table and for the aerodynamics table were refined by in-game testing, with the objective of permitting the user to fly the aircraft in DCS World as 'player' to the max velocity, and service ceiling corresponding to the aircraft as found on the sources disucssed above.


		}, --end of engine

	},

	DamageParts =
	{
		[1] = "canberra-collision",
	},

	-- (file 5 for aessembly)

	-- new
	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
		[0]		= {critical_damage = 5, args = {146}},
		[3]		= {critical_damage = 20,args = {65}}  ,
		[4]		= {critical_damage = 20, args = {150}},
		[5]		= {critical_damage = 20, args = {147}},
		[7]		= {critical_damage = 4, args = {249}} ,
		[9]		= {critical_damage = 3, args = {154}},
		[10]	= {critical_damage = 3, args = {153}},
		[11]	= {critical_damage = 3, args = {167}},
		[12]	= {critical_damage = 3, args = {161}},
		[15]	= {critical_damage = 5, args = {267}},
		[16]	= {critical_damage = 5, args = {266}},
		[23]	= {critical_damage = 8, args = {223}, deps_cells = {25}},
		[24]	= {critical_damage = 8, args = {213}, deps_cells = {26, 60}},
		[25]	= {critical_damage = 3, args = {226}},
		[26]	= {critical_damage = 3, args = {216}},
		[29]	= {critical_damage = 9, args = {224}, deps_cells = {31, 25, 23}},
		[30]	= {critical_damage = 9, args = {214}, deps_cells = {32, 26, 24, 60}},
		[31]	= {critical_damage = 4, args = {229}},
		[32]	= {critical_damage = 4, args = {219}},
		[35]	= {critical_damage = 10, args = {225}, deps_cells = {29, 31, 25, 23}},
		[36]	= {critical_damage = 10, args = {215}, deps_cells = {30, 32, 26, 24, 60}} ,
		[37]	= {critical_damage = 4, args = {227}},
		[38]	= {critical_damage = 4, args = {217}},
		[39]	= {critical_damage = 7,	args = {244}, deps_cells = {53}},
		[40]	= {critical_damage = 7, args = {241}, deps_cells = {54}},
		[45]	= {critical_damage = 9, args = {235}, deps_cells = {39, 51, 53}},
		[46]	= {critical_damage = 9, args = {233}, deps_cells = {40, 52, 54}},
		[51]	= {critical_damage = 3, args = {239}},
		[52]	= {critical_damage = 3, args = {237}},
		[53]	= {critical_damage = 3, args = {248}},
		[54]	= {critical_damage = 3, args = {247}},
		[55]	= {critical_damage = 20, args = {81}, deps_cells = {39, 40, 45, 46, 51, 52, 53, 54}},
		[59]	= {critical_damage = 5, args = {148}},
		[60]	= {critical_damage = 1, args = {144}},

		[83]	= {critical_damage = 3, args = {134}} ,-- nose wheel
		[84]	= {critical_damage = 3, args = {136}}, -- left wheel
		[85]	= {critical_damage = 3, args = {135}} ,-- right wheel
	},


	-- solve triangle to have B_end == C_end with given A
	-- B_start assumed to be A_start
	-- C_start assumed to be A_end
	
	SolveTriangles = 
	{
		-- left gear post kinematics 
		{
			A_start   = "bracing_centr004",
			A_end     = "bracing_centr003",
			B_end     = "bracing_004",
			B_control = 484,
			C_end	  = "bracing_003",
			C_control = 483,
			B_scale   =  1/math.rad(46);
			C_scale   =  1/math.rad(25);
		},
		-- right gear post kinematics 
		{
			A_start   = "bracing_centr006",
			A_end     = "bracing_centr005",
			B_end     = "bracing_006",
			B_control = 486,
			C_end	  = "bracing_005",
			C_control = 485,
			B_scale   =  1/math.rad(46);
			C_scale   =  1/math.rad(25);
		},
	},  --SolveTriangles


}



--SFM_add.lua (file 6 for assembly)

add_aircraft(canberra)


